#!/usr/bin/env perl
#   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
#   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
#
#   This file is part of FreePOOMA.
#
#   FreePOOMA is free software; you can redistribute it and/or modify it
#   under the terms of the Expat license.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
#   license for more details.
#
#   You should have received a copy of the Expat license along with
#   FreePOOMA; see the file LICENSE.

#############################################################################
#
# Program to generate makefiles for tecolote-like make systems.
# Using this program will replace most of your current make files.
#
# laa, 08-Mar-1998
#
#############################################################################
use Cwd;

$DEBUG       = 1;
$VERBOSE     = 1;

@CC          = ("inst.cpp", "cmpl.cpp", "f", "F");  # source file suffixes
@HH          = ("h", "hh");                         # header file suffixes

# Skip directories that match these regular expressions
@SKIPDIRS    = qw( ^CVS$ ^config$ ^ii_files$ ^ti_files$ ^RT_ );

# Do makefile, include file, subdir file, object file?
($DOM, $DOI, $DOS, $DOO) = (1, 1, 1, 1);
$MFILE       = "makefile";
$IFILE       = "include.mk";
$SFILE       = "subdir.mk";
$OFILE       = "objfile.mk";
   
$PROJECT     = $ARGV[0];
$SHARED_ROOT = $ENV{SHARED_ROOT};
$PROGRAM     = $0; $PROGRAM =~ s/.*\/(.*)$/$1/;
$TOP         = `pwd`;  chomp $TOP;
$DATE        = `date`; chomp $DATE;

if    ($PROJECT =~ /^-p/i) { # purge makefiles
  print "Purging makefiles...\n";
  $command = qq(find . -name "[mM]akefile" -o -name "*.mk" | grep -v config | grep -v Shared | xargs rm\n);
  print $command if ($VERBOSE);
  print `$command`;
}
elsif ($PROJECT =~ /^-b/i) { # purge backup makefiles
  print "Purging backed up makefiles...\n";
  $command = qq(find . -name "[mM]akefile.bak" -o -name "*.mk.bak" | grep -v config | grep -v Shared | xargs rm\n);
  print $command if ($VERBOSE);
  print `$command`;
}
elsif ($PROJECT =~ /^-l/i) { # list makefiles
  $command = qq(find . -name "[mM]akefile*" -o -name "*.mk*" | grep -v config | grep -v Shared\n);
  print $command if ($VERBOSE);
  print `$command`;
}
elsif ($#ARGV != 0 || $PROJECT =~ /^-h/i) { # print help
  &help;
}
else {  # do it
  print "\nTop directory = $TOP\n";
  &dodir($TOP);
}

#############################################################################
# Print help and usage information.
sub help {
  my ($suffix, $dir);
  print <<EOF;
usage:
  mm.pl has one argument, 'PROJECT'.
examples:
  mm.pl TECOLOTE (Makes makefiles with include paths relative to \$TECOLOTE_ROOT)
  mm.pl POOMA    (Makes makefiles with include paths relative to \$POOMA_ROOT)
  mm.pl -p       (Recursively removes [Mm]akefile and  *.mk)
  mm.pl -l       (Recursively list [Mm]akefile and  *.mk)
  mm.pl -h       (Print this message)

mm.pl starts at the current working directory and creates 
  $MFILE, $IFILE, $SFILE and $OFILE 
in all directories which have source or header files in or below them. Source 
files end in any of:
EOF

  foreach $suffix (@CC) { print qq( ".$suffix"); }
  print "\nAnd header files end in any of\n";
  foreach $suffix (@HH) { print qq( "$.suffix"); }
  print "\nDirectories matching the following regular expressions are skipped:\n";
  foreach $dir (@SKIPDIRS) { print " \/${dir}\/"; }

  print <<EOF;


This script sets up the default target at each directory level to be 
\$(LOCAL_OBJS). The value of \$(LOCAL_OBJS) is set at make time by assuming 
that all source files should be compiled. You can change this by editing the 
$OFILE files.

This script can do most of the work of creating a make system, but you will 
typically need to edit the following files:
  $MFILE: to add targets like executables
  $OFILE: to add or remove .o files from the default compilation
  $SFILE: to add or remove subdirectories

You shouldn't have to edit any of the $IFILE files. They are just wrappers
that organize the other make files in each directory.
EOF
}

#############################################################################
# Decend recursively through $dir to create the necessary make files.
sub dodir {
  my($dir)= @_;
  my (@things, @source_header_files);
  my($olddir) = cwd();

  print "\n\n"             if ($VERBOSE > 1);
  print "olddir=$olddir\n" if ($VERBOSE > 1);
  print "DIRECTORY=$dir\n" if ($VERBOSE > 1);

  chdir $dir or die "Can't cd to $dir";

  @source_header_files = &findfiles(".", @CC, @HH);
  if ($#source_header_files < 0) {
    print "  Skipping $subdir... No source or header files below this level.\n" if ($VERBOSE > 0);
    chdir $olddir or die "Can't cd to $olddir";
    return;
  }

  opendir(DIR, ".") or die "Can't open $dir";
  @allthings = readdir(DIR);
  closedir(DIR);
  THING: foreach $thing (sort @allthings) {
    next if ($thing =~ /^\.+$/);	# Skip dot directories
    foreach $dir (@SKIPDIRS) { 
      if ($thing =~ /$dir/) {
        print "Skipping $thing\n" if ($VERBOSE > 1);
        next THING;
      }
    }
    push @things, $thing;
  }
  &create_makefile()           if ($DOM); # make the makefile
  &create_include_file()       if ($DOI); # make the include file
  &create_object_file(@things) if ($DOO); # make the objects file
  &create_subdir_file(@things) if ($DOS); # make the subdirectories file

  foreach $subdir (sort @things) {
    next unless (-d $subdir);
    print "Processing $subdir\n" if ($VERBOSE > 0);
    &dodir($subdir);
    print "Returning to $olddir\n" if ($VERBOSE > 2);
    chdir $olddir or die "Can't cd to $olddir";
  }
}

#############################################################################
# Write local include file. Use 'include's wherever possible.

sub create_include_file {
  print "Writing ", cwd(), "/$IFILE\n" if ($VERBOSE > 1);
  &backup_file($IFILE);
  open (MK, ">$IFILE") || die "Couldn't open $IFILE for writing\n";
  print MK <<EOF;
# Generated by $PROGRAM: $DATE

# Wrap make components from SHARED_ROOT and the current directory in the 
# proper order so that variables like ODIR have the correct directory-specific 
# value at the right moment.  See the included files for details of what they 
# are doing. This file should NOT be manually edited.

# Set NEXTDIR, THISDIR and DIR_LIST
include \$(SHARED_ROOT)/include1.mk

# Include list of subdirectories to process
-include \$(THISDIR)/subdir.mk

# Set ODIR, UNIQUE
include \$(SHARED_ROOT)/include2.mk

# Set list of object files, relative to ODIR
-include \$(THISDIR)/objfile.mk

# Set rules for the ODIR directory 
include \$(SHARED_ROOT)/compilerules.mk

# Remove current dir from DIR_LIST
DIR_LIST :=\$(filter-out \$(firstword \$(DIR_LIST)), \$(DIR_LIST))

EOF
close MK;
}

#############################################################################
# Create a generic makefile.

sub create_makefile {
  print "Writing ", cwd(), "/$MFILE\n" if ($VERBOSE > 1);
  &backup_file($MFILE);
  open (MK, ">$MFILE") || die "Couldn't open $MFILE for writing\n";
  print MK "# Generated by ${PROGRAM}: ${DATE}\n";
  print MK "# This file is user-editable\n";
  print MK "include \$(${PROJECT}_ROOT)/config/head.mk\n";
  print MK "default:: \$(LOCAL_OBJS)\n";
  print MK "include \$(SHARED_ROOT)/tail.mk\n";
  close MK;
}

#############################################################################
# Create file containing list of object files to create.

sub create_object_file {
  my (@things) = @_;
  my ($thing, $objectlist, $nobjects);

  print "Writing ", cwd(), "/$OFILE\n" if ($VERBOSE > 1);
  &backup_file($OFILE);

  open (MK, ">$OFILE") || die "Couldn't open $OFILE for writing\n";
  print MK "# Generated by $PROGRAM: $DATE\n";
  print MK "# Object file list.\n";
  print MK "# This file is user-editable.\n";
  print MK "# Be sure that \$(UNIQUE)_OBJS is set, even if set to empty.\n\n";

  $objectlist = "";

  foreach $thing (sort @things) {
    next if (-d $thing);
    foreach $suffix (@CC) { 
      if ($thing =~ /^.*\.$suffix$/) {
	  $thing =~ s/(.*)\.[^.]+/$1/;
	  $objectlist .= "                  \$(ODIR)/$thing.o \\\n";
      }
    }
  }

  if ($objectlist =~ /.+/) { 
    $objectlist =~ s/^ *//;  # strip extra spaces from first line
    $objectlist =~ s/\\$//;  # strip last continuation
    print MK "\$(UNIQUE)_OBJS := $objectlist\n";
  }
  else           {
    print MK "\$(UNIQUE)_OBJS :=\n";
  }

  print MK "LOCAL_OBJS += \$(\$(UNIQUE)_OBJS)\n";
  close MK;
}

#############################################################################
# Create file containing list of subdirectories to process.

sub create_subdir_file {
  my (@things) = @_;
  my ($dir, @source_header_files);

  print "Writing ", cwd(), "/$SFILE\n" if ($VERBOSE > 1);
  &backup_file($SFILE);
  open (MK, ">$SFILE") || die "Couldn't open $SFILE for writing\n";
  print MK "# Generated by $PROGRAM: $DATE\n";
  print MK "# Subdirectory list\n";
  print MK "# This file is user-editable. Add or remove blocks of three lines.\n\n";

  THING: foreach $thing (sort @things) {
    next THING unless (-d $thing);
    next THING if ($thing =~ /^\.+$/);	# Skip dot directories

    foreach $dir (@SKIPDIRS) { 
      if ($thing =~ /$dir/) {
        print "Skipping $thing\n" if ($VERBOSE > 1);
        next THING;
      }
    }

    @source_header_files = &findfiles($thing, @CC, @HH);

    if ( ($#source_header_files >= 0)         ) {
      print MK "\n";
      print MK "NEXTDIR := $thing\n";
      print MK "include \$(THISDIR)/\$(NEXTDIR)/$IFILE\n";
      print MK "THISDIR :=\$(firstword \$(DIR_LIST))\n";
    }
  }
  close MK;
}

#############################################################################
# Scan a directory hierarchy for source and header files.
sub findfiles {
  my($dir, @suffixes) = @_;
  my($command, $suffix, @foundfiles);
  $command = "find $dir ";
  foreach $suffix (@suffixes) {
    $command .= qq(-name "*.$suffix" -o );
  }
  $command =~ s/^(.*)? -o /$1/;  # remove trailing -o
  print "command=$command\n" if ($VERBOSE > 2);
  @foundfiles = `$command`;
}

#############################################################################
sub backup_file {
  my($file) = @_;
  my($command);
  return unless (-s $file);
  $command = "mv $file $file.bak";
  print "command=$command\n" if ($VERBOSE > 2);
  print `$command`;
}


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: mm.pl,v $   $Author: richard $
#  $Revision: 1.11 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
