// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

// include files

#include "JacobiInC.h"
#include "JacobiInCppTran.h"
#include "JacobiInP2.h"


//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);

  Benchmark Jac(argc, argv);

  Jac.addImplementation(new JacobiInC);
  Jac.addImplementation(new JacobiInCppTran);
  Jac.addImplementation(new JacobiInP2UnOpt);
  Jac.addImplementation(new JacobiInP2Opt);

  Jac.setSamplingParameters(10,1,4);
  Jac.setIterations(100);
  Jac.run();

  Pooma::finalize();
  
  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Jacobi.cpp,v $   $Author: richard $
// $Revision: 1.13 $   $Date: 2004/11/01 18:15:17 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
