// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

#ifndef POOMA_BENCHMARKS_MESSAGING_MPISTUBS_H
#define POOMA_BENCHMARKS_MESSAGING_MPISTUBS_H

typedef int MPI_Comm;
typedef int MPI_Request;

struct MPI_Status {
  int MPI_TAG;
  MPI_Status() {MPI_TAG = 23;}
  ~MPI_Status() {}
};

void MPI_Init(int *argc, char ***argv) {}
void MPI_Finalize() {}
void MPI_Comm_dup(MPI_Comm, MPI_Comm *) {}
void MPI_Comm_rank(MPI_Comm comm, int *pe) { *pe = 0; }
void MPI_Comm_size(MPI_Comm comm, int *npe) { *npe = 1; }
void MPI_Barrier(MPI_Comm) {}
void MPI_Reduce(double *, double *, int, int, int, int, MPI_Comm) {}
void MPI_Isend(double *, int, int, int, int, MPI_Comm, MPI_Request *) {}
void MPI_Recv(double *, int, int, int, int, MPI_Comm, MPI_Status *) {}


#define MPI_COMM_WORLD 0
#define MPI_DOUBLE 1
#define MPI_MAX 2
#define MPI_ANY_SOURCE 3
#define MPI_ANY_TAG 4



#endif // POOMA_BENCHMARKS_MESSAGING_MPISTUBS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: MPIStubs.h,v $   $Author: richard $
// $Revision: 1.4 $   $Date: 2004/11/01 18:15:14 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
