// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// GKPoisson Benchmark
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------

#include "GKPoissonInP2.h"
#include "GKPoissonInCppTran.h"
#include "GKPoissonInC.h"

extern void mpcase(Benchmark &bm);

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  Pooma::initialize(argc, argv);
  
  // Run stencil version of Zhihong's gyrokinetic poisson equation.
  // (Uniform T_e, T_e/T_i = 1, grid spacing = rhoi.)
  // See examples/GKPoisson/GKPoisson.h for more info.

  Benchmark gkpoisson(argc, argv, "GK Poisson Solver");

  gkpoisson.addImplementation(new GKPoissonInC(0.95));
  gkpoisson.addImplementation(new GKPoissonInCppTran(0.95));
  gkpoisson.addImplementation(new GKPoissonInP2UnOpt(0.95));
  gkpoisson.addImplementation(new GKPoissonInP2Opt(0.95));

  // Handle the MP case separately so we can compile it with different
  // optimization. CW cannot compile this with full optimization.
  
  gkpoisson.setNumPatches(5);
  mpcase(gkpoisson);
  
  gkpoisson.setSamplingParameters(10,2,3);
  gkpoisson.run();

  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: GKPoisson.cpp,v $   $Author: richard $
// $Revision: 1.11 $   $Date: 2004/11/01 18:15:13 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
