/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif

/* Doof3d kernels */

#define a(i,j,k) A[(i) + n * (j + n * (k))]
#define b(i,j,k) B[(i) + n * (j + n * (k))]

void
runDoof3dInCRestrict(double* A, double* restrict B, int n) 
{
  int i, j, k;
  const double fact = 1.0 / 9.0;

  for (k = 1; k <= n - 2; k++) 
    {
      for (j = 1; j <= n - 2; j++) 
        {
          for (i = 1; i <= n - 2; i++) 
            {
              b(i,j,k) = fact * (
                a(i-1,j-1,k-1) + a(i,  j-1,k-1) + a(i+1,j-1,k-1) +
                a(i-1,j,  k-1) + a(i,  j,  k-1) + a(i+1,j,  k-1) +
                a(i-1,j+1,k-1) + a(i,  j+1,k-1) + a(i+1,j+1,k-1) +
                a(i-1,j-1,k  ) + a(i,  j-1,k  ) + a(i+1,j-1,k  ) +
                a(i-1,j,  k  ) + a(i,  j,  k  ) + a(i+1,j,  k  ) +
                a(i-1,j+1,k  ) + a(i,  j+1,k  ) + a(i+1,j+1,k  ) +
                a(i-1,j-1,k+1) + a(i,  j-1,k+1) + a(i+1,j-1,k+1) +
                a(i-1,j,  k+1) + a(i,  j,  k+1) + a(i+1,j,  k+1) +
                a(i-1,j+1,k+1) + a(i,  j+1,k+1) + a(i+1,j+1,k+1));
            }
        }
    }
}

void
runDoof3dInC(double* A, double* B, int n) 
{
  int i, j, k;
  const double fact = 1.0 / 9.0;

  for (k = 1; k <= n - 2; k++) 
    {
      for (j = 1; j <= n - 2; j++) 
        {
          for (i = 1; i <= n - 2; i++) 
            {
              b(i,j,k) = fact * (
                a(i-1,j-1,k-1) + a(i,  j-1,k-1) + a(i+1,j-1,k-1) +
                a(i-1,j,  k-1) + a(i,  j,  k-1) + a(i+1,j,  k-1) +
                a(i-1,j+1,k-1) + a(i,  j+1,k-1) + a(i+1,j+1,k-1) +
                a(i-1,j-1,k  ) + a(i,  j-1,k  ) + a(i+1,j-1,k  ) +
                a(i-1,j,  k  ) + a(i,  j,  k  ) + a(i+1,j,  k  ) +
                a(i-1,j+1,k  ) + a(i,  j+1,k  ) + a(i+1,j+1,k  ) +
                a(i-1,j-1,k+1) + a(i,  j-1,k+1) + a(i+1,j-1,k+1) +
                a(i-1,j,  k+1) + a(i,  j,  k+1) + a(i+1,j,  k+1) +
                a(i-1,j+1,k+1) + a(i,  j+1,k+1) + a(i+1,j+1,k+1));
            }
        }
    }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: Doof3dInC.c,v $   $Author: richard $
 * $Revision: 1.6 $   $Date: 2004/11/01 18:15:12 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
