// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//
//-----------------------------------------------------------------------------
// Loop 18 benchmark.
// Based on the Blitz++ version by Todd Veldhuizen.
// See http://monet.uwaterloo.ca/blitz/benchmarks.
//-----------------------------------------------------------------------------

// include files

#include "Loop18InP2.h"
#include "Loop18InCppTran.h"
#include "Loop18InC.h"

//-----------------------------------------------------------------------------
// Main program.
//-----------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  // Initialize Pooma.
  Pooma::initialize(argc, argv);

  // Create a Benchmark object for timings.
  Benchmark Loop18(argc, argv);

  // Register objects for running Loop 18 in C, C++Tran, and Pooma II.
#if !POOMA_NO_RESTRICT
  Loop18.addImplementation(new Loop18InC<true>());
#endif
  Loop18.addImplementation(new Loop18InC<false>());
  Loop18.addImplementation(new Loop18InCppTran());
  Loop18.addImplementation(new Loop18InP2());

  // Run benchmarks for array sizes from 10^2 to 10^5.
  Loop18.setSamplingParameters(100,3,3);
  Loop18.run();

  Pooma::finalize();
  
  return 0;

}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Loop18.cpp,v $   $Author: richard $
// $Revision: 1.14 $   $Date: 2004/11/01 18:15:04 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
