/* -*- C -*- */
/*
   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC

   This file is part of FreePOOMA.

   FreePOOMA is free software; you can redistribute it and/or modify it
   under the terms of the Expat license.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
   license for more details.

   You should have received a copy of the Expat license along with
   FreePOOMA; see the file LICENSE.
 */

/* include files */

#include "Pooma/Configuration.h"
#include <math.h>


/* wrapper for integrated C/C++ compilers */

#ifdef __cplusplus
extern "C" {
#endif

void
runAbcSetup(double* a, double* b, double *c, int n)
{
  int i, j;

  for (j = 0; j <= n - 1; j++)
  {
    for (i = 0; i <= n - 1; i++)
    {
      b[i + n * j] = 0.0;
      c[i + n * j] = 1000.0;
    }
  }
}

/* Abc kernels */

void
runAbcInCRestrict(double *restrict a, double *restrict b,
		  double *restrict c, int n)
{
  int iter, j, i;

  runAbcSetup(a, b, c, n);

  for (iter = 0; iter < 10; ++iter)
    {
      const double k = 1.0 / sqrt((double)(iter+1));
      for (j = 0; j < n; ++j)
	{
	  for (i = 0; i < n; ++i)
	    {
	      a[i + n * j] = b[i + n * j] + k * c[i + n * j];
	      c[i + n * j] = 0.5 * (a[i + n * j] - b[i + n * j]);
	    }
	}
    }
}

void
runAbcInC(double* a, double* b, double* c, int n)
{
  int iter, j, i;

  runAbcSetup(a, b, c, n);

  for (iter = 0; iter < 10; ++iter)
    {
      double k;
      k = 1.0 / sqrt((double)(iter + 1));
      for (j = 0; j < n; ++j)
	{
	  for (i = 0; i < n; ++i)
	    {
	      a[i + n * j] = b[i + n * j] + k * c[i + n * j];
	      c[i + n * j] = 0.5 * (a[i + n * j] - b[i + n * j]);
	    }
	}
    }
}

#ifdef __cplusplus
}
#endif

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: ABCInC.c,v $   $Author: richard $
 * $Revision: 1.12 $   $Date: 2004/11/01 18:15:02 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
