!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
! ----------------------------------------------------------
! COMPUTES THE INTEGRAL CLASS (f sp|p sp)
! ----------------------------------------------------------
   SUBROUTINE IntB10020302(PrmBufB,LBra,PrmBufK,LKet,ACInfo,BDInfo, &
                              OA,LDA,OB,LDB,OC,LDC,OD,LDD,PBC,INTGRL)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      USE ShellPairStruct
      USE GammaF6
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER        :: LBra,LKet,CDOffSet
      REAL(DOUBLE)   :: PrmBufB(10,LBra),PrmBufK(10,LKet)
      TYPE(SmallAtomInfo) :: ACInfo,BDInfo
      TYPE(PBCInfo) :: PBC
      REAL(DOUBLE)  :: INTGRL(*)
      REAL(DOUBLE)  :: Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz
      REAL(DOUBLE)  :: Dx,Dy,Dz,Qx,Qy,Qz,Px,Py,Pz
      REAL(DOUBLE)  :: PQx,PQy,PQz,FPQx,FPQy,FPQz
      REAL(DOUBLE)  :: Zeta,Eta,Omega,Up,Uq,Upq
      REAL(DOUBLE)  :: T,ET,TwoT,InvT,SqInvT
      REAL(DOUBLE)  :: VRR(35,10,0:6)
      REAL(DOUBLE)  :: HRR(45,13,4)
      INTEGER       :: OffSet,OA,LDA,OB,LDB,OC,LDC,OD,LDD,I,J,K,L
      EXTERNAL InitDbl
      CALL InitDbl(45*13,HRR(1,1,1))
      Ax=ACInfo%Atm1X
      Ay=ACInfo%Atm1Y
      Az=ACInfo%Atm1Z
      Bx=ACInfo%Atm2X
      By=ACInfo%Atm2Y
      Bz=ACInfo%Atm2Z
      Cx=BDInfo%Atm1X
      Cy=BDInfo%Atm1Y
      Cz=BDInfo%Atm1Z
      Dx=BDInfo%Atm2X
      Dy=BDInfo%Atm2Y
      Dz=BDInfo%Atm2Z
      ABx=Ax-Bx
      ABy=Ay-By
      ABz=Az-Bz
      CDx=Cx-Dx
      CDy=Cy-Dy
      CDz=Cz-Dz
      DO J=1,LKet ! K^2 VRR |N0) loop
         Eta=PrmBufK(1,J)
         Qx=PrmBufK(2,J)
         Qy=PrmBufK(3,J)
         Qz=PrmBufK(4,J)
         Uq=PrmBufK(5,J)
         FnSpK=PrmBufK(6,J)
         QCx=Qx-Cx
         QCy=Qy-Cy
         QCz=Qz-Cz
         DO K=1,LBra ! K^2 VRR (M0| loop
            Zeta=PrmBufB(1,K)
            Px=PrmBufB(2,K)
            Py=PrmBufB(3,K)
            Pz=PrmBufB(4,K)
            Up=PrmBufB(5,K)
            FnSpB=PrmBufB(6,K)
            r1xZpE=One/(Zeta+Eta)
            Upq=SQRT(r1xZpE)*Up*Uq
            HfxZpE=Half/(Zeta+Eta)
            r1x2E=Half/Eta
            r1x2Z=Half/Zeta
            ExZpE=Eta*r1xZpE
            ZxZpE=Zeta*r1xZpE
            Omega=Eta*Zeta*r1xZpE
            PAx=Px-Ax
            PAy=Py-Ay
            PAz=Pz-Az
            PQx=Px-Qx
            PQy=Py-Qy
            PQz=Pz-Qz
            ! Begin Minimum Image Convention
            FPQx = PQx*PBC%InvBoxSh%D(1,1)+PQy*PBC%InvBoxSh%D(1,2)+PQz*PBC%InvBoxSh%D(1,3)
            FPQy = PQy*PBC%InvBoxSh%D(2,2)+PQz*PBC%InvBoxSh%D(2,3)
            FPQz = PQz*PBC%InvBoxSh%D(3,3)
            IF(PBC%AutoW%I(1)==1)FPQx=FPQx-ANINT(FPQx-SIGN(1D-15,FPQx))
            IF(PBC%AutoW%I(2)==1)FPQy=FPQy-ANINT(FPQy-SIGN(1D-15,FPQy))
            IF(PBC%AutoW%I(3)==1)FPQz=FPQz-ANINT(FPQz-SIGN(1D-15,FPQz))
            PQx=FPQx*PBC%BoxShape%D(1,1)+FPQy*PBC%BoxShape%D(1,2)+FPQz*PBC%BoxShape%D(1,3)
            PQy=FPQy*PBC%BoxShape%D(2,2)+FPQz*PBC%BoxShape%D(2,3)
            PQz=FPQz*PBC%BoxShape%D(3,3)
            ! End MIC
            WPx = -Eta*PQx*r1xZpE
            WPy = -Eta*PQy*r1xZpE
            WPz = -Eta*PQz*r1xZpE
            WQx = Zeta*PQx*r1xZpE
            WQy = Zeta*PQy*r1xZpE
            WQz = Zeta*PQz*r1xZpE
            T=Omega*(PQx*PQx+PQy*PQy+PQz*PQz)
            IF(T<Gamma_Switch)THEN
              L=AINT(T*Gamma_Grid)
              ET=EXP(-T)
              TwoT=Two*T
              W6=(F6_0(L)+T*(F6_1(L)+T*(F6_2(L)+T*(F6_3(L)+T*F6_4(L)))))
              W5=+9.090909090909090D-02*(TwoT*W6+ET)
              W4=+1.111111111111111D-01*(TwoT*W5+ET)
              W3=+1.428571428571428D-01*(TwoT*W4+ET)
              W2=+2.000000000000000D-01*(TwoT*W3+ET)
              W1=+3.333333333333333D-01*(TwoT*W2+ET)
              W0=TwoT*W1+ET
              VRR(1,1,0)=Upq*W0
              VRR(1,1,1)=Upq*W1
              VRR(1,1,2)=Upq*W2
              VRR(1,1,3)=Upq*W3
              VRR(1,1,4)=Upq*W4
              VRR(1,1,5)=Upq*W5
              VRR(1,1,6)=Upq*W6
            ELSE
              InvT=One/T
              SqInvT=DSQRT(InvT)
              VRR(1,1,0)=+8.862269254527580D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,1)=+4.431134627263790D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,2)=+6.646701940895685D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,3)=+1.661675485223921D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,4)=+5.815864198283724D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,5)=+2.617138889227676D+01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,6)=+1.439426389075222D+02*Upq*SqInvT
            ENDIF
            ! Generating (p0|s0)^(5)
            VRR(2,1,5)=PAx*VRR(1,1,5)+WPx*VRR(1,1,6)
            VRR(3,1,5)=PAy*VRR(1,1,5)+WPy*VRR(1,1,6)
            VRR(4,1,5)=PAz*VRR(1,1,5)+WPz*VRR(1,1,6)
            ! Generating (p0|s0)^(4)
            VRR(2,1,4)=PAx*VRR(1,1,4)+WPx*VRR(1,1,5)
            VRR(3,1,4)=PAy*VRR(1,1,4)+WPy*VRR(1,1,5)
            VRR(4,1,4)=PAz*VRR(1,1,4)+WPz*VRR(1,1,5)
            ! Generating (p0|s0)^(3)
            VRR(2,1,3)=PAx*VRR(1,1,3)+WPx*VRR(1,1,4)
            VRR(3,1,3)=PAy*VRR(1,1,3)+WPy*VRR(1,1,4)
            VRR(4,1,3)=PAz*VRR(1,1,3)+WPz*VRR(1,1,4)
            ! Generating (p0|s0)^(2)
            VRR(2,1,2)=PAx*VRR(1,1,2)+WPx*VRR(1,1,3)
            VRR(3,1,2)=PAy*VRR(1,1,2)+WPy*VRR(1,1,3)
            VRR(4,1,2)=PAz*VRR(1,1,2)+WPz*VRR(1,1,3)
            ! Generating (p0|s0)^(1)
            VRR(2,1,1)=PAx*VRR(1,1,1)+WPx*VRR(1,1,2)
            VRR(3,1,1)=PAy*VRR(1,1,1)+WPy*VRR(1,1,2)
            VRR(4,1,1)=PAz*VRR(1,1,1)+WPz*VRR(1,1,2)
            ! Generating (p0|s0)^(0)
            VRR(2,1,0)=PAx*VRR(1,1,0)+WPx*VRR(1,1,1)
            VRR(3,1,0)=PAy*VRR(1,1,0)+WPy*VRR(1,1,1)
            VRR(4,1,0)=PAz*VRR(1,1,0)+WPz*VRR(1,1,1)
            ! Generating (d0|s0)^(4)
            VRR(5,1,4)=PAx*VRR(2,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPx*VRR(2,1,5)
            VRR(6,1,4)=PAx*VRR(3,1,4)+WPx*VRR(3,1,5)
            VRR(7,1,4)=PAy*VRR(3,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPy*VRR(3,1,5)
            VRR(8,1,4)=PAx*VRR(4,1,4)+WPx*VRR(4,1,5)
            VRR(9,1,4)=PAy*VRR(4,1,4)+WPy*VRR(4,1,5)
            VRR(10,1,4)=PAz*VRR(4,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPz*VRR(4,1,5)
            ! Generating (d0|s0)^(3)
            VRR(5,1,3)=PAx*VRR(2,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPx*VRR(2,1,4)
            VRR(6,1,3)=PAx*VRR(3,1,3)+WPx*VRR(3,1,4)
            VRR(7,1,3)=PAy*VRR(3,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPy*VRR(3,1,4)
            VRR(8,1,3)=PAx*VRR(4,1,3)+WPx*VRR(4,1,4)
            VRR(9,1,3)=PAy*VRR(4,1,3)+WPy*VRR(4,1,4)
            VRR(10,1,3)=PAz*VRR(4,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPz*VRR(4,1,4)
            ! Generating (d0|s0)^(2)
            VRR(5,1,2)=PAx*VRR(2,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPx*VRR(2,1,3)
            VRR(6,1,2)=PAx*VRR(3,1,2)+WPx*VRR(3,1,3)
            VRR(7,1,2)=PAy*VRR(3,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPy*VRR(3,1,3)
            VRR(8,1,2)=PAx*VRR(4,1,2)+WPx*VRR(4,1,3)
            VRR(9,1,2)=PAy*VRR(4,1,2)+WPy*VRR(4,1,3)
            VRR(10,1,2)=PAz*VRR(4,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPz*VRR(4,1,3)
            ! Generating (d0|s0)^(1)
            VRR(5,1,1)=PAx*VRR(2,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPx*VRR(2,1,2)
            VRR(6,1,1)=PAx*VRR(3,1,1)+WPx*VRR(3,1,2)
            VRR(7,1,1)=PAy*VRR(3,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPy*VRR(3,1,2)
            VRR(8,1,1)=PAx*VRR(4,1,1)+WPx*VRR(4,1,2)
            VRR(9,1,1)=PAy*VRR(4,1,1)+WPy*VRR(4,1,2)
            VRR(10,1,1)=PAz*VRR(4,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPz*VRR(4,1,2)
            ! Generating (d0|s0)^(0)
            VRR(5,1,0)=PAx*VRR(2,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPx*VRR(2,1,1)
            VRR(6,1,0)=PAx*VRR(3,1,0)+WPx*VRR(3,1,1)
            VRR(7,1,0)=PAy*VRR(3,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPy*VRR(3,1,1)
            VRR(8,1,0)=PAx*VRR(4,1,0)+WPx*VRR(4,1,1)
            VRR(9,1,0)=PAy*VRR(4,1,0)+WPy*VRR(4,1,1)
            VRR(10,1,0)=PAz*VRR(4,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPz*VRR(4,1,1)
            ! Generating (f0|s0)^(3)
            CALL VRRf0s0(35,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|s0)^(2)
            CALL VRRf0s0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|s0)^(1)
            CALL VRRf0s0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|s0)^(0)
            CALL VRRf0s0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|s0)^(2)
            CALL VRRg0s0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|s0)^(1)
            CALL VRRg0s0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|s0)^(0)
            CALL VRRg0s0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|p0)^(5)
            VRR(1,2,5)=QCx*VRR(1,1,5)+WQx*VRR(1,1,6)
            VRR(1,3,5)=QCy*VRR(1,1,5)+WQy*VRR(1,1,6)
            VRR(1,4,5)=QCz*VRR(1,1,5)+WQz*VRR(1,1,6)
            ! Generating (s0|p0)^(4)
            VRR(1,2,4)=QCx*VRR(1,1,4)+WQx*VRR(1,1,5)
            VRR(1,3,4)=QCy*VRR(1,1,4)+WQy*VRR(1,1,5)
            VRR(1,4,4)=QCz*VRR(1,1,4)+WQz*VRR(1,1,5)
            ! Generating (s0|p0)^(3)
            VRR(1,2,3)=QCx*VRR(1,1,3)+WQx*VRR(1,1,4)
            VRR(1,3,3)=QCy*VRR(1,1,3)+WQy*VRR(1,1,4)
            VRR(1,4,3)=QCz*VRR(1,1,3)+WQz*VRR(1,1,4)
            ! Generating (s0|p0)^(2)
            VRR(1,2,2)=QCx*VRR(1,1,2)+WQx*VRR(1,1,3)
            VRR(1,3,2)=QCy*VRR(1,1,2)+WQy*VRR(1,1,3)
            VRR(1,4,2)=QCz*VRR(1,1,2)+WQz*VRR(1,1,3)
            ! Generating (s0|p0)^(1)
            VRR(1,2,1)=QCx*VRR(1,1,1)+WQx*VRR(1,1,2)
            VRR(1,3,1)=QCy*VRR(1,1,1)+WQy*VRR(1,1,2)
            VRR(1,4,1)=QCz*VRR(1,1,1)+WQz*VRR(1,1,2)
            ! Generating (s0|p0)^(0)
            VRR(1,2,0)=QCx*VRR(1,1,0)+WQx*VRR(1,1,1)
            VRR(1,3,0)=QCy*VRR(1,1,0)+WQy*VRR(1,1,1)
            VRR(1,4,0)=QCz*VRR(1,1,0)+WQz*VRR(1,1,1)
            ! Generating (p0|p0)^(4)
            VRR(2,2,4)=QCx*VRR(2,1,4)+HfxZpE*VRR(1,1,5)+WQx*VRR(2,1,5)
            VRR(2,3,4)=QCy*VRR(2,1,4)+WQy*VRR(2,1,5)
            VRR(2,4,4)=QCz*VRR(2,1,4)+WQz*VRR(2,1,5)
            VRR(3,2,4)=QCx*VRR(3,1,4)+WQx*VRR(3,1,5)
            VRR(3,3,4)=QCy*VRR(3,1,4)+HfxZpE*VRR(1,1,5)+WQy*VRR(3,1,5)
            VRR(3,4,4)=QCz*VRR(3,1,4)+WQz*VRR(3,1,5)
            VRR(4,2,4)=QCx*VRR(4,1,4)+WQx*VRR(4,1,5)
            VRR(4,3,4)=QCy*VRR(4,1,4)+WQy*VRR(4,1,5)
            VRR(4,4,4)=QCz*VRR(4,1,4)+HfxZpE*VRR(1,1,5)+WQz*VRR(4,1,5)
            ! Generating (p0|p0)^(3)
            VRR(2,2,3)=QCx*VRR(2,1,3)+HfxZpE*VRR(1,1,4)+WQx*VRR(2,1,4)
            VRR(2,3,3)=QCy*VRR(2,1,3)+WQy*VRR(2,1,4)
            VRR(2,4,3)=QCz*VRR(2,1,3)+WQz*VRR(2,1,4)
            VRR(3,2,3)=QCx*VRR(3,1,3)+WQx*VRR(3,1,4)
            VRR(3,3,3)=QCy*VRR(3,1,3)+HfxZpE*VRR(1,1,4)+WQy*VRR(3,1,4)
            VRR(3,4,3)=QCz*VRR(3,1,3)+WQz*VRR(3,1,4)
            VRR(4,2,3)=QCx*VRR(4,1,3)+WQx*VRR(4,1,4)
            VRR(4,3,3)=QCy*VRR(4,1,3)+WQy*VRR(4,1,4)
            VRR(4,4,3)=QCz*VRR(4,1,3)+HfxZpE*VRR(1,1,4)+WQz*VRR(4,1,4)
            ! Generating (p0|p0)^(2)
            VRR(2,2,2)=QCx*VRR(2,1,2)+HfxZpE*VRR(1,1,3)+WQx*VRR(2,1,3)
            VRR(2,3,2)=QCy*VRR(2,1,2)+WQy*VRR(2,1,3)
            VRR(2,4,2)=QCz*VRR(2,1,2)+WQz*VRR(2,1,3)
            VRR(3,2,2)=QCx*VRR(3,1,2)+WQx*VRR(3,1,3)
            VRR(3,3,2)=QCy*VRR(3,1,2)+HfxZpE*VRR(1,1,3)+WQy*VRR(3,1,3)
            VRR(3,4,2)=QCz*VRR(3,1,2)+WQz*VRR(3,1,3)
            VRR(4,2,2)=QCx*VRR(4,1,2)+WQx*VRR(4,1,3)
            VRR(4,3,2)=QCy*VRR(4,1,2)+WQy*VRR(4,1,3)
            VRR(4,4,2)=QCz*VRR(4,1,2)+HfxZpE*VRR(1,1,3)+WQz*VRR(4,1,3)
            ! Generating (p0|p0)^(1)
            VRR(2,2,1)=QCx*VRR(2,1,1)+HfxZpE*VRR(1,1,2)+WQx*VRR(2,1,2)
            VRR(2,3,1)=QCy*VRR(2,1,1)+WQy*VRR(2,1,2)
            VRR(2,4,1)=QCz*VRR(2,1,1)+WQz*VRR(2,1,2)
            VRR(3,2,1)=QCx*VRR(3,1,1)+WQx*VRR(3,1,2)
            VRR(3,3,1)=QCy*VRR(3,1,1)+HfxZpE*VRR(1,1,2)+WQy*VRR(3,1,2)
            VRR(3,4,1)=QCz*VRR(3,1,1)+WQz*VRR(3,1,2)
            VRR(4,2,1)=QCx*VRR(4,1,1)+WQx*VRR(4,1,2)
            VRR(4,3,1)=QCy*VRR(4,1,1)+WQy*VRR(4,1,2)
            VRR(4,4,1)=QCz*VRR(4,1,1)+HfxZpE*VRR(1,1,2)+WQz*VRR(4,1,2)
            ! Generating (p0|p0)^(0)
            VRR(2,2,0)=QCx*VRR(2,1,0)+HfxZpE*VRR(1,1,1)+WQx*VRR(2,1,1)
            VRR(2,3,0)=QCy*VRR(2,1,0)+WQy*VRR(2,1,1)
            VRR(2,4,0)=QCz*VRR(2,1,0)+WQz*VRR(2,1,1)
            VRR(3,2,0)=QCx*VRR(3,1,0)+WQx*VRR(3,1,1)
            VRR(3,3,0)=QCy*VRR(3,1,0)+HfxZpE*VRR(1,1,1)+WQy*VRR(3,1,1)
            VRR(3,4,0)=QCz*VRR(3,1,0)+WQz*VRR(3,1,1)
            VRR(4,2,0)=QCx*VRR(4,1,0)+WQx*VRR(4,1,1)
            VRR(4,3,0)=QCy*VRR(4,1,0)+WQy*VRR(4,1,1)
            VRR(4,4,0)=QCz*VRR(4,1,0)+HfxZpE*VRR(1,1,1)+WQz*VRR(4,1,1)
            ! Generating (d0|p0)^(3)
            CALL VRRd0p0(35,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|p0)^(2)
            CALL VRRd0p0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|p0)^(1)
            CALL VRRd0p0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|p0)^(0)
            CALL VRRd0p0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|p0)^(2)
            CALL VRRf0p0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|p0)^(1)
            CALL VRRf0p0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|p0)^(0)
            CALL VRRf0p0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|p0)^(1)
            CALL VRRg0p0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|p0)^(0)
            CALL VRRg0p0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|d0)^(4)
            CALL VRRs0d0(35,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|d0)^(3)
            CALL VRRs0d0(35,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|d0)^(2)
            CALL VRRs0d0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|d0)^(1)
            CALL VRRs0d0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|d0)^(0)
            CALL VRRs0d0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|d0)^(3)
            CALL VRRp0d0(35,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|d0)^(2)
            CALL VRRp0d0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|d0)^(1)
            CALL VRRp0d0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|d0)^(0)
            CALL VRRp0d0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|d0)^(2)
            CALL VRRd0d0(35,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|d0)^(1)
            CALL VRRd0d0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|d0)^(0)
            CALL VRRd0d0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|d0)^(1)
            CALL VRRf0d0(35,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|d0)^(0)
            CALL VRRf0d0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|d0)^(0)
            CALL VRRg0d0(35,10,VRR(1,1,0),VRR(1,1,1))
            ! Contracting ...
            CALL CNTRCT10232(VRR,HRR)
         ENDDO ! (M0| loop
      ENDDO ! |N0) loop
      ! Generating (f,0|p,sp)^(0)
      CALL KetHRR32(45,HRR)
      ! Generating (f,sp|p,sp)^(0)
      DO L=1,4
         DO K=2,4
            CDOffSet=(OC+K-2)*LDC+(OD+L-1)*LDD
            CALL BraHRR102(OA,OB,LDA,LDB,CDOffSet,HRR(1,K,L),INTGRL)
          ENDDO
      ENDDO
    END SUBROUTINE IntB10020302
    SUBROUTINE CNTRCT10232(VRR,HRR)
      USE DerivedTypes
      USE VScratchB
      REAL(DOUBLE)  :: VRR(35,10,0:6)
      REAL(DOUBLE)  :: HRR(45,13,4)
      HRR(1,1,1)=HRR(1,1,1)+VRR(1,1,0)
      HRR(1,2,1)=HRR(1,2,1)+VRR(1,2,0)
      HRR(1,11,1)=HRR(1,11,1)+FnSpK*VRR(1,2,0)
      HRR(1,3,1)=HRR(1,3,1)+VRR(1,3,0)
      HRR(1,12,1)=HRR(1,12,1)+FnSpK*VRR(1,3,0)
      HRR(1,4,1)=HRR(1,4,1)+VRR(1,4,0)
      HRR(1,13,1)=HRR(1,13,1)+FnSpK*VRR(1,4,0)
      HRR(1,5,1)=HRR(1,5,1)+VRR(1,5,0)
      HRR(1,6,1)=HRR(1,6,1)+VRR(1,6,0)
      HRR(1,7,1)=HRR(1,7,1)+VRR(1,7,0)
      HRR(1,8,1)=HRR(1,8,1)+VRR(1,8,0)
      HRR(1,9,1)=HRR(1,9,1)+VRR(1,9,0)
      HRR(1,10,1)=HRR(1,10,1)+VRR(1,10,0)
      HRR(2,1,1)=HRR(2,1,1)+VRR(2,1,0)
      HRR(2,2,1)=HRR(2,2,1)+VRR(2,2,0)
      HRR(2,11,1)=HRR(2,11,1)+FnSpK*VRR(2,2,0)
      HRR(2,3,1)=HRR(2,3,1)+VRR(2,3,0)
      HRR(2,12,1)=HRR(2,12,1)+FnSpK*VRR(2,3,0)
      HRR(2,4,1)=HRR(2,4,1)+VRR(2,4,0)
      HRR(2,13,1)=HRR(2,13,1)+FnSpK*VRR(2,4,0)
      HRR(2,5,1)=HRR(2,5,1)+VRR(2,5,0)
      HRR(2,6,1)=HRR(2,6,1)+VRR(2,6,0)
      HRR(2,7,1)=HRR(2,7,1)+VRR(2,7,0)
      HRR(2,8,1)=HRR(2,8,1)+VRR(2,8,0)
      HRR(2,9,1)=HRR(2,9,1)+VRR(2,9,0)
      HRR(2,10,1)=HRR(2,10,1)+VRR(2,10,0)
      HRR(3,1,1)=HRR(3,1,1)+VRR(3,1,0)
      HRR(3,2,1)=HRR(3,2,1)+VRR(3,2,0)
      HRR(3,11,1)=HRR(3,11,1)+FnSpK*VRR(3,2,0)
      HRR(3,3,1)=HRR(3,3,1)+VRR(3,3,0)
      HRR(3,12,1)=HRR(3,12,1)+FnSpK*VRR(3,3,0)
      HRR(3,4,1)=HRR(3,4,1)+VRR(3,4,0)
      HRR(3,13,1)=HRR(3,13,1)+FnSpK*VRR(3,4,0)
      HRR(3,5,1)=HRR(3,5,1)+VRR(3,5,0)
      HRR(3,6,1)=HRR(3,6,1)+VRR(3,6,0)
      HRR(3,7,1)=HRR(3,7,1)+VRR(3,7,0)
      HRR(3,8,1)=HRR(3,8,1)+VRR(3,8,0)
      HRR(3,9,1)=HRR(3,9,1)+VRR(3,9,0)
      HRR(3,10,1)=HRR(3,10,1)+VRR(3,10,0)
      HRR(4,1,1)=HRR(4,1,1)+VRR(4,1,0)
      HRR(4,2,1)=HRR(4,2,1)+VRR(4,2,0)
      HRR(4,11,1)=HRR(4,11,1)+FnSpK*VRR(4,2,0)
      HRR(4,3,1)=HRR(4,3,1)+VRR(4,3,0)
      HRR(4,12,1)=HRR(4,12,1)+FnSpK*VRR(4,3,0)
      HRR(4,4,1)=HRR(4,4,1)+VRR(4,4,0)
      HRR(4,13,1)=HRR(4,13,1)+FnSpK*VRR(4,4,0)
      HRR(4,5,1)=HRR(4,5,1)+VRR(4,5,0)
      HRR(4,6,1)=HRR(4,6,1)+VRR(4,6,0)
      HRR(4,7,1)=HRR(4,7,1)+VRR(4,7,0)
      HRR(4,8,1)=HRR(4,8,1)+VRR(4,8,0)
      HRR(4,9,1)=HRR(4,9,1)+VRR(4,9,0)
      HRR(4,10,1)=HRR(4,10,1)+VRR(4,10,0)
      HRR(5,1,1)=HRR(5,1,1)+VRR(5,1,0)
      HRR(5,2,1)=HRR(5,2,1)+VRR(5,2,0)
      HRR(5,11,1)=HRR(5,11,1)+FnSpK*VRR(5,2,0)
      HRR(5,3,1)=HRR(5,3,1)+VRR(5,3,0)
      HRR(5,12,1)=HRR(5,12,1)+FnSpK*VRR(5,3,0)
      HRR(5,4,1)=HRR(5,4,1)+VRR(5,4,0)
      HRR(5,13,1)=HRR(5,13,1)+FnSpK*VRR(5,4,0)
      HRR(5,5,1)=HRR(5,5,1)+VRR(5,5,0)
      HRR(5,6,1)=HRR(5,6,1)+VRR(5,6,0)
      HRR(5,7,1)=HRR(5,7,1)+VRR(5,7,0)
      HRR(5,8,1)=HRR(5,8,1)+VRR(5,8,0)
      HRR(5,9,1)=HRR(5,9,1)+VRR(5,9,0)
      HRR(5,10,1)=HRR(5,10,1)+VRR(5,10,0)
      HRR(6,1,1)=HRR(6,1,1)+VRR(6,1,0)
      HRR(6,2,1)=HRR(6,2,1)+VRR(6,2,0)
      HRR(6,11,1)=HRR(6,11,1)+FnSpK*VRR(6,2,0)
      HRR(6,3,1)=HRR(6,3,1)+VRR(6,3,0)
      HRR(6,12,1)=HRR(6,12,1)+FnSpK*VRR(6,3,0)
      HRR(6,4,1)=HRR(6,4,1)+VRR(6,4,0)
      HRR(6,13,1)=HRR(6,13,1)+FnSpK*VRR(6,4,0)
      HRR(6,5,1)=HRR(6,5,1)+VRR(6,5,0)
      HRR(6,6,1)=HRR(6,6,1)+VRR(6,6,0)
      HRR(6,7,1)=HRR(6,7,1)+VRR(6,7,0)
      HRR(6,8,1)=HRR(6,8,1)+VRR(6,8,0)
      HRR(6,9,1)=HRR(6,9,1)+VRR(6,9,0)
      HRR(6,10,1)=HRR(6,10,1)+VRR(6,10,0)
      HRR(7,1,1)=HRR(7,1,1)+VRR(7,1,0)
      HRR(7,2,1)=HRR(7,2,1)+VRR(7,2,0)
      HRR(7,11,1)=HRR(7,11,1)+FnSpK*VRR(7,2,0)
      HRR(7,3,1)=HRR(7,3,1)+VRR(7,3,0)
      HRR(7,12,1)=HRR(7,12,1)+FnSpK*VRR(7,3,0)
      HRR(7,4,1)=HRR(7,4,1)+VRR(7,4,0)
      HRR(7,13,1)=HRR(7,13,1)+FnSpK*VRR(7,4,0)
      HRR(7,5,1)=HRR(7,5,1)+VRR(7,5,0)
      HRR(7,6,1)=HRR(7,6,1)+VRR(7,6,0)
      HRR(7,7,1)=HRR(7,7,1)+VRR(7,7,0)
      HRR(7,8,1)=HRR(7,8,1)+VRR(7,8,0)
      HRR(7,9,1)=HRR(7,9,1)+VRR(7,9,0)
      HRR(7,10,1)=HRR(7,10,1)+VRR(7,10,0)
      HRR(8,1,1)=HRR(8,1,1)+VRR(8,1,0)
      HRR(8,2,1)=HRR(8,2,1)+VRR(8,2,0)
      HRR(8,11,1)=HRR(8,11,1)+FnSpK*VRR(8,2,0)
      HRR(8,3,1)=HRR(8,3,1)+VRR(8,3,0)
      HRR(8,12,1)=HRR(8,12,1)+FnSpK*VRR(8,3,0)
      HRR(8,4,1)=HRR(8,4,1)+VRR(8,4,0)
      HRR(8,13,1)=HRR(8,13,1)+FnSpK*VRR(8,4,0)
      HRR(8,5,1)=HRR(8,5,1)+VRR(8,5,0)
      HRR(8,6,1)=HRR(8,6,1)+VRR(8,6,0)
      HRR(8,7,1)=HRR(8,7,1)+VRR(8,7,0)
      HRR(8,8,1)=HRR(8,8,1)+VRR(8,8,0)
      HRR(8,9,1)=HRR(8,9,1)+VRR(8,9,0)
      HRR(8,10,1)=HRR(8,10,1)+VRR(8,10,0)
      HRR(9,1,1)=HRR(9,1,1)+VRR(9,1,0)
      HRR(9,2,1)=HRR(9,2,1)+VRR(9,2,0)
      HRR(9,11,1)=HRR(9,11,1)+FnSpK*VRR(9,2,0)
      HRR(9,3,1)=HRR(9,3,1)+VRR(9,3,0)
      HRR(9,12,1)=HRR(9,12,1)+FnSpK*VRR(9,3,0)
      HRR(9,4,1)=HRR(9,4,1)+VRR(9,4,0)
      HRR(9,13,1)=HRR(9,13,1)+FnSpK*VRR(9,4,0)
      HRR(9,5,1)=HRR(9,5,1)+VRR(9,5,0)
      HRR(9,6,1)=HRR(9,6,1)+VRR(9,6,0)
      HRR(9,7,1)=HRR(9,7,1)+VRR(9,7,0)
      HRR(9,8,1)=HRR(9,8,1)+VRR(9,8,0)
      HRR(9,9,1)=HRR(9,9,1)+VRR(9,9,0)
      HRR(9,10,1)=HRR(9,10,1)+VRR(9,10,0)
      HRR(10,1,1)=HRR(10,1,1)+VRR(10,1,0)
      HRR(10,2,1)=HRR(10,2,1)+VRR(10,2,0)
      HRR(10,11,1)=HRR(10,11,1)+FnSpK*VRR(10,2,0)
      HRR(10,3,1)=HRR(10,3,1)+VRR(10,3,0)
      HRR(10,12,1)=HRR(10,12,1)+FnSpK*VRR(10,3,0)
      HRR(10,4,1)=HRR(10,4,1)+VRR(10,4,0)
      HRR(10,13,1)=HRR(10,13,1)+FnSpK*VRR(10,4,0)
      HRR(10,5,1)=HRR(10,5,1)+VRR(10,5,0)
      HRR(10,6,1)=HRR(10,6,1)+VRR(10,6,0)
      HRR(10,7,1)=HRR(10,7,1)+VRR(10,7,0)
      HRR(10,8,1)=HRR(10,8,1)+VRR(10,8,0)
      HRR(10,9,1)=HRR(10,9,1)+VRR(10,9,0)
      HRR(10,10,1)=HRR(10,10,1)+VRR(10,10,0)
      HRR(11,1,1)=HRR(11,1,1)+VRR(11,1,0)
      HRR(36,1,1)=HRR(36,1,1)+FnSpB*VRR(11,1,0)
      HRR(11,2,1)=HRR(11,2,1)+VRR(11,2,0)
      HRR(36,11,1)=HRR(36,11,1)+FnSpB*FnSpK*VRR(11,2,0)
      HRR(36,2,1)=HRR(36,2,1)+FnSpB*VRR(11,2,0)
      HRR(11,11,1)=HRR(11,11,1)+FnSpK*VRR(11,2,0)
      HRR(11,3,1)=HRR(11,3,1)+VRR(11,3,0)
      HRR(36,12,1)=HRR(36,12,1)+FnSpB*FnSpK*VRR(11,3,0)
      HRR(36,3,1)=HRR(36,3,1)+FnSpB*VRR(11,3,0)
      HRR(11,12,1)=HRR(11,12,1)+FnSpK*VRR(11,3,0)
      HRR(11,4,1)=HRR(11,4,1)+VRR(11,4,0)
      HRR(36,13,1)=HRR(36,13,1)+FnSpB*FnSpK*VRR(11,4,0)
      HRR(36,4,1)=HRR(36,4,1)+FnSpB*VRR(11,4,0)
      HRR(11,13,1)=HRR(11,13,1)+FnSpK*VRR(11,4,0)
      HRR(11,5,1)=HRR(11,5,1)+VRR(11,5,0)
      HRR(36,5,1)=HRR(36,5,1)+FnSpB*VRR(11,5,0)
      HRR(11,6,1)=HRR(11,6,1)+VRR(11,6,0)
      HRR(36,6,1)=HRR(36,6,1)+FnSpB*VRR(11,6,0)
      HRR(11,7,1)=HRR(11,7,1)+VRR(11,7,0)
      HRR(36,7,1)=HRR(36,7,1)+FnSpB*VRR(11,7,0)
      HRR(11,8,1)=HRR(11,8,1)+VRR(11,8,0)
      HRR(36,8,1)=HRR(36,8,1)+FnSpB*VRR(11,8,0)
      HRR(11,9,1)=HRR(11,9,1)+VRR(11,9,0)
      HRR(36,9,1)=HRR(36,9,1)+FnSpB*VRR(11,9,0)
      HRR(11,10,1)=HRR(11,10,1)+VRR(11,10,0)
      HRR(36,10,1)=HRR(36,10,1)+FnSpB*VRR(11,10,0)
      HRR(12,1,1)=HRR(12,1,1)+VRR(12,1,0)
      HRR(37,1,1)=HRR(37,1,1)+FnSpB*VRR(12,1,0)
      HRR(12,2,1)=HRR(12,2,1)+VRR(12,2,0)
      HRR(37,11,1)=HRR(37,11,1)+FnSpB*FnSpK*VRR(12,2,0)
      HRR(37,2,1)=HRR(37,2,1)+FnSpB*VRR(12,2,0)
      HRR(12,11,1)=HRR(12,11,1)+FnSpK*VRR(12,2,0)
      HRR(12,3,1)=HRR(12,3,1)+VRR(12,3,0)
      HRR(37,12,1)=HRR(37,12,1)+FnSpB*FnSpK*VRR(12,3,0)
      HRR(37,3,1)=HRR(37,3,1)+FnSpB*VRR(12,3,0)
      HRR(12,12,1)=HRR(12,12,1)+FnSpK*VRR(12,3,0)
      HRR(12,4,1)=HRR(12,4,1)+VRR(12,4,0)
      HRR(37,13,1)=HRR(37,13,1)+FnSpB*FnSpK*VRR(12,4,0)
      HRR(37,4,1)=HRR(37,4,1)+FnSpB*VRR(12,4,0)
      HRR(12,13,1)=HRR(12,13,1)+FnSpK*VRR(12,4,0)
      HRR(12,5,1)=HRR(12,5,1)+VRR(12,5,0)
      HRR(37,5,1)=HRR(37,5,1)+FnSpB*VRR(12,5,0)
      HRR(12,6,1)=HRR(12,6,1)+VRR(12,6,0)
      HRR(37,6,1)=HRR(37,6,1)+FnSpB*VRR(12,6,0)
      HRR(12,7,1)=HRR(12,7,1)+VRR(12,7,0)
      HRR(37,7,1)=HRR(37,7,1)+FnSpB*VRR(12,7,0)
      HRR(12,8,1)=HRR(12,8,1)+VRR(12,8,0)
      HRR(37,8,1)=HRR(37,8,1)+FnSpB*VRR(12,8,0)
      HRR(12,9,1)=HRR(12,9,1)+VRR(12,9,0)
      HRR(37,9,1)=HRR(37,9,1)+FnSpB*VRR(12,9,0)
      HRR(12,10,1)=HRR(12,10,1)+VRR(12,10,0)
      HRR(37,10,1)=HRR(37,10,1)+FnSpB*VRR(12,10,0)
      HRR(13,1,1)=HRR(13,1,1)+VRR(13,1,0)
      HRR(38,1,1)=HRR(38,1,1)+FnSpB*VRR(13,1,0)
      HRR(13,2,1)=HRR(13,2,1)+VRR(13,2,0)
      HRR(38,11,1)=HRR(38,11,1)+FnSpB*FnSpK*VRR(13,2,0)
      HRR(38,2,1)=HRR(38,2,1)+FnSpB*VRR(13,2,0)
      HRR(13,11,1)=HRR(13,11,1)+FnSpK*VRR(13,2,0)
      HRR(13,3,1)=HRR(13,3,1)+VRR(13,3,0)
      HRR(38,12,1)=HRR(38,12,1)+FnSpB*FnSpK*VRR(13,3,0)
      HRR(38,3,1)=HRR(38,3,1)+FnSpB*VRR(13,3,0)
      HRR(13,12,1)=HRR(13,12,1)+FnSpK*VRR(13,3,0)
      HRR(13,4,1)=HRR(13,4,1)+VRR(13,4,0)
      HRR(38,13,1)=HRR(38,13,1)+FnSpB*FnSpK*VRR(13,4,0)
      HRR(38,4,1)=HRR(38,4,1)+FnSpB*VRR(13,4,0)
      HRR(13,13,1)=HRR(13,13,1)+FnSpK*VRR(13,4,0)
      HRR(13,5,1)=HRR(13,5,1)+VRR(13,5,0)
      HRR(38,5,1)=HRR(38,5,1)+FnSpB*VRR(13,5,0)
      HRR(13,6,1)=HRR(13,6,1)+VRR(13,6,0)
      HRR(38,6,1)=HRR(38,6,1)+FnSpB*VRR(13,6,0)
      HRR(13,7,1)=HRR(13,7,1)+VRR(13,7,0)
      HRR(38,7,1)=HRR(38,7,1)+FnSpB*VRR(13,7,0)
      HRR(13,8,1)=HRR(13,8,1)+VRR(13,8,0)
      HRR(38,8,1)=HRR(38,8,1)+FnSpB*VRR(13,8,0)
      HRR(13,9,1)=HRR(13,9,1)+VRR(13,9,0)
      HRR(38,9,1)=HRR(38,9,1)+FnSpB*VRR(13,9,0)
      HRR(13,10,1)=HRR(13,10,1)+VRR(13,10,0)
      HRR(38,10,1)=HRR(38,10,1)+FnSpB*VRR(13,10,0)
      HRR(14,1,1)=HRR(14,1,1)+VRR(14,1,0)
      HRR(39,1,1)=HRR(39,1,1)+FnSpB*VRR(14,1,0)
      HRR(14,2,1)=HRR(14,2,1)+VRR(14,2,0)
      HRR(39,11,1)=HRR(39,11,1)+FnSpB*FnSpK*VRR(14,2,0)
      HRR(39,2,1)=HRR(39,2,1)+FnSpB*VRR(14,2,0)
      HRR(14,11,1)=HRR(14,11,1)+FnSpK*VRR(14,2,0)
      HRR(14,3,1)=HRR(14,3,1)+VRR(14,3,0)
      HRR(39,12,1)=HRR(39,12,1)+FnSpB*FnSpK*VRR(14,3,0)
      HRR(39,3,1)=HRR(39,3,1)+FnSpB*VRR(14,3,0)
      HRR(14,12,1)=HRR(14,12,1)+FnSpK*VRR(14,3,0)
      HRR(14,4,1)=HRR(14,4,1)+VRR(14,4,0)
      HRR(39,13,1)=HRR(39,13,1)+FnSpB*FnSpK*VRR(14,4,0)
      HRR(39,4,1)=HRR(39,4,1)+FnSpB*VRR(14,4,0)
      HRR(14,13,1)=HRR(14,13,1)+FnSpK*VRR(14,4,0)
      HRR(14,5,1)=HRR(14,5,1)+VRR(14,5,0)
      HRR(39,5,1)=HRR(39,5,1)+FnSpB*VRR(14,5,0)
      HRR(14,6,1)=HRR(14,6,1)+VRR(14,6,0)
      HRR(39,6,1)=HRR(39,6,1)+FnSpB*VRR(14,6,0)
      HRR(14,7,1)=HRR(14,7,1)+VRR(14,7,0)
      HRR(39,7,1)=HRR(39,7,1)+FnSpB*VRR(14,7,0)
      HRR(14,8,1)=HRR(14,8,1)+VRR(14,8,0)
      HRR(39,8,1)=HRR(39,8,1)+FnSpB*VRR(14,8,0)
      HRR(14,9,1)=HRR(14,9,1)+VRR(14,9,0)
      HRR(39,9,1)=HRR(39,9,1)+FnSpB*VRR(14,9,0)
      HRR(14,10,1)=HRR(14,10,1)+VRR(14,10,0)
      HRR(39,10,1)=HRR(39,10,1)+FnSpB*VRR(14,10,0)
      HRR(15,1,1)=HRR(15,1,1)+VRR(15,1,0)
      HRR(40,1,1)=HRR(40,1,1)+FnSpB*VRR(15,1,0)
      HRR(15,2,1)=HRR(15,2,1)+VRR(15,2,0)
      HRR(40,11,1)=HRR(40,11,1)+FnSpB*FnSpK*VRR(15,2,0)
      HRR(40,2,1)=HRR(40,2,1)+FnSpB*VRR(15,2,0)
      HRR(15,11,1)=HRR(15,11,1)+FnSpK*VRR(15,2,0)
      HRR(15,3,1)=HRR(15,3,1)+VRR(15,3,0)
      HRR(40,12,1)=HRR(40,12,1)+FnSpB*FnSpK*VRR(15,3,0)
      HRR(40,3,1)=HRR(40,3,1)+FnSpB*VRR(15,3,0)
      HRR(15,12,1)=HRR(15,12,1)+FnSpK*VRR(15,3,0)
      HRR(15,4,1)=HRR(15,4,1)+VRR(15,4,0)
      HRR(40,13,1)=HRR(40,13,1)+FnSpB*FnSpK*VRR(15,4,0)
      HRR(40,4,1)=HRR(40,4,1)+FnSpB*VRR(15,4,0)
      HRR(15,13,1)=HRR(15,13,1)+FnSpK*VRR(15,4,0)
      HRR(15,5,1)=HRR(15,5,1)+VRR(15,5,0)
      HRR(40,5,1)=HRR(40,5,1)+FnSpB*VRR(15,5,0)
      HRR(15,6,1)=HRR(15,6,1)+VRR(15,6,0)
      HRR(40,6,1)=HRR(40,6,1)+FnSpB*VRR(15,6,0)
      HRR(15,7,1)=HRR(15,7,1)+VRR(15,7,0)
      HRR(40,7,1)=HRR(40,7,1)+FnSpB*VRR(15,7,0)
      HRR(15,8,1)=HRR(15,8,1)+VRR(15,8,0)
      HRR(40,8,1)=HRR(40,8,1)+FnSpB*VRR(15,8,0)
      HRR(15,9,1)=HRR(15,9,1)+VRR(15,9,0)
      HRR(40,9,1)=HRR(40,9,1)+FnSpB*VRR(15,9,0)
      HRR(15,10,1)=HRR(15,10,1)+VRR(15,10,0)
      HRR(40,10,1)=HRR(40,10,1)+FnSpB*VRR(15,10,0)
      HRR(16,1,1)=HRR(16,1,1)+VRR(16,1,0)
      HRR(41,1,1)=HRR(41,1,1)+FnSpB*VRR(16,1,0)
      HRR(16,2,1)=HRR(16,2,1)+VRR(16,2,0)
      HRR(41,11,1)=HRR(41,11,1)+FnSpB*FnSpK*VRR(16,2,0)
      HRR(41,2,1)=HRR(41,2,1)+FnSpB*VRR(16,2,0)
      HRR(16,11,1)=HRR(16,11,1)+FnSpK*VRR(16,2,0)
      HRR(16,3,1)=HRR(16,3,1)+VRR(16,3,0)
      HRR(41,12,1)=HRR(41,12,1)+FnSpB*FnSpK*VRR(16,3,0)
      HRR(41,3,1)=HRR(41,3,1)+FnSpB*VRR(16,3,0)
      HRR(16,12,1)=HRR(16,12,1)+FnSpK*VRR(16,3,0)
      HRR(16,4,1)=HRR(16,4,1)+VRR(16,4,0)
      HRR(41,13,1)=HRR(41,13,1)+FnSpB*FnSpK*VRR(16,4,0)
      HRR(41,4,1)=HRR(41,4,1)+FnSpB*VRR(16,4,0)
      HRR(16,13,1)=HRR(16,13,1)+FnSpK*VRR(16,4,0)
      HRR(16,5,1)=HRR(16,5,1)+VRR(16,5,0)
      HRR(41,5,1)=HRR(41,5,1)+FnSpB*VRR(16,5,0)
      HRR(16,6,1)=HRR(16,6,1)+VRR(16,6,0)
      HRR(41,6,1)=HRR(41,6,1)+FnSpB*VRR(16,6,0)
      HRR(16,7,1)=HRR(16,7,1)+VRR(16,7,0)
      HRR(41,7,1)=HRR(41,7,1)+FnSpB*VRR(16,7,0)
      HRR(16,8,1)=HRR(16,8,1)+VRR(16,8,0)
      HRR(41,8,1)=HRR(41,8,1)+FnSpB*VRR(16,8,0)
      HRR(16,9,1)=HRR(16,9,1)+VRR(16,9,0)
      HRR(41,9,1)=HRR(41,9,1)+FnSpB*VRR(16,9,0)
      HRR(16,10,1)=HRR(16,10,1)+VRR(16,10,0)
      HRR(41,10,1)=HRR(41,10,1)+FnSpB*VRR(16,10,0)
      HRR(17,1,1)=HRR(17,1,1)+VRR(17,1,0)
      HRR(42,1,1)=HRR(42,1,1)+FnSpB*VRR(17,1,0)
      HRR(17,2,1)=HRR(17,2,1)+VRR(17,2,0)
      HRR(42,11,1)=HRR(42,11,1)+FnSpB*FnSpK*VRR(17,2,0)
      HRR(42,2,1)=HRR(42,2,1)+FnSpB*VRR(17,2,0)
      HRR(17,11,1)=HRR(17,11,1)+FnSpK*VRR(17,2,0)
      HRR(17,3,1)=HRR(17,3,1)+VRR(17,3,0)
      HRR(42,12,1)=HRR(42,12,1)+FnSpB*FnSpK*VRR(17,3,0)
      HRR(42,3,1)=HRR(42,3,1)+FnSpB*VRR(17,3,0)
      HRR(17,12,1)=HRR(17,12,1)+FnSpK*VRR(17,3,0)
      HRR(17,4,1)=HRR(17,4,1)+VRR(17,4,0)
      HRR(42,13,1)=HRR(42,13,1)+FnSpB*FnSpK*VRR(17,4,0)
      HRR(42,4,1)=HRR(42,4,1)+FnSpB*VRR(17,4,0)
      HRR(17,13,1)=HRR(17,13,1)+FnSpK*VRR(17,4,0)
      HRR(17,5,1)=HRR(17,5,1)+VRR(17,5,0)
      HRR(42,5,1)=HRR(42,5,1)+FnSpB*VRR(17,5,0)
      HRR(17,6,1)=HRR(17,6,1)+VRR(17,6,0)
      HRR(42,6,1)=HRR(42,6,1)+FnSpB*VRR(17,6,0)
      HRR(17,7,1)=HRR(17,7,1)+VRR(17,7,0)
      HRR(42,7,1)=HRR(42,7,1)+FnSpB*VRR(17,7,0)
      HRR(17,8,1)=HRR(17,8,1)+VRR(17,8,0)
      HRR(42,8,1)=HRR(42,8,1)+FnSpB*VRR(17,8,0)
      HRR(17,9,1)=HRR(17,9,1)+VRR(17,9,0)
      HRR(42,9,1)=HRR(42,9,1)+FnSpB*VRR(17,9,0)
      HRR(17,10,1)=HRR(17,10,1)+VRR(17,10,0)
      HRR(42,10,1)=HRR(42,10,1)+FnSpB*VRR(17,10,0)
      HRR(18,1,1)=HRR(18,1,1)+VRR(18,1,0)
      HRR(43,1,1)=HRR(43,1,1)+FnSpB*VRR(18,1,0)
      HRR(18,2,1)=HRR(18,2,1)+VRR(18,2,0)
      HRR(43,11,1)=HRR(43,11,1)+FnSpB*FnSpK*VRR(18,2,0)
      HRR(43,2,1)=HRR(43,2,1)+FnSpB*VRR(18,2,0)
      HRR(18,11,1)=HRR(18,11,1)+FnSpK*VRR(18,2,0)
      HRR(18,3,1)=HRR(18,3,1)+VRR(18,3,0)
      HRR(43,12,1)=HRR(43,12,1)+FnSpB*FnSpK*VRR(18,3,0)
      HRR(43,3,1)=HRR(43,3,1)+FnSpB*VRR(18,3,0)
      HRR(18,12,1)=HRR(18,12,1)+FnSpK*VRR(18,3,0)
      HRR(18,4,1)=HRR(18,4,1)+VRR(18,4,0)
      HRR(43,13,1)=HRR(43,13,1)+FnSpB*FnSpK*VRR(18,4,0)
      HRR(43,4,1)=HRR(43,4,1)+FnSpB*VRR(18,4,0)
      HRR(18,13,1)=HRR(18,13,1)+FnSpK*VRR(18,4,0)
      HRR(18,5,1)=HRR(18,5,1)+VRR(18,5,0)
      HRR(43,5,1)=HRR(43,5,1)+FnSpB*VRR(18,5,0)
      HRR(18,6,1)=HRR(18,6,1)+VRR(18,6,0)
      HRR(43,6,1)=HRR(43,6,1)+FnSpB*VRR(18,6,0)
      HRR(18,7,1)=HRR(18,7,1)+VRR(18,7,0)
      HRR(43,7,1)=HRR(43,7,1)+FnSpB*VRR(18,7,0)
      HRR(18,8,1)=HRR(18,8,1)+VRR(18,8,0)
      HRR(43,8,1)=HRR(43,8,1)+FnSpB*VRR(18,8,0)
      HRR(18,9,1)=HRR(18,9,1)+VRR(18,9,0)
      HRR(43,9,1)=HRR(43,9,1)+FnSpB*VRR(18,9,0)
      HRR(18,10,1)=HRR(18,10,1)+VRR(18,10,0)
      HRR(43,10,1)=HRR(43,10,1)+FnSpB*VRR(18,10,0)
      HRR(19,1,1)=HRR(19,1,1)+VRR(19,1,0)
      HRR(44,1,1)=HRR(44,1,1)+FnSpB*VRR(19,1,0)
      HRR(19,2,1)=HRR(19,2,1)+VRR(19,2,0)
      HRR(44,11,1)=HRR(44,11,1)+FnSpB*FnSpK*VRR(19,2,0)
      HRR(44,2,1)=HRR(44,2,1)+FnSpB*VRR(19,2,0)
      HRR(19,11,1)=HRR(19,11,1)+FnSpK*VRR(19,2,0)
      HRR(19,3,1)=HRR(19,3,1)+VRR(19,3,0)
      HRR(44,12,1)=HRR(44,12,1)+FnSpB*FnSpK*VRR(19,3,0)
      HRR(44,3,1)=HRR(44,3,1)+FnSpB*VRR(19,3,0)
      HRR(19,12,1)=HRR(19,12,1)+FnSpK*VRR(19,3,0)
      HRR(19,4,1)=HRR(19,4,1)+VRR(19,4,0)
      HRR(44,13,1)=HRR(44,13,1)+FnSpB*FnSpK*VRR(19,4,0)
      HRR(44,4,1)=HRR(44,4,1)+FnSpB*VRR(19,4,0)
      HRR(19,13,1)=HRR(19,13,1)+FnSpK*VRR(19,4,0)
      HRR(19,5,1)=HRR(19,5,1)+VRR(19,5,0)
      HRR(44,5,1)=HRR(44,5,1)+FnSpB*VRR(19,5,0)
      HRR(19,6,1)=HRR(19,6,1)+VRR(19,6,0)
      HRR(44,6,1)=HRR(44,6,1)+FnSpB*VRR(19,6,0)
      HRR(19,7,1)=HRR(19,7,1)+VRR(19,7,0)
      HRR(44,7,1)=HRR(44,7,1)+FnSpB*VRR(19,7,0)
      HRR(19,8,1)=HRR(19,8,1)+VRR(19,8,0)
      HRR(44,8,1)=HRR(44,8,1)+FnSpB*VRR(19,8,0)
      HRR(19,9,1)=HRR(19,9,1)+VRR(19,9,0)
      HRR(44,9,1)=HRR(44,9,1)+FnSpB*VRR(19,9,0)
      HRR(19,10,1)=HRR(19,10,1)+VRR(19,10,0)
      HRR(44,10,1)=HRR(44,10,1)+FnSpB*VRR(19,10,0)
      HRR(20,1,1)=HRR(20,1,1)+VRR(20,1,0)
      HRR(45,1,1)=HRR(45,1,1)+FnSpB*VRR(20,1,0)
      HRR(20,2,1)=HRR(20,2,1)+VRR(20,2,0)
      HRR(45,11,1)=HRR(45,11,1)+FnSpB*FnSpK*VRR(20,2,0)
      HRR(45,2,1)=HRR(45,2,1)+FnSpB*VRR(20,2,0)
      HRR(20,11,1)=HRR(20,11,1)+FnSpK*VRR(20,2,0)
      HRR(20,3,1)=HRR(20,3,1)+VRR(20,3,0)
      HRR(45,12,1)=HRR(45,12,1)+FnSpB*FnSpK*VRR(20,3,0)
      HRR(45,3,1)=HRR(45,3,1)+FnSpB*VRR(20,3,0)
      HRR(20,12,1)=HRR(20,12,1)+FnSpK*VRR(20,3,0)
      HRR(20,4,1)=HRR(20,4,1)+VRR(20,4,0)
      HRR(45,13,1)=HRR(45,13,1)+FnSpB*FnSpK*VRR(20,4,0)
      HRR(45,4,1)=HRR(45,4,1)+FnSpB*VRR(20,4,0)
      HRR(20,13,1)=HRR(20,13,1)+FnSpK*VRR(20,4,0)
      HRR(20,5,1)=HRR(20,5,1)+VRR(20,5,0)
      HRR(45,5,1)=HRR(45,5,1)+FnSpB*VRR(20,5,0)
      HRR(20,6,1)=HRR(20,6,1)+VRR(20,6,0)
      HRR(45,6,1)=HRR(45,6,1)+FnSpB*VRR(20,6,0)
      HRR(20,7,1)=HRR(20,7,1)+VRR(20,7,0)
      HRR(45,7,1)=HRR(45,7,1)+FnSpB*VRR(20,7,0)
      HRR(20,8,1)=HRR(20,8,1)+VRR(20,8,0)
      HRR(45,8,1)=HRR(45,8,1)+FnSpB*VRR(20,8,0)
      HRR(20,9,1)=HRR(20,9,1)+VRR(20,9,0)
      HRR(45,9,1)=HRR(45,9,1)+FnSpB*VRR(20,9,0)
      HRR(20,10,1)=HRR(20,10,1)+VRR(20,10,0)
      HRR(45,10,1)=HRR(45,10,1)+FnSpB*VRR(20,10,0)
      HRR(21,1,1)=HRR(21,1,1)+VRR(21,1,0)
      HRR(21,2,1)=HRR(21,2,1)+VRR(21,2,0)
      HRR(21,11,1)=HRR(21,11,1)+FnSpK*VRR(21,2,0)
      HRR(21,3,1)=HRR(21,3,1)+VRR(21,3,0)
      HRR(21,12,1)=HRR(21,12,1)+FnSpK*VRR(21,3,0)
      HRR(21,4,1)=HRR(21,4,1)+VRR(21,4,0)
      HRR(21,13,1)=HRR(21,13,1)+FnSpK*VRR(21,4,0)
      HRR(21,5,1)=HRR(21,5,1)+VRR(21,5,0)
      HRR(21,6,1)=HRR(21,6,1)+VRR(21,6,0)
      HRR(21,7,1)=HRR(21,7,1)+VRR(21,7,0)
      HRR(21,8,1)=HRR(21,8,1)+VRR(21,8,0)
      HRR(21,9,1)=HRR(21,9,1)+VRR(21,9,0)
      HRR(21,10,1)=HRR(21,10,1)+VRR(21,10,0)
      HRR(22,1,1)=HRR(22,1,1)+VRR(22,1,0)
      HRR(22,2,1)=HRR(22,2,1)+VRR(22,2,0)
      HRR(22,11,1)=HRR(22,11,1)+FnSpK*VRR(22,2,0)
      HRR(22,3,1)=HRR(22,3,1)+VRR(22,3,0)
      HRR(22,12,1)=HRR(22,12,1)+FnSpK*VRR(22,3,0)
      HRR(22,4,1)=HRR(22,4,1)+VRR(22,4,0)
      HRR(22,13,1)=HRR(22,13,1)+FnSpK*VRR(22,4,0)
      HRR(22,5,1)=HRR(22,5,1)+VRR(22,5,0)
      HRR(22,6,1)=HRR(22,6,1)+VRR(22,6,0)
      HRR(22,7,1)=HRR(22,7,1)+VRR(22,7,0)
      HRR(22,8,1)=HRR(22,8,1)+VRR(22,8,0)
      HRR(22,9,1)=HRR(22,9,1)+VRR(22,9,0)
      HRR(22,10,1)=HRR(22,10,1)+VRR(22,10,0)
      HRR(23,1,1)=HRR(23,1,1)+VRR(23,1,0)
      HRR(23,2,1)=HRR(23,2,1)+VRR(23,2,0)
      HRR(23,11,1)=HRR(23,11,1)+FnSpK*VRR(23,2,0)
      HRR(23,3,1)=HRR(23,3,1)+VRR(23,3,0)
      HRR(23,12,1)=HRR(23,12,1)+FnSpK*VRR(23,3,0)
      HRR(23,4,1)=HRR(23,4,1)+VRR(23,4,0)
      HRR(23,13,1)=HRR(23,13,1)+FnSpK*VRR(23,4,0)
      HRR(23,5,1)=HRR(23,5,1)+VRR(23,5,0)
      HRR(23,6,1)=HRR(23,6,1)+VRR(23,6,0)
      HRR(23,7,1)=HRR(23,7,1)+VRR(23,7,0)
      HRR(23,8,1)=HRR(23,8,1)+VRR(23,8,0)
      HRR(23,9,1)=HRR(23,9,1)+VRR(23,9,0)
      HRR(23,10,1)=HRR(23,10,1)+VRR(23,10,0)
      HRR(24,1,1)=HRR(24,1,1)+VRR(24,1,0)
      HRR(24,2,1)=HRR(24,2,1)+VRR(24,2,0)
      HRR(24,11,1)=HRR(24,11,1)+FnSpK*VRR(24,2,0)
      HRR(24,3,1)=HRR(24,3,1)+VRR(24,3,0)
      HRR(24,12,1)=HRR(24,12,1)+FnSpK*VRR(24,3,0)
      HRR(24,4,1)=HRR(24,4,1)+VRR(24,4,0)
      HRR(24,13,1)=HRR(24,13,1)+FnSpK*VRR(24,4,0)
      HRR(24,5,1)=HRR(24,5,1)+VRR(24,5,0)
      HRR(24,6,1)=HRR(24,6,1)+VRR(24,6,0)
      HRR(24,7,1)=HRR(24,7,1)+VRR(24,7,0)
      HRR(24,8,1)=HRR(24,8,1)+VRR(24,8,0)
      HRR(24,9,1)=HRR(24,9,1)+VRR(24,9,0)
      HRR(24,10,1)=HRR(24,10,1)+VRR(24,10,0)
      HRR(25,1,1)=HRR(25,1,1)+VRR(25,1,0)
      HRR(25,2,1)=HRR(25,2,1)+VRR(25,2,0)
      HRR(25,11,1)=HRR(25,11,1)+FnSpK*VRR(25,2,0)
      HRR(25,3,1)=HRR(25,3,1)+VRR(25,3,0)
      HRR(25,12,1)=HRR(25,12,1)+FnSpK*VRR(25,3,0)
      HRR(25,4,1)=HRR(25,4,1)+VRR(25,4,0)
      HRR(25,13,1)=HRR(25,13,1)+FnSpK*VRR(25,4,0)
      HRR(25,5,1)=HRR(25,5,1)+VRR(25,5,0)
      HRR(25,6,1)=HRR(25,6,1)+VRR(25,6,0)
      HRR(25,7,1)=HRR(25,7,1)+VRR(25,7,0)
      HRR(25,8,1)=HRR(25,8,1)+VRR(25,8,0)
      HRR(25,9,1)=HRR(25,9,1)+VRR(25,9,0)
      HRR(25,10,1)=HRR(25,10,1)+VRR(25,10,0)
      HRR(26,1,1)=HRR(26,1,1)+VRR(26,1,0)
      HRR(26,2,1)=HRR(26,2,1)+VRR(26,2,0)
      HRR(26,11,1)=HRR(26,11,1)+FnSpK*VRR(26,2,0)
      HRR(26,3,1)=HRR(26,3,1)+VRR(26,3,0)
      HRR(26,12,1)=HRR(26,12,1)+FnSpK*VRR(26,3,0)
      HRR(26,4,1)=HRR(26,4,1)+VRR(26,4,0)
      HRR(26,13,1)=HRR(26,13,1)+FnSpK*VRR(26,4,0)
      HRR(26,5,1)=HRR(26,5,1)+VRR(26,5,0)
      HRR(26,6,1)=HRR(26,6,1)+VRR(26,6,0)
      HRR(26,7,1)=HRR(26,7,1)+VRR(26,7,0)
      HRR(26,8,1)=HRR(26,8,1)+VRR(26,8,0)
      HRR(26,9,1)=HRR(26,9,1)+VRR(26,9,0)
      HRR(26,10,1)=HRR(26,10,1)+VRR(26,10,0)
      HRR(27,1,1)=HRR(27,1,1)+VRR(27,1,0)
      HRR(27,2,1)=HRR(27,2,1)+VRR(27,2,0)
      HRR(27,11,1)=HRR(27,11,1)+FnSpK*VRR(27,2,0)
      HRR(27,3,1)=HRR(27,3,1)+VRR(27,3,0)
      HRR(27,12,1)=HRR(27,12,1)+FnSpK*VRR(27,3,0)
      HRR(27,4,1)=HRR(27,4,1)+VRR(27,4,0)
      HRR(27,13,1)=HRR(27,13,1)+FnSpK*VRR(27,4,0)
      HRR(27,5,1)=HRR(27,5,1)+VRR(27,5,0)
      HRR(27,6,1)=HRR(27,6,1)+VRR(27,6,0)
      HRR(27,7,1)=HRR(27,7,1)+VRR(27,7,0)
      HRR(27,8,1)=HRR(27,8,1)+VRR(27,8,0)
      HRR(27,9,1)=HRR(27,9,1)+VRR(27,9,0)
      HRR(27,10,1)=HRR(27,10,1)+VRR(27,10,0)
      HRR(28,1,1)=HRR(28,1,1)+VRR(28,1,0)
      HRR(28,2,1)=HRR(28,2,1)+VRR(28,2,0)
      HRR(28,11,1)=HRR(28,11,1)+FnSpK*VRR(28,2,0)
      HRR(28,3,1)=HRR(28,3,1)+VRR(28,3,0)
      HRR(28,12,1)=HRR(28,12,1)+FnSpK*VRR(28,3,0)
      HRR(28,4,1)=HRR(28,4,1)+VRR(28,4,0)
      HRR(28,13,1)=HRR(28,13,1)+FnSpK*VRR(28,4,0)
      HRR(28,5,1)=HRR(28,5,1)+VRR(28,5,0)
      HRR(28,6,1)=HRR(28,6,1)+VRR(28,6,0)
      HRR(28,7,1)=HRR(28,7,1)+VRR(28,7,0)
      HRR(28,8,1)=HRR(28,8,1)+VRR(28,8,0)
      HRR(28,9,1)=HRR(28,9,1)+VRR(28,9,0)
      HRR(28,10,1)=HRR(28,10,1)+VRR(28,10,0)
      HRR(29,1,1)=HRR(29,1,1)+VRR(29,1,0)
      HRR(29,2,1)=HRR(29,2,1)+VRR(29,2,0)
      HRR(29,11,1)=HRR(29,11,1)+FnSpK*VRR(29,2,0)
      HRR(29,3,1)=HRR(29,3,1)+VRR(29,3,0)
      HRR(29,12,1)=HRR(29,12,1)+FnSpK*VRR(29,3,0)
      HRR(29,4,1)=HRR(29,4,1)+VRR(29,4,0)
      HRR(29,13,1)=HRR(29,13,1)+FnSpK*VRR(29,4,0)
      HRR(29,5,1)=HRR(29,5,1)+VRR(29,5,0)
      HRR(29,6,1)=HRR(29,6,1)+VRR(29,6,0)
      HRR(29,7,1)=HRR(29,7,1)+VRR(29,7,0)
      HRR(29,8,1)=HRR(29,8,1)+VRR(29,8,0)
      HRR(29,9,1)=HRR(29,9,1)+VRR(29,9,0)
      HRR(29,10,1)=HRR(29,10,1)+VRR(29,10,0)
      HRR(30,1,1)=HRR(30,1,1)+VRR(30,1,0)
      HRR(30,2,1)=HRR(30,2,1)+VRR(30,2,0)
      HRR(30,11,1)=HRR(30,11,1)+FnSpK*VRR(30,2,0)
      HRR(30,3,1)=HRR(30,3,1)+VRR(30,3,0)
      HRR(30,12,1)=HRR(30,12,1)+FnSpK*VRR(30,3,0)
      HRR(30,4,1)=HRR(30,4,1)+VRR(30,4,0)
      HRR(30,13,1)=HRR(30,13,1)+FnSpK*VRR(30,4,0)
      HRR(30,5,1)=HRR(30,5,1)+VRR(30,5,0)
      HRR(30,6,1)=HRR(30,6,1)+VRR(30,6,0)
      HRR(30,7,1)=HRR(30,7,1)+VRR(30,7,0)
      HRR(30,8,1)=HRR(30,8,1)+VRR(30,8,0)
      HRR(30,9,1)=HRR(30,9,1)+VRR(30,9,0)
      HRR(30,10,1)=HRR(30,10,1)+VRR(30,10,0)
      HRR(31,1,1)=HRR(31,1,1)+VRR(31,1,0)
      HRR(31,2,1)=HRR(31,2,1)+VRR(31,2,0)
      HRR(31,11,1)=HRR(31,11,1)+FnSpK*VRR(31,2,0)
      HRR(31,3,1)=HRR(31,3,1)+VRR(31,3,0)
      HRR(31,12,1)=HRR(31,12,1)+FnSpK*VRR(31,3,0)
      HRR(31,4,1)=HRR(31,4,1)+VRR(31,4,0)
      HRR(31,13,1)=HRR(31,13,1)+FnSpK*VRR(31,4,0)
      HRR(31,5,1)=HRR(31,5,1)+VRR(31,5,0)
      HRR(31,6,1)=HRR(31,6,1)+VRR(31,6,0)
      HRR(31,7,1)=HRR(31,7,1)+VRR(31,7,0)
      HRR(31,8,1)=HRR(31,8,1)+VRR(31,8,0)
      HRR(31,9,1)=HRR(31,9,1)+VRR(31,9,0)
      HRR(31,10,1)=HRR(31,10,1)+VRR(31,10,0)
      HRR(32,1,1)=HRR(32,1,1)+VRR(32,1,0)
      HRR(32,2,1)=HRR(32,2,1)+VRR(32,2,0)
      HRR(32,11,1)=HRR(32,11,1)+FnSpK*VRR(32,2,0)
      HRR(32,3,1)=HRR(32,3,1)+VRR(32,3,0)
      HRR(32,12,1)=HRR(32,12,1)+FnSpK*VRR(32,3,0)
      HRR(32,4,1)=HRR(32,4,1)+VRR(32,4,0)
      HRR(32,13,1)=HRR(32,13,1)+FnSpK*VRR(32,4,0)
      HRR(32,5,1)=HRR(32,5,1)+VRR(32,5,0)
      HRR(32,6,1)=HRR(32,6,1)+VRR(32,6,0)
      HRR(32,7,1)=HRR(32,7,1)+VRR(32,7,0)
      HRR(32,8,1)=HRR(32,8,1)+VRR(32,8,0)
      HRR(32,9,1)=HRR(32,9,1)+VRR(32,9,0)
      HRR(32,10,1)=HRR(32,10,1)+VRR(32,10,0)
      HRR(33,1,1)=HRR(33,1,1)+VRR(33,1,0)
      HRR(33,2,1)=HRR(33,2,1)+VRR(33,2,0)
      HRR(33,11,1)=HRR(33,11,1)+FnSpK*VRR(33,2,0)
      HRR(33,3,1)=HRR(33,3,1)+VRR(33,3,0)
      HRR(33,12,1)=HRR(33,12,1)+FnSpK*VRR(33,3,0)
      HRR(33,4,1)=HRR(33,4,1)+VRR(33,4,0)
      HRR(33,13,1)=HRR(33,13,1)+FnSpK*VRR(33,4,0)
      HRR(33,5,1)=HRR(33,5,1)+VRR(33,5,0)
      HRR(33,6,1)=HRR(33,6,1)+VRR(33,6,0)
      HRR(33,7,1)=HRR(33,7,1)+VRR(33,7,0)
      HRR(33,8,1)=HRR(33,8,1)+VRR(33,8,0)
      HRR(33,9,1)=HRR(33,9,1)+VRR(33,9,0)
      HRR(33,10,1)=HRR(33,10,1)+VRR(33,10,0)
      HRR(34,1,1)=HRR(34,1,1)+VRR(34,1,0)
      HRR(34,2,1)=HRR(34,2,1)+VRR(34,2,0)
      HRR(34,11,1)=HRR(34,11,1)+FnSpK*VRR(34,2,0)
      HRR(34,3,1)=HRR(34,3,1)+VRR(34,3,0)
      HRR(34,12,1)=HRR(34,12,1)+FnSpK*VRR(34,3,0)
      HRR(34,4,1)=HRR(34,4,1)+VRR(34,4,0)
      HRR(34,13,1)=HRR(34,13,1)+FnSpK*VRR(34,4,0)
      HRR(34,5,1)=HRR(34,5,1)+VRR(34,5,0)
      HRR(34,6,1)=HRR(34,6,1)+VRR(34,6,0)
      HRR(34,7,1)=HRR(34,7,1)+VRR(34,7,0)
      HRR(34,8,1)=HRR(34,8,1)+VRR(34,8,0)
      HRR(34,9,1)=HRR(34,9,1)+VRR(34,9,0)
      HRR(34,10,1)=HRR(34,10,1)+VRR(34,10,0)
      HRR(35,1,1)=HRR(35,1,1)+VRR(35,1,0)
      HRR(35,2,1)=HRR(35,2,1)+VRR(35,2,0)
      HRR(35,11,1)=HRR(35,11,1)+FnSpK*VRR(35,2,0)
      HRR(35,3,1)=HRR(35,3,1)+VRR(35,3,0)
      HRR(35,12,1)=HRR(35,12,1)+FnSpK*VRR(35,3,0)
      HRR(35,4,1)=HRR(35,4,1)+VRR(35,4,0)
      HRR(35,13,1)=HRR(35,13,1)+FnSpK*VRR(35,4,0)
      HRR(35,5,1)=HRR(35,5,1)+VRR(35,5,0)
      HRR(35,6,1)=HRR(35,6,1)+VRR(35,6,0)
      HRR(35,7,1)=HRR(35,7,1)+VRR(35,7,0)
      HRR(35,8,1)=HRR(35,8,1)+VRR(35,8,0)
      HRR(35,9,1)=HRR(35,9,1)+VRR(35,9,0)
      HRR(35,10,1)=HRR(35,10,1)+VRR(35,10,0)
    END SUBROUTINE CNTRCT10232
