!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
    SUBROUTINE BraHRR310ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR,HRRA,HRRB,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*),HRRA(*),HRRB(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(2_x,11|
      DUM=-HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(-3.D0*HRR(2)+&
                         ABx*(-HRR(1)+&
                         HRRA(5))+&
                         3.D0*HRRA(11))+&
                         3.D0*HRRA(21))+&
                         HRRA(36)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,11_x|
      DUM=-3.D0*HRR(11)+&
                         ABx*(-6.D0*HRR(5)+&
                         ABx*(-3.D0*HRR(2)+&
                         ABx*(ABx*HRRB(2)+&
                         4.D0*HRRB(5))+&
                         6.D0*HRRB(11))+&
                         4.D0*HRRB(21))+&
                         HRRB(36)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(6)+&
                         3.D0*HRRA(12))+&
                         3.D0*HRRA(22))+&
                         HRRA(37)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,11_y|
      DUM=ABy*HRRB(21)+&
                         ABx*(3.D0*ABy*HRRB(11)+&
                         ABx*(3.D0*ABy*HRRB(5)+&
                         ABx*(ABy*HRRB(2)+&
                         HRRB(6))+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(22))+&
                         HRRB(37)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(8)+&
                         3.D0*HRRA(15))+&
                         3.D0*HRRA(26))+&
                         HRRA(42)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,11_z|
      DUM=ABz*HRRB(21)+&
                         ABx*(3.D0*ABz*HRRB(11)+&
                         ABx*(3.D0*ABz*HRRB(5)+&
                         ABx*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(26))+&
                         HRRB(42)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(3_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(6)+&
                         3.D0*HRRA(12))+&
                         3.D0*HRRA(22))+&
                         HRRA(37)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,11_x|
      DUM=-3.D0*HRR(12)+&
                         ABx*(-6.D0*HRR(6)+&
                         ABx*(-3.D0*HRR(3)+&
                         ABx*(ABx*HRRB(3)+&
                         4.D0*HRRB(6))+&
                         6.D0*HRRB(12))+&
                         4.D0*HRRB(22))+&
                         HRRB(37)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,11|
      DUM=-HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(-3.D0*HRR(2)+&
                         ABx*(-HRR(1)+&
                         HRRA(7))+&
                         3.D0*HRRA(13))+&
                         3.D0*HRRA(23))+&
                         HRRA(38)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,11_y|
      DUM=ABy*HRRB(22)+&
                         ABx*(3.D0*ABy*HRRB(12)+&
                         ABx*(3.D0*ABy*HRRB(6)+&
                         ABx*(ABy*HRRB(3)+&
                         HRRB(7))+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(23))+&
                         HRRB(38)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(9)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,11_z|
      DUM=ABz*HRRB(22)+&
                         ABx*(3.D0*ABz*HRRB(12)+&
                         ABx*(3.D0*ABz*HRRB(6)+&
                         ABx*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(4_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(8)+&
                         3.D0*HRRA(15))+&
                         3.D0*HRRA(26))+&
                         HRRA(42)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,11_x|
      DUM=-3.D0*HRR(15)+&
                         ABx*(-6.D0*HRR(8)+&
                         ABx*(-3.D0*HRR(4)+&
                         ABx*(ABx*HRRB(4)+&
                         4.D0*HRRB(8))+&
                         6.D0*HRRB(15))+&
                         4.D0*HRRB(26))+&
                         HRRB(42)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(9)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,11_y|
      DUM=ABy*HRRB(26)+&
                         ABx*(3.D0*ABy*HRRB(15)+&
                         ABx*(3.D0*ABy*HRRB(8)+&
                         ABx*(ABy*HRRB(4)+&
                         HRRB(9))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,11|
      DUM=-HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(-3.D0*HRR(2)+&
                         ABx*(-HRR(1)+&
                         HRRA(10))+&
                         3.D0*HRRA(18))+&
                         3.D0*HRRA(30))+&
                         HRRA(47)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,11_z|
      DUM=ABz*HRRB(26)+&
                         ABx*(3.D0*ABz*HRRB(15)+&
                         ABx*(3.D0*ABz*HRRB(8)+&
                         ABx*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(30))+&
                         HRRB(47)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(2_x,12|
      DUM=-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(21))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         2.D0*HRRA(11))+&
                         ABx*(-HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(5))+&
                         HRRA(12))+&
                         2.D0*HRRA(22))+&
                         HRRA(37)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,12_x|
      DUM=-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         HRRB(21))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         3.D0*HRRB(11))+&
                         ABx*(3.D0*ABy*HRRB(5)+&
                         ABx*(ABy*HRRB(2)+&
                         HRRB(6))+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(22))+&
                         HRRB(37)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,12|
      DUM=ABy*HRRA(22)+&
                         ABx*(2.D0*ABy*HRRA(12)+&
                         ABx*(ABy*HRRA(6)+&
                         HRRA(13))+&
                         2.D0*HRRA(23))+&
                         HRRA(38)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,12_y|
      DUM=-HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         2.D0*HRRB(22))+&
                         ABx*(-2.D0*HRR(5)+&
                         ABy*(2.D0*ABy*HRRB(5)+&
                         4.D0*HRRB(12))+&
                         ABx*(-HRR(2)+&
                         ABy*(ABy*HRRB(2)+&
                         2.D0*HRRB(6))+&
                         HRRB(13))+&
                         2.D0*HRRB(23))+&
                         HRRB(38)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,12|
      DUM=ABy*HRRA(26)+&
                         ABx*(2.D0*ABy*HRRA(15)+&
                         ABx*(ABy*HRRA(8)+&
                         HRRA(16))+&
                         2.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,12_z|
      DUM=ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         ABx*(2.D0*ABz*HRRB(12)+&
                         ABy*(2.D0*ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         ABx*(ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         HRRB(16))+&
                         2.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(3_x,12|
      DUM=ABy*HRRA(22)+&
                         ABx*(2.D0*ABy*HRRA(12)+&
                         ABx*(ABy*HRRA(6)+&
                         HRRA(13))+&
                         2.D0*HRRA(23))+&
                         HRRA(38)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,12_x|
      DUM=-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRB(22))+&
                         ABx*(-2.D0*HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         3.D0*HRRB(12))+&
                         ABx*(3.D0*ABy*HRRB(6)+&
                         ABx*(ABy*HRRB(3)+&
                         HRRB(7))+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(23))+&
                         HRRB(38)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,12|
      DUM=-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         2.D0*HRRA(13))+&
                         ABx*(-HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(7))+&
                         HRRA(14))+&
                         2.D0*HRRA(24))+&
                         HRRA(39)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,12_y|
      DUM=-HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         2.D0*HRRB(23))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(2.D0*ABy*HRRB(6)+&
                         4.D0*HRRB(13))+&
                         ABx*(-HRR(3)+&
                         ABy*(ABy*HRRB(3)+&
                         2.D0*HRRB(7))+&
                         HRRB(14))+&
                         2.D0*HRRB(24))+&
                         HRRB(39)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,12|
      DUM=ABy*HRRA(27)+&
                         ABx*(2.D0*ABy*HRRA(16)+&
                         ABx*(ABy*HRRA(9)+&
                         HRRA(17))+&
                         2.D0*HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,12_z|
      DUM=ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         ABx*(2.D0*ABz*HRRB(13)+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABx*(ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         HRRB(17))+&
                         2.D0*HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(4_x,12|
      DUM=ABy*HRRA(26)+&
                         ABx*(2.D0*ABy*HRRA(15)+&
                         ABx*(ABy*HRRA(8)+&
                         HRRA(16))+&
                         2.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,12_x|
      DUM=-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRB(26))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABy*(-2.D0*HRR(4)+&
                         3.D0*HRRB(15))+&
                         ABx*(3.D0*ABy*HRRB(8)+&
                         ABx*(ABy*HRRB(4)+&
                         HRRB(9))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,12|
      DUM=ABy*HRRA(27)+&
                         ABx*(2.D0*ABy*HRRA(16)+&
                         ABx*(ABy*HRRA(9)+&
                         HRRA(17))+&
                         2.D0*HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,12_y|
      DUM=-HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         2.D0*HRRB(27))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABy*(2.D0*ABy*HRRB(8)+&
                         4.D0*HRRB(16))+&
                         ABx*(-HRR(4)+&
                         ABy*(ABy*HRRB(4)+&
                         2.D0*HRRB(9))+&
                         HRRB(17))+&
                         2.D0*HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,12|
      DUM=-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         2.D0*HRRA(18))+&
                         ABx*(-HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(10))+&
                         HRRA(19))+&
                         2.D0*HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,12_z|
      DUM=ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         ABx*(2.D0*ABz*HRRB(16)+&
                         ABy*(2.D0*ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         ABx*(ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         HRRB(19))+&
                         2.D0*HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(2_x,13|
      DUM=-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(11))+&
                         2.D0*HRRA(22))+&
                         ABx*(-HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(5))+&
                         2.D0*HRRA(12))+&
                         HRRA(23))+&
                         HRRA(38)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,13_x|
      DUM=-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRB(11))+&
                         2.D0*HRRB(22))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(5)+&
                         4.D0*HRRB(12))+&
                         ABx*(ABy*(ABy*HRRB(2)+&
                         2.D0*HRRB(6))+&
                         HRRB(13))+&
                         2.D0*HRRB(23))+&
                         HRRB(38)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,13|
      DUM=ABy*(ABy*HRRA(12)+&
                         2.D0*HRRA(23))+&
                         ABx*(ABy*(ABy*HRRA(6)+&
                         2.D0*HRRA(13))+&
                         HRRA(24))+&
                         HRRA(39)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,13_y|
      DUM=-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         ABy*(ABy*HRRB(5)+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(23))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         ABy*(ABy*HRRB(2)+&
                         3.D0*HRRB(6))+&
                         3.D0*HRRB(13))+&
                         HRRB(24))+&
                         HRRB(39)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,13|
      DUM=ABy*(ABy*HRRA(15)+&
                         2.D0*HRRA(27))+&
                         ABx*(ABy*(ABy*HRRA(8)+&
                         2.D0*HRRA(16))+&
                         HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,13_z|
      DUM=ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*HRRB(13)+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         2.D0*HRRB(16))+&
                         HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(3_x,13|
      DUM=ABy*(ABy*HRRA(12)+&
                         2.D0*HRRA(23))+&
                         ABx*(ABy*(ABy*HRRA(6)+&
                         2.D0*HRRA(13))+&
                         HRRA(24))+&
                         HRRA(39)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,13_x|
      DUM=-HRR(14)+&
                         ABy*(-2.D0*HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRB(12))+&
                         2.D0*HRRB(23))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(6)+&
                         4.D0*HRRB(13))+&
                         ABx*(ABy*(ABy*HRRB(3)+&
                         2.D0*HRRB(7))+&
                         HRRB(14))+&
                         2.D0*HRRB(24))+&
                         HRRB(39)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,13|
      DUM=-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(13))+&
                         2.D0*HRRA(24))+&
                         ABx*(-HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(7))+&
                         2.D0*HRRA(14))+&
                         HRRA(25))+&
                         HRRA(40)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,13_y|
      DUM=-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(ABy*HRRB(6)+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(24))+&
                         ABx*(-2.D0*HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         ABy*(ABy*HRRB(3)+&
                         3.D0*HRRB(7))+&
                         3.D0*HRRB(14))+&
                         HRRB(25))+&
                         HRRB(40)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,13|
      DUM=ABy*(ABy*HRRA(16)+&
                         2.D0*HRRA(28))+&
                         ABx*(ABy*(ABy*HRRA(9)+&
                         2.D0*HRRA(17))+&
                         HRRA(29))+&
                         HRRA(45)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,13_z|
      DUM=ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         ABx*(ABz*HRRB(14)+&
                         ABy*(2.D0*ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         2.D0*HRRB(17))+&
                         HRRB(29))+&
                         HRRB(45)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(4_x,13|
      DUM=ABy*(ABy*HRRA(15)+&
                         2.D0*HRRA(27))+&
                         ABx*(ABy*(ABy*HRRA(8)+&
                         2.D0*HRRA(16))+&
                         HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,13_x|
      DUM=-HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(8)+&
                         4.D0*HRRB(16))+&
                         ABx*(ABy*(ABy*HRRB(4)+&
                         2.D0*HRRB(9))+&
                         HRRB(17))+&
                         2.D0*HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,13|
      DUM=ABy*(ABy*HRRA(16)+&
                         2.D0*HRRA(28))+&
                         ABx*(ABy*(ABy*HRRA(9)+&
                         2.D0*HRRA(17))+&
                         HRRA(29))+&
                         HRRA(45)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,13_y|
      DUM=-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         ABy*(ABy*HRRB(8)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABy*(-2.D0*HRR(4)+&
                         ABy*(ABy*HRRB(4)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(17))+&
                         HRRB(29))+&
                         HRRB(45)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,13|
      DUM=-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(18))+&
                         2.D0*HRRA(31))+&
                         ABx*(-HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(10))+&
                         2.D0*HRRA(19))+&
                         HRRA(32))+&
                         HRRA(49)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,13_z|
      DUM=ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         ABx*(ABz*HRRB(17)+&
                         ABy*(2.D0*ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         2.D0*HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(2_x,14|
      DUM=-HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(-3.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(5))+&
                         3.D0*HRRA(12))+&
                         3.D0*HRRA(23))+&
                         HRRA(39)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(5)+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(23))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(2)+&
                         3.D0*HRRB(6))+&
                         3.D0*HRRB(13))+&
                         HRRB(24))+&
                         HRRB(39)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(6)+&
                         3.D0*HRRA(13))+&
                         3.D0*HRRA(24))+&
                         HRRA(40)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,14_y|
      DUM=-3.D0*HRR(13)+&
                         ABy*(-6.D0*HRR(6)+&
                         ABy*(-3.D0*HRR(2)+&
                         ABy*(ABy*HRRB(2)+&
                         4.D0*HRRB(6))+&
                         6.D0*HRRB(13))+&
                         4.D0*HRRB(24))+&
                         HRRB(40)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(8)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(28))+&
                         HRRA(45)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,14_z|
      DUM=ABz*HRRB(24)+&
                         ABy*(3.D0*ABz*HRRB(13)+&
                         ABy*(3.D0*ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         HRRB(45)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(3_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(6)+&
                         3.D0*HRRA(13))+&
                         3.D0*HRRA(24))+&
                         HRRA(40)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(6)+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(24))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(3)+&
                         3.D0*HRRB(7))+&
                         3.D0*HRRB(14))+&
                         HRRB(25))+&
                         HRRB(40)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,14|
      DUM=-HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(-3.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(7))+&
                         3.D0*HRRA(14))+&
                         3.D0*HRRA(25))+&
                         HRRA(41)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,14_y|
      DUM=-3.D0*HRR(14)+&
                         ABy*(-6.D0*HRR(7)+&
                         ABy*(-3.D0*HRR(3)+&
                         ABy*(ABy*HRRB(3)+&
                         4.D0*HRRB(7))+&
                         6.D0*HRRB(14))+&
                         4.D0*HRRB(25))+&
                         HRRB(41)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(9)+&
                         3.D0*HRRA(17))+&
                         3.D0*HRRA(29))+&
                         HRRA(46)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,14_z|
      DUM=ABz*HRRB(25)+&
                         ABy*(3.D0*ABz*HRRB(14)+&
                         ABy*(3.D0*ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(29))+&
                         HRRB(46)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(4_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(8)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(28))+&
                         HRRA(45)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(8)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(4)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(17))+&
                         HRRB(29))+&
                         HRRB(45)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(9)+&
                         3.D0*HRRA(17))+&
                         3.D0*HRRA(29))+&
                         HRRA(46)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,14_y|
      DUM=-3.D0*HRR(17)+&
                         ABy*(-6.D0*HRR(9)+&
                         ABy*(-3.D0*HRR(4)+&
                         ABy*(ABy*HRRB(4)+&
                         4.D0*HRRB(9))+&
                         6.D0*HRRB(17))+&
                         4.D0*HRRB(29))+&
                         HRRB(46)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,14|
      DUM=-HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(-3.D0*HRR(3)+&
                         ABy*(-HRR(1)+&
                         HRRA(10))+&
                         3.D0*HRRA(19))+&
                         3.D0*HRRA(32))+&
                         HRRA(50)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,14_z|
      DUM=ABz*HRRB(29)+&
                         ABy*(3.D0*ABz*HRRB(17)+&
                         ABy*(3.D0*ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(32))+&
                         HRRB(50)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(2_x,15|
      DUM=-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(21))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         2.D0*HRRA(11))+&
                         ABx*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         HRRA(15))+&
                         2.D0*HRRA(26))+&
                         HRRA(42)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,15_x|
      DUM=-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         HRRB(21))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         3.D0*HRRB(11))+&
                         ABx*(3.D0*ABz*HRRB(5)+&
                         ABx*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(26))+&
                         HRRB(42)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,15|
      DUM=ABz*HRRA(22)+&
                         ABx*(2.D0*ABz*HRRA(12)+&
                         ABx*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         2.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,15_y|
      DUM=ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         ABx*(2.D0*ABz*HRRB(12)+&
                         ABy*(2.D0*ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         ABx*(ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         HRRB(16))+&
                         2.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,15|
      DUM=ABz*HRRA(26)+&
                         ABx*(2.D0*ABz*HRRA(15)+&
                         ABx*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         2.D0*HRRA(30))+&
                         HRRA(47)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,15_z|
      DUM=-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         ABx*(-2.D0*HRR(5)+&
                         ABz*(2.D0*ABz*HRRB(5)+&
                         4.D0*HRRB(15))+&
                         ABx*(-HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         2.D0*HRRB(30))+&
                         HRRB(47)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(3_x,15|
      DUM=ABz*HRRA(22)+&
                         ABx*(2.D0*ABz*HRRA(12)+&
                         ABx*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         2.D0*HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,15_x|
      DUM=-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRB(22))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         3.D0*HRRB(12))+&
                         ABx*(3.D0*ABz*HRRB(6)+&
                         ABx*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,15|
      DUM=-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         2.D0*HRRA(13))+&
                         ABx*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         HRRA(17))+&
                         2.D0*HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,15_y|
      DUM=ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         ABx*(2.D0*ABz*HRRB(13)+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABx*(ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         HRRB(17))+&
                         2.D0*HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,15|
      DUM=ABz*HRRA(27)+&
                         ABx*(2.D0*ABz*HRRA(16)+&
                         ABx*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         2.D0*HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,15_z|
      DUM=-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABz*(2.D0*ABz*HRRB(6)+&
                         4.D0*HRRB(16))+&
                         ABx*(-HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         2.D0*HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(4_x,15|
      DUM=ABz*HRRA(26)+&
                         ABx*(2.D0*ABz*HRRA(15)+&
                         ABx*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         2.D0*HRRA(30))+&
                         HRRA(47)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,15_x|
      DUM=-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRB(26))+&
                         ABx*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         3.D0*HRRB(15))+&
                         ABx*(3.D0*ABz*HRRB(8)+&
                         ABx*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(30))+&
                         HRRB(47)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,15|
      DUM=ABz*HRRA(27)+&
                         ABx*(2.D0*ABz*HRRA(16)+&
                         ABx*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         2.D0*HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,15_y|
      DUM=ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         ABx*(2.D0*ABz*HRRB(16)+&
                         ABy*(2.D0*ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         ABx*(ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         HRRB(19))+&
                         2.D0*HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,15|
      DUM=-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         2.D0*HRRA(18))+&
                         ABx*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         HRRA(20))+&
                         2.D0*HRRA(33))+&
                         HRRA(51)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,15_z|
      DUM=-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(2.D0*ABz*HRRB(8)+&
                         4.D0*HRRB(18))+&
                         ABx*(-HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         2.D0*HRRB(33))+&
                         HRRB(51)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(2_x,16|
      DUM=-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(22))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(11))+&
                         HRRA(26))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         HRRA(15))+&
                         HRRA(27))+&
                         HRRA(43)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,16_x|
      DUM=-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(22))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRB(11))+&
                         HRRB(26))+&
                         ABx*(2.D0*ABz*HRRB(12)+&
                         ABy*(2.D0*ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         ABx*(ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         HRRB(16))+&
                         2.D0*HRRB(27))+&
                         HRRB(43)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,16|
      DUM=ABz*HRRA(23)+&
                         ABy*(ABz*HRRA(12)+&
                         HRRA(27))+&
                         ABx*(ABz*HRRA(13)+&
                         ABy*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,16_y|
      DUM=-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRB(23))+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         ABx*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRB(13))+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         2.D0*HRRB(16))+&
                         HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,16|
      DUM=ABz*HRRA(27)+&
                         ABy*(ABz*HRRA(15)+&
                         HRRA(30))+&
                         ABx*(ABz*HRRA(16)+&
                         ABy*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,16_z|
      DUM=-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(-HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         ABx*(-HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABy*(-HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(3_x,16|
      DUM=ABz*HRRA(23)+&
                         ABy*(ABz*HRRA(12)+&
                         HRRA(27))+&
                         ABx*(ABz*HRRA(13)+&
                         ABy*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         HRRA(28))+&
                         HRRA(44)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,16_x|
      DUM=-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRB(23))+&
                         ABy*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRB(12))+&
                         HRRB(27))+&
                         ABx*(2.D0*ABz*HRRB(13)+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABx*(ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         HRRB(17))+&
                         2.D0*HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,16|
      DUM=-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(24))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         HRRA(28))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(14))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         HRRA(17))+&
                         HRRA(29))+&
                         HRRA(45)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,16_y|
      DUM=-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(24))+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRB(14))+&
                         ABy*(2.D0*ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         2.D0*HRRB(17))+&
                         HRRB(29))+&
                         HRRB(45)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,16|
      DUM=ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         ABx*(ABz*HRRA(17)+&
                         ABy*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         HRRA(32))+&
                         HRRA(49)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,16_z|
      DUM=-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(-HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         ABx*(-HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         ABy*(-HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(4_x,16|
      DUM=ABz*HRRA(27)+&
                         ABy*(ABz*HRRA(15)+&
                         HRRA(30))+&
                         ABx*(ABz*HRRA(16)+&
                         ABy*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,16_x|
      DUM=-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRB(27))+&
                         ABy*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRB(15))+&
                         HRRB(30))+&
                         ABx*(2.D0*ABz*HRRB(16)+&
                         ABy*(2.D0*ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         ABx*(ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         HRRB(19))+&
                         2.D0*HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,16|
      DUM=ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         ABx*(ABz*HRRA(17)+&
                         ABy*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         HRRA(32))+&
                         HRRA(49)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,16_y|
      DUM=-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRB(28))+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         ABx*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRB(17))+&
                         ABy*(2.D0*ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         2.D0*HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,16|
      DUM=-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         HRRA(33))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         HRRA(20))+&
                         HRRA(34))+&
                         HRRA(52)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,16_z|
      DUM=-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         ABx*(-HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         ABy*(-HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         HRRB(34))+&
                         HRRB(52)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(2_x,17|
      DUM=-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         2.D0*HRRA(12))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         HRRA(15))+&
                         2.D0*HRRA(27))+&
                         HRRA(44)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,17_x|
      DUM=ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*HRRB(13)+&
                         ABy*(2.D0*ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         2.D0*HRRB(16))+&
                         HRRB(28))+&
                         HRRB(44)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,17|
      DUM=ABz*HRRA(24)+&
                         ABy*(2.D0*ABz*HRRA(13)+&
                         ABy*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         2.D0*HRRA(28))+&
                         HRRA(45)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,17_y|
      DUM=-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRB(24))+&
                         ABy*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         3.D0*HRRB(13))+&
                         ABy*(3.D0*ABz*HRRB(6)+&
                         ABy*(ABz*HRRB(2)+&
                         HRRB(8))+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         HRRB(45)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,17|
      DUM=ABz*HRRA(28)+&
                         ABy*(2.D0*ABz*HRRA(16)+&
                         ABy*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         2.D0*HRRA(31))+&
                         HRRA(49)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,17_z|
      DUM=-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(-2.D0*HRR(6)+&
                         ABz*(2.D0*ABz*HRRB(6)+&
                         4.D0*HRRB(16))+&
                         ABy*(-HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         HRRB(49)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(3_x,17|
      DUM=ABz*HRRA(24)+&
                         ABy*(2.D0*ABz*HRRA(13)+&
                         ABy*(ABz*HRRA(6)+&
                         HRRA(16))+&
                         2.D0*HRRA(28))+&
                         HRRA(45)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,17_x|
      DUM=ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         ABx*(ABz*HRRB(14)+&
                         ABy*(2.D0*ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         2.D0*HRRB(17))+&
                         HRRB(29))+&
                         HRRB(45)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,17|
      DUM=-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(25))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         2.D0*HRRA(14))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         HRRA(17))+&
                         2.D0*HRRA(29))+&
                         HRRA(46)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,17_y|
      DUM=-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         HRRB(25))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         3.D0*HRRB(14))+&
                         ABy*(3.D0*ABz*HRRB(7)+&
                         ABy*(ABz*HRRB(3)+&
                         HRRB(9))+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(29))+&
                         HRRB(46)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,17|
      DUM=ABz*HRRA(29)+&
                         ABy*(2.D0*ABz*HRRA(17)+&
                         ABy*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         2.D0*HRRA(32))+&
                         HRRA(50)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,17_z|
      DUM=-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         ABy*(-2.D0*HRR(7)+&
                         ABz*(2.D0*ABz*HRRB(7)+&
                         4.D0*HRRB(17))+&
                         ABy*(-HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         2.D0*HRRB(32))+&
                         HRRB(50)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(4_x,17|
      DUM=ABz*HRRA(28)+&
                         ABy*(2.D0*ABz*HRRA(16)+&
                         ABy*(ABz*HRRA(8)+&
                         HRRA(18))+&
                         2.D0*HRRA(31))+&
                         HRRA(49)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,17_x|
      DUM=ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         ABx*(ABz*HRRB(17)+&
                         ABy*(2.D0*ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         2.D0*HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,17|
      DUM=ABz*HRRA(29)+&
                         ABy*(2.D0*ABz*HRRA(17)+&
                         ABy*(ABz*HRRA(9)+&
                         HRRA(19))+&
                         2.D0*HRRA(32))+&
                         HRRA(50)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,17_y|
      DUM=-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRB(29))+&
                         ABy*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         3.D0*HRRB(17))+&
                         ABy*(3.D0*ABz*HRRB(9)+&
                         ABy*(ABz*HRRB(4)+&
                         HRRB(10))+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(32))+&
                         HRRB(50)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,17|
      DUM=-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         2.D0*HRRA(19))+&
                         ABy*(-HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         HRRA(20))+&
                         2.D0*HRRA(34))+&
                         HRRA(53)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,17_z|
      DUM=-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(2.D0*ABz*HRRB(9)+&
                         4.D0*HRRB(19))+&
                         ABy*(-HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         2.D0*HRRB(34))+&
                         HRRB(53)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(2_x,18|
      DUM=-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(11))+&
                         2.D0*HRRA(26))+&
                         ABx*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         2.D0*HRRA(15))+&
                         HRRA(30))+&
                         HRRA(47)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,18_x|
      DUM=-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRB(11))+&
                         2.D0*HRRB(26))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(5)+&
                         4.D0*HRRB(15))+&
                         ABx*(ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         2.D0*HRRB(30))+&
                         HRRB(47)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,18|
      DUM=ABz*(ABz*HRRA(12)+&
                         2.D0*HRRA(27))+&
                         ABx*(ABz*(ABz*HRRA(6)+&
                         2.D0*HRRA(16))+&
                         HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,18_y|
      DUM=ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         ABx*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABy*(ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,18|
      DUM=ABz*(ABz*HRRA(15)+&
                         2.D0*HRRA(30))+&
                         ABx*(ABz*(ABz*HRRA(8)+&
                         2.D0*HRRA(18))+&
                         HRRA(33))+&
                         HRRA(51)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,18_z|
      DUM=-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         3.D0*HRRB(8))+&
                         3.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(51)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(3_x,18|
      DUM=ABz*(ABz*HRRA(12)+&
                         2.D0*HRRA(27))+&
                         ABx*(ABz*(ABz*HRRA(6)+&
                         2.D0*HRRA(16))+&
                         HRRA(31))+&
                         HRRA(48)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,18_x|
      DUM=-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRB(12))+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(6)+&
                         4.D0*HRRB(16))+&
                         ABx*(ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         2.D0*HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,18|
      DUM=-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         2.D0*HRRA(28))+&
                         ABx*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         2.D0*HRRA(17))+&
                         HRRA(32))+&
                         HRRA(49)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,18_y|
      DUM=ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         ABx*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         ABy*(ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,18|
      DUM=ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         ABx*(ABz*(ABz*HRRA(9)+&
                         2.D0*HRRA(19))+&
                         HRRA(34))+&
                         HRRA(52)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,18_z|
      DUM=-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(52)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(4_x,18|
      DUM=ABz*(ABz*HRRA(15)+&
                         2.D0*HRRA(30))+&
                         ABx*(ABz*(ABz*HRRA(8)+&
                         2.D0*HRRA(18))+&
                         HRRA(33))+&
                         HRRA(51)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,18_x|
      DUM=-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRB(15))+&
                         2.D0*HRRB(30))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(8)+&
                         4.D0*HRRB(18))+&
                         ABx*(ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         2.D0*HRRB(33))+&
                         HRRB(51)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,18|
      DUM=ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         ABx*(ABz*(ABz*HRRA(9)+&
                         2.D0*HRRA(19))+&
                         HRRA(34))+&
                         HRRA(52)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,18_y|
      DUM=ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         ABx*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         ABy*(ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         HRRB(34))+&
                         HRRB(52)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,18|
      DUM=-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         2.D0*HRRA(33))+&
                         ABx*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         2.D0*HRRA(20))+&
                         HRRA(35))+&
                         HRRA(54)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,18_z|
      DUM=-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         ABx*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         3.D0*HRRB(10))+&
                         3.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(54)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(2_x,19|
      DUM=-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         2.D0*HRRA(27))+&
                         ABy*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         2.D0*HRRA(15))+&
                         HRRA(30))+&
                         HRRA(48)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,19_x|
      DUM=ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         ABx*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         ABy*(ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         HRRB(31))+&
                         HRRB(48)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,19|
      DUM=ABz*(ABz*HRRA(13)+&
                         2.D0*HRRA(28))+&
                         ABy*(ABz*(ABz*HRRA(6)+&
                         2.D0*HRRA(16))+&
                         HRRA(31))+&
                         HRRA(49)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,19_y|
      DUM=-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRB(13))+&
                         2.D0*HRRB(28))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(6)+&
                         4.D0*HRRB(16))+&
                         ABy*(ABz*(ABz*HRRB(2)+&
                         2.D0*HRRB(8))+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         HRRB(49)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,19|
      DUM=ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         ABy*(ABz*(ABz*HRRA(8)+&
                         2.D0*HRRA(18))+&
                         HRRA(33))+&
                         HRRA(52)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,19_z|
      DUM=-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         ABy*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         3.D0*HRRB(8))+&
                         3.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(52)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(3_x,19|
      DUM=ABz*(ABz*HRRA(13)+&
                         2.D0*HRRA(28))+&
                         ABy*(ABz*(ABz*HRRA(6)+&
                         2.D0*HRRA(16))+&
                         HRRA(31))+&
                         HRRA(49)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,19_x|
      DUM=ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         ABx*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         ABy*(ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         HRRB(32))+&
                         HRRB(49)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,19|
      DUM=-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(14))+&
                         2.D0*HRRA(29))+&
                         ABy*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         2.D0*HRRA(17))+&
                         HRRA(32))+&
                         HRRA(50)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,19_y|
      DUM=-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRB(14))+&
                         2.D0*HRRB(29))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(7)+&
                         4.D0*HRRB(17))+&
                         ABy*(ABz*(ABz*HRRB(3)+&
                         2.D0*HRRB(9))+&
                         HRRB(19))+&
                         2.D0*HRRB(32))+&
                         HRRB(50)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,19|
      DUM=ABz*(ABz*HRRA(17)+&
                         2.D0*HRRA(32))+&
                         ABy*(ABz*(ABz*HRRA(9)+&
                         2.D0*HRRA(19))+&
                         HRRA(34))+&
                         HRRA(53)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,19_z|
      DUM=-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(53)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(4_x,19|
      DUM=ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         ABy*(ABz*(ABz*HRRA(8)+&
                         2.D0*HRRA(18))+&
                         HRRA(33))+&
                         HRRA(52)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,19_x|
      DUM=ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         ABx*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         ABy*(ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         HRRB(34))+&
                         HRRB(52)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,19|
      DUM=ABz*(ABz*HRRA(17)+&
                         2.D0*HRRA(32))+&
                         ABy*(ABz*(ABz*HRRA(9)+&
                         2.D0*HRRA(19))+&
                         HRRA(34))+&
                         HRRA(53)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,19_y|
      DUM=-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRB(17))+&
                         2.D0*HRRB(32))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(9)+&
                         4.D0*HRRB(19))+&
                         ABy*(ABz*(ABz*HRRB(4)+&
                         2.D0*HRRB(10))+&
                         HRRB(20))+&
                         2.D0*HRRB(34))+&
                         HRRB(53)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,19|
      DUM=-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         2.D0*HRRA(34))+&
                         ABy*(-HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         2.D0*HRRA(20))+&
                         HRRA(35))+&
                         HRRA(55)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,19_z|
      DUM=-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         ABy*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         3.D0*HRRB(10))+&
                         3.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(55)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(2_x,20|
      DUM=-HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(-3.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(5))+&
                         3.D0*HRRA(15))+&
                         3.D0*HRRA(30))+&
                         HRRA(51)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(2,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(2)+&
                         3.D0*HRRB(8))+&
                         3.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(51)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(2_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(6)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(31))+&
                         HRRA(52)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(2,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(2)+&
                         3.D0*HRRB(8))+&
                         3.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(52)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(2_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(8)+&
                         3.D0*HRRA(18))+&
                         3.D0*HRRA(33))+&
                         HRRA(54)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(2,20_z|
      DUM=-3.D0*HRR(18)+&
                         ABz*(-6.D0*HRR(8)+&
                         ABz*(-3.D0*HRR(2)+&
                         ABz*(ABz*HRRB(2)+&
                         4.D0*HRRB(8))+&
                         6.D0*HRRB(18))+&
                         4.D0*HRRB(33))+&
                         HRRB(54)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(3_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(6)+&
                         3.D0*HRRA(16))+&
                         3.D0*HRRA(31))+&
                         HRRA(52)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(3,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(3)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(52)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(3_y,20|
      DUM=-HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(-3.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(7))+&
                         3.D0*HRRA(17))+&
                         3.D0*HRRA(32))+&
                         HRRA(53)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(3,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(3)+&
                         3.D0*HRRB(9))+&
                         3.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(53)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(3_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(9)+&
                         3.D0*HRRA(19))+&
                         3.D0*HRRA(34))+&
                         HRRA(55)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(3,20_z|
      DUM=-3.D0*HRR(19)+&
                         ABz*(-6.D0*HRR(9)+&
                         ABz*(-3.D0*HRR(3)+&
                         ABz*(ABz*HRRB(3)+&
                         4.D0*HRRB(9))+&
                         6.D0*HRRB(19))+&
                         4.D0*HRRB(34))+&
                         HRRB(55)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(4_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(8)+&
                         3.D0*HRRA(18))+&
                         3.D0*HRRA(33))+&
                         HRRA(54)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(4,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(4)+&
                         3.D0*HRRB(10))+&
                         3.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(54)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(4_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(9)+&
                         3.D0*HRRA(19))+&
                         3.D0*HRRA(34))+&
                         HRRA(55)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(4,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(4)+&
                         3.D0*HRRB(10))+&
                         3.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(55)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(4_z,20|
      DUM=-HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(-3.D0*HRR(4)+&
                         ABz*(-HRR(1)+&
                         HRRA(10))+&
                         3.D0*HRRA(20))+&
                         3.D0*HRRA(35))+&
                         HRRA(56)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(4,20_z|
      DUM=-3.D0*HRR(20)+&
                         ABz*(-6.D0*HRR(10)+&
                         ABz*(-3.D0*HRR(4)+&
                         ABz*(ABz*HRRB(4)+&
                         4.D0*HRRB(10))+&
                         6.D0*HRRB(20))+&
                         4.D0*HRRB(35))+&
                         HRRB(56)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
    END SUBROUTINE BraHRR310ab
    SUBROUTINE BraHRR310cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,Cart,HRR,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,Cart,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(2,11|
      DUM=ABx*(ABx*(ABx*HRR(2)+&
                                3.D0*HRR(5))+&
                                3.D0*HRR(11))+&
                                HRR(21)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(3,11|
      DUM=ABx*(ABx*(ABx*HRR(3)+&
                                3.D0*HRR(6))+&
                                3.D0*HRR(12))+&
                                HRR(22)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(4,11|
      DUM=ABx*(ABx*(ABx*HRR(4)+&
                                3.D0*HRR(8))+&
                                3.D0*HRR(15))+&
                                HRR(26)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(2,12|
      DUM=ABy*HRR(11)+&
                                ABx*(2.D0*ABy*HRR(5)+&
                                ABx*(ABy*HRR(2)+&
                                HRR(6))+&
                                2.D0*HRR(12))+&
                                HRR(22)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(3,12|
      DUM=ABy*HRR(12)+&
                                ABx*(2.D0*ABy*HRR(6)+&
                                ABx*(ABy*HRR(3)+&
                                HRR(7))+&
                                2.D0*HRR(13))+&
                                HRR(23)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(4,12|
      DUM=ABy*HRR(15)+&
                                ABx*(2.D0*ABy*HRR(8)+&
                                ABx*(ABy*HRR(4)+&
                                HRR(9))+&
                                2.D0*HRR(16))+&
                                HRR(27)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(2,13|
      DUM=ABy*(ABy*HRR(5)+&
                                2.D0*HRR(12))+&
                                ABx*(ABy*(ABy*HRR(2)+&
                                2.D0*HRR(6))+&
                                HRR(13))+&
                                HRR(23)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(3,13|
      DUM=ABy*(ABy*HRR(6)+&
                                2.D0*HRR(13))+&
                                ABx*(ABy*(ABy*HRR(3)+&
                                2.D0*HRR(7))+&
                                HRR(14))+&
                                HRR(24)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(4,13|
      DUM=ABy*(ABy*HRR(8)+&
                                2.D0*HRR(16))+&
                                ABx*(ABy*(ABy*HRR(4)+&
                                2.D0*HRR(9))+&
                                HRR(17))+&
                                HRR(28)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(2,14|
      DUM=ABy*(ABy*(ABy*HRR(2)+&
                                3.D0*HRR(6))+&
                                3.D0*HRR(13))+&
                                HRR(24)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(3,14|
      DUM=ABy*(ABy*(ABy*HRR(3)+&
                                3.D0*HRR(7))+&
                                3.D0*HRR(14))+&
                                HRR(25)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(4,14|
      DUM=ABy*(ABy*(ABy*HRR(4)+&
                                3.D0*HRR(9))+&
                                3.D0*HRR(17))+&
                                HRR(29)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(2,15|
      DUM=ABz*HRR(11)+&
                                ABx*(2.D0*ABz*HRR(5)+&
                                ABx*(ABz*HRR(2)+&
                                HRR(8))+&
                                2.D0*HRR(15))+&
                                HRR(26)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(3,15|
      DUM=ABz*HRR(12)+&
                                ABx*(2.D0*ABz*HRR(6)+&
                                ABx*(ABz*HRR(3)+&
                                HRR(9))+&
                                2.D0*HRR(16))+&
                                HRR(27)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(4,15|
      DUM=ABz*HRR(15)+&
                                ABx*(2.D0*ABz*HRR(8)+&
                                ABx*(ABz*HRR(4)+&
                                HRR(10))+&
                                2.D0*HRR(18))+&
                                HRR(30)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(2,16|
      DUM=ABz*HRR(12)+&
                                ABy*(ABz*HRR(5)+&
                                HRR(15))+&
                                ABx*(ABz*HRR(6)+&
                                ABy*(ABz*HRR(2)+&
                                HRR(8))+&
                                HRR(16))+&
                                HRR(27)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(3,16|
      DUM=ABz*HRR(13)+&
                                ABy*(ABz*HRR(6)+&
                                HRR(16))+&
                                ABx*(ABz*HRR(7)+&
                                ABy*(ABz*HRR(3)+&
                                HRR(9))+&
                                HRR(17))+&
                                HRR(28)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(4,16|
      DUM=ABz*HRR(16)+&
                                ABy*(ABz*HRR(8)+&
                                HRR(18))+&
                                ABx*(ABz*HRR(9)+&
                                ABy*(ABz*HRR(4)+&
                                HRR(10))+&
                                HRR(19))+&
                                HRR(31)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(2,17|
      DUM=ABz*HRR(13)+&
                                ABy*(2.D0*ABz*HRR(6)+&
                                ABy*(ABz*HRR(2)+&
                                HRR(8))+&
                                2.D0*HRR(16))+&
                                HRR(28)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(3,17|
      DUM=ABz*HRR(14)+&
                                ABy*(2.D0*ABz*HRR(7)+&
                                ABy*(ABz*HRR(3)+&
                                HRR(9))+&
                                2.D0*HRR(17))+&
                                HRR(29)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(4,17|
      DUM=ABz*HRR(17)+&
                                ABy*(2.D0*ABz*HRR(9)+&
                                ABy*(ABz*HRR(4)+&
                                HRR(10))+&
                                2.D0*HRR(19))+&
                                HRR(32)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(2,18|
      DUM=ABz*(ABz*HRR(5)+&
                                2.D0*HRR(15))+&
                                ABx*(ABz*(ABz*HRR(2)+&
                                2.D0*HRR(8))+&
                                HRR(18))+&
                                HRR(30)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(3,18|
      DUM=ABz*(ABz*HRR(6)+&
                                2.D0*HRR(16))+&
                                ABx*(ABz*(ABz*HRR(3)+&
                                2.D0*HRR(9))+&
                                HRR(19))+&
                                HRR(31)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(4,18|
      DUM=ABz*(ABz*HRR(8)+&
                                2.D0*HRR(18))+&
                                ABx*(ABz*(ABz*HRR(4)+&
                                2.D0*HRR(10))+&
                                HRR(20))+&
                                HRR(33)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(2,19|
      DUM=ABz*(ABz*HRR(6)+&
                                2.D0*HRR(16))+&
                                ABy*(ABz*(ABz*HRR(2)+&
                                2.D0*HRR(8))+&
                                HRR(18))+&
                                HRR(31)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(3,19|
      DUM=ABz*(ABz*HRR(7)+&
                                2.D0*HRR(17))+&
                                ABy*(ABz*(ABz*HRR(3)+&
                                2.D0*HRR(9))+&
                                HRR(19))+&
                                HRR(32)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(4,19|
      DUM=ABz*(ABz*HRR(9)+&
                                2.D0*HRR(19))+&
                                ABy*(ABz*(ABz*HRR(4)+&
                                2.D0*HRR(10))+&
                                HRR(20))+&
                                HRR(34)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(2,20|
      DUM=ABz*(ABz*(ABz*HRR(2)+&
                                3.D0*HRR(8))+&
                                3.D0*HRR(18))+&
                                HRR(33)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(3,20|
      DUM=ABz*(ABz*(ABz*HRR(3)+&
                                3.D0*HRR(9))+&
                                3.D0*HRR(19))+&
                                HRR(34)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(4,20|
      DUM=ABz*(ABz*(ABz*HRR(4)+&
                                3.D0*HRR(10))+&
                                3.D0*HRR(20))+&
                                HRR(35)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
    END SUBROUTINE BraHRR310cd
