!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
    SUBROUTINE BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR,HRRA,HRRB,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*),HRRA(*),HRRB(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(11_x,5|
      DUM=-3.D0*HRR(21)+&
                         ABx*(-6.D0*HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(36))+&
                         HRRA(57)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,5_x|
      DUM=-2.D0*HRR(21)+&
                         ABx*(-2.D0*HRR(11)+&
                         ABx*(ABx*HRRB(11)+&
                         3.D0*HRRB(21))+&
                         3.D0*HRRB(36))+&
                         HRRB(57)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,5|
      DUM=ABx*(ABx*HRRA(22)+&
                         2.D0*HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,5_y|
      DUM=ABy*HRRB(36)+&
                         ABx*(2.D0*ABy*HRRB(21)+&
                         ABx*(ABy*HRRB(11)+&
                         HRRB(22))+&
                         2.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,5|
      DUM=ABx*(ABx*HRRA(26)+&
                         2.D0*HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,5_z|
      DUM=ABz*HRRB(36)+&
                         ABx*(2.D0*ABz*HRRB(21)+&
                         ABx*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(12_x,5|
      DUM=-2.D0*HRR(22)+&
                         ABx*(-4.D0*HRR(12)+&
                         ABx*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,5_x|
      DUM=-2.D0*HRR(22)+&
                         ABx*(-2.D0*HRR(12)+&
                         ABx*(ABx*HRRB(12)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,5|
      DUM=-HRR(21)+&
                         ABx*(-2.D0*HRR(11)+&
                         ABx*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,5_y|
      DUM=ABy*HRRB(37)+&
                         ABx*(2.D0*ABy*HRRB(22)+&
                         ABx*(ABy*HRRB(12)+&
                         HRRB(23))+&
                         2.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,5|
      DUM=ABx*(ABx*HRRA(27)+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,5_z|
      DUM=ABz*HRRB(37)+&
                         ABx*(2.D0*ABz*HRRB(22)+&
                         ABx*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(13_x,5|
      DUM=-HRR(23)+&
                         ABx*(-2.D0*HRR(13)+&
                         ABx*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,5_x|
      DUM=-2.D0*HRR(23)+&
                         ABx*(-2.D0*HRR(13)+&
                         ABx*(ABx*HRRB(13)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,5|
      DUM=-2.D0*HRR(22)+&
                         ABx*(-4.D0*HRR(12)+&
                         ABx*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,5_y|
      DUM=ABy*HRRB(38)+&
                         ABx*(2.D0*ABy*HRRB(23)+&
                         ABx*(ABy*HRRB(13)+&
                         HRRB(24))+&
                         2.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,5|
      DUM=ABx*(ABx*HRRA(28)+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,5_z|
      DUM=ABz*HRRB(38)+&
                         ABx*(2.D0*ABz*HRRB(23)+&
                         ABx*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(14_x,5|
      DUM=ABx*(ABx*HRRA(24)+&
                         2.D0*HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,5_x|
      DUM=-2.D0*HRR(24)+&
                         ABx*(-2.D0*HRR(14)+&
                         ABx*(ABx*HRRB(14)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,5|
      DUM=-3.D0*HRR(23)+&
                         ABx*(-6.D0*HRR(13)+&
                         ABx*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,5_y|
      DUM=ABy*HRRB(39)+&
                         ABx*(2.D0*ABy*HRRB(24)+&
                         ABx*(ABy*HRRB(14)+&
                         HRRB(25))+&
                         2.D0*HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,5|
      DUM=ABx*(ABx*HRRA(29)+&
                         2.D0*HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,5_z|
      DUM=ABz*HRRB(39)+&
                         ABx*(2.D0*ABz*HRRB(24)+&
                         ABx*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(15_x,5|
      DUM=-2.D0*HRR(26)+&
                         ABx*(-4.D0*HRR(15)+&
                         ABx*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,5_x|
      DUM=-2.D0*HRR(26)+&
                         ABx*(-2.D0*HRR(15)+&
                         ABx*(ABx*HRRB(15)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,5|
      DUM=ABx*(ABx*HRRA(27)+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,5_y|
      DUM=ABy*HRRB(42)+&
                         ABx*(2.D0*ABy*HRRB(26)+&
                         ABx*(ABy*HRRB(15)+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,5|
      DUM=-HRR(21)+&
                         ABx*(-2.D0*HRR(11)+&
                         ABx*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,5_z|
      DUM=ABz*HRRB(42)+&
                         ABx*(2.D0*ABz*HRRB(26)+&
                         ABx*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(16_x,5|
      DUM=-HRR(27)+&
                         ABx*(-2.D0*HRR(16)+&
                         ABx*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,5_x|
      DUM=-2.D0*HRR(27)+&
                         ABx*(-2.D0*HRR(16)+&
                         ABx*(ABx*HRRB(16)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,5|
      DUM=-HRR(26)+&
                         ABx*(-2.D0*HRR(15)+&
                         ABx*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,5_y|
      DUM=ABy*HRRB(43)+&
                         ABx*(2.D0*ABy*HRRB(27)+&
                         ABx*(ABy*HRRB(16)+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,5|
      DUM=-HRR(22)+&
                         ABx*(-2.D0*HRR(12)+&
                         ABx*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,5_z|
      DUM=ABz*HRRB(43)+&
                         ABx*(2.D0*ABz*HRRB(27)+&
                         ABx*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(17_x,5|
      DUM=ABx*(ABx*HRRA(28)+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,5_x|
      DUM=-2.D0*HRR(28)+&
                         ABx*(-2.D0*HRR(17)+&
                         ABx*(ABx*HRRB(17)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,5|
      DUM=-2.D0*HRR(27)+&
                         ABx*(-4.D0*HRR(16)+&
                         ABx*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,5_y|
      DUM=ABy*HRRB(44)+&
                         ABx*(2.D0*ABy*HRRB(28)+&
                         ABx*(ABy*HRRB(17)+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,5|
      DUM=-HRR(23)+&
                         ABx*(-2.D0*HRR(13)+&
                         ABx*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,5_z|
      DUM=ABz*HRRB(44)+&
                         ABx*(2.D0*ABz*HRRB(28)+&
                         ABx*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(18_x,5|
      DUM=-HRR(30)+&
                         ABx*(-2.D0*HRR(18)+&
                         ABx*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,5_x|
      DUM=-2.D0*HRR(30)+&
                         ABx*(-2.D0*HRR(18)+&
                         ABx*(ABx*HRRB(18)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,5|
      DUM=ABx*(ABx*HRRA(31)+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,5_y|
      DUM=ABy*HRRB(47)+&
                         ABx*(2.D0*ABy*HRRB(30)+&
                         ABx*(ABy*HRRB(18)+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,5|
      DUM=-2.D0*HRR(26)+&
                         ABx*(-4.D0*HRR(15)+&
                         ABx*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,5_z|
      DUM=ABz*HRRB(47)+&
                         ABx*(2.D0*ABz*HRRB(30)+&
                         ABx*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(19_x,5|
      DUM=ABx*(ABx*HRRA(31)+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,5_x|
      DUM=-2.D0*HRR(31)+&
                         ABx*(-2.D0*HRR(19)+&
                         ABx*(ABx*HRRB(19)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,5|
      DUM=-HRR(30)+&
                         ABx*(-2.D0*HRR(18)+&
                         ABx*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,5_y|
      DUM=ABy*HRRB(48)+&
                         ABx*(2.D0*ABy*HRRB(31)+&
                         ABx*(ABy*HRRB(19)+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,5|
      DUM=-2.D0*HRR(27)+&
                         ABx*(-4.D0*HRR(16)+&
                         ABx*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,5_z|
      DUM=ABz*HRRB(48)+&
                         ABx*(2.D0*ABz*HRRB(31)+&
                         ABx*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(20_x,5|
      DUM=ABx*(ABx*HRRA(33)+&
                         2.D0*HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,5_x|
      DUM=-2.D0*HRR(33)+&
                         ABx*(-2.D0*HRR(20)+&
                         ABx*(ABx*HRRB(20)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,5|
      DUM=ABx*(ABx*HRRA(34)+&
                         2.D0*HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,5_y|
      DUM=ABy*HRRB(51)+&
                         ABx*(2.D0*ABy*HRRB(33)+&
                         ABx*(ABy*HRRB(20)+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,5|
      DUM=-3.D0*HRR(30)+&
                         ABx*(-6.D0*HRR(18)+&
                         ABx*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,5_z|
      DUM=ABz*HRRB(51)+&
                         ABx*(2.D0*ABz*HRRB(33)+&
                         ABx*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(11_x,6|
      DUM=-3.D0*HRR(22)+&
                         ABy*(-3.D0*HRR(11)+&
                         HRRA(36))+&
                         ABx*(-3.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,6_x|
      DUM=-HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRB(36))+&
                         ABx*(2.D0*ABy*HRRB(21)+&
                         ABx*(ABy*HRRB(11)+&
                         HRRB(22))+&
                         2.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,6|
      DUM=ABy*HRRA(37)+&
                         ABx*(ABy*HRRA(22)+&
                         HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,6_y|
      DUM=-HRR(21)+&
                         ABy*(ABy*HRRB(21)+&
                         2.D0*HRRB(37))+&
                         ABx*(-HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         2.D0*HRRB(22))+&
                         HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,6|
      DUM=ABy*HRRA(42)+&
                         ABx*(ABy*HRRA(26)+&
                         HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,6_z|
      DUM=ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(12_x,6|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,6_x|
      DUM=-HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRB(37))+&
                         ABx*(2.D0*ABy*HRRB(22)+&
                         ABx*(ABy*HRRB(12)+&
                         HRRB(23))+&
                         2.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,6|
      DUM=-HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(38))+&
                         ABx*(-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,6_y|
      DUM=-HRR(22)+&
                         ABy*(ABy*HRRB(22)+&
                         2.D0*HRRB(38))+&
                         ABx*(-HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         2.D0*HRRB(23))+&
                         HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,6|
      DUM=ABy*HRRA(43)+&
                         ABx*(ABy*HRRA(27)+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,6_z|
      DUM=ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(13_x,6|
      DUM=-HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRA(38))+&
                         ABx*(-HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,6_x|
      DUM=-HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRB(38))+&
                         ABx*(2.D0*ABy*HRRB(23)+&
                         ABx*(ABy*HRRB(13)+&
                         HRRB(24))+&
                         2.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,6|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,6_y|
      DUM=-HRR(23)+&
                         ABy*(ABy*HRRB(23)+&
                         2.D0*HRRB(39))+&
                         ABx*(-HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         2.D0*HRRB(24))+&
                         HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,6|
      DUM=ABy*HRRA(44)+&
                         ABx*(ABy*HRRA(28)+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,6_z|
      DUM=ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(14_x,6|
      DUM=ABy*HRRA(39)+&
                         ABx*(ABy*HRRA(24)+&
                         HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,6_x|
      DUM=-HRR(25)+&
                         ABy*(-HRR(14)+&
                         HRRB(39))+&
                         ABx*(2.D0*ABy*HRRB(24)+&
                         ABx*(ABy*HRRB(14)+&
                         HRRB(25))+&
                         2.D0*HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,6|
      DUM=-3.D0*HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         HRRA(40))+&
                         ABx*(-3.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(41))+&
                         HRRA(62)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,6_y|
      DUM=-HRR(24)+&
                         ABy*(ABy*HRRB(24)+&
                         2.D0*HRRB(40))+&
                         ABx*(-HRR(14)+&
                         ABy*(ABy*HRRB(14)+&
                         2.D0*HRRB(25))+&
                         HRRB(41))+&
                         HRRB(62)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,6|
      DUM=ABy*HRRA(45)+&
                         ABx*(ABy*HRRA(29)+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,6_z|
      DUM=ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(15_x,6|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRA(42))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,6_x|
      DUM=-HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRB(42))+&
                         ABx*(2.D0*ABy*HRRB(26)+&
                         ABx*(ABy*HRRB(15)+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,6|
      DUM=ABy*HRRA(43)+&
                         ABx*(ABy*HRRA(27)+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,6_y|
      DUM=-HRR(26)+&
                         ABy*(ABy*HRRB(26)+&
                         2.D0*HRRB(43))+&
                         ABx*(-HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,6|
      DUM=-HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(47))+&
                         ABx*(-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,6_z|
      DUM=ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(16_x,6|
      DUM=-HRR(28)+&
                         ABy*(-HRR(16)+&
                         HRRA(43))+&
                         ABx*(-HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,6_x|
      DUM=-HRR(28)+&
                         ABy*(-HRR(16)+&
                         HRRB(43))+&
                         ABx*(2.D0*ABy*HRRB(27)+&
                         ABx*(ABy*HRRB(16)+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,6|
      DUM=-HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRA(44))+&
                         ABx*(-HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,6_y|
      DUM=-HRR(27)+&
                         ABy*(ABy*HRRB(27)+&
                         2.D0*HRRB(44))+&
                         ABx*(-HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,6|
      DUM=-HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRA(48))+&
                         ABx*(-HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,6_z|
      DUM=ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(17_x,6|
      DUM=ABy*HRRA(44)+&
                         ABx*(ABy*HRRA(28)+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,6_x|
      DUM=-HRR(29)+&
                         ABy*(-HRR(17)+&
                         HRRB(44))+&
                         ABx*(2.D0*ABy*HRRB(28)+&
                         ABx*(ABy*HRRB(17)+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,6|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         HRRA(45))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,6_y|
      DUM=-HRR(28)+&
                         ABy*(ABy*HRRB(28)+&
                         2.D0*HRRB(45))+&
                         ABx*(-HRR(17)+&
                         ABy*(ABy*HRRB(17)+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,6|
      DUM=-HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRA(49))+&
                         ABx*(-HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,6_z|
      DUM=ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(18_x,6|
      DUM=-HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRA(47))+&
                         ABx*(-HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,6_x|
      DUM=-HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRB(47))+&
                         ABx*(2.D0*ABy*HRRB(30)+&
                         ABx*(ABy*HRRB(18)+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,6|
      DUM=ABy*HRRA(48)+&
                         ABx*(ABy*HRRA(31)+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,6_y|
      DUM=-HRR(30)+&
                         ABy*(ABy*HRRB(30)+&
                         2.D0*HRRB(48))+&
                         ABx*(-HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,6|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,6_z|
      DUM=ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(19_x,6|
      DUM=ABy*HRRA(48)+&
                         ABx*(ABy*HRRA(31)+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,6_x|
      DUM=-HRR(32)+&
                         ABy*(-HRR(19)+&
                         HRRB(48))+&
                         ABx*(2.D0*ABy*HRRB(31)+&
                         ABx*(ABy*HRRB(19)+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,6|
      DUM=-HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRA(49))+&
                         ABx*(-HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,6_y|
      DUM=-HRR(31)+&
                         ABy*(ABy*HRRB(31)+&
                         2.D0*HRRB(49))+&
                         ABx*(-HRR(19)+&
                         ABy*(ABy*HRRB(19)+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,6|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,6_z|
      DUM=ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(20_x,6|
      DUM=ABy*HRRA(51)+&
                         ABx*(ABy*HRRA(33)+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,6_x|
      DUM=-HRR(34)+&
                         ABy*(-HRR(20)+&
                         HRRB(51))+&
                         ABx*(2.D0*ABy*HRRB(33)+&
                         ABx*(ABy*HRRB(20)+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,6|
      DUM=ABy*HRRA(52)+&
                         ABx*(ABy*HRRA(34)+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,6_y|
      DUM=-HRR(33)+&
                         ABy*(ABy*HRRB(33)+&
                         2.D0*HRRB(52))+&
                         ABx*(-HRR(20)+&
                         ABy*(ABy*HRRB(20)+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,6|
      DUM=-3.D0*HRR(31)+&
                         ABy*(-3.D0*HRR(18)+&
                         HRRA(54))+&
                         ABx*(-3.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,6_z|
      DUM=ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(11_x,7|
      DUM=-3.D0*HRR(23)+&
                         ABy*(-6.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(37))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,7_x|
      DUM=ABy*(ABy*HRRB(21)+&
                         2.D0*HRRB(37))+&
                         ABx*(ABy*(ABy*HRRB(11)+&
                         2.D0*HRRB(22))+&
                         HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,7|
      DUM=ABy*(ABy*HRRA(22)+&
                         2.D0*HRRA(38))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,7_y|
      DUM=-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(38))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,7|
      DUM=ABy*(ABy*HRRA(26)+&
                         2.D0*HRRA(43))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,7_z|
      DUM=ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(12_x,7|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-4.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(38))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,7_x|
      DUM=ABy*(ABy*HRRB(22)+&
                         2.D0*HRRB(38))+&
                         ABx*(ABy*(ABy*HRRB(12)+&
                         2.D0*HRRB(23))+&
                         HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,7|
      DUM=-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(39))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,7_y|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(39))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,7|
      DUM=ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,7_z|
      DUM=ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(13_x,7|
      DUM=-HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(39))+&
                         HRRA(61)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,7_x|
      DUM=ABy*(ABy*HRRB(23)+&
                         2.D0*HRRB(39))+&
                         ABx*(ABy*(ABy*HRRB(13)+&
                         2.D0*HRRB(24))+&
                         HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,7|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-4.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(40))+&
                         HRRA(62)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,7_y|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(40))+&
                         HRRB(62)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,7|
      DUM=ABy*(ABy*HRRA(28)+&
                         2.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,7_z|
      DUM=ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(14_x,7|
      DUM=ABy*(ABy*HRRA(24)+&
                         2.D0*HRRA(40))+&
                         HRRA(62)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,7_x|
      DUM=ABy*(ABy*HRRB(24)+&
                         2.D0*HRRB(40))+&
                         ABx*(ABy*(ABy*HRRB(14)+&
                         2.D0*HRRB(25))+&
                         HRRB(41))+&
                         HRRB(62)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,7|
      DUM=-3.D0*HRR(25)+&
                         ABy*(-6.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(41))+&
                         HRRA(63)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,7_y|
      DUM=-2.D0*HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(ABy*HRRB(14)+&
                         3.D0*HRRB(25))+&
                         3.D0*HRRB(41))+&
                         HRRB(63)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,7|
      DUM=ABy*(ABy*HRRA(29)+&
                         2.D0*HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,7_z|
      DUM=ABz*HRRB(41)+&
                         ABy*(2.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(15_x,7|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(43))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,7_x|
      DUM=ABy*(ABy*HRRB(26)+&
                         2.D0*HRRB(43))+&
                         ABx*(ABy*(ABy*HRRB(15)+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,7|
      DUM=ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,7_y|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,7|
      DUM=-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,7_z|
      DUM=ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(16_x,7|
      DUM=-HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,7_x|
      DUM=ABy*(ABy*HRRB(27)+&
                         2.D0*HRRB(44))+&
                         ABx*(ABy*(ABy*HRRB(16)+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,7|
      DUM=-HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,7_y|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,7|
      DUM=-HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,7_z|
      DUM=ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(17_x,7|
      DUM=ABy*(ABy*HRRA(28)+&
                         2.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,7_x|
      DUM=ABy*(ABy*HRRB(28)+&
                         2.D0*HRRB(45))+&
                         ABx*(ABy*(ABy*HRRB(17)+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,7|
      DUM=-2.D0*HRR(29)+&
                         ABy*(-4.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,7_y|
      DUM=-2.D0*HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         ABy*(ABy*HRRB(17)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,7|
      DUM=-HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,7_z|
      DUM=ABz*HRRB(46)+&
                         ABy*(2.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(18_x,7|
      DUM=-HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,7_x|
      DUM=ABy*(ABy*HRRB(30)+&
                         2.D0*HRRB(48))+&
                         ABx*(ABy*(ABy*HRRB(18)+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,7|
      DUM=ABy*(ABy*HRRA(31)+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,7_y|
      DUM=-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,7|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,7_z|
      DUM=ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(19_x,7|
      DUM=ABy*(ABy*HRRA(31)+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,7_x|
      DUM=ABy*(ABy*HRRB(31)+&
                         2.D0*HRRB(49))+&
                         ABx*(ABy*(ABy*HRRB(19)+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,7|
      DUM=-HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,7_y|
      DUM=-2.D0*HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(ABy*HRRB(19)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,7|
      DUM=-2.D0*HRR(29)+&
                         ABy*(-4.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,7_z|
      DUM=ABz*HRRB(50)+&
                         ABy*(2.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(20_x,7|
      DUM=ABy*(ABy*HRRA(33)+&
                         2.D0*HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,7_x|
      DUM=ABy*(ABy*HRRB(33)+&
                         2.D0*HRRB(52))+&
                         ABx*(ABy*(ABy*HRRB(20)+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,7|
      DUM=ABy*(ABy*HRRA(34)+&
                         2.D0*HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,7_y|
      DUM=-2.D0*HRR(34)+&
                         ABy*(-2.D0*HRR(20)+&
                         ABy*(ABy*HRRB(20)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,7|
      DUM=-3.D0*HRR(32)+&
                         ABy*(-6.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,7_z|
      DUM=ABz*HRRB(53)+&
                         ABy*(2.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(11_x,8|
      DUM=-3.D0*HRR(26)+&
                         ABz*(-3.D0*HRR(11)+&
                         HRRA(36))+&
                         ABx*(-3.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,8_x|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(36))+&
                         ABx*(2.D0*ABz*HRRB(21)+&
                         ABx*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,8|
      DUM=ABz*HRRA(37)+&
                         ABx*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,8_y|
      DUM=ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,8|
      DUM=ABz*HRRA(42)+&
                         ABx*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,8_z|
      DUM=-HRR(21)+&
                         ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(12_x,8|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,8_x|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(37))+&
                         ABx*(2.D0*ABz*HRRB(22)+&
                         ABx*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,8|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(38))+&
                         ABx*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,8_y|
      DUM=ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,8|
      DUM=ABz*HRRA(43)+&
                         ABx*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,8_z|
      DUM=-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(13_x,8|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(38))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,8_x|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(38))+&
                         ABx*(2.D0*ABz*HRRB(23)+&
                         ABx*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,8|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,8_y|
      DUM=ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,8|
      DUM=ABz*HRRA(44)+&
                         ABx*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,8_z|
      DUM=-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(14_x,8|
      DUM=ABz*HRRA(39)+&
                         ABx*(ABz*HRRA(24)+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,8_x|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(39))+&
                         ABx*(2.D0*ABz*HRRB(24)+&
                         ABx*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,8|
      DUM=-3.D0*HRR(28)+&
                         ABz*(-3.D0*HRR(13)+&
                         HRRA(40))+&
                         ABx*(-3.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,8_y|
      DUM=ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,8|
      DUM=ABz*HRRA(45)+&
                         ABx*(ABz*HRRA(29)+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,8_z|
      DUM=-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABx*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(15_x,8|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(42))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,8_x|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(42))+&
                         ABx*(2.D0*ABz*HRRB(26)+&
                         ABx*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,8|
      DUM=ABz*HRRA(43)+&
                         ABx*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,8_y|
      DUM=ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,8|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(47))+&
                         ABx*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,8_z|
      DUM=-HRR(26)+&
                         ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(16_x,8|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(43))+&
                         ABx*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,8_x|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(43))+&
                         ABx*(2.D0*ABz*HRRB(27)+&
                         ABx*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,8|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRA(44))+&
                         ABx*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,8_y|
      DUM=ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,8|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         ABx*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,8_z|
      DUM=-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(17_x,8|
      DUM=ABz*HRRA(44)+&
                         ABx*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,8_x|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(44))+&
                         ABx*(2.D0*ABz*HRRB(28)+&
                         ABx*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,8|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(45))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,8_y|
      DUM=ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,8|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,8_z|
      DUM=-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABx*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(18_x,8|
      DUM=-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(47))+&
                         ABx*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,8_x|
      DUM=-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(47))+&
                         ABx*(2.D0*ABz*HRRB(30)+&
                         ABx*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,8|
      DUM=ABz*HRRA(48)+&
                         ABx*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,8_y|
      DUM=ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,8|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,8_z|
      DUM=-HRR(30)+&
                         ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(19_x,8|
      DUM=ABz*HRRA(48)+&
                         ABx*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,8_x|
      DUM=-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(48))+&
                         ABx*(2.D0*ABz*HRRB(31)+&
                         ABx*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,8|
      DUM=-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(49))+&
                         ABx*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,8_y|
      DUM=ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,8|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,8_z|
      DUM=-HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABx*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(20_x,8|
      DUM=ABz*HRRA(51)+&
                         ABx*(ABz*HRRA(33)+&
                         HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,8_x|
      DUM=-HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(51))+&
                         ABx*(2.D0*ABz*HRRB(33)+&
                         ABx*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,8|
      DUM=ABz*HRRA(52)+&
                         ABx*(ABz*HRRA(34)+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,8_y|
      DUM=ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,8|
      DUM=-3.D0*HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         HRRA(54))+&
                         ABx*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(56))+&
                         HRRA(82)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,8_z|
      DUM=-HRR(33)+&
                         ABz*(ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         ABx*(-HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(82)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(11_x,9|
      DUM=-3.D0*HRR(27)+&
                         ABz*(-3.D0*HRR(12)+&
                         HRRA(37))+&
                         ABy*(-3.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,9_x|
      DUM=ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,9|
      DUM=ABz*HRRA(38)+&
                         ABy*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,9_y|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(38))+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,9|
      DUM=ABz*HRRA(43)+&
                         ABy*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,9_z|
      DUM=-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(12_x,9|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(38))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,9_x|
      DUM=ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,9|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(39))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,9_y|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(39))+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,9|
      DUM=ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,9_z|
      DUM=-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(13_x,9|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(39))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,9_x|
      DUM=ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,9|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,9_y|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(40))+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,9|
      DUM=ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,9_z|
      DUM=-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(14_x,9|
      DUM=ABz*HRRA(40)+&
                         ABy*(ABz*HRRA(24)+&
                         HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,9_x|
      DUM=ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,9|
      DUM=-3.D0*HRR(29)+&
                         ABz*(-3.D0*HRR(14)+&
                         HRRA(41))+&
                         ABy*(-3.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,9_y|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(41))+&
                         ABy*(2.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,9|
      DUM=ABz*HRRA(46)+&
                         ABy*(ABz*HRRA(29)+&
                         HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,9_z|
      DUM=-HRR(25)+&
                         ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(15_x,9|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(43))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,9_x|
      DUM=ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,9|
      DUM=ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,9_y|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(44))+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,9|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,9_z|
      DUM=-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(16_x,9|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRA(44))+&
                         ABy*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,9_x|
      DUM=ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,9|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(45))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,9_y|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(45))+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,9|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,9_z|
      DUM=-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(17_x,9|
      DUM=ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,9_x|
      DUM=ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,9|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,9_y|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(46))+&
                         ABy*(2.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,9|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,9_z|
      DUM=-HRR(29)+&
                         ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(18_x,9|
      DUM=-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(48))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,9_x|
      DUM=ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,9|
      DUM=ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,9_y|
      DUM=-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(49))+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,9|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,9_z|
      DUM=-HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(19_x,9|
      DUM=ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,9_x|
      DUM=ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,9|
      DUM=-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(50))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,9_y|
      DUM=-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(50))+&
                         ABy*(2.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,9|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(53))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,9_z|
      DUM=-HRR(32)+&
                         ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(20_x,9|
      DUM=ABz*HRRA(52)+&
                         ABy*(ABz*HRRA(33)+&
                         HRRA(54))+&
                         HRRA(80)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,9_x|
      DUM=ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,9|
      DUM=ABz*HRRA(53)+&
                         ABy*(ABz*HRRA(34)+&
                         HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,9_y|
      DUM=-HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(53))+&
                         ABy*(2.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,9|
      DUM=-3.D0*HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         HRRA(55))+&
                         ABy*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(56))+&
                         HRRA(83)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,9_z|
      DUM=-HRR(34)+&
                         ABz*(ABz*HRRB(34)+&
                         2.D0*HRRB(55))+&
                         ABy*(-HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(11_x,10|
      DUM=-3.D0*HRR(30)+&
                         ABz*(-6.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(42))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,10_x|
      DUM=ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,10|
      DUM=ABz*(ABz*HRRA(22)+&
                         2.D0*HRRA(43))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,10_y|
      DUM=ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,10|
      DUM=ABz*(ABz*HRRA(26)+&
                         2.D0*HRRA(47))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,10_z|
      DUM=-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(12_x,10|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(43))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,10_x|
      DUM=ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,10|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,10_y|
      DUM=ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,10|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,10_z|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(13_x,10|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,10_x|
      DUM=ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,10|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(45))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,10_y|
      DUM=ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,10|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,10_z|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(14_x,10|
      DUM=ABz*(ABz*HRRA(24)+&
                         2.D0*HRRA(45))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,10_x|
      DUM=ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,10|
      DUM=-3.D0*HRR(32)+&
                         ABz*(-6.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(46))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,10_y|
      DUM=ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,10|
      DUM=ABz*(ABz*HRRA(29)+&
                         2.D0*HRRA(50))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,10_z|
      DUM=-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(15_x,10|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(47))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,10_x|
      DUM=ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,10|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,10_y|
      DUM=ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,10|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,10_z|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(16_x,10|
      DUM=-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(48))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,10_x|
      DUM=ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,10|
      DUM=-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(49))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,10_y|
      DUM=ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,10|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,10_z|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(17_x,10|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,10_x|
      DUM=ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,10|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(50))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,10_y|
      DUM=ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,10|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,10_z|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(18_x,10|
      DUM=-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,10_x|
      DUM=ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,10|
      DUM=ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,10_y|
      DUM=ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,10|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(54))+&
                         HRRA(82)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,10_z|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         HRRB(82)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(19_x,10|
      DUM=ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,10_x|
      DUM=ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,10|
      DUM=-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,10_y|
      DUM=ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,10|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(55))+&
                         HRRA(83)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,10_z|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         HRRB(83)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(20_x,10|
      DUM=ABz*(ABz*HRRA(33)+&
                         2.D0*HRRA(54))+&
                         HRRA(82)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,10_x|
      DUM=ABz*(ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         ABx*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(82)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,10|
      DUM=ABz*(ABz*HRRA(34)+&
                         2.D0*HRRA(55))+&
                         HRRA(83)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,10_y|
      DUM=ABz*(ABz*HRRB(34)+&
                         2.D0*HRRB(55))+&
                         ABy*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,10|
      DUM=-3.D0*HRR(35)+&
                         ABz*(-6.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(56))+&
                         HRRA(84)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,10_z|
      DUM=-2.D0*HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         3.D0*HRRB(35))+&
                         3.D0*HRRB(56))+&
                         HRRB(84)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
    END SUBROUTINE BraHRR106ab
    SUBROUTINE BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,Cart,HRR,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,Cart,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(11,5|
      DUM=ABx*(ABx*HRR(11)+&
                                2.D0*HRR(21))+&
                                HRR(36)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(12,5|
      DUM=ABx*(ABx*HRR(12)+&
                                2.D0*HRR(22))+&
                                HRR(37)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(13,5|
      DUM=ABx*(ABx*HRR(13)+&
                                2.D0*HRR(23))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(14,5|
      DUM=ABx*(ABx*HRR(14)+&
                                2.D0*HRR(24))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(15,5|
      DUM=ABx*(ABx*HRR(15)+&
                                2.D0*HRR(26))+&
                                HRR(42)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(16,5|
      DUM=ABx*(ABx*HRR(16)+&
                                2.D0*HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(17,5|
      DUM=ABx*(ABx*HRR(17)+&
                                2.D0*HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(18,5|
      DUM=ABx*(ABx*HRR(18)+&
                                2.D0*HRR(30))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(19,5|
      DUM=ABx*(ABx*HRR(19)+&
                                2.D0*HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(20,5|
      DUM=ABx*(ABx*HRR(20)+&
                                2.D0*HRR(33))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(11,6|
      DUM=ABy*HRR(21)+&
                                ABx*(ABy*HRR(11)+&
                                HRR(22))+&
                                HRR(37)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(12,6|
      DUM=ABy*HRR(22)+&
                                ABx*(ABy*HRR(12)+&
                                HRR(23))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(13,6|
      DUM=ABy*HRR(23)+&
                                ABx*(ABy*HRR(13)+&
                                HRR(24))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(14,6|
      DUM=ABy*HRR(24)+&
                                ABx*(ABy*HRR(14)+&
                                HRR(25))+&
                                HRR(40)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(15,6|
      DUM=ABy*HRR(26)+&
                                ABx*(ABy*HRR(15)+&
                                HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(16,6|
      DUM=ABy*HRR(27)+&
                                ABx*(ABy*HRR(16)+&
                                HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(17,6|
      DUM=ABy*HRR(28)+&
                                ABx*(ABy*HRR(17)+&
                                HRR(29))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(18,6|
      DUM=ABy*HRR(30)+&
                                ABx*(ABy*HRR(18)+&
                                HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(19,6|
      DUM=ABy*HRR(31)+&
                                ABx*(ABy*HRR(19)+&
                                HRR(32))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(20,6|
      DUM=ABy*HRR(33)+&
                                ABx*(ABy*HRR(20)+&
                                HRR(34))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(11,7|
      DUM=ABy*(ABy*HRR(11)+&
                                2.D0*HRR(22))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(12,7|
      DUM=ABy*(ABy*HRR(12)+&
                                2.D0*HRR(23))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(13,7|
      DUM=ABy*(ABy*HRR(13)+&
                                2.D0*HRR(24))+&
                                HRR(40)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(14,7|
      DUM=ABy*(ABy*HRR(14)+&
                                2.D0*HRR(25))+&
                                HRR(41)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(15,7|
      DUM=ABy*(ABy*HRR(15)+&
                                2.D0*HRR(27))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(16,7|
      DUM=ABy*(ABy*HRR(16)+&
                                2.D0*HRR(28))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(17,7|
      DUM=ABy*(ABy*HRR(17)+&
                                2.D0*HRR(29))+&
                                HRR(46)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(18,7|
      DUM=ABy*(ABy*HRR(18)+&
                                2.D0*HRR(31))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(19,7|
      DUM=ABy*(ABy*HRR(19)+&
                                2.D0*HRR(32))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(20,7|
      DUM=ABy*(ABy*HRR(20)+&
                                2.D0*HRR(34))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(11,8|
      DUM=ABz*HRR(21)+&
                                ABx*(ABz*HRR(11)+&
                                HRR(26))+&
                                HRR(42)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(12,8|
      DUM=ABz*HRR(22)+&
                                ABx*(ABz*HRR(12)+&
                                HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(13,8|
      DUM=ABz*HRR(23)+&
                                ABx*(ABz*HRR(13)+&
                                HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(14,8|
      DUM=ABz*HRR(24)+&
                                ABx*(ABz*HRR(14)+&
                                HRR(29))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(15,8|
      DUM=ABz*HRR(26)+&
                                ABx*(ABz*HRR(15)+&
                                HRR(30))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(16,8|
      DUM=ABz*HRR(27)+&
                                ABx*(ABz*HRR(16)+&
                                HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(17,8|
      DUM=ABz*HRR(28)+&
                                ABx*(ABz*HRR(17)+&
                                HRR(32))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(18,8|
      DUM=ABz*HRR(30)+&
                                ABx*(ABz*HRR(18)+&
                                HRR(33))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(19,8|
      DUM=ABz*HRR(31)+&
                                ABx*(ABz*HRR(19)+&
                                HRR(34))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(20,8|
      DUM=ABz*HRR(33)+&
                                ABx*(ABz*HRR(20)+&
                                HRR(35))+&
                                HRR(54)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(11,9|
      DUM=ABz*HRR(22)+&
                                ABy*(ABz*HRR(11)+&
                                HRR(26))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(12,9|
      DUM=ABz*HRR(23)+&
                                ABy*(ABz*HRR(12)+&
                                HRR(27))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(13,9|
      DUM=ABz*HRR(24)+&
                                ABy*(ABz*HRR(13)+&
                                HRR(28))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(14,9|
      DUM=ABz*HRR(25)+&
                                ABy*(ABz*HRR(14)+&
                                HRR(29))+&
                                HRR(46)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(15,9|
      DUM=ABz*HRR(27)+&
                                ABy*(ABz*HRR(15)+&
                                HRR(30))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(16,9|
      DUM=ABz*HRR(28)+&
                                ABy*(ABz*HRR(16)+&
                                HRR(31))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(17,9|
      DUM=ABz*HRR(29)+&
                                ABy*(ABz*HRR(17)+&
                                HRR(32))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(18,9|
      DUM=ABz*HRR(31)+&
                                ABy*(ABz*HRR(18)+&
                                HRR(33))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(19,9|
      DUM=ABz*HRR(32)+&
                                ABy*(ABz*HRR(19)+&
                                HRR(34))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(20,9|
      DUM=ABz*HRR(34)+&
                                ABy*(ABz*HRR(20)+&
                                HRR(35))+&
                                HRR(55)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(11,10|
      DUM=ABz*(ABz*HRR(11)+&
                                2.D0*HRR(26))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(12,10|
      DUM=ABz*(ABz*HRR(12)+&
                                2.D0*HRR(27))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(13,10|
      DUM=ABz*(ABz*HRR(13)+&
                                2.D0*HRR(28))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(14,10|
      DUM=ABz*(ABz*HRR(14)+&
                                2.D0*HRR(29))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(15,10|
      DUM=ABz*(ABz*HRR(15)+&
                                2.D0*HRR(30))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(16,10|
      DUM=ABz*(ABz*HRR(16)+&
                                2.D0*HRR(31))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(17,10|
      DUM=ABz*(ABz*HRR(17)+&
                                2.D0*HRR(32))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(18,10|
      DUM=ABz*(ABz*HRR(18)+&
                                2.D0*HRR(33))+&
                                HRR(54)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(19,10|
      DUM=ABz*(ABz*HRR(19)+&
                                2.D0*HRR(34))+&
                                HRR(55)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(20,10|
      DUM=ABz*(ABz*HRR(20)+&
                                2.D0*HRR(35))+&
                                HRR(56)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
    END SUBROUTINE BraHRR106cd
