!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0h0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(21,24)
      V(2)=HfxZpE*VRR1(21,25)
      V(3)=HfxZpE*VRR1(21,29)
      V(4)=HfxZpE*VRR1(21,33)
      V(5)=HfxZpE*VRR1(21,34)
      V(6)=HfxZpE*VRR1(21,35)
      V(7)=HfxZpE*VRR1(22,23)
      V(8)=HfxZpE*VRR1(22,24)
      V(9)=2.D0*V(8)
      V(10)=r1x2Z*VRR0(12,44)
      V(11)=ExZpE*r1x2Z*VRR1(12,44)
      V(12)=HfxZpE*VRR1(22,28)
      V(13)=2.D0*V(12)
      V(14)=HfxZpE*VRR1(22,29)
      V(15)=HfxZpE*VRR1(22,30)
      V(16)=r1x2Z*VRR0(12,48)
      V(17)=ExZpE*r1x2Z*VRR1(12,48)
      V(18)=HfxZpE*VRR1(22,31)
      V(19)=r1x2Z*VRR0(12,49)
      V(20)=ExZpE*r1x2Z*VRR1(12,49)
      V(21)=HfxZpE*VRR1(22,32)
      V(22)=HfxZpE*VRR1(22,33)
      V(23)=HfxZpE*VRR1(22,34)
      V(24)=r1x2E*VRR0(38,12)
      V(25)=r1x2E*ZxZpE*VRR1(38,12)
      V(26)=r1x2E*VRR0(38,13)
      V(27)=HfxZpE*VRR1(23,23)
      V(28)=3.D0*V(27)
      V(29)=r1x2E*ZxZpE*VRR1(38,13)
      V(30)=r1x2E*VRR0(38,15)
      V(31)=r1x2E*ZxZpE*VRR1(38,15)
      V(32)=r1x2E*VRR0(38,16)
      V(33)=2.D0*V(32)
      V(34)=HfxZpE*VRR1(23,27)
      V(35)=r1x2E*ZxZpE*VRR1(38,16)
      V(36)=-2.D0*V(35)
      V(37)=r1x2Z*VRR0(13,44)
      V(38)=ExZpE*r1x2Z*VRR1(13,44)
      V(39)=HfxZpE*VRR1(23,28)
      V(40)=r1x2E*VRR0(38,17)
      V(41)=r1x2E*ZxZpE*VRR1(38,17)
      V(42)=r1x2E*VRR0(38,18)
      V(43)=HfxZpE*VRR1(23,30)
      V(44)=r1x2E*ZxZpE*VRR1(38,18)
      V(45)=r1x2Z*VRR0(13,48)
      V(46)=ExZpE*r1x2Z*VRR1(13,48)
      V(47)=HfxZpE*VRR1(23,31)
      V(48)=2.D0*V(47)
      V(49)=r1x2Z*VRR0(13,49)
      V(50)=ExZpE*r1x2Z*VRR1(13,49)
      V(51)=HfxZpE*VRR1(23,32)
      V(52)=r1x2E*VRR0(38,19)
      V(53)=r1x2E*ZxZpE*VRR1(38,19)
      V(54)=r1x2E*VRR0(39,12)
      V(55)=HfxZpE*VRR1(24,22)
      V(56)=2.D0*V(55)
      V(57)=r1x2E*ZxZpE*VRR1(39,12)
      V(58)=r1x2E*VRR0(39,13)
      V(59)=HfxZpE*VRR1(24,23)
      V(60)=r1x2E*ZxZpE*VRR1(39,13)
      V(61)=r1x2E*VRR0(39,15)
      V(62)=HfxZpE*VRR1(24,26)
      V(63)=r1x2E*ZxZpE*VRR1(39,15)
      V(64)=r1x2E*VRR0(39,16)
      V(65)=2.D0*V(64)
      V(66)=HfxZpE*VRR1(24,27)
      V(67)=2.D0*V(66)
      V(68)=r1x2E*ZxZpE*VRR1(39,16)
      V(69)=-2.D0*V(68)
      V(70)=r1x2E*VRR0(39,17)
      V(71)=r1x2E*ZxZpE*VRR1(39,17)
      V(72)=r1x2E*VRR0(39,18)
      V(73)=HfxZpE*VRR1(24,30)
      V(74)=r1x2E*ZxZpE*VRR1(39,18)
      V(75)=r1x2E*VRR0(39,19)
      V(76)=r1x2E*ZxZpE*VRR1(39,19)
      V(77)=HfxZpE*VRR1(25,21)
      V(78)=HfxZpE*VRR1(25,22)
      V(79)=HfxZpE*VRR1(25,26)
      V(80)=HfxZpE*VRR1(24,31)
      V(81)=HfxZpE*VRR1(24,32)
      V(82)=HfxZpE*VRR1(24,33)
      V(83)=HfxZpE*VRR1(24,34)
      V(84)=HfxZpE*VRR1(25,33)
      V(85)=HfxZpE*VRR1(25,34)
      V(86)=HfxZpE*VRR1(25,35)
      V(87)=HfxZpE*VRR1(26,23)
      V(88)=HfxZpE*VRR1(26,24)
      V(89)=r1x2Z*VRR0(15,44)
      V(90)=ExZpE*r1x2Z*VRR1(15,44)
      V(91)=HfxZpE*VRR1(26,28)
      V(92)=HfxZpE*VRR1(26,29)
      V(93)=HfxZpE*VRR1(26,30)
      V(94)=r1x2Z*VRR0(15,48)
      V(95)=ExZpE*r1x2Z*VRR1(15,48)
      V(96)=HfxZpE*VRR1(26,31)
      V(97)=2.D0*V(96)
      V(98)=r1x2Z*VRR0(15,49)
      V(99)=ExZpE*r1x2Z*VRR1(15,49)
      V(100)=HfxZpE*VRR1(26,32)
      V(101)=HfxZpE*VRR1(26,33)
      V(102)=2.D0*V(101)
      V(103)=HfxZpE*VRR1(26,34)
      V(104)=r1x2E*VRR0(43,12)
      V(105)=r1x2E*ZxZpE*VRR1(43,12)
      V(106)=r1x2E*VRR0(43,13)
      V(107)=HfxZpE*VRR1(27,23)
      V(108)=r1x2E*ZxZpE*VRR1(43,13)
      V(109)=r1x2E*VRR0(43,15)
      V(110)=r1x2E*ZxZpE*VRR1(43,15)
      V(111)=r1x2E*VRR0(43,16)
      V(112)=2.D0*V(111)
      V(113)=r1x2E*ZxZpE*VRR1(43,16)
      V(114)=-2.D0*V(113)
      V(115)=r1x2Z*VRR0(16,44)
      V(116)=2.D0*V(115)
      V(117)=ExZpE*r1x2Z*VRR1(16,44)
      V(118)=-2.D0*V(117)
      V(119)=HfxZpE*VRR1(27,28)
      V(120)=2.D0*V(119)
      V(121)=r1x2E*VRR0(43,17)
      V(122)=r1x2E*ZxZpE*VRR1(43,17)
      V(123)=r1x2E*VRR0(43,18)
      V(124)=HfxZpE*VRR1(27,30)
      V(125)=r1x2E*ZxZpE*VRR1(43,18)
      V(126)=r1x2Z*VRR0(16,48)
      V(127)=2.D0*V(126)
      V(128)=ExZpE*r1x2Z*VRR1(16,48)
      V(129)=-2.D0*V(128)
      V(130)=HfxZpE*VRR1(27,31)
      V(131)=2.D0*V(130)
      V(132)=r1x2Z*VRR0(16,49)
      V(133)=2.D0*V(132)
      V(134)=ExZpE*r1x2Z*VRR1(16,49)
      V(135)=-2.D0*V(134)
      V(136)=HfxZpE*VRR1(27,32)
      V(137)=r1x2E*VRR0(43,19)
      V(138)=r1x2E*ZxZpE*VRR1(43,19)
      V(139)=r1x2E*VRR0(44,12)
      V(140)=r1x2E*ZxZpE*VRR1(44,12)
      V(141)=r1x2E*VRR0(44,13)
      V(142)=HfxZpE*VRR1(28,23)
      V(143)=r1x2E*ZxZpE*VRR1(44,13)
      V(144)=r1x2E*VRR0(44,15)
      V(145)=r1x2E*ZxZpE*VRR1(44,15)
      V(146)=r1x2E*VRR0(44,16)
      V(147)=2.D0*V(146)
      V(148)=HfxZpE*VRR1(28,27)
      V(149)=2.D0*V(148)
      V(150)=r1x2E*ZxZpE*VRR1(44,16)
      V(151)=-2.D0*V(150)
      V(152)=r1x2E*VRR0(44,17)
      V(153)=HfxZpE*VRR1(28,28)
      V(154)=r1x2E*ZxZpE*VRR1(44,17)
      V(155)=r1x2E*VRR0(44,18)
      V(156)=HfxZpE*VRR1(28,30)
      V(157)=2.D0*V(156)
      V(158)=r1x2E*ZxZpE*VRR1(44,18)
      V(159)=r1x2E*VRR0(44,19)
      V(160)=HfxZpE*VRR1(28,31)
      V(161)=2.D0*V(160)
      V(162)=r1x2E*ZxZpE*VRR1(44,19)
      V(163)=2.D0*V(136)
      V(164)=r1x2E*VRR0(45,12)
      V(165)=HfxZpE*VRR1(29,22)
      V(166)=r1x2E*ZxZpE*VRR1(45,12)
      V(167)=r1x2E*VRR0(45,13)
      V(168)=HfxZpE*VRR1(29,23)
      V(169)=r1x2E*ZxZpE*VRR1(45,13)
      V(170)=r1x2E*VRR0(45,15)
      V(171)=HfxZpE*VRR1(29,26)
      V(172)=r1x2E*ZxZpE*VRR1(45,15)
      V(173)=r1x2E*VRR0(45,16)
      V(174)=2.D0*V(173)
      V(175)=HfxZpE*VRR1(29,27)
      V(176)=r1x2E*ZxZpE*VRR1(45,16)
      V(177)=-2.D0*V(176)
      V(178)=r1x2E*VRR0(45,17)
      V(179)=r1x2E*ZxZpE*VRR1(45,17)
      V(180)=r1x2E*VRR0(45,18)
      V(181)=HfxZpE*VRR1(29,30)
      V(182)=r1x2E*ZxZpE*VRR1(45,18)
      V(183)=r1x2E*VRR0(45,19)
      V(184)=HfxZpE*VRR1(28,32)
      V(185)=r1x2E*ZxZpE*VRR1(45,19)
      V(186)=r1x2Z*VRR0(17,44)
      V(187)=ExZpE*r1x2Z*VRR1(17,44)
      V(188)=r1x2Z*VRR0(17,48)
      V(189)=ExZpE*r1x2Z*VRR1(17,48)
      V(190)=r1x2Z*VRR0(17,49)
      V(191)=ExZpE*r1x2Z*VRR1(17,49)
      V(192)=HfxZpE*VRR1(29,31)
      V(193)=2.D0*V(192)
      V(194)=HfxZpE*VRR1(29,32)
      V(195)=HfxZpE*VRR1(29,33)
      V(196)=HfxZpE*VRR1(29,34)
      V(197)=2.D0*V(196)
      V(198)=r1x2E*VRR0(47,12)
      V(199)=r1x2E*ZxZpE*VRR1(47,12)
      V(200)=r1x2E*VRR0(47,13)
      V(201)=HfxZpE*VRR1(30,23)
      V(202)=r1x2E*ZxZpE*VRR1(47,13)
      V(203)=r1x2E*VRR0(47,15)
      V(204)=r1x2E*ZxZpE*VRR1(47,15)
      V(205)=r1x2E*VRR0(47,16)
      V(206)=2.D0*V(205)
      V(207)=HfxZpE*VRR1(30,27)
      V(208)=r1x2E*ZxZpE*VRR1(47,16)
      V(209)=-2.D0*V(208)
      V(210)=r1x2Z*VRR0(18,44)
      V(211)=ExZpE*r1x2Z*VRR1(18,44)
      V(212)=HfxZpE*VRR1(30,28)
      V(213)=2.D0*V(212)
      V(214)=r1x2E*VRR0(47,17)
      V(215)=r1x2E*ZxZpE*VRR1(47,17)
      V(216)=r1x2E*VRR0(47,18)
      V(217)=HfxZpE*VRR1(30,30)
      V(218)=3.D0*V(217)
      V(219)=r1x2E*ZxZpE*VRR1(47,18)
      V(220)=r1x2Z*VRR0(18,48)
      V(221)=ExZpE*r1x2Z*VRR1(18,48)
      V(222)=HfxZpE*VRR1(30,31)
      V(223)=r1x2Z*VRR0(18,49)
      V(224)=ExZpE*r1x2Z*VRR1(18,49)
      V(225)=HfxZpE*VRR1(30,32)
      V(226)=r1x2E*VRR0(47,19)
      V(227)=r1x2E*ZxZpE*VRR1(47,19)
      V(228)=r1x2E*VRR0(48,12)
      V(229)=r1x2E*ZxZpE*VRR1(48,12)
      V(230)=r1x2E*VRR0(48,13)
      V(231)=HfxZpE*VRR1(31,23)
      V(232)=2.D0*V(231)
      V(233)=r1x2E*ZxZpE*VRR1(48,13)
      V(234)=r1x2E*VRR0(48,15)
      V(235)=r1x2E*ZxZpE*VRR1(48,15)
      V(236)=r1x2E*VRR0(48,16)
      V(237)=2.D0*V(236)
      V(238)=HfxZpE*VRR1(31,27)
      V(239)=2.D0*V(238)
      V(240)=r1x2E*ZxZpE*VRR1(48,16)
      V(241)=-2.D0*V(240)
      V(242)=r1x2E*VRR0(48,17)
      V(243)=HfxZpE*VRR1(31,28)
      V(244)=2.D0*V(243)
      V(245)=r1x2E*ZxZpE*VRR1(48,17)
      V(246)=r1x2E*VRR0(48,18)
      V(247)=HfxZpE*VRR1(31,30)
      V(248)=r1x2E*ZxZpE*VRR1(48,18)
      V(249)=r1x2E*VRR0(48,19)
      V(250)=HfxZpE*VRR1(31,31)
      V(251)=2.D0*V(250)
      V(252)=r1x2E*ZxZpE*VRR1(48,19)
      V(253)=r1x2E*VRR0(49,12)
      V(254)=r1x2E*ZxZpE*VRR1(49,12)
      V(255)=r1x2E*VRR0(49,13)
      V(256)=HfxZpE*VRR1(32,23)
      V(257)=r1x2E*ZxZpE*VRR1(49,13)
      V(258)=r1x2E*VRR0(49,15)
      V(259)=r1x2E*ZxZpE*VRR1(49,15)
      V(260)=r1x2E*VRR0(49,16)
      V(261)=2.D0*V(260)
      V(262)=HfxZpE*VRR1(32,27)
      V(263)=r1x2E*ZxZpE*VRR1(49,16)
      V(264)=-2.D0*V(263)
      V(265)=r1x2E*VRR0(49,17)
      V(266)=HfxZpE*VRR1(32,28)
      V(267)=r1x2E*ZxZpE*VRR1(49,17)
      V(268)=r1x2E*VRR0(49,18)
      V(269)=HfxZpE*VRR1(32,30)
      V(270)=r1x2E*ZxZpE*VRR1(49,18)
      V(271)=r1x2E*VRR0(49,19)
      V(272)=HfxZpE*VRR1(32,31)
      V(273)=r1x2E*ZxZpE*VRR1(49,19)
      V(274)=HfxZpE*VRR1(31,32)
      V(275)=r1x2E*VRR0(50,12)
      V(276)=r1x2E*ZxZpE*VRR1(50,12)
      V(277)=r1x2E*VRR0(50,13)
      V(278)=r1x2E*ZxZpE*VRR1(50,13)
      V(279)=r1x2E*VRR0(50,15)
      V(280)=r1x2E*ZxZpE*VRR1(50,15)
      V(281)=r1x2E*VRR0(50,16)
      V(282)=2.D0*V(281)
      V(283)=r1x2E*ZxZpE*VRR1(50,16)
      V(284)=-2.D0*V(283)
      V(285)=r1x2Z*VRR0(19,44)
      V(286)=ExZpE*r1x2Z*VRR1(19,44)
      V(287)=2.D0*V(262)
      V(288)=r1x2E*VRR0(50,17)
      V(289)=r1x2E*ZxZpE*VRR1(50,17)
      V(290)=r1x2E*VRR0(50,18)
      V(291)=r1x2E*ZxZpE*VRR1(50,18)
      V(292)=r1x2Z*VRR0(19,48)
      V(293)=ExZpE*r1x2Z*VRR1(19,48)
      V(294)=r1x2Z*VRR0(19,49)
      V(295)=ExZpE*r1x2Z*VRR1(19,49)
      V(296)=r1x2E*VRR0(50,19)
      V(297)=HfxZpE*VRR1(32,32)
      V(298)=3.D0*V(297)
      V(299)=r1x2E*ZxZpE*VRR1(50,19)
      V(300)=r1x2E*VRR0(51,12)
      V(301)=HfxZpE*VRR1(33,22)
      V(302)=r1x2E*ZxZpE*VRR1(51,12)
      V(303)=r1x2E*VRR0(51,13)
      V(304)=HfxZpE*VRR1(33,23)
      V(305)=r1x2E*ZxZpE*VRR1(51,13)
      V(306)=r1x2E*VRR0(51,15)
      V(307)=HfxZpE*VRR1(33,26)
      V(308)=2.D0*V(307)
      V(309)=r1x2E*ZxZpE*VRR1(51,15)
      V(310)=r1x2E*VRR0(51,16)
      V(311)=2.D0*V(310)
      V(312)=HfxZpE*VRR1(33,27)
      V(313)=2.D0*V(312)
      V(314)=r1x2E*ZxZpE*VRR1(51,16)
      V(315)=-2.D0*V(314)
      V(316)=r1x2E*VRR0(51,17)
      V(317)=r1x2E*ZxZpE*VRR1(51,17)
      V(318)=r1x2E*VRR0(51,18)
      V(319)=HfxZpE*VRR1(33,30)
      V(320)=r1x2E*ZxZpE*VRR1(51,18)
      V(321)=r1x2E*VRR0(51,19)
      V(322)=r1x2E*ZxZpE*VRR1(51,19)
      V(323)=r1x2E*VRR0(52,12)
      V(324)=HfxZpE*VRR1(34,22)
      V(325)=r1x2E*ZxZpE*VRR1(52,12)
      V(326)=r1x2E*VRR0(52,13)
      V(327)=HfxZpE*VRR1(34,23)
      V(328)=r1x2E*ZxZpE*VRR1(52,13)
      V(329)=HfxZpE*VRR1(33,24)
      V(330)=r1x2E*VRR0(52,15)
      V(331)=HfxZpE*VRR1(34,26)
      V(332)=r1x2E*ZxZpE*VRR1(52,15)
      V(333)=r1x2E*VRR0(52,16)
      V(334)=2.D0*V(333)
      V(335)=HfxZpE*VRR1(34,27)
      V(336)=r1x2E*ZxZpE*VRR1(52,16)
      V(337)=-2.D0*V(336)
      V(338)=HfxZpE*VRR1(33,28)
      V(339)=r1x2E*VRR0(52,17)
      V(340)=HfxZpE*VRR1(33,29)
      V(341)=r1x2E*ZxZpE*VRR1(52,17)
      V(342)=r1x2E*VRR0(52,18)
      V(343)=HfxZpE*VRR1(34,30)
      V(344)=r1x2E*ZxZpE*VRR1(52,18)
      V(345)=r1x2E*VRR0(52,19)
      V(346)=HfxZpE*VRR1(33,32)
      V(347)=r1x2E*ZxZpE*VRR1(52,19)
      V(348)=r1x2E*VRR0(53,12)
      V(349)=r1x2E*ZxZpE*VRR1(53,12)
      V(350)=r1x2E*VRR0(53,13)
      V(351)=r1x2E*ZxZpE*VRR1(53,13)
      V(352)=HfxZpE*VRR1(34,24)
      V(353)=r1x2E*VRR0(53,15)
      V(354)=r1x2E*ZxZpE*VRR1(53,15)
      V(355)=r1x2E*VRR0(53,16)
      V(356)=2.D0*V(355)
      V(357)=r1x2E*ZxZpE*VRR1(53,16)
      V(358)=-2.D0*V(357)
      V(359)=HfxZpE*VRR1(34,28)
      V(360)=2.D0*V(359)
      V(361)=r1x2E*VRR0(53,17)
      V(362)=HfxZpE*VRR1(34,29)
      V(363)=2.D0*V(362)
      V(364)=r1x2E*ZxZpE*VRR1(53,17)
      V(365)=r1x2E*VRR0(53,18)
      V(366)=r1x2E*ZxZpE*VRR1(53,18)
      V(367)=r1x2E*VRR0(53,19)
      V(368)=HfxZpE*VRR1(34,32)
      V(369)=r1x2E*ZxZpE*VRR1(53,19)
      V(370)=HfxZpE*VRR1(35,21)
      V(371)=HfxZpE*VRR1(35,22)
      V(372)=HfxZpE*VRR1(35,26)
      V(373)=HfxZpE*VRR1(35,24)
      V(374)=HfxZpE*VRR1(35,25)
      V(375)=HfxZpE*VRR1(35,29)
      VRR0(36,36)=4.D0*r1x2E*VRR0(36,11)+QCx*VRR0(36,21)+5.D0*HfxZpE*VRR1(21,21)-4.D0*r1x2E*ZxZpE*VRR1(36,11)+WQx*VRR1(36,21)
      VRR0(36,37)=4.D0*r1x2Z*VRR0(11,37)+PAx*VRR0(21,37)-4.D0*ExZpE*r1x2Z*VRR1(11,37)+4.D0*HfxZpE*VRR1(21,22)+WPx*VRR1(21,37)
      VRR0(36,38)=4.D0*r1x2Z*VRR0(11,38)+PAx*VRR0(21,38)-4.D0*ExZpE*r1x2Z*VRR1(11,38)+3.D0*HfxZpE*VRR1(21,23)+WPx*VRR1(21,38)
      VRR0(36,39)=2.D0*V(1)+4.D0*r1x2Z*VRR0(11,39)+PAx*VRR0(21,39)-4.D0*ExZpE*r1x2Z*VRR1(11,39)+WPx*VRR1(21,39)
      VRR0(36,40)=V(2)+4.D0*r1x2Z*VRR0(11,40)+PAx*VRR0(21,40)-4.D0*ExZpE*r1x2Z*VRR1(11,40)+WPx*VRR1(21,40)
      VRR0(36,41)=4.D0*r1x2E*VRR0(36,14)+QCy*VRR0(36,25)-4.D0*r1x2E*ZxZpE*VRR1(36,14)+WQy*VRR1(36,25)
      VRR0(36,42)=4.D0*r1x2Z*VRR0(11,42)+PAx*VRR0(21,42)-4.D0*ExZpE*r1x2Z*VRR1(11,42)+4.D0*HfxZpE*VRR1(21,26)+WPx*VRR1(21,42)
      VRR0(36,43)=4.D0*r1x2Z*VRR0(11,43)+PAx*VRR0(21,43)-4.D0*ExZpE*r1x2Z*VRR1(11,43)+3.D0*HfxZpE*VRR1(21,27)+WPx*VRR1(21,43)
      VRR0(36,44)=4.D0*r1x2Z*VRR0(11,44)+PAx*VRR0(21,44)-4.D0*ExZpE*r1x2Z*VRR1(11,44)+2.D0*HfxZpE*VRR1(21,28)+WPx*VRR1(21,44)
      VRR0(36,45)=V(3)+4.D0*r1x2Z*VRR0(11,45)+PAx*VRR0(21,45)-4.D0*ExZpE*r1x2Z*VRR1(11,45)+WPx*VRR1(21,45)
      VRR0(36,46)=4.D0*r1x2Z*VRR0(11,46)+PAx*VRR0(21,46)-4.D0*ExZpE*r1x2Z*VRR1(11,46)+WPx*VRR1(21,46)
      VRR0(36,47)=4.D0*r1x2Z*VRR0(11,47)+PAx*VRR0(21,47)-4.D0*ExZpE*r1x2Z*VRR1(11,47)+3.D0*HfxZpE*VRR1(21,30)+WPx*VRR1(21,47)
      VRR0(36,48)=4.D0*r1x2Z*VRR0(11,48)+PAx*VRR0(21,48)-4.D0*ExZpE*r1x2Z*VRR1(11,48)+2.D0*HfxZpE*VRR1(21,31)+WPx*VRR1(21,48)
      VRR0(36,49)=4.D0*r1x2Z*VRR0(11,49)+PAx*VRR0(21,49)-4.D0*ExZpE*r1x2Z*VRR1(11,49)+HfxZpE*VRR1(21,32)+WPx*VRR1(21,49)
      VRR0(36,50)=4.D0*r1x2Z*VRR0(11,50)+PAx*VRR0(21,50)-4.D0*ExZpE*r1x2Z*VRR1(11,50)+WPx*VRR1(21,50)
      VRR0(36,51)=2.D0*V(4)+4.D0*r1x2Z*VRR0(11,51)+PAx*VRR0(21,51)-4.D0*ExZpE*r1x2Z*VRR1(11,51)+WPx*VRR1(21,51)
      VRR0(36,52)=V(5)+4.D0*r1x2Z*VRR0(11,52)+PAx*VRR0(21,52)-4.D0*ExZpE*r1x2Z*VRR1(11,52)+WPx*VRR1(21,52)
      VRR0(36,53)=4.D0*r1x2Z*VRR0(11,53)+PAx*VRR0(21,53)-4.D0*ExZpE*r1x2Z*VRR1(11,53)+WPx*VRR1(21,53)
      VRR0(36,54)=V(6)+4.D0*r1x2Z*VRR0(11,54)+PAx*VRR0(21,54)-4.D0*ExZpE*r1x2Z*VRR1(11,54)+WPx*VRR1(21,54)
      VRR0(36,55)=4.D0*r1x2Z*VRR0(11,55)+PAx*VRR0(21,55)-4.D0*ExZpE*r1x2Z*VRR1(11,55)+WPx*VRR1(21,55)
      VRR0(36,56)=4.D0*r1x2E*VRR0(36,20)+QCz*VRR0(36,35)-4.D0*r1x2E*ZxZpE*VRR1(36,20)+WQz*VRR1(36,35)
      VRR0(37,36)=4.D0*r1x2E*VRR0(37,11)+QCx*VRR0(37,21)+4.D0*HfxZpE*VRR1(22,21)-4.D0*r1x2E*ZxZpE*VRR1(37,11)+WQx*VRR1(37,21)
      VRR0(37,37)=3.D0*r1x2E*VRR0(37,12)+QCx*VRR0(37,22)+4.D0*HfxZpE*VRR1(22,22)-3.D0*r1x2E*ZxZpE*VRR1(37,12)+WQx*VRR1(37,22)
      VRR0(37,38)=3.D0*V(7)+3.D0*r1x2Z*VRR0(12,38)+PAx*VRR0(22,38)-3.D0*ExZpE*r1x2Z*VRR1(12,38)+WPx*VRR1(22,38)
      VRR0(37,39)=V(9)+3.D0*r1x2Z*VRR0(12,39)+PAx*VRR0(22,39)-3.D0*ExZpE*r1x2Z*VRR1(12,39)+WPx*VRR1(22,39)
      VRR0(37,40)=V(1)+3.D0*r1x2E*VRR0(37,13)+QCy*VRR0(37,24)-3.D0*r1x2E*ZxZpE*VRR1(37,13)+WQy*VRR1(37,24)
      VRR0(37,41)=V(2)+4.D0*r1x2E*VRR0(37,14)+QCy*VRR0(37,25)-4.D0*r1x2E*ZxZpE*VRR1(37,14)+WQy*VRR1(37,25)
      VRR0(37,42)=3.D0*r1x2E*VRR0(37,15)+QCx*VRR0(37,26)+4.D0*HfxZpE*VRR1(22,26)-3.D0*r1x2E*ZxZpE*VRR1(37,15)+WQx*VRR1(37,26)
      VRR0(37,43)=3.D0*r1x2Z*VRR0(12,43)+PAx*VRR0(22,43)-3.D0*ExZpE*r1x2Z*VRR1(12,43)+3.D0*HfxZpE*VRR1(22,27)+WPx*VRR1(22,43)
      VRR0(37,44)=3.D0*V(10)-3.D0*V(11)+V(13)+PAx*VRR0(22,44)+WPx*VRR1(22,44)
      VRR0(37,45)=V(14)+3.D0*r1x2Z*VRR0(12,45)+PAx*VRR0(22,45)-3.D0*ExZpE*r1x2Z*VRR1(12,45)+WPx*VRR1(22,45)
      VRR0(37,46)=V(3)+3.D0*r1x2E*VRR0(37,17)+QCy*VRR0(37,29)-3.D0*r1x2E*ZxZpE*VRR1(37,17)+WQy*VRR1(37,29)
      VRR0(37,47)=3.D0*V(15)+3.D0*r1x2Z*VRR0(12,47)+PAx*VRR0(22,47)-3.D0*ExZpE*r1x2Z*VRR1(12,47)+WPx*VRR1(22,47)
      VRR0(37,48)=3.D0*V(16)-3.D0*V(17)+2.D0*V(18)+PAx*VRR0(22,48)+WPx*VRR1(22,48)
      VRR0(37,49)=3.D0*V(19)-3.D0*V(20)+V(21)+PAx*VRR0(22,49)+WPx*VRR1(22,49)
      VRR0(37,50)=3.D0*r1x2Z*VRR0(12,50)+PAx*VRR0(22,50)-3.D0*ExZpE*r1x2Z*VRR1(12,50)+WPx*VRR1(22,50)
      VRR0(37,51)=2.D0*V(22)+3.D0*r1x2Z*VRR0(12,51)+PAx*VRR0(22,51)-3.D0*ExZpE*r1x2Z*VRR1(12,51)+WPx*VRR1(22,51)
      VRR0(37,52)=V(23)+3.D0*r1x2Z*VRR0(12,52)+PAx*VRR0(22,52)-3.D0*ExZpE*r1x2Z*VRR1(12,52)+WPx*VRR1(22,52)
      VRR0(37,53)=3.D0*r1x2Z*VRR0(12,53)+PAx*VRR0(22,53)-3.D0*ExZpE*r1x2Z*VRR1(12,53)+WPx*VRR1(22,53)
      VRR0(37,54)=3.D0*r1x2E*VRR0(37,18)+QCz*VRR0(37,33)-3.D0*r1x2E*ZxZpE*VRR1(37,18)+WQz*VRR1(37,33)
      VRR0(37,55)=3.D0*r1x2E*VRR0(37,19)+QCz*VRR0(37,34)-3.D0*r1x2E*ZxZpE*VRR1(37,19)+WQz*VRR1(37,34)
      VRR0(37,56)=4.D0*r1x2E*VRR0(37,20)+QCz*VRR0(37,35)-4.D0*r1x2E*ZxZpE*VRR1(37,20)+WQz*VRR1(37,35)
      VRR0(38,36)=4.D0*r1x2E*VRR0(38,11)+QCx*VRR0(38,21)+3.D0*HfxZpE*VRR1(23,21)-4.D0*r1x2E*ZxZpE*VRR1(38,11)+WQx*VRR1(38,21)
      VRR0(38,37)=3.D0*V(24)-3.D0*V(25)+QCx*VRR0(38,22)+3.D0*HfxZpE*VRR1(23,22)+WQx*VRR1(38,22)
      VRR0(38,38)=2.D0*V(26)+V(28)-2.D0*V(29)+QCx*VRR0(38,23)+WQx*VRR1(38,23)
      VRR0(38,39)=2.D0*V(7)+2.D0*V(24)-2.D0*V(25)+QCy*VRR0(38,23)+WQy*VRR1(38,23)
      VRR0(38,40)=V(9)+3.D0*V(26)-3.D0*V(29)+QCy*VRR0(38,24)+WQy*VRR1(38,24)
      VRR0(38,41)=4.D0*r1x2E*VRR0(38,14)+QCy*VRR0(38,25)+2.D0*HfxZpE*VRR1(22,25)-4.D0*r1x2E*ZxZpE*VRR1(38,14)+WQy*VRR1(38,25)
      VRR0(38,42)=3.D0*V(30)-3.D0*V(31)+QCx*VRR0(38,26)+3.D0*HfxZpE*VRR1(23,26)+WQx*VRR1(38,26)
      VRR0(38,43)=V(33)+3.D0*V(34)+V(36)+QCx*VRR0(38,27)+WQx*VRR1(38,27)
      VRR0(38,44)=2.D0*V(37)-2.D0*V(38)+2.D0*V(39)+PAx*VRR0(23,44)+WPx*VRR1(23,44)
      VRR0(38,45)=V(13)+V(33)+V(36)+QCy*VRR0(38,28)+WQy*VRR1(38,28)
      VRR0(38,46)=2.D0*V(14)+3.D0*V(40)-3.D0*V(41)+QCy*VRR0(38,29)+WQy*VRR1(38,29)
      VRR0(38,47)=2.D0*V(42)+3.D0*V(43)-2.D0*V(44)+QCx*VRR0(38,30)+WQx*VRR1(38,30)
      VRR0(38,48)=2.D0*V(45)-2.D0*V(46)+V(48)+PAx*VRR0(23,48)+WPx*VRR1(23,48)
      VRR0(38,49)=2.D0*V(49)-2.D0*V(50)+V(51)+PAx*VRR0(23,49)+WPx*VRR1(23,49)
      VRR0(38,50)=2.D0*V(21)+2.D0*V(52)-2.D0*V(53)+QCy*VRR0(38,32)+WQy*VRR1(38,32)
      VRR0(38,51)=2.D0*V(30)-2.D0*V(31)+QCz*VRR0(38,30)+WQz*VRR1(38,30)
      VRR0(38,52)=V(33)+V(36)+QCz*VRR0(38,31)+WQz*VRR1(38,31)
      VRR0(38,53)=2.D0*V(40)-2.D0*V(41)+QCz*VRR0(38,32)+WQz*VRR1(38,32)
      VRR0(38,54)=3.D0*V(42)-3.D0*V(44)+QCz*VRR0(38,33)+WQz*VRR1(38,33)
      VRR0(38,55)=3.D0*V(52)-3.D0*V(53)+QCz*VRR0(38,34)+WQz*VRR1(38,34)
      VRR0(38,56)=4.D0*r1x2E*VRR0(38,20)+QCz*VRR0(38,35)-4.D0*r1x2E*ZxZpE*VRR1(38,20)+WQz*VRR1(38,35)
      VRR0(39,36)=4.D0*r1x2E*VRR0(39,11)+QCx*VRR0(39,21)+2.D0*HfxZpE*VRR1(24,21)-4.D0*r1x2E*ZxZpE*VRR1(39,11)+WQx*VRR1(39,21)
      VRR0(39,37)=3.D0*V(54)+V(56)-3.D0*V(57)+QCx*VRR0(39,22)+WQx*VRR1(39,22)
      VRR0(39,38)=2.D0*V(58)+2.D0*V(59)-2.D0*V(60)+QCx*VRR0(39,23)+WQx*VRR1(39,23)
      VRR0(39,39)=V(28)+2.D0*V(54)-2.D0*V(57)+QCy*VRR0(39,23)+WQy*VRR1(39,23)
      VRR0(39,40)=3.D0*V(58)-3.D0*V(60)+QCy*VRR0(39,24)+3.D0*HfxZpE*VRR1(23,24)+WQy*VRR1(39,24)
      VRR0(39,41)=4.D0*r1x2E*VRR0(39,14)+QCy*VRR0(39,25)+3.D0*HfxZpE*VRR1(23,25)-4.D0*r1x2E*ZxZpE*VRR1(39,14)+WQy*VRR1(39,25)
      VRR0(39,42)=3.D0*V(61)+2.D0*V(62)-3.D0*V(63)+QCx*VRR0(39,26)+WQx*VRR1(39,26)
      VRR0(39,43)=V(65)+V(67)+V(69)+QCx*VRR0(39,27)+WQx*VRR1(39,27)
      VRR0(39,44)=2.D0*V(10)-2.D0*V(11)+2.D0*V(34)+PAy*VRR0(23,44)+WPy*VRR1(23,44)
      VRR0(39,45)=3.D0*V(39)+V(65)+V(69)+QCy*VRR0(39,28)+WQy*VRR1(39,28)
      VRR0(39,46)=3.D0*V(70)-3.D0*V(71)+QCy*VRR0(39,29)+3.D0*HfxZpE*VRR1(23,29)+WQy*VRR1(39,29)
      VRR0(39,47)=2.D0*V(72)+2.D0*V(73)-2.D0*V(74)+QCx*VRR0(39,30)+WQx*VRR1(39,30)
      VRR0(39,48)=2.D0*V(16)-2.D0*V(17)+V(43)+PAy*VRR0(23,48)+WPy*VRR1(23,48)
      VRR0(39,49)=2.D0*V(19)-2.D0*V(20)+V(48)+PAy*VRR0(23,49)+WPy*VRR1(23,49)
      VRR0(39,50)=3.D0*V(51)+2.D0*V(75)-2.D0*V(76)+QCy*VRR0(39,32)+WQy*VRR1(39,32)
      VRR0(39,51)=2.D0*V(61)-2.D0*V(63)+QCz*VRR0(39,30)+WQz*VRR1(39,30)
      VRR0(39,52)=V(65)+V(69)+QCz*VRR0(39,31)+WQz*VRR1(39,31)
      VRR0(39,53)=2.D0*V(70)-2.D0*V(71)+QCz*VRR0(39,32)+WQz*VRR1(39,32)
      VRR0(39,54)=3.D0*V(72)-3.D0*V(74)+QCz*VRR0(39,33)+WQz*VRR1(39,33)
      VRR0(39,55)=3.D0*V(75)-3.D0*V(76)+QCz*VRR0(39,34)+WQz*VRR1(39,34)
      VRR0(39,56)=4.D0*r1x2E*VRR0(39,20)+QCz*VRR0(39,35)-4.D0*r1x2E*ZxZpE*VRR1(39,20)+WQz*VRR1(39,35)
      VRR0(40,36)=V(77)+4.D0*r1x2E*VRR0(40,11)+QCx*VRR0(40,21)-4.D0*r1x2E*ZxZpE*VRR1(40,11)+WQx*VRR1(40,21)
      VRR0(40,37)=V(78)+3.D0*r1x2E*VRR0(40,12)+QCx*VRR0(40,22)-3.D0*r1x2E*ZxZpE*VRR1(40,12)+WQx*VRR1(40,22)
      VRR0(40,38)=V(56)+3.D0*r1x2Z*VRR0(13,38)+PAy*VRR0(24,38)-3.D0*ExZpE*r1x2Z*VRR1(13,38)+WPy*VRR1(24,38)
      VRR0(40,39)=3.D0*V(59)+3.D0*r1x2Z*VRR0(13,39)+PAy*VRR0(24,39)-3.D0*ExZpE*r1x2Z*VRR1(13,39)+WPy*VRR1(24,39)
      VRR0(40,40)=3.D0*r1x2E*VRR0(40,13)+QCy*VRR0(40,24)+4.D0*HfxZpE*VRR1(24,24)-3.D0*r1x2E*ZxZpE*VRR1(40,13)+WQy*VRR1(40,24)
      VRR0(40,41)=4.D0*r1x2E*VRR0(40,14)+QCy*VRR0(40,25)+4.D0*HfxZpE*VRR1(24,25)-4.D0*r1x2E*ZxZpE*VRR1(40,14)+WQy*VRR1(40,25)
      VRR0(40,42)=V(79)+3.D0*r1x2E*VRR0(40,15)+QCx*VRR0(40,26)-3.D0*r1x2E*ZxZpE*VRR1(40,15)+WQx*VRR1(40,26)
      VRR0(40,43)=V(62)+3.D0*r1x2Z*VRR0(13,43)+PAy*VRR0(24,43)-3.D0*ExZpE*r1x2Z*VRR1(13,43)+WPy*VRR1(24,43)
      VRR0(40,44)=3.D0*V(37)-3.D0*V(38)+V(67)+PAy*VRR0(24,44)+WPy*VRR1(24,44)
      VRR0(40,45)=3.D0*r1x2Z*VRR0(13,45)+PAy*VRR0(24,45)-3.D0*ExZpE*r1x2Z*VRR1(13,45)+3.D0*HfxZpE*VRR1(24,28)+WPy*VRR1(24,45)
      VRR0(40,46)=3.D0*r1x2E*VRR0(40,17)+QCy*VRR0(40,29)+4.D0*HfxZpE*VRR1(24,29)-3.D0*r1x2E*ZxZpE*VRR1(40,17)+WQy*VRR1(40,29)
      VRR0(40,47)=3.D0*r1x2Z*VRR0(13,47)+PAy*VRR0(24,47)-3.D0*ExZpE*r1x2Z*VRR1(13,47)+WPy*VRR1(24,47)
      VRR0(40,48)=3.D0*V(45)-3.D0*V(46)+V(73)+PAy*VRR0(24,48)+WPy*VRR1(24,48)
      VRR0(40,49)=3.D0*V(49)-3.D0*V(50)+2.D0*V(80)+PAy*VRR0(24,49)+WPy*VRR1(24,49)
      VRR0(40,50)=3.D0*V(81)+3.D0*r1x2Z*VRR0(13,50)+PAy*VRR0(24,50)-3.D0*ExZpE*r1x2Z*VRR1(13,50)+WPy*VRR1(24,50)
      VRR0(40,51)=3.D0*r1x2Z*VRR0(13,51)+PAy*VRR0(24,51)-3.D0*ExZpE*r1x2Z*VRR1(13,51)+WPy*VRR1(24,51)
      VRR0(40,52)=V(82)+3.D0*r1x2Z*VRR0(13,52)+PAy*VRR0(24,52)-3.D0*ExZpE*r1x2Z*VRR1(13,52)+WPy*VRR1(24,52)
      VRR0(40,53)=2.D0*V(83)+3.D0*r1x2Z*VRR0(13,53)+PAy*VRR0(24,53)-3.D0*ExZpE*r1x2Z*VRR1(13,53)+WPy*VRR1(24,53)
      VRR0(40,54)=3.D0*r1x2E*VRR0(40,18)+QCz*VRR0(40,33)-3.D0*r1x2E*ZxZpE*VRR1(40,18)+WQz*VRR1(40,33)
      VRR0(40,55)=3.D0*r1x2E*VRR0(40,19)+QCz*VRR0(40,34)-3.D0*r1x2E*ZxZpE*VRR1(40,19)+WQz*VRR1(40,34)
      VRR0(40,56)=4.D0*r1x2E*VRR0(40,20)+QCz*VRR0(40,35)-4.D0*r1x2E*ZxZpE*VRR1(40,20)+WQz*VRR1(40,35)
      VRR0(41,36)=4.D0*r1x2E*VRR0(41,11)+QCx*VRR0(41,21)-4.D0*r1x2E*ZxZpE*VRR1(41,11)+WQx*VRR1(41,21)
      VRR0(41,37)=V(77)+4.D0*r1x2Z*VRR0(14,37)+PAy*VRR0(25,37)-4.D0*ExZpE*r1x2Z*VRR1(14,37)+WPy*VRR1(25,37)
      VRR0(41,38)=2.D0*V(78)+4.D0*r1x2Z*VRR0(14,38)+PAy*VRR0(25,38)-4.D0*ExZpE*r1x2Z*VRR1(14,38)+WPy*VRR1(25,38)
      VRR0(41,39)=4.D0*r1x2Z*VRR0(14,39)+PAy*VRR0(25,39)-4.D0*ExZpE*r1x2Z*VRR1(14,39)+3.D0*HfxZpE*VRR1(25,23)+WPy*VRR1(25,39)
      VRR0(41,40)=4.D0*r1x2Z*VRR0(14,40)+PAy*VRR0(25,40)-4.D0*ExZpE*r1x2Z*VRR1(14,40)+4.D0*HfxZpE*VRR1(25,24)+WPy*VRR1(25,40)
      VRR0(41,41)=4.D0*r1x2E*VRR0(41,14)+QCy*VRR0(41,25)+5.D0*HfxZpE*VRR1(25,25)-4.D0*r1x2E*ZxZpE*VRR1(41,14)+WQy*VRR1(41,25)
      VRR0(41,42)=4.D0*r1x2Z*VRR0(14,42)+PAy*VRR0(25,42)-4.D0*ExZpE*r1x2Z*VRR1(14,42)+WPy*VRR1(25,42)
      VRR0(41,43)=V(79)+4.D0*r1x2Z*VRR0(14,43)+PAy*VRR0(25,43)-4.D0*ExZpE*r1x2Z*VRR1(14,43)+WPy*VRR1(25,43)
      VRR0(41,44)=4.D0*r1x2Z*VRR0(14,44)+PAy*VRR0(25,44)-4.D0*ExZpE*r1x2Z*VRR1(14,44)+2.D0*HfxZpE*VRR1(25,27)+WPy*VRR1(25,44)
      VRR0(41,45)=4.D0*r1x2Z*VRR0(14,45)+PAy*VRR0(25,45)-4.D0*ExZpE*r1x2Z*VRR1(14,45)+3.D0*HfxZpE*VRR1(25,28)+WPy*VRR1(25,45)
      VRR0(41,46)=4.D0*r1x2Z*VRR0(14,46)+PAy*VRR0(25,46)-4.D0*ExZpE*r1x2Z*VRR1(14,46)+4.D0*HfxZpE*VRR1(25,29)+WPy*VRR1(25,46)
      VRR0(41,47)=4.D0*r1x2Z*VRR0(14,47)+PAy*VRR0(25,47)-4.D0*ExZpE*r1x2Z*VRR1(14,47)+WPy*VRR1(25,47)
      VRR0(41,48)=4.D0*r1x2Z*VRR0(14,48)+PAy*VRR0(25,48)-4.D0*ExZpE*r1x2Z*VRR1(14,48)+HfxZpE*VRR1(25,30)+WPy*VRR1(25,48)
      VRR0(41,49)=4.D0*r1x2Z*VRR0(14,49)+PAy*VRR0(25,49)-4.D0*ExZpE*r1x2Z*VRR1(14,49)+2.D0*HfxZpE*VRR1(25,31)+WPy*VRR1(25,49)
      VRR0(41,50)=4.D0*r1x2Z*VRR0(14,50)+PAy*VRR0(25,50)-4.D0*ExZpE*r1x2Z*VRR1(14,50)+3.D0*HfxZpE*VRR1(25,32)+WPy*VRR1(25,50)
      VRR0(41,51)=4.D0*r1x2Z*VRR0(14,51)+PAy*VRR0(25,51)-4.D0*ExZpE*r1x2Z*VRR1(14,51)+WPy*VRR1(25,51)
      VRR0(41,52)=V(84)+4.D0*r1x2Z*VRR0(14,52)+PAy*VRR0(25,52)-4.D0*ExZpE*r1x2Z*VRR1(14,52)+WPy*VRR1(25,52)
      VRR0(41,53)=2.D0*V(85)+4.D0*r1x2Z*VRR0(14,53)+PAy*VRR0(25,53)-4.D0*ExZpE*r1x2Z*VRR1(14,53)+WPy*VRR1(25,53)
      VRR0(41,54)=4.D0*r1x2Z*VRR0(14,54)+PAy*VRR0(25,54)-4.D0*ExZpE*r1x2Z*VRR1(14,54)+WPy*VRR1(25,54)
      VRR0(41,55)=V(86)+4.D0*r1x2Z*VRR0(14,55)+PAy*VRR0(25,55)-4.D0*ExZpE*r1x2Z*VRR1(14,55)+WPy*VRR1(25,55)
      VRR0(41,56)=4.D0*r1x2E*VRR0(41,20)+QCz*VRR0(41,35)-4.D0*r1x2E*ZxZpE*VRR1(41,20)+WQz*VRR1(41,35)
      VRR0(42,36)=4.D0*r1x2E*VRR0(42,11)+QCx*VRR0(42,21)+4.D0*HfxZpE*VRR1(26,21)-4.D0*r1x2E*ZxZpE*VRR1(42,11)+WQx*VRR1(42,21)
      VRR0(42,37)=3.D0*r1x2E*VRR0(42,12)+QCx*VRR0(42,22)+4.D0*HfxZpE*VRR1(26,22)-3.D0*r1x2E*ZxZpE*VRR1(42,12)+WQx*VRR1(42,22)
      VRR0(42,38)=3.D0*V(87)+3.D0*r1x2Z*VRR0(15,38)+PAx*VRR0(26,38)-3.D0*ExZpE*r1x2Z*VRR1(15,38)+WPx*VRR1(26,38)
      VRR0(42,39)=2.D0*V(88)+3.D0*r1x2Z*VRR0(15,39)+PAx*VRR0(26,39)-3.D0*ExZpE*r1x2Z*VRR1(15,39)+WPx*VRR1(26,39)
      VRR0(42,40)=3.D0*r1x2E*VRR0(42,13)+QCy*VRR0(42,24)-3.D0*r1x2E*ZxZpE*VRR1(42,13)+WQy*VRR1(42,24)
      VRR0(42,41)=4.D0*r1x2E*VRR0(42,14)+QCy*VRR0(42,25)-4.D0*r1x2E*ZxZpE*VRR1(42,14)+WQy*VRR1(42,25)
      VRR0(42,42)=3.D0*r1x2E*VRR0(42,15)+QCx*VRR0(42,26)+4.D0*HfxZpE*VRR1(26,26)-3.D0*r1x2E*ZxZpE*VRR1(42,15)+WQx*VRR1(42,26)
      VRR0(42,43)=3.D0*r1x2Z*VRR0(15,43)+PAx*VRR0(26,43)-3.D0*ExZpE*r1x2Z*VRR1(15,43)+3.D0*HfxZpE*VRR1(26,27)+WPx*VRR1(26,43)
      VRR0(42,44)=3.D0*V(89)-3.D0*V(90)+2.D0*V(91)+PAx*VRR0(26,44)+WPx*VRR1(26,44)
      VRR0(42,45)=V(92)+3.D0*r1x2Z*VRR0(15,45)+PAx*VRR0(26,45)-3.D0*ExZpE*r1x2Z*VRR1(15,45)+WPx*VRR1(26,45)
      VRR0(42,46)=3.D0*r1x2E*VRR0(42,17)+QCy*VRR0(42,29)-3.D0*r1x2E*ZxZpE*VRR1(42,17)+WQy*VRR1(42,29)
      VRR0(42,47)=3.D0*V(93)+3.D0*r1x2Z*VRR0(15,47)+PAx*VRR0(26,47)-3.D0*ExZpE*r1x2Z*VRR1(15,47)+WPx*VRR1(26,47)
      VRR0(42,48)=3.D0*V(94)-3.D0*V(95)+V(97)+PAx*VRR0(26,48)+WPx*VRR1(26,48)
      VRR0(42,49)=3.D0*V(98)-3.D0*V(99)+V(100)+PAx*VRR0(26,49)+WPx*VRR1(26,49)
      VRR0(42,50)=3.D0*r1x2Z*VRR0(15,50)+PAx*VRR0(26,50)-3.D0*ExZpE*r1x2Z*VRR1(15,50)+WPx*VRR1(26,50)
      VRR0(42,51)=V(102)+3.D0*r1x2Z*VRR0(15,51)+PAx*VRR0(26,51)-3.D0*ExZpE*r1x2Z*VRR1(15,51)+WPx*VRR1(26,51)
      VRR0(42,52)=V(103)+3.D0*r1x2Z*VRR0(15,52)+PAx*VRR0(26,52)-3.D0*ExZpE*r1x2Z*VRR1(15,52)+WPx*VRR1(26,52)
      VRR0(42,53)=3.D0*r1x2Z*VRR0(15,53)+PAx*VRR0(26,53)-3.D0*ExZpE*r1x2Z*VRR1(15,53)+WPx*VRR1(26,53)
      VRR0(42,54)=V(4)+3.D0*r1x2E*VRR0(42,18)+QCz*VRR0(42,33)-3.D0*r1x2E*ZxZpE*VRR1(42,18)+WQz*VRR1(42,33)
      VRR0(42,55)=V(5)+3.D0*r1x2E*VRR0(42,19)+QCz*VRR0(42,34)-3.D0*r1x2E*ZxZpE*VRR1(42,19)+WQz*VRR1(42,34)
      VRR0(42,56)=V(6)+4.D0*r1x2E*VRR0(42,20)+QCz*VRR0(42,35)-4.D0*r1x2E*ZxZpE*VRR1(42,20)+WQz*VRR1(42,35)
      VRR0(43,36)=4.D0*r1x2E*VRR0(43,11)+QCx*VRR0(43,21)+3.D0*HfxZpE*VRR1(27,21)-4.D0*r1x2E*ZxZpE*VRR1(43,11)+WQx*VRR1(43,21)
      VRR0(43,37)=3.D0*V(104)-3.D0*V(105)+QCx*VRR0(43,22)+3.D0*HfxZpE*VRR1(27,22)+WQx*VRR1(43,22)
      VRR0(43,38)=2.D0*V(106)+3.D0*V(107)-2.D0*V(108)+QCx*VRR0(43,23)+WQx*VRR1(43,23)
      VRR0(43,39)=V(87)+2.D0*V(104)-2.D0*V(105)+QCy*VRR0(43,23)+WQy*VRR1(43,23)
      VRR0(43,40)=V(88)+3.D0*V(106)-3.D0*V(108)+QCy*VRR0(43,24)+WQy*VRR1(43,24)
      VRR0(43,41)=4.D0*r1x2E*VRR0(43,14)+QCy*VRR0(43,25)+HfxZpE*VRR1(26,25)-4.D0*r1x2E*ZxZpE*VRR1(43,14)+WQy*VRR1(43,25)
      VRR0(43,42)=3.D0*V(109)-3.D0*V(110)+QCx*VRR0(43,26)+3.D0*HfxZpE*VRR1(27,26)+WQx*VRR1(43,26)
      VRR0(43,43)=V(112)+V(114)+QCx*VRR0(43,27)+3.D0*HfxZpE*VRR1(27,27)+WQx*VRR1(43,27)
      VRR0(43,44)=V(116)+V(118)+V(120)+PAx*VRR0(27,44)+WPx*VRR1(27,44)
      VRR0(43,45)=V(91)+V(112)+V(114)+QCy*VRR0(43,28)+WQy*VRR1(43,28)
      VRR0(43,46)=V(92)+3.D0*V(121)-3.D0*V(122)+QCy*VRR0(43,29)+WQy*VRR1(43,29)
      VRR0(43,47)=2.D0*V(123)+3.D0*V(124)-2.D0*V(125)+QCx*VRR0(43,30)+WQx*VRR1(43,30)
      VRR0(43,48)=V(127)+V(129)+V(131)+PAx*VRR0(27,48)+WPx*VRR1(27,48)
      VRR0(43,49)=V(133)+V(135)+V(136)+PAx*VRR0(27,49)+WPx*VRR1(27,49)
      VRR0(43,50)=V(100)+2.D0*V(137)-2.D0*V(138)+QCy*VRR0(43,32)+WQy*VRR1(43,32)
      VRR0(43,51)=V(15)+2.D0*V(109)-2.D0*V(110)+QCz*VRR0(43,30)+WQz*VRR1(43,30)
      VRR0(43,52)=V(18)+V(112)+V(114)+QCz*VRR0(43,31)+WQz*VRR1(43,31)
      VRR0(43,53)=V(21)+2.D0*V(121)-2.D0*V(122)+QCz*VRR0(43,32)+WQz*VRR1(43,32)
      VRR0(43,54)=V(22)+3.D0*V(123)-3.D0*V(125)+QCz*VRR0(43,33)+WQz*VRR1(43,33)
      VRR0(43,55)=V(23)+3.D0*V(137)-3.D0*V(138)+QCz*VRR0(43,34)+WQz*VRR1(43,34)
      VRR0(43,56)=4.D0*r1x2E*VRR0(43,20)+QCz*VRR0(43,35)+HfxZpE*VRR1(22,35)-4.D0*r1x2E*ZxZpE*VRR1(43,20)+WQz*VRR1(43,35)
      VRR0(44,36)=4.D0*r1x2E*VRR0(44,11)+QCx*VRR0(44,21)+2.D0*HfxZpE*VRR1(28,21)-4.D0*r1x2E*ZxZpE*VRR1(44,11)+WQx*VRR1(44,21)
      VRR0(44,37)=3.D0*V(139)-3.D0*V(140)+QCx*VRR0(44,22)+2.D0*HfxZpE*VRR1(28,22)+WQx*VRR1(44,22)
      VRR0(44,38)=2.D0*V(141)+2.D0*V(142)-2.D0*V(143)+QCx*VRR0(44,23)+WQx*VRR1(44,23)
      VRR0(44,39)=2.D0*V(107)+2.D0*V(139)-2.D0*V(140)+QCy*VRR0(44,23)+WQy*VRR1(44,23)
      VRR0(44,40)=3.D0*V(141)-3.D0*V(143)+QCy*VRR0(44,24)+2.D0*HfxZpE*VRR1(27,24)+WQy*VRR1(44,24)
      VRR0(44,41)=4.D0*r1x2E*VRR0(44,14)+QCy*VRR0(44,25)+2.D0*HfxZpE*VRR1(27,25)-4.D0*r1x2E*ZxZpE*VRR1(44,14)+WQy*VRR1(44,25)
      VRR0(44,42)=3.D0*V(144)-3.D0*V(145)+QCx*VRR0(44,26)+2.D0*HfxZpE*VRR1(28,26)+WQx*VRR1(44,26)
      VRR0(44,43)=V(147)+V(149)+V(151)+QCx*VRR0(44,27)+WQx*VRR1(44,27)
      VRR0(44,44)=V(152)+2.D0*V(153)-V(154)+QCx*VRR0(44,28)+WQx*VRR1(44,28)
      VRR0(44,45)=V(120)+V(147)+V(151)+QCy*VRR0(44,28)+WQy*VRR1(44,28)
      VRR0(44,46)=3.D0*V(152)-3.D0*V(154)+QCy*VRR0(44,29)+2.D0*HfxZpE*VRR1(27,29)+WQy*VRR1(44,29)
      VRR0(44,47)=2.D0*V(155)+V(157)-2.D0*V(158)+QCx*VRR0(44,30)+WQx*VRR1(44,30)
      VRR0(44,48)=V(159)+V(161)-V(162)+QCx*VRR0(44,31)+WQx*VRR1(44,31)
      VRR0(44,49)=V(131)+V(155)-V(158)+QCy*VRR0(44,31)+WQy*VRR1(44,31)
      VRR0(44,50)=2.D0*V(159)-2.D0*V(162)+V(163)+QCy*VRR0(44,32)+WQy*VRR1(44,32)
      VRR0(44,51)=V(43)+2.D0*V(144)-2.D0*V(145)+QCz*VRR0(44,30)+WQz*VRR1(44,30)
      VRR0(44,52)=V(47)+V(147)+V(151)+QCz*VRR0(44,31)+WQz*VRR1(44,31)
      VRR0(44,53)=V(51)+2.D0*V(152)-2.D0*V(154)+QCz*VRR0(44,32)+WQz*VRR1(44,32)
      VRR0(44,54)=3.D0*V(155)-3.D0*V(158)+QCz*VRR0(44,33)+HfxZpE*VRR1(23,33)+WQz*VRR1(44,33)
      VRR0(44,55)=3.D0*V(159)-3.D0*V(162)+QCz*VRR0(44,34)+HfxZpE*VRR1(23,34)+WQz*VRR1(44,34)
      VRR0(44,56)=4.D0*r1x2E*VRR0(44,20)+QCz*VRR0(44,35)+HfxZpE*VRR1(23,35)-4.D0*r1x2E*ZxZpE*VRR1(44,20)+WQz*VRR1(44,35)
      VRR0(45,36)=4.D0*r1x2E*VRR0(45,11)+QCx*VRR0(45,21)+HfxZpE*VRR1(29,21)-4.D0*r1x2E*ZxZpE*VRR1(45,11)+WQx*VRR1(45,21)
      VRR0(45,37)=3.D0*V(164)+V(165)-3.D0*V(166)+QCx*VRR0(45,22)+WQx*VRR1(45,22)
      VRR0(45,38)=2.D0*V(167)+V(168)-2.D0*V(169)+QCx*VRR0(45,23)+WQx*VRR1(45,23)
      VRR0(45,39)=3.D0*V(142)+2.D0*V(164)-2.D0*V(166)+QCy*VRR0(45,23)+WQy*VRR1(45,23)
      VRR0(45,40)=3.D0*V(167)-3.D0*V(169)+QCy*VRR0(45,24)+3.D0*HfxZpE*VRR1(28,24)+WQy*VRR1(45,24)
      VRR0(45,41)=4.D0*r1x2E*VRR0(45,14)+QCy*VRR0(45,25)+3.D0*HfxZpE*VRR1(28,25)-4.D0*r1x2E*ZxZpE*VRR1(45,14)+WQy*VRR1(45,25)
      VRR0(45,42)=3.D0*V(170)+V(171)-3.D0*V(172)+QCx*VRR0(45,26)+WQx*VRR1(45,26)
      VRR0(45,43)=V(174)+V(175)+V(177)+QCx*VRR0(45,27)+WQx*VRR1(45,27)
      VRR0(45,44)=V(116)+V(118)+V(149)+PAy*VRR0(28,44)+WPy*VRR1(28,44)
      VRR0(45,45)=3.D0*V(153)+V(174)+V(177)+QCy*VRR0(45,28)+WQy*VRR1(45,28)
      VRR0(45,46)=3.D0*V(178)-3.D0*V(179)+QCy*VRR0(45,29)+3.D0*HfxZpE*VRR1(28,29)+WQy*VRR1(45,29)
      VRR0(45,47)=2.D0*V(180)+V(181)-2.D0*V(182)+QCx*VRR0(45,30)+WQx*VRR1(45,30)
      VRR0(45,48)=V(127)+V(129)+V(156)+PAy*VRR0(28,48)+WPy*VRR1(28,48)
      VRR0(45,49)=V(133)+V(135)+V(161)+PAy*VRR0(28,49)+WPy*VRR1(28,49)
      VRR0(45,50)=2.D0*V(183)+3.D0*V(184)-2.D0*V(185)+QCy*VRR0(45,32)+WQy*VRR1(45,32)
      VRR0(45,51)=V(73)+2.D0*V(170)-2.D0*V(172)+QCz*VRR0(45,30)+WQz*VRR1(45,30)
      VRR0(45,52)=V(80)+V(174)+V(177)+QCz*VRR0(45,31)+WQz*VRR1(45,31)
      VRR0(45,53)=V(81)+2.D0*V(178)-2.D0*V(179)+QCz*VRR0(45,32)+WQz*VRR1(45,32)
      VRR0(45,54)=V(82)+3.D0*V(180)-3.D0*V(182)+QCz*VRR0(45,33)+WQz*VRR1(45,33)
      VRR0(45,55)=V(83)+3.D0*V(183)-3.D0*V(185)+QCz*VRR0(45,34)+WQz*VRR1(45,34)
      VRR0(45,56)=4.D0*r1x2E*VRR0(45,20)+QCz*VRR0(45,35)+HfxZpE*VRR1(24,35)-4.D0*r1x2E*ZxZpE*VRR1(45,20)+WQz*VRR1(45,35)
      VRR0(46,36)=4.D0*r1x2E*VRR0(46,11)+QCx*VRR0(46,21)-4.D0*r1x2E*ZxZpE*VRR1(46,11)+WQx*VRR1(46,21)
      VRR0(46,37)=3.D0*r1x2E*VRR0(46,12)+QCx*VRR0(46,22)-3.D0*r1x2E*ZxZpE*VRR1(46,12)+WQx*VRR1(46,22)
      VRR0(46,38)=2.D0*V(165)+3.D0*r1x2Z*VRR0(17,38)+PAy*VRR0(29,38)-3.D0*ExZpE*r1x2Z*VRR1(17,38)+WPy*VRR1(29,38)
      VRR0(46,39)=3.D0*V(168)+3.D0*r1x2Z*VRR0(17,39)+PAy*VRR0(29,39)-3.D0*ExZpE*r1x2Z*VRR1(17,39)+WPy*VRR1(29,39)
      VRR0(46,40)=3.D0*r1x2E*VRR0(46,13)+QCy*VRR0(46,24)+4.D0*HfxZpE*VRR1(29,24)-3.D0*r1x2E*ZxZpE*VRR1(46,13)+WQy*VRR1(46,24)
      VRR0(46,41)=4.D0*r1x2E*VRR0(46,14)+QCy*VRR0(46,25)+4.D0*HfxZpE*VRR1(29,25)-4.D0*r1x2E*ZxZpE*VRR1(46,14)+WQy*VRR1(46,25)
      VRR0(46,42)=3.D0*r1x2E*VRR0(46,15)+QCx*VRR0(46,26)-3.D0*r1x2E*ZxZpE*VRR1(46,15)+WQx*VRR1(46,26)
      VRR0(46,43)=V(171)+3.D0*r1x2Z*VRR0(17,43)+PAy*VRR0(29,43)-3.D0*ExZpE*r1x2Z*VRR1(17,43)+WPy*VRR1(29,43)
      VRR0(46,44)=2.D0*V(175)+3.D0*V(186)-3.D0*V(187)+PAy*VRR0(29,44)+WPy*VRR1(29,44)
      VRR0(46,45)=3.D0*r1x2Z*VRR0(17,45)+PAy*VRR0(29,45)-3.D0*ExZpE*r1x2Z*VRR1(17,45)+3.D0*HfxZpE*VRR1(29,28)+WPy*VRR1(29,45)
      VRR0(46,46)=3.D0*r1x2E*VRR0(46,17)+QCy*VRR0(46,29)+4.D0*HfxZpE*VRR1(29,29)-3.D0*r1x2E*ZxZpE*VRR1(46,17)+WQy*VRR1(46,29)
      VRR0(46,47)=3.D0*r1x2Z*VRR0(17,47)+PAy*VRR0(29,47)-3.D0*ExZpE*r1x2Z*VRR1(17,47)+WPy*VRR1(29,47)
      VRR0(46,48)=V(181)+3.D0*V(188)-3.D0*V(189)+PAy*VRR0(29,48)+WPy*VRR1(29,48)
      VRR0(46,49)=3.D0*V(190)-3.D0*V(191)+V(193)+PAy*VRR0(29,49)+WPy*VRR1(29,49)
      VRR0(46,50)=3.D0*V(194)+3.D0*r1x2Z*VRR0(17,50)+PAy*VRR0(29,50)-3.D0*ExZpE*r1x2Z*VRR1(17,50)+WPy*VRR1(29,50)
      VRR0(46,51)=3.D0*r1x2Z*VRR0(17,51)+PAy*VRR0(29,51)-3.D0*ExZpE*r1x2Z*VRR1(17,51)+WPy*VRR1(29,51)
      VRR0(46,52)=V(195)+3.D0*r1x2Z*VRR0(17,52)+PAy*VRR0(29,52)-3.D0*ExZpE*r1x2Z*VRR1(17,52)+WPy*VRR1(29,52)
      VRR0(46,53)=V(197)+3.D0*r1x2Z*VRR0(17,53)+PAy*VRR0(29,53)-3.D0*ExZpE*r1x2Z*VRR1(17,53)+WPy*VRR1(29,53)
      VRR0(46,54)=V(84)+3.D0*r1x2E*VRR0(46,18)+QCz*VRR0(46,33)-3.D0*r1x2E*ZxZpE*VRR1(46,18)+WQz*VRR1(46,33)
      VRR0(46,55)=V(85)+3.D0*r1x2E*VRR0(46,19)+QCz*VRR0(46,34)-3.D0*r1x2E*ZxZpE*VRR1(46,19)+WQz*VRR1(46,34)
      VRR0(46,56)=V(86)+4.D0*r1x2E*VRR0(46,20)+QCz*VRR0(46,35)-4.D0*r1x2E*ZxZpE*VRR1(46,20)+WQz*VRR1(46,35)
      VRR0(47,36)=4.D0*r1x2E*VRR0(47,11)+QCx*VRR0(47,21)+3.D0*HfxZpE*VRR1(30,21)-4.D0*r1x2E*ZxZpE*VRR1(47,11)+WQx*VRR1(47,21)
      VRR0(47,37)=3.D0*V(198)-3.D0*V(199)+QCx*VRR0(47,22)+3.D0*HfxZpE*VRR1(30,22)+WQx*VRR1(47,22)
      VRR0(47,38)=2.D0*V(200)+3.D0*V(201)-2.D0*V(202)+QCx*VRR0(47,23)+WQx*VRR1(47,23)
      VRR0(47,39)=2.D0*V(198)-2.D0*V(199)+QCy*VRR0(47,23)+WQy*VRR1(47,23)
      VRR0(47,40)=3.D0*V(200)-3.D0*V(202)+QCy*VRR0(47,24)+WQy*VRR1(47,24)
      VRR0(47,41)=4.D0*r1x2E*VRR0(47,14)+QCy*VRR0(47,25)-4.D0*r1x2E*ZxZpE*VRR1(47,14)+WQy*VRR1(47,25)
      VRR0(47,42)=3.D0*V(203)-3.D0*V(204)+QCx*VRR0(47,26)+3.D0*HfxZpE*VRR1(30,26)+WQx*VRR1(47,26)
      VRR0(47,43)=V(206)+3.D0*V(207)+V(209)+QCx*VRR0(47,27)+WQx*VRR1(47,27)
      VRR0(47,44)=2.D0*V(210)-2.D0*V(211)+V(213)+PAx*VRR0(30,44)+WPx*VRR1(30,44)
      VRR0(47,45)=V(206)+V(209)+QCy*VRR0(47,28)+WQy*VRR1(47,28)
      VRR0(47,46)=3.D0*V(214)-3.D0*V(215)+QCy*VRR0(47,29)+WQy*VRR1(47,29)
      VRR0(47,47)=2.D0*V(216)+V(218)-2.D0*V(219)+QCx*VRR0(47,30)+WQx*VRR1(47,30)
      VRR0(47,48)=2.D0*V(220)-2.D0*V(221)+2.D0*V(222)+PAx*VRR0(30,48)+WPx*VRR1(30,48)
      VRR0(47,49)=2.D0*V(223)-2.D0*V(224)+V(225)+PAx*VRR0(30,49)+WPx*VRR1(30,49)
      VRR0(47,50)=2.D0*V(226)-2.D0*V(227)+QCy*VRR0(47,32)+WQy*VRR1(47,32)
      VRR0(47,51)=2.D0*V(93)+2.D0*V(203)-2.D0*V(204)+QCz*VRR0(47,30)+WQz*VRR1(47,30)
      VRR0(47,52)=V(97)+V(206)+V(209)+QCz*VRR0(47,31)+WQz*VRR1(47,31)
      VRR0(47,53)=2.D0*V(100)+2.D0*V(214)-2.D0*V(215)+QCz*VRR0(47,32)+WQz*VRR1(47,32)
      VRR0(47,54)=V(102)+3.D0*V(216)-3.D0*V(219)+QCz*VRR0(47,33)+WQz*VRR1(47,33)
      VRR0(47,55)=2.D0*V(103)+3.D0*V(226)-3.D0*V(227)+QCz*VRR0(47,34)+WQz*VRR1(47,34)
      VRR0(47,56)=4.D0*r1x2E*VRR0(47,20)+QCz*VRR0(47,35)+2.D0*HfxZpE*VRR1(26,35)-4.D0*r1x2E*ZxZpE*VRR1(47,20)+WQz*VRR1(47,35)
      VRR0(48,36)=4.D0*r1x2E*VRR0(48,11)+QCx*VRR0(48,21)+2.D0*HfxZpE*VRR1(31,21)-4.D0*r1x2E*ZxZpE*VRR1(48,11)+WQx*VRR1(48,21)
      VRR0(48,37)=3.D0*V(228)-3.D0*V(229)+QCx*VRR0(48,22)+2.D0*HfxZpE*VRR1(31,22)+WQx*VRR1(48,22)
      VRR0(48,38)=2.D0*V(230)+V(232)-2.D0*V(233)+QCx*VRR0(48,23)+WQx*VRR1(48,23)
      VRR0(48,39)=V(201)+2.D0*V(228)-2.D0*V(229)+QCy*VRR0(48,23)+WQy*VRR1(48,23)
      VRR0(48,40)=3.D0*V(230)-3.D0*V(233)+QCy*VRR0(48,24)+HfxZpE*VRR1(30,24)+WQy*VRR1(48,24)
      VRR0(48,41)=4.D0*r1x2E*VRR0(48,14)+QCy*VRR0(48,25)+HfxZpE*VRR1(30,25)-4.D0*r1x2E*ZxZpE*VRR1(48,14)+WQy*VRR1(48,25)
      VRR0(48,42)=3.D0*V(234)-3.D0*V(235)+QCx*VRR0(48,26)+2.D0*HfxZpE*VRR1(31,26)+WQx*VRR1(48,26)
      VRR0(48,43)=V(237)+V(239)+V(241)+QCx*VRR0(48,27)+WQx*VRR1(48,27)
      VRR0(48,44)=V(242)+V(244)-V(245)+QCx*VRR0(48,28)+WQx*VRR1(48,28)
      VRR0(48,45)=V(212)+V(237)+V(241)+QCy*VRR0(48,28)+WQy*VRR1(48,28)
      VRR0(48,46)=3.D0*V(242)-3.D0*V(245)+QCy*VRR0(48,29)+HfxZpE*VRR1(30,29)+WQy*VRR1(48,29)
      VRR0(48,47)=2.D0*V(246)+2.D0*V(247)-2.D0*V(248)+QCx*VRR0(48,30)+WQx*VRR1(48,30)
      VRR0(48,48)=V(249)+V(251)-V(252)+QCx*VRR0(48,31)+WQx*VRR1(48,31)
      VRR0(48,49)=V(222)+V(246)-V(248)+QCy*VRR0(48,31)+WQy*VRR1(48,31)
      VRR0(48,50)=V(225)+2.D0*V(249)-2.D0*V(252)+QCy*VRR0(48,32)+WQy*VRR1(48,32)
      VRR0(48,51)=2.D0*V(124)+2.D0*V(234)-2.D0*V(235)+QCz*VRR0(48,30)+WQz*VRR1(48,30)
      VRR0(48,52)=V(131)+V(237)+V(241)+QCz*VRR0(48,31)+WQz*VRR1(48,31)
      VRR0(48,53)=V(163)+2.D0*V(242)-2.D0*V(245)+QCz*VRR0(48,32)+WQz*VRR1(48,32)
      VRR0(48,54)=3.D0*V(246)-3.D0*V(248)+QCz*VRR0(48,33)+2.D0*HfxZpE*VRR1(27,33)+WQz*VRR1(48,33)
      VRR0(48,55)=3.D0*V(249)-3.D0*V(252)+QCz*VRR0(48,34)+2.D0*HfxZpE*VRR1(27,34)+WQz*VRR1(48,34)
      VRR0(48,56)=4.D0*r1x2E*VRR0(48,20)+QCz*VRR0(48,35)+2.D0*HfxZpE*VRR1(27,35)-4.D0*r1x2E*ZxZpE*VRR1(48,20)+WQz*VRR1(48,35)
      VRR0(49,36)=4.D0*r1x2E*VRR0(49,11)+QCx*VRR0(49,21)+HfxZpE*VRR1(32,21)-4.D0*r1x2E*ZxZpE*VRR1(49,11)+WQx*VRR1(49,21)
      VRR0(49,37)=3.D0*V(253)-3.D0*V(254)+QCx*VRR0(49,22)+HfxZpE*VRR1(32,22)+WQx*VRR1(49,22)
      VRR0(49,38)=2.D0*V(255)+V(256)-2.D0*V(257)+QCx*VRR0(49,23)+WQx*VRR1(49,23)
      VRR0(49,39)=V(232)+2.D0*V(253)-2.D0*V(254)+QCy*VRR0(49,23)+WQy*VRR1(49,23)
      VRR0(49,40)=3.D0*V(255)-3.D0*V(257)+QCy*VRR0(49,24)+2.D0*HfxZpE*VRR1(31,24)+WQy*VRR1(49,24)
      VRR0(49,41)=4.D0*r1x2E*VRR0(49,14)+QCy*VRR0(49,25)+2.D0*HfxZpE*VRR1(31,25)-4.D0*r1x2E*ZxZpE*VRR1(49,14)+WQy*VRR1(49,25)
      VRR0(49,42)=3.D0*V(258)-3.D0*V(259)+QCx*VRR0(49,26)+HfxZpE*VRR1(32,26)+WQx*VRR1(49,26)
      VRR0(49,43)=V(261)+V(262)+V(264)+QCx*VRR0(49,27)+WQx*VRR1(49,27)
      VRR0(49,44)=V(265)+V(266)-V(267)+QCx*VRR0(49,28)+WQx*VRR1(49,28)
      VRR0(49,45)=V(244)+V(261)+V(264)+QCy*VRR0(49,28)+WQy*VRR1(49,28)
      VRR0(49,46)=3.D0*V(265)-3.D0*V(267)+QCy*VRR0(49,29)+2.D0*HfxZpE*VRR1(31,29)+WQy*VRR1(49,29)
      VRR0(49,47)=2.D0*V(268)+V(269)-2.D0*V(270)+QCx*VRR0(49,30)+WQx*VRR1(49,30)
      VRR0(49,48)=V(271)+V(272)-V(273)+QCx*VRR0(49,31)+WQx*VRR1(49,31)
      VRR0(49,49)=V(251)+V(268)-V(270)+QCy*VRR0(49,31)+WQy*VRR1(49,31)
      VRR0(49,50)=2.D0*V(271)-2.D0*V(273)+2.D0*V(274)+QCy*VRR0(49,32)+WQy*VRR1(49,32)
      VRR0(49,51)=V(157)+2.D0*V(258)-2.D0*V(259)+QCz*VRR0(49,30)+WQz*VRR1(49,30)
      VRR0(49,52)=V(161)+V(261)+V(264)+QCz*VRR0(49,31)+WQz*VRR1(49,31)
      VRR0(49,53)=2.D0*V(184)+2.D0*V(265)-2.D0*V(267)+QCz*VRR0(49,32)+WQz*VRR1(49,32)
      VRR0(49,54)=3.D0*V(268)-3.D0*V(270)+QCz*VRR0(49,33)+2.D0*HfxZpE*VRR1(28,33)+WQz*VRR1(49,33)
      VRR0(49,55)=3.D0*V(271)-3.D0*V(273)+QCz*VRR0(49,34)+2.D0*HfxZpE*VRR1(28,34)+WQz*VRR1(49,34)
      VRR0(49,56)=4.D0*r1x2E*VRR0(49,20)+QCz*VRR0(49,35)+2.D0*HfxZpE*VRR1(28,35)-4.D0*r1x2E*ZxZpE*VRR1(49,20)+WQz*VRR1(49,35)
      VRR0(50,36)=4.D0*r1x2E*VRR0(50,11)+QCx*VRR0(50,21)-4.D0*r1x2E*ZxZpE*VRR1(50,11)+WQx*VRR1(50,21)
      VRR0(50,37)=3.D0*V(275)-3.D0*V(276)+QCx*VRR0(50,22)+WQx*VRR1(50,22)
      VRR0(50,38)=2.D0*V(277)-2.D0*V(278)+QCx*VRR0(50,23)+WQx*VRR1(50,23)
      VRR0(50,39)=3.D0*V(256)+2.D0*V(275)-2.D0*V(276)+QCy*VRR0(50,23)+WQy*VRR1(50,23)
      VRR0(50,40)=3.D0*V(277)-3.D0*V(278)+QCy*VRR0(50,24)+3.D0*HfxZpE*VRR1(32,24)+WQy*VRR1(50,24)
      VRR0(50,41)=4.D0*r1x2E*VRR0(50,14)+QCy*VRR0(50,25)+3.D0*HfxZpE*VRR1(32,25)-4.D0*r1x2E*ZxZpE*VRR1(50,14)+WQy*VRR1(50,25)
      VRR0(50,42)=3.D0*V(279)-3.D0*V(280)+QCx*VRR0(50,26)+WQx*VRR1(50,26)
      VRR0(50,43)=V(282)+V(284)+QCx*VRR0(50,27)+WQx*VRR1(50,27)
      VRR0(50,44)=2.D0*V(285)-2.D0*V(286)+V(287)+PAy*VRR0(32,44)+WPy*VRR1(32,44)
      VRR0(50,45)=3.D0*V(266)+V(282)+V(284)+QCy*VRR0(50,28)+WQy*VRR1(50,28)
      VRR0(50,46)=3.D0*V(288)-3.D0*V(289)+QCy*VRR0(50,29)+3.D0*HfxZpE*VRR1(32,29)+WQy*VRR1(50,29)
      VRR0(50,47)=2.D0*V(290)-2.D0*V(291)+QCx*VRR0(50,30)+WQx*VRR1(50,30)
      VRR0(50,48)=V(269)+2.D0*V(292)-2.D0*V(293)+PAy*VRR0(32,48)+WPy*VRR1(32,48)
      VRR0(50,49)=2.D0*V(272)+2.D0*V(294)-2.D0*V(295)+PAy*VRR0(32,49)+WPy*VRR1(32,49)
      VRR0(50,50)=2.D0*V(296)+V(298)-2.D0*V(299)+QCy*VRR0(50,32)+WQy*VRR1(50,32)
      VRR0(50,51)=2.D0*V(181)+2.D0*V(279)-2.D0*V(280)+QCz*VRR0(50,30)+WQz*VRR1(50,30)
      VRR0(50,52)=V(193)+V(282)+V(284)+QCz*VRR0(50,31)+WQz*VRR1(50,31)
      VRR0(50,53)=2.D0*V(194)+2.D0*V(288)-2.D0*V(289)+QCz*VRR0(50,32)+WQz*VRR1(50,32)
      VRR0(50,54)=2.D0*V(195)+3.D0*V(290)-3.D0*V(291)+QCz*VRR0(50,33)+WQz*VRR1(50,33)
      VRR0(50,55)=V(197)+3.D0*V(296)-3.D0*V(299)+QCz*VRR0(50,34)+WQz*VRR1(50,34)
      VRR0(50,56)=4.D0*r1x2E*VRR0(50,20)+QCz*VRR0(50,35)+2.D0*HfxZpE*VRR1(29,35)-4.D0*r1x2E*ZxZpE*VRR1(50,20)+WQz*VRR1(50,35)
      VRR0(51,36)=4.D0*r1x2E*VRR0(51,11)+QCx*VRR0(51,21)+2.D0*HfxZpE*VRR1(33,21)-4.D0*r1x2E*ZxZpE*VRR1(51,11)+WQx*VRR1(51,21)
      VRR0(51,37)=3.D0*V(300)+2.D0*V(301)-3.D0*V(302)+QCx*VRR0(51,22)+WQx*VRR1(51,22)
      VRR0(51,38)=2.D0*V(303)+2.D0*V(304)-2.D0*V(305)+QCx*VRR0(51,23)+WQx*VRR1(51,23)
      VRR0(51,39)=2.D0*V(300)-2.D0*V(302)+QCy*VRR0(51,23)+WQy*VRR1(51,23)
      VRR0(51,40)=3.D0*V(303)-3.D0*V(305)+QCy*VRR0(51,24)+WQy*VRR1(51,24)
      VRR0(51,41)=4.D0*r1x2E*VRR0(51,14)+QCy*VRR0(51,25)-4.D0*r1x2E*ZxZpE*VRR1(51,14)+WQy*VRR1(51,25)
      VRR0(51,42)=3.D0*V(306)+V(308)-3.D0*V(309)+QCx*VRR0(51,26)+WQx*VRR1(51,26)
      VRR0(51,43)=V(311)+V(313)+V(315)+QCx*VRR0(51,27)+WQx*VRR1(51,27)
      VRR0(51,44)=2.D0*V(89)-2.D0*V(90)+V(201)+PAz*VRR0(30,44)+WPz*VRR1(30,44)
      VRR0(51,45)=V(311)+V(315)+QCy*VRR0(51,28)+WQy*VRR1(51,28)
      VRR0(51,46)=3.D0*V(316)-3.D0*V(317)+QCy*VRR0(51,29)+WQy*VRR1(51,29)
      VRR0(51,47)=2.D0*V(318)+2.D0*V(319)-2.D0*V(320)+QCx*VRR0(51,30)+WQx*VRR1(51,30)
      VRR0(51,48)=2.D0*V(94)-2.D0*V(95)+2.D0*V(207)+PAz*VRR0(30,48)+WPz*VRR1(30,48)
      VRR0(51,49)=2.D0*V(98)-2.D0*V(99)+V(213)+PAz*VRR0(30,49)+WPz*VRR1(30,49)
      VRR0(51,50)=2.D0*V(321)-2.D0*V(322)+QCy*VRR0(51,32)+WQy*VRR1(51,32)
      VRR0(51,51)=V(218)+2.D0*V(306)-2.D0*V(309)+QCz*VRR0(51,30)+WQz*VRR1(51,30)
      VRR0(51,52)=3.D0*V(222)+V(311)+V(315)+QCz*VRR0(51,31)+WQz*VRR1(51,31)
      VRR0(51,53)=3.D0*V(225)+2.D0*V(316)-2.D0*V(317)+QCz*VRR0(51,32)+WQz*VRR1(51,32)
      VRR0(51,54)=3.D0*V(318)-3.D0*V(320)+QCz*VRR0(51,33)+3.D0*HfxZpE*VRR1(30,33)+WQz*VRR1(51,33)
      VRR0(51,55)=3.D0*V(321)-3.D0*V(322)+QCz*VRR0(51,34)+3.D0*HfxZpE*VRR1(30,34)+WQz*VRR1(51,34)
      VRR0(51,56)=4.D0*r1x2E*VRR0(51,20)+QCz*VRR0(51,35)+3.D0*HfxZpE*VRR1(30,35)-4.D0*r1x2E*ZxZpE*VRR1(51,20)+WQz*VRR1(51,35)
      VRR0(52,36)=4.D0*r1x2E*VRR0(52,11)+QCx*VRR0(52,21)+HfxZpE*VRR1(34,21)-4.D0*r1x2E*ZxZpE*VRR1(52,11)+WQx*VRR1(52,21)
      VRR0(52,37)=3.D0*V(323)+V(324)-3.D0*V(325)+QCx*VRR0(52,22)+WQx*VRR1(52,22)
      VRR0(52,38)=2.D0*V(326)+V(327)-2.D0*V(328)+QCx*VRR0(52,23)+WQx*VRR1(52,23)
      VRR0(52,39)=V(304)+2.D0*V(323)-2.D0*V(325)+QCy*VRR0(52,23)+WQy*VRR1(52,23)
      VRR0(52,40)=3.D0*V(326)-3.D0*V(328)+V(329)+QCy*VRR0(52,24)+WQy*VRR1(52,24)
      VRR0(52,41)=4.D0*r1x2E*VRR0(52,14)+QCy*VRR0(52,25)+HfxZpE*VRR1(33,25)-4.D0*r1x2E*ZxZpE*VRR1(52,14)+WQy*VRR1(52,25)
      VRR0(52,42)=3.D0*V(330)+V(331)-3.D0*V(332)+QCx*VRR0(52,26)+WQx*VRR1(52,26)
      VRR0(52,43)=V(334)+V(335)+V(337)+QCx*VRR0(52,27)+WQx*VRR1(52,27)
      VRR0(52,44)=V(116)+V(118)+V(231)+PAz*VRR0(31,44)+WPz*VRR1(31,44)
      VRR0(52,45)=V(334)+V(337)+V(338)+QCy*VRR0(52,28)+WQy*VRR1(52,28)
      VRR0(52,46)=3.D0*V(339)+V(340)-3.D0*V(341)+QCy*VRR0(52,29)+WQy*VRR1(52,29)
      VRR0(52,47)=2.D0*V(342)+V(343)-2.D0*V(344)+QCx*VRR0(52,30)+WQx*VRR1(52,30)
      VRR0(52,48)=V(127)+V(129)+V(239)+PAz*VRR0(31,48)+WPz*VRR1(31,48)
      VRR0(52,49)=V(133)+V(135)+V(244)+PAz*VRR0(31,49)+WPz*VRR1(31,49)
      VRR0(52,50)=2.D0*V(345)+V(346)-2.D0*V(347)+QCy*VRR0(52,32)+WQy*VRR1(52,32)
      VRR0(52,51)=3.D0*V(247)+2.D0*V(330)-2.D0*V(332)+QCz*VRR0(52,30)+WQz*VRR1(52,30)
      VRR0(52,52)=3.D0*V(250)+V(334)+V(337)+QCz*VRR0(52,31)+WQz*VRR1(52,31)
      VRR0(52,53)=3.D0*V(274)+2.D0*V(339)-2.D0*V(341)+QCz*VRR0(52,32)+WQz*VRR1(52,32)
      VRR0(52,54)=3.D0*V(342)-3.D0*V(344)+QCz*VRR0(52,33)+3.D0*HfxZpE*VRR1(31,33)+WQz*VRR1(52,33)
      VRR0(52,55)=3.D0*V(345)-3.D0*V(347)+QCz*VRR0(52,34)+3.D0*HfxZpE*VRR1(31,34)+WQz*VRR1(52,34)
      VRR0(52,56)=4.D0*r1x2E*VRR0(52,20)+QCz*VRR0(52,35)+3.D0*HfxZpE*VRR1(31,35)-4.D0*r1x2E*ZxZpE*VRR1(52,20)+WQz*VRR1(52,35)
      VRR0(53,36)=4.D0*r1x2E*VRR0(53,11)+QCx*VRR0(53,21)-4.D0*r1x2E*ZxZpE*VRR1(53,11)+WQx*VRR1(53,21)
      VRR0(53,37)=3.D0*V(348)-3.D0*V(349)+QCx*VRR0(53,22)+WQx*VRR1(53,22)
      VRR0(53,38)=2.D0*V(350)-2.D0*V(351)+QCx*VRR0(53,23)+WQx*VRR1(53,23)
      VRR0(53,39)=2.D0*V(327)+2.D0*V(348)-2.D0*V(349)+QCy*VRR0(53,23)+WQy*VRR1(53,23)
      VRR0(53,40)=3.D0*V(350)-3.D0*V(351)+2.D0*V(352)+QCy*VRR0(53,24)+WQy*VRR1(53,24)
      VRR0(53,41)=4.D0*r1x2E*VRR0(53,14)+QCy*VRR0(53,25)+2.D0*HfxZpE*VRR1(34,25)-4.D0*r1x2E*ZxZpE*VRR1(53,14)+WQy*VRR1(53,25)
      VRR0(53,42)=3.D0*V(353)-3.D0*V(354)+QCx*VRR0(53,26)+WQx*VRR1(53,26)
      VRR0(53,43)=V(356)+V(358)+QCx*VRR0(53,27)+WQx*VRR1(53,27)
      VRR0(53,44)=2.D0*V(186)-2.D0*V(187)+V(256)+PAz*VRR0(32,44)+WPz*VRR1(32,44)
      VRR0(53,45)=V(356)+V(358)+V(360)+QCy*VRR0(53,28)+WQy*VRR1(53,28)
      VRR0(53,46)=3.D0*V(361)+V(363)-3.D0*V(364)+QCy*VRR0(53,29)+WQy*VRR1(53,29)
      VRR0(53,47)=2.D0*V(365)-2.D0*V(366)+QCx*VRR0(53,30)+WQx*VRR1(53,30)
      VRR0(53,48)=2.D0*V(188)-2.D0*V(189)+V(287)+PAz*VRR0(32,48)+WPz*VRR1(32,48)
      VRR0(53,49)=2.D0*V(190)-2.D0*V(191)+2.D0*V(266)+PAz*VRR0(32,49)+WPz*VRR1(32,49)
      VRR0(53,50)=2.D0*V(367)+2.D0*V(368)-2.D0*V(369)+QCy*VRR0(53,32)+WQy*VRR1(53,32)
      VRR0(53,51)=3.D0*V(269)+2.D0*V(353)-2.D0*V(354)+QCz*VRR0(53,30)+WQz*VRR1(53,30)
      VRR0(53,52)=3.D0*V(272)+V(356)+V(358)+QCz*VRR0(53,31)+WQz*VRR1(53,31)
      VRR0(53,53)=V(298)+2.D0*V(361)-2.D0*V(364)+QCz*VRR0(53,32)+WQz*VRR1(53,32)
      VRR0(53,54)=3.D0*V(365)-3.D0*V(366)+QCz*VRR0(53,33)+3.D0*HfxZpE*VRR1(32,33)+WQz*VRR1(53,33)
      VRR0(53,55)=3.D0*V(367)-3.D0*V(369)+QCz*VRR0(53,34)+3.D0*HfxZpE*VRR1(32,34)+WQz*VRR1(53,34)
      VRR0(53,56)=4.D0*r1x2E*VRR0(53,20)+QCz*VRR0(53,35)+3.D0*HfxZpE*VRR1(32,35)-4.D0*r1x2E*ZxZpE*VRR1(53,20)+WQz*VRR1(53,35)
      VRR0(54,36)=V(370)+4.D0*r1x2E*VRR0(54,11)+QCx*VRR0(54,21)-4.D0*r1x2E*ZxZpE*VRR1(54,11)+WQx*VRR1(54,21)
      VRR0(54,37)=V(371)+3.D0*r1x2E*VRR0(54,12)+QCx*VRR0(54,22)-3.D0*r1x2E*ZxZpE*VRR1(54,12)+WQx*VRR1(54,22)
      VRR0(54,38)=3.D0*r1x2Z*VRR0(18,38)+PAz*VRR0(33,38)-3.D0*ExZpE*r1x2Z*VRR1(18,38)+WPz*VRR1(33,38)
      VRR0(54,39)=3.D0*r1x2Z*VRR0(18,39)+PAz*VRR0(33,39)-3.D0*ExZpE*r1x2Z*VRR1(18,39)+WPz*VRR1(33,39)
      VRR0(54,40)=3.D0*r1x2E*VRR0(54,13)+QCy*VRR0(54,24)-3.D0*r1x2E*ZxZpE*VRR1(54,13)+WQy*VRR1(54,24)
      VRR0(54,41)=4.D0*r1x2E*VRR0(54,14)+QCy*VRR0(54,25)-4.D0*r1x2E*ZxZpE*VRR1(54,14)+WQy*VRR1(54,25)
      VRR0(54,42)=V(372)+3.D0*r1x2E*VRR0(54,15)+QCx*VRR0(54,26)-3.D0*r1x2E*ZxZpE*VRR1(54,15)+WQx*VRR1(54,26)
      VRR0(54,43)=V(301)+3.D0*r1x2Z*VRR0(18,43)+PAz*VRR0(33,43)-3.D0*ExZpE*r1x2Z*VRR1(18,43)+WPz*VRR1(33,43)
      VRR0(54,44)=3.D0*V(210)-3.D0*V(211)+V(304)+PAz*VRR0(33,44)+WPz*VRR1(33,44)
      VRR0(54,45)=V(329)+3.D0*r1x2Z*VRR0(18,45)+PAz*VRR0(33,45)-3.D0*ExZpE*r1x2Z*VRR1(18,45)+WPz*VRR1(33,45)
      VRR0(54,46)=3.D0*r1x2E*VRR0(54,17)+QCy*VRR0(54,29)-3.D0*r1x2E*ZxZpE*VRR1(54,17)+WQy*VRR1(54,29)
      VRR0(54,47)=V(308)+3.D0*r1x2Z*VRR0(18,47)+PAz*VRR0(33,47)-3.D0*ExZpE*r1x2Z*VRR1(18,47)+WPz*VRR1(33,47)
      VRR0(54,48)=3.D0*V(220)-3.D0*V(221)+V(313)+PAz*VRR0(33,48)+WPz*VRR1(33,48)
      VRR0(54,49)=3.D0*V(223)-3.D0*V(224)+2.D0*V(338)+PAz*VRR0(33,49)+WPz*VRR1(33,49)
      VRR0(54,50)=2.D0*V(340)+3.D0*r1x2Z*VRR0(18,50)+PAz*VRR0(33,50)-3.D0*ExZpE*r1x2Z*VRR1(18,50)+WPz*VRR1(33,50)
      VRR0(54,51)=3.D0*V(319)+3.D0*r1x2Z*VRR0(18,51)+PAz*VRR0(33,51)-3.D0*ExZpE*r1x2Z*VRR1(18,51)+WPz*VRR1(33,51)
      VRR0(54,52)=3.D0*r1x2Z*VRR0(18,52)+PAz*VRR0(33,52)-3.D0*ExZpE*r1x2Z*VRR1(18,52)+3.D0*HfxZpE*VRR1(33,31)+WPz*VRR1(33,52)
      VRR0(54,53)=3.D0*V(346)+3.D0*r1x2Z*VRR0(18,53)+PAz*VRR0(33,53)-3.D0*ExZpE*r1x2Z*VRR1(18,53)+WPz*VRR1(33,53)
      VRR0(54,54)=3.D0*r1x2E*VRR0(54,18)+QCz*VRR0(54,33)+4.D0*HfxZpE*VRR1(33,33)-3.D0*r1x2E*ZxZpE*VRR1(54,18)+WQz*VRR1(54,33)
      VRR0(54,55)=3.D0*r1x2E*VRR0(54,19)+QCz*VRR0(54,34)+4.D0*HfxZpE*VRR1(33,34)-3.D0*r1x2E*ZxZpE*VRR1(54,19)+WQz*VRR1(54,34)
      VRR0(54,56)=4.D0*r1x2E*VRR0(54,20)+QCz*VRR0(54,35)+4.D0*HfxZpE*VRR1(33,35)-4.D0*r1x2E*ZxZpE*VRR1(54,20)+WQz*VRR1(54,35)
      VRR0(55,36)=4.D0*r1x2E*VRR0(55,11)+QCx*VRR0(55,21)-4.D0*r1x2E*ZxZpE*VRR1(55,11)+WQx*VRR1(55,21)
      VRR0(55,37)=3.D0*r1x2E*VRR0(55,12)+QCx*VRR0(55,22)-3.D0*r1x2E*ZxZpE*VRR1(55,12)+WQx*VRR1(55,22)
      VRR0(55,38)=3.D0*r1x2Z*VRR0(19,38)+PAz*VRR0(34,38)-3.D0*ExZpE*r1x2Z*VRR1(19,38)+WPz*VRR1(34,38)
      VRR0(55,39)=3.D0*r1x2Z*VRR0(19,39)+PAz*VRR0(34,39)-3.D0*ExZpE*r1x2Z*VRR1(19,39)+WPz*VRR1(34,39)
      VRR0(55,40)=V(373)+3.D0*r1x2E*VRR0(55,13)+QCy*VRR0(55,24)-3.D0*r1x2E*ZxZpE*VRR1(55,13)+WQy*VRR1(55,24)
      VRR0(55,41)=V(374)+4.D0*r1x2E*VRR0(55,14)+QCy*VRR0(55,25)-4.D0*r1x2E*ZxZpE*VRR1(55,14)+WQy*VRR1(55,25)
      VRR0(55,42)=3.D0*r1x2E*VRR0(55,15)+QCx*VRR0(55,26)-3.D0*r1x2E*ZxZpE*VRR1(55,15)+WQx*VRR1(55,26)
      VRR0(55,43)=V(324)+3.D0*r1x2Z*VRR0(19,43)+PAz*VRR0(34,43)-3.D0*ExZpE*r1x2Z*VRR1(19,43)+WPz*VRR1(34,43)
      VRR0(55,44)=3.D0*V(285)-3.D0*V(286)+V(327)+PAz*VRR0(34,44)+WPz*VRR1(34,44)
      VRR0(55,45)=V(352)+3.D0*r1x2Z*VRR0(19,45)+PAz*VRR0(34,45)-3.D0*ExZpE*r1x2Z*VRR1(19,45)+WPz*VRR1(34,45)
      VRR0(55,46)=V(375)+3.D0*r1x2E*VRR0(55,17)+QCy*VRR0(55,29)-3.D0*r1x2E*ZxZpE*VRR1(55,17)+WQy*VRR1(55,29)
      VRR0(55,47)=2.D0*V(331)+3.D0*r1x2Z*VRR0(19,47)+PAz*VRR0(34,47)-3.D0*ExZpE*r1x2Z*VRR1(19,47)+WPz*VRR1(34,47)
      VRR0(55,48)=3.D0*V(292)-3.D0*V(293)+2.D0*V(335)+PAz*VRR0(34,48)+WPz*VRR1(34,48)
      VRR0(55,49)=3.D0*V(294)-3.D0*V(295)+V(360)+PAz*VRR0(34,49)+WPz*VRR1(34,49)
      VRR0(55,50)=V(363)+3.D0*r1x2Z*VRR0(19,50)+PAz*VRR0(34,50)-3.D0*ExZpE*r1x2Z*VRR1(19,50)+WPz*VRR1(34,50)
      VRR0(55,51)=3.D0*V(343)+3.D0*r1x2Z*VRR0(19,51)+PAz*VRR0(34,51)-3.D0*ExZpE*r1x2Z*VRR1(19,51)+WPz*VRR1(34,51)
      VRR0(55,52)=3.D0*r1x2Z*VRR0(19,52)+PAz*VRR0(34,52)-3.D0*ExZpE*r1x2Z*VRR1(19,52)+3.D0*HfxZpE*VRR1(34,31)+WPz*VRR1(34,52)
      VRR0(55,53)=3.D0*V(368)+3.D0*r1x2Z*VRR0(19,53)+PAz*VRR0(34,53)-3.D0*ExZpE*r1x2Z*VRR1(19,53)+WPz*VRR1(34,53)
      VRR0(55,54)=3.D0*r1x2E*VRR0(55,18)+QCz*VRR0(55,33)+4.D0*HfxZpE*VRR1(34,33)-3.D0*r1x2E*ZxZpE*VRR1(55,18)+WQz*VRR1(55,33)
      VRR0(55,55)=3.D0*r1x2E*VRR0(55,19)+QCz*VRR0(55,34)+4.D0*HfxZpE*VRR1(34,34)-3.D0*r1x2E*ZxZpE*VRR1(55,19)+WQz*VRR1(55,34)
      VRR0(55,56)=4.D0*r1x2E*VRR0(55,20)+QCz*VRR0(55,35)+4.D0*HfxZpE*VRR1(34,35)-4.D0*r1x2E*ZxZpE*VRR1(55,20)+WQz*VRR1(55,35)
      VRR0(56,36)=4.D0*r1x2E*VRR0(56,11)+QCx*VRR0(56,21)-4.D0*r1x2E*ZxZpE*VRR1(56,11)+WQx*VRR1(56,21)
      VRR0(56,37)=4.D0*r1x2Z*VRR0(20,37)+PAz*VRR0(35,37)-4.D0*ExZpE*r1x2Z*VRR1(20,37)+WPz*VRR1(35,37)
      VRR0(56,38)=4.D0*r1x2Z*VRR0(20,38)+PAz*VRR0(35,38)-4.D0*ExZpE*r1x2Z*VRR1(20,38)+WPz*VRR1(35,38)
      VRR0(56,39)=4.D0*r1x2Z*VRR0(20,39)+PAz*VRR0(35,39)-4.D0*ExZpE*r1x2Z*VRR1(20,39)+WPz*VRR1(35,39)
      VRR0(56,40)=4.D0*r1x2Z*VRR0(20,40)+PAz*VRR0(35,40)-4.D0*ExZpE*r1x2Z*VRR1(20,40)+WPz*VRR1(35,40)
      VRR0(56,41)=4.D0*r1x2E*VRR0(56,14)+QCy*VRR0(56,25)-4.D0*r1x2E*ZxZpE*VRR1(56,14)+WQy*VRR1(56,25)
      VRR0(56,42)=V(370)+4.D0*r1x2Z*VRR0(20,42)+PAz*VRR0(35,42)-4.D0*ExZpE*r1x2Z*VRR1(20,42)+WPz*VRR1(35,42)
      VRR0(56,43)=V(371)+4.D0*r1x2Z*VRR0(20,43)+PAz*VRR0(35,43)-4.D0*ExZpE*r1x2Z*VRR1(20,43)+WPz*VRR1(35,43)
      VRR0(56,44)=4.D0*r1x2Z*VRR0(20,44)+PAz*VRR0(35,44)-4.D0*ExZpE*r1x2Z*VRR1(20,44)+HfxZpE*VRR1(35,23)+WPz*VRR1(35,44)
      VRR0(56,45)=V(373)+4.D0*r1x2Z*VRR0(20,45)+PAz*VRR0(35,45)-4.D0*ExZpE*r1x2Z*VRR1(20,45)+WPz*VRR1(35,45)
      VRR0(56,46)=V(374)+4.D0*r1x2Z*VRR0(20,46)+PAz*VRR0(35,46)-4.D0*ExZpE*r1x2Z*VRR1(20,46)+WPz*VRR1(35,46)
      VRR0(56,47)=2.D0*V(372)+4.D0*r1x2Z*VRR0(20,47)+PAz*VRR0(35,47)-4.D0*ExZpE*r1x2Z*VRR1(20,47)+WPz*VRR1(35,47)
      VRR0(56,48)=4.D0*r1x2Z*VRR0(20,48)+PAz*VRR0(35,48)-4.D0*ExZpE*r1x2Z*VRR1(20,48)+2.D0*HfxZpE*VRR1(35,27)+WPz*VRR1(35,48)
      VRR0(56,49)=4.D0*r1x2Z*VRR0(20,49)+PAz*VRR0(35,49)-4.D0*ExZpE*r1x2Z*VRR1(20,49)+2.D0*HfxZpE*VRR1(35,28)+WPz*VRR1(35,49)
      VRR0(56,50)=2.D0*V(375)+4.D0*r1x2Z*VRR0(20,50)+PAz*VRR0(35,50)-4.D0*ExZpE*r1x2Z*VRR1(20,50)+WPz*VRR1(35,50)
      VRR0(56,51)=4.D0*r1x2Z*VRR0(20,51)+PAz*VRR0(35,51)-4.D0*ExZpE*r1x2Z*VRR1(20,51)+3.D0*HfxZpE*VRR1(35,30)+WPz*VRR1(35,51)
      VRR0(56,52)=4.D0*r1x2Z*VRR0(20,52)+PAz*VRR0(35,52)-4.D0*ExZpE*r1x2Z*VRR1(20,52)+3.D0*HfxZpE*VRR1(35,31)+WPz*VRR1(35,52)
      VRR0(56,53)=4.D0*r1x2Z*VRR0(20,53)+PAz*VRR0(35,53)-4.D0*ExZpE*r1x2Z*VRR1(20,53)+3.D0*HfxZpE*VRR1(35,32)+WPz*VRR1(35,53)
      VRR0(56,54)=4.D0*r1x2Z*VRR0(20,54)+PAz*VRR0(35,54)-4.D0*ExZpE*r1x2Z*VRR1(20,54)+4.D0*HfxZpE*VRR1(35,33)+WPz*VRR1(35,54)
      VRR0(56,55)=4.D0*r1x2Z*VRR0(20,55)+PAz*VRR0(35,55)-4.D0*ExZpE*r1x2Z*VRR1(20,55)+4.D0*HfxZpE*VRR1(35,34)+WPz*VRR1(35,55)
      VRR0(56,56)=4.D0*r1x2E*VRR0(56,20)+QCz*VRR0(56,35)+5.D0*HfxZpE*VRR1(35,35)-4.D0*r1x2E*ZxZpE*VRR1(56,20)+WQz*VRR1(56,35)
END SUBROUTINE VRRh0h0
SUBROUTINE MVRRh0h0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(36,36)=QCx*VS0(36,21)+WQx*VS1(36,21)-r1x2E*VR1(36,21)&
   +4D0*r1x2E*(VS0(36,11)-ZxZpE*VS1(36,11))&
   +5D0*HfxZpE*VS1(21,21)
VS0(36,37)=QCx*VS0(36,22)+WQx*VS1(36,22)-r1x2E*VR1(36,22)&
   +3D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))&
   +5D0*HfxZpE*VS1(21,22)
VS0(36,38)=QCx*VS0(36,23)+WQx*VS1(36,23)-r1x2E*VR1(36,23)&
   +2D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))&
   +5D0*HfxZpE*VS1(21,23)
VS0(36,39)=QCy*VS0(36,23)+WQy*VS1(36,23)&
   +2D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))
VS0(36,40)=QCy*VS0(36,24)+WQy*VS1(36,24)&
   +3D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))
VS0(36,41)=QCy*VS0(36,25)+WQy*VS1(36,25)&
   +4D0*r1x2E*(VS0(36,14)-ZxZpE*VS1(36,14))
VS0(36,42)=QCx*VS0(36,26)+WQx*VS1(36,26)-r1x2E*VR1(36,26)&
   +3D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))&
   +5D0*HfxZpE*VS1(21,26)
VS0(36,43)=QCx*VS0(36,27)+WQx*VS1(36,27)-r1x2E*VR1(36,27)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))&
   +5D0*HfxZpE*VS1(21,27)
VS0(36,44)=QCx*VS0(36,28)+WQx*VS1(36,28)-r1x2E*VR1(36,28)&
   +r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))&
   +5D0*HfxZpE*VS1(21,28)
VS0(36,45)=QCy*VS0(36,28)+WQy*VS1(36,28)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,46)=QCy*VS0(36,29)+WQy*VS1(36,29)&
   +3D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,47)=QCx*VS0(36,30)+WQx*VS1(36,30)-r1x2E*VR1(36,30)&
   +2D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))&
   +5D0*HfxZpE*VS1(21,30)
VS0(36,48)=QCx*VS0(36,31)+WQx*VS1(36,31)-r1x2E*VR1(36,31)&
   +r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))&
   +5D0*HfxZpE*VS1(21,31)
VS0(36,49)=QCy*VS0(36,31)+WQy*VS1(36,31)&
   +r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,50)=QCy*VS0(36,32)+WQy*VS1(36,32)&
   +2D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,51)=QCz*VS0(36,30)+WQz*VS1(36,30)&
   +2D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))
VS0(36,52)=QCz*VS0(36,31)+WQz*VS1(36,31)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,53)=QCz*VS0(36,32)+WQz*VS1(36,32)&
   +2D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,54)=QCz*VS0(36,33)+WQz*VS1(36,33)&
   +3D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,55)=QCz*VS0(36,34)+WQz*VS1(36,34)&
   +3D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,56)=QCz*VS0(36,35)+WQz*VS1(36,35)&
   +4D0*r1x2E*(VS0(36,20)-ZxZpE*VS1(36,20))
VS0(37,36)=QCx*VS0(37,21)+WQx*VS1(37,21)-r1x2E*VR1(37,21)&
   +4D0*r1x2E*(VS0(37,11)-ZxZpE*VS1(37,11))&
   +4D0*HfxZpE*VS1(22,21)
VS0(37,37)=QCx*VS0(37,22)+WQx*VS1(37,22)-r1x2E*VR1(37,22)&
   +3D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +4D0*HfxZpE*VS1(22,22)
VS0(37,38)=QCx*VS0(37,23)+WQx*VS1(37,23)-r1x2E*VR1(37,23)&
   +2D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +4D0*HfxZpE*VS1(22,23)
VS0(37,39)=QCy*VS0(37,23)+WQy*VS1(37,23)&
   +2D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +HfxZpE*VS1(21,23)
VS0(37,40)=QCy*VS0(37,24)+WQy*VS1(37,24)&
   +3D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +HfxZpE*VS1(21,24)
VS0(37,41)=QCy*VS0(37,25)+WQy*VS1(37,25)&
   +4D0*r1x2E*(VS0(37,14)-ZxZpE*VS1(37,14))&
   +HfxZpE*VS1(21,25)
VS0(37,42)=QCx*VS0(37,26)+WQx*VS1(37,26)-r1x2E*VR1(37,26)&
   +3D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))&
   +4D0*HfxZpE*VS1(22,26)
VS0(37,43)=QCx*VS0(37,27)+WQx*VS1(37,27)-r1x2E*VR1(37,27)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +4D0*HfxZpE*VS1(22,27)
VS0(37,44)=QCx*VS0(37,28)+WQx*VS1(37,28)-r1x2E*VR1(37,28)&
   +r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +4D0*HfxZpE*VS1(22,28)
VS0(37,45)=QCy*VS0(37,28)+WQy*VS1(37,28)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +HfxZpE*VS1(21,28)
VS0(37,46)=QCy*VS0(37,29)+WQy*VS1(37,29)&
   +3D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +HfxZpE*VS1(21,29)
VS0(37,47)=QCx*VS0(37,30)+WQx*VS1(37,30)-r1x2E*VR1(37,30)&
   +2D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +4D0*HfxZpE*VS1(22,30)
VS0(37,48)=QCx*VS0(37,31)+WQx*VS1(37,31)-r1x2E*VR1(37,31)&
   +r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +4D0*HfxZpE*VS1(22,31)
VS0(37,49)=QCy*VS0(37,31)+WQy*VS1(37,31)&
   +r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +HfxZpE*VS1(21,31)
VS0(37,50)=QCy*VS0(37,32)+WQy*VS1(37,32)&
   +2D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +HfxZpE*VS1(21,32)
VS0(37,51)=QCz*VS0(37,30)+WQz*VS1(37,30)&
   +2D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))
VS0(37,52)=QCz*VS0(37,31)+WQz*VS1(37,31)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))
VS0(37,53)=QCz*VS0(37,32)+WQz*VS1(37,32)&
   +2D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))
VS0(37,54)=QCz*VS0(37,33)+WQz*VS1(37,33)&
   +3D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))
VS0(37,55)=QCz*VS0(37,34)+WQz*VS1(37,34)&
   +3D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))
VS0(37,56)=QCz*VS0(37,35)+WQz*VS1(37,35)&
   +4D0*r1x2E*(VS0(37,20)-ZxZpE*VS1(37,20))
VS0(38,36)=QCx*VS0(38,21)+WQx*VS1(38,21)-r1x2E*VR1(38,21)&
   +4D0*r1x2E*(VS0(38,11)-ZxZpE*VS1(38,11))&
   +3D0*HfxZpE*VS1(23,21)
VS0(38,37)=QCx*VS0(38,22)+WQx*VS1(38,22)-r1x2E*VR1(38,22)&
   +3D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +3D0*HfxZpE*VS1(23,22)
VS0(38,38)=QCx*VS0(38,23)+WQx*VS1(38,23)-r1x2E*VR1(38,23)&
   +2D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +3D0*HfxZpE*VS1(23,23)
VS0(38,39)=QCy*VS0(38,23)+WQy*VS1(38,23)&
   +2D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +2D0*HfxZpE*VS1(22,23)
VS0(38,40)=QCy*VS0(38,24)+WQy*VS1(38,24)&
   +3D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +2D0*HfxZpE*VS1(22,24)
VS0(38,41)=QCy*VS0(38,25)+WQy*VS1(38,25)&
   +4D0*r1x2E*(VS0(38,14)-ZxZpE*VS1(38,14))&
   +2D0*HfxZpE*VS1(22,25)
VS0(38,42)=QCx*VS0(38,26)+WQx*VS1(38,26)-r1x2E*VR1(38,26)&
   +3D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))&
   +3D0*HfxZpE*VS1(23,26)
VS0(38,43)=QCx*VS0(38,27)+WQx*VS1(38,27)-r1x2E*VR1(38,27)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +3D0*HfxZpE*VS1(23,27)
VS0(38,44)=QCx*VS0(38,28)+WQx*VS1(38,28)-r1x2E*VR1(38,28)&
   +r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +3D0*HfxZpE*VS1(23,28)
VS0(38,45)=QCy*VS0(38,28)+WQy*VS1(38,28)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +2D0*HfxZpE*VS1(22,28)
VS0(38,46)=QCy*VS0(38,29)+WQy*VS1(38,29)&
   +3D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +2D0*HfxZpE*VS1(22,29)
VS0(38,47)=QCx*VS0(38,30)+WQx*VS1(38,30)-r1x2E*VR1(38,30)&
   +2D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +3D0*HfxZpE*VS1(23,30)
VS0(38,48)=QCx*VS0(38,31)+WQx*VS1(38,31)-r1x2E*VR1(38,31)&
   +r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +3D0*HfxZpE*VS1(23,31)
VS0(38,49)=QCy*VS0(38,31)+WQy*VS1(38,31)&
   +r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +2D0*HfxZpE*VS1(22,31)
VS0(38,50)=QCy*VS0(38,32)+WQy*VS1(38,32)&
   +2D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +2D0*HfxZpE*VS1(22,32)
VS0(38,51)=QCz*VS0(38,30)+WQz*VS1(38,30)&
   +2D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))
VS0(38,52)=QCz*VS0(38,31)+WQz*VS1(38,31)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))
VS0(38,53)=QCz*VS0(38,32)+WQz*VS1(38,32)&
   +2D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))
VS0(38,54)=QCz*VS0(38,33)+WQz*VS1(38,33)&
   +3D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))
VS0(38,55)=QCz*VS0(38,34)+WQz*VS1(38,34)&
   +3D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))
VS0(38,56)=QCz*VS0(38,35)+WQz*VS1(38,35)&
   +4D0*r1x2E*(VS0(38,20)-ZxZpE*VS1(38,20))
VS0(39,36)=QCx*VS0(39,21)+WQx*VS1(39,21)-r1x2E*VR1(39,21)&
   +4D0*r1x2E*(VS0(39,11)-ZxZpE*VS1(39,11))&
   +2D0*HfxZpE*VS1(24,21)
VS0(39,37)=QCx*VS0(39,22)+WQx*VS1(39,22)-r1x2E*VR1(39,22)&
   +3D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +2D0*HfxZpE*VS1(24,22)
VS0(39,38)=QCx*VS0(39,23)+WQx*VS1(39,23)-r1x2E*VR1(39,23)&
   +2D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +2D0*HfxZpE*VS1(24,23)
VS0(39,39)=QCy*VS0(39,23)+WQy*VS1(39,23)&
   +2D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +3D0*HfxZpE*VS1(23,23)
VS0(39,40)=QCy*VS0(39,24)+WQy*VS1(39,24)&
   +3D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +3D0*HfxZpE*VS1(23,24)
VS0(39,41)=QCy*VS0(39,25)+WQy*VS1(39,25)&
   +4D0*r1x2E*(VS0(39,14)-ZxZpE*VS1(39,14))&
   +3D0*HfxZpE*VS1(23,25)
VS0(39,42)=QCx*VS0(39,26)+WQx*VS1(39,26)-r1x2E*VR1(39,26)&
   +3D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))&
   +2D0*HfxZpE*VS1(24,26)
VS0(39,43)=QCx*VS0(39,27)+WQx*VS1(39,27)-r1x2E*VR1(39,27)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +2D0*HfxZpE*VS1(24,27)
VS0(39,44)=QCx*VS0(39,28)+WQx*VS1(39,28)-r1x2E*VR1(39,28)&
   +r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +2D0*HfxZpE*VS1(24,28)
VS0(39,45)=QCy*VS0(39,28)+WQy*VS1(39,28)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +3D0*HfxZpE*VS1(23,28)
VS0(39,46)=QCy*VS0(39,29)+WQy*VS1(39,29)&
   +3D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +3D0*HfxZpE*VS1(23,29)
VS0(39,47)=QCx*VS0(39,30)+WQx*VS1(39,30)-r1x2E*VR1(39,30)&
   +2D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +2D0*HfxZpE*VS1(24,30)
VS0(39,48)=QCx*VS0(39,31)+WQx*VS1(39,31)-r1x2E*VR1(39,31)&
   +r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +2D0*HfxZpE*VS1(24,31)
VS0(39,49)=QCy*VS0(39,31)+WQy*VS1(39,31)&
   +r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +3D0*HfxZpE*VS1(23,31)
VS0(39,50)=QCy*VS0(39,32)+WQy*VS1(39,32)&
   +2D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +3D0*HfxZpE*VS1(23,32)
VS0(39,51)=QCz*VS0(39,30)+WQz*VS1(39,30)&
   +2D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))
VS0(39,52)=QCz*VS0(39,31)+WQz*VS1(39,31)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))
VS0(39,53)=QCz*VS0(39,32)+WQz*VS1(39,32)&
   +2D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))
VS0(39,54)=QCz*VS0(39,33)+WQz*VS1(39,33)&
   +3D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))
VS0(39,55)=QCz*VS0(39,34)+WQz*VS1(39,34)&
   +3D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))
VS0(39,56)=QCz*VS0(39,35)+WQz*VS1(39,35)&
   +4D0*r1x2E*(VS0(39,20)-ZxZpE*VS1(39,20))
VS0(40,36)=QCx*VS0(40,21)+WQx*VS1(40,21)-r1x2E*VR1(40,21)&
   +4D0*r1x2E*(VS0(40,11)-ZxZpE*VS1(40,11))&
   +HfxZpE*VS1(25,21)
VS0(40,37)=QCx*VS0(40,22)+WQx*VS1(40,22)-r1x2E*VR1(40,22)&
   +3D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +HfxZpE*VS1(25,22)
VS0(40,38)=QCx*VS0(40,23)+WQx*VS1(40,23)-r1x2E*VR1(40,23)&
   +2D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +HfxZpE*VS1(25,23)
VS0(40,39)=QCy*VS0(40,23)+WQy*VS1(40,23)&
   +2D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +4D0*HfxZpE*VS1(24,23)
VS0(40,40)=QCy*VS0(40,24)+WQy*VS1(40,24)&
   +3D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +4D0*HfxZpE*VS1(24,24)
VS0(40,41)=QCy*VS0(40,25)+WQy*VS1(40,25)&
   +4D0*r1x2E*(VS0(40,14)-ZxZpE*VS1(40,14))&
   +4D0*HfxZpE*VS1(24,25)
VS0(40,42)=QCx*VS0(40,26)+WQx*VS1(40,26)-r1x2E*VR1(40,26)&
   +3D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))&
   +HfxZpE*VS1(25,26)
VS0(40,43)=QCx*VS0(40,27)+WQx*VS1(40,27)-r1x2E*VR1(40,27)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +HfxZpE*VS1(25,27)
VS0(40,44)=QCx*VS0(40,28)+WQx*VS1(40,28)-r1x2E*VR1(40,28)&
   +r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +HfxZpE*VS1(25,28)
VS0(40,45)=QCy*VS0(40,28)+WQy*VS1(40,28)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +4D0*HfxZpE*VS1(24,28)
VS0(40,46)=QCy*VS0(40,29)+WQy*VS1(40,29)&
   +3D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +4D0*HfxZpE*VS1(24,29)
VS0(40,47)=QCx*VS0(40,30)+WQx*VS1(40,30)-r1x2E*VR1(40,30)&
   +2D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +HfxZpE*VS1(25,30)
VS0(40,48)=QCx*VS0(40,31)+WQx*VS1(40,31)-r1x2E*VR1(40,31)&
   +r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +HfxZpE*VS1(25,31)
VS0(40,49)=QCy*VS0(40,31)+WQy*VS1(40,31)&
   +r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +4D0*HfxZpE*VS1(24,31)
VS0(40,50)=QCy*VS0(40,32)+WQy*VS1(40,32)&
   +2D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +4D0*HfxZpE*VS1(24,32)
VS0(40,51)=QCz*VS0(40,30)+WQz*VS1(40,30)&
   +2D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))
VS0(40,52)=QCz*VS0(40,31)+WQz*VS1(40,31)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))
VS0(40,53)=QCz*VS0(40,32)+WQz*VS1(40,32)&
   +2D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))
VS0(40,54)=QCz*VS0(40,33)+WQz*VS1(40,33)&
   +3D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))
VS0(40,55)=QCz*VS0(40,34)+WQz*VS1(40,34)&
   +3D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))
VS0(40,56)=QCz*VS0(40,35)+WQz*VS1(40,35)&
   +4D0*r1x2E*(VS0(40,20)-ZxZpE*VS1(40,20))
VS0(41,36)=QCx*VS0(41,21)+WQx*VS1(41,21)-r1x2E*VR1(41,21)&
   +4D0*r1x2E*(VS0(41,11)-ZxZpE*VS1(41,11))
VS0(41,37)=QCx*VS0(41,22)+WQx*VS1(41,22)-r1x2E*VR1(41,22)&
   +3D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))
VS0(41,38)=QCx*VS0(41,23)+WQx*VS1(41,23)-r1x2E*VR1(41,23)&
   +2D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))
VS0(41,39)=QCy*VS0(41,23)+WQy*VS1(41,23)&
   +2D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))&
   +5D0*HfxZpE*VS1(25,23)
VS0(41,40)=QCy*VS0(41,24)+WQy*VS1(41,24)&
   +3D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))&
   +5D0*HfxZpE*VS1(25,24)
VS0(41,41)=QCy*VS0(41,25)+WQy*VS1(41,25)&
   +4D0*r1x2E*(VS0(41,14)-ZxZpE*VS1(41,14))&
   +5D0*HfxZpE*VS1(25,25)
VS0(41,42)=QCx*VS0(41,26)+WQx*VS1(41,26)-r1x2E*VR1(41,26)&
   +3D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,43)=QCx*VS0(41,27)+WQx*VS1(41,27)-r1x2E*VR1(41,27)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,44)=QCx*VS0(41,28)+WQx*VS1(41,28)-r1x2E*VR1(41,28)&
   +r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,45)=QCy*VS0(41,28)+WQy*VS1(41,28)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))&
   +5D0*HfxZpE*VS1(25,28)
VS0(41,46)=QCy*VS0(41,29)+WQy*VS1(41,29)&
   +3D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))&
   +5D0*HfxZpE*VS1(25,29)
VS0(41,47)=QCx*VS0(41,30)+WQx*VS1(41,30)-r1x2E*VR1(41,30)&
   +2D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,48)=QCx*VS0(41,31)+WQx*VS1(41,31)-r1x2E*VR1(41,31)&
   +r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,49)=QCy*VS0(41,31)+WQy*VS1(41,31)&
   +r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))&
   +5D0*HfxZpE*VS1(25,31)
VS0(41,50)=QCy*VS0(41,32)+WQy*VS1(41,32)&
   +2D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))&
   +5D0*HfxZpE*VS1(25,32)
VS0(41,51)=QCz*VS0(41,30)+WQz*VS1(41,30)&
   +2D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,52)=QCz*VS0(41,31)+WQz*VS1(41,31)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,53)=QCz*VS0(41,32)+WQz*VS1(41,32)&
   +2D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,54)=QCz*VS0(41,33)+WQz*VS1(41,33)&
   +3D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,55)=QCz*VS0(41,34)+WQz*VS1(41,34)&
   +3D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,56)=QCz*VS0(41,35)+WQz*VS1(41,35)&
   +4D0*r1x2E*(VS0(41,20)-ZxZpE*VS1(41,20))
VS0(42,36)=QCx*VS0(42,21)+WQx*VS1(42,21)-r1x2E*VR1(42,21)&
   +4D0*r1x2E*(VS0(42,11)-ZxZpE*VS1(42,11))&
   +4D0*HfxZpE*VS1(26,21)
VS0(42,37)=QCx*VS0(42,22)+WQx*VS1(42,22)-r1x2E*VR1(42,22)&
   +3D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))&
   +4D0*HfxZpE*VS1(26,22)
VS0(42,38)=QCx*VS0(42,23)+WQx*VS1(42,23)-r1x2E*VR1(42,23)&
   +2D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))&
   +4D0*HfxZpE*VS1(26,23)
VS0(42,39)=QCy*VS0(42,23)+WQy*VS1(42,23)&
   +2D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))
VS0(42,40)=QCy*VS0(42,24)+WQy*VS1(42,24)&
   +3D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))
VS0(42,41)=QCy*VS0(42,25)+WQy*VS1(42,25)&
   +4D0*r1x2E*(VS0(42,14)-ZxZpE*VS1(42,14))
VS0(42,42)=QCx*VS0(42,26)+WQx*VS1(42,26)-r1x2E*VR1(42,26)&
   +3D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +4D0*HfxZpE*VS1(26,26)
VS0(42,43)=QCx*VS0(42,27)+WQx*VS1(42,27)-r1x2E*VR1(42,27)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +4D0*HfxZpE*VS1(26,27)
VS0(42,44)=QCx*VS0(42,28)+WQx*VS1(42,28)-r1x2E*VR1(42,28)&
   +r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +4D0*HfxZpE*VS1(26,28)
VS0(42,45)=QCy*VS0(42,28)+WQy*VS1(42,28)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))
VS0(42,46)=QCy*VS0(42,29)+WQy*VS1(42,29)&
   +3D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))
VS0(42,47)=QCx*VS0(42,30)+WQx*VS1(42,30)-r1x2E*VR1(42,30)&
   +2D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +4D0*HfxZpE*VS1(26,30)
VS0(42,48)=QCx*VS0(42,31)+WQx*VS1(42,31)-r1x2E*VR1(42,31)&
   +r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +4D0*HfxZpE*VS1(26,31)
VS0(42,49)=QCy*VS0(42,31)+WQy*VS1(42,31)&
   +r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))
VS0(42,50)=QCy*VS0(42,32)+WQy*VS1(42,32)&
   +2D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))
VS0(42,51)=QCz*VS0(42,30)+WQz*VS1(42,30)&
   +2D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +HfxZpE*VS1(21,30)
VS0(42,52)=QCz*VS0(42,31)+WQz*VS1(42,31)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +HfxZpE*VS1(21,31)
VS0(42,53)=QCz*VS0(42,32)+WQz*VS1(42,32)&
   +2D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +HfxZpE*VS1(21,32)
VS0(42,54)=QCz*VS0(42,33)+WQz*VS1(42,33)&
   +3D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +HfxZpE*VS1(21,33)
VS0(42,55)=QCz*VS0(42,34)+WQz*VS1(42,34)&
   +3D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +HfxZpE*VS1(21,34)
VS0(42,56)=QCz*VS0(42,35)+WQz*VS1(42,35)&
   +4D0*r1x2E*(VS0(42,20)-ZxZpE*VS1(42,20))&
   +HfxZpE*VS1(21,35)
VS0(43,36)=QCx*VS0(43,21)+WQx*VS1(43,21)-r1x2E*VR1(43,21)&
   +4D0*r1x2E*(VS0(43,11)-ZxZpE*VS1(43,11))&
   +3D0*HfxZpE*VS1(27,21)
VS0(43,37)=QCx*VS0(43,22)+WQx*VS1(43,22)-r1x2E*VR1(43,22)&
   +3D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +3D0*HfxZpE*VS1(27,22)
VS0(43,38)=QCx*VS0(43,23)+WQx*VS1(43,23)-r1x2E*VR1(43,23)&
   +2D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +3D0*HfxZpE*VS1(27,23)
VS0(43,39)=QCy*VS0(43,23)+WQy*VS1(43,23)&
   +2D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +HfxZpE*VS1(26,23)
VS0(43,40)=QCy*VS0(43,24)+WQy*VS1(43,24)&
   +3D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +HfxZpE*VS1(26,24)
VS0(43,41)=QCy*VS0(43,25)+WQy*VS1(43,25)&
   +4D0*r1x2E*(VS0(43,14)-ZxZpE*VS1(43,14))&
   +HfxZpE*VS1(26,25)
VS0(43,42)=QCx*VS0(43,26)+WQx*VS1(43,26)-r1x2E*VR1(43,26)&
   +3D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +3D0*HfxZpE*VS1(27,26)
VS0(43,43)=QCx*VS0(43,27)+WQx*VS1(43,27)-r1x2E*VR1(43,27)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +3D0*HfxZpE*VS1(27,27)
VS0(43,44)=QCx*VS0(43,28)+WQx*VS1(43,28)-r1x2E*VR1(43,28)&
   +r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +3D0*HfxZpE*VS1(27,28)
VS0(43,45)=QCy*VS0(43,28)+WQy*VS1(43,28)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(26,28)
VS0(43,46)=QCy*VS0(43,29)+WQy*VS1(43,29)&
   +3D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(26,29)
VS0(43,47)=QCx*VS0(43,30)+WQx*VS1(43,30)-r1x2E*VR1(43,30)&
   +2D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +3D0*HfxZpE*VS1(27,30)
VS0(43,48)=QCx*VS0(43,31)+WQx*VS1(43,31)-r1x2E*VR1(43,31)&
   +r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +3D0*HfxZpE*VS1(27,31)
VS0(43,49)=QCy*VS0(43,31)+WQy*VS1(43,31)&
   +r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(26,31)
VS0(43,50)=QCy*VS0(43,32)+WQy*VS1(43,32)&
   +2D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(26,32)
VS0(43,51)=QCz*VS0(43,30)+WQz*VS1(43,30)&
   +2D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +HfxZpE*VS1(22,30)
VS0(43,52)=QCz*VS0(43,31)+WQz*VS1(43,31)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(22,31)
VS0(43,53)=QCz*VS0(43,32)+WQz*VS1(43,32)&
   +2D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(22,32)
VS0(43,54)=QCz*VS0(43,33)+WQz*VS1(43,33)&
   +3D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(22,33)
VS0(43,55)=QCz*VS0(43,34)+WQz*VS1(43,34)&
   +3D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(22,34)
VS0(43,56)=QCz*VS0(43,35)+WQz*VS1(43,35)&
   +4D0*r1x2E*(VS0(43,20)-ZxZpE*VS1(43,20))&
   +HfxZpE*VS1(22,35)
VS0(44,36)=QCx*VS0(44,21)+WQx*VS1(44,21)-r1x2E*VR1(44,21)&
   +4D0*r1x2E*(VS0(44,11)-ZxZpE*VS1(44,11))&
   +2D0*HfxZpE*VS1(28,21)
VS0(44,37)=QCx*VS0(44,22)+WQx*VS1(44,22)-r1x2E*VR1(44,22)&
   +3D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(28,22)
VS0(44,38)=QCx*VS0(44,23)+WQx*VS1(44,23)-r1x2E*VR1(44,23)&
   +2D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(28,23)
VS0(44,39)=QCy*VS0(44,23)+WQy*VS1(44,23)&
   +2D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(27,23)
VS0(44,40)=QCy*VS0(44,24)+WQy*VS1(44,24)&
   +3D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(27,24)
VS0(44,41)=QCy*VS0(44,25)+WQy*VS1(44,25)&
   +4D0*r1x2E*(VS0(44,14)-ZxZpE*VS1(44,14))&
   +2D0*HfxZpE*VS1(27,25)
VS0(44,42)=QCx*VS0(44,26)+WQx*VS1(44,26)-r1x2E*VR1(44,26)&
   +3D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +2D0*HfxZpE*VS1(28,26)
VS0(44,43)=QCx*VS0(44,27)+WQx*VS1(44,27)-r1x2E*VR1(44,27)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(28,27)
VS0(44,44)=QCx*VS0(44,28)+WQx*VS1(44,28)-r1x2E*VR1(44,28)&
   +r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(28,28)
VS0(44,45)=QCy*VS0(44,28)+WQy*VS1(44,28)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(27,28)
VS0(44,46)=QCy*VS0(44,29)+WQy*VS1(44,29)&
   +3D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(27,29)
VS0(44,47)=QCx*VS0(44,30)+WQx*VS1(44,30)-r1x2E*VR1(44,30)&
   +2D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(28,30)
VS0(44,48)=QCx*VS0(44,31)+WQx*VS1(44,31)-r1x2E*VR1(44,31)&
   +r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(28,31)
VS0(44,49)=QCy*VS0(44,31)+WQy*VS1(44,31)&
   +r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(27,31)
VS0(44,50)=QCy*VS0(44,32)+WQy*VS1(44,32)&
   +2D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(27,32)
VS0(44,51)=QCz*VS0(44,30)+WQz*VS1(44,30)&
   +2D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +HfxZpE*VS1(23,30)
VS0(44,52)=QCz*VS0(44,31)+WQz*VS1(44,31)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +HfxZpE*VS1(23,31)
VS0(44,53)=QCz*VS0(44,32)+WQz*VS1(44,32)&
   +2D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +HfxZpE*VS1(23,32)
VS0(44,54)=QCz*VS0(44,33)+WQz*VS1(44,33)&
   +3D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +HfxZpE*VS1(23,33)
VS0(44,55)=QCz*VS0(44,34)+WQz*VS1(44,34)&
   +3D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +HfxZpE*VS1(23,34)
VS0(44,56)=QCz*VS0(44,35)+WQz*VS1(44,35)&
   +4D0*r1x2E*(VS0(44,20)-ZxZpE*VS1(44,20))&
   +HfxZpE*VS1(23,35)
VS0(45,36)=QCx*VS0(45,21)+WQx*VS1(45,21)-r1x2E*VR1(45,21)&
   +4D0*r1x2E*(VS0(45,11)-ZxZpE*VS1(45,11))&
   +HfxZpE*VS1(29,21)
VS0(45,37)=QCx*VS0(45,22)+WQx*VS1(45,22)-r1x2E*VR1(45,22)&
   +3D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +HfxZpE*VS1(29,22)
VS0(45,38)=QCx*VS0(45,23)+WQx*VS1(45,23)-r1x2E*VR1(45,23)&
   +2D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +HfxZpE*VS1(29,23)
VS0(45,39)=QCy*VS0(45,23)+WQy*VS1(45,23)&
   +2D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +3D0*HfxZpE*VS1(28,23)
VS0(45,40)=QCy*VS0(45,24)+WQy*VS1(45,24)&
   +3D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +3D0*HfxZpE*VS1(28,24)
VS0(45,41)=QCy*VS0(45,25)+WQy*VS1(45,25)&
   +4D0*r1x2E*(VS0(45,14)-ZxZpE*VS1(45,14))&
   +3D0*HfxZpE*VS1(28,25)
VS0(45,42)=QCx*VS0(45,26)+WQx*VS1(45,26)-r1x2E*VR1(45,26)&
   +3D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(29,26)
VS0(45,43)=QCx*VS0(45,27)+WQx*VS1(45,27)-r1x2E*VR1(45,27)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(29,27)
VS0(45,44)=QCx*VS0(45,28)+WQx*VS1(45,28)-r1x2E*VR1(45,28)&
   +r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(29,28)
VS0(45,45)=QCy*VS0(45,28)+WQy*VS1(45,28)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +3D0*HfxZpE*VS1(28,28)
VS0(45,46)=QCy*VS0(45,29)+WQy*VS1(45,29)&
   +3D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +3D0*HfxZpE*VS1(28,29)
VS0(45,47)=QCx*VS0(45,30)+WQx*VS1(45,30)-r1x2E*VR1(45,30)&
   +2D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(29,30)
VS0(45,48)=QCx*VS0(45,31)+WQx*VS1(45,31)-r1x2E*VR1(45,31)&
   +r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(29,31)
VS0(45,49)=QCy*VS0(45,31)+WQy*VS1(45,31)&
   +r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +3D0*HfxZpE*VS1(28,31)
VS0(45,50)=QCy*VS0(45,32)+WQy*VS1(45,32)&
   +2D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +3D0*HfxZpE*VS1(28,32)
VS0(45,51)=QCz*VS0(45,30)+WQz*VS1(45,30)&
   +2D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(24,30)
VS0(45,52)=QCz*VS0(45,31)+WQz*VS1(45,31)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(24,31)
VS0(45,53)=QCz*VS0(45,32)+WQz*VS1(45,32)&
   +2D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(24,32)
VS0(45,54)=QCz*VS0(45,33)+WQz*VS1(45,33)&
   +3D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(24,33)
VS0(45,55)=QCz*VS0(45,34)+WQz*VS1(45,34)&
   +3D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(24,34)
VS0(45,56)=QCz*VS0(45,35)+WQz*VS1(45,35)&
   +4D0*r1x2E*(VS0(45,20)-ZxZpE*VS1(45,20))&
   +HfxZpE*VS1(24,35)
VS0(46,36)=QCx*VS0(46,21)+WQx*VS1(46,21)-r1x2E*VR1(46,21)&
   +4D0*r1x2E*(VS0(46,11)-ZxZpE*VS1(46,11))
VS0(46,37)=QCx*VS0(46,22)+WQx*VS1(46,22)-r1x2E*VR1(46,22)&
   +3D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))
VS0(46,38)=QCx*VS0(46,23)+WQx*VS1(46,23)-r1x2E*VR1(46,23)&
   +2D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))
VS0(46,39)=QCy*VS0(46,23)+WQy*VS1(46,23)&
   +2D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))&
   +4D0*HfxZpE*VS1(29,23)
VS0(46,40)=QCy*VS0(46,24)+WQy*VS1(46,24)&
   +3D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))&
   +4D0*HfxZpE*VS1(29,24)
VS0(46,41)=QCy*VS0(46,25)+WQy*VS1(46,25)&
   +4D0*r1x2E*(VS0(46,14)-ZxZpE*VS1(46,14))&
   +4D0*HfxZpE*VS1(29,25)
VS0(46,42)=QCx*VS0(46,26)+WQx*VS1(46,26)-r1x2E*VR1(46,26)&
   +3D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))
VS0(46,43)=QCx*VS0(46,27)+WQx*VS1(46,27)-r1x2E*VR1(46,27)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))
VS0(46,44)=QCx*VS0(46,28)+WQx*VS1(46,28)-r1x2E*VR1(46,28)&
   +r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))
VS0(46,45)=QCy*VS0(46,28)+WQy*VS1(46,28)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +4D0*HfxZpE*VS1(29,28)
VS0(46,46)=QCy*VS0(46,29)+WQy*VS1(46,29)&
   +3D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +4D0*HfxZpE*VS1(29,29)
VS0(46,47)=QCx*VS0(46,30)+WQx*VS1(46,30)-r1x2E*VR1(46,30)&
   +2D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))
VS0(46,48)=QCx*VS0(46,31)+WQx*VS1(46,31)-r1x2E*VR1(46,31)&
   +r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))
VS0(46,49)=QCy*VS0(46,31)+WQy*VS1(46,31)&
   +r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +4D0*HfxZpE*VS1(29,31)
VS0(46,50)=QCy*VS0(46,32)+WQy*VS1(46,32)&
   +2D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +4D0*HfxZpE*VS1(29,32)
VS0(46,51)=QCz*VS0(46,30)+WQz*VS1(46,30)&
   +2D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))&
   +HfxZpE*VS1(25,30)
VS0(46,52)=QCz*VS0(46,31)+WQz*VS1(46,31)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +HfxZpE*VS1(25,31)
VS0(46,53)=QCz*VS0(46,32)+WQz*VS1(46,32)&
   +2D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +HfxZpE*VS1(25,32)
VS0(46,54)=QCz*VS0(46,33)+WQz*VS1(46,33)&
   +3D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +HfxZpE*VS1(25,33)
VS0(46,55)=QCz*VS0(46,34)+WQz*VS1(46,34)&
   +3D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +HfxZpE*VS1(25,34)
VS0(46,56)=QCz*VS0(46,35)+WQz*VS1(46,35)&
   +4D0*r1x2E*(VS0(46,20)-ZxZpE*VS1(46,20))&
   +HfxZpE*VS1(25,35)
VS0(47,36)=QCx*VS0(47,21)+WQx*VS1(47,21)-r1x2E*VR1(47,21)&
   +4D0*r1x2E*(VS0(47,11)-ZxZpE*VS1(47,11))&
   +3D0*HfxZpE*VS1(30,21)
VS0(47,37)=QCx*VS0(47,22)+WQx*VS1(47,22)-r1x2E*VR1(47,22)&
   +3D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))&
   +3D0*HfxZpE*VS1(30,22)
VS0(47,38)=QCx*VS0(47,23)+WQx*VS1(47,23)-r1x2E*VR1(47,23)&
   +2D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))&
   +3D0*HfxZpE*VS1(30,23)
VS0(47,39)=QCy*VS0(47,23)+WQy*VS1(47,23)&
   +2D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))
VS0(47,40)=QCy*VS0(47,24)+WQy*VS1(47,24)&
   +3D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))
VS0(47,41)=QCy*VS0(47,25)+WQy*VS1(47,25)&
   +4D0*r1x2E*(VS0(47,14)-ZxZpE*VS1(47,14))
VS0(47,42)=QCx*VS0(47,26)+WQx*VS1(47,26)-r1x2E*VR1(47,26)&
   +3D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +3D0*HfxZpE*VS1(30,26)
VS0(47,43)=QCx*VS0(47,27)+WQx*VS1(47,27)-r1x2E*VR1(47,27)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +3D0*HfxZpE*VS1(30,27)
VS0(47,44)=QCx*VS0(47,28)+WQx*VS1(47,28)-r1x2E*VR1(47,28)&
   +r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +3D0*HfxZpE*VS1(30,28)
VS0(47,45)=QCy*VS0(47,28)+WQy*VS1(47,28)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))
VS0(47,46)=QCy*VS0(47,29)+WQy*VS1(47,29)&
   +3D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))
VS0(47,47)=QCx*VS0(47,30)+WQx*VS1(47,30)-r1x2E*VR1(47,30)&
   +2D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +3D0*HfxZpE*VS1(30,30)
VS0(47,48)=QCx*VS0(47,31)+WQx*VS1(47,31)-r1x2E*VR1(47,31)&
   +r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +3D0*HfxZpE*VS1(30,31)
VS0(47,49)=QCy*VS0(47,31)+WQy*VS1(47,31)&
   +r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))
VS0(47,50)=QCy*VS0(47,32)+WQy*VS1(47,32)&
   +2D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))
VS0(47,51)=QCz*VS0(47,30)+WQz*VS1(47,30)&
   +2D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +2D0*HfxZpE*VS1(26,30)
VS0(47,52)=QCz*VS0(47,31)+WQz*VS1(47,31)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +2D0*HfxZpE*VS1(26,31)
VS0(47,53)=QCz*VS0(47,32)+WQz*VS1(47,32)&
   +2D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +2D0*HfxZpE*VS1(26,32)
VS0(47,54)=QCz*VS0(47,33)+WQz*VS1(47,33)&
   +3D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +2D0*HfxZpE*VS1(26,33)
VS0(47,55)=QCz*VS0(47,34)+WQz*VS1(47,34)&
   +3D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +2D0*HfxZpE*VS1(26,34)
VS0(47,56)=QCz*VS0(47,35)+WQz*VS1(47,35)&
   +4D0*r1x2E*(VS0(47,20)-ZxZpE*VS1(47,20))&
   +2D0*HfxZpE*VS1(26,35)
VS0(48,36)=QCx*VS0(48,21)+WQx*VS1(48,21)-r1x2E*VR1(48,21)&
   +4D0*r1x2E*(VS0(48,11)-ZxZpE*VS1(48,11))&
   +2D0*HfxZpE*VS1(31,21)
VS0(48,37)=QCx*VS0(48,22)+WQx*VS1(48,22)-r1x2E*VR1(48,22)&
   +3D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +2D0*HfxZpE*VS1(31,22)
VS0(48,38)=QCx*VS0(48,23)+WQx*VS1(48,23)-r1x2E*VR1(48,23)&
   +2D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +2D0*HfxZpE*VS1(31,23)
VS0(48,39)=QCy*VS0(48,23)+WQy*VS1(48,23)&
   +2D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +HfxZpE*VS1(30,23)
VS0(48,40)=QCy*VS0(48,24)+WQy*VS1(48,24)&
   +3D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +HfxZpE*VS1(30,24)
VS0(48,41)=QCy*VS0(48,25)+WQy*VS1(48,25)&
   +4D0*r1x2E*(VS0(48,14)-ZxZpE*VS1(48,14))&
   +HfxZpE*VS1(30,25)
VS0(48,42)=QCx*VS0(48,26)+WQx*VS1(48,26)-r1x2E*VR1(48,26)&
   +3D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(31,26)
VS0(48,43)=QCx*VS0(48,27)+WQx*VS1(48,27)-r1x2E*VR1(48,27)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(31,27)
VS0(48,44)=QCx*VS0(48,28)+WQx*VS1(48,28)-r1x2E*VR1(48,28)&
   +r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(31,28)
VS0(48,45)=QCy*VS0(48,28)+WQy*VS1(48,28)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +HfxZpE*VS1(30,28)
VS0(48,46)=QCy*VS0(48,29)+WQy*VS1(48,29)&
   +3D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +HfxZpE*VS1(30,29)
VS0(48,47)=QCx*VS0(48,30)+WQx*VS1(48,30)-r1x2E*VR1(48,30)&
   +2D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(31,30)
VS0(48,48)=QCx*VS0(48,31)+WQx*VS1(48,31)-r1x2E*VR1(48,31)&
   +r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(31,31)
VS0(48,49)=QCy*VS0(48,31)+WQy*VS1(48,31)&
   +r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +HfxZpE*VS1(30,31)
VS0(48,50)=QCy*VS0(48,32)+WQy*VS1(48,32)&
   +2D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +HfxZpE*VS1(30,32)
VS0(48,51)=QCz*VS0(48,30)+WQz*VS1(48,30)&
   +2D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(27,30)
VS0(48,52)=QCz*VS0(48,31)+WQz*VS1(48,31)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(27,31)
VS0(48,53)=QCz*VS0(48,32)+WQz*VS1(48,32)&
   +2D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(27,32)
VS0(48,54)=QCz*VS0(48,33)+WQz*VS1(48,33)&
   +3D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(27,33)
VS0(48,55)=QCz*VS0(48,34)+WQz*VS1(48,34)&
   +3D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(27,34)
VS0(48,56)=QCz*VS0(48,35)+WQz*VS1(48,35)&
   +4D0*r1x2E*(VS0(48,20)-ZxZpE*VS1(48,20))&
   +2D0*HfxZpE*VS1(27,35)
VS0(49,36)=QCx*VS0(49,21)+WQx*VS1(49,21)-r1x2E*VR1(49,21)&
   +4D0*r1x2E*(VS0(49,11)-ZxZpE*VS1(49,11))&
   +HfxZpE*VS1(32,21)
VS0(49,37)=QCx*VS0(49,22)+WQx*VS1(49,22)-r1x2E*VR1(49,22)&
   +3D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +HfxZpE*VS1(32,22)
VS0(49,38)=QCx*VS0(49,23)+WQx*VS1(49,23)-r1x2E*VR1(49,23)&
   +2D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +HfxZpE*VS1(32,23)
VS0(49,39)=QCy*VS0(49,23)+WQy*VS1(49,23)&
   +2D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +2D0*HfxZpE*VS1(31,23)
VS0(49,40)=QCy*VS0(49,24)+WQy*VS1(49,24)&
   +3D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +2D0*HfxZpE*VS1(31,24)
VS0(49,41)=QCy*VS0(49,25)+WQy*VS1(49,25)&
   +4D0*r1x2E*(VS0(49,14)-ZxZpE*VS1(49,14))&
   +2D0*HfxZpE*VS1(31,25)
VS0(49,42)=QCx*VS0(49,26)+WQx*VS1(49,26)-r1x2E*VR1(49,26)&
   +3D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +HfxZpE*VS1(32,26)
VS0(49,43)=QCx*VS0(49,27)+WQx*VS1(49,27)-r1x2E*VR1(49,27)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +HfxZpE*VS1(32,27)
VS0(49,44)=QCx*VS0(49,28)+WQx*VS1(49,28)-r1x2E*VR1(49,28)&
   +r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +HfxZpE*VS1(32,28)
VS0(49,45)=QCy*VS0(49,28)+WQy*VS1(49,28)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(31,28)
VS0(49,46)=QCy*VS0(49,29)+WQy*VS1(49,29)&
   +3D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(31,29)
VS0(49,47)=QCx*VS0(49,30)+WQx*VS1(49,30)-r1x2E*VR1(49,30)&
   +2D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +HfxZpE*VS1(32,30)
VS0(49,48)=QCx*VS0(49,31)+WQx*VS1(49,31)-r1x2E*VR1(49,31)&
   +r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +HfxZpE*VS1(32,31)
VS0(49,49)=QCy*VS0(49,31)+WQy*VS1(49,31)&
   +r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(31,31)
VS0(49,50)=QCy*VS0(49,32)+WQy*VS1(49,32)&
   +2D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(31,32)
VS0(49,51)=QCz*VS0(49,30)+WQz*VS1(49,30)&
   +2D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +2D0*HfxZpE*VS1(28,30)
VS0(49,52)=QCz*VS0(49,31)+WQz*VS1(49,31)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(28,31)
VS0(49,53)=QCz*VS0(49,32)+WQz*VS1(49,32)&
   +2D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(28,32)
VS0(49,54)=QCz*VS0(49,33)+WQz*VS1(49,33)&
   +3D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(28,33)
VS0(49,55)=QCz*VS0(49,34)+WQz*VS1(49,34)&
   +3D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(28,34)
VS0(49,56)=QCz*VS0(49,35)+WQz*VS1(49,35)&
   +4D0*r1x2E*(VS0(49,20)-ZxZpE*VS1(49,20))&
   +2D0*HfxZpE*VS1(28,35)
VS0(50,36)=QCx*VS0(50,21)+WQx*VS1(50,21)-r1x2E*VR1(50,21)&
   +4D0*r1x2E*(VS0(50,11)-ZxZpE*VS1(50,11))
VS0(50,37)=QCx*VS0(50,22)+WQx*VS1(50,22)-r1x2E*VR1(50,22)&
   +3D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))
VS0(50,38)=QCx*VS0(50,23)+WQx*VS1(50,23)-r1x2E*VR1(50,23)&
   +2D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))
VS0(50,39)=QCy*VS0(50,23)+WQy*VS1(50,23)&
   +2D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))&
   +3D0*HfxZpE*VS1(32,23)
VS0(50,40)=QCy*VS0(50,24)+WQy*VS1(50,24)&
   +3D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))&
   +3D0*HfxZpE*VS1(32,24)
VS0(50,41)=QCy*VS0(50,25)+WQy*VS1(50,25)&
   +4D0*r1x2E*(VS0(50,14)-ZxZpE*VS1(50,14))&
   +3D0*HfxZpE*VS1(32,25)
VS0(50,42)=QCx*VS0(50,26)+WQx*VS1(50,26)-r1x2E*VR1(50,26)&
   +3D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))
VS0(50,43)=QCx*VS0(50,27)+WQx*VS1(50,27)-r1x2E*VR1(50,27)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))
VS0(50,44)=QCx*VS0(50,28)+WQx*VS1(50,28)-r1x2E*VR1(50,28)&
   +r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))
VS0(50,45)=QCy*VS0(50,28)+WQy*VS1(50,28)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +3D0*HfxZpE*VS1(32,28)
VS0(50,46)=QCy*VS0(50,29)+WQy*VS1(50,29)&
   +3D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +3D0*HfxZpE*VS1(32,29)
VS0(50,47)=QCx*VS0(50,30)+WQx*VS1(50,30)-r1x2E*VR1(50,30)&
   +2D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))
VS0(50,48)=QCx*VS0(50,31)+WQx*VS1(50,31)-r1x2E*VR1(50,31)&
   +r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))
VS0(50,49)=QCy*VS0(50,31)+WQy*VS1(50,31)&
   +r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +3D0*HfxZpE*VS1(32,31)
VS0(50,50)=QCy*VS0(50,32)+WQy*VS1(50,32)&
   +2D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +3D0*HfxZpE*VS1(32,32)
VS0(50,51)=QCz*VS0(50,30)+WQz*VS1(50,30)&
   +2D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))&
   +2D0*HfxZpE*VS1(29,30)
VS0(50,52)=QCz*VS0(50,31)+WQz*VS1(50,31)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +2D0*HfxZpE*VS1(29,31)
VS0(50,53)=QCz*VS0(50,32)+WQz*VS1(50,32)&
   +2D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +2D0*HfxZpE*VS1(29,32)
VS0(50,54)=QCz*VS0(50,33)+WQz*VS1(50,33)&
   +3D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +2D0*HfxZpE*VS1(29,33)
VS0(50,55)=QCz*VS0(50,34)+WQz*VS1(50,34)&
   +3D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +2D0*HfxZpE*VS1(29,34)
VS0(50,56)=QCz*VS0(50,35)+WQz*VS1(50,35)&
   +4D0*r1x2E*(VS0(50,20)-ZxZpE*VS1(50,20))&
   +2D0*HfxZpE*VS1(29,35)
VS0(51,36)=QCx*VS0(51,21)+WQx*VS1(51,21)-r1x2E*VR1(51,21)&
   +4D0*r1x2E*(VS0(51,11)-ZxZpE*VS1(51,11))&
   +2D0*HfxZpE*VS1(33,21)
VS0(51,37)=QCx*VS0(51,22)+WQx*VS1(51,22)-r1x2E*VR1(51,22)&
   +3D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))&
   +2D0*HfxZpE*VS1(33,22)
VS0(51,38)=QCx*VS0(51,23)+WQx*VS1(51,23)-r1x2E*VR1(51,23)&
   +2D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))&
   +2D0*HfxZpE*VS1(33,23)
VS0(51,39)=QCy*VS0(51,23)+WQy*VS1(51,23)&
   +2D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))
VS0(51,40)=QCy*VS0(51,24)+WQy*VS1(51,24)&
   +3D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))
VS0(51,41)=QCy*VS0(51,25)+WQy*VS1(51,25)&
   +4D0*r1x2E*(VS0(51,14)-ZxZpE*VS1(51,14))
VS0(51,42)=QCx*VS0(51,26)+WQx*VS1(51,26)-r1x2E*VR1(51,26)&
   +3D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +2D0*HfxZpE*VS1(33,26)
VS0(51,43)=QCx*VS0(51,27)+WQx*VS1(51,27)-r1x2E*VR1(51,27)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +2D0*HfxZpE*VS1(33,27)
VS0(51,44)=QCx*VS0(51,28)+WQx*VS1(51,28)-r1x2E*VR1(51,28)&
   +r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +2D0*HfxZpE*VS1(33,28)
VS0(51,45)=QCy*VS0(51,28)+WQy*VS1(51,28)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))
VS0(51,46)=QCy*VS0(51,29)+WQy*VS1(51,29)&
   +3D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))
VS0(51,47)=QCx*VS0(51,30)+WQx*VS1(51,30)-r1x2E*VR1(51,30)&
   +2D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +2D0*HfxZpE*VS1(33,30)
VS0(51,48)=QCx*VS0(51,31)+WQx*VS1(51,31)-r1x2E*VR1(51,31)&
   +r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +2D0*HfxZpE*VS1(33,31)
VS0(51,49)=QCy*VS0(51,31)+WQy*VS1(51,31)&
   +r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))
VS0(51,50)=QCy*VS0(51,32)+WQy*VS1(51,32)&
   +2D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))
VS0(51,51)=QCz*VS0(51,30)+WQz*VS1(51,30)&
   +2D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +3D0*HfxZpE*VS1(30,30)
VS0(51,52)=QCz*VS0(51,31)+WQz*VS1(51,31)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +3D0*HfxZpE*VS1(30,31)
VS0(51,53)=QCz*VS0(51,32)+WQz*VS1(51,32)&
   +2D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +3D0*HfxZpE*VS1(30,32)
VS0(51,54)=QCz*VS0(51,33)+WQz*VS1(51,33)&
   +3D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +3D0*HfxZpE*VS1(30,33)
VS0(51,55)=QCz*VS0(51,34)+WQz*VS1(51,34)&
   +3D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +3D0*HfxZpE*VS1(30,34)
VS0(51,56)=QCz*VS0(51,35)+WQz*VS1(51,35)&
   +4D0*r1x2E*(VS0(51,20)-ZxZpE*VS1(51,20))&
   +3D0*HfxZpE*VS1(30,35)
VS0(52,36)=QCx*VS0(52,21)+WQx*VS1(52,21)-r1x2E*VR1(52,21)&
   +4D0*r1x2E*(VS0(52,11)-ZxZpE*VS1(52,11))&
   +HfxZpE*VS1(34,21)
VS0(52,37)=QCx*VS0(52,22)+WQx*VS1(52,22)-r1x2E*VR1(52,22)&
   +3D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(34,22)
VS0(52,38)=QCx*VS0(52,23)+WQx*VS1(52,23)-r1x2E*VR1(52,23)&
   +2D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(34,23)
VS0(52,39)=QCy*VS0(52,23)+WQy*VS1(52,23)&
   +2D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(33,23)
VS0(52,40)=QCy*VS0(52,24)+WQy*VS1(52,24)&
   +3D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(33,24)
VS0(52,41)=QCy*VS0(52,25)+WQy*VS1(52,25)&
   +4D0*r1x2E*(VS0(52,14)-ZxZpE*VS1(52,14))&
   +HfxZpE*VS1(33,25)
VS0(52,42)=QCx*VS0(52,26)+WQx*VS1(52,26)-r1x2E*VR1(52,26)&
   +3D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +HfxZpE*VS1(34,26)
VS0(52,43)=QCx*VS0(52,27)+WQx*VS1(52,27)-r1x2E*VR1(52,27)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(34,27)
VS0(52,44)=QCx*VS0(52,28)+WQx*VS1(52,28)-r1x2E*VR1(52,28)&
   +r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(34,28)
VS0(52,45)=QCy*VS0(52,28)+WQy*VS1(52,28)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(33,28)
VS0(52,46)=QCy*VS0(52,29)+WQy*VS1(52,29)&
   +3D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(33,29)
VS0(52,47)=QCx*VS0(52,30)+WQx*VS1(52,30)-r1x2E*VR1(52,30)&
   +2D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(34,30)
VS0(52,48)=QCx*VS0(52,31)+WQx*VS1(52,31)-r1x2E*VR1(52,31)&
   +r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(34,31)
VS0(52,49)=QCy*VS0(52,31)+WQy*VS1(52,31)&
   +r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(33,31)
VS0(52,50)=QCy*VS0(52,32)+WQy*VS1(52,32)&
   +2D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(33,32)
VS0(52,51)=QCz*VS0(52,30)+WQz*VS1(52,30)&
   +2D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +3D0*HfxZpE*VS1(31,30)
VS0(52,52)=QCz*VS0(52,31)+WQz*VS1(52,31)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +3D0*HfxZpE*VS1(31,31)
VS0(52,53)=QCz*VS0(52,32)+WQz*VS1(52,32)&
   +2D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +3D0*HfxZpE*VS1(31,32)
VS0(52,54)=QCz*VS0(52,33)+WQz*VS1(52,33)&
   +3D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +3D0*HfxZpE*VS1(31,33)
VS0(52,55)=QCz*VS0(52,34)+WQz*VS1(52,34)&
   +3D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +3D0*HfxZpE*VS1(31,34)
VS0(52,56)=QCz*VS0(52,35)+WQz*VS1(52,35)&
   +4D0*r1x2E*(VS0(52,20)-ZxZpE*VS1(52,20))&
   +3D0*HfxZpE*VS1(31,35)
VS0(53,36)=QCx*VS0(53,21)+WQx*VS1(53,21)-r1x2E*VR1(53,21)&
   +4D0*r1x2E*(VS0(53,11)-ZxZpE*VS1(53,11))
VS0(53,37)=QCx*VS0(53,22)+WQx*VS1(53,22)-r1x2E*VR1(53,22)&
   +3D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))
VS0(53,38)=QCx*VS0(53,23)+WQx*VS1(53,23)-r1x2E*VR1(53,23)&
   +2D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))
VS0(53,39)=QCy*VS0(53,23)+WQy*VS1(53,23)&
   +2D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))&
   +2D0*HfxZpE*VS1(34,23)
VS0(53,40)=QCy*VS0(53,24)+WQy*VS1(53,24)&
   +3D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))&
   +2D0*HfxZpE*VS1(34,24)
VS0(53,41)=QCy*VS0(53,25)+WQy*VS1(53,25)&
   +4D0*r1x2E*(VS0(53,14)-ZxZpE*VS1(53,14))&
   +2D0*HfxZpE*VS1(34,25)
VS0(53,42)=QCx*VS0(53,26)+WQx*VS1(53,26)-r1x2E*VR1(53,26)&
   +3D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))
VS0(53,43)=QCx*VS0(53,27)+WQx*VS1(53,27)-r1x2E*VR1(53,27)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))
VS0(53,44)=QCx*VS0(53,28)+WQx*VS1(53,28)-r1x2E*VR1(53,28)&
   +r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))
VS0(53,45)=QCy*VS0(53,28)+WQy*VS1(53,28)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +2D0*HfxZpE*VS1(34,28)
VS0(53,46)=QCy*VS0(53,29)+WQy*VS1(53,29)&
   +3D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +2D0*HfxZpE*VS1(34,29)
VS0(53,47)=QCx*VS0(53,30)+WQx*VS1(53,30)-r1x2E*VR1(53,30)&
   +2D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))
VS0(53,48)=QCx*VS0(53,31)+WQx*VS1(53,31)-r1x2E*VR1(53,31)&
   +r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))
VS0(53,49)=QCy*VS0(53,31)+WQy*VS1(53,31)&
   +r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +2D0*HfxZpE*VS1(34,31)
VS0(53,50)=QCy*VS0(53,32)+WQy*VS1(53,32)&
   +2D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +2D0*HfxZpE*VS1(34,32)
VS0(53,51)=QCz*VS0(53,30)+WQz*VS1(53,30)&
   +2D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))&
   +3D0*HfxZpE*VS1(32,30)
VS0(53,52)=QCz*VS0(53,31)+WQz*VS1(53,31)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +3D0*HfxZpE*VS1(32,31)
VS0(53,53)=QCz*VS0(53,32)+WQz*VS1(53,32)&
   +2D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +3D0*HfxZpE*VS1(32,32)
VS0(53,54)=QCz*VS0(53,33)+WQz*VS1(53,33)&
   +3D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +3D0*HfxZpE*VS1(32,33)
VS0(53,55)=QCz*VS0(53,34)+WQz*VS1(53,34)&
   +3D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +3D0*HfxZpE*VS1(32,34)
VS0(53,56)=QCz*VS0(53,35)+WQz*VS1(53,35)&
   +4D0*r1x2E*(VS0(53,20)-ZxZpE*VS1(53,20))&
   +3D0*HfxZpE*VS1(32,35)
VS0(54,36)=QCx*VS0(54,21)+WQx*VS1(54,21)-r1x2E*VR1(54,21)&
   +4D0*r1x2E*(VS0(54,11)-ZxZpE*VS1(54,11))&
   +HfxZpE*VS1(35,21)
VS0(54,37)=QCx*VS0(54,22)+WQx*VS1(54,22)-r1x2E*VR1(54,22)&
   +3D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))&
   +HfxZpE*VS1(35,22)
VS0(54,38)=QCx*VS0(54,23)+WQx*VS1(54,23)-r1x2E*VR1(54,23)&
   +2D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))&
   +HfxZpE*VS1(35,23)
VS0(54,39)=QCy*VS0(54,23)+WQy*VS1(54,23)&
   +2D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))
VS0(54,40)=QCy*VS0(54,24)+WQy*VS1(54,24)&
   +3D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))
VS0(54,41)=QCy*VS0(54,25)+WQy*VS1(54,25)&
   +4D0*r1x2E*(VS0(54,14)-ZxZpE*VS1(54,14))
VS0(54,42)=QCx*VS0(54,26)+WQx*VS1(54,26)-r1x2E*VR1(54,26)&
   +3D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +HfxZpE*VS1(35,26)
VS0(54,43)=QCx*VS0(54,27)+WQx*VS1(54,27)-r1x2E*VR1(54,27)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +HfxZpE*VS1(35,27)
VS0(54,44)=QCx*VS0(54,28)+WQx*VS1(54,28)-r1x2E*VR1(54,28)&
   +r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +HfxZpE*VS1(35,28)
VS0(54,45)=QCy*VS0(54,28)+WQy*VS1(54,28)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))
VS0(54,46)=QCy*VS0(54,29)+WQy*VS1(54,29)&
   +3D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))
VS0(54,47)=QCx*VS0(54,30)+WQx*VS1(54,30)-r1x2E*VR1(54,30)&
   +2D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +HfxZpE*VS1(35,30)
VS0(54,48)=QCx*VS0(54,31)+WQx*VS1(54,31)-r1x2E*VR1(54,31)&
   +r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +HfxZpE*VS1(35,31)
VS0(54,49)=QCy*VS0(54,31)+WQy*VS1(54,31)&
   +r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))
VS0(54,50)=QCy*VS0(54,32)+WQy*VS1(54,32)&
   +2D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))
VS0(54,51)=QCz*VS0(54,30)+WQz*VS1(54,30)&
   +2D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +4D0*HfxZpE*VS1(33,30)
VS0(54,52)=QCz*VS0(54,31)+WQz*VS1(54,31)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +4D0*HfxZpE*VS1(33,31)
VS0(54,53)=QCz*VS0(54,32)+WQz*VS1(54,32)&
   +2D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +4D0*HfxZpE*VS1(33,32)
VS0(54,54)=QCz*VS0(54,33)+WQz*VS1(54,33)&
   +3D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +4D0*HfxZpE*VS1(33,33)
VS0(54,55)=QCz*VS0(54,34)+WQz*VS1(54,34)&
   +3D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +4D0*HfxZpE*VS1(33,34)
VS0(54,56)=QCz*VS0(54,35)+WQz*VS1(54,35)&
   +4D0*r1x2E*(VS0(54,20)-ZxZpE*VS1(54,20))&
   +4D0*HfxZpE*VS1(33,35)
VS0(55,36)=QCx*VS0(55,21)+WQx*VS1(55,21)-r1x2E*VR1(55,21)&
   +4D0*r1x2E*(VS0(55,11)-ZxZpE*VS1(55,11))
VS0(55,37)=QCx*VS0(55,22)+WQx*VS1(55,22)-r1x2E*VR1(55,22)&
   +3D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))
VS0(55,38)=QCx*VS0(55,23)+WQx*VS1(55,23)-r1x2E*VR1(55,23)&
   +2D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))
VS0(55,39)=QCy*VS0(55,23)+WQy*VS1(55,23)&
   +2D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))&
   +HfxZpE*VS1(35,23)
VS0(55,40)=QCy*VS0(55,24)+WQy*VS1(55,24)&
   +3D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))&
   +HfxZpE*VS1(35,24)
VS0(55,41)=QCy*VS0(55,25)+WQy*VS1(55,25)&
   +4D0*r1x2E*(VS0(55,14)-ZxZpE*VS1(55,14))&
   +HfxZpE*VS1(35,25)
VS0(55,42)=QCx*VS0(55,26)+WQx*VS1(55,26)-r1x2E*VR1(55,26)&
   +3D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))
VS0(55,43)=QCx*VS0(55,27)+WQx*VS1(55,27)-r1x2E*VR1(55,27)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))
VS0(55,44)=QCx*VS0(55,28)+WQx*VS1(55,28)-r1x2E*VR1(55,28)&
   +r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))
VS0(55,45)=QCy*VS0(55,28)+WQy*VS1(55,28)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +HfxZpE*VS1(35,28)
VS0(55,46)=QCy*VS0(55,29)+WQy*VS1(55,29)&
   +3D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +HfxZpE*VS1(35,29)
VS0(55,47)=QCx*VS0(55,30)+WQx*VS1(55,30)-r1x2E*VR1(55,30)&
   +2D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))
VS0(55,48)=QCx*VS0(55,31)+WQx*VS1(55,31)-r1x2E*VR1(55,31)&
   +r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))
VS0(55,49)=QCy*VS0(55,31)+WQy*VS1(55,31)&
   +r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +HfxZpE*VS1(35,31)
VS0(55,50)=QCy*VS0(55,32)+WQy*VS1(55,32)&
   +2D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +HfxZpE*VS1(35,32)
VS0(55,51)=QCz*VS0(55,30)+WQz*VS1(55,30)&
   +2D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))&
   +4D0*HfxZpE*VS1(34,30)
VS0(55,52)=QCz*VS0(55,31)+WQz*VS1(55,31)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +4D0*HfxZpE*VS1(34,31)
VS0(55,53)=QCz*VS0(55,32)+WQz*VS1(55,32)&
   +2D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +4D0*HfxZpE*VS1(34,32)
VS0(55,54)=QCz*VS0(55,33)+WQz*VS1(55,33)&
   +3D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +4D0*HfxZpE*VS1(34,33)
VS0(55,55)=QCz*VS0(55,34)+WQz*VS1(55,34)&
   +3D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +4D0*HfxZpE*VS1(34,34)
VS0(55,56)=QCz*VS0(55,35)+WQz*VS1(55,35)&
   +4D0*r1x2E*(VS0(55,20)-ZxZpE*VS1(55,20))&
   +4D0*HfxZpE*VS1(34,35)
VS0(56,36)=QCx*VS0(56,21)+WQx*VS1(56,21)-r1x2E*VR1(56,21)&
   +4D0*r1x2E*(VS0(56,11)-ZxZpE*VS1(56,11))
VS0(56,37)=QCx*VS0(56,22)+WQx*VS1(56,22)-r1x2E*VR1(56,22)&
   +3D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,38)=QCx*VS0(56,23)+WQx*VS1(56,23)-r1x2E*VR1(56,23)&
   +2D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,39)=QCy*VS0(56,23)+WQy*VS1(56,23)&
   +2D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,40)=QCy*VS0(56,24)+WQy*VS1(56,24)&
   +3D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,41)=QCy*VS0(56,25)+WQy*VS1(56,25)&
   +4D0*r1x2E*(VS0(56,14)-ZxZpE*VS1(56,14))
VS0(56,42)=QCx*VS0(56,26)+WQx*VS1(56,26)-r1x2E*VR1(56,26)&
   +3D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))
VS0(56,43)=QCx*VS0(56,27)+WQx*VS1(56,27)-r1x2E*VR1(56,27)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,44)=QCx*VS0(56,28)+WQx*VS1(56,28)-r1x2E*VR1(56,28)&
   +r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,45)=QCy*VS0(56,28)+WQy*VS1(56,28)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,46)=QCy*VS0(56,29)+WQy*VS1(56,29)&
   +3D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,47)=QCx*VS0(56,30)+WQx*VS1(56,30)-r1x2E*VR1(56,30)&
   +2D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,48)=QCx*VS0(56,31)+WQx*VS1(56,31)-r1x2E*VR1(56,31)&
   +r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,49)=QCy*VS0(56,31)+WQy*VS1(56,31)&
   +r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,50)=QCy*VS0(56,32)+WQy*VS1(56,32)&
   +2D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,51)=QCz*VS0(56,30)+WQz*VS1(56,30)&
   +2D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))&
   +5D0*HfxZpE*VS1(35,30)
VS0(56,52)=QCz*VS0(56,31)+WQz*VS1(56,31)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))&
   +5D0*HfxZpE*VS1(35,31)
VS0(56,53)=QCz*VS0(56,32)+WQz*VS1(56,32)&
   +2D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))&
   +5D0*HfxZpE*VS1(35,32)
VS0(56,54)=QCz*VS0(56,33)+WQz*VS1(56,33)&
   +3D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))&
   +5D0*HfxZpE*VS1(35,33)
VS0(56,55)=QCz*VS0(56,34)+WQz*VS1(56,34)&
   +3D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))&
   +5D0*HfxZpE*VS1(35,34)
VS0(56,56)=QCz*VS0(56,35)+WQz*VS1(56,35)&
   +4D0*r1x2E*(VS0(56,20)-ZxZpE*VS1(56,20))&
   +5D0*HfxZpE*VS1(35,35)
CASE(2)
VS0(36,36)=QCx*VS0(36,21)+WQx*VS1(36,21)&
   +4D0*r1x2E*(VS0(36,11)-ZxZpE*VS1(36,11))&
   +5D0*HfxZpE*VS1(21,21)
VS0(36,37)=QCx*VS0(36,22)+WQx*VS1(36,22)&
   +3D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))&
   +5D0*HfxZpE*VS1(21,22)
VS0(36,38)=QCx*VS0(36,23)+WQx*VS1(36,23)&
   +2D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))&
   +5D0*HfxZpE*VS1(21,23)
VS0(36,39)=QCy*VS0(36,23)+WQy*VS1(36,23)-r1x2E*VR1(36,23)&
   +2D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))
VS0(36,40)=QCy*VS0(36,24)+WQy*VS1(36,24)-r1x2E*VR1(36,24)&
   +3D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))
VS0(36,41)=QCy*VS0(36,25)+WQy*VS1(36,25)-r1x2E*VR1(36,25)&
   +4D0*r1x2E*(VS0(36,14)-ZxZpE*VS1(36,14))
VS0(36,42)=QCx*VS0(36,26)+WQx*VS1(36,26)&
   +3D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))&
   +5D0*HfxZpE*VS1(21,26)
VS0(36,43)=QCx*VS0(36,27)+WQx*VS1(36,27)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))&
   +5D0*HfxZpE*VS1(21,27)
VS0(36,44)=QCx*VS0(36,28)+WQx*VS1(36,28)&
   +r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))&
   +5D0*HfxZpE*VS1(21,28)
VS0(36,45)=QCy*VS0(36,28)+WQy*VS1(36,28)-r1x2E*VR1(36,28)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,46)=QCy*VS0(36,29)+WQy*VS1(36,29)-r1x2E*VR1(36,29)&
   +3D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,47)=QCx*VS0(36,30)+WQx*VS1(36,30)&
   +2D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))&
   +5D0*HfxZpE*VS1(21,30)
VS0(36,48)=QCx*VS0(36,31)+WQx*VS1(36,31)&
   +r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))&
   +5D0*HfxZpE*VS1(21,31)
VS0(36,49)=QCy*VS0(36,31)+WQy*VS1(36,31)-r1x2E*VR1(36,31)&
   +r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,50)=QCy*VS0(36,32)+WQy*VS1(36,32)-r1x2E*VR1(36,32)&
   +2D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,51)=QCz*VS0(36,30)+WQz*VS1(36,30)&
   +2D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))
VS0(36,52)=QCz*VS0(36,31)+WQz*VS1(36,31)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,53)=QCz*VS0(36,32)+WQz*VS1(36,32)&
   +2D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,54)=QCz*VS0(36,33)+WQz*VS1(36,33)&
   +3D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,55)=QCz*VS0(36,34)+WQz*VS1(36,34)&
   +3D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,56)=QCz*VS0(36,35)+WQz*VS1(36,35)&
   +4D0*r1x2E*(VS0(36,20)-ZxZpE*VS1(36,20))
VS0(37,36)=QCx*VS0(37,21)+WQx*VS1(37,21)&
   +4D0*r1x2E*(VS0(37,11)-ZxZpE*VS1(37,11))&
   +4D0*HfxZpE*VS1(22,21)
VS0(37,37)=QCx*VS0(37,22)+WQx*VS1(37,22)&
   +3D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +4D0*HfxZpE*VS1(22,22)
VS0(37,38)=QCx*VS0(37,23)+WQx*VS1(37,23)&
   +2D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +4D0*HfxZpE*VS1(22,23)
VS0(37,39)=QCy*VS0(37,23)+WQy*VS1(37,23)-r1x2E*VR1(37,23)&
   +2D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +HfxZpE*VS1(21,23)
VS0(37,40)=QCy*VS0(37,24)+WQy*VS1(37,24)-r1x2E*VR1(37,24)&
   +3D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +HfxZpE*VS1(21,24)
VS0(37,41)=QCy*VS0(37,25)+WQy*VS1(37,25)-r1x2E*VR1(37,25)&
   +4D0*r1x2E*(VS0(37,14)-ZxZpE*VS1(37,14))&
   +HfxZpE*VS1(21,25)
VS0(37,42)=QCx*VS0(37,26)+WQx*VS1(37,26)&
   +3D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))&
   +4D0*HfxZpE*VS1(22,26)
VS0(37,43)=QCx*VS0(37,27)+WQx*VS1(37,27)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +4D0*HfxZpE*VS1(22,27)
VS0(37,44)=QCx*VS0(37,28)+WQx*VS1(37,28)&
   +r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +4D0*HfxZpE*VS1(22,28)
VS0(37,45)=QCy*VS0(37,28)+WQy*VS1(37,28)-r1x2E*VR1(37,28)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +HfxZpE*VS1(21,28)
VS0(37,46)=QCy*VS0(37,29)+WQy*VS1(37,29)-r1x2E*VR1(37,29)&
   +3D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +HfxZpE*VS1(21,29)
VS0(37,47)=QCx*VS0(37,30)+WQx*VS1(37,30)&
   +2D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +4D0*HfxZpE*VS1(22,30)
VS0(37,48)=QCx*VS0(37,31)+WQx*VS1(37,31)&
   +r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +4D0*HfxZpE*VS1(22,31)
VS0(37,49)=QCy*VS0(37,31)+WQy*VS1(37,31)-r1x2E*VR1(37,31)&
   +r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +HfxZpE*VS1(21,31)
VS0(37,50)=QCy*VS0(37,32)+WQy*VS1(37,32)-r1x2E*VR1(37,32)&
   +2D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +HfxZpE*VS1(21,32)
VS0(37,51)=QCz*VS0(37,30)+WQz*VS1(37,30)&
   +2D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))
VS0(37,52)=QCz*VS0(37,31)+WQz*VS1(37,31)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))
VS0(37,53)=QCz*VS0(37,32)+WQz*VS1(37,32)&
   +2D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))
VS0(37,54)=QCz*VS0(37,33)+WQz*VS1(37,33)&
   +3D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))
VS0(37,55)=QCz*VS0(37,34)+WQz*VS1(37,34)&
   +3D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))
VS0(37,56)=QCz*VS0(37,35)+WQz*VS1(37,35)&
   +4D0*r1x2E*(VS0(37,20)-ZxZpE*VS1(37,20))
VS0(38,36)=QCx*VS0(38,21)+WQx*VS1(38,21)&
   +4D0*r1x2E*(VS0(38,11)-ZxZpE*VS1(38,11))&
   +3D0*HfxZpE*VS1(23,21)
VS0(38,37)=QCx*VS0(38,22)+WQx*VS1(38,22)&
   +3D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +3D0*HfxZpE*VS1(23,22)
VS0(38,38)=QCx*VS0(38,23)+WQx*VS1(38,23)&
   +2D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +3D0*HfxZpE*VS1(23,23)
VS0(38,39)=QCy*VS0(38,23)+WQy*VS1(38,23)-r1x2E*VR1(38,23)&
   +2D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +2D0*HfxZpE*VS1(22,23)
VS0(38,40)=QCy*VS0(38,24)+WQy*VS1(38,24)-r1x2E*VR1(38,24)&
   +3D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +2D0*HfxZpE*VS1(22,24)
VS0(38,41)=QCy*VS0(38,25)+WQy*VS1(38,25)-r1x2E*VR1(38,25)&
   +4D0*r1x2E*(VS0(38,14)-ZxZpE*VS1(38,14))&
   +2D0*HfxZpE*VS1(22,25)
VS0(38,42)=QCx*VS0(38,26)+WQx*VS1(38,26)&
   +3D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))&
   +3D0*HfxZpE*VS1(23,26)
VS0(38,43)=QCx*VS0(38,27)+WQx*VS1(38,27)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +3D0*HfxZpE*VS1(23,27)
VS0(38,44)=QCx*VS0(38,28)+WQx*VS1(38,28)&
   +r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +3D0*HfxZpE*VS1(23,28)
VS0(38,45)=QCy*VS0(38,28)+WQy*VS1(38,28)-r1x2E*VR1(38,28)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +2D0*HfxZpE*VS1(22,28)
VS0(38,46)=QCy*VS0(38,29)+WQy*VS1(38,29)-r1x2E*VR1(38,29)&
   +3D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +2D0*HfxZpE*VS1(22,29)
VS0(38,47)=QCx*VS0(38,30)+WQx*VS1(38,30)&
   +2D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +3D0*HfxZpE*VS1(23,30)
VS0(38,48)=QCx*VS0(38,31)+WQx*VS1(38,31)&
   +r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +3D0*HfxZpE*VS1(23,31)
VS0(38,49)=QCy*VS0(38,31)+WQy*VS1(38,31)-r1x2E*VR1(38,31)&
   +r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +2D0*HfxZpE*VS1(22,31)
VS0(38,50)=QCy*VS0(38,32)+WQy*VS1(38,32)-r1x2E*VR1(38,32)&
   +2D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +2D0*HfxZpE*VS1(22,32)
VS0(38,51)=QCz*VS0(38,30)+WQz*VS1(38,30)&
   +2D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))
VS0(38,52)=QCz*VS0(38,31)+WQz*VS1(38,31)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))
VS0(38,53)=QCz*VS0(38,32)+WQz*VS1(38,32)&
   +2D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))
VS0(38,54)=QCz*VS0(38,33)+WQz*VS1(38,33)&
   +3D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))
VS0(38,55)=QCz*VS0(38,34)+WQz*VS1(38,34)&
   +3D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))
VS0(38,56)=QCz*VS0(38,35)+WQz*VS1(38,35)&
   +4D0*r1x2E*(VS0(38,20)-ZxZpE*VS1(38,20))
VS0(39,36)=QCx*VS0(39,21)+WQx*VS1(39,21)&
   +4D0*r1x2E*(VS0(39,11)-ZxZpE*VS1(39,11))&
   +2D0*HfxZpE*VS1(24,21)
VS0(39,37)=QCx*VS0(39,22)+WQx*VS1(39,22)&
   +3D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +2D0*HfxZpE*VS1(24,22)
VS0(39,38)=QCx*VS0(39,23)+WQx*VS1(39,23)&
   +2D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +2D0*HfxZpE*VS1(24,23)
VS0(39,39)=QCy*VS0(39,23)+WQy*VS1(39,23)-r1x2E*VR1(39,23)&
   +2D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +3D0*HfxZpE*VS1(23,23)
VS0(39,40)=QCy*VS0(39,24)+WQy*VS1(39,24)-r1x2E*VR1(39,24)&
   +3D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +3D0*HfxZpE*VS1(23,24)
VS0(39,41)=QCy*VS0(39,25)+WQy*VS1(39,25)-r1x2E*VR1(39,25)&
   +4D0*r1x2E*(VS0(39,14)-ZxZpE*VS1(39,14))&
   +3D0*HfxZpE*VS1(23,25)
VS0(39,42)=QCx*VS0(39,26)+WQx*VS1(39,26)&
   +3D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))&
   +2D0*HfxZpE*VS1(24,26)
VS0(39,43)=QCx*VS0(39,27)+WQx*VS1(39,27)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +2D0*HfxZpE*VS1(24,27)
VS0(39,44)=QCx*VS0(39,28)+WQx*VS1(39,28)&
   +r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +2D0*HfxZpE*VS1(24,28)
VS0(39,45)=QCy*VS0(39,28)+WQy*VS1(39,28)-r1x2E*VR1(39,28)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +3D0*HfxZpE*VS1(23,28)
VS0(39,46)=QCy*VS0(39,29)+WQy*VS1(39,29)-r1x2E*VR1(39,29)&
   +3D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +3D0*HfxZpE*VS1(23,29)
VS0(39,47)=QCx*VS0(39,30)+WQx*VS1(39,30)&
   +2D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +2D0*HfxZpE*VS1(24,30)
VS0(39,48)=QCx*VS0(39,31)+WQx*VS1(39,31)&
   +r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +2D0*HfxZpE*VS1(24,31)
VS0(39,49)=QCy*VS0(39,31)+WQy*VS1(39,31)-r1x2E*VR1(39,31)&
   +r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +3D0*HfxZpE*VS1(23,31)
VS0(39,50)=QCy*VS0(39,32)+WQy*VS1(39,32)-r1x2E*VR1(39,32)&
   +2D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +3D0*HfxZpE*VS1(23,32)
VS0(39,51)=QCz*VS0(39,30)+WQz*VS1(39,30)&
   +2D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))
VS0(39,52)=QCz*VS0(39,31)+WQz*VS1(39,31)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))
VS0(39,53)=QCz*VS0(39,32)+WQz*VS1(39,32)&
   +2D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))
VS0(39,54)=QCz*VS0(39,33)+WQz*VS1(39,33)&
   +3D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))
VS0(39,55)=QCz*VS0(39,34)+WQz*VS1(39,34)&
   +3D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))
VS0(39,56)=QCz*VS0(39,35)+WQz*VS1(39,35)&
   +4D0*r1x2E*(VS0(39,20)-ZxZpE*VS1(39,20))
VS0(40,36)=QCx*VS0(40,21)+WQx*VS1(40,21)&
   +4D0*r1x2E*(VS0(40,11)-ZxZpE*VS1(40,11))&
   +HfxZpE*VS1(25,21)
VS0(40,37)=QCx*VS0(40,22)+WQx*VS1(40,22)&
   +3D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +HfxZpE*VS1(25,22)
VS0(40,38)=QCx*VS0(40,23)+WQx*VS1(40,23)&
   +2D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +HfxZpE*VS1(25,23)
VS0(40,39)=QCy*VS0(40,23)+WQy*VS1(40,23)-r1x2E*VR1(40,23)&
   +2D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +4D0*HfxZpE*VS1(24,23)
VS0(40,40)=QCy*VS0(40,24)+WQy*VS1(40,24)-r1x2E*VR1(40,24)&
   +3D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +4D0*HfxZpE*VS1(24,24)
VS0(40,41)=QCy*VS0(40,25)+WQy*VS1(40,25)-r1x2E*VR1(40,25)&
   +4D0*r1x2E*(VS0(40,14)-ZxZpE*VS1(40,14))&
   +4D0*HfxZpE*VS1(24,25)
VS0(40,42)=QCx*VS0(40,26)+WQx*VS1(40,26)&
   +3D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))&
   +HfxZpE*VS1(25,26)
VS0(40,43)=QCx*VS0(40,27)+WQx*VS1(40,27)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +HfxZpE*VS1(25,27)
VS0(40,44)=QCx*VS0(40,28)+WQx*VS1(40,28)&
   +r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +HfxZpE*VS1(25,28)
VS0(40,45)=QCy*VS0(40,28)+WQy*VS1(40,28)-r1x2E*VR1(40,28)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +4D0*HfxZpE*VS1(24,28)
VS0(40,46)=QCy*VS0(40,29)+WQy*VS1(40,29)-r1x2E*VR1(40,29)&
   +3D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +4D0*HfxZpE*VS1(24,29)
VS0(40,47)=QCx*VS0(40,30)+WQx*VS1(40,30)&
   +2D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +HfxZpE*VS1(25,30)
VS0(40,48)=QCx*VS0(40,31)+WQx*VS1(40,31)&
   +r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +HfxZpE*VS1(25,31)
VS0(40,49)=QCy*VS0(40,31)+WQy*VS1(40,31)-r1x2E*VR1(40,31)&
   +r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +4D0*HfxZpE*VS1(24,31)
VS0(40,50)=QCy*VS0(40,32)+WQy*VS1(40,32)-r1x2E*VR1(40,32)&
   +2D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +4D0*HfxZpE*VS1(24,32)
VS0(40,51)=QCz*VS0(40,30)+WQz*VS1(40,30)&
   +2D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))
VS0(40,52)=QCz*VS0(40,31)+WQz*VS1(40,31)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))
VS0(40,53)=QCz*VS0(40,32)+WQz*VS1(40,32)&
   +2D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))
VS0(40,54)=QCz*VS0(40,33)+WQz*VS1(40,33)&
   +3D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))
VS0(40,55)=QCz*VS0(40,34)+WQz*VS1(40,34)&
   +3D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))
VS0(40,56)=QCz*VS0(40,35)+WQz*VS1(40,35)&
   +4D0*r1x2E*(VS0(40,20)-ZxZpE*VS1(40,20))
VS0(41,36)=QCx*VS0(41,21)+WQx*VS1(41,21)&
   +4D0*r1x2E*(VS0(41,11)-ZxZpE*VS1(41,11))
VS0(41,37)=QCx*VS0(41,22)+WQx*VS1(41,22)&
   +3D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))
VS0(41,38)=QCx*VS0(41,23)+WQx*VS1(41,23)&
   +2D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))
VS0(41,39)=QCy*VS0(41,23)+WQy*VS1(41,23)-r1x2E*VR1(41,23)&
   +2D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))&
   +5D0*HfxZpE*VS1(25,23)
VS0(41,40)=QCy*VS0(41,24)+WQy*VS1(41,24)-r1x2E*VR1(41,24)&
   +3D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))&
   +5D0*HfxZpE*VS1(25,24)
VS0(41,41)=QCy*VS0(41,25)+WQy*VS1(41,25)-r1x2E*VR1(41,25)&
   +4D0*r1x2E*(VS0(41,14)-ZxZpE*VS1(41,14))&
   +5D0*HfxZpE*VS1(25,25)
VS0(41,42)=QCx*VS0(41,26)+WQx*VS1(41,26)&
   +3D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,43)=QCx*VS0(41,27)+WQx*VS1(41,27)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,44)=QCx*VS0(41,28)+WQx*VS1(41,28)&
   +r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,45)=QCy*VS0(41,28)+WQy*VS1(41,28)-r1x2E*VR1(41,28)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))&
   +5D0*HfxZpE*VS1(25,28)
VS0(41,46)=QCy*VS0(41,29)+WQy*VS1(41,29)-r1x2E*VR1(41,29)&
   +3D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))&
   +5D0*HfxZpE*VS1(25,29)
VS0(41,47)=QCx*VS0(41,30)+WQx*VS1(41,30)&
   +2D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,48)=QCx*VS0(41,31)+WQx*VS1(41,31)&
   +r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,49)=QCy*VS0(41,31)+WQy*VS1(41,31)-r1x2E*VR1(41,31)&
   +r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))&
   +5D0*HfxZpE*VS1(25,31)
VS0(41,50)=QCy*VS0(41,32)+WQy*VS1(41,32)-r1x2E*VR1(41,32)&
   +2D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))&
   +5D0*HfxZpE*VS1(25,32)
VS0(41,51)=QCz*VS0(41,30)+WQz*VS1(41,30)&
   +2D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,52)=QCz*VS0(41,31)+WQz*VS1(41,31)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,53)=QCz*VS0(41,32)+WQz*VS1(41,32)&
   +2D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,54)=QCz*VS0(41,33)+WQz*VS1(41,33)&
   +3D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,55)=QCz*VS0(41,34)+WQz*VS1(41,34)&
   +3D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,56)=QCz*VS0(41,35)+WQz*VS1(41,35)&
   +4D0*r1x2E*(VS0(41,20)-ZxZpE*VS1(41,20))
VS0(42,36)=QCx*VS0(42,21)+WQx*VS1(42,21)&
   +4D0*r1x2E*(VS0(42,11)-ZxZpE*VS1(42,11))&
   +4D0*HfxZpE*VS1(26,21)
VS0(42,37)=QCx*VS0(42,22)+WQx*VS1(42,22)&
   +3D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))&
   +4D0*HfxZpE*VS1(26,22)
VS0(42,38)=QCx*VS0(42,23)+WQx*VS1(42,23)&
   +2D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))&
   +4D0*HfxZpE*VS1(26,23)
VS0(42,39)=QCy*VS0(42,23)+WQy*VS1(42,23)-r1x2E*VR1(42,23)&
   +2D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))
VS0(42,40)=QCy*VS0(42,24)+WQy*VS1(42,24)-r1x2E*VR1(42,24)&
   +3D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))
VS0(42,41)=QCy*VS0(42,25)+WQy*VS1(42,25)-r1x2E*VR1(42,25)&
   +4D0*r1x2E*(VS0(42,14)-ZxZpE*VS1(42,14))
VS0(42,42)=QCx*VS0(42,26)+WQx*VS1(42,26)&
   +3D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +4D0*HfxZpE*VS1(26,26)
VS0(42,43)=QCx*VS0(42,27)+WQx*VS1(42,27)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +4D0*HfxZpE*VS1(26,27)
VS0(42,44)=QCx*VS0(42,28)+WQx*VS1(42,28)&
   +r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +4D0*HfxZpE*VS1(26,28)
VS0(42,45)=QCy*VS0(42,28)+WQy*VS1(42,28)-r1x2E*VR1(42,28)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))
VS0(42,46)=QCy*VS0(42,29)+WQy*VS1(42,29)-r1x2E*VR1(42,29)&
   +3D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))
VS0(42,47)=QCx*VS0(42,30)+WQx*VS1(42,30)&
   +2D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +4D0*HfxZpE*VS1(26,30)
VS0(42,48)=QCx*VS0(42,31)+WQx*VS1(42,31)&
   +r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +4D0*HfxZpE*VS1(26,31)
VS0(42,49)=QCy*VS0(42,31)+WQy*VS1(42,31)-r1x2E*VR1(42,31)&
   +r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))
VS0(42,50)=QCy*VS0(42,32)+WQy*VS1(42,32)-r1x2E*VR1(42,32)&
   +2D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))
VS0(42,51)=QCz*VS0(42,30)+WQz*VS1(42,30)&
   +2D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +HfxZpE*VS1(21,30)
VS0(42,52)=QCz*VS0(42,31)+WQz*VS1(42,31)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +HfxZpE*VS1(21,31)
VS0(42,53)=QCz*VS0(42,32)+WQz*VS1(42,32)&
   +2D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +HfxZpE*VS1(21,32)
VS0(42,54)=QCz*VS0(42,33)+WQz*VS1(42,33)&
   +3D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +HfxZpE*VS1(21,33)
VS0(42,55)=QCz*VS0(42,34)+WQz*VS1(42,34)&
   +3D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +HfxZpE*VS1(21,34)
VS0(42,56)=QCz*VS0(42,35)+WQz*VS1(42,35)&
   +4D0*r1x2E*(VS0(42,20)-ZxZpE*VS1(42,20))&
   +HfxZpE*VS1(21,35)
VS0(43,36)=QCx*VS0(43,21)+WQx*VS1(43,21)&
   +4D0*r1x2E*(VS0(43,11)-ZxZpE*VS1(43,11))&
   +3D0*HfxZpE*VS1(27,21)
VS0(43,37)=QCx*VS0(43,22)+WQx*VS1(43,22)&
   +3D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +3D0*HfxZpE*VS1(27,22)
VS0(43,38)=QCx*VS0(43,23)+WQx*VS1(43,23)&
   +2D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +3D0*HfxZpE*VS1(27,23)
VS0(43,39)=QCy*VS0(43,23)+WQy*VS1(43,23)-r1x2E*VR1(43,23)&
   +2D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +HfxZpE*VS1(26,23)
VS0(43,40)=QCy*VS0(43,24)+WQy*VS1(43,24)-r1x2E*VR1(43,24)&
   +3D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +HfxZpE*VS1(26,24)
VS0(43,41)=QCy*VS0(43,25)+WQy*VS1(43,25)-r1x2E*VR1(43,25)&
   +4D0*r1x2E*(VS0(43,14)-ZxZpE*VS1(43,14))&
   +HfxZpE*VS1(26,25)
VS0(43,42)=QCx*VS0(43,26)+WQx*VS1(43,26)&
   +3D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +3D0*HfxZpE*VS1(27,26)
VS0(43,43)=QCx*VS0(43,27)+WQx*VS1(43,27)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +3D0*HfxZpE*VS1(27,27)
VS0(43,44)=QCx*VS0(43,28)+WQx*VS1(43,28)&
   +r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +3D0*HfxZpE*VS1(27,28)
VS0(43,45)=QCy*VS0(43,28)+WQy*VS1(43,28)-r1x2E*VR1(43,28)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(26,28)
VS0(43,46)=QCy*VS0(43,29)+WQy*VS1(43,29)-r1x2E*VR1(43,29)&
   +3D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(26,29)
VS0(43,47)=QCx*VS0(43,30)+WQx*VS1(43,30)&
   +2D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +3D0*HfxZpE*VS1(27,30)
VS0(43,48)=QCx*VS0(43,31)+WQx*VS1(43,31)&
   +r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +3D0*HfxZpE*VS1(27,31)
VS0(43,49)=QCy*VS0(43,31)+WQy*VS1(43,31)-r1x2E*VR1(43,31)&
   +r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(26,31)
VS0(43,50)=QCy*VS0(43,32)+WQy*VS1(43,32)-r1x2E*VR1(43,32)&
   +2D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(26,32)
VS0(43,51)=QCz*VS0(43,30)+WQz*VS1(43,30)&
   +2D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +HfxZpE*VS1(22,30)
VS0(43,52)=QCz*VS0(43,31)+WQz*VS1(43,31)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(22,31)
VS0(43,53)=QCz*VS0(43,32)+WQz*VS1(43,32)&
   +2D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(22,32)
VS0(43,54)=QCz*VS0(43,33)+WQz*VS1(43,33)&
   +3D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(22,33)
VS0(43,55)=QCz*VS0(43,34)+WQz*VS1(43,34)&
   +3D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(22,34)
VS0(43,56)=QCz*VS0(43,35)+WQz*VS1(43,35)&
   +4D0*r1x2E*(VS0(43,20)-ZxZpE*VS1(43,20))&
   +HfxZpE*VS1(22,35)
VS0(44,36)=QCx*VS0(44,21)+WQx*VS1(44,21)&
   +4D0*r1x2E*(VS0(44,11)-ZxZpE*VS1(44,11))&
   +2D0*HfxZpE*VS1(28,21)
VS0(44,37)=QCx*VS0(44,22)+WQx*VS1(44,22)&
   +3D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(28,22)
VS0(44,38)=QCx*VS0(44,23)+WQx*VS1(44,23)&
   +2D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(28,23)
VS0(44,39)=QCy*VS0(44,23)+WQy*VS1(44,23)-r1x2E*VR1(44,23)&
   +2D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(27,23)
VS0(44,40)=QCy*VS0(44,24)+WQy*VS1(44,24)-r1x2E*VR1(44,24)&
   +3D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(27,24)
VS0(44,41)=QCy*VS0(44,25)+WQy*VS1(44,25)-r1x2E*VR1(44,25)&
   +4D0*r1x2E*(VS0(44,14)-ZxZpE*VS1(44,14))&
   +2D0*HfxZpE*VS1(27,25)
VS0(44,42)=QCx*VS0(44,26)+WQx*VS1(44,26)&
   +3D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +2D0*HfxZpE*VS1(28,26)
VS0(44,43)=QCx*VS0(44,27)+WQx*VS1(44,27)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(28,27)
VS0(44,44)=QCx*VS0(44,28)+WQx*VS1(44,28)&
   +r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(28,28)
VS0(44,45)=QCy*VS0(44,28)+WQy*VS1(44,28)-r1x2E*VR1(44,28)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(27,28)
VS0(44,46)=QCy*VS0(44,29)+WQy*VS1(44,29)-r1x2E*VR1(44,29)&
   +3D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(27,29)
VS0(44,47)=QCx*VS0(44,30)+WQx*VS1(44,30)&
   +2D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(28,30)
VS0(44,48)=QCx*VS0(44,31)+WQx*VS1(44,31)&
   +r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(28,31)
VS0(44,49)=QCy*VS0(44,31)+WQy*VS1(44,31)-r1x2E*VR1(44,31)&
   +r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(27,31)
VS0(44,50)=QCy*VS0(44,32)+WQy*VS1(44,32)-r1x2E*VR1(44,32)&
   +2D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(27,32)
VS0(44,51)=QCz*VS0(44,30)+WQz*VS1(44,30)&
   +2D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +HfxZpE*VS1(23,30)
VS0(44,52)=QCz*VS0(44,31)+WQz*VS1(44,31)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +HfxZpE*VS1(23,31)
VS0(44,53)=QCz*VS0(44,32)+WQz*VS1(44,32)&
   +2D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +HfxZpE*VS1(23,32)
VS0(44,54)=QCz*VS0(44,33)+WQz*VS1(44,33)&
   +3D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +HfxZpE*VS1(23,33)
VS0(44,55)=QCz*VS0(44,34)+WQz*VS1(44,34)&
   +3D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +HfxZpE*VS1(23,34)
VS0(44,56)=QCz*VS0(44,35)+WQz*VS1(44,35)&
   +4D0*r1x2E*(VS0(44,20)-ZxZpE*VS1(44,20))&
   +HfxZpE*VS1(23,35)
VS0(45,36)=QCx*VS0(45,21)+WQx*VS1(45,21)&
   +4D0*r1x2E*(VS0(45,11)-ZxZpE*VS1(45,11))&
   +HfxZpE*VS1(29,21)
VS0(45,37)=QCx*VS0(45,22)+WQx*VS1(45,22)&
   +3D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +HfxZpE*VS1(29,22)
VS0(45,38)=QCx*VS0(45,23)+WQx*VS1(45,23)&
   +2D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +HfxZpE*VS1(29,23)
VS0(45,39)=QCy*VS0(45,23)+WQy*VS1(45,23)-r1x2E*VR1(45,23)&
   +2D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +3D0*HfxZpE*VS1(28,23)
VS0(45,40)=QCy*VS0(45,24)+WQy*VS1(45,24)-r1x2E*VR1(45,24)&
   +3D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +3D0*HfxZpE*VS1(28,24)
VS0(45,41)=QCy*VS0(45,25)+WQy*VS1(45,25)-r1x2E*VR1(45,25)&
   +4D0*r1x2E*(VS0(45,14)-ZxZpE*VS1(45,14))&
   +3D0*HfxZpE*VS1(28,25)
VS0(45,42)=QCx*VS0(45,26)+WQx*VS1(45,26)&
   +3D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(29,26)
VS0(45,43)=QCx*VS0(45,27)+WQx*VS1(45,27)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(29,27)
VS0(45,44)=QCx*VS0(45,28)+WQx*VS1(45,28)&
   +r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(29,28)
VS0(45,45)=QCy*VS0(45,28)+WQy*VS1(45,28)-r1x2E*VR1(45,28)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +3D0*HfxZpE*VS1(28,28)
VS0(45,46)=QCy*VS0(45,29)+WQy*VS1(45,29)-r1x2E*VR1(45,29)&
   +3D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +3D0*HfxZpE*VS1(28,29)
VS0(45,47)=QCx*VS0(45,30)+WQx*VS1(45,30)&
   +2D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(29,30)
VS0(45,48)=QCx*VS0(45,31)+WQx*VS1(45,31)&
   +r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(29,31)
VS0(45,49)=QCy*VS0(45,31)+WQy*VS1(45,31)-r1x2E*VR1(45,31)&
   +r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +3D0*HfxZpE*VS1(28,31)
VS0(45,50)=QCy*VS0(45,32)+WQy*VS1(45,32)-r1x2E*VR1(45,32)&
   +2D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +3D0*HfxZpE*VS1(28,32)
VS0(45,51)=QCz*VS0(45,30)+WQz*VS1(45,30)&
   +2D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(24,30)
VS0(45,52)=QCz*VS0(45,31)+WQz*VS1(45,31)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(24,31)
VS0(45,53)=QCz*VS0(45,32)+WQz*VS1(45,32)&
   +2D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(24,32)
VS0(45,54)=QCz*VS0(45,33)+WQz*VS1(45,33)&
   +3D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(24,33)
VS0(45,55)=QCz*VS0(45,34)+WQz*VS1(45,34)&
   +3D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(24,34)
VS0(45,56)=QCz*VS0(45,35)+WQz*VS1(45,35)&
   +4D0*r1x2E*(VS0(45,20)-ZxZpE*VS1(45,20))&
   +HfxZpE*VS1(24,35)
VS0(46,36)=QCx*VS0(46,21)+WQx*VS1(46,21)&
   +4D0*r1x2E*(VS0(46,11)-ZxZpE*VS1(46,11))
VS0(46,37)=QCx*VS0(46,22)+WQx*VS1(46,22)&
   +3D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))
VS0(46,38)=QCx*VS0(46,23)+WQx*VS1(46,23)&
   +2D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))
VS0(46,39)=QCy*VS0(46,23)+WQy*VS1(46,23)-r1x2E*VR1(46,23)&
   +2D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))&
   +4D0*HfxZpE*VS1(29,23)
VS0(46,40)=QCy*VS0(46,24)+WQy*VS1(46,24)-r1x2E*VR1(46,24)&
   +3D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))&
   +4D0*HfxZpE*VS1(29,24)
VS0(46,41)=QCy*VS0(46,25)+WQy*VS1(46,25)-r1x2E*VR1(46,25)&
   +4D0*r1x2E*(VS0(46,14)-ZxZpE*VS1(46,14))&
   +4D0*HfxZpE*VS1(29,25)
VS0(46,42)=QCx*VS0(46,26)+WQx*VS1(46,26)&
   +3D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))
VS0(46,43)=QCx*VS0(46,27)+WQx*VS1(46,27)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))
VS0(46,44)=QCx*VS0(46,28)+WQx*VS1(46,28)&
   +r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))
VS0(46,45)=QCy*VS0(46,28)+WQy*VS1(46,28)-r1x2E*VR1(46,28)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +4D0*HfxZpE*VS1(29,28)
VS0(46,46)=QCy*VS0(46,29)+WQy*VS1(46,29)-r1x2E*VR1(46,29)&
   +3D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +4D0*HfxZpE*VS1(29,29)
VS0(46,47)=QCx*VS0(46,30)+WQx*VS1(46,30)&
   +2D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))
VS0(46,48)=QCx*VS0(46,31)+WQx*VS1(46,31)&
   +r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))
VS0(46,49)=QCy*VS0(46,31)+WQy*VS1(46,31)-r1x2E*VR1(46,31)&
   +r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +4D0*HfxZpE*VS1(29,31)
VS0(46,50)=QCy*VS0(46,32)+WQy*VS1(46,32)-r1x2E*VR1(46,32)&
   +2D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +4D0*HfxZpE*VS1(29,32)
VS0(46,51)=QCz*VS0(46,30)+WQz*VS1(46,30)&
   +2D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))&
   +HfxZpE*VS1(25,30)
VS0(46,52)=QCz*VS0(46,31)+WQz*VS1(46,31)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +HfxZpE*VS1(25,31)
VS0(46,53)=QCz*VS0(46,32)+WQz*VS1(46,32)&
   +2D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +HfxZpE*VS1(25,32)
VS0(46,54)=QCz*VS0(46,33)+WQz*VS1(46,33)&
   +3D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +HfxZpE*VS1(25,33)
VS0(46,55)=QCz*VS0(46,34)+WQz*VS1(46,34)&
   +3D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +HfxZpE*VS1(25,34)
VS0(46,56)=QCz*VS0(46,35)+WQz*VS1(46,35)&
   +4D0*r1x2E*(VS0(46,20)-ZxZpE*VS1(46,20))&
   +HfxZpE*VS1(25,35)
VS0(47,36)=QCx*VS0(47,21)+WQx*VS1(47,21)&
   +4D0*r1x2E*(VS0(47,11)-ZxZpE*VS1(47,11))&
   +3D0*HfxZpE*VS1(30,21)
VS0(47,37)=QCx*VS0(47,22)+WQx*VS1(47,22)&
   +3D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))&
   +3D0*HfxZpE*VS1(30,22)
VS0(47,38)=QCx*VS0(47,23)+WQx*VS1(47,23)&
   +2D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))&
   +3D0*HfxZpE*VS1(30,23)
VS0(47,39)=QCy*VS0(47,23)+WQy*VS1(47,23)-r1x2E*VR1(47,23)&
   +2D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))
VS0(47,40)=QCy*VS0(47,24)+WQy*VS1(47,24)-r1x2E*VR1(47,24)&
   +3D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))
VS0(47,41)=QCy*VS0(47,25)+WQy*VS1(47,25)-r1x2E*VR1(47,25)&
   +4D0*r1x2E*(VS0(47,14)-ZxZpE*VS1(47,14))
VS0(47,42)=QCx*VS0(47,26)+WQx*VS1(47,26)&
   +3D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +3D0*HfxZpE*VS1(30,26)
VS0(47,43)=QCx*VS0(47,27)+WQx*VS1(47,27)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +3D0*HfxZpE*VS1(30,27)
VS0(47,44)=QCx*VS0(47,28)+WQx*VS1(47,28)&
   +r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +3D0*HfxZpE*VS1(30,28)
VS0(47,45)=QCy*VS0(47,28)+WQy*VS1(47,28)-r1x2E*VR1(47,28)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))
VS0(47,46)=QCy*VS0(47,29)+WQy*VS1(47,29)-r1x2E*VR1(47,29)&
   +3D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))
VS0(47,47)=QCx*VS0(47,30)+WQx*VS1(47,30)&
   +2D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +3D0*HfxZpE*VS1(30,30)
VS0(47,48)=QCx*VS0(47,31)+WQx*VS1(47,31)&
   +r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +3D0*HfxZpE*VS1(30,31)
VS0(47,49)=QCy*VS0(47,31)+WQy*VS1(47,31)-r1x2E*VR1(47,31)&
   +r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))
VS0(47,50)=QCy*VS0(47,32)+WQy*VS1(47,32)-r1x2E*VR1(47,32)&
   +2D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))
VS0(47,51)=QCz*VS0(47,30)+WQz*VS1(47,30)&
   +2D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +2D0*HfxZpE*VS1(26,30)
VS0(47,52)=QCz*VS0(47,31)+WQz*VS1(47,31)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +2D0*HfxZpE*VS1(26,31)
VS0(47,53)=QCz*VS0(47,32)+WQz*VS1(47,32)&
   +2D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +2D0*HfxZpE*VS1(26,32)
VS0(47,54)=QCz*VS0(47,33)+WQz*VS1(47,33)&
   +3D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +2D0*HfxZpE*VS1(26,33)
VS0(47,55)=QCz*VS0(47,34)+WQz*VS1(47,34)&
   +3D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +2D0*HfxZpE*VS1(26,34)
VS0(47,56)=QCz*VS0(47,35)+WQz*VS1(47,35)&
   +4D0*r1x2E*(VS0(47,20)-ZxZpE*VS1(47,20))&
   +2D0*HfxZpE*VS1(26,35)
VS0(48,36)=QCx*VS0(48,21)+WQx*VS1(48,21)&
   +4D0*r1x2E*(VS0(48,11)-ZxZpE*VS1(48,11))&
   +2D0*HfxZpE*VS1(31,21)
VS0(48,37)=QCx*VS0(48,22)+WQx*VS1(48,22)&
   +3D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +2D0*HfxZpE*VS1(31,22)
VS0(48,38)=QCx*VS0(48,23)+WQx*VS1(48,23)&
   +2D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +2D0*HfxZpE*VS1(31,23)
VS0(48,39)=QCy*VS0(48,23)+WQy*VS1(48,23)-r1x2E*VR1(48,23)&
   +2D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +HfxZpE*VS1(30,23)
VS0(48,40)=QCy*VS0(48,24)+WQy*VS1(48,24)-r1x2E*VR1(48,24)&
   +3D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +HfxZpE*VS1(30,24)
VS0(48,41)=QCy*VS0(48,25)+WQy*VS1(48,25)-r1x2E*VR1(48,25)&
   +4D0*r1x2E*(VS0(48,14)-ZxZpE*VS1(48,14))&
   +HfxZpE*VS1(30,25)
VS0(48,42)=QCx*VS0(48,26)+WQx*VS1(48,26)&
   +3D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(31,26)
VS0(48,43)=QCx*VS0(48,27)+WQx*VS1(48,27)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(31,27)
VS0(48,44)=QCx*VS0(48,28)+WQx*VS1(48,28)&
   +r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(31,28)
VS0(48,45)=QCy*VS0(48,28)+WQy*VS1(48,28)-r1x2E*VR1(48,28)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +HfxZpE*VS1(30,28)
VS0(48,46)=QCy*VS0(48,29)+WQy*VS1(48,29)-r1x2E*VR1(48,29)&
   +3D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +HfxZpE*VS1(30,29)
VS0(48,47)=QCx*VS0(48,30)+WQx*VS1(48,30)&
   +2D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(31,30)
VS0(48,48)=QCx*VS0(48,31)+WQx*VS1(48,31)&
   +r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(31,31)
VS0(48,49)=QCy*VS0(48,31)+WQy*VS1(48,31)-r1x2E*VR1(48,31)&
   +r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +HfxZpE*VS1(30,31)
VS0(48,50)=QCy*VS0(48,32)+WQy*VS1(48,32)-r1x2E*VR1(48,32)&
   +2D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +HfxZpE*VS1(30,32)
VS0(48,51)=QCz*VS0(48,30)+WQz*VS1(48,30)&
   +2D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(27,30)
VS0(48,52)=QCz*VS0(48,31)+WQz*VS1(48,31)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(27,31)
VS0(48,53)=QCz*VS0(48,32)+WQz*VS1(48,32)&
   +2D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(27,32)
VS0(48,54)=QCz*VS0(48,33)+WQz*VS1(48,33)&
   +3D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(27,33)
VS0(48,55)=QCz*VS0(48,34)+WQz*VS1(48,34)&
   +3D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(27,34)
VS0(48,56)=QCz*VS0(48,35)+WQz*VS1(48,35)&
   +4D0*r1x2E*(VS0(48,20)-ZxZpE*VS1(48,20))&
   +2D0*HfxZpE*VS1(27,35)
VS0(49,36)=QCx*VS0(49,21)+WQx*VS1(49,21)&
   +4D0*r1x2E*(VS0(49,11)-ZxZpE*VS1(49,11))&
   +HfxZpE*VS1(32,21)
VS0(49,37)=QCx*VS0(49,22)+WQx*VS1(49,22)&
   +3D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +HfxZpE*VS1(32,22)
VS0(49,38)=QCx*VS0(49,23)+WQx*VS1(49,23)&
   +2D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +HfxZpE*VS1(32,23)
VS0(49,39)=QCy*VS0(49,23)+WQy*VS1(49,23)-r1x2E*VR1(49,23)&
   +2D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +2D0*HfxZpE*VS1(31,23)
VS0(49,40)=QCy*VS0(49,24)+WQy*VS1(49,24)-r1x2E*VR1(49,24)&
   +3D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +2D0*HfxZpE*VS1(31,24)
VS0(49,41)=QCy*VS0(49,25)+WQy*VS1(49,25)-r1x2E*VR1(49,25)&
   +4D0*r1x2E*(VS0(49,14)-ZxZpE*VS1(49,14))&
   +2D0*HfxZpE*VS1(31,25)
VS0(49,42)=QCx*VS0(49,26)+WQx*VS1(49,26)&
   +3D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +HfxZpE*VS1(32,26)
VS0(49,43)=QCx*VS0(49,27)+WQx*VS1(49,27)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +HfxZpE*VS1(32,27)
VS0(49,44)=QCx*VS0(49,28)+WQx*VS1(49,28)&
   +r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +HfxZpE*VS1(32,28)
VS0(49,45)=QCy*VS0(49,28)+WQy*VS1(49,28)-r1x2E*VR1(49,28)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(31,28)
VS0(49,46)=QCy*VS0(49,29)+WQy*VS1(49,29)-r1x2E*VR1(49,29)&
   +3D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(31,29)
VS0(49,47)=QCx*VS0(49,30)+WQx*VS1(49,30)&
   +2D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +HfxZpE*VS1(32,30)
VS0(49,48)=QCx*VS0(49,31)+WQx*VS1(49,31)&
   +r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +HfxZpE*VS1(32,31)
VS0(49,49)=QCy*VS0(49,31)+WQy*VS1(49,31)-r1x2E*VR1(49,31)&
   +r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(31,31)
VS0(49,50)=QCy*VS0(49,32)+WQy*VS1(49,32)-r1x2E*VR1(49,32)&
   +2D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(31,32)
VS0(49,51)=QCz*VS0(49,30)+WQz*VS1(49,30)&
   +2D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +2D0*HfxZpE*VS1(28,30)
VS0(49,52)=QCz*VS0(49,31)+WQz*VS1(49,31)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(28,31)
VS0(49,53)=QCz*VS0(49,32)+WQz*VS1(49,32)&
   +2D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(28,32)
VS0(49,54)=QCz*VS0(49,33)+WQz*VS1(49,33)&
   +3D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(28,33)
VS0(49,55)=QCz*VS0(49,34)+WQz*VS1(49,34)&
   +3D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(28,34)
VS0(49,56)=QCz*VS0(49,35)+WQz*VS1(49,35)&
   +4D0*r1x2E*(VS0(49,20)-ZxZpE*VS1(49,20))&
   +2D0*HfxZpE*VS1(28,35)
VS0(50,36)=QCx*VS0(50,21)+WQx*VS1(50,21)&
   +4D0*r1x2E*(VS0(50,11)-ZxZpE*VS1(50,11))
VS0(50,37)=QCx*VS0(50,22)+WQx*VS1(50,22)&
   +3D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))
VS0(50,38)=QCx*VS0(50,23)+WQx*VS1(50,23)&
   +2D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))
VS0(50,39)=QCy*VS0(50,23)+WQy*VS1(50,23)-r1x2E*VR1(50,23)&
   +2D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))&
   +3D0*HfxZpE*VS1(32,23)
VS0(50,40)=QCy*VS0(50,24)+WQy*VS1(50,24)-r1x2E*VR1(50,24)&
   +3D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))&
   +3D0*HfxZpE*VS1(32,24)
VS0(50,41)=QCy*VS0(50,25)+WQy*VS1(50,25)-r1x2E*VR1(50,25)&
   +4D0*r1x2E*(VS0(50,14)-ZxZpE*VS1(50,14))&
   +3D0*HfxZpE*VS1(32,25)
VS0(50,42)=QCx*VS0(50,26)+WQx*VS1(50,26)&
   +3D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))
VS0(50,43)=QCx*VS0(50,27)+WQx*VS1(50,27)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))
VS0(50,44)=QCx*VS0(50,28)+WQx*VS1(50,28)&
   +r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))
VS0(50,45)=QCy*VS0(50,28)+WQy*VS1(50,28)-r1x2E*VR1(50,28)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +3D0*HfxZpE*VS1(32,28)
VS0(50,46)=QCy*VS0(50,29)+WQy*VS1(50,29)-r1x2E*VR1(50,29)&
   +3D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +3D0*HfxZpE*VS1(32,29)
VS0(50,47)=QCx*VS0(50,30)+WQx*VS1(50,30)&
   +2D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))
VS0(50,48)=QCx*VS0(50,31)+WQx*VS1(50,31)&
   +r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))
VS0(50,49)=QCy*VS0(50,31)+WQy*VS1(50,31)-r1x2E*VR1(50,31)&
   +r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +3D0*HfxZpE*VS1(32,31)
VS0(50,50)=QCy*VS0(50,32)+WQy*VS1(50,32)-r1x2E*VR1(50,32)&
   +2D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +3D0*HfxZpE*VS1(32,32)
VS0(50,51)=QCz*VS0(50,30)+WQz*VS1(50,30)&
   +2D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))&
   +2D0*HfxZpE*VS1(29,30)
VS0(50,52)=QCz*VS0(50,31)+WQz*VS1(50,31)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +2D0*HfxZpE*VS1(29,31)
VS0(50,53)=QCz*VS0(50,32)+WQz*VS1(50,32)&
   +2D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +2D0*HfxZpE*VS1(29,32)
VS0(50,54)=QCz*VS0(50,33)+WQz*VS1(50,33)&
   +3D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +2D0*HfxZpE*VS1(29,33)
VS0(50,55)=QCz*VS0(50,34)+WQz*VS1(50,34)&
   +3D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +2D0*HfxZpE*VS1(29,34)
VS0(50,56)=QCz*VS0(50,35)+WQz*VS1(50,35)&
   +4D0*r1x2E*(VS0(50,20)-ZxZpE*VS1(50,20))&
   +2D0*HfxZpE*VS1(29,35)
VS0(51,36)=QCx*VS0(51,21)+WQx*VS1(51,21)&
   +4D0*r1x2E*(VS0(51,11)-ZxZpE*VS1(51,11))&
   +2D0*HfxZpE*VS1(33,21)
VS0(51,37)=QCx*VS0(51,22)+WQx*VS1(51,22)&
   +3D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))&
   +2D0*HfxZpE*VS1(33,22)
VS0(51,38)=QCx*VS0(51,23)+WQx*VS1(51,23)&
   +2D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))&
   +2D0*HfxZpE*VS1(33,23)
VS0(51,39)=QCy*VS0(51,23)+WQy*VS1(51,23)-r1x2E*VR1(51,23)&
   +2D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))
VS0(51,40)=QCy*VS0(51,24)+WQy*VS1(51,24)-r1x2E*VR1(51,24)&
   +3D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))
VS0(51,41)=QCy*VS0(51,25)+WQy*VS1(51,25)-r1x2E*VR1(51,25)&
   +4D0*r1x2E*(VS0(51,14)-ZxZpE*VS1(51,14))
VS0(51,42)=QCx*VS0(51,26)+WQx*VS1(51,26)&
   +3D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +2D0*HfxZpE*VS1(33,26)
VS0(51,43)=QCx*VS0(51,27)+WQx*VS1(51,27)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +2D0*HfxZpE*VS1(33,27)
VS0(51,44)=QCx*VS0(51,28)+WQx*VS1(51,28)&
   +r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +2D0*HfxZpE*VS1(33,28)
VS0(51,45)=QCy*VS0(51,28)+WQy*VS1(51,28)-r1x2E*VR1(51,28)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))
VS0(51,46)=QCy*VS0(51,29)+WQy*VS1(51,29)-r1x2E*VR1(51,29)&
   +3D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))
VS0(51,47)=QCx*VS0(51,30)+WQx*VS1(51,30)&
   +2D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +2D0*HfxZpE*VS1(33,30)
VS0(51,48)=QCx*VS0(51,31)+WQx*VS1(51,31)&
   +r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +2D0*HfxZpE*VS1(33,31)
VS0(51,49)=QCy*VS0(51,31)+WQy*VS1(51,31)-r1x2E*VR1(51,31)&
   +r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))
VS0(51,50)=QCy*VS0(51,32)+WQy*VS1(51,32)-r1x2E*VR1(51,32)&
   +2D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))
VS0(51,51)=QCz*VS0(51,30)+WQz*VS1(51,30)&
   +2D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +3D0*HfxZpE*VS1(30,30)
VS0(51,52)=QCz*VS0(51,31)+WQz*VS1(51,31)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +3D0*HfxZpE*VS1(30,31)
VS0(51,53)=QCz*VS0(51,32)+WQz*VS1(51,32)&
   +2D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +3D0*HfxZpE*VS1(30,32)
VS0(51,54)=QCz*VS0(51,33)+WQz*VS1(51,33)&
   +3D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +3D0*HfxZpE*VS1(30,33)
VS0(51,55)=QCz*VS0(51,34)+WQz*VS1(51,34)&
   +3D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +3D0*HfxZpE*VS1(30,34)
VS0(51,56)=QCz*VS0(51,35)+WQz*VS1(51,35)&
   +4D0*r1x2E*(VS0(51,20)-ZxZpE*VS1(51,20))&
   +3D0*HfxZpE*VS1(30,35)
VS0(52,36)=QCx*VS0(52,21)+WQx*VS1(52,21)&
   +4D0*r1x2E*(VS0(52,11)-ZxZpE*VS1(52,11))&
   +HfxZpE*VS1(34,21)
VS0(52,37)=QCx*VS0(52,22)+WQx*VS1(52,22)&
   +3D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(34,22)
VS0(52,38)=QCx*VS0(52,23)+WQx*VS1(52,23)&
   +2D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(34,23)
VS0(52,39)=QCy*VS0(52,23)+WQy*VS1(52,23)-r1x2E*VR1(52,23)&
   +2D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(33,23)
VS0(52,40)=QCy*VS0(52,24)+WQy*VS1(52,24)-r1x2E*VR1(52,24)&
   +3D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(33,24)
VS0(52,41)=QCy*VS0(52,25)+WQy*VS1(52,25)-r1x2E*VR1(52,25)&
   +4D0*r1x2E*(VS0(52,14)-ZxZpE*VS1(52,14))&
   +HfxZpE*VS1(33,25)
VS0(52,42)=QCx*VS0(52,26)+WQx*VS1(52,26)&
   +3D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +HfxZpE*VS1(34,26)
VS0(52,43)=QCx*VS0(52,27)+WQx*VS1(52,27)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(34,27)
VS0(52,44)=QCx*VS0(52,28)+WQx*VS1(52,28)&
   +r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(34,28)
VS0(52,45)=QCy*VS0(52,28)+WQy*VS1(52,28)-r1x2E*VR1(52,28)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(33,28)
VS0(52,46)=QCy*VS0(52,29)+WQy*VS1(52,29)-r1x2E*VR1(52,29)&
   +3D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(33,29)
VS0(52,47)=QCx*VS0(52,30)+WQx*VS1(52,30)&
   +2D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(34,30)
VS0(52,48)=QCx*VS0(52,31)+WQx*VS1(52,31)&
   +r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(34,31)
VS0(52,49)=QCy*VS0(52,31)+WQy*VS1(52,31)-r1x2E*VR1(52,31)&
   +r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(33,31)
VS0(52,50)=QCy*VS0(52,32)+WQy*VS1(52,32)-r1x2E*VR1(52,32)&
   +2D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(33,32)
VS0(52,51)=QCz*VS0(52,30)+WQz*VS1(52,30)&
   +2D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +3D0*HfxZpE*VS1(31,30)
VS0(52,52)=QCz*VS0(52,31)+WQz*VS1(52,31)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +3D0*HfxZpE*VS1(31,31)
VS0(52,53)=QCz*VS0(52,32)+WQz*VS1(52,32)&
   +2D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +3D0*HfxZpE*VS1(31,32)
VS0(52,54)=QCz*VS0(52,33)+WQz*VS1(52,33)&
   +3D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +3D0*HfxZpE*VS1(31,33)
VS0(52,55)=QCz*VS0(52,34)+WQz*VS1(52,34)&
   +3D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +3D0*HfxZpE*VS1(31,34)
VS0(52,56)=QCz*VS0(52,35)+WQz*VS1(52,35)&
   +4D0*r1x2E*(VS0(52,20)-ZxZpE*VS1(52,20))&
   +3D0*HfxZpE*VS1(31,35)
VS0(53,36)=QCx*VS0(53,21)+WQx*VS1(53,21)&
   +4D0*r1x2E*(VS0(53,11)-ZxZpE*VS1(53,11))
VS0(53,37)=QCx*VS0(53,22)+WQx*VS1(53,22)&
   +3D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))
VS0(53,38)=QCx*VS0(53,23)+WQx*VS1(53,23)&
   +2D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))
VS0(53,39)=QCy*VS0(53,23)+WQy*VS1(53,23)-r1x2E*VR1(53,23)&
   +2D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))&
   +2D0*HfxZpE*VS1(34,23)
VS0(53,40)=QCy*VS0(53,24)+WQy*VS1(53,24)-r1x2E*VR1(53,24)&
   +3D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))&
   +2D0*HfxZpE*VS1(34,24)
VS0(53,41)=QCy*VS0(53,25)+WQy*VS1(53,25)-r1x2E*VR1(53,25)&
   +4D0*r1x2E*(VS0(53,14)-ZxZpE*VS1(53,14))&
   +2D0*HfxZpE*VS1(34,25)
VS0(53,42)=QCx*VS0(53,26)+WQx*VS1(53,26)&
   +3D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))
VS0(53,43)=QCx*VS0(53,27)+WQx*VS1(53,27)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))
VS0(53,44)=QCx*VS0(53,28)+WQx*VS1(53,28)&
   +r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))
VS0(53,45)=QCy*VS0(53,28)+WQy*VS1(53,28)-r1x2E*VR1(53,28)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +2D0*HfxZpE*VS1(34,28)
VS0(53,46)=QCy*VS0(53,29)+WQy*VS1(53,29)-r1x2E*VR1(53,29)&
   +3D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +2D0*HfxZpE*VS1(34,29)
VS0(53,47)=QCx*VS0(53,30)+WQx*VS1(53,30)&
   +2D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))
VS0(53,48)=QCx*VS0(53,31)+WQx*VS1(53,31)&
   +r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))
VS0(53,49)=QCy*VS0(53,31)+WQy*VS1(53,31)-r1x2E*VR1(53,31)&
   +r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +2D0*HfxZpE*VS1(34,31)
VS0(53,50)=QCy*VS0(53,32)+WQy*VS1(53,32)-r1x2E*VR1(53,32)&
   +2D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +2D0*HfxZpE*VS1(34,32)
VS0(53,51)=QCz*VS0(53,30)+WQz*VS1(53,30)&
   +2D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))&
   +3D0*HfxZpE*VS1(32,30)
VS0(53,52)=QCz*VS0(53,31)+WQz*VS1(53,31)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +3D0*HfxZpE*VS1(32,31)
VS0(53,53)=QCz*VS0(53,32)+WQz*VS1(53,32)&
   +2D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +3D0*HfxZpE*VS1(32,32)
VS0(53,54)=QCz*VS0(53,33)+WQz*VS1(53,33)&
   +3D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +3D0*HfxZpE*VS1(32,33)
VS0(53,55)=QCz*VS0(53,34)+WQz*VS1(53,34)&
   +3D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +3D0*HfxZpE*VS1(32,34)
VS0(53,56)=QCz*VS0(53,35)+WQz*VS1(53,35)&
   +4D0*r1x2E*(VS0(53,20)-ZxZpE*VS1(53,20))&
   +3D0*HfxZpE*VS1(32,35)
VS0(54,36)=QCx*VS0(54,21)+WQx*VS1(54,21)&
   +4D0*r1x2E*(VS0(54,11)-ZxZpE*VS1(54,11))&
   +HfxZpE*VS1(35,21)
VS0(54,37)=QCx*VS0(54,22)+WQx*VS1(54,22)&
   +3D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))&
   +HfxZpE*VS1(35,22)
VS0(54,38)=QCx*VS0(54,23)+WQx*VS1(54,23)&
   +2D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))&
   +HfxZpE*VS1(35,23)
VS0(54,39)=QCy*VS0(54,23)+WQy*VS1(54,23)-r1x2E*VR1(54,23)&
   +2D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))
VS0(54,40)=QCy*VS0(54,24)+WQy*VS1(54,24)-r1x2E*VR1(54,24)&
   +3D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))
VS0(54,41)=QCy*VS0(54,25)+WQy*VS1(54,25)-r1x2E*VR1(54,25)&
   +4D0*r1x2E*(VS0(54,14)-ZxZpE*VS1(54,14))
VS0(54,42)=QCx*VS0(54,26)+WQx*VS1(54,26)&
   +3D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +HfxZpE*VS1(35,26)
VS0(54,43)=QCx*VS0(54,27)+WQx*VS1(54,27)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +HfxZpE*VS1(35,27)
VS0(54,44)=QCx*VS0(54,28)+WQx*VS1(54,28)&
   +r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +HfxZpE*VS1(35,28)
VS0(54,45)=QCy*VS0(54,28)+WQy*VS1(54,28)-r1x2E*VR1(54,28)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))
VS0(54,46)=QCy*VS0(54,29)+WQy*VS1(54,29)-r1x2E*VR1(54,29)&
   +3D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))
VS0(54,47)=QCx*VS0(54,30)+WQx*VS1(54,30)&
   +2D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +HfxZpE*VS1(35,30)
VS0(54,48)=QCx*VS0(54,31)+WQx*VS1(54,31)&
   +r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +HfxZpE*VS1(35,31)
VS0(54,49)=QCy*VS0(54,31)+WQy*VS1(54,31)-r1x2E*VR1(54,31)&
   +r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))
VS0(54,50)=QCy*VS0(54,32)+WQy*VS1(54,32)-r1x2E*VR1(54,32)&
   +2D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))
VS0(54,51)=QCz*VS0(54,30)+WQz*VS1(54,30)&
   +2D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +4D0*HfxZpE*VS1(33,30)
VS0(54,52)=QCz*VS0(54,31)+WQz*VS1(54,31)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +4D0*HfxZpE*VS1(33,31)
VS0(54,53)=QCz*VS0(54,32)+WQz*VS1(54,32)&
   +2D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +4D0*HfxZpE*VS1(33,32)
VS0(54,54)=QCz*VS0(54,33)+WQz*VS1(54,33)&
   +3D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +4D0*HfxZpE*VS1(33,33)
VS0(54,55)=QCz*VS0(54,34)+WQz*VS1(54,34)&
   +3D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +4D0*HfxZpE*VS1(33,34)
VS0(54,56)=QCz*VS0(54,35)+WQz*VS1(54,35)&
   +4D0*r1x2E*(VS0(54,20)-ZxZpE*VS1(54,20))&
   +4D0*HfxZpE*VS1(33,35)
VS0(55,36)=QCx*VS0(55,21)+WQx*VS1(55,21)&
   +4D0*r1x2E*(VS0(55,11)-ZxZpE*VS1(55,11))
VS0(55,37)=QCx*VS0(55,22)+WQx*VS1(55,22)&
   +3D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))
VS0(55,38)=QCx*VS0(55,23)+WQx*VS1(55,23)&
   +2D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))
VS0(55,39)=QCy*VS0(55,23)+WQy*VS1(55,23)-r1x2E*VR1(55,23)&
   +2D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))&
   +HfxZpE*VS1(35,23)
VS0(55,40)=QCy*VS0(55,24)+WQy*VS1(55,24)-r1x2E*VR1(55,24)&
   +3D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))&
   +HfxZpE*VS1(35,24)
VS0(55,41)=QCy*VS0(55,25)+WQy*VS1(55,25)-r1x2E*VR1(55,25)&
   +4D0*r1x2E*(VS0(55,14)-ZxZpE*VS1(55,14))&
   +HfxZpE*VS1(35,25)
VS0(55,42)=QCx*VS0(55,26)+WQx*VS1(55,26)&
   +3D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))
VS0(55,43)=QCx*VS0(55,27)+WQx*VS1(55,27)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))
VS0(55,44)=QCx*VS0(55,28)+WQx*VS1(55,28)&
   +r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))
VS0(55,45)=QCy*VS0(55,28)+WQy*VS1(55,28)-r1x2E*VR1(55,28)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +HfxZpE*VS1(35,28)
VS0(55,46)=QCy*VS0(55,29)+WQy*VS1(55,29)-r1x2E*VR1(55,29)&
   +3D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +HfxZpE*VS1(35,29)
VS0(55,47)=QCx*VS0(55,30)+WQx*VS1(55,30)&
   +2D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))
VS0(55,48)=QCx*VS0(55,31)+WQx*VS1(55,31)&
   +r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))
VS0(55,49)=QCy*VS0(55,31)+WQy*VS1(55,31)-r1x2E*VR1(55,31)&
   +r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +HfxZpE*VS1(35,31)
VS0(55,50)=QCy*VS0(55,32)+WQy*VS1(55,32)-r1x2E*VR1(55,32)&
   +2D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +HfxZpE*VS1(35,32)
VS0(55,51)=QCz*VS0(55,30)+WQz*VS1(55,30)&
   +2D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))&
   +4D0*HfxZpE*VS1(34,30)
VS0(55,52)=QCz*VS0(55,31)+WQz*VS1(55,31)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +4D0*HfxZpE*VS1(34,31)
VS0(55,53)=QCz*VS0(55,32)+WQz*VS1(55,32)&
   +2D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +4D0*HfxZpE*VS1(34,32)
VS0(55,54)=QCz*VS0(55,33)+WQz*VS1(55,33)&
   +3D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +4D0*HfxZpE*VS1(34,33)
VS0(55,55)=QCz*VS0(55,34)+WQz*VS1(55,34)&
   +3D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +4D0*HfxZpE*VS1(34,34)
VS0(55,56)=QCz*VS0(55,35)+WQz*VS1(55,35)&
   +4D0*r1x2E*(VS0(55,20)-ZxZpE*VS1(55,20))&
   +4D0*HfxZpE*VS1(34,35)
VS0(56,36)=QCx*VS0(56,21)+WQx*VS1(56,21)&
   +4D0*r1x2E*(VS0(56,11)-ZxZpE*VS1(56,11))
VS0(56,37)=QCx*VS0(56,22)+WQx*VS1(56,22)&
   +3D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,38)=QCx*VS0(56,23)+WQx*VS1(56,23)&
   +2D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,39)=QCy*VS0(56,23)+WQy*VS1(56,23)-r1x2E*VR1(56,23)&
   +2D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,40)=QCy*VS0(56,24)+WQy*VS1(56,24)-r1x2E*VR1(56,24)&
   +3D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,41)=QCy*VS0(56,25)+WQy*VS1(56,25)-r1x2E*VR1(56,25)&
   +4D0*r1x2E*(VS0(56,14)-ZxZpE*VS1(56,14))
VS0(56,42)=QCx*VS0(56,26)+WQx*VS1(56,26)&
   +3D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))
VS0(56,43)=QCx*VS0(56,27)+WQx*VS1(56,27)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,44)=QCx*VS0(56,28)+WQx*VS1(56,28)&
   +r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,45)=QCy*VS0(56,28)+WQy*VS1(56,28)-r1x2E*VR1(56,28)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,46)=QCy*VS0(56,29)+WQy*VS1(56,29)-r1x2E*VR1(56,29)&
   +3D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,47)=QCx*VS0(56,30)+WQx*VS1(56,30)&
   +2D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,48)=QCx*VS0(56,31)+WQx*VS1(56,31)&
   +r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,49)=QCy*VS0(56,31)+WQy*VS1(56,31)-r1x2E*VR1(56,31)&
   +r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,50)=QCy*VS0(56,32)+WQy*VS1(56,32)-r1x2E*VR1(56,32)&
   +2D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,51)=QCz*VS0(56,30)+WQz*VS1(56,30)&
   +2D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))&
   +5D0*HfxZpE*VS1(35,30)
VS0(56,52)=QCz*VS0(56,31)+WQz*VS1(56,31)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))&
   +5D0*HfxZpE*VS1(35,31)
VS0(56,53)=QCz*VS0(56,32)+WQz*VS1(56,32)&
   +2D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))&
   +5D0*HfxZpE*VS1(35,32)
VS0(56,54)=QCz*VS0(56,33)+WQz*VS1(56,33)&
   +3D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))&
   +5D0*HfxZpE*VS1(35,33)
VS0(56,55)=QCz*VS0(56,34)+WQz*VS1(56,34)&
   +3D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))&
   +5D0*HfxZpE*VS1(35,34)
VS0(56,56)=QCz*VS0(56,35)+WQz*VS1(56,35)&
   +4D0*r1x2E*(VS0(56,20)-ZxZpE*VS1(56,20))&
   +5D0*HfxZpE*VS1(35,35)
CASE(3)
VS0(36,36)=QCx*VS0(36,21)+WQx*VS1(36,21)&
   +4D0*r1x2E*(VS0(36,11)-ZxZpE*VS1(36,11))&
   +5D0*HfxZpE*VS1(21,21)
VS0(36,37)=QCx*VS0(36,22)+WQx*VS1(36,22)&
   +3D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))&
   +5D0*HfxZpE*VS1(21,22)
VS0(36,38)=QCx*VS0(36,23)+WQx*VS1(36,23)&
   +2D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))&
   +5D0*HfxZpE*VS1(21,23)
VS0(36,39)=QCy*VS0(36,23)+WQy*VS1(36,23)&
   +2D0*r1x2E*(VS0(36,12)-ZxZpE*VS1(36,12))
VS0(36,40)=QCy*VS0(36,24)+WQy*VS1(36,24)&
   +3D0*r1x2E*(VS0(36,13)-ZxZpE*VS1(36,13))
VS0(36,41)=QCy*VS0(36,25)+WQy*VS1(36,25)&
   +4D0*r1x2E*(VS0(36,14)-ZxZpE*VS1(36,14))
VS0(36,42)=QCx*VS0(36,26)+WQx*VS1(36,26)&
   +3D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))&
   +5D0*HfxZpE*VS1(21,26)
VS0(36,43)=QCx*VS0(36,27)+WQx*VS1(36,27)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))&
   +5D0*HfxZpE*VS1(21,27)
VS0(36,44)=QCx*VS0(36,28)+WQx*VS1(36,28)&
   +r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))&
   +5D0*HfxZpE*VS1(21,28)
VS0(36,45)=QCy*VS0(36,28)+WQy*VS1(36,28)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,46)=QCy*VS0(36,29)+WQy*VS1(36,29)&
   +3D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,47)=QCx*VS0(36,30)+WQx*VS1(36,30)&
   +2D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))&
   +5D0*HfxZpE*VS1(21,30)
VS0(36,48)=QCx*VS0(36,31)+WQx*VS1(36,31)&
   +r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))&
   +5D0*HfxZpE*VS1(21,31)
VS0(36,49)=QCy*VS0(36,31)+WQy*VS1(36,31)&
   +r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,50)=QCy*VS0(36,32)+WQy*VS1(36,32)&
   +2D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,51)=QCz*VS0(36,30)+WQz*VS1(36,30)-r1x2E*VR1(36,30)&
   +2D0*r1x2E*(VS0(36,15)-ZxZpE*VS1(36,15))
VS0(36,52)=QCz*VS0(36,31)+WQz*VS1(36,31)-r1x2E*VR1(36,31)&
   +2D0*r1x2E*(VS0(36,16)-ZxZpE*VS1(36,16))
VS0(36,53)=QCz*VS0(36,32)+WQz*VS1(36,32)-r1x2E*VR1(36,32)&
   +2D0*r1x2E*(VS0(36,17)-ZxZpE*VS1(36,17))
VS0(36,54)=QCz*VS0(36,33)+WQz*VS1(36,33)-r1x2E*VR1(36,33)&
   +3D0*r1x2E*(VS0(36,18)-ZxZpE*VS1(36,18))
VS0(36,55)=QCz*VS0(36,34)+WQz*VS1(36,34)-r1x2E*VR1(36,34)&
   +3D0*r1x2E*(VS0(36,19)-ZxZpE*VS1(36,19))
VS0(36,56)=QCz*VS0(36,35)+WQz*VS1(36,35)-r1x2E*VR1(36,35)&
   +4D0*r1x2E*(VS0(36,20)-ZxZpE*VS1(36,20))
VS0(37,36)=QCx*VS0(37,21)+WQx*VS1(37,21)&
   +4D0*r1x2E*(VS0(37,11)-ZxZpE*VS1(37,11))&
   +4D0*HfxZpE*VS1(22,21)
VS0(37,37)=QCx*VS0(37,22)+WQx*VS1(37,22)&
   +3D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +4D0*HfxZpE*VS1(22,22)
VS0(37,38)=QCx*VS0(37,23)+WQx*VS1(37,23)&
   +2D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +4D0*HfxZpE*VS1(22,23)
VS0(37,39)=QCy*VS0(37,23)+WQy*VS1(37,23)&
   +2D0*r1x2E*(VS0(37,12)-ZxZpE*VS1(37,12))&
   +HfxZpE*VS1(21,23)
VS0(37,40)=QCy*VS0(37,24)+WQy*VS1(37,24)&
   +3D0*r1x2E*(VS0(37,13)-ZxZpE*VS1(37,13))&
   +HfxZpE*VS1(21,24)
VS0(37,41)=QCy*VS0(37,25)+WQy*VS1(37,25)&
   +4D0*r1x2E*(VS0(37,14)-ZxZpE*VS1(37,14))&
   +HfxZpE*VS1(21,25)
VS0(37,42)=QCx*VS0(37,26)+WQx*VS1(37,26)&
   +3D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))&
   +4D0*HfxZpE*VS1(22,26)
VS0(37,43)=QCx*VS0(37,27)+WQx*VS1(37,27)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +4D0*HfxZpE*VS1(22,27)
VS0(37,44)=QCx*VS0(37,28)+WQx*VS1(37,28)&
   +r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +4D0*HfxZpE*VS1(22,28)
VS0(37,45)=QCy*VS0(37,28)+WQy*VS1(37,28)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))&
   +HfxZpE*VS1(21,28)
VS0(37,46)=QCy*VS0(37,29)+WQy*VS1(37,29)&
   +3D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))&
   +HfxZpE*VS1(21,29)
VS0(37,47)=QCx*VS0(37,30)+WQx*VS1(37,30)&
   +2D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +4D0*HfxZpE*VS1(22,30)
VS0(37,48)=QCx*VS0(37,31)+WQx*VS1(37,31)&
   +r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +4D0*HfxZpE*VS1(22,31)
VS0(37,49)=QCy*VS0(37,31)+WQy*VS1(37,31)&
   +r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))&
   +HfxZpE*VS1(21,31)
VS0(37,50)=QCy*VS0(37,32)+WQy*VS1(37,32)&
   +2D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))&
   +HfxZpE*VS1(21,32)
VS0(37,51)=QCz*VS0(37,30)+WQz*VS1(37,30)-r1x2E*VR1(37,30)&
   +2D0*r1x2E*(VS0(37,15)-ZxZpE*VS1(37,15))
VS0(37,52)=QCz*VS0(37,31)+WQz*VS1(37,31)-r1x2E*VR1(37,31)&
   +2D0*r1x2E*(VS0(37,16)-ZxZpE*VS1(37,16))
VS0(37,53)=QCz*VS0(37,32)+WQz*VS1(37,32)-r1x2E*VR1(37,32)&
   +2D0*r1x2E*(VS0(37,17)-ZxZpE*VS1(37,17))
VS0(37,54)=QCz*VS0(37,33)+WQz*VS1(37,33)-r1x2E*VR1(37,33)&
   +3D0*r1x2E*(VS0(37,18)-ZxZpE*VS1(37,18))
VS0(37,55)=QCz*VS0(37,34)+WQz*VS1(37,34)-r1x2E*VR1(37,34)&
   +3D0*r1x2E*(VS0(37,19)-ZxZpE*VS1(37,19))
VS0(37,56)=QCz*VS0(37,35)+WQz*VS1(37,35)-r1x2E*VR1(37,35)&
   +4D0*r1x2E*(VS0(37,20)-ZxZpE*VS1(37,20))
VS0(38,36)=QCx*VS0(38,21)+WQx*VS1(38,21)&
   +4D0*r1x2E*(VS0(38,11)-ZxZpE*VS1(38,11))&
   +3D0*HfxZpE*VS1(23,21)
VS0(38,37)=QCx*VS0(38,22)+WQx*VS1(38,22)&
   +3D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +3D0*HfxZpE*VS1(23,22)
VS0(38,38)=QCx*VS0(38,23)+WQx*VS1(38,23)&
   +2D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +3D0*HfxZpE*VS1(23,23)
VS0(38,39)=QCy*VS0(38,23)+WQy*VS1(38,23)&
   +2D0*r1x2E*(VS0(38,12)-ZxZpE*VS1(38,12))&
   +2D0*HfxZpE*VS1(22,23)
VS0(38,40)=QCy*VS0(38,24)+WQy*VS1(38,24)&
   +3D0*r1x2E*(VS0(38,13)-ZxZpE*VS1(38,13))&
   +2D0*HfxZpE*VS1(22,24)
VS0(38,41)=QCy*VS0(38,25)+WQy*VS1(38,25)&
   +4D0*r1x2E*(VS0(38,14)-ZxZpE*VS1(38,14))&
   +2D0*HfxZpE*VS1(22,25)
VS0(38,42)=QCx*VS0(38,26)+WQx*VS1(38,26)&
   +3D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))&
   +3D0*HfxZpE*VS1(23,26)
VS0(38,43)=QCx*VS0(38,27)+WQx*VS1(38,27)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +3D0*HfxZpE*VS1(23,27)
VS0(38,44)=QCx*VS0(38,28)+WQx*VS1(38,28)&
   +r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +3D0*HfxZpE*VS1(23,28)
VS0(38,45)=QCy*VS0(38,28)+WQy*VS1(38,28)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))&
   +2D0*HfxZpE*VS1(22,28)
VS0(38,46)=QCy*VS0(38,29)+WQy*VS1(38,29)&
   +3D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))&
   +2D0*HfxZpE*VS1(22,29)
VS0(38,47)=QCx*VS0(38,30)+WQx*VS1(38,30)&
   +2D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +3D0*HfxZpE*VS1(23,30)
VS0(38,48)=QCx*VS0(38,31)+WQx*VS1(38,31)&
   +r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +3D0*HfxZpE*VS1(23,31)
VS0(38,49)=QCy*VS0(38,31)+WQy*VS1(38,31)&
   +r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))&
   +2D0*HfxZpE*VS1(22,31)
VS0(38,50)=QCy*VS0(38,32)+WQy*VS1(38,32)&
   +2D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))&
   +2D0*HfxZpE*VS1(22,32)
VS0(38,51)=QCz*VS0(38,30)+WQz*VS1(38,30)-r1x2E*VR1(38,30)&
   +2D0*r1x2E*(VS0(38,15)-ZxZpE*VS1(38,15))
VS0(38,52)=QCz*VS0(38,31)+WQz*VS1(38,31)-r1x2E*VR1(38,31)&
   +2D0*r1x2E*(VS0(38,16)-ZxZpE*VS1(38,16))
VS0(38,53)=QCz*VS0(38,32)+WQz*VS1(38,32)-r1x2E*VR1(38,32)&
   +2D0*r1x2E*(VS0(38,17)-ZxZpE*VS1(38,17))
VS0(38,54)=QCz*VS0(38,33)+WQz*VS1(38,33)-r1x2E*VR1(38,33)&
   +3D0*r1x2E*(VS0(38,18)-ZxZpE*VS1(38,18))
VS0(38,55)=QCz*VS0(38,34)+WQz*VS1(38,34)-r1x2E*VR1(38,34)&
   +3D0*r1x2E*(VS0(38,19)-ZxZpE*VS1(38,19))
VS0(38,56)=QCz*VS0(38,35)+WQz*VS1(38,35)-r1x2E*VR1(38,35)&
   +4D0*r1x2E*(VS0(38,20)-ZxZpE*VS1(38,20))
VS0(39,36)=QCx*VS0(39,21)+WQx*VS1(39,21)&
   +4D0*r1x2E*(VS0(39,11)-ZxZpE*VS1(39,11))&
   +2D0*HfxZpE*VS1(24,21)
VS0(39,37)=QCx*VS0(39,22)+WQx*VS1(39,22)&
   +3D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +2D0*HfxZpE*VS1(24,22)
VS0(39,38)=QCx*VS0(39,23)+WQx*VS1(39,23)&
   +2D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +2D0*HfxZpE*VS1(24,23)
VS0(39,39)=QCy*VS0(39,23)+WQy*VS1(39,23)&
   +2D0*r1x2E*(VS0(39,12)-ZxZpE*VS1(39,12))&
   +3D0*HfxZpE*VS1(23,23)
VS0(39,40)=QCy*VS0(39,24)+WQy*VS1(39,24)&
   +3D0*r1x2E*(VS0(39,13)-ZxZpE*VS1(39,13))&
   +3D0*HfxZpE*VS1(23,24)
VS0(39,41)=QCy*VS0(39,25)+WQy*VS1(39,25)&
   +4D0*r1x2E*(VS0(39,14)-ZxZpE*VS1(39,14))&
   +3D0*HfxZpE*VS1(23,25)
VS0(39,42)=QCx*VS0(39,26)+WQx*VS1(39,26)&
   +3D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))&
   +2D0*HfxZpE*VS1(24,26)
VS0(39,43)=QCx*VS0(39,27)+WQx*VS1(39,27)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +2D0*HfxZpE*VS1(24,27)
VS0(39,44)=QCx*VS0(39,28)+WQx*VS1(39,28)&
   +r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +2D0*HfxZpE*VS1(24,28)
VS0(39,45)=QCy*VS0(39,28)+WQy*VS1(39,28)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))&
   +3D0*HfxZpE*VS1(23,28)
VS0(39,46)=QCy*VS0(39,29)+WQy*VS1(39,29)&
   +3D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))&
   +3D0*HfxZpE*VS1(23,29)
VS0(39,47)=QCx*VS0(39,30)+WQx*VS1(39,30)&
   +2D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +2D0*HfxZpE*VS1(24,30)
VS0(39,48)=QCx*VS0(39,31)+WQx*VS1(39,31)&
   +r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +2D0*HfxZpE*VS1(24,31)
VS0(39,49)=QCy*VS0(39,31)+WQy*VS1(39,31)&
   +r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))&
   +3D0*HfxZpE*VS1(23,31)
VS0(39,50)=QCy*VS0(39,32)+WQy*VS1(39,32)&
   +2D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))&
   +3D0*HfxZpE*VS1(23,32)
VS0(39,51)=QCz*VS0(39,30)+WQz*VS1(39,30)-r1x2E*VR1(39,30)&
   +2D0*r1x2E*(VS0(39,15)-ZxZpE*VS1(39,15))
VS0(39,52)=QCz*VS0(39,31)+WQz*VS1(39,31)-r1x2E*VR1(39,31)&
   +2D0*r1x2E*(VS0(39,16)-ZxZpE*VS1(39,16))
VS0(39,53)=QCz*VS0(39,32)+WQz*VS1(39,32)-r1x2E*VR1(39,32)&
   +2D0*r1x2E*(VS0(39,17)-ZxZpE*VS1(39,17))
VS0(39,54)=QCz*VS0(39,33)+WQz*VS1(39,33)-r1x2E*VR1(39,33)&
   +3D0*r1x2E*(VS0(39,18)-ZxZpE*VS1(39,18))
VS0(39,55)=QCz*VS0(39,34)+WQz*VS1(39,34)-r1x2E*VR1(39,34)&
   +3D0*r1x2E*(VS0(39,19)-ZxZpE*VS1(39,19))
VS0(39,56)=QCz*VS0(39,35)+WQz*VS1(39,35)-r1x2E*VR1(39,35)&
   +4D0*r1x2E*(VS0(39,20)-ZxZpE*VS1(39,20))
VS0(40,36)=QCx*VS0(40,21)+WQx*VS1(40,21)&
   +4D0*r1x2E*(VS0(40,11)-ZxZpE*VS1(40,11))&
   +HfxZpE*VS1(25,21)
VS0(40,37)=QCx*VS0(40,22)+WQx*VS1(40,22)&
   +3D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +HfxZpE*VS1(25,22)
VS0(40,38)=QCx*VS0(40,23)+WQx*VS1(40,23)&
   +2D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +HfxZpE*VS1(25,23)
VS0(40,39)=QCy*VS0(40,23)+WQy*VS1(40,23)&
   +2D0*r1x2E*(VS0(40,12)-ZxZpE*VS1(40,12))&
   +4D0*HfxZpE*VS1(24,23)
VS0(40,40)=QCy*VS0(40,24)+WQy*VS1(40,24)&
   +3D0*r1x2E*(VS0(40,13)-ZxZpE*VS1(40,13))&
   +4D0*HfxZpE*VS1(24,24)
VS0(40,41)=QCy*VS0(40,25)+WQy*VS1(40,25)&
   +4D0*r1x2E*(VS0(40,14)-ZxZpE*VS1(40,14))&
   +4D0*HfxZpE*VS1(24,25)
VS0(40,42)=QCx*VS0(40,26)+WQx*VS1(40,26)&
   +3D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))&
   +HfxZpE*VS1(25,26)
VS0(40,43)=QCx*VS0(40,27)+WQx*VS1(40,27)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +HfxZpE*VS1(25,27)
VS0(40,44)=QCx*VS0(40,28)+WQx*VS1(40,28)&
   +r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +HfxZpE*VS1(25,28)
VS0(40,45)=QCy*VS0(40,28)+WQy*VS1(40,28)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))&
   +4D0*HfxZpE*VS1(24,28)
VS0(40,46)=QCy*VS0(40,29)+WQy*VS1(40,29)&
   +3D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))&
   +4D0*HfxZpE*VS1(24,29)
VS0(40,47)=QCx*VS0(40,30)+WQx*VS1(40,30)&
   +2D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +HfxZpE*VS1(25,30)
VS0(40,48)=QCx*VS0(40,31)+WQx*VS1(40,31)&
   +r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +HfxZpE*VS1(25,31)
VS0(40,49)=QCy*VS0(40,31)+WQy*VS1(40,31)&
   +r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))&
   +4D0*HfxZpE*VS1(24,31)
VS0(40,50)=QCy*VS0(40,32)+WQy*VS1(40,32)&
   +2D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))&
   +4D0*HfxZpE*VS1(24,32)
VS0(40,51)=QCz*VS0(40,30)+WQz*VS1(40,30)-r1x2E*VR1(40,30)&
   +2D0*r1x2E*(VS0(40,15)-ZxZpE*VS1(40,15))
VS0(40,52)=QCz*VS0(40,31)+WQz*VS1(40,31)-r1x2E*VR1(40,31)&
   +2D0*r1x2E*(VS0(40,16)-ZxZpE*VS1(40,16))
VS0(40,53)=QCz*VS0(40,32)+WQz*VS1(40,32)-r1x2E*VR1(40,32)&
   +2D0*r1x2E*(VS0(40,17)-ZxZpE*VS1(40,17))
VS0(40,54)=QCz*VS0(40,33)+WQz*VS1(40,33)-r1x2E*VR1(40,33)&
   +3D0*r1x2E*(VS0(40,18)-ZxZpE*VS1(40,18))
VS0(40,55)=QCz*VS0(40,34)+WQz*VS1(40,34)-r1x2E*VR1(40,34)&
   +3D0*r1x2E*(VS0(40,19)-ZxZpE*VS1(40,19))
VS0(40,56)=QCz*VS0(40,35)+WQz*VS1(40,35)-r1x2E*VR1(40,35)&
   +4D0*r1x2E*(VS0(40,20)-ZxZpE*VS1(40,20))
VS0(41,36)=QCx*VS0(41,21)+WQx*VS1(41,21)&
   +4D0*r1x2E*(VS0(41,11)-ZxZpE*VS1(41,11))
VS0(41,37)=QCx*VS0(41,22)+WQx*VS1(41,22)&
   +3D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))
VS0(41,38)=QCx*VS0(41,23)+WQx*VS1(41,23)&
   +2D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))
VS0(41,39)=QCy*VS0(41,23)+WQy*VS1(41,23)&
   +2D0*r1x2E*(VS0(41,12)-ZxZpE*VS1(41,12))&
   +5D0*HfxZpE*VS1(25,23)
VS0(41,40)=QCy*VS0(41,24)+WQy*VS1(41,24)&
   +3D0*r1x2E*(VS0(41,13)-ZxZpE*VS1(41,13))&
   +5D0*HfxZpE*VS1(25,24)
VS0(41,41)=QCy*VS0(41,25)+WQy*VS1(41,25)&
   +4D0*r1x2E*(VS0(41,14)-ZxZpE*VS1(41,14))&
   +5D0*HfxZpE*VS1(25,25)
VS0(41,42)=QCx*VS0(41,26)+WQx*VS1(41,26)&
   +3D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,43)=QCx*VS0(41,27)+WQx*VS1(41,27)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,44)=QCx*VS0(41,28)+WQx*VS1(41,28)&
   +r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,45)=QCy*VS0(41,28)+WQy*VS1(41,28)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))&
   +5D0*HfxZpE*VS1(25,28)
VS0(41,46)=QCy*VS0(41,29)+WQy*VS1(41,29)&
   +3D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))&
   +5D0*HfxZpE*VS1(25,29)
VS0(41,47)=QCx*VS0(41,30)+WQx*VS1(41,30)&
   +2D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,48)=QCx*VS0(41,31)+WQx*VS1(41,31)&
   +r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,49)=QCy*VS0(41,31)+WQy*VS1(41,31)&
   +r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))&
   +5D0*HfxZpE*VS1(25,31)
VS0(41,50)=QCy*VS0(41,32)+WQy*VS1(41,32)&
   +2D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))&
   +5D0*HfxZpE*VS1(25,32)
VS0(41,51)=QCz*VS0(41,30)+WQz*VS1(41,30)-r1x2E*VR1(41,30)&
   +2D0*r1x2E*(VS0(41,15)-ZxZpE*VS1(41,15))
VS0(41,52)=QCz*VS0(41,31)+WQz*VS1(41,31)-r1x2E*VR1(41,31)&
   +2D0*r1x2E*(VS0(41,16)-ZxZpE*VS1(41,16))
VS0(41,53)=QCz*VS0(41,32)+WQz*VS1(41,32)-r1x2E*VR1(41,32)&
   +2D0*r1x2E*(VS0(41,17)-ZxZpE*VS1(41,17))
VS0(41,54)=QCz*VS0(41,33)+WQz*VS1(41,33)-r1x2E*VR1(41,33)&
   +3D0*r1x2E*(VS0(41,18)-ZxZpE*VS1(41,18))
VS0(41,55)=QCz*VS0(41,34)+WQz*VS1(41,34)-r1x2E*VR1(41,34)&
   +3D0*r1x2E*(VS0(41,19)-ZxZpE*VS1(41,19))
VS0(41,56)=QCz*VS0(41,35)+WQz*VS1(41,35)-r1x2E*VR1(41,35)&
   +4D0*r1x2E*(VS0(41,20)-ZxZpE*VS1(41,20))
VS0(42,36)=QCx*VS0(42,21)+WQx*VS1(42,21)&
   +4D0*r1x2E*(VS0(42,11)-ZxZpE*VS1(42,11))&
   +4D0*HfxZpE*VS1(26,21)
VS0(42,37)=QCx*VS0(42,22)+WQx*VS1(42,22)&
   +3D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))&
   +4D0*HfxZpE*VS1(26,22)
VS0(42,38)=QCx*VS0(42,23)+WQx*VS1(42,23)&
   +2D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))&
   +4D0*HfxZpE*VS1(26,23)
VS0(42,39)=QCy*VS0(42,23)+WQy*VS1(42,23)&
   +2D0*r1x2E*(VS0(42,12)-ZxZpE*VS1(42,12))
VS0(42,40)=QCy*VS0(42,24)+WQy*VS1(42,24)&
   +3D0*r1x2E*(VS0(42,13)-ZxZpE*VS1(42,13))
VS0(42,41)=QCy*VS0(42,25)+WQy*VS1(42,25)&
   +4D0*r1x2E*(VS0(42,14)-ZxZpE*VS1(42,14))
VS0(42,42)=QCx*VS0(42,26)+WQx*VS1(42,26)&
   +3D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +4D0*HfxZpE*VS1(26,26)
VS0(42,43)=QCx*VS0(42,27)+WQx*VS1(42,27)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +4D0*HfxZpE*VS1(26,27)
VS0(42,44)=QCx*VS0(42,28)+WQx*VS1(42,28)&
   +r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +4D0*HfxZpE*VS1(26,28)
VS0(42,45)=QCy*VS0(42,28)+WQy*VS1(42,28)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))
VS0(42,46)=QCy*VS0(42,29)+WQy*VS1(42,29)&
   +3D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))
VS0(42,47)=QCx*VS0(42,30)+WQx*VS1(42,30)&
   +2D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +4D0*HfxZpE*VS1(26,30)
VS0(42,48)=QCx*VS0(42,31)+WQx*VS1(42,31)&
   +r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +4D0*HfxZpE*VS1(26,31)
VS0(42,49)=QCy*VS0(42,31)+WQy*VS1(42,31)&
   +r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))
VS0(42,50)=QCy*VS0(42,32)+WQy*VS1(42,32)&
   +2D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))
VS0(42,51)=QCz*VS0(42,30)+WQz*VS1(42,30)-r1x2E*VR1(42,30)&
   +2D0*r1x2E*(VS0(42,15)-ZxZpE*VS1(42,15))&
   +HfxZpE*VS1(21,30)
VS0(42,52)=QCz*VS0(42,31)+WQz*VS1(42,31)-r1x2E*VR1(42,31)&
   +2D0*r1x2E*(VS0(42,16)-ZxZpE*VS1(42,16))&
   +HfxZpE*VS1(21,31)
VS0(42,53)=QCz*VS0(42,32)+WQz*VS1(42,32)-r1x2E*VR1(42,32)&
   +2D0*r1x2E*(VS0(42,17)-ZxZpE*VS1(42,17))&
   +HfxZpE*VS1(21,32)
VS0(42,54)=QCz*VS0(42,33)+WQz*VS1(42,33)-r1x2E*VR1(42,33)&
   +3D0*r1x2E*(VS0(42,18)-ZxZpE*VS1(42,18))&
   +HfxZpE*VS1(21,33)
VS0(42,55)=QCz*VS0(42,34)+WQz*VS1(42,34)-r1x2E*VR1(42,34)&
   +3D0*r1x2E*(VS0(42,19)-ZxZpE*VS1(42,19))&
   +HfxZpE*VS1(21,34)
VS0(42,56)=QCz*VS0(42,35)+WQz*VS1(42,35)-r1x2E*VR1(42,35)&
   +4D0*r1x2E*(VS0(42,20)-ZxZpE*VS1(42,20))&
   +HfxZpE*VS1(21,35)
VS0(43,36)=QCx*VS0(43,21)+WQx*VS1(43,21)&
   +4D0*r1x2E*(VS0(43,11)-ZxZpE*VS1(43,11))&
   +3D0*HfxZpE*VS1(27,21)
VS0(43,37)=QCx*VS0(43,22)+WQx*VS1(43,22)&
   +3D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +3D0*HfxZpE*VS1(27,22)
VS0(43,38)=QCx*VS0(43,23)+WQx*VS1(43,23)&
   +2D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +3D0*HfxZpE*VS1(27,23)
VS0(43,39)=QCy*VS0(43,23)+WQy*VS1(43,23)&
   +2D0*r1x2E*(VS0(43,12)-ZxZpE*VS1(43,12))&
   +HfxZpE*VS1(26,23)
VS0(43,40)=QCy*VS0(43,24)+WQy*VS1(43,24)&
   +3D0*r1x2E*(VS0(43,13)-ZxZpE*VS1(43,13))&
   +HfxZpE*VS1(26,24)
VS0(43,41)=QCy*VS0(43,25)+WQy*VS1(43,25)&
   +4D0*r1x2E*(VS0(43,14)-ZxZpE*VS1(43,14))&
   +HfxZpE*VS1(26,25)
VS0(43,42)=QCx*VS0(43,26)+WQx*VS1(43,26)&
   +3D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +3D0*HfxZpE*VS1(27,26)
VS0(43,43)=QCx*VS0(43,27)+WQx*VS1(43,27)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +3D0*HfxZpE*VS1(27,27)
VS0(43,44)=QCx*VS0(43,28)+WQx*VS1(43,28)&
   +r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +3D0*HfxZpE*VS1(27,28)
VS0(43,45)=QCy*VS0(43,28)+WQy*VS1(43,28)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(26,28)
VS0(43,46)=QCy*VS0(43,29)+WQy*VS1(43,29)&
   +3D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(26,29)
VS0(43,47)=QCx*VS0(43,30)+WQx*VS1(43,30)&
   +2D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +3D0*HfxZpE*VS1(27,30)
VS0(43,48)=QCx*VS0(43,31)+WQx*VS1(43,31)&
   +r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +3D0*HfxZpE*VS1(27,31)
VS0(43,49)=QCy*VS0(43,31)+WQy*VS1(43,31)&
   +r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(26,31)
VS0(43,50)=QCy*VS0(43,32)+WQy*VS1(43,32)&
   +2D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(26,32)
VS0(43,51)=QCz*VS0(43,30)+WQz*VS1(43,30)-r1x2E*VR1(43,30)&
   +2D0*r1x2E*(VS0(43,15)-ZxZpE*VS1(43,15))&
   +HfxZpE*VS1(22,30)
VS0(43,52)=QCz*VS0(43,31)+WQz*VS1(43,31)-r1x2E*VR1(43,31)&
   +2D0*r1x2E*(VS0(43,16)-ZxZpE*VS1(43,16))&
   +HfxZpE*VS1(22,31)
VS0(43,53)=QCz*VS0(43,32)+WQz*VS1(43,32)-r1x2E*VR1(43,32)&
   +2D0*r1x2E*(VS0(43,17)-ZxZpE*VS1(43,17))&
   +HfxZpE*VS1(22,32)
VS0(43,54)=QCz*VS0(43,33)+WQz*VS1(43,33)-r1x2E*VR1(43,33)&
   +3D0*r1x2E*(VS0(43,18)-ZxZpE*VS1(43,18))&
   +HfxZpE*VS1(22,33)
VS0(43,55)=QCz*VS0(43,34)+WQz*VS1(43,34)-r1x2E*VR1(43,34)&
   +3D0*r1x2E*(VS0(43,19)-ZxZpE*VS1(43,19))&
   +HfxZpE*VS1(22,34)
VS0(43,56)=QCz*VS0(43,35)+WQz*VS1(43,35)-r1x2E*VR1(43,35)&
   +4D0*r1x2E*(VS0(43,20)-ZxZpE*VS1(43,20))&
   +HfxZpE*VS1(22,35)
VS0(44,36)=QCx*VS0(44,21)+WQx*VS1(44,21)&
   +4D0*r1x2E*(VS0(44,11)-ZxZpE*VS1(44,11))&
   +2D0*HfxZpE*VS1(28,21)
VS0(44,37)=QCx*VS0(44,22)+WQx*VS1(44,22)&
   +3D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(28,22)
VS0(44,38)=QCx*VS0(44,23)+WQx*VS1(44,23)&
   +2D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(28,23)
VS0(44,39)=QCy*VS0(44,23)+WQy*VS1(44,23)&
   +2D0*r1x2E*(VS0(44,12)-ZxZpE*VS1(44,12))&
   +2D0*HfxZpE*VS1(27,23)
VS0(44,40)=QCy*VS0(44,24)+WQy*VS1(44,24)&
   +3D0*r1x2E*(VS0(44,13)-ZxZpE*VS1(44,13))&
   +2D0*HfxZpE*VS1(27,24)
VS0(44,41)=QCy*VS0(44,25)+WQy*VS1(44,25)&
   +4D0*r1x2E*(VS0(44,14)-ZxZpE*VS1(44,14))&
   +2D0*HfxZpE*VS1(27,25)
VS0(44,42)=QCx*VS0(44,26)+WQx*VS1(44,26)&
   +3D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +2D0*HfxZpE*VS1(28,26)
VS0(44,43)=QCx*VS0(44,27)+WQx*VS1(44,27)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(28,27)
VS0(44,44)=QCx*VS0(44,28)+WQx*VS1(44,28)&
   +r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(28,28)
VS0(44,45)=QCy*VS0(44,28)+WQy*VS1(44,28)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +2D0*HfxZpE*VS1(27,28)
VS0(44,46)=QCy*VS0(44,29)+WQy*VS1(44,29)&
   +3D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +2D0*HfxZpE*VS1(27,29)
VS0(44,47)=QCx*VS0(44,30)+WQx*VS1(44,30)&
   +2D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(28,30)
VS0(44,48)=QCx*VS0(44,31)+WQx*VS1(44,31)&
   +r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(28,31)
VS0(44,49)=QCy*VS0(44,31)+WQy*VS1(44,31)&
   +r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +2D0*HfxZpE*VS1(27,31)
VS0(44,50)=QCy*VS0(44,32)+WQy*VS1(44,32)&
   +2D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +2D0*HfxZpE*VS1(27,32)
VS0(44,51)=QCz*VS0(44,30)+WQz*VS1(44,30)-r1x2E*VR1(44,30)&
   +2D0*r1x2E*(VS0(44,15)-ZxZpE*VS1(44,15))&
   +HfxZpE*VS1(23,30)
VS0(44,52)=QCz*VS0(44,31)+WQz*VS1(44,31)-r1x2E*VR1(44,31)&
   +2D0*r1x2E*(VS0(44,16)-ZxZpE*VS1(44,16))&
   +HfxZpE*VS1(23,31)
VS0(44,53)=QCz*VS0(44,32)+WQz*VS1(44,32)-r1x2E*VR1(44,32)&
   +2D0*r1x2E*(VS0(44,17)-ZxZpE*VS1(44,17))&
   +HfxZpE*VS1(23,32)
VS0(44,54)=QCz*VS0(44,33)+WQz*VS1(44,33)-r1x2E*VR1(44,33)&
   +3D0*r1x2E*(VS0(44,18)-ZxZpE*VS1(44,18))&
   +HfxZpE*VS1(23,33)
VS0(44,55)=QCz*VS0(44,34)+WQz*VS1(44,34)-r1x2E*VR1(44,34)&
   +3D0*r1x2E*(VS0(44,19)-ZxZpE*VS1(44,19))&
   +HfxZpE*VS1(23,34)
VS0(44,56)=QCz*VS0(44,35)+WQz*VS1(44,35)-r1x2E*VR1(44,35)&
   +4D0*r1x2E*(VS0(44,20)-ZxZpE*VS1(44,20))&
   +HfxZpE*VS1(23,35)
VS0(45,36)=QCx*VS0(45,21)+WQx*VS1(45,21)&
   +4D0*r1x2E*(VS0(45,11)-ZxZpE*VS1(45,11))&
   +HfxZpE*VS1(29,21)
VS0(45,37)=QCx*VS0(45,22)+WQx*VS1(45,22)&
   +3D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +HfxZpE*VS1(29,22)
VS0(45,38)=QCx*VS0(45,23)+WQx*VS1(45,23)&
   +2D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +HfxZpE*VS1(29,23)
VS0(45,39)=QCy*VS0(45,23)+WQy*VS1(45,23)&
   +2D0*r1x2E*(VS0(45,12)-ZxZpE*VS1(45,12))&
   +3D0*HfxZpE*VS1(28,23)
VS0(45,40)=QCy*VS0(45,24)+WQy*VS1(45,24)&
   +3D0*r1x2E*(VS0(45,13)-ZxZpE*VS1(45,13))&
   +3D0*HfxZpE*VS1(28,24)
VS0(45,41)=QCy*VS0(45,25)+WQy*VS1(45,25)&
   +4D0*r1x2E*(VS0(45,14)-ZxZpE*VS1(45,14))&
   +3D0*HfxZpE*VS1(28,25)
VS0(45,42)=QCx*VS0(45,26)+WQx*VS1(45,26)&
   +3D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(29,26)
VS0(45,43)=QCx*VS0(45,27)+WQx*VS1(45,27)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(29,27)
VS0(45,44)=QCx*VS0(45,28)+WQx*VS1(45,28)&
   +r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(29,28)
VS0(45,45)=QCy*VS0(45,28)+WQy*VS1(45,28)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +3D0*HfxZpE*VS1(28,28)
VS0(45,46)=QCy*VS0(45,29)+WQy*VS1(45,29)&
   +3D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +3D0*HfxZpE*VS1(28,29)
VS0(45,47)=QCx*VS0(45,30)+WQx*VS1(45,30)&
   +2D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(29,30)
VS0(45,48)=QCx*VS0(45,31)+WQx*VS1(45,31)&
   +r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(29,31)
VS0(45,49)=QCy*VS0(45,31)+WQy*VS1(45,31)&
   +r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +3D0*HfxZpE*VS1(28,31)
VS0(45,50)=QCy*VS0(45,32)+WQy*VS1(45,32)&
   +2D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +3D0*HfxZpE*VS1(28,32)
VS0(45,51)=QCz*VS0(45,30)+WQz*VS1(45,30)-r1x2E*VR1(45,30)&
   +2D0*r1x2E*(VS0(45,15)-ZxZpE*VS1(45,15))&
   +HfxZpE*VS1(24,30)
VS0(45,52)=QCz*VS0(45,31)+WQz*VS1(45,31)-r1x2E*VR1(45,31)&
   +2D0*r1x2E*(VS0(45,16)-ZxZpE*VS1(45,16))&
   +HfxZpE*VS1(24,31)
VS0(45,53)=QCz*VS0(45,32)+WQz*VS1(45,32)-r1x2E*VR1(45,32)&
   +2D0*r1x2E*(VS0(45,17)-ZxZpE*VS1(45,17))&
   +HfxZpE*VS1(24,32)
VS0(45,54)=QCz*VS0(45,33)+WQz*VS1(45,33)-r1x2E*VR1(45,33)&
   +3D0*r1x2E*(VS0(45,18)-ZxZpE*VS1(45,18))&
   +HfxZpE*VS1(24,33)
VS0(45,55)=QCz*VS0(45,34)+WQz*VS1(45,34)-r1x2E*VR1(45,34)&
   +3D0*r1x2E*(VS0(45,19)-ZxZpE*VS1(45,19))&
   +HfxZpE*VS1(24,34)
VS0(45,56)=QCz*VS0(45,35)+WQz*VS1(45,35)-r1x2E*VR1(45,35)&
   +4D0*r1x2E*(VS0(45,20)-ZxZpE*VS1(45,20))&
   +HfxZpE*VS1(24,35)
VS0(46,36)=QCx*VS0(46,21)+WQx*VS1(46,21)&
   +4D0*r1x2E*(VS0(46,11)-ZxZpE*VS1(46,11))
VS0(46,37)=QCx*VS0(46,22)+WQx*VS1(46,22)&
   +3D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))
VS0(46,38)=QCx*VS0(46,23)+WQx*VS1(46,23)&
   +2D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))
VS0(46,39)=QCy*VS0(46,23)+WQy*VS1(46,23)&
   +2D0*r1x2E*(VS0(46,12)-ZxZpE*VS1(46,12))&
   +4D0*HfxZpE*VS1(29,23)
VS0(46,40)=QCy*VS0(46,24)+WQy*VS1(46,24)&
   +3D0*r1x2E*(VS0(46,13)-ZxZpE*VS1(46,13))&
   +4D0*HfxZpE*VS1(29,24)
VS0(46,41)=QCy*VS0(46,25)+WQy*VS1(46,25)&
   +4D0*r1x2E*(VS0(46,14)-ZxZpE*VS1(46,14))&
   +4D0*HfxZpE*VS1(29,25)
VS0(46,42)=QCx*VS0(46,26)+WQx*VS1(46,26)&
   +3D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))
VS0(46,43)=QCx*VS0(46,27)+WQx*VS1(46,27)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))
VS0(46,44)=QCx*VS0(46,28)+WQx*VS1(46,28)&
   +r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))
VS0(46,45)=QCy*VS0(46,28)+WQy*VS1(46,28)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +4D0*HfxZpE*VS1(29,28)
VS0(46,46)=QCy*VS0(46,29)+WQy*VS1(46,29)&
   +3D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +4D0*HfxZpE*VS1(29,29)
VS0(46,47)=QCx*VS0(46,30)+WQx*VS1(46,30)&
   +2D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))
VS0(46,48)=QCx*VS0(46,31)+WQx*VS1(46,31)&
   +r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))
VS0(46,49)=QCy*VS0(46,31)+WQy*VS1(46,31)&
   +r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +4D0*HfxZpE*VS1(29,31)
VS0(46,50)=QCy*VS0(46,32)+WQy*VS1(46,32)&
   +2D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +4D0*HfxZpE*VS1(29,32)
VS0(46,51)=QCz*VS0(46,30)+WQz*VS1(46,30)-r1x2E*VR1(46,30)&
   +2D0*r1x2E*(VS0(46,15)-ZxZpE*VS1(46,15))&
   +HfxZpE*VS1(25,30)
VS0(46,52)=QCz*VS0(46,31)+WQz*VS1(46,31)-r1x2E*VR1(46,31)&
   +2D0*r1x2E*(VS0(46,16)-ZxZpE*VS1(46,16))&
   +HfxZpE*VS1(25,31)
VS0(46,53)=QCz*VS0(46,32)+WQz*VS1(46,32)-r1x2E*VR1(46,32)&
   +2D0*r1x2E*(VS0(46,17)-ZxZpE*VS1(46,17))&
   +HfxZpE*VS1(25,32)
VS0(46,54)=QCz*VS0(46,33)+WQz*VS1(46,33)-r1x2E*VR1(46,33)&
   +3D0*r1x2E*(VS0(46,18)-ZxZpE*VS1(46,18))&
   +HfxZpE*VS1(25,33)
VS0(46,55)=QCz*VS0(46,34)+WQz*VS1(46,34)-r1x2E*VR1(46,34)&
   +3D0*r1x2E*(VS0(46,19)-ZxZpE*VS1(46,19))&
   +HfxZpE*VS1(25,34)
VS0(46,56)=QCz*VS0(46,35)+WQz*VS1(46,35)-r1x2E*VR1(46,35)&
   +4D0*r1x2E*(VS0(46,20)-ZxZpE*VS1(46,20))&
   +HfxZpE*VS1(25,35)
VS0(47,36)=QCx*VS0(47,21)+WQx*VS1(47,21)&
   +4D0*r1x2E*(VS0(47,11)-ZxZpE*VS1(47,11))&
   +3D0*HfxZpE*VS1(30,21)
VS0(47,37)=QCx*VS0(47,22)+WQx*VS1(47,22)&
   +3D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))&
   +3D0*HfxZpE*VS1(30,22)
VS0(47,38)=QCx*VS0(47,23)+WQx*VS1(47,23)&
   +2D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))&
   +3D0*HfxZpE*VS1(30,23)
VS0(47,39)=QCy*VS0(47,23)+WQy*VS1(47,23)&
   +2D0*r1x2E*(VS0(47,12)-ZxZpE*VS1(47,12))
VS0(47,40)=QCy*VS0(47,24)+WQy*VS1(47,24)&
   +3D0*r1x2E*(VS0(47,13)-ZxZpE*VS1(47,13))
VS0(47,41)=QCy*VS0(47,25)+WQy*VS1(47,25)&
   +4D0*r1x2E*(VS0(47,14)-ZxZpE*VS1(47,14))
VS0(47,42)=QCx*VS0(47,26)+WQx*VS1(47,26)&
   +3D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +3D0*HfxZpE*VS1(30,26)
VS0(47,43)=QCx*VS0(47,27)+WQx*VS1(47,27)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +3D0*HfxZpE*VS1(30,27)
VS0(47,44)=QCx*VS0(47,28)+WQx*VS1(47,28)&
   +r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +3D0*HfxZpE*VS1(30,28)
VS0(47,45)=QCy*VS0(47,28)+WQy*VS1(47,28)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))
VS0(47,46)=QCy*VS0(47,29)+WQy*VS1(47,29)&
   +3D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))
VS0(47,47)=QCx*VS0(47,30)+WQx*VS1(47,30)&
   +2D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +3D0*HfxZpE*VS1(30,30)
VS0(47,48)=QCx*VS0(47,31)+WQx*VS1(47,31)&
   +r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +3D0*HfxZpE*VS1(30,31)
VS0(47,49)=QCy*VS0(47,31)+WQy*VS1(47,31)&
   +r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))
VS0(47,50)=QCy*VS0(47,32)+WQy*VS1(47,32)&
   +2D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))
VS0(47,51)=QCz*VS0(47,30)+WQz*VS1(47,30)-r1x2E*VR1(47,30)&
   +2D0*r1x2E*(VS0(47,15)-ZxZpE*VS1(47,15))&
   +2D0*HfxZpE*VS1(26,30)
VS0(47,52)=QCz*VS0(47,31)+WQz*VS1(47,31)-r1x2E*VR1(47,31)&
   +2D0*r1x2E*(VS0(47,16)-ZxZpE*VS1(47,16))&
   +2D0*HfxZpE*VS1(26,31)
VS0(47,53)=QCz*VS0(47,32)+WQz*VS1(47,32)-r1x2E*VR1(47,32)&
   +2D0*r1x2E*(VS0(47,17)-ZxZpE*VS1(47,17))&
   +2D0*HfxZpE*VS1(26,32)
VS0(47,54)=QCz*VS0(47,33)+WQz*VS1(47,33)-r1x2E*VR1(47,33)&
   +3D0*r1x2E*(VS0(47,18)-ZxZpE*VS1(47,18))&
   +2D0*HfxZpE*VS1(26,33)
VS0(47,55)=QCz*VS0(47,34)+WQz*VS1(47,34)-r1x2E*VR1(47,34)&
   +3D0*r1x2E*(VS0(47,19)-ZxZpE*VS1(47,19))&
   +2D0*HfxZpE*VS1(26,34)
VS0(47,56)=QCz*VS0(47,35)+WQz*VS1(47,35)-r1x2E*VR1(47,35)&
   +4D0*r1x2E*(VS0(47,20)-ZxZpE*VS1(47,20))&
   +2D0*HfxZpE*VS1(26,35)
VS0(48,36)=QCx*VS0(48,21)+WQx*VS1(48,21)&
   +4D0*r1x2E*(VS0(48,11)-ZxZpE*VS1(48,11))&
   +2D0*HfxZpE*VS1(31,21)
VS0(48,37)=QCx*VS0(48,22)+WQx*VS1(48,22)&
   +3D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +2D0*HfxZpE*VS1(31,22)
VS0(48,38)=QCx*VS0(48,23)+WQx*VS1(48,23)&
   +2D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +2D0*HfxZpE*VS1(31,23)
VS0(48,39)=QCy*VS0(48,23)+WQy*VS1(48,23)&
   +2D0*r1x2E*(VS0(48,12)-ZxZpE*VS1(48,12))&
   +HfxZpE*VS1(30,23)
VS0(48,40)=QCy*VS0(48,24)+WQy*VS1(48,24)&
   +3D0*r1x2E*(VS0(48,13)-ZxZpE*VS1(48,13))&
   +HfxZpE*VS1(30,24)
VS0(48,41)=QCy*VS0(48,25)+WQy*VS1(48,25)&
   +4D0*r1x2E*(VS0(48,14)-ZxZpE*VS1(48,14))&
   +HfxZpE*VS1(30,25)
VS0(48,42)=QCx*VS0(48,26)+WQx*VS1(48,26)&
   +3D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(31,26)
VS0(48,43)=QCx*VS0(48,27)+WQx*VS1(48,27)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(31,27)
VS0(48,44)=QCx*VS0(48,28)+WQx*VS1(48,28)&
   +r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(31,28)
VS0(48,45)=QCy*VS0(48,28)+WQy*VS1(48,28)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +HfxZpE*VS1(30,28)
VS0(48,46)=QCy*VS0(48,29)+WQy*VS1(48,29)&
   +3D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +HfxZpE*VS1(30,29)
VS0(48,47)=QCx*VS0(48,30)+WQx*VS1(48,30)&
   +2D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(31,30)
VS0(48,48)=QCx*VS0(48,31)+WQx*VS1(48,31)&
   +r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(31,31)
VS0(48,49)=QCy*VS0(48,31)+WQy*VS1(48,31)&
   +r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +HfxZpE*VS1(30,31)
VS0(48,50)=QCy*VS0(48,32)+WQy*VS1(48,32)&
   +2D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +HfxZpE*VS1(30,32)
VS0(48,51)=QCz*VS0(48,30)+WQz*VS1(48,30)-r1x2E*VR1(48,30)&
   +2D0*r1x2E*(VS0(48,15)-ZxZpE*VS1(48,15))&
   +2D0*HfxZpE*VS1(27,30)
VS0(48,52)=QCz*VS0(48,31)+WQz*VS1(48,31)-r1x2E*VR1(48,31)&
   +2D0*r1x2E*(VS0(48,16)-ZxZpE*VS1(48,16))&
   +2D0*HfxZpE*VS1(27,31)
VS0(48,53)=QCz*VS0(48,32)+WQz*VS1(48,32)-r1x2E*VR1(48,32)&
   +2D0*r1x2E*(VS0(48,17)-ZxZpE*VS1(48,17))&
   +2D0*HfxZpE*VS1(27,32)
VS0(48,54)=QCz*VS0(48,33)+WQz*VS1(48,33)-r1x2E*VR1(48,33)&
   +3D0*r1x2E*(VS0(48,18)-ZxZpE*VS1(48,18))&
   +2D0*HfxZpE*VS1(27,33)
VS0(48,55)=QCz*VS0(48,34)+WQz*VS1(48,34)-r1x2E*VR1(48,34)&
   +3D0*r1x2E*(VS0(48,19)-ZxZpE*VS1(48,19))&
   +2D0*HfxZpE*VS1(27,34)
VS0(48,56)=QCz*VS0(48,35)+WQz*VS1(48,35)-r1x2E*VR1(48,35)&
   +4D0*r1x2E*(VS0(48,20)-ZxZpE*VS1(48,20))&
   +2D0*HfxZpE*VS1(27,35)
VS0(49,36)=QCx*VS0(49,21)+WQx*VS1(49,21)&
   +4D0*r1x2E*(VS0(49,11)-ZxZpE*VS1(49,11))&
   +HfxZpE*VS1(32,21)
VS0(49,37)=QCx*VS0(49,22)+WQx*VS1(49,22)&
   +3D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +HfxZpE*VS1(32,22)
VS0(49,38)=QCx*VS0(49,23)+WQx*VS1(49,23)&
   +2D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +HfxZpE*VS1(32,23)
VS0(49,39)=QCy*VS0(49,23)+WQy*VS1(49,23)&
   +2D0*r1x2E*(VS0(49,12)-ZxZpE*VS1(49,12))&
   +2D0*HfxZpE*VS1(31,23)
VS0(49,40)=QCy*VS0(49,24)+WQy*VS1(49,24)&
   +3D0*r1x2E*(VS0(49,13)-ZxZpE*VS1(49,13))&
   +2D0*HfxZpE*VS1(31,24)
VS0(49,41)=QCy*VS0(49,25)+WQy*VS1(49,25)&
   +4D0*r1x2E*(VS0(49,14)-ZxZpE*VS1(49,14))&
   +2D0*HfxZpE*VS1(31,25)
VS0(49,42)=QCx*VS0(49,26)+WQx*VS1(49,26)&
   +3D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +HfxZpE*VS1(32,26)
VS0(49,43)=QCx*VS0(49,27)+WQx*VS1(49,27)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +HfxZpE*VS1(32,27)
VS0(49,44)=QCx*VS0(49,28)+WQx*VS1(49,28)&
   +r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +HfxZpE*VS1(32,28)
VS0(49,45)=QCy*VS0(49,28)+WQy*VS1(49,28)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(31,28)
VS0(49,46)=QCy*VS0(49,29)+WQy*VS1(49,29)&
   +3D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(31,29)
VS0(49,47)=QCx*VS0(49,30)+WQx*VS1(49,30)&
   +2D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +HfxZpE*VS1(32,30)
VS0(49,48)=QCx*VS0(49,31)+WQx*VS1(49,31)&
   +r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +HfxZpE*VS1(32,31)
VS0(49,49)=QCy*VS0(49,31)+WQy*VS1(49,31)&
   +r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(31,31)
VS0(49,50)=QCy*VS0(49,32)+WQy*VS1(49,32)&
   +2D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(31,32)
VS0(49,51)=QCz*VS0(49,30)+WQz*VS1(49,30)-r1x2E*VR1(49,30)&
   +2D0*r1x2E*(VS0(49,15)-ZxZpE*VS1(49,15))&
   +2D0*HfxZpE*VS1(28,30)
VS0(49,52)=QCz*VS0(49,31)+WQz*VS1(49,31)-r1x2E*VR1(49,31)&
   +2D0*r1x2E*(VS0(49,16)-ZxZpE*VS1(49,16))&
   +2D0*HfxZpE*VS1(28,31)
VS0(49,53)=QCz*VS0(49,32)+WQz*VS1(49,32)-r1x2E*VR1(49,32)&
   +2D0*r1x2E*(VS0(49,17)-ZxZpE*VS1(49,17))&
   +2D0*HfxZpE*VS1(28,32)
VS0(49,54)=QCz*VS0(49,33)+WQz*VS1(49,33)-r1x2E*VR1(49,33)&
   +3D0*r1x2E*(VS0(49,18)-ZxZpE*VS1(49,18))&
   +2D0*HfxZpE*VS1(28,33)
VS0(49,55)=QCz*VS0(49,34)+WQz*VS1(49,34)-r1x2E*VR1(49,34)&
   +3D0*r1x2E*(VS0(49,19)-ZxZpE*VS1(49,19))&
   +2D0*HfxZpE*VS1(28,34)
VS0(49,56)=QCz*VS0(49,35)+WQz*VS1(49,35)-r1x2E*VR1(49,35)&
   +4D0*r1x2E*(VS0(49,20)-ZxZpE*VS1(49,20))&
   +2D0*HfxZpE*VS1(28,35)
VS0(50,36)=QCx*VS0(50,21)+WQx*VS1(50,21)&
   +4D0*r1x2E*(VS0(50,11)-ZxZpE*VS1(50,11))
VS0(50,37)=QCx*VS0(50,22)+WQx*VS1(50,22)&
   +3D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))
VS0(50,38)=QCx*VS0(50,23)+WQx*VS1(50,23)&
   +2D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))
VS0(50,39)=QCy*VS0(50,23)+WQy*VS1(50,23)&
   +2D0*r1x2E*(VS0(50,12)-ZxZpE*VS1(50,12))&
   +3D0*HfxZpE*VS1(32,23)
VS0(50,40)=QCy*VS0(50,24)+WQy*VS1(50,24)&
   +3D0*r1x2E*(VS0(50,13)-ZxZpE*VS1(50,13))&
   +3D0*HfxZpE*VS1(32,24)
VS0(50,41)=QCy*VS0(50,25)+WQy*VS1(50,25)&
   +4D0*r1x2E*(VS0(50,14)-ZxZpE*VS1(50,14))&
   +3D0*HfxZpE*VS1(32,25)
VS0(50,42)=QCx*VS0(50,26)+WQx*VS1(50,26)&
   +3D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))
VS0(50,43)=QCx*VS0(50,27)+WQx*VS1(50,27)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))
VS0(50,44)=QCx*VS0(50,28)+WQx*VS1(50,28)&
   +r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))
VS0(50,45)=QCy*VS0(50,28)+WQy*VS1(50,28)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +3D0*HfxZpE*VS1(32,28)
VS0(50,46)=QCy*VS0(50,29)+WQy*VS1(50,29)&
   +3D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +3D0*HfxZpE*VS1(32,29)
VS0(50,47)=QCx*VS0(50,30)+WQx*VS1(50,30)&
   +2D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))
VS0(50,48)=QCx*VS0(50,31)+WQx*VS1(50,31)&
   +r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))
VS0(50,49)=QCy*VS0(50,31)+WQy*VS1(50,31)&
   +r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +3D0*HfxZpE*VS1(32,31)
VS0(50,50)=QCy*VS0(50,32)+WQy*VS1(50,32)&
   +2D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +3D0*HfxZpE*VS1(32,32)
VS0(50,51)=QCz*VS0(50,30)+WQz*VS1(50,30)-r1x2E*VR1(50,30)&
   +2D0*r1x2E*(VS0(50,15)-ZxZpE*VS1(50,15))&
   +2D0*HfxZpE*VS1(29,30)
VS0(50,52)=QCz*VS0(50,31)+WQz*VS1(50,31)-r1x2E*VR1(50,31)&
   +2D0*r1x2E*(VS0(50,16)-ZxZpE*VS1(50,16))&
   +2D0*HfxZpE*VS1(29,31)
VS0(50,53)=QCz*VS0(50,32)+WQz*VS1(50,32)-r1x2E*VR1(50,32)&
   +2D0*r1x2E*(VS0(50,17)-ZxZpE*VS1(50,17))&
   +2D0*HfxZpE*VS1(29,32)
VS0(50,54)=QCz*VS0(50,33)+WQz*VS1(50,33)-r1x2E*VR1(50,33)&
   +3D0*r1x2E*(VS0(50,18)-ZxZpE*VS1(50,18))&
   +2D0*HfxZpE*VS1(29,33)
VS0(50,55)=QCz*VS0(50,34)+WQz*VS1(50,34)-r1x2E*VR1(50,34)&
   +3D0*r1x2E*(VS0(50,19)-ZxZpE*VS1(50,19))&
   +2D0*HfxZpE*VS1(29,34)
VS0(50,56)=QCz*VS0(50,35)+WQz*VS1(50,35)-r1x2E*VR1(50,35)&
   +4D0*r1x2E*(VS0(50,20)-ZxZpE*VS1(50,20))&
   +2D0*HfxZpE*VS1(29,35)
VS0(51,36)=QCx*VS0(51,21)+WQx*VS1(51,21)&
   +4D0*r1x2E*(VS0(51,11)-ZxZpE*VS1(51,11))&
   +2D0*HfxZpE*VS1(33,21)
VS0(51,37)=QCx*VS0(51,22)+WQx*VS1(51,22)&
   +3D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))&
   +2D0*HfxZpE*VS1(33,22)
VS0(51,38)=QCx*VS0(51,23)+WQx*VS1(51,23)&
   +2D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))&
   +2D0*HfxZpE*VS1(33,23)
VS0(51,39)=QCy*VS0(51,23)+WQy*VS1(51,23)&
   +2D0*r1x2E*(VS0(51,12)-ZxZpE*VS1(51,12))
VS0(51,40)=QCy*VS0(51,24)+WQy*VS1(51,24)&
   +3D0*r1x2E*(VS0(51,13)-ZxZpE*VS1(51,13))
VS0(51,41)=QCy*VS0(51,25)+WQy*VS1(51,25)&
   +4D0*r1x2E*(VS0(51,14)-ZxZpE*VS1(51,14))
VS0(51,42)=QCx*VS0(51,26)+WQx*VS1(51,26)&
   +3D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +2D0*HfxZpE*VS1(33,26)
VS0(51,43)=QCx*VS0(51,27)+WQx*VS1(51,27)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +2D0*HfxZpE*VS1(33,27)
VS0(51,44)=QCx*VS0(51,28)+WQx*VS1(51,28)&
   +r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +2D0*HfxZpE*VS1(33,28)
VS0(51,45)=QCy*VS0(51,28)+WQy*VS1(51,28)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))
VS0(51,46)=QCy*VS0(51,29)+WQy*VS1(51,29)&
   +3D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))
VS0(51,47)=QCx*VS0(51,30)+WQx*VS1(51,30)&
   +2D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +2D0*HfxZpE*VS1(33,30)
VS0(51,48)=QCx*VS0(51,31)+WQx*VS1(51,31)&
   +r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +2D0*HfxZpE*VS1(33,31)
VS0(51,49)=QCy*VS0(51,31)+WQy*VS1(51,31)&
   +r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))
VS0(51,50)=QCy*VS0(51,32)+WQy*VS1(51,32)&
   +2D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))
VS0(51,51)=QCz*VS0(51,30)+WQz*VS1(51,30)-r1x2E*VR1(51,30)&
   +2D0*r1x2E*(VS0(51,15)-ZxZpE*VS1(51,15))&
   +3D0*HfxZpE*VS1(30,30)
VS0(51,52)=QCz*VS0(51,31)+WQz*VS1(51,31)-r1x2E*VR1(51,31)&
   +2D0*r1x2E*(VS0(51,16)-ZxZpE*VS1(51,16))&
   +3D0*HfxZpE*VS1(30,31)
VS0(51,53)=QCz*VS0(51,32)+WQz*VS1(51,32)-r1x2E*VR1(51,32)&
   +2D0*r1x2E*(VS0(51,17)-ZxZpE*VS1(51,17))&
   +3D0*HfxZpE*VS1(30,32)
VS0(51,54)=QCz*VS0(51,33)+WQz*VS1(51,33)-r1x2E*VR1(51,33)&
   +3D0*r1x2E*(VS0(51,18)-ZxZpE*VS1(51,18))&
   +3D0*HfxZpE*VS1(30,33)
VS0(51,55)=QCz*VS0(51,34)+WQz*VS1(51,34)-r1x2E*VR1(51,34)&
   +3D0*r1x2E*(VS0(51,19)-ZxZpE*VS1(51,19))&
   +3D0*HfxZpE*VS1(30,34)
VS0(51,56)=QCz*VS0(51,35)+WQz*VS1(51,35)-r1x2E*VR1(51,35)&
   +4D0*r1x2E*(VS0(51,20)-ZxZpE*VS1(51,20))&
   +3D0*HfxZpE*VS1(30,35)
VS0(52,36)=QCx*VS0(52,21)+WQx*VS1(52,21)&
   +4D0*r1x2E*(VS0(52,11)-ZxZpE*VS1(52,11))&
   +HfxZpE*VS1(34,21)
VS0(52,37)=QCx*VS0(52,22)+WQx*VS1(52,22)&
   +3D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(34,22)
VS0(52,38)=QCx*VS0(52,23)+WQx*VS1(52,23)&
   +2D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(34,23)
VS0(52,39)=QCy*VS0(52,23)+WQy*VS1(52,23)&
   +2D0*r1x2E*(VS0(52,12)-ZxZpE*VS1(52,12))&
   +HfxZpE*VS1(33,23)
VS0(52,40)=QCy*VS0(52,24)+WQy*VS1(52,24)&
   +3D0*r1x2E*(VS0(52,13)-ZxZpE*VS1(52,13))&
   +HfxZpE*VS1(33,24)
VS0(52,41)=QCy*VS0(52,25)+WQy*VS1(52,25)&
   +4D0*r1x2E*(VS0(52,14)-ZxZpE*VS1(52,14))&
   +HfxZpE*VS1(33,25)
VS0(52,42)=QCx*VS0(52,26)+WQx*VS1(52,26)&
   +3D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +HfxZpE*VS1(34,26)
VS0(52,43)=QCx*VS0(52,27)+WQx*VS1(52,27)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(34,27)
VS0(52,44)=QCx*VS0(52,28)+WQx*VS1(52,28)&
   +r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(34,28)
VS0(52,45)=QCy*VS0(52,28)+WQy*VS1(52,28)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +HfxZpE*VS1(33,28)
VS0(52,46)=QCy*VS0(52,29)+WQy*VS1(52,29)&
   +3D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +HfxZpE*VS1(33,29)
VS0(52,47)=QCx*VS0(52,30)+WQx*VS1(52,30)&
   +2D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(34,30)
VS0(52,48)=QCx*VS0(52,31)+WQx*VS1(52,31)&
   +r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(34,31)
VS0(52,49)=QCy*VS0(52,31)+WQy*VS1(52,31)&
   +r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +HfxZpE*VS1(33,31)
VS0(52,50)=QCy*VS0(52,32)+WQy*VS1(52,32)&
   +2D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +HfxZpE*VS1(33,32)
VS0(52,51)=QCz*VS0(52,30)+WQz*VS1(52,30)-r1x2E*VR1(52,30)&
   +2D0*r1x2E*(VS0(52,15)-ZxZpE*VS1(52,15))&
   +3D0*HfxZpE*VS1(31,30)
VS0(52,52)=QCz*VS0(52,31)+WQz*VS1(52,31)-r1x2E*VR1(52,31)&
   +2D0*r1x2E*(VS0(52,16)-ZxZpE*VS1(52,16))&
   +3D0*HfxZpE*VS1(31,31)
VS0(52,53)=QCz*VS0(52,32)+WQz*VS1(52,32)-r1x2E*VR1(52,32)&
   +2D0*r1x2E*(VS0(52,17)-ZxZpE*VS1(52,17))&
   +3D0*HfxZpE*VS1(31,32)
VS0(52,54)=QCz*VS0(52,33)+WQz*VS1(52,33)-r1x2E*VR1(52,33)&
   +3D0*r1x2E*(VS0(52,18)-ZxZpE*VS1(52,18))&
   +3D0*HfxZpE*VS1(31,33)
VS0(52,55)=QCz*VS0(52,34)+WQz*VS1(52,34)-r1x2E*VR1(52,34)&
   +3D0*r1x2E*(VS0(52,19)-ZxZpE*VS1(52,19))&
   +3D0*HfxZpE*VS1(31,34)
VS0(52,56)=QCz*VS0(52,35)+WQz*VS1(52,35)-r1x2E*VR1(52,35)&
   +4D0*r1x2E*(VS0(52,20)-ZxZpE*VS1(52,20))&
   +3D0*HfxZpE*VS1(31,35)
VS0(53,36)=QCx*VS0(53,21)+WQx*VS1(53,21)&
   +4D0*r1x2E*(VS0(53,11)-ZxZpE*VS1(53,11))
VS0(53,37)=QCx*VS0(53,22)+WQx*VS1(53,22)&
   +3D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))
VS0(53,38)=QCx*VS0(53,23)+WQx*VS1(53,23)&
   +2D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))
VS0(53,39)=QCy*VS0(53,23)+WQy*VS1(53,23)&
   +2D0*r1x2E*(VS0(53,12)-ZxZpE*VS1(53,12))&
   +2D0*HfxZpE*VS1(34,23)
VS0(53,40)=QCy*VS0(53,24)+WQy*VS1(53,24)&
   +3D0*r1x2E*(VS0(53,13)-ZxZpE*VS1(53,13))&
   +2D0*HfxZpE*VS1(34,24)
VS0(53,41)=QCy*VS0(53,25)+WQy*VS1(53,25)&
   +4D0*r1x2E*(VS0(53,14)-ZxZpE*VS1(53,14))&
   +2D0*HfxZpE*VS1(34,25)
VS0(53,42)=QCx*VS0(53,26)+WQx*VS1(53,26)&
   +3D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))
VS0(53,43)=QCx*VS0(53,27)+WQx*VS1(53,27)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))
VS0(53,44)=QCx*VS0(53,28)+WQx*VS1(53,28)&
   +r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))
VS0(53,45)=QCy*VS0(53,28)+WQy*VS1(53,28)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +2D0*HfxZpE*VS1(34,28)
VS0(53,46)=QCy*VS0(53,29)+WQy*VS1(53,29)&
   +3D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +2D0*HfxZpE*VS1(34,29)
VS0(53,47)=QCx*VS0(53,30)+WQx*VS1(53,30)&
   +2D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))
VS0(53,48)=QCx*VS0(53,31)+WQx*VS1(53,31)&
   +r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))
VS0(53,49)=QCy*VS0(53,31)+WQy*VS1(53,31)&
   +r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +2D0*HfxZpE*VS1(34,31)
VS0(53,50)=QCy*VS0(53,32)+WQy*VS1(53,32)&
   +2D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +2D0*HfxZpE*VS1(34,32)
VS0(53,51)=QCz*VS0(53,30)+WQz*VS1(53,30)-r1x2E*VR1(53,30)&
   +2D0*r1x2E*(VS0(53,15)-ZxZpE*VS1(53,15))&
   +3D0*HfxZpE*VS1(32,30)
VS0(53,52)=QCz*VS0(53,31)+WQz*VS1(53,31)-r1x2E*VR1(53,31)&
   +2D0*r1x2E*(VS0(53,16)-ZxZpE*VS1(53,16))&
   +3D0*HfxZpE*VS1(32,31)
VS0(53,53)=QCz*VS0(53,32)+WQz*VS1(53,32)-r1x2E*VR1(53,32)&
   +2D0*r1x2E*(VS0(53,17)-ZxZpE*VS1(53,17))&
   +3D0*HfxZpE*VS1(32,32)
VS0(53,54)=QCz*VS0(53,33)+WQz*VS1(53,33)-r1x2E*VR1(53,33)&
   +3D0*r1x2E*(VS0(53,18)-ZxZpE*VS1(53,18))&
   +3D0*HfxZpE*VS1(32,33)
VS0(53,55)=QCz*VS0(53,34)+WQz*VS1(53,34)-r1x2E*VR1(53,34)&
   +3D0*r1x2E*(VS0(53,19)-ZxZpE*VS1(53,19))&
   +3D0*HfxZpE*VS1(32,34)
VS0(53,56)=QCz*VS0(53,35)+WQz*VS1(53,35)-r1x2E*VR1(53,35)&
   +4D0*r1x2E*(VS0(53,20)-ZxZpE*VS1(53,20))&
   +3D0*HfxZpE*VS1(32,35)
VS0(54,36)=QCx*VS0(54,21)+WQx*VS1(54,21)&
   +4D0*r1x2E*(VS0(54,11)-ZxZpE*VS1(54,11))&
   +HfxZpE*VS1(35,21)
VS0(54,37)=QCx*VS0(54,22)+WQx*VS1(54,22)&
   +3D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))&
   +HfxZpE*VS1(35,22)
VS0(54,38)=QCx*VS0(54,23)+WQx*VS1(54,23)&
   +2D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))&
   +HfxZpE*VS1(35,23)
VS0(54,39)=QCy*VS0(54,23)+WQy*VS1(54,23)&
   +2D0*r1x2E*(VS0(54,12)-ZxZpE*VS1(54,12))
VS0(54,40)=QCy*VS0(54,24)+WQy*VS1(54,24)&
   +3D0*r1x2E*(VS0(54,13)-ZxZpE*VS1(54,13))
VS0(54,41)=QCy*VS0(54,25)+WQy*VS1(54,25)&
   +4D0*r1x2E*(VS0(54,14)-ZxZpE*VS1(54,14))
VS0(54,42)=QCx*VS0(54,26)+WQx*VS1(54,26)&
   +3D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +HfxZpE*VS1(35,26)
VS0(54,43)=QCx*VS0(54,27)+WQx*VS1(54,27)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +HfxZpE*VS1(35,27)
VS0(54,44)=QCx*VS0(54,28)+WQx*VS1(54,28)&
   +r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +HfxZpE*VS1(35,28)
VS0(54,45)=QCy*VS0(54,28)+WQy*VS1(54,28)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))
VS0(54,46)=QCy*VS0(54,29)+WQy*VS1(54,29)&
   +3D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))
VS0(54,47)=QCx*VS0(54,30)+WQx*VS1(54,30)&
   +2D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +HfxZpE*VS1(35,30)
VS0(54,48)=QCx*VS0(54,31)+WQx*VS1(54,31)&
   +r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +HfxZpE*VS1(35,31)
VS0(54,49)=QCy*VS0(54,31)+WQy*VS1(54,31)&
   +r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))
VS0(54,50)=QCy*VS0(54,32)+WQy*VS1(54,32)&
   +2D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))
VS0(54,51)=QCz*VS0(54,30)+WQz*VS1(54,30)-r1x2E*VR1(54,30)&
   +2D0*r1x2E*(VS0(54,15)-ZxZpE*VS1(54,15))&
   +4D0*HfxZpE*VS1(33,30)
VS0(54,52)=QCz*VS0(54,31)+WQz*VS1(54,31)-r1x2E*VR1(54,31)&
   +2D0*r1x2E*(VS0(54,16)-ZxZpE*VS1(54,16))&
   +4D0*HfxZpE*VS1(33,31)
VS0(54,53)=QCz*VS0(54,32)+WQz*VS1(54,32)-r1x2E*VR1(54,32)&
   +2D0*r1x2E*(VS0(54,17)-ZxZpE*VS1(54,17))&
   +4D0*HfxZpE*VS1(33,32)
VS0(54,54)=QCz*VS0(54,33)+WQz*VS1(54,33)-r1x2E*VR1(54,33)&
   +3D0*r1x2E*(VS0(54,18)-ZxZpE*VS1(54,18))&
   +4D0*HfxZpE*VS1(33,33)
VS0(54,55)=QCz*VS0(54,34)+WQz*VS1(54,34)-r1x2E*VR1(54,34)&
   +3D0*r1x2E*(VS0(54,19)-ZxZpE*VS1(54,19))&
   +4D0*HfxZpE*VS1(33,34)
VS0(54,56)=QCz*VS0(54,35)+WQz*VS1(54,35)-r1x2E*VR1(54,35)&
   +4D0*r1x2E*(VS0(54,20)-ZxZpE*VS1(54,20))&
   +4D0*HfxZpE*VS1(33,35)
VS0(55,36)=QCx*VS0(55,21)+WQx*VS1(55,21)&
   +4D0*r1x2E*(VS0(55,11)-ZxZpE*VS1(55,11))
VS0(55,37)=QCx*VS0(55,22)+WQx*VS1(55,22)&
   +3D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))
VS0(55,38)=QCx*VS0(55,23)+WQx*VS1(55,23)&
   +2D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))
VS0(55,39)=QCy*VS0(55,23)+WQy*VS1(55,23)&
   +2D0*r1x2E*(VS0(55,12)-ZxZpE*VS1(55,12))&
   +HfxZpE*VS1(35,23)
VS0(55,40)=QCy*VS0(55,24)+WQy*VS1(55,24)&
   +3D0*r1x2E*(VS0(55,13)-ZxZpE*VS1(55,13))&
   +HfxZpE*VS1(35,24)
VS0(55,41)=QCy*VS0(55,25)+WQy*VS1(55,25)&
   +4D0*r1x2E*(VS0(55,14)-ZxZpE*VS1(55,14))&
   +HfxZpE*VS1(35,25)
VS0(55,42)=QCx*VS0(55,26)+WQx*VS1(55,26)&
   +3D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))
VS0(55,43)=QCx*VS0(55,27)+WQx*VS1(55,27)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))
VS0(55,44)=QCx*VS0(55,28)+WQx*VS1(55,28)&
   +r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))
VS0(55,45)=QCy*VS0(55,28)+WQy*VS1(55,28)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +HfxZpE*VS1(35,28)
VS0(55,46)=QCy*VS0(55,29)+WQy*VS1(55,29)&
   +3D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +HfxZpE*VS1(35,29)
VS0(55,47)=QCx*VS0(55,30)+WQx*VS1(55,30)&
   +2D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))
VS0(55,48)=QCx*VS0(55,31)+WQx*VS1(55,31)&
   +r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))
VS0(55,49)=QCy*VS0(55,31)+WQy*VS1(55,31)&
   +r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +HfxZpE*VS1(35,31)
VS0(55,50)=QCy*VS0(55,32)+WQy*VS1(55,32)&
   +2D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +HfxZpE*VS1(35,32)
VS0(55,51)=QCz*VS0(55,30)+WQz*VS1(55,30)-r1x2E*VR1(55,30)&
   +2D0*r1x2E*(VS0(55,15)-ZxZpE*VS1(55,15))&
   +4D0*HfxZpE*VS1(34,30)
VS0(55,52)=QCz*VS0(55,31)+WQz*VS1(55,31)-r1x2E*VR1(55,31)&
   +2D0*r1x2E*(VS0(55,16)-ZxZpE*VS1(55,16))&
   +4D0*HfxZpE*VS1(34,31)
VS0(55,53)=QCz*VS0(55,32)+WQz*VS1(55,32)-r1x2E*VR1(55,32)&
   +2D0*r1x2E*(VS0(55,17)-ZxZpE*VS1(55,17))&
   +4D0*HfxZpE*VS1(34,32)
VS0(55,54)=QCz*VS0(55,33)+WQz*VS1(55,33)-r1x2E*VR1(55,33)&
   +3D0*r1x2E*(VS0(55,18)-ZxZpE*VS1(55,18))&
   +4D0*HfxZpE*VS1(34,33)
VS0(55,55)=QCz*VS0(55,34)+WQz*VS1(55,34)-r1x2E*VR1(55,34)&
   +3D0*r1x2E*(VS0(55,19)-ZxZpE*VS1(55,19))&
   +4D0*HfxZpE*VS1(34,34)
VS0(55,56)=QCz*VS0(55,35)+WQz*VS1(55,35)-r1x2E*VR1(55,35)&
   +4D0*r1x2E*(VS0(55,20)-ZxZpE*VS1(55,20))&
   +4D0*HfxZpE*VS1(34,35)
VS0(56,36)=QCx*VS0(56,21)+WQx*VS1(56,21)&
   +4D0*r1x2E*(VS0(56,11)-ZxZpE*VS1(56,11))
VS0(56,37)=QCx*VS0(56,22)+WQx*VS1(56,22)&
   +3D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,38)=QCx*VS0(56,23)+WQx*VS1(56,23)&
   +2D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,39)=QCy*VS0(56,23)+WQy*VS1(56,23)&
   +2D0*r1x2E*(VS0(56,12)-ZxZpE*VS1(56,12))
VS0(56,40)=QCy*VS0(56,24)+WQy*VS1(56,24)&
   +3D0*r1x2E*(VS0(56,13)-ZxZpE*VS1(56,13))
VS0(56,41)=QCy*VS0(56,25)+WQy*VS1(56,25)&
   +4D0*r1x2E*(VS0(56,14)-ZxZpE*VS1(56,14))
VS0(56,42)=QCx*VS0(56,26)+WQx*VS1(56,26)&
   +3D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))
VS0(56,43)=QCx*VS0(56,27)+WQx*VS1(56,27)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,44)=QCx*VS0(56,28)+WQx*VS1(56,28)&
   +r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,45)=QCy*VS0(56,28)+WQy*VS1(56,28)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))
VS0(56,46)=QCy*VS0(56,29)+WQy*VS1(56,29)&
   +3D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))
VS0(56,47)=QCx*VS0(56,30)+WQx*VS1(56,30)&
   +2D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,48)=QCx*VS0(56,31)+WQx*VS1(56,31)&
   +r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,49)=QCy*VS0(56,31)+WQy*VS1(56,31)&
   +r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))
VS0(56,50)=QCy*VS0(56,32)+WQy*VS1(56,32)&
   +2D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))
VS0(56,51)=QCz*VS0(56,30)+WQz*VS1(56,30)-r1x2E*VR1(56,30)&
   +2D0*r1x2E*(VS0(56,15)-ZxZpE*VS1(56,15))&
   +5D0*HfxZpE*VS1(35,30)
VS0(56,52)=QCz*VS0(56,31)+WQz*VS1(56,31)-r1x2E*VR1(56,31)&
   +2D0*r1x2E*(VS0(56,16)-ZxZpE*VS1(56,16))&
   +5D0*HfxZpE*VS1(35,31)
VS0(56,53)=QCz*VS0(56,32)+WQz*VS1(56,32)-r1x2E*VR1(56,32)&
   +2D0*r1x2E*(VS0(56,17)-ZxZpE*VS1(56,17))&
   +5D0*HfxZpE*VS1(35,32)
VS0(56,54)=QCz*VS0(56,33)+WQz*VS1(56,33)-r1x2E*VR1(56,33)&
   +3D0*r1x2E*(VS0(56,18)-ZxZpE*VS1(56,18))&
   +5D0*HfxZpE*VS1(35,33)
VS0(56,55)=QCz*VS0(56,34)+WQz*VS1(56,34)-r1x2E*VR1(56,34)&
   +3D0*r1x2E*(VS0(56,19)-ZxZpE*VS1(56,19))&
   +5D0*HfxZpE*VS1(35,34)
VS0(56,56)=QCz*VS0(56,35)+WQz*VS1(56,35)-r1x2E*VR1(56,35)&
   +4D0*r1x2E*(VS0(56,20)-ZxZpE*VS1(56,20))&
   +5D0*HfxZpE*VS1(35,35)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRh0h0'
STOP
END SELECT
END SUBROUTINE MVRRh0h0
