!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRf0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(11,38)
      V(2)=r1x2E*ZxZpE*VRR1(11,38)
      V(3)=r1x2E*VRR0(11,39)
      V(4)=HfxZpE*VRR1(5,60)
      V(5)=r1x2E*ZxZpE*VRR1(11,39)
      V(6)=r1x2E*VRR0(11,44)
      V(7)=3.D0*V(6)
      V(8)=r1x2E*ZxZpE*VRR1(11,44)
      V(9)=-3.D0*V(8)
      V(10)=r1x2E*VRR0(11,45)
      V(11)=HfxZpE*VRR1(5,67)
      V(12)=r1x2E*ZxZpE*VRR1(11,45)
      V(13)=r1x2E*VRR0(11,47)
      V(14)=r1x2E*ZxZpE*VRR1(11,47)
      V(15)=r1x2E*VRR0(11,48)
      V(16)=3.D0*V(15)
      V(17)=r1x2E*ZxZpE*VRR1(11,48)
      V(18)=-3.D0*V(17)
      V(19)=r1x2E*VRR0(11,49)
      V(20)=HfxZpE*VRR1(5,72)
      V(21)=r1x2E*ZxZpE*VRR1(11,49)
      V(22)=3.D0*V(19)
      V(23)=-3.D0*V(21)
      V(24)=r1x2E*VRR0(11,50)
      V(25)=r1x2E*ZxZpE*VRR1(11,50)
      V(26)=r1x2E*VRR0(11,51)
      V(27)=HfxZpE*VRR1(5,75)
      V(28)=r1x2E*ZxZpE*VRR1(11,51)
      V(29)=r1x2E*VRR0(11,52)
      V(30)=2.D0*V(29)
      V(31)=HfxZpE*VRR1(5,76)
      V(32)=r1x2E*ZxZpE*VRR1(11,52)
      V(33)=-2.D0*V(32)
      V(34)=r1x2E*VRR0(11,53)
      V(35)=r1x2E*ZxZpE*VRR1(11,53)
      V(36)=r1x2E*VRR0(12,38)
      V(37)=r1x2E*ZxZpE*VRR1(12,38)
      V(38)=r1x2E*VRR0(12,39)
      V(39)=HfxZpE*VRR1(6,60)
      V(40)=2.D0*V(39)
      V(41)=r1x2E*ZxZpE*VRR1(12,39)
      V(42)=r1x2E*VRR0(12,44)
      V(43)=3.D0*V(42)
      V(44)=r1x2E*ZxZpE*VRR1(12,44)
      V(45)=-3.D0*V(44)
      V(46)=r1x2E*VRR0(12,45)
      V(47)=HfxZpE*VRR1(6,67)
      V(48)=2.D0*V(47)
      V(49)=r1x2E*ZxZpE*VRR1(12,45)
      V(50)=r1x2E*VRR0(12,47)
      V(51)=r1x2E*ZxZpE*VRR1(12,47)
      V(52)=r1x2E*VRR0(12,48)
      V(53)=3.D0*V(52)
      V(54)=r1x2E*ZxZpE*VRR1(12,48)
      V(55)=-3.D0*V(54)
      V(56)=r1x2E*VRR0(12,49)
      V(57)=HfxZpE*VRR1(6,72)
      V(58)=2.D0*V(57)
      V(59)=r1x2E*ZxZpE*VRR1(12,49)
      V(60)=3.D0*V(56)
      V(61)=-3.D0*V(59)
      V(62)=r1x2E*VRR0(12,50)
      V(63)=r1x2E*ZxZpE*VRR1(12,50)
      V(64)=r1x2E*VRR0(12,51)
      V(65)=HfxZpE*VRR1(6,75)
      V(66)=r1x2E*ZxZpE*VRR1(12,51)
      V(67)=r1x2E*VRR0(12,52)
      V(68)=2.D0*V(67)
      V(69)=HfxZpE*VRR1(6,76)
      V(70)=r1x2E*ZxZpE*VRR1(12,52)
      V(71)=-2.D0*V(70)
      V(72)=HfxZpE*VRR1(5,77)
      V(73)=r1x2E*VRR0(12,53)
      V(74)=HfxZpE*VRR1(5,78)
      V(75)=r1x2E*ZxZpE*VRR1(12,53)
      V(76)=r1x2E*VRR0(13,38)
      V(77)=r1x2E*ZxZpE*VRR1(13,38)
      V(78)=r1x2E*VRR0(13,39)
      V(79)=HfxZpE*VRR1(7,60)
      V(80)=r1x2E*ZxZpE*VRR1(13,39)
      V(81)=r1x2E*VRR0(13,44)
      V(82)=3.D0*V(81)
      V(83)=r1x2E*ZxZpE*VRR1(13,44)
      V(84)=-3.D0*V(83)
      V(85)=r1x2E*VRR0(13,45)
      V(86)=HfxZpE*VRR1(7,67)
      V(87)=r1x2E*ZxZpE*VRR1(13,45)
      V(88)=r1x2E*VRR0(13,47)
      V(89)=r1x2E*ZxZpE*VRR1(13,47)
      V(90)=r1x2E*VRR0(13,48)
      V(91)=3.D0*V(90)
      V(92)=r1x2E*ZxZpE*VRR1(13,48)
      V(93)=-3.D0*V(92)
      V(94)=r1x2E*VRR0(13,49)
      V(95)=HfxZpE*VRR1(7,72)
      V(96)=r1x2E*ZxZpE*VRR1(13,49)
      V(97)=3.D0*V(94)
      V(98)=-3.D0*V(96)
      V(99)=r1x2E*VRR0(13,50)
      V(100)=r1x2E*ZxZpE*VRR1(13,50)
      V(101)=r1x2E*VRR0(13,51)
      V(102)=HfxZpE*VRR1(7,75)
      V(103)=r1x2E*ZxZpE*VRR1(13,51)
      V(104)=r1x2E*VRR0(13,52)
      V(105)=2.D0*V(104)
      V(106)=HfxZpE*VRR1(7,76)
      V(107)=r1x2E*ZxZpE*VRR1(13,52)
      V(108)=-2.D0*V(107)
      V(109)=HfxZpE*VRR1(6,77)
      V(110)=r1x2E*VRR0(13,53)
      V(111)=HfxZpE*VRR1(6,78)
      V(112)=r1x2E*ZxZpE*VRR1(13,53)
      V(113)=r1x2E*VRR0(14,38)
      V(114)=r1x2E*ZxZpE*VRR1(14,38)
      V(115)=r1x2E*VRR0(14,39)
      V(116)=r1x2E*ZxZpE*VRR1(14,39)
      V(117)=r1x2E*VRR0(14,44)
      V(118)=3.D0*V(117)
      V(119)=r1x2E*ZxZpE*VRR1(14,44)
      V(120)=-3.D0*V(119)
      V(121)=r1x2E*VRR0(14,45)
      V(122)=r1x2E*ZxZpE*VRR1(14,45)
      V(123)=r1x2E*VRR0(14,47)
      V(124)=r1x2E*ZxZpE*VRR1(14,47)
      V(125)=r1x2E*VRR0(14,48)
      V(126)=3.D0*V(125)
      V(127)=r1x2E*ZxZpE*VRR1(14,48)
      V(128)=-3.D0*V(127)
      V(129)=r1x2E*VRR0(14,49)
      V(130)=r1x2E*ZxZpE*VRR1(14,49)
      V(131)=3.D0*V(129)
      V(132)=-3.D0*V(130)
      V(133)=r1x2E*VRR0(14,50)
      V(134)=r1x2E*ZxZpE*VRR1(14,50)
      V(135)=r1x2E*VRR0(14,51)
      V(136)=r1x2E*ZxZpE*VRR1(14,51)
      V(137)=r1x2E*VRR0(14,52)
      V(138)=2.D0*V(137)
      V(139)=r1x2E*ZxZpE*VRR1(14,52)
      V(140)=-2.D0*V(139)
      V(141)=HfxZpE*VRR1(7,77)
      V(142)=r1x2E*VRR0(14,53)
      V(143)=HfxZpE*VRR1(7,78)
      V(144)=r1x2E*ZxZpE*VRR1(14,53)
      V(145)=r1x2E*VRR0(15,38)
      V(146)=r1x2E*ZxZpE*VRR1(15,38)
      V(147)=r1x2E*VRR0(15,39)
      V(148)=HfxZpE*VRR1(8,60)
      V(149)=r1x2E*ZxZpE*VRR1(15,39)
      V(150)=r1x2E*VRR0(15,44)
      V(151)=3.D0*V(150)
      V(152)=r1x2E*ZxZpE*VRR1(15,44)
      V(153)=-3.D0*V(152)
      V(154)=r1x2E*VRR0(15,45)
      V(155)=HfxZpE*VRR1(8,67)
      V(156)=r1x2E*ZxZpE*VRR1(15,45)
      V(157)=r1x2E*VRR0(15,47)
      V(158)=r1x2E*ZxZpE*VRR1(15,47)
      V(159)=r1x2E*VRR0(15,48)
      V(160)=3.D0*V(159)
      V(161)=r1x2E*ZxZpE*VRR1(15,48)
      V(162)=-3.D0*V(161)
      V(163)=r1x2E*VRR0(15,49)
      V(164)=HfxZpE*VRR1(8,72)
      V(165)=2.D0*V(164)
      V(166)=r1x2E*ZxZpE*VRR1(15,49)
      V(167)=3.D0*V(163)
      V(168)=-3.D0*V(166)
      V(169)=r1x2E*VRR0(15,50)
      V(170)=r1x2E*ZxZpE*VRR1(15,50)
      V(171)=r1x2E*VRR0(15,51)
      V(172)=HfxZpE*VRR1(8,75)
      V(173)=2.D0*V(172)
      V(174)=r1x2E*ZxZpE*VRR1(15,51)
      V(175)=r1x2E*VRR0(15,52)
      V(176)=2.D0*V(175)
      V(177)=HfxZpE*VRR1(8,76)
      V(178)=2.D0*V(177)
      V(179)=r1x2E*ZxZpE*VRR1(15,52)
      V(180)=-2.D0*V(179)
      V(181)=r1x2E*VRR0(15,53)
      V(182)=r1x2E*ZxZpE*VRR1(15,53)
      V(183)=r1x2E*VRR0(16,38)
      V(184)=r1x2E*ZxZpE*VRR1(16,38)
      V(185)=r1x2E*VRR0(16,39)
      V(186)=HfxZpE*VRR1(9,60)
      V(187)=r1x2E*ZxZpE*VRR1(16,39)
      V(188)=r1x2E*VRR0(16,44)
      V(189)=3.D0*V(188)
      V(190)=r1x2E*ZxZpE*VRR1(16,44)
      V(191)=-3.D0*V(190)
      V(192)=r1x2E*VRR0(16,45)
      V(193)=HfxZpE*VRR1(9,67)
      V(194)=r1x2E*ZxZpE*VRR1(16,45)
      V(195)=r1x2E*VRR0(16,47)
      V(196)=r1x2E*ZxZpE*VRR1(16,47)
      V(197)=r1x2E*VRR0(16,48)
      V(198)=3.D0*V(197)
      V(199)=r1x2E*ZxZpE*VRR1(16,48)
      V(200)=-3.D0*V(199)
      V(201)=r1x2E*VRR0(16,49)
      V(202)=HfxZpE*VRR1(9,72)
      V(203)=r1x2E*ZxZpE*VRR1(16,49)
      V(204)=3.D0*V(201)
      V(205)=-3.D0*V(203)
      V(206)=r1x2E*VRR0(16,50)
      V(207)=r1x2E*ZxZpE*VRR1(16,50)
      V(208)=r1x2E*VRR0(16,51)
      V(209)=HfxZpE*VRR1(9,75)
      V(210)=r1x2E*ZxZpE*VRR1(16,51)
      V(211)=r1x2E*VRR0(16,52)
      V(212)=2.D0*V(211)
      V(213)=HfxZpE*VRR1(9,76)
      V(214)=r1x2E*ZxZpE*VRR1(16,52)
      V(215)=-2.D0*V(214)
      V(216)=HfxZpE*VRR1(8,77)
      V(217)=r1x2E*VRR0(16,53)
      V(218)=HfxZpE*VRR1(8,78)
      V(219)=r1x2E*ZxZpE*VRR1(16,53)
      V(220)=r1x2E*VRR0(17,38)
      V(221)=r1x2E*ZxZpE*VRR1(17,38)
      V(222)=r1x2E*VRR0(17,39)
      V(223)=r1x2E*ZxZpE*VRR1(17,39)
      V(224)=r1x2E*VRR0(17,44)
      V(225)=3.D0*V(224)
      V(226)=r1x2E*ZxZpE*VRR1(17,44)
      V(227)=-3.D0*V(226)
      V(228)=r1x2E*VRR0(17,45)
      V(229)=r1x2E*ZxZpE*VRR1(17,45)
      V(230)=r1x2E*VRR0(17,47)
      V(231)=r1x2E*ZxZpE*VRR1(17,47)
      V(232)=r1x2E*VRR0(17,48)
      V(233)=3.D0*V(232)
      V(234)=r1x2E*ZxZpE*VRR1(17,48)
      V(235)=-3.D0*V(234)
      V(236)=r1x2E*VRR0(17,49)
      V(237)=r1x2E*ZxZpE*VRR1(17,49)
      V(238)=2.D0*V(202)
      V(239)=3.D0*V(236)
      V(240)=-3.D0*V(237)
      V(241)=r1x2E*VRR0(17,50)
      V(242)=r1x2E*ZxZpE*VRR1(17,50)
      V(243)=r1x2E*VRR0(17,51)
      V(244)=r1x2E*ZxZpE*VRR1(17,51)
      V(245)=r1x2E*VRR0(17,52)
      V(246)=2.D0*V(245)
      V(247)=r1x2E*ZxZpE*VRR1(17,52)
      V(248)=-2.D0*V(247)
      V(249)=HfxZpE*VRR1(9,77)
      V(250)=2.D0*V(249)
      V(251)=r1x2E*VRR0(17,53)
      V(252)=HfxZpE*VRR1(9,78)
      V(253)=2.D0*V(252)
      V(254)=r1x2E*ZxZpE*VRR1(17,53)
      V(255)=r1x2E*VRR0(18,38)
      V(256)=r1x2E*ZxZpE*VRR1(18,38)
      V(257)=r1x2E*VRR0(18,39)
      V(258)=HfxZpE*VRR1(10,60)
      V(259)=r1x2E*ZxZpE*VRR1(18,39)
      V(260)=r1x2E*VRR0(18,44)
      V(261)=3.D0*V(260)
      V(262)=r1x2E*ZxZpE*VRR1(18,44)
      V(263)=-3.D0*V(262)
      V(264)=r1x2E*VRR0(18,45)
      V(265)=HfxZpE*VRR1(10,67)
      V(266)=r1x2E*ZxZpE*VRR1(18,45)
      V(267)=r1x2E*VRR0(18,47)
      V(268)=r1x2E*ZxZpE*VRR1(18,47)
      V(269)=r1x2E*VRR0(18,48)
      V(270)=3.D0*V(269)
      V(271)=r1x2E*ZxZpE*VRR1(18,48)
      V(272)=-3.D0*V(271)
      V(273)=r1x2E*VRR0(18,49)
      V(274)=HfxZpE*VRR1(10,72)
      V(275)=r1x2E*ZxZpE*VRR1(18,49)
      V(276)=3.D0*V(273)
      V(277)=-3.D0*V(275)
      V(278)=r1x2E*VRR0(18,50)
      V(279)=r1x2E*ZxZpE*VRR1(18,50)
      V(280)=r1x2E*VRR0(18,51)
      V(281)=HfxZpE*VRR1(10,75)
      V(282)=r1x2E*ZxZpE*VRR1(18,51)
      V(283)=r1x2E*VRR0(18,52)
      V(284)=2.D0*V(283)
      V(285)=HfxZpE*VRR1(10,76)
      V(286)=r1x2E*ZxZpE*VRR1(18,52)
      V(287)=-2.D0*V(286)
      V(288)=r1x2E*VRR0(18,53)
      V(289)=r1x2E*ZxZpE*VRR1(18,53)
      V(290)=r1x2E*VRR0(19,38)
      V(291)=r1x2E*ZxZpE*VRR1(19,38)
      V(292)=r1x2E*VRR0(19,39)
      V(293)=r1x2E*ZxZpE*VRR1(19,39)
      V(294)=r1x2E*VRR0(19,44)
      V(295)=3.D0*V(294)
      V(296)=r1x2E*ZxZpE*VRR1(19,44)
      V(297)=-3.D0*V(296)
      V(298)=r1x2E*VRR0(19,45)
      V(299)=r1x2E*ZxZpE*VRR1(19,45)
      V(300)=r1x2E*VRR0(19,47)
      V(301)=r1x2E*ZxZpE*VRR1(19,47)
      V(302)=r1x2E*VRR0(19,48)
      V(303)=3.D0*V(302)
      V(304)=r1x2E*ZxZpE*VRR1(19,48)
      V(305)=-3.D0*V(304)
      V(306)=r1x2E*VRR0(19,49)
      V(307)=r1x2E*ZxZpE*VRR1(19,49)
      V(308)=3.D0*V(306)
      V(309)=-3.D0*V(307)
      V(310)=r1x2E*VRR0(19,50)
      V(311)=r1x2E*ZxZpE*VRR1(19,50)
      V(312)=r1x2E*VRR0(19,51)
      V(313)=r1x2E*ZxZpE*VRR1(19,51)
      V(314)=r1x2E*VRR0(19,52)
      V(315)=2.D0*V(314)
      V(316)=r1x2E*ZxZpE*VRR1(19,52)
      V(317)=-2.D0*V(316)
      V(318)=HfxZpE*VRR1(10,77)
      V(319)=r1x2E*VRR0(19,53)
      V(320)=HfxZpE*VRR1(10,78)
      V(321)=r1x2E*ZxZpE*VRR1(19,53)
      V(322)=r1x2E*VRR0(20,38)
      V(323)=r1x2E*ZxZpE*VRR1(20,38)
      V(324)=r1x2E*VRR0(20,39)
      V(325)=r1x2E*ZxZpE*VRR1(20,39)
      V(326)=r1x2E*VRR0(20,44)
      V(327)=3.D0*V(326)
      V(328)=r1x2E*ZxZpE*VRR1(20,44)
      V(329)=-3.D0*V(328)
      V(330)=r1x2E*VRR0(20,45)
      V(331)=r1x2E*ZxZpE*VRR1(20,45)
      V(332)=r1x2E*VRR0(20,47)
      V(333)=r1x2E*ZxZpE*VRR1(20,47)
      V(334)=r1x2E*VRR0(20,48)
      V(335)=3.D0*V(334)
      V(336)=r1x2E*ZxZpE*VRR1(20,48)
      V(337)=-3.D0*V(336)
      V(338)=r1x2E*VRR0(20,49)
      V(339)=r1x2E*ZxZpE*VRR1(20,49)
      V(340)=3.D0*V(338)
      V(341)=-3.D0*V(339)
      V(342)=r1x2E*VRR0(20,50)
      V(343)=r1x2E*ZxZpE*VRR1(20,50)
      V(344)=r1x2E*VRR0(20,51)
      V(345)=r1x2E*ZxZpE*VRR1(20,51)
      V(346)=r1x2E*VRR0(20,52)
      V(347)=2.D0*V(346)
      V(348)=r1x2E*ZxZpE*VRR1(20,52)
      V(349)=-2.D0*V(348)
      V(350)=r1x2E*VRR0(20,53)
      V(351)=r1x2E*ZxZpE*VRR1(20,53)
      VRR0(11,85)=6.D0*r1x2E*VRR0(11,36)+QCx*VRR0(11,57)+3.D0*HfxZpE*VRR1(5,57)-6.D0*r1x2E*ZxZpE*VRR1(11,36)+WQx*VRR1(11,57)
      VRR0(11,86)=5.D0*r1x2E*VRR0(11,37)+QCx*VRR0(11,58)+3.D0*HfxZpE*VRR1(5,58)-5.D0*r1x2E*ZxZpE*VRR1(11,37)+WQx*VRR1(11,58)
      VRR0(11,87)=4.D0*V(1)-4.D0*V(2)+QCx*VRR0(11,59)+3.D0*HfxZpE*VRR1(5,59)+WQx*VRR1(11,59)
      VRR0(11,88)=3.D0*V(3)+3.D0*V(4)-3.D0*V(5)+QCx*VRR0(11,60)+WQx*VRR1(11,60)
      VRR0(11,89)=3.D0*V(1)-3.D0*V(2)+QCy*VRR0(11,60)+WQy*VRR1(11,60)
      VRR0(11,90)=4.D0*V(3)-4.D0*V(5)+QCy*VRR0(11,61)+WQy*VRR1(11,61)
      VRR0(11,91)=5.D0*r1x2E*VRR0(11,40)+QCy*VRR0(11,62)-5.D0*r1x2E*ZxZpE*VRR1(11,40)+WQy*VRR1(11,62)
      VRR0(11,92)=6.D0*r1x2E*VRR0(11,41)+QCy*VRR0(11,63)-6.D0*r1x2E*ZxZpE*VRR1(11,41)+WQy*VRR1(11,63)
      VRR0(11,93)=5.D0*r1x2E*VRR0(11,42)+QCx*VRR0(11,64)+3.D0*HfxZpE*VRR1(5,64)-5.D0*r1x2E*ZxZpE*VRR1(11,42)+WQx*VRR1(11,64)
      VRR0(11,94)=4.D0*r1x2E*VRR0(11,43)+QCx*VRR0(11,65)+3.D0*HfxZpE*VRR1(5,65)-4.D0*r1x2E*ZxZpE*VRR1(11,43)+WQx*VRR1(11,65)
      VRR0(11,95)=V(7)+V(9)+QCx*VRR0(11,66)+3.D0*HfxZpE*VRR1(5,66)+WQx*VRR1(11,66)
      VRR0(11,96)=2.D0*V(10)+3.D0*V(11)-2.D0*V(12)+QCx*VRR0(11,67)+WQx*VRR1(11,67)
      VRR0(11,97)=V(7)+V(9)+QCy*VRR0(11,67)+WQy*VRR1(11,67)
      VRR0(11,98)=4.D0*V(10)-4.D0*V(12)+QCy*VRR0(11,68)+WQy*VRR1(11,68)
      VRR0(11,99)=5.D0*r1x2E*VRR0(11,46)+QCy*VRR0(11,69)-5.D0*r1x2E*ZxZpE*VRR1(11,46)+WQy*VRR1(11,69)
      VRR0(11,100)=4.D0*V(13)-4.D0*V(14)+QCx*VRR0(11,70)+3.D0*HfxZpE*VRR1(5,70)+WQx*VRR1(11,70)
      VRR0(11,101)=V(16)+V(18)+QCx*VRR0(11,71)+3.D0*HfxZpE*VRR1(5,71)+WQx*VRR1(11,71)
      VRR0(11,102)=2.D0*V(19)+3.D0*V(20)-2.D0*V(21)+QCx*VRR0(11,72)+WQx*VRR1(11,72)
      VRR0(11,103)=2.D0*V(15)-2.D0*V(17)+QCy*VRR0(11,72)+WQy*VRR1(11,72)
      VRR0(11,104)=V(22)+V(23)+QCy*VRR0(11,73)+WQy*VRR1(11,73)
      VRR0(11,105)=4.D0*V(24)-4.D0*V(25)+QCy*VRR0(11,74)+WQy*VRR1(11,74)
      VRR0(11,106)=3.D0*V(26)+3.D0*V(27)-3.D0*V(28)+QCx*VRR0(11,75)+WQx*VRR1(11,75)
      VRR0(11,107)=V(30)+3.D0*V(31)+V(33)+QCx*VRR0(11,76)+WQx*VRR1(11,76)
      VRR0(11,108)=2.D0*V(6)-2.D0*V(8)+QCz*VRR0(11,72)+WQz*VRR1(11,72)
      VRR0(11,109)=V(30)+V(33)+QCy*VRR0(11,77)+WQy*VRR1(11,77)
      VRR0(11,110)=3.D0*V(34)-3.D0*V(35)+QCy*VRR0(11,78)+WQy*VRR1(11,78)
      VRR0(11,111)=3.D0*V(13)-3.D0*V(14)+QCz*VRR0(11,75)+WQz*VRR1(11,75)
      VRR0(11,112)=V(16)+V(18)+QCz*VRR0(11,76)+WQz*VRR1(11,76)
      VRR0(11,113)=V(22)+V(23)+QCz*VRR0(11,77)+WQz*VRR1(11,77)
      VRR0(11,114)=3.D0*V(24)-3.D0*V(25)+QCz*VRR0(11,78)+WQz*VRR1(11,78)
      VRR0(11,115)=4.D0*V(26)-4.D0*V(28)+QCz*VRR0(11,79)+WQz*VRR1(11,79)
      VRR0(11,116)=4.D0*V(29)-4.D0*V(32)+QCz*VRR0(11,80)+WQz*VRR1(11,80)
      VRR0(11,117)=4.D0*V(34)-4.D0*V(35)+QCz*VRR0(11,81)+WQz*VRR1(11,81)
      VRR0(11,118)=5.D0*r1x2E*VRR0(11,54)+QCz*VRR0(11,82)-5.D0*r1x2E*ZxZpE*VRR1(11,54)+WQz*VRR1(11,82)
      VRR0(11,119)=5.D0*r1x2E*VRR0(11,55)+QCz*VRR0(11,83)-5.D0*r1x2E*ZxZpE*VRR1(11,55)+WQz*VRR1(11,83)
      VRR0(11,120)=6.D0*r1x2E*VRR0(11,56)+QCz*VRR0(11,84)-6.D0*r1x2E*ZxZpE*VRR1(11,56)+WQz*VRR1(11,84)
      VRR0(12,85)=6.D0*r1x2E*VRR0(12,36)+QCx*VRR0(12,57)+2.D0*HfxZpE*VRR1(6,57)-6.D0*r1x2E*ZxZpE*VRR1(12,36)+WQx*VRR1(12,57)
      VRR0(12,86)=5.D0*r1x2E*VRR0(12,37)+QCx*VRR0(12,58)+2.D0*HfxZpE*VRR1(6,58)-5.D0*r1x2E*ZxZpE*VRR1(12,37)+WQx*VRR1(12,58)
      VRR0(12,87)=4.D0*V(36)-4.D0*V(37)+QCx*VRR0(12,59)+2.D0*HfxZpE*VRR1(6,59)+WQx*VRR1(12,59)
      VRR0(12,88)=3.D0*V(38)+V(40)-3.D0*V(41)+QCx*VRR0(12,60)+WQx*VRR1(12,60)
      VRR0(12,89)=V(4)+3.D0*V(36)-3.D0*V(37)+QCy*VRR0(12,60)+WQy*VRR1(12,60)
      VRR0(12,90)=4.D0*V(38)-4.D0*V(41)+QCy*VRR0(12,61)+HfxZpE*VRR1(5,61)+WQy*VRR1(12,61)
      VRR0(12,91)=5.D0*r1x2E*VRR0(12,40)+QCy*VRR0(12,62)+HfxZpE*VRR1(5,62)-5.D0*r1x2E*ZxZpE*VRR1(12,40)+WQy*VRR1(12,62)
      VRR0(12,92)=6.D0*r1x2E*VRR0(12,41)+QCy*VRR0(12,63)+HfxZpE*VRR1(5,63)-6.D0*r1x2E*ZxZpE*VRR1(12,41)+WQy*VRR1(12,63)
      VRR0(12,93)=5.D0*r1x2E*VRR0(12,42)+QCx*VRR0(12,64)+2.D0*HfxZpE*VRR1(6,64)-5.D0*r1x2E*ZxZpE*VRR1(12,42)+WQx*VRR1(12,64)
      VRR0(12,94)=4.D0*r1x2E*VRR0(12,43)+QCx*VRR0(12,65)+2.D0*HfxZpE*VRR1(6,65)-4.D0*r1x2E*ZxZpE*VRR1(12,43)+WQx*VRR1(12,65)
      VRR0(12,95)=V(43)+V(45)+QCx*VRR0(12,66)+2.D0*HfxZpE*VRR1(6,66)+WQx*VRR1(12,66)
      VRR0(12,96)=2.D0*V(46)+V(48)-2.D0*V(49)+QCx*VRR0(12,67)+WQx*VRR1(12,67)
      VRR0(12,97)=V(11)+V(43)+V(45)+QCy*VRR0(12,67)+WQy*VRR1(12,67)
      VRR0(12,98)=4.D0*V(46)-4.D0*V(49)+QCy*VRR0(12,68)+HfxZpE*VRR1(5,68)+WQy*VRR1(12,68)
      VRR0(12,99)=5.D0*r1x2E*VRR0(12,46)+QCy*VRR0(12,69)+HfxZpE*VRR1(5,69)-5.D0*r1x2E*ZxZpE*VRR1(12,46)+WQy*VRR1(12,69)
      VRR0(12,100)=4.D0*V(50)-4.D0*V(51)+QCx*VRR0(12,70)+2.D0*HfxZpE*VRR1(6,70)+WQx*VRR1(12,70)
      VRR0(12,101)=V(53)+V(55)+QCx*VRR0(12,71)+2.D0*HfxZpE*VRR1(6,71)+WQx*VRR1(12,71)
      VRR0(12,102)=2.D0*V(56)+V(58)-2.D0*V(59)+QCx*VRR0(12,72)+WQx*VRR1(12,72)
      VRR0(12,103)=V(20)+2.D0*V(52)-2.D0*V(54)+QCy*VRR0(12,72)+WQy*VRR1(12,72)
      VRR0(12,104)=V(60)+V(61)+QCy*VRR0(12,73)+HfxZpE*VRR1(5,73)+WQy*VRR1(12,73)
      VRR0(12,105)=4.D0*V(62)-4.D0*V(63)+QCy*VRR0(12,74)+HfxZpE*VRR1(5,74)+WQy*VRR1(12,74)
      VRR0(12,106)=3.D0*V(64)+2.D0*V(65)-3.D0*V(66)+QCx*VRR0(12,75)+WQx*VRR1(12,75)
      VRR0(12,107)=V(68)+2.D0*V(69)+V(71)+QCx*VRR0(12,76)+WQx*VRR1(12,76)
      VRR0(12,108)=2.D0*V(42)-2.D0*V(44)+QCz*VRR0(12,72)+WQz*VRR1(12,72)
      VRR0(12,109)=V(68)+V(71)+V(72)+QCy*VRR0(12,77)+WQy*VRR1(12,77)
      VRR0(12,110)=3.D0*V(73)+V(74)-3.D0*V(75)+QCy*VRR0(12,78)+WQy*VRR1(12,78)
      VRR0(12,111)=3.D0*V(50)-3.D0*V(51)+QCz*VRR0(12,75)+WQz*VRR1(12,75)
      VRR0(12,112)=V(53)+V(55)+QCz*VRR0(12,76)+WQz*VRR1(12,76)
      VRR0(12,113)=V(60)+V(61)+QCz*VRR0(12,77)+WQz*VRR1(12,77)
      VRR0(12,114)=3.D0*V(62)-3.D0*V(63)+QCz*VRR0(12,78)+WQz*VRR1(12,78)
      VRR0(12,115)=4.D0*V(64)-4.D0*V(66)+QCz*VRR0(12,79)+WQz*VRR1(12,79)
      VRR0(12,116)=4.D0*V(67)-4.D0*V(70)+QCz*VRR0(12,80)+WQz*VRR1(12,80)
      VRR0(12,117)=4.D0*V(73)-4.D0*V(75)+QCz*VRR0(12,81)+WQz*VRR1(12,81)
      VRR0(12,118)=5.D0*r1x2E*VRR0(12,54)+QCz*VRR0(12,82)-5.D0*r1x2E*ZxZpE*VRR1(12,54)+WQz*VRR1(12,82)
      VRR0(12,119)=5.D0*r1x2E*VRR0(12,55)+QCz*VRR0(12,83)-5.D0*r1x2E*ZxZpE*VRR1(12,55)+WQz*VRR1(12,83)
      VRR0(12,120)=6.D0*r1x2E*VRR0(12,56)+QCz*VRR0(12,84)-6.D0*r1x2E*ZxZpE*VRR1(12,56)+WQz*VRR1(12,84)
      VRR0(13,85)=6.D0*r1x2E*VRR0(13,36)+QCx*VRR0(13,57)+HfxZpE*VRR1(7,57)-6.D0*r1x2E*ZxZpE*VRR1(13,36)+WQx*VRR1(13,57)
      VRR0(13,86)=5.D0*r1x2E*VRR0(13,37)+QCx*VRR0(13,58)+HfxZpE*VRR1(7,58)-5.D0*r1x2E*ZxZpE*VRR1(13,37)+WQx*VRR1(13,58)
      VRR0(13,87)=4.D0*V(76)-4.D0*V(77)+QCx*VRR0(13,59)+HfxZpE*VRR1(7,59)+WQx*VRR1(13,59)
      VRR0(13,88)=3.D0*V(78)+V(79)-3.D0*V(80)+QCx*VRR0(13,60)+WQx*VRR1(13,60)
      VRR0(13,89)=V(40)+3.D0*V(76)-3.D0*V(77)+QCy*VRR0(13,60)+WQy*VRR1(13,60)
      VRR0(13,90)=4.D0*V(78)-4.D0*V(80)+QCy*VRR0(13,61)+2.D0*HfxZpE*VRR1(6,61)+WQy*VRR1(13,61)
      VRR0(13,91)=5.D0*r1x2E*VRR0(13,40)+QCy*VRR0(13,62)+2.D0*HfxZpE*VRR1(6,62)-5.D0*r1x2E*ZxZpE*VRR1(13,40)+WQy*VRR1(13,62)
      VRR0(13,92)=6.D0*r1x2E*VRR0(13,41)+QCy*VRR0(13,63)+2.D0*HfxZpE*VRR1(6,63)-6.D0*r1x2E*ZxZpE*VRR1(13,41)+WQy*VRR1(13,63)
      VRR0(13,93)=5.D0*r1x2E*VRR0(13,42)+QCx*VRR0(13,64)+HfxZpE*VRR1(7,64)-5.D0*r1x2E*ZxZpE*VRR1(13,42)+WQx*VRR1(13,64)
      VRR0(13,94)=4.D0*r1x2E*VRR0(13,43)+QCx*VRR0(13,65)+HfxZpE*VRR1(7,65)-4.D0*r1x2E*ZxZpE*VRR1(13,43)+WQx*VRR1(13,65)
      VRR0(13,95)=V(82)+V(84)+QCx*VRR0(13,66)+HfxZpE*VRR1(7,66)+WQx*VRR1(13,66)
      VRR0(13,96)=2.D0*V(85)+V(86)-2.D0*V(87)+QCx*VRR0(13,67)+WQx*VRR1(13,67)
      VRR0(13,97)=V(48)+V(82)+V(84)+QCy*VRR0(13,67)+WQy*VRR1(13,67)
      VRR0(13,98)=4.D0*V(85)-4.D0*V(87)+QCy*VRR0(13,68)+2.D0*HfxZpE*VRR1(6,68)+WQy*VRR1(13,68)
      VRR0(13,99)=5.D0*r1x2E*VRR0(13,46)+QCy*VRR0(13,69)+2.D0*HfxZpE*VRR1(6,69)-5.D0*r1x2E*ZxZpE*VRR1(13,46)+WQy*VRR1(13,69)
      VRR0(13,100)=4.D0*V(88)-4.D0*V(89)+QCx*VRR0(13,70)+HfxZpE*VRR1(7,70)+WQx*VRR1(13,70)
      VRR0(13,101)=V(91)+V(93)+QCx*VRR0(13,71)+HfxZpE*VRR1(7,71)+WQx*VRR1(13,71)
      VRR0(13,102)=2.D0*V(94)+V(95)-2.D0*V(96)+QCx*VRR0(13,72)+WQx*VRR1(13,72)
      VRR0(13,103)=V(58)+2.D0*V(90)-2.D0*V(92)+QCy*VRR0(13,72)+WQy*VRR1(13,72)
      VRR0(13,104)=V(97)+V(98)+QCy*VRR0(13,73)+2.D0*HfxZpE*VRR1(6,73)+WQy*VRR1(13,73)
      VRR0(13,105)=4.D0*V(99)-4.D0*V(100)+QCy*VRR0(13,74)+2.D0*HfxZpE*VRR1(6,74)+WQy*VRR1(13,74)
      VRR0(13,106)=3.D0*V(101)+V(102)-3.D0*V(103)+QCx*VRR0(13,75)+WQx*VRR1(13,75)
      VRR0(13,107)=V(105)+V(106)+V(108)+QCx*VRR0(13,76)+WQx*VRR1(13,76)
      VRR0(13,108)=2.D0*V(81)-2.D0*V(83)+QCz*VRR0(13,72)+WQz*VRR1(13,72)
      VRR0(13,109)=V(105)+V(108)+2.D0*V(109)+QCy*VRR0(13,77)+WQy*VRR1(13,77)
      VRR0(13,110)=3.D0*V(110)+2.D0*V(111)-3.D0*V(112)+QCy*VRR0(13,78)+WQy*VRR1(13,78)
      VRR0(13,111)=3.D0*V(88)-3.D0*V(89)+QCz*VRR0(13,75)+WQz*VRR1(13,75)
      VRR0(13,112)=V(91)+V(93)+QCz*VRR0(13,76)+WQz*VRR1(13,76)
      VRR0(13,113)=V(97)+V(98)+QCz*VRR0(13,77)+WQz*VRR1(13,77)
      VRR0(13,114)=3.D0*V(99)-3.D0*V(100)+QCz*VRR0(13,78)+WQz*VRR1(13,78)
      VRR0(13,115)=4.D0*V(101)-4.D0*V(103)+QCz*VRR0(13,79)+WQz*VRR1(13,79)
      VRR0(13,116)=4.D0*V(104)-4.D0*V(107)+QCz*VRR0(13,80)+WQz*VRR1(13,80)
      VRR0(13,117)=4.D0*V(110)-4.D0*V(112)+QCz*VRR0(13,81)+WQz*VRR1(13,81)
      VRR0(13,118)=5.D0*r1x2E*VRR0(13,54)+QCz*VRR0(13,82)-5.D0*r1x2E*ZxZpE*VRR1(13,54)+WQz*VRR1(13,82)
      VRR0(13,119)=5.D0*r1x2E*VRR0(13,55)+QCz*VRR0(13,83)-5.D0*r1x2E*ZxZpE*VRR1(13,55)+WQz*VRR1(13,83)
      VRR0(13,120)=6.D0*r1x2E*VRR0(13,56)+QCz*VRR0(13,84)-6.D0*r1x2E*ZxZpE*VRR1(13,56)+WQz*VRR1(13,84)
      VRR0(14,85)=6.D0*r1x2E*VRR0(14,36)+QCx*VRR0(14,57)-6.D0*r1x2E*ZxZpE*VRR1(14,36)+WQx*VRR1(14,57)
      VRR0(14,86)=5.D0*r1x2E*VRR0(14,37)+QCx*VRR0(14,58)-5.D0*r1x2E*ZxZpE*VRR1(14,37)+WQx*VRR1(14,58)
      VRR0(14,87)=4.D0*V(113)-4.D0*V(114)+QCx*VRR0(14,59)+WQx*VRR1(14,59)
      VRR0(14,88)=3.D0*V(115)-3.D0*V(116)+QCx*VRR0(14,60)+WQx*VRR1(14,60)
      VRR0(14,89)=3.D0*V(79)+3.D0*V(113)-3.D0*V(114)+QCy*VRR0(14,60)+WQy*VRR1(14,60)
      VRR0(14,90)=4.D0*V(115)-4.D0*V(116)+QCy*VRR0(14,61)+3.D0*HfxZpE*VRR1(7,61)+WQy*VRR1(14,61)
      VRR0(14,91)=5.D0*r1x2E*VRR0(14,40)+QCy*VRR0(14,62)+3.D0*HfxZpE*VRR1(7,62)-5.D0*r1x2E*ZxZpE*VRR1(14,40)+WQy*VRR1(14,62)
      VRR0(14,92)=6.D0*r1x2E*VRR0(14,41)+QCy*VRR0(14,63)+3.D0*HfxZpE*VRR1(7,63)-6.D0*r1x2E*ZxZpE*VRR1(14,41)+WQy*VRR1(14,63)
      VRR0(14,93)=5.D0*r1x2E*VRR0(14,42)+QCx*VRR0(14,64)-5.D0*r1x2E*ZxZpE*VRR1(14,42)+WQx*VRR1(14,64)
      VRR0(14,94)=4.D0*r1x2E*VRR0(14,43)+QCx*VRR0(14,65)-4.D0*r1x2E*ZxZpE*VRR1(14,43)+WQx*VRR1(14,65)
      VRR0(14,95)=V(118)+V(120)+QCx*VRR0(14,66)+WQx*VRR1(14,66)
      VRR0(14,96)=2.D0*V(121)-2.D0*V(122)+QCx*VRR0(14,67)+WQx*VRR1(14,67)
      VRR0(14,97)=3.D0*V(86)+V(118)+V(120)+QCy*VRR0(14,67)+WQy*VRR1(14,67)
      VRR0(14,98)=4.D0*V(121)-4.D0*V(122)+QCy*VRR0(14,68)+3.D0*HfxZpE*VRR1(7,68)+WQy*VRR1(14,68)
      VRR0(14,99)=5.D0*r1x2E*VRR0(14,46)+QCy*VRR0(14,69)+3.D0*HfxZpE*VRR1(7,69)-5.D0*r1x2E*ZxZpE*VRR1(14,46)+WQy*VRR1(14,69)
      VRR0(14,100)=4.D0*V(123)-4.D0*V(124)+QCx*VRR0(14,70)+WQx*VRR1(14,70)
      VRR0(14,101)=V(126)+V(128)+QCx*VRR0(14,71)+WQx*VRR1(14,71)
      VRR0(14,102)=2.D0*V(129)-2.D0*V(130)+QCx*VRR0(14,72)+WQx*VRR1(14,72)
      VRR0(14,103)=3.D0*V(95)+2.D0*V(125)-2.D0*V(127)+QCy*VRR0(14,72)+WQy*VRR1(14,72)
      VRR0(14,104)=V(131)+V(132)+QCy*VRR0(14,73)+3.D0*HfxZpE*VRR1(7,73)+WQy*VRR1(14,73)
      VRR0(14,105)=4.D0*V(133)-4.D0*V(134)+QCy*VRR0(14,74)+3.D0*HfxZpE*VRR1(7,74)+WQy*VRR1(14,74)
      VRR0(14,106)=3.D0*V(135)-3.D0*V(136)+QCx*VRR0(14,75)+WQx*VRR1(14,75)
      VRR0(14,107)=V(138)+V(140)+QCx*VRR0(14,76)+WQx*VRR1(14,76)
      VRR0(14,108)=2.D0*V(117)-2.D0*V(119)+QCz*VRR0(14,72)+WQz*VRR1(14,72)
      VRR0(14,109)=V(138)+V(140)+3.D0*V(141)+QCy*VRR0(14,77)+WQy*VRR1(14,77)
      VRR0(14,110)=3.D0*V(142)+3.D0*V(143)-3.D0*V(144)+QCy*VRR0(14,78)+WQy*VRR1(14,78)
      VRR0(14,111)=3.D0*V(123)-3.D0*V(124)+QCz*VRR0(14,75)+WQz*VRR1(14,75)
      VRR0(14,112)=V(126)+V(128)+QCz*VRR0(14,76)+WQz*VRR1(14,76)
      VRR0(14,113)=V(131)+V(132)+QCz*VRR0(14,77)+WQz*VRR1(14,77)
      VRR0(14,114)=3.D0*V(133)-3.D0*V(134)+QCz*VRR0(14,78)+WQz*VRR1(14,78)
      VRR0(14,115)=4.D0*V(135)-4.D0*V(136)+QCz*VRR0(14,79)+WQz*VRR1(14,79)
      VRR0(14,116)=4.D0*V(137)-4.D0*V(139)+QCz*VRR0(14,80)+WQz*VRR1(14,80)
      VRR0(14,117)=4.D0*V(142)-4.D0*V(144)+QCz*VRR0(14,81)+WQz*VRR1(14,81)
      VRR0(14,118)=5.D0*r1x2E*VRR0(14,54)+QCz*VRR0(14,82)-5.D0*r1x2E*ZxZpE*VRR1(14,54)+WQz*VRR1(14,82)
      VRR0(14,119)=5.D0*r1x2E*VRR0(14,55)+QCz*VRR0(14,83)-5.D0*r1x2E*ZxZpE*VRR1(14,55)+WQz*VRR1(14,83)
      VRR0(14,120)=6.D0*r1x2E*VRR0(14,56)+QCz*VRR0(14,84)-6.D0*r1x2E*ZxZpE*VRR1(14,56)+WQz*VRR1(14,84)
      VRR0(15,85)=6.D0*r1x2E*VRR0(15,36)+QCx*VRR0(15,57)+2.D0*HfxZpE*VRR1(8,57)-6.D0*r1x2E*ZxZpE*VRR1(15,36)+WQx*VRR1(15,57)
      VRR0(15,86)=5.D0*r1x2E*VRR0(15,37)+QCx*VRR0(15,58)+2.D0*HfxZpE*VRR1(8,58)-5.D0*r1x2E*ZxZpE*VRR1(15,37)+WQx*VRR1(15,58)
      VRR0(15,87)=4.D0*V(145)-4.D0*V(146)+QCx*VRR0(15,59)+2.D0*HfxZpE*VRR1(8,59)+WQx*VRR1(15,59)
      VRR0(15,88)=3.D0*V(147)+2.D0*V(148)-3.D0*V(149)+QCx*VRR0(15,60)+WQx*VRR1(15,60)
      VRR0(15,89)=3.D0*V(145)-3.D0*V(146)+QCy*VRR0(15,60)+WQy*VRR1(15,60)
      VRR0(15,90)=4.D0*V(147)-4.D0*V(149)+QCy*VRR0(15,61)+WQy*VRR1(15,61)
      VRR0(15,91)=5.D0*r1x2E*VRR0(15,40)+QCy*VRR0(15,62)-5.D0*r1x2E*ZxZpE*VRR1(15,40)+WQy*VRR1(15,62)
      VRR0(15,92)=6.D0*r1x2E*VRR0(15,41)+QCy*VRR0(15,63)-6.D0*r1x2E*ZxZpE*VRR1(15,41)+WQy*VRR1(15,63)
      VRR0(15,93)=5.D0*r1x2E*VRR0(15,42)+QCx*VRR0(15,64)+2.D0*HfxZpE*VRR1(8,64)-5.D0*r1x2E*ZxZpE*VRR1(15,42)+WQx*VRR1(15,64)
      VRR0(15,94)=4.D0*r1x2E*VRR0(15,43)+QCx*VRR0(15,65)+2.D0*HfxZpE*VRR1(8,65)-4.D0*r1x2E*ZxZpE*VRR1(15,43)+WQx*VRR1(15,65)
      VRR0(15,95)=V(151)+V(153)+QCx*VRR0(15,66)+2.D0*HfxZpE*VRR1(8,66)+WQx*VRR1(15,66)
      VRR0(15,96)=2.D0*V(154)+2.D0*V(155)-2.D0*V(156)+QCx*VRR0(15,67)+WQx*VRR1(15,67)
      VRR0(15,97)=V(151)+V(153)+QCy*VRR0(15,67)+WQy*VRR1(15,67)
      VRR0(15,98)=4.D0*V(154)-4.D0*V(156)+QCy*VRR0(15,68)+WQy*VRR1(15,68)
      VRR0(15,99)=5.D0*r1x2E*VRR0(15,46)+QCy*VRR0(15,69)-5.D0*r1x2E*ZxZpE*VRR1(15,46)+WQy*VRR1(15,69)
      VRR0(15,100)=4.D0*V(157)-4.D0*V(158)+QCx*VRR0(15,70)+2.D0*HfxZpE*VRR1(8,70)+WQx*VRR1(15,70)
      VRR0(15,101)=V(160)+V(162)+QCx*VRR0(15,71)+2.D0*HfxZpE*VRR1(8,71)+WQx*VRR1(15,71)
      VRR0(15,102)=2.D0*V(163)+V(165)-2.D0*V(166)+QCx*VRR0(15,72)+WQx*VRR1(15,72)
      VRR0(15,103)=2.D0*V(159)-2.D0*V(161)+QCy*VRR0(15,72)+WQy*VRR1(15,72)
      VRR0(15,104)=V(167)+V(168)+QCy*VRR0(15,73)+WQy*VRR1(15,73)
      VRR0(15,105)=4.D0*V(169)-4.D0*V(170)+QCy*VRR0(15,74)+WQy*VRR1(15,74)
      VRR0(15,106)=3.D0*V(171)+V(173)-3.D0*V(174)+QCx*VRR0(15,75)+WQx*VRR1(15,75)
      VRR0(15,107)=V(176)+V(178)+V(180)+QCx*VRR0(15,76)+WQx*VRR1(15,76)
      VRR0(15,108)=V(20)+2.D0*V(150)-2.D0*V(152)+QCz*VRR0(15,72)+WQz*VRR1(15,72)
      VRR0(15,109)=V(176)+V(180)+QCy*VRR0(15,77)+WQy*VRR1(15,77)
      VRR0(15,110)=3.D0*V(181)-3.D0*V(182)+QCy*VRR0(15,78)+WQy*VRR1(15,78)
      VRR0(15,111)=V(27)+3.D0*V(157)-3.D0*V(158)+QCz*VRR0(15,75)+WQz*VRR1(15,75)
      VRR0(15,112)=V(31)+V(160)+V(162)+QCz*VRR0(15,76)+WQz*VRR1(15,76)
      VRR0(15,113)=V(72)+V(167)+V(168)+QCz*VRR0(15,77)+WQz*VRR1(15,77)
      VRR0(15,114)=V(74)+3.D0*V(169)-3.D0*V(170)+QCz*VRR0(15,78)+WQz*VRR1(15,78)
      VRR0(15,115)=4.D0*V(171)-4.D0*V(174)+QCz*VRR0(15,79)+HfxZpE*VRR1(5,79)+WQz*VRR1(15,79)
      VRR0(15,116)=4.D0*V(175)-4.D0*V(179)+QCz*VRR0(15,80)+HfxZpE*VRR1(5,80)+WQz*VRR1(15,80)
      VRR0(15,117)=4.D0*V(181)-4.D0*V(182)+QCz*VRR0(15,81)+HfxZpE*VRR1(5,81)+WQz*VRR1(15,81)
      VRR0(15,118)=5.D0*r1x2E*VRR0(15,54)+QCz*VRR0(15,82)+HfxZpE*VRR1(5,82)-5.D0*r1x2E*ZxZpE*VRR1(15,54)+WQz*VRR1(15,82)
      VRR0(15,119)=5.D0*r1x2E*VRR0(15,55)+QCz*VRR0(15,83)+HfxZpE*VRR1(5,83)-5.D0*r1x2E*ZxZpE*VRR1(15,55)+WQz*VRR1(15,83)
      VRR0(15,120)=6.D0*r1x2E*VRR0(15,56)+QCz*VRR0(15,84)+HfxZpE*VRR1(5,84)-6.D0*r1x2E*ZxZpE*VRR1(15,56)+WQz*VRR1(15,84)
      VRR0(16,85)=6.D0*r1x2E*VRR0(16,36)+QCx*VRR0(16,57)+HfxZpE*VRR1(9,57)-6.D0*r1x2E*ZxZpE*VRR1(16,36)+WQx*VRR1(16,57)
      VRR0(16,86)=5.D0*r1x2E*VRR0(16,37)+QCx*VRR0(16,58)+HfxZpE*VRR1(9,58)-5.D0*r1x2E*ZxZpE*VRR1(16,37)+WQx*VRR1(16,58)
      VRR0(16,87)=4.D0*V(183)-4.D0*V(184)+QCx*VRR0(16,59)+HfxZpE*VRR1(9,59)+WQx*VRR1(16,59)
      VRR0(16,88)=3.D0*V(185)+V(186)-3.D0*V(187)+QCx*VRR0(16,60)+WQx*VRR1(16,60)
      VRR0(16,89)=V(148)+3.D0*V(183)-3.D0*V(184)+QCy*VRR0(16,60)+WQy*VRR1(16,60)
      VRR0(16,90)=4.D0*V(185)-4.D0*V(187)+QCy*VRR0(16,61)+HfxZpE*VRR1(8,61)+WQy*VRR1(16,61)
      VRR0(16,91)=5.D0*r1x2E*VRR0(16,40)+QCy*VRR0(16,62)+HfxZpE*VRR1(8,62)-5.D0*r1x2E*ZxZpE*VRR1(16,40)+WQy*VRR1(16,62)
      VRR0(16,92)=6.D0*r1x2E*VRR0(16,41)+QCy*VRR0(16,63)+HfxZpE*VRR1(8,63)-6.D0*r1x2E*ZxZpE*VRR1(16,41)+WQy*VRR1(16,63)
      VRR0(16,93)=5.D0*r1x2E*VRR0(16,42)+QCx*VRR0(16,64)+HfxZpE*VRR1(9,64)-5.D0*r1x2E*ZxZpE*VRR1(16,42)+WQx*VRR1(16,64)
      VRR0(16,94)=4.D0*r1x2E*VRR0(16,43)+QCx*VRR0(16,65)+HfxZpE*VRR1(9,65)-4.D0*r1x2E*ZxZpE*VRR1(16,43)+WQx*VRR1(16,65)
      VRR0(16,95)=V(189)+V(191)+QCx*VRR0(16,66)+HfxZpE*VRR1(9,66)+WQx*VRR1(16,66)
      VRR0(16,96)=2.D0*V(192)+V(193)-2.D0*V(194)+QCx*VRR0(16,67)+WQx*VRR1(16,67)
      VRR0(16,97)=V(155)+V(189)+V(191)+QCy*VRR0(16,67)+WQy*VRR1(16,67)
      VRR0(16,98)=4.D0*V(192)-4.D0*V(194)+QCy*VRR0(16,68)+HfxZpE*VRR1(8,68)+WQy*VRR1(16,68)
      VRR0(16,99)=5.D0*r1x2E*VRR0(16,46)+QCy*VRR0(16,69)+HfxZpE*VRR1(8,69)-5.D0*r1x2E*ZxZpE*VRR1(16,46)+WQy*VRR1(16,69)
      VRR0(16,100)=4.D0*V(195)-4.D0*V(196)+QCx*VRR0(16,70)+HfxZpE*VRR1(9,70)+WQx*VRR1(16,70)
      VRR0(16,101)=V(198)+V(200)+QCx*VRR0(16,71)+HfxZpE*VRR1(9,71)+WQx*VRR1(16,71)
      VRR0(16,102)=2.D0*V(201)+V(202)-2.D0*V(203)+QCx*VRR0(16,72)+WQx*VRR1(16,72)
      VRR0(16,103)=V(164)+2.D0*V(197)-2.D0*V(199)+QCy*VRR0(16,72)+WQy*VRR1(16,72)
      VRR0(16,104)=V(204)+V(205)+QCy*VRR0(16,73)+HfxZpE*VRR1(8,73)+WQy*VRR1(16,73)
      VRR0(16,105)=4.D0*V(206)-4.D0*V(207)+QCy*VRR0(16,74)+HfxZpE*VRR1(8,74)+WQy*VRR1(16,74)
      VRR0(16,106)=3.D0*V(208)+V(209)-3.D0*V(210)+QCx*VRR0(16,75)+WQx*VRR1(16,75)
      VRR0(16,107)=V(212)+V(213)+V(215)+QCx*VRR0(16,76)+WQx*VRR1(16,76)
      VRR0(16,108)=V(57)+2.D0*V(188)-2.D0*V(190)+QCz*VRR0(16,72)+WQz*VRR1(16,72)
      VRR0(16,109)=V(212)+V(215)+V(216)+QCy*VRR0(16,77)+WQy*VRR1(16,77)
      VRR0(16,110)=3.D0*V(217)+V(218)-3.D0*V(219)+QCy*VRR0(16,78)+WQy*VRR1(16,78)
      VRR0(16,111)=V(65)+3.D0*V(195)-3.D0*V(196)+QCz*VRR0(16,75)+WQz*VRR1(16,75)
      VRR0(16,112)=V(69)+V(198)+V(200)+QCz*VRR0(16,76)+WQz*VRR1(16,76)
      VRR0(16,113)=V(109)+V(204)+V(205)+QCz*VRR0(16,77)+WQz*VRR1(16,77)
      VRR0(16,114)=V(111)+3.D0*V(206)-3.D0*V(207)+QCz*VRR0(16,78)+WQz*VRR1(16,78)
      VRR0(16,115)=4.D0*V(208)-4.D0*V(210)+QCz*VRR0(16,79)+HfxZpE*VRR1(6,79)+WQz*VRR1(16,79)
      VRR0(16,116)=4.D0*V(211)-4.D0*V(214)+QCz*VRR0(16,80)+HfxZpE*VRR1(6,80)+WQz*VRR1(16,80)
      VRR0(16,117)=4.D0*V(217)-4.D0*V(219)+QCz*VRR0(16,81)+HfxZpE*VRR1(6,81)+WQz*VRR1(16,81)
      VRR0(16,118)=5.D0*r1x2E*VRR0(16,54)+QCz*VRR0(16,82)+HfxZpE*VRR1(6,82)-5.D0*r1x2E*ZxZpE*VRR1(16,54)+WQz*VRR1(16,82)
      VRR0(16,119)=5.D0*r1x2E*VRR0(16,55)+QCz*VRR0(16,83)+HfxZpE*VRR1(6,83)-5.D0*r1x2E*ZxZpE*VRR1(16,55)+WQz*VRR1(16,83)
      VRR0(16,120)=6.D0*r1x2E*VRR0(16,56)+QCz*VRR0(16,84)+HfxZpE*VRR1(6,84)-6.D0*r1x2E*ZxZpE*VRR1(16,56)+WQz*VRR1(16,84)
      VRR0(17,85)=6.D0*r1x2E*VRR0(17,36)+QCx*VRR0(17,57)-6.D0*r1x2E*ZxZpE*VRR1(17,36)+WQx*VRR1(17,57)
      VRR0(17,86)=5.D0*r1x2E*VRR0(17,37)+QCx*VRR0(17,58)-5.D0*r1x2E*ZxZpE*VRR1(17,37)+WQx*VRR1(17,58)
      VRR0(17,87)=4.D0*V(220)-4.D0*V(221)+QCx*VRR0(17,59)+WQx*VRR1(17,59)
      VRR0(17,88)=3.D0*V(222)-3.D0*V(223)+QCx*VRR0(17,60)+WQx*VRR1(17,60)
      VRR0(17,89)=2.D0*V(186)+3.D0*V(220)-3.D0*V(221)+QCy*VRR0(17,60)+WQy*VRR1(17,60)
      VRR0(17,90)=4.D0*V(222)-4.D0*V(223)+QCy*VRR0(17,61)+2.D0*HfxZpE*VRR1(9,61)+WQy*VRR1(17,61)
      VRR0(17,91)=5.D0*r1x2E*VRR0(17,40)+QCy*VRR0(17,62)+2.D0*HfxZpE*VRR1(9,62)-5.D0*r1x2E*ZxZpE*VRR1(17,40)+WQy*VRR1(17,62)
      VRR0(17,92)=6.D0*r1x2E*VRR0(17,41)+QCy*VRR0(17,63)+2.D0*HfxZpE*VRR1(9,63)-6.D0*r1x2E*ZxZpE*VRR1(17,41)+WQy*VRR1(17,63)
      VRR0(17,93)=5.D0*r1x2E*VRR0(17,42)+QCx*VRR0(17,64)-5.D0*r1x2E*ZxZpE*VRR1(17,42)+WQx*VRR1(17,64)
      VRR0(17,94)=4.D0*r1x2E*VRR0(17,43)+QCx*VRR0(17,65)-4.D0*r1x2E*ZxZpE*VRR1(17,43)+WQx*VRR1(17,65)
      VRR0(17,95)=V(225)+V(227)+QCx*VRR0(17,66)+WQx*VRR1(17,66)
      VRR0(17,96)=2.D0*V(228)-2.D0*V(229)+QCx*VRR0(17,67)+WQx*VRR1(17,67)
      VRR0(17,97)=2.D0*V(193)+V(225)+V(227)+QCy*VRR0(17,67)+WQy*VRR1(17,67)
      VRR0(17,98)=4.D0*V(228)-4.D0*V(229)+QCy*VRR0(17,68)+2.D0*HfxZpE*VRR1(9,68)+WQy*VRR1(17,68)
      VRR0(17,99)=5.D0*r1x2E*VRR0(17,46)+QCy*VRR0(17,69)+2.D0*HfxZpE*VRR1(9,69)-5.D0*r1x2E*ZxZpE*VRR1(17,46)+WQy*VRR1(17,69)
      VRR0(17,100)=4.D0*V(230)-4.D0*V(231)+QCx*VRR0(17,70)+WQx*VRR1(17,70)
      VRR0(17,101)=V(233)+V(235)+QCx*VRR0(17,71)+WQx*VRR1(17,71)
      VRR0(17,102)=2.D0*V(236)-2.D0*V(237)+QCx*VRR0(17,72)+WQx*VRR1(17,72)
      VRR0(17,103)=2.D0*V(232)-2.D0*V(234)+V(238)+QCy*VRR0(17,72)+WQy*VRR1(17,72)
      VRR0(17,104)=V(239)+V(240)+QCy*VRR0(17,73)+2.D0*HfxZpE*VRR1(9,73)+WQy*VRR1(17,73)
      VRR0(17,105)=4.D0*V(241)-4.D0*V(242)+QCy*VRR0(17,74)+2.D0*HfxZpE*VRR1(9,74)+WQy*VRR1(17,74)
      VRR0(17,106)=3.D0*V(243)-3.D0*V(244)+QCx*VRR0(17,75)+WQx*VRR1(17,75)
      VRR0(17,107)=V(246)+V(248)+QCx*VRR0(17,76)+WQx*VRR1(17,76)
      VRR0(17,108)=V(95)+2.D0*V(224)-2.D0*V(226)+QCz*VRR0(17,72)+WQz*VRR1(17,72)
      VRR0(17,109)=V(246)+V(248)+V(250)+QCy*VRR0(17,77)+WQy*VRR1(17,77)
      VRR0(17,110)=3.D0*V(251)+V(253)-3.D0*V(254)+QCy*VRR0(17,78)+WQy*VRR1(17,78)
      VRR0(17,111)=V(102)+3.D0*V(230)-3.D0*V(231)+QCz*VRR0(17,75)+WQz*VRR1(17,75)
      VRR0(17,112)=V(106)+V(233)+V(235)+QCz*VRR0(17,76)+WQz*VRR1(17,76)
      VRR0(17,113)=V(141)+V(239)+V(240)+QCz*VRR0(17,77)+WQz*VRR1(17,77)
      VRR0(17,114)=V(143)+3.D0*V(241)-3.D0*V(242)+QCz*VRR0(17,78)+WQz*VRR1(17,78)
      VRR0(17,115)=4.D0*V(243)-4.D0*V(244)+QCz*VRR0(17,79)+HfxZpE*VRR1(7,79)+WQz*VRR1(17,79)
      VRR0(17,116)=4.D0*V(245)-4.D0*V(247)+QCz*VRR0(17,80)+HfxZpE*VRR1(7,80)+WQz*VRR1(17,80)
      VRR0(17,117)=4.D0*V(251)-4.D0*V(254)+QCz*VRR0(17,81)+HfxZpE*VRR1(7,81)+WQz*VRR1(17,81)
      VRR0(17,118)=5.D0*r1x2E*VRR0(17,54)+QCz*VRR0(17,82)+HfxZpE*VRR1(7,82)-5.D0*r1x2E*ZxZpE*VRR1(17,54)+WQz*VRR1(17,82)
      VRR0(17,119)=5.D0*r1x2E*VRR0(17,55)+QCz*VRR0(17,83)+HfxZpE*VRR1(7,83)-5.D0*r1x2E*ZxZpE*VRR1(17,55)+WQz*VRR1(17,83)
      VRR0(17,120)=6.D0*r1x2E*VRR0(17,56)+QCz*VRR0(17,84)+HfxZpE*VRR1(7,84)-6.D0*r1x2E*ZxZpE*VRR1(17,56)+WQz*VRR1(17,84)
      VRR0(18,85)=6.D0*r1x2E*VRR0(18,36)+QCx*VRR0(18,57)+HfxZpE*VRR1(10,57)-6.D0*r1x2E*ZxZpE*VRR1(18,36)+WQx*VRR1(18,57)
      VRR0(18,86)=5.D0*r1x2E*VRR0(18,37)+QCx*VRR0(18,58)+HfxZpE*VRR1(10,58)-5.D0*r1x2E*ZxZpE*VRR1(18,37)+WQx*VRR1(18,58)
      VRR0(18,87)=4.D0*V(255)-4.D0*V(256)+QCx*VRR0(18,59)+HfxZpE*VRR1(10,59)+WQx*VRR1(18,59)
      VRR0(18,88)=3.D0*V(257)+V(258)-3.D0*V(259)+QCx*VRR0(18,60)+WQx*VRR1(18,60)
      VRR0(18,89)=3.D0*V(255)-3.D0*V(256)+QCy*VRR0(18,60)+WQy*VRR1(18,60)
      VRR0(18,90)=4.D0*V(257)-4.D0*V(259)+QCy*VRR0(18,61)+WQy*VRR1(18,61)
      VRR0(18,91)=5.D0*r1x2E*VRR0(18,40)+QCy*VRR0(18,62)-5.D0*r1x2E*ZxZpE*VRR1(18,40)+WQy*VRR1(18,62)
      VRR0(18,92)=6.D0*r1x2E*VRR0(18,41)+QCy*VRR0(18,63)-6.D0*r1x2E*ZxZpE*VRR1(18,41)+WQy*VRR1(18,63)
      VRR0(18,93)=5.D0*r1x2E*VRR0(18,42)+QCx*VRR0(18,64)+HfxZpE*VRR1(10,64)-5.D0*r1x2E*ZxZpE*VRR1(18,42)+WQx*VRR1(18,64)
      VRR0(18,94)=4.D0*r1x2E*VRR0(18,43)+QCx*VRR0(18,65)+HfxZpE*VRR1(10,65)-4.D0*r1x2E*ZxZpE*VRR1(18,43)+WQx*VRR1(18,65)
      VRR0(18,95)=V(261)+V(263)+QCx*VRR0(18,66)+HfxZpE*VRR1(10,66)+WQx*VRR1(18,66)
      VRR0(18,96)=2.D0*V(264)+V(265)-2.D0*V(266)+QCx*VRR0(18,67)+WQx*VRR1(18,67)
      VRR0(18,97)=V(261)+V(263)+QCy*VRR0(18,67)+WQy*VRR1(18,67)
      VRR0(18,98)=4.D0*V(264)-4.D0*V(266)+QCy*VRR0(18,68)+WQy*VRR1(18,68)
      VRR0(18,99)=5.D0*r1x2E*VRR0(18,46)+QCy*VRR0(18,69)-5.D0*r1x2E*ZxZpE*VRR1(18,46)+WQy*VRR1(18,69)
      VRR0(18,100)=4.D0*V(267)-4.D0*V(268)+QCx*VRR0(18,70)+HfxZpE*VRR1(10,70)+WQx*VRR1(18,70)
      VRR0(18,101)=V(270)+V(272)+QCx*VRR0(18,71)+HfxZpE*VRR1(10,71)+WQx*VRR1(18,71)
      VRR0(18,102)=2.D0*V(273)+V(274)-2.D0*V(275)+QCx*VRR0(18,72)+WQx*VRR1(18,72)
      VRR0(18,103)=2.D0*V(269)-2.D0*V(271)+QCy*VRR0(18,72)+WQy*VRR1(18,72)
      VRR0(18,104)=V(276)+V(277)+QCy*VRR0(18,73)+WQy*VRR1(18,73)
      VRR0(18,105)=4.D0*V(278)-4.D0*V(279)+QCy*VRR0(18,74)+WQy*VRR1(18,74)
      VRR0(18,106)=3.D0*V(280)+V(281)-3.D0*V(282)+QCx*VRR0(18,75)+WQx*VRR1(18,75)
      VRR0(18,107)=V(284)+V(285)+V(287)+QCx*VRR0(18,76)+WQx*VRR1(18,76)
      VRR0(18,108)=V(165)+2.D0*V(260)-2.D0*V(262)+QCz*VRR0(18,72)+WQz*VRR1(18,72)
      VRR0(18,109)=V(284)+V(287)+QCy*VRR0(18,77)+WQy*VRR1(18,77)
      VRR0(18,110)=3.D0*V(288)-3.D0*V(289)+QCy*VRR0(18,78)+WQy*VRR1(18,78)
      VRR0(18,111)=V(173)+3.D0*V(267)-3.D0*V(268)+QCz*VRR0(18,75)+WQz*VRR1(18,75)
      VRR0(18,112)=V(178)+V(270)+V(272)+QCz*VRR0(18,76)+WQz*VRR1(18,76)
      VRR0(18,113)=2.D0*V(216)+V(276)+V(277)+QCz*VRR0(18,77)+WQz*VRR1(18,77)
      VRR0(18,114)=2.D0*V(218)+3.D0*V(278)-3.D0*V(279)+QCz*VRR0(18,78)+WQz*VRR1(18,78)
      VRR0(18,115)=4.D0*V(280)-4.D0*V(282)+QCz*VRR0(18,79)+2.D0*HfxZpE*VRR1(8,79)+WQz*VRR1(18,79)
      VRR0(18,116)=4.D0*V(283)-4.D0*V(286)+QCz*VRR0(18,80)+2.D0*HfxZpE*VRR1(8,80)+WQz*VRR1(18,80)
      VRR0(18,117)=4.D0*V(288)-4.D0*V(289)+QCz*VRR0(18,81)+2.D0*HfxZpE*VRR1(8,81)+WQz*VRR1(18,81)
      VRR0(18,118)=5.D0*r1x2E*VRR0(18,54)+QCz*VRR0(18,82)+2.D0*HfxZpE*VRR1(8,82)-5.D0*r1x2E*ZxZpE*VRR1(18,54)+WQz*VRR1(18,82)
      VRR0(18,119)=5.D0*r1x2E*VRR0(18,55)+QCz*VRR0(18,83)+2.D0*HfxZpE*VRR1(8,83)-5.D0*r1x2E*ZxZpE*VRR1(18,55)+WQz*VRR1(18,83)
      VRR0(18,120)=6.D0*r1x2E*VRR0(18,56)+QCz*VRR0(18,84)+2.D0*HfxZpE*VRR1(8,84)-6.D0*r1x2E*ZxZpE*VRR1(18,56)+WQz*VRR1(18,84)
      VRR0(19,85)=6.D0*r1x2E*VRR0(19,36)+QCx*VRR0(19,57)-6.D0*r1x2E*ZxZpE*VRR1(19,36)+WQx*VRR1(19,57)
      VRR0(19,86)=5.D0*r1x2E*VRR0(19,37)+QCx*VRR0(19,58)-5.D0*r1x2E*ZxZpE*VRR1(19,37)+WQx*VRR1(19,58)
      VRR0(19,87)=4.D0*V(290)-4.D0*V(291)+QCx*VRR0(19,59)+WQx*VRR1(19,59)
      VRR0(19,88)=3.D0*V(292)-3.D0*V(293)+QCx*VRR0(19,60)+WQx*VRR1(19,60)
      VRR0(19,89)=V(258)+3.D0*V(290)-3.D0*V(291)+QCy*VRR0(19,60)+WQy*VRR1(19,60)
      VRR0(19,90)=4.D0*V(292)-4.D0*V(293)+QCy*VRR0(19,61)+HfxZpE*VRR1(10,61)+WQy*VRR1(19,61)
      VRR0(19,91)=5.D0*r1x2E*VRR0(19,40)+QCy*VRR0(19,62)+HfxZpE*VRR1(10,62)-5.D0*r1x2E*ZxZpE*VRR1(19,40)+WQy*VRR1(19,62)
      VRR0(19,92)=6.D0*r1x2E*VRR0(19,41)+QCy*VRR0(19,63)+HfxZpE*VRR1(10,63)-6.D0*r1x2E*ZxZpE*VRR1(19,41)+WQy*VRR1(19,63)
      VRR0(19,93)=5.D0*r1x2E*VRR0(19,42)+QCx*VRR0(19,64)-5.D0*r1x2E*ZxZpE*VRR1(19,42)+WQx*VRR1(19,64)
      VRR0(19,94)=4.D0*r1x2E*VRR0(19,43)+QCx*VRR0(19,65)-4.D0*r1x2E*ZxZpE*VRR1(19,43)+WQx*VRR1(19,65)
      VRR0(19,95)=V(295)+V(297)+QCx*VRR0(19,66)+WQx*VRR1(19,66)
      VRR0(19,96)=2.D0*V(298)-2.D0*V(299)+QCx*VRR0(19,67)+WQx*VRR1(19,67)
      VRR0(19,97)=V(265)+V(295)+V(297)+QCy*VRR0(19,67)+WQy*VRR1(19,67)
      VRR0(19,98)=4.D0*V(298)-4.D0*V(299)+QCy*VRR0(19,68)+HfxZpE*VRR1(10,68)+WQy*VRR1(19,68)
      VRR0(19,99)=5.D0*r1x2E*VRR0(19,46)+QCy*VRR0(19,69)+HfxZpE*VRR1(10,69)-5.D0*r1x2E*ZxZpE*VRR1(19,46)+WQy*VRR1(19,69)
      VRR0(19,100)=4.D0*V(300)-4.D0*V(301)+QCx*VRR0(19,70)+WQx*VRR1(19,70)
      VRR0(19,101)=V(303)+V(305)+QCx*VRR0(19,71)+WQx*VRR1(19,71)
      VRR0(19,102)=2.D0*V(306)-2.D0*V(307)+QCx*VRR0(19,72)+WQx*VRR1(19,72)
      VRR0(19,103)=V(274)+2.D0*V(302)-2.D0*V(304)+QCy*VRR0(19,72)+WQy*VRR1(19,72)
      VRR0(19,104)=V(308)+V(309)+QCy*VRR0(19,73)+HfxZpE*VRR1(10,73)+WQy*VRR1(19,73)
      VRR0(19,105)=4.D0*V(310)-4.D0*V(311)+QCy*VRR0(19,74)+HfxZpE*VRR1(10,74)+WQy*VRR1(19,74)
      VRR0(19,106)=3.D0*V(312)-3.D0*V(313)+QCx*VRR0(19,75)+WQx*VRR1(19,75)
      VRR0(19,107)=V(315)+V(317)+QCx*VRR0(19,76)+WQx*VRR1(19,76)
      VRR0(19,108)=V(238)+2.D0*V(294)-2.D0*V(296)+QCz*VRR0(19,72)+WQz*VRR1(19,72)
      VRR0(19,109)=V(315)+V(317)+V(318)+QCy*VRR0(19,77)+WQy*VRR1(19,77)
      VRR0(19,110)=3.D0*V(319)+V(320)-3.D0*V(321)+QCy*VRR0(19,78)+WQy*VRR1(19,78)
      VRR0(19,111)=2.D0*V(209)+3.D0*V(300)-3.D0*V(301)+QCz*VRR0(19,75)+WQz*VRR1(19,75)
      VRR0(19,112)=2.D0*V(213)+V(303)+V(305)+QCz*VRR0(19,76)+WQz*VRR1(19,76)
      VRR0(19,113)=V(250)+V(308)+V(309)+QCz*VRR0(19,77)+WQz*VRR1(19,77)
      VRR0(19,114)=V(253)+3.D0*V(310)-3.D0*V(311)+QCz*VRR0(19,78)+WQz*VRR1(19,78)
      VRR0(19,115)=4.D0*V(312)-4.D0*V(313)+QCz*VRR0(19,79)+2.D0*HfxZpE*VRR1(9,79)+WQz*VRR1(19,79)
      VRR0(19,116)=4.D0*V(314)-4.D0*V(316)+QCz*VRR0(19,80)+2.D0*HfxZpE*VRR1(9,80)+WQz*VRR1(19,80)
      VRR0(19,117)=4.D0*V(319)-4.D0*V(321)+QCz*VRR0(19,81)+2.D0*HfxZpE*VRR1(9,81)+WQz*VRR1(19,81)
      VRR0(19,118)=5.D0*r1x2E*VRR0(19,54)+QCz*VRR0(19,82)+2.D0*HfxZpE*VRR1(9,82)-5.D0*r1x2E*ZxZpE*VRR1(19,54)+WQz*VRR1(19,82)
      VRR0(19,119)=5.D0*r1x2E*VRR0(19,55)+QCz*VRR0(19,83)+2.D0*HfxZpE*VRR1(9,83)-5.D0*r1x2E*ZxZpE*VRR1(19,55)+WQz*VRR1(19,83)
      VRR0(19,120)=6.D0*r1x2E*VRR0(19,56)+QCz*VRR0(19,84)+2.D0*HfxZpE*VRR1(9,84)-6.D0*r1x2E*ZxZpE*VRR1(19,56)+WQz*VRR1(19,84)
      VRR0(20,85)=6.D0*r1x2E*VRR0(20,36)+QCx*VRR0(20,57)-6.D0*r1x2E*ZxZpE*VRR1(20,36)+WQx*VRR1(20,57)
      VRR0(20,86)=5.D0*r1x2E*VRR0(20,37)+QCx*VRR0(20,58)-5.D0*r1x2E*ZxZpE*VRR1(20,37)+WQx*VRR1(20,58)
      VRR0(20,87)=4.D0*V(322)-4.D0*V(323)+QCx*VRR0(20,59)+WQx*VRR1(20,59)
      VRR0(20,88)=3.D0*V(324)-3.D0*V(325)+QCx*VRR0(20,60)+WQx*VRR1(20,60)
      VRR0(20,89)=3.D0*V(322)-3.D0*V(323)+QCy*VRR0(20,60)+WQy*VRR1(20,60)
      VRR0(20,90)=4.D0*V(324)-4.D0*V(325)+QCy*VRR0(20,61)+WQy*VRR1(20,61)
      VRR0(20,91)=5.D0*r1x2E*VRR0(20,40)+QCy*VRR0(20,62)-5.D0*r1x2E*ZxZpE*VRR1(20,40)+WQy*VRR1(20,62)
      VRR0(20,92)=6.D0*r1x2E*VRR0(20,41)+QCy*VRR0(20,63)-6.D0*r1x2E*ZxZpE*VRR1(20,41)+WQy*VRR1(20,63)
      VRR0(20,93)=5.D0*r1x2E*VRR0(20,42)+QCx*VRR0(20,64)-5.D0*r1x2E*ZxZpE*VRR1(20,42)+WQx*VRR1(20,64)
      VRR0(20,94)=4.D0*r1x2E*VRR0(20,43)+QCx*VRR0(20,65)-4.D0*r1x2E*ZxZpE*VRR1(20,43)+WQx*VRR1(20,65)
      VRR0(20,95)=V(327)+V(329)+QCx*VRR0(20,66)+WQx*VRR1(20,66)
      VRR0(20,96)=2.D0*V(330)-2.D0*V(331)+QCx*VRR0(20,67)+WQx*VRR1(20,67)
      VRR0(20,97)=V(327)+V(329)+QCy*VRR0(20,67)+WQy*VRR1(20,67)
      VRR0(20,98)=4.D0*V(330)-4.D0*V(331)+QCy*VRR0(20,68)+WQy*VRR1(20,68)
      VRR0(20,99)=5.D0*r1x2E*VRR0(20,46)+QCy*VRR0(20,69)-5.D0*r1x2E*ZxZpE*VRR1(20,46)+WQy*VRR1(20,69)
      VRR0(20,100)=4.D0*V(332)-4.D0*V(333)+QCx*VRR0(20,70)+WQx*VRR1(20,70)
      VRR0(20,101)=V(335)+V(337)+QCx*VRR0(20,71)+WQx*VRR1(20,71)
      VRR0(20,102)=2.D0*V(338)-2.D0*V(339)+QCx*VRR0(20,72)+WQx*VRR1(20,72)
      VRR0(20,103)=2.D0*V(334)-2.D0*V(336)+QCy*VRR0(20,72)+WQy*VRR1(20,72)
      VRR0(20,104)=V(340)+V(341)+QCy*VRR0(20,73)+WQy*VRR1(20,73)
      VRR0(20,105)=4.D0*V(342)-4.D0*V(343)+QCy*VRR0(20,74)+WQy*VRR1(20,74)
      VRR0(20,106)=3.D0*V(344)-3.D0*V(345)+QCx*VRR0(20,75)+WQx*VRR1(20,75)
      VRR0(20,107)=V(347)+V(349)+QCx*VRR0(20,76)+WQx*VRR1(20,76)
      VRR0(20,108)=3.D0*V(274)+2.D0*V(326)-2.D0*V(328)+QCz*VRR0(20,72)+WQz*VRR1(20,72)
      VRR0(20,109)=V(347)+V(349)+QCy*VRR0(20,77)+WQy*VRR1(20,77)
      VRR0(20,110)=3.D0*V(350)-3.D0*V(351)+QCy*VRR0(20,78)+WQy*VRR1(20,78)
      VRR0(20,111)=3.D0*V(281)+3.D0*V(332)-3.D0*V(333)+QCz*VRR0(20,75)+WQz*VRR1(20,75)
      VRR0(20,112)=3.D0*V(285)+V(335)+V(337)+QCz*VRR0(20,76)+WQz*VRR1(20,76)
      VRR0(20,113)=3.D0*V(318)+V(340)+V(341)+QCz*VRR0(20,77)+WQz*VRR1(20,77)
      VRR0(20,114)=3.D0*V(320)+3.D0*V(342)-3.D0*V(343)+QCz*VRR0(20,78)+WQz*VRR1(20,78)
      VRR0(20,115)=4.D0*V(344)-4.D0*V(345)+QCz*VRR0(20,79)+3.D0*HfxZpE*VRR1(10,79)+WQz*VRR1(20,79)
      VRR0(20,116)=4.D0*V(346)-4.D0*V(348)+QCz*VRR0(20,80)+3.D0*HfxZpE*VRR1(10,80)+WQz*VRR1(20,80)
      VRR0(20,117)=4.D0*V(350)-4.D0*V(351)+QCz*VRR0(20,81)+3.D0*HfxZpE*VRR1(10,81)+WQz*VRR1(20,81)
      VRR0(20,118)=5.D0*r1x2E*VRR0(20,54)+QCz*VRR0(20,82)+3.D0*HfxZpE*VRR1(10,82)-5.D0*r1x2E*ZxZpE*VRR1(20,54)+WQz*VRR1(20,82)
      VRR0(20,119)=5.D0*r1x2E*VRR0(20,55)+QCz*VRR0(20,83)+3.D0*HfxZpE*VRR1(10,83)-5.D0*r1x2E*ZxZpE*VRR1(20,55)+WQz*VRR1(20,83)
      VRR0(20,120)=6.D0*r1x2E*VRR0(20,56)+QCz*VRR0(20,84)+3.D0*HfxZpE*VRR1(10,84)-6.D0*r1x2E*ZxZpE*VRR1(20,56)+WQz*VRR1(20,84)
END SUBROUTINE VRRf0j0
