!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRj0h0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(58,25)
      V(2)=HfxZpE*VRR1(58,35)
      V(3)=r1x2Z*VRR0(38,38)
      V(4)=ExZpE*r1x2Z*VRR1(38,38)
      V(5)=r1x2Z*VRR0(38,39)
      V(6)=ExZpE*r1x2Z*VRR1(38,39)
      V(7)=HfxZpE*VRR1(59,24)
      V(8)=HfxZpE*VRR1(59,25)
      V(9)=r1x2Z*VRR0(38,43)
      V(10)=ExZpE*r1x2Z*VRR1(38,43)
      V(11)=r1x2Z*VRR0(38,44)
      V(12)=ExZpE*r1x2Z*VRR1(38,44)
      V(13)=r1x2Z*VRR0(38,45)
      V(14)=ExZpE*r1x2Z*VRR1(38,45)
      V(15)=HfxZpE*VRR1(59,29)
      V(16)=r1x2Z*VRR0(38,47)
      V(17)=ExZpE*r1x2Z*VRR1(38,47)
      V(18)=r1x2Z*VRR0(38,48)
      V(19)=ExZpE*r1x2Z*VRR1(38,48)
      V(20)=r1x2Z*VRR0(38,49)
      V(21)=ExZpE*r1x2Z*VRR1(38,49)
      V(22)=r1x2Z*VRR0(38,50)
      V(23)=ExZpE*r1x2Z*VRR1(38,50)
      V(24)=r1x2Z*VRR0(38,51)
      V(25)=ExZpE*r1x2Z*VRR1(38,51)
      V(26)=HfxZpE*VRR1(59,33)
      V(27)=r1x2Z*VRR0(38,52)
      V(28)=ExZpE*r1x2Z*VRR1(38,52)
      V(29)=HfxZpE*VRR1(59,34)
      V(30)=r1x2Z*VRR0(38,53)
      V(31)=ExZpE*r1x2Z*VRR1(38,53)
      V(32)=HfxZpE*VRR1(59,35)
      V(33)=HfxZpE*VRR1(60,22)
      V(34)=r1x2Z*VRR0(39,38)
      V(35)=ExZpE*r1x2Z*VRR1(39,38)
      V(36)=HfxZpE*VRR1(60,23)
      V(37)=3.D0*V(36)
      V(38)=r1x2Z*VRR0(39,39)
      V(39)=ExZpE*r1x2Z*VRR1(39,39)
      V(40)=HfxZpE*VRR1(60,24)
      V(41)=HfxZpE*VRR1(60,26)
      V(42)=r1x2Z*VRR0(39,43)
      V(43)=ExZpE*r1x2Z*VRR1(39,43)
      V(44)=HfxZpE*VRR1(60,27)
      V(45)=r1x2Z*VRR0(39,44)
      V(46)=ExZpE*r1x2Z*VRR1(39,44)
      V(47)=HfxZpE*VRR1(60,28)
      V(48)=r1x2Z*VRR0(39,45)
      V(49)=ExZpE*r1x2Z*VRR1(39,45)
      V(50)=HfxZpE*VRR1(60,29)
      V(51)=r1x2Z*VRR0(39,47)
      V(52)=ExZpE*r1x2Z*VRR1(39,47)
      V(53)=HfxZpE*VRR1(60,30)
      V(54)=r1x2Z*VRR0(39,48)
      V(55)=ExZpE*r1x2Z*VRR1(39,48)
      V(56)=HfxZpE*VRR1(60,31)
      V(57)=2.D0*V(56)
      V(58)=r1x2Z*VRR0(39,49)
      V(59)=ExZpE*r1x2Z*VRR1(39,49)
      V(60)=HfxZpE*VRR1(60,32)
      V(61)=r1x2Z*VRR0(39,50)
      V(62)=ExZpE*r1x2Z*VRR1(39,50)
      V(63)=r1x2Z*VRR0(39,51)
      V(64)=ExZpE*r1x2Z*VRR1(39,51)
      V(65)=HfxZpE*VRR1(60,33)
      V(66)=r1x2Z*VRR0(39,52)
      V(67)=ExZpE*r1x2Z*VRR1(39,52)
      V(68)=HfxZpE*VRR1(60,34)
      V(69)=r1x2Z*VRR0(39,53)
      V(70)=ExZpE*r1x2Z*VRR1(39,53)
      V(71)=HfxZpE*VRR1(61,21)
      V(72)=HfxZpE*VRR1(61,22)
      V(73)=HfxZpE*VRR1(61,26)
      V(74)=HfxZpE*VRR1(62,21)
      V(75)=HfxZpE*VRR1(61,33)
      V(76)=HfxZpE*VRR1(61,34)
      V(77)=HfxZpE*VRR1(61,35)
      V(78)=HfxZpE*VRR1(62,35)
      V(79)=HfxZpE*VRR1(64,25)
      V(80)=HfxZpE*VRR1(64,35)
      V(81)=HfxZpE*VRR1(65,24)
      V(82)=2.D0*V(81)
      V(83)=HfxZpE*VRR1(65,25)
      V(84)=HfxZpE*VRR1(65,29)
      V(85)=HfxZpE*VRR1(65,33)
      V(86)=2.D0*V(85)
      V(87)=HfxZpE*VRR1(65,34)
      V(88)=HfxZpE*VRR1(65,35)
      V(89)=r1x2Z*VRR0(44,38)
      V(90)=3.D0*V(89)
      V(91)=ExZpE*r1x2Z*VRR1(44,38)
      V(92)=-3.D0*V(91)
      V(93)=HfxZpE*VRR1(66,23)
      V(94)=3.D0*V(93)
      V(95)=r1x2Z*VRR0(44,39)
      V(96)=3.D0*V(95)
      V(97)=ExZpE*r1x2Z*VRR1(44,39)
      V(98)=-3.D0*V(97)
      V(99)=HfxZpE*VRR1(66,24)
      V(100)=r1x2Z*VRR0(44,43)
      V(101)=3.D0*V(100)
      V(102)=ExZpE*r1x2Z*VRR1(44,43)
      V(103)=-3.D0*V(102)
      V(104)=r1x2Z*VRR0(44,44)
      V(105)=3.D0*V(104)
      V(106)=ExZpE*r1x2Z*VRR1(44,44)
      V(107)=-3.D0*V(106)
      V(108)=HfxZpE*VRR1(66,28)
      V(109)=r1x2Z*VRR0(44,45)
      V(110)=3.D0*V(109)
      V(111)=ExZpE*r1x2Z*VRR1(44,45)
      V(112)=-3.D0*V(111)
      V(113)=HfxZpE*VRR1(66,29)
      V(114)=r1x2Z*VRR0(44,47)
      V(115)=3.D0*V(114)
      V(116)=ExZpE*r1x2Z*VRR1(44,47)
      V(117)=-3.D0*V(116)
      V(118)=HfxZpE*VRR1(66,30)
      V(119)=r1x2Z*VRR0(44,48)
      V(120)=3.D0*V(119)
      V(121)=ExZpE*r1x2Z*VRR1(44,48)
      V(122)=-3.D0*V(121)
      V(123)=HfxZpE*VRR1(66,31)
      V(124)=2.D0*V(123)
      V(125)=r1x2Z*VRR0(44,49)
      V(126)=3.D0*V(125)
      V(127)=ExZpE*r1x2Z*VRR1(44,49)
      V(128)=-3.D0*V(127)
      V(129)=HfxZpE*VRR1(66,32)
      V(130)=r1x2Z*VRR0(44,50)
      V(131)=3.D0*V(130)
      V(132)=ExZpE*r1x2Z*VRR1(44,50)
      V(133)=-3.D0*V(132)
      V(134)=r1x2Z*VRR0(44,51)
      V(135)=3.D0*V(134)
      V(136)=ExZpE*r1x2Z*VRR1(44,51)
      V(137)=-3.D0*V(136)
      V(138)=HfxZpE*VRR1(66,33)
      V(139)=2.D0*V(138)
      V(140)=r1x2Z*VRR0(44,52)
      V(141)=3.D0*V(140)
      V(142)=ExZpE*r1x2Z*VRR1(44,52)
      V(143)=-3.D0*V(142)
      V(144)=HfxZpE*VRR1(66,34)
      V(145)=r1x2Z*VRR0(44,53)
      V(146)=3.D0*V(145)
      V(147)=ExZpE*r1x2Z*VRR1(44,53)
      V(148)=-3.D0*V(147)
      V(149)=r1x2E*VRR0(96,12)
      V(150)=HfxZpE*VRR1(67,22)
      V(151)=r1x2E*ZxZpE*VRR1(96,12)
      V(152)=r1x2E*VRR0(96,13)
      V(153)=HfxZpE*VRR1(67,23)
      V(154)=3.D0*V(153)
      V(155)=r1x2E*ZxZpE*VRR1(96,13)
      V(156)=r1x2E*VRR0(96,15)
      V(157)=HfxZpE*VRR1(67,26)
      V(158)=r1x2E*ZxZpE*VRR1(96,15)
      V(159)=r1x2E*VRR0(96,16)
      V(160)=2.D0*V(159)
      V(161)=HfxZpE*VRR1(67,27)
      V(162)=r1x2E*ZxZpE*VRR1(96,16)
      V(163)=-2.D0*V(162)
      V(164)=r1x2Z*VRR0(45,44)
      V(165)=ExZpE*r1x2Z*VRR1(45,44)
      V(166)=HfxZpE*VRR1(67,28)
      V(167)=r1x2E*VRR0(96,17)
      V(168)=r1x2E*ZxZpE*VRR1(96,17)
      V(169)=r1x2E*VRR0(96,18)
      V(170)=HfxZpE*VRR1(67,30)
      V(171)=r1x2E*ZxZpE*VRR1(96,18)
      V(172)=r1x2Z*VRR0(45,48)
      V(173)=ExZpE*r1x2Z*VRR1(45,48)
      V(174)=HfxZpE*VRR1(67,31)
      V(175)=2.D0*V(174)
      V(176)=r1x2Z*VRR0(45,49)
      V(177)=ExZpE*r1x2Z*VRR1(45,49)
      V(178)=HfxZpE*VRR1(67,32)
      V(179)=r1x2E*VRR0(96,19)
      V(180)=r1x2E*ZxZpE*VRR1(96,19)
      V(181)=HfxZpE*VRR1(68,21)
      V(182)=HfxZpE*VRR1(68,22)
      V(183)=2.D0*V(182)
      V(184)=HfxZpE*VRR1(68,26)
      V(185)=HfxZpE*VRR1(67,33)
      V(186)=HfxZpE*VRR1(67,34)
      V(187)=2.D0*V(186)
      V(188)=HfxZpE*VRR1(69,21)
      V(189)=HfxZpE*VRR1(68,33)
      V(190)=HfxZpE*VRR1(68,34)
      V(191)=2.D0*V(190)
      V(192)=HfxZpE*VRR1(68,35)
      V(193)=HfxZpE*VRR1(69,35)
      V(194)=r1x2Z*VRR0(47,38)
      V(195)=ExZpE*r1x2Z*VRR1(47,38)
      V(196)=r1x2Z*VRR0(47,39)
      V(197)=ExZpE*r1x2Z*VRR1(47,39)
      V(198)=HfxZpE*VRR1(70,24)
      V(199)=HfxZpE*VRR1(70,25)
      V(200)=r1x2Z*VRR0(47,43)
      V(201)=ExZpE*r1x2Z*VRR1(47,43)
      V(202)=r1x2Z*VRR0(47,44)
      V(203)=ExZpE*r1x2Z*VRR1(47,44)
      V(204)=r1x2Z*VRR0(47,45)
      V(205)=ExZpE*r1x2Z*VRR1(47,45)
      V(206)=HfxZpE*VRR1(70,29)
      V(207)=r1x2Z*VRR0(47,47)
      V(208)=ExZpE*r1x2Z*VRR1(47,47)
      V(209)=r1x2Z*VRR0(47,48)
      V(210)=ExZpE*r1x2Z*VRR1(47,48)
      V(211)=r1x2Z*VRR0(47,49)
      V(212)=ExZpE*r1x2Z*VRR1(47,49)
      V(213)=r1x2Z*VRR0(47,50)
      V(214)=ExZpE*r1x2Z*VRR1(47,50)
      V(215)=r1x2Z*VRR0(47,51)
      V(216)=ExZpE*r1x2Z*VRR1(47,51)
      V(217)=HfxZpE*VRR1(70,33)
      V(218)=r1x2Z*VRR0(47,52)
      V(219)=ExZpE*r1x2Z*VRR1(47,52)
      V(220)=HfxZpE*VRR1(70,34)
      V(221)=r1x2Z*VRR0(47,53)
      V(222)=ExZpE*r1x2Z*VRR1(47,53)
      V(223)=HfxZpE*VRR1(70,35)
      V(224)=r1x2Z*VRR0(48,38)
      V(225)=3.D0*V(224)
      V(226)=ExZpE*r1x2Z*VRR1(48,38)
      V(227)=-3.D0*V(226)
      V(228)=HfxZpE*VRR1(71,23)
      V(229)=r1x2Z*VRR0(48,39)
      V(230)=3.D0*V(229)
      V(231)=ExZpE*r1x2Z*VRR1(48,39)
      V(232)=-3.D0*V(231)
      V(233)=HfxZpE*VRR1(71,24)
      V(234)=2.D0*V(233)
      V(235)=r1x2Z*VRR0(48,43)
      V(236)=3.D0*V(235)
      V(237)=ExZpE*r1x2Z*VRR1(48,43)
      V(238)=-3.D0*V(237)
      V(239)=r1x2Z*VRR0(48,44)
      V(240)=3.D0*V(239)
      V(241)=ExZpE*r1x2Z*VRR1(48,44)
      V(242)=-3.D0*V(241)
      V(243)=HfxZpE*VRR1(71,28)
      V(244)=2.D0*V(243)
      V(245)=r1x2Z*VRR0(48,45)
      V(246)=3.D0*V(245)
      V(247)=ExZpE*r1x2Z*VRR1(48,45)
      V(248)=-3.D0*V(247)
      V(249)=HfxZpE*VRR1(71,29)
      V(250)=r1x2Z*VRR0(48,47)
      V(251)=3.D0*V(250)
      V(252)=ExZpE*r1x2Z*VRR1(48,47)
      V(253)=-3.D0*V(252)
      V(254)=HfxZpE*VRR1(71,30)
      V(255)=3.D0*V(254)
      V(256)=r1x2Z*VRR0(48,48)
      V(257)=3.D0*V(256)
      V(258)=ExZpE*r1x2Z*VRR1(48,48)
      V(259)=-3.D0*V(258)
      V(260)=HfxZpE*VRR1(71,31)
      V(261)=r1x2Z*VRR0(48,49)
      V(262)=3.D0*V(261)
      V(263)=ExZpE*r1x2Z*VRR1(48,49)
      V(264)=-3.D0*V(263)
      V(265)=HfxZpE*VRR1(71,32)
      V(266)=r1x2Z*VRR0(48,50)
      V(267)=3.D0*V(266)
      V(268)=ExZpE*r1x2Z*VRR1(48,50)
      V(269)=-3.D0*V(268)
      V(270)=r1x2Z*VRR0(48,51)
      V(271)=3.D0*V(270)
      V(272)=ExZpE*r1x2Z*VRR1(48,51)
      V(273)=-3.D0*V(272)
      V(274)=HfxZpE*VRR1(71,33)
      V(275)=r1x2Z*VRR0(48,52)
      V(276)=3.D0*V(275)
      V(277)=ExZpE*r1x2Z*VRR1(48,52)
      V(278)=-3.D0*V(277)
      V(279)=HfxZpE*VRR1(71,34)
      V(280)=r1x2Z*VRR0(48,53)
      V(281)=3.D0*V(280)
      V(282)=ExZpE*r1x2Z*VRR1(48,53)
      V(283)=-3.D0*V(282)
      V(284)=r1x2E*VRR0(102,12)
      V(285)=r1x2E*ZxZpE*VRR1(102,12)
      V(286)=r1x2E*VRR0(102,13)
      V(287)=HfxZpE*VRR1(72,23)
      V(288)=3.D0*V(287)
      V(289)=r1x2E*ZxZpE*VRR1(102,13)
      V(290)=r1x2E*VRR0(102,15)
      V(291)=r1x2E*ZxZpE*VRR1(102,15)
      V(292)=r1x2E*VRR0(102,16)
      V(293)=2.D0*V(292)
      V(294)=HfxZpE*VRR1(72,27)
      V(295)=r1x2E*ZxZpE*VRR1(102,16)
      V(296)=-2.D0*V(295)
      V(297)=r1x2Z*VRR0(49,44)
      V(298)=ExZpE*r1x2Z*VRR1(49,44)
      V(299)=HfxZpE*VRR1(72,28)
      V(300)=2.D0*V(299)
      V(301)=r1x2E*VRR0(102,17)
      V(302)=r1x2E*ZxZpE*VRR1(102,17)
      V(303)=r1x2E*VRR0(102,18)
      V(304)=HfxZpE*VRR1(72,30)
      V(305)=3.D0*V(304)
      V(306)=r1x2E*ZxZpE*VRR1(102,18)
      V(307)=r1x2Z*VRR0(49,48)
      V(308)=ExZpE*r1x2Z*VRR1(49,48)
      V(309)=HfxZpE*VRR1(72,31)
      V(310)=2.D0*V(309)
      V(311)=r1x2Z*VRR0(49,49)
      V(312)=ExZpE*r1x2Z*VRR1(49,49)
      V(313)=HfxZpE*VRR1(72,32)
      V(314)=r1x2E*VRR0(102,19)
      V(315)=r1x2E*ZxZpE*VRR1(102,19)
      V(316)=r1x2E*VRR0(103,12)
      V(317)=HfxZpE*VRR1(73,22)
      V(318)=2.D0*V(317)
      V(319)=r1x2E*ZxZpE*VRR1(103,12)
      V(320)=r1x2E*VRR0(103,13)
      V(321)=HfxZpE*VRR1(73,23)
      V(322)=r1x2E*ZxZpE*VRR1(103,13)
      V(323)=r1x2E*VRR0(103,15)
      V(324)=HfxZpE*VRR1(73,26)
      V(325)=r1x2E*ZxZpE*VRR1(103,15)
      V(326)=r1x2E*VRR0(103,16)
      V(327)=2.D0*V(326)
      V(328)=HfxZpE*VRR1(73,27)
      V(329)=2.D0*V(328)
      V(330)=r1x2E*ZxZpE*VRR1(103,16)
      V(331)=-2.D0*V(330)
      V(332)=2.D0*V(294)
      V(333)=r1x2E*VRR0(103,17)
      V(334)=r1x2E*ZxZpE*VRR1(103,17)
      V(335)=r1x2E*VRR0(103,18)
      V(336)=HfxZpE*VRR1(73,30)
      V(337)=r1x2E*ZxZpE*VRR1(103,18)
      V(338)=r1x2E*VRR0(103,19)
      V(339)=3.D0*V(313)
      V(340)=r1x2E*ZxZpE*VRR1(103,19)
      V(341)=HfxZpE*VRR1(74,21)
      V(342)=HfxZpE*VRR1(74,22)
      V(343)=r1x2Z*VRR0(49,38)
      V(344)=3.D0*V(343)
      V(345)=ExZpE*r1x2Z*VRR1(49,38)
      V(346)=-3.D0*V(345)
      V(347)=r1x2Z*VRR0(49,39)
      V(348)=3.D0*V(347)
      V(349)=ExZpE*r1x2Z*VRR1(49,39)
      V(350)=-3.D0*V(349)
      V(351)=HfxZpE*VRR1(74,26)
      V(352)=r1x2Z*VRR0(49,43)
      V(353)=3.D0*V(352)
      V(354)=ExZpE*r1x2Z*VRR1(49,43)
      V(355)=-3.D0*V(354)
      V(356)=3.D0*V(297)
      V(357)=-3.D0*V(298)
      V(358)=r1x2Z*VRR0(49,45)
      V(359)=3.D0*V(358)
      V(360)=ExZpE*r1x2Z*VRR1(49,45)
      V(361)=-3.D0*V(360)
      V(362)=r1x2Z*VRR0(49,47)
      V(363)=3.D0*V(362)
      V(364)=ExZpE*r1x2Z*VRR1(49,47)
      V(365)=-3.D0*V(364)
      V(366)=3.D0*V(307)
      V(367)=-3.D0*V(308)
      V(368)=3.D0*V(311)
      V(369)=-3.D0*V(312)
      V(370)=HfxZpE*VRR1(73,31)
      V(371)=r1x2Z*VRR0(49,50)
      V(372)=3.D0*V(371)
      V(373)=ExZpE*r1x2Z*VRR1(49,50)
      V(374)=-3.D0*V(373)
      V(375)=HfxZpE*VRR1(73,32)
      V(376)=3.D0*V(375)
      V(377)=r1x2Z*VRR0(49,51)
      V(378)=3.D0*V(377)
      V(379)=ExZpE*r1x2Z*VRR1(49,51)
      V(380)=-3.D0*V(379)
      V(381)=r1x2Z*VRR0(49,52)
      V(382)=3.D0*V(381)
      V(383)=ExZpE*r1x2Z*VRR1(49,52)
      V(384)=-3.D0*V(383)
      V(385)=HfxZpE*VRR1(73,33)
      V(386)=r1x2Z*VRR0(49,53)
      V(387)=3.D0*V(386)
      V(388)=ExZpE*r1x2Z*VRR1(49,53)
      V(389)=-3.D0*V(388)
      V(390)=HfxZpE*VRR1(73,34)
      V(391)=r1x2Z*VRR0(50,38)
      V(392)=ExZpE*r1x2Z*VRR1(50,38)
      V(393)=r1x2Z*VRR0(50,39)
      V(394)=ExZpE*r1x2Z*VRR1(50,39)
      V(395)=r1x2Z*VRR0(50,43)
      V(396)=ExZpE*r1x2Z*VRR1(50,43)
      V(397)=r1x2Z*VRR0(50,44)
      V(398)=ExZpE*r1x2Z*VRR1(50,44)
      V(399)=r1x2Z*VRR0(50,45)
      V(400)=ExZpE*r1x2Z*VRR1(50,45)
      V(401)=r1x2Z*VRR0(50,47)
      V(402)=ExZpE*r1x2Z*VRR1(50,47)
      V(403)=r1x2Z*VRR0(50,48)
      V(404)=ExZpE*r1x2Z*VRR1(50,48)
      V(405)=r1x2Z*VRR0(50,49)
      V(406)=ExZpE*r1x2Z*VRR1(50,49)
      V(407)=r1x2Z*VRR0(50,50)
      V(408)=ExZpE*r1x2Z*VRR1(50,50)
      V(409)=r1x2Z*VRR0(50,51)
      V(410)=ExZpE*r1x2Z*VRR1(50,51)
      V(411)=r1x2Z*VRR0(50,52)
      V(412)=ExZpE*r1x2Z*VRR1(50,52)
      V(413)=HfxZpE*VRR1(74,33)
      V(414)=r1x2Z*VRR0(50,53)
      V(415)=ExZpE*r1x2Z*VRR1(50,53)
      V(416)=HfxZpE*VRR1(74,34)
      V(417)=HfxZpE*VRR1(74,35)
      V(418)=HfxZpE*VRR1(75,22)
      V(419)=r1x2Z*VRR0(51,38)
      V(420)=ExZpE*r1x2Z*VRR1(51,38)
      V(421)=HfxZpE*VRR1(75,23)
      V(422)=r1x2Z*VRR0(51,39)
      V(423)=ExZpE*r1x2Z*VRR1(51,39)
      V(424)=HfxZpE*VRR1(75,24)
      V(425)=HfxZpE*VRR1(75,26)
      V(426)=r1x2Z*VRR0(51,43)
      V(427)=ExZpE*r1x2Z*VRR1(51,43)
      V(428)=HfxZpE*VRR1(75,27)
      V(429)=r1x2Z*VRR0(51,44)
      V(430)=ExZpE*r1x2Z*VRR1(51,44)
      V(431)=HfxZpE*VRR1(75,28)
      V(432)=2.D0*V(431)
      V(433)=r1x2Z*VRR0(51,45)
      V(434)=ExZpE*r1x2Z*VRR1(51,45)
      V(435)=HfxZpE*VRR1(75,29)
      V(436)=r1x2Z*VRR0(51,47)
      V(437)=ExZpE*r1x2Z*VRR1(51,47)
      V(438)=HfxZpE*VRR1(75,30)
      V(439)=3.D0*V(438)
      V(440)=r1x2Z*VRR0(51,48)
      V(441)=ExZpE*r1x2Z*VRR1(51,48)
      V(442)=HfxZpE*VRR1(75,31)
      V(443)=r1x2Z*VRR0(51,49)
      V(444)=ExZpE*r1x2Z*VRR1(51,49)
      V(445)=HfxZpE*VRR1(75,32)
      V(446)=r1x2Z*VRR0(51,50)
      V(447)=ExZpE*r1x2Z*VRR1(51,50)
      V(448)=r1x2Z*VRR0(51,51)
      V(449)=ExZpE*r1x2Z*VRR1(51,51)
      V(450)=HfxZpE*VRR1(75,33)
      V(451)=r1x2Z*VRR0(51,52)
      V(452)=ExZpE*r1x2Z*VRR1(51,52)
      V(453)=HfxZpE*VRR1(75,34)
      V(454)=r1x2Z*VRR0(51,53)
      V(455)=ExZpE*r1x2Z*VRR1(51,53)
      V(456)=r1x2E*VRR0(107,12)
      V(457)=HfxZpE*VRR1(76,22)
      V(458)=r1x2E*ZxZpE*VRR1(107,12)
      V(459)=r1x2E*VRR0(107,13)
      V(460)=HfxZpE*VRR1(76,23)
      V(461)=r1x2E*ZxZpE*VRR1(107,13)
      V(462)=r1x2E*VRR0(107,15)
      V(463)=HfxZpE*VRR1(76,26)
      V(464)=r1x2E*ZxZpE*VRR1(107,15)
      V(465)=r1x2E*VRR0(107,16)
      V(466)=2.D0*V(465)
      V(467)=HfxZpE*VRR1(76,27)
      V(468)=r1x2E*ZxZpE*VRR1(107,16)
      V(469)=-2.D0*V(468)
      V(470)=r1x2Z*VRR0(52,44)
      V(471)=2.D0*V(470)
      V(472)=ExZpE*r1x2Z*VRR1(52,44)
      V(473)=-2.D0*V(472)
      V(474)=HfxZpE*VRR1(76,28)
      V(475)=2.D0*V(474)
      V(476)=r1x2E*VRR0(107,17)
      V(477)=r1x2E*ZxZpE*VRR1(107,17)
      V(478)=r1x2E*VRR0(107,18)
      V(479)=HfxZpE*VRR1(76,30)
      V(480)=3.D0*V(479)
      V(481)=r1x2E*ZxZpE*VRR1(107,18)
      V(482)=r1x2Z*VRR0(52,48)
      V(483)=2.D0*V(482)
      V(484)=ExZpE*r1x2Z*VRR1(52,48)
      V(485)=-2.D0*V(484)
      V(486)=HfxZpE*VRR1(76,31)
      V(487)=r1x2Z*VRR0(52,49)
      V(488)=2.D0*V(487)
      V(489)=ExZpE*r1x2Z*VRR1(52,49)
      V(490)=-2.D0*V(489)
      V(491)=HfxZpE*VRR1(76,32)
      V(492)=r1x2E*VRR0(107,19)
      V(493)=r1x2E*ZxZpE*VRR1(107,19)
      V(494)=r1x2E*VRR0(108,12)
      V(495)=HfxZpE*VRR1(77,22)
      V(496)=r1x2E*ZxZpE*VRR1(108,12)
      V(497)=r1x2E*VRR0(108,13)
      V(498)=HfxZpE*VRR1(77,23)
      V(499)=r1x2E*ZxZpE*VRR1(108,13)
      V(500)=HfxZpE*VRR1(76,24)
      V(501)=r1x2E*VRR0(108,15)
      V(502)=HfxZpE*VRR1(77,26)
      V(503)=2.D0*V(502)
      V(504)=r1x2E*ZxZpE*VRR1(108,15)
      V(505)=r1x2E*VRR0(108,16)
      V(506)=2.D0*V(505)
      V(507)=HfxZpE*VRR1(77,27)
      V(508)=2.D0*V(507)
      V(509)=r1x2E*ZxZpE*VRR1(108,16)
      V(510)=-2.D0*V(509)
      V(511)=r1x2E*VRR0(108,17)
      V(512)=HfxZpE*VRR1(76,29)
      V(513)=2.D0*V(512)
      V(514)=r1x2E*ZxZpE*VRR1(108,17)
      V(515)=r1x2E*VRR0(108,18)
      V(516)=HfxZpE*VRR1(77,30)
      V(517)=r1x2E*ZxZpE*VRR1(108,18)
      V(518)=r1x2E*VRR0(108,19)
      V(519)=r1x2E*ZxZpE*VRR1(108,19)
      V(520)=r1x2E*VRR0(109,12)
      V(521)=HfxZpE*VRR1(78,22)
      V(522)=r1x2E*ZxZpE*VRR1(109,12)
      V(523)=r1x2E*VRR0(109,13)
      V(524)=HfxZpE*VRR1(78,23)
      V(525)=r1x2E*ZxZpE*VRR1(109,13)
      V(526)=HfxZpE*VRR1(77,24)
      V(527)=r1x2E*VRR0(109,15)
      V(528)=HfxZpE*VRR1(78,26)
      V(529)=r1x2E*ZxZpE*VRR1(109,15)
      V(530)=r1x2E*VRR0(109,16)
      V(531)=2.D0*V(530)
      V(532)=HfxZpE*VRR1(78,27)
      V(533)=r1x2E*ZxZpE*VRR1(109,16)
      V(534)=-2.D0*V(533)
      V(535)=HfxZpE*VRR1(77,28)
      V(536)=r1x2E*VRR0(109,17)
      V(537)=HfxZpE*VRR1(77,29)
      V(538)=r1x2E*ZxZpE*VRR1(109,17)
      V(539)=r1x2E*VRR0(109,18)
      V(540)=HfxZpE*VRR1(78,30)
      V(541)=r1x2E*ZxZpE*VRR1(109,18)
      V(542)=HfxZpE*VRR1(77,31)
      V(543)=r1x2E*VRR0(109,19)
      V(544)=HfxZpE*VRR1(77,32)
      V(545)=3.D0*V(544)
      V(546)=r1x2E*ZxZpE*VRR1(109,19)
      V(547)=r1x2Z*VRR0(53,38)
      V(548)=ExZpE*r1x2Z*VRR1(53,38)
      V(549)=r1x2Z*VRR0(53,39)
      V(550)=ExZpE*r1x2Z*VRR1(53,39)
      V(551)=HfxZpE*VRR1(78,24)
      V(552)=r1x2Z*VRR0(53,43)
      V(553)=ExZpE*r1x2Z*VRR1(53,43)
      V(554)=r1x2Z*VRR0(53,44)
      V(555)=ExZpE*r1x2Z*VRR1(53,44)
      V(556)=2.D0*V(532)
      V(557)=r1x2Z*VRR0(53,45)
      V(558)=ExZpE*r1x2Z*VRR1(53,45)
      V(559)=HfxZpE*VRR1(78,28)
      V(560)=HfxZpE*VRR1(78,29)
      V(561)=r1x2Z*VRR0(53,47)
      V(562)=ExZpE*r1x2Z*VRR1(53,47)
      V(563)=r1x2Z*VRR0(53,48)
      V(564)=ExZpE*r1x2Z*VRR1(53,48)
      V(565)=r1x2Z*VRR0(53,49)
      V(566)=ExZpE*r1x2Z*VRR1(53,49)
      V(567)=HfxZpE*VRR1(78,31)
      V(568)=r1x2Z*VRR0(53,50)
      V(569)=ExZpE*r1x2Z*VRR1(53,50)
      V(570)=HfxZpE*VRR1(78,32)
      V(571)=3.D0*V(570)
      V(572)=r1x2Z*VRR0(53,51)
      V(573)=ExZpE*r1x2Z*VRR1(53,51)
      V(574)=r1x2Z*VRR0(53,52)
      V(575)=ExZpE*r1x2Z*VRR1(53,52)
      V(576)=HfxZpE*VRR1(78,33)
      V(577)=r1x2Z*VRR0(53,53)
      V(578)=ExZpE*r1x2Z*VRR1(53,53)
      V(579)=HfxZpE*VRR1(78,34)
      V(580)=HfxZpE*VRR1(79,21)
      V(581)=HfxZpE*VRR1(79,22)
      V(582)=HfxZpE*VRR1(79,26)
      V(583)=HfxZpE*VRR1(80,21)
      V(584)=HfxZpE*VRR1(80,22)
      V(585)=HfxZpE*VRR1(79,24)
      V(586)=HfxZpE*VRR1(79,25)
      V(587)=HfxZpE*VRR1(80,26)
      V(588)=2.D0*V(587)
      V(589)=HfxZpE*VRR1(79,29)
      V(590)=HfxZpE*VRR1(81,21)
      V(591)=HfxZpE*VRR1(81,22)
      V(592)=HfxZpE*VRR1(80,24)
      V(593)=HfxZpE*VRR1(80,25)
      V(594)=HfxZpE*VRR1(81,26)
      V(595)=HfxZpE*VRR1(80,29)
      V(596)=2.D0*V(595)
      V(597)=HfxZpE*VRR1(81,24)
      V(598)=HfxZpE*VRR1(81,25)
      V(599)=HfxZpE*VRR1(81,29)
      V(600)=HfxZpE*VRR1(82,21)
      V(601)=HfxZpE*VRR1(83,21)
      V(602)=HfxZpE*VRR1(82,25)
      V(603)=HfxZpE*VRR1(83,25)
      VRR0(85,36)=6.D0*r1x2Z*VRR0(36,36)+PAx*VRR0(57,36)-6.D0*ExZpE*r1x2Z*VRR1(36,36)+5.D0*HfxZpE*VRR1(57,21)+WPx*VRR1(57,36)
      VRR0(85,37)=6.D0*r1x2Z*VRR0(36,37)+PAx*VRR0(57,37)-6.D0*ExZpE*r1x2Z*VRR1(36,37)+4.D0*HfxZpE*VRR1(57,22)+WPx*VRR1(57,37)
      VRR0(85,38)=6.D0*r1x2Z*VRR0(36,38)+PAx*VRR0(57,38)-6.D0*ExZpE*r1x2Z*VRR1(36,38)+3.D0*HfxZpE*VRR1(57,23)+WPx*VRR1(57,38)
      VRR0(85,39)=6.D0*r1x2Z*VRR0(36,39)+PAx*VRR0(57,39)-6.D0*ExZpE*r1x2Z*VRR1(36,39)+2.D0*HfxZpE*VRR1(57,24)+WPx*VRR1(57,39)
      VRR0(85,40)=6.D0*r1x2Z*VRR0(36,40)+PAx*VRR0(57,40)-6.D0*ExZpE*r1x2Z*VRR1(36,40)+HfxZpE*VRR1(57,25)+WPx*VRR1(57,40)
      VRR0(85,41)=6.D0*r1x2Z*VRR0(36,41)+PAx*VRR0(57,41)-6.D0*ExZpE*r1x2Z*VRR1(36,41)+WPx*VRR1(57,41)
      VRR0(85,42)=6.D0*r1x2Z*VRR0(36,42)+PAx*VRR0(57,42)-6.D0*ExZpE*r1x2Z*VRR1(36,42)+4.D0*HfxZpE*VRR1(57,26)+WPx*VRR1(57,42)
      VRR0(85,43)=6.D0*r1x2Z*VRR0(36,43)+PAx*VRR0(57,43)-6.D0*ExZpE*r1x2Z*VRR1(36,43)+3.D0*HfxZpE*VRR1(57,27)+WPx*VRR1(57,43)
      VRR0(85,44)=6.D0*r1x2Z*VRR0(36,44)+PAx*VRR0(57,44)-6.D0*ExZpE*r1x2Z*VRR1(36,44)+2.D0*HfxZpE*VRR1(57,28)+WPx*VRR1(57,44)
      VRR0(85,45)=6.D0*r1x2Z*VRR0(36,45)+PAx*VRR0(57,45)-6.D0*ExZpE*r1x2Z*VRR1(36,45)+HfxZpE*VRR1(57,29)+WPx*VRR1(57,45)
      VRR0(85,46)=6.D0*r1x2Z*VRR0(36,46)+PAx*VRR0(57,46)-6.D0*ExZpE*r1x2Z*VRR1(36,46)+WPx*VRR1(57,46)
      VRR0(85,47)=6.D0*r1x2Z*VRR0(36,47)+PAx*VRR0(57,47)-6.D0*ExZpE*r1x2Z*VRR1(36,47)+3.D0*HfxZpE*VRR1(57,30)+WPx*VRR1(57,47)
      VRR0(85,48)=6.D0*r1x2Z*VRR0(36,48)+PAx*VRR0(57,48)-6.D0*ExZpE*r1x2Z*VRR1(36,48)+2.D0*HfxZpE*VRR1(57,31)+WPx*VRR1(57,48)
      VRR0(85,49)=6.D0*r1x2Z*VRR0(36,49)+PAx*VRR0(57,49)-6.D0*ExZpE*r1x2Z*VRR1(36,49)+HfxZpE*VRR1(57,32)+WPx*VRR1(57,49)
      VRR0(85,50)=6.D0*r1x2Z*VRR0(36,50)+PAx*VRR0(57,50)-6.D0*ExZpE*r1x2Z*VRR1(36,50)+WPx*VRR1(57,50)
      VRR0(85,51)=6.D0*r1x2Z*VRR0(36,51)+PAx*VRR0(57,51)-6.D0*ExZpE*r1x2Z*VRR1(36,51)+2.D0*HfxZpE*VRR1(57,33)+WPx*VRR1(57,51)
      VRR0(85,52)=6.D0*r1x2Z*VRR0(36,52)+PAx*VRR0(57,52)-6.D0*ExZpE*r1x2Z*VRR1(36,52)+HfxZpE*VRR1(57,34)+WPx*VRR1(57,52)
      VRR0(85,53)=6.D0*r1x2Z*VRR0(36,53)+PAx*VRR0(57,53)-6.D0*ExZpE*r1x2Z*VRR1(36,53)+WPx*VRR1(57,53)
      VRR0(85,54)=6.D0*r1x2Z*VRR0(36,54)+PAx*VRR0(57,54)-6.D0*ExZpE*r1x2Z*VRR1(36,54)+HfxZpE*VRR1(57,35)+WPx*VRR1(57,54)
      VRR0(85,55)=6.D0*r1x2Z*VRR0(36,55)+PAx*VRR0(57,55)-6.D0*ExZpE*r1x2Z*VRR1(36,55)+WPx*VRR1(57,55)
      VRR0(85,56)=6.D0*r1x2Z*VRR0(36,56)+PAx*VRR0(57,56)-6.D0*ExZpE*r1x2Z*VRR1(36,56)+WPx*VRR1(57,56)
      VRR0(86,36)=5.D0*r1x2Z*VRR0(37,36)+PAx*VRR0(58,36)-5.D0*ExZpE*r1x2Z*VRR1(37,36)+5.D0*HfxZpE*VRR1(58,21)+WPx*VRR1(58,36)
      VRR0(86,37)=5.D0*r1x2Z*VRR0(37,37)+PAx*VRR0(58,37)-5.D0*ExZpE*r1x2Z*VRR1(37,37)+4.D0*HfxZpE*VRR1(58,22)+WPx*VRR1(58,37)
      VRR0(86,38)=5.D0*r1x2Z*VRR0(37,38)+PAx*VRR0(58,38)-5.D0*ExZpE*r1x2Z*VRR1(37,38)+3.D0*HfxZpE*VRR1(58,23)+WPx*VRR1(58,38)
      VRR0(86,39)=5.D0*r1x2Z*VRR0(37,39)+PAx*VRR0(58,39)-5.D0*ExZpE*r1x2Z*VRR1(37,39)+2.D0*HfxZpE*VRR1(58,24)+WPx*VRR1(58,39)
      VRR0(86,40)=V(1)+5.D0*r1x2Z*VRR0(37,40)+PAx*VRR0(58,40)-5.D0*ExZpE*r1x2Z*VRR1(37,40)+WPx*VRR1(58,40)
      VRR0(86,41)=5.D0*r1x2Z*VRR0(37,41)+PAx*VRR0(58,41)-5.D0*ExZpE*r1x2Z*VRR1(37,41)+WPx*VRR1(58,41)
      VRR0(86,42)=5.D0*r1x2Z*VRR0(37,42)+PAx*VRR0(58,42)-5.D0*ExZpE*r1x2Z*VRR1(37,42)+4.D0*HfxZpE*VRR1(58,26)+WPx*VRR1(58,42)
      VRR0(86,43)=5.D0*r1x2Z*VRR0(37,43)+PAx*VRR0(58,43)-5.D0*ExZpE*r1x2Z*VRR1(37,43)+3.D0*HfxZpE*VRR1(58,27)+WPx*VRR1(58,43)
      VRR0(86,44)=5.D0*r1x2Z*VRR0(37,44)+PAx*VRR0(58,44)-5.D0*ExZpE*r1x2Z*VRR1(37,44)+2.D0*HfxZpE*VRR1(58,28)+WPx*VRR1(58,44)
      VRR0(86,45)=5.D0*r1x2Z*VRR0(37,45)+PAx*VRR0(58,45)-5.D0*ExZpE*r1x2Z*VRR1(37,45)+HfxZpE*VRR1(58,29)+WPx*VRR1(58,45)
      VRR0(86,46)=5.D0*r1x2Z*VRR0(37,46)+PAx*VRR0(58,46)-5.D0*ExZpE*r1x2Z*VRR1(37,46)+WPx*VRR1(58,46)
      VRR0(86,47)=5.D0*r1x2Z*VRR0(37,47)+PAx*VRR0(58,47)-5.D0*ExZpE*r1x2Z*VRR1(37,47)+3.D0*HfxZpE*VRR1(58,30)+WPx*VRR1(58,47)
      VRR0(86,48)=5.D0*r1x2Z*VRR0(37,48)+PAx*VRR0(58,48)-5.D0*ExZpE*r1x2Z*VRR1(37,48)+2.D0*HfxZpE*VRR1(58,31)+WPx*VRR1(58,48)
      VRR0(86,49)=5.D0*r1x2Z*VRR0(37,49)+PAx*VRR0(58,49)-5.D0*ExZpE*r1x2Z*VRR1(37,49)+HfxZpE*VRR1(58,32)+WPx*VRR1(58,49)
      VRR0(86,50)=5.D0*r1x2Z*VRR0(37,50)+PAx*VRR0(58,50)-5.D0*ExZpE*r1x2Z*VRR1(37,50)+WPx*VRR1(58,50)
      VRR0(86,51)=5.D0*r1x2Z*VRR0(37,51)+PAx*VRR0(58,51)-5.D0*ExZpE*r1x2Z*VRR1(37,51)+2.D0*HfxZpE*VRR1(58,33)+WPx*VRR1(58,51)
      VRR0(86,52)=5.D0*r1x2Z*VRR0(37,52)+PAx*VRR0(58,52)-5.D0*ExZpE*r1x2Z*VRR1(37,52)+HfxZpE*VRR1(58,34)+WPx*VRR1(58,52)
      VRR0(86,53)=5.D0*r1x2Z*VRR0(37,53)+PAx*VRR0(58,53)-5.D0*ExZpE*r1x2Z*VRR1(37,53)+WPx*VRR1(58,53)
      VRR0(86,54)=V(2)+5.D0*r1x2Z*VRR0(37,54)+PAx*VRR0(58,54)-5.D0*ExZpE*r1x2Z*VRR1(37,54)+WPx*VRR1(58,54)
      VRR0(86,55)=5.D0*r1x2Z*VRR0(37,55)+PAx*VRR0(58,55)-5.D0*ExZpE*r1x2Z*VRR1(37,55)+WPx*VRR1(58,55)
      VRR0(86,56)=5.D0*r1x2Z*VRR0(37,56)+PAx*VRR0(58,56)-5.D0*ExZpE*r1x2Z*VRR1(37,56)+WPx*VRR1(58,56)
      VRR0(87,36)=4.D0*r1x2E*VRR0(87,11)+QCx*VRR0(87,21)+5.D0*HfxZpE*VRR1(59,21)-4.D0*r1x2E*ZxZpE*VRR1(87,11)+WQx*VRR1(87,21)
      VRR0(87,37)=4.D0*r1x2Z*VRR0(38,37)+PAx*VRR0(59,37)-4.D0*ExZpE*r1x2Z*VRR1(38,37)+4.D0*HfxZpE*VRR1(59,22)+WPx*VRR1(59,37)
      VRR0(87,38)=4.D0*V(3)-4.D0*V(4)+PAx*VRR0(59,38)+3.D0*HfxZpE*VRR1(59,23)+WPx*VRR1(59,38)
      VRR0(87,39)=4.D0*V(5)-4.D0*V(6)+2.D0*V(7)+PAx*VRR0(59,39)+WPx*VRR1(59,39)
      VRR0(87,40)=V(8)+4.D0*r1x2Z*VRR0(38,40)+PAx*VRR0(59,40)-4.D0*ExZpE*r1x2Z*VRR1(38,40)+WPx*VRR1(59,40)
      VRR0(87,41)=2.D0*V(1)+4.D0*r1x2E*VRR0(87,14)+QCy*VRR0(87,25)-4.D0*r1x2E*ZxZpE*VRR1(87,14)+WQy*VRR1(87,25)
      VRR0(87,42)=4.D0*r1x2Z*VRR0(38,42)+PAx*VRR0(59,42)-4.D0*ExZpE*r1x2Z*VRR1(38,42)+4.D0*HfxZpE*VRR1(59,26)+WPx*VRR1(59,42)
      VRR0(87,43)=4.D0*V(9)-4.D0*V(10)+PAx*VRR0(59,43)+3.D0*HfxZpE*VRR1(59,27)+WPx*VRR1(59,43)
      VRR0(87,44)=4.D0*V(11)-4.D0*V(12)+PAx*VRR0(59,44)+2.D0*HfxZpE*VRR1(59,28)+WPx*VRR1(59,44)
      VRR0(87,45)=4.D0*V(13)-4.D0*V(14)+V(15)+PAx*VRR0(59,45)+WPx*VRR1(59,45)
      VRR0(87,46)=4.D0*r1x2Z*VRR0(38,46)+PAx*VRR0(59,46)-4.D0*ExZpE*r1x2Z*VRR1(38,46)+WPx*VRR1(59,46)
      VRR0(87,47)=4.D0*V(16)-4.D0*V(17)+PAx*VRR0(59,47)+3.D0*HfxZpE*VRR1(59,30)+WPx*VRR1(59,47)
      VRR0(87,48)=4.D0*V(18)-4.D0*V(19)+PAx*VRR0(59,48)+2.D0*HfxZpE*VRR1(59,31)+WPx*VRR1(59,48)
      VRR0(87,49)=4.D0*V(20)-4.D0*V(21)+PAx*VRR0(59,49)+HfxZpE*VRR1(59,32)+WPx*VRR1(59,49)
      VRR0(87,50)=4.D0*V(22)-4.D0*V(23)+PAx*VRR0(59,50)+WPx*VRR1(59,50)
      VRR0(87,51)=4.D0*V(24)-4.D0*V(25)+2.D0*V(26)+PAx*VRR0(59,51)+WPx*VRR1(59,51)
      VRR0(87,52)=4.D0*V(27)-4.D0*V(28)+V(29)+PAx*VRR0(59,52)+WPx*VRR1(59,52)
      VRR0(87,53)=4.D0*V(30)-4.D0*V(31)+PAx*VRR0(59,53)+WPx*VRR1(59,53)
      VRR0(87,54)=V(32)+4.D0*r1x2Z*VRR0(38,54)+PAx*VRR0(59,54)-4.D0*ExZpE*r1x2Z*VRR1(38,54)+WPx*VRR1(59,54)
      VRR0(87,55)=4.D0*r1x2Z*VRR0(38,55)+PAx*VRR0(59,55)-4.D0*ExZpE*r1x2Z*VRR1(38,55)+WPx*VRR1(59,55)
      VRR0(87,56)=4.D0*r1x2E*VRR0(87,20)+QCz*VRR0(87,35)-4.D0*r1x2E*ZxZpE*VRR1(87,20)+WQz*VRR1(87,35)
      VRR0(88,36)=4.D0*r1x2E*VRR0(88,11)+QCx*VRR0(88,21)+4.D0*HfxZpE*VRR1(60,21)-4.D0*r1x2E*ZxZpE*VRR1(88,11)+WQx*VRR1(88,21)
      VRR0(88,37)=4.D0*V(33)+3.D0*r1x2E*VRR0(88,12)+QCx*VRR0(88,22)-3.D0*r1x2E*ZxZpE*VRR1(88,12)+WQx*VRR1(88,22)
      VRR0(88,38)=3.D0*V(34)-3.D0*V(35)+V(37)+PAx*VRR0(60,38)+WPx*VRR1(60,38)
      VRR0(88,39)=3.D0*V(38)-3.D0*V(39)+2.D0*V(40)+PAx*VRR0(60,39)+WPx*VRR1(60,39)
      VRR0(88,40)=3.D0*V(7)+3.D0*r1x2E*VRR0(88,13)+QCy*VRR0(88,24)-3.D0*r1x2E*ZxZpE*VRR1(88,13)+WQy*VRR1(88,24)
      VRR0(88,41)=3.D0*V(8)+4.D0*r1x2E*VRR0(88,14)+QCy*VRR0(88,25)-4.D0*r1x2E*ZxZpE*VRR1(88,14)+WQy*VRR1(88,25)
      VRR0(88,42)=4.D0*V(41)+3.D0*r1x2E*VRR0(88,15)+QCx*VRR0(88,26)-3.D0*r1x2E*ZxZpE*VRR1(88,15)+WQx*VRR1(88,26)
      VRR0(88,43)=3.D0*V(42)-3.D0*V(43)+3.D0*V(44)+PAx*VRR0(60,43)+WPx*VRR1(60,43)
      VRR0(88,44)=3.D0*V(45)-3.D0*V(46)+2.D0*V(47)+PAx*VRR0(60,44)+WPx*VRR1(60,44)
      VRR0(88,45)=3.D0*V(48)-3.D0*V(49)+V(50)+PAx*VRR0(60,45)+WPx*VRR1(60,45)
      VRR0(88,46)=3.D0*V(15)+3.D0*r1x2E*VRR0(88,17)+QCy*VRR0(88,29)-3.D0*r1x2E*ZxZpE*VRR1(88,17)+WQy*VRR1(88,29)
      VRR0(88,47)=3.D0*V(51)-3.D0*V(52)+3.D0*V(53)+PAx*VRR0(60,47)+WPx*VRR1(60,47)
      VRR0(88,48)=3.D0*V(54)-3.D0*V(55)+V(57)+PAx*VRR0(60,48)+WPx*VRR1(60,48)
      VRR0(88,49)=3.D0*V(58)-3.D0*V(59)+V(60)+PAx*VRR0(60,49)+WPx*VRR1(60,49)
      VRR0(88,50)=3.D0*V(61)-3.D0*V(62)+PAx*VRR0(60,50)+WPx*VRR1(60,50)
      VRR0(88,51)=3.D0*V(63)-3.D0*V(64)+2.D0*V(65)+PAx*VRR0(60,51)+WPx*VRR1(60,51)
      VRR0(88,52)=3.D0*V(66)-3.D0*V(67)+V(68)+PAx*VRR0(60,52)+WPx*VRR1(60,52)
      VRR0(88,53)=3.D0*V(69)-3.D0*V(70)+PAx*VRR0(60,53)+WPx*VRR1(60,53)
      VRR0(88,54)=3.D0*r1x2E*VRR0(88,18)+QCz*VRR0(88,33)-3.D0*r1x2E*ZxZpE*VRR1(88,18)+WQz*VRR1(88,33)
      VRR0(88,55)=3.D0*r1x2E*VRR0(88,19)+QCz*VRR0(88,34)-3.D0*r1x2E*ZxZpE*VRR1(88,19)+WQz*VRR1(88,34)
      VRR0(88,56)=4.D0*r1x2E*VRR0(88,20)+QCz*VRR0(88,35)-4.D0*r1x2E*ZxZpE*VRR1(88,20)+WQz*VRR1(88,35)
      VRR0(89,36)=3.D0*V(71)+4.D0*r1x2E*VRR0(89,11)+QCx*VRR0(89,21)-4.D0*r1x2E*ZxZpE*VRR1(89,11)+WQx*VRR1(89,21)
      VRR0(89,37)=3.D0*V(72)+3.D0*r1x2E*VRR0(89,12)+QCx*VRR0(89,22)-3.D0*r1x2E*ZxZpE*VRR1(89,12)+WQx*VRR1(89,22)
      VRR0(89,38)=3.D0*V(3)-3.D0*V(4)+2.D0*V(33)+PAy*VRR0(60,38)+WPy*VRR1(60,38)
      VRR0(89,39)=3.D0*V(5)-3.D0*V(6)+V(37)+PAy*VRR0(60,39)+WPy*VRR1(60,39)
      VRR0(89,40)=4.D0*V(40)+3.D0*r1x2E*VRR0(89,13)+QCy*VRR0(89,24)-3.D0*r1x2E*ZxZpE*VRR1(89,13)+WQy*VRR1(89,24)
      VRR0(89,41)=4.D0*r1x2E*VRR0(89,14)+QCy*VRR0(89,25)+4.D0*HfxZpE*VRR1(60,25)-4.D0*r1x2E*ZxZpE*VRR1(89,14)+WQy*VRR1(89,25)
      VRR0(89,42)=3.D0*V(73)+3.D0*r1x2E*VRR0(89,15)+QCx*VRR0(89,26)-3.D0*r1x2E*ZxZpE*VRR1(89,15)+WQx*VRR1(89,26)
      VRR0(89,43)=3.D0*V(9)-3.D0*V(10)+V(41)+PAy*VRR0(60,43)+WPy*VRR1(60,43)
      VRR0(89,44)=3.D0*V(11)-3.D0*V(12)+2.D0*V(44)+PAy*VRR0(60,44)+WPy*VRR1(60,44)
      VRR0(89,45)=3.D0*V(13)-3.D0*V(14)+3.D0*V(47)+PAy*VRR0(60,45)+WPy*VRR1(60,45)
      VRR0(89,46)=4.D0*V(50)+3.D0*r1x2E*VRR0(89,17)+QCy*VRR0(89,29)-3.D0*r1x2E*ZxZpE*VRR1(89,17)+WQy*VRR1(89,29)
      VRR0(89,47)=3.D0*V(16)-3.D0*V(17)+PAy*VRR0(60,47)+WPy*VRR1(60,47)
      VRR0(89,48)=3.D0*V(18)-3.D0*V(19)+V(53)+PAy*VRR0(60,48)+WPy*VRR1(60,48)
      VRR0(89,49)=3.D0*V(20)-3.D0*V(21)+V(57)+PAy*VRR0(60,49)+WPy*VRR1(60,49)
      VRR0(89,50)=3.D0*V(22)-3.D0*V(23)+3.D0*V(60)+PAy*VRR0(60,50)+WPy*VRR1(60,50)
      VRR0(89,51)=3.D0*V(24)-3.D0*V(25)+PAy*VRR0(60,51)+WPy*VRR1(60,51)
      VRR0(89,52)=3.D0*V(27)-3.D0*V(28)+V(65)+PAy*VRR0(60,52)+WPy*VRR1(60,52)
      VRR0(89,53)=3.D0*V(30)-3.D0*V(31)+2.D0*V(68)+PAy*VRR0(60,53)+WPy*VRR1(60,53)
      VRR0(89,54)=3.D0*r1x2E*VRR0(89,18)+QCz*VRR0(89,33)-3.D0*r1x2E*ZxZpE*VRR1(89,18)+WQz*VRR1(89,33)
      VRR0(89,55)=3.D0*r1x2E*VRR0(89,19)+QCz*VRR0(89,34)-3.D0*r1x2E*ZxZpE*VRR1(89,19)+WQz*VRR1(89,34)
      VRR0(89,56)=4.D0*r1x2E*VRR0(89,20)+QCz*VRR0(89,35)-4.D0*r1x2E*ZxZpE*VRR1(89,20)+WQz*VRR1(89,35)
      VRR0(90,36)=2.D0*V(74)+4.D0*r1x2E*VRR0(90,11)+QCx*VRR0(90,21)-4.D0*r1x2E*ZxZpE*VRR1(90,11)+WQx*VRR1(90,21)
      VRR0(90,37)=V(71)+4.D0*r1x2Z*VRR0(39,37)+PAy*VRR0(61,37)-4.D0*ExZpE*r1x2Z*VRR1(39,37)+WPy*VRR1(61,37)
      VRR0(90,38)=4.D0*V(34)-4.D0*V(35)+2.D0*V(72)+PAy*VRR0(61,38)+WPy*VRR1(61,38)
      VRR0(90,39)=4.D0*V(38)-4.D0*V(39)+PAy*VRR0(61,39)+3.D0*HfxZpE*VRR1(61,23)+WPy*VRR1(61,39)
      VRR0(90,40)=4.D0*r1x2Z*VRR0(39,40)+PAy*VRR0(61,40)-4.D0*ExZpE*r1x2Z*VRR1(39,40)+4.D0*HfxZpE*VRR1(61,24)+WPy*VRR1(61,40)
      VRR0(90,41)=4.D0*r1x2E*VRR0(90,14)+QCy*VRR0(90,25)+5.D0*HfxZpE*VRR1(61,25)-4.D0*r1x2E*ZxZpE*VRR1(90,14)+WQy*VRR1(90,25)
      VRR0(90,42)=4.D0*r1x2Z*VRR0(39,42)+PAy*VRR0(61,42)-4.D0*ExZpE*r1x2Z*VRR1(39,42)+WPy*VRR1(61,42)
      VRR0(90,43)=4.D0*V(42)-4.D0*V(43)+V(73)+PAy*VRR0(61,43)+WPy*VRR1(61,43)
      VRR0(90,44)=4.D0*V(45)-4.D0*V(46)+PAy*VRR0(61,44)+2.D0*HfxZpE*VRR1(61,27)+WPy*VRR1(61,44)
      VRR0(90,45)=4.D0*V(48)-4.D0*V(49)+PAy*VRR0(61,45)+3.D0*HfxZpE*VRR1(61,28)+WPy*VRR1(61,45)
      VRR0(90,46)=4.D0*r1x2Z*VRR0(39,46)+PAy*VRR0(61,46)-4.D0*ExZpE*r1x2Z*VRR1(39,46)+4.D0*HfxZpE*VRR1(61,29)+WPy*VRR1(61,46)
      VRR0(90,47)=4.D0*V(51)-4.D0*V(52)+PAy*VRR0(61,47)+WPy*VRR1(61,47)
      VRR0(90,48)=4.D0*V(54)-4.D0*V(55)+PAy*VRR0(61,48)+HfxZpE*VRR1(61,30)+WPy*VRR1(61,48)
      VRR0(90,49)=4.D0*V(58)-4.D0*V(59)+PAy*VRR0(61,49)+2.D0*HfxZpE*VRR1(61,31)+WPy*VRR1(61,49)
      VRR0(90,50)=4.D0*V(61)-4.D0*V(62)+PAy*VRR0(61,50)+3.D0*HfxZpE*VRR1(61,32)+WPy*VRR1(61,50)
      VRR0(90,51)=4.D0*V(63)-4.D0*V(64)+PAy*VRR0(61,51)+WPy*VRR1(61,51)
      VRR0(90,52)=4.D0*V(66)-4.D0*V(67)+V(75)+PAy*VRR0(61,52)+WPy*VRR1(61,52)
      VRR0(90,53)=4.D0*V(69)-4.D0*V(70)+2.D0*V(76)+PAy*VRR0(61,53)+WPy*VRR1(61,53)
      VRR0(90,54)=4.D0*r1x2Z*VRR0(39,54)+PAy*VRR0(61,54)-4.D0*ExZpE*r1x2Z*VRR1(39,54)+WPy*VRR1(61,54)
      VRR0(90,55)=V(77)+4.D0*r1x2Z*VRR0(39,55)+PAy*VRR0(61,55)-4.D0*ExZpE*r1x2Z*VRR1(39,55)+WPy*VRR1(61,55)
      VRR0(90,56)=4.D0*r1x2E*VRR0(90,20)+QCz*VRR0(90,35)-4.D0*r1x2E*ZxZpE*VRR1(90,20)+WQz*VRR1(90,35)
      VRR0(91,36)=5.D0*r1x2Z*VRR0(40,36)+PAy*VRR0(62,36)-5.D0*ExZpE*r1x2Z*VRR1(40,36)+WPy*VRR1(62,36)
      VRR0(91,37)=V(74)+5.D0*r1x2Z*VRR0(40,37)+PAy*VRR0(62,37)-5.D0*ExZpE*r1x2Z*VRR1(40,37)+WPy*VRR1(62,37)
      VRR0(91,38)=5.D0*r1x2Z*VRR0(40,38)+PAy*VRR0(62,38)-5.D0*ExZpE*r1x2Z*VRR1(40,38)+2.D0*HfxZpE*VRR1(62,22)+WPy*VRR1(62,38)
      VRR0(91,39)=5.D0*r1x2Z*VRR0(40,39)+PAy*VRR0(62,39)-5.D0*ExZpE*r1x2Z*VRR1(40,39)+3.D0*HfxZpE*VRR1(62,23)+WPy*VRR1(62,39)
      VRR0(91,40)=5.D0*r1x2Z*VRR0(40,40)+PAy*VRR0(62,40)-5.D0*ExZpE*r1x2Z*VRR1(40,40)+4.D0*HfxZpE*VRR1(62,24)+WPy*VRR1(62,40)
      VRR0(91,41)=5.D0*r1x2Z*VRR0(40,41)+PAy*VRR0(62,41)-5.D0*ExZpE*r1x2Z*VRR1(40,41)+5.D0*HfxZpE*VRR1(62,25)+WPy*VRR1(62,41)
      VRR0(91,42)=5.D0*r1x2Z*VRR0(40,42)+PAy*VRR0(62,42)-5.D0*ExZpE*r1x2Z*VRR1(40,42)+WPy*VRR1(62,42)
      VRR0(91,43)=5.D0*r1x2Z*VRR0(40,43)+PAy*VRR0(62,43)-5.D0*ExZpE*r1x2Z*VRR1(40,43)+HfxZpE*VRR1(62,26)+WPy*VRR1(62,43)
      VRR0(91,44)=5.D0*r1x2Z*VRR0(40,44)+PAy*VRR0(62,44)-5.D0*ExZpE*r1x2Z*VRR1(40,44)+2.D0*HfxZpE*VRR1(62,27)+WPy*VRR1(62,44)
      VRR0(91,45)=5.D0*r1x2Z*VRR0(40,45)+PAy*VRR0(62,45)-5.D0*ExZpE*r1x2Z*VRR1(40,45)+3.D0*HfxZpE*VRR1(62,28)+WPy*VRR1(62,45)
      VRR0(91,46)=5.D0*r1x2Z*VRR0(40,46)+PAy*VRR0(62,46)-5.D0*ExZpE*r1x2Z*VRR1(40,46)+4.D0*HfxZpE*VRR1(62,29)+WPy*VRR1(62,46)
      VRR0(91,47)=5.D0*r1x2Z*VRR0(40,47)+PAy*VRR0(62,47)-5.D0*ExZpE*r1x2Z*VRR1(40,47)+WPy*VRR1(62,47)
      VRR0(91,48)=5.D0*r1x2Z*VRR0(40,48)+PAy*VRR0(62,48)-5.D0*ExZpE*r1x2Z*VRR1(40,48)+HfxZpE*VRR1(62,30)+WPy*VRR1(62,48)
      VRR0(91,49)=5.D0*r1x2Z*VRR0(40,49)+PAy*VRR0(62,49)-5.D0*ExZpE*r1x2Z*VRR1(40,49)+2.D0*HfxZpE*VRR1(62,31)+WPy*VRR1(62,49)
      VRR0(91,50)=5.D0*r1x2Z*VRR0(40,50)+PAy*VRR0(62,50)-5.D0*ExZpE*r1x2Z*VRR1(40,50)+3.D0*HfxZpE*VRR1(62,32)+WPy*VRR1(62,50)
      VRR0(91,51)=5.D0*r1x2Z*VRR0(40,51)+PAy*VRR0(62,51)-5.D0*ExZpE*r1x2Z*VRR1(40,51)+WPy*VRR1(62,51)
      VRR0(91,52)=5.D0*r1x2Z*VRR0(40,52)+PAy*VRR0(62,52)-5.D0*ExZpE*r1x2Z*VRR1(40,52)+HfxZpE*VRR1(62,33)+WPy*VRR1(62,52)
      VRR0(91,53)=5.D0*r1x2Z*VRR0(40,53)+PAy*VRR0(62,53)-5.D0*ExZpE*r1x2Z*VRR1(40,53)+2.D0*HfxZpE*VRR1(62,34)+WPy*VRR1(62,53)
      VRR0(91,54)=5.D0*r1x2Z*VRR0(40,54)+PAy*VRR0(62,54)-5.D0*ExZpE*r1x2Z*VRR1(40,54)+WPy*VRR1(62,54)
      VRR0(91,55)=V(78)+5.D0*r1x2Z*VRR0(40,55)+PAy*VRR0(62,55)-5.D0*ExZpE*r1x2Z*VRR1(40,55)+WPy*VRR1(62,55)
      VRR0(91,56)=5.D0*r1x2Z*VRR0(40,56)+PAy*VRR0(62,56)-5.D0*ExZpE*r1x2Z*VRR1(40,56)+WPy*VRR1(62,56)
      VRR0(92,36)=6.D0*r1x2Z*VRR0(41,36)+PAy*VRR0(63,36)-6.D0*ExZpE*r1x2Z*VRR1(41,36)+WPy*VRR1(63,36)
      VRR0(92,37)=6.D0*r1x2Z*VRR0(41,37)+PAy*VRR0(63,37)-6.D0*ExZpE*r1x2Z*VRR1(41,37)+HfxZpE*VRR1(63,21)+WPy*VRR1(63,37)
      VRR0(92,38)=6.D0*r1x2Z*VRR0(41,38)+PAy*VRR0(63,38)-6.D0*ExZpE*r1x2Z*VRR1(41,38)+2.D0*HfxZpE*VRR1(63,22)+WPy*VRR1(63,38)
      VRR0(92,39)=6.D0*r1x2Z*VRR0(41,39)+PAy*VRR0(63,39)-6.D0*ExZpE*r1x2Z*VRR1(41,39)+3.D0*HfxZpE*VRR1(63,23)+WPy*VRR1(63,39)
      VRR0(92,40)=6.D0*r1x2Z*VRR0(41,40)+PAy*VRR0(63,40)-6.D0*ExZpE*r1x2Z*VRR1(41,40)+4.D0*HfxZpE*VRR1(63,24)+WPy*VRR1(63,40)
      VRR0(92,41)=6.D0*r1x2Z*VRR0(41,41)+PAy*VRR0(63,41)-6.D0*ExZpE*r1x2Z*VRR1(41,41)+5.D0*HfxZpE*VRR1(63,25)+WPy*VRR1(63,41)
      VRR0(92,42)=6.D0*r1x2Z*VRR0(41,42)+PAy*VRR0(63,42)-6.D0*ExZpE*r1x2Z*VRR1(41,42)+WPy*VRR1(63,42)
      VRR0(92,43)=6.D0*r1x2Z*VRR0(41,43)+PAy*VRR0(63,43)-6.D0*ExZpE*r1x2Z*VRR1(41,43)+HfxZpE*VRR1(63,26)+WPy*VRR1(63,43)
      VRR0(92,44)=6.D0*r1x2Z*VRR0(41,44)+PAy*VRR0(63,44)-6.D0*ExZpE*r1x2Z*VRR1(41,44)+2.D0*HfxZpE*VRR1(63,27)+WPy*VRR1(63,44)
      VRR0(92,45)=6.D0*r1x2Z*VRR0(41,45)+PAy*VRR0(63,45)-6.D0*ExZpE*r1x2Z*VRR1(41,45)+3.D0*HfxZpE*VRR1(63,28)+WPy*VRR1(63,45)
      VRR0(92,46)=6.D0*r1x2Z*VRR0(41,46)+PAy*VRR0(63,46)-6.D0*ExZpE*r1x2Z*VRR1(41,46)+4.D0*HfxZpE*VRR1(63,29)+WPy*VRR1(63,46)
      VRR0(92,47)=6.D0*r1x2Z*VRR0(41,47)+PAy*VRR0(63,47)-6.D0*ExZpE*r1x2Z*VRR1(41,47)+WPy*VRR1(63,47)
      VRR0(92,48)=6.D0*r1x2Z*VRR0(41,48)+PAy*VRR0(63,48)-6.D0*ExZpE*r1x2Z*VRR1(41,48)+HfxZpE*VRR1(63,30)+WPy*VRR1(63,48)
      VRR0(92,49)=6.D0*r1x2Z*VRR0(41,49)+PAy*VRR0(63,49)-6.D0*ExZpE*r1x2Z*VRR1(41,49)+2.D0*HfxZpE*VRR1(63,31)+WPy*VRR1(63,49)
      VRR0(92,50)=6.D0*r1x2Z*VRR0(41,50)+PAy*VRR0(63,50)-6.D0*ExZpE*r1x2Z*VRR1(41,50)+3.D0*HfxZpE*VRR1(63,32)+WPy*VRR1(63,50)
      VRR0(92,51)=6.D0*r1x2Z*VRR0(41,51)+PAy*VRR0(63,51)-6.D0*ExZpE*r1x2Z*VRR1(41,51)+WPy*VRR1(63,51)
      VRR0(92,52)=6.D0*r1x2Z*VRR0(41,52)+PAy*VRR0(63,52)-6.D0*ExZpE*r1x2Z*VRR1(41,52)+HfxZpE*VRR1(63,33)+WPy*VRR1(63,52)
      VRR0(92,53)=6.D0*r1x2Z*VRR0(41,53)+PAy*VRR0(63,53)-6.D0*ExZpE*r1x2Z*VRR1(41,53)+2.D0*HfxZpE*VRR1(63,34)+WPy*VRR1(63,53)
      VRR0(92,54)=6.D0*r1x2Z*VRR0(41,54)+PAy*VRR0(63,54)-6.D0*ExZpE*r1x2Z*VRR1(41,54)+WPy*VRR1(63,54)
      VRR0(92,55)=6.D0*r1x2Z*VRR0(41,55)+PAy*VRR0(63,55)-6.D0*ExZpE*r1x2Z*VRR1(41,55)+HfxZpE*VRR1(63,35)+WPy*VRR1(63,55)
      VRR0(92,56)=6.D0*r1x2Z*VRR0(41,56)+PAy*VRR0(63,56)-6.D0*ExZpE*r1x2Z*VRR1(41,56)+WPy*VRR1(63,56)
      VRR0(93,36)=5.D0*r1x2Z*VRR0(42,36)+PAx*VRR0(64,36)-5.D0*ExZpE*r1x2Z*VRR1(42,36)+5.D0*HfxZpE*VRR1(64,21)+WPx*VRR1(64,36)
      VRR0(93,37)=5.D0*r1x2Z*VRR0(42,37)+PAx*VRR0(64,37)-5.D0*ExZpE*r1x2Z*VRR1(42,37)+4.D0*HfxZpE*VRR1(64,22)+WPx*VRR1(64,37)
      VRR0(93,38)=5.D0*r1x2Z*VRR0(42,38)+PAx*VRR0(64,38)-5.D0*ExZpE*r1x2Z*VRR1(42,38)+3.D0*HfxZpE*VRR1(64,23)+WPx*VRR1(64,38)
      VRR0(93,39)=5.D0*r1x2Z*VRR0(42,39)+PAx*VRR0(64,39)-5.D0*ExZpE*r1x2Z*VRR1(42,39)+2.D0*HfxZpE*VRR1(64,24)+WPx*VRR1(64,39)
      VRR0(93,40)=V(79)+5.D0*r1x2Z*VRR0(42,40)+PAx*VRR0(64,40)-5.D0*ExZpE*r1x2Z*VRR1(42,40)+WPx*VRR1(64,40)
      VRR0(93,41)=5.D0*r1x2Z*VRR0(42,41)+PAx*VRR0(64,41)-5.D0*ExZpE*r1x2Z*VRR1(42,41)+WPx*VRR1(64,41)
      VRR0(93,42)=5.D0*r1x2Z*VRR0(42,42)+PAx*VRR0(64,42)-5.D0*ExZpE*r1x2Z*VRR1(42,42)+4.D0*HfxZpE*VRR1(64,26)+WPx*VRR1(64,42)
      VRR0(93,43)=5.D0*r1x2Z*VRR0(42,43)+PAx*VRR0(64,43)-5.D0*ExZpE*r1x2Z*VRR1(42,43)+3.D0*HfxZpE*VRR1(64,27)+WPx*VRR1(64,43)
      VRR0(93,44)=5.D0*r1x2Z*VRR0(42,44)+PAx*VRR0(64,44)-5.D0*ExZpE*r1x2Z*VRR1(42,44)+2.D0*HfxZpE*VRR1(64,28)+WPx*VRR1(64,44)
      VRR0(93,45)=5.D0*r1x2Z*VRR0(42,45)+PAx*VRR0(64,45)-5.D0*ExZpE*r1x2Z*VRR1(42,45)+HfxZpE*VRR1(64,29)+WPx*VRR1(64,45)
      VRR0(93,46)=5.D0*r1x2Z*VRR0(42,46)+PAx*VRR0(64,46)-5.D0*ExZpE*r1x2Z*VRR1(42,46)+WPx*VRR1(64,46)
      VRR0(93,47)=5.D0*r1x2Z*VRR0(42,47)+PAx*VRR0(64,47)-5.D0*ExZpE*r1x2Z*VRR1(42,47)+3.D0*HfxZpE*VRR1(64,30)+WPx*VRR1(64,47)
      VRR0(93,48)=5.D0*r1x2Z*VRR0(42,48)+PAx*VRR0(64,48)-5.D0*ExZpE*r1x2Z*VRR1(42,48)+2.D0*HfxZpE*VRR1(64,31)+WPx*VRR1(64,48)
      VRR0(93,49)=5.D0*r1x2Z*VRR0(42,49)+PAx*VRR0(64,49)-5.D0*ExZpE*r1x2Z*VRR1(42,49)+HfxZpE*VRR1(64,32)+WPx*VRR1(64,49)
      VRR0(93,50)=5.D0*r1x2Z*VRR0(42,50)+PAx*VRR0(64,50)-5.D0*ExZpE*r1x2Z*VRR1(42,50)+WPx*VRR1(64,50)
      VRR0(93,51)=5.D0*r1x2Z*VRR0(42,51)+PAx*VRR0(64,51)-5.D0*ExZpE*r1x2Z*VRR1(42,51)+2.D0*HfxZpE*VRR1(64,33)+WPx*VRR1(64,51)
      VRR0(93,52)=5.D0*r1x2Z*VRR0(42,52)+PAx*VRR0(64,52)-5.D0*ExZpE*r1x2Z*VRR1(42,52)+HfxZpE*VRR1(64,34)+WPx*VRR1(64,52)
      VRR0(93,53)=5.D0*r1x2Z*VRR0(42,53)+PAx*VRR0(64,53)-5.D0*ExZpE*r1x2Z*VRR1(42,53)+WPx*VRR1(64,53)
      VRR0(93,54)=V(80)+5.D0*r1x2Z*VRR0(42,54)+PAx*VRR0(64,54)-5.D0*ExZpE*r1x2Z*VRR1(42,54)+WPx*VRR1(64,54)
      VRR0(93,55)=5.D0*r1x2Z*VRR0(42,55)+PAx*VRR0(64,55)-5.D0*ExZpE*r1x2Z*VRR1(42,55)+WPx*VRR1(64,55)
      VRR0(93,56)=5.D0*r1x2Z*VRR0(42,56)+PAx*VRR0(64,56)-5.D0*ExZpE*r1x2Z*VRR1(42,56)+WPx*VRR1(64,56)
      VRR0(94,36)=4.D0*r1x2E*VRR0(94,11)+QCx*VRR0(94,21)+5.D0*HfxZpE*VRR1(65,21)-4.D0*r1x2E*ZxZpE*VRR1(94,11)+WQx*VRR1(94,21)
      VRR0(94,37)=4.D0*r1x2Z*VRR0(43,37)+PAx*VRR0(65,37)-4.D0*ExZpE*r1x2Z*VRR1(43,37)+4.D0*HfxZpE*VRR1(65,22)+WPx*VRR1(65,37)
      VRR0(94,38)=4.D0*r1x2Z*VRR0(43,38)+PAx*VRR0(65,38)-4.D0*ExZpE*r1x2Z*VRR1(43,38)+3.D0*HfxZpE*VRR1(65,23)+WPx*VRR1(65,38)
      VRR0(94,39)=V(82)+4.D0*r1x2Z*VRR0(43,39)+PAx*VRR0(65,39)-4.D0*ExZpE*r1x2Z*VRR1(43,39)+WPx*VRR1(65,39)
      VRR0(94,40)=V(83)+4.D0*r1x2Z*VRR0(43,40)+PAx*VRR0(65,40)-4.D0*ExZpE*r1x2Z*VRR1(43,40)+WPx*VRR1(65,40)
      VRR0(94,41)=V(79)+4.D0*r1x2E*VRR0(94,14)+QCy*VRR0(94,25)-4.D0*r1x2E*ZxZpE*VRR1(94,14)+WQy*VRR1(94,25)
      VRR0(94,42)=4.D0*r1x2Z*VRR0(43,42)+PAx*VRR0(65,42)-4.D0*ExZpE*r1x2Z*VRR1(43,42)+4.D0*HfxZpE*VRR1(65,26)+WPx*VRR1(65,42)
      VRR0(94,43)=4.D0*r1x2Z*VRR0(43,43)+PAx*VRR0(65,43)-4.D0*ExZpE*r1x2Z*VRR1(43,43)+3.D0*HfxZpE*VRR1(65,27)+WPx*VRR1(65,43)
      VRR0(94,44)=4.D0*r1x2Z*VRR0(43,44)+PAx*VRR0(65,44)-4.D0*ExZpE*r1x2Z*VRR1(43,44)+2.D0*HfxZpE*VRR1(65,28)+WPx*VRR1(65,44)
      VRR0(94,45)=V(84)+4.D0*r1x2Z*VRR0(43,45)+PAx*VRR0(65,45)-4.D0*ExZpE*r1x2Z*VRR1(43,45)+WPx*VRR1(65,45)
      VRR0(94,46)=4.D0*r1x2Z*VRR0(43,46)+PAx*VRR0(65,46)-4.D0*ExZpE*r1x2Z*VRR1(43,46)+WPx*VRR1(65,46)
      VRR0(94,47)=4.D0*r1x2Z*VRR0(43,47)+PAx*VRR0(65,47)-4.D0*ExZpE*r1x2Z*VRR1(43,47)+3.D0*HfxZpE*VRR1(65,30)+WPx*VRR1(65,47)
      VRR0(94,48)=4.D0*r1x2Z*VRR0(43,48)+PAx*VRR0(65,48)-4.D0*ExZpE*r1x2Z*VRR1(43,48)+2.D0*HfxZpE*VRR1(65,31)+WPx*VRR1(65,48)
      VRR0(94,49)=4.D0*r1x2Z*VRR0(43,49)+PAx*VRR0(65,49)-4.D0*ExZpE*r1x2Z*VRR1(43,49)+HfxZpE*VRR1(65,32)+WPx*VRR1(65,49)
      VRR0(94,50)=4.D0*r1x2Z*VRR0(43,50)+PAx*VRR0(65,50)-4.D0*ExZpE*r1x2Z*VRR1(43,50)+WPx*VRR1(65,50)
      VRR0(94,51)=V(86)+4.D0*r1x2Z*VRR0(43,51)+PAx*VRR0(65,51)-4.D0*ExZpE*r1x2Z*VRR1(43,51)+WPx*VRR1(65,51)
      VRR0(94,52)=V(87)+4.D0*r1x2Z*VRR0(43,52)+PAx*VRR0(65,52)-4.D0*ExZpE*r1x2Z*VRR1(43,52)+WPx*VRR1(65,52)
      VRR0(94,53)=4.D0*r1x2Z*VRR0(43,53)+PAx*VRR0(65,53)-4.D0*ExZpE*r1x2Z*VRR1(43,53)+WPx*VRR1(65,53)
      VRR0(94,54)=V(88)+4.D0*r1x2Z*VRR0(43,54)+PAx*VRR0(65,54)-4.D0*ExZpE*r1x2Z*VRR1(43,54)+WPx*VRR1(65,54)
      VRR0(94,55)=4.D0*r1x2Z*VRR0(43,55)+PAx*VRR0(65,55)-4.D0*ExZpE*r1x2Z*VRR1(43,55)+WPx*VRR1(65,55)
      VRR0(94,56)=V(2)+4.D0*r1x2E*VRR0(94,20)+QCz*VRR0(94,35)-4.D0*r1x2E*ZxZpE*VRR1(94,20)+WQz*VRR1(94,35)
      VRR0(95,36)=4.D0*r1x2E*VRR0(95,11)+QCx*VRR0(95,21)+4.D0*HfxZpE*VRR1(66,21)-4.D0*r1x2E*ZxZpE*VRR1(95,11)+WQx*VRR1(95,21)
      VRR0(95,37)=3.D0*r1x2E*VRR0(95,12)+QCx*VRR0(95,22)+4.D0*HfxZpE*VRR1(66,22)-3.D0*r1x2E*ZxZpE*VRR1(95,12)+WQx*VRR1(95,22)
      VRR0(95,38)=V(90)+V(92)+V(94)+PAx*VRR0(66,38)+WPx*VRR1(66,38)
      VRR0(95,39)=V(96)+V(98)+2.D0*V(99)+PAx*VRR0(66,39)+WPx*VRR1(66,39)
      VRR0(95,40)=V(82)+3.D0*r1x2E*VRR0(95,13)+QCy*VRR0(95,24)-3.D0*r1x2E*ZxZpE*VRR1(95,13)+WQy*VRR1(95,24)
      VRR0(95,41)=2.D0*V(83)+4.D0*r1x2E*VRR0(95,14)+QCy*VRR0(95,25)-4.D0*r1x2E*ZxZpE*VRR1(95,14)+WQy*VRR1(95,25)
      VRR0(95,42)=3.D0*r1x2E*VRR0(95,15)+QCx*VRR0(95,26)+4.D0*HfxZpE*VRR1(66,26)-3.D0*r1x2E*ZxZpE*VRR1(95,15)+WQx*VRR1(95,26)
      VRR0(95,43)=V(101)+V(103)+PAx*VRR0(66,43)+3.D0*HfxZpE*VRR1(66,27)+WPx*VRR1(66,43)
      VRR0(95,44)=V(105)+V(107)+2.D0*V(108)+PAx*VRR0(66,44)+WPx*VRR1(66,44)
      VRR0(95,45)=V(110)+V(112)+V(113)+PAx*VRR0(66,45)+WPx*VRR1(66,45)
      VRR0(95,46)=2.D0*V(84)+3.D0*r1x2E*VRR0(95,17)+QCy*VRR0(95,29)-3.D0*r1x2E*ZxZpE*VRR1(95,17)+WQy*VRR1(95,29)
      VRR0(95,47)=V(115)+V(117)+3.D0*V(118)+PAx*VRR0(66,47)+WPx*VRR1(66,47)
      VRR0(95,48)=V(120)+V(122)+V(124)+PAx*VRR0(66,48)+WPx*VRR1(66,48)
      VRR0(95,49)=V(126)+V(128)+V(129)+PAx*VRR0(66,49)+WPx*VRR1(66,49)
      VRR0(95,50)=V(131)+V(133)+PAx*VRR0(66,50)+WPx*VRR1(66,50)
      VRR0(95,51)=V(135)+V(137)+V(139)+PAx*VRR0(66,51)+WPx*VRR1(66,51)
      VRR0(95,52)=V(141)+V(143)+V(144)+PAx*VRR0(66,52)+WPx*VRR1(66,52)
      VRR0(95,53)=V(146)+V(148)+PAx*VRR0(66,53)+WPx*VRR1(66,53)
      VRR0(95,54)=V(26)+3.D0*r1x2E*VRR0(95,18)+QCz*VRR0(95,33)-3.D0*r1x2E*ZxZpE*VRR1(95,18)+WQz*VRR1(95,33)
      VRR0(95,55)=V(29)+3.D0*r1x2E*VRR0(95,19)+QCz*VRR0(95,34)-3.D0*r1x2E*ZxZpE*VRR1(95,19)+WQz*VRR1(95,34)
      VRR0(95,56)=V(32)+4.D0*r1x2E*VRR0(95,20)+QCz*VRR0(95,35)-4.D0*r1x2E*ZxZpE*VRR1(95,20)+WQz*VRR1(95,35)
      VRR0(96,36)=4.D0*r1x2E*VRR0(96,11)+QCx*VRR0(96,21)+3.D0*HfxZpE*VRR1(67,21)-4.D0*r1x2E*ZxZpE*VRR1(96,11)+WQx*VRR1(96,21)
      VRR0(96,37)=3.D0*V(149)+3.D0*V(150)-3.D0*V(151)+QCx*VRR0(96,22)+WQx*VRR1(96,22)
      VRR0(96,38)=2.D0*V(152)+V(154)-2.D0*V(155)+QCx*VRR0(96,23)+WQx*VRR1(96,23)
      VRR0(96,39)=V(94)+2.D0*V(149)-2.D0*V(151)+QCy*VRR0(96,23)+WQy*VRR1(96,23)
      VRR0(96,40)=3.D0*V(99)+3.D0*V(152)-3.D0*V(155)+QCy*VRR0(96,24)+WQy*VRR1(96,24)
      VRR0(96,41)=4.D0*r1x2E*VRR0(96,14)+QCy*VRR0(96,25)+3.D0*HfxZpE*VRR1(66,25)-4.D0*r1x2E*ZxZpE*VRR1(96,14)+WQy*VRR1(96,25)
      VRR0(96,42)=3.D0*V(156)+3.D0*V(157)-3.D0*V(158)+QCx*VRR0(96,26)+WQx*VRR1(96,26)
      VRR0(96,43)=V(160)+3.D0*V(161)+V(163)+QCx*VRR0(96,27)+WQx*VRR1(96,27)
      VRR0(96,44)=2.D0*V(164)-2.D0*V(165)+2.D0*V(166)+PAx*VRR0(67,44)+WPx*VRR1(67,44)
      VRR0(96,45)=3.D0*V(108)+V(160)+V(163)+QCy*VRR0(96,28)+WQy*VRR1(96,28)
      VRR0(96,46)=3.D0*V(113)+3.D0*V(167)-3.D0*V(168)+QCy*VRR0(96,29)+WQy*VRR1(96,29)
      VRR0(96,47)=2.D0*V(169)+3.D0*V(170)-2.D0*V(171)+QCx*VRR0(96,30)+WQx*VRR1(96,30)
      VRR0(96,48)=2.D0*V(172)-2.D0*V(173)+V(175)+PAx*VRR0(67,48)+WPx*VRR1(67,48)
      VRR0(96,49)=2.D0*V(176)-2.D0*V(177)+V(178)+PAx*VRR0(67,49)+WPx*VRR1(67,49)
      VRR0(96,50)=3.D0*V(129)+2.D0*V(179)-2.D0*V(180)+QCy*VRR0(96,32)+WQy*VRR1(96,32)
      VRR0(96,51)=V(53)+2.D0*V(156)-2.D0*V(158)+QCz*VRR0(96,30)+WQz*VRR1(96,30)
      VRR0(96,52)=V(56)+V(160)+V(163)+QCz*VRR0(96,31)+WQz*VRR1(96,31)
      VRR0(96,53)=V(60)+2.D0*V(167)-2.D0*V(168)+QCz*VRR0(96,32)+WQz*VRR1(96,32)
      VRR0(96,54)=V(65)+3.D0*V(169)-3.D0*V(171)+QCz*VRR0(96,33)+WQz*VRR1(96,33)
      VRR0(96,55)=V(68)+3.D0*V(179)-3.D0*V(180)+QCz*VRR0(96,34)+WQz*VRR1(96,34)
      VRR0(96,56)=4.D0*r1x2E*VRR0(96,20)+QCz*VRR0(96,35)+HfxZpE*VRR1(60,35)-4.D0*r1x2E*ZxZpE*VRR1(96,20)+WQz*VRR1(96,35)
      VRR0(97,36)=2.D0*V(181)+4.D0*r1x2E*VRR0(97,11)+QCx*VRR0(97,21)-4.D0*r1x2E*ZxZpE*VRR1(97,11)+WQx*VRR1(97,21)
      VRR0(97,37)=V(183)+3.D0*r1x2E*VRR0(97,12)+QCx*VRR0(97,22)-3.D0*r1x2E*ZxZpE*VRR1(97,12)+WQx*VRR1(97,22)
      VRR0(97,38)=V(90)+V(92)+2.D0*V(150)+PAy*VRR0(67,38)+WPy*VRR1(67,38)
      VRR0(97,39)=V(96)+V(98)+V(154)+PAy*VRR0(67,39)+WPy*VRR1(67,39)
      VRR0(97,40)=3.D0*r1x2E*VRR0(97,13)+QCy*VRR0(97,24)+4.D0*HfxZpE*VRR1(67,24)-3.D0*r1x2E*ZxZpE*VRR1(97,13)+WQy*VRR1(97,24)
      VRR0(97,41)=4.D0*r1x2E*VRR0(97,14)+QCy*VRR0(97,25)+4.D0*HfxZpE*VRR1(67,25)-4.D0*r1x2E*ZxZpE*VRR1(97,14)+WQy*VRR1(97,25)
      VRR0(97,42)=2.D0*V(184)+3.D0*r1x2E*VRR0(97,15)+QCx*VRR0(97,26)-3.D0*r1x2E*ZxZpE*VRR1(97,15)+WQx*VRR1(97,26)
      VRR0(97,43)=V(101)+V(103)+V(157)+PAy*VRR0(67,43)+WPy*VRR1(67,43)
      VRR0(97,44)=V(105)+V(107)+2.D0*V(161)+PAy*VRR0(67,44)+WPy*VRR1(67,44)
      VRR0(97,45)=V(110)+V(112)+3.D0*V(166)+PAy*VRR0(67,45)+WPy*VRR1(67,45)
      VRR0(97,46)=3.D0*r1x2E*VRR0(97,17)+QCy*VRR0(97,29)+4.D0*HfxZpE*VRR1(67,29)-3.D0*r1x2E*ZxZpE*VRR1(97,17)+WQy*VRR1(97,29)
      VRR0(97,47)=V(115)+V(117)+PAy*VRR0(67,47)+WPy*VRR1(67,47)
      VRR0(97,48)=V(120)+V(122)+V(170)+PAy*VRR0(67,48)+WPy*VRR1(67,48)
      VRR0(97,49)=V(126)+V(128)+V(175)+PAy*VRR0(67,49)+WPy*VRR1(67,49)
      VRR0(97,50)=V(131)+V(133)+3.D0*V(178)+PAy*VRR0(67,50)+WPy*VRR1(67,50)
      VRR0(97,51)=V(135)+V(137)+PAy*VRR0(67,51)+WPy*VRR1(67,51)
      VRR0(97,52)=V(141)+V(143)+V(185)+PAy*VRR0(67,52)+WPy*VRR1(67,52)
      VRR0(97,53)=V(146)+V(148)+V(187)+PAy*VRR0(67,53)+WPy*VRR1(67,53)
      VRR0(97,54)=V(75)+3.D0*r1x2E*VRR0(97,18)+QCz*VRR0(97,33)-3.D0*r1x2E*ZxZpE*VRR1(97,18)+WQz*VRR1(97,33)
      VRR0(97,55)=V(76)+3.D0*r1x2E*VRR0(97,19)+QCz*VRR0(97,34)-3.D0*r1x2E*ZxZpE*VRR1(97,19)+WQz*VRR1(97,34)
      VRR0(97,56)=V(77)+4.D0*r1x2E*VRR0(97,20)+QCz*VRR0(97,35)-4.D0*r1x2E*ZxZpE*VRR1(97,20)+WQz*VRR1(97,35)
      VRR0(98,36)=V(188)+4.D0*r1x2E*VRR0(98,11)+QCx*VRR0(98,21)-4.D0*r1x2E*ZxZpE*VRR1(98,11)+WQx*VRR1(98,21)
      VRR0(98,37)=V(181)+4.D0*r1x2Z*VRR0(45,37)+PAy*VRR0(68,37)-4.D0*ExZpE*r1x2Z*VRR1(45,37)+WPy*VRR1(68,37)
      VRR0(98,38)=V(183)+4.D0*r1x2Z*VRR0(45,38)+PAy*VRR0(68,38)-4.D0*ExZpE*r1x2Z*VRR1(45,38)+WPy*VRR1(68,38)
      VRR0(98,39)=4.D0*r1x2Z*VRR0(45,39)+PAy*VRR0(68,39)-4.D0*ExZpE*r1x2Z*VRR1(45,39)+3.D0*HfxZpE*VRR1(68,23)+WPy*VRR1(68,39)
      VRR0(98,40)=4.D0*r1x2Z*VRR0(45,40)+PAy*VRR0(68,40)-4.D0*ExZpE*r1x2Z*VRR1(45,40)+4.D0*HfxZpE*VRR1(68,24)+WPy*VRR1(68,40)
      VRR0(98,41)=4.D0*r1x2E*VRR0(98,14)+QCy*VRR0(98,25)+5.D0*HfxZpE*VRR1(68,25)-4.D0*r1x2E*ZxZpE*VRR1(98,14)+WQy*VRR1(98,25)
      VRR0(98,42)=4.D0*r1x2Z*VRR0(45,42)+PAy*VRR0(68,42)-4.D0*ExZpE*r1x2Z*VRR1(45,42)+WPy*VRR1(68,42)
      VRR0(98,43)=V(184)+4.D0*r1x2Z*VRR0(45,43)+PAy*VRR0(68,43)-4.D0*ExZpE*r1x2Z*VRR1(45,43)+WPy*VRR1(68,43)
      VRR0(98,44)=4.D0*V(164)-4.D0*V(165)+PAy*VRR0(68,44)+2.D0*HfxZpE*VRR1(68,27)+WPy*VRR1(68,44)
      VRR0(98,45)=4.D0*r1x2Z*VRR0(45,45)+PAy*VRR0(68,45)-4.D0*ExZpE*r1x2Z*VRR1(45,45)+3.D0*HfxZpE*VRR1(68,28)+WPy*VRR1(68,45)
      VRR0(98,46)=4.D0*r1x2Z*VRR0(45,46)+PAy*VRR0(68,46)-4.D0*ExZpE*r1x2Z*VRR1(45,46)+4.D0*HfxZpE*VRR1(68,29)+WPy*VRR1(68,46)
      VRR0(98,47)=4.D0*r1x2Z*VRR0(45,47)+PAy*VRR0(68,47)-4.D0*ExZpE*r1x2Z*VRR1(45,47)+WPy*VRR1(68,47)
      VRR0(98,48)=4.D0*V(172)-4.D0*V(173)+PAy*VRR0(68,48)+HfxZpE*VRR1(68,30)+WPy*VRR1(68,48)
      VRR0(98,49)=4.D0*V(176)-4.D0*V(177)+PAy*VRR0(68,49)+2.D0*HfxZpE*VRR1(68,31)+WPy*VRR1(68,49)
      VRR0(98,50)=4.D0*r1x2Z*VRR0(45,50)+PAy*VRR0(68,50)-4.D0*ExZpE*r1x2Z*VRR1(45,50)+3.D0*HfxZpE*VRR1(68,32)+WPy*VRR1(68,50)
      VRR0(98,51)=4.D0*r1x2Z*VRR0(45,51)+PAy*VRR0(68,51)-4.D0*ExZpE*r1x2Z*VRR1(45,51)+WPy*VRR1(68,51)
      VRR0(98,52)=V(189)+4.D0*r1x2Z*VRR0(45,52)+PAy*VRR0(68,52)-4.D0*ExZpE*r1x2Z*VRR1(45,52)+WPy*VRR1(68,52)
      VRR0(98,53)=V(191)+4.D0*r1x2Z*VRR0(45,53)+PAy*VRR0(68,53)-4.D0*ExZpE*r1x2Z*VRR1(45,53)+WPy*VRR1(68,53)
      VRR0(98,54)=4.D0*r1x2Z*VRR0(45,54)+PAy*VRR0(68,54)-4.D0*ExZpE*r1x2Z*VRR1(45,54)+WPy*VRR1(68,54)
      VRR0(98,55)=V(192)+4.D0*r1x2Z*VRR0(45,55)+PAy*VRR0(68,55)-4.D0*ExZpE*r1x2Z*VRR1(45,55)+WPy*VRR1(68,55)
      VRR0(98,56)=V(78)+4.D0*r1x2E*VRR0(98,20)+QCz*VRR0(98,35)-4.D0*r1x2E*ZxZpE*VRR1(98,20)+WQz*VRR1(98,35)
      VRR0(99,36)=5.D0*r1x2Z*VRR0(46,36)+PAy*VRR0(69,36)-5.D0*ExZpE*r1x2Z*VRR1(46,36)+WPy*VRR1(69,36)
      VRR0(99,37)=V(188)+5.D0*r1x2Z*VRR0(46,37)+PAy*VRR0(69,37)-5.D0*ExZpE*r1x2Z*VRR1(46,37)+WPy*VRR1(69,37)
      VRR0(99,38)=5.D0*r1x2Z*VRR0(46,38)+PAy*VRR0(69,38)-5.D0*ExZpE*r1x2Z*VRR1(46,38)+2.D0*HfxZpE*VRR1(69,22)+WPy*VRR1(69,38)
      VRR0(99,39)=5.D0*r1x2Z*VRR0(46,39)+PAy*VRR0(69,39)-5.D0*ExZpE*r1x2Z*VRR1(46,39)+3.D0*HfxZpE*VRR1(69,23)+WPy*VRR1(69,39)
      VRR0(99,40)=5.D0*r1x2Z*VRR0(46,40)+PAy*VRR0(69,40)-5.D0*ExZpE*r1x2Z*VRR1(46,40)+4.D0*HfxZpE*VRR1(69,24)+WPy*VRR1(69,40)
      VRR0(99,41)=5.D0*r1x2Z*VRR0(46,41)+PAy*VRR0(69,41)-5.D0*ExZpE*r1x2Z*VRR1(46,41)+5.D0*HfxZpE*VRR1(69,25)+WPy*VRR1(69,41)
      VRR0(99,42)=5.D0*r1x2Z*VRR0(46,42)+PAy*VRR0(69,42)-5.D0*ExZpE*r1x2Z*VRR1(46,42)+WPy*VRR1(69,42)
      VRR0(99,43)=5.D0*r1x2Z*VRR0(46,43)+PAy*VRR0(69,43)-5.D0*ExZpE*r1x2Z*VRR1(46,43)+HfxZpE*VRR1(69,26)+WPy*VRR1(69,43)
      VRR0(99,44)=5.D0*r1x2Z*VRR0(46,44)+PAy*VRR0(69,44)-5.D0*ExZpE*r1x2Z*VRR1(46,44)+2.D0*HfxZpE*VRR1(69,27)+WPy*VRR1(69,44)
      VRR0(99,45)=5.D0*r1x2Z*VRR0(46,45)+PAy*VRR0(69,45)-5.D0*ExZpE*r1x2Z*VRR1(46,45)+3.D0*HfxZpE*VRR1(69,28)+WPy*VRR1(69,45)
      VRR0(99,46)=5.D0*r1x2Z*VRR0(46,46)+PAy*VRR0(69,46)-5.D0*ExZpE*r1x2Z*VRR1(46,46)+4.D0*HfxZpE*VRR1(69,29)+WPy*VRR1(69,46)
      VRR0(99,47)=5.D0*r1x2Z*VRR0(46,47)+PAy*VRR0(69,47)-5.D0*ExZpE*r1x2Z*VRR1(46,47)+WPy*VRR1(69,47)
      VRR0(99,48)=5.D0*r1x2Z*VRR0(46,48)+PAy*VRR0(69,48)-5.D0*ExZpE*r1x2Z*VRR1(46,48)+HfxZpE*VRR1(69,30)+WPy*VRR1(69,48)
      VRR0(99,49)=5.D0*r1x2Z*VRR0(46,49)+PAy*VRR0(69,49)-5.D0*ExZpE*r1x2Z*VRR1(46,49)+2.D0*HfxZpE*VRR1(69,31)+WPy*VRR1(69,49)
      VRR0(99,50)=5.D0*r1x2Z*VRR0(46,50)+PAy*VRR0(69,50)-5.D0*ExZpE*r1x2Z*VRR1(46,50)+3.D0*HfxZpE*VRR1(69,32)+WPy*VRR1(69,50)
      VRR0(99,51)=5.D0*r1x2Z*VRR0(46,51)+PAy*VRR0(69,51)-5.D0*ExZpE*r1x2Z*VRR1(46,51)+WPy*VRR1(69,51)
      VRR0(99,52)=5.D0*r1x2Z*VRR0(46,52)+PAy*VRR0(69,52)-5.D0*ExZpE*r1x2Z*VRR1(46,52)+HfxZpE*VRR1(69,33)+WPy*VRR1(69,52)
      VRR0(99,53)=5.D0*r1x2Z*VRR0(46,53)+PAy*VRR0(69,53)-5.D0*ExZpE*r1x2Z*VRR1(46,53)+2.D0*HfxZpE*VRR1(69,34)+WPy*VRR1(69,53)
      VRR0(99,54)=5.D0*r1x2Z*VRR0(46,54)+PAy*VRR0(69,54)-5.D0*ExZpE*r1x2Z*VRR1(46,54)+WPy*VRR1(69,54)
      VRR0(99,55)=V(193)+5.D0*r1x2Z*VRR0(46,55)+PAy*VRR0(69,55)-5.D0*ExZpE*r1x2Z*VRR1(46,55)+WPy*VRR1(69,55)
      VRR0(99,56)=5.D0*r1x2Z*VRR0(46,56)+PAy*VRR0(69,56)-5.D0*ExZpE*r1x2Z*VRR1(46,56)+WPy*VRR1(69,56)
      VRR0(100,36)=4.D0*r1x2E*VRR0(100,11)+QCx*VRR0(100,21)+5.D0*HfxZpE*VRR1(70,21)-4.D0*r1x2E*ZxZpE*VRR1(100,11)+WQx*VRR1(100,21)
      VRR0(100,37)=4.D0*r1x2Z*VRR0(47,37)+PAx*VRR0(70,37)-4.D0*ExZpE*r1x2Z*VRR1(47,37)+4.D0*HfxZpE*VRR1(70,22)+WPx*VRR1(70,37)
      VRR0(100,38)=4.D0*V(194)-4.D0*V(195)+PAx*VRR0(70,38)+3.D0*HfxZpE*VRR1(70,23)+WPx*VRR1(70,38)
      VRR0(100,39)=4.D0*V(196)-4.D0*V(197)+2.D0*V(198)+PAx*VRR0(70,39)+WPx*VRR1(70,39)
      VRR0(100,40)=V(199)+4.D0*r1x2Z*VRR0(47,40)+PAx*VRR0(70,40)-4.D0*ExZpE*r1x2Z*VRR1(47,40)+WPx*VRR1(70,40)
      VRR0(100,41)=4.D0*r1x2E*VRR0(100,14)+QCy*VRR0(100,25)-4.D0*r1x2E*ZxZpE*VRR1(100,14)+WQy*VRR1(100,25)
      VRR0(100,42)=4.D0*r1x2Z*VRR0(47,42)+PAx*VRR0(70,42)-4.D0*ExZpE*r1x2Z*VRR1(47,42)+4.D0*HfxZpE*VRR1(70,26)+WPx*VRR1(70,42)
      VRR0(100,43)=4.D0*V(200)-4.D0*V(201)+PAx*VRR0(70,43)+3.D0*HfxZpE*VRR1(70,27)+WPx*VRR1(70,43)
      VRR0(100,44)=4.D0*V(202)-4.D0*V(203)+PAx*VRR0(70,44)+2.D0*HfxZpE*VRR1(70,28)+WPx*VRR1(70,44)
      VRR0(100,45)=4.D0*V(204)-4.D0*V(205)+V(206)+PAx*VRR0(70,45)+WPx*VRR1(70,45)
      VRR0(100,46)=4.D0*r1x2Z*VRR0(47,46)+PAx*VRR0(70,46)-4.D0*ExZpE*r1x2Z*VRR1(47,46)+WPx*VRR1(70,46)
      VRR0(100,47)=4.D0*V(207)-4.D0*V(208)+PAx*VRR0(70,47)+3.D0*HfxZpE*VRR1(70,30)+WPx*VRR1(70,47)
      VRR0(100,48)=4.D0*V(209)-4.D0*V(210)+PAx*VRR0(70,48)+2.D0*HfxZpE*VRR1(70,31)+WPx*VRR1(70,48)
      VRR0(100,49)=4.D0*V(211)-4.D0*V(212)+PAx*VRR0(70,49)+HfxZpE*VRR1(70,32)+WPx*VRR1(70,49)
      VRR0(100,50)=4.D0*V(213)-4.D0*V(214)+PAx*VRR0(70,50)+WPx*VRR1(70,50)
      VRR0(100,51)=4.D0*V(215)-4.D0*V(216)+2.D0*V(217)+PAx*VRR0(70,51)+WPx*VRR1(70,51)
      VRR0(100,52)=4.D0*V(218)-4.D0*V(219)+V(220)+PAx*VRR0(70,52)+WPx*VRR1(70,52)
      VRR0(100,53)=4.D0*V(221)-4.D0*V(222)+PAx*VRR0(70,53)+WPx*VRR1(70,53)
      VRR0(100,54)=V(223)+4.D0*r1x2Z*VRR0(47,54)+PAx*VRR0(70,54)-4.D0*ExZpE*r1x2Z*VRR1(47,54)+WPx*VRR1(70,54)
      VRR0(100,55)=4.D0*r1x2Z*VRR0(47,55)+PAx*VRR0(70,55)-4.D0*ExZpE*r1x2Z*VRR1(47,55)+WPx*VRR1(70,55)
      VRR0(100,56)=2.D0*V(80)+4.D0*r1x2E*VRR0(100,20)+QCz*VRR0(100,35)-4.D0*r1x2E*ZxZpE*VRR1(100,20)+WQz*VRR1(100,35)
      VRR0(101,36)=4.D0*r1x2E*VRR0(101,11)+QCx*VRR0(101,21)+4.D0*HfxZpE*VRR1(71,21)-4.D0*r1x2E*ZxZpE*VRR1(101,11)+WQx*VRR1(101,21)
      VRR0(101,37)=3.D0*r1x2E*VRR0(101,12)+QCx*VRR0(101,22)+4.D0*HfxZpE*VRR1(71,22)-3.D0*r1x2E*ZxZpE*VRR1(101,12)+WQx*VRR1(101,22)
      VRR0(101,38)=V(225)+V(227)+3.D0*V(228)+PAx*VRR0(71,38)+WPx*VRR1(71,38)
      VRR0(101,39)=V(230)+V(232)+V(234)+PAx*VRR0(71,39)+WPx*VRR1(71,39)
      VRR0(101,40)=V(198)+3.D0*r1x2E*VRR0(101,13)+QCy*VRR0(101,24)-3.D0*r1x2E*ZxZpE*VRR1(101,13)+WQy*VRR1(101,24)
      VRR0(101,41)=V(199)+4.D0*r1x2E*VRR0(101,14)+QCy*VRR0(101,25)-4.D0*r1x2E*ZxZpE*VRR1(101,14)+WQy*VRR1(101,25)
      VRR0(101,42)=3.D0*r1x2E*VRR0(101,15)+QCx*VRR0(101,26)+4.D0*HfxZpE*VRR1(71,26)-3.D0*r1x2E*ZxZpE*VRR1(101,15)+WQx*VRR1(101,26)
      VRR0(101,43)=V(236)+V(238)+PAx*VRR0(71,43)+3.D0*HfxZpE*VRR1(71,27)+WPx*VRR1(71,43)
      VRR0(101,44)=V(240)+V(242)+V(244)+PAx*VRR0(71,44)+WPx*VRR1(71,44)
      VRR0(101,45)=V(246)+V(248)+V(249)+PAx*VRR0(71,45)+WPx*VRR1(71,45)
      VRR0(101,46)=V(206)+3.D0*r1x2E*VRR0(101,17)+QCy*VRR0(101,29)-3.D0*r1x2E*ZxZpE*VRR1(101,17)+WQy*VRR1(101,29)
      VRR0(101,47)=V(251)+V(253)+V(255)+PAx*VRR0(71,47)+WPx*VRR1(71,47)
      VRR0(101,48)=V(257)+V(259)+2.D0*V(260)+PAx*VRR0(71,48)+WPx*VRR1(71,48)
      VRR0(101,49)=V(262)+V(264)+V(265)+PAx*VRR0(71,49)+WPx*VRR1(71,49)
      VRR0(101,50)=V(267)+V(269)+PAx*VRR0(71,50)+WPx*VRR1(71,50)
      VRR0(101,51)=V(271)+V(273)+2.D0*V(274)+PAx*VRR0(71,51)+WPx*VRR1(71,51)
      VRR0(101,52)=V(276)+V(278)+V(279)+PAx*VRR0(71,52)+WPx*VRR1(71,52)
      VRR0(101,53)=V(281)+V(283)+PAx*VRR0(71,53)+WPx*VRR1(71,53)
      VRR0(101,54)=V(86)+3.D0*r1x2E*VRR0(101,18)+QCz*VRR0(101,33)-3.D0*r1x2E*ZxZpE*VRR1(101,18)+WQz*VRR1(101,33)
      VRR0(101,55)=2.D0*V(87)+3.D0*r1x2E*VRR0(101,19)+QCz*VRR0(101,34)-3.D0*r1x2E*ZxZpE*VRR1(101,19)+WQz*VRR1(101,34)
      VRR0(101,56)=2.D0*V(88)+4.D0*r1x2E*VRR0(101,20)+QCz*VRR0(101,35)-4.D0*r1x2E*ZxZpE*VRR1(101,20)+WQz*VRR1(101,35)
      VRR0(102,36)=4.D0*r1x2E*VRR0(102,11)+QCx*VRR0(102,21)+3.D0*HfxZpE*VRR1(72,21)-4.D0*r1x2E*ZxZpE*VRR1(102,11)+WQx*VRR1(102,21)
      VRR0(102,37)=3.D0*V(284)-3.D0*V(285)+QCx*VRR0(102,22)+3.D0*HfxZpE*VRR1(72,22)+WQx*VRR1(102,22)
      VRR0(102,38)=2.D0*V(286)+V(288)-2.D0*V(289)+QCx*VRR0(102,23)+WQx*VRR1(102,23)
      VRR0(102,39)=2.D0*V(228)+2.D0*V(284)-2.D0*V(285)+QCy*VRR0(102,23)+WQy*VRR1(102,23)
      VRR0(102,40)=V(234)+3.D0*V(286)-3.D0*V(289)+QCy*VRR0(102,24)+WQy*VRR1(102,24)
      VRR0(102,41)=4.D0*r1x2E*VRR0(102,14)+QCy*VRR0(102,25)+2.D0*HfxZpE*VRR1(71,25)-4.D0*r1x2E*ZxZpE*VRR1(102,14)+WQy*VRR1(102,25)
      VRR0(102,42)=3.D0*V(290)-3.D0*V(291)+QCx*VRR0(102,26)+3.D0*HfxZpE*VRR1(72,26)+WQx*VRR1(102,26)
      VRR0(102,43)=V(293)+3.D0*V(294)+V(296)+QCx*VRR0(102,27)+WQx*VRR1(102,27)
      VRR0(102,44)=2.D0*V(297)-2.D0*V(298)+V(300)+PAx*VRR0(72,44)+WPx*VRR1(72,44)
      VRR0(102,45)=V(244)+V(293)+V(296)+QCy*VRR0(102,28)+WQy*VRR1(102,28)
      VRR0(102,46)=2.D0*V(249)+3.D0*V(301)-3.D0*V(302)+QCy*VRR0(102,29)+WQy*VRR1(102,29)
      VRR0(102,47)=2.D0*V(303)+V(305)-2.D0*V(306)+QCx*VRR0(102,30)+WQx*VRR1(102,30)
      VRR0(102,48)=2.D0*V(307)-2.D0*V(308)+V(310)+PAx*VRR0(72,48)+WPx*VRR1(72,48)
      VRR0(102,49)=2.D0*V(311)-2.D0*V(312)+V(313)+PAx*VRR0(72,49)+WPx*VRR1(72,49)
      VRR0(102,50)=2.D0*V(265)+2.D0*V(314)-2.D0*V(315)+QCy*VRR0(102,32)+WQy*VRR1(102,32)
      VRR0(102,51)=2.D0*V(118)+2.D0*V(290)-2.D0*V(291)+QCz*VRR0(102,30)+WQz*VRR1(102,30)
      VRR0(102,52)=V(124)+V(293)+V(296)+QCz*VRR0(102,31)+WQz*VRR1(102,31)
      VRR0(102,53)=2.D0*V(129)+2.D0*V(301)-2.D0*V(302)+QCz*VRR0(102,32)+WQz*VRR1(102,32)
      VRR0(102,54)=V(139)+3.D0*V(303)-3.D0*V(306)+QCz*VRR0(102,33)+WQz*VRR1(102,33)
      VRR0(102,55)=2.D0*V(144)+3.D0*V(314)-3.D0*V(315)+QCz*VRR0(102,34)+WQz*VRR1(102,34)
      VRR0(102,56)=4.D0*r1x2E*VRR0(102,20)+QCz*VRR0(102,35)+2.D0*HfxZpE*VRR1(66,35)-4.D0*r1x2E*ZxZpE*VRR1(102,20)+WQz*VRR1(102,35)
      VRR0(103,36)=4.D0*r1x2E*VRR0(103,11)+QCx*VRR0(103,21)+2.D0*HfxZpE*VRR1(73,21)-4.D0*r1x2E*ZxZpE*VRR1(103,11)+WQx*VRR1(103,21)
      VRR0(103,37)=3.D0*V(316)+V(318)-3.D0*V(319)+QCx*VRR0(103,22)+WQx*VRR1(103,22)
      VRR0(103,38)=2.D0*V(320)+2.D0*V(321)-2.D0*V(322)+QCx*VRR0(103,23)+WQx*VRR1(103,23)
      VRR0(103,39)=V(288)+2.D0*V(316)-2.D0*V(319)+QCy*VRR0(103,23)+WQy*VRR1(103,23)
      VRR0(103,40)=3.D0*V(320)-3.D0*V(322)+QCy*VRR0(103,24)+3.D0*HfxZpE*VRR1(72,24)+WQy*VRR1(103,24)
      VRR0(103,41)=4.D0*r1x2E*VRR0(103,14)+QCy*VRR0(103,25)+3.D0*HfxZpE*VRR1(72,25)-4.D0*r1x2E*ZxZpE*VRR1(103,14)+WQy*VRR1(103,25)
      VRR0(103,42)=3.D0*V(323)+2.D0*V(324)-3.D0*V(325)+QCx*VRR0(103,26)+WQx*VRR1(103,26)
      VRR0(103,43)=V(327)+V(329)+V(331)+QCx*VRR0(103,27)+WQx*VRR1(103,27)
      VRR0(103,44)=2.D0*V(239)-2.D0*V(241)+V(332)+PAy*VRR0(72,44)+WPy*VRR1(72,44)
      VRR0(103,45)=3.D0*V(299)+V(327)+V(331)+QCy*VRR0(103,28)+WQy*VRR1(103,28)
      VRR0(103,46)=3.D0*V(333)-3.D0*V(334)+QCy*VRR0(103,29)+3.D0*HfxZpE*VRR1(72,29)+WQy*VRR1(103,29)
      VRR0(103,47)=2.D0*V(335)+2.D0*V(336)-2.D0*V(337)+QCx*VRR0(103,30)+WQx*VRR1(103,30)
      VRR0(103,48)=2.D0*V(256)-2.D0*V(258)+V(304)+PAy*VRR0(72,48)+WPy*VRR1(72,48)
      VRR0(103,49)=2.D0*V(261)-2.D0*V(263)+V(310)+PAy*VRR0(72,49)+WPy*VRR1(72,49)
      VRR0(103,50)=2.D0*V(338)+V(339)-2.D0*V(340)+QCy*VRR0(103,32)+WQy*VRR1(103,32)
      VRR0(103,51)=2.D0*V(170)+2.D0*V(323)-2.D0*V(325)+QCz*VRR0(103,30)+WQz*VRR1(103,30)
      VRR0(103,52)=V(175)+V(327)+V(331)+QCz*VRR0(103,31)+WQz*VRR1(103,31)
      VRR0(103,53)=2.D0*V(178)+2.D0*V(333)-2.D0*V(334)+QCz*VRR0(103,32)+WQz*VRR1(103,32)
      VRR0(103,54)=2.D0*V(185)+3.D0*V(335)-3.D0*V(337)+QCz*VRR0(103,33)+WQz*VRR1(103,33)
      VRR0(103,55)=V(187)+3.D0*V(338)-3.D0*V(340)+QCz*VRR0(103,34)+WQz*VRR1(103,34)
      VRR0(103,56)=4.D0*r1x2E*VRR0(103,20)+QCz*VRR0(103,35)+2.D0*HfxZpE*VRR1(67,35)-4.D0*r1x2E*ZxZpE*VRR1(103,20)+WQz*VRR1(103,35)
      VRR0(104,36)=V(341)+4.D0*r1x2E*VRR0(104,11)+QCx*VRR0(104,21)-4.D0*r1x2E*ZxZpE*VRR1(104,11)+WQx*VRR1(104,21)
      VRR0(104,37)=V(342)+3.D0*r1x2E*VRR0(104,12)+QCx*VRR0(104,22)-3.D0*r1x2E*ZxZpE*VRR1(104,12)+WQx*VRR1(104,22)
      VRR0(104,38)=V(318)+V(344)+V(346)+PAy*VRR0(73,38)+WPy*VRR1(73,38)
      VRR0(104,39)=3.D0*V(321)+V(348)+V(350)+PAy*VRR0(73,39)+WPy*VRR1(73,39)
      VRR0(104,40)=3.D0*r1x2E*VRR0(104,13)+QCy*VRR0(104,24)+4.D0*HfxZpE*VRR1(73,24)-3.D0*r1x2E*ZxZpE*VRR1(104,13)+WQy*VRR1(104,24)
      VRR0(104,41)=4.D0*r1x2E*VRR0(104,14)+QCy*VRR0(104,25)+4.D0*HfxZpE*VRR1(73,25)-4.D0*r1x2E*ZxZpE*VRR1(104,14)+WQy*VRR1(104,25)
      VRR0(104,42)=V(351)+3.D0*r1x2E*VRR0(104,15)+QCx*VRR0(104,26)-3.D0*r1x2E*ZxZpE*VRR1(104,15)+WQx*VRR1(104,26)
      VRR0(104,43)=V(324)+V(353)+V(355)+PAy*VRR0(73,43)+WPy*VRR1(73,43)
      VRR0(104,44)=V(329)+V(356)+V(357)+PAy*VRR0(73,44)+WPy*VRR1(73,44)
      VRR0(104,45)=V(359)+V(361)+PAy*VRR0(73,45)+3.D0*HfxZpE*VRR1(73,28)+WPy*VRR1(73,45)
      VRR0(104,46)=3.D0*r1x2E*VRR0(104,17)+QCy*VRR0(104,29)+4.D0*HfxZpE*VRR1(73,29)-3.D0*r1x2E*ZxZpE*VRR1(104,17)+WQy*VRR1(104,29)
      VRR0(104,47)=V(363)+V(365)+PAy*VRR0(73,47)+WPy*VRR1(73,47)
      VRR0(104,48)=V(336)+V(366)+V(367)+PAy*VRR0(73,48)+WPy*VRR1(73,48)
      VRR0(104,49)=V(368)+V(369)+2.D0*V(370)+PAy*VRR0(73,49)+WPy*VRR1(73,49)
      VRR0(104,50)=V(372)+V(374)+V(376)+PAy*VRR0(73,50)+WPy*VRR1(73,50)
      VRR0(104,51)=V(378)+V(380)+PAy*VRR0(73,51)+WPy*VRR1(73,51)
      VRR0(104,52)=V(382)+V(384)+V(385)+PAy*VRR0(73,52)+WPy*VRR1(73,52)
      VRR0(104,53)=V(387)+V(389)+2.D0*V(390)+PAy*VRR0(73,53)+WPy*VRR1(73,53)
      VRR0(104,54)=2.D0*V(189)+3.D0*r1x2E*VRR0(104,18)+QCz*VRR0(104,33)-3.D0*r1x2E*ZxZpE*VRR1(104,18)+WQz*VRR1(104,33)
      VRR0(104,55)=V(191)+3.D0*r1x2E*VRR0(104,19)+QCz*VRR0(104,34)-3.D0*r1x2E*ZxZpE*VRR1(104,19)+WQz*VRR1(104,34)
      VRR0(104,56)=2.D0*V(192)+4.D0*r1x2E*VRR0(104,20)+QCz*VRR0(104,35)-4.D0*r1x2E*ZxZpE*VRR1(104,20)+WQz*VRR1(104,35)
      VRR0(105,36)=4.D0*r1x2E*VRR0(105,11)+QCx*VRR0(105,21)-4.D0*r1x2E*ZxZpE*VRR1(105,11)+WQx*VRR1(105,21)
      VRR0(105,37)=V(341)+4.D0*r1x2Z*VRR0(50,37)+PAy*VRR0(74,37)-4.D0*ExZpE*r1x2Z*VRR1(50,37)+WPy*VRR1(74,37)
      VRR0(105,38)=2.D0*V(342)+4.D0*V(391)-4.D0*V(392)+PAy*VRR0(74,38)+WPy*VRR1(74,38)
      VRR0(105,39)=4.D0*V(393)-4.D0*V(394)+PAy*VRR0(74,39)+3.D0*HfxZpE*VRR1(74,23)+WPy*VRR1(74,39)
      VRR0(105,40)=4.D0*r1x2Z*VRR0(50,40)+PAy*VRR0(74,40)-4.D0*ExZpE*r1x2Z*VRR1(50,40)+4.D0*HfxZpE*VRR1(74,24)+WPy*VRR1(74,40)
      VRR0(105,41)=4.D0*r1x2E*VRR0(105,14)+QCy*VRR0(105,25)+5.D0*HfxZpE*VRR1(74,25)-4.D0*r1x2E*ZxZpE*VRR1(105,14)+WQy*VRR1(105,25)
      VRR0(105,42)=4.D0*r1x2Z*VRR0(50,42)+PAy*VRR0(74,42)-4.D0*ExZpE*r1x2Z*VRR1(50,42)+WPy*VRR1(74,42)
      VRR0(105,43)=V(351)+4.D0*V(395)-4.D0*V(396)+PAy*VRR0(74,43)+WPy*VRR1(74,43)
      VRR0(105,44)=4.D0*V(397)-4.D0*V(398)+PAy*VRR0(74,44)+2.D0*HfxZpE*VRR1(74,27)+WPy*VRR1(74,44)
      VRR0(105,45)=4.D0*V(399)-4.D0*V(400)+PAy*VRR0(74,45)+3.D0*HfxZpE*VRR1(74,28)+WPy*VRR1(74,45)
      VRR0(105,46)=4.D0*r1x2Z*VRR0(50,46)+PAy*VRR0(74,46)-4.D0*ExZpE*r1x2Z*VRR1(50,46)+4.D0*HfxZpE*VRR1(74,29)+WPy*VRR1(74,46)
      VRR0(105,47)=4.D0*V(401)-4.D0*V(402)+PAy*VRR0(74,47)+WPy*VRR1(74,47)
      VRR0(105,48)=4.D0*V(403)-4.D0*V(404)+PAy*VRR0(74,48)+HfxZpE*VRR1(74,30)+WPy*VRR1(74,48)
      VRR0(105,49)=4.D0*V(405)-4.D0*V(406)+PAy*VRR0(74,49)+2.D0*HfxZpE*VRR1(74,31)+WPy*VRR1(74,49)
      VRR0(105,50)=4.D0*V(407)-4.D0*V(408)+PAy*VRR0(74,50)+3.D0*HfxZpE*VRR1(74,32)+WPy*VRR1(74,50)
      VRR0(105,51)=4.D0*V(409)-4.D0*V(410)+PAy*VRR0(74,51)+WPy*VRR1(74,51)
      VRR0(105,52)=4.D0*V(411)-4.D0*V(412)+V(413)+PAy*VRR0(74,52)+WPy*VRR1(74,52)
      VRR0(105,53)=4.D0*V(414)-4.D0*V(415)+2.D0*V(416)+PAy*VRR0(74,53)+WPy*VRR1(74,53)
      VRR0(105,54)=4.D0*r1x2Z*VRR0(50,54)+PAy*VRR0(74,54)-4.D0*ExZpE*r1x2Z*VRR1(50,54)+WPy*VRR1(74,54)
      VRR0(105,55)=V(417)+4.D0*r1x2Z*VRR0(50,55)+PAy*VRR0(74,55)-4.D0*ExZpE*r1x2Z*VRR1(50,55)+WPy*VRR1(74,55)
      VRR0(105,56)=2.D0*V(193)+4.D0*r1x2E*VRR0(105,20)+QCz*VRR0(105,35)-4.D0*r1x2E*ZxZpE*VRR1(105,20)+WQz*VRR1(105,35)
      VRR0(106,36)=4.D0*r1x2E*VRR0(106,11)+QCx*VRR0(106,21)+4.D0*HfxZpE*VRR1(75,21)-4.D0*r1x2E*ZxZpE*VRR1(106,11)+WQx*VRR1(106,21)
      VRR0(106,37)=4.D0*V(418)+3.D0*r1x2E*VRR0(106,12)+QCx*VRR0(106,22)-3.D0*r1x2E*ZxZpE*VRR1(106,12)+WQx*VRR1(106,22)
      VRR0(106,38)=3.D0*V(419)-3.D0*V(420)+3.D0*V(421)+PAx*VRR0(75,38)+WPx*VRR1(75,38)
      VRR0(106,39)=3.D0*V(422)-3.D0*V(423)+2.D0*V(424)+PAx*VRR0(75,39)+WPx*VRR1(75,39)
      VRR0(106,40)=3.D0*r1x2E*VRR0(106,13)+QCy*VRR0(106,24)-3.D0*r1x2E*ZxZpE*VRR1(106,13)+WQy*VRR1(106,24)
      VRR0(106,41)=4.D0*r1x2E*VRR0(106,14)+QCy*VRR0(106,25)-4.D0*r1x2E*ZxZpE*VRR1(106,14)+WQy*VRR1(106,25)
      VRR0(106,42)=4.D0*V(425)+3.D0*r1x2E*VRR0(106,15)+QCx*VRR0(106,26)-3.D0*r1x2E*ZxZpE*VRR1(106,15)+WQx*VRR1(106,26)
      VRR0(106,43)=3.D0*V(426)-3.D0*V(427)+3.D0*V(428)+PAx*VRR0(75,43)+WPx*VRR1(75,43)
      VRR0(106,44)=3.D0*V(429)-3.D0*V(430)+V(432)+PAx*VRR0(75,44)+WPx*VRR1(75,44)
      VRR0(106,45)=3.D0*V(433)-3.D0*V(434)+V(435)+PAx*VRR0(75,45)+WPx*VRR1(75,45)
      VRR0(106,46)=3.D0*r1x2E*VRR0(106,17)+QCy*VRR0(106,29)-3.D0*r1x2E*ZxZpE*VRR1(106,17)+WQy*VRR1(106,29)
      VRR0(106,47)=3.D0*V(436)-3.D0*V(437)+V(439)+PAx*VRR0(75,47)+WPx*VRR1(75,47)
      VRR0(106,48)=3.D0*V(440)-3.D0*V(441)+2.D0*V(442)+PAx*VRR0(75,48)+WPx*VRR1(75,48)
      VRR0(106,49)=3.D0*V(443)-3.D0*V(444)+V(445)+PAx*VRR0(75,49)+WPx*VRR1(75,49)
      VRR0(106,50)=3.D0*V(446)-3.D0*V(447)+PAx*VRR0(75,50)+WPx*VRR1(75,50)
      VRR0(106,51)=3.D0*V(448)-3.D0*V(449)+2.D0*V(450)+PAx*VRR0(75,51)+WPx*VRR1(75,51)
      VRR0(106,52)=3.D0*V(451)-3.D0*V(452)+V(453)+PAx*VRR0(75,52)+WPx*VRR1(75,52)
      VRR0(106,53)=3.D0*V(454)-3.D0*V(455)+PAx*VRR0(75,53)+WPx*VRR1(75,53)
      VRR0(106,54)=3.D0*V(217)+3.D0*r1x2E*VRR0(106,18)+QCz*VRR0(106,33)-3.D0*r1x2E*ZxZpE*VRR1(106,18)+WQz*VRR1(106,33)
      VRR0(106,55)=3.D0*V(220)+3.D0*r1x2E*VRR0(106,19)+QCz*VRR0(106,34)-3.D0*r1x2E*ZxZpE*VRR1(106,19)+WQz*VRR1(106,34)
      VRR0(106,56)=3.D0*V(223)+4.D0*r1x2E*VRR0(106,20)+QCz*VRR0(106,35)-4.D0*r1x2E*ZxZpE*VRR1(106,20)+WQz*VRR1(106,35)
      VRR0(107,36)=4.D0*r1x2E*VRR0(107,11)+QCx*VRR0(107,21)+3.D0*HfxZpE*VRR1(76,21)-4.D0*r1x2E*ZxZpE*VRR1(107,11)+WQx*VRR1(107,21)
      VRR0(107,37)=3.D0*V(456)+3.D0*V(457)-3.D0*V(458)+QCx*VRR0(107,22)+WQx*VRR1(107,22)
      VRR0(107,38)=2.D0*V(459)+3.D0*V(460)-2.D0*V(461)+QCx*VRR0(107,23)+WQx*VRR1(107,23)
      VRR0(107,39)=V(421)+2.D0*V(456)-2.D0*V(458)+QCy*VRR0(107,23)+WQy*VRR1(107,23)
      VRR0(107,40)=V(424)+3.D0*V(459)-3.D0*V(461)+QCy*VRR0(107,24)+WQy*VRR1(107,24)
      VRR0(107,41)=4.D0*r1x2E*VRR0(107,14)+QCy*VRR0(107,25)+HfxZpE*VRR1(75,25)-4.D0*r1x2E*ZxZpE*VRR1(107,14)+WQy*VRR1(107,25)
      VRR0(107,42)=3.D0*V(462)+3.D0*V(463)-3.D0*V(464)+QCx*VRR0(107,26)+WQx*VRR1(107,26)
      VRR0(107,43)=V(466)+3.D0*V(467)+V(469)+QCx*VRR0(107,27)+WQx*VRR1(107,27)
      VRR0(107,44)=V(471)+V(473)+V(475)+PAx*VRR0(76,44)+WPx*VRR1(76,44)
      VRR0(107,45)=V(431)+V(466)+V(469)+QCy*VRR0(107,28)+WQy*VRR1(107,28)
      VRR0(107,46)=V(435)+3.D0*V(476)-3.D0*V(477)+QCy*VRR0(107,29)+WQy*VRR1(107,29)
      VRR0(107,47)=2.D0*V(478)+V(480)-2.D0*V(481)+QCx*VRR0(107,30)+WQx*VRR1(107,30)
      VRR0(107,48)=V(483)+V(485)+2.D0*V(486)+PAx*VRR0(76,48)+WPx*VRR1(76,48)
      VRR0(107,49)=V(488)+V(490)+V(491)+PAx*VRR0(76,49)+WPx*VRR1(76,49)
      VRR0(107,50)=V(445)+2.D0*V(492)-2.D0*V(493)+QCy*VRR0(107,32)+WQy*VRR1(107,32)
      VRR0(107,51)=V(255)+2.D0*V(462)-2.D0*V(464)+QCz*VRR0(107,30)+WQz*VRR1(107,30)
      VRR0(107,52)=3.D0*V(260)+V(466)+V(469)+QCz*VRR0(107,31)+WQz*VRR1(107,31)
      VRR0(107,53)=3.D0*V(265)+2.D0*V(476)-2.D0*V(477)+QCz*VRR0(107,32)+WQz*VRR1(107,32)
      VRR0(107,54)=3.D0*V(274)+3.D0*V(478)-3.D0*V(481)+QCz*VRR0(107,33)+WQz*VRR1(107,33)
      VRR0(107,55)=3.D0*V(279)+3.D0*V(492)-3.D0*V(493)+QCz*VRR0(107,34)+WQz*VRR1(107,34)
      VRR0(107,56)=4.D0*r1x2E*VRR0(107,20)+QCz*VRR0(107,35)+3.D0*HfxZpE*VRR1(71,35)-4.D0*r1x2E*ZxZpE*VRR1(107,20)+WQz*VRR1(107,35)
      VRR0(108,36)=4.D0*r1x2E*VRR0(108,11)+QCx*VRR0(108,21)+2.D0*HfxZpE*VRR1(77,21)-4.D0*r1x2E*ZxZpE*VRR1(108,11)+WQx*VRR1(108,21)
      VRR0(108,37)=3.D0*V(494)+2.D0*V(495)-3.D0*V(496)+QCx*VRR0(108,22)+WQx*VRR1(108,22)
      VRR0(108,38)=2.D0*V(497)+2.D0*V(498)-2.D0*V(499)+QCx*VRR0(108,23)+WQx*VRR1(108,23)
      VRR0(108,39)=2.D0*V(460)+2.D0*V(494)-2.D0*V(496)+QCy*VRR0(108,23)+WQy*VRR1(108,23)
      VRR0(108,40)=3.D0*V(497)-3.D0*V(499)+2.D0*V(500)+QCy*VRR0(108,24)+WQy*VRR1(108,24)
      VRR0(108,41)=4.D0*r1x2E*VRR0(108,14)+QCy*VRR0(108,25)+2.D0*HfxZpE*VRR1(76,25)-4.D0*r1x2E*ZxZpE*VRR1(108,14)+WQy*VRR1(108,25)
      VRR0(108,42)=3.D0*V(501)+V(503)-3.D0*V(504)+QCx*VRR0(108,26)+WQx*VRR1(108,26)
      VRR0(108,43)=V(506)+V(508)+V(510)+QCx*VRR0(108,27)+WQx*VRR1(108,27)
      VRR0(108,44)=2.D0*V(104)-2.D0*V(106)+V(287)+PAz*VRR0(72,44)+WPz*VRR1(72,44)
      VRR0(108,45)=V(475)+V(506)+V(510)+QCy*VRR0(108,28)+WQy*VRR1(108,28)
      VRR0(108,46)=3.D0*V(511)+V(513)-3.D0*V(514)+QCy*VRR0(108,29)+WQy*VRR1(108,29)
      VRR0(108,47)=2.D0*V(515)+2.D0*V(516)-2.D0*V(517)+QCx*VRR0(108,30)+WQx*VRR1(108,30)
      VRR0(108,48)=2.D0*V(119)-2.D0*V(121)+V(332)+PAz*VRR0(72,48)+WPz*VRR1(72,48)
      VRR0(108,49)=2.D0*V(125)-2.D0*V(127)+V(300)+PAz*VRR0(72,49)+WPz*VRR1(72,49)
      VRR0(108,50)=2.D0*V(491)+2.D0*V(518)-2.D0*V(519)+QCy*VRR0(108,32)+WQy*VRR1(108,32)
      VRR0(108,51)=V(305)+2.D0*V(501)-2.D0*V(504)+QCz*VRR0(108,30)+WQz*VRR1(108,30)
      VRR0(108,52)=3.D0*V(309)+V(506)+V(510)+QCz*VRR0(108,31)+WQz*VRR1(108,31)
      VRR0(108,53)=V(339)+2.D0*V(511)-2.D0*V(514)+QCz*VRR0(108,32)+WQz*VRR1(108,32)
      VRR0(108,54)=3.D0*V(515)-3.D0*V(517)+QCz*VRR0(108,33)+3.D0*HfxZpE*VRR1(72,33)+WQz*VRR1(108,33)
      VRR0(108,55)=3.D0*V(518)-3.D0*V(519)+QCz*VRR0(108,34)+3.D0*HfxZpE*VRR1(72,34)+WQz*VRR1(108,34)
      VRR0(108,56)=4.D0*r1x2E*VRR0(108,20)+QCz*VRR0(108,35)+3.D0*HfxZpE*VRR1(72,35)-4.D0*r1x2E*ZxZpE*VRR1(108,20)+WQz*VRR1(108,35)
      VRR0(109,36)=4.D0*r1x2E*VRR0(109,11)+QCx*VRR0(109,21)+HfxZpE*VRR1(78,21)-4.D0*r1x2E*ZxZpE*VRR1(109,11)+WQx*VRR1(109,21)
      VRR0(109,37)=3.D0*V(520)+V(521)-3.D0*V(522)+QCx*VRR0(109,22)+WQx*VRR1(109,22)
      VRR0(109,38)=2.D0*V(523)+V(524)-2.D0*V(525)+QCx*VRR0(109,23)+WQx*VRR1(109,23)
      VRR0(109,39)=3.D0*V(498)+2.D0*V(520)-2.D0*V(522)+QCy*VRR0(109,23)+WQy*VRR1(109,23)
      VRR0(109,40)=3.D0*V(523)-3.D0*V(525)+3.D0*V(526)+QCy*VRR0(109,24)+WQy*VRR1(109,24)
      VRR0(109,41)=4.D0*r1x2E*VRR0(109,14)+QCy*VRR0(109,25)+3.D0*HfxZpE*VRR1(77,25)-4.D0*r1x2E*ZxZpE*VRR1(109,14)+WQy*VRR1(109,25)
      VRR0(109,42)=3.D0*V(527)+V(528)-3.D0*V(529)+QCx*VRR0(109,26)+WQx*VRR1(109,26)
      VRR0(109,43)=V(531)+V(532)+V(534)+QCx*VRR0(109,27)+WQx*VRR1(109,27)
      VRR0(109,44)=V(471)+V(473)+V(508)+PAy*VRR0(77,44)+WPy*VRR1(77,44)
      VRR0(109,45)=V(531)+V(534)+3.D0*V(535)+QCy*VRR0(109,28)+WQy*VRR1(109,28)
      VRR0(109,46)=3.D0*V(536)+3.D0*V(537)-3.D0*V(538)+QCy*VRR0(109,29)+WQy*VRR1(109,29)
      VRR0(109,47)=2.D0*V(539)+V(540)-2.D0*V(541)+QCx*VRR0(109,30)+WQx*VRR1(109,30)
      VRR0(109,48)=V(483)+V(485)+V(516)+PAy*VRR0(77,48)+WPy*VRR1(77,48)
      VRR0(109,49)=V(488)+V(490)+2.D0*V(542)+PAy*VRR0(77,49)+WPy*VRR1(77,49)
      VRR0(109,50)=2.D0*V(543)+V(545)-2.D0*V(546)+QCy*VRR0(109,32)+WQy*VRR1(109,32)
      VRR0(109,51)=3.D0*V(336)+2.D0*V(527)-2.D0*V(529)+QCz*VRR0(109,30)+WQz*VRR1(109,30)
      VRR0(109,52)=3.D0*V(370)+V(531)+V(534)+QCz*VRR0(109,31)+WQz*VRR1(109,31)
      VRR0(109,53)=V(376)+2.D0*V(536)-2.D0*V(538)+QCz*VRR0(109,32)+WQz*VRR1(109,32)
      VRR0(109,54)=3.D0*V(385)+3.D0*V(539)-3.D0*V(541)+QCz*VRR0(109,33)+WQz*VRR1(109,33)
      VRR0(109,55)=3.D0*V(390)+3.D0*V(543)-3.D0*V(546)+QCz*VRR0(109,34)+WQz*VRR1(109,34)
      VRR0(109,56)=4.D0*r1x2E*VRR0(109,20)+QCz*VRR0(109,35)+3.D0*HfxZpE*VRR1(73,35)-4.D0*r1x2E*ZxZpE*VRR1(109,20)+WQz*VRR1(109,35)
      VRR0(110,36)=4.D0*r1x2E*VRR0(110,11)+QCx*VRR0(110,21)-4.D0*r1x2E*ZxZpE*VRR1(110,11)+WQx*VRR1(110,21)
      VRR0(110,37)=3.D0*r1x2E*VRR0(110,12)+QCx*VRR0(110,22)-3.D0*r1x2E*ZxZpE*VRR1(110,12)+WQx*VRR1(110,22)
      VRR0(110,38)=2.D0*V(521)+3.D0*V(547)-3.D0*V(548)+PAy*VRR0(78,38)+WPy*VRR1(78,38)
      VRR0(110,39)=3.D0*V(524)+3.D0*V(549)-3.D0*V(550)+PAy*VRR0(78,39)+WPy*VRR1(78,39)
      VRR0(110,40)=4.D0*V(551)+3.D0*r1x2E*VRR0(110,13)+QCy*VRR0(110,24)-3.D0*r1x2E*ZxZpE*VRR1(110,13)+WQy*VRR1(110,24)
      VRR0(110,41)=4.D0*r1x2E*VRR0(110,14)+QCy*VRR0(110,25)+4.D0*HfxZpE*VRR1(78,25)-4.D0*r1x2E*ZxZpE*VRR1(110,14)+WQy*VRR1(110,25)
      VRR0(110,42)=3.D0*r1x2E*VRR0(110,15)+QCx*VRR0(110,26)-3.D0*r1x2E*ZxZpE*VRR1(110,15)+WQx*VRR1(110,26)
      VRR0(110,43)=V(528)+3.D0*V(552)-3.D0*V(553)+PAy*VRR0(78,43)+WPy*VRR1(78,43)
      VRR0(110,44)=3.D0*V(554)-3.D0*V(555)+V(556)+PAy*VRR0(78,44)+WPy*VRR1(78,44)
      VRR0(110,45)=3.D0*V(557)-3.D0*V(558)+3.D0*V(559)+PAy*VRR0(78,45)+WPy*VRR1(78,45)
      VRR0(110,46)=4.D0*V(560)+3.D0*r1x2E*VRR0(110,17)+QCy*VRR0(110,29)-3.D0*r1x2E*ZxZpE*VRR1(110,17)+WQy*VRR1(110,29)
      VRR0(110,47)=3.D0*V(561)-3.D0*V(562)+PAy*VRR0(78,47)+WPy*VRR1(78,47)
      VRR0(110,48)=V(540)+3.D0*V(563)-3.D0*V(564)+PAy*VRR0(78,48)+WPy*VRR1(78,48)
      VRR0(110,49)=3.D0*V(565)-3.D0*V(566)+2.D0*V(567)+PAy*VRR0(78,49)+WPy*VRR1(78,49)
      VRR0(110,50)=3.D0*V(568)-3.D0*V(569)+V(571)+PAy*VRR0(78,50)+WPy*VRR1(78,50)
      VRR0(110,51)=3.D0*V(572)-3.D0*V(573)+PAy*VRR0(78,51)+WPy*VRR1(78,51)
      VRR0(110,52)=3.D0*V(574)-3.D0*V(575)+V(576)+PAy*VRR0(78,52)+WPy*VRR1(78,52)
      VRR0(110,53)=3.D0*V(577)-3.D0*V(578)+2.D0*V(579)+PAy*VRR0(78,53)+WPy*VRR1(78,53)
      VRR0(110,54)=3.D0*V(413)+3.D0*r1x2E*VRR0(110,18)+QCz*VRR0(110,33)-3.D0*r1x2E*ZxZpE*VRR1(110,18)+WQz*VRR1(110,33)
      VRR0(110,55)=3.D0*V(416)+3.D0*r1x2E*VRR0(110,19)+QCz*VRR0(110,34)-3.D0*r1x2E*ZxZpE*VRR1(110,19)+WQz*VRR1(110,34)
      VRR0(110,56)=3.D0*V(417)+4.D0*r1x2E*VRR0(110,20)+QCz*VRR0(110,35)-4.D0*r1x2E*ZxZpE*VRR1(110,20)+WQz*VRR1(110,35)
      VRR0(111,36)=3.D0*V(580)+4.D0*r1x2E*VRR0(111,11)+QCx*VRR0(111,21)-4.D0*r1x2E*ZxZpE*VRR1(111,11)+WQx*VRR1(111,21)
      VRR0(111,37)=3.D0*V(581)+3.D0*r1x2E*VRR0(111,12)+QCx*VRR0(111,22)-3.D0*r1x2E*ZxZpE*VRR1(111,12)+WQx*VRR1(111,22)
      VRR0(111,38)=3.D0*V(194)-3.D0*V(195)+PAz*VRR0(75,38)+WPz*VRR1(75,38)
      VRR0(111,39)=3.D0*V(196)-3.D0*V(197)+PAz*VRR0(75,39)+WPz*VRR1(75,39)
      VRR0(111,40)=3.D0*r1x2E*VRR0(111,13)+QCy*VRR0(111,24)-3.D0*r1x2E*ZxZpE*VRR1(111,13)+WQy*VRR1(111,24)
      VRR0(111,41)=4.D0*r1x2E*VRR0(111,14)+QCy*VRR0(111,25)-4.D0*r1x2E*ZxZpE*VRR1(111,14)+WQy*VRR1(111,25)
      VRR0(111,42)=3.D0*V(582)+3.D0*r1x2E*VRR0(111,15)+QCx*VRR0(111,26)-3.D0*r1x2E*ZxZpE*VRR1(111,15)+WQx*VRR1(111,26)
      VRR0(111,43)=3.D0*V(200)-3.D0*V(201)+V(418)+PAz*VRR0(75,43)+WPz*VRR1(75,43)
      VRR0(111,44)=3.D0*V(202)-3.D0*V(203)+V(421)+PAz*VRR0(75,44)+WPz*VRR1(75,44)
      VRR0(111,45)=3.D0*V(204)-3.D0*V(205)+V(424)+PAz*VRR0(75,45)+WPz*VRR1(75,45)
      VRR0(111,46)=3.D0*r1x2E*VRR0(111,17)+QCy*VRR0(111,29)-3.D0*r1x2E*ZxZpE*VRR1(111,17)+WQy*VRR1(111,29)
      VRR0(111,47)=3.D0*V(207)-3.D0*V(208)+2.D0*V(425)+PAz*VRR0(75,47)+WPz*VRR1(75,47)
      VRR0(111,48)=3.D0*V(209)-3.D0*V(210)+2.D0*V(428)+PAz*VRR0(75,48)+WPz*VRR1(75,48)
      VRR0(111,49)=3.D0*V(211)-3.D0*V(212)+V(432)+PAz*VRR0(75,49)+WPz*VRR1(75,49)
      VRR0(111,50)=3.D0*V(213)-3.D0*V(214)+2.D0*V(435)+PAz*VRR0(75,50)+WPz*VRR1(75,50)
      VRR0(111,51)=3.D0*V(215)-3.D0*V(216)+V(439)+PAz*VRR0(75,51)+WPz*VRR1(75,51)
      VRR0(111,52)=3.D0*V(218)-3.D0*V(219)+3.D0*V(442)+PAz*VRR0(75,52)+WPz*VRR1(75,52)
      VRR0(111,53)=3.D0*V(221)-3.D0*V(222)+3.D0*V(445)+PAz*VRR0(75,53)+WPz*VRR1(75,53)
      VRR0(111,54)=4.D0*V(450)+3.D0*r1x2E*VRR0(111,18)+QCz*VRR0(111,33)-3.D0*r1x2E*ZxZpE*VRR1(111,18)+WQz*VRR1(111,33)
      VRR0(111,55)=4.D0*V(453)+3.D0*r1x2E*VRR0(111,19)+QCz*VRR0(111,34)-3.D0*r1x2E*ZxZpE*VRR1(111,19)+WQz*VRR1(111,34)
      VRR0(111,56)=4.D0*r1x2E*VRR0(111,20)+QCz*VRR0(111,35)+4.D0*HfxZpE*VRR1(75,35)-4.D0*r1x2E*ZxZpE*VRR1(111,20)+WQz*VRR1(111,35)
      VRR0(112,36)=2.D0*V(583)+4.D0*r1x2E*VRR0(112,11)+QCx*VRR0(112,21)-4.D0*r1x2E*ZxZpE*VRR1(112,11)+WQx*VRR1(112,21)
      VRR0(112,37)=2.D0*V(584)+3.D0*r1x2E*VRR0(112,12)+QCx*VRR0(112,22)-3.D0*r1x2E*ZxZpE*VRR1(112,12)+WQx*VRR1(112,22)
      VRR0(112,38)=V(225)+V(227)+PAz*VRR0(76,38)+WPz*VRR1(76,38)
      VRR0(112,39)=V(230)+V(232)+PAz*VRR0(76,39)+WPz*VRR1(76,39)
      VRR0(112,40)=V(585)+3.D0*r1x2E*VRR0(112,13)+QCy*VRR0(112,24)-3.D0*r1x2E*ZxZpE*VRR1(112,13)+WQy*VRR1(112,24)
      VRR0(112,41)=V(586)+4.D0*r1x2E*VRR0(112,14)+QCy*VRR0(112,25)-4.D0*r1x2E*ZxZpE*VRR1(112,14)+WQy*VRR1(112,25)
      VRR0(112,42)=V(588)+3.D0*r1x2E*VRR0(112,15)+QCx*VRR0(112,26)-3.D0*r1x2E*ZxZpE*VRR1(112,15)+WQx*VRR1(112,26)
      VRR0(112,43)=V(236)+V(238)+V(457)+PAz*VRR0(76,43)+WPz*VRR1(76,43)
      VRR0(112,44)=V(240)+V(242)+V(460)+PAz*VRR0(76,44)+WPz*VRR1(76,44)
      VRR0(112,45)=V(246)+V(248)+V(500)+PAz*VRR0(76,45)+WPz*VRR1(76,45)
      VRR0(112,46)=V(589)+3.D0*r1x2E*VRR0(112,17)+QCy*VRR0(112,29)-3.D0*r1x2E*ZxZpE*VRR1(112,17)+WQy*VRR1(112,29)
      VRR0(112,47)=V(251)+V(253)+2.D0*V(463)+PAz*VRR0(76,47)+WPz*VRR1(76,47)
      VRR0(112,48)=V(257)+V(259)+2.D0*V(467)+PAz*VRR0(76,48)+WPz*VRR1(76,48)
      VRR0(112,49)=V(262)+V(264)+V(475)+PAz*VRR0(76,49)+WPz*VRR1(76,49)
      VRR0(112,50)=V(267)+V(269)+V(513)+PAz*VRR0(76,50)+WPz*VRR1(76,50)
      VRR0(112,51)=V(271)+V(273)+V(480)+PAz*VRR0(76,51)+WPz*VRR1(76,51)
      VRR0(112,52)=V(276)+V(278)+3.D0*V(486)+PAz*VRR0(76,52)+WPz*VRR1(76,52)
      VRR0(112,53)=V(281)+V(283)+3.D0*V(491)+PAz*VRR0(76,53)+WPz*VRR1(76,53)
      VRR0(112,54)=3.D0*r1x2E*VRR0(112,18)+QCz*VRR0(112,33)+4.D0*HfxZpE*VRR1(76,33)-3.D0*r1x2E*ZxZpE*VRR1(112,18)+WQz*VRR1(112,33)
      VRR0(112,55)=3.D0*r1x2E*VRR0(112,19)+QCz*VRR0(112,34)+4.D0*HfxZpE*VRR1(76,34)-3.D0*r1x2E*ZxZpE*VRR1(112,19)+WQz*VRR1(112,34)
      VRR0(112,56)=4.D0*r1x2E*VRR0(112,20)+QCz*VRR0(112,35)+4.D0*HfxZpE*VRR1(76,35)-4.D0*r1x2E*ZxZpE*VRR1(112,20)+WQz*VRR1(112,35)
      VRR0(113,36)=V(590)+4.D0*r1x2E*VRR0(113,11)+QCx*VRR0(113,21)-4.D0*r1x2E*ZxZpE*VRR1(113,11)+WQx*VRR1(113,21)
      VRR0(113,37)=V(591)+3.D0*r1x2E*VRR0(113,12)+QCx*VRR0(113,22)-3.D0*r1x2E*ZxZpE*VRR1(113,12)+WQx*VRR1(113,22)
      VRR0(113,38)=V(344)+V(346)+PAz*VRR0(77,38)+WPz*VRR1(77,38)
      VRR0(113,39)=V(348)+V(350)+PAz*VRR0(77,39)+WPz*VRR1(77,39)
      VRR0(113,40)=2.D0*V(592)+3.D0*r1x2E*VRR0(113,13)+QCy*VRR0(113,24)-3.D0*r1x2E*ZxZpE*VRR1(113,13)+WQy*VRR1(113,24)
      VRR0(113,41)=2.D0*V(593)+4.D0*r1x2E*VRR0(113,14)+QCy*VRR0(113,25)-4.D0*r1x2E*ZxZpE*VRR1(113,14)+WQy*VRR1(113,25)
      VRR0(113,42)=V(594)+3.D0*r1x2E*VRR0(113,15)+QCx*VRR0(113,26)-3.D0*r1x2E*ZxZpE*VRR1(113,15)+WQx*VRR1(113,26)
      VRR0(113,43)=V(353)+V(355)+V(495)+PAz*VRR0(77,43)+WPz*VRR1(77,43)
      VRR0(113,44)=V(356)+V(357)+V(498)+PAz*VRR0(77,44)+WPz*VRR1(77,44)
      VRR0(113,45)=V(359)+V(361)+V(526)+PAz*VRR0(77,45)+WPz*VRR1(77,45)
      VRR0(113,46)=V(596)+3.D0*r1x2E*VRR0(113,17)+QCy*VRR0(113,29)-3.D0*r1x2E*ZxZpE*VRR1(113,17)+WQy*VRR1(113,29)
      VRR0(113,47)=V(363)+V(365)+V(503)+PAz*VRR0(77,47)+WPz*VRR1(77,47)
      VRR0(113,48)=V(366)+V(367)+V(508)+PAz*VRR0(77,48)+WPz*VRR1(77,48)
      VRR0(113,49)=V(368)+V(369)+2.D0*V(535)+PAz*VRR0(77,49)+WPz*VRR1(77,49)
      VRR0(113,50)=V(372)+V(374)+2.D0*V(537)+PAz*VRR0(77,50)+WPz*VRR1(77,50)
      VRR0(113,51)=V(378)+V(380)+3.D0*V(516)+PAz*VRR0(77,51)+WPz*VRR1(77,51)
      VRR0(113,52)=V(382)+V(384)+3.D0*V(542)+PAz*VRR0(77,52)+WPz*VRR1(77,52)
      VRR0(113,53)=V(387)+V(389)+V(545)+PAz*VRR0(77,53)+WPz*VRR1(77,53)
      VRR0(113,54)=3.D0*r1x2E*VRR0(113,18)+QCz*VRR0(113,33)+4.D0*HfxZpE*VRR1(77,33)-3.D0*r1x2E*ZxZpE*VRR1(113,18)+WQz*VRR1(113,33)
      VRR0(113,55)=3.D0*r1x2E*VRR0(113,19)+QCz*VRR0(113,34)+4.D0*HfxZpE*VRR1(77,34)-3.D0*r1x2E*ZxZpE*VRR1(113,19)+WQz*VRR1(113,34)
      VRR0(113,56)=4.D0*r1x2E*VRR0(113,20)+QCz*VRR0(113,35)+4.D0*HfxZpE*VRR1(77,35)-4.D0*r1x2E*ZxZpE*VRR1(113,20)+WQz*VRR1(113,35)
      VRR0(114,36)=4.D0*r1x2E*VRR0(114,11)+QCx*VRR0(114,21)-4.D0*r1x2E*ZxZpE*VRR1(114,11)+WQx*VRR1(114,21)
      VRR0(114,37)=3.D0*r1x2E*VRR0(114,12)+QCx*VRR0(114,22)-3.D0*r1x2E*ZxZpE*VRR1(114,12)+WQx*VRR1(114,22)
      VRR0(114,38)=3.D0*V(391)-3.D0*V(392)+PAz*VRR0(78,38)+WPz*VRR1(78,38)
      VRR0(114,39)=3.D0*V(393)-3.D0*V(394)+PAz*VRR0(78,39)+WPz*VRR1(78,39)
      VRR0(114,40)=3.D0*V(597)+3.D0*r1x2E*VRR0(114,13)+QCy*VRR0(114,24)-3.D0*r1x2E*ZxZpE*VRR1(114,13)+WQy*VRR1(114,24)
      VRR0(114,41)=3.D0*V(598)+4.D0*r1x2E*VRR0(114,14)+QCy*VRR0(114,25)-4.D0*r1x2E*ZxZpE*VRR1(114,14)+WQy*VRR1(114,25)
      VRR0(114,42)=3.D0*r1x2E*VRR0(114,15)+QCx*VRR0(114,26)-3.D0*r1x2E*ZxZpE*VRR1(114,15)+WQx*VRR1(114,26)
      VRR0(114,43)=3.D0*V(395)-3.D0*V(396)+V(521)+PAz*VRR0(78,43)+WPz*VRR1(78,43)
      VRR0(114,44)=3.D0*V(397)-3.D0*V(398)+V(524)+PAz*VRR0(78,44)+WPz*VRR1(78,44)
      VRR0(114,45)=3.D0*V(399)-3.D0*V(400)+V(551)+PAz*VRR0(78,45)+WPz*VRR1(78,45)
      VRR0(114,46)=3.D0*V(599)+3.D0*r1x2E*VRR0(114,17)+QCy*VRR0(114,29)-3.D0*r1x2E*ZxZpE*VRR1(114,17)+WQy*VRR1(114,29)
      VRR0(114,47)=3.D0*V(401)-3.D0*V(402)+2.D0*V(528)+PAz*VRR0(78,47)+WPz*VRR1(78,47)
      VRR0(114,48)=3.D0*V(403)-3.D0*V(404)+V(556)+PAz*VRR0(78,48)+WPz*VRR1(78,48)
      VRR0(114,49)=3.D0*V(405)-3.D0*V(406)+2.D0*V(559)+PAz*VRR0(78,49)+WPz*VRR1(78,49)
      VRR0(114,50)=3.D0*V(407)-3.D0*V(408)+2.D0*V(560)+PAz*VRR0(78,50)+WPz*VRR1(78,50)
      VRR0(114,51)=3.D0*V(409)-3.D0*V(410)+3.D0*V(540)+PAz*VRR0(78,51)+WPz*VRR1(78,51)
      VRR0(114,52)=3.D0*V(411)-3.D0*V(412)+3.D0*V(567)+PAz*VRR0(78,52)+WPz*VRR1(78,52)
      VRR0(114,53)=3.D0*V(414)-3.D0*V(415)+V(571)+PAz*VRR0(78,53)+WPz*VRR1(78,53)
      VRR0(114,54)=4.D0*V(576)+3.D0*r1x2E*VRR0(114,18)+QCz*VRR0(114,33)-3.D0*r1x2E*ZxZpE*VRR1(114,18)+WQz*VRR1(114,33)
      VRR0(114,55)=4.D0*V(579)+3.D0*r1x2E*VRR0(114,19)+QCz*VRR0(114,34)-3.D0*r1x2E*ZxZpE*VRR1(114,19)+WQz*VRR1(114,34)
      VRR0(114,56)=4.D0*r1x2E*VRR0(114,20)+QCz*VRR0(114,35)+4.D0*HfxZpE*VRR1(78,35)-4.D0*r1x2E*ZxZpE*VRR1(114,20)+WQz*VRR1(114,35)
      VRR0(115,36)=2.D0*V(600)+4.D0*r1x2E*VRR0(115,11)+QCx*VRR0(115,21)-4.D0*r1x2E*ZxZpE*VRR1(115,11)+WQx*VRR1(115,21)
      VRR0(115,37)=4.D0*r1x2Z*VRR0(51,37)+PAz*VRR0(79,37)-4.D0*ExZpE*r1x2Z*VRR1(51,37)+WPz*VRR1(79,37)
      VRR0(115,38)=4.D0*V(419)-4.D0*V(420)+PAz*VRR0(79,38)+WPz*VRR1(79,38)
      VRR0(115,39)=4.D0*V(422)-4.D0*V(423)+PAz*VRR0(79,39)+WPz*VRR1(79,39)
      VRR0(115,40)=4.D0*r1x2Z*VRR0(51,40)+PAz*VRR0(79,40)-4.D0*ExZpE*r1x2Z*VRR1(51,40)+WPz*VRR1(79,40)
      VRR0(115,41)=4.D0*r1x2E*VRR0(115,14)+QCy*VRR0(115,25)-4.D0*r1x2E*ZxZpE*VRR1(115,14)+WQy*VRR1(115,25)
      VRR0(115,42)=V(580)+4.D0*r1x2Z*VRR0(51,42)+PAz*VRR0(79,42)-4.D0*ExZpE*r1x2Z*VRR1(51,42)+WPz*VRR1(79,42)
      VRR0(115,43)=4.D0*V(426)-4.D0*V(427)+V(581)+PAz*VRR0(79,43)+WPz*VRR1(79,43)
      VRR0(115,44)=4.D0*V(429)-4.D0*V(430)+PAz*VRR0(79,44)+HfxZpE*VRR1(79,23)+WPz*VRR1(79,44)
      VRR0(115,45)=4.D0*V(433)-4.D0*V(434)+V(585)+PAz*VRR0(79,45)+WPz*VRR1(79,45)
      VRR0(115,46)=V(586)+4.D0*r1x2Z*VRR0(51,46)+PAz*VRR0(79,46)-4.D0*ExZpE*r1x2Z*VRR1(51,46)+WPz*VRR1(79,46)
      VRR0(115,47)=4.D0*V(436)-4.D0*V(437)+2.D0*V(582)+PAz*VRR0(79,47)+WPz*VRR1(79,47)
      VRR0(115,48)=4.D0*V(440)-4.D0*V(441)+PAz*VRR0(79,48)+2.D0*HfxZpE*VRR1(79,27)+WPz*VRR1(79,48)
      VRR0(115,49)=4.D0*V(443)-4.D0*V(444)+PAz*VRR0(79,49)+2.D0*HfxZpE*VRR1(79,28)+WPz*VRR1(79,49)
      VRR0(115,50)=4.D0*V(446)-4.D0*V(447)+2.D0*V(589)+PAz*VRR0(79,50)+WPz*VRR1(79,50)
      VRR0(115,51)=4.D0*V(448)-4.D0*V(449)+PAz*VRR0(79,51)+3.D0*HfxZpE*VRR1(79,30)+WPz*VRR1(79,51)
      VRR0(115,52)=4.D0*V(451)-4.D0*V(452)+PAz*VRR0(79,52)+3.D0*HfxZpE*VRR1(79,31)+WPz*VRR1(79,52)
      VRR0(115,53)=4.D0*V(454)-4.D0*V(455)+PAz*VRR0(79,53)+3.D0*HfxZpE*VRR1(79,32)+WPz*VRR1(79,53)
      VRR0(115,54)=4.D0*r1x2Z*VRR0(51,54)+PAz*VRR0(79,54)-4.D0*ExZpE*r1x2Z*VRR1(51,54)+4.D0*HfxZpE*VRR1(79,33)+WPz*VRR1(79,54)
      VRR0(115,55)=4.D0*r1x2Z*VRR0(51,55)+PAz*VRR0(79,55)-4.D0*ExZpE*r1x2Z*VRR1(51,55)+4.D0*HfxZpE*VRR1(79,34)+WPz*VRR1(79,55)
      VRR0(115,56)=4.D0*r1x2E*VRR0(115,20)+QCz*VRR0(115,35)+5.D0*HfxZpE*VRR1(79,35)-4.D0*r1x2E*ZxZpE*VRR1(115,20)+WQz*VRR1(115,35)
      VRR0(116,36)=V(601)+4.D0*r1x2E*VRR0(116,11)+QCx*VRR0(116,21)-4.D0*r1x2E*ZxZpE*VRR1(116,11)+WQx*VRR1(116,21)
      VRR0(116,37)=4.D0*r1x2Z*VRR0(52,37)+PAz*VRR0(80,37)-4.D0*ExZpE*r1x2Z*VRR1(52,37)+WPz*VRR1(80,37)
      VRR0(116,38)=4.D0*r1x2Z*VRR0(52,38)+PAz*VRR0(80,38)-4.D0*ExZpE*r1x2Z*VRR1(52,38)+WPz*VRR1(80,38)
      VRR0(116,39)=4.D0*r1x2Z*VRR0(52,39)+PAz*VRR0(80,39)-4.D0*ExZpE*r1x2Z*VRR1(52,39)+WPz*VRR1(80,39)
      VRR0(116,40)=4.D0*r1x2Z*VRR0(52,40)+PAz*VRR0(80,40)-4.D0*ExZpE*r1x2Z*VRR1(52,40)+WPz*VRR1(80,40)
      VRR0(116,41)=V(602)+4.D0*r1x2E*VRR0(116,14)+QCy*VRR0(116,25)-4.D0*r1x2E*ZxZpE*VRR1(116,14)+WQy*VRR1(116,25)
      VRR0(116,42)=V(583)+4.D0*r1x2Z*VRR0(52,42)+PAz*VRR0(80,42)-4.D0*ExZpE*r1x2Z*VRR1(52,42)+WPz*VRR1(80,42)
      VRR0(116,43)=V(584)+4.D0*r1x2Z*VRR0(52,43)+PAz*VRR0(80,43)-4.D0*ExZpE*r1x2Z*VRR1(52,43)+WPz*VRR1(80,43)
      VRR0(116,44)=4.D0*V(470)-4.D0*V(472)+PAz*VRR0(80,44)+HfxZpE*VRR1(80,23)+WPz*VRR1(80,44)
      VRR0(116,45)=V(592)+4.D0*r1x2Z*VRR0(52,45)+PAz*VRR0(80,45)-4.D0*ExZpE*r1x2Z*VRR1(52,45)+WPz*VRR1(80,45)
      VRR0(116,46)=V(593)+4.D0*r1x2Z*VRR0(52,46)+PAz*VRR0(80,46)-4.D0*ExZpE*r1x2Z*VRR1(52,46)+WPz*VRR1(80,46)
      VRR0(116,47)=V(588)+4.D0*r1x2Z*VRR0(52,47)+PAz*VRR0(80,47)-4.D0*ExZpE*r1x2Z*VRR1(52,47)+WPz*VRR1(80,47)
      VRR0(116,48)=4.D0*V(482)-4.D0*V(484)+PAz*VRR0(80,48)+2.D0*HfxZpE*VRR1(80,27)+WPz*VRR1(80,48)
      VRR0(116,49)=4.D0*V(487)-4.D0*V(489)+PAz*VRR0(80,49)+2.D0*HfxZpE*VRR1(80,28)+WPz*VRR1(80,49)
      VRR0(116,50)=V(596)+4.D0*r1x2Z*VRR0(52,50)+PAz*VRR0(80,50)-4.D0*ExZpE*r1x2Z*VRR1(52,50)+WPz*VRR1(80,50)
      VRR0(116,51)=4.D0*r1x2Z*VRR0(52,51)+PAz*VRR0(80,51)-4.D0*ExZpE*r1x2Z*VRR1(52,51)+3.D0*HfxZpE*VRR1(80,30)+WPz*VRR1(80,51)
      VRR0(116,52)=4.D0*r1x2Z*VRR0(52,52)+PAz*VRR0(80,52)-4.D0*ExZpE*r1x2Z*VRR1(52,52)+3.D0*HfxZpE*VRR1(80,31)+WPz*VRR1(80,52)
      VRR0(116,53)=4.D0*r1x2Z*VRR0(52,53)+PAz*VRR0(80,53)-4.D0*ExZpE*r1x2Z*VRR1(52,53)+3.D0*HfxZpE*VRR1(80,32)+WPz*VRR1(80,53)
      VRR0(116,54)=4.D0*r1x2Z*VRR0(52,54)+PAz*VRR0(80,54)-4.D0*ExZpE*r1x2Z*VRR1(52,54)+4.D0*HfxZpE*VRR1(80,33)+WPz*VRR1(80,54)
      VRR0(116,55)=4.D0*r1x2Z*VRR0(52,55)+PAz*VRR0(80,55)-4.D0*ExZpE*r1x2Z*VRR1(52,55)+4.D0*HfxZpE*VRR1(80,34)+WPz*VRR1(80,55)
      VRR0(116,56)=4.D0*r1x2E*VRR0(116,20)+QCz*VRR0(116,35)+5.D0*HfxZpE*VRR1(80,35)-4.D0*r1x2E*ZxZpE*VRR1(116,20)+WQz*VRR1(116,35)
      VRR0(117,36)=4.D0*r1x2E*VRR0(117,11)+QCx*VRR0(117,21)-4.D0*r1x2E*ZxZpE*VRR1(117,11)+WQx*VRR1(117,21)
      VRR0(117,37)=4.D0*r1x2Z*VRR0(53,37)+PAz*VRR0(81,37)-4.D0*ExZpE*r1x2Z*VRR1(53,37)+WPz*VRR1(81,37)
      VRR0(117,38)=4.D0*V(547)-4.D0*V(548)+PAz*VRR0(81,38)+WPz*VRR1(81,38)
      VRR0(117,39)=4.D0*V(549)-4.D0*V(550)+PAz*VRR0(81,39)+WPz*VRR1(81,39)
      VRR0(117,40)=4.D0*r1x2Z*VRR0(53,40)+PAz*VRR0(81,40)-4.D0*ExZpE*r1x2Z*VRR1(53,40)+WPz*VRR1(81,40)
      VRR0(117,41)=2.D0*V(603)+4.D0*r1x2E*VRR0(117,14)+QCy*VRR0(117,25)-4.D0*r1x2E*ZxZpE*VRR1(117,14)+WQy*VRR1(117,25)
      VRR0(117,42)=V(590)+4.D0*r1x2Z*VRR0(53,42)+PAz*VRR0(81,42)-4.D0*ExZpE*r1x2Z*VRR1(53,42)+WPz*VRR1(81,42)
      VRR0(117,43)=4.D0*V(552)-4.D0*V(553)+V(591)+PAz*VRR0(81,43)+WPz*VRR1(81,43)
      VRR0(117,44)=4.D0*V(554)-4.D0*V(555)+PAz*VRR0(81,44)+HfxZpE*VRR1(81,23)+WPz*VRR1(81,44)
      VRR0(117,45)=4.D0*V(557)-4.D0*V(558)+V(597)+PAz*VRR0(81,45)+WPz*VRR1(81,45)
      VRR0(117,46)=V(598)+4.D0*r1x2Z*VRR0(53,46)+PAz*VRR0(81,46)-4.D0*ExZpE*r1x2Z*VRR1(53,46)+WPz*VRR1(81,46)
      VRR0(117,47)=4.D0*V(561)-4.D0*V(562)+2.D0*V(594)+PAz*VRR0(81,47)+WPz*VRR1(81,47)
      VRR0(117,48)=4.D0*V(563)-4.D0*V(564)+PAz*VRR0(81,48)+2.D0*HfxZpE*VRR1(81,27)+WPz*VRR1(81,48)
      VRR0(117,49)=4.D0*V(565)-4.D0*V(566)+PAz*VRR0(81,49)+2.D0*HfxZpE*VRR1(81,28)+WPz*VRR1(81,49)
      VRR0(117,50)=4.D0*V(568)-4.D0*V(569)+2.D0*V(599)+PAz*VRR0(81,50)+WPz*VRR1(81,50)
      VRR0(117,51)=4.D0*V(572)-4.D0*V(573)+PAz*VRR0(81,51)+3.D0*HfxZpE*VRR1(81,30)+WPz*VRR1(81,51)
      VRR0(117,52)=4.D0*V(574)-4.D0*V(575)+PAz*VRR0(81,52)+3.D0*HfxZpE*VRR1(81,31)+WPz*VRR1(81,52)
      VRR0(117,53)=4.D0*V(577)-4.D0*V(578)+PAz*VRR0(81,53)+3.D0*HfxZpE*VRR1(81,32)+WPz*VRR1(81,53)
      VRR0(117,54)=4.D0*r1x2Z*VRR0(53,54)+PAz*VRR0(81,54)-4.D0*ExZpE*r1x2Z*VRR1(53,54)+4.D0*HfxZpE*VRR1(81,33)+WPz*VRR1(81,54)
      VRR0(117,55)=4.D0*r1x2Z*VRR0(53,55)+PAz*VRR0(81,55)-4.D0*ExZpE*r1x2Z*VRR1(53,55)+4.D0*HfxZpE*VRR1(81,34)+WPz*VRR1(81,55)
      VRR0(117,56)=4.D0*r1x2E*VRR0(117,20)+QCz*VRR0(117,35)+5.D0*HfxZpE*VRR1(81,35)-4.D0*r1x2E*ZxZpE*VRR1(117,20)+WQz*VRR1(117,35)
      VRR0(118,36)=5.D0*r1x2Z*VRR0(54,36)+PAz*VRR0(82,36)-5.D0*ExZpE*r1x2Z*VRR1(54,36)+WPz*VRR1(82,36)
      VRR0(118,37)=5.D0*r1x2Z*VRR0(54,37)+PAz*VRR0(82,37)-5.D0*ExZpE*r1x2Z*VRR1(54,37)+WPz*VRR1(82,37)
      VRR0(118,38)=5.D0*r1x2Z*VRR0(54,38)+PAz*VRR0(82,38)-5.D0*ExZpE*r1x2Z*VRR1(54,38)+WPz*VRR1(82,38)
      VRR0(118,39)=5.D0*r1x2Z*VRR0(54,39)+PAz*VRR0(82,39)-5.D0*ExZpE*r1x2Z*VRR1(54,39)+WPz*VRR1(82,39)
      VRR0(118,40)=5.D0*r1x2Z*VRR0(54,40)+PAz*VRR0(82,40)-5.D0*ExZpE*r1x2Z*VRR1(54,40)+WPz*VRR1(82,40)
      VRR0(118,41)=5.D0*r1x2Z*VRR0(54,41)+PAz*VRR0(82,41)-5.D0*ExZpE*r1x2Z*VRR1(54,41)+WPz*VRR1(82,41)
      VRR0(118,42)=V(600)+5.D0*r1x2Z*VRR0(54,42)+PAz*VRR0(82,42)-5.D0*ExZpE*r1x2Z*VRR1(54,42)+WPz*VRR1(82,42)
      VRR0(118,43)=5.D0*r1x2Z*VRR0(54,43)+PAz*VRR0(82,43)-5.D0*ExZpE*r1x2Z*VRR1(54,43)+HfxZpE*VRR1(82,22)+WPz*VRR1(82,43)
      VRR0(118,44)=5.D0*r1x2Z*VRR0(54,44)+PAz*VRR0(82,44)-5.D0*ExZpE*r1x2Z*VRR1(54,44)+HfxZpE*VRR1(82,23)+WPz*VRR1(82,44)
      VRR0(118,45)=5.D0*r1x2Z*VRR0(54,45)+PAz*VRR0(82,45)-5.D0*ExZpE*r1x2Z*VRR1(54,45)+HfxZpE*VRR1(82,24)+WPz*VRR1(82,45)
      VRR0(118,46)=V(602)+5.D0*r1x2Z*VRR0(54,46)+PAz*VRR0(82,46)-5.D0*ExZpE*r1x2Z*VRR1(54,46)+WPz*VRR1(82,46)
      VRR0(118,47)=5.D0*r1x2Z*VRR0(54,47)+PAz*VRR0(82,47)-5.D0*ExZpE*r1x2Z*VRR1(54,47)+2.D0*HfxZpE*VRR1(82,26)+WPz*VRR1(82,47)
      VRR0(118,48)=5.D0*r1x2Z*VRR0(54,48)+PAz*VRR0(82,48)-5.D0*ExZpE*r1x2Z*VRR1(54,48)+2.D0*HfxZpE*VRR1(82,27)+WPz*VRR1(82,48)
      VRR0(118,49)=5.D0*r1x2Z*VRR0(54,49)+PAz*VRR0(82,49)-5.D0*ExZpE*r1x2Z*VRR1(54,49)+2.D0*HfxZpE*VRR1(82,28)+WPz*VRR1(82,49)
      VRR0(118,50)=5.D0*r1x2Z*VRR0(54,50)+PAz*VRR0(82,50)-5.D0*ExZpE*r1x2Z*VRR1(54,50)+2.D0*HfxZpE*VRR1(82,29)+WPz*VRR1(82,50)
      VRR0(118,51)=5.D0*r1x2Z*VRR0(54,51)+PAz*VRR0(82,51)-5.D0*ExZpE*r1x2Z*VRR1(54,51)+3.D0*HfxZpE*VRR1(82,30)+WPz*VRR1(82,51)
      VRR0(118,52)=5.D0*r1x2Z*VRR0(54,52)+PAz*VRR0(82,52)-5.D0*ExZpE*r1x2Z*VRR1(54,52)+3.D0*HfxZpE*VRR1(82,31)+WPz*VRR1(82,52)
      VRR0(118,53)=5.D0*r1x2Z*VRR0(54,53)+PAz*VRR0(82,53)-5.D0*ExZpE*r1x2Z*VRR1(54,53)+3.D0*HfxZpE*VRR1(82,32)+WPz*VRR1(82,53)
      VRR0(118,54)=5.D0*r1x2Z*VRR0(54,54)+PAz*VRR0(82,54)-5.D0*ExZpE*r1x2Z*VRR1(54,54)+4.D0*HfxZpE*VRR1(82,33)+WPz*VRR1(82,54)
      VRR0(118,55)=5.D0*r1x2Z*VRR0(54,55)+PAz*VRR0(82,55)-5.D0*ExZpE*r1x2Z*VRR1(54,55)+4.D0*HfxZpE*VRR1(82,34)+WPz*VRR1(82,55)
      VRR0(118,56)=5.D0*r1x2Z*VRR0(54,56)+PAz*VRR0(82,56)-5.D0*ExZpE*r1x2Z*VRR1(54,56)+5.D0*HfxZpE*VRR1(82,35)+WPz*VRR1(82,56)
      VRR0(119,36)=5.D0*r1x2Z*VRR0(55,36)+PAz*VRR0(83,36)-5.D0*ExZpE*r1x2Z*VRR1(55,36)+WPz*VRR1(83,36)
      VRR0(119,37)=5.D0*r1x2Z*VRR0(55,37)+PAz*VRR0(83,37)-5.D0*ExZpE*r1x2Z*VRR1(55,37)+WPz*VRR1(83,37)
      VRR0(119,38)=5.D0*r1x2Z*VRR0(55,38)+PAz*VRR0(83,38)-5.D0*ExZpE*r1x2Z*VRR1(55,38)+WPz*VRR1(83,38)
      VRR0(119,39)=5.D0*r1x2Z*VRR0(55,39)+PAz*VRR0(83,39)-5.D0*ExZpE*r1x2Z*VRR1(55,39)+WPz*VRR1(83,39)
      VRR0(119,40)=5.D0*r1x2Z*VRR0(55,40)+PAz*VRR0(83,40)-5.D0*ExZpE*r1x2Z*VRR1(55,40)+WPz*VRR1(83,40)
      VRR0(119,41)=5.D0*r1x2Z*VRR0(55,41)+PAz*VRR0(83,41)-5.D0*ExZpE*r1x2Z*VRR1(55,41)+WPz*VRR1(83,41)
      VRR0(119,42)=V(601)+5.D0*r1x2Z*VRR0(55,42)+PAz*VRR0(83,42)-5.D0*ExZpE*r1x2Z*VRR1(55,42)+WPz*VRR1(83,42)
      VRR0(119,43)=5.D0*r1x2Z*VRR0(55,43)+PAz*VRR0(83,43)-5.D0*ExZpE*r1x2Z*VRR1(55,43)+HfxZpE*VRR1(83,22)+WPz*VRR1(83,43)
      VRR0(119,44)=5.D0*r1x2Z*VRR0(55,44)+PAz*VRR0(83,44)-5.D0*ExZpE*r1x2Z*VRR1(55,44)+HfxZpE*VRR1(83,23)+WPz*VRR1(83,44)
      VRR0(119,45)=5.D0*r1x2Z*VRR0(55,45)+PAz*VRR0(83,45)-5.D0*ExZpE*r1x2Z*VRR1(55,45)+HfxZpE*VRR1(83,24)+WPz*VRR1(83,45)
      VRR0(119,46)=V(603)+5.D0*r1x2Z*VRR0(55,46)+PAz*VRR0(83,46)-5.D0*ExZpE*r1x2Z*VRR1(55,46)+WPz*VRR1(83,46)
      VRR0(119,47)=5.D0*r1x2Z*VRR0(55,47)+PAz*VRR0(83,47)-5.D0*ExZpE*r1x2Z*VRR1(55,47)+2.D0*HfxZpE*VRR1(83,26)+WPz*VRR1(83,47)
      VRR0(119,48)=5.D0*r1x2Z*VRR0(55,48)+PAz*VRR0(83,48)-5.D0*ExZpE*r1x2Z*VRR1(55,48)+2.D0*HfxZpE*VRR1(83,27)+WPz*VRR1(83,48)
      VRR0(119,49)=5.D0*r1x2Z*VRR0(55,49)+PAz*VRR0(83,49)-5.D0*ExZpE*r1x2Z*VRR1(55,49)+2.D0*HfxZpE*VRR1(83,28)+WPz*VRR1(83,49)
      VRR0(119,50)=5.D0*r1x2Z*VRR0(55,50)+PAz*VRR0(83,50)-5.D0*ExZpE*r1x2Z*VRR1(55,50)+2.D0*HfxZpE*VRR1(83,29)+WPz*VRR1(83,50)
      VRR0(119,51)=5.D0*r1x2Z*VRR0(55,51)+PAz*VRR0(83,51)-5.D0*ExZpE*r1x2Z*VRR1(55,51)+3.D0*HfxZpE*VRR1(83,30)+WPz*VRR1(83,51)
      VRR0(119,52)=5.D0*r1x2Z*VRR0(55,52)+PAz*VRR0(83,52)-5.D0*ExZpE*r1x2Z*VRR1(55,52)+3.D0*HfxZpE*VRR1(83,31)+WPz*VRR1(83,52)
      VRR0(119,53)=5.D0*r1x2Z*VRR0(55,53)+PAz*VRR0(83,53)-5.D0*ExZpE*r1x2Z*VRR1(55,53)+3.D0*HfxZpE*VRR1(83,32)+WPz*VRR1(83,53)
      VRR0(119,54)=5.D0*r1x2Z*VRR0(55,54)+PAz*VRR0(83,54)-5.D0*ExZpE*r1x2Z*VRR1(55,54)+4.D0*HfxZpE*VRR1(83,33)+WPz*VRR1(83,54)
      VRR0(119,55)=5.D0*r1x2Z*VRR0(55,55)+PAz*VRR0(83,55)-5.D0*ExZpE*r1x2Z*VRR1(55,55)+4.D0*HfxZpE*VRR1(83,34)+WPz*VRR1(83,55)
      VRR0(119,56)=5.D0*r1x2Z*VRR0(55,56)+PAz*VRR0(83,56)-5.D0*ExZpE*r1x2Z*VRR1(55,56)+5.D0*HfxZpE*VRR1(83,35)+WPz*VRR1(83,56)
      VRR0(120,36)=6.D0*r1x2Z*VRR0(56,36)+PAz*VRR0(84,36)-6.D0*ExZpE*r1x2Z*VRR1(56,36)+WPz*VRR1(84,36)
      VRR0(120,37)=6.D0*r1x2Z*VRR0(56,37)+PAz*VRR0(84,37)-6.D0*ExZpE*r1x2Z*VRR1(56,37)+WPz*VRR1(84,37)
      VRR0(120,38)=6.D0*r1x2Z*VRR0(56,38)+PAz*VRR0(84,38)-6.D0*ExZpE*r1x2Z*VRR1(56,38)+WPz*VRR1(84,38)
      VRR0(120,39)=6.D0*r1x2Z*VRR0(56,39)+PAz*VRR0(84,39)-6.D0*ExZpE*r1x2Z*VRR1(56,39)+WPz*VRR1(84,39)
      VRR0(120,40)=6.D0*r1x2Z*VRR0(56,40)+PAz*VRR0(84,40)-6.D0*ExZpE*r1x2Z*VRR1(56,40)+WPz*VRR1(84,40)
      VRR0(120,41)=6.D0*r1x2Z*VRR0(56,41)+PAz*VRR0(84,41)-6.D0*ExZpE*r1x2Z*VRR1(56,41)+WPz*VRR1(84,41)
      VRR0(120,42)=6.D0*r1x2Z*VRR0(56,42)+PAz*VRR0(84,42)-6.D0*ExZpE*r1x2Z*VRR1(56,42)+HfxZpE*VRR1(84,21)+WPz*VRR1(84,42)
      VRR0(120,43)=6.D0*r1x2Z*VRR0(56,43)+PAz*VRR0(84,43)-6.D0*ExZpE*r1x2Z*VRR1(56,43)+HfxZpE*VRR1(84,22)+WPz*VRR1(84,43)
      VRR0(120,44)=6.D0*r1x2Z*VRR0(56,44)+PAz*VRR0(84,44)-6.D0*ExZpE*r1x2Z*VRR1(56,44)+HfxZpE*VRR1(84,23)+WPz*VRR1(84,44)
      VRR0(120,45)=6.D0*r1x2Z*VRR0(56,45)+PAz*VRR0(84,45)-6.D0*ExZpE*r1x2Z*VRR1(56,45)+HfxZpE*VRR1(84,24)+WPz*VRR1(84,45)
      VRR0(120,46)=6.D0*r1x2Z*VRR0(56,46)+PAz*VRR0(84,46)-6.D0*ExZpE*r1x2Z*VRR1(56,46)+HfxZpE*VRR1(84,25)+WPz*VRR1(84,46)
      VRR0(120,47)=6.D0*r1x2Z*VRR0(56,47)+PAz*VRR0(84,47)-6.D0*ExZpE*r1x2Z*VRR1(56,47)+2.D0*HfxZpE*VRR1(84,26)+WPz*VRR1(84,47)
      VRR0(120,48)=6.D0*r1x2Z*VRR0(56,48)+PAz*VRR0(84,48)-6.D0*ExZpE*r1x2Z*VRR1(56,48)+2.D0*HfxZpE*VRR1(84,27)+WPz*VRR1(84,48)
      VRR0(120,49)=6.D0*r1x2Z*VRR0(56,49)+PAz*VRR0(84,49)-6.D0*ExZpE*r1x2Z*VRR1(56,49)+2.D0*HfxZpE*VRR1(84,28)+WPz*VRR1(84,49)
      VRR0(120,50)=6.D0*r1x2Z*VRR0(56,50)+PAz*VRR0(84,50)-6.D0*ExZpE*r1x2Z*VRR1(56,50)+2.D0*HfxZpE*VRR1(84,29)+WPz*VRR1(84,50)
      VRR0(120,51)=6.D0*r1x2Z*VRR0(56,51)+PAz*VRR0(84,51)-6.D0*ExZpE*r1x2Z*VRR1(56,51)+3.D0*HfxZpE*VRR1(84,30)+WPz*VRR1(84,51)
      VRR0(120,52)=6.D0*r1x2Z*VRR0(56,52)+PAz*VRR0(84,52)-6.D0*ExZpE*r1x2Z*VRR1(56,52)+3.D0*HfxZpE*VRR1(84,31)+WPz*VRR1(84,52)
      VRR0(120,53)=6.D0*r1x2Z*VRR0(56,53)+PAz*VRR0(84,53)-6.D0*ExZpE*r1x2Z*VRR1(56,53)+3.D0*HfxZpE*VRR1(84,32)+WPz*VRR1(84,53)
      VRR0(120,54)=6.D0*r1x2Z*VRR0(56,54)+PAz*VRR0(84,54)-6.D0*ExZpE*r1x2Z*VRR1(56,54)+4.D0*HfxZpE*VRR1(84,33)+WPz*VRR1(84,54)
      VRR0(120,55)=6.D0*r1x2Z*VRR0(56,55)+PAz*VRR0(84,55)-6.D0*ExZpE*r1x2Z*VRR1(56,55)+4.D0*HfxZpE*VRR1(84,34)+WPz*VRR1(84,55)
      VRR0(120,56)=6.D0*r1x2Z*VRR0(56,56)+PAz*VRR0(84,56)-6.D0*ExZpE*r1x2Z*VRR1(56,56)+5.D0*HfxZpE*VRR1(84,35)+WPz*VRR1(84,56)
END SUBROUTINE VRRj0h0
