!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRi0g0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(37,14)
      V(2)=HfxZpE*VRR1(37,20)
      V(3)=r1x2Z*VRR0(23,22)
      V(4)=3.D0*V(3)
      V(5)=ExZpE*r1x2Z*VRR1(23,22)
      V(6)=-3.D0*V(5)
      V(7)=r1x2Z*VRR0(23,23)
      V(8)=3.D0*V(7)
      V(9)=ExZpE*r1x2Z*VRR1(23,23)
      V(10)=-3.D0*V(9)
      V(11)=HfxZpE*VRR1(38,13)
      V(12)=r1x2Z*VRR0(23,24)
      V(13)=3.D0*V(12)
      V(14)=ExZpE*r1x2Z*VRR1(23,24)
      V(15)=-3.D0*V(14)
      V(16)=HfxZpE*VRR1(38,14)
      V(17)=r1x2Z*VRR0(23,26)
      V(18)=3.D0*V(17)
      V(19)=ExZpE*r1x2Z*VRR1(23,26)
      V(20)=-3.D0*V(19)
      V(21)=r1x2Z*VRR0(23,27)
      V(22)=3.D0*V(21)
      V(23)=ExZpE*r1x2Z*VRR1(23,27)
      V(24)=-3.D0*V(23)
      V(25)=r1x2Z*VRR0(23,28)
      V(26)=3.D0*V(25)
      V(27)=ExZpE*r1x2Z*VRR1(23,28)
      V(28)=-3.D0*V(27)
      V(29)=HfxZpE*VRR1(38,17)
      V(30)=r1x2Z*VRR0(23,29)
      V(31)=3.D0*V(30)
      V(32)=ExZpE*r1x2Z*VRR1(23,29)
      V(33)=-3.D0*V(32)
      V(34)=r1x2Z*VRR0(23,30)
      V(35)=3.D0*V(34)
      V(36)=ExZpE*r1x2Z*VRR1(23,30)
      V(37)=-3.D0*V(36)
      V(38)=HfxZpE*VRR1(38,18)
      V(39)=r1x2Z*VRR0(23,31)
      V(40)=3.D0*V(39)
      V(41)=ExZpE*r1x2Z*VRR1(23,31)
      V(42)=-3.D0*V(41)
      V(43)=HfxZpE*VRR1(38,19)
      V(44)=r1x2Z*VRR0(23,32)
      V(45)=3.D0*V(44)
      V(46)=ExZpE*r1x2Z*VRR1(23,32)
      V(47)=-3.D0*V(46)
      V(48)=r1x2Z*VRR0(23,33)
      V(49)=3.D0*V(48)
      V(50)=ExZpE*r1x2Z*VRR1(23,33)
      V(51)=-3.D0*V(50)
      V(52)=HfxZpE*VRR1(38,20)
      V(53)=r1x2Z*VRR0(23,34)
      V(54)=3.D0*V(53)
      V(55)=ExZpE*r1x2Z*VRR1(23,34)
      V(56)=-3.D0*V(55)
      V(57)=HfxZpE*VRR1(39,11)
      V(58)=r1x2E*VRR0(60,6)
      V(59)=2.D0*V(58)
      V(60)=HfxZpE*VRR1(39,12)
      V(61)=r1x2E*ZxZpE*VRR1(60,6)
      V(62)=-2.D0*V(61)
      V(63)=r1x2Z*VRR0(24,23)
      V(64)=ExZpE*r1x2Z*VRR1(24,23)
      V(65)=HfxZpE*VRR1(39,13)
      V(66)=r1x2E*VRR0(60,8)
      V(67)=2.D0*V(66)
      V(68)=HfxZpE*VRR1(39,15)
      V(69)=r1x2E*ZxZpE*VRR1(60,8)
      V(70)=-2.D0*V(69)
      V(71)=r1x2Z*VRR0(24,27)
      V(72)=ExZpE*r1x2Z*VRR1(24,27)
      V(73)=HfxZpE*VRR1(39,16)
      V(74)=2.D0*V(73)
      V(75)=r1x2Z*VRR0(24,28)
      V(76)=ExZpE*r1x2Z*VRR1(24,28)
      V(77)=HfxZpE*VRR1(39,17)
      V(78)=r1x2E*VRR0(60,9)
      V(79)=2.D0*V(78)
      V(80)=r1x2E*ZxZpE*VRR1(60,9)
      V(81)=-2.D0*V(80)
      V(82)=r1x2Z*VRR0(24,30)
      V(83)=ExZpE*r1x2Z*VRR1(24,30)
      V(84)=HfxZpE*VRR1(39,18)
      V(85)=r1x2Z*VRR0(24,31)
      V(86)=ExZpE*r1x2Z*VRR1(24,31)
      V(87)=HfxZpE*VRR1(39,19)
      V(88)=r1x2Z*VRR0(24,32)
      V(89)=ExZpE*r1x2Z*VRR1(24,32)
      V(90)=HfxZpE*VRR1(40,11)
      V(91)=HfxZpE*VRR1(39,20)
      V(92)=HfxZpE*VRR1(40,20)
      V(93)=HfxZpE*VRR1(42,14)
      V(94)=HfxZpE*VRR1(42,20)
      V(95)=r1x2Z*VRR0(27,23)
      V(96)=ExZpE*r1x2Z*VRR1(27,23)
      V(97)=HfxZpE*VRR1(43,13)
      V(98)=2.D0*V(97)
      V(99)=HfxZpE*VRR1(43,14)
      V(100)=r1x2Z*VRR0(27,27)
      V(101)=ExZpE*r1x2Z*VRR1(27,27)
      V(102)=r1x2Z*VRR0(27,28)
      V(103)=ExZpE*r1x2Z*VRR1(27,28)
      V(104)=HfxZpE*VRR1(43,17)
      V(105)=r1x2Z*VRR0(27,30)
      V(106)=ExZpE*r1x2Z*VRR1(27,30)
      V(107)=HfxZpE*VRR1(43,18)
      V(108)=2.D0*V(107)
      V(109)=r1x2Z*VRR0(27,31)
      V(110)=ExZpE*r1x2Z*VRR1(27,31)
      V(111)=HfxZpE*VRR1(43,19)
      V(112)=r1x2Z*VRR0(27,32)
      V(113)=ExZpE*r1x2Z*VRR1(27,32)
      V(114)=HfxZpE*VRR1(43,20)
      V(115)=r1x2E*VRR0(66,6)
      V(116)=2.D0*V(115)
      V(117)=HfxZpE*VRR1(44,12)
      V(118)=r1x2E*ZxZpE*VRR1(66,6)
      V(119)=-2.D0*V(118)
      V(120)=r1x2Z*VRR0(28,23)
      V(121)=2.D0*V(120)
      V(122)=ExZpE*r1x2Z*VRR1(28,23)
      V(123)=-2.D0*V(122)
      V(124)=HfxZpE*VRR1(44,13)
      V(125)=r1x2E*VRR0(66,8)
      V(126)=2.D0*V(125)
      V(127)=HfxZpE*VRR1(44,15)
      V(128)=r1x2E*ZxZpE*VRR1(66,8)
      V(129)=-2.D0*V(128)
      V(130)=r1x2Z*VRR0(28,27)
      V(131)=2.D0*V(130)
      V(132)=ExZpE*r1x2Z*VRR1(28,27)
      V(133)=-2.D0*V(132)
      V(134)=HfxZpE*VRR1(44,16)
      V(135)=2.D0*V(134)
      V(136)=r1x2Z*VRR0(28,28)
      V(137)=2.D0*V(136)
      V(138)=ExZpE*r1x2Z*VRR1(28,28)
      V(139)=-2.D0*V(138)
      V(140)=HfxZpE*VRR1(44,17)
      V(141)=r1x2E*VRR0(66,9)
      V(142)=2.D0*V(141)
      V(143)=r1x2E*ZxZpE*VRR1(66,9)
      V(144)=-2.D0*V(143)
      V(145)=r1x2Z*VRR0(28,30)
      V(146)=2.D0*V(145)
      V(147)=ExZpE*r1x2Z*VRR1(28,30)
      V(148)=-2.D0*V(147)
      V(149)=HfxZpE*VRR1(44,18)
      V(150)=2.D0*V(149)
      V(151)=r1x2Z*VRR0(28,31)
      V(152)=2.D0*V(151)
      V(153)=ExZpE*r1x2Z*VRR1(28,31)
      V(154)=-2.D0*V(153)
      V(155)=HfxZpE*VRR1(44,19)
      V(156)=r1x2Z*VRR0(28,32)
      V(157)=2.D0*V(156)
      V(158)=ExZpE*r1x2Z*VRR1(28,32)
      V(159)=-2.D0*V(158)
      V(160)=HfxZpE*VRR1(45,11)
      V(161)=r1x2E*VRR0(67,6)
      V(162)=2.D0*V(161)
      V(163)=HfxZpE*VRR1(45,12)
      V(164)=2.D0*V(163)
      V(165)=r1x2E*ZxZpE*VRR1(67,6)
      V(166)=-2.D0*V(165)
      V(167)=2.D0*V(95)
      V(168)=-2.D0*V(96)
      V(169)=r1x2E*VRR0(67,8)
      V(170)=2.D0*V(169)
      V(171)=HfxZpE*VRR1(45,15)
      V(172)=r1x2E*ZxZpE*VRR1(67,8)
      V(173)=-2.D0*V(172)
      V(174)=2.D0*V(100)
      V(175)=-2.D0*V(101)
      V(176)=2.D0*V(102)
      V(177)=-2.D0*V(103)
      V(178)=r1x2E*VRR0(67,9)
      V(179)=2.D0*V(178)
      V(180)=r1x2E*ZxZpE*VRR1(67,9)
      V(181)=-2.D0*V(180)
      V(182)=2.D0*V(105)
      V(183)=-2.D0*V(106)
      V(184)=2.D0*V(109)
      V(185)=-2.D0*V(110)
      V(186)=2.D0*V(112)
      V(187)=-2.D0*V(113)
      V(188)=2.D0*V(155)
      V(189)=HfxZpE*VRR1(46,11)
      V(190)=HfxZpE*VRR1(45,18)
      V(191)=HfxZpE*VRR1(45,19)
      V(192)=2.D0*V(191)
      V(193)=HfxZpE*VRR1(45,20)
      V(194)=HfxZpE*VRR1(46,20)
      V(195)=r1x2Z*VRR0(30,22)
      V(196)=3.D0*V(195)
      V(197)=ExZpE*r1x2Z*VRR1(30,22)
      V(198)=-3.D0*V(197)
      V(199)=r1x2Z*VRR0(30,23)
      V(200)=3.D0*V(199)
      V(201)=ExZpE*r1x2Z*VRR1(30,23)
      V(202)=-3.D0*V(201)
      V(203)=HfxZpE*VRR1(47,13)
      V(204)=r1x2Z*VRR0(30,24)
      V(205)=3.D0*V(204)
      V(206)=ExZpE*r1x2Z*VRR1(30,24)
      V(207)=-3.D0*V(206)
      V(208)=HfxZpE*VRR1(47,14)
      V(209)=r1x2Z*VRR0(30,26)
      V(210)=3.D0*V(209)
      V(211)=ExZpE*r1x2Z*VRR1(30,26)
      V(212)=-3.D0*V(211)
      V(213)=r1x2Z*VRR0(30,27)
      V(214)=3.D0*V(213)
      V(215)=ExZpE*r1x2Z*VRR1(30,27)
      V(216)=-3.D0*V(215)
      V(217)=r1x2Z*VRR0(30,28)
      V(218)=3.D0*V(217)
      V(219)=ExZpE*r1x2Z*VRR1(30,28)
      V(220)=-3.D0*V(219)
      V(221)=HfxZpE*VRR1(47,17)
      V(222)=r1x2Z*VRR0(30,29)
      V(223)=3.D0*V(222)
      V(224)=ExZpE*r1x2Z*VRR1(30,29)
      V(225)=-3.D0*V(224)
      V(226)=r1x2Z*VRR0(30,30)
      V(227)=3.D0*V(226)
      V(228)=ExZpE*r1x2Z*VRR1(30,30)
      V(229)=-3.D0*V(228)
      V(230)=HfxZpE*VRR1(47,18)
      V(231)=r1x2Z*VRR0(30,31)
      V(232)=3.D0*V(231)
      V(233)=ExZpE*r1x2Z*VRR1(30,31)
      V(234)=-3.D0*V(233)
      V(235)=HfxZpE*VRR1(47,19)
      V(236)=r1x2Z*VRR0(30,32)
      V(237)=3.D0*V(236)
      V(238)=ExZpE*r1x2Z*VRR1(30,32)
      V(239)=-3.D0*V(238)
      V(240)=r1x2Z*VRR0(30,33)
      V(241)=3.D0*V(240)
      V(242)=ExZpE*r1x2Z*VRR1(30,33)
      V(243)=-3.D0*V(242)
      V(244)=HfxZpE*VRR1(47,20)
      V(245)=r1x2Z*VRR0(30,34)
      V(246)=3.D0*V(245)
      V(247)=ExZpE*r1x2Z*VRR1(30,34)
      V(248)=-3.D0*V(247)
      V(249)=r1x2E*VRR0(71,6)
      V(250)=2.D0*V(249)
      V(251)=HfxZpE*VRR1(48,12)
      V(252)=r1x2E*ZxZpE*VRR1(71,6)
      V(253)=-2.D0*V(252)
      V(254)=r1x2Z*VRR0(31,23)
      V(255)=2.D0*V(254)
      V(256)=ExZpE*r1x2Z*VRR1(31,23)
      V(257)=-2.D0*V(256)
      V(258)=HfxZpE*VRR1(48,13)
      V(259)=2.D0*V(258)
      V(260)=r1x2E*VRR0(71,8)
      V(261)=2.D0*V(260)
      V(262)=HfxZpE*VRR1(48,15)
      V(263)=r1x2E*ZxZpE*VRR1(71,8)
      V(264)=-2.D0*V(263)
      V(265)=r1x2Z*VRR0(31,27)
      V(266)=2.D0*V(265)
      V(267)=ExZpE*r1x2Z*VRR1(31,27)
      V(268)=-2.D0*V(267)
      V(269)=HfxZpE*VRR1(48,16)
      V(270)=2.D0*V(269)
      V(271)=r1x2Z*VRR0(31,28)
      V(272)=2.D0*V(271)
      V(273)=ExZpE*r1x2Z*VRR1(31,28)
      V(274)=-2.D0*V(273)
      V(275)=HfxZpE*VRR1(48,17)
      V(276)=r1x2E*VRR0(71,9)
      V(277)=2.D0*V(276)
      V(278)=r1x2E*ZxZpE*VRR1(71,9)
      V(279)=-2.D0*V(278)
      V(280)=r1x2Z*VRR0(31,30)
      V(281)=2.D0*V(280)
      V(282)=ExZpE*r1x2Z*VRR1(31,30)
      V(283)=-2.D0*V(282)
      V(284)=HfxZpE*VRR1(48,18)
      V(285)=r1x2Z*VRR0(31,31)
      V(286)=2.D0*V(285)
      V(287)=ExZpE*r1x2Z*VRR1(31,31)
      V(288)=-2.D0*V(287)
      V(289)=HfxZpE*VRR1(48,19)
      V(290)=r1x2Z*VRR0(31,32)
      V(291)=2.D0*V(290)
      V(292)=ExZpE*r1x2Z*VRR1(31,32)
      V(293)=-2.D0*V(292)
      V(294)=r1x2E*VRR0(72,6)
      V(295)=2.D0*V(294)
      V(296)=HfxZpE*VRR1(49,12)
      V(297)=2.D0*V(296)
      V(298)=r1x2E*ZxZpE*VRR1(72,6)
      V(299)=-2.D0*V(298)
      V(300)=r1x2E*VRR0(72,7)
      V(301)=HfxZpE*VRR1(49,13)
      V(302)=r1x2E*ZxZpE*VRR1(72,7)
      V(303)=r1x2E*VRR0(72,8)
      V(304)=2.D0*V(303)
      V(305)=HfxZpE*VRR1(49,15)
      V(306)=2.D0*V(305)
      V(307)=r1x2E*ZxZpE*VRR1(72,8)
      V(308)=-2.D0*V(307)
      V(309)=r1x2E*VRR0(72,9)
      V(310)=HfxZpE*VRR1(49,16)
      V(311)=2.D0*V(310)
      V(312)=r1x2E*ZxZpE*VRR1(72,9)
      V(313)=2.D0*V(309)
      V(314)=2.D0*V(275)
      V(315)=-2.D0*V(312)
      V(316)=r1x2E*VRR0(72,10)
      V(317)=HfxZpE*VRR1(49,18)
      V(318)=r1x2E*ZxZpE*VRR1(72,10)
      V(319)=-V(318)
      V(320)=HfxZpE*VRR1(50,11)
      V(321)=r1x2E*VRR0(73,6)
      V(322)=2.D0*V(321)
      V(323)=HfxZpE*VRR1(50,12)
      V(324)=r1x2E*ZxZpE*VRR1(73,6)
      V(325)=-2.D0*V(324)
      V(326)=r1x2E*VRR0(73,8)
      V(327)=2.D0*V(326)
      V(328)=HfxZpE*VRR1(50,15)
      V(329)=r1x2E*ZxZpE*VRR1(73,8)
      V(330)=-2.D0*V(329)
      V(331)=r1x2E*VRR0(73,9)
      V(332)=2.D0*V(331)
      V(333)=HfxZpE*VRR1(49,17)
      V(334)=r1x2E*ZxZpE*VRR1(73,9)
      V(335)=-2.D0*V(334)
      V(336)=HfxZpE*VRR1(49,19)
      V(337)=r1x2Z*VRR0(32,22)
      V(338)=3.D0*V(337)
      V(339)=ExZpE*r1x2Z*VRR1(32,22)
      V(340)=-3.D0*V(339)
      V(341)=r1x2Z*VRR0(32,23)
      V(342)=3.D0*V(341)
      V(343)=ExZpE*r1x2Z*VRR1(32,23)
      V(344)=-3.D0*V(343)
      V(345)=r1x2Z*VRR0(32,24)
      V(346)=3.D0*V(345)
      V(347)=ExZpE*r1x2Z*VRR1(32,24)
      V(348)=-3.D0*V(347)
      V(349)=r1x2Z*VRR0(32,26)
      V(350)=3.D0*V(349)
      V(351)=ExZpE*r1x2Z*VRR1(32,26)
      V(352)=-3.D0*V(351)
      V(353)=r1x2Z*VRR0(32,27)
      V(354)=3.D0*V(353)
      V(355)=ExZpE*r1x2Z*VRR1(32,27)
      V(356)=-3.D0*V(355)
      V(357)=r1x2Z*VRR0(32,28)
      V(358)=3.D0*V(357)
      V(359)=ExZpE*r1x2Z*VRR1(32,28)
      V(360)=-3.D0*V(359)
      V(361)=r1x2Z*VRR0(32,29)
      V(362)=3.D0*V(361)
      V(363)=ExZpE*r1x2Z*VRR1(32,29)
      V(364)=-3.D0*V(363)
      V(365)=r1x2Z*VRR0(32,30)
      V(366)=3.D0*V(365)
      V(367)=ExZpE*r1x2Z*VRR1(32,30)
      V(368)=-3.D0*V(367)
      V(369)=r1x2Z*VRR0(32,31)
      V(370)=3.D0*V(369)
      V(371)=ExZpE*r1x2Z*VRR1(32,31)
      V(372)=-3.D0*V(371)
      V(373)=HfxZpE*VRR1(50,18)
      V(374)=r1x2Z*VRR0(32,32)
      V(375)=3.D0*V(374)
      V(376)=ExZpE*r1x2Z*VRR1(32,32)
      V(377)=-3.D0*V(376)
      V(378)=HfxZpE*VRR1(50,19)
      V(379)=r1x2Z*VRR0(32,33)
      V(380)=3.D0*V(379)
      V(381)=ExZpE*r1x2Z*VRR1(32,33)
      V(382)=-3.D0*V(381)
      V(383)=r1x2Z*VRR0(32,34)
      V(384)=3.D0*V(383)
      V(385)=ExZpE*r1x2Z*VRR1(32,34)
      V(386)=-3.D0*V(385)
      V(387)=HfxZpE*VRR1(50,20)
      V(388)=HfxZpE*VRR1(51,11)
      V(389)=r1x2E*VRR0(75,6)
      V(390)=2.D0*V(389)
      V(391)=HfxZpE*VRR1(51,12)
      V(392)=r1x2E*ZxZpE*VRR1(75,6)
      V(393)=-2.D0*V(392)
      V(394)=r1x2Z*VRR0(33,23)
      V(395)=ExZpE*r1x2Z*VRR1(33,23)
      V(396)=HfxZpE*VRR1(51,13)
      V(397)=r1x2E*VRR0(75,8)
      V(398)=2.D0*V(397)
      V(399)=HfxZpE*VRR1(51,15)
      V(400)=r1x2E*ZxZpE*VRR1(75,8)
      V(401)=-2.D0*V(400)
      V(402)=r1x2Z*VRR0(33,27)
      V(403)=ExZpE*r1x2Z*VRR1(33,27)
      V(404)=HfxZpE*VRR1(51,16)
      V(405)=2.D0*V(404)
      V(406)=r1x2Z*VRR0(33,28)
      V(407)=ExZpE*r1x2Z*VRR1(33,28)
      V(408)=HfxZpE*VRR1(51,17)
      V(409)=r1x2E*VRR0(75,9)
      V(410)=2.D0*V(409)
      V(411)=r1x2E*ZxZpE*VRR1(75,9)
      V(412)=-2.D0*V(411)
      V(413)=r1x2Z*VRR0(33,30)
      V(414)=ExZpE*r1x2Z*VRR1(33,30)
      V(415)=HfxZpE*VRR1(51,18)
      V(416)=r1x2Z*VRR0(33,31)
      V(417)=ExZpE*r1x2Z*VRR1(33,31)
      V(418)=HfxZpE*VRR1(51,19)
      V(419)=r1x2Z*VRR0(33,32)
      V(420)=ExZpE*r1x2Z*VRR1(33,32)
      V(421)=HfxZpE*VRR1(52,11)
      V(422)=r1x2E*VRR0(76,6)
      V(423)=2.D0*V(422)
      V(424)=HfxZpE*VRR1(52,12)
      V(425)=r1x2E*ZxZpE*VRR1(76,6)
      V(426)=-2.D0*V(425)
      V(427)=HfxZpE*VRR1(51,14)
      V(428)=r1x2E*VRR0(76,8)
      V(429)=2.D0*V(428)
      V(430)=HfxZpE*VRR1(52,15)
      V(431)=2.D0*V(430)
      V(432)=r1x2E*ZxZpE*VRR1(76,8)
      V(433)=-2.D0*V(432)
      V(434)=r1x2E*VRR0(76,9)
      V(435)=2.D0*V(434)
      V(436)=r1x2E*ZxZpE*VRR1(76,9)
      V(437)=-2.D0*V(436)
      V(438)=HfxZpE*VRR1(53,11)
      V(439)=r1x2E*VRR0(77,6)
      V(440)=2.D0*V(439)
      V(441)=HfxZpE*VRR1(53,12)
      V(442)=r1x2E*ZxZpE*VRR1(77,6)
      V(443)=-2.D0*V(442)
      V(444)=HfxZpE*VRR1(52,13)
      V(445)=HfxZpE*VRR1(52,14)
      V(446)=r1x2E*VRR0(77,8)
      V(447)=2.D0*V(446)
      V(448)=HfxZpE*VRR1(53,15)
      V(449)=r1x2E*ZxZpE*VRR1(77,8)
      V(450)=-2.D0*V(449)
      V(451)=r1x2E*VRR0(77,9)
      V(452)=2.D0*V(451)
      V(453)=HfxZpE*VRR1(52,17)
      V(454)=2.D0*V(453)
      V(455)=r1x2E*ZxZpE*VRR1(77,9)
      V(456)=-2.D0*V(455)
      V(457)=r1x2E*VRR0(78,6)
      V(458)=2.D0*V(457)
      V(459)=r1x2E*ZxZpE*VRR1(78,6)
      V(460)=-2.D0*V(459)
      V(461)=r1x2Z*VRR0(34,23)
      V(462)=ExZpE*r1x2Z*VRR1(34,23)
      V(463)=HfxZpE*VRR1(53,13)
      V(464)=HfxZpE*VRR1(53,14)
      V(465)=r1x2E*VRR0(78,8)
      V(466)=2.D0*V(465)
      V(467)=r1x2E*ZxZpE*VRR1(78,8)
      V(468)=-2.D0*V(467)
      V(469)=r1x2Z*VRR0(34,27)
      V(470)=ExZpE*r1x2Z*VRR1(34,27)
      V(471)=r1x2Z*VRR0(34,28)
      V(472)=ExZpE*r1x2Z*VRR1(34,28)
      V(473)=HfxZpE*VRR1(53,16)
      V(474)=2.D0*V(473)
      V(475)=r1x2E*VRR0(78,9)
      V(476)=2.D0*V(475)
      V(477)=HfxZpE*VRR1(53,17)
      V(478)=r1x2E*ZxZpE*VRR1(78,9)
      V(479)=-2.D0*V(478)
      V(480)=r1x2Z*VRR0(34,30)
      V(481)=ExZpE*r1x2Z*VRR1(34,30)
      V(482)=r1x2Z*VRR0(34,31)
      V(483)=ExZpE*r1x2Z*VRR1(34,31)
      V(484)=HfxZpE*VRR1(53,18)
      V(485)=r1x2Z*VRR0(34,32)
      V(486)=ExZpE*r1x2Z*VRR1(34,32)
      V(487)=HfxZpE*VRR1(53,19)
      V(488)=HfxZpE*VRR1(54,11)
      V(489)=HfxZpE*VRR1(55,11)
      V(490)=HfxZpE*VRR1(54,14)
      V(491)=HfxZpE*VRR1(55,14)
      VRR0(57,21)=5.D0*r1x2Z*VRR0(21,21)+PAx*VRR0(36,21)-5.D0*ExZpE*r1x2Z*VRR1(21,21)+4.D0*HfxZpE*VRR1(36,11)+WPx*VRR1(36,21)
      VRR0(57,22)=5.D0*r1x2Z*VRR0(21,22)+PAx*VRR0(36,22)-5.D0*ExZpE*r1x2Z*VRR1(21,22)+3.D0*HfxZpE*VRR1(36,12)+WPx*VRR1(36,22)
      VRR0(57,23)=5.D0*r1x2Z*VRR0(21,23)+PAx*VRR0(36,23)-5.D0*ExZpE*r1x2Z*VRR1(21,23)+2.D0*HfxZpE*VRR1(36,13)+WPx*VRR1(36,23)
      VRR0(57,24)=5.D0*r1x2Z*VRR0(21,24)+PAx*VRR0(36,24)-5.D0*ExZpE*r1x2Z*VRR1(21,24)+HfxZpE*VRR1(36,14)+WPx*VRR1(36,24)
      VRR0(57,25)=5.D0*r1x2Z*VRR0(21,25)+PAx*VRR0(36,25)-5.D0*ExZpE*r1x2Z*VRR1(21,25)+WPx*VRR1(36,25)
      VRR0(57,26)=5.D0*r1x2Z*VRR0(21,26)+PAx*VRR0(36,26)-5.D0*ExZpE*r1x2Z*VRR1(21,26)+3.D0*HfxZpE*VRR1(36,15)+WPx*VRR1(36,26)
      VRR0(57,27)=5.D0*r1x2Z*VRR0(21,27)+PAx*VRR0(36,27)-5.D0*ExZpE*r1x2Z*VRR1(21,27)+2.D0*HfxZpE*VRR1(36,16)+WPx*VRR1(36,27)
      VRR0(57,28)=5.D0*r1x2Z*VRR0(21,28)+PAx*VRR0(36,28)-5.D0*ExZpE*r1x2Z*VRR1(21,28)+HfxZpE*VRR1(36,17)+WPx*VRR1(36,28)
      VRR0(57,29)=5.D0*r1x2Z*VRR0(21,29)+PAx*VRR0(36,29)-5.D0*ExZpE*r1x2Z*VRR1(21,29)+WPx*VRR1(36,29)
      VRR0(57,30)=5.D0*r1x2Z*VRR0(21,30)+PAx*VRR0(36,30)-5.D0*ExZpE*r1x2Z*VRR1(21,30)+2.D0*HfxZpE*VRR1(36,18)+WPx*VRR1(36,30)
      VRR0(57,31)=5.D0*r1x2Z*VRR0(21,31)+PAx*VRR0(36,31)-5.D0*ExZpE*r1x2Z*VRR1(21,31)+HfxZpE*VRR1(36,19)+WPx*VRR1(36,31)
      VRR0(57,32)=5.D0*r1x2Z*VRR0(21,32)+PAx*VRR0(36,32)-5.D0*ExZpE*r1x2Z*VRR1(21,32)+WPx*VRR1(36,32)
      VRR0(57,33)=5.D0*r1x2Z*VRR0(21,33)+PAx*VRR0(36,33)-5.D0*ExZpE*r1x2Z*VRR1(21,33)+HfxZpE*VRR1(36,20)+WPx*VRR1(36,33)
      VRR0(57,34)=5.D0*r1x2Z*VRR0(21,34)+PAx*VRR0(36,34)-5.D0*ExZpE*r1x2Z*VRR1(21,34)+WPx*VRR1(36,34)
      VRR0(57,35)=5.D0*r1x2Z*VRR0(21,35)+PAx*VRR0(36,35)-5.D0*ExZpE*r1x2Z*VRR1(21,35)+WPx*VRR1(36,35)
      VRR0(58,21)=4.D0*r1x2Z*VRR0(22,21)+PAx*VRR0(37,21)-4.D0*ExZpE*r1x2Z*VRR1(22,21)+4.D0*HfxZpE*VRR1(37,11)+WPx*VRR1(37,21)
      VRR0(58,22)=4.D0*r1x2Z*VRR0(22,22)+PAx*VRR0(37,22)-4.D0*ExZpE*r1x2Z*VRR1(22,22)+3.D0*HfxZpE*VRR1(37,12)+WPx*VRR1(37,22)
      VRR0(58,23)=4.D0*r1x2Z*VRR0(22,23)+PAx*VRR0(37,23)-4.D0*ExZpE*r1x2Z*VRR1(22,23)+2.D0*HfxZpE*VRR1(37,13)+WPx*VRR1(37,23)
      VRR0(58,24)=V(1)+4.D0*r1x2Z*VRR0(22,24)+PAx*VRR0(37,24)-4.D0*ExZpE*r1x2Z*VRR1(22,24)+WPx*VRR1(37,24)
      VRR0(58,25)=4.D0*r1x2Z*VRR0(22,25)+PAx*VRR0(37,25)-4.D0*ExZpE*r1x2Z*VRR1(22,25)+WPx*VRR1(37,25)
      VRR0(58,26)=4.D0*r1x2Z*VRR0(22,26)+PAx*VRR0(37,26)-4.D0*ExZpE*r1x2Z*VRR1(22,26)+3.D0*HfxZpE*VRR1(37,15)+WPx*VRR1(37,26)
      VRR0(58,27)=4.D0*r1x2Z*VRR0(22,27)+PAx*VRR0(37,27)-4.D0*ExZpE*r1x2Z*VRR1(22,27)+2.D0*HfxZpE*VRR1(37,16)+WPx*VRR1(37,27)
      VRR0(58,28)=4.D0*r1x2Z*VRR0(22,28)+PAx*VRR0(37,28)-4.D0*ExZpE*r1x2Z*VRR1(22,28)+HfxZpE*VRR1(37,17)+WPx*VRR1(37,28)
      VRR0(58,29)=4.D0*r1x2Z*VRR0(22,29)+PAx*VRR0(37,29)-4.D0*ExZpE*r1x2Z*VRR1(22,29)+WPx*VRR1(37,29)
      VRR0(58,30)=4.D0*r1x2Z*VRR0(22,30)+PAx*VRR0(37,30)-4.D0*ExZpE*r1x2Z*VRR1(22,30)+2.D0*HfxZpE*VRR1(37,18)+WPx*VRR1(37,30)
      VRR0(58,31)=4.D0*r1x2Z*VRR0(22,31)+PAx*VRR0(37,31)-4.D0*ExZpE*r1x2Z*VRR1(22,31)+HfxZpE*VRR1(37,19)+WPx*VRR1(37,31)
      VRR0(58,32)=4.D0*r1x2Z*VRR0(22,32)+PAx*VRR0(37,32)-4.D0*ExZpE*r1x2Z*VRR1(22,32)+WPx*VRR1(37,32)
      VRR0(58,33)=V(2)+4.D0*r1x2Z*VRR0(22,33)+PAx*VRR0(37,33)-4.D0*ExZpE*r1x2Z*VRR1(22,33)+WPx*VRR1(37,33)
      VRR0(58,34)=4.D0*r1x2Z*VRR0(22,34)+PAx*VRR0(37,34)-4.D0*ExZpE*r1x2Z*VRR1(22,34)+WPx*VRR1(37,34)
      VRR0(58,35)=4.D0*r1x2Z*VRR0(22,35)+PAx*VRR0(37,35)-4.D0*ExZpE*r1x2Z*VRR1(22,35)+WPx*VRR1(37,35)
      VRR0(59,21)=3.D0*r1x2E*VRR0(59,5)+QCx*VRR0(59,11)+4.D0*HfxZpE*VRR1(38,11)-3.D0*r1x2E*ZxZpE*VRR1(59,5)+WQx*VRR1(59,11)
      VRR0(59,22)=V(4)+V(6)+PAx*VRR0(38,22)+3.D0*HfxZpE*VRR1(38,12)+WPx*VRR1(38,22)
      VRR0(59,23)=V(8)+V(10)+2.D0*V(11)+PAx*VRR0(38,23)+WPx*VRR1(38,23)
      VRR0(59,24)=V(13)+V(15)+V(16)+PAx*VRR0(38,24)+WPx*VRR1(38,24)
      VRR0(59,25)=2.D0*V(1)+3.D0*r1x2E*VRR0(59,7)+QCy*VRR0(59,14)-3.D0*r1x2E*ZxZpE*VRR1(59,7)+WQy*VRR1(59,14)
      VRR0(59,26)=V(18)+V(20)+PAx*VRR0(38,26)+3.D0*HfxZpE*VRR1(38,15)+WPx*VRR1(38,26)
      VRR0(59,27)=V(22)+V(24)+PAx*VRR0(38,27)+2.D0*HfxZpE*VRR1(38,16)+WPx*VRR1(38,27)
      VRR0(59,28)=V(26)+V(28)+V(29)+PAx*VRR0(38,28)+WPx*VRR1(38,28)
      VRR0(59,29)=V(31)+V(33)+PAx*VRR0(38,29)+WPx*VRR1(38,29)
      VRR0(59,30)=V(35)+V(37)+2.D0*V(38)+PAx*VRR0(38,30)+WPx*VRR1(38,30)
      VRR0(59,31)=V(40)+V(42)+V(43)+PAx*VRR0(38,31)+WPx*VRR1(38,31)
      VRR0(59,32)=V(45)+V(47)+PAx*VRR0(38,32)+WPx*VRR1(38,32)
      VRR0(59,33)=V(49)+V(51)+V(52)+PAx*VRR0(38,33)+WPx*VRR1(38,33)
      VRR0(59,34)=V(54)+V(56)+PAx*VRR0(38,34)+WPx*VRR1(38,34)
      VRR0(59,35)=3.D0*r1x2E*VRR0(59,10)+QCz*VRR0(59,20)-3.D0*r1x2E*ZxZpE*VRR1(59,10)+WQz*VRR1(59,20)
      VRR0(60,21)=3.D0*V(57)+3.D0*r1x2E*VRR0(60,5)+QCx*VRR0(60,11)-3.D0*r1x2E*ZxZpE*VRR1(60,5)+WQx*VRR1(60,11)
      VRR0(60,22)=V(59)+3.D0*V(60)+V(62)+QCx*VRR0(60,12)+WQx*VRR1(60,12)
      VRR0(60,23)=2.D0*V(63)-2.D0*V(64)+2.D0*V(65)+PAx*VRR0(39,23)+WPx*VRR1(39,23)
      VRR0(60,24)=3.D0*V(11)+V(59)+V(62)+QCy*VRR0(60,13)+WQy*VRR1(60,13)
      VRR0(60,25)=3.D0*V(16)+3.D0*r1x2E*VRR0(60,7)+QCy*VRR0(60,14)-3.D0*r1x2E*ZxZpE*VRR1(60,7)+WQy*VRR1(60,14)
      VRR0(60,26)=V(67)+3.D0*V(68)+V(70)+QCx*VRR0(60,15)+WQx*VRR1(60,15)
      VRR0(60,27)=2.D0*V(71)-2.D0*V(72)+V(74)+PAx*VRR0(39,27)+WPx*VRR1(39,27)
      VRR0(60,28)=2.D0*V(75)-2.D0*V(76)+V(77)+PAx*VRR0(39,28)+WPx*VRR1(39,28)
      VRR0(60,29)=3.D0*V(29)+V(79)+V(81)+QCy*VRR0(60,17)+WQy*VRR1(60,17)
      VRR0(60,30)=2.D0*V(82)-2.D0*V(83)+2.D0*V(84)+PAx*VRR0(39,30)+WPx*VRR1(39,30)
      VRR0(60,31)=2.D0*V(85)-2.D0*V(86)+V(87)+PAx*VRR0(39,31)+WPx*VRR1(39,31)
      VRR0(60,32)=2.D0*V(88)-2.D0*V(89)+PAx*VRR0(39,32)+WPx*VRR1(39,32)
      VRR0(60,33)=V(67)+V(70)+QCz*VRR0(60,18)+WQz*VRR1(60,18)
      VRR0(60,34)=V(79)+V(81)+QCz*VRR0(60,19)+WQz*VRR1(60,19)
      VRR0(60,35)=3.D0*r1x2E*VRR0(60,10)+QCz*VRR0(60,20)-3.D0*r1x2E*ZxZpE*VRR1(60,10)+WQz*VRR1(60,20)
      VRR0(61,21)=2.D0*V(90)+3.D0*r1x2E*VRR0(61,5)+QCx*VRR0(61,11)-3.D0*r1x2E*ZxZpE*VRR1(61,5)+WQx*VRR1(61,11)
      VRR0(61,22)=V(4)+V(6)+V(57)+PAy*VRR0(39,22)+WPy*VRR1(39,22)
      VRR0(61,23)=V(8)+V(10)+2.D0*V(60)+PAy*VRR0(39,23)+WPy*VRR1(39,23)
      VRR0(61,24)=V(13)+V(15)+3.D0*V(65)+PAy*VRR0(39,24)+WPy*VRR1(39,24)
      VRR0(61,25)=3.D0*r1x2E*VRR0(61,7)+QCy*VRR0(61,14)+4.D0*HfxZpE*VRR1(39,14)-3.D0*r1x2E*ZxZpE*VRR1(61,7)+WQy*VRR1(61,14)
      VRR0(61,26)=V(18)+V(20)+PAy*VRR0(39,26)+WPy*VRR1(39,26)
      VRR0(61,27)=V(22)+V(24)+V(68)+PAy*VRR0(39,27)+WPy*VRR1(39,27)
      VRR0(61,28)=V(26)+V(28)+V(74)+PAy*VRR0(39,28)+WPy*VRR1(39,28)
      VRR0(61,29)=V(31)+V(33)+3.D0*V(77)+PAy*VRR0(39,29)+WPy*VRR1(39,29)
      VRR0(61,30)=V(35)+V(37)+PAy*VRR0(39,30)+WPy*VRR1(39,30)
      VRR0(61,31)=V(40)+V(42)+V(84)+PAy*VRR0(39,31)+WPy*VRR1(39,31)
      VRR0(61,32)=V(45)+V(47)+2.D0*V(87)+PAy*VRR0(39,32)+WPy*VRR1(39,32)
      VRR0(61,33)=V(49)+V(51)+PAy*VRR0(39,33)+WPy*VRR1(39,33)
      VRR0(61,34)=V(54)+V(56)+V(91)+PAy*VRR0(39,34)+WPy*VRR1(39,34)
      VRR0(61,35)=3.D0*r1x2E*VRR0(61,10)+QCz*VRR0(61,20)-3.D0*r1x2E*ZxZpE*VRR1(61,10)+WQz*VRR1(61,20)
      VRR0(62,21)=4.D0*r1x2Z*VRR0(24,21)+PAy*VRR0(40,21)-4.D0*ExZpE*r1x2Z*VRR1(24,21)+WPy*VRR1(40,21)
      VRR0(62,22)=V(90)+4.D0*r1x2Z*VRR0(24,22)+PAy*VRR0(40,22)-4.D0*ExZpE*r1x2Z*VRR1(24,22)+WPy*VRR1(40,22)
      VRR0(62,23)=4.D0*V(63)-4.D0*V(64)+PAy*VRR0(40,23)+2.D0*HfxZpE*VRR1(40,12)+WPy*VRR1(40,23)
      VRR0(62,24)=4.D0*r1x2Z*VRR0(24,24)+PAy*VRR0(40,24)-4.D0*ExZpE*r1x2Z*VRR1(24,24)+3.D0*HfxZpE*VRR1(40,13)+WPy*VRR1(40,24)
      VRR0(62,25)=4.D0*r1x2Z*VRR0(24,25)+PAy*VRR0(40,25)-4.D0*ExZpE*r1x2Z*VRR1(24,25)+4.D0*HfxZpE*VRR1(40,14)+WPy*VRR1(40,25)
      VRR0(62,26)=4.D0*r1x2Z*VRR0(24,26)+PAy*VRR0(40,26)-4.D0*ExZpE*r1x2Z*VRR1(24,26)+WPy*VRR1(40,26)
      VRR0(62,27)=4.D0*V(71)-4.D0*V(72)+PAy*VRR0(40,27)+HfxZpE*VRR1(40,15)+WPy*VRR1(40,27)
      VRR0(62,28)=4.D0*V(75)-4.D0*V(76)+PAy*VRR0(40,28)+2.D0*HfxZpE*VRR1(40,16)+WPy*VRR1(40,28)
      VRR0(62,29)=4.D0*r1x2Z*VRR0(24,29)+PAy*VRR0(40,29)-4.D0*ExZpE*r1x2Z*VRR1(24,29)+3.D0*HfxZpE*VRR1(40,17)+WPy*VRR1(40,29)
      VRR0(62,30)=4.D0*V(82)-4.D0*V(83)+PAy*VRR0(40,30)+WPy*VRR1(40,30)
      VRR0(62,31)=4.D0*V(85)-4.D0*V(86)+PAy*VRR0(40,31)+HfxZpE*VRR1(40,18)+WPy*VRR1(40,31)
      VRR0(62,32)=4.D0*V(88)-4.D0*V(89)+PAy*VRR0(40,32)+2.D0*HfxZpE*VRR1(40,19)+WPy*VRR1(40,32)
      VRR0(62,33)=4.D0*r1x2Z*VRR0(24,33)+PAy*VRR0(40,33)-4.D0*ExZpE*r1x2Z*VRR1(24,33)+WPy*VRR1(40,33)
      VRR0(62,34)=V(92)+4.D0*r1x2Z*VRR0(24,34)+PAy*VRR0(40,34)-4.D0*ExZpE*r1x2Z*VRR1(24,34)+WPy*VRR1(40,34)
      VRR0(62,35)=4.D0*r1x2Z*VRR0(24,35)+PAy*VRR0(40,35)-4.D0*ExZpE*r1x2Z*VRR1(24,35)+WPy*VRR1(40,35)
      VRR0(63,21)=5.D0*r1x2Z*VRR0(25,21)+PAy*VRR0(41,21)-5.D0*ExZpE*r1x2Z*VRR1(25,21)+WPy*VRR1(41,21)
      VRR0(63,22)=5.D0*r1x2Z*VRR0(25,22)+PAy*VRR0(41,22)-5.D0*ExZpE*r1x2Z*VRR1(25,22)+HfxZpE*VRR1(41,11)+WPy*VRR1(41,22)
      VRR0(63,23)=5.D0*r1x2Z*VRR0(25,23)+PAy*VRR0(41,23)-5.D0*ExZpE*r1x2Z*VRR1(25,23)+2.D0*HfxZpE*VRR1(41,12)+WPy*VRR1(41,23)
      VRR0(63,24)=5.D0*r1x2Z*VRR0(25,24)+PAy*VRR0(41,24)-5.D0*ExZpE*r1x2Z*VRR1(25,24)+3.D0*HfxZpE*VRR1(41,13)+WPy*VRR1(41,24)
      VRR0(63,25)=5.D0*r1x2Z*VRR0(25,25)+PAy*VRR0(41,25)-5.D0*ExZpE*r1x2Z*VRR1(25,25)+4.D0*HfxZpE*VRR1(41,14)+WPy*VRR1(41,25)
      VRR0(63,26)=5.D0*r1x2Z*VRR0(25,26)+PAy*VRR0(41,26)-5.D0*ExZpE*r1x2Z*VRR1(25,26)+WPy*VRR1(41,26)
      VRR0(63,27)=5.D0*r1x2Z*VRR0(25,27)+PAy*VRR0(41,27)-5.D0*ExZpE*r1x2Z*VRR1(25,27)+HfxZpE*VRR1(41,15)+WPy*VRR1(41,27)
      VRR0(63,28)=5.D0*r1x2Z*VRR0(25,28)+PAy*VRR0(41,28)-5.D0*ExZpE*r1x2Z*VRR1(25,28)+2.D0*HfxZpE*VRR1(41,16)+WPy*VRR1(41,28)
      VRR0(63,29)=5.D0*r1x2Z*VRR0(25,29)+PAy*VRR0(41,29)-5.D0*ExZpE*r1x2Z*VRR1(25,29)+3.D0*HfxZpE*VRR1(41,17)+WPy*VRR1(41,29)
      VRR0(63,30)=5.D0*r1x2Z*VRR0(25,30)+PAy*VRR0(41,30)-5.D0*ExZpE*r1x2Z*VRR1(25,30)+WPy*VRR1(41,30)
      VRR0(63,31)=5.D0*r1x2Z*VRR0(25,31)+PAy*VRR0(41,31)-5.D0*ExZpE*r1x2Z*VRR1(25,31)+HfxZpE*VRR1(41,18)+WPy*VRR1(41,31)
      VRR0(63,32)=5.D0*r1x2Z*VRR0(25,32)+PAy*VRR0(41,32)-5.D0*ExZpE*r1x2Z*VRR1(25,32)+2.D0*HfxZpE*VRR1(41,19)+WPy*VRR1(41,32)
      VRR0(63,33)=5.D0*r1x2Z*VRR0(25,33)+PAy*VRR0(41,33)-5.D0*ExZpE*r1x2Z*VRR1(25,33)+WPy*VRR1(41,33)
      VRR0(63,34)=5.D0*r1x2Z*VRR0(25,34)+PAy*VRR0(41,34)-5.D0*ExZpE*r1x2Z*VRR1(25,34)+HfxZpE*VRR1(41,20)+WPy*VRR1(41,34)
      VRR0(63,35)=5.D0*r1x2Z*VRR0(25,35)+PAy*VRR0(41,35)-5.D0*ExZpE*r1x2Z*VRR1(25,35)+WPy*VRR1(41,35)
      VRR0(64,21)=4.D0*r1x2Z*VRR0(26,21)+PAx*VRR0(42,21)-4.D0*ExZpE*r1x2Z*VRR1(26,21)+4.D0*HfxZpE*VRR1(42,11)+WPx*VRR1(42,21)
      VRR0(64,22)=4.D0*r1x2Z*VRR0(26,22)+PAx*VRR0(42,22)-4.D0*ExZpE*r1x2Z*VRR1(26,22)+3.D0*HfxZpE*VRR1(42,12)+WPx*VRR1(42,22)
      VRR0(64,23)=4.D0*r1x2Z*VRR0(26,23)+PAx*VRR0(42,23)-4.D0*ExZpE*r1x2Z*VRR1(26,23)+2.D0*HfxZpE*VRR1(42,13)+WPx*VRR1(42,23)
      VRR0(64,24)=V(93)+4.D0*r1x2Z*VRR0(26,24)+PAx*VRR0(42,24)-4.D0*ExZpE*r1x2Z*VRR1(26,24)+WPx*VRR1(42,24)
      VRR0(64,25)=4.D0*r1x2Z*VRR0(26,25)+PAx*VRR0(42,25)-4.D0*ExZpE*r1x2Z*VRR1(26,25)+WPx*VRR1(42,25)
      VRR0(64,26)=4.D0*r1x2Z*VRR0(26,26)+PAx*VRR0(42,26)-4.D0*ExZpE*r1x2Z*VRR1(26,26)+3.D0*HfxZpE*VRR1(42,15)+WPx*VRR1(42,26)
      VRR0(64,27)=4.D0*r1x2Z*VRR0(26,27)+PAx*VRR0(42,27)-4.D0*ExZpE*r1x2Z*VRR1(26,27)+2.D0*HfxZpE*VRR1(42,16)+WPx*VRR1(42,27)
      VRR0(64,28)=4.D0*r1x2Z*VRR0(26,28)+PAx*VRR0(42,28)-4.D0*ExZpE*r1x2Z*VRR1(26,28)+HfxZpE*VRR1(42,17)+WPx*VRR1(42,28)
      VRR0(64,29)=4.D0*r1x2Z*VRR0(26,29)+PAx*VRR0(42,29)-4.D0*ExZpE*r1x2Z*VRR1(26,29)+WPx*VRR1(42,29)
      VRR0(64,30)=4.D0*r1x2Z*VRR0(26,30)+PAx*VRR0(42,30)-4.D0*ExZpE*r1x2Z*VRR1(26,30)+2.D0*HfxZpE*VRR1(42,18)+WPx*VRR1(42,30)
      VRR0(64,31)=4.D0*r1x2Z*VRR0(26,31)+PAx*VRR0(42,31)-4.D0*ExZpE*r1x2Z*VRR1(26,31)+HfxZpE*VRR1(42,19)+WPx*VRR1(42,31)
      VRR0(64,32)=4.D0*r1x2Z*VRR0(26,32)+PAx*VRR0(42,32)-4.D0*ExZpE*r1x2Z*VRR1(26,32)+WPx*VRR1(42,32)
      VRR0(64,33)=V(94)+4.D0*r1x2Z*VRR0(26,33)+PAx*VRR0(42,33)-4.D0*ExZpE*r1x2Z*VRR1(26,33)+WPx*VRR1(42,33)
      VRR0(64,34)=4.D0*r1x2Z*VRR0(26,34)+PAx*VRR0(42,34)-4.D0*ExZpE*r1x2Z*VRR1(26,34)+WPx*VRR1(42,34)
      VRR0(64,35)=4.D0*r1x2Z*VRR0(26,35)+PAx*VRR0(42,35)-4.D0*ExZpE*r1x2Z*VRR1(26,35)+WPx*VRR1(42,35)
      VRR0(65,21)=3.D0*r1x2E*VRR0(65,5)+QCx*VRR0(65,11)+4.D0*HfxZpE*VRR1(43,11)-3.D0*r1x2E*ZxZpE*VRR1(65,5)+WQx*VRR1(65,11)
      VRR0(65,22)=3.D0*r1x2Z*VRR0(27,22)+PAx*VRR0(43,22)-3.D0*ExZpE*r1x2Z*VRR1(27,22)+3.D0*HfxZpE*VRR1(43,12)+WPx*VRR1(43,22)
      VRR0(65,23)=3.D0*V(95)-3.D0*V(96)+V(98)+PAx*VRR0(43,23)+WPx*VRR1(43,23)
      VRR0(65,24)=V(99)+3.D0*r1x2Z*VRR0(27,24)+PAx*VRR0(43,24)-3.D0*ExZpE*r1x2Z*VRR1(27,24)+WPx*VRR1(43,24)
      VRR0(65,25)=V(93)+3.D0*r1x2E*VRR0(65,7)+QCy*VRR0(65,14)-3.D0*r1x2E*ZxZpE*VRR1(65,7)+WQy*VRR1(65,14)
      VRR0(65,26)=3.D0*r1x2Z*VRR0(27,26)+PAx*VRR0(43,26)-3.D0*ExZpE*r1x2Z*VRR1(27,26)+3.D0*HfxZpE*VRR1(43,15)+WPx*VRR1(43,26)
      VRR0(65,27)=3.D0*V(100)-3.D0*V(101)+PAx*VRR0(43,27)+2.D0*HfxZpE*VRR1(43,16)+WPx*VRR1(43,27)
      VRR0(65,28)=3.D0*V(102)-3.D0*V(103)+V(104)+PAx*VRR0(43,28)+WPx*VRR1(43,28)
      VRR0(65,29)=3.D0*r1x2Z*VRR0(27,29)+PAx*VRR0(43,29)-3.D0*ExZpE*r1x2Z*VRR1(27,29)+WPx*VRR1(43,29)
      VRR0(65,30)=3.D0*V(105)-3.D0*V(106)+V(108)+PAx*VRR0(43,30)+WPx*VRR1(43,30)
      VRR0(65,31)=3.D0*V(109)-3.D0*V(110)+V(111)+PAx*VRR0(43,31)+WPx*VRR1(43,31)
      VRR0(65,32)=3.D0*V(112)-3.D0*V(113)+PAx*VRR0(43,32)+WPx*VRR1(43,32)
      VRR0(65,33)=V(114)+3.D0*r1x2Z*VRR0(27,33)+PAx*VRR0(43,33)-3.D0*ExZpE*r1x2Z*VRR1(27,33)+WPx*VRR1(43,33)
      VRR0(65,34)=3.D0*r1x2Z*VRR0(27,34)+PAx*VRR0(43,34)-3.D0*ExZpE*r1x2Z*VRR1(27,34)+WPx*VRR1(43,34)
      VRR0(65,35)=V(2)+3.D0*r1x2E*VRR0(65,10)+QCz*VRR0(65,20)-3.D0*r1x2E*ZxZpE*VRR1(65,10)+WQz*VRR1(65,20)
      VRR0(66,21)=3.D0*r1x2E*VRR0(66,5)+QCx*VRR0(66,11)+3.D0*HfxZpE*VRR1(44,11)-3.D0*r1x2E*ZxZpE*VRR1(66,5)+WQx*VRR1(66,11)
      VRR0(66,22)=V(116)+3.D0*V(117)+V(119)+QCx*VRR0(66,12)+WQx*VRR1(66,12)
      VRR0(66,23)=V(121)+V(123)+2.D0*V(124)+PAx*VRR0(44,23)+WPx*VRR1(44,23)
      VRR0(66,24)=V(98)+V(116)+V(119)+QCy*VRR0(66,13)+WQy*VRR1(66,13)
      VRR0(66,25)=2.D0*V(99)+3.D0*r1x2E*VRR0(66,7)+QCy*VRR0(66,14)-3.D0*r1x2E*ZxZpE*VRR1(66,7)+WQy*VRR1(66,14)
      VRR0(66,26)=V(126)+3.D0*V(127)+V(129)+QCx*VRR0(66,15)+WQx*VRR1(66,15)
      VRR0(66,27)=V(131)+V(133)+V(135)+PAx*VRR0(44,27)+WPx*VRR1(44,27)
      VRR0(66,28)=V(137)+V(139)+V(140)+PAx*VRR0(44,28)+WPx*VRR1(44,28)
      VRR0(66,29)=2.D0*V(104)+V(142)+V(144)+QCy*VRR0(66,17)+WQy*VRR1(66,17)
      VRR0(66,30)=V(146)+V(148)+V(150)+PAx*VRR0(44,30)+WPx*VRR1(44,30)
      VRR0(66,31)=V(152)+V(154)+V(155)+PAx*VRR0(44,31)+WPx*VRR1(44,31)
      VRR0(66,32)=V(157)+V(159)+PAx*VRR0(44,32)+WPx*VRR1(44,32)
      VRR0(66,33)=V(38)+V(126)+V(129)+QCz*VRR0(66,18)+WQz*VRR1(66,18)
      VRR0(66,34)=V(43)+V(142)+V(144)+QCz*VRR0(66,19)+WQz*VRR1(66,19)
      VRR0(66,35)=V(52)+3.D0*r1x2E*VRR0(66,10)+QCz*VRR0(66,20)-3.D0*r1x2E*ZxZpE*VRR1(66,10)+WQz*VRR1(66,20)
      VRR0(67,21)=2.D0*V(160)+3.D0*r1x2E*VRR0(67,5)+QCx*VRR0(67,11)-3.D0*r1x2E*ZxZpE*VRR1(67,5)+WQx*VRR1(67,11)
      VRR0(67,22)=V(162)+V(164)+V(166)+QCx*VRR0(67,12)+WQx*VRR1(67,12)
      VRR0(67,23)=2.D0*V(117)+V(167)+V(168)+PAy*VRR0(44,23)+WPy*VRR1(44,23)
      VRR0(67,24)=3.D0*V(124)+V(162)+V(166)+QCy*VRR0(67,13)+WQy*VRR1(67,13)
      VRR0(67,25)=3.D0*r1x2E*VRR0(67,7)+QCy*VRR0(67,14)+3.D0*HfxZpE*VRR1(44,14)-3.D0*r1x2E*ZxZpE*VRR1(67,7)+WQy*VRR1(67,14)
      VRR0(67,26)=V(170)+2.D0*V(171)+V(173)+QCx*VRR0(67,15)+WQx*VRR1(67,15)
      VRR0(67,27)=V(127)+V(174)+V(175)+PAy*VRR0(44,27)+WPy*VRR1(44,27)
      VRR0(67,28)=V(135)+V(176)+V(177)+PAy*VRR0(44,28)+WPy*VRR1(44,28)
      VRR0(67,29)=3.D0*V(140)+V(179)+V(181)+QCy*VRR0(67,17)+WQy*VRR1(67,17)
      VRR0(67,30)=V(182)+V(183)+PAy*VRR0(44,30)+WPy*VRR1(44,30)
      VRR0(67,31)=V(149)+V(184)+V(185)+PAy*VRR0(44,31)+WPy*VRR1(44,31)
      VRR0(67,32)=V(186)+V(187)+V(188)+PAy*VRR0(44,32)+WPy*VRR1(44,32)
      VRR0(67,33)=V(84)+V(170)+V(173)+QCz*VRR0(67,18)+WQz*VRR1(67,18)
      VRR0(67,34)=V(87)+V(179)+V(181)+QCz*VRR0(67,19)+WQz*VRR1(67,19)
      VRR0(67,35)=V(91)+3.D0*r1x2E*VRR0(67,10)+QCz*VRR0(67,20)-3.D0*r1x2E*ZxZpE*VRR1(67,10)+WQz*VRR1(67,20)
      VRR0(68,21)=V(189)+3.D0*r1x2E*VRR0(68,5)+QCx*VRR0(68,11)-3.D0*r1x2E*ZxZpE*VRR1(68,5)+WQx*VRR1(68,11)
      VRR0(68,22)=V(160)+3.D0*r1x2Z*VRR0(28,22)+PAy*VRR0(45,22)-3.D0*ExZpE*r1x2Z*VRR1(28,22)+WPy*VRR1(45,22)
      VRR0(68,23)=3.D0*V(120)-3.D0*V(122)+V(164)+PAy*VRR0(45,23)+WPy*VRR1(45,23)
      VRR0(68,24)=3.D0*r1x2Z*VRR0(28,24)+PAy*VRR0(45,24)-3.D0*ExZpE*r1x2Z*VRR1(28,24)+3.D0*HfxZpE*VRR1(45,13)+WPy*VRR1(45,24)
      VRR0(68,25)=3.D0*r1x2E*VRR0(68,7)+QCy*VRR0(68,14)+4.D0*HfxZpE*VRR1(45,14)-3.D0*r1x2E*ZxZpE*VRR1(68,7)+WQy*VRR1(68,14)
      VRR0(68,26)=3.D0*r1x2Z*VRR0(28,26)+PAy*VRR0(45,26)-3.D0*ExZpE*r1x2Z*VRR1(28,26)+WPy*VRR1(45,26)
      VRR0(68,27)=3.D0*V(130)-3.D0*V(132)+V(171)+PAy*VRR0(45,27)+WPy*VRR1(45,27)
      VRR0(68,28)=3.D0*V(136)-3.D0*V(138)+PAy*VRR0(45,28)+2.D0*HfxZpE*VRR1(45,16)+WPy*VRR1(45,28)
      VRR0(68,29)=3.D0*r1x2Z*VRR0(28,29)+PAy*VRR0(45,29)-3.D0*ExZpE*r1x2Z*VRR1(28,29)+3.D0*HfxZpE*VRR1(45,17)+WPy*VRR1(45,29)
      VRR0(68,30)=3.D0*V(145)-3.D0*V(147)+PAy*VRR0(45,30)+WPy*VRR1(45,30)
      VRR0(68,31)=3.D0*V(151)-3.D0*V(153)+V(190)+PAy*VRR0(45,31)+WPy*VRR1(45,31)
      VRR0(68,32)=3.D0*V(156)-3.D0*V(158)+V(192)+PAy*VRR0(45,32)+WPy*VRR1(45,32)
      VRR0(68,33)=3.D0*r1x2Z*VRR0(28,33)+PAy*VRR0(45,33)-3.D0*ExZpE*r1x2Z*VRR1(28,33)+WPy*VRR1(45,33)
      VRR0(68,34)=V(193)+3.D0*r1x2Z*VRR0(28,34)+PAy*VRR0(45,34)-3.D0*ExZpE*r1x2Z*VRR1(28,34)+WPy*VRR1(45,34)
      VRR0(68,35)=V(92)+3.D0*r1x2E*VRR0(68,10)+QCz*VRR0(68,20)-3.D0*r1x2E*ZxZpE*VRR1(68,10)+WQz*VRR1(68,20)
      VRR0(69,21)=4.D0*r1x2Z*VRR0(29,21)+PAy*VRR0(46,21)-4.D0*ExZpE*r1x2Z*VRR1(29,21)+WPy*VRR1(46,21)
      VRR0(69,22)=V(189)+4.D0*r1x2Z*VRR0(29,22)+PAy*VRR0(46,22)-4.D0*ExZpE*r1x2Z*VRR1(29,22)+WPy*VRR1(46,22)
      VRR0(69,23)=4.D0*r1x2Z*VRR0(29,23)+PAy*VRR0(46,23)-4.D0*ExZpE*r1x2Z*VRR1(29,23)+2.D0*HfxZpE*VRR1(46,12)+WPy*VRR1(46,23)
      VRR0(69,24)=4.D0*r1x2Z*VRR0(29,24)+PAy*VRR0(46,24)-4.D0*ExZpE*r1x2Z*VRR1(29,24)+3.D0*HfxZpE*VRR1(46,13)+WPy*VRR1(46,24)
      VRR0(69,25)=4.D0*r1x2Z*VRR0(29,25)+PAy*VRR0(46,25)-4.D0*ExZpE*r1x2Z*VRR1(29,25)+4.D0*HfxZpE*VRR1(46,14)+WPy*VRR1(46,25)
      VRR0(69,26)=4.D0*r1x2Z*VRR0(29,26)+PAy*VRR0(46,26)-4.D0*ExZpE*r1x2Z*VRR1(29,26)+WPy*VRR1(46,26)
      VRR0(69,27)=4.D0*r1x2Z*VRR0(29,27)+PAy*VRR0(46,27)-4.D0*ExZpE*r1x2Z*VRR1(29,27)+HfxZpE*VRR1(46,15)+WPy*VRR1(46,27)
      VRR0(69,28)=4.D0*r1x2Z*VRR0(29,28)+PAy*VRR0(46,28)-4.D0*ExZpE*r1x2Z*VRR1(29,28)+2.D0*HfxZpE*VRR1(46,16)+WPy*VRR1(46,28)
      VRR0(69,29)=4.D0*r1x2Z*VRR0(29,29)+PAy*VRR0(46,29)-4.D0*ExZpE*r1x2Z*VRR1(29,29)+3.D0*HfxZpE*VRR1(46,17)+WPy*VRR1(46,29)
      VRR0(69,30)=4.D0*r1x2Z*VRR0(29,30)+PAy*VRR0(46,30)-4.D0*ExZpE*r1x2Z*VRR1(29,30)+WPy*VRR1(46,30)
      VRR0(69,31)=4.D0*r1x2Z*VRR0(29,31)+PAy*VRR0(46,31)-4.D0*ExZpE*r1x2Z*VRR1(29,31)+HfxZpE*VRR1(46,18)+WPy*VRR1(46,31)
      VRR0(69,32)=4.D0*r1x2Z*VRR0(29,32)+PAy*VRR0(46,32)-4.D0*ExZpE*r1x2Z*VRR1(29,32)+2.D0*HfxZpE*VRR1(46,19)+WPy*VRR1(46,32)
      VRR0(69,33)=4.D0*r1x2Z*VRR0(29,33)+PAy*VRR0(46,33)-4.D0*ExZpE*r1x2Z*VRR1(29,33)+WPy*VRR1(46,33)
      VRR0(69,34)=V(194)+4.D0*r1x2Z*VRR0(29,34)+PAy*VRR0(46,34)-4.D0*ExZpE*r1x2Z*VRR1(29,34)+WPy*VRR1(46,34)
      VRR0(69,35)=4.D0*r1x2Z*VRR0(29,35)+PAy*VRR0(46,35)-4.D0*ExZpE*r1x2Z*VRR1(29,35)+WPy*VRR1(46,35)
      VRR0(70,21)=3.D0*r1x2E*VRR0(70,5)+QCx*VRR0(70,11)+4.D0*HfxZpE*VRR1(47,11)-3.D0*r1x2E*ZxZpE*VRR1(70,5)+WQx*VRR1(70,11)
      VRR0(70,22)=V(196)+V(198)+PAx*VRR0(47,22)+3.D0*HfxZpE*VRR1(47,12)+WPx*VRR1(47,22)
      VRR0(70,23)=V(200)+V(202)+2.D0*V(203)+PAx*VRR0(47,23)+WPx*VRR1(47,23)
      VRR0(70,24)=V(205)+V(207)+V(208)+PAx*VRR0(47,24)+WPx*VRR1(47,24)
      VRR0(70,25)=3.D0*r1x2E*VRR0(70,7)+QCy*VRR0(70,14)-3.D0*r1x2E*ZxZpE*VRR1(70,7)+WQy*VRR1(70,14)
      VRR0(70,26)=V(210)+V(212)+PAx*VRR0(47,26)+3.D0*HfxZpE*VRR1(47,15)+WPx*VRR1(47,26)
      VRR0(70,27)=V(214)+V(216)+PAx*VRR0(47,27)+2.D0*HfxZpE*VRR1(47,16)+WPx*VRR1(47,27)
      VRR0(70,28)=V(218)+V(220)+V(221)+PAx*VRR0(47,28)+WPx*VRR1(47,28)
      VRR0(70,29)=V(223)+V(225)+PAx*VRR0(47,29)+WPx*VRR1(47,29)
      VRR0(70,30)=V(227)+V(229)+2.D0*V(230)+PAx*VRR0(47,30)+WPx*VRR1(47,30)
      VRR0(70,31)=V(232)+V(234)+V(235)+PAx*VRR0(47,31)+WPx*VRR1(47,31)
      VRR0(70,32)=V(237)+V(239)+PAx*VRR0(47,32)+WPx*VRR1(47,32)
      VRR0(70,33)=V(241)+V(243)+V(244)+PAx*VRR0(47,33)+WPx*VRR1(47,33)
      VRR0(70,34)=V(246)+V(248)+PAx*VRR0(47,34)+WPx*VRR1(47,34)
      VRR0(70,35)=2.D0*V(94)+3.D0*r1x2E*VRR0(70,10)+QCz*VRR0(70,20)-3.D0*r1x2E*ZxZpE*VRR1(70,10)+WQz*VRR1(70,20)
      VRR0(71,21)=3.D0*r1x2E*VRR0(71,5)+QCx*VRR0(71,11)+3.D0*HfxZpE*VRR1(48,11)-3.D0*r1x2E*ZxZpE*VRR1(71,5)+WQx*VRR1(71,11)
      VRR0(71,22)=V(250)+3.D0*V(251)+V(253)+QCx*VRR0(71,12)+WQx*VRR1(71,12)
      VRR0(71,23)=V(255)+V(257)+V(259)+PAx*VRR0(48,23)+WPx*VRR1(48,23)
      VRR0(71,24)=V(203)+V(250)+V(253)+QCy*VRR0(71,13)+WQy*VRR1(71,13)
      VRR0(71,25)=V(208)+3.D0*r1x2E*VRR0(71,7)+QCy*VRR0(71,14)-3.D0*r1x2E*ZxZpE*VRR1(71,7)+WQy*VRR1(71,14)
      VRR0(71,26)=V(261)+3.D0*V(262)+V(264)+QCx*VRR0(71,15)+WQx*VRR1(71,15)
      VRR0(71,27)=V(266)+V(268)+V(270)+PAx*VRR0(48,27)+WPx*VRR1(48,27)
      VRR0(71,28)=V(272)+V(274)+V(275)+PAx*VRR0(48,28)+WPx*VRR1(48,28)
      VRR0(71,29)=V(221)+V(277)+V(279)+QCy*VRR0(71,17)+WQy*VRR1(71,17)
      VRR0(71,30)=V(281)+V(283)+2.D0*V(284)+PAx*VRR0(48,30)+WPx*VRR1(48,30)
      VRR0(71,31)=V(286)+V(288)+V(289)+PAx*VRR0(48,31)+WPx*VRR1(48,31)
      VRR0(71,32)=V(291)+V(293)+PAx*VRR0(48,32)+WPx*VRR1(48,32)
      VRR0(71,33)=V(108)+V(261)+V(264)+QCz*VRR0(71,18)+WQz*VRR1(71,18)
      VRR0(71,34)=2.D0*V(111)+V(277)+V(279)+QCz*VRR0(71,19)+WQz*VRR1(71,19)
      VRR0(71,35)=2.D0*V(114)+3.D0*r1x2E*VRR0(71,10)+QCz*VRR0(71,20)-3.D0*r1x2E*ZxZpE*VRR1(71,10)+WQz*VRR1(71,20)
      VRR0(72,21)=3.D0*r1x2E*VRR0(72,5)+QCx*VRR0(72,11)+2.D0*HfxZpE*VRR1(49,11)-3.D0*r1x2E*ZxZpE*VRR1(72,5)+WQx*VRR1(72,11)
      VRR0(72,22)=V(295)+V(297)+V(299)+QCx*VRR0(72,12)+WQx*VRR1(72,12)
      VRR0(72,23)=V(300)+2.D0*V(301)-V(302)+QCx*VRR0(72,13)+WQx*VRR1(72,13)
      VRR0(72,24)=V(259)+V(295)+V(299)+QCy*VRR0(72,13)+WQy*VRR1(72,13)
      VRR0(72,25)=3.D0*V(300)-3.D0*V(302)+QCy*VRR0(72,14)+2.D0*HfxZpE*VRR1(48,14)+WQy*VRR1(72,14)
      VRR0(72,26)=V(304)+V(306)+V(308)+QCx*VRR0(72,15)+WQx*VRR1(72,15)
      VRR0(72,27)=V(309)+V(311)-V(312)+QCx*VRR0(72,16)+WQx*VRR1(72,16)
      VRR0(72,28)=V(270)+V(303)-V(307)+QCy*VRR0(72,16)+WQy*VRR1(72,16)
      VRR0(72,29)=V(313)+V(314)+V(315)+QCy*VRR0(72,17)+WQy*VRR1(72,17)
      VRR0(72,30)=V(316)+2.D0*V(317)+V(319)+QCx*VRR0(72,18)+WQx*VRR1(72,18)
      VRR0(72,31)=V(135)+V(294)-V(298)+QCz*VRR0(72,16)+WQz*VRR1(72,16)
      VRR0(72,32)=2.D0*V(289)+V(316)+V(319)+QCy*VRR0(72,19)+WQy*VRR1(72,19)
      VRR0(72,33)=V(150)+V(304)+V(308)+QCz*VRR0(72,18)+WQz*VRR1(72,18)
      VRR0(72,34)=V(188)+V(313)+V(315)+QCz*VRR0(72,19)+WQz*VRR1(72,19)
      VRR0(72,35)=3.D0*V(316)-3.D0*V(318)+QCz*VRR0(72,20)+2.D0*HfxZpE*VRR1(44,20)+WQz*VRR1(72,20)
      VRR0(73,21)=V(320)+3.D0*r1x2E*VRR0(73,5)+QCx*VRR0(73,11)-3.D0*r1x2E*ZxZpE*VRR1(73,5)+WQx*VRR1(73,11)
      VRR0(73,22)=V(322)+V(323)+V(325)+QCx*VRR0(73,12)+WQx*VRR1(73,12)
      VRR0(73,23)=V(255)+V(257)+V(297)+PAy*VRR0(49,23)+WPy*VRR1(49,23)
      VRR0(73,24)=3.D0*V(301)+V(322)+V(325)+QCy*VRR0(73,13)+WQy*VRR1(73,13)
      VRR0(73,25)=3.D0*r1x2E*VRR0(73,7)+QCy*VRR0(73,14)+3.D0*HfxZpE*VRR1(49,14)-3.D0*r1x2E*ZxZpE*VRR1(73,7)+WQy*VRR1(73,14)
      VRR0(73,26)=V(327)+V(328)+V(330)+QCx*VRR0(73,15)+WQx*VRR1(73,15)
      VRR0(73,27)=V(266)+V(268)+V(305)+PAy*VRR0(49,27)+WPy*VRR1(49,27)
      VRR0(73,28)=V(272)+V(274)+V(311)+PAy*VRR0(49,28)+WPy*VRR1(49,28)
      VRR0(73,29)=V(332)+3.D0*V(333)+V(335)+QCy*VRR0(73,17)+WQy*VRR1(73,17)
      VRR0(73,30)=V(281)+V(283)+PAy*VRR0(49,30)+WPy*VRR1(49,30)
      VRR0(73,31)=V(286)+V(288)+V(317)+PAy*VRR0(49,31)+WPy*VRR1(49,31)
      VRR0(73,32)=V(291)+V(293)+2.D0*V(336)+PAy*VRR0(49,32)+WPy*VRR1(49,32)
      VRR0(73,33)=2.D0*V(190)+V(327)+V(330)+QCz*VRR0(73,18)+WQz*VRR1(73,18)
      VRR0(73,34)=V(192)+V(332)+V(335)+QCz*VRR0(73,19)+WQz*VRR1(73,19)
      VRR0(73,35)=2.D0*V(193)+3.D0*r1x2E*VRR0(73,10)+QCz*VRR0(73,20)-3.D0*r1x2E*ZxZpE*VRR1(73,10)+WQz*VRR1(73,20)
      VRR0(74,21)=3.D0*r1x2E*VRR0(74,5)+QCx*VRR0(74,11)-3.D0*r1x2E*ZxZpE*VRR1(74,5)+WQx*VRR1(74,11)
      VRR0(74,22)=V(320)+V(338)+V(340)+PAy*VRR0(50,22)+WPy*VRR1(50,22)
      VRR0(74,23)=2.D0*V(323)+V(342)+V(344)+PAy*VRR0(50,23)+WPy*VRR1(50,23)
      VRR0(74,24)=V(346)+V(348)+PAy*VRR0(50,24)+3.D0*HfxZpE*VRR1(50,13)+WPy*VRR1(50,24)
      VRR0(74,25)=3.D0*r1x2E*VRR0(74,7)+QCy*VRR0(74,14)+4.D0*HfxZpE*VRR1(50,14)-3.D0*r1x2E*ZxZpE*VRR1(74,7)+WQy*VRR1(74,14)
      VRR0(74,26)=V(350)+V(352)+PAy*VRR0(50,26)+WPy*VRR1(50,26)
      VRR0(74,27)=V(328)+V(354)+V(356)+PAy*VRR0(50,27)+WPy*VRR1(50,27)
      VRR0(74,28)=V(358)+V(360)+PAy*VRR0(50,28)+2.D0*HfxZpE*VRR1(50,16)+WPy*VRR1(50,28)
      VRR0(74,29)=V(362)+V(364)+PAy*VRR0(50,29)+3.D0*HfxZpE*VRR1(50,17)+WPy*VRR1(50,29)
      VRR0(74,30)=V(366)+V(368)+PAy*VRR0(50,30)+WPy*VRR1(50,30)
      VRR0(74,31)=V(370)+V(372)+V(373)+PAy*VRR0(50,31)+WPy*VRR1(50,31)
      VRR0(74,32)=V(375)+V(377)+2.D0*V(378)+PAy*VRR0(50,32)+WPy*VRR1(50,32)
      VRR0(74,33)=V(380)+V(382)+PAy*VRR0(50,33)+WPy*VRR1(50,33)
      VRR0(74,34)=V(384)+V(386)+V(387)+PAy*VRR0(50,34)+WPy*VRR1(50,34)
      VRR0(74,35)=2.D0*V(194)+3.D0*r1x2E*VRR0(74,10)+QCz*VRR0(74,20)-3.D0*r1x2E*ZxZpE*VRR1(74,10)+WQz*VRR1(74,20)
      VRR0(75,21)=3.D0*V(388)+3.D0*r1x2E*VRR0(75,5)+QCx*VRR0(75,11)-3.D0*r1x2E*ZxZpE*VRR1(75,5)+WQx*VRR1(75,11)
      VRR0(75,22)=V(390)+3.D0*V(391)+V(393)+QCx*VRR0(75,12)+WQx*VRR1(75,12)
      VRR0(75,23)=2.D0*V(394)-2.D0*V(395)+2.D0*V(396)+PAx*VRR0(51,23)+WPx*VRR1(51,23)
      VRR0(75,24)=V(390)+V(393)+QCy*VRR0(75,13)+WQy*VRR1(75,13)
      VRR0(75,25)=3.D0*r1x2E*VRR0(75,7)+QCy*VRR0(75,14)-3.D0*r1x2E*ZxZpE*VRR1(75,7)+WQy*VRR1(75,14)
      VRR0(75,26)=V(398)+3.D0*V(399)+V(401)+QCx*VRR0(75,15)+WQx*VRR1(75,15)
      VRR0(75,27)=2.D0*V(402)-2.D0*V(403)+V(405)+PAx*VRR0(51,27)+WPx*VRR1(51,27)
      VRR0(75,28)=2.D0*V(406)-2.D0*V(407)+V(408)+PAx*VRR0(51,28)+WPx*VRR1(51,28)
      VRR0(75,29)=V(410)+V(412)+QCy*VRR0(75,17)+WQy*VRR1(75,17)
      VRR0(75,30)=2.D0*V(413)-2.D0*V(414)+2.D0*V(415)+PAx*VRR0(51,30)+WPx*VRR1(51,30)
      VRR0(75,31)=2.D0*V(416)-2.D0*V(417)+V(418)+PAx*VRR0(51,31)+WPx*VRR1(51,31)
      VRR0(75,32)=2.D0*V(419)-2.D0*V(420)+PAx*VRR0(51,32)+WPx*VRR1(51,32)
      VRR0(75,33)=3.D0*V(230)+V(398)+V(401)+QCz*VRR0(75,18)+WQz*VRR1(75,18)
      VRR0(75,34)=3.D0*V(235)+V(410)+V(412)+QCz*VRR0(75,19)+WQz*VRR1(75,19)
      VRR0(75,35)=3.D0*V(244)+3.D0*r1x2E*VRR0(75,10)+QCz*VRR0(75,20)-3.D0*r1x2E*ZxZpE*VRR1(75,10)+WQz*VRR1(75,20)
      VRR0(76,21)=2.D0*V(421)+3.D0*r1x2E*VRR0(76,5)+QCx*VRR0(76,11)-3.D0*r1x2E*ZxZpE*VRR1(76,5)+WQx*VRR1(76,11)
      VRR0(76,22)=V(423)+2.D0*V(424)+V(426)+QCx*VRR0(76,12)+WQx*VRR1(76,12)
      VRR0(76,23)=V(167)+V(168)+PAz*VRR0(48,23)+WPz*VRR1(48,23)
      VRR0(76,24)=V(396)+V(423)+V(426)+QCy*VRR0(76,13)+WQy*VRR1(76,13)
      VRR0(76,25)=V(427)+3.D0*r1x2E*VRR0(76,7)+QCy*VRR0(76,14)-3.D0*r1x2E*ZxZpE*VRR1(76,7)+WQy*VRR1(76,14)
      VRR0(76,26)=V(429)+V(431)+V(433)+QCx*VRR0(76,15)+WQx*VRR1(76,15)
      VRR0(76,27)=V(174)+V(175)+V(251)+PAz*VRR0(48,27)+WPz*VRR1(48,27)
      VRR0(76,28)=V(176)+V(177)+V(258)+PAz*VRR0(48,28)+WPz*VRR1(48,28)
      VRR0(76,29)=V(408)+V(435)+V(437)+QCy*VRR0(76,17)+WQy*VRR1(76,17)
      VRR0(76,30)=V(182)+V(183)+2.D0*V(262)+PAz*VRR0(48,30)+WPz*VRR1(48,30)
      VRR0(76,31)=V(184)+V(185)+V(270)+PAz*VRR0(48,31)+WPz*VRR1(48,31)
      VRR0(76,32)=V(186)+V(187)+V(314)+PAz*VRR0(48,32)+WPz*VRR1(48,32)
      VRR0(76,33)=3.D0*V(284)+V(429)+V(433)+QCz*VRR0(76,18)+WQz*VRR1(76,18)
      VRR0(76,34)=3.D0*V(289)+V(435)+V(437)+QCz*VRR0(76,19)+WQz*VRR1(76,19)
      VRR0(76,35)=3.D0*r1x2E*VRR0(76,10)+QCz*VRR0(76,20)+3.D0*HfxZpE*VRR1(48,20)-3.D0*r1x2E*ZxZpE*VRR1(76,10)+WQz*VRR1(76,20)
      VRR0(77,21)=V(438)+3.D0*r1x2E*VRR0(77,5)+QCx*VRR0(77,11)-3.D0*r1x2E*ZxZpE*VRR1(77,5)+WQx*VRR1(77,11)
      VRR0(77,22)=V(440)+V(441)+V(443)+QCx*VRR0(77,12)+WQx*VRR1(77,12)
      VRR0(77,23)=V(121)+V(123)+PAz*VRR0(49,23)+WPz*VRR1(49,23)
      VRR0(77,24)=V(440)+V(443)+2.D0*V(444)+QCy*VRR0(77,13)+WQy*VRR1(77,13)
      VRR0(77,25)=2.D0*V(445)+3.D0*r1x2E*VRR0(77,7)+QCy*VRR0(77,14)-3.D0*r1x2E*ZxZpE*VRR1(77,7)+WQy*VRR1(77,14)
      VRR0(77,26)=V(447)+V(448)+V(450)+QCx*VRR0(77,15)+WQx*VRR1(77,15)
      VRR0(77,27)=V(131)+V(133)+V(296)+PAz*VRR0(49,27)+WPz*VRR1(49,27)
      VRR0(77,28)=V(137)+V(139)+V(301)+PAz*VRR0(49,28)+WPz*VRR1(49,28)
      VRR0(77,29)=V(452)+V(454)+V(456)+QCy*VRR0(77,17)+WQy*VRR1(77,17)
      VRR0(77,30)=V(146)+V(148)+V(306)+PAz*VRR0(49,30)+WPz*VRR1(49,30)
      VRR0(77,31)=V(152)+V(154)+V(311)+PAz*VRR0(49,31)+WPz*VRR1(49,31)
      VRR0(77,32)=V(157)+V(159)+2.D0*V(333)+PAz*VRR0(49,32)+WPz*VRR1(49,32)
      VRR0(77,33)=3.D0*V(317)+V(447)+V(450)+QCz*VRR0(77,18)+WQz*VRR1(77,18)
      VRR0(77,34)=3.D0*V(336)+V(452)+V(456)+QCz*VRR0(77,19)+WQz*VRR1(77,19)
      VRR0(77,35)=3.D0*r1x2E*VRR0(77,10)+QCz*VRR0(77,20)+3.D0*HfxZpE*VRR1(49,20)-3.D0*r1x2E*ZxZpE*VRR1(77,10)+WQz*VRR1(77,20)
      VRR0(78,21)=3.D0*r1x2E*VRR0(78,5)+QCx*VRR0(78,11)-3.D0*r1x2E*ZxZpE*VRR1(78,5)+WQx*VRR1(78,11)
      VRR0(78,22)=V(458)+V(460)+QCx*VRR0(78,12)+WQx*VRR1(78,12)
      VRR0(78,23)=2.D0*V(441)+2.D0*V(461)-2.D0*V(462)+PAy*VRR0(53,23)+WPy*VRR1(53,23)
      VRR0(78,24)=V(458)+V(460)+3.D0*V(463)+QCy*VRR0(78,13)+WQy*VRR1(78,13)
      VRR0(78,25)=3.D0*V(464)+3.D0*r1x2E*VRR0(78,7)+QCy*VRR0(78,14)-3.D0*r1x2E*ZxZpE*VRR1(78,7)+WQy*VRR1(78,14)
      VRR0(78,26)=V(466)+V(468)+QCx*VRR0(78,15)+WQx*VRR1(78,15)
      VRR0(78,27)=V(448)+2.D0*V(469)-2.D0*V(470)+PAy*VRR0(53,27)+WPy*VRR1(53,27)
      VRR0(78,28)=2.D0*V(471)-2.D0*V(472)+V(474)+PAy*VRR0(53,28)+WPy*VRR1(53,28)
      VRR0(78,29)=V(476)+3.D0*V(477)+V(479)+QCy*VRR0(78,17)+WQy*VRR1(78,17)
      VRR0(78,30)=2.D0*V(480)-2.D0*V(481)+PAy*VRR0(53,30)+WPy*VRR1(53,30)
      VRR0(78,31)=2.D0*V(482)-2.D0*V(483)+V(484)+PAy*VRR0(53,31)+WPy*VRR1(53,31)
      VRR0(78,32)=2.D0*V(485)-2.D0*V(486)+2.D0*V(487)+PAy*VRR0(53,32)+WPy*VRR1(53,32)
      VRR0(78,33)=3.D0*V(373)+V(466)+V(468)+QCz*VRR0(78,18)+WQz*VRR1(78,18)
      VRR0(78,34)=3.D0*V(378)+V(476)+V(479)+QCz*VRR0(78,19)+WQz*VRR1(78,19)
      VRR0(78,35)=3.D0*V(387)+3.D0*r1x2E*VRR0(78,10)+QCz*VRR0(78,20)-3.D0*r1x2E*ZxZpE*VRR1(78,10)+WQz*VRR1(78,20)
      VRR0(79,21)=2.D0*V(488)+3.D0*r1x2E*VRR0(79,5)+QCx*VRR0(79,11)-3.D0*r1x2E*ZxZpE*VRR1(79,5)+WQx*VRR1(79,11)
      VRR0(79,22)=V(196)+V(198)+PAz*VRR0(51,22)+WPz*VRR1(51,22)
      VRR0(79,23)=V(200)+V(202)+PAz*VRR0(51,23)+WPz*VRR1(51,23)
      VRR0(79,24)=V(205)+V(207)+PAz*VRR0(51,24)+WPz*VRR1(51,24)
      VRR0(79,25)=3.D0*r1x2E*VRR0(79,7)+QCy*VRR0(79,14)-3.D0*r1x2E*ZxZpE*VRR1(79,7)+WQy*VRR1(79,14)
      VRR0(79,26)=V(210)+V(212)+V(388)+PAz*VRR0(51,26)+WPz*VRR1(51,26)
      VRR0(79,27)=V(214)+V(216)+V(391)+PAz*VRR0(51,27)+WPz*VRR1(51,27)
      VRR0(79,28)=V(218)+V(220)+V(396)+PAz*VRR0(51,28)+WPz*VRR1(51,28)
      VRR0(79,29)=V(223)+V(225)+V(427)+PAz*VRR0(51,29)+WPz*VRR1(51,29)
      VRR0(79,30)=V(227)+V(229)+2.D0*V(399)+PAz*VRR0(51,30)+WPz*VRR1(51,30)
      VRR0(79,31)=V(232)+V(234)+V(405)+PAz*VRR0(51,31)+WPz*VRR1(51,31)
      VRR0(79,32)=V(237)+V(239)+2.D0*V(408)+PAz*VRR0(51,32)+WPz*VRR1(51,32)
      VRR0(79,33)=V(241)+V(243)+3.D0*V(415)+PAz*VRR0(51,33)+WPz*VRR1(51,33)
      VRR0(79,34)=V(246)+V(248)+3.D0*V(418)+PAz*VRR0(51,34)+WPz*VRR1(51,34)
      VRR0(79,35)=3.D0*r1x2E*VRR0(79,10)+QCz*VRR0(79,20)+4.D0*HfxZpE*VRR1(51,20)-3.D0*r1x2E*ZxZpE*VRR1(79,10)+WQz*VRR1(79,20)
      VRR0(80,21)=V(489)+3.D0*r1x2E*VRR0(80,5)+QCx*VRR0(80,11)-3.D0*r1x2E*ZxZpE*VRR1(80,5)+WQx*VRR1(80,11)
      VRR0(80,22)=3.D0*r1x2Z*VRR0(31,22)+PAz*VRR0(52,22)-3.D0*ExZpE*r1x2Z*VRR1(31,22)+WPz*VRR1(52,22)
      VRR0(80,23)=3.D0*V(254)-3.D0*V(256)+PAz*VRR0(52,23)+WPz*VRR1(52,23)
      VRR0(80,24)=3.D0*r1x2Z*VRR0(31,24)+PAz*VRR0(52,24)-3.D0*ExZpE*r1x2Z*VRR1(31,24)+WPz*VRR1(52,24)
      VRR0(80,25)=V(490)+3.D0*r1x2E*VRR0(80,7)+QCy*VRR0(80,14)-3.D0*r1x2E*ZxZpE*VRR1(80,7)+WQy*VRR1(80,14)
      VRR0(80,26)=V(421)+3.D0*r1x2Z*VRR0(31,26)+PAz*VRR0(52,26)-3.D0*ExZpE*r1x2Z*VRR1(31,26)+WPz*VRR1(52,26)
      VRR0(80,27)=3.D0*V(265)-3.D0*V(267)+V(424)+PAz*VRR0(52,27)+WPz*VRR1(52,27)
      VRR0(80,28)=3.D0*V(271)-3.D0*V(273)+V(444)+PAz*VRR0(52,28)+WPz*VRR1(52,28)
      VRR0(80,29)=V(445)+3.D0*r1x2Z*VRR0(31,29)+PAz*VRR0(52,29)-3.D0*ExZpE*r1x2Z*VRR1(31,29)+WPz*VRR1(52,29)
      VRR0(80,30)=3.D0*V(280)-3.D0*V(282)+V(431)+PAz*VRR0(52,30)+WPz*VRR1(52,30)
      VRR0(80,31)=3.D0*V(285)-3.D0*V(287)+PAz*VRR0(52,31)+2.D0*HfxZpE*VRR1(52,16)+WPz*VRR1(52,31)
      VRR0(80,32)=3.D0*V(290)-3.D0*V(292)+V(454)+PAz*VRR0(52,32)+WPz*VRR1(52,32)
      VRR0(80,33)=3.D0*r1x2Z*VRR0(31,33)+PAz*VRR0(52,33)-3.D0*ExZpE*r1x2Z*VRR1(31,33)+3.D0*HfxZpE*VRR1(52,18)+WPz*VRR1(52,33)
      VRR0(80,34)=3.D0*r1x2Z*VRR0(31,34)+PAz*VRR0(52,34)-3.D0*ExZpE*r1x2Z*VRR1(31,34)+3.D0*HfxZpE*VRR1(52,19)+WPz*VRR1(52,34)
      VRR0(80,35)=3.D0*r1x2E*VRR0(80,10)+QCz*VRR0(80,20)+4.D0*HfxZpE*VRR1(52,20)-3.D0*r1x2E*ZxZpE*VRR1(80,10)+WQz*VRR1(80,20)
      VRR0(81,21)=3.D0*r1x2E*VRR0(81,5)+QCx*VRR0(81,11)-3.D0*r1x2E*ZxZpE*VRR1(81,5)+WQx*VRR1(81,11)
      VRR0(81,22)=V(338)+V(340)+PAz*VRR0(53,22)+WPz*VRR1(53,22)
      VRR0(81,23)=V(342)+V(344)+PAz*VRR0(53,23)+WPz*VRR1(53,23)
      VRR0(81,24)=V(346)+V(348)+PAz*VRR0(53,24)+WPz*VRR1(53,24)
      VRR0(81,25)=2.D0*V(491)+3.D0*r1x2E*VRR0(81,7)+QCy*VRR0(81,14)-3.D0*r1x2E*ZxZpE*VRR1(81,7)+WQy*VRR1(81,14)
      VRR0(81,26)=V(350)+V(352)+V(438)+PAz*VRR0(53,26)+WPz*VRR1(53,26)
      VRR0(81,27)=V(354)+V(356)+V(441)+PAz*VRR0(53,27)+WPz*VRR1(53,27)
      VRR0(81,28)=V(358)+V(360)+V(463)+PAz*VRR0(53,28)+WPz*VRR1(53,28)
      VRR0(81,29)=V(362)+V(364)+V(464)+PAz*VRR0(53,29)+WPz*VRR1(53,29)
      VRR0(81,30)=V(366)+V(368)+2.D0*V(448)+PAz*VRR0(53,30)+WPz*VRR1(53,30)
      VRR0(81,31)=V(370)+V(372)+V(474)+PAz*VRR0(53,31)+WPz*VRR1(53,31)
      VRR0(81,32)=V(375)+V(377)+2.D0*V(477)+PAz*VRR0(53,32)+WPz*VRR1(53,32)
      VRR0(81,33)=V(380)+V(382)+3.D0*V(484)+PAz*VRR0(53,33)+WPz*VRR1(53,33)
      VRR0(81,34)=V(384)+V(386)+3.D0*V(487)+PAz*VRR0(53,34)+WPz*VRR1(53,34)
      VRR0(81,35)=3.D0*r1x2E*VRR0(81,10)+QCz*VRR0(81,20)+4.D0*HfxZpE*VRR1(53,20)-3.D0*r1x2E*ZxZpE*VRR1(81,10)+WQz*VRR1(81,20)
      VRR0(82,21)=4.D0*r1x2Z*VRR0(33,21)+PAz*VRR0(54,21)-4.D0*ExZpE*r1x2Z*VRR1(33,21)+WPz*VRR1(54,21)
      VRR0(82,22)=4.D0*r1x2Z*VRR0(33,22)+PAz*VRR0(54,22)-4.D0*ExZpE*r1x2Z*VRR1(33,22)+WPz*VRR1(54,22)
      VRR0(82,23)=4.D0*V(394)-4.D0*V(395)+PAz*VRR0(54,23)+WPz*VRR1(54,23)
      VRR0(82,24)=4.D0*r1x2Z*VRR0(33,24)+PAz*VRR0(54,24)-4.D0*ExZpE*r1x2Z*VRR1(33,24)+WPz*VRR1(54,24)
      VRR0(82,25)=4.D0*r1x2Z*VRR0(33,25)+PAz*VRR0(54,25)-4.D0*ExZpE*r1x2Z*VRR1(33,25)+WPz*VRR1(54,25)
      VRR0(82,26)=V(488)+4.D0*r1x2Z*VRR0(33,26)+PAz*VRR0(54,26)-4.D0*ExZpE*r1x2Z*VRR1(33,26)+WPz*VRR1(54,26)
      VRR0(82,27)=4.D0*V(402)-4.D0*V(403)+PAz*VRR0(54,27)+HfxZpE*VRR1(54,12)+WPz*VRR1(54,27)
      VRR0(82,28)=4.D0*V(406)-4.D0*V(407)+PAz*VRR0(54,28)+HfxZpE*VRR1(54,13)+WPz*VRR1(54,28)
      VRR0(82,29)=V(490)+4.D0*r1x2Z*VRR0(33,29)+PAz*VRR0(54,29)-4.D0*ExZpE*r1x2Z*VRR1(33,29)+WPz*VRR1(54,29)
      VRR0(82,30)=4.D0*V(413)-4.D0*V(414)+PAz*VRR0(54,30)+2.D0*HfxZpE*VRR1(54,15)+WPz*VRR1(54,30)
      VRR0(82,31)=4.D0*V(416)-4.D0*V(417)+PAz*VRR0(54,31)+2.D0*HfxZpE*VRR1(54,16)+WPz*VRR1(54,31)
      VRR0(82,32)=4.D0*V(419)-4.D0*V(420)+PAz*VRR0(54,32)+2.D0*HfxZpE*VRR1(54,17)+WPz*VRR1(54,32)
      VRR0(82,33)=4.D0*r1x2Z*VRR0(33,33)+PAz*VRR0(54,33)-4.D0*ExZpE*r1x2Z*VRR1(33,33)+3.D0*HfxZpE*VRR1(54,18)+WPz*VRR1(54,33)
      VRR0(82,34)=4.D0*r1x2Z*VRR0(33,34)+PAz*VRR0(54,34)-4.D0*ExZpE*r1x2Z*VRR1(33,34)+3.D0*HfxZpE*VRR1(54,19)+WPz*VRR1(54,34)
      VRR0(82,35)=4.D0*r1x2Z*VRR0(33,35)+PAz*VRR0(54,35)-4.D0*ExZpE*r1x2Z*VRR1(33,35)+4.D0*HfxZpE*VRR1(54,20)+WPz*VRR1(54,35)
      VRR0(83,21)=4.D0*r1x2Z*VRR0(34,21)+PAz*VRR0(55,21)-4.D0*ExZpE*r1x2Z*VRR1(34,21)+WPz*VRR1(55,21)
      VRR0(83,22)=4.D0*r1x2Z*VRR0(34,22)+PAz*VRR0(55,22)-4.D0*ExZpE*r1x2Z*VRR1(34,22)+WPz*VRR1(55,22)
      VRR0(83,23)=4.D0*V(461)-4.D0*V(462)+PAz*VRR0(55,23)+WPz*VRR1(55,23)
      VRR0(83,24)=4.D0*r1x2Z*VRR0(34,24)+PAz*VRR0(55,24)-4.D0*ExZpE*r1x2Z*VRR1(34,24)+WPz*VRR1(55,24)
      VRR0(83,25)=4.D0*r1x2Z*VRR0(34,25)+PAz*VRR0(55,25)-4.D0*ExZpE*r1x2Z*VRR1(34,25)+WPz*VRR1(55,25)
      VRR0(83,26)=V(489)+4.D0*r1x2Z*VRR0(34,26)+PAz*VRR0(55,26)-4.D0*ExZpE*r1x2Z*VRR1(34,26)+WPz*VRR1(55,26)
      VRR0(83,27)=4.D0*V(469)-4.D0*V(470)+PAz*VRR0(55,27)+HfxZpE*VRR1(55,12)+WPz*VRR1(55,27)
      VRR0(83,28)=4.D0*V(471)-4.D0*V(472)+PAz*VRR0(55,28)+HfxZpE*VRR1(55,13)+WPz*VRR1(55,28)
      VRR0(83,29)=V(491)+4.D0*r1x2Z*VRR0(34,29)+PAz*VRR0(55,29)-4.D0*ExZpE*r1x2Z*VRR1(34,29)+WPz*VRR1(55,29)
      VRR0(83,30)=4.D0*V(480)-4.D0*V(481)+PAz*VRR0(55,30)+2.D0*HfxZpE*VRR1(55,15)+WPz*VRR1(55,30)
      VRR0(83,31)=4.D0*V(482)-4.D0*V(483)+PAz*VRR0(55,31)+2.D0*HfxZpE*VRR1(55,16)+WPz*VRR1(55,31)
      VRR0(83,32)=4.D0*V(485)-4.D0*V(486)+PAz*VRR0(55,32)+2.D0*HfxZpE*VRR1(55,17)+WPz*VRR1(55,32)
      VRR0(83,33)=4.D0*r1x2Z*VRR0(34,33)+PAz*VRR0(55,33)-4.D0*ExZpE*r1x2Z*VRR1(34,33)+3.D0*HfxZpE*VRR1(55,18)+WPz*VRR1(55,33)
      VRR0(83,34)=4.D0*r1x2Z*VRR0(34,34)+PAz*VRR0(55,34)-4.D0*ExZpE*r1x2Z*VRR1(34,34)+3.D0*HfxZpE*VRR1(55,19)+WPz*VRR1(55,34)
      VRR0(83,35)=4.D0*r1x2Z*VRR0(34,35)+PAz*VRR0(55,35)-4.D0*ExZpE*r1x2Z*VRR1(34,35)+4.D0*HfxZpE*VRR1(55,20)+WPz*VRR1(55,35)
      VRR0(84,21)=5.D0*r1x2Z*VRR0(35,21)+PAz*VRR0(56,21)-5.D0*ExZpE*r1x2Z*VRR1(35,21)+WPz*VRR1(56,21)
      VRR0(84,22)=5.D0*r1x2Z*VRR0(35,22)+PAz*VRR0(56,22)-5.D0*ExZpE*r1x2Z*VRR1(35,22)+WPz*VRR1(56,22)
      VRR0(84,23)=5.D0*r1x2Z*VRR0(35,23)+PAz*VRR0(56,23)-5.D0*ExZpE*r1x2Z*VRR1(35,23)+WPz*VRR1(56,23)
      VRR0(84,24)=5.D0*r1x2Z*VRR0(35,24)+PAz*VRR0(56,24)-5.D0*ExZpE*r1x2Z*VRR1(35,24)+WPz*VRR1(56,24)
      VRR0(84,25)=5.D0*r1x2Z*VRR0(35,25)+PAz*VRR0(56,25)-5.D0*ExZpE*r1x2Z*VRR1(35,25)+WPz*VRR1(56,25)
      VRR0(84,26)=5.D0*r1x2Z*VRR0(35,26)+PAz*VRR0(56,26)-5.D0*ExZpE*r1x2Z*VRR1(35,26)+HfxZpE*VRR1(56,11)+WPz*VRR1(56,26)
      VRR0(84,27)=5.D0*r1x2Z*VRR0(35,27)+PAz*VRR0(56,27)-5.D0*ExZpE*r1x2Z*VRR1(35,27)+HfxZpE*VRR1(56,12)+WPz*VRR1(56,27)
      VRR0(84,28)=5.D0*r1x2Z*VRR0(35,28)+PAz*VRR0(56,28)-5.D0*ExZpE*r1x2Z*VRR1(35,28)+HfxZpE*VRR1(56,13)+WPz*VRR1(56,28)
      VRR0(84,29)=5.D0*r1x2Z*VRR0(35,29)+PAz*VRR0(56,29)-5.D0*ExZpE*r1x2Z*VRR1(35,29)+HfxZpE*VRR1(56,14)+WPz*VRR1(56,29)
      VRR0(84,30)=5.D0*r1x2Z*VRR0(35,30)+PAz*VRR0(56,30)-5.D0*ExZpE*r1x2Z*VRR1(35,30)+2.D0*HfxZpE*VRR1(56,15)+WPz*VRR1(56,30)
      VRR0(84,31)=5.D0*r1x2Z*VRR0(35,31)+PAz*VRR0(56,31)-5.D0*ExZpE*r1x2Z*VRR1(35,31)+2.D0*HfxZpE*VRR1(56,16)+WPz*VRR1(56,31)
      VRR0(84,32)=5.D0*r1x2Z*VRR0(35,32)+PAz*VRR0(56,32)-5.D0*ExZpE*r1x2Z*VRR1(35,32)+2.D0*HfxZpE*VRR1(56,17)+WPz*VRR1(56,32)
      VRR0(84,33)=5.D0*r1x2Z*VRR0(35,33)+PAz*VRR0(56,33)-5.D0*ExZpE*r1x2Z*VRR1(35,33)+3.D0*HfxZpE*VRR1(56,18)+WPz*VRR1(56,33)
      VRR0(84,34)=5.D0*r1x2Z*VRR0(35,34)+PAz*VRR0(56,34)-5.D0*ExZpE*r1x2Z*VRR1(35,34)+3.D0*HfxZpE*VRR1(56,19)+WPz*VRR1(56,34)
      VRR0(84,35)=5.D0*r1x2Z*VRR0(35,35)+PAz*VRR0(56,35)-5.D0*ExZpE*r1x2Z*VRR1(35,35)+4.D0*HfxZpE*VRR1(56,20)+WPz*VRR1(56,35)
END SUBROUTINE VRRi0g0
SUBROUTINE MVRRi0g0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(57,21)=PAx*VS0(36,21)+WPx*VS1(36,21)+r1x2Z*VR1(36,21)&
   +5D0*r1x2Z*(VS0(21,21)-ExZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(36,11)
VS0(57,22)=PAx*VS0(36,22)+WPx*VS1(36,22)+r1x2Z*VR1(36,22)&
   +5D0*r1x2Z*(VS0(21,22)-ExZpE*VS1(21,22))&
   +3D0*HfxZpE*VS1(36,12)
VS0(57,23)=PAx*VS0(36,23)+WPx*VS1(36,23)+r1x2Z*VR1(36,23)&
   +5D0*r1x2Z*(VS0(21,23)-ExZpE*VS1(21,23))&
   +2D0*HfxZpE*VS1(36,13)
VS0(57,24)=PAx*VS0(36,24)+WPx*VS1(36,24)+r1x2Z*VR1(36,24)&
   +5D0*r1x2Z*(VS0(21,24)-ExZpE*VS1(21,24))&
   +HfxZpE*VS1(36,14)
VS0(57,25)=PAx*VS0(36,25)+WPx*VS1(36,25)+r1x2Z*VR1(36,25)&
   +5D0*r1x2Z*(VS0(21,25)-ExZpE*VS1(21,25))
VS0(57,26)=PAx*VS0(36,26)+WPx*VS1(36,26)+r1x2Z*VR1(36,26)&
   +5D0*r1x2Z*(VS0(21,26)-ExZpE*VS1(21,26))&
   +3D0*HfxZpE*VS1(36,15)
VS0(57,27)=PAx*VS0(36,27)+WPx*VS1(36,27)+r1x2Z*VR1(36,27)&
   +5D0*r1x2Z*(VS0(21,27)-ExZpE*VS1(21,27))&
   +2D0*HfxZpE*VS1(36,16)
VS0(57,28)=PAx*VS0(36,28)+WPx*VS1(36,28)+r1x2Z*VR1(36,28)&
   +5D0*r1x2Z*(VS0(21,28)-ExZpE*VS1(21,28))&
   +HfxZpE*VS1(36,17)
VS0(57,29)=PAx*VS0(36,29)+WPx*VS1(36,29)+r1x2Z*VR1(36,29)&
   +5D0*r1x2Z*(VS0(21,29)-ExZpE*VS1(21,29))
VS0(57,30)=PAx*VS0(36,30)+WPx*VS1(36,30)+r1x2Z*VR1(36,30)&
   +5D0*r1x2Z*(VS0(21,30)-ExZpE*VS1(21,30))&
   +2D0*HfxZpE*VS1(36,18)
VS0(57,31)=PAx*VS0(36,31)+WPx*VS1(36,31)+r1x2Z*VR1(36,31)&
   +5D0*r1x2Z*(VS0(21,31)-ExZpE*VS1(21,31))&
   +HfxZpE*VS1(36,19)
VS0(57,32)=PAx*VS0(36,32)+WPx*VS1(36,32)+r1x2Z*VR1(36,32)&
   +5D0*r1x2Z*(VS0(21,32)-ExZpE*VS1(21,32))
VS0(57,33)=PAx*VS0(36,33)+WPx*VS1(36,33)+r1x2Z*VR1(36,33)&
   +5D0*r1x2Z*(VS0(21,33)-ExZpE*VS1(21,33))&
   +HfxZpE*VS1(36,20)
VS0(57,34)=PAx*VS0(36,34)+WPx*VS1(36,34)+r1x2Z*VR1(36,34)&
   +5D0*r1x2Z*(VS0(21,34)-ExZpE*VS1(21,34))
VS0(57,35)=PAx*VS0(36,35)+WPx*VS1(36,35)+r1x2Z*VR1(36,35)&
   +5D0*r1x2Z*(VS0(21,35)-ExZpE*VS1(21,35))
VS0(58,21)=PAx*VS0(37,21)+WPx*VS1(37,21)+r1x2Z*VR1(37,21)&
   +4D0*r1x2Z*(VS0(22,21)-ExZpE*VS1(22,21))&
   +4D0*HfxZpE*VS1(37,11)
VS0(58,22)=PAx*VS0(37,22)+WPx*VS1(37,22)+r1x2Z*VR1(37,22)&
   +4D0*r1x2Z*(VS0(22,22)-ExZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(37,12)
VS0(58,23)=PAx*VS0(37,23)+WPx*VS1(37,23)+r1x2Z*VR1(37,23)&
   +4D0*r1x2Z*(VS0(22,23)-ExZpE*VS1(22,23))&
   +2D0*HfxZpE*VS1(37,13)
VS0(58,24)=PAx*VS0(37,24)+WPx*VS1(37,24)+r1x2Z*VR1(37,24)&
   +4D0*r1x2Z*(VS0(22,24)-ExZpE*VS1(22,24))&
   +HfxZpE*VS1(37,14)
VS0(58,25)=PAx*VS0(37,25)+WPx*VS1(37,25)+r1x2Z*VR1(37,25)&
   +4D0*r1x2Z*(VS0(22,25)-ExZpE*VS1(22,25))
VS0(58,26)=PAx*VS0(37,26)+WPx*VS1(37,26)+r1x2Z*VR1(37,26)&
   +4D0*r1x2Z*(VS0(22,26)-ExZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(37,15)
VS0(58,27)=PAx*VS0(37,27)+WPx*VS1(37,27)+r1x2Z*VR1(37,27)&
   +4D0*r1x2Z*(VS0(22,27)-ExZpE*VS1(22,27))&
   +2D0*HfxZpE*VS1(37,16)
VS0(58,28)=PAx*VS0(37,28)+WPx*VS1(37,28)+r1x2Z*VR1(37,28)&
   +4D0*r1x2Z*(VS0(22,28)-ExZpE*VS1(22,28))&
   +HfxZpE*VS1(37,17)
VS0(58,29)=PAx*VS0(37,29)+WPx*VS1(37,29)+r1x2Z*VR1(37,29)&
   +4D0*r1x2Z*(VS0(22,29)-ExZpE*VS1(22,29))
VS0(58,30)=PAx*VS0(37,30)+WPx*VS1(37,30)+r1x2Z*VR1(37,30)&
   +4D0*r1x2Z*(VS0(22,30)-ExZpE*VS1(22,30))&
   +2D0*HfxZpE*VS1(37,18)
VS0(58,31)=PAx*VS0(37,31)+WPx*VS1(37,31)+r1x2Z*VR1(37,31)&
   +4D0*r1x2Z*(VS0(22,31)-ExZpE*VS1(22,31))&
   +HfxZpE*VS1(37,19)
VS0(58,32)=PAx*VS0(37,32)+WPx*VS1(37,32)+r1x2Z*VR1(37,32)&
   +4D0*r1x2Z*(VS0(22,32)-ExZpE*VS1(22,32))
VS0(58,33)=PAx*VS0(37,33)+WPx*VS1(37,33)+r1x2Z*VR1(37,33)&
   +4D0*r1x2Z*(VS0(22,33)-ExZpE*VS1(22,33))&
   +HfxZpE*VS1(37,20)
VS0(58,34)=PAx*VS0(37,34)+WPx*VS1(37,34)+r1x2Z*VR1(37,34)&
   +4D0*r1x2Z*(VS0(22,34)-ExZpE*VS1(22,34))
VS0(58,35)=PAx*VS0(37,35)+WPx*VS1(37,35)+r1x2Z*VR1(37,35)&
   +4D0*r1x2Z*(VS0(22,35)-ExZpE*VS1(22,35))
VS0(59,21)=PAx*VS0(38,21)+WPx*VS1(38,21)+r1x2Z*VR1(38,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))&
   +4D0*HfxZpE*VS1(38,11)
VS0(59,22)=PAx*VS0(38,22)+WPx*VS1(38,22)+r1x2Z*VR1(38,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +3D0*HfxZpE*VS1(38,12)
VS0(59,23)=PAx*VS0(38,23)+WPx*VS1(38,23)+r1x2Z*VR1(38,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(38,13)
VS0(59,24)=PAx*VS0(38,24)+WPx*VS1(38,24)+r1x2Z*VR1(38,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +HfxZpE*VS1(38,14)
VS0(59,25)=PAx*VS0(38,25)+WPx*VS1(38,25)+r1x2Z*VR1(38,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))
VS0(59,26)=PAx*VS0(38,26)+WPx*VS1(38,26)+r1x2Z*VR1(38,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))&
   +3D0*HfxZpE*VS1(38,15)
VS0(59,27)=PAx*VS0(38,27)+WPx*VS1(38,27)+r1x2Z*VR1(38,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(38,16)
VS0(59,28)=PAx*VS0(38,28)+WPx*VS1(38,28)+r1x2Z*VR1(38,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +HfxZpE*VS1(38,17)
VS0(59,29)=PAx*VS0(38,29)+WPx*VS1(38,29)+r1x2Z*VR1(38,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))
VS0(59,30)=PAx*VS0(38,30)+WPx*VS1(38,30)+r1x2Z*VR1(38,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(38,18)
VS0(59,31)=PAx*VS0(38,31)+WPx*VS1(38,31)+r1x2Z*VR1(38,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(38,19)
VS0(59,32)=PAx*VS0(38,32)+WPx*VS1(38,32)+r1x2Z*VR1(38,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))
VS0(59,33)=PAx*VS0(38,33)+WPx*VS1(38,33)+r1x2Z*VR1(38,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))&
   +HfxZpE*VS1(38,20)
VS0(59,34)=PAx*VS0(38,34)+WPx*VS1(38,34)+r1x2Z*VR1(38,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))
VS0(59,35)=PAx*VS0(38,35)+WPx*VS1(38,35)+r1x2Z*VR1(38,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(60,21)=PAx*VS0(39,21)+WPx*VS1(39,21)+r1x2Z*VR1(39,21)&
   +2D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))&
   +4D0*HfxZpE*VS1(39,11)
VS0(60,22)=PAx*VS0(39,22)+WPx*VS1(39,22)+r1x2Z*VR1(39,22)&
   +2D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +3D0*HfxZpE*VS1(39,12)
VS0(60,23)=PAx*VS0(39,23)+WPx*VS1(39,23)+r1x2Z*VR1(39,23)&
   +2D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(39,13)
VS0(60,24)=PAx*VS0(39,24)+WPx*VS1(39,24)+r1x2Z*VR1(39,24)&
   +2D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +HfxZpE*VS1(39,14)
VS0(60,25)=PAx*VS0(39,25)+WPx*VS1(39,25)+r1x2Z*VR1(39,25)&
   +2D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))
VS0(60,26)=PAx*VS0(39,26)+WPx*VS1(39,26)+r1x2Z*VR1(39,26)&
   +2D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))&
   +3D0*HfxZpE*VS1(39,15)
VS0(60,27)=PAx*VS0(39,27)+WPx*VS1(39,27)+r1x2Z*VR1(39,27)&
   +2D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +2D0*HfxZpE*VS1(39,16)
VS0(60,28)=PAx*VS0(39,28)+WPx*VS1(39,28)+r1x2Z*VR1(39,28)&
   +2D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +HfxZpE*VS1(39,17)
VS0(60,29)=PAx*VS0(39,29)+WPx*VS1(39,29)+r1x2Z*VR1(39,29)&
   +2D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))
VS0(60,30)=PAx*VS0(39,30)+WPx*VS1(39,30)+r1x2Z*VR1(39,30)&
   +2D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))&
   +2D0*HfxZpE*VS1(39,18)
VS0(60,31)=PAx*VS0(39,31)+WPx*VS1(39,31)+r1x2Z*VR1(39,31)&
   +2D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(39,19)
VS0(60,32)=PAx*VS0(39,32)+WPx*VS1(39,32)+r1x2Z*VR1(39,32)&
   +2D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))
VS0(60,33)=PAx*VS0(39,33)+WPx*VS1(39,33)+r1x2Z*VR1(39,33)&
   +2D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))&
   +HfxZpE*VS1(39,20)
VS0(60,34)=PAx*VS0(39,34)+WPx*VS1(39,34)+r1x2Z*VR1(39,34)&
   +2D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))
VS0(60,35)=PAx*VS0(39,35)+WPx*VS1(39,35)+r1x2Z*VR1(39,35)&
   +2D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(61,21)=PAy*VS0(39,21)+WPy*VS1(39,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))
VS0(61,22)=PAy*VS0(39,22)+WPy*VS1(39,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +HfxZpE*VS1(39,11)
VS0(61,23)=PAy*VS0(39,23)+WPy*VS1(39,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(39,12)
VS0(61,24)=PAy*VS0(39,24)+WPy*VS1(39,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +3D0*HfxZpE*VS1(39,13)
VS0(61,25)=PAy*VS0(39,25)+WPy*VS1(39,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))&
   +4D0*HfxZpE*VS1(39,14)
VS0(61,26)=PAy*VS0(39,26)+WPy*VS1(39,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))
VS0(61,27)=PAy*VS0(39,27)+WPy*VS1(39,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +HfxZpE*VS1(39,15)
VS0(61,28)=PAy*VS0(39,28)+WPy*VS1(39,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(39,16)
VS0(61,29)=PAy*VS0(39,29)+WPy*VS1(39,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))&
   +3D0*HfxZpE*VS1(39,17)
VS0(61,30)=PAy*VS0(39,30)+WPy*VS1(39,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))
VS0(61,31)=PAy*VS0(39,31)+WPy*VS1(39,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(39,18)
VS0(61,32)=PAy*VS0(39,32)+WPy*VS1(39,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(39,19)
VS0(61,33)=PAy*VS0(39,33)+WPy*VS1(39,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))
VS0(61,34)=PAy*VS0(39,34)+WPy*VS1(39,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))&
   +HfxZpE*VS1(39,20)
VS0(61,35)=PAy*VS0(39,35)+WPy*VS1(39,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(62,21)=PAy*VS0(40,21)+WPy*VS1(40,21)&
   +4D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))
VS0(62,22)=PAy*VS0(40,22)+WPy*VS1(40,22)&
   +4D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +HfxZpE*VS1(40,11)
VS0(62,23)=PAy*VS0(40,23)+WPy*VS1(40,23)&
   +4D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(40,12)
VS0(62,24)=PAy*VS0(40,24)+WPy*VS1(40,24)&
   +4D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(40,13)
VS0(62,25)=PAy*VS0(40,25)+WPy*VS1(40,25)&
   +4D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))&
   +4D0*HfxZpE*VS1(40,14)
VS0(62,26)=PAy*VS0(40,26)+WPy*VS1(40,26)&
   +4D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))
VS0(62,27)=PAy*VS0(40,27)+WPy*VS1(40,27)&
   +4D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +HfxZpE*VS1(40,15)
VS0(62,28)=PAy*VS0(40,28)+WPy*VS1(40,28)&
   +4D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +2D0*HfxZpE*VS1(40,16)
VS0(62,29)=PAy*VS0(40,29)+WPy*VS1(40,29)&
   +4D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(40,17)
VS0(62,30)=PAy*VS0(40,30)+WPy*VS1(40,30)&
   +4D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))
VS0(62,31)=PAy*VS0(40,31)+WPy*VS1(40,31)&
   +4D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(40,18)
VS0(62,32)=PAy*VS0(40,32)+WPy*VS1(40,32)&
   +4D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))&
   +2D0*HfxZpE*VS1(40,19)
VS0(62,33)=PAy*VS0(40,33)+WPy*VS1(40,33)&
   +4D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))
VS0(62,34)=PAy*VS0(40,34)+WPy*VS1(40,34)&
   +4D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))&
   +HfxZpE*VS1(40,20)
VS0(62,35)=PAy*VS0(40,35)+WPy*VS1(40,35)&
   +4D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(63,21)=PAy*VS0(41,21)+WPy*VS1(41,21)&
   +5D0*r1x2Z*(VS0(25,21)-ExZpE*VS1(25,21))
VS0(63,22)=PAy*VS0(41,22)+WPy*VS1(41,22)&
   +5D0*r1x2Z*(VS0(25,22)-ExZpE*VS1(25,22))&
   +HfxZpE*VS1(41,11)
VS0(63,23)=PAy*VS0(41,23)+WPy*VS1(41,23)&
   +5D0*r1x2Z*(VS0(25,23)-ExZpE*VS1(25,23))&
   +2D0*HfxZpE*VS1(41,12)
VS0(63,24)=PAy*VS0(41,24)+WPy*VS1(41,24)&
   +5D0*r1x2Z*(VS0(25,24)-ExZpE*VS1(25,24))&
   +3D0*HfxZpE*VS1(41,13)
VS0(63,25)=PAy*VS0(41,25)+WPy*VS1(41,25)&
   +5D0*r1x2Z*(VS0(25,25)-ExZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(41,14)
VS0(63,26)=PAy*VS0(41,26)+WPy*VS1(41,26)&
   +5D0*r1x2Z*(VS0(25,26)-ExZpE*VS1(25,26))
VS0(63,27)=PAy*VS0(41,27)+WPy*VS1(41,27)&
   +5D0*r1x2Z*(VS0(25,27)-ExZpE*VS1(25,27))&
   +HfxZpE*VS1(41,15)
VS0(63,28)=PAy*VS0(41,28)+WPy*VS1(41,28)&
   +5D0*r1x2Z*(VS0(25,28)-ExZpE*VS1(25,28))&
   +2D0*HfxZpE*VS1(41,16)
VS0(63,29)=PAy*VS0(41,29)+WPy*VS1(41,29)&
   +5D0*r1x2Z*(VS0(25,29)-ExZpE*VS1(25,29))&
   +3D0*HfxZpE*VS1(41,17)
VS0(63,30)=PAy*VS0(41,30)+WPy*VS1(41,30)&
   +5D0*r1x2Z*(VS0(25,30)-ExZpE*VS1(25,30))
VS0(63,31)=PAy*VS0(41,31)+WPy*VS1(41,31)&
   +5D0*r1x2Z*(VS0(25,31)-ExZpE*VS1(25,31))&
   +HfxZpE*VS1(41,18)
VS0(63,32)=PAy*VS0(41,32)+WPy*VS1(41,32)&
   +5D0*r1x2Z*(VS0(25,32)-ExZpE*VS1(25,32))&
   +2D0*HfxZpE*VS1(41,19)
VS0(63,33)=PAy*VS0(41,33)+WPy*VS1(41,33)&
   +5D0*r1x2Z*(VS0(25,33)-ExZpE*VS1(25,33))
VS0(63,34)=PAy*VS0(41,34)+WPy*VS1(41,34)&
   +5D0*r1x2Z*(VS0(25,34)-ExZpE*VS1(25,34))&
   +HfxZpE*VS1(41,20)
VS0(63,35)=PAy*VS0(41,35)+WPy*VS1(41,35)&
   +5D0*r1x2Z*(VS0(25,35)-ExZpE*VS1(25,35))
VS0(64,21)=PAx*VS0(42,21)+WPx*VS1(42,21)+r1x2Z*VR1(42,21)&
   +4D0*r1x2Z*(VS0(26,21)-ExZpE*VS1(26,21))&
   +4D0*HfxZpE*VS1(42,11)
VS0(64,22)=PAx*VS0(42,22)+WPx*VS1(42,22)+r1x2Z*VR1(42,22)&
   +4D0*r1x2Z*(VS0(26,22)-ExZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(42,12)
VS0(64,23)=PAx*VS0(42,23)+WPx*VS1(42,23)+r1x2Z*VR1(42,23)&
   +4D0*r1x2Z*(VS0(26,23)-ExZpE*VS1(26,23))&
   +2D0*HfxZpE*VS1(42,13)
VS0(64,24)=PAx*VS0(42,24)+WPx*VS1(42,24)+r1x2Z*VR1(42,24)&
   +4D0*r1x2Z*(VS0(26,24)-ExZpE*VS1(26,24))&
   +HfxZpE*VS1(42,14)
VS0(64,25)=PAx*VS0(42,25)+WPx*VS1(42,25)+r1x2Z*VR1(42,25)&
   +4D0*r1x2Z*(VS0(26,25)-ExZpE*VS1(26,25))
VS0(64,26)=PAx*VS0(42,26)+WPx*VS1(42,26)+r1x2Z*VR1(42,26)&
   +4D0*r1x2Z*(VS0(26,26)-ExZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(42,15)
VS0(64,27)=PAx*VS0(42,27)+WPx*VS1(42,27)+r1x2Z*VR1(42,27)&
   +4D0*r1x2Z*(VS0(26,27)-ExZpE*VS1(26,27))&
   +2D0*HfxZpE*VS1(42,16)
VS0(64,28)=PAx*VS0(42,28)+WPx*VS1(42,28)+r1x2Z*VR1(42,28)&
   +4D0*r1x2Z*(VS0(26,28)-ExZpE*VS1(26,28))&
   +HfxZpE*VS1(42,17)
VS0(64,29)=PAx*VS0(42,29)+WPx*VS1(42,29)+r1x2Z*VR1(42,29)&
   +4D0*r1x2Z*(VS0(26,29)-ExZpE*VS1(26,29))
VS0(64,30)=PAx*VS0(42,30)+WPx*VS1(42,30)+r1x2Z*VR1(42,30)&
   +4D0*r1x2Z*(VS0(26,30)-ExZpE*VS1(26,30))&
   +2D0*HfxZpE*VS1(42,18)
VS0(64,31)=PAx*VS0(42,31)+WPx*VS1(42,31)+r1x2Z*VR1(42,31)&
   +4D0*r1x2Z*(VS0(26,31)-ExZpE*VS1(26,31))&
   +HfxZpE*VS1(42,19)
VS0(64,32)=PAx*VS0(42,32)+WPx*VS1(42,32)+r1x2Z*VR1(42,32)&
   +4D0*r1x2Z*(VS0(26,32)-ExZpE*VS1(26,32))
VS0(64,33)=PAx*VS0(42,33)+WPx*VS1(42,33)+r1x2Z*VR1(42,33)&
   +4D0*r1x2Z*(VS0(26,33)-ExZpE*VS1(26,33))&
   +HfxZpE*VS1(42,20)
VS0(64,34)=PAx*VS0(42,34)+WPx*VS1(42,34)+r1x2Z*VR1(42,34)&
   +4D0*r1x2Z*(VS0(26,34)-ExZpE*VS1(26,34))
VS0(64,35)=PAx*VS0(42,35)+WPx*VS1(42,35)+r1x2Z*VR1(42,35)&
   +4D0*r1x2Z*(VS0(26,35)-ExZpE*VS1(26,35))
VS0(65,21)=PAx*VS0(43,21)+WPx*VS1(43,21)+r1x2Z*VR1(43,21)&
   +3D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))&
   +4D0*HfxZpE*VS1(43,11)
VS0(65,22)=PAx*VS0(43,22)+WPx*VS1(43,22)+r1x2Z*VR1(43,22)&
   +3D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +3D0*HfxZpE*VS1(43,12)
VS0(65,23)=PAx*VS0(43,23)+WPx*VS1(43,23)+r1x2Z*VR1(43,23)&
   +3D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(43,13)
VS0(65,24)=PAx*VS0(43,24)+WPx*VS1(43,24)+r1x2Z*VR1(43,24)&
   +3D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +HfxZpE*VS1(43,14)
VS0(65,25)=PAx*VS0(43,25)+WPx*VS1(43,25)+r1x2Z*VR1(43,25)&
   +3D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(65,26)=PAx*VS0(43,26)+WPx*VS1(43,26)+r1x2Z*VR1(43,26)&
   +3D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +3D0*HfxZpE*VS1(43,15)
VS0(65,27)=PAx*VS0(43,27)+WPx*VS1(43,27)+r1x2Z*VR1(43,27)&
   +3D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(43,16)
VS0(65,28)=PAx*VS0(43,28)+WPx*VS1(43,28)+r1x2Z*VR1(43,28)&
   +3D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(43,17)
VS0(65,29)=PAx*VS0(43,29)+WPx*VS1(43,29)+r1x2Z*VR1(43,29)&
   +3D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))
VS0(65,30)=PAx*VS0(43,30)+WPx*VS1(43,30)+r1x2Z*VR1(43,30)&
   +3D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(43,18)
VS0(65,31)=PAx*VS0(43,31)+WPx*VS1(43,31)+r1x2Z*VR1(43,31)&
   +3D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(43,19)
VS0(65,32)=PAx*VS0(43,32)+WPx*VS1(43,32)+r1x2Z*VR1(43,32)&
   +3D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))
VS0(65,33)=PAx*VS0(43,33)+WPx*VS1(43,33)+r1x2Z*VR1(43,33)&
   +3D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +HfxZpE*VS1(43,20)
VS0(65,34)=PAx*VS0(43,34)+WPx*VS1(43,34)+r1x2Z*VR1(43,34)&
   +3D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))
VS0(65,35)=PAx*VS0(43,35)+WPx*VS1(43,35)+r1x2Z*VR1(43,35)&
   +3D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(66,21)=PAx*VS0(44,21)+WPx*VS1(44,21)+r1x2Z*VR1(44,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))&
   +4D0*HfxZpE*VS1(44,11)
VS0(66,22)=PAx*VS0(44,22)+WPx*VS1(44,22)+r1x2Z*VR1(44,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +3D0*HfxZpE*VS1(44,12)
VS0(66,23)=PAx*VS0(44,23)+WPx*VS1(44,23)+r1x2Z*VR1(44,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(44,13)
VS0(66,24)=PAx*VS0(44,24)+WPx*VS1(44,24)+r1x2Z*VR1(44,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +HfxZpE*VS1(44,14)
VS0(66,25)=PAx*VS0(44,25)+WPx*VS1(44,25)+r1x2Z*VR1(44,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(66,26)=PAx*VS0(44,26)+WPx*VS1(44,26)+r1x2Z*VR1(44,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +3D0*HfxZpE*VS1(44,15)
VS0(66,27)=PAx*VS0(44,27)+WPx*VS1(44,27)+r1x2Z*VR1(44,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(44,16)
VS0(66,28)=PAx*VS0(44,28)+WPx*VS1(44,28)+r1x2Z*VR1(44,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(44,17)
VS0(66,29)=PAx*VS0(44,29)+WPx*VS1(44,29)+r1x2Z*VR1(44,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))
VS0(66,30)=PAx*VS0(44,30)+WPx*VS1(44,30)+r1x2Z*VR1(44,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(44,18)
VS0(66,31)=PAx*VS0(44,31)+WPx*VS1(44,31)+r1x2Z*VR1(44,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(44,19)
VS0(66,32)=PAx*VS0(44,32)+WPx*VS1(44,32)+r1x2Z*VR1(44,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))
VS0(66,33)=PAx*VS0(44,33)+WPx*VS1(44,33)+r1x2Z*VR1(44,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +HfxZpE*VS1(44,20)
VS0(66,34)=PAx*VS0(44,34)+WPx*VS1(44,34)+r1x2Z*VR1(44,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))
VS0(66,35)=PAx*VS0(44,35)+WPx*VS1(44,35)+r1x2Z*VR1(44,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(67,21)=PAy*VS0(44,21)+WPy*VS1(44,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(67,22)=PAy*VS0(44,22)+WPy*VS1(44,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +HfxZpE*VS1(44,11)
VS0(67,23)=PAy*VS0(44,23)+WPy*VS1(44,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(44,12)
VS0(67,24)=PAy*VS0(44,24)+WPy*VS1(44,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +3D0*HfxZpE*VS1(44,13)
VS0(67,25)=PAy*VS0(44,25)+WPy*VS1(44,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))&
   +4D0*HfxZpE*VS1(44,14)
VS0(67,26)=PAy*VS0(44,26)+WPy*VS1(44,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))
VS0(67,27)=PAy*VS0(44,27)+WPy*VS1(44,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(44,15)
VS0(67,28)=PAy*VS0(44,28)+WPy*VS1(44,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(44,16)
VS0(67,29)=PAy*VS0(44,29)+WPy*VS1(44,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +3D0*HfxZpE*VS1(44,17)
VS0(67,30)=PAy*VS0(44,30)+WPy*VS1(44,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))
VS0(67,31)=PAy*VS0(44,31)+WPy*VS1(44,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(44,18)
VS0(67,32)=PAy*VS0(44,32)+WPy*VS1(44,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(44,19)
VS0(67,33)=PAy*VS0(44,33)+WPy*VS1(44,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))
VS0(67,34)=PAy*VS0(44,34)+WPy*VS1(44,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +HfxZpE*VS1(44,20)
VS0(67,35)=PAy*VS0(44,35)+WPy*VS1(44,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(68,21)=PAy*VS0(45,21)+WPy*VS1(45,21)&
   +3D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(68,22)=PAy*VS0(45,22)+WPy*VS1(45,22)&
   +3D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +HfxZpE*VS1(45,11)
VS0(68,23)=PAy*VS0(45,23)+WPy*VS1(45,23)&
   +3D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(45,12)
VS0(68,24)=PAy*VS0(45,24)+WPy*VS1(45,24)&
   +3D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +3D0*HfxZpE*VS1(45,13)
VS0(68,25)=PAy*VS0(45,25)+WPy*VS1(45,25)&
   +3D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))&
   +4D0*HfxZpE*VS1(45,14)
VS0(68,26)=PAy*VS0(45,26)+WPy*VS1(45,26)&
   +3D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))
VS0(68,27)=PAy*VS0(45,27)+WPy*VS1(45,27)&
   +3D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(45,15)
VS0(68,28)=PAy*VS0(45,28)+WPy*VS1(45,28)&
   +3D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(45,16)
VS0(68,29)=PAy*VS0(45,29)+WPy*VS1(45,29)&
   +3D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +3D0*HfxZpE*VS1(45,17)
VS0(68,30)=PAy*VS0(45,30)+WPy*VS1(45,30)&
   +3D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))
VS0(68,31)=PAy*VS0(45,31)+WPy*VS1(45,31)&
   +3D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(45,18)
VS0(68,32)=PAy*VS0(45,32)+WPy*VS1(45,32)&
   +3D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(45,19)
VS0(68,33)=PAy*VS0(45,33)+WPy*VS1(45,33)&
   +3D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))
VS0(68,34)=PAy*VS0(45,34)+WPy*VS1(45,34)&
   +3D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +HfxZpE*VS1(45,20)
VS0(68,35)=PAy*VS0(45,35)+WPy*VS1(45,35)&
   +3D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(69,21)=PAy*VS0(46,21)+WPy*VS1(46,21)&
   +4D0*r1x2Z*(VS0(29,21)-ExZpE*VS1(29,21))
VS0(69,22)=PAy*VS0(46,22)+WPy*VS1(46,22)&
   +4D0*r1x2Z*(VS0(29,22)-ExZpE*VS1(29,22))&
   +HfxZpE*VS1(46,11)
VS0(69,23)=PAy*VS0(46,23)+WPy*VS1(46,23)&
   +4D0*r1x2Z*(VS0(29,23)-ExZpE*VS1(29,23))&
   +2D0*HfxZpE*VS1(46,12)
VS0(69,24)=PAy*VS0(46,24)+WPy*VS1(46,24)&
   +4D0*r1x2Z*(VS0(29,24)-ExZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(46,13)
VS0(69,25)=PAy*VS0(46,25)+WPy*VS1(46,25)&
   +4D0*r1x2Z*(VS0(29,25)-ExZpE*VS1(29,25))&
   +4D0*HfxZpE*VS1(46,14)
VS0(69,26)=PAy*VS0(46,26)+WPy*VS1(46,26)&
   +4D0*r1x2Z*(VS0(29,26)-ExZpE*VS1(29,26))
VS0(69,27)=PAy*VS0(46,27)+WPy*VS1(46,27)&
   +4D0*r1x2Z*(VS0(29,27)-ExZpE*VS1(29,27))&
   +HfxZpE*VS1(46,15)
VS0(69,28)=PAy*VS0(46,28)+WPy*VS1(46,28)&
   +4D0*r1x2Z*(VS0(29,28)-ExZpE*VS1(29,28))&
   +2D0*HfxZpE*VS1(46,16)
VS0(69,29)=PAy*VS0(46,29)+WPy*VS1(46,29)&
   +4D0*r1x2Z*(VS0(29,29)-ExZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(46,17)
VS0(69,30)=PAy*VS0(46,30)+WPy*VS1(46,30)&
   +4D0*r1x2Z*(VS0(29,30)-ExZpE*VS1(29,30))
VS0(69,31)=PAy*VS0(46,31)+WPy*VS1(46,31)&
   +4D0*r1x2Z*(VS0(29,31)-ExZpE*VS1(29,31))&
   +HfxZpE*VS1(46,18)
VS0(69,32)=PAy*VS0(46,32)+WPy*VS1(46,32)&
   +4D0*r1x2Z*(VS0(29,32)-ExZpE*VS1(29,32))&
   +2D0*HfxZpE*VS1(46,19)
VS0(69,33)=PAy*VS0(46,33)+WPy*VS1(46,33)&
   +4D0*r1x2Z*(VS0(29,33)-ExZpE*VS1(29,33))
VS0(69,34)=PAy*VS0(46,34)+WPy*VS1(46,34)&
   +4D0*r1x2Z*(VS0(29,34)-ExZpE*VS1(29,34))&
   +HfxZpE*VS1(46,20)
VS0(69,35)=PAy*VS0(46,35)+WPy*VS1(46,35)&
   +4D0*r1x2Z*(VS0(29,35)-ExZpE*VS1(29,35))
VS0(70,21)=PAx*VS0(47,21)+WPx*VS1(47,21)+r1x2Z*VR1(47,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))&
   +4D0*HfxZpE*VS1(47,11)
VS0(70,22)=PAx*VS0(47,22)+WPx*VS1(47,22)+r1x2Z*VR1(47,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))&
   +3D0*HfxZpE*VS1(47,12)
VS0(70,23)=PAx*VS0(47,23)+WPx*VS1(47,23)+r1x2Z*VR1(47,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(47,13)
VS0(70,24)=PAx*VS0(47,24)+WPx*VS1(47,24)+r1x2Z*VR1(47,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))&
   +HfxZpE*VS1(47,14)
VS0(70,25)=PAx*VS0(47,25)+WPx*VS1(47,25)+r1x2Z*VR1(47,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(70,26)=PAx*VS0(47,26)+WPx*VS1(47,26)+r1x2Z*VR1(47,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +3D0*HfxZpE*VS1(47,15)
VS0(70,27)=PAx*VS0(47,27)+WPx*VS1(47,27)+r1x2Z*VR1(47,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(47,16)
VS0(70,28)=PAx*VS0(47,28)+WPx*VS1(47,28)+r1x2Z*VR1(47,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(47,17)
VS0(70,29)=PAx*VS0(47,29)+WPx*VS1(47,29)+r1x2Z*VR1(47,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))
VS0(70,30)=PAx*VS0(47,30)+WPx*VS1(47,30)+r1x2Z*VR1(47,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(47,18)
VS0(70,31)=PAx*VS0(47,31)+WPx*VS1(47,31)+r1x2Z*VR1(47,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +HfxZpE*VS1(47,19)
VS0(70,32)=PAx*VS0(47,32)+WPx*VS1(47,32)+r1x2Z*VR1(47,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))
VS0(70,33)=PAx*VS0(47,33)+WPx*VS1(47,33)+r1x2Z*VR1(47,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +HfxZpE*VS1(47,20)
VS0(70,34)=PAx*VS0(47,34)+WPx*VS1(47,34)+r1x2Z*VR1(47,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))
VS0(70,35)=PAx*VS0(47,35)+WPx*VS1(47,35)+r1x2Z*VR1(47,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))
VS0(71,21)=PAx*VS0(48,21)+WPx*VS1(48,21)+r1x2Z*VR1(48,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))&
   +4D0*HfxZpE*VS1(48,11)
VS0(71,22)=PAx*VS0(48,22)+WPx*VS1(48,22)+r1x2Z*VR1(48,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +3D0*HfxZpE*VS1(48,12)
VS0(71,23)=PAx*VS0(48,23)+WPx*VS1(48,23)+r1x2Z*VR1(48,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(48,13)
VS0(71,24)=PAx*VS0(48,24)+WPx*VS1(48,24)+r1x2Z*VR1(48,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +HfxZpE*VS1(48,14)
VS0(71,25)=PAx*VS0(48,25)+WPx*VS1(48,25)+r1x2Z*VR1(48,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(71,26)=PAx*VS0(48,26)+WPx*VS1(48,26)+r1x2Z*VR1(48,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +3D0*HfxZpE*VS1(48,15)
VS0(71,27)=PAx*VS0(48,27)+WPx*VS1(48,27)+r1x2Z*VR1(48,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(48,16)
VS0(71,28)=PAx*VS0(48,28)+WPx*VS1(48,28)+r1x2Z*VR1(48,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(48,17)
VS0(71,29)=PAx*VS0(48,29)+WPx*VS1(48,29)+r1x2Z*VR1(48,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))
VS0(71,30)=PAx*VS0(48,30)+WPx*VS1(48,30)+r1x2Z*VR1(48,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(48,18)
VS0(71,31)=PAx*VS0(48,31)+WPx*VS1(48,31)+r1x2Z*VR1(48,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(48,19)
VS0(71,32)=PAx*VS0(48,32)+WPx*VS1(48,32)+r1x2Z*VR1(48,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))
VS0(71,33)=PAx*VS0(48,33)+WPx*VS1(48,33)+r1x2Z*VR1(48,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +HfxZpE*VS1(48,20)
VS0(71,34)=PAx*VS0(48,34)+WPx*VS1(48,34)+r1x2Z*VR1(48,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))
VS0(71,35)=PAx*VS0(48,35)+WPx*VS1(48,35)+r1x2Z*VR1(48,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(72,21)=PAx*VS0(49,21)+WPx*VS1(49,21)+r1x2Z*VR1(49,21)&
   +r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))&
   +4D0*HfxZpE*VS1(49,11)
VS0(72,22)=PAx*VS0(49,22)+WPx*VS1(49,22)+r1x2Z*VR1(49,22)&
   +r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +3D0*HfxZpE*VS1(49,12)
VS0(72,23)=PAx*VS0(49,23)+WPx*VS1(49,23)+r1x2Z*VR1(49,23)&
   +r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(49,13)
VS0(72,24)=PAx*VS0(49,24)+WPx*VS1(49,24)+r1x2Z*VR1(49,24)&
   +r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +HfxZpE*VS1(49,14)
VS0(72,25)=PAx*VS0(49,25)+WPx*VS1(49,25)+r1x2Z*VR1(49,25)&
   +r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(72,26)=PAx*VS0(49,26)+WPx*VS1(49,26)+r1x2Z*VR1(49,26)&
   +r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +3D0*HfxZpE*VS1(49,15)
VS0(72,27)=PAx*VS0(49,27)+WPx*VS1(49,27)+r1x2Z*VR1(49,27)&
   +r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(49,16)
VS0(72,28)=PAx*VS0(49,28)+WPx*VS1(49,28)+r1x2Z*VR1(49,28)&
   +r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(49,17)
VS0(72,29)=PAx*VS0(49,29)+WPx*VS1(49,29)+r1x2Z*VR1(49,29)&
   +r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))
VS0(72,30)=PAx*VS0(49,30)+WPx*VS1(49,30)+r1x2Z*VR1(49,30)&
   +r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(49,18)
VS0(72,31)=PAx*VS0(49,31)+WPx*VS1(49,31)+r1x2Z*VR1(49,31)&
   +r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(49,19)
VS0(72,32)=PAx*VS0(49,32)+WPx*VS1(49,32)+r1x2Z*VR1(49,32)&
   +r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))
VS0(72,33)=PAx*VS0(49,33)+WPx*VS1(49,33)+r1x2Z*VR1(49,33)&
   +r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +HfxZpE*VS1(49,20)
VS0(72,34)=PAx*VS0(49,34)+WPx*VS1(49,34)+r1x2Z*VR1(49,34)&
   +r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))
VS0(72,35)=PAx*VS0(49,35)+WPx*VS1(49,35)+r1x2Z*VR1(49,35)&
   +r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(73,21)=PAy*VS0(49,21)+WPy*VS1(49,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(73,22)=PAy*VS0(49,22)+WPy*VS1(49,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +HfxZpE*VS1(49,11)
VS0(73,23)=PAy*VS0(49,23)+WPy*VS1(49,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(49,12)
VS0(73,24)=PAy*VS0(49,24)+WPy*VS1(49,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +3D0*HfxZpE*VS1(49,13)
VS0(73,25)=PAy*VS0(49,25)+WPy*VS1(49,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))&
   +4D0*HfxZpE*VS1(49,14)
VS0(73,26)=PAy*VS0(49,26)+WPy*VS1(49,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))
VS0(73,27)=PAy*VS0(49,27)+WPy*VS1(49,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(49,15)
VS0(73,28)=PAy*VS0(49,28)+WPy*VS1(49,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(49,16)
VS0(73,29)=PAy*VS0(49,29)+WPy*VS1(49,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +3D0*HfxZpE*VS1(49,17)
VS0(73,30)=PAy*VS0(49,30)+WPy*VS1(49,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))
VS0(73,31)=PAy*VS0(49,31)+WPy*VS1(49,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(49,18)
VS0(73,32)=PAy*VS0(49,32)+WPy*VS1(49,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(49,19)
VS0(73,33)=PAy*VS0(49,33)+WPy*VS1(49,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))
VS0(73,34)=PAy*VS0(49,34)+WPy*VS1(49,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +HfxZpE*VS1(49,20)
VS0(73,35)=PAy*VS0(49,35)+WPy*VS1(49,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(74,21)=PAy*VS0(50,21)+WPy*VS1(50,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(74,22)=PAy*VS0(50,22)+WPy*VS1(50,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +HfxZpE*VS1(50,11)
VS0(74,23)=PAy*VS0(50,23)+WPy*VS1(50,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(50,12)
VS0(74,24)=PAy*VS0(50,24)+WPy*VS1(50,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +3D0*HfxZpE*VS1(50,13)
VS0(74,25)=PAy*VS0(50,25)+WPy*VS1(50,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))&
   +4D0*HfxZpE*VS1(50,14)
VS0(74,26)=PAy*VS0(50,26)+WPy*VS1(50,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))
VS0(74,27)=PAy*VS0(50,27)+WPy*VS1(50,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(50,15)
VS0(74,28)=PAy*VS0(50,28)+WPy*VS1(50,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(50,16)
VS0(74,29)=PAy*VS0(50,29)+WPy*VS1(50,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +3D0*HfxZpE*VS1(50,17)
VS0(74,30)=PAy*VS0(50,30)+WPy*VS1(50,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))
VS0(74,31)=PAy*VS0(50,31)+WPy*VS1(50,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(50,18)
VS0(74,32)=PAy*VS0(50,32)+WPy*VS1(50,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(50,19)
VS0(74,33)=PAy*VS0(50,33)+WPy*VS1(50,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))
VS0(74,34)=PAy*VS0(50,34)+WPy*VS1(50,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +HfxZpE*VS1(50,20)
VS0(74,35)=PAy*VS0(50,35)+WPy*VS1(50,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(75,21)=PAx*VS0(51,21)+WPx*VS1(51,21)+r1x2Z*VR1(51,21)&
   +2D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))&
   +4D0*HfxZpE*VS1(51,11)
VS0(75,22)=PAx*VS0(51,22)+WPx*VS1(51,22)+r1x2Z*VR1(51,22)&
   +2D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))&
   +3D0*HfxZpE*VS1(51,12)
VS0(75,23)=PAx*VS0(51,23)+WPx*VS1(51,23)+r1x2Z*VR1(51,23)&
   +2D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))&
   +2D0*HfxZpE*VS1(51,13)
VS0(75,24)=PAx*VS0(51,24)+WPx*VS1(51,24)+r1x2Z*VR1(51,24)&
   +2D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))&
   +HfxZpE*VS1(51,14)
VS0(75,25)=PAx*VS0(51,25)+WPx*VS1(51,25)+r1x2Z*VR1(51,25)&
   +2D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(75,26)=PAx*VS0(51,26)+WPx*VS1(51,26)+r1x2Z*VR1(51,26)&
   +2D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +3D0*HfxZpE*VS1(51,15)
VS0(75,27)=PAx*VS0(51,27)+WPx*VS1(51,27)+r1x2Z*VR1(51,27)&
   +2D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +2D0*HfxZpE*VS1(51,16)
VS0(75,28)=PAx*VS0(51,28)+WPx*VS1(51,28)+r1x2Z*VR1(51,28)&
   +2D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(51,17)
VS0(75,29)=PAx*VS0(51,29)+WPx*VS1(51,29)+r1x2Z*VR1(51,29)&
   +2D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))
VS0(75,30)=PAx*VS0(51,30)+WPx*VS1(51,30)+r1x2Z*VR1(51,30)&
   +2D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(51,18)
VS0(75,31)=PAx*VS0(51,31)+WPx*VS1(51,31)+r1x2Z*VR1(51,31)&
   +2D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +HfxZpE*VS1(51,19)
VS0(75,32)=PAx*VS0(51,32)+WPx*VS1(51,32)+r1x2Z*VR1(51,32)&
   +2D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))
VS0(75,33)=PAx*VS0(51,33)+WPx*VS1(51,33)+r1x2Z*VR1(51,33)&
   +2D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +HfxZpE*VS1(51,20)
VS0(75,34)=PAx*VS0(51,34)+WPx*VS1(51,34)+r1x2Z*VR1(51,34)&
   +2D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))
VS0(75,35)=PAx*VS0(51,35)+WPx*VS1(51,35)+r1x2Z*VR1(51,35)&
   +2D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))
VS0(76,21)=PAz*VS0(48,21)+WPz*VS1(48,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(76,22)=PAz*VS0(48,22)+WPz*VS1(48,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))
VS0(76,23)=PAz*VS0(48,23)+WPz*VS1(48,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))
VS0(76,24)=PAz*VS0(48,24)+WPz*VS1(48,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))
VS0(76,25)=PAz*VS0(48,25)+WPz*VS1(48,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(76,26)=PAz*VS0(48,26)+WPz*VS1(48,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +HfxZpE*VS1(48,11)
VS0(76,27)=PAz*VS0(48,27)+WPz*VS1(48,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(48,12)
VS0(76,28)=PAz*VS0(48,28)+WPz*VS1(48,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(48,13)
VS0(76,29)=PAz*VS0(48,29)+WPz*VS1(48,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +HfxZpE*VS1(48,14)
VS0(76,30)=PAz*VS0(48,30)+WPz*VS1(48,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(48,15)
VS0(76,31)=PAz*VS0(48,31)+WPz*VS1(48,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(48,16)
VS0(76,32)=PAz*VS0(48,32)+WPz*VS1(48,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(48,17)
VS0(76,33)=PAz*VS0(48,33)+WPz*VS1(48,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +3D0*HfxZpE*VS1(48,18)
VS0(76,34)=PAz*VS0(48,34)+WPz*VS1(48,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +3D0*HfxZpE*VS1(48,19)
VS0(76,35)=PAz*VS0(48,35)+WPz*VS1(48,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))&
   +4D0*HfxZpE*VS1(48,20)
VS0(77,21)=PAz*VS0(49,21)+WPz*VS1(49,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(77,22)=PAz*VS0(49,22)+WPz*VS1(49,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))
VS0(77,23)=PAz*VS0(49,23)+WPz*VS1(49,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))
VS0(77,24)=PAz*VS0(49,24)+WPz*VS1(49,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))
VS0(77,25)=PAz*VS0(49,25)+WPz*VS1(49,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(77,26)=PAz*VS0(49,26)+WPz*VS1(49,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +HfxZpE*VS1(49,11)
VS0(77,27)=PAz*VS0(49,27)+WPz*VS1(49,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(49,12)
VS0(77,28)=PAz*VS0(49,28)+WPz*VS1(49,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(49,13)
VS0(77,29)=PAz*VS0(49,29)+WPz*VS1(49,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +HfxZpE*VS1(49,14)
VS0(77,30)=PAz*VS0(49,30)+WPz*VS1(49,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(49,15)
VS0(77,31)=PAz*VS0(49,31)+WPz*VS1(49,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(49,16)
VS0(77,32)=PAz*VS0(49,32)+WPz*VS1(49,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(49,17)
VS0(77,33)=PAz*VS0(49,33)+WPz*VS1(49,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +3D0*HfxZpE*VS1(49,18)
VS0(77,34)=PAz*VS0(49,34)+WPz*VS1(49,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +3D0*HfxZpE*VS1(49,19)
VS0(77,35)=PAz*VS0(49,35)+WPz*VS1(49,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))&
   +4D0*HfxZpE*VS1(49,20)
VS0(78,21)=PAy*VS0(53,21)+WPy*VS1(53,21)&
   +2D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(78,22)=PAy*VS0(53,22)+WPy*VS1(53,22)&
   +2D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))&
   +HfxZpE*VS1(53,11)
VS0(78,23)=PAy*VS0(53,23)+WPy*VS1(53,23)&
   +2D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))&
   +2D0*HfxZpE*VS1(53,12)
VS0(78,24)=PAy*VS0(53,24)+WPy*VS1(53,24)&
   +2D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))&
   +3D0*HfxZpE*VS1(53,13)
VS0(78,25)=PAy*VS0(53,25)+WPy*VS1(53,25)&
   +2D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))&
   +4D0*HfxZpE*VS1(53,14)
VS0(78,26)=PAy*VS0(53,26)+WPy*VS1(53,26)&
   +2D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))
VS0(78,27)=PAy*VS0(53,27)+WPy*VS1(53,27)&
   +2D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(53,15)
VS0(78,28)=PAy*VS0(53,28)+WPy*VS1(53,28)&
   +2D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +2D0*HfxZpE*VS1(53,16)
VS0(78,29)=PAy*VS0(53,29)+WPy*VS1(53,29)&
   +2D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +3D0*HfxZpE*VS1(53,17)
VS0(78,30)=PAy*VS0(53,30)+WPy*VS1(53,30)&
   +2D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))
VS0(78,31)=PAy*VS0(53,31)+WPy*VS1(53,31)&
   +2D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +HfxZpE*VS1(53,18)
VS0(78,32)=PAy*VS0(53,32)+WPy*VS1(53,32)&
   +2D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(53,19)
VS0(78,33)=PAy*VS0(53,33)+WPy*VS1(53,33)&
   +2D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))
VS0(78,34)=PAy*VS0(53,34)+WPy*VS1(53,34)&
   +2D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +HfxZpE*VS1(53,20)
VS0(78,35)=PAy*VS0(53,35)+WPy*VS1(53,35)&
   +2D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))
VS0(79,21)=PAz*VS0(51,21)+WPz*VS1(51,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))
VS0(79,22)=PAz*VS0(51,22)+WPz*VS1(51,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))
VS0(79,23)=PAz*VS0(51,23)+WPz*VS1(51,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))
VS0(79,24)=PAz*VS0(51,24)+WPz*VS1(51,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))
VS0(79,25)=PAz*VS0(51,25)+WPz*VS1(51,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(79,26)=PAz*VS0(51,26)+WPz*VS1(51,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +HfxZpE*VS1(51,11)
VS0(79,27)=PAz*VS0(51,27)+WPz*VS1(51,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +HfxZpE*VS1(51,12)
VS0(79,28)=PAz*VS0(51,28)+WPz*VS1(51,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(51,13)
VS0(79,29)=PAz*VS0(51,29)+WPz*VS1(51,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))&
   +HfxZpE*VS1(51,14)
VS0(79,30)=PAz*VS0(51,30)+WPz*VS1(51,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(51,15)
VS0(79,31)=PAz*VS0(51,31)+WPz*VS1(51,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(51,16)
VS0(79,32)=PAz*VS0(51,32)+WPz*VS1(51,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(51,17)
VS0(79,33)=PAz*VS0(51,33)+WPz*VS1(51,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +3D0*HfxZpE*VS1(51,18)
VS0(79,34)=PAz*VS0(51,34)+WPz*VS1(51,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))&
   +3D0*HfxZpE*VS1(51,19)
VS0(79,35)=PAz*VS0(51,35)+WPz*VS1(51,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))&
   +4D0*HfxZpE*VS1(51,20)
VS0(80,21)=PAz*VS0(52,21)+WPz*VS1(52,21)&
   +3D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(80,22)=PAz*VS0(52,22)+WPz*VS1(52,22)&
   +3D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))
VS0(80,23)=PAz*VS0(52,23)+WPz*VS1(52,23)&
   +3D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))
VS0(80,24)=PAz*VS0(52,24)+WPz*VS1(52,24)&
   +3D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))
VS0(80,25)=PAz*VS0(52,25)+WPz*VS1(52,25)&
   +3D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(80,26)=PAz*VS0(52,26)+WPz*VS1(52,26)&
   +3D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +HfxZpE*VS1(52,11)
VS0(80,27)=PAz*VS0(52,27)+WPz*VS1(52,27)&
   +3D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(52,12)
VS0(80,28)=PAz*VS0(52,28)+WPz*VS1(52,28)&
   +3D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(52,13)
VS0(80,29)=PAz*VS0(52,29)+WPz*VS1(52,29)&
   +3D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +HfxZpE*VS1(52,14)
VS0(80,30)=PAz*VS0(52,30)+WPz*VS1(52,30)&
   +3D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(52,15)
VS0(80,31)=PAz*VS0(52,31)+WPz*VS1(52,31)&
   +3D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(52,16)
VS0(80,32)=PAz*VS0(52,32)+WPz*VS1(52,32)&
   +3D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(52,17)
VS0(80,33)=PAz*VS0(52,33)+WPz*VS1(52,33)&
   +3D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +3D0*HfxZpE*VS1(52,18)
VS0(80,34)=PAz*VS0(52,34)+WPz*VS1(52,34)&
   +3D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +3D0*HfxZpE*VS1(52,19)
VS0(80,35)=PAz*VS0(52,35)+WPz*VS1(52,35)&
   +3D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))&
   +4D0*HfxZpE*VS1(52,20)
VS0(81,21)=PAz*VS0(53,21)+WPz*VS1(53,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(81,22)=PAz*VS0(53,22)+WPz*VS1(53,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))
VS0(81,23)=PAz*VS0(53,23)+WPz*VS1(53,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))
VS0(81,24)=PAz*VS0(53,24)+WPz*VS1(53,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))
VS0(81,25)=PAz*VS0(53,25)+WPz*VS1(53,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(81,26)=PAz*VS0(53,26)+WPz*VS1(53,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +HfxZpE*VS1(53,11)
VS0(81,27)=PAz*VS0(53,27)+WPz*VS1(53,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(53,12)
VS0(81,28)=PAz*VS0(53,28)+WPz*VS1(53,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(53,13)
VS0(81,29)=PAz*VS0(53,29)+WPz*VS1(53,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +HfxZpE*VS1(53,14)
VS0(81,30)=PAz*VS0(53,30)+WPz*VS1(53,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(53,15)
VS0(81,31)=PAz*VS0(53,31)+WPz*VS1(53,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(53,16)
VS0(81,32)=PAz*VS0(53,32)+WPz*VS1(53,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(53,17)
VS0(81,33)=PAz*VS0(53,33)+WPz*VS1(53,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +3D0*HfxZpE*VS1(53,18)
VS0(81,34)=PAz*VS0(53,34)+WPz*VS1(53,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +3D0*HfxZpE*VS1(53,19)
VS0(81,35)=PAz*VS0(53,35)+WPz*VS1(53,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))&
   +4D0*HfxZpE*VS1(53,20)
VS0(82,21)=PAz*VS0(54,21)+WPz*VS1(54,21)&
   +4D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))
VS0(82,22)=PAz*VS0(54,22)+WPz*VS1(54,22)&
   +4D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))
VS0(82,23)=PAz*VS0(54,23)+WPz*VS1(54,23)&
   +4D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))
VS0(82,24)=PAz*VS0(54,24)+WPz*VS1(54,24)&
   +4D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))
VS0(82,25)=PAz*VS0(54,25)+WPz*VS1(54,25)&
   +4D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(82,26)=PAz*VS0(54,26)+WPz*VS1(54,26)&
   +4D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +HfxZpE*VS1(54,11)
VS0(82,27)=PAz*VS0(54,27)+WPz*VS1(54,27)&
   +4D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +HfxZpE*VS1(54,12)
VS0(82,28)=PAz*VS0(54,28)+WPz*VS1(54,28)&
   +4D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(54,13)
VS0(82,29)=PAz*VS0(54,29)+WPz*VS1(54,29)&
   +4D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))&
   +HfxZpE*VS1(54,14)
VS0(82,30)=PAz*VS0(54,30)+WPz*VS1(54,30)&
   +4D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(54,15)
VS0(82,31)=PAz*VS0(54,31)+WPz*VS1(54,31)&
   +4D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +2D0*HfxZpE*VS1(54,16)
VS0(82,32)=PAz*VS0(54,32)+WPz*VS1(54,32)&
   +4D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))&
   +2D0*HfxZpE*VS1(54,17)
VS0(82,33)=PAz*VS0(54,33)+WPz*VS1(54,33)&
   +4D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(54,18)
VS0(82,34)=PAz*VS0(54,34)+WPz*VS1(54,34)&
   +4D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(54,19)
VS0(82,35)=PAz*VS0(54,35)+WPz*VS1(54,35)&
   +4D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))&
   +4D0*HfxZpE*VS1(54,20)
VS0(83,21)=PAz*VS0(55,21)+WPz*VS1(55,21)&
   +4D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(83,22)=PAz*VS0(55,22)+WPz*VS1(55,22)&
   +4D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))
VS0(83,23)=PAz*VS0(55,23)+WPz*VS1(55,23)&
   +4D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))
VS0(83,24)=PAz*VS0(55,24)+WPz*VS1(55,24)&
   +4D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))
VS0(83,25)=PAz*VS0(55,25)+WPz*VS1(55,25)&
   +4D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))
VS0(83,26)=PAz*VS0(55,26)+WPz*VS1(55,26)&
   +4D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))&
   +HfxZpE*VS1(55,11)
VS0(83,27)=PAz*VS0(55,27)+WPz*VS1(55,27)&
   +4D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(55,12)
VS0(83,28)=PAz*VS0(55,28)+WPz*VS1(55,28)&
   +4D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +HfxZpE*VS1(55,13)
VS0(83,29)=PAz*VS0(55,29)+WPz*VS1(55,29)&
   +4D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +HfxZpE*VS1(55,14)
VS0(83,30)=PAz*VS0(55,30)+WPz*VS1(55,30)&
   +4D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))&
   +2D0*HfxZpE*VS1(55,15)
VS0(83,31)=PAz*VS0(55,31)+WPz*VS1(55,31)&
   +4D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +2D0*HfxZpE*VS1(55,16)
VS0(83,32)=PAz*VS0(55,32)+WPz*VS1(55,32)&
   +4D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(55,17)
VS0(83,33)=PAz*VS0(55,33)+WPz*VS1(55,33)&
   +4D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(55,18)
VS0(83,34)=PAz*VS0(55,34)+WPz*VS1(55,34)&
   +4D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(55,19)
VS0(83,35)=PAz*VS0(55,35)+WPz*VS1(55,35)&
   +4D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))&
   +4D0*HfxZpE*VS1(55,20)
VS0(84,21)=PAz*VS0(56,21)+WPz*VS1(56,21)&
   +5D0*r1x2Z*(VS0(35,21)-ExZpE*VS1(35,21))
VS0(84,22)=PAz*VS0(56,22)+WPz*VS1(56,22)&
   +5D0*r1x2Z*(VS0(35,22)-ExZpE*VS1(35,22))
VS0(84,23)=PAz*VS0(56,23)+WPz*VS1(56,23)&
   +5D0*r1x2Z*(VS0(35,23)-ExZpE*VS1(35,23))
VS0(84,24)=PAz*VS0(56,24)+WPz*VS1(56,24)&
   +5D0*r1x2Z*(VS0(35,24)-ExZpE*VS1(35,24))
VS0(84,25)=PAz*VS0(56,25)+WPz*VS1(56,25)&
   +5D0*r1x2Z*(VS0(35,25)-ExZpE*VS1(35,25))
VS0(84,26)=PAz*VS0(56,26)+WPz*VS1(56,26)&
   +5D0*r1x2Z*(VS0(35,26)-ExZpE*VS1(35,26))&
   +HfxZpE*VS1(56,11)
VS0(84,27)=PAz*VS0(56,27)+WPz*VS1(56,27)&
   +5D0*r1x2Z*(VS0(35,27)-ExZpE*VS1(35,27))&
   +HfxZpE*VS1(56,12)
VS0(84,28)=PAz*VS0(56,28)+WPz*VS1(56,28)&
   +5D0*r1x2Z*(VS0(35,28)-ExZpE*VS1(35,28))&
   +HfxZpE*VS1(56,13)
VS0(84,29)=PAz*VS0(56,29)+WPz*VS1(56,29)&
   +5D0*r1x2Z*(VS0(35,29)-ExZpE*VS1(35,29))&
   +HfxZpE*VS1(56,14)
VS0(84,30)=PAz*VS0(56,30)+WPz*VS1(56,30)&
   +5D0*r1x2Z*(VS0(35,30)-ExZpE*VS1(35,30))&
   +2D0*HfxZpE*VS1(56,15)
VS0(84,31)=PAz*VS0(56,31)+WPz*VS1(56,31)&
   +5D0*r1x2Z*(VS0(35,31)-ExZpE*VS1(35,31))&
   +2D0*HfxZpE*VS1(56,16)
VS0(84,32)=PAz*VS0(56,32)+WPz*VS1(56,32)&
   +5D0*r1x2Z*(VS0(35,32)-ExZpE*VS1(35,32))&
   +2D0*HfxZpE*VS1(56,17)
VS0(84,33)=PAz*VS0(56,33)+WPz*VS1(56,33)&
   +5D0*r1x2Z*(VS0(35,33)-ExZpE*VS1(35,33))&
   +3D0*HfxZpE*VS1(56,18)
VS0(84,34)=PAz*VS0(56,34)+WPz*VS1(56,34)&
   +5D0*r1x2Z*(VS0(35,34)-ExZpE*VS1(35,34))&
   +3D0*HfxZpE*VS1(56,19)
VS0(84,35)=PAz*VS0(56,35)+WPz*VS1(56,35)&
   +5D0*r1x2Z*(VS0(35,35)-ExZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(56,20)
CASE(2)
VS0(57,21)=PAx*VS0(36,21)+WPx*VS1(36,21)&
   +5D0*r1x2Z*(VS0(21,21)-ExZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(36,11)
VS0(57,22)=PAx*VS0(36,22)+WPx*VS1(36,22)&
   +5D0*r1x2Z*(VS0(21,22)-ExZpE*VS1(21,22))&
   +3D0*HfxZpE*VS1(36,12)
VS0(57,23)=PAx*VS0(36,23)+WPx*VS1(36,23)&
   +5D0*r1x2Z*(VS0(21,23)-ExZpE*VS1(21,23))&
   +2D0*HfxZpE*VS1(36,13)
VS0(57,24)=PAx*VS0(36,24)+WPx*VS1(36,24)&
   +5D0*r1x2Z*(VS0(21,24)-ExZpE*VS1(21,24))&
   +HfxZpE*VS1(36,14)
VS0(57,25)=PAx*VS0(36,25)+WPx*VS1(36,25)&
   +5D0*r1x2Z*(VS0(21,25)-ExZpE*VS1(21,25))
VS0(57,26)=PAx*VS0(36,26)+WPx*VS1(36,26)&
   +5D0*r1x2Z*(VS0(21,26)-ExZpE*VS1(21,26))&
   +3D0*HfxZpE*VS1(36,15)
VS0(57,27)=PAx*VS0(36,27)+WPx*VS1(36,27)&
   +5D0*r1x2Z*(VS0(21,27)-ExZpE*VS1(21,27))&
   +2D0*HfxZpE*VS1(36,16)
VS0(57,28)=PAx*VS0(36,28)+WPx*VS1(36,28)&
   +5D0*r1x2Z*(VS0(21,28)-ExZpE*VS1(21,28))&
   +HfxZpE*VS1(36,17)
VS0(57,29)=PAx*VS0(36,29)+WPx*VS1(36,29)&
   +5D0*r1x2Z*(VS0(21,29)-ExZpE*VS1(21,29))
VS0(57,30)=PAx*VS0(36,30)+WPx*VS1(36,30)&
   +5D0*r1x2Z*(VS0(21,30)-ExZpE*VS1(21,30))&
   +2D0*HfxZpE*VS1(36,18)
VS0(57,31)=PAx*VS0(36,31)+WPx*VS1(36,31)&
   +5D0*r1x2Z*(VS0(21,31)-ExZpE*VS1(21,31))&
   +HfxZpE*VS1(36,19)
VS0(57,32)=PAx*VS0(36,32)+WPx*VS1(36,32)&
   +5D0*r1x2Z*(VS0(21,32)-ExZpE*VS1(21,32))
VS0(57,33)=PAx*VS0(36,33)+WPx*VS1(36,33)&
   +5D0*r1x2Z*(VS0(21,33)-ExZpE*VS1(21,33))&
   +HfxZpE*VS1(36,20)
VS0(57,34)=PAx*VS0(36,34)+WPx*VS1(36,34)&
   +5D0*r1x2Z*(VS0(21,34)-ExZpE*VS1(21,34))
VS0(57,35)=PAx*VS0(36,35)+WPx*VS1(36,35)&
   +5D0*r1x2Z*(VS0(21,35)-ExZpE*VS1(21,35))
VS0(58,21)=PAx*VS0(37,21)+WPx*VS1(37,21)&
   +4D0*r1x2Z*(VS0(22,21)-ExZpE*VS1(22,21))&
   +4D0*HfxZpE*VS1(37,11)
VS0(58,22)=PAx*VS0(37,22)+WPx*VS1(37,22)&
   +4D0*r1x2Z*(VS0(22,22)-ExZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(37,12)
VS0(58,23)=PAx*VS0(37,23)+WPx*VS1(37,23)&
   +4D0*r1x2Z*(VS0(22,23)-ExZpE*VS1(22,23))&
   +2D0*HfxZpE*VS1(37,13)
VS0(58,24)=PAx*VS0(37,24)+WPx*VS1(37,24)&
   +4D0*r1x2Z*(VS0(22,24)-ExZpE*VS1(22,24))&
   +HfxZpE*VS1(37,14)
VS0(58,25)=PAx*VS0(37,25)+WPx*VS1(37,25)&
   +4D0*r1x2Z*(VS0(22,25)-ExZpE*VS1(22,25))
VS0(58,26)=PAx*VS0(37,26)+WPx*VS1(37,26)&
   +4D0*r1x2Z*(VS0(22,26)-ExZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(37,15)
VS0(58,27)=PAx*VS0(37,27)+WPx*VS1(37,27)&
   +4D0*r1x2Z*(VS0(22,27)-ExZpE*VS1(22,27))&
   +2D0*HfxZpE*VS1(37,16)
VS0(58,28)=PAx*VS0(37,28)+WPx*VS1(37,28)&
   +4D0*r1x2Z*(VS0(22,28)-ExZpE*VS1(22,28))&
   +HfxZpE*VS1(37,17)
VS0(58,29)=PAx*VS0(37,29)+WPx*VS1(37,29)&
   +4D0*r1x2Z*(VS0(22,29)-ExZpE*VS1(22,29))
VS0(58,30)=PAx*VS0(37,30)+WPx*VS1(37,30)&
   +4D0*r1x2Z*(VS0(22,30)-ExZpE*VS1(22,30))&
   +2D0*HfxZpE*VS1(37,18)
VS0(58,31)=PAx*VS0(37,31)+WPx*VS1(37,31)&
   +4D0*r1x2Z*(VS0(22,31)-ExZpE*VS1(22,31))&
   +HfxZpE*VS1(37,19)
VS0(58,32)=PAx*VS0(37,32)+WPx*VS1(37,32)&
   +4D0*r1x2Z*(VS0(22,32)-ExZpE*VS1(22,32))
VS0(58,33)=PAx*VS0(37,33)+WPx*VS1(37,33)&
   +4D0*r1x2Z*(VS0(22,33)-ExZpE*VS1(22,33))&
   +HfxZpE*VS1(37,20)
VS0(58,34)=PAx*VS0(37,34)+WPx*VS1(37,34)&
   +4D0*r1x2Z*(VS0(22,34)-ExZpE*VS1(22,34))
VS0(58,35)=PAx*VS0(37,35)+WPx*VS1(37,35)&
   +4D0*r1x2Z*(VS0(22,35)-ExZpE*VS1(22,35))
VS0(59,21)=PAx*VS0(38,21)+WPx*VS1(38,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))&
   +4D0*HfxZpE*VS1(38,11)
VS0(59,22)=PAx*VS0(38,22)+WPx*VS1(38,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +3D0*HfxZpE*VS1(38,12)
VS0(59,23)=PAx*VS0(38,23)+WPx*VS1(38,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(38,13)
VS0(59,24)=PAx*VS0(38,24)+WPx*VS1(38,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +HfxZpE*VS1(38,14)
VS0(59,25)=PAx*VS0(38,25)+WPx*VS1(38,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))
VS0(59,26)=PAx*VS0(38,26)+WPx*VS1(38,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))&
   +3D0*HfxZpE*VS1(38,15)
VS0(59,27)=PAx*VS0(38,27)+WPx*VS1(38,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(38,16)
VS0(59,28)=PAx*VS0(38,28)+WPx*VS1(38,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +HfxZpE*VS1(38,17)
VS0(59,29)=PAx*VS0(38,29)+WPx*VS1(38,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))
VS0(59,30)=PAx*VS0(38,30)+WPx*VS1(38,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(38,18)
VS0(59,31)=PAx*VS0(38,31)+WPx*VS1(38,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(38,19)
VS0(59,32)=PAx*VS0(38,32)+WPx*VS1(38,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))
VS0(59,33)=PAx*VS0(38,33)+WPx*VS1(38,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))&
   +HfxZpE*VS1(38,20)
VS0(59,34)=PAx*VS0(38,34)+WPx*VS1(38,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))
VS0(59,35)=PAx*VS0(38,35)+WPx*VS1(38,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(60,21)=PAx*VS0(39,21)+WPx*VS1(39,21)&
   +2D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))&
   +4D0*HfxZpE*VS1(39,11)
VS0(60,22)=PAx*VS0(39,22)+WPx*VS1(39,22)&
   +2D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +3D0*HfxZpE*VS1(39,12)
VS0(60,23)=PAx*VS0(39,23)+WPx*VS1(39,23)&
   +2D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(39,13)
VS0(60,24)=PAx*VS0(39,24)+WPx*VS1(39,24)&
   +2D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +HfxZpE*VS1(39,14)
VS0(60,25)=PAx*VS0(39,25)+WPx*VS1(39,25)&
   +2D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))
VS0(60,26)=PAx*VS0(39,26)+WPx*VS1(39,26)&
   +2D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))&
   +3D0*HfxZpE*VS1(39,15)
VS0(60,27)=PAx*VS0(39,27)+WPx*VS1(39,27)&
   +2D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +2D0*HfxZpE*VS1(39,16)
VS0(60,28)=PAx*VS0(39,28)+WPx*VS1(39,28)&
   +2D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +HfxZpE*VS1(39,17)
VS0(60,29)=PAx*VS0(39,29)+WPx*VS1(39,29)&
   +2D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))
VS0(60,30)=PAx*VS0(39,30)+WPx*VS1(39,30)&
   +2D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))&
   +2D0*HfxZpE*VS1(39,18)
VS0(60,31)=PAx*VS0(39,31)+WPx*VS1(39,31)&
   +2D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(39,19)
VS0(60,32)=PAx*VS0(39,32)+WPx*VS1(39,32)&
   +2D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))
VS0(60,33)=PAx*VS0(39,33)+WPx*VS1(39,33)&
   +2D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))&
   +HfxZpE*VS1(39,20)
VS0(60,34)=PAx*VS0(39,34)+WPx*VS1(39,34)&
   +2D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))
VS0(60,35)=PAx*VS0(39,35)+WPx*VS1(39,35)&
   +2D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(61,21)=PAy*VS0(39,21)+WPy*VS1(39,21)+r1x2Z*VR1(39,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))
VS0(61,22)=PAy*VS0(39,22)+WPy*VS1(39,22)+r1x2Z*VR1(39,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +HfxZpE*VS1(39,11)
VS0(61,23)=PAy*VS0(39,23)+WPy*VS1(39,23)+r1x2Z*VR1(39,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(39,12)
VS0(61,24)=PAy*VS0(39,24)+WPy*VS1(39,24)+r1x2Z*VR1(39,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +3D0*HfxZpE*VS1(39,13)
VS0(61,25)=PAy*VS0(39,25)+WPy*VS1(39,25)+r1x2Z*VR1(39,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))&
   +4D0*HfxZpE*VS1(39,14)
VS0(61,26)=PAy*VS0(39,26)+WPy*VS1(39,26)+r1x2Z*VR1(39,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))
VS0(61,27)=PAy*VS0(39,27)+WPy*VS1(39,27)+r1x2Z*VR1(39,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +HfxZpE*VS1(39,15)
VS0(61,28)=PAy*VS0(39,28)+WPy*VS1(39,28)+r1x2Z*VR1(39,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(39,16)
VS0(61,29)=PAy*VS0(39,29)+WPy*VS1(39,29)+r1x2Z*VR1(39,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))&
   +3D0*HfxZpE*VS1(39,17)
VS0(61,30)=PAy*VS0(39,30)+WPy*VS1(39,30)+r1x2Z*VR1(39,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))
VS0(61,31)=PAy*VS0(39,31)+WPy*VS1(39,31)+r1x2Z*VR1(39,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(39,18)
VS0(61,32)=PAy*VS0(39,32)+WPy*VS1(39,32)+r1x2Z*VR1(39,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(39,19)
VS0(61,33)=PAy*VS0(39,33)+WPy*VS1(39,33)+r1x2Z*VR1(39,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))
VS0(61,34)=PAy*VS0(39,34)+WPy*VS1(39,34)+r1x2Z*VR1(39,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))&
   +HfxZpE*VS1(39,20)
VS0(61,35)=PAy*VS0(39,35)+WPy*VS1(39,35)+r1x2Z*VR1(39,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(62,21)=PAy*VS0(40,21)+WPy*VS1(40,21)+r1x2Z*VR1(40,21)&
   +4D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))
VS0(62,22)=PAy*VS0(40,22)+WPy*VS1(40,22)+r1x2Z*VR1(40,22)&
   +4D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +HfxZpE*VS1(40,11)
VS0(62,23)=PAy*VS0(40,23)+WPy*VS1(40,23)+r1x2Z*VR1(40,23)&
   +4D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(40,12)
VS0(62,24)=PAy*VS0(40,24)+WPy*VS1(40,24)+r1x2Z*VR1(40,24)&
   +4D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(40,13)
VS0(62,25)=PAy*VS0(40,25)+WPy*VS1(40,25)+r1x2Z*VR1(40,25)&
   +4D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))&
   +4D0*HfxZpE*VS1(40,14)
VS0(62,26)=PAy*VS0(40,26)+WPy*VS1(40,26)+r1x2Z*VR1(40,26)&
   +4D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))
VS0(62,27)=PAy*VS0(40,27)+WPy*VS1(40,27)+r1x2Z*VR1(40,27)&
   +4D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +HfxZpE*VS1(40,15)
VS0(62,28)=PAy*VS0(40,28)+WPy*VS1(40,28)+r1x2Z*VR1(40,28)&
   +4D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +2D0*HfxZpE*VS1(40,16)
VS0(62,29)=PAy*VS0(40,29)+WPy*VS1(40,29)+r1x2Z*VR1(40,29)&
   +4D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(40,17)
VS0(62,30)=PAy*VS0(40,30)+WPy*VS1(40,30)+r1x2Z*VR1(40,30)&
   +4D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))
VS0(62,31)=PAy*VS0(40,31)+WPy*VS1(40,31)+r1x2Z*VR1(40,31)&
   +4D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(40,18)
VS0(62,32)=PAy*VS0(40,32)+WPy*VS1(40,32)+r1x2Z*VR1(40,32)&
   +4D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))&
   +2D0*HfxZpE*VS1(40,19)
VS0(62,33)=PAy*VS0(40,33)+WPy*VS1(40,33)+r1x2Z*VR1(40,33)&
   +4D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))
VS0(62,34)=PAy*VS0(40,34)+WPy*VS1(40,34)+r1x2Z*VR1(40,34)&
   +4D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))&
   +HfxZpE*VS1(40,20)
VS0(62,35)=PAy*VS0(40,35)+WPy*VS1(40,35)+r1x2Z*VR1(40,35)&
   +4D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(63,21)=PAy*VS0(41,21)+WPy*VS1(41,21)+r1x2Z*VR1(41,21)&
   +5D0*r1x2Z*(VS0(25,21)-ExZpE*VS1(25,21))
VS0(63,22)=PAy*VS0(41,22)+WPy*VS1(41,22)+r1x2Z*VR1(41,22)&
   +5D0*r1x2Z*(VS0(25,22)-ExZpE*VS1(25,22))&
   +HfxZpE*VS1(41,11)
VS0(63,23)=PAy*VS0(41,23)+WPy*VS1(41,23)+r1x2Z*VR1(41,23)&
   +5D0*r1x2Z*(VS0(25,23)-ExZpE*VS1(25,23))&
   +2D0*HfxZpE*VS1(41,12)
VS0(63,24)=PAy*VS0(41,24)+WPy*VS1(41,24)+r1x2Z*VR1(41,24)&
   +5D0*r1x2Z*(VS0(25,24)-ExZpE*VS1(25,24))&
   +3D0*HfxZpE*VS1(41,13)
VS0(63,25)=PAy*VS0(41,25)+WPy*VS1(41,25)+r1x2Z*VR1(41,25)&
   +5D0*r1x2Z*(VS0(25,25)-ExZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(41,14)
VS0(63,26)=PAy*VS0(41,26)+WPy*VS1(41,26)+r1x2Z*VR1(41,26)&
   +5D0*r1x2Z*(VS0(25,26)-ExZpE*VS1(25,26))
VS0(63,27)=PAy*VS0(41,27)+WPy*VS1(41,27)+r1x2Z*VR1(41,27)&
   +5D0*r1x2Z*(VS0(25,27)-ExZpE*VS1(25,27))&
   +HfxZpE*VS1(41,15)
VS0(63,28)=PAy*VS0(41,28)+WPy*VS1(41,28)+r1x2Z*VR1(41,28)&
   +5D0*r1x2Z*(VS0(25,28)-ExZpE*VS1(25,28))&
   +2D0*HfxZpE*VS1(41,16)
VS0(63,29)=PAy*VS0(41,29)+WPy*VS1(41,29)+r1x2Z*VR1(41,29)&
   +5D0*r1x2Z*(VS0(25,29)-ExZpE*VS1(25,29))&
   +3D0*HfxZpE*VS1(41,17)
VS0(63,30)=PAy*VS0(41,30)+WPy*VS1(41,30)+r1x2Z*VR1(41,30)&
   +5D0*r1x2Z*(VS0(25,30)-ExZpE*VS1(25,30))
VS0(63,31)=PAy*VS0(41,31)+WPy*VS1(41,31)+r1x2Z*VR1(41,31)&
   +5D0*r1x2Z*(VS0(25,31)-ExZpE*VS1(25,31))&
   +HfxZpE*VS1(41,18)
VS0(63,32)=PAy*VS0(41,32)+WPy*VS1(41,32)+r1x2Z*VR1(41,32)&
   +5D0*r1x2Z*(VS0(25,32)-ExZpE*VS1(25,32))&
   +2D0*HfxZpE*VS1(41,19)
VS0(63,33)=PAy*VS0(41,33)+WPy*VS1(41,33)+r1x2Z*VR1(41,33)&
   +5D0*r1x2Z*(VS0(25,33)-ExZpE*VS1(25,33))
VS0(63,34)=PAy*VS0(41,34)+WPy*VS1(41,34)+r1x2Z*VR1(41,34)&
   +5D0*r1x2Z*(VS0(25,34)-ExZpE*VS1(25,34))&
   +HfxZpE*VS1(41,20)
VS0(63,35)=PAy*VS0(41,35)+WPy*VS1(41,35)+r1x2Z*VR1(41,35)&
   +5D0*r1x2Z*(VS0(25,35)-ExZpE*VS1(25,35))
VS0(64,21)=PAx*VS0(42,21)+WPx*VS1(42,21)&
   +4D0*r1x2Z*(VS0(26,21)-ExZpE*VS1(26,21))&
   +4D0*HfxZpE*VS1(42,11)
VS0(64,22)=PAx*VS0(42,22)+WPx*VS1(42,22)&
   +4D0*r1x2Z*(VS0(26,22)-ExZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(42,12)
VS0(64,23)=PAx*VS0(42,23)+WPx*VS1(42,23)&
   +4D0*r1x2Z*(VS0(26,23)-ExZpE*VS1(26,23))&
   +2D0*HfxZpE*VS1(42,13)
VS0(64,24)=PAx*VS0(42,24)+WPx*VS1(42,24)&
   +4D0*r1x2Z*(VS0(26,24)-ExZpE*VS1(26,24))&
   +HfxZpE*VS1(42,14)
VS0(64,25)=PAx*VS0(42,25)+WPx*VS1(42,25)&
   +4D0*r1x2Z*(VS0(26,25)-ExZpE*VS1(26,25))
VS0(64,26)=PAx*VS0(42,26)+WPx*VS1(42,26)&
   +4D0*r1x2Z*(VS0(26,26)-ExZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(42,15)
VS0(64,27)=PAx*VS0(42,27)+WPx*VS1(42,27)&
   +4D0*r1x2Z*(VS0(26,27)-ExZpE*VS1(26,27))&
   +2D0*HfxZpE*VS1(42,16)
VS0(64,28)=PAx*VS0(42,28)+WPx*VS1(42,28)&
   +4D0*r1x2Z*(VS0(26,28)-ExZpE*VS1(26,28))&
   +HfxZpE*VS1(42,17)
VS0(64,29)=PAx*VS0(42,29)+WPx*VS1(42,29)&
   +4D0*r1x2Z*(VS0(26,29)-ExZpE*VS1(26,29))
VS0(64,30)=PAx*VS0(42,30)+WPx*VS1(42,30)&
   +4D0*r1x2Z*(VS0(26,30)-ExZpE*VS1(26,30))&
   +2D0*HfxZpE*VS1(42,18)
VS0(64,31)=PAx*VS0(42,31)+WPx*VS1(42,31)&
   +4D0*r1x2Z*(VS0(26,31)-ExZpE*VS1(26,31))&
   +HfxZpE*VS1(42,19)
VS0(64,32)=PAx*VS0(42,32)+WPx*VS1(42,32)&
   +4D0*r1x2Z*(VS0(26,32)-ExZpE*VS1(26,32))
VS0(64,33)=PAx*VS0(42,33)+WPx*VS1(42,33)&
   +4D0*r1x2Z*(VS0(26,33)-ExZpE*VS1(26,33))&
   +HfxZpE*VS1(42,20)
VS0(64,34)=PAx*VS0(42,34)+WPx*VS1(42,34)&
   +4D0*r1x2Z*(VS0(26,34)-ExZpE*VS1(26,34))
VS0(64,35)=PAx*VS0(42,35)+WPx*VS1(42,35)&
   +4D0*r1x2Z*(VS0(26,35)-ExZpE*VS1(26,35))
VS0(65,21)=PAx*VS0(43,21)+WPx*VS1(43,21)&
   +3D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))&
   +4D0*HfxZpE*VS1(43,11)
VS0(65,22)=PAx*VS0(43,22)+WPx*VS1(43,22)&
   +3D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +3D0*HfxZpE*VS1(43,12)
VS0(65,23)=PAx*VS0(43,23)+WPx*VS1(43,23)&
   +3D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(43,13)
VS0(65,24)=PAx*VS0(43,24)+WPx*VS1(43,24)&
   +3D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +HfxZpE*VS1(43,14)
VS0(65,25)=PAx*VS0(43,25)+WPx*VS1(43,25)&
   +3D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(65,26)=PAx*VS0(43,26)+WPx*VS1(43,26)&
   +3D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +3D0*HfxZpE*VS1(43,15)
VS0(65,27)=PAx*VS0(43,27)+WPx*VS1(43,27)&
   +3D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(43,16)
VS0(65,28)=PAx*VS0(43,28)+WPx*VS1(43,28)&
   +3D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(43,17)
VS0(65,29)=PAx*VS0(43,29)+WPx*VS1(43,29)&
   +3D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))
VS0(65,30)=PAx*VS0(43,30)+WPx*VS1(43,30)&
   +3D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(43,18)
VS0(65,31)=PAx*VS0(43,31)+WPx*VS1(43,31)&
   +3D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(43,19)
VS0(65,32)=PAx*VS0(43,32)+WPx*VS1(43,32)&
   +3D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))
VS0(65,33)=PAx*VS0(43,33)+WPx*VS1(43,33)&
   +3D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +HfxZpE*VS1(43,20)
VS0(65,34)=PAx*VS0(43,34)+WPx*VS1(43,34)&
   +3D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))
VS0(65,35)=PAx*VS0(43,35)+WPx*VS1(43,35)&
   +3D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(66,21)=PAx*VS0(44,21)+WPx*VS1(44,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))&
   +4D0*HfxZpE*VS1(44,11)
VS0(66,22)=PAx*VS0(44,22)+WPx*VS1(44,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +3D0*HfxZpE*VS1(44,12)
VS0(66,23)=PAx*VS0(44,23)+WPx*VS1(44,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(44,13)
VS0(66,24)=PAx*VS0(44,24)+WPx*VS1(44,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +HfxZpE*VS1(44,14)
VS0(66,25)=PAx*VS0(44,25)+WPx*VS1(44,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(66,26)=PAx*VS0(44,26)+WPx*VS1(44,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +3D0*HfxZpE*VS1(44,15)
VS0(66,27)=PAx*VS0(44,27)+WPx*VS1(44,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(44,16)
VS0(66,28)=PAx*VS0(44,28)+WPx*VS1(44,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(44,17)
VS0(66,29)=PAx*VS0(44,29)+WPx*VS1(44,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))
VS0(66,30)=PAx*VS0(44,30)+WPx*VS1(44,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(44,18)
VS0(66,31)=PAx*VS0(44,31)+WPx*VS1(44,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(44,19)
VS0(66,32)=PAx*VS0(44,32)+WPx*VS1(44,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))
VS0(66,33)=PAx*VS0(44,33)+WPx*VS1(44,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +HfxZpE*VS1(44,20)
VS0(66,34)=PAx*VS0(44,34)+WPx*VS1(44,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))
VS0(66,35)=PAx*VS0(44,35)+WPx*VS1(44,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(67,21)=PAy*VS0(44,21)+WPy*VS1(44,21)+r1x2Z*VR1(44,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(67,22)=PAy*VS0(44,22)+WPy*VS1(44,22)+r1x2Z*VR1(44,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +HfxZpE*VS1(44,11)
VS0(67,23)=PAy*VS0(44,23)+WPy*VS1(44,23)+r1x2Z*VR1(44,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(44,12)
VS0(67,24)=PAy*VS0(44,24)+WPy*VS1(44,24)+r1x2Z*VR1(44,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +3D0*HfxZpE*VS1(44,13)
VS0(67,25)=PAy*VS0(44,25)+WPy*VS1(44,25)+r1x2Z*VR1(44,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))&
   +4D0*HfxZpE*VS1(44,14)
VS0(67,26)=PAy*VS0(44,26)+WPy*VS1(44,26)+r1x2Z*VR1(44,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))
VS0(67,27)=PAy*VS0(44,27)+WPy*VS1(44,27)+r1x2Z*VR1(44,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(44,15)
VS0(67,28)=PAy*VS0(44,28)+WPy*VS1(44,28)+r1x2Z*VR1(44,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(44,16)
VS0(67,29)=PAy*VS0(44,29)+WPy*VS1(44,29)+r1x2Z*VR1(44,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +3D0*HfxZpE*VS1(44,17)
VS0(67,30)=PAy*VS0(44,30)+WPy*VS1(44,30)+r1x2Z*VR1(44,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))
VS0(67,31)=PAy*VS0(44,31)+WPy*VS1(44,31)+r1x2Z*VR1(44,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(44,18)
VS0(67,32)=PAy*VS0(44,32)+WPy*VS1(44,32)+r1x2Z*VR1(44,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(44,19)
VS0(67,33)=PAy*VS0(44,33)+WPy*VS1(44,33)+r1x2Z*VR1(44,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))
VS0(67,34)=PAy*VS0(44,34)+WPy*VS1(44,34)+r1x2Z*VR1(44,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +HfxZpE*VS1(44,20)
VS0(67,35)=PAy*VS0(44,35)+WPy*VS1(44,35)+r1x2Z*VR1(44,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(68,21)=PAy*VS0(45,21)+WPy*VS1(45,21)+r1x2Z*VR1(45,21)&
   +3D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(68,22)=PAy*VS0(45,22)+WPy*VS1(45,22)+r1x2Z*VR1(45,22)&
   +3D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +HfxZpE*VS1(45,11)
VS0(68,23)=PAy*VS0(45,23)+WPy*VS1(45,23)+r1x2Z*VR1(45,23)&
   +3D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(45,12)
VS0(68,24)=PAy*VS0(45,24)+WPy*VS1(45,24)+r1x2Z*VR1(45,24)&
   +3D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +3D0*HfxZpE*VS1(45,13)
VS0(68,25)=PAy*VS0(45,25)+WPy*VS1(45,25)+r1x2Z*VR1(45,25)&
   +3D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))&
   +4D0*HfxZpE*VS1(45,14)
VS0(68,26)=PAy*VS0(45,26)+WPy*VS1(45,26)+r1x2Z*VR1(45,26)&
   +3D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))
VS0(68,27)=PAy*VS0(45,27)+WPy*VS1(45,27)+r1x2Z*VR1(45,27)&
   +3D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(45,15)
VS0(68,28)=PAy*VS0(45,28)+WPy*VS1(45,28)+r1x2Z*VR1(45,28)&
   +3D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(45,16)
VS0(68,29)=PAy*VS0(45,29)+WPy*VS1(45,29)+r1x2Z*VR1(45,29)&
   +3D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +3D0*HfxZpE*VS1(45,17)
VS0(68,30)=PAy*VS0(45,30)+WPy*VS1(45,30)+r1x2Z*VR1(45,30)&
   +3D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))
VS0(68,31)=PAy*VS0(45,31)+WPy*VS1(45,31)+r1x2Z*VR1(45,31)&
   +3D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(45,18)
VS0(68,32)=PAy*VS0(45,32)+WPy*VS1(45,32)+r1x2Z*VR1(45,32)&
   +3D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(45,19)
VS0(68,33)=PAy*VS0(45,33)+WPy*VS1(45,33)+r1x2Z*VR1(45,33)&
   +3D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))
VS0(68,34)=PAy*VS0(45,34)+WPy*VS1(45,34)+r1x2Z*VR1(45,34)&
   +3D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +HfxZpE*VS1(45,20)
VS0(68,35)=PAy*VS0(45,35)+WPy*VS1(45,35)+r1x2Z*VR1(45,35)&
   +3D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(69,21)=PAy*VS0(46,21)+WPy*VS1(46,21)+r1x2Z*VR1(46,21)&
   +4D0*r1x2Z*(VS0(29,21)-ExZpE*VS1(29,21))
VS0(69,22)=PAy*VS0(46,22)+WPy*VS1(46,22)+r1x2Z*VR1(46,22)&
   +4D0*r1x2Z*(VS0(29,22)-ExZpE*VS1(29,22))&
   +HfxZpE*VS1(46,11)
VS0(69,23)=PAy*VS0(46,23)+WPy*VS1(46,23)+r1x2Z*VR1(46,23)&
   +4D0*r1x2Z*(VS0(29,23)-ExZpE*VS1(29,23))&
   +2D0*HfxZpE*VS1(46,12)
VS0(69,24)=PAy*VS0(46,24)+WPy*VS1(46,24)+r1x2Z*VR1(46,24)&
   +4D0*r1x2Z*(VS0(29,24)-ExZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(46,13)
VS0(69,25)=PAy*VS0(46,25)+WPy*VS1(46,25)+r1x2Z*VR1(46,25)&
   +4D0*r1x2Z*(VS0(29,25)-ExZpE*VS1(29,25))&
   +4D0*HfxZpE*VS1(46,14)
VS0(69,26)=PAy*VS0(46,26)+WPy*VS1(46,26)+r1x2Z*VR1(46,26)&
   +4D0*r1x2Z*(VS0(29,26)-ExZpE*VS1(29,26))
VS0(69,27)=PAy*VS0(46,27)+WPy*VS1(46,27)+r1x2Z*VR1(46,27)&
   +4D0*r1x2Z*(VS0(29,27)-ExZpE*VS1(29,27))&
   +HfxZpE*VS1(46,15)
VS0(69,28)=PAy*VS0(46,28)+WPy*VS1(46,28)+r1x2Z*VR1(46,28)&
   +4D0*r1x2Z*(VS0(29,28)-ExZpE*VS1(29,28))&
   +2D0*HfxZpE*VS1(46,16)
VS0(69,29)=PAy*VS0(46,29)+WPy*VS1(46,29)+r1x2Z*VR1(46,29)&
   +4D0*r1x2Z*(VS0(29,29)-ExZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(46,17)
VS0(69,30)=PAy*VS0(46,30)+WPy*VS1(46,30)+r1x2Z*VR1(46,30)&
   +4D0*r1x2Z*(VS0(29,30)-ExZpE*VS1(29,30))
VS0(69,31)=PAy*VS0(46,31)+WPy*VS1(46,31)+r1x2Z*VR1(46,31)&
   +4D0*r1x2Z*(VS0(29,31)-ExZpE*VS1(29,31))&
   +HfxZpE*VS1(46,18)
VS0(69,32)=PAy*VS0(46,32)+WPy*VS1(46,32)+r1x2Z*VR1(46,32)&
   +4D0*r1x2Z*(VS0(29,32)-ExZpE*VS1(29,32))&
   +2D0*HfxZpE*VS1(46,19)
VS0(69,33)=PAy*VS0(46,33)+WPy*VS1(46,33)+r1x2Z*VR1(46,33)&
   +4D0*r1x2Z*(VS0(29,33)-ExZpE*VS1(29,33))
VS0(69,34)=PAy*VS0(46,34)+WPy*VS1(46,34)+r1x2Z*VR1(46,34)&
   +4D0*r1x2Z*(VS0(29,34)-ExZpE*VS1(29,34))&
   +HfxZpE*VS1(46,20)
VS0(69,35)=PAy*VS0(46,35)+WPy*VS1(46,35)+r1x2Z*VR1(46,35)&
   +4D0*r1x2Z*(VS0(29,35)-ExZpE*VS1(29,35))
VS0(70,21)=PAx*VS0(47,21)+WPx*VS1(47,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))&
   +4D0*HfxZpE*VS1(47,11)
VS0(70,22)=PAx*VS0(47,22)+WPx*VS1(47,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))&
   +3D0*HfxZpE*VS1(47,12)
VS0(70,23)=PAx*VS0(47,23)+WPx*VS1(47,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(47,13)
VS0(70,24)=PAx*VS0(47,24)+WPx*VS1(47,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))&
   +HfxZpE*VS1(47,14)
VS0(70,25)=PAx*VS0(47,25)+WPx*VS1(47,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(70,26)=PAx*VS0(47,26)+WPx*VS1(47,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +3D0*HfxZpE*VS1(47,15)
VS0(70,27)=PAx*VS0(47,27)+WPx*VS1(47,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(47,16)
VS0(70,28)=PAx*VS0(47,28)+WPx*VS1(47,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(47,17)
VS0(70,29)=PAx*VS0(47,29)+WPx*VS1(47,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))
VS0(70,30)=PAx*VS0(47,30)+WPx*VS1(47,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(47,18)
VS0(70,31)=PAx*VS0(47,31)+WPx*VS1(47,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +HfxZpE*VS1(47,19)
VS0(70,32)=PAx*VS0(47,32)+WPx*VS1(47,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))
VS0(70,33)=PAx*VS0(47,33)+WPx*VS1(47,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +HfxZpE*VS1(47,20)
VS0(70,34)=PAx*VS0(47,34)+WPx*VS1(47,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))
VS0(70,35)=PAx*VS0(47,35)+WPx*VS1(47,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))
VS0(71,21)=PAx*VS0(48,21)+WPx*VS1(48,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))&
   +4D0*HfxZpE*VS1(48,11)
VS0(71,22)=PAx*VS0(48,22)+WPx*VS1(48,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +3D0*HfxZpE*VS1(48,12)
VS0(71,23)=PAx*VS0(48,23)+WPx*VS1(48,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(48,13)
VS0(71,24)=PAx*VS0(48,24)+WPx*VS1(48,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +HfxZpE*VS1(48,14)
VS0(71,25)=PAx*VS0(48,25)+WPx*VS1(48,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(71,26)=PAx*VS0(48,26)+WPx*VS1(48,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +3D0*HfxZpE*VS1(48,15)
VS0(71,27)=PAx*VS0(48,27)+WPx*VS1(48,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(48,16)
VS0(71,28)=PAx*VS0(48,28)+WPx*VS1(48,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(48,17)
VS0(71,29)=PAx*VS0(48,29)+WPx*VS1(48,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))
VS0(71,30)=PAx*VS0(48,30)+WPx*VS1(48,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(48,18)
VS0(71,31)=PAx*VS0(48,31)+WPx*VS1(48,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(48,19)
VS0(71,32)=PAx*VS0(48,32)+WPx*VS1(48,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))
VS0(71,33)=PAx*VS0(48,33)+WPx*VS1(48,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +HfxZpE*VS1(48,20)
VS0(71,34)=PAx*VS0(48,34)+WPx*VS1(48,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))
VS0(71,35)=PAx*VS0(48,35)+WPx*VS1(48,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(72,21)=PAx*VS0(49,21)+WPx*VS1(49,21)&
   +r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))&
   +4D0*HfxZpE*VS1(49,11)
VS0(72,22)=PAx*VS0(49,22)+WPx*VS1(49,22)&
   +r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +3D0*HfxZpE*VS1(49,12)
VS0(72,23)=PAx*VS0(49,23)+WPx*VS1(49,23)&
   +r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(49,13)
VS0(72,24)=PAx*VS0(49,24)+WPx*VS1(49,24)&
   +r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +HfxZpE*VS1(49,14)
VS0(72,25)=PAx*VS0(49,25)+WPx*VS1(49,25)&
   +r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(72,26)=PAx*VS0(49,26)+WPx*VS1(49,26)&
   +r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +3D0*HfxZpE*VS1(49,15)
VS0(72,27)=PAx*VS0(49,27)+WPx*VS1(49,27)&
   +r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(49,16)
VS0(72,28)=PAx*VS0(49,28)+WPx*VS1(49,28)&
   +r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(49,17)
VS0(72,29)=PAx*VS0(49,29)+WPx*VS1(49,29)&
   +r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))
VS0(72,30)=PAx*VS0(49,30)+WPx*VS1(49,30)&
   +r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(49,18)
VS0(72,31)=PAx*VS0(49,31)+WPx*VS1(49,31)&
   +r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(49,19)
VS0(72,32)=PAx*VS0(49,32)+WPx*VS1(49,32)&
   +r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))
VS0(72,33)=PAx*VS0(49,33)+WPx*VS1(49,33)&
   +r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +HfxZpE*VS1(49,20)
VS0(72,34)=PAx*VS0(49,34)+WPx*VS1(49,34)&
   +r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))
VS0(72,35)=PAx*VS0(49,35)+WPx*VS1(49,35)&
   +r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(73,21)=PAy*VS0(49,21)+WPy*VS1(49,21)+r1x2Z*VR1(49,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(73,22)=PAy*VS0(49,22)+WPy*VS1(49,22)+r1x2Z*VR1(49,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +HfxZpE*VS1(49,11)
VS0(73,23)=PAy*VS0(49,23)+WPy*VS1(49,23)+r1x2Z*VR1(49,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(49,12)
VS0(73,24)=PAy*VS0(49,24)+WPy*VS1(49,24)+r1x2Z*VR1(49,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +3D0*HfxZpE*VS1(49,13)
VS0(73,25)=PAy*VS0(49,25)+WPy*VS1(49,25)+r1x2Z*VR1(49,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))&
   +4D0*HfxZpE*VS1(49,14)
VS0(73,26)=PAy*VS0(49,26)+WPy*VS1(49,26)+r1x2Z*VR1(49,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))
VS0(73,27)=PAy*VS0(49,27)+WPy*VS1(49,27)+r1x2Z*VR1(49,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(49,15)
VS0(73,28)=PAy*VS0(49,28)+WPy*VS1(49,28)+r1x2Z*VR1(49,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(49,16)
VS0(73,29)=PAy*VS0(49,29)+WPy*VS1(49,29)+r1x2Z*VR1(49,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +3D0*HfxZpE*VS1(49,17)
VS0(73,30)=PAy*VS0(49,30)+WPy*VS1(49,30)+r1x2Z*VR1(49,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))
VS0(73,31)=PAy*VS0(49,31)+WPy*VS1(49,31)+r1x2Z*VR1(49,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(49,18)
VS0(73,32)=PAy*VS0(49,32)+WPy*VS1(49,32)+r1x2Z*VR1(49,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(49,19)
VS0(73,33)=PAy*VS0(49,33)+WPy*VS1(49,33)+r1x2Z*VR1(49,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))
VS0(73,34)=PAy*VS0(49,34)+WPy*VS1(49,34)+r1x2Z*VR1(49,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +HfxZpE*VS1(49,20)
VS0(73,35)=PAy*VS0(49,35)+WPy*VS1(49,35)+r1x2Z*VR1(49,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(74,21)=PAy*VS0(50,21)+WPy*VS1(50,21)+r1x2Z*VR1(50,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(74,22)=PAy*VS0(50,22)+WPy*VS1(50,22)+r1x2Z*VR1(50,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +HfxZpE*VS1(50,11)
VS0(74,23)=PAy*VS0(50,23)+WPy*VS1(50,23)+r1x2Z*VR1(50,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(50,12)
VS0(74,24)=PAy*VS0(50,24)+WPy*VS1(50,24)+r1x2Z*VR1(50,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +3D0*HfxZpE*VS1(50,13)
VS0(74,25)=PAy*VS0(50,25)+WPy*VS1(50,25)+r1x2Z*VR1(50,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))&
   +4D0*HfxZpE*VS1(50,14)
VS0(74,26)=PAy*VS0(50,26)+WPy*VS1(50,26)+r1x2Z*VR1(50,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))
VS0(74,27)=PAy*VS0(50,27)+WPy*VS1(50,27)+r1x2Z*VR1(50,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(50,15)
VS0(74,28)=PAy*VS0(50,28)+WPy*VS1(50,28)+r1x2Z*VR1(50,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(50,16)
VS0(74,29)=PAy*VS0(50,29)+WPy*VS1(50,29)+r1x2Z*VR1(50,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +3D0*HfxZpE*VS1(50,17)
VS0(74,30)=PAy*VS0(50,30)+WPy*VS1(50,30)+r1x2Z*VR1(50,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))
VS0(74,31)=PAy*VS0(50,31)+WPy*VS1(50,31)+r1x2Z*VR1(50,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(50,18)
VS0(74,32)=PAy*VS0(50,32)+WPy*VS1(50,32)+r1x2Z*VR1(50,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(50,19)
VS0(74,33)=PAy*VS0(50,33)+WPy*VS1(50,33)+r1x2Z*VR1(50,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))
VS0(74,34)=PAy*VS0(50,34)+WPy*VS1(50,34)+r1x2Z*VR1(50,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +HfxZpE*VS1(50,20)
VS0(74,35)=PAy*VS0(50,35)+WPy*VS1(50,35)+r1x2Z*VR1(50,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(75,21)=PAx*VS0(51,21)+WPx*VS1(51,21)&
   +2D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))&
   +4D0*HfxZpE*VS1(51,11)
VS0(75,22)=PAx*VS0(51,22)+WPx*VS1(51,22)&
   +2D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))&
   +3D0*HfxZpE*VS1(51,12)
VS0(75,23)=PAx*VS0(51,23)+WPx*VS1(51,23)&
   +2D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))&
   +2D0*HfxZpE*VS1(51,13)
VS0(75,24)=PAx*VS0(51,24)+WPx*VS1(51,24)&
   +2D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))&
   +HfxZpE*VS1(51,14)
VS0(75,25)=PAx*VS0(51,25)+WPx*VS1(51,25)&
   +2D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(75,26)=PAx*VS0(51,26)+WPx*VS1(51,26)&
   +2D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +3D0*HfxZpE*VS1(51,15)
VS0(75,27)=PAx*VS0(51,27)+WPx*VS1(51,27)&
   +2D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +2D0*HfxZpE*VS1(51,16)
VS0(75,28)=PAx*VS0(51,28)+WPx*VS1(51,28)&
   +2D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(51,17)
VS0(75,29)=PAx*VS0(51,29)+WPx*VS1(51,29)&
   +2D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))
VS0(75,30)=PAx*VS0(51,30)+WPx*VS1(51,30)&
   +2D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(51,18)
VS0(75,31)=PAx*VS0(51,31)+WPx*VS1(51,31)&
   +2D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +HfxZpE*VS1(51,19)
VS0(75,32)=PAx*VS0(51,32)+WPx*VS1(51,32)&
   +2D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))
VS0(75,33)=PAx*VS0(51,33)+WPx*VS1(51,33)&
   +2D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +HfxZpE*VS1(51,20)
VS0(75,34)=PAx*VS0(51,34)+WPx*VS1(51,34)&
   +2D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))
VS0(75,35)=PAx*VS0(51,35)+WPx*VS1(51,35)&
   +2D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))
VS0(76,21)=PAz*VS0(48,21)+WPz*VS1(48,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(76,22)=PAz*VS0(48,22)+WPz*VS1(48,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))
VS0(76,23)=PAz*VS0(48,23)+WPz*VS1(48,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))
VS0(76,24)=PAz*VS0(48,24)+WPz*VS1(48,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))
VS0(76,25)=PAz*VS0(48,25)+WPz*VS1(48,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(76,26)=PAz*VS0(48,26)+WPz*VS1(48,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +HfxZpE*VS1(48,11)
VS0(76,27)=PAz*VS0(48,27)+WPz*VS1(48,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(48,12)
VS0(76,28)=PAz*VS0(48,28)+WPz*VS1(48,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(48,13)
VS0(76,29)=PAz*VS0(48,29)+WPz*VS1(48,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +HfxZpE*VS1(48,14)
VS0(76,30)=PAz*VS0(48,30)+WPz*VS1(48,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(48,15)
VS0(76,31)=PAz*VS0(48,31)+WPz*VS1(48,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(48,16)
VS0(76,32)=PAz*VS0(48,32)+WPz*VS1(48,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(48,17)
VS0(76,33)=PAz*VS0(48,33)+WPz*VS1(48,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +3D0*HfxZpE*VS1(48,18)
VS0(76,34)=PAz*VS0(48,34)+WPz*VS1(48,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +3D0*HfxZpE*VS1(48,19)
VS0(76,35)=PAz*VS0(48,35)+WPz*VS1(48,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))&
   +4D0*HfxZpE*VS1(48,20)
VS0(77,21)=PAz*VS0(49,21)+WPz*VS1(49,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(77,22)=PAz*VS0(49,22)+WPz*VS1(49,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))
VS0(77,23)=PAz*VS0(49,23)+WPz*VS1(49,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))
VS0(77,24)=PAz*VS0(49,24)+WPz*VS1(49,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))
VS0(77,25)=PAz*VS0(49,25)+WPz*VS1(49,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(77,26)=PAz*VS0(49,26)+WPz*VS1(49,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +HfxZpE*VS1(49,11)
VS0(77,27)=PAz*VS0(49,27)+WPz*VS1(49,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(49,12)
VS0(77,28)=PAz*VS0(49,28)+WPz*VS1(49,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(49,13)
VS0(77,29)=PAz*VS0(49,29)+WPz*VS1(49,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +HfxZpE*VS1(49,14)
VS0(77,30)=PAz*VS0(49,30)+WPz*VS1(49,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(49,15)
VS0(77,31)=PAz*VS0(49,31)+WPz*VS1(49,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(49,16)
VS0(77,32)=PAz*VS0(49,32)+WPz*VS1(49,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(49,17)
VS0(77,33)=PAz*VS0(49,33)+WPz*VS1(49,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +3D0*HfxZpE*VS1(49,18)
VS0(77,34)=PAz*VS0(49,34)+WPz*VS1(49,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +3D0*HfxZpE*VS1(49,19)
VS0(77,35)=PAz*VS0(49,35)+WPz*VS1(49,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))&
   +4D0*HfxZpE*VS1(49,20)
VS0(78,21)=PAy*VS0(53,21)+WPy*VS1(53,21)+r1x2Z*VR1(53,21)&
   +2D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(78,22)=PAy*VS0(53,22)+WPy*VS1(53,22)+r1x2Z*VR1(53,22)&
   +2D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))&
   +HfxZpE*VS1(53,11)
VS0(78,23)=PAy*VS0(53,23)+WPy*VS1(53,23)+r1x2Z*VR1(53,23)&
   +2D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))&
   +2D0*HfxZpE*VS1(53,12)
VS0(78,24)=PAy*VS0(53,24)+WPy*VS1(53,24)+r1x2Z*VR1(53,24)&
   +2D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))&
   +3D0*HfxZpE*VS1(53,13)
VS0(78,25)=PAy*VS0(53,25)+WPy*VS1(53,25)+r1x2Z*VR1(53,25)&
   +2D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))&
   +4D0*HfxZpE*VS1(53,14)
VS0(78,26)=PAy*VS0(53,26)+WPy*VS1(53,26)+r1x2Z*VR1(53,26)&
   +2D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))
VS0(78,27)=PAy*VS0(53,27)+WPy*VS1(53,27)+r1x2Z*VR1(53,27)&
   +2D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(53,15)
VS0(78,28)=PAy*VS0(53,28)+WPy*VS1(53,28)+r1x2Z*VR1(53,28)&
   +2D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +2D0*HfxZpE*VS1(53,16)
VS0(78,29)=PAy*VS0(53,29)+WPy*VS1(53,29)+r1x2Z*VR1(53,29)&
   +2D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +3D0*HfxZpE*VS1(53,17)
VS0(78,30)=PAy*VS0(53,30)+WPy*VS1(53,30)+r1x2Z*VR1(53,30)&
   +2D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))
VS0(78,31)=PAy*VS0(53,31)+WPy*VS1(53,31)+r1x2Z*VR1(53,31)&
   +2D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +HfxZpE*VS1(53,18)
VS0(78,32)=PAy*VS0(53,32)+WPy*VS1(53,32)+r1x2Z*VR1(53,32)&
   +2D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(53,19)
VS0(78,33)=PAy*VS0(53,33)+WPy*VS1(53,33)+r1x2Z*VR1(53,33)&
   +2D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))
VS0(78,34)=PAy*VS0(53,34)+WPy*VS1(53,34)+r1x2Z*VR1(53,34)&
   +2D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +HfxZpE*VS1(53,20)
VS0(78,35)=PAy*VS0(53,35)+WPy*VS1(53,35)+r1x2Z*VR1(53,35)&
   +2D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))
VS0(79,21)=PAz*VS0(51,21)+WPz*VS1(51,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))
VS0(79,22)=PAz*VS0(51,22)+WPz*VS1(51,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))
VS0(79,23)=PAz*VS0(51,23)+WPz*VS1(51,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))
VS0(79,24)=PAz*VS0(51,24)+WPz*VS1(51,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))
VS0(79,25)=PAz*VS0(51,25)+WPz*VS1(51,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(79,26)=PAz*VS0(51,26)+WPz*VS1(51,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +HfxZpE*VS1(51,11)
VS0(79,27)=PAz*VS0(51,27)+WPz*VS1(51,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +HfxZpE*VS1(51,12)
VS0(79,28)=PAz*VS0(51,28)+WPz*VS1(51,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(51,13)
VS0(79,29)=PAz*VS0(51,29)+WPz*VS1(51,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))&
   +HfxZpE*VS1(51,14)
VS0(79,30)=PAz*VS0(51,30)+WPz*VS1(51,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(51,15)
VS0(79,31)=PAz*VS0(51,31)+WPz*VS1(51,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(51,16)
VS0(79,32)=PAz*VS0(51,32)+WPz*VS1(51,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(51,17)
VS0(79,33)=PAz*VS0(51,33)+WPz*VS1(51,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +3D0*HfxZpE*VS1(51,18)
VS0(79,34)=PAz*VS0(51,34)+WPz*VS1(51,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))&
   +3D0*HfxZpE*VS1(51,19)
VS0(79,35)=PAz*VS0(51,35)+WPz*VS1(51,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))&
   +4D0*HfxZpE*VS1(51,20)
VS0(80,21)=PAz*VS0(52,21)+WPz*VS1(52,21)&
   +3D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(80,22)=PAz*VS0(52,22)+WPz*VS1(52,22)&
   +3D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))
VS0(80,23)=PAz*VS0(52,23)+WPz*VS1(52,23)&
   +3D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))
VS0(80,24)=PAz*VS0(52,24)+WPz*VS1(52,24)&
   +3D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))
VS0(80,25)=PAz*VS0(52,25)+WPz*VS1(52,25)&
   +3D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(80,26)=PAz*VS0(52,26)+WPz*VS1(52,26)&
   +3D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +HfxZpE*VS1(52,11)
VS0(80,27)=PAz*VS0(52,27)+WPz*VS1(52,27)&
   +3D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(52,12)
VS0(80,28)=PAz*VS0(52,28)+WPz*VS1(52,28)&
   +3D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(52,13)
VS0(80,29)=PAz*VS0(52,29)+WPz*VS1(52,29)&
   +3D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +HfxZpE*VS1(52,14)
VS0(80,30)=PAz*VS0(52,30)+WPz*VS1(52,30)&
   +3D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(52,15)
VS0(80,31)=PAz*VS0(52,31)+WPz*VS1(52,31)&
   +3D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(52,16)
VS0(80,32)=PAz*VS0(52,32)+WPz*VS1(52,32)&
   +3D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(52,17)
VS0(80,33)=PAz*VS0(52,33)+WPz*VS1(52,33)&
   +3D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +3D0*HfxZpE*VS1(52,18)
VS0(80,34)=PAz*VS0(52,34)+WPz*VS1(52,34)&
   +3D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +3D0*HfxZpE*VS1(52,19)
VS0(80,35)=PAz*VS0(52,35)+WPz*VS1(52,35)&
   +3D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))&
   +4D0*HfxZpE*VS1(52,20)
VS0(81,21)=PAz*VS0(53,21)+WPz*VS1(53,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(81,22)=PAz*VS0(53,22)+WPz*VS1(53,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))
VS0(81,23)=PAz*VS0(53,23)+WPz*VS1(53,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))
VS0(81,24)=PAz*VS0(53,24)+WPz*VS1(53,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))
VS0(81,25)=PAz*VS0(53,25)+WPz*VS1(53,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(81,26)=PAz*VS0(53,26)+WPz*VS1(53,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +HfxZpE*VS1(53,11)
VS0(81,27)=PAz*VS0(53,27)+WPz*VS1(53,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(53,12)
VS0(81,28)=PAz*VS0(53,28)+WPz*VS1(53,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(53,13)
VS0(81,29)=PAz*VS0(53,29)+WPz*VS1(53,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +HfxZpE*VS1(53,14)
VS0(81,30)=PAz*VS0(53,30)+WPz*VS1(53,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(53,15)
VS0(81,31)=PAz*VS0(53,31)+WPz*VS1(53,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(53,16)
VS0(81,32)=PAz*VS0(53,32)+WPz*VS1(53,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(53,17)
VS0(81,33)=PAz*VS0(53,33)+WPz*VS1(53,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +3D0*HfxZpE*VS1(53,18)
VS0(81,34)=PAz*VS0(53,34)+WPz*VS1(53,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +3D0*HfxZpE*VS1(53,19)
VS0(81,35)=PAz*VS0(53,35)+WPz*VS1(53,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))&
   +4D0*HfxZpE*VS1(53,20)
VS0(82,21)=PAz*VS0(54,21)+WPz*VS1(54,21)&
   +4D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))
VS0(82,22)=PAz*VS0(54,22)+WPz*VS1(54,22)&
   +4D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))
VS0(82,23)=PAz*VS0(54,23)+WPz*VS1(54,23)&
   +4D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))
VS0(82,24)=PAz*VS0(54,24)+WPz*VS1(54,24)&
   +4D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))
VS0(82,25)=PAz*VS0(54,25)+WPz*VS1(54,25)&
   +4D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(82,26)=PAz*VS0(54,26)+WPz*VS1(54,26)&
   +4D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +HfxZpE*VS1(54,11)
VS0(82,27)=PAz*VS0(54,27)+WPz*VS1(54,27)&
   +4D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +HfxZpE*VS1(54,12)
VS0(82,28)=PAz*VS0(54,28)+WPz*VS1(54,28)&
   +4D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(54,13)
VS0(82,29)=PAz*VS0(54,29)+WPz*VS1(54,29)&
   +4D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))&
   +HfxZpE*VS1(54,14)
VS0(82,30)=PAz*VS0(54,30)+WPz*VS1(54,30)&
   +4D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(54,15)
VS0(82,31)=PAz*VS0(54,31)+WPz*VS1(54,31)&
   +4D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +2D0*HfxZpE*VS1(54,16)
VS0(82,32)=PAz*VS0(54,32)+WPz*VS1(54,32)&
   +4D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))&
   +2D0*HfxZpE*VS1(54,17)
VS0(82,33)=PAz*VS0(54,33)+WPz*VS1(54,33)&
   +4D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(54,18)
VS0(82,34)=PAz*VS0(54,34)+WPz*VS1(54,34)&
   +4D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(54,19)
VS0(82,35)=PAz*VS0(54,35)+WPz*VS1(54,35)&
   +4D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))&
   +4D0*HfxZpE*VS1(54,20)
VS0(83,21)=PAz*VS0(55,21)+WPz*VS1(55,21)&
   +4D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(83,22)=PAz*VS0(55,22)+WPz*VS1(55,22)&
   +4D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))
VS0(83,23)=PAz*VS0(55,23)+WPz*VS1(55,23)&
   +4D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))
VS0(83,24)=PAz*VS0(55,24)+WPz*VS1(55,24)&
   +4D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))
VS0(83,25)=PAz*VS0(55,25)+WPz*VS1(55,25)&
   +4D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))
VS0(83,26)=PAz*VS0(55,26)+WPz*VS1(55,26)&
   +4D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))&
   +HfxZpE*VS1(55,11)
VS0(83,27)=PAz*VS0(55,27)+WPz*VS1(55,27)&
   +4D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(55,12)
VS0(83,28)=PAz*VS0(55,28)+WPz*VS1(55,28)&
   +4D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +HfxZpE*VS1(55,13)
VS0(83,29)=PAz*VS0(55,29)+WPz*VS1(55,29)&
   +4D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +HfxZpE*VS1(55,14)
VS0(83,30)=PAz*VS0(55,30)+WPz*VS1(55,30)&
   +4D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))&
   +2D0*HfxZpE*VS1(55,15)
VS0(83,31)=PAz*VS0(55,31)+WPz*VS1(55,31)&
   +4D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +2D0*HfxZpE*VS1(55,16)
VS0(83,32)=PAz*VS0(55,32)+WPz*VS1(55,32)&
   +4D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(55,17)
VS0(83,33)=PAz*VS0(55,33)+WPz*VS1(55,33)&
   +4D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(55,18)
VS0(83,34)=PAz*VS0(55,34)+WPz*VS1(55,34)&
   +4D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(55,19)
VS0(83,35)=PAz*VS0(55,35)+WPz*VS1(55,35)&
   +4D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))&
   +4D0*HfxZpE*VS1(55,20)
VS0(84,21)=PAz*VS0(56,21)+WPz*VS1(56,21)&
   +5D0*r1x2Z*(VS0(35,21)-ExZpE*VS1(35,21))
VS0(84,22)=PAz*VS0(56,22)+WPz*VS1(56,22)&
   +5D0*r1x2Z*(VS0(35,22)-ExZpE*VS1(35,22))
VS0(84,23)=PAz*VS0(56,23)+WPz*VS1(56,23)&
   +5D0*r1x2Z*(VS0(35,23)-ExZpE*VS1(35,23))
VS0(84,24)=PAz*VS0(56,24)+WPz*VS1(56,24)&
   +5D0*r1x2Z*(VS0(35,24)-ExZpE*VS1(35,24))
VS0(84,25)=PAz*VS0(56,25)+WPz*VS1(56,25)&
   +5D0*r1x2Z*(VS0(35,25)-ExZpE*VS1(35,25))
VS0(84,26)=PAz*VS0(56,26)+WPz*VS1(56,26)&
   +5D0*r1x2Z*(VS0(35,26)-ExZpE*VS1(35,26))&
   +HfxZpE*VS1(56,11)
VS0(84,27)=PAz*VS0(56,27)+WPz*VS1(56,27)&
   +5D0*r1x2Z*(VS0(35,27)-ExZpE*VS1(35,27))&
   +HfxZpE*VS1(56,12)
VS0(84,28)=PAz*VS0(56,28)+WPz*VS1(56,28)&
   +5D0*r1x2Z*(VS0(35,28)-ExZpE*VS1(35,28))&
   +HfxZpE*VS1(56,13)
VS0(84,29)=PAz*VS0(56,29)+WPz*VS1(56,29)&
   +5D0*r1x2Z*(VS0(35,29)-ExZpE*VS1(35,29))&
   +HfxZpE*VS1(56,14)
VS0(84,30)=PAz*VS0(56,30)+WPz*VS1(56,30)&
   +5D0*r1x2Z*(VS0(35,30)-ExZpE*VS1(35,30))&
   +2D0*HfxZpE*VS1(56,15)
VS0(84,31)=PAz*VS0(56,31)+WPz*VS1(56,31)&
   +5D0*r1x2Z*(VS0(35,31)-ExZpE*VS1(35,31))&
   +2D0*HfxZpE*VS1(56,16)
VS0(84,32)=PAz*VS0(56,32)+WPz*VS1(56,32)&
   +5D0*r1x2Z*(VS0(35,32)-ExZpE*VS1(35,32))&
   +2D0*HfxZpE*VS1(56,17)
VS0(84,33)=PAz*VS0(56,33)+WPz*VS1(56,33)&
   +5D0*r1x2Z*(VS0(35,33)-ExZpE*VS1(35,33))&
   +3D0*HfxZpE*VS1(56,18)
VS0(84,34)=PAz*VS0(56,34)+WPz*VS1(56,34)&
   +5D0*r1x2Z*(VS0(35,34)-ExZpE*VS1(35,34))&
   +3D0*HfxZpE*VS1(56,19)
VS0(84,35)=PAz*VS0(56,35)+WPz*VS1(56,35)&
   +5D0*r1x2Z*(VS0(35,35)-ExZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(56,20)
CASE(3)
VS0(57,21)=PAx*VS0(36,21)+WPx*VS1(36,21)&
   +5D0*r1x2Z*(VS0(21,21)-ExZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(36,11)
VS0(57,22)=PAx*VS0(36,22)+WPx*VS1(36,22)&
   +5D0*r1x2Z*(VS0(21,22)-ExZpE*VS1(21,22))&
   +3D0*HfxZpE*VS1(36,12)
VS0(57,23)=PAx*VS0(36,23)+WPx*VS1(36,23)&
   +5D0*r1x2Z*(VS0(21,23)-ExZpE*VS1(21,23))&
   +2D0*HfxZpE*VS1(36,13)
VS0(57,24)=PAx*VS0(36,24)+WPx*VS1(36,24)&
   +5D0*r1x2Z*(VS0(21,24)-ExZpE*VS1(21,24))&
   +HfxZpE*VS1(36,14)
VS0(57,25)=PAx*VS0(36,25)+WPx*VS1(36,25)&
   +5D0*r1x2Z*(VS0(21,25)-ExZpE*VS1(21,25))
VS0(57,26)=PAx*VS0(36,26)+WPx*VS1(36,26)&
   +5D0*r1x2Z*(VS0(21,26)-ExZpE*VS1(21,26))&
   +3D0*HfxZpE*VS1(36,15)
VS0(57,27)=PAx*VS0(36,27)+WPx*VS1(36,27)&
   +5D0*r1x2Z*(VS0(21,27)-ExZpE*VS1(21,27))&
   +2D0*HfxZpE*VS1(36,16)
VS0(57,28)=PAx*VS0(36,28)+WPx*VS1(36,28)&
   +5D0*r1x2Z*(VS0(21,28)-ExZpE*VS1(21,28))&
   +HfxZpE*VS1(36,17)
VS0(57,29)=PAx*VS0(36,29)+WPx*VS1(36,29)&
   +5D0*r1x2Z*(VS0(21,29)-ExZpE*VS1(21,29))
VS0(57,30)=PAx*VS0(36,30)+WPx*VS1(36,30)&
   +5D0*r1x2Z*(VS0(21,30)-ExZpE*VS1(21,30))&
   +2D0*HfxZpE*VS1(36,18)
VS0(57,31)=PAx*VS0(36,31)+WPx*VS1(36,31)&
   +5D0*r1x2Z*(VS0(21,31)-ExZpE*VS1(21,31))&
   +HfxZpE*VS1(36,19)
VS0(57,32)=PAx*VS0(36,32)+WPx*VS1(36,32)&
   +5D0*r1x2Z*(VS0(21,32)-ExZpE*VS1(21,32))
VS0(57,33)=PAx*VS0(36,33)+WPx*VS1(36,33)&
   +5D0*r1x2Z*(VS0(21,33)-ExZpE*VS1(21,33))&
   +HfxZpE*VS1(36,20)
VS0(57,34)=PAx*VS0(36,34)+WPx*VS1(36,34)&
   +5D0*r1x2Z*(VS0(21,34)-ExZpE*VS1(21,34))
VS0(57,35)=PAx*VS0(36,35)+WPx*VS1(36,35)&
   +5D0*r1x2Z*(VS0(21,35)-ExZpE*VS1(21,35))
VS0(58,21)=PAx*VS0(37,21)+WPx*VS1(37,21)&
   +4D0*r1x2Z*(VS0(22,21)-ExZpE*VS1(22,21))&
   +4D0*HfxZpE*VS1(37,11)
VS0(58,22)=PAx*VS0(37,22)+WPx*VS1(37,22)&
   +4D0*r1x2Z*(VS0(22,22)-ExZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(37,12)
VS0(58,23)=PAx*VS0(37,23)+WPx*VS1(37,23)&
   +4D0*r1x2Z*(VS0(22,23)-ExZpE*VS1(22,23))&
   +2D0*HfxZpE*VS1(37,13)
VS0(58,24)=PAx*VS0(37,24)+WPx*VS1(37,24)&
   +4D0*r1x2Z*(VS0(22,24)-ExZpE*VS1(22,24))&
   +HfxZpE*VS1(37,14)
VS0(58,25)=PAx*VS0(37,25)+WPx*VS1(37,25)&
   +4D0*r1x2Z*(VS0(22,25)-ExZpE*VS1(22,25))
VS0(58,26)=PAx*VS0(37,26)+WPx*VS1(37,26)&
   +4D0*r1x2Z*(VS0(22,26)-ExZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(37,15)
VS0(58,27)=PAx*VS0(37,27)+WPx*VS1(37,27)&
   +4D0*r1x2Z*(VS0(22,27)-ExZpE*VS1(22,27))&
   +2D0*HfxZpE*VS1(37,16)
VS0(58,28)=PAx*VS0(37,28)+WPx*VS1(37,28)&
   +4D0*r1x2Z*(VS0(22,28)-ExZpE*VS1(22,28))&
   +HfxZpE*VS1(37,17)
VS0(58,29)=PAx*VS0(37,29)+WPx*VS1(37,29)&
   +4D0*r1x2Z*(VS0(22,29)-ExZpE*VS1(22,29))
VS0(58,30)=PAx*VS0(37,30)+WPx*VS1(37,30)&
   +4D0*r1x2Z*(VS0(22,30)-ExZpE*VS1(22,30))&
   +2D0*HfxZpE*VS1(37,18)
VS0(58,31)=PAx*VS0(37,31)+WPx*VS1(37,31)&
   +4D0*r1x2Z*(VS0(22,31)-ExZpE*VS1(22,31))&
   +HfxZpE*VS1(37,19)
VS0(58,32)=PAx*VS0(37,32)+WPx*VS1(37,32)&
   +4D0*r1x2Z*(VS0(22,32)-ExZpE*VS1(22,32))
VS0(58,33)=PAx*VS0(37,33)+WPx*VS1(37,33)&
   +4D0*r1x2Z*(VS0(22,33)-ExZpE*VS1(22,33))&
   +HfxZpE*VS1(37,20)
VS0(58,34)=PAx*VS0(37,34)+WPx*VS1(37,34)&
   +4D0*r1x2Z*(VS0(22,34)-ExZpE*VS1(22,34))
VS0(58,35)=PAx*VS0(37,35)+WPx*VS1(37,35)&
   +4D0*r1x2Z*(VS0(22,35)-ExZpE*VS1(22,35))
VS0(59,21)=PAx*VS0(38,21)+WPx*VS1(38,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))&
   +4D0*HfxZpE*VS1(38,11)
VS0(59,22)=PAx*VS0(38,22)+WPx*VS1(38,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +3D0*HfxZpE*VS1(38,12)
VS0(59,23)=PAx*VS0(38,23)+WPx*VS1(38,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(38,13)
VS0(59,24)=PAx*VS0(38,24)+WPx*VS1(38,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +HfxZpE*VS1(38,14)
VS0(59,25)=PAx*VS0(38,25)+WPx*VS1(38,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))
VS0(59,26)=PAx*VS0(38,26)+WPx*VS1(38,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))&
   +3D0*HfxZpE*VS1(38,15)
VS0(59,27)=PAx*VS0(38,27)+WPx*VS1(38,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(38,16)
VS0(59,28)=PAx*VS0(38,28)+WPx*VS1(38,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +HfxZpE*VS1(38,17)
VS0(59,29)=PAx*VS0(38,29)+WPx*VS1(38,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))
VS0(59,30)=PAx*VS0(38,30)+WPx*VS1(38,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(38,18)
VS0(59,31)=PAx*VS0(38,31)+WPx*VS1(38,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(38,19)
VS0(59,32)=PAx*VS0(38,32)+WPx*VS1(38,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))
VS0(59,33)=PAx*VS0(38,33)+WPx*VS1(38,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))&
   +HfxZpE*VS1(38,20)
VS0(59,34)=PAx*VS0(38,34)+WPx*VS1(38,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))
VS0(59,35)=PAx*VS0(38,35)+WPx*VS1(38,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(60,21)=PAx*VS0(39,21)+WPx*VS1(39,21)&
   +2D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))&
   +4D0*HfxZpE*VS1(39,11)
VS0(60,22)=PAx*VS0(39,22)+WPx*VS1(39,22)&
   +2D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +3D0*HfxZpE*VS1(39,12)
VS0(60,23)=PAx*VS0(39,23)+WPx*VS1(39,23)&
   +2D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(39,13)
VS0(60,24)=PAx*VS0(39,24)+WPx*VS1(39,24)&
   +2D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +HfxZpE*VS1(39,14)
VS0(60,25)=PAx*VS0(39,25)+WPx*VS1(39,25)&
   +2D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))
VS0(60,26)=PAx*VS0(39,26)+WPx*VS1(39,26)&
   +2D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))&
   +3D0*HfxZpE*VS1(39,15)
VS0(60,27)=PAx*VS0(39,27)+WPx*VS1(39,27)&
   +2D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +2D0*HfxZpE*VS1(39,16)
VS0(60,28)=PAx*VS0(39,28)+WPx*VS1(39,28)&
   +2D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +HfxZpE*VS1(39,17)
VS0(60,29)=PAx*VS0(39,29)+WPx*VS1(39,29)&
   +2D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))
VS0(60,30)=PAx*VS0(39,30)+WPx*VS1(39,30)&
   +2D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))&
   +2D0*HfxZpE*VS1(39,18)
VS0(60,31)=PAx*VS0(39,31)+WPx*VS1(39,31)&
   +2D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(39,19)
VS0(60,32)=PAx*VS0(39,32)+WPx*VS1(39,32)&
   +2D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))
VS0(60,33)=PAx*VS0(39,33)+WPx*VS1(39,33)&
   +2D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))&
   +HfxZpE*VS1(39,20)
VS0(60,34)=PAx*VS0(39,34)+WPx*VS1(39,34)&
   +2D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))
VS0(60,35)=PAx*VS0(39,35)+WPx*VS1(39,35)&
   +2D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(61,21)=PAy*VS0(39,21)+WPy*VS1(39,21)&
   +3D0*r1x2Z*(VS0(23,21)-ExZpE*VS1(23,21))
VS0(61,22)=PAy*VS0(39,22)+WPy*VS1(39,22)&
   +3D0*r1x2Z*(VS0(23,22)-ExZpE*VS1(23,22))&
   +HfxZpE*VS1(39,11)
VS0(61,23)=PAy*VS0(39,23)+WPy*VS1(39,23)&
   +3D0*r1x2Z*(VS0(23,23)-ExZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(39,12)
VS0(61,24)=PAy*VS0(39,24)+WPy*VS1(39,24)&
   +3D0*r1x2Z*(VS0(23,24)-ExZpE*VS1(23,24))&
   +3D0*HfxZpE*VS1(39,13)
VS0(61,25)=PAy*VS0(39,25)+WPy*VS1(39,25)&
   +3D0*r1x2Z*(VS0(23,25)-ExZpE*VS1(23,25))&
   +4D0*HfxZpE*VS1(39,14)
VS0(61,26)=PAy*VS0(39,26)+WPy*VS1(39,26)&
   +3D0*r1x2Z*(VS0(23,26)-ExZpE*VS1(23,26))
VS0(61,27)=PAy*VS0(39,27)+WPy*VS1(39,27)&
   +3D0*r1x2Z*(VS0(23,27)-ExZpE*VS1(23,27))&
   +HfxZpE*VS1(39,15)
VS0(61,28)=PAy*VS0(39,28)+WPy*VS1(39,28)&
   +3D0*r1x2Z*(VS0(23,28)-ExZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(39,16)
VS0(61,29)=PAy*VS0(39,29)+WPy*VS1(39,29)&
   +3D0*r1x2Z*(VS0(23,29)-ExZpE*VS1(23,29))&
   +3D0*HfxZpE*VS1(39,17)
VS0(61,30)=PAy*VS0(39,30)+WPy*VS1(39,30)&
   +3D0*r1x2Z*(VS0(23,30)-ExZpE*VS1(23,30))
VS0(61,31)=PAy*VS0(39,31)+WPy*VS1(39,31)&
   +3D0*r1x2Z*(VS0(23,31)-ExZpE*VS1(23,31))&
   +HfxZpE*VS1(39,18)
VS0(61,32)=PAy*VS0(39,32)+WPy*VS1(39,32)&
   +3D0*r1x2Z*(VS0(23,32)-ExZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(39,19)
VS0(61,33)=PAy*VS0(39,33)+WPy*VS1(39,33)&
   +3D0*r1x2Z*(VS0(23,33)-ExZpE*VS1(23,33))
VS0(61,34)=PAy*VS0(39,34)+WPy*VS1(39,34)&
   +3D0*r1x2Z*(VS0(23,34)-ExZpE*VS1(23,34))&
   +HfxZpE*VS1(39,20)
VS0(61,35)=PAy*VS0(39,35)+WPy*VS1(39,35)&
   +3D0*r1x2Z*(VS0(23,35)-ExZpE*VS1(23,35))
VS0(62,21)=PAy*VS0(40,21)+WPy*VS1(40,21)&
   +4D0*r1x2Z*(VS0(24,21)-ExZpE*VS1(24,21))
VS0(62,22)=PAy*VS0(40,22)+WPy*VS1(40,22)&
   +4D0*r1x2Z*(VS0(24,22)-ExZpE*VS1(24,22))&
   +HfxZpE*VS1(40,11)
VS0(62,23)=PAy*VS0(40,23)+WPy*VS1(40,23)&
   +4D0*r1x2Z*(VS0(24,23)-ExZpE*VS1(24,23))&
   +2D0*HfxZpE*VS1(40,12)
VS0(62,24)=PAy*VS0(40,24)+WPy*VS1(40,24)&
   +4D0*r1x2Z*(VS0(24,24)-ExZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(40,13)
VS0(62,25)=PAy*VS0(40,25)+WPy*VS1(40,25)&
   +4D0*r1x2Z*(VS0(24,25)-ExZpE*VS1(24,25))&
   +4D0*HfxZpE*VS1(40,14)
VS0(62,26)=PAy*VS0(40,26)+WPy*VS1(40,26)&
   +4D0*r1x2Z*(VS0(24,26)-ExZpE*VS1(24,26))
VS0(62,27)=PAy*VS0(40,27)+WPy*VS1(40,27)&
   +4D0*r1x2Z*(VS0(24,27)-ExZpE*VS1(24,27))&
   +HfxZpE*VS1(40,15)
VS0(62,28)=PAy*VS0(40,28)+WPy*VS1(40,28)&
   +4D0*r1x2Z*(VS0(24,28)-ExZpE*VS1(24,28))&
   +2D0*HfxZpE*VS1(40,16)
VS0(62,29)=PAy*VS0(40,29)+WPy*VS1(40,29)&
   +4D0*r1x2Z*(VS0(24,29)-ExZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(40,17)
VS0(62,30)=PAy*VS0(40,30)+WPy*VS1(40,30)&
   +4D0*r1x2Z*(VS0(24,30)-ExZpE*VS1(24,30))
VS0(62,31)=PAy*VS0(40,31)+WPy*VS1(40,31)&
   +4D0*r1x2Z*(VS0(24,31)-ExZpE*VS1(24,31))&
   +HfxZpE*VS1(40,18)
VS0(62,32)=PAy*VS0(40,32)+WPy*VS1(40,32)&
   +4D0*r1x2Z*(VS0(24,32)-ExZpE*VS1(24,32))&
   +2D0*HfxZpE*VS1(40,19)
VS0(62,33)=PAy*VS0(40,33)+WPy*VS1(40,33)&
   +4D0*r1x2Z*(VS0(24,33)-ExZpE*VS1(24,33))
VS0(62,34)=PAy*VS0(40,34)+WPy*VS1(40,34)&
   +4D0*r1x2Z*(VS0(24,34)-ExZpE*VS1(24,34))&
   +HfxZpE*VS1(40,20)
VS0(62,35)=PAy*VS0(40,35)+WPy*VS1(40,35)&
   +4D0*r1x2Z*(VS0(24,35)-ExZpE*VS1(24,35))
VS0(63,21)=PAy*VS0(41,21)+WPy*VS1(41,21)&
   +5D0*r1x2Z*(VS0(25,21)-ExZpE*VS1(25,21))
VS0(63,22)=PAy*VS0(41,22)+WPy*VS1(41,22)&
   +5D0*r1x2Z*(VS0(25,22)-ExZpE*VS1(25,22))&
   +HfxZpE*VS1(41,11)
VS0(63,23)=PAy*VS0(41,23)+WPy*VS1(41,23)&
   +5D0*r1x2Z*(VS0(25,23)-ExZpE*VS1(25,23))&
   +2D0*HfxZpE*VS1(41,12)
VS0(63,24)=PAy*VS0(41,24)+WPy*VS1(41,24)&
   +5D0*r1x2Z*(VS0(25,24)-ExZpE*VS1(25,24))&
   +3D0*HfxZpE*VS1(41,13)
VS0(63,25)=PAy*VS0(41,25)+WPy*VS1(41,25)&
   +5D0*r1x2Z*(VS0(25,25)-ExZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(41,14)
VS0(63,26)=PAy*VS0(41,26)+WPy*VS1(41,26)&
   +5D0*r1x2Z*(VS0(25,26)-ExZpE*VS1(25,26))
VS0(63,27)=PAy*VS0(41,27)+WPy*VS1(41,27)&
   +5D0*r1x2Z*(VS0(25,27)-ExZpE*VS1(25,27))&
   +HfxZpE*VS1(41,15)
VS0(63,28)=PAy*VS0(41,28)+WPy*VS1(41,28)&
   +5D0*r1x2Z*(VS0(25,28)-ExZpE*VS1(25,28))&
   +2D0*HfxZpE*VS1(41,16)
VS0(63,29)=PAy*VS0(41,29)+WPy*VS1(41,29)&
   +5D0*r1x2Z*(VS0(25,29)-ExZpE*VS1(25,29))&
   +3D0*HfxZpE*VS1(41,17)
VS0(63,30)=PAy*VS0(41,30)+WPy*VS1(41,30)&
   +5D0*r1x2Z*(VS0(25,30)-ExZpE*VS1(25,30))
VS0(63,31)=PAy*VS0(41,31)+WPy*VS1(41,31)&
   +5D0*r1x2Z*(VS0(25,31)-ExZpE*VS1(25,31))&
   +HfxZpE*VS1(41,18)
VS0(63,32)=PAy*VS0(41,32)+WPy*VS1(41,32)&
   +5D0*r1x2Z*(VS0(25,32)-ExZpE*VS1(25,32))&
   +2D0*HfxZpE*VS1(41,19)
VS0(63,33)=PAy*VS0(41,33)+WPy*VS1(41,33)&
   +5D0*r1x2Z*(VS0(25,33)-ExZpE*VS1(25,33))
VS0(63,34)=PAy*VS0(41,34)+WPy*VS1(41,34)&
   +5D0*r1x2Z*(VS0(25,34)-ExZpE*VS1(25,34))&
   +HfxZpE*VS1(41,20)
VS0(63,35)=PAy*VS0(41,35)+WPy*VS1(41,35)&
   +5D0*r1x2Z*(VS0(25,35)-ExZpE*VS1(25,35))
VS0(64,21)=PAx*VS0(42,21)+WPx*VS1(42,21)&
   +4D0*r1x2Z*(VS0(26,21)-ExZpE*VS1(26,21))&
   +4D0*HfxZpE*VS1(42,11)
VS0(64,22)=PAx*VS0(42,22)+WPx*VS1(42,22)&
   +4D0*r1x2Z*(VS0(26,22)-ExZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(42,12)
VS0(64,23)=PAx*VS0(42,23)+WPx*VS1(42,23)&
   +4D0*r1x2Z*(VS0(26,23)-ExZpE*VS1(26,23))&
   +2D0*HfxZpE*VS1(42,13)
VS0(64,24)=PAx*VS0(42,24)+WPx*VS1(42,24)&
   +4D0*r1x2Z*(VS0(26,24)-ExZpE*VS1(26,24))&
   +HfxZpE*VS1(42,14)
VS0(64,25)=PAx*VS0(42,25)+WPx*VS1(42,25)&
   +4D0*r1x2Z*(VS0(26,25)-ExZpE*VS1(26,25))
VS0(64,26)=PAx*VS0(42,26)+WPx*VS1(42,26)&
   +4D0*r1x2Z*(VS0(26,26)-ExZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(42,15)
VS0(64,27)=PAx*VS0(42,27)+WPx*VS1(42,27)&
   +4D0*r1x2Z*(VS0(26,27)-ExZpE*VS1(26,27))&
   +2D0*HfxZpE*VS1(42,16)
VS0(64,28)=PAx*VS0(42,28)+WPx*VS1(42,28)&
   +4D0*r1x2Z*(VS0(26,28)-ExZpE*VS1(26,28))&
   +HfxZpE*VS1(42,17)
VS0(64,29)=PAx*VS0(42,29)+WPx*VS1(42,29)&
   +4D0*r1x2Z*(VS0(26,29)-ExZpE*VS1(26,29))
VS0(64,30)=PAx*VS0(42,30)+WPx*VS1(42,30)&
   +4D0*r1x2Z*(VS0(26,30)-ExZpE*VS1(26,30))&
   +2D0*HfxZpE*VS1(42,18)
VS0(64,31)=PAx*VS0(42,31)+WPx*VS1(42,31)&
   +4D0*r1x2Z*(VS0(26,31)-ExZpE*VS1(26,31))&
   +HfxZpE*VS1(42,19)
VS0(64,32)=PAx*VS0(42,32)+WPx*VS1(42,32)&
   +4D0*r1x2Z*(VS0(26,32)-ExZpE*VS1(26,32))
VS0(64,33)=PAx*VS0(42,33)+WPx*VS1(42,33)&
   +4D0*r1x2Z*(VS0(26,33)-ExZpE*VS1(26,33))&
   +HfxZpE*VS1(42,20)
VS0(64,34)=PAx*VS0(42,34)+WPx*VS1(42,34)&
   +4D0*r1x2Z*(VS0(26,34)-ExZpE*VS1(26,34))
VS0(64,35)=PAx*VS0(42,35)+WPx*VS1(42,35)&
   +4D0*r1x2Z*(VS0(26,35)-ExZpE*VS1(26,35))
VS0(65,21)=PAx*VS0(43,21)+WPx*VS1(43,21)&
   +3D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))&
   +4D0*HfxZpE*VS1(43,11)
VS0(65,22)=PAx*VS0(43,22)+WPx*VS1(43,22)&
   +3D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +3D0*HfxZpE*VS1(43,12)
VS0(65,23)=PAx*VS0(43,23)+WPx*VS1(43,23)&
   +3D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(43,13)
VS0(65,24)=PAx*VS0(43,24)+WPx*VS1(43,24)&
   +3D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +HfxZpE*VS1(43,14)
VS0(65,25)=PAx*VS0(43,25)+WPx*VS1(43,25)&
   +3D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(65,26)=PAx*VS0(43,26)+WPx*VS1(43,26)&
   +3D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +3D0*HfxZpE*VS1(43,15)
VS0(65,27)=PAx*VS0(43,27)+WPx*VS1(43,27)&
   +3D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(43,16)
VS0(65,28)=PAx*VS0(43,28)+WPx*VS1(43,28)&
   +3D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(43,17)
VS0(65,29)=PAx*VS0(43,29)+WPx*VS1(43,29)&
   +3D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))
VS0(65,30)=PAx*VS0(43,30)+WPx*VS1(43,30)&
   +3D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(43,18)
VS0(65,31)=PAx*VS0(43,31)+WPx*VS1(43,31)&
   +3D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(43,19)
VS0(65,32)=PAx*VS0(43,32)+WPx*VS1(43,32)&
   +3D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))
VS0(65,33)=PAx*VS0(43,33)+WPx*VS1(43,33)&
   +3D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +HfxZpE*VS1(43,20)
VS0(65,34)=PAx*VS0(43,34)+WPx*VS1(43,34)&
   +3D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))
VS0(65,35)=PAx*VS0(43,35)+WPx*VS1(43,35)&
   +3D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(66,21)=PAx*VS0(44,21)+WPx*VS1(44,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))&
   +4D0*HfxZpE*VS1(44,11)
VS0(66,22)=PAx*VS0(44,22)+WPx*VS1(44,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +3D0*HfxZpE*VS1(44,12)
VS0(66,23)=PAx*VS0(44,23)+WPx*VS1(44,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(44,13)
VS0(66,24)=PAx*VS0(44,24)+WPx*VS1(44,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +HfxZpE*VS1(44,14)
VS0(66,25)=PAx*VS0(44,25)+WPx*VS1(44,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(66,26)=PAx*VS0(44,26)+WPx*VS1(44,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +3D0*HfxZpE*VS1(44,15)
VS0(66,27)=PAx*VS0(44,27)+WPx*VS1(44,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(44,16)
VS0(66,28)=PAx*VS0(44,28)+WPx*VS1(44,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(44,17)
VS0(66,29)=PAx*VS0(44,29)+WPx*VS1(44,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))
VS0(66,30)=PAx*VS0(44,30)+WPx*VS1(44,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(44,18)
VS0(66,31)=PAx*VS0(44,31)+WPx*VS1(44,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(44,19)
VS0(66,32)=PAx*VS0(44,32)+WPx*VS1(44,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))
VS0(66,33)=PAx*VS0(44,33)+WPx*VS1(44,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +HfxZpE*VS1(44,20)
VS0(66,34)=PAx*VS0(44,34)+WPx*VS1(44,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))
VS0(66,35)=PAx*VS0(44,35)+WPx*VS1(44,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(67,21)=PAy*VS0(44,21)+WPy*VS1(44,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(67,22)=PAy*VS0(44,22)+WPy*VS1(44,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))&
   +HfxZpE*VS1(44,11)
VS0(67,23)=PAy*VS0(44,23)+WPy*VS1(44,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(44,12)
VS0(67,24)=PAy*VS0(44,24)+WPy*VS1(44,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))&
   +3D0*HfxZpE*VS1(44,13)
VS0(67,25)=PAy*VS0(44,25)+WPy*VS1(44,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))&
   +4D0*HfxZpE*VS1(44,14)
VS0(67,26)=PAy*VS0(44,26)+WPy*VS1(44,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))
VS0(67,27)=PAy*VS0(44,27)+WPy*VS1(44,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(44,15)
VS0(67,28)=PAy*VS0(44,28)+WPy*VS1(44,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(44,16)
VS0(67,29)=PAy*VS0(44,29)+WPy*VS1(44,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +3D0*HfxZpE*VS1(44,17)
VS0(67,30)=PAy*VS0(44,30)+WPy*VS1(44,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))
VS0(67,31)=PAy*VS0(44,31)+WPy*VS1(44,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +HfxZpE*VS1(44,18)
VS0(67,32)=PAy*VS0(44,32)+WPy*VS1(44,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(44,19)
VS0(67,33)=PAy*VS0(44,33)+WPy*VS1(44,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))
VS0(67,34)=PAy*VS0(44,34)+WPy*VS1(44,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +HfxZpE*VS1(44,20)
VS0(67,35)=PAy*VS0(44,35)+WPy*VS1(44,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))
VS0(68,21)=PAy*VS0(45,21)+WPy*VS1(45,21)&
   +3D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(68,22)=PAy*VS0(45,22)+WPy*VS1(45,22)&
   +3D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))&
   +HfxZpE*VS1(45,11)
VS0(68,23)=PAy*VS0(45,23)+WPy*VS1(45,23)&
   +3D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(45,12)
VS0(68,24)=PAy*VS0(45,24)+WPy*VS1(45,24)&
   +3D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))&
   +3D0*HfxZpE*VS1(45,13)
VS0(68,25)=PAy*VS0(45,25)+WPy*VS1(45,25)&
   +3D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))&
   +4D0*HfxZpE*VS1(45,14)
VS0(68,26)=PAy*VS0(45,26)+WPy*VS1(45,26)&
   +3D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))
VS0(68,27)=PAy*VS0(45,27)+WPy*VS1(45,27)&
   +3D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(45,15)
VS0(68,28)=PAy*VS0(45,28)+WPy*VS1(45,28)&
   +3D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(45,16)
VS0(68,29)=PAy*VS0(45,29)+WPy*VS1(45,29)&
   +3D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +3D0*HfxZpE*VS1(45,17)
VS0(68,30)=PAy*VS0(45,30)+WPy*VS1(45,30)&
   +3D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))
VS0(68,31)=PAy*VS0(45,31)+WPy*VS1(45,31)&
   +3D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +HfxZpE*VS1(45,18)
VS0(68,32)=PAy*VS0(45,32)+WPy*VS1(45,32)&
   +3D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(45,19)
VS0(68,33)=PAy*VS0(45,33)+WPy*VS1(45,33)&
   +3D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))
VS0(68,34)=PAy*VS0(45,34)+WPy*VS1(45,34)&
   +3D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +HfxZpE*VS1(45,20)
VS0(68,35)=PAy*VS0(45,35)+WPy*VS1(45,35)&
   +3D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))
VS0(69,21)=PAy*VS0(46,21)+WPy*VS1(46,21)&
   +4D0*r1x2Z*(VS0(29,21)-ExZpE*VS1(29,21))
VS0(69,22)=PAy*VS0(46,22)+WPy*VS1(46,22)&
   +4D0*r1x2Z*(VS0(29,22)-ExZpE*VS1(29,22))&
   +HfxZpE*VS1(46,11)
VS0(69,23)=PAy*VS0(46,23)+WPy*VS1(46,23)&
   +4D0*r1x2Z*(VS0(29,23)-ExZpE*VS1(29,23))&
   +2D0*HfxZpE*VS1(46,12)
VS0(69,24)=PAy*VS0(46,24)+WPy*VS1(46,24)&
   +4D0*r1x2Z*(VS0(29,24)-ExZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(46,13)
VS0(69,25)=PAy*VS0(46,25)+WPy*VS1(46,25)&
   +4D0*r1x2Z*(VS0(29,25)-ExZpE*VS1(29,25))&
   +4D0*HfxZpE*VS1(46,14)
VS0(69,26)=PAy*VS0(46,26)+WPy*VS1(46,26)&
   +4D0*r1x2Z*(VS0(29,26)-ExZpE*VS1(29,26))
VS0(69,27)=PAy*VS0(46,27)+WPy*VS1(46,27)&
   +4D0*r1x2Z*(VS0(29,27)-ExZpE*VS1(29,27))&
   +HfxZpE*VS1(46,15)
VS0(69,28)=PAy*VS0(46,28)+WPy*VS1(46,28)&
   +4D0*r1x2Z*(VS0(29,28)-ExZpE*VS1(29,28))&
   +2D0*HfxZpE*VS1(46,16)
VS0(69,29)=PAy*VS0(46,29)+WPy*VS1(46,29)&
   +4D0*r1x2Z*(VS0(29,29)-ExZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(46,17)
VS0(69,30)=PAy*VS0(46,30)+WPy*VS1(46,30)&
   +4D0*r1x2Z*(VS0(29,30)-ExZpE*VS1(29,30))
VS0(69,31)=PAy*VS0(46,31)+WPy*VS1(46,31)&
   +4D0*r1x2Z*(VS0(29,31)-ExZpE*VS1(29,31))&
   +HfxZpE*VS1(46,18)
VS0(69,32)=PAy*VS0(46,32)+WPy*VS1(46,32)&
   +4D0*r1x2Z*(VS0(29,32)-ExZpE*VS1(29,32))&
   +2D0*HfxZpE*VS1(46,19)
VS0(69,33)=PAy*VS0(46,33)+WPy*VS1(46,33)&
   +4D0*r1x2Z*(VS0(29,33)-ExZpE*VS1(29,33))
VS0(69,34)=PAy*VS0(46,34)+WPy*VS1(46,34)&
   +4D0*r1x2Z*(VS0(29,34)-ExZpE*VS1(29,34))&
   +HfxZpE*VS1(46,20)
VS0(69,35)=PAy*VS0(46,35)+WPy*VS1(46,35)&
   +4D0*r1x2Z*(VS0(29,35)-ExZpE*VS1(29,35))
VS0(70,21)=PAx*VS0(47,21)+WPx*VS1(47,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))&
   +4D0*HfxZpE*VS1(47,11)
VS0(70,22)=PAx*VS0(47,22)+WPx*VS1(47,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))&
   +3D0*HfxZpE*VS1(47,12)
VS0(70,23)=PAx*VS0(47,23)+WPx*VS1(47,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(47,13)
VS0(70,24)=PAx*VS0(47,24)+WPx*VS1(47,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))&
   +HfxZpE*VS1(47,14)
VS0(70,25)=PAx*VS0(47,25)+WPx*VS1(47,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(70,26)=PAx*VS0(47,26)+WPx*VS1(47,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +3D0*HfxZpE*VS1(47,15)
VS0(70,27)=PAx*VS0(47,27)+WPx*VS1(47,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(47,16)
VS0(70,28)=PAx*VS0(47,28)+WPx*VS1(47,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(47,17)
VS0(70,29)=PAx*VS0(47,29)+WPx*VS1(47,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))
VS0(70,30)=PAx*VS0(47,30)+WPx*VS1(47,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(47,18)
VS0(70,31)=PAx*VS0(47,31)+WPx*VS1(47,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +HfxZpE*VS1(47,19)
VS0(70,32)=PAx*VS0(47,32)+WPx*VS1(47,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))
VS0(70,33)=PAx*VS0(47,33)+WPx*VS1(47,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +HfxZpE*VS1(47,20)
VS0(70,34)=PAx*VS0(47,34)+WPx*VS1(47,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))
VS0(70,35)=PAx*VS0(47,35)+WPx*VS1(47,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))
VS0(71,21)=PAx*VS0(48,21)+WPx*VS1(48,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))&
   +4D0*HfxZpE*VS1(48,11)
VS0(71,22)=PAx*VS0(48,22)+WPx*VS1(48,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +3D0*HfxZpE*VS1(48,12)
VS0(71,23)=PAx*VS0(48,23)+WPx*VS1(48,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(48,13)
VS0(71,24)=PAx*VS0(48,24)+WPx*VS1(48,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +HfxZpE*VS1(48,14)
VS0(71,25)=PAx*VS0(48,25)+WPx*VS1(48,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(71,26)=PAx*VS0(48,26)+WPx*VS1(48,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +3D0*HfxZpE*VS1(48,15)
VS0(71,27)=PAx*VS0(48,27)+WPx*VS1(48,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(48,16)
VS0(71,28)=PAx*VS0(48,28)+WPx*VS1(48,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(48,17)
VS0(71,29)=PAx*VS0(48,29)+WPx*VS1(48,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))
VS0(71,30)=PAx*VS0(48,30)+WPx*VS1(48,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(48,18)
VS0(71,31)=PAx*VS0(48,31)+WPx*VS1(48,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(48,19)
VS0(71,32)=PAx*VS0(48,32)+WPx*VS1(48,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))
VS0(71,33)=PAx*VS0(48,33)+WPx*VS1(48,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +HfxZpE*VS1(48,20)
VS0(71,34)=PAx*VS0(48,34)+WPx*VS1(48,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))
VS0(71,35)=PAx*VS0(48,35)+WPx*VS1(48,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(72,21)=PAx*VS0(49,21)+WPx*VS1(49,21)&
   +r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))&
   +4D0*HfxZpE*VS1(49,11)
VS0(72,22)=PAx*VS0(49,22)+WPx*VS1(49,22)&
   +r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +3D0*HfxZpE*VS1(49,12)
VS0(72,23)=PAx*VS0(49,23)+WPx*VS1(49,23)&
   +r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(49,13)
VS0(72,24)=PAx*VS0(49,24)+WPx*VS1(49,24)&
   +r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +HfxZpE*VS1(49,14)
VS0(72,25)=PAx*VS0(49,25)+WPx*VS1(49,25)&
   +r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(72,26)=PAx*VS0(49,26)+WPx*VS1(49,26)&
   +r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +3D0*HfxZpE*VS1(49,15)
VS0(72,27)=PAx*VS0(49,27)+WPx*VS1(49,27)&
   +r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(49,16)
VS0(72,28)=PAx*VS0(49,28)+WPx*VS1(49,28)&
   +r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(49,17)
VS0(72,29)=PAx*VS0(49,29)+WPx*VS1(49,29)&
   +r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))
VS0(72,30)=PAx*VS0(49,30)+WPx*VS1(49,30)&
   +r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(49,18)
VS0(72,31)=PAx*VS0(49,31)+WPx*VS1(49,31)&
   +r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(49,19)
VS0(72,32)=PAx*VS0(49,32)+WPx*VS1(49,32)&
   +r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))
VS0(72,33)=PAx*VS0(49,33)+WPx*VS1(49,33)&
   +r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +HfxZpE*VS1(49,20)
VS0(72,34)=PAx*VS0(49,34)+WPx*VS1(49,34)&
   +r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))
VS0(72,35)=PAx*VS0(49,35)+WPx*VS1(49,35)&
   +r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(73,21)=PAy*VS0(49,21)+WPy*VS1(49,21)&
   +2D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(73,22)=PAy*VS0(49,22)+WPy*VS1(49,22)&
   +2D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))&
   +HfxZpE*VS1(49,11)
VS0(73,23)=PAy*VS0(49,23)+WPy*VS1(49,23)&
   +2D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))&
   +2D0*HfxZpE*VS1(49,12)
VS0(73,24)=PAy*VS0(49,24)+WPy*VS1(49,24)&
   +2D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))&
   +3D0*HfxZpE*VS1(49,13)
VS0(73,25)=PAy*VS0(49,25)+WPy*VS1(49,25)&
   +2D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))&
   +4D0*HfxZpE*VS1(49,14)
VS0(73,26)=PAy*VS0(49,26)+WPy*VS1(49,26)&
   +2D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))
VS0(73,27)=PAy*VS0(49,27)+WPy*VS1(49,27)&
   +2D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(49,15)
VS0(73,28)=PAy*VS0(49,28)+WPy*VS1(49,28)&
   +2D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(49,16)
VS0(73,29)=PAy*VS0(49,29)+WPy*VS1(49,29)&
   +2D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +3D0*HfxZpE*VS1(49,17)
VS0(73,30)=PAy*VS0(49,30)+WPy*VS1(49,30)&
   +2D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))
VS0(73,31)=PAy*VS0(49,31)+WPy*VS1(49,31)&
   +2D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +HfxZpE*VS1(49,18)
VS0(73,32)=PAy*VS0(49,32)+WPy*VS1(49,32)&
   +2D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(49,19)
VS0(73,33)=PAy*VS0(49,33)+WPy*VS1(49,33)&
   +2D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))
VS0(73,34)=PAy*VS0(49,34)+WPy*VS1(49,34)&
   +2D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +HfxZpE*VS1(49,20)
VS0(73,35)=PAy*VS0(49,35)+WPy*VS1(49,35)&
   +2D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))
VS0(74,21)=PAy*VS0(50,21)+WPy*VS1(50,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(74,22)=PAy*VS0(50,22)+WPy*VS1(50,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))&
   +HfxZpE*VS1(50,11)
VS0(74,23)=PAy*VS0(50,23)+WPy*VS1(50,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(50,12)
VS0(74,24)=PAy*VS0(50,24)+WPy*VS1(50,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))&
   +3D0*HfxZpE*VS1(50,13)
VS0(74,25)=PAy*VS0(50,25)+WPy*VS1(50,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))&
   +4D0*HfxZpE*VS1(50,14)
VS0(74,26)=PAy*VS0(50,26)+WPy*VS1(50,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))
VS0(74,27)=PAy*VS0(50,27)+WPy*VS1(50,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(50,15)
VS0(74,28)=PAy*VS0(50,28)+WPy*VS1(50,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(50,16)
VS0(74,29)=PAy*VS0(50,29)+WPy*VS1(50,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +3D0*HfxZpE*VS1(50,17)
VS0(74,30)=PAy*VS0(50,30)+WPy*VS1(50,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))
VS0(74,31)=PAy*VS0(50,31)+WPy*VS1(50,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +HfxZpE*VS1(50,18)
VS0(74,32)=PAy*VS0(50,32)+WPy*VS1(50,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(50,19)
VS0(74,33)=PAy*VS0(50,33)+WPy*VS1(50,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))
VS0(74,34)=PAy*VS0(50,34)+WPy*VS1(50,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +HfxZpE*VS1(50,20)
VS0(74,35)=PAy*VS0(50,35)+WPy*VS1(50,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))
VS0(75,21)=PAx*VS0(51,21)+WPx*VS1(51,21)&
   +2D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))&
   +4D0*HfxZpE*VS1(51,11)
VS0(75,22)=PAx*VS0(51,22)+WPx*VS1(51,22)&
   +2D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))&
   +3D0*HfxZpE*VS1(51,12)
VS0(75,23)=PAx*VS0(51,23)+WPx*VS1(51,23)&
   +2D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))&
   +2D0*HfxZpE*VS1(51,13)
VS0(75,24)=PAx*VS0(51,24)+WPx*VS1(51,24)&
   +2D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))&
   +HfxZpE*VS1(51,14)
VS0(75,25)=PAx*VS0(51,25)+WPx*VS1(51,25)&
   +2D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(75,26)=PAx*VS0(51,26)+WPx*VS1(51,26)&
   +2D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +3D0*HfxZpE*VS1(51,15)
VS0(75,27)=PAx*VS0(51,27)+WPx*VS1(51,27)&
   +2D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +2D0*HfxZpE*VS1(51,16)
VS0(75,28)=PAx*VS0(51,28)+WPx*VS1(51,28)&
   +2D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(51,17)
VS0(75,29)=PAx*VS0(51,29)+WPx*VS1(51,29)&
   +2D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))
VS0(75,30)=PAx*VS0(51,30)+WPx*VS1(51,30)&
   +2D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(51,18)
VS0(75,31)=PAx*VS0(51,31)+WPx*VS1(51,31)&
   +2D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +HfxZpE*VS1(51,19)
VS0(75,32)=PAx*VS0(51,32)+WPx*VS1(51,32)&
   +2D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))
VS0(75,33)=PAx*VS0(51,33)+WPx*VS1(51,33)&
   +2D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +HfxZpE*VS1(51,20)
VS0(75,34)=PAx*VS0(51,34)+WPx*VS1(51,34)&
   +2D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))
VS0(75,35)=PAx*VS0(51,35)+WPx*VS1(51,35)&
   +2D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))
VS0(76,21)=PAz*VS0(48,21)+WPz*VS1(48,21)+r1x2Z*VR1(48,21)&
   +2D0*r1x2Z*(VS0(27,21)-ExZpE*VS1(27,21))
VS0(76,22)=PAz*VS0(48,22)+WPz*VS1(48,22)+r1x2Z*VR1(48,22)&
   +2D0*r1x2Z*(VS0(27,22)-ExZpE*VS1(27,22))
VS0(76,23)=PAz*VS0(48,23)+WPz*VS1(48,23)+r1x2Z*VR1(48,23)&
   +2D0*r1x2Z*(VS0(27,23)-ExZpE*VS1(27,23))
VS0(76,24)=PAz*VS0(48,24)+WPz*VS1(48,24)+r1x2Z*VR1(48,24)&
   +2D0*r1x2Z*(VS0(27,24)-ExZpE*VS1(27,24))
VS0(76,25)=PAz*VS0(48,25)+WPz*VS1(48,25)+r1x2Z*VR1(48,25)&
   +2D0*r1x2Z*(VS0(27,25)-ExZpE*VS1(27,25))
VS0(76,26)=PAz*VS0(48,26)+WPz*VS1(48,26)+r1x2Z*VR1(48,26)&
   +2D0*r1x2Z*(VS0(27,26)-ExZpE*VS1(27,26))&
   +HfxZpE*VS1(48,11)
VS0(76,27)=PAz*VS0(48,27)+WPz*VS1(48,27)+r1x2Z*VR1(48,27)&
   +2D0*r1x2Z*(VS0(27,27)-ExZpE*VS1(27,27))&
   +HfxZpE*VS1(48,12)
VS0(76,28)=PAz*VS0(48,28)+WPz*VS1(48,28)+r1x2Z*VR1(48,28)&
   +2D0*r1x2Z*(VS0(27,28)-ExZpE*VS1(27,28))&
   +HfxZpE*VS1(48,13)
VS0(76,29)=PAz*VS0(48,29)+WPz*VS1(48,29)+r1x2Z*VR1(48,29)&
   +2D0*r1x2Z*(VS0(27,29)-ExZpE*VS1(27,29))&
   +HfxZpE*VS1(48,14)
VS0(76,30)=PAz*VS0(48,30)+WPz*VS1(48,30)+r1x2Z*VR1(48,30)&
   +2D0*r1x2Z*(VS0(27,30)-ExZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(48,15)
VS0(76,31)=PAz*VS0(48,31)+WPz*VS1(48,31)+r1x2Z*VR1(48,31)&
   +2D0*r1x2Z*(VS0(27,31)-ExZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(48,16)
VS0(76,32)=PAz*VS0(48,32)+WPz*VS1(48,32)+r1x2Z*VR1(48,32)&
   +2D0*r1x2Z*(VS0(27,32)-ExZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(48,17)
VS0(76,33)=PAz*VS0(48,33)+WPz*VS1(48,33)+r1x2Z*VR1(48,33)&
   +2D0*r1x2Z*(VS0(27,33)-ExZpE*VS1(27,33))&
   +3D0*HfxZpE*VS1(48,18)
VS0(76,34)=PAz*VS0(48,34)+WPz*VS1(48,34)+r1x2Z*VR1(48,34)&
   +2D0*r1x2Z*(VS0(27,34)-ExZpE*VS1(27,34))&
   +3D0*HfxZpE*VS1(48,19)
VS0(76,35)=PAz*VS0(48,35)+WPz*VS1(48,35)+r1x2Z*VR1(48,35)&
   +2D0*r1x2Z*(VS0(27,35)-ExZpE*VS1(27,35))&
   +4D0*HfxZpE*VS1(48,20)
VS0(77,21)=PAz*VS0(49,21)+WPz*VS1(49,21)+r1x2Z*VR1(49,21)&
   +2D0*r1x2Z*(VS0(28,21)-ExZpE*VS1(28,21))
VS0(77,22)=PAz*VS0(49,22)+WPz*VS1(49,22)+r1x2Z*VR1(49,22)&
   +2D0*r1x2Z*(VS0(28,22)-ExZpE*VS1(28,22))
VS0(77,23)=PAz*VS0(49,23)+WPz*VS1(49,23)+r1x2Z*VR1(49,23)&
   +2D0*r1x2Z*(VS0(28,23)-ExZpE*VS1(28,23))
VS0(77,24)=PAz*VS0(49,24)+WPz*VS1(49,24)+r1x2Z*VR1(49,24)&
   +2D0*r1x2Z*(VS0(28,24)-ExZpE*VS1(28,24))
VS0(77,25)=PAz*VS0(49,25)+WPz*VS1(49,25)+r1x2Z*VR1(49,25)&
   +2D0*r1x2Z*(VS0(28,25)-ExZpE*VS1(28,25))
VS0(77,26)=PAz*VS0(49,26)+WPz*VS1(49,26)+r1x2Z*VR1(49,26)&
   +2D0*r1x2Z*(VS0(28,26)-ExZpE*VS1(28,26))&
   +HfxZpE*VS1(49,11)
VS0(77,27)=PAz*VS0(49,27)+WPz*VS1(49,27)+r1x2Z*VR1(49,27)&
   +2D0*r1x2Z*(VS0(28,27)-ExZpE*VS1(28,27))&
   +HfxZpE*VS1(49,12)
VS0(77,28)=PAz*VS0(49,28)+WPz*VS1(49,28)+r1x2Z*VR1(49,28)&
   +2D0*r1x2Z*(VS0(28,28)-ExZpE*VS1(28,28))&
   +HfxZpE*VS1(49,13)
VS0(77,29)=PAz*VS0(49,29)+WPz*VS1(49,29)+r1x2Z*VR1(49,29)&
   +2D0*r1x2Z*(VS0(28,29)-ExZpE*VS1(28,29))&
   +HfxZpE*VS1(49,14)
VS0(77,30)=PAz*VS0(49,30)+WPz*VS1(49,30)+r1x2Z*VR1(49,30)&
   +2D0*r1x2Z*(VS0(28,30)-ExZpE*VS1(28,30))&
   +2D0*HfxZpE*VS1(49,15)
VS0(77,31)=PAz*VS0(49,31)+WPz*VS1(49,31)+r1x2Z*VR1(49,31)&
   +2D0*r1x2Z*(VS0(28,31)-ExZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(49,16)
VS0(77,32)=PAz*VS0(49,32)+WPz*VS1(49,32)+r1x2Z*VR1(49,32)&
   +2D0*r1x2Z*(VS0(28,32)-ExZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(49,17)
VS0(77,33)=PAz*VS0(49,33)+WPz*VS1(49,33)+r1x2Z*VR1(49,33)&
   +2D0*r1x2Z*(VS0(28,33)-ExZpE*VS1(28,33))&
   +3D0*HfxZpE*VS1(49,18)
VS0(77,34)=PAz*VS0(49,34)+WPz*VS1(49,34)+r1x2Z*VR1(49,34)&
   +2D0*r1x2Z*(VS0(28,34)-ExZpE*VS1(28,34))&
   +3D0*HfxZpE*VS1(49,19)
VS0(77,35)=PAz*VS0(49,35)+WPz*VS1(49,35)+r1x2Z*VR1(49,35)&
   +2D0*r1x2Z*(VS0(28,35)-ExZpE*VS1(28,35))&
   +4D0*HfxZpE*VS1(49,20)
VS0(78,21)=PAy*VS0(53,21)+WPy*VS1(53,21)&
   +2D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(78,22)=PAy*VS0(53,22)+WPy*VS1(53,22)&
   +2D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))&
   +HfxZpE*VS1(53,11)
VS0(78,23)=PAy*VS0(53,23)+WPy*VS1(53,23)&
   +2D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))&
   +2D0*HfxZpE*VS1(53,12)
VS0(78,24)=PAy*VS0(53,24)+WPy*VS1(53,24)&
   +2D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))&
   +3D0*HfxZpE*VS1(53,13)
VS0(78,25)=PAy*VS0(53,25)+WPy*VS1(53,25)&
   +2D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))&
   +4D0*HfxZpE*VS1(53,14)
VS0(78,26)=PAy*VS0(53,26)+WPy*VS1(53,26)&
   +2D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))
VS0(78,27)=PAy*VS0(53,27)+WPy*VS1(53,27)&
   +2D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(53,15)
VS0(78,28)=PAy*VS0(53,28)+WPy*VS1(53,28)&
   +2D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +2D0*HfxZpE*VS1(53,16)
VS0(78,29)=PAy*VS0(53,29)+WPy*VS1(53,29)&
   +2D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +3D0*HfxZpE*VS1(53,17)
VS0(78,30)=PAy*VS0(53,30)+WPy*VS1(53,30)&
   +2D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))
VS0(78,31)=PAy*VS0(53,31)+WPy*VS1(53,31)&
   +2D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +HfxZpE*VS1(53,18)
VS0(78,32)=PAy*VS0(53,32)+WPy*VS1(53,32)&
   +2D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(53,19)
VS0(78,33)=PAy*VS0(53,33)+WPy*VS1(53,33)&
   +2D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))
VS0(78,34)=PAy*VS0(53,34)+WPy*VS1(53,34)&
   +2D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +HfxZpE*VS1(53,20)
VS0(78,35)=PAy*VS0(53,35)+WPy*VS1(53,35)&
   +2D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))
VS0(79,21)=PAz*VS0(51,21)+WPz*VS1(51,21)+r1x2Z*VR1(51,21)&
   +3D0*r1x2Z*(VS0(30,21)-ExZpE*VS1(30,21))
VS0(79,22)=PAz*VS0(51,22)+WPz*VS1(51,22)+r1x2Z*VR1(51,22)&
   +3D0*r1x2Z*(VS0(30,22)-ExZpE*VS1(30,22))
VS0(79,23)=PAz*VS0(51,23)+WPz*VS1(51,23)+r1x2Z*VR1(51,23)&
   +3D0*r1x2Z*(VS0(30,23)-ExZpE*VS1(30,23))
VS0(79,24)=PAz*VS0(51,24)+WPz*VS1(51,24)+r1x2Z*VR1(51,24)&
   +3D0*r1x2Z*(VS0(30,24)-ExZpE*VS1(30,24))
VS0(79,25)=PAz*VS0(51,25)+WPz*VS1(51,25)+r1x2Z*VR1(51,25)&
   +3D0*r1x2Z*(VS0(30,25)-ExZpE*VS1(30,25))
VS0(79,26)=PAz*VS0(51,26)+WPz*VS1(51,26)+r1x2Z*VR1(51,26)&
   +3D0*r1x2Z*(VS0(30,26)-ExZpE*VS1(30,26))&
   +HfxZpE*VS1(51,11)
VS0(79,27)=PAz*VS0(51,27)+WPz*VS1(51,27)+r1x2Z*VR1(51,27)&
   +3D0*r1x2Z*(VS0(30,27)-ExZpE*VS1(30,27))&
   +HfxZpE*VS1(51,12)
VS0(79,28)=PAz*VS0(51,28)+WPz*VS1(51,28)+r1x2Z*VR1(51,28)&
   +3D0*r1x2Z*(VS0(30,28)-ExZpE*VS1(30,28))&
   +HfxZpE*VS1(51,13)
VS0(79,29)=PAz*VS0(51,29)+WPz*VS1(51,29)+r1x2Z*VR1(51,29)&
   +3D0*r1x2Z*(VS0(30,29)-ExZpE*VS1(30,29))&
   +HfxZpE*VS1(51,14)
VS0(79,30)=PAz*VS0(51,30)+WPz*VS1(51,30)+r1x2Z*VR1(51,30)&
   +3D0*r1x2Z*(VS0(30,30)-ExZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(51,15)
VS0(79,31)=PAz*VS0(51,31)+WPz*VS1(51,31)+r1x2Z*VR1(51,31)&
   +3D0*r1x2Z*(VS0(30,31)-ExZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(51,16)
VS0(79,32)=PAz*VS0(51,32)+WPz*VS1(51,32)+r1x2Z*VR1(51,32)&
   +3D0*r1x2Z*(VS0(30,32)-ExZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(51,17)
VS0(79,33)=PAz*VS0(51,33)+WPz*VS1(51,33)+r1x2Z*VR1(51,33)&
   +3D0*r1x2Z*(VS0(30,33)-ExZpE*VS1(30,33))&
   +3D0*HfxZpE*VS1(51,18)
VS0(79,34)=PAz*VS0(51,34)+WPz*VS1(51,34)+r1x2Z*VR1(51,34)&
   +3D0*r1x2Z*(VS0(30,34)-ExZpE*VS1(30,34))&
   +3D0*HfxZpE*VS1(51,19)
VS0(79,35)=PAz*VS0(51,35)+WPz*VS1(51,35)+r1x2Z*VR1(51,35)&
   +3D0*r1x2Z*(VS0(30,35)-ExZpE*VS1(30,35))&
   +4D0*HfxZpE*VS1(51,20)
VS0(80,21)=PAz*VS0(52,21)+WPz*VS1(52,21)+r1x2Z*VR1(52,21)&
   +3D0*r1x2Z*(VS0(31,21)-ExZpE*VS1(31,21))
VS0(80,22)=PAz*VS0(52,22)+WPz*VS1(52,22)+r1x2Z*VR1(52,22)&
   +3D0*r1x2Z*(VS0(31,22)-ExZpE*VS1(31,22))
VS0(80,23)=PAz*VS0(52,23)+WPz*VS1(52,23)+r1x2Z*VR1(52,23)&
   +3D0*r1x2Z*(VS0(31,23)-ExZpE*VS1(31,23))
VS0(80,24)=PAz*VS0(52,24)+WPz*VS1(52,24)+r1x2Z*VR1(52,24)&
   +3D0*r1x2Z*(VS0(31,24)-ExZpE*VS1(31,24))
VS0(80,25)=PAz*VS0(52,25)+WPz*VS1(52,25)+r1x2Z*VR1(52,25)&
   +3D0*r1x2Z*(VS0(31,25)-ExZpE*VS1(31,25))
VS0(80,26)=PAz*VS0(52,26)+WPz*VS1(52,26)+r1x2Z*VR1(52,26)&
   +3D0*r1x2Z*(VS0(31,26)-ExZpE*VS1(31,26))&
   +HfxZpE*VS1(52,11)
VS0(80,27)=PAz*VS0(52,27)+WPz*VS1(52,27)+r1x2Z*VR1(52,27)&
   +3D0*r1x2Z*(VS0(31,27)-ExZpE*VS1(31,27))&
   +HfxZpE*VS1(52,12)
VS0(80,28)=PAz*VS0(52,28)+WPz*VS1(52,28)+r1x2Z*VR1(52,28)&
   +3D0*r1x2Z*(VS0(31,28)-ExZpE*VS1(31,28))&
   +HfxZpE*VS1(52,13)
VS0(80,29)=PAz*VS0(52,29)+WPz*VS1(52,29)+r1x2Z*VR1(52,29)&
   +3D0*r1x2Z*(VS0(31,29)-ExZpE*VS1(31,29))&
   +HfxZpE*VS1(52,14)
VS0(80,30)=PAz*VS0(52,30)+WPz*VS1(52,30)+r1x2Z*VR1(52,30)&
   +3D0*r1x2Z*(VS0(31,30)-ExZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(52,15)
VS0(80,31)=PAz*VS0(52,31)+WPz*VS1(52,31)+r1x2Z*VR1(52,31)&
   +3D0*r1x2Z*(VS0(31,31)-ExZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(52,16)
VS0(80,32)=PAz*VS0(52,32)+WPz*VS1(52,32)+r1x2Z*VR1(52,32)&
   +3D0*r1x2Z*(VS0(31,32)-ExZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(52,17)
VS0(80,33)=PAz*VS0(52,33)+WPz*VS1(52,33)+r1x2Z*VR1(52,33)&
   +3D0*r1x2Z*(VS0(31,33)-ExZpE*VS1(31,33))&
   +3D0*HfxZpE*VS1(52,18)
VS0(80,34)=PAz*VS0(52,34)+WPz*VS1(52,34)+r1x2Z*VR1(52,34)&
   +3D0*r1x2Z*(VS0(31,34)-ExZpE*VS1(31,34))&
   +3D0*HfxZpE*VS1(52,19)
VS0(80,35)=PAz*VS0(52,35)+WPz*VS1(52,35)+r1x2Z*VR1(52,35)&
   +3D0*r1x2Z*(VS0(31,35)-ExZpE*VS1(31,35))&
   +4D0*HfxZpE*VS1(52,20)
VS0(81,21)=PAz*VS0(53,21)+WPz*VS1(53,21)+r1x2Z*VR1(53,21)&
   +3D0*r1x2Z*(VS0(32,21)-ExZpE*VS1(32,21))
VS0(81,22)=PAz*VS0(53,22)+WPz*VS1(53,22)+r1x2Z*VR1(53,22)&
   +3D0*r1x2Z*(VS0(32,22)-ExZpE*VS1(32,22))
VS0(81,23)=PAz*VS0(53,23)+WPz*VS1(53,23)+r1x2Z*VR1(53,23)&
   +3D0*r1x2Z*(VS0(32,23)-ExZpE*VS1(32,23))
VS0(81,24)=PAz*VS0(53,24)+WPz*VS1(53,24)+r1x2Z*VR1(53,24)&
   +3D0*r1x2Z*(VS0(32,24)-ExZpE*VS1(32,24))
VS0(81,25)=PAz*VS0(53,25)+WPz*VS1(53,25)+r1x2Z*VR1(53,25)&
   +3D0*r1x2Z*(VS0(32,25)-ExZpE*VS1(32,25))
VS0(81,26)=PAz*VS0(53,26)+WPz*VS1(53,26)+r1x2Z*VR1(53,26)&
   +3D0*r1x2Z*(VS0(32,26)-ExZpE*VS1(32,26))&
   +HfxZpE*VS1(53,11)
VS0(81,27)=PAz*VS0(53,27)+WPz*VS1(53,27)+r1x2Z*VR1(53,27)&
   +3D0*r1x2Z*(VS0(32,27)-ExZpE*VS1(32,27))&
   +HfxZpE*VS1(53,12)
VS0(81,28)=PAz*VS0(53,28)+WPz*VS1(53,28)+r1x2Z*VR1(53,28)&
   +3D0*r1x2Z*(VS0(32,28)-ExZpE*VS1(32,28))&
   +HfxZpE*VS1(53,13)
VS0(81,29)=PAz*VS0(53,29)+WPz*VS1(53,29)+r1x2Z*VR1(53,29)&
   +3D0*r1x2Z*(VS0(32,29)-ExZpE*VS1(32,29))&
   +HfxZpE*VS1(53,14)
VS0(81,30)=PAz*VS0(53,30)+WPz*VS1(53,30)+r1x2Z*VR1(53,30)&
   +3D0*r1x2Z*(VS0(32,30)-ExZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(53,15)
VS0(81,31)=PAz*VS0(53,31)+WPz*VS1(53,31)+r1x2Z*VR1(53,31)&
   +3D0*r1x2Z*(VS0(32,31)-ExZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(53,16)
VS0(81,32)=PAz*VS0(53,32)+WPz*VS1(53,32)+r1x2Z*VR1(53,32)&
   +3D0*r1x2Z*(VS0(32,32)-ExZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(53,17)
VS0(81,33)=PAz*VS0(53,33)+WPz*VS1(53,33)+r1x2Z*VR1(53,33)&
   +3D0*r1x2Z*(VS0(32,33)-ExZpE*VS1(32,33))&
   +3D0*HfxZpE*VS1(53,18)
VS0(81,34)=PAz*VS0(53,34)+WPz*VS1(53,34)+r1x2Z*VR1(53,34)&
   +3D0*r1x2Z*(VS0(32,34)-ExZpE*VS1(32,34))&
   +3D0*HfxZpE*VS1(53,19)
VS0(81,35)=PAz*VS0(53,35)+WPz*VS1(53,35)+r1x2Z*VR1(53,35)&
   +3D0*r1x2Z*(VS0(32,35)-ExZpE*VS1(32,35))&
   +4D0*HfxZpE*VS1(53,20)
VS0(82,21)=PAz*VS0(54,21)+WPz*VS1(54,21)+r1x2Z*VR1(54,21)&
   +4D0*r1x2Z*(VS0(33,21)-ExZpE*VS1(33,21))
VS0(82,22)=PAz*VS0(54,22)+WPz*VS1(54,22)+r1x2Z*VR1(54,22)&
   +4D0*r1x2Z*(VS0(33,22)-ExZpE*VS1(33,22))
VS0(82,23)=PAz*VS0(54,23)+WPz*VS1(54,23)+r1x2Z*VR1(54,23)&
   +4D0*r1x2Z*(VS0(33,23)-ExZpE*VS1(33,23))
VS0(82,24)=PAz*VS0(54,24)+WPz*VS1(54,24)+r1x2Z*VR1(54,24)&
   +4D0*r1x2Z*(VS0(33,24)-ExZpE*VS1(33,24))
VS0(82,25)=PAz*VS0(54,25)+WPz*VS1(54,25)+r1x2Z*VR1(54,25)&
   +4D0*r1x2Z*(VS0(33,25)-ExZpE*VS1(33,25))
VS0(82,26)=PAz*VS0(54,26)+WPz*VS1(54,26)+r1x2Z*VR1(54,26)&
   +4D0*r1x2Z*(VS0(33,26)-ExZpE*VS1(33,26))&
   +HfxZpE*VS1(54,11)
VS0(82,27)=PAz*VS0(54,27)+WPz*VS1(54,27)+r1x2Z*VR1(54,27)&
   +4D0*r1x2Z*(VS0(33,27)-ExZpE*VS1(33,27))&
   +HfxZpE*VS1(54,12)
VS0(82,28)=PAz*VS0(54,28)+WPz*VS1(54,28)+r1x2Z*VR1(54,28)&
   +4D0*r1x2Z*(VS0(33,28)-ExZpE*VS1(33,28))&
   +HfxZpE*VS1(54,13)
VS0(82,29)=PAz*VS0(54,29)+WPz*VS1(54,29)+r1x2Z*VR1(54,29)&
   +4D0*r1x2Z*(VS0(33,29)-ExZpE*VS1(33,29))&
   +HfxZpE*VS1(54,14)
VS0(82,30)=PAz*VS0(54,30)+WPz*VS1(54,30)+r1x2Z*VR1(54,30)&
   +4D0*r1x2Z*(VS0(33,30)-ExZpE*VS1(33,30))&
   +2D0*HfxZpE*VS1(54,15)
VS0(82,31)=PAz*VS0(54,31)+WPz*VS1(54,31)+r1x2Z*VR1(54,31)&
   +4D0*r1x2Z*(VS0(33,31)-ExZpE*VS1(33,31))&
   +2D0*HfxZpE*VS1(54,16)
VS0(82,32)=PAz*VS0(54,32)+WPz*VS1(54,32)+r1x2Z*VR1(54,32)&
   +4D0*r1x2Z*(VS0(33,32)-ExZpE*VS1(33,32))&
   +2D0*HfxZpE*VS1(54,17)
VS0(82,33)=PAz*VS0(54,33)+WPz*VS1(54,33)+r1x2Z*VR1(54,33)&
   +4D0*r1x2Z*(VS0(33,33)-ExZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(54,18)
VS0(82,34)=PAz*VS0(54,34)+WPz*VS1(54,34)+r1x2Z*VR1(54,34)&
   +4D0*r1x2Z*(VS0(33,34)-ExZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(54,19)
VS0(82,35)=PAz*VS0(54,35)+WPz*VS1(54,35)+r1x2Z*VR1(54,35)&
   +4D0*r1x2Z*(VS0(33,35)-ExZpE*VS1(33,35))&
   +4D0*HfxZpE*VS1(54,20)
VS0(83,21)=PAz*VS0(55,21)+WPz*VS1(55,21)+r1x2Z*VR1(55,21)&
   +4D0*r1x2Z*(VS0(34,21)-ExZpE*VS1(34,21))
VS0(83,22)=PAz*VS0(55,22)+WPz*VS1(55,22)+r1x2Z*VR1(55,22)&
   +4D0*r1x2Z*(VS0(34,22)-ExZpE*VS1(34,22))
VS0(83,23)=PAz*VS0(55,23)+WPz*VS1(55,23)+r1x2Z*VR1(55,23)&
   +4D0*r1x2Z*(VS0(34,23)-ExZpE*VS1(34,23))
VS0(83,24)=PAz*VS0(55,24)+WPz*VS1(55,24)+r1x2Z*VR1(55,24)&
   +4D0*r1x2Z*(VS0(34,24)-ExZpE*VS1(34,24))
VS0(83,25)=PAz*VS0(55,25)+WPz*VS1(55,25)+r1x2Z*VR1(55,25)&
   +4D0*r1x2Z*(VS0(34,25)-ExZpE*VS1(34,25))
VS0(83,26)=PAz*VS0(55,26)+WPz*VS1(55,26)+r1x2Z*VR1(55,26)&
   +4D0*r1x2Z*(VS0(34,26)-ExZpE*VS1(34,26))&
   +HfxZpE*VS1(55,11)
VS0(83,27)=PAz*VS0(55,27)+WPz*VS1(55,27)+r1x2Z*VR1(55,27)&
   +4D0*r1x2Z*(VS0(34,27)-ExZpE*VS1(34,27))&
   +HfxZpE*VS1(55,12)
VS0(83,28)=PAz*VS0(55,28)+WPz*VS1(55,28)+r1x2Z*VR1(55,28)&
   +4D0*r1x2Z*(VS0(34,28)-ExZpE*VS1(34,28))&
   +HfxZpE*VS1(55,13)
VS0(83,29)=PAz*VS0(55,29)+WPz*VS1(55,29)+r1x2Z*VR1(55,29)&
   +4D0*r1x2Z*(VS0(34,29)-ExZpE*VS1(34,29))&
   +HfxZpE*VS1(55,14)
VS0(83,30)=PAz*VS0(55,30)+WPz*VS1(55,30)+r1x2Z*VR1(55,30)&
   +4D0*r1x2Z*(VS0(34,30)-ExZpE*VS1(34,30))&
   +2D0*HfxZpE*VS1(55,15)
VS0(83,31)=PAz*VS0(55,31)+WPz*VS1(55,31)+r1x2Z*VR1(55,31)&
   +4D0*r1x2Z*(VS0(34,31)-ExZpE*VS1(34,31))&
   +2D0*HfxZpE*VS1(55,16)
VS0(83,32)=PAz*VS0(55,32)+WPz*VS1(55,32)+r1x2Z*VR1(55,32)&
   +4D0*r1x2Z*(VS0(34,32)-ExZpE*VS1(34,32))&
   +2D0*HfxZpE*VS1(55,17)
VS0(83,33)=PAz*VS0(55,33)+WPz*VS1(55,33)+r1x2Z*VR1(55,33)&
   +4D0*r1x2Z*(VS0(34,33)-ExZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(55,18)
VS0(83,34)=PAz*VS0(55,34)+WPz*VS1(55,34)+r1x2Z*VR1(55,34)&
   +4D0*r1x2Z*(VS0(34,34)-ExZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(55,19)
VS0(83,35)=PAz*VS0(55,35)+WPz*VS1(55,35)+r1x2Z*VR1(55,35)&
   +4D0*r1x2Z*(VS0(34,35)-ExZpE*VS1(34,35))&
   +4D0*HfxZpE*VS1(55,20)
VS0(84,21)=PAz*VS0(56,21)+WPz*VS1(56,21)+r1x2Z*VR1(56,21)&
   +5D0*r1x2Z*(VS0(35,21)-ExZpE*VS1(35,21))
VS0(84,22)=PAz*VS0(56,22)+WPz*VS1(56,22)+r1x2Z*VR1(56,22)&
   +5D0*r1x2Z*(VS0(35,22)-ExZpE*VS1(35,22))
VS0(84,23)=PAz*VS0(56,23)+WPz*VS1(56,23)+r1x2Z*VR1(56,23)&
   +5D0*r1x2Z*(VS0(35,23)-ExZpE*VS1(35,23))
VS0(84,24)=PAz*VS0(56,24)+WPz*VS1(56,24)+r1x2Z*VR1(56,24)&
   +5D0*r1x2Z*(VS0(35,24)-ExZpE*VS1(35,24))
VS0(84,25)=PAz*VS0(56,25)+WPz*VS1(56,25)+r1x2Z*VR1(56,25)&
   +5D0*r1x2Z*(VS0(35,25)-ExZpE*VS1(35,25))
VS0(84,26)=PAz*VS0(56,26)+WPz*VS1(56,26)+r1x2Z*VR1(56,26)&
   +5D0*r1x2Z*(VS0(35,26)-ExZpE*VS1(35,26))&
   +HfxZpE*VS1(56,11)
VS0(84,27)=PAz*VS0(56,27)+WPz*VS1(56,27)+r1x2Z*VR1(56,27)&
   +5D0*r1x2Z*(VS0(35,27)-ExZpE*VS1(35,27))&
   +HfxZpE*VS1(56,12)
VS0(84,28)=PAz*VS0(56,28)+WPz*VS1(56,28)+r1x2Z*VR1(56,28)&
   +5D0*r1x2Z*(VS0(35,28)-ExZpE*VS1(35,28))&
   +HfxZpE*VS1(56,13)
VS0(84,29)=PAz*VS0(56,29)+WPz*VS1(56,29)+r1x2Z*VR1(56,29)&
   +5D0*r1x2Z*(VS0(35,29)-ExZpE*VS1(35,29))&
   +HfxZpE*VS1(56,14)
VS0(84,30)=PAz*VS0(56,30)+WPz*VS1(56,30)+r1x2Z*VR1(56,30)&
   +5D0*r1x2Z*(VS0(35,30)-ExZpE*VS1(35,30))&
   +2D0*HfxZpE*VS1(56,15)
VS0(84,31)=PAz*VS0(56,31)+WPz*VS1(56,31)+r1x2Z*VR1(56,31)&
   +5D0*r1x2Z*(VS0(35,31)-ExZpE*VS1(35,31))&
   +2D0*HfxZpE*VS1(56,16)
VS0(84,32)=PAz*VS0(56,32)+WPz*VS1(56,32)+r1x2Z*VR1(56,32)&
   +5D0*r1x2Z*(VS0(35,32)-ExZpE*VS1(35,32))&
   +2D0*HfxZpE*VS1(56,17)
VS0(84,33)=PAz*VS0(56,33)+WPz*VS1(56,33)+r1x2Z*VR1(56,33)&
   +5D0*r1x2Z*(VS0(35,33)-ExZpE*VS1(35,33))&
   +3D0*HfxZpE*VS1(56,18)
VS0(84,34)=PAz*VS0(56,34)+WPz*VS1(56,34)+r1x2Z*VR1(56,34)&
   +5D0*r1x2Z*(VS0(35,34)-ExZpE*VS1(35,34))&
   +3D0*HfxZpE*VS1(56,19)
VS0(84,35)=PAz*VS0(56,35)+WPz*VS1(56,35)+r1x2Z*VR1(56,35)&
   +5D0*r1x2Z*(VS0(35,35)-ExZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(56,20)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRi0g0'
STOP
END SELECT
END SUBROUTINE MVRRi0g0
