!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRi0f0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(23,11)
      V(2)=3.D0*V(1)
      V(3)=ExZpE*r1x2Z*VRR1(23,11)
      V(4)=-3.D0*V(3)
      V(5)=r1x2Z*VRR0(23,12)
      V(6)=3.D0*V(5)
      V(7)=ExZpE*r1x2Z*VRR1(23,12)
      V(8)=-3.D0*V(7)
      V(9)=r1x2Z*VRR0(23,13)
      V(10)=3.D0*V(9)
      V(11)=ExZpE*r1x2Z*VRR1(23,13)
      V(12)=-3.D0*V(11)
      V(13)=HfxZpE*VRR1(38,7)
      V(14)=r1x2Z*VRR0(23,14)
      V(15)=3.D0*V(14)
      V(16)=ExZpE*r1x2Z*VRR1(23,14)
      V(17)=-3.D0*V(16)
      V(18)=r1x2Z*VRR0(23,15)
      V(19)=3.D0*V(18)
      V(20)=ExZpE*r1x2Z*VRR1(23,15)
      V(21)=-3.D0*V(20)
      V(22)=r1x2Z*VRR0(23,16)
      V(23)=3.D0*V(22)
      V(24)=ExZpE*r1x2Z*VRR1(23,16)
      V(25)=-3.D0*V(24)
      V(26)=r1x2Z*VRR0(23,17)
      V(27)=3.D0*V(26)
      V(28)=ExZpE*r1x2Z*VRR1(23,17)
      V(29)=-3.D0*V(28)
      V(30)=r1x2Z*VRR0(23,18)
      V(31)=3.D0*V(30)
      V(32)=ExZpE*r1x2Z*VRR1(23,18)
      V(33)=-3.D0*V(32)
      V(34)=HfxZpE*VRR1(38,10)
      V(35)=r1x2Z*VRR0(23,19)
      V(36)=3.D0*V(35)
      V(37)=ExZpE*r1x2Z*VRR1(23,19)
      V(38)=-3.D0*V(37)
      V(39)=r1x2Z*VRR0(23,20)
      V(40)=3.D0*V(39)
      V(41)=ExZpE*r1x2Z*VRR1(23,20)
      V(42)=-3.D0*V(41)
      V(43)=HfxZpE*VRR1(39,5)
      V(44)=r1x2Z*VRR0(24,12)
      V(45)=ExZpE*r1x2Z*VRR1(24,12)
      V(46)=HfxZpE*VRR1(39,6)
      V(47)=2.D0*V(46)
      V(48)=r1x2Z*VRR0(24,13)
      V(49)=ExZpE*r1x2Z*VRR1(24,13)
      V(50)=HfxZpE*VRR1(39,7)
      V(51)=r1x2Z*VRR0(24,15)
      V(52)=ExZpE*r1x2Z*VRR1(24,15)
      V(53)=HfxZpE*VRR1(39,8)
      V(54)=r1x2Z*VRR0(24,16)
      V(55)=ExZpE*r1x2Z*VRR1(24,16)
      V(56)=HfxZpE*VRR1(39,9)
      V(57)=r1x2Z*VRR0(24,17)
      V(58)=ExZpE*r1x2Z*VRR1(24,17)
      V(59)=r1x2Z*VRR0(24,18)
      V(60)=ExZpE*r1x2Z*VRR1(24,18)
      V(61)=HfxZpE*VRR1(39,10)
      V(62)=r1x2Z*VRR0(24,19)
      V(63)=ExZpE*r1x2Z*VRR1(24,19)
      V(64)=r1x2Z*VRR0(27,12)
      V(65)=ExZpE*r1x2Z*VRR1(27,12)
      V(66)=r1x2Z*VRR0(27,13)
      V(67)=ExZpE*r1x2Z*VRR1(27,13)
      V(68)=HfxZpE*VRR1(43,7)
      V(69)=r1x2Z*VRR0(27,15)
      V(70)=ExZpE*r1x2Z*VRR1(27,15)
      V(71)=r1x2Z*VRR0(27,16)
      V(72)=ExZpE*r1x2Z*VRR1(27,16)
      V(73)=r1x2Z*VRR0(27,17)
      V(74)=ExZpE*r1x2Z*VRR1(27,17)
      V(75)=r1x2Z*VRR0(27,18)
      V(76)=ExZpE*r1x2Z*VRR1(27,18)
      V(77)=HfxZpE*VRR1(43,10)
      V(78)=r1x2Z*VRR0(27,19)
      V(79)=ExZpE*r1x2Z*VRR1(27,19)
      V(80)=HfxZpE*VRR1(44,5)
      V(81)=r1x2Z*VRR0(28,12)
      V(82)=2.D0*V(81)
      V(83)=ExZpE*r1x2Z*VRR1(28,12)
      V(84)=-2.D0*V(83)
      V(85)=HfxZpE*VRR1(44,6)
      V(86)=2.D0*V(85)
      V(87)=r1x2Z*VRR0(28,13)
      V(88)=2.D0*V(87)
      V(89)=ExZpE*r1x2Z*VRR1(28,13)
      V(90)=-2.D0*V(89)
      V(91)=HfxZpE*VRR1(44,7)
      V(92)=r1x2Z*VRR0(28,15)
      V(93)=2.D0*V(92)
      V(94)=ExZpE*r1x2Z*VRR1(28,15)
      V(95)=-2.D0*V(94)
      V(96)=HfxZpE*VRR1(44,8)
      V(97)=2.D0*V(96)
      V(98)=r1x2Z*VRR0(28,16)
      V(99)=2.D0*V(98)
      V(100)=ExZpE*r1x2Z*VRR1(28,16)
      V(101)=-2.D0*V(100)
      V(102)=HfxZpE*VRR1(44,9)
      V(103)=r1x2Z*VRR0(28,17)
      V(104)=2.D0*V(103)
      V(105)=ExZpE*r1x2Z*VRR1(28,17)
      V(106)=-2.D0*V(105)
      V(107)=r1x2Z*VRR0(28,18)
      V(108)=2.D0*V(107)
      V(109)=ExZpE*r1x2Z*VRR1(28,18)
      V(110)=-2.D0*V(109)
      V(111)=HfxZpE*VRR1(44,10)
      V(112)=r1x2Z*VRR0(28,19)
      V(113)=2.D0*V(112)
      V(114)=ExZpE*r1x2Z*VRR1(28,19)
      V(115)=-2.D0*V(114)
      V(116)=HfxZpE*VRR1(45,5)
      V(117)=2.D0*V(64)
      V(118)=-2.D0*V(65)
      V(119)=2.D0*V(66)
      V(120)=-2.D0*V(67)
      V(121)=2.D0*V(69)
      V(122)=-2.D0*V(70)
      V(123)=2.D0*V(71)
      V(124)=-2.D0*V(72)
      V(125)=2.D0*V(73)
      V(126)=-2.D0*V(74)
      V(127)=2.D0*V(102)
      V(128)=2.D0*V(75)
      V(129)=-2.D0*V(76)
      V(130)=2.D0*V(78)
      V(131)=-2.D0*V(79)
      V(132)=HfxZpE*VRR1(45,10)
      V(133)=r1x2Z*VRR0(30,11)
      V(134)=3.D0*V(133)
      V(135)=ExZpE*r1x2Z*VRR1(30,11)
      V(136)=-3.D0*V(135)
      V(137)=r1x2Z*VRR0(30,12)
      V(138)=3.D0*V(137)
      V(139)=ExZpE*r1x2Z*VRR1(30,12)
      V(140)=-3.D0*V(139)
      V(141)=r1x2Z*VRR0(30,13)
      V(142)=3.D0*V(141)
      V(143)=ExZpE*r1x2Z*VRR1(30,13)
      V(144)=-3.D0*V(143)
      V(145)=HfxZpE*VRR1(47,7)
      V(146)=r1x2Z*VRR0(30,14)
      V(147)=3.D0*V(146)
      V(148)=ExZpE*r1x2Z*VRR1(30,14)
      V(149)=-3.D0*V(148)
      V(150)=r1x2Z*VRR0(30,15)
      V(151)=3.D0*V(150)
      V(152)=ExZpE*r1x2Z*VRR1(30,15)
      V(153)=-3.D0*V(152)
      V(154)=r1x2Z*VRR0(30,16)
      V(155)=3.D0*V(154)
      V(156)=ExZpE*r1x2Z*VRR1(30,16)
      V(157)=-3.D0*V(156)
      V(158)=r1x2Z*VRR0(30,17)
      V(159)=3.D0*V(158)
      V(160)=ExZpE*r1x2Z*VRR1(30,17)
      V(161)=-3.D0*V(160)
      V(162)=r1x2Z*VRR0(30,18)
      V(163)=3.D0*V(162)
      V(164)=ExZpE*r1x2Z*VRR1(30,18)
      V(165)=-3.D0*V(164)
      V(166)=HfxZpE*VRR1(47,10)
      V(167)=r1x2Z*VRR0(30,19)
      V(168)=3.D0*V(167)
      V(169)=ExZpE*r1x2Z*VRR1(30,19)
      V(170)=-3.D0*V(169)
      V(171)=r1x2Z*VRR0(30,20)
      V(172)=3.D0*V(171)
      V(173)=ExZpE*r1x2Z*VRR1(30,20)
      V(174)=-3.D0*V(173)
      V(175)=HfxZpE*VRR1(48,5)
      V(176)=r1x2Z*VRR0(31,12)
      V(177)=2.D0*V(176)
      V(178)=ExZpE*r1x2Z*VRR1(31,12)
      V(179)=-2.D0*V(178)
      V(180)=HfxZpE*VRR1(48,6)
      V(181)=2.D0*V(180)
      V(182)=r1x2Z*VRR0(31,13)
      V(183)=2.D0*V(182)
      V(184)=ExZpE*r1x2Z*VRR1(31,13)
      V(185)=-2.D0*V(184)
      V(186)=HfxZpE*VRR1(48,7)
      V(187)=r1x2Z*VRR0(31,15)
      V(188)=2.D0*V(187)
      V(189)=ExZpE*r1x2Z*VRR1(31,15)
      V(190)=-2.D0*V(189)
      V(191)=HfxZpE*VRR1(48,8)
      V(192)=2.D0*V(191)
      V(193)=r1x2Z*VRR0(31,16)
      V(194)=2.D0*V(193)
      V(195)=ExZpE*r1x2Z*VRR1(31,16)
      V(196)=-2.D0*V(195)
      V(197)=HfxZpE*VRR1(48,9)
      V(198)=r1x2Z*VRR0(31,17)
      V(199)=2.D0*V(198)
      V(200)=ExZpE*r1x2Z*VRR1(31,17)
      V(201)=-2.D0*V(200)
      V(202)=r1x2Z*VRR0(31,18)
      V(203)=2.D0*V(202)
      V(204)=ExZpE*r1x2Z*VRR1(31,18)
      V(205)=-2.D0*V(204)
      V(206)=HfxZpE*VRR1(48,10)
      V(207)=r1x2Z*VRR0(31,19)
      V(208)=2.D0*V(207)
      V(209)=ExZpE*r1x2Z*VRR1(31,19)
      V(210)=-2.D0*V(209)
      V(211)=r1x2E*VRR0(72,2)
      V(212)=HfxZpE*VRR1(49,5)
      V(213)=r1x2E*ZxZpE*VRR1(72,2)
      V(214)=r1x2E*VRR0(72,3)
      V(215)=HfxZpE*VRR1(49,6)
      V(216)=2.D0*V(215)
      V(217)=r1x2E*ZxZpE*VRR1(72,3)
      V(218)=-V(217)
      V(219)=-V(213)
      V(220)=r1x2E*VRR0(72,4)
      V(221)=HfxZpE*VRR1(49,8)
      V(222)=2.D0*V(221)
      V(223)=r1x2E*ZxZpE*VRR1(72,4)
      V(224)=-V(223)
      V(225)=r1x2Z*VRR0(32,16)
      V(226)=ExZpE*r1x2Z*VRR1(32,16)
      V(227)=HfxZpE*VRR1(49,9)
      V(228)=2.D0*V(197)
      V(229)=HfxZpE*VRR1(50,5)
      V(230)=HfxZpE*VRR1(49,7)
      V(231)=2.D0*V(227)
      V(232)=HfxZpE*VRR1(49,10)
      V(233)=r1x2Z*VRR0(32,11)
      V(234)=3.D0*V(233)
      V(235)=ExZpE*r1x2Z*VRR1(32,11)
      V(236)=-3.D0*V(235)
      V(237)=r1x2Z*VRR0(32,12)
      V(238)=3.D0*V(237)
      V(239)=ExZpE*r1x2Z*VRR1(32,12)
      V(240)=-3.D0*V(239)
      V(241)=r1x2Z*VRR0(32,13)
      V(242)=3.D0*V(241)
      V(243)=ExZpE*r1x2Z*VRR1(32,13)
      V(244)=-3.D0*V(243)
      V(245)=r1x2Z*VRR0(32,14)
      V(246)=3.D0*V(245)
      V(247)=ExZpE*r1x2Z*VRR1(32,14)
      V(248)=-3.D0*V(247)
      V(249)=r1x2Z*VRR0(32,15)
      V(250)=3.D0*V(249)
      V(251)=ExZpE*r1x2Z*VRR1(32,15)
      V(252)=-3.D0*V(251)
      V(253)=3.D0*V(225)
      V(254)=-3.D0*V(226)
      V(255)=r1x2Z*VRR0(32,17)
      V(256)=3.D0*V(255)
      V(257)=ExZpE*r1x2Z*VRR1(32,17)
      V(258)=-3.D0*V(257)
      V(259)=r1x2Z*VRR0(32,18)
      V(260)=3.D0*V(259)
      V(261)=ExZpE*r1x2Z*VRR1(32,18)
      V(262)=-3.D0*V(261)
      V(263)=r1x2Z*VRR0(32,19)
      V(264)=3.D0*V(263)
      V(265)=ExZpE*r1x2Z*VRR1(32,19)
      V(266)=-3.D0*V(265)
      V(267)=HfxZpE*VRR1(50,10)
      V(268)=r1x2Z*VRR0(32,20)
      V(269)=3.D0*V(268)
      V(270)=ExZpE*r1x2Z*VRR1(32,20)
      V(271)=-3.D0*V(270)
      V(272)=HfxZpE*VRR1(51,5)
      V(273)=r1x2Z*VRR0(33,12)
      V(274)=ExZpE*r1x2Z*VRR1(33,12)
      V(275)=HfxZpE*VRR1(51,6)
      V(276)=r1x2Z*VRR0(33,13)
      V(277)=ExZpE*r1x2Z*VRR1(33,13)
      V(278)=HfxZpE*VRR1(51,7)
      V(279)=r1x2Z*VRR0(33,15)
      V(280)=ExZpE*r1x2Z*VRR1(33,15)
      V(281)=HfxZpE*VRR1(51,8)
      V(282)=2.D0*V(281)
      V(283)=r1x2Z*VRR0(33,16)
      V(284)=ExZpE*r1x2Z*VRR1(33,16)
      V(285)=HfxZpE*VRR1(51,9)
      V(286)=r1x2Z*VRR0(33,17)
      V(287)=ExZpE*r1x2Z*VRR1(33,17)
      V(288)=r1x2Z*VRR0(33,18)
      V(289)=ExZpE*r1x2Z*VRR1(33,18)
      V(290)=HfxZpE*VRR1(51,10)
      V(291)=r1x2Z*VRR0(33,19)
      V(292)=ExZpE*r1x2Z*VRR1(33,19)
      V(293)=HfxZpE*VRR1(52,5)
      V(294)=HfxZpE*VRR1(53,5)
      V(295)=HfxZpE*VRR1(52,7)
      V(296)=r1x2Z*VRR0(34,12)
      V(297)=ExZpE*r1x2Z*VRR1(34,12)
      V(298)=r1x2Z*VRR0(34,13)
      V(299)=ExZpE*r1x2Z*VRR1(34,13)
      V(300)=HfxZpE*VRR1(53,6)
      V(301)=HfxZpE*VRR1(53,7)
      V(302)=r1x2Z*VRR0(34,15)
      V(303)=ExZpE*r1x2Z*VRR1(34,15)
      V(304)=r1x2Z*VRR0(34,16)
      V(305)=ExZpE*r1x2Z*VRR1(34,16)
      V(306)=HfxZpE*VRR1(53,8)
      V(307)=r1x2Z*VRR0(34,17)
      V(308)=ExZpE*r1x2Z*VRR1(34,17)
      V(309)=HfxZpE*VRR1(53,9)
      V(310)=2.D0*V(309)
      V(311)=r1x2Z*VRR0(34,18)
      V(312)=ExZpE*r1x2Z*VRR1(34,18)
      V(313)=r1x2Z*VRR0(34,19)
      V(314)=ExZpE*r1x2Z*VRR1(34,19)
      V(315)=HfxZpE*VRR1(53,10)
      VRR0(57,11)=5.D0*r1x2Z*VRR0(21,11)+PAx*VRR0(36,11)-5.D0*ExZpE*r1x2Z*VRR1(21,11)+3.D0*HfxZpE*VRR1(36,5)+WPx*VRR1(36,11)
      VRR0(57,12)=5.D0*r1x2Z*VRR0(21,12)+PAx*VRR0(36,12)-5.D0*ExZpE*r1x2Z*VRR1(21,12)+2.D0*HfxZpE*VRR1(36,6)+WPx*VRR1(36,12)
      VRR0(57,13)=5.D0*r1x2Z*VRR0(21,13)+PAx*VRR0(36,13)-5.D0*ExZpE*r1x2Z*VRR1(21,13)+HfxZpE*VRR1(36,7)+WPx*VRR1(36,13)
      VRR0(57,14)=5.D0*r1x2Z*VRR0(21,14)+PAx*VRR0(36,14)-5.D0*ExZpE*r1x2Z*VRR1(21,14)+WPx*VRR1(36,14)
      VRR0(57,15)=5.D0*r1x2Z*VRR0(21,15)+PAx*VRR0(36,15)-5.D0*ExZpE*r1x2Z*VRR1(21,15)+2.D0*HfxZpE*VRR1(36,8)+WPx*VRR1(36,15)
      VRR0(57,16)=5.D0*r1x2Z*VRR0(21,16)+PAx*VRR0(36,16)-5.D0*ExZpE*r1x2Z*VRR1(21,16)+HfxZpE*VRR1(36,9)+WPx*VRR1(36,16)
      VRR0(57,17)=5.D0*r1x2Z*VRR0(21,17)+PAx*VRR0(36,17)-5.D0*ExZpE*r1x2Z*VRR1(21,17)+WPx*VRR1(36,17)
      VRR0(57,18)=5.D0*r1x2Z*VRR0(21,18)+PAx*VRR0(36,18)-5.D0*ExZpE*r1x2Z*VRR1(21,18)+HfxZpE*VRR1(36,10)+WPx*VRR1(36,18)
      VRR0(57,19)=5.D0*r1x2Z*VRR0(21,19)+PAx*VRR0(36,19)-5.D0*ExZpE*r1x2Z*VRR1(21,19)+WPx*VRR1(36,19)
      VRR0(57,20)=5.D0*r1x2Z*VRR0(21,20)+PAx*VRR0(36,20)-5.D0*ExZpE*r1x2Z*VRR1(21,20)+WPx*VRR1(36,20)
      VRR0(58,11)=4.D0*r1x2Z*VRR0(22,11)+PAx*VRR0(37,11)-4.D0*ExZpE*r1x2Z*VRR1(22,11)+3.D0*HfxZpE*VRR1(37,5)+WPx*VRR1(37,11)
      VRR0(58,12)=4.D0*r1x2Z*VRR0(22,12)+PAx*VRR0(37,12)-4.D0*ExZpE*r1x2Z*VRR1(22,12)+2.D0*HfxZpE*VRR1(37,6)+WPx*VRR1(37,12)
      VRR0(58,13)=4.D0*r1x2Z*VRR0(22,13)+PAx*VRR0(37,13)-4.D0*ExZpE*r1x2Z*VRR1(22,13)+HfxZpE*VRR1(37,7)+WPx*VRR1(37,13)
      VRR0(58,14)=4.D0*r1x2Z*VRR0(22,14)+PAx*VRR0(37,14)-4.D0*ExZpE*r1x2Z*VRR1(22,14)+WPx*VRR1(37,14)
      VRR0(58,15)=4.D0*r1x2Z*VRR0(22,15)+PAx*VRR0(37,15)-4.D0*ExZpE*r1x2Z*VRR1(22,15)+2.D0*HfxZpE*VRR1(37,8)+WPx*VRR1(37,15)
      VRR0(58,16)=4.D0*r1x2Z*VRR0(22,16)+PAx*VRR0(37,16)-4.D0*ExZpE*r1x2Z*VRR1(22,16)+HfxZpE*VRR1(37,9)+WPx*VRR1(37,16)
      VRR0(58,17)=4.D0*r1x2Z*VRR0(22,17)+PAx*VRR0(37,17)-4.D0*ExZpE*r1x2Z*VRR1(22,17)+WPx*VRR1(37,17)
      VRR0(58,18)=4.D0*r1x2Z*VRR0(22,18)+PAx*VRR0(37,18)-4.D0*ExZpE*r1x2Z*VRR1(22,18)+HfxZpE*VRR1(37,10)+WPx*VRR1(37,18)
      VRR0(58,19)=4.D0*r1x2Z*VRR0(22,19)+PAx*VRR0(37,19)-4.D0*ExZpE*r1x2Z*VRR1(22,19)+WPx*VRR1(37,19)
      VRR0(58,20)=4.D0*r1x2Z*VRR0(22,20)+PAx*VRR0(37,20)-4.D0*ExZpE*r1x2Z*VRR1(22,20)+WPx*VRR1(37,20)
      VRR0(59,11)=V(2)+V(4)+PAx*VRR0(38,11)+3.D0*HfxZpE*VRR1(38,5)+WPx*VRR1(38,11)
      VRR0(59,12)=V(6)+V(8)+PAx*VRR0(38,12)+2.D0*HfxZpE*VRR1(38,6)+WPx*VRR1(38,12)
      VRR0(59,13)=V(10)+V(12)+V(13)+PAx*VRR0(38,13)+WPx*VRR1(38,13)
      VRR0(59,14)=V(15)+V(17)+PAx*VRR0(38,14)+WPx*VRR1(38,14)
      VRR0(59,15)=V(19)+V(21)+PAx*VRR0(38,15)+2.D0*HfxZpE*VRR1(38,8)+WPx*VRR1(38,15)
      VRR0(59,16)=V(23)+V(25)+PAx*VRR0(38,16)+HfxZpE*VRR1(38,9)+WPx*VRR1(38,16)
      VRR0(59,17)=V(27)+V(29)+PAx*VRR0(38,17)+WPx*VRR1(38,17)
      VRR0(59,18)=V(31)+V(33)+V(34)+PAx*VRR0(38,18)+WPx*VRR1(38,18)
      VRR0(59,19)=V(36)+V(38)+PAx*VRR0(38,19)+WPx*VRR1(38,19)
      VRR0(59,20)=V(40)+V(42)+PAx*VRR0(38,20)+WPx*VRR1(38,20)
      VRR0(60,11)=3.D0*V(43)+2.D0*r1x2E*VRR0(60,2)+QCx*VRR0(60,5)-2.D0*r1x2E*ZxZpE*VRR1(60,2)+WQx*VRR1(60,5)
      VRR0(60,12)=2.D0*V(44)-2.D0*V(45)+V(47)+PAx*VRR0(39,12)+WPx*VRR1(39,12)
      VRR0(60,13)=2.D0*V(48)-2.D0*V(49)+V(50)+PAx*VRR0(39,13)+WPx*VRR1(39,13)
      VRR0(60,14)=3.D0*V(13)+2.D0*r1x2E*VRR0(60,3)+QCy*VRR0(60,7)-2.D0*r1x2E*ZxZpE*VRR1(60,3)+WQy*VRR1(60,7)
      VRR0(60,15)=2.D0*V(51)-2.D0*V(52)+2.D0*V(53)+PAx*VRR0(39,15)+WPx*VRR1(39,15)
      VRR0(60,16)=2.D0*V(54)-2.D0*V(55)+V(56)+PAx*VRR0(39,16)+WPx*VRR1(39,16)
      VRR0(60,17)=2.D0*V(57)-2.D0*V(58)+PAx*VRR0(39,17)+WPx*VRR1(39,17)
      VRR0(60,18)=2.D0*V(59)-2.D0*V(60)+V(61)+PAx*VRR0(39,18)+WPx*VRR1(39,18)
      VRR0(60,19)=2.D0*V(62)-2.D0*V(63)+PAx*VRR0(39,19)+WPx*VRR1(39,19)
      VRR0(60,20)=2.D0*r1x2E*VRR0(60,4)+QCz*VRR0(60,10)-2.D0*r1x2E*ZxZpE*VRR1(60,4)+WQz*VRR1(60,10)
      VRR0(61,11)=V(2)+V(4)+PAy*VRR0(39,11)+WPy*VRR1(39,11)
      VRR0(61,12)=V(6)+V(8)+V(43)+PAy*VRR0(39,12)+WPy*VRR1(39,12)
      VRR0(61,13)=V(10)+V(12)+V(47)+PAy*VRR0(39,13)+WPy*VRR1(39,13)
      VRR0(61,14)=V(15)+V(17)+3.D0*V(50)+PAy*VRR0(39,14)+WPy*VRR1(39,14)
      VRR0(61,15)=V(19)+V(21)+PAy*VRR0(39,15)+WPy*VRR1(39,15)
      VRR0(61,16)=V(23)+V(25)+V(53)+PAy*VRR0(39,16)+WPy*VRR1(39,16)
      VRR0(61,17)=V(27)+V(29)+2.D0*V(56)+PAy*VRR0(39,17)+WPy*VRR1(39,17)
      VRR0(61,18)=V(31)+V(33)+PAy*VRR0(39,18)+WPy*VRR1(39,18)
      VRR0(61,19)=V(36)+V(38)+V(61)+PAy*VRR0(39,19)+WPy*VRR1(39,19)
      VRR0(61,20)=V(40)+V(42)+PAy*VRR0(39,20)+WPy*VRR1(39,20)
      VRR0(62,11)=4.D0*r1x2Z*VRR0(24,11)+PAy*VRR0(40,11)-4.D0*ExZpE*r1x2Z*VRR1(24,11)+WPy*VRR1(40,11)
      VRR0(62,12)=4.D0*V(44)-4.D0*V(45)+PAy*VRR0(40,12)+HfxZpE*VRR1(40,5)+WPy*VRR1(40,12)
      VRR0(62,13)=4.D0*V(48)-4.D0*V(49)+PAy*VRR0(40,13)+2.D0*HfxZpE*VRR1(40,6)+WPy*VRR1(40,13)
      VRR0(62,14)=4.D0*r1x2Z*VRR0(24,14)+PAy*VRR0(40,14)-4.D0*ExZpE*r1x2Z*VRR1(24,14)+3.D0*HfxZpE*VRR1(40,7)+WPy*VRR1(40,14)
      VRR0(62,15)=4.D0*V(51)-4.D0*V(52)+PAy*VRR0(40,15)+WPy*VRR1(40,15)
      VRR0(62,16)=4.D0*V(54)-4.D0*V(55)+PAy*VRR0(40,16)+HfxZpE*VRR1(40,8)+WPy*VRR1(40,16)
      VRR0(62,17)=4.D0*V(57)-4.D0*V(58)+PAy*VRR0(40,17)+2.D0*HfxZpE*VRR1(40,9)+WPy*VRR1(40,17)
      VRR0(62,18)=4.D0*V(59)-4.D0*V(60)+PAy*VRR0(40,18)+WPy*VRR1(40,18)
      VRR0(62,19)=4.D0*V(62)-4.D0*V(63)+PAy*VRR0(40,19)+HfxZpE*VRR1(40,10)+WPy*VRR1(40,19)
      VRR0(62,20)=4.D0*r1x2Z*VRR0(24,20)+PAy*VRR0(40,20)-4.D0*ExZpE*r1x2Z*VRR1(24,20)+WPy*VRR1(40,20)
      VRR0(63,11)=5.D0*r1x2Z*VRR0(25,11)+PAy*VRR0(41,11)-5.D0*ExZpE*r1x2Z*VRR1(25,11)+WPy*VRR1(41,11)
      VRR0(63,12)=5.D0*r1x2Z*VRR0(25,12)+PAy*VRR0(41,12)-5.D0*ExZpE*r1x2Z*VRR1(25,12)+HfxZpE*VRR1(41,5)+WPy*VRR1(41,12)
      VRR0(63,13)=5.D0*r1x2Z*VRR0(25,13)+PAy*VRR0(41,13)-5.D0*ExZpE*r1x2Z*VRR1(25,13)+2.D0*HfxZpE*VRR1(41,6)+WPy*VRR1(41,13)
      VRR0(63,14)=5.D0*r1x2Z*VRR0(25,14)+PAy*VRR0(41,14)-5.D0*ExZpE*r1x2Z*VRR1(25,14)+3.D0*HfxZpE*VRR1(41,7)+WPy*VRR1(41,14)
      VRR0(63,15)=5.D0*r1x2Z*VRR0(25,15)+PAy*VRR0(41,15)-5.D0*ExZpE*r1x2Z*VRR1(25,15)+WPy*VRR1(41,15)
      VRR0(63,16)=5.D0*r1x2Z*VRR0(25,16)+PAy*VRR0(41,16)-5.D0*ExZpE*r1x2Z*VRR1(25,16)+HfxZpE*VRR1(41,8)+WPy*VRR1(41,16)
      VRR0(63,17)=5.D0*r1x2Z*VRR0(25,17)+PAy*VRR0(41,17)-5.D0*ExZpE*r1x2Z*VRR1(25,17)+2.D0*HfxZpE*VRR1(41,9)+WPy*VRR1(41,17)
      VRR0(63,18)=5.D0*r1x2Z*VRR0(25,18)+PAy*VRR0(41,18)-5.D0*ExZpE*r1x2Z*VRR1(25,18)+WPy*VRR1(41,18)
      VRR0(63,19)=5.D0*r1x2Z*VRR0(25,19)+PAy*VRR0(41,19)-5.D0*ExZpE*r1x2Z*VRR1(25,19)+HfxZpE*VRR1(41,10)+WPy*VRR1(41,19)
      VRR0(63,20)=5.D0*r1x2Z*VRR0(25,20)+PAy*VRR0(41,20)-5.D0*ExZpE*r1x2Z*VRR1(25,20)+WPy*VRR1(41,20)
      VRR0(64,11)=4.D0*r1x2Z*VRR0(26,11)+PAx*VRR0(42,11)-4.D0*ExZpE*r1x2Z*VRR1(26,11)+3.D0*HfxZpE*VRR1(42,5)+WPx*VRR1(42,11)
      VRR0(64,12)=4.D0*r1x2Z*VRR0(26,12)+PAx*VRR0(42,12)-4.D0*ExZpE*r1x2Z*VRR1(26,12)+2.D0*HfxZpE*VRR1(42,6)+WPx*VRR1(42,12)
      VRR0(64,13)=4.D0*r1x2Z*VRR0(26,13)+PAx*VRR0(42,13)-4.D0*ExZpE*r1x2Z*VRR1(26,13)+HfxZpE*VRR1(42,7)+WPx*VRR1(42,13)
      VRR0(64,14)=4.D0*r1x2Z*VRR0(26,14)+PAx*VRR0(42,14)-4.D0*ExZpE*r1x2Z*VRR1(26,14)+WPx*VRR1(42,14)
      VRR0(64,15)=4.D0*r1x2Z*VRR0(26,15)+PAx*VRR0(42,15)-4.D0*ExZpE*r1x2Z*VRR1(26,15)+2.D0*HfxZpE*VRR1(42,8)+WPx*VRR1(42,15)
      VRR0(64,16)=4.D0*r1x2Z*VRR0(26,16)+PAx*VRR0(42,16)-4.D0*ExZpE*r1x2Z*VRR1(26,16)+HfxZpE*VRR1(42,9)+WPx*VRR1(42,16)
      VRR0(64,17)=4.D0*r1x2Z*VRR0(26,17)+PAx*VRR0(42,17)-4.D0*ExZpE*r1x2Z*VRR1(26,17)+WPx*VRR1(42,17)
      VRR0(64,18)=4.D0*r1x2Z*VRR0(26,18)+PAx*VRR0(42,18)-4.D0*ExZpE*r1x2Z*VRR1(26,18)+HfxZpE*VRR1(42,10)+WPx*VRR1(42,18)
      VRR0(64,19)=4.D0*r1x2Z*VRR0(26,19)+PAx*VRR0(42,19)-4.D0*ExZpE*r1x2Z*VRR1(26,19)+WPx*VRR1(42,19)
      VRR0(64,20)=4.D0*r1x2Z*VRR0(26,20)+PAx*VRR0(42,20)-4.D0*ExZpE*r1x2Z*VRR1(26,20)+WPx*VRR1(42,20)
      VRR0(65,11)=3.D0*r1x2Z*VRR0(27,11)+PAx*VRR0(43,11)-3.D0*ExZpE*r1x2Z*VRR1(27,11)+3.D0*HfxZpE*VRR1(43,5)+WPx*VRR1(43,11)
      VRR0(65,12)=3.D0*V(64)-3.D0*V(65)+PAx*VRR0(43,12)+2.D0*HfxZpE*VRR1(43,6)+WPx*VRR1(43,12)
      VRR0(65,13)=3.D0*V(66)-3.D0*V(67)+V(68)+PAx*VRR0(43,13)+WPx*VRR1(43,13)
      VRR0(65,14)=3.D0*r1x2Z*VRR0(27,14)+PAx*VRR0(43,14)-3.D0*ExZpE*r1x2Z*VRR1(27,14)+WPx*VRR1(43,14)
      VRR0(65,15)=3.D0*V(69)-3.D0*V(70)+PAx*VRR0(43,15)+2.D0*HfxZpE*VRR1(43,8)+WPx*VRR1(43,15)
      VRR0(65,16)=3.D0*V(71)-3.D0*V(72)+PAx*VRR0(43,16)+HfxZpE*VRR1(43,9)+WPx*VRR1(43,16)
      VRR0(65,17)=3.D0*V(73)-3.D0*V(74)+PAx*VRR0(43,17)+WPx*VRR1(43,17)
      VRR0(65,18)=3.D0*V(75)-3.D0*V(76)+V(77)+PAx*VRR0(43,18)+WPx*VRR1(43,18)
      VRR0(65,19)=3.D0*V(78)-3.D0*V(79)+PAx*VRR0(43,19)+WPx*VRR1(43,19)
      VRR0(65,20)=3.D0*r1x2Z*VRR0(27,20)+PAx*VRR0(43,20)-3.D0*ExZpE*r1x2Z*VRR1(27,20)+WPx*VRR1(43,20)
      VRR0(66,11)=3.D0*V(80)+2.D0*r1x2E*VRR0(66,2)+QCx*VRR0(66,5)-2.D0*r1x2E*ZxZpE*VRR1(66,2)+WQx*VRR1(66,5)
      VRR0(66,12)=V(82)+V(84)+V(86)+PAx*VRR0(44,12)+WPx*VRR1(44,12)
      VRR0(66,13)=V(88)+V(90)+V(91)+PAx*VRR0(44,13)+WPx*VRR1(44,13)
      VRR0(66,14)=2.D0*V(68)+2.D0*r1x2E*VRR0(66,3)+QCy*VRR0(66,7)-2.D0*r1x2E*ZxZpE*VRR1(66,3)+WQy*VRR1(66,7)
      VRR0(66,15)=V(93)+V(95)+V(97)+PAx*VRR0(44,15)+WPx*VRR1(44,15)
      VRR0(66,16)=V(99)+V(101)+V(102)+PAx*VRR0(44,16)+WPx*VRR1(44,16)
      VRR0(66,17)=V(104)+V(106)+PAx*VRR0(44,17)+WPx*VRR1(44,17)
      VRR0(66,18)=V(108)+V(110)+V(111)+PAx*VRR0(44,18)+WPx*VRR1(44,18)
      VRR0(66,19)=V(113)+V(115)+PAx*VRR0(44,19)+WPx*VRR1(44,19)
      VRR0(66,20)=V(34)+2.D0*r1x2E*VRR0(66,4)+QCz*VRR0(66,10)-2.D0*r1x2E*ZxZpE*VRR1(66,4)+WQz*VRR1(66,10)
      VRR0(67,11)=2.D0*V(116)+2.D0*r1x2E*VRR0(67,2)+QCx*VRR0(67,5)-2.D0*r1x2E*ZxZpE*VRR1(67,2)+WQx*VRR1(67,5)
      VRR0(67,12)=V(80)+V(117)+V(118)+PAy*VRR0(44,12)+WPy*VRR1(44,12)
      VRR0(67,13)=V(86)+V(119)+V(120)+PAy*VRR0(44,13)+WPy*VRR1(44,13)
      VRR0(67,14)=3.D0*V(91)+2.D0*r1x2E*VRR0(67,3)+QCy*VRR0(67,7)-2.D0*r1x2E*ZxZpE*VRR1(67,3)+WQy*VRR1(67,7)
      VRR0(67,15)=V(121)+V(122)+PAy*VRR0(44,15)+WPy*VRR1(44,15)
      VRR0(67,16)=V(96)+V(123)+V(124)+PAy*VRR0(44,16)+WPy*VRR1(44,16)
      VRR0(67,17)=V(125)+V(126)+V(127)+PAy*VRR0(44,17)+WPy*VRR1(44,17)
      VRR0(67,18)=V(128)+V(129)+PAy*VRR0(44,18)+WPy*VRR1(44,18)
      VRR0(67,19)=V(111)+V(130)+V(131)+PAy*VRR0(44,19)+WPy*VRR1(44,19)
      VRR0(67,20)=V(61)+2.D0*r1x2E*VRR0(67,4)+QCz*VRR0(67,10)-2.D0*r1x2E*ZxZpE*VRR1(67,4)+WQz*VRR1(67,10)
      VRR0(68,11)=3.D0*r1x2Z*VRR0(28,11)+PAy*VRR0(45,11)-3.D0*ExZpE*r1x2Z*VRR1(28,11)+WPy*VRR1(45,11)
      VRR0(68,12)=3.D0*V(81)-3.D0*V(83)+V(116)+PAy*VRR0(45,12)+WPy*VRR1(45,12)
      VRR0(68,13)=3.D0*V(87)-3.D0*V(89)+PAy*VRR0(45,13)+2.D0*HfxZpE*VRR1(45,6)+WPy*VRR1(45,13)
      VRR0(68,14)=3.D0*r1x2Z*VRR0(28,14)+PAy*VRR0(45,14)-3.D0*ExZpE*r1x2Z*VRR1(28,14)+3.D0*HfxZpE*VRR1(45,7)+WPy*VRR1(45,14)
      VRR0(68,15)=3.D0*V(92)-3.D0*V(94)+PAy*VRR0(45,15)+WPy*VRR1(45,15)
      VRR0(68,16)=3.D0*V(98)-3.D0*V(100)+PAy*VRR0(45,16)+HfxZpE*VRR1(45,8)+WPy*VRR1(45,16)
      VRR0(68,17)=3.D0*V(103)-3.D0*V(105)+PAy*VRR0(45,17)+2.D0*HfxZpE*VRR1(45,9)+WPy*VRR1(45,17)
      VRR0(68,18)=3.D0*V(107)-3.D0*V(109)+PAy*VRR0(45,18)+WPy*VRR1(45,18)
      VRR0(68,19)=3.D0*V(112)-3.D0*V(114)+V(132)+PAy*VRR0(45,19)+WPy*VRR1(45,19)
      VRR0(68,20)=3.D0*r1x2Z*VRR0(28,20)+PAy*VRR0(45,20)-3.D0*ExZpE*r1x2Z*VRR1(28,20)+WPy*VRR1(45,20)
      VRR0(69,11)=4.D0*r1x2Z*VRR0(29,11)+PAy*VRR0(46,11)-4.D0*ExZpE*r1x2Z*VRR1(29,11)+WPy*VRR1(46,11)
      VRR0(69,12)=4.D0*r1x2Z*VRR0(29,12)+PAy*VRR0(46,12)-4.D0*ExZpE*r1x2Z*VRR1(29,12)+HfxZpE*VRR1(46,5)+WPy*VRR1(46,12)
      VRR0(69,13)=4.D0*r1x2Z*VRR0(29,13)+PAy*VRR0(46,13)-4.D0*ExZpE*r1x2Z*VRR1(29,13)+2.D0*HfxZpE*VRR1(46,6)+WPy*VRR1(46,13)
      VRR0(69,14)=4.D0*r1x2Z*VRR0(29,14)+PAy*VRR0(46,14)-4.D0*ExZpE*r1x2Z*VRR1(29,14)+3.D0*HfxZpE*VRR1(46,7)+WPy*VRR1(46,14)
      VRR0(69,15)=4.D0*r1x2Z*VRR0(29,15)+PAy*VRR0(46,15)-4.D0*ExZpE*r1x2Z*VRR1(29,15)+WPy*VRR1(46,15)
      VRR0(69,16)=4.D0*r1x2Z*VRR0(29,16)+PAy*VRR0(46,16)-4.D0*ExZpE*r1x2Z*VRR1(29,16)+HfxZpE*VRR1(46,8)+WPy*VRR1(46,16)
      VRR0(69,17)=4.D0*r1x2Z*VRR0(29,17)+PAy*VRR0(46,17)-4.D0*ExZpE*r1x2Z*VRR1(29,17)+2.D0*HfxZpE*VRR1(46,9)+WPy*VRR1(46,17)
      VRR0(69,18)=4.D0*r1x2Z*VRR0(29,18)+PAy*VRR0(46,18)-4.D0*ExZpE*r1x2Z*VRR1(29,18)+WPy*VRR1(46,18)
      VRR0(69,19)=4.D0*r1x2Z*VRR0(29,19)+PAy*VRR0(46,19)-4.D0*ExZpE*r1x2Z*VRR1(29,19)+HfxZpE*VRR1(46,10)+WPy*VRR1(46,19)
      VRR0(69,20)=4.D0*r1x2Z*VRR0(29,20)+PAy*VRR0(46,20)-4.D0*ExZpE*r1x2Z*VRR1(29,20)+WPy*VRR1(46,20)
      VRR0(70,11)=V(134)+V(136)+PAx*VRR0(47,11)+3.D0*HfxZpE*VRR1(47,5)+WPx*VRR1(47,11)
      VRR0(70,12)=V(138)+V(140)+PAx*VRR0(47,12)+2.D0*HfxZpE*VRR1(47,6)+WPx*VRR1(47,12)
      VRR0(70,13)=V(142)+V(144)+V(145)+PAx*VRR0(47,13)+WPx*VRR1(47,13)
      VRR0(70,14)=V(147)+V(149)+PAx*VRR0(47,14)+WPx*VRR1(47,14)
      VRR0(70,15)=V(151)+V(153)+PAx*VRR0(47,15)+2.D0*HfxZpE*VRR1(47,8)+WPx*VRR1(47,15)
      VRR0(70,16)=V(155)+V(157)+PAx*VRR0(47,16)+HfxZpE*VRR1(47,9)+WPx*VRR1(47,16)
      VRR0(70,17)=V(159)+V(161)+PAx*VRR0(47,17)+WPx*VRR1(47,17)
      VRR0(70,18)=V(163)+V(165)+V(166)+PAx*VRR0(47,18)+WPx*VRR1(47,18)
      VRR0(70,19)=V(168)+V(170)+PAx*VRR0(47,19)+WPx*VRR1(47,19)
      VRR0(70,20)=V(172)+V(174)+PAx*VRR0(47,20)+WPx*VRR1(47,20)
      VRR0(71,11)=3.D0*V(175)+2.D0*r1x2E*VRR0(71,2)+QCx*VRR0(71,5)-2.D0*r1x2E*ZxZpE*VRR1(71,2)+WQx*VRR1(71,5)
      VRR0(71,12)=V(177)+V(179)+V(181)+PAx*VRR0(48,12)+WPx*VRR1(48,12)
      VRR0(71,13)=V(183)+V(185)+V(186)+PAx*VRR0(48,13)+WPx*VRR1(48,13)
      VRR0(71,14)=V(145)+2.D0*r1x2E*VRR0(71,3)+QCy*VRR0(71,7)-2.D0*r1x2E*ZxZpE*VRR1(71,3)+WQy*VRR1(71,7)
      VRR0(71,15)=V(188)+V(190)+V(192)+PAx*VRR0(48,15)+WPx*VRR1(48,15)
      VRR0(71,16)=V(194)+V(196)+V(197)+PAx*VRR0(48,16)+WPx*VRR1(48,16)
      VRR0(71,17)=V(199)+V(201)+PAx*VRR0(48,17)+WPx*VRR1(48,17)
      VRR0(71,18)=V(203)+V(205)+V(206)+PAx*VRR0(48,18)+WPx*VRR1(48,18)
      VRR0(71,19)=V(208)+V(210)+PAx*VRR0(48,19)+WPx*VRR1(48,19)
      VRR0(71,20)=2.D0*V(77)+2.D0*r1x2E*VRR0(71,4)+QCz*VRR0(71,10)-2.D0*r1x2E*ZxZpE*VRR1(71,4)+WQz*VRR1(71,10)
      VRR0(72,11)=2.D0*V(211)+2.D0*V(212)-2.D0*V(213)+QCx*VRR0(72,5)+WQx*VRR1(72,5)
      VRR0(72,12)=V(214)+V(216)+V(218)+QCx*VRR0(72,6)+WQx*VRR1(72,6)
      VRR0(72,13)=V(181)+V(211)+V(219)+QCy*VRR0(72,6)+WQy*VRR1(72,6)
      VRR0(72,14)=2.D0*V(186)+2.D0*V(214)-2.D0*V(217)+QCy*VRR0(72,7)+WQy*VRR1(72,7)
      VRR0(72,15)=V(220)+V(222)+V(224)+QCx*VRR0(72,8)+WQx*VRR1(72,8)
      VRR0(72,16)=V(225)-V(226)+V(227)+PAx*VRR0(49,16)+WPx*VRR1(49,16)
      VRR0(72,17)=V(220)+V(224)+V(228)+QCy*VRR0(72,9)+WQy*VRR1(72,9)
      VRR0(72,18)=V(97)+V(211)+V(219)+QCz*VRR0(72,8)+WQz*VRR1(72,8)
      VRR0(72,19)=V(127)+V(214)+V(218)+QCz*VRR0(72,9)+WQz*VRR1(72,9)
      VRR0(72,20)=2.D0*V(111)+2.D0*V(220)-2.D0*V(223)+QCz*VRR0(72,10)+WQz*VRR1(72,10)
      VRR0(73,11)=V(229)+2.D0*r1x2E*VRR0(73,2)+QCx*VRR0(73,5)-2.D0*r1x2E*ZxZpE*VRR1(73,2)+WQx*VRR1(73,5)
      VRR0(73,12)=V(177)+V(179)+V(212)+PAy*VRR0(49,12)+WPy*VRR1(49,12)
      VRR0(73,13)=V(183)+V(185)+V(216)+PAy*VRR0(49,13)+WPy*VRR1(49,13)
      VRR0(73,14)=3.D0*V(230)+2.D0*r1x2E*VRR0(73,3)+QCy*VRR0(73,7)-2.D0*r1x2E*ZxZpE*VRR1(73,3)+WQy*VRR1(73,7)
      VRR0(73,15)=V(188)+V(190)+PAy*VRR0(49,15)+WPy*VRR1(49,15)
      VRR0(73,16)=V(194)+V(196)+V(221)+PAy*VRR0(49,16)+WPy*VRR1(49,16)
      VRR0(73,17)=V(199)+V(201)+V(231)+PAy*VRR0(49,17)+WPy*VRR1(49,17)
      VRR0(73,18)=V(203)+V(205)+PAy*VRR0(49,18)+WPy*VRR1(49,18)
      VRR0(73,19)=V(208)+V(210)+V(232)+PAy*VRR0(49,19)+WPy*VRR1(49,19)
      VRR0(73,20)=2.D0*V(132)+2.D0*r1x2E*VRR0(73,4)+QCz*VRR0(73,10)-2.D0*r1x2E*ZxZpE*VRR1(73,4)+WQz*VRR1(73,10)
      VRR0(74,11)=V(234)+V(236)+PAy*VRR0(50,11)+WPy*VRR1(50,11)
      VRR0(74,12)=V(229)+V(238)+V(240)+PAy*VRR0(50,12)+WPy*VRR1(50,12)
      VRR0(74,13)=V(242)+V(244)+PAy*VRR0(50,13)+2.D0*HfxZpE*VRR1(50,6)+WPy*VRR1(50,13)
      VRR0(74,14)=V(246)+V(248)+PAy*VRR0(50,14)+3.D0*HfxZpE*VRR1(50,7)+WPy*VRR1(50,14)
      VRR0(74,15)=V(250)+V(252)+PAy*VRR0(50,15)+WPy*VRR1(50,15)
      VRR0(74,16)=V(253)+V(254)+PAy*VRR0(50,16)+HfxZpE*VRR1(50,8)+WPy*VRR1(50,16)
      VRR0(74,17)=V(256)+V(258)+PAy*VRR0(50,17)+2.D0*HfxZpE*VRR1(50,9)+WPy*VRR1(50,17)
      VRR0(74,18)=V(260)+V(262)+PAy*VRR0(50,18)+WPy*VRR1(50,18)
      VRR0(74,19)=V(264)+V(266)+V(267)+PAy*VRR0(50,19)+WPy*VRR1(50,19)
      VRR0(74,20)=V(269)+V(271)+PAy*VRR0(50,20)+WPy*VRR1(50,20)
      VRR0(75,11)=3.D0*V(272)+2.D0*r1x2E*VRR0(75,2)+QCx*VRR0(75,5)-2.D0*r1x2E*ZxZpE*VRR1(75,2)+WQx*VRR1(75,5)
      VRR0(75,12)=2.D0*V(273)-2.D0*V(274)+2.D0*V(275)+PAx*VRR0(51,12)+WPx*VRR1(51,12)
      VRR0(75,13)=2.D0*V(276)-2.D0*V(277)+V(278)+PAx*VRR0(51,13)+WPx*VRR1(51,13)
      VRR0(75,14)=2.D0*r1x2E*VRR0(75,3)+QCy*VRR0(75,7)-2.D0*r1x2E*ZxZpE*VRR1(75,3)+WQy*VRR1(75,7)
      VRR0(75,15)=2.D0*V(279)-2.D0*V(280)+V(282)+PAx*VRR0(51,15)+WPx*VRR1(51,15)
      VRR0(75,16)=2.D0*V(283)-2.D0*V(284)+V(285)+PAx*VRR0(51,16)+WPx*VRR1(51,16)
      VRR0(75,17)=2.D0*V(286)-2.D0*V(287)+PAx*VRR0(51,17)+WPx*VRR1(51,17)
      VRR0(75,18)=2.D0*V(288)-2.D0*V(289)+V(290)+PAx*VRR0(51,18)+WPx*VRR1(51,18)
      VRR0(75,19)=2.D0*V(291)-2.D0*V(292)+PAx*VRR0(51,19)+WPx*VRR1(51,19)
      VRR0(75,20)=3.D0*V(166)+2.D0*r1x2E*VRR0(75,4)+QCz*VRR0(75,10)-2.D0*r1x2E*ZxZpE*VRR1(75,4)+WQz*VRR1(75,10)
      VRR0(76,11)=2.D0*V(293)+2.D0*r1x2E*VRR0(76,2)+QCx*VRR0(76,5)-2.D0*r1x2E*ZxZpE*VRR1(76,2)+WQx*VRR1(76,5)
      VRR0(76,12)=V(117)+V(118)+PAz*VRR0(48,12)+WPz*VRR1(48,12)
      VRR0(76,13)=V(119)+V(120)+PAz*VRR0(48,13)+WPz*VRR1(48,13)
      VRR0(76,14)=V(278)+2.D0*r1x2E*VRR0(76,3)+QCy*VRR0(76,7)-2.D0*r1x2E*ZxZpE*VRR1(76,3)+WQy*VRR1(76,7)
      VRR0(76,15)=V(121)+V(122)+V(175)+PAz*VRR0(48,15)+WPz*VRR1(48,15)
      VRR0(76,16)=V(123)+V(124)+V(180)+PAz*VRR0(48,16)+WPz*VRR1(48,16)
      VRR0(76,17)=V(125)+V(126)+V(186)+PAz*VRR0(48,17)+WPz*VRR1(48,17)
      VRR0(76,18)=V(128)+V(129)+V(192)+PAz*VRR0(48,18)+WPz*VRR1(48,18)
      VRR0(76,19)=V(130)+V(131)+V(228)+PAz*VRR0(48,19)+WPz*VRR1(48,19)
      VRR0(76,20)=3.D0*V(206)+2.D0*r1x2E*VRR0(76,4)+QCz*VRR0(76,10)-2.D0*r1x2E*ZxZpE*VRR1(76,4)+WQz*VRR1(76,10)
      VRR0(77,11)=V(294)+2.D0*r1x2E*VRR0(77,2)+QCx*VRR0(77,5)-2.D0*r1x2E*ZxZpE*VRR1(77,2)+WQx*VRR1(77,5)
      VRR0(77,12)=V(82)+V(84)+PAz*VRR0(49,12)+WPz*VRR1(49,12)
      VRR0(77,13)=V(88)+V(90)+PAz*VRR0(49,13)+WPz*VRR1(49,13)
      VRR0(77,14)=2.D0*V(295)+2.D0*r1x2E*VRR0(77,3)+QCy*VRR0(77,7)-2.D0*r1x2E*ZxZpE*VRR1(77,3)+WQy*VRR1(77,7)
      VRR0(77,15)=V(93)+V(95)+V(212)+PAz*VRR0(49,15)+WPz*VRR1(49,15)
      VRR0(77,16)=V(99)+V(101)+V(215)+PAz*VRR0(49,16)+WPz*VRR1(49,16)
      VRR0(77,17)=V(104)+V(106)+V(230)+PAz*VRR0(49,17)+WPz*VRR1(49,17)
      VRR0(77,18)=V(108)+V(110)+V(222)+PAz*VRR0(49,18)+WPz*VRR1(49,18)
      VRR0(77,19)=V(113)+V(115)+V(231)+PAz*VRR0(49,19)+WPz*VRR1(49,19)
      VRR0(77,20)=3.D0*V(232)+2.D0*r1x2E*VRR0(77,4)+QCz*VRR0(77,10)-2.D0*r1x2E*ZxZpE*VRR1(77,4)+WQz*VRR1(77,10)
      VRR0(78,11)=2.D0*r1x2E*VRR0(78,2)+QCx*VRR0(78,5)-2.D0*r1x2E*ZxZpE*VRR1(78,2)+WQx*VRR1(78,5)
      VRR0(78,12)=V(294)+2.D0*V(296)-2.D0*V(297)+PAy*VRR0(53,12)+WPy*VRR1(53,12)
      VRR0(78,13)=2.D0*V(298)-2.D0*V(299)+2.D0*V(300)+PAy*VRR0(53,13)+WPy*VRR1(53,13)
      VRR0(78,14)=3.D0*V(301)+2.D0*r1x2E*VRR0(78,3)+QCy*VRR0(78,7)-2.D0*r1x2E*ZxZpE*VRR1(78,3)+WQy*VRR1(78,7)
      VRR0(78,15)=2.D0*V(302)-2.D0*V(303)+PAy*VRR0(53,15)+WPy*VRR1(53,15)
      VRR0(78,16)=2.D0*V(304)-2.D0*V(305)+V(306)+PAy*VRR0(53,16)+WPy*VRR1(53,16)
      VRR0(78,17)=2.D0*V(307)-2.D0*V(308)+V(310)+PAy*VRR0(53,17)+WPy*VRR1(53,17)
      VRR0(78,18)=2.D0*V(311)-2.D0*V(312)+PAy*VRR0(53,18)+WPy*VRR1(53,18)
      VRR0(78,19)=2.D0*V(313)-2.D0*V(314)+V(315)+PAy*VRR0(53,19)+WPy*VRR1(53,19)
      VRR0(78,20)=3.D0*V(267)+2.D0*r1x2E*VRR0(78,4)+QCz*VRR0(78,10)-2.D0*r1x2E*ZxZpE*VRR1(78,4)+WQz*VRR1(78,10)
      VRR0(79,11)=V(134)+V(136)+PAz*VRR0(51,11)+WPz*VRR1(51,11)
      VRR0(79,12)=V(138)+V(140)+PAz*VRR0(51,12)+WPz*VRR1(51,12)
      VRR0(79,13)=V(142)+V(144)+PAz*VRR0(51,13)+WPz*VRR1(51,13)
      VRR0(79,14)=V(147)+V(149)+PAz*VRR0(51,14)+WPz*VRR1(51,14)
      VRR0(79,15)=V(151)+V(153)+V(272)+PAz*VRR0(51,15)+WPz*VRR1(51,15)
      VRR0(79,16)=V(155)+V(157)+V(275)+PAz*VRR0(51,16)+WPz*VRR1(51,16)
      VRR0(79,17)=V(159)+V(161)+V(278)+PAz*VRR0(51,17)+WPz*VRR1(51,17)
      VRR0(79,18)=V(163)+V(165)+V(282)+PAz*VRR0(51,18)+WPz*VRR1(51,18)
      VRR0(79,19)=V(168)+V(170)+2.D0*V(285)+PAz*VRR0(51,19)+WPz*VRR1(51,19)
      VRR0(79,20)=V(172)+V(174)+3.D0*V(290)+PAz*VRR0(51,20)+WPz*VRR1(51,20)
      VRR0(80,11)=3.D0*r1x2Z*VRR0(31,11)+PAz*VRR0(52,11)-3.D0*ExZpE*r1x2Z*VRR1(31,11)+WPz*VRR1(52,11)
      VRR0(80,12)=3.D0*V(176)-3.D0*V(178)+PAz*VRR0(52,12)+WPz*VRR1(52,12)
      VRR0(80,13)=3.D0*V(182)-3.D0*V(184)+PAz*VRR0(52,13)+WPz*VRR1(52,13)
      VRR0(80,14)=3.D0*r1x2Z*VRR0(31,14)+PAz*VRR0(52,14)-3.D0*ExZpE*r1x2Z*VRR1(31,14)+WPz*VRR1(52,14)
      VRR0(80,15)=3.D0*V(187)-3.D0*V(189)+V(293)+PAz*VRR0(52,15)+WPz*VRR1(52,15)
      VRR0(80,16)=3.D0*V(193)-3.D0*V(195)+PAz*VRR0(52,16)+HfxZpE*VRR1(52,6)+WPz*VRR1(52,16)
      VRR0(80,17)=3.D0*V(198)-3.D0*V(200)+V(295)+PAz*VRR0(52,17)+WPz*VRR1(52,17)
      VRR0(80,18)=3.D0*V(202)-3.D0*V(204)+PAz*VRR0(52,18)+2.D0*HfxZpE*VRR1(52,8)+WPz*VRR1(52,18)
      VRR0(80,19)=3.D0*V(207)-3.D0*V(209)+PAz*VRR0(52,19)+2.D0*HfxZpE*VRR1(52,9)+WPz*VRR1(52,19)
      VRR0(80,20)=3.D0*r1x2Z*VRR0(31,20)+PAz*VRR0(52,20)-3.D0*ExZpE*r1x2Z*VRR1(31,20)+3.D0*HfxZpE*VRR1(52,10)+WPz*VRR1(52,20)
      VRR0(81,11)=V(234)+V(236)+PAz*VRR0(53,11)+WPz*VRR1(53,11)
      VRR0(81,12)=V(238)+V(240)+PAz*VRR0(53,12)+WPz*VRR1(53,12)
      VRR0(81,13)=V(242)+V(244)+PAz*VRR0(53,13)+WPz*VRR1(53,13)
      VRR0(81,14)=V(246)+V(248)+PAz*VRR0(53,14)+WPz*VRR1(53,14)
      VRR0(81,15)=V(250)+V(252)+V(294)+PAz*VRR0(53,15)+WPz*VRR1(53,15)
      VRR0(81,16)=V(253)+V(254)+V(300)+PAz*VRR0(53,16)+WPz*VRR1(53,16)
      VRR0(81,17)=V(256)+V(258)+V(301)+PAz*VRR0(53,17)+WPz*VRR1(53,17)
      VRR0(81,18)=V(260)+V(262)+2.D0*V(306)+PAz*VRR0(53,18)+WPz*VRR1(53,18)
      VRR0(81,19)=V(264)+V(266)+V(310)+PAz*VRR0(53,19)+WPz*VRR1(53,19)
      VRR0(81,20)=V(269)+V(271)+3.D0*V(315)+PAz*VRR0(53,20)+WPz*VRR1(53,20)
      VRR0(82,11)=4.D0*r1x2Z*VRR0(33,11)+PAz*VRR0(54,11)-4.D0*ExZpE*r1x2Z*VRR1(33,11)+WPz*VRR1(54,11)
      VRR0(82,12)=4.D0*V(273)-4.D0*V(274)+PAz*VRR0(54,12)+WPz*VRR1(54,12)
      VRR0(82,13)=4.D0*V(276)-4.D0*V(277)+PAz*VRR0(54,13)+WPz*VRR1(54,13)
      VRR0(82,14)=4.D0*r1x2Z*VRR0(33,14)+PAz*VRR0(54,14)-4.D0*ExZpE*r1x2Z*VRR1(33,14)+WPz*VRR1(54,14)
      VRR0(82,15)=4.D0*V(279)-4.D0*V(280)+PAz*VRR0(54,15)+HfxZpE*VRR1(54,5)+WPz*VRR1(54,15)
      VRR0(82,16)=4.D0*V(283)-4.D0*V(284)+PAz*VRR0(54,16)+HfxZpE*VRR1(54,6)+WPz*VRR1(54,16)
      VRR0(82,17)=4.D0*V(286)-4.D0*V(287)+PAz*VRR0(54,17)+HfxZpE*VRR1(54,7)+WPz*VRR1(54,17)
      VRR0(82,18)=4.D0*V(288)-4.D0*V(289)+PAz*VRR0(54,18)+2.D0*HfxZpE*VRR1(54,8)+WPz*VRR1(54,18)
      VRR0(82,19)=4.D0*V(291)-4.D0*V(292)+PAz*VRR0(54,19)+2.D0*HfxZpE*VRR1(54,9)+WPz*VRR1(54,19)
      VRR0(82,20)=4.D0*r1x2Z*VRR0(33,20)+PAz*VRR0(54,20)-4.D0*ExZpE*r1x2Z*VRR1(33,20)+3.D0*HfxZpE*VRR1(54,10)+WPz*VRR1(54,20)
      VRR0(83,11)=4.D0*r1x2Z*VRR0(34,11)+PAz*VRR0(55,11)-4.D0*ExZpE*r1x2Z*VRR1(34,11)+WPz*VRR1(55,11)
      VRR0(83,12)=4.D0*V(296)-4.D0*V(297)+PAz*VRR0(55,12)+WPz*VRR1(55,12)
      VRR0(83,13)=4.D0*V(298)-4.D0*V(299)+PAz*VRR0(55,13)+WPz*VRR1(55,13)
      VRR0(83,14)=4.D0*r1x2Z*VRR0(34,14)+PAz*VRR0(55,14)-4.D0*ExZpE*r1x2Z*VRR1(34,14)+WPz*VRR1(55,14)
      VRR0(83,15)=4.D0*V(302)-4.D0*V(303)+PAz*VRR0(55,15)+HfxZpE*VRR1(55,5)+WPz*VRR1(55,15)
      VRR0(83,16)=4.D0*V(304)-4.D0*V(305)+PAz*VRR0(55,16)+HfxZpE*VRR1(55,6)+WPz*VRR1(55,16)
      VRR0(83,17)=4.D0*V(307)-4.D0*V(308)+PAz*VRR0(55,17)+HfxZpE*VRR1(55,7)+WPz*VRR1(55,17)
      VRR0(83,18)=4.D0*V(311)-4.D0*V(312)+PAz*VRR0(55,18)+2.D0*HfxZpE*VRR1(55,8)+WPz*VRR1(55,18)
      VRR0(83,19)=4.D0*V(313)-4.D0*V(314)+PAz*VRR0(55,19)+2.D0*HfxZpE*VRR1(55,9)+WPz*VRR1(55,19)
      VRR0(83,20)=4.D0*r1x2Z*VRR0(34,20)+PAz*VRR0(55,20)-4.D0*ExZpE*r1x2Z*VRR1(34,20)+3.D0*HfxZpE*VRR1(55,10)+WPz*VRR1(55,20)
      VRR0(84,11)=5.D0*r1x2Z*VRR0(35,11)+PAz*VRR0(56,11)-5.D0*ExZpE*r1x2Z*VRR1(35,11)+WPz*VRR1(56,11)
      VRR0(84,12)=5.D0*r1x2Z*VRR0(35,12)+PAz*VRR0(56,12)-5.D0*ExZpE*r1x2Z*VRR1(35,12)+WPz*VRR1(56,12)
      VRR0(84,13)=5.D0*r1x2Z*VRR0(35,13)+PAz*VRR0(56,13)-5.D0*ExZpE*r1x2Z*VRR1(35,13)+WPz*VRR1(56,13)
      VRR0(84,14)=5.D0*r1x2Z*VRR0(35,14)+PAz*VRR0(56,14)-5.D0*ExZpE*r1x2Z*VRR1(35,14)+WPz*VRR1(56,14)
      VRR0(84,15)=5.D0*r1x2Z*VRR0(35,15)+PAz*VRR0(56,15)-5.D0*ExZpE*r1x2Z*VRR1(35,15)+HfxZpE*VRR1(56,5)+WPz*VRR1(56,15)
      VRR0(84,16)=5.D0*r1x2Z*VRR0(35,16)+PAz*VRR0(56,16)-5.D0*ExZpE*r1x2Z*VRR1(35,16)+HfxZpE*VRR1(56,6)+WPz*VRR1(56,16)
      VRR0(84,17)=5.D0*r1x2Z*VRR0(35,17)+PAz*VRR0(56,17)-5.D0*ExZpE*r1x2Z*VRR1(35,17)+HfxZpE*VRR1(56,7)+WPz*VRR1(56,17)
      VRR0(84,18)=5.D0*r1x2Z*VRR0(35,18)+PAz*VRR0(56,18)-5.D0*ExZpE*r1x2Z*VRR1(35,18)+2.D0*HfxZpE*VRR1(56,8)+WPz*VRR1(56,18)
      VRR0(84,19)=5.D0*r1x2Z*VRR0(35,19)+PAz*VRR0(56,19)-5.D0*ExZpE*r1x2Z*VRR1(35,19)+2.D0*HfxZpE*VRR1(56,9)+WPz*VRR1(56,19)
      VRR0(84,20)=5.D0*r1x2Z*VRR0(35,20)+PAz*VRR0(56,20)-5.D0*ExZpE*r1x2Z*VRR1(35,20)+3.D0*HfxZpE*VRR1(56,10)+WPz*VRR1(56,20)
END SUBROUTINE VRRi0f0
SUBROUTINE MVRRi0f0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(57,11)=PAx*VS0(36,11)+WPx*VS1(36,11)+r1x2Z*VR1(36,11)&
   +5D0*r1x2Z*(VS0(21,11)-ExZpE*VS1(21,11))&
   +3D0*HfxZpE*VS1(36,5)
VS0(57,12)=PAx*VS0(36,12)+WPx*VS1(36,12)+r1x2Z*VR1(36,12)&
   +5D0*r1x2Z*(VS0(21,12)-ExZpE*VS1(21,12))&
   +2D0*HfxZpE*VS1(36,6)
VS0(57,13)=PAx*VS0(36,13)+WPx*VS1(36,13)+r1x2Z*VR1(36,13)&
   +5D0*r1x2Z*(VS0(21,13)-ExZpE*VS1(21,13))&
   +HfxZpE*VS1(36,7)
VS0(57,14)=PAx*VS0(36,14)+WPx*VS1(36,14)+r1x2Z*VR1(36,14)&
   +5D0*r1x2Z*(VS0(21,14)-ExZpE*VS1(21,14))
VS0(57,15)=PAx*VS0(36,15)+WPx*VS1(36,15)+r1x2Z*VR1(36,15)&
   +5D0*r1x2Z*(VS0(21,15)-ExZpE*VS1(21,15))&
   +2D0*HfxZpE*VS1(36,8)
VS0(57,16)=PAx*VS0(36,16)+WPx*VS1(36,16)+r1x2Z*VR1(36,16)&
   +5D0*r1x2Z*(VS0(21,16)-ExZpE*VS1(21,16))&
   +HfxZpE*VS1(36,9)
VS0(57,17)=PAx*VS0(36,17)+WPx*VS1(36,17)+r1x2Z*VR1(36,17)&
   +5D0*r1x2Z*(VS0(21,17)-ExZpE*VS1(21,17))
VS0(57,18)=PAx*VS0(36,18)+WPx*VS1(36,18)+r1x2Z*VR1(36,18)&
   +5D0*r1x2Z*(VS0(21,18)-ExZpE*VS1(21,18))&
   +HfxZpE*VS1(36,10)
VS0(57,19)=PAx*VS0(36,19)+WPx*VS1(36,19)+r1x2Z*VR1(36,19)&
   +5D0*r1x2Z*(VS0(21,19)-ExZpE*VS1(21,19))
VS0(57,20)=PAx*VS0(36,20)+WPx*VS1(36,20)+r1x2Z*VR1(36,20)&
   +5D0*r1x2Z*(VS0(21,20)-ExZpE*VS1(21,20))
VS0(58,11)=PAx*VS0(37,11)+WPx*VS1(37,11)+r1x2Z*VR1(37,11)&
   +4D0*r1x2Z*(VS0(22,11)-ExZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(37,5)
VS0(58,12)=PAx*VS0(37,12)+WPx*VS1(37,12)+r1x2Z*VR1(37,12)&
   +4D0*r1x2Z*(VS0(22,12)-ExZpE*VS1(22,12))&
   +2D0*HfxZpE*VS1(37,6)
VS0(58,13)=PAx*VS0(37,13)+WPx*VS1(37,13)+r1x2Z*VR1(37,13)&
   +4D0*r1x2Z*(VS0(22,13)-ExZpE*VS1(22,13))&
   +HfxZpE*VS1(37,7)
VS0(58,14)=PAx*VS0(37,14)+WPx*VS1(37,14)+r1x2Z*VR1(37,14)&
   +4D0*r1x2Z*(VS0(22,14)-ExZpE*VS1(22,14))
VS0(58,15)=PAx*VS0(37,15)+WPx*VS1(37,15)+r1x2Z*VR1(37,15)&
   +4D0*r1x2Z*(VS0(22,15)-ExZpE*VS1(22,15))&
   +2D0*HfxZpE*VS1(37,8)
VS0(58,16)=PAx*VS0(37,16)+WPx*VS1(37,16)+r1x2Z*VR1(37,16)&
   +4D0*r1x2Z*(VS0(22,16)-ExZpE*VS1(22,16))&
   +HfxZpE*VS1(37,9)
VS0(58,17)=PAx*VS0(37,17)+WPx*VS1(37,17)+r1x2Z*VR1(37,17)&
   +4D0*r1x2Z*(VS0(22,17)-ExZpE*VS1(22,17))
VS0(58,18)=PAx*VS0(37,18)+WPx*VS1(37,18)+r1x2Z*VR1(37,18)&
   +4D0*r1x2Z*(VS0(22,18)-ExZpE*VS1(22,18))&
   +HfxZpE*VS1(37,10)
VS0(58,19)=PAx*VS0(37,19)+WPx*VS1(37,19)+r1x2Z*VR1(37,19)&
   +4D0*r1x2Z*(VS0(22,19)-ExZpE*VS1(22,19))
VS0(58,20)=PAx*VS0(37,20)+WPx*VS1(37,20)+r1x2Z*VR1(37,20)&
   +4D0*r1x2Z*(VS0(22,20)-ExZpE*VS1(22,20))
VS0(59,11)=PAx*VS0(38,11)+WPx*VS1(38,11)+r1x2Z*VR1(38,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))&
   +3D0*HfxZpE*VS1(38,5)
VS0(59,12)=PAx*VS0(38,12)+WPx*VS1(38,12)+r1x2Z*VR1(38,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(38,6)
VS0(59,13)=PAx*VS0(38,13)+WPx*VS1(38,13)+r1x2Z*VR1(38,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +HfxZpE*VS1(38,7)
VS0(59,14)=PAx*VS0(38,14)+WPx*VS1(38,14)+r1x2Z*VR1(38,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))
VS0(59,15)=PAx*VS0(38,15)+WPx*VS1(38,15)+r1x2Z*VR1(38,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(38,8)
VS0(59,16)=PAx*VS0(38,16)+WPx*VS1(38,16)+r1x2Z*VR1(38,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(38,9)
VS0(59,17)=PAx*VS0(38,17)+WPx*VS1(38,17)+r1x2Z*VR1(38,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))
VS0(59,18)=PAx*VS0(38,18)+WPx*VS1(38,18)+r1x2Z*VR1(38,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))&
   +HfxZpE*VS1(38,10)
VS0(59,19)=PAx*VS0(38,19)+WPx*VS1(38,19)+r1x2Z*VR1(38,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))
VS0(59,20)=PAx*VS0(38,20)+WPx*VS1(38,20)+r1x2Z*VR1(38,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(60,11)=PAx*VS0(39,11)+WPx*VS1(39,11)+r1x2Z*VR1(39,11)&
   +2D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))&
   +3D0*HfxZpE*VS1(39,5)
VS0(60,12)=PAx*VS0(39,12)+WPx*VS1(39,12)+r1x2Z*VR1(39,12)&
   +2D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +2D0*HfxZpE*VS1(39,6)
VS0(60,13)=PAx*VS0(39,13)+WPx*VS1(39,13)+r1x2Z*VR1(39,13)&
   +2D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +HfxZpE*VS1(39,7)
VS0(60,14)=PAx*VS0(39,14)+WPx*VS1(39,14)+r1x2Z*VR1(39,14)&
   +2D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))
VS0(60,15)=PAx*VS0(39,15)+WPx*VS1(39,15)+r1x2Z*VR1(39,15)&
   +2D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))&
   +2D0*HfxZpE*VS1(39,8)
VS0(60,16)=PAx*VS0(39,16)+WPx*VS1(39,16)+r1x2Z*VR1(39,16)&
   +2D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(39,9)
VS0(60,17)=PAx*VS0(39,17)+WPx*VS1(39,17)+r1x2Z*VR1(39,17)&
   +2D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))
VS0(60,18)=PAx*VS0(39,18)+WPx*VS1(39,18)+r1x2Z*VR1(39,18)&
   +2D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))&
   +HfxZpE*VS1(39,10)
VS0(60,19)=PAx*VS0(39,19)+WPx*VS1(39,19)+r1x2Z*VR1(39,19)&
   +2D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))
VS0(60,20)=PAx*VS0(39,20)+WPx*VS1(39,20)+r1x2Z*VR1(39,20)&
   +2D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(61,11)=PAy*VS0(39,11)+WPy*VS1(39,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))
VS0(61,12)=PAy*VS0(39,12)+WPy*VS1(39,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +HfxZpE*VS1(39,5)
VS0(61,13)=PAy*VS0(39,13)+WPy*VS1(39,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(39,6)
VS0(61,14)=PAy*VS0(39,14)+WPy*VS1(39,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))&
   +3D0*HfxZpE*VS1(39,7)
VS0(61,15)=PAy*VS0(39,15)+WPy*VS1(39,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))
VS0(61,16)=PAy*VS0(39,16)+WPy*VS1(39,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(39,8)
VS0(61,17)=PAy*VS0(39,17)+WPy*VS1(39,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(39,9)
VS0(61,18)=PAy*VS0(39,18)+WPy*VS1(39,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))
VS0(61,19)=PAy*VS0(39,19)+WPy*VS1(39,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))&
   +HfxZpE*VS1(39,10)
VS0(61,20)=PAy*VS0(39,20)+WPy*VS1(39,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(62,11)=PAy*VS0(40,11)+WPy*VS1(40,11)&
   +4D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))
VS0(62,12)=PAy*VS0(40,12)+WPy*VS1(40,12)&
   +4D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +HfxZpE*VS1(40,5)
VS0(62,13)=PAy*VS0(40,13)+WPy*VS1(40,13)&
   +4D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +2D0*HfxZpE*VS1(40,6)
VS0(62,14)=PAy*VS0(40,14)+WPy*VS1(40,14)&
   +4D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(40,7)
VS0(62,15)=PAy*VS0(40,15)+WPy*VS1(40,15)&
   +4D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))
VS0(62,16)=PAy*VS0(40,16)+WPy*VS1(40,16)&
   +4D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(40,8)
VS0(62,17)=PAy*VS0(40,17)+WPy*VS1(40,17)&
   +4D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))&
   +2D0*HfxZpE*VS1(40,9)
VS0(62,18)=PAy*VS0(40,18)+WPy*VS1(40,18)&
   +4D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))
VS0(62,19)=PAy*VS0(40,19)+WPy*VS1(40,19)&
   +4D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))&
   +HfxZpE*VS1(40,10)
VS0(62,20)=PAy*VS0(40,20)+WPy*VS1(40,20)&
   +4D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(63,11)=PAy*VS0(41,11)+WPy*VS1(41,11)&
   +5D0*r1x2Z*(VS0(25,11)-ExZpE*VS1(25,11))
VS0(63,12)=PAy*VS0(41,12)+WPy*VS1(41,12)&
   +5D0*r1x2Z*(VS0(25,12)-ExZpE*VS1(25,12))&
   +HfxZpE*VS1(41,5)
VS0(63,13)=PAy*VS0(41,13)+WPy*VS1(41,13)&
   +5D0*r1x2Z*(VS0(25,13)-ExZpE*VS1(25,13))&
   +2D0*HfxZpE*VS1(41,6)
VS0(63,14)=PAy*VS0(41,14)+WPy*VS1(41,14)&
   +5D0*r1x2Z*(VS0(25,14)-ExZpE*VS1(25,14))&
   +3D0*HfxZpE*VS1(41,7)
VS0(63,15)=PAy*VS0(41,15)+WPy*VS1(41,15)&
   +5D0*r1x2Z*(VS0(25,15)-ExZpE*VS1(25,15))
VS0(63,16)=PAy*VS0(41,16)+WPy*VS1(41,16)&
   +5D0*r1x2Z*(VS0(25,16)-ExZpE*VS1(25,16))&
   +HfxZpE*VS1(41,8)
VS0(63,17)=PAy*VS0(41,17)+WPy*VS1(41,17)&
   +5D0*r1x2Z*(VS0(25,17)-ExZpE*VS1(25,17))&
   +2D0*HfxZpE*VS1(41,9)
VS0(63,18)=PAy*VS0(41,18)+WPy*VS1(41,18)&
   +5D0*r1x2Z*(VS0(25,18)-ExZpE*VS1(25,18))
VS0(63,19)=PAy*VS0(41,19)+WPy*VS1(41,19)&
   +5D0*r1x2Z*(VS0(25,19)-ExZpE*VS1(25,19))&
   +HfxZpE*VS1(41,10)
VS0(63,20)=PAy*VS0(41,20)+WPy*VS1(41,20)&
   +5D0*r1x2Z*(VS0(25,20)-ExZpE*VS1(25,20))
VS0(64,11)=PAx*VS0(42,11)+WPx*VS1(42,11)+r1x2Z*VR1(42,11)&
   +4D0*r1x2Z*(VS0(26,11)-ExZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(42,5)
VS0(64,12)=PAx*VS0(42,12)+WPx*VS1(42,12)+r1x2Z*VR1(42,12)&
   +4D0*r1x2Z*(VS0(26,12)-ExZpE*VS1(26,12))&
   +2D0*HfxZpE*VS1(42,6)
VS0(64,13)=PAx*VS0(42,13)+WPx*VS1(42,13)+r1x2Z*VR1(42,13)&
   +4D0*r1x2Z*(VS0(26,13)-ExZpE*VS1(26,13))&
   +HfxZpE*VS1(42,7)
VS0(64,14)=PAx*VS0(42,14)+WPx*VS1(42,14)+r1x2Z*VR1(42,14)&
   +4D0*r1x2Z*(VS0(26,14)-ExZpE*VS1(26,14))
VS0(64,15)=PAx*VS0(42,15)+WPx*VS1(42,15)+r1x2Z*VR1(42,15)&
   +4D0*r1x2Z*(VS0(26,15)-ExZpE*VS1(26,15))&
   +2D0*HfxZpE*VS1(42,8)
VS0(64,16)=PAx*VS0(42,16)+WPx*VS1(42,16)+r1x2Z*VR1(42,16)&
   +4D0*r1x2Z*(VS0(26,16)-ExZpE*VS1(26,16))&
   +HfxZpE*VS1(42,9)
VS0(64,17)=PAx*VS0(42,17)+WPx*VS1(42,17)+r1x2Z*VR1(42,17)&
   +4D0*r1x2Z*(VS0(26,17)-ExZpE*VS1(26,17))
VS0(64,18)=PAx*VS0(42,18)+WPx*VS1(42,18)+r1x2Z*VR1(42,18)&
   +4D0*r1x2Z*(VS0(26,18)-ExZpE*VS1(26,18))&
   +HfxZpE*VS1(42,10)
VS0(64,19)=PAx*VS0(42,19)+WPx*VS1(42,19)+r1x2Z*VR1(42,19)&
   +4D0*r1x2Z*(VS0(26,19)-ExZpE*VS1(26,19))
VS0(64,20)=PAx*VS0(42,20)+WPx*VS1(42,20)+r1x2Z*VR1(42,20)&
   +4D0*r1x2Z*(VS0(26,20)-ExZpE*VS1(26,20))
VS0(65,11)=PAx*VS0(43,11)+WPx*VS1(43,11)+r1x2Z*VR1(43,11)&
   +3D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))&
   +3D0*HfxZpE*VS1(43,5)
VS0(65,12)=PAx*VS0(43,12)+WPx*VS1(43,12)+r1x2Z*VR1(43,12)&
   +3D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(43,6)
VS0(65,13)=PAx*VS0(43,13)+WPx*VS1(43,13)+r1x2Z*VR1(43,13)&
   +3D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +HfxZpE*VS1(43,7)
VS0(65,14)=PAx*VS0(43,14)+WPx*VS1(43,14)+r1x2Z*VR1(43,14)&
   +3D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(65,15)=PAx*VS0(43,15)+WPx*VS1(43,15)+r1x2Z*VR1(43,15)&
   +3D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(43,8)
VS0(65,16)=PAx*VS0(43,16)+WPx*VS1(43,16)+r1x2Z*VR1(43,16)&
   +3D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(43,9)
VS0(65,17)=PAx*VS0(43,17)+WPx*VS1(43,17)+r1x2Z*VR1(43,17)&
   +3D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))
VS0(65,18)=PAx*VS0(43,18)+WPx*VS1(43,18)+r1x2Z*VR1(43,18)&
   +3D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +HfxZpE*VS1(43,10)
VS0(65,19)=PAx*VS0(43,19)+WPx*VS1(43,19)+r1x2Z*VR1(43,19)&
   +3D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))
VS0(65,20)=PAx*VS0(43,20)+WPx*VS1(43,20)+r1x2Z*VR1(43,20)&
   +3D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(66,11)=PAx*VS0(44,11)+WPx*VS1(44,11)+r1x2Z*VR1(44,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))&
   +3D0*HfxZpE*VS1(44,5)
VS0(66,12)=PAx*VS0(44,12)+WPx*VS1(44,12)+r1x2Z*VR1(44,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(44,6)
VS0(66,13)=PAx*VS0(44,13)+WPx*VS1(44,13)+r1x2Z*VR1(44,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +HfxZpE*VS1(44,7)
VS0(66,14)=PAx*VS0(44,14)+WPx*VS1(44,14)+r1x2Z*VR1(44,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(66,15)=PAx*VS0(44,15)+WPx*VS1(44,15)+r1x2Z*VR1(44,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +2D0*HfxZpE*VS1(44,8)
VS0(66,16)=PAx*VS0(44,16)+WPx*VS1(44,16)+r1x2Z*VR1(44,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(44,9)
VS0(66,17)=PAx*VS0(44,17)+WPx*VS1(44,17)+r1x2Z*VR1(44,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))
VS0(66,18)=PAx*VS0(44,18)+WPx*VS1(44,18)+r1x2Z*VR1(44,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +HfxZpE*VS1(44,10)
VS0(66,19)=PAx*VS0(44,19)+WPx*VS1(44,19)+r1x2Z*VR1(44,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))
VS0(66,20)=PAx*VS0(44,20)+WPx*VS1(44,20)+r1x2Z*VR1(44,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(67,11)=PAy*VS0(44,11)+WPy*VS1(44,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(67,12)=PAy*VS0(44,12)+WPy*VS1(44,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +HfxZpE*VS1(44,5)
VS0(67,13)=PAy*VS0(44,13)+WPy*VS1(44,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(44,6)
VS0(67,14)=PAy*VS0(44,14)+WPy*VS1(44,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))&
   +3D0*HfxZpE*VS1(44,7)
VS0(67,15)=PAy*VS0(44,15)+WPy*VS1(44,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))
VS0(67,16)=PAy*VS0(44,16)+WPy*VS1(44,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(44,8)
VS0(67,17)=PAy*VS0(44,17)+WPy*VS1(44,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(44,9)
VS0(67,18)=PAy*VS0(44,18)+WPy*VS1(44,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))
VS0(67,19)=PAy*VS0(44,19)+WPy*VS1(44,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +HfxZpE*VS1(44,10)
VS0(67,20)=PAy*VS0(44,20)+WPy*VS1(44,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(68,11)=PAy*VS0(45,11)+WPy*VS1(45,11)&
   +3D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(68,12)=PAy*VS0(45,12)+WPy*VS1(45,12)&
   +3D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +HfxZpE*VS1(45,5)
VS0(68,13)=PAy*VS0(45,13)+WPy*VS1(45,13)&
   +3D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(45,6)
VS0(68,14)=PAy*VS0(45,14)+WPy*VS1(45,14)&
   +3D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))&
   +3D0*HfxZpE*VS1(45,7)
VS0(68,15)=PAy*VS0(45,15)+WPy*VS1(45,15)&
   +3D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))
VS0(68,16)=PAy*VS0(45,16)+WPy*VS1(45,16)&
   +3D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(45,8)
VS0(68,17)=PAy*VS0(45,17)+WPy*VS1(45,17)&
   +3D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(45,9)
VS0(68,18)=PAy*VS0(45,18)+WPy*VS1(45,18)&
   +3D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))
VS0(68,19)=PAy*VS0(45,19)+WPy*VS1(45,19)&
   +3D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +HfxZpE*VS1(45,10)
VS0(68,20)=PAy*VS0(45,20)+WPy*VS1(45,20)&
   +3D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(69,11)=PAy*VS0(46,11)+WPy*VS1(46,11)&
   +4D0*r1x2Z*(VS0(29,11)-ExZpE*VS1(29,11))
VS0(69,12)=PAy*VS0(46,12)+WPy*VS1(46,12)&
   +4D0*r1x2Z*(VS0(29,12)-ExZpE*VS1(29,12))&
   +HfxZpE*VS1(46,5)
VS0(69,13)=PAy*VS0(46,13)+WPy*VS1(46,13)&
   +4D0*r1x2Z*(VS0(29,13)-ExZpE*VS1(29,13))&
   +2D0*HfxZpE*VS1(46,6)
VS0(69,14)=PAy*VS0(46,14)+WPy*VS1(46,14)&
   +4D0*r1x2Z*(VS0(29,14)-ExZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(46,7)
VS0(69,15)=PAy*VS0(46,15)+WPy*VS1(46,15)&
   +4D0*r1x2Z*(VS0(29,15)-ExZpE*VS1(29,15))
VS0(69,16)=PAy*VS0(46,16)+WPy*VS1(46,16)&
   +4D0*r1x2Z*(VS0(29,16)-ExZpE*VS1(29,16))&
   +HfxZpE*VS1(46,8)
VS0(69,17)=PAy*VS0(46,17)+WPy*VS1(46,17)&
   +4D0*r1x2Z*(VS0(29,17)-ExZpE*VS1(29,17))&
   +2D0*HfxZpE*VS1(46,9)
VS0(69,18)=PAy*VS0(46,18)+WPy*VS1(46,18)&
   +4D0*r1x2Z*(VS0(29,18)-ExZpE*VS1(29,18))
VS0(69,19)=PAy*VS0(46,19)+WPy*VS1(46,19)&
   +4D0*r1x2Z*(VS0(29,19)-ExZpE*VS1(29,19))&
   +HfxZpE*VS1(46,10)
VS0(69,20)=PAy*VS0(46,20)+WPy*VS1(46,20)&
   +4D0*r1x2Z*(VS0(29,20)-ExZpE*VS1(29,20))
VS0(70,11)=PAx*VS0(47,11)+WPx*VS1(47,11)+r1x2Z*VR1(47,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))&
   +3D0*HfxZpE*VS1(47,5)
VS0(70,12)=PAx*VS0(47,12)+WPx*VS1(47,12)+r1x2Z*VR1(47,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(47,6)
VS0(70,13)=PAx*VS0(47,13)+WPx*VS1(47,13)+r1x2Z*VR1(47,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))&
   +HfxZpE*VS1(47,7)
VS0(70,14)=PAx*VS0(47,14)+WPx*VS1(47,14)+r1x2Z*VR1(47,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(70,15)=PAx*VS0(47,15)+WPx*VS1(47,15)+r1x2Z*VR1(47,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(47,8)
VS0(70,16)=PAx*VS0(47,16)+WPx*VS1(47,16)+r1x2Z*VR1(47,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(47,9)
VS0(70,17)=PAx*VS0(47,17)+WPx*VS1(47,17)+r1x2Z*VR1(47,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))
VS0(70,18)=PAx*VS0(47,18)+WPx*VS1(47,18)+r1x2Z*VR1(47,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +HfxZpE*VS1(47,10)
VS0(70,19)=PAx*VS0(47,19)+WPx*VS1(47,19)+r1x2Z*VR1(47,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))
VS0(70,20)=PAx*VS0(47,20)+WPx*VS1(47,20)+r1x2Z*VR1(47,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))
VS0(71,11)=PAx*VS0(48,11)+WPx*VS1(48,11)+r1x2Z*VR1(48,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))&
   +3D0*HfxZpE*VS1(48,5)
VS0(71,12)=PAx*VS0(48,12)+WPx*VS1(48,12)+r1x2Z*VR1(48,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +2D0*HfxZpE*VS1(48,6)
VS0(71,13)=PAx*VS0(48,13)+WPx*VS1(48,13)+r1x2Z*VR1(48,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +HfxZpE*VS1(48,7)
VS0(71,14)=PAx*VS0(48,14)+WPx*VS1(48,14)+r1x2Z*VR1(48,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(71,15)=PAx*VS0(48,15)+WPx*VS1(48,15)+r1x2Z*VR1(48,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(48,8)
VS0(71,16)=PAx*VS0(48,16)+WPx*VS1(48,16)+r1x2Z*VR1(48,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(48,9)
VS0(71,17)=PAx*VS0(48,17)+WPx*VS1(48,17)+r1x2Z*VR1(48,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))
VS0(71,18)=PAx*VS0(48,18)+WPx*VS1(48,18)+r1x2Z*VR1(48,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +HfxZpE*VS1(48,10)
VS0(71,19)=PAx*VS0(48,19)+WPx*VS1(48,19)+r1x2Z*VR1(48,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))
VS0(71,20)=PAx*VS0(48,20)+WPx*VS1(48,20)+r1x2Z*VR1(48,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(72,11)=PAx*VS0(49,11)+WPx*VS1(49,11)+r1x2Z*VR1(49,11)&
   +r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))&
   +3D0*HfxZpE*VS1(49,5)
VS0(72,12)=PAx*VS0(49,12)+WPx*VS1(49,12)+r1x2Z*VR1(49,12)&
   +r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(49,6)
VS0(72,13)=PAx*VS0(49,13)+WPx*VS1(49,13)+r1x2Z*VR1(49,13)&
   +r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +HfxZpE*VS1(49,7)
VS0(72,14)=PAx*VS0(49,14)+WPx*VS1(49,14)+r1x2Z*VR1(49,14)&
   +r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(72,15)=PAx*VS0(49,15)+WPx*VS1(49,15)+r1x2Z*VR1(49,15)&
   +r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(49,8)
VS0(72,16)=PAx*VS0(49,16)+WPx*VS1(49,16)+r1x2Z*VR1(49,16)&
   +r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(49,9)
VS0(72,17)=PAx*VS0(49,17)+WPx*VS1(49,17)+r1x2Z*VR1(49,17)&
   +r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))
VS0(72,18)=PAx*VS0(49,18)+WPx*VS1(49,18)+r1x2Z*VR1(49,18)&
   +r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +HfxZpE*VS1(49,10)
VS0(72,19)=PAx*VS0(49,19)+WPx*VS1(49,19)+r1x2Z*VR1(49,19)&
   +r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))
VS0(72,20)=PAx*VS0(49,20)+WPx*VS1(49,20)+r1x2Z*VR1(49,20)&
   +r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(73,11)=PAy*VS0(49,11)+WPy*VS1(49,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(73,12)=PAy*VS0(49,12)+WPy*VS1(49,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +HfxZpE*VS1(49,5)
VS0(73,13)=PAy*VS0(49,13)+WPy*VS1(49,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +2D0*HfxZpE*VS1(49,6)
VS0(73,14)=PAy*VS0(49,14)+WPy*VS1(49,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))&
   +3D0*HfxZpE*VS1(49,7)
VS0(73,15)=PAy*VS0(49,15)+WPy*VS1(49,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))
VS0(73,16)=PAy*VS0(49,16)+WPy*VS1(49,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(49,8)
VS0(73,17)=PAy*VS0(49,17)+WPy*VS1(49,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(49,9)
VS0(73,18)=PAy*VS0(49,18)+WPy*VS1(49,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))
VS0(73,19)=PAy*VS0(49,19)+WPy*VS1(49,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +HfxZpE*VS1(49,10)
VS0(73,20)=PAy*VS0(49,20)+WPy*VS1(49,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(74,11)=PAy*VS0(50,11)+WPy*VS1(50,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(74,12)=PAy*VS0(50,12)+WPy*VS1(50,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +HfxZpE*VS1(50,5)
VS0(74,13)=PAy*VS0(50,13)+WPy*VS1(50,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(50,6)
VS0(74,14)=PAy*VS0(50,14)+WPy*VS1(50,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))&
   +3D0*HfxZpE*VS1(50,7)
VS0(74,15)=PAy*VS0(50,15)+WPy*VS1(50,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))
VS0(74,16)=PAy*VS0(50,16)+WPy*VS1(50,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(50,8)
VS0(74,17)=PAy*VS0(50,17)+WPy*VS1(50,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(50,9)
VS0(74,18)=PAy*VS0(50,18)+WPy*VS1(50,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))
VS0(74,19)=PAy*VS0(50,19)+WPy*VS1(50,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +HfxZpE*VS1(50,10)
VS0(74,20)=PAy*VS0(50,20)+WPy*VS1(50,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(75,11)=PAx*VS0(51,11)+WPx*VS1(51,11)+r1x2Z*VR1(51,11)&
   +2D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))&
   +3D0*HfxZpE*VS1(51,5)
VS0(75,12)=PAx*VS0(51,12)+WPx*VS1(51,12)+r1x2Z*VR1(51,12)&
   +2D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))&
   +2D0*HfxZpE*VS1(51,6)
VS0(75,13)=PAx*VS0(51,13)+WPx*VS1(51,13)+r1x2Z*VR1(51,13)&
   +2D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))&
   +HfxZpE*VS1(51,7)
VS0(75,14)=PAx*VS0(51,14)+WPx*VS1(51,14)+r1x2Z*VR1(51,14)&
   +2D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(75,15)=PAx*VS0(51,15)+WPx*VS1(51,15)+r1x2Z*VR1(51,15)&
   +2D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +2D0*HfxZpE*VS1(51,8)
VS0(75,16)=PAx*VS0(51,16)+WPx*VS1(51,16)+r1x2Z*VR1(51,16)&
   +2D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(51,9)
VS0(75,17)=PAx*VS0(51,17)+WPx*VS1(51,17)+r1x2Z*VR1(51,17)&
   +2D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))
VS0(75,18)=PAx*VS0(51,18)+WPx*VS1(51,18)+r1x2Z*VR1(51,18)&
   +2D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +HfxZpE*VS1(51,10)
VS0(75,19)=PAx*VS0(51,19)+WPx*VS1(51,19)+r1x2Z*VR1(51,19)&
   +2D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))
VS0(75,20)=PAx*VS0(51,20)+WPx*VS1(51,20)+r1x2Z*VR1(51,20)&
   +2D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))
VS0(76,11)=PAz*VS0(48,11)+WPz*VS1(48,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(76,12)=PAz*VS0(48,12)+WPz*VS1(48,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))
VS0(76,13)=PAz*VS0(48,13)+WPz*VS1(48,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))
VS0(76,14)=PAz*VS0(48,14)+WPz*VS1(48,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(76,15)=PAz*VS0(48,15)+WPz*VS1(48,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +HfxZpE*VS1(48,5)
VS0(76,16)=PAz*VS0(48,16)+WPz*VS1(48,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(48,6)
VS0(76,17)=PAz*VS0(48,17)+WPz*VS1(48,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +HfxZpE*VS1(48,7)
VS0(76,18)=PAz*VS0(48,18)+WPz*VS1(48,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(48,8)
VS0(76,19)=PAz*VS0(48,19)+WPz*VS1(48,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(48,9)
VS0(76,20)=PAz*VS0(48,20)+WPz*VS1(48,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))&
   +3D0*HfxZpE*VS1(48,10)
VS0(77,11)=PAz*VS0(49,11)+WPz*VS1(49,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(77,12)=PAz*VS0(49,12)+WPz*VS1(49,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))
VS0(77,13)=PAz*VS0(49,13)+WPz*VS1(49,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))
VS0(77,14)=PAz*VS0(49,14)+WPz*VS1(49,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(77,15)=PAz*VS0(49,15)+WPz*VS1(49,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +HfxZpE*VS1(49,5)
VS0(77,16)=PAz*VS0(49,16)+WPz*VS1(49,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(49,6)
VS0(77,17)=PAz*VS0(49,17)+WPz*VS1(49,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +HfxZpE*VS1(49,7)
VS0(77,18)=PAz*VS0(49,18)+WPz*VS1(49,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(49,8)
VS0(77,19)=PAz*VS0(49,19)+WPz*VS1(49,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(49,9)
VS0(77,20)=PAz*VS0(49,20)+WPz*VS1(49,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))&
   +3D0*HfxZpE*VS1(49,10)
VS0(78,11)=PAy*VS0(53,11)+WPy*VS1(53,11)&
   +2D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(78,12)=PAy*VS0(53,12)+WPy*VS1(53,12)&
   +2D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))&
   +HfxZpE*VS1(53,5)
VS0(78,13)=PAy*VS0(53,13)+WPy*VS1(53,13)&
   +2D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))&
   +2D0*HfxZpE*VS1(53,6)
VS0(78,14)=PAy*VS0(53,14)+WPy*VS1(53,14)&
   +2D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))&
   +3D0*HfxZpE*VS1(53,7)
VS0(78,15)=PAy*VS0(53,15)+WPy*VS1(53,15)&
   +2D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))
VS0(78,16)=PAy*VS0(53,16)+WPy*VS1(53,16)&
   +2D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(53,8)
VS0(78,17)=PAy*VS0(53,17)+WPy*VS1(53,17)&
   +2D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +2D0*HfxZpE*VS1(53,9)
VS0(78,18)=PAy*VS0(53,18)+WPy*VS1(53,18)&
   +2D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))
VS0(78,19)=PAy*VS0(53,19)+WPy*VS1(53,19)&
   +2D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +HfxZpE*VS1(53,10)
VS0(78,20)=PAy*VS0(53,20)+WPy*VS1(53,20)&
   +2D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))
VS0(79,11)=PAz*VS0(51,11)+WPz*VS1(51,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))
VS0(79,12)=PAz*VS0(51,12)+WPz*VS1(51,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))
VS0(79,13)=PAz*VS0(51,13)+WPz*VS1(51,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))
VS0(79,14)=PAz*VS0(51,14)+WPz*VS1(51,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(79,15)=PAz*VS0(51,15)+WPz*VS1(51,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +HfxZpE*VS1(51,5)
VS0(79,16)=PAz*VS0(51,16)+WPz*VS1(51,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(51,6)
VS0(79,17)=PAz*VS0(51,17)+WPz*VS1(51,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))&
   +HfxZpE*VS1(51,7)
VS0(79,18)=PAz*VS0(51,18)+WPz*VS1(51,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(51,8)
VS0(79,19)=PAz*VS0(51,19)+WPz*VS1(51,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(51,9)
VS0(79,20)=PAz*VS0(51,20)+WPz*VS1(51,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))&
   +3D0*HfxZpE*VS1(51,10)
VS0(80,11)=PAz*VS0(52,11)+WPz*VS1(52,11)&
   +3D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(80,12)=PAz*VS0(52,12)+WPz*VS1(52,12)&
   +3D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))
VS0(80,13)=PAz*VS0(52,13)+WPz*VS1(52,13)&
   +3D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))
VS0(80,14)=PAz*VS0(52,14)+WPz*VS1(52,14)&
   +3D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(80,15)=PAz*VS0(52,15)+WPz*VS1(52,15)&
   +3D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +HfxZpE*VS1(52,5)
VS0(80,16)=PAz*VS0(52,16)+WPz*VS1(52,16)&
   +3D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(52,6)
VS0(80,17)=PAz*VS0(52,17)+WPz*VS1(52,17)&
   +3D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +HfxZpE*VS1(52,7)
VS0(80,18)=PAz*VS0(52,18)+WPz*VS1(52,18)&
   +3D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(52,8)
VS0(80,19)=PAz*VS0(52,19)+WPz*VS1(52,19)&
   +3D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(52,9)
VS0(80,20)=PAz*VS0(52,20)+WPz*VS1(52,20)&
   +3D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))&
   +3D0*HfxZpE*VS1(52,10)
VS0(81,11)=PAz*VS0(53,11)+WPz*VS1(53,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(81,12)=PAz*VS0(53,12)+WPz*VS1(53,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))
VS0(81,13)=PAz*VS0(53,13)+WPz*VS1(53,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))
VS0(81,14)=PAz*VS0(53,14)+WPz*VS1(53,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(81,15)=PAz*VS0(53,15)+WPz*VS1(53,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +HfxZpE*VS1(53,5)
VS0(81,16)=PAz*VS0(53,16)+WPz*VS1(53,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(53,6)
VS0(81,17)=PAz*VS0(53,17)+WPz*VS1(53,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +HfxZpE*VS1(53,7)
VS0(81,18)=PAz*VS0(53,18)+WPz*VS1(53,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(53,8)
VS0(81,19)=PAz*VS0(53,19)+WPz*VS1(53,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(53,9)
VS0(81,20)=PAz*VS0(53,20)+WPz*VS1(53,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))&
   +3D0*HfxZpE*VS1(53,10)
VS0(82,11)=PAz*VS0(54,11)+WPz*VS1(54,11)&
   +4D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))
VS0(82,12)=PAz*VS0(54,12)+WPz*VS1(54,12)&
   +4D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))
VS0(82,13)=PAz*VS0(54,13)+WPz*VS1(54,13)&
   +4D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))
VS0(82,14)=PAz*VS0(54,14)+WPz*VS1(54,14)&
   +4D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(82,15)=PAz*VS0(54,15)+WPz*VS1(54,15)&
   +4D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +HfxZpE*VS1(54,5)
VS0(82,16)=PAz*VS0(54,16)+WPz*VS1(54,16)&
   +4D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(54,6)
VS0(82,17)=PAz*VS0(54,17)+WPz*VS1(54,17)&
   +4D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))&
   +HfxZpE*VS1(54,7)
VS0(82,18)=PAz*VS0(54,18)+WPz*VS1(54,18)&
   +4D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +2D0*HfxZpE*VS1(54,8)
VS0(82,19)=PAz*VS0(54,19)+WPz*VS1(54,19)&
   +4D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))&
   +2D0*HfxZpE*VS1(54,9)
VS0(82,20)=PAz*VS0(54,20)+WPz*VS1(54,20)&
   +4D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(54,10)
VS0(83,11)=PAz*VS0(55,11)+WPz*VS1(55,11)&
   +4D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(83,12)=PAz*VS0(55,12)+WPz*VS1(55,12)&
   +4D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))
VS0(83,13)=PAz*VS0(55,13)+WPz*VS1(55,13)&
   +4D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))
VS0(83,14)=PAz*VS0(55,14)+WPz*VS1(55,14)&
   +4D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))
VS0(83,15)=PAz*VS0(55,15)+WPz*VS1(55,15)&
   +4D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))&
   +HfxZpE*VS1(55,5)
VS0(83,16)=PAz*VS0(55,16)+WPz*VS1(55,16)&
   +4D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(55,6)
VS0(83,17)=PAz*VS0(55,17)+WPz*VS1(55,17)&
   +4D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +HfxZpE*VS1(55,7)
VS0(83,18)=PAz*VS0(55,18)+WPz*VS1(55,18)&
   +4D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))&
   +2D0*HfxZpE*VS1(55,8)
VS0(83,19)=PAz*VS0(55,19)+WPz*VS1(55,19)&
   +4D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +2D0*HfxZpE*VS1(55,9)
VS0(83,20)=PAz*VS0(55,20)+WPz*VS1(55,20)&
   +4D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(55,10)
VS0(84,11)=PAz*VS0(56,11)+WPz*VS1(56,11)&
   +5D0*r1x2Z*(VS0(35,11)-ExZpE*VS1(35,11))
VS0(84,12)=PAz*VS0(56,12)+WPz*VS1(56,12)&
   +5D0*r1x2Z*(VS0(35,12)-ExZpE*VS1(35,12))
VS0(84,13)=PAz*VS0(56,13)+WPz*VS1(56,13)&
   +5D0*r1x2Z*(VS0(35,13)-ExZpE*VS1(35,13))
VS0(84,14)=PAz*VS0(56,14)+WPz*VS1(56,14)&
   +5D0*r1x2Z*(VS0(35,14)-ExZpE*VS1(35,14))
VS0(84,15)=PAz*VS0(56,15)+WPz*VS1(56,15)&
   +5D0*r1x2Z*(VS0(35,15)-ExZpE*VS1(35,15))&
   +HfxZpE*VS1(56,5)
VS0(84,16)=PAz*VS0(56,16)+WPz*VS1(56,16)&
   +5D0*r1x2Z*(VS0(35,16)-ExZpE*VS1(35,16))&
   +HfxZpE*VS1(56,6)
VS0(84,17)=PAz*VS0(56,17)+WPz*VS1(56,17)&
   +5D0*r1x2Z*(VS0(35,17)-ExZpE*VS1(35,17))&
   +HfxZpE*VS1(56,7)
VS0(84,18)=PAz*VS0(56,18)+WPz*VS1(56,18)&
   +5D0*r1x2Z*(VS0(35,18)-ExZpE*VS1(35,18))&
   +2D0*HfxZpE*VS1(56,8)
VS0(84,19)=PAz*VS0(56,19)+WPz*VS1(56,19)&
   +5D0*r1x2Z*(VS0(35,19)-ExZpE*VS1(35,19))&
   +2D0*HfxZpE*VS1(56,9)
VS0(84,20)=PAz*VS0(56,20)+WPz*VS1(56,20)&
   +5D0*r1x2Z*(VS0(35,20)-ExZpE*VS1(35,20))&
   +3D0*HfxZpE*VS1(56,10)
CASE(2)
VS0(57,11)=PAx*VS0(36,11)+WPx*VS1(36,11)&
   +5D0*r1x2Z*(VS0(21,11)-ExZpE*VS1(21,11))&
   +3D0*HfxZpE*VS1(36,5)
VS0(57,12)=PAx*VS0(36,12)+WPx*VS1(36,12)&
   +5D0*r1x2Z*(VS0(21,12)-ExZpE*VS1(21,12))&
   +2D0*HfxZpE*VS1(36,6)
VS0(57,13)=PAx*VS0(36,13)+WPx*VS1(36,13)&
   +5D0*r1x2Z*(VS0(21,13)-ExZpE*VS1(21,13))&
   +HfxZpE*VS1(36,7)
VS0(57,14)=PAx*VS0(36,14)+WPx*VS1(36,14)&
   +5D0*r1x2Z*(VS0(21,14)-ExZpE*VS1(21,14))
VS0(57,15)=PAx*VS0(36,15)+WPx*VS1(36,15)&
   +5D0*r1x2Z*(VS0(21,15)-ExZpE*VS1(21,15))&
   +2D0*HfxZpE*VS1(36,8)
VS0(57,16)=PAx*VS0(36,16)+WPx*VS1(36,16)&
   +5D0*r1x2Z*(VS0(21,16)-ExZpE*VS1(21,16))&
   +HfxZpE*VS1(36,9)
VS0(57,17)=PAx*VS0(36,17)+WPx*VS1(36,17)&
   +5D0*r1x2Z*(VS0(21,17)-ExZpE*VS1(21,17))
VS0(57,18)=PAx*VS0(36,18)+WPx*VS1(36,18)&
   +5D0*r1x2Z*(VS0(21,18)-ExZpE*VS1(21,18))&
   +HfxZpE*VS1(36,10)
VS0(57,19)=PAx*VS0(36,19)+WPx*VS1(36,19)&
   +5D0*r1x2Z*(VS0(21,19)-ExZpE*VS1(21,19))
VS0(57,20)=PAx*VS0(36,20)+WPx*VS1(36,20)&
   +5D0*r1x2Z*(VS0(21,20)-ExZpE*VS1(21,20))
VS0(58,11)=PAx*VS0(37,11)+WPx*VS1(37,11)&
   +4D0*r1x2Z*(VS0(22,11)-ExZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(37,5)
VS0(58,12)=PAx*VS0(37,12)+WPx*VS1(37,12)&
   +4D0*r1x2Z*(VS0(22,12)-ExZpE*VS1(22,12))&
   +2D0*HfxZpE*VS1(37,6)
VS0(58,13)=PAx*VS0(37,13)+WPx*VS1(37,13)&
   +4D0*r1x2Z*(VS0(22,13)-ExZpE*VS1(22,13))&
   +HfxZpE*VS1(37,7)
VS0(58,14)=PAx*VS0(37,14)+WPx*VS1(37,14)&
   +4D0*r1x2Z*(VS0(22,14)-ExZpE*VS1(22,14))
VS0(58,15)=PAx*VS0(37,15)+WPx*VS1(37,15)&
   +4D0*r1x2Z*(VS0(22,15)-ExZpE*VS1(22,15))&
   +2D0*HfxZpE*VS1(37,8)
VS0(58,16)=PAx*VS0(37,16)+WPx*VS1(37,16)&
   +4D0*r1x2Z*(VS0(22,16)-ExZpE*VS1(22,16))&
   +HfxZpE*VS1(37,9)
VS0(58,17)=PAx*VS0(37,17)+WPx*VS1(37,17)&
   +4D0*r1x2Z*(VS0(22,17)-ExZpE*VS1(22,17))
VS0(58,18)=PAx*VS0(37,18)+WPx*VS1(37,18)&
   +4D0*r1x2Z*(VS0(22,18)-ExZpE*VS1(22,18))&
   +HfxZpE*VS1(37,10)
VS0(58,19)=PAx*VS0(37,19)+WPx*VS1(37,19)&
   +4D0*r1x2Z*(VS0(22,19)-ExZpE*VS1(22,19))
VS0(58,20)=PAx*VS0(37,20)+WPx*VS1(37,20)&
   +4D0*r1x2Z*(VS0(22,20)-ExZpE*VS1(22,20))
VS0(59,11)=PAx*VS0(38,11)+WPx*VS1(38,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))&
   +3D0*HfxZpE*VS1(38,5)
VS0(59,12)=PAx*VS0(38,12)+WPx*VS1(38,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(38,6)
VS0(59,13)=PAx*VS0(38,13)+WPx*VS1(38,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +HfxZpE*VS1(38,7)
VS0(59,14)=PAx*VS0(38,14)+WPx*VS1(38,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))
VS0(59,15)=PAx*VS0(38,15)+WPx*VS1(38,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(38,8)
VS0(59,16)=PAx*VS0(38,16)+WPx*VS1(38,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(38,9)
VS0(59,17)=PAx*VS0(38,17)+WPx*VS1(38,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))
VS0(59,18)=PAx*VS0(38,18)+WPx*VS1(38,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))&
   +HfxZpE*VS1(38,10)
VS0(59,19)=PAx*VS0(38,19)+WPx*VS1(38,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))
VS0(59,20)=PAx*VS0(38,20)+WPx*VS1(38,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(60,11)=PAx*VS0(39,11)+WPx*VS1(39,11)&
   +2D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))&
   +3D0*HfxZpE*VS1(39,5)
VS0(60,12)=PAx*VS0(39,12)+WPx*VS1(39,12)&
   +2D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +2D0*HfxZpE*VS1(39,6)
VS0(60,13)=PAx*VS0(39,13)+WPx*VS1(39,13)&
   +2D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +HfxZpE*VS1(39,7)
VS0(60,14)=PAx*VS0(39,14)+WPx*VS1(39,14)&
   +2D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))
VS0(60,15)=PAx*VS0(39,15)+WPx*VS1(39,15)&
   +2D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))&
   +2D0*HfxZpE*VS1(39,8)
VS0(60,16)=PAx*VS0(39,16)+WPx*VS1(39,16)&
   +2D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(39,9)
VS0(60,17)=PAx*VS0(39,17)+WPx*VS1(39,17)&
   +2D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))
VS0(60,18)=PAx*VS0(39,18)+WPx*VS1(39,18)&
   +2D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))&
   +HfxZpE*VS1(39,10)
VS0(60,19)=PAx*VS0(39,19)+WPx*VS1(39,19)&
   +2D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))
VS0(60,20)=PAx*VS0(39,20)+WPx*VS1(39,20)&
   +2D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(61,11)=PAy*VS0(39,11)+WPy*VS1(39,11)+r1x2Z*VR1(39,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))
VS0(61,12)=PAy*VS0(39,12)+WPy*VS1(39,12)+r1x2Z*VR1(39,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +HfxZpE*VS1(39,5)
VS0(61,13)=PAy*VS0(39,13)+WPy*VS1(39,13)+r1x2Z*VR1(39,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(39,6)
VS0(61,14)=PAy*VS0(39,14)+WPy*VS1(39,14)+r1x2Z*VR1(39,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))&
   +3D0*HfxZpE*VS1(39,7)
VS0(61,15)=PAy*VS0(39,15)+WPy*VS1(39,15)+r1x2Z*VR1(39,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))
VS0(61,16)=PAy*VS0(39,16)+WPy*VS1(39,16)+r1x2Z*VR1(39,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(39,8)
VS0(61,17)=PAy*VS0(39,17)+WPy*VS1(39,17)+r1x2Z*VR1(39,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(39,9)
VS0(61,18)=PAy*VS0(39,18)+WPy*VS1(39,18)+r1x2Z*VR1(39,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))
VS0(61,19)=PAy*VS0(39,19)+WPy*VS1(39,19)+r1x2Z*VR1(39,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))&
   +HfxZpE*VS1(39,10)
VS0(61,20)=PAy*VS0(39,20)+WPy*VS1(39,20)+r1x2Z*VR1(39,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(62,11)=PAy*VS0(40,11)+WPy*VS1(40,11)+r1x2Z*VR1(40,11)&
   +4D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))
VS0(62,12)=PAy*VS0(40,12)+WPy*VS1(40,12)+r1x2Z*VR1(40,12)&
   +4D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +HfxZpE*VS1(40,5)
VS0(62,13)=PAy*VS0(40,13)+WPy*VS1(40,13)+r1x2Z*VR1(40,13)&
   +4D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +2D0*HfxZpE*VS1(40,6)
VS0(62,14)=PAy*VS0(40,14)+WPy*VS1(40,14)+r1x2Z*VR1(40,14)&
   +4D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(40,7)
VS0(62,15)=PAy*VS0(40,15)+WPy*VS1(40,15)+r1x2Z*VR1(40,15)&
   +4D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))
VS0(62,16)=PAy*VS0(40,16)+WPy*VS1(40,16)+r1x2Z*VR1(40,16)&
   +4D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(40,8)
VS0(62,17)=PAy*VS0(40,17)+WPy*VS1(40,17)+r1x2Z*VR1(40,17)&
   +4D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))&
   +2D0*HfxZpE*VS1(40,9)
VS0(62,18)=PAy*VS0(40,18)+WPy*VS1(40,18)+r1x2Z*VR1(40,18)&
   +4D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))
VS0(62,19)=PAy*VS0(40,19)+WPy*VS1(40,19)+r1x2Z*VR1(40,19)&
   +4D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))&
   +HfxZpE*VS1(40,10)
VS0(62,20)=PAy*VS0(40,20)+WPy*VS1(40,20)+r1x2Z*VR1(40,20)&
   +4D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(63,11)=PAy*VS0(41,11)+WPy*VS1(41,11)+r1x2Z*VR1(41,11)&
   +5D0*r1x2Z*(VS0(25,11)-ExZpE*VS1(25,11))
VS0(63,12)=PAy*VS0(41,12)+WPy*VS1(41,12)+r1x2Z*VR1(41,12)&
   +5D0*r1x2Z*(VS0(25,12)-ExZpE*VS1(25,12))&
   +HfxZpE*VS1(41,5)
VS0(63,13)=PAy*VS0(41,13)+WPy*VS1(41,13)+r1x2Z*VR1(41,13)&
   +5D0*r1x2Z*(VS0(25,13)-ExZpE*VS1(25,13))&
   +2D0*HfxZpE*VS1(41,6)
VS0(63,14)=PAy*VS0(41,14)+WPy*VS1(41,14)+r1x2Z*VR1(41,14)&
   +5D0*r1x2Z*(VS0(25,14)-ExZpE*VS1(25,14))&
   +3D0*HfxZpE*VS1(41,7)
VS0(63,15)=PAy*VS0(41,15)+WPy*VS1(41,15)+r1x2Z*VR1(41,15)&
   +5D0*r1x2Z*(VS0(25,15)-ExZpE*VS1(25,15))
VS0(63,16)=PAy*VS0(41,16)+WPy*VS1(41,16)+r1x2Z*VR1(41,16)&
   +5D0*r1x2Z*(VS0(25,16)-ExZpE*VS1(25,16))&
   +HfxZpE*VS1(41,8)
VS0(63,17)=PAy*VS0(41,17)+WPy*VS1(41,17)+r1x2Z*VR1(41,17)&
   +5D0*r1x2Z*(VS0(25,17)-ExZpE*VS1(25,17))&
   +2D0*HfxZpE*VS1(41,9)
VS0(63,18)=PAy*VS0(41,18)+WPy*VS1(41,18)+r1x2Z*VR1(41,18)&
   +5D0*r1x2Z*(VS0(25,18)-ExZpE*VS1(25,18))
VS0(63,19)=PAy*VS0(41,19)+WPy*VS1(41,19)+r1x2Z*VR1(41,19)&
   +5D0*r1x2Z*(VS0(25,19)-ExZpE*VS1(25,19))&
   +HfxZpE*VS1(41,10)
VS0(63,20)=PAy*VS0(41,20)+WPy*VS1(41,20)+r1x2Z*VR1(41,20)&
   +5D0*r1x2Z*(VS0(25,20)-ExZpE*VS1(25,20))
VS0(64,11)=PAx*VS0(42,11)+WPx*VS1(42,11)&
   +4D0*r1x2Z*(VS0(26,11)-ExZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(42,5)
VS0(64,12)=PAx*VS0(42,12)+WPx*VS1(42,12)&
   +4D0*r1x2Z*(VS0(26,12)-ExZpE*VS1(26,12))&
   +2D0*HfxZpE*VS1(42,6)
VS0(64,13)=PAx*VS0(42,13)+WPx*VS1(42,13)&
   +4D0*r1x2Z*(VS0(26,13)-ExZpE*VS1(26,13))&
   +HfxZpE*VS1(42,7)
VS0(64,14)=PAx*VS0(42,14)+WPx*VS1(42,14)&
   +4D0*r1x2Z*(VS0(26,14)-ExZpE*VS1(26,14))
VS0(64,15)=PAx*VS0(42,15)+WPx*VS1(42,15)&
   +4D0*r1x2Z*(VS0(26,15)-ExZpE*VS1(26,15))&
   +2D0*HfxZpE*VS1(42,8)
VS0(64,16)=PAx*VS0(42,16)+WPx*VS1(42,16)&
   +4D0*r1x2Z*(VS0(26,16)-ExZpE*VS1(26,16))&
   +HfxZpE*VS1(42,9)
VS0(64,17)=PAx*VS0(42,17)+WPx*VS1(42,17)&
   +4D0*r1x2Z*(VS0(26,17)-ExZpE*VS1(26,17))
VS0(64,18)=PAx*VS0(42,18)+WPx*VS1(42,18)&
   +4D0*r1x2Z*(VS0(26,18)-ExZpE*VS1(26,18))&
   +HfxZpE*VS1(42,10)
VS0(64,19)=PAx*VS0(42,19)+WPx*VS1(42,19)&
   +4D0*r1x2Z*(VS0(26,19)-ExZpE*VS1(26,19))
VS0(64,20)=PAx*VS0(42,20)+WPx*VS1(42,20)&
   +4D0*r1x2Z*(VS0(26,20)-ExZpE*VS1(26,20))
VS0(65,11)=PAx*VS0(43,11)+WPx*VS1(43,11)&
   +3D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))&
   +3D0*HfxZpE*VS1(43,5)
VS0(65,12)=PAx*VS0(43,12)+WPx*VS1(43,12)&
   +3D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(43,6)
VS0(65,13)=PAx*VS0(43,13)+WPx*VS1(43,13)&
   +3D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +HfxZpE*VS1(43,7)
VS0(65,14)=PAx*VS0(43,14)+WPx*VS1(43,14)&
   +3D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(65,15)=PAx*VS0(43,15)+WPx*VS1(43,15)&
   +3D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(43,8)
VS0(65,16)=PAx*VS0(43,16)+WPx*VS1(43,16)&
   +3D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(43,9)
VS0(65,17)=PAx*VS0(43,17)+WPx*VS1(43,17)&
   +3D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))
VS0(65,18)=PAx*VS0(43,18)+WPx*VS1(43,18)&
   +3D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +HfxZpE*VS1(43,10)
VS0(65,19)=PAx*VS0(43,19)+WPx*VS1(43,19)&
   +3D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))
VS0(65,20)=PAx*VS0(43,20)+WPx*VS1(43,20)&
   +3D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(66,11)=PAx*VS0(44,11)+WPx*VS1(44,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))&
   +3D0*HfxZpE*VS1(44,5)
VS0(66,12)=PAx*VS0(44,12)+WPx*VS1(44,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(44,6)
VS0(66,13)=PAx*VS0(44,13)+WPx*VS1(44,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +HfxZpE*VS1(44,7)
VS0(66,14)=PAx*VS0(44,14)+WPx*VS1(44,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(66,15)=PAx*VS0(44,15)+WPx*VS1(44,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +2D0*HfxZpE*VS1(44,8)
VS0(66,16)=PAx*VS0(44,16)+WPx*VS1(44,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(44,9)
VS0(66,17)=PAx*VS0(44,17)+WPx*VS1(44,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))
VS0(66,18)=PAx*VS0(44,18)+WPx*VS1(44,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +HfxZpE*VS1(44,10)
VS0(66,19)=PAx*VS0(44,19)+WPx*VS1(44,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))
VS0(66,20)=PAx*VS0(44,20)+WPx*VS1(44,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(67,11)=PAy*VS0(44,11)+WPy*VS1(44,11)+r1x2Z*VR1(44,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(67,12)=PAy*VS0(44,12)+WPy*VS1(44,12)+r1x2Z*VR1(44,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +HfxZpE*VS1(44,5)
VS0(67,13)=PAy*VS0(44,13)+WPy*VS1(44,13)+r1x2Z*VR1(44,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(44,6)
VS0(67,14)=PAy*VS0(44,14)+WPy*VS1(44,14)+r1x2Z*VR1(44,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))&
   +3D0*HfxZpE*VS1(44,7)
VS0(67,15)=PAy*VS0(44,15)+WPy*VS1(44,15)+r1x2Z*VR1(44,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))
VS0(67,16)=PAy*VS0(44,16)+WPy*VS1(44,16)+r1x2Z*VR1(44,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(44,8)
VS0(67,17)=PAy*VS0(44,17)+WPy*VS1(44,17)+r1x2Z*VR1(44,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(44,9)
VS0(67,18)=PAy*VS0(44,18)+WPy*VS1(44,18)+r1x2Z*VR1(44,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))
VS0(67,19)=PAy*VS0(44,19)+WPy*VS1(44,19)+r1x2Z*VR1(44,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +HfxZpE*VS1(44,10)
VS0(67,20)=PAy*VS0(44,20)+WPy*VS1(44,20)+r1x2Z*VR1(44,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(68,11)=PAy*VS0(45,11)+WPy*VS1(45,11)+r1x2Z*VR1(45,11)&
   +3D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(68,12)=PAy*VS0(45,12)+WPy*VS1(45,12)+r1x2Z*VR1(45,12)&
   +3D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +HfxZpE*VS1(45,5)
VS0(68,13)=PAy*VS0(45,13)+WPy*VS1(45,13)+r1x2Z*VR1(45,13)&
   +3D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(45,6)
VS0(68,14)=PAy*VS0(45,14)+WPy*VS1(45,14)+r1x2Z*VR1(45,14)&
   +3D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))&
   +3D0*HfxZpE*VS1(45,7)
VS0(68,15)=PAy*VS0(45,15)+WPy*VS1(45,15)+r1x2Z*VR1(45,15)&
   +3D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))
VS0(68,16)=PAy*VS0(45,16)+WPy*VS1(45,16)+r1x2Z*VR1(45,16)&
   +3D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(45,8)
VS0(68,17)=PAy*VS0(45,17)+WPy*VS1(45,17)+r1x2Z*VR1(45,17)&
   +3D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(45,9)
VS0(68,18)=PAy*VS0(45,18)+WPy*VS1(45,18)+r1x2Z*VR1(45,18)&
   +3D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))
VS0(68,19)=PAy*VS0(45,19)+WPy*VS1(45,19)+r1x2Z*VR1(45,19)&
   +3D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +HfxZpE*VS1(45,10)
VS0(68,20)=PAy*VS0(45,20)+WPy*VS1(45,20)+r1x2Z*VR1(45,20)&
   +3D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(69,11)=PAy*VS0(46,11)+WPy*VS1(46,11)+r1x2Z*VR1(46,11)&
   +4D0*r1x2Z*(VS0(29,11)-ExZpE*VS1(29,11))
VS0(69,12)=PAy*VS0(46,12)+WPy*VS1(46,12)+r1x2Z*VR1(46,12)&
   +4D0*r1x2Z*(VS0(29,12)-ExZpE*VS1(29,12))&
   +HfxZpE*VS1(46,5)
VS0(69,13)=PAy*VS0(46,13)+WPy*VS1(46,13)+r1x2Z*VR1(46,13)&
   +4D0*r1x2Z*(VS0(29,13)-ExZpE*VS1(29,13))&
   +2D0*HfxZpE*VS1(46,6)
VS0(69,14)=PAy*VS0(46,14)+WPy*VS1(46,14)+r1x2Z*VR1(46,14)&
   +4D0*r1x2Z*(VS0(29,14)-ExZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(46,7)
VS0(69,15)=PAy*VS0(46,15)+WPy*VS1(46,15)+r1x2Z*VR1(46,15)&
   +4D0*r1x2Z*(VS0(29,15)-ExZpE*VS1(29,15))
VS0(69,16)=PAy*VS0(46,16)+WPy*VS1(46,16)+r1x2Z*VR1(46,16)&
   +4D0*r1x2Z*(VS0(29,16)-ExZpE*VS1(29,16))&
   +HfxZpE*VS1(46,8)
VS0(69,17)=PAy*VS0(46,17)+WPy*VS1(46,17)+r1x2Z*VR1(46,17)&
   +4D0*r1x2Z*(VS0(29,17)-ExZpE*VS1(29,17))&
   +2D0*HfxZpE*VS1(46,9)
VS0(69,18)=PAy*VS0(46,18)+WPy*VS1(46,18)+r1x2Z*VR1(46,18)&
   +4D0*r1x2Z*(VS0(29,18)-ExZpE*VS1(29,18))
VS0(69,19)=PAy*VS0(46,19)+WPy*VS1(46,19)+r1x2Z*VR1(46,19)&
   +4D0*r1x2Z*(VS0(29,19)-ExZpE*VS1(29,19))&
   +HfxZpE*VS1(46,10)
VS0(69,20)=PAy*VS0(46,20)+WPy*VS1(46,20)+r1x2Z*VR1(46,20)&
   +4D0*r1x2Z*(VS0(29,20)-ExZpE*VS1(29,20))
VS0(70,11)=PAx*VS0(47,11)+WPx*VS1(47,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))&
   +3D0*HfxZpE*VS1(47,5)
VS0(70,12)=PAx*VS0(47,12)+WPx*VS1(47,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(47,6)
VS0(70,13)=PAx*VS0(47,13)+WPx*VS1(47,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))&
   +HfxZpE*VS1(47,7)
VS0(70,14)=PAx*VS0(47,14)+WPx*VS1(47,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(70,15)=PAx*VS0(47,15)+WPx*VS1(47,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(47,8)
VS0(70,16)=PAx*VS0(47,16)+WPx*VS1(47,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(47,9)
VS0(70,17)=PAx*VS0(47,17)+WPx*VS1(47,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))
VS0(70,18)=PAx*VS0(47,18)+WPx*VS1(47,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +HfxZpE*VS1(47,10)
VS0(70,19)=PAx*VS0(47,19)+WPx*VS1(47,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))
VS0(70,20)=PAx*VS0(47,20)+WPx*VS1(47,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))
VS0(71,11)=PAx*VS0(48,11)+WPx*VS1(48,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))&
   +3D0*HfxZpE*VS1(48,5)
VS0(71,12)=PAx*VS0(48,12)+WPx*VS1(48,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +2D0*HfxZpE*VS1(48,6)
VS0(71,13)=PAx*VS0(48,13)+WPx*VS1(48,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +HfxZpE*VS1(48,7)
VS0(71,14)=PAx*VS0(48,14)+WPx*VS1(48,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(71,15)=PAx*VS0(48,15)+WPx*VS1(48,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(48,8)
VS0(71,16)=PAx*VS0(48,16)+WPx*VS1(48,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(48,9)
VS0(71,17)=PAx*VS0(48,17)+WPx*VS1(48,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))
VS0(71,18)=PAx*VS0(48,18)+WPx*VS1(48,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +HfxZpE*VS1(48,10)
VS0(71,19)=PAx*VS0(48,19)+WPx*VS1(48,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))
VS0(71,20)=PAx*VS0(48,20)+WPx*VS1(48,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(72,11)=PAx*VS0(49,11)+WPx*VS1(49,11)&
   +r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))&
   +3D0*HfxZpE*VS1(49,5)
VS0(72,12)=PAx*VS0(49,12)+WPx*VS1(49,12)&
   +r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(49,6)
VS0(72,13)=PAx*VS0(49,13)+WPx*VS1(49,13)&
   +r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +HfxZpE*VS1(49,7)
VS0(72,14)=PAx*VS0(49,14)+WPx*VS1(49,14)&
   +r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(72,15)=PAx*VS0(49,15)+WPx*VS1(49,15)&
   +r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(49,8)
VS0(72,16)=PAx*VS0(49,16)+WPx*VS1(49,16)&
   +r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(49,9)
VS0(72,17)=PAx*VS0(49,17)+WPx*VS1(49,17)&
   +r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))
VS0(72,18)=PAx*VS0(49,18)+WPx*VS1(49,18)&
   +r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +HfxZpE*VS1(49,10)
VS0(72,19)=PAx*VS0(49,19)+WPx*VS1(49,19)&
   +r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))
VS0(72,20)=PAx*VS0(49,20)+WPx*VS1(49,20)&
   +r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(73,11)=PAy*VS0(49,11)+WPy*VS1(49,11)+r1x2Z*VR1(49,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(73,12)=PAy*VS0(49,12)+WPy*VS1(49,12)+r1x2Z*VR1(49,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +HfxZpE*VS1(49,5)
VS0(73,13)=PAy*VS0(49,13)+WPy*VS1(49,13)+r1x2Z*VR1(49,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +2D0*HfxZpE*VS1(49,6)
VS0(73,14)=PAy*VS0(49,14)+WPy*VS1(49,14)+r1x2Z*VR1(49,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))&
   +3D0*HfxZpE*VS1(49,7)
VS0(73,15)=PAy*VS0(49,15)+WPy*VS1(49,15)+r1x2Z*VR1(49,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))
VS0(73,16)=PAy*VS0(49,16)+WPy*VS1(49,16)+r1x2Z*VR1(49,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(49,8)
VS0(73,17)=PAy*VS0(49,17)+WPy*VS1(49,17)+r1x2Z*VR1(49,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(49,9)
VS0(73,18)=PAy*VS0(49,18)+WPy*VS1(49,18)+r1x2Z*VR1(49,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))
VS0(73,19)=PAy*VS0(49,19)+WPy*VS1(49,19)+r1x2Z*VR1(49,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +HfxZpE*VS1(49,10)
VS0(73,20)=PAy*VS0(49,20)+WPy*VS1(49,20)+r1x2Z*VR1(49,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(74,11)=PAy*VS0(50,11)+WPy*VS1(50,11)+r1x2Z*VR1(50,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(74,12)=PAy*VS0(50,12)+WPy*VS1(50,12)+r1x2Z*VR1(50,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +HfxZpE*VS1(50,5)
VS0(74,13)=PAy*VS0(50,13)+WPy*VS1(50,13)+r1x2Z*VR1(50,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(50,6)
VS0(74,14)=PAy*VS0(50,14)+WPy*VS1(50,14)+r1x2Z*VR1(50,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))&
   +3D0*HfxZpE*VS1(50,7)
VS0(74,15)=PAy*VS0(50,15)+WPy*VS1(50,15)+r1x2Z*VR1(50,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))
VS0(74,16)=PAy*VS0(50,16)+WPy*VS1(50,16)+r1x2Z*VR1(50,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(50,8)
VS0(74,17)=PAy*VS0(50,17)+WPy*VS1(50,17)+r1x2Z*VR1(50,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(50,9)
VS0(74,18)=PAy*VS0(50,18)+WPy*VS1(50,18)+r1x2Z*VR1(50,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))
VS0(74,19)=PAy*VS0(50,19)+WPy*VS1(50,19)+r1x2Z*VR1(50,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +HfxZpE*VS1(50,10)
VS0(74,20)=PAy*VS0(50,20)+WPy*VS1(50,20)+r1x2Z*VR1(50,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(75,11)=PAx*VS0(51,11)+WPx*VS1(51,11)&
   +2D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))&
   +3D0*HfxZpE*VS1(51,5)
VS0(75,12)=PAx*VS0(51,12)+WPx*VS1(51,12)&
   +2D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))&
   +2D0*HfxZpE*VS1(51,6)
VS0(75,13)=PAx*VS0(51,13)+WPx*VS1(51,13)&
   +2D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))&
   +HfxZpE*VS1(51,7)
VS0(75,14)=PAx*VS0(51,14)+WPx*VS1(51,14)&
   +2D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(75,15)=PAx*VS0(51,15)+WPx*VS1(51,15)&
   +2D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +2D0*HfxZpE*VS1(51,8)
VS0(75,16)=PAx*VS0(51,16)+WPx*VS1(51,16)&
   +2D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(51,9)
VS0(75,17)=PAx*VS0(51,17)+WPx*VS1(51,17)&
   +2D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))
VS0(75,18)=PAx*VS0(51,18)+WPx*VS1(51,18)&
   +2D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +HfxZpE*VS1(51,10)
VS0(75,19)=PAx*VS0(51,19)+WPx*VS1(51,19)&
   +2D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))
VS0(75,20)=PAx*VS0(51,20)+WPx*VS1(51,20)&
   +2D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))
VS0(76,11)=PAz*VS0(48,11)+WPz*VS1(48,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(76,12)=PAz*VS0(48,12)+WPz*VS1(48,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))
VS0(76,13)=PAz*VS0(48,13)+WPz*VS1(48,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))
VS0(76,14)=PAz*VS0(48,14)+WPz*VS1(48,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(76,15)=PAz*VS0(48,15)+WPz*VS1(48,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +HfxZpE*VS1(48,5)
VS0(76,16)=PAz*VS0(48,16)+WPz*VS1(48,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(48,6)
VS0(76,17)=PAz*VS0(48,17)+WPz*VS1(48,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +HfxZpE*VS1(48,7)
VS0(76,18)=PAz*VS0(48,18)+WPz*VS1(48,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(48,8)
VS0(76,19)=PAz*VS0(48,19)+WPz*VS1(48,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(48,9)
VS0(76,20)=PAz*VS0(48,20)+WPz*VS1(48,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))&
   +3D0*HfxZpE*VS1(48,10)
VS0(77,11)=PAz*VS0(49,11)+WPz*VS1(49,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(77,12)=PAz*VS0(49,12)+WPz*VS1(49,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))
VS0(77,13)=PAz*VS0(49,13)+WPz*VS1(49,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))
VS0(77,14)=PAz*VS0(49,14)+WPz*VS1(49,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(77,15)=PAz*VS0(49,15)+WPz*VS1(49,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +HfxZpE*VS1(49,5)
VS0(77,16)=PAz*VS0(49,16)+WPz*VS1(49,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(49,6)
VS0(77,17)=PAz*VS0(49,17)+WPz*VS1(49,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +HfxZpE*VS1(49,7)
VS0(77,18)=PAz*VS0(49,18)+WPz*VS1(49,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(49,8)
VS0(77,19)=PAz*VS0(49,19)+WPz*VS1(49,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(49,9)
VS0(77,20)=PAz*VS0(49,20)+WPz*VS1(49,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))&
   +3D0*HfxZpE*VS1(49,10)
VS0(78,11)=PAy*VS0(53,11)+WPy*VS1(53,11)+r1x2Z*VR1(53,11)&
   +2D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(78,12)=PAy*VS0(53,12)+WPy*VS1(53,12)+r1x2Z*VR1(53,12)&
   +2D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))&
   +HfxZpE*VS1(53,5)
VS0(78,13)=PAy*VS0(53,13)+WPy*VS1(53,13)+r1x2Z*VR1(53,13)&
   +2D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))&
   +2D0*HfxZpE*VS1(53,6)
VS0(78,14)=PAy*VS0(53,14)+WPy*VS1(53,14)+r1x2Z*VR1(53,14)&
   +2D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))&
   +3D0*HfxZpE*VS1(53,7)
VS0(78,15)=PAy*VS0(53,15)+WPy*VS1(53,15)+r1x2Z*VR1(53,15)&
   +2D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))
VS0(78,16)=PAy*VS0(53,16)+WPy*VS1(53,16)+r1x2Z*VR1(53,16)&
   +2D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(53,8)
VS0(78,17)=PAy*VS0(53,17)+WPy*VS1(53,17)+r1x2Z*VR1(53,17)&
   +2D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +2D0*HfxZpE*VS1(53,9)
VS0(78,18)=PAy*VS0(53,18)+WPy*VS1(53,18)+r1x2Z*VR1(53,18)&
   +2D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))
VS0(78,19)=PAy*VS0(53,19)+WPy*VS1(53,19)+r1x2Z*VR1(53,19)&
   +2D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +HfxZpE*VS1(53,10)
VS0(78,20)=PAy*VS0(53,20)+WPy*VS1(53,20)+r1x2Z*VR1(53,20)&
   +2D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))
VS0(79,11)=PAz*VS0(51,11)+WPz*VS1(51,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))
VS0(79,12)=PAz*VS0(51,12)+WPz*VS1(51,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))
VS0(79,13)=PAz*VS0(51,13)+WPz*VS1(51,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))
VS0(79,14)=PAz*VS0(51,14)+WPz*VS1(51,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(79,15)=PAz*VS0(51,15)+WPz*VS1(51,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +HfxZpE*VS1(51,5)
VS0(79,16)=PAz*VS0(51,16)+WPz*VS1(51,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(51,6)
VS0(79,17)=PAz*VS0(51,17)+WPz*VS1(51,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))&
   +HfxZpE*VS1(51,7)
VS0(79,18)=PAz*VS0(51,18)+WPz*VS1(51,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(51,8)
VS0(79,19)=PAz*VS0(51,19)+WPz*VS1(51,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(51,9)
VS0(79,20)=PAz*VS0(51,20)+WPz*VS1(51,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))&
   +3D0*HfxZpE*VS1(51,10)
VS0(80,11)=PAz*VS0(52,11)+WPz*VS1(52,11)&
   +3D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(80,12)=PAz*VS0(52,12)+WPz*VS1(52,12)&
   +3D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))
VS0(80,13)=PAz*VS0(52,13)+WPz*VS1(52,13)&
   +3D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))
VS0(80,14)=PAz*VS0(52,14)+WPz*VS1(52,14)&
   +3D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(80,15)=PAz*VS0(52,15)+WPz*VS1(52,15)&
   +3D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +HfxZpE*VS1(52,5)
VS0(80,16)=PAz*VS0(52,16)+WPz*VS1(52,16)&
   +3D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(52,6)
VS0(80,17)=PAz*VS0(52,17)+WPz*VS1(52,17)&
   +3D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +HfxZpE*VS1(52,7)
VS0(80,18)=PAz*VS0(52,18)+WPz*VS1(52,18)&
   +3D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(52,8)
VS0(80,19)=PAz*VS0(52,19)+WPz*VS1(52,19)&
   +3D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(52,9)
VS0(80,20)=PAz*VS0(52,20)+WPz*VS1(52,20)&
   +3D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))&
   +3D0*HfxZpE*VS1(52,10)
VS0(81,11)=PAz*VS0(53,11)+WPz*VS1(53,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(81,12)=PAz*VS0(53,12)+WPz*VS1(53,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))
VS0(81,13)=PAz*VS0(53,13)+WPz*VS1(53,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))
VS0(81,14)=PAz*VS0(53,14)+WPz*VS1(53,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(81,15)=PAz*VS0(53,15)+WPz*VS1(53,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +HfxZpE*VS1(53,5)
VS0(81,16)=PAz*VS0(53,16)+WPz*VS1(53,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(53,6)
VS0(81,17)=PAz*VS0(53,17)+WPz*VS1(53,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +HfxZpE*VS1(53,7)
VS0(81,18)=PAz*VS0(53,18)+WPz*VS1(53,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(53,8)
VS0(81,19)=PAz*VS0(53,19)+WPz*VS1(53,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(53,9)
VS0(81,20)=PAz*VS0(53,20)+WPz*VS1(53,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))&
   +3D0*HfxZpE*VS1(53,10)
VS0(82,11)=PAz*VS0(54,11)+WPz*VS1(54,11)&
   +4D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))
VS0(82,12)=PAz*VS0(54,12)+WPz*VS1(54,12)&
   +4D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))
VS0(82,13)=PAz*VS0(54,13)+WPz*VS1(54,13)&
   +4D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))
VS0(82,14)=PAz*VS0(54,14)+WPz*VS1(54,14)&
   +4D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(82,15)=PAz*VS0(54,15)+WPz*VS1(54,15)&
   +4D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +HfxZpE*VS1(54,5)
VS0(82,16)=PAz*VS0(54,16)+WPz*VS1(54,16)&
   +4D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(54,6)
VS0(82,17)=PAz*VS0(54,17)+WPz*VS1(54,17)&
   +4D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))&
   +HfxZpE*VS1(54,7)
VS0(82,18)=PAz*VS0(54,18)+WPz*VS1(54,18)&
   +4D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +2D0*HfxZpE*VS1(54,8)
VS0(82,19)=PAz*VS0(54,19)+WPz*VS1(54,19)&
   +4D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))&
   +2D0*HfxZpE*VS1(54,9)
VS0(82,20)=PAz*VS0(54,20)+WPz*VS1(54,20)&
   +4D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(54,10)
VS0(83,11)=PAz*VS0(55,11)+WPz*VS1(55,11)&
   +4D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(83,12)=PAz*VS0(55,12)+WPz*VS1(55,12)&
   +4D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))
VS0(83,13)=PAz*VS0(55,13)+WPz*VS1(55,13)&
   +4D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))
VS0(83,14)=PAz*VS0(55,14)+WPz*VS1(55,14)&
   +4D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))
VS0(83,15)=PAz*VS0(55,15)+WPz*VS1(55,15)&
   +4D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))&
   +HfxZpE*VS1(55,5)
VS0(83,16)=PAz*VS0(55,16)+WPz*VS1(55,16)&
   +4D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(55,6)
VS0(83,17)=PAz*VS0(55,17)+WPz*VS1(55,17)&
   +4D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +HfxZpE*VS1(55,7)
VS0(83,18)=PAz*VS0(55,18)+WPz*VS1(55,18)&
   +4D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))&
   +2D0*HfxZpE*VS1(55,8)
VS0(83,19)=PAz*VS0(55,19)+WPz*VS1(55,19)&
   +4D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +2D0*HfxZpE*VS1(55,9)
VS0(83,20)=PAz*VS0(55,20)+WPz*VS1(55,20)&
   +4D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(55,10)
VS0(84,11)=PAz*VS0(56,11)+WPz*VS1(56,11)&
   +5D0*r1x2Z*(VS0(35,11)-ExZpE*VS1(35,11))
VS0(84,12)=PAz*VS0(56,12)+WPz*VS1(56,12)&
   +5D0*r1x2Z*(VS0(35,12)-ExZpE*VS1(35,12))
VS0(84,13)=PAz*VS0(56,13)+WPz*VS1(56,13)&
   +5D0*r1x2Z*(VS0(35,13)-ExZpE*VS1(35,13))
VS0(84,14)=PAz*VS0(56,14)+WPz*VS1(56,14)&
   +5D0*r1x2Z*(VS0(35,14)-ExZpE*VS1(35,14))
VS0(84,15)=PAz*VS0(56,15)+WPz*VS1(56,15)&
   +5D0*r1x2Z*(VS0(35,15)-ExZpE*VS1(35,15))&
   +HfxZpE*VS1(56,5)
VS0(84,16)=PAz*VS0(56,16)+WPz*VS1(56,16)&
   +5D0*r1x2Z*(VS0(35,16)-ExZpE*VS1(35,16))&
   +HfxZpE*VS1(56,6)
VS0(84,17)=PAz*VS0(56,17)+WPz*VS1(56,17)&
   +5D0*r1x2Z*(VS0(35,17)-ExZpE*VS1(35,17))&
   +HfxZpE*VS1(56,7)
VS0(84,18)=PAz*VS0(56,18)+WPz*VS1(56,18)&
   +5D0*r1x2Z*(VS0(35,18)-ExZpE*VS1(35,18))&
   +2D0*HfxZpE*VS1(56,8)
VS0(84,19)=PAz*VS0(56,19)+WPz*VS1(56,19)&
   +5D0*r1x2Z*(VS0(35,19)-ExZpE*VS1(35,19))&
   +2D0*HfxZpE*VS1(56,9)
VS0(84,20)=PAz*VS0(56,20)+WPz*VS1(56,20)&
   +5D0*r1x2Z*(VS0(35,20)-ExZpE*VS1(35,20))&
   +3D0*HfxZpE*VS1(56,10)
CASE(3)
VS0(57,11)=PAx*VS0(36,11)+WPx*VS1(36,11)&
   +5D0*r1x2Z*(VS0(21,11)-ExZpE*VS1(21,11))&
   +3D0*HfxZpE*VS1(36,5)
VS0(57,12)=PAx*VS0(36,12)+WPx*VS1(36,12)&
   +5D0*r1x2Z*(VS0(21,12)-ExZpE*VS1(21,12))&
   +2D0*HfxZpE*VS1(36,6)
VS0(57,13)=PAx*VS0(36,13)+WPx*VS1(36,13)&
   +5D0*r1x2Z*(VS0(21,13)-ExZpE*VS1(21,13))&
   +HfxZpE*VS1(36,7)
VS0(57,14)=PAx*VS0(36,14)+WPx*VS1(36,14)&
   +5D0*r1x2Z*(VS0(21,14)-ExZpE*VS1(21,14))
VS0(57,15)=PAx*VS0(36,15)+WPx*VS1(36,15)&
   +5D0*r1x2Z*(VS0(21,15)-ExZpE*VS1(21,15))&
   +2D0*HfxZpE*VS1(36,8)
VS0(57,16)=PAx*VS0(36,16)+WPx*VS1(36,16)&
   +5D0*r1x2Z*(VS0(21,16)-ExZpE*VS1(21,16))&
   +HfxZpE*VS1(36,9)
VS0(57,17)=PAx*VS0(36,17)+WPx*VS1(36,17)&
   +5D0*r1x2Z*(VS0(21,17)-ExZpE*VS1(21,17))
VS0(57,18)=PAx*VS0(36,18)+WPx*VS1(36,18)&
   +5D0*r1x2Z*(VS0(21,18)-ExZpE*VS1(21,18))&
   +HfxZpE*VS1(36,10)
VS0(57,19)=PAx*VS0(36,19)+WPx*VS1(36,19)&
   +5D0*r1x2Z*(VS0(21,19)-ExZpE*VS1(21,19))
VS0(57,20)=PAx*VS0(36,20)+WPx*VS1(36,20)&
   +5D0*r1x2Z*(VS0(21,20)-ExZpE*VS1(21,20))
VS0(58,11)=PAx*VS0(37,11)+WPx*VS1(37,11)&
   +4D0*r1x2Z*(VS0(22,11)-ExZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(37,5)
VS0(58,12)=PAx*VS0(37,12)+WPx*VS1(37,12)&
   +4D0*r1x2Z*(VS0(22,12)-ExZpE*VS1(22,12))&
   +2D0*HfxZpE*VS1(37,6)
VS0(58,13)=PAx*VS0(37,13)+WPx*VS1(37,13)&
   +4D0*r1x2Z*(VS0(22,13)-ExZpE*VS1(22,13))&
   +HfxZpE*VS1(37,7)
VS0(58,14)=PAx*VS0(37,14)+WPx*VS1(37,14)&
   +4D0*r1x2Z*(VS0(22,14)-ExZpE*VS1(22,14))
VS0(58,15)=PAx*VS0(37,15)+WPx*VS1(37,15)&
   +4D0*r1x2Z*(VS0(22,15)-ExZpE*VS1(22,15))&
   +2D0*HfxZpE*VS1(37,8)
VS0(58,16)=PAx*VS0(37,16)+WPx*VS1(37,16)&
   +4D0*r1x2Z*(VS0(22,16)-ExZpE*VS1(22,16))&
   +HfxZpE*VS1(37,9)
VS0(58,17)=PAx*VS0(37,17)+WPx*VS1(37,17)&
   +4D0*r1x2Z*(VS0(22,17)-ExZpE*VS1(22,17))
VS0(58,18)=PAx*VS0(37,18)+WPx*VS1(37,18)&
   +4D0*r1x2Z*(VS0(22,18)-ExZpE*VS1(22,18))&
   +HfxZpE*VS1(37,10)
VS0(58,19)=PAx*VS0(37,19)+WPx*VS1(37,19)&
   +4D0*r1x2Z*(VS0(22,19)-ExZpE*VS1(22,19))
VS0(58,20)=PAx*VS0(37,20)+WPx*VS1(37,20)&
   +4D0*r1x2Z*(VS0(22,20)-ExZpE*VS1(22,20))
VS0(59,11)=PAx*VS0(38,11)+WPx*VS1(38,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))&
   +3D0*HfxZpE*VS1(38,5)
VS0(59,12)=PAx*VS0(38,12)+WPx*VS1(38,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(38,6)
VS0(59,13)=PAx*VS0(38,13)+WPx*VS1(38,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +HfxZpE*VS1(38,7)
VS0(59,14)=PAx*VS0(38,14)+WPx*VS1(38,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))
VS0(59,15)=PAx*VS0(38,15)+WPx*VS1(38,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(38,8)
VS0(59,16)=PAx*VS0(38,16)+WPx*VS1(38,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(38,9)
VS0(59,17)=PAx*VS0(38,17)+WPx*VS1(38,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))
VS0(59,18)=PAx*VS0(38,18)+WPx*VS1(38,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))&
   +HfxZpE*VS1(38,10)
VS0(59,19)=PAx*VS0(38,19)+WPx*VS1(38,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))
VS0(59,20)=PAx*VS0(38,20)+WPx*VS1(38,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(60,11)=PAx*VS0(39,11)+WPx*VS1(39,11)&
   +2D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))&
   +3D0*HfxZpE*VS1(39,5)
VS0(60,12)=PAx*VS0(39,12)+WPx*VS1(39,12)&
   +2D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +2D0*HfxZpE*VS1(39,6)
VS0(60,13)=PAx*VS0(39,13)+WPx*VS1(39,13)&
   +2D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +HfxZpE*VS1(39,7)
VS0(60,14)=PAx*VS0(39,14)+WPx*VS1(39,14)&
   +2D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))
VS0(60,15)=PAx*VS0(39,15)+WPx*VS1(39,15)&
   +2D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))&
   +2D0*HfxZpE*VS1(39,8)
VS0(60,16)=PAx*VS0(39,16)+WPx*VS1(39,16)&
   +2D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(39,9)
VS0(60,17)=PAx*VS0(39,17)+WPx*VS1(39,17)&
   +2D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))
VS0(60,18)=PAx*VS0(39,18)+WPx*VS1(39,18)&
   +2D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))&
   +HfxZpE*VS1(39,10)
VS0(60,19)=PAx*VS0(39,19)+WPx*VS1(39,19)&
   +2D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))
VS0(60,20)=PAx*VS0(39,20)+WPx*VS1(39,20)&
   +2D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(61,11)=PAy*VS0(39,11)+WPy*VS1(39,11)&
   +3D0*r1x2Z*(VS0(23,11)-ExZpE*VS1(23,11))
VS0(61,12)=PAy*VS0(39,12)+WPy*VS1(39,12)&
   +3D0*r1x2Z*(VS0(23,12)-ExZpE*VS1(23,12))&
   +HfxZpE*VS1(39,5)
VS0(61,13)=PAy*VS0(39,13)+WPy*VS1(39,13)&
   +3D0*r1x2Z*(VS0(23,13)-ExZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(39,6)
VS0(61,14)=PAy*VS0(39,14)+WPy*VS1(39,14)&
   +3D0*r1x2Z*(VS0(23,14)-ExZpE*VS1(23,14))&
   +3D0*HfxZpE*VS1(39,7)
VS0(61,15)=PAy*VS0(39,15)+WPy*VS1(39,15)&
   +3D0*r1x2Z*(VS0(23,15)-ExZpE*VS1(23,15))
VS0(61,16)=PAy*VS0(39,16)+WPy*VS1(39,16)&
   +3D0*r1x2Z*(VS0(23,16)-ExZpE*VS1(23,16))&
   +HfxZpE*VS1(39,8)
VS0(61,17)=PAy*VS0(39,17)+WPy*VS1(39,17)&
   +3D0*r1x2Z*(VS0(23,17)-ExZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(39,9)
VS0(61,18)=PAy*VS0(39,18)+WPy*VS1(39,18)&
   +3D0*r1x2Z*(VS0(23,18)-ExZpE*VS1(23,18))
VS0(61,19)=PAy*VS0(39,19)+WPy*VS1(39,19)&
   +3D0*r1x2Z*(VS0(23,19)-ExZpE*VS1(23,19))&
   +HfxZpE*VS1(39,10)
VS0(61,20)=PAy*VS0(39,20)+WPy*VS1(39,20)&
   +3D0*r1x2Z*(VS0(23,20)-ExZpE*VS1(23,20))
VS0(62,11)=PAy*VS0(40,11)+WPy*VS1(40,11)&
   +4D0*r1x2Z*(VS0(24,11)-ExZpE*VS1(24,11))
VS0(62,12)=PAy*VS0(40,12)+WPy*VS1(40,12)&
   +4D0*r1x2Z*(VS0(24,12)-ExZpE*VS1(24,12))&
   +HfxZpE*VS1(40,5)
VS0(62,13)=PAy*VS0(40,13)+WPy*VS1(40,13)&
   +4D0*r1x2Z*(VS0(24,13)-ExZpE*VS1(24,13))&
   +2D0*HfxZpE*VS1(40,6)
VS0(62,14)=PAy*VS0(40,14)+WPy*VS1(40,14)&
   +4D0*r1x2Z*(VS0(24,14)-ExZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(40,7)
VS0(62,15)=PAy*VS0(40,15)+WPy*VS1(40,15)&
   +4D0*r1x2Z*(VS0(24,15)-ExZpE*VS1(24,15))
VS0(62,16)=PAy*VS0(40,16)+WPy*VS1(40,16)&
   +4D0*r1x2Z*(VS0(24,16)-ExZpE*VS1(24,16))&
   +HfxZpE*VS1(40,8)
VS0(62,17)=PAy*VS0(40,17)+WPy*VS1(40,17)&
   +4D0*r1x2Z*(VS0(24,17)-ExZpE*VS1(24,17))&
   +2D0*HfxZpE*VS1(40,9)
VS0(62,18)=PAy*VS0(40,18)+WPy*VS1(40,18)&
   +4D0*r1x2Z*(VS0(24,18)-ExZpE*VS1(24,18))
VS0(62,19)=PAy*VS0(40,19)+WPy*VS1(40,19)&
   +4D0*r1x2Z*(VS0(24,19)-ExZpE*VS1(24,19))&
   +HfxZpE*VS1(40,10)
VS0(62,20)=PAy*VS0(40,20)+WPy*VS1(40,20)&
   +4D0*r1x2Z*(VS0(24,20)-ExZpE*VS1(24,20))
VS0(63,11)=PAy*VS0(41,11)+WPy*VS1(41,11)&
   +5D0*r1x2Z*(VS0(25,11)-ExZpE*VS1(25,11))
VS0(63,12)=PAy*VS0(41,12)+WPy*VS1(41,12)&
   +5D0*r1x2Z*(VS0(25,12)-ExZpE*VS1(25,12))&
   +HfxZpE*VS1(41,5)
VS0(63,13)=PAy*VS0(41,13)+WPy*VS1(41,13)&
   +5D0*r1x2Z*(VS0(25,13)-ExZpE*VS1(25,13))&
   +2D0*HfxZpE*VS1(41,6)
VS0(63,14)=PAy*VS0(41,14)+WPy*VS1(41,14)&
   +5D0*r1x2Z*(VS0(25,14)-ExZpE*VS1(25,14))&
   +3D0*HfxZpE*VS1(41,7)
VS0(63,15)=PAy*VS0(41,15)+WPy*VS1(41,15)&
   +5D0*r1x2Z*(VS0(25,15)-ExZpE*VS1(25,15))
VS0(63,16)=PAy*VS0(41,16)+WPy*VS1(41,16)&
   +5D0*r1x2Z*(VS0(25,16)-ExZpE*VS1(25,16))&
   +HfxZpE*VS1(41,8)
VS0(63,17)=PAy*VS0(41,17)+WPy*VS1(41,17)&
   +5D0*r1x2Z*(VS0(25,17)-ExZpE*VS1(25,17))&
   +2D0*HfxZpE*VS1(41,9)
VS0(63,18)=PAy*VS0(41,18)+WPy*VS1(41,18)&
   +5D0*r1x2Z*(VS0(25,18)-ExZpE*VS1(25,18))
VS0(63,19)=PAy*VS0(41,19)+WPy*VS1(41,19)&
   +5D0*r1x2Z*(VS0(25,19)-ExZpE*VS1(25,19))&
   +HfxZpE*VS1(41,10)
VS0(63,20)=PAy*VS0(41,20)+WPy*VS1(41,20)&
   +5D0*r1x2Z*(VS0(25,20)-ExZpE*VS1(25,20))
VS0(64,11)=PAx*VS0(42,11)+WPx*VS1(42,11)&
   +4D0*r1x2Z*(VS0(26,11)-ExZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(42,5)
VS0(64,12)=PAx*VS0(42,12)+WPx*VS1(42,12)&
   +4D0*r1x2Z*(VS0(26,12)-ExZpE*VS1(26,12))&
   +2D0*HfxZpE*VS1(42,6)
VS0(64,13)=PAx*VS0(42,13)+WPx*VS1(42,13)&
   +4D0*r1x2Z*(VS0(26,13)-ExZpE*VS1(26,13))&
   +HfxZpE*VS1(42,7)
VS0(64,14)=PAx*VS0(42,14)+WPx*VS1(42,14)&
   +4D0*r1x2Z*(VS0(26,14)-ExZpE*VS1(26,14))
VS0(64,15)=PAx*VS0(42,15)+WPx*VS1(42,15)&
   +4D0*r1x2Z*(VS0(26,15)-ExZpE*VS1(26,15))&
   +2D0*HfxZpE*VS1(42,8)
VS0(64,16)=PAx*VS0(42,16)+WPx*VS1(42,16)&
   +4D0*r1x2Z*(VS0(26,16)-ExZpE*VS1(26,16))&
   +HfxZpE*VS1(42,9)
VS0(64,17)=PAx*VS0(42,17)+WPx*VS1(42,17)&
   +4D0*r1x2Z*(VS0(26,17)-ExZpE*VS1(26,17))
VS0(64,18)=PAx*VS0(42,18)+WPx*VS1(42,18)&
   +4D0*r1x2Z*(VS0(26,18)-ExZpE*VS1(26,18))&
   +HfxZpE*VS1(42,10)
VS0(64,19)=PAx*VS0(42,19)+WPx*VS1(42,19)&
   +4D0*r1x2Z*(VS0(26,19)-ExZpE*VS1(26,19))
VS0(64,20)=PAx*VS0(42,20)+WPx*VS1(42,20)&
   +4D0*r1x2Z*(VS0(26,20)-ExZpE*VS1(26,20))
VS0(65,11)=PAx*VS0(43,11)+WPx*VS1(43,11)&
   +3D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))&
   +3D0*HfxZpE*VS1(43,5)
VS0(65,12)=PAx*VS0(43,12)+WPx*VS1(43,12)&
   +3D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(43,6)
VS0(65,13)=PAx*VS0(43,13)+WPx*VS1(43,13)&
   +3D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +HfxZpE*VS1(43,7)
VS0(65,14)=PAx*VS0(43,14)+WPx*VS1(43,14)&
   +3D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(65,15)=PAx*VS0(43,15)+WPx*VS1(43,15)&
   +3D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(43,8)
VS0(65,16)=PAx*VS0(43,16)+WPx*VS1(43,16)&
   +3D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(43,9)
VS0(65,17)=PAx*VS0(43,17)+WPx*VS1(43,17)&
   +3D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))
VS0(65,18)=PAx*VS0(43,18)+WPx*VS1(43,18)&
   +3D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +HfxZpE*VS1(43,10)
VS0(65,19)=PAx*VS0(43,19)+WPx*VS1(43,19)&
   +3D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))
VS0(65,20)=PAx*VS0(43,20)+WPx*VS1(43,20)&
   +3D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(66,11)=PAx*VS0(44,11)+WPx*VS1(44,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))&
   +3D0*HfxZpE*VS1(44,5)
VS0(66,12)=PAx*VS0(44,12)+WPx*VS1(44,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(44,6)
VS0(66,13)=PAx*VS0(44,13)+WPx*VS1(44,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +HfxZpE*VS1(44,7)
VS0(66,14)=PAx*VS0(44,14)+WPx*VS1(44,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(66,15)=PAx*VS0(44,15)+WPx*VS1(44,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +2D0*HfxZpE*VS1(44,8)
VS0(66,16)=PAx*VS0(44,16)+WPx*VS1(44,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(44,9)
VS0(66,17)=PAx*VS0(44,17)+WPx*VS1(44,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))
VS0(66,18)=PAx*VS0(44,18)+WPx*VS1(44,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +HfxZpE*VS1(44,10)
VS0(66,19)=PAx*VS0(44,19)+WPx*VS1(44,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))
VS0(66,20)=PAx*VS0(44,20)+WPx*VS1(44,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(67,11)=PAy*VS0(44,11)+WPy*VS1(44,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(67,12)=PAy*VS0(44,12)+WPy*VS1(44,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))&
   +HfxZpE*VS1(44,5)
VS0(67,13)=PAy*VS0(44,13)+WPy*VS1(44,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(44,6)
VS0(67,14)=PAy*VS0(44,14)+WPy*VS1(44,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))&
   +3D0*HfxZpE*VS1(44,7)
VS0(67,15)=PAy*VS0(44,15)+WPy*VS1(44,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))
VS0(67,16)=PAy*VS0(44,16)+WPy*VS1(44,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(44,8)
VS0(67,17)=PAy*VS0(44,17)+WPy*VS1(44,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(44,9)
VS0(67,18)=PAy*VS0(44,18)+WPy*VS1(44,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))
VS0(67,19)=PAy*VS0(44,19)+WPy*VS1(44,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +HfxZpE*VS1(44,10)
VS0(67,20)=PAy*VS0(44,20)+WPy*VS1(44,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))
VS0(68,11)=PAy*VS0(45,11)+WPy*VS1(45,11)&
   +3D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(68,12)=PAy*VS0(45,12)+WPy*VS1(45,12)&
   +3D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))&
   +HfxZpE*VS1(45,5)
VS0(68,13)=PAy*VS0(45,13)+WPy*VS1(45,13)&
   +3D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(45,6)
VS0(68,14)=PAy*VS0(45,14)+WPy*VS1(45,14)&
   +3D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))&
   +3D0*HfxZpE*VS1(45,7)
VS0(68,15)=PAy*VS0(45,15)+WPy*VS1(45,15)&
   +3D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))
VS0(68,16)=PAy*VS0(45,16)+WPy*VS1(45,16)&
   +3D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(45,8)
VS0(68,17)=PAy*VS0(45,17)+WPy*VS1(45,17)&
   +3D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(45,9)
VS0(68,18)=PAy*VS0(45,18)+WPy*VS1(45,18)&
   +3D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))
VS0(68,19)=PAy*VS0(45,19)+WPy*VS1(45,19)&
   +3D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +HfxZpE*VS1(45,10)
VS0(68,20)=PAy*VS0(45,20)+WPy*VS1(45,20)&
   +3D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))
VS0(69,11)=PAy*VS0(46,11)+WPy*VS1(46,11)&
   +4D0*r1x2Z*(VS0(29,11)-ExZpE*VS1(29,11))
VS0(69,12)=PAy*VS0(46,12)+WPy*VS1(46,12)&
   +4D0*r1x2Z*(VS0(29,12)-ExZpE*VS1(29,12))&
   +HfxZpE*VS1(46,5)
VS0(69,13)=PAy*VS0(46,13)+WPy*VS1(46,13)&
   +4D0*r1x2Z*(VS0(29,13)-ExZpE*VS1(29,13))&
   +2D0*HfxZpE*VS1(46,6)
VS0(69,14)=PAy*VS0(46,14)+WPy*VS1(46,14)&
   +4D0*r1x2Z*(VS0(29,14)-ExZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(46,7)
VS0(69,15)=PAy*VS0(46,15)+WPy*VS1(46,15)&
   +4D0*r1x2Z*(VS0(29,15)-ExZpE*VS1(29,15))
VS0(69,16)=PAy*VS0(46,16)+WPy*VS1(46,16)&
   +4D0*r1x2Z*(VS0(29,16)-ExZpE*VS1(29,16))&
   +HfxZpE*VS1(46,8)
VS0(69,17)=PAy*VS0(46,17)+WPy*VS1(46,17)&
   +4D0*r1x2Z*(VS0(29,17)-ExZpE*VS1(29,17))&
   +2D0*HfxZpE*VS1(46,9)
VS0(69,18)=PAy*VS0(46,18)+WPy*VS1(46,18)&
   +4D0*r1x2Z*(VS0(29,18)-ExZpE*VS1(29,18))
VS0(69,19)=PAy*VS0(46,19)+WPy*VS1(46,19)&
   +4D0*r1x2Z*(VS0(29,19)-ExZpE*VS1(29,19))&
   +HfxZpE*VS1(46,10)
VS0(69,20)=PAy*VS0(46,20)+WPy*VS1(46,20)&
   +4D0*r1x2Z*(VS0(29,20)-ExZpE*VS1(29,20))
VS0(70,11)=PAx*VS0(47,11)+WPx*VS1(47,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))&
   +3D0*HfxZpE*VS1(47,5)
VS0(70,12)=PAx*VS0(47,12)+WPx*VS1(47,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(47,6)
VS0(70,13)=PAx*VS0(47,13)+WPx*VS1(47,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))&
   +HfxZpE*VS1(47,7)
VS0(70,14)=PAx*VS0(47,14)+WPx*VS1(47,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(70,15)=PAx*VS0(47,15)+WPx*VS1(47,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(47,8)
VS0(70,16)=PAx*VS0(47,16)+WPx*VS1(47,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(47,9)
VS0(70,17)=PAx*VS0(47,17)+WPx*VS1(47,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))
VS0(70,18)=PAx*VS0(47,18)+WPx*VS1(47,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +HfxZpE*VS1(47,10)
VS0(70,19)=PAx*VS0(47,19)+WPx*VS1(47,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))
VS0(70,20)=PAx*VS0(47,20)+WPx*VS1(47,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))
VS0(71,11)=PAx*VS0(48,11)+WPx*VS1(48,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))&
   +3D0*HfxZpE*VS1(48,5)
VS0(71,12)=PAx*VS0(48,12)+WPx*VS1(48,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +2D0*HfxZpE*VS1(48,6)
VS0(71,13)=PAx*VS0(48,13)+WPx*VS1(48,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +HfxZpE*VS1(48,7)
VS0(71,14)=PAx*VS0(48,14)+WPx*VS1(48,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(71,15)=PAx*VS0(48,15)+WPx*VS1(48,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(48,8)
VS0(71,16)=PAx*VS0(48,16)+WPx*VS1(48,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(48,9)
VS0(71,17)=PAx*VS0(48,17)+WPx*VS1(48,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))
VS0(71,18)=PAx*VS0(48,18)+WPx*VS1(48,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +HfxZpE*VS1(48,10)
VS0(71,19)=PAx*VS0(48,19)+WPx*VS1(48,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))
VS0(71,20)=PAx*VS0(48,20)+WPx*VS1(48,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(72,11)=PAx*VS0(49,11)+WPx*VS1(49,11)&
   +r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))&
   +3D0*HfxZpE*VS1(49,5)
VS0(72,12)=PAx*VS0(49,12)+WPx*VS1(49,12)&
   +r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(49,6)
VS0(72,13)=PAx*VS0(49,13)+WPx*VS1(49,13)&
   +r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +HfxZpE*VS1(49,7)
VS0(72,14)=PAx*VS0(49,14)+WPx*VS1(49,14)&
   +r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(72,15)=PAx*VS0(49,15)+WPx*VS1(49,15)&
   +r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(49,8)
VS0(72,16)=PAx*VS0(49,16)+WPx*VS1(49,16)&
   +r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(49,9)
VS0(72,17)=PAx*VS0(49,17)+WPx*VS1(49,17)&
   +r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))
VS0(72,18)=PAx*VS0(49,18)+WPx*VS1(49,18)&
   +r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +HfxZpE*VS1(49,10)
VS0(72,19)=PAx*VS0(49,19)+WPx*VS1(49,19)&
   +r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))
VS0(72,20)=PAx*VS0(49,20)+WPx*VS1(49,20)&
   +r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(73,11)=PAy*VS0(49,11)+WPy*VS1(49,11)&
   +2D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(73,12)=PAy*VS0(49,12)+WPy*VS1(49,12)&
   +2D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))&
   +HfxZpE*VS1(49,5)
VS0(73,13)=PAy*VS0(49,13)+WPy*VS1(49,13)&
   +2D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))&
   +2D0*HfxZpE*VS1(49,6)
VS0(73,14)=PAy*VS0(49,14)+WPy*VS1(49,14)&
   +2D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))&
   +3D0*HfxZpE*VS1(49,7)
VS0(73,15)=PAy*VS0(49,15)+WPy*VS1(49,15)&
   +2D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))
VS0(73,16)=PAy*VS0(49,16)+WPy*VS1(49,16)&
   +2D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(49,8)
VS0(73,17)=PAy*VS0(49,17)+WPy*VS1(49,17)&
   +2D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(49,9)
VS0(73,18)=PAy*VS0(49,18)+WPy*VS1(49,18)&
   +2D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))
VS0(73,19)=PAy*VS0(49,19)+WPy*VS1(49,19)&
   +2D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +HfxZpE*VS1(49,10)
VS0(73,20)=PAy*VS0(49,20)+WPy*VS1(49,20)&
   +2D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))
VS0(74,11)=PAy*VS0(50,11)+WPy*VS1(50,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(74,12)=PAy*VS0(50,12)+WPy*VS1(50,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))&
   +HfxZpE*VS1(50,5)
VS0(74,13)=PAy*VS0(50,13)+WPy*VS1(50,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(50,6)
VS0(74,14)=PAy*VS0(50,14)+WPy*VS1(50,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))&
   +3D0*HfxZpE*VS1(50,7)
VS0(74,15)=PAy*VS0(50,15)+WPy*VS1(50,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))
VS0(74,16)=PAy*VS0(50,16)+WPy*VS1(50,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(50,8)
VS0(74,17)=PAy*VS0(50,17)+WPy*VS1(50,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(50,9)
VS0(74,18)=PAy*VS0(50,18)+WPy*VS1(50,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))
VS0(74,19)=PAy*VS0(50,19)+WPy*VS1(50,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +HfxZpE*VS1(50,10)
VS0(74,20)=PAy*VS0(50,20)+WPy*VS1(50,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))
VS0(75,11)=PAx*VS0(51,11)+WPx*VS1(51,11)&
   +2D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))&
   +3D0*HfxZpE*VS1(51,5)
VS0(75,12)=PAx*VS0(51,12)+WPx*VS1(51,12)&
   +2D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))&
   +2D0*HfxZpE*VS1(51,6)
VS0(75,13)=PAx*VS0(51,13)+WPx*VS1(51,13)&
   +2D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))&
   +HfxZpE*VS1(51,7)
VS0(75,14)=PAx*VS0(51,14)+WPx*VS1(51,14)&
   +2D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(75,15)=PAx*VS0(51,15)+WPx*VS1(51,15)&
   +2D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +2D0*HfxZpE*VS1(51,8)
VS0(75,16)=PAx*VS0(51,16)+WPx*VS1(51,16)&
   +2D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(51,9)
VS0(75,17)=PAx*VS0(51,17)+WPx*VS1(51,17)&
   +2D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))
VS0(75,18)=PAx*VS0(51,18)+WPx*VS1(51,18)&
   +2D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +HfxZpE*VS1(51,10)
VS0(75,19)=PAx*VS0(51,19)+WPx*VS1(51,19)&
   +2D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))
VS0(75,20)=PAx*VS0(51,20)+WPx*VS1(51,20)&
   +2D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))
VS0(76,11)=PAz*VS0(48,11)+WPz*VS1(48,11)+r1x2Z*VR1(48,11)&
   +2D0*r1x2Z*(VS0(27,11)-ExZpE*VS1(27,11))
VS0(76,12)=PAz*VS0(48,12)+WPz*VS1(48,12)+r1x2Z*VR1(48,12)&
   +2D0*r1x2Z*(VS0(27,12)-ExZpE*VS1(27,12))
VS0(76,13)=PAz*VS0(48,13)+WPz*VS1(48,13)+r1x2Z*VR1(48,13)&
   +2D0*r1x2Z*(VS0(27,13)-ExZpE*VS1(27,13))
VS0(76,14)=PAz*VS0(48,14)+WPz*VS1(48,14)+r1x2Z*VR1(48,14)&
   +2D0*r1x2Z*(VS0(27,14)-ExZpE*VS1(27,14))
VS0(76,15)=PAz*VS0(48,15)+WPz*VS1(48,15)+r1x2Z*VR1(48,15)&
   +2D0*r1x2Z*(VS0(27,15)-ExZpE*VS1(27,15))&
   +HfxZpE*VS1(48,5)
VS0(76,16)=PAz*VS0(48,16)+WPz*VS1(48,16)+r1x2Z*VR1(48,16)&
   +2D0*r1x2Z*(VS0(27,16)-ExZpE*VS1(27,16))&
   +HfxZpE*VS1(48,6)
VS0(76,17)=PAz*VS0(48,17)+WPz*VS1(48,17)+r1x2Z*VR1(48,17)&
   +2D0*r1x2Z*(VS0(27,17)-ExZpE*VS1(27,17))&
   +HfxZpE*VS1(48,7)
VS0(76,18)=PAz*VS0(48,18)+WPz*VS1(48,18)+r1x2Z*VR1(48,18)&
   +2D0*r1x2Z*(VS0(27,18)-ExZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(48,8)
VS0(76,19)=PAz*VS0(48,19)+WPz*VS1(48,19)+r1x2Z*VR1(48,19)&
   +2D0*r1x2Z*(VS0(27,19)-ExZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(48,9)
VS0(76,20)=PAz*VS0(48,20)+WPz*VS1(48,20)+r1x2Z*VR1(48,20)&
   +2D0*r1x2Z*(VS0(27,20)-ExZpE*VS1(27,20))&
   +3D0*HfxZpE*VS1(48,10)
VS0(77,11)=PAz*VS0(49,11)+WPz*VS1(49,11)+r1x2Z*VR1(49,11)&
   +2D0*r1x2Z*(VS0(28,11)-ExZpE*VS1(28,11))
VS0(77,12)=PAz*VS0(49,12)+WPz*VS1(49,12)+r1x2Z*VR1(49,12)&
   +2D0*r1x2Z*(VS0(28,12)-ExZpE*VS1(28,12))
VS0(77,13)=PAz*VS0(49,13)+WPz*VS1(49,13)+r1x2Z*VR1(49,13)&
   +2D0*r1x2Z*(VS0(28,13)-ExZpE*VS1(28,13))
VS0(77,14)=PAz*VS0(49,14)+WPz*VS1(49,14)+r1x2Z*VR1(49,14)&
   +2D0*r1x2Z*(VS0(28,14)-ExZpE*VS1(28,14))
VS0(77,15)=PAz*VS0(49,15)+WPz*VS1(49,15)+r1x2Z*VR1(49,15)&
   +2D0*r1x2Z*(VS0(28,15)-ExZpE*VS1(28,15))&
   +HfxZpE*VS1(49,5)
VS0(77,16)=PAz*VS0(49,16)+WPz*VS1(49,16)+r1x2Z*VR1(49,16)&
   +2D0*r1x2Z*(VS0(28,16)-ExZpE*VS1(28,16))&
   +HfxZpE*VS1(49,6)
VS0(77,17)=PAz*VS0(49,17)+WPz*VS1(49,17)+r1x2Z*VR1(49,17)&
   +2D0*r1x2Z*(VS0(28,17)-ExZpE*VS1(28,17))&
   +HfxZpE*VS1(49,7)
VS0(77,18)=PAz*VS0(49,18)+WPz*VS1(49,18)+r1x2Z*VR1(49,18)&
   +2D0*r1x2Z*(VS0(28,18)-ExZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(49,8)
VS0(77,19)=PAz*VS0(49,19)+WPz*VS1(49,19)+r1x2Z*VR1(49,19)&
   +2D0*r1x2Z*(VS0(28,19)-ExZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(49,9)
VS0(77,20)=PAz*VS0(49,20)+WPz*VS1(49,20)+r1x2Z*VR1(49,20)&
   +2D0*r1x2Z*(VS0(28,20)-ExZpE*VS1(28,20))&
   +3D0*HfxZpE*VS1(49,10)
VS0(78,11)=PAy*VS0(53,11)+WPy*VS1(53,11)&
   +2D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(78,12)=PAy*VS0(53,12)+WPy*VS1(53,12)&
   +2D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))&
   +HfxZpE*VS1(53,5)
VS0(78,13)=PAy*VS0(53,13)+WPy*VS1(53,13)&
   +2D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))&
   +2D0*HfxZpE*VS1(53,6)
VS0(78,14)=PAy*VS0(53,14)+WPy*VS1(53,14)&
   +2D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))&
   +3D0*HfxZpE*VS1(53,7)
VS0(78,15)=PAy*VS0(53,15)+WPy*VS1(53,15)&
   +2D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))
VS0(78,16)=PAy*VS0(53,16)+WPy*VS1(53,16)&
   +2D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(53,8)
VS0(78,17)=PAy*VS0(53,17)+WPy*VS1(53,17)&
   +2D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +2D0*HfxZpE*VS1(53,9)
VS0(78,18)=PAy*VS0(53,18)+WPy*VS1(53,18)&
   +2D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))
VS0(78,19)=PAy*VS0(53,19)+WPy*VS1(53,19)&
   +2D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +HfxZpE*VS1(53,10)
VS0(78,20)=PAy*VS0(53,20)+WPy*VS1(53,20)&
   +2D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))
VS0(79,11)=PAz*VS0(51,11)+WPz*VS1(51,11)+r1x2Z*VR1(51,11)&
   +3D0*r1x2Z*(VS0(30,11)-ExZpE*VS1(30,11))
VS0(79,12)=PAz*VS0(51,12)+WPz*VS1(51,12)+r1x2Z*VR1(51,12)&
   +3D0*r1x2Z*(VS0(30,12)-ExZpE*VS1(30,12))
VS0(79,13)=PAz*VS0(51,13)+WPz*VS1(51,13)+r1x2Z*VR1(51,13)&
   +3D0*r1x2Z*(VS0(30,13)-ExZpE*VS1(30,13))
VS0(79,14)=PAz*VS0(51,14)+WPz*VS1(51,14)+r1x2Z*VR1(51,14)&
   +3D0*r1x2Z*(VS0(30,14)-ExZpE*VS1(30,14))
VS0(79,15)=PAz*VS0(51,15)+WPz*VS1(51,15)+r1x2Z*VR1(51,15)&
   +3D0*r1x2Z*(VS0(30,15)-ExZpE*VS1(30,15))&
   +HfxZpE*VS1(51,5)
VS0(79,16)=PAz*VS0(51,16)+WPz*VS1(51,16)+r1x2Z*VR1(51,16)&
   +3D0*r1x2Z*(VS0(30,16)-ExZpE*VS1(30,16))&
   +HfxZpE*VS1(51,6)
VS0(79,17)=PAz*VS0(51,17)+WPz*VS1(51,17)+r1x2Z*VR1(51,17)&
   +3D0*r1x2Z*(VS0(30,17)-ExZpE*VS1(30,17))&
   +HfxZpE*VS1(51,7)
VS0(79,18)=PAz*VS0(51,18)+WPz*VS1(51,18)+r1x2Z*VR1(51,18)&
   +3D0*r1x2Z*(VS0(30,18)-ExZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(51,8)
VS0(79,19)=PAz*VS0(51,19)+WPz*VS1(51,19)+r1x2Z*VR1(51,19)&
   +3D0*r1x2Z*(VS0(30,19)-ExZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(51,9)
VS0(79,20)=PAz*VS0(51,20)+WPz*VS1(51,20)+r1x2Z*VR1(51,20)&
   +3D0*r1x2Z*(VS0(30,20)-ExZpE*VS1(30,20))&
   +3D0*HfxZpE*VS1(51,10)
VS0(80,11)=PAz*VS0(52,11)+WPz*VS1(52,11)+r1x2Z*VR1(52,11)&
   +3D0*r1x2Z*(VS0(31,11)-ExZpE*VS1(31,11))
VS0(80,12)=PAz*VS0(52,12)+WPz*VS1(52,12)+r1x2Z*VR1(52,12)&
   +3D0*r1x2Z*(VS0(31,12)-ExZpE*VS1(31,12))
VS0(80,13)=PAz*VS0(52,13)+WPz*VS1(52,13)+r1x2Z*VR1(52,13)&
   +3D0*r1x2Z*(VS0(31,13)-ExZpE*VS1(31,13))
VS0(80,14)=PAz*VS0(52,14)+WPz*VS1(52,14)+r1x2Z*VR1(52,14)&
   +3D0*r1x2Z*(VS0(31,14)-ExZpE*VS1(31,14))
VS0(80,15)=PAz*VS0(52,15)+WPz*VS1(52,15)+r1x2Z*VR1(52,15)&
   +3D0*r1x2Z*(VS0(31,15)-ExZpE*VS1(31,15))&
   +HfxZpE*VS1(52,5)
VS0(80,16)=PAz*VS0(52,16)+WPz*VS1(52,16)+r1x2Z*VR1(52,16)&
   +3D0*r1x2Z*(VS0(31,16)-ExZpE*VS1(31,16))&
   +HfxZpE*VS1(52,6)
VS0(80,17)=PAz*VS0(52,17)+WPz*VS1(52,17)+r1x2Z*VR1(52,17)&
   +3D0*r1x2Z*(VS0(31,17)-ExZpE*VS1(31,17))&
   +HfxZpE*VS1(52,7)
VS0(80,18)=PAz*VS0(52,18)+WPz*VS1(52,18)+r1x2Z*VR1(52,18)&
   +3D0*r1x2Z*(VS0(31,18)-ExZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(52,8)
VS0(80,19)=PAz*VS0(52,19)+WPz*VS1(52,19)+r1x2Z*VR1(52,19)&
   +3D0*r1x2Z*(VS0(31,19)-ExZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(52,9)
VS0(80,20)=PAz*VS0(52,20)+WPz*VS1(52,20)+r1x2Z*VR1(52,20)&
   +3D0*r1x2Z*(VS0(31,20)-ExZpE*VS1(31,20))&
   +3D0*HfxZpE*VS1(52,10)
VS0(81,11)=PAz*VS0(53,11)+WPz*VS1(53,11)+r1x2Z*VR1(53,11)&
   +3D0*r1x2Z*(VS0(32,11)-ExZpE*VS1(32,11))
VS0(81,12)=PAz*VS0(53,12)+WPz*VS1(53,12)+r1x2Z*VR1(53,12)&
   +3D0*r1x2Z*(VS0(32,12)-ExZpE*VS1(32,12))
VS0(81,13)=PAz*VS0(53,13)+WPz*VS1(53,13)+r1x2Z*VR1(53,13)&
   +3D0*r1x2Z*(VS0(32,13)-ExZpE*VS1(32,13))
VS0(81,14)=PAz*VS0(53,14)+WPz*VS1(53,14)+r1x2Z*VR1(53,14)&
   +3D0*r1x2Z*(VS0(32,14)-ExZpE*VS1(32,14))
VS0(81,15)=PAz*VS0(53,15)+WPz*VS1(53,15)+r1x2Z*VR1(53,15)&
   +3D0*r1x2Z*(VS0(32,15)-ExZpE*VS1(32,15))&
   +HfxZpE*VS1(53,5)
VS0(81,16)=PAz*VS0(53,16)+WPz*VS1(53,16)+r1x2Z*VR1(53,16)&
   +3D0*r1x2Z*(VS0(32,16)-ExZpE*VS1(32,16))&
   +HfxZpE*VS1(53,6)
VS0(81,17)=PAz*VS0(53,17)+WPz*VS1(53,17)+r1x2Z*VR1(53,17)&
   +3D0*r1x2Z*(VS0(32,17)-ExZpE*VS1(32,17))&
   +HfxZpE*VS1(53,7)
VS0(81,18)=PAz*VS0(53,18)+WPz*VS1(53,18)+r1x2Z*VR1(53,18)&
   +3D0*r1x2Z*(VS0(32,18)-ExZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(53,8)
VS0(81,19)=PAz*VS0(53,19)+WPz*VS1(53,19)+r1x2Z*VR1(53,19)&
   +3D0*r1x2Z*(VS0(32,19)-ExZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(53,9)
VS0(81,20)=PAz*VS0(53,20)+WPz*VS1(53,20)+r1x2Z*VR1(53,20)&
   +3D0*r1x2Z*(VS0(32,20)-ExZpE*VS1(32,20))&
   +3D0*HfxZpE*VS1(53,10)
VS0(82,11)=PAz*VS0(54,11)+WPz*VS1(54,11)+r1x2Z*VR1(54,11)&
   +4D0*r1x2Z*(VS0(33,11)-ExZpE*VS1(33,11))
VS0(82,12)=PAz*VS0(54,12)+WPz*VS1(54,12)+r1x2Z*VR1(54,12)&
   +4D0*r1x2Z*(VS0(33,12)-ExZpE*VS1(33,12))
VS0(82,13)=PAz*VS0(54,13)+WPz*VS1(54,13)+r1x2Z*VR1(54,13)&
   +4D0*r1x2Z*(VS0(33,13)-ExZpE*VS1(33,13))
VS0(82,14)=PAz*VS0(54,14)+WPz*VS1(54,14)+r1x2Z*VR1(54,14)&
   +4D0*r1x2Z*(VS0(33,14)-ExZpE*VS1(33,14))
VS0(82,15)=PAz*VS0(54,15)+WPz*VS1(54,15)+r1x2Z*VR1(54,15)&
   +4D0*r1x2Z*(VS0(33,15)-ExZpE*VS1(33,15))&
   +HfxZpE*VS1(54,5)
VS0(82,16)=PAz*VS0(54,16)+WPz*VS1(54,16)+r1x2Z*VR1(54,16)&
   +4D0*r1x2Z*(VS0(33,16)-ExZpE*VS1(33,16))&
   +HfxZpE*VS1(54,6)
VS0(82,17)=PAz*VS0(54,17)+WPz*VS1(54,17)+r1x2Z*VR1(54,17)&
   +4D0*r1x2Z*(VS0(33,17)-ExZpE*VS1(33,17))&
   +HfxZpE*VS1(54,7)
VS0(82,18)=PAz*VS0(54,18)+WPz*VS1(54,18)+r1x2Z*VR1(54,18)&
   +4D0*r1x2Z*(VS0(33,18)-ExZpE*VS1(33,18))&
   +2D0*HfxZpE*VS1(54,8)
VS0(82,19)=PAz*VS0(54,19)+WPz*VS1(54,19)+r1x2Z*VR1(54,19)&
   +4D0*r1x2Z*(VS0(33,19)-ExZpE*VS1(33,19))&
   +2D0*HfxZpE*VS1(54,9)
VS0(82,20)=PAz*VS0(54,20)+WPz*VS1(54,20)+r1x2Z*VR1(54,20)&
   +4D0*r1x2Z*(VS0(33,20)-ExZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(54,10)
VS0(83,11)=PAz*VS0(55,11)+WPz*VS1(55,11)+r1x2Z*VR1(55,11)&
   +4D0*r1x2Z*(VS0(34,11)-ExZpE*VS1(34,11))
VS0(83,12)=PAz*VS0(55,12)+WPz*VS1(55,12)+r1x2Z*VR1(55,12)&
   +4D0*r1x2Z*(VS0(34,12)-ExZpE*VS1(34,12))
VS0(83,13)=PAz*VS0(55,13)+WPz*VS1(55,13)+r1x2Z*VR1(55,13)&
   +4D0*r1x2Z*(VS0(34,13)-ExZpE*VS1(34,13))
VS0(83,14)=PAz*VS0(55,14)+WPz*VS1(55,14)+r1x2Z*VR1(55,14)&
   +4D0*r1x2Z*(VS0(34,14)-ExZpE*VS1(34,14))
VS0(83,15)=PAz*VS0(55,15)+WPz*VS1(55,15)+r1x2Z*VR1(55,15)&
   +4D0*r1x2Z*(VS0(34,15)-ExZpE*VS1(34,15))&
   +HfxZpE*VS1(55,5)
VS0(83,16)=PAz*VS0(55,16)+WPz*VS1(55,16)+r1x2Z*VR1(55,16)&
   +4D0*r1x2Z*(VS0(34,16)-ExZpE*VS1(34,16))&
   +HfxZpE*VS1(55,6)
VS0(83,17)=PAz*VS0(55,17)+WPz*VS1(55,17)+r1x2Z*VR1(55,17)&
   +4D0*r1x2Z*(VS0(34,17)-ExZpE*VS1(34,17))&
   +HfxZpE*VS1(55,7)
VS0(83,18)=PAz*VS0(55,18)+WPz*VS1(55,18)+r1x2Z*VR1(55,18)&
   +4D0*r1x2Z*(VS0(34,18)-ExZpE*VS1(34,18))&
   +2D0*HfxZpE*VS1(55,8)
VS0(83,19)=PAz*VS0(55,19)+WPz*VS1(55,19)+r1x2Z*VR1(55,19)&
   +4D0*r1x2Z*(VS0(34,19)-ExZpE*VS1(34,19))&
   +2D0*HfxZpE*VS1(55,9)
VS0(83,20)=PAz*VS0(55,20)+WPz*VS1(55,20)+r1x2Z*VR1(55,20)&
   +4D0*r1x2Z*(VS0(34,20)-ExZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(55,10)
VS0(84,11)=PAz*VS0(56,11)+WPz*VS1(56,11)+r1x2Z*VR1(56,11)&
   +5D0*r1x2Z*(VS0(35,11)-ExZpE*VS1(35,11))
VS0(84,12)=PAz*VS0(56,12)+WPz*VS1(56,12)+r1x2Z*VR1(56,12)&
   +5D0*r1x2Z*(VS0(35,12)-ExZpE*VS1(35,12))
VS0(84,13)=PAz*VS0(56,13)+WPz*VS1(56,13)+r1x2Z*VR1(56,13)&
   +5D0*r1x2Z*(VS0(35,13)-ExZpE*VS1(35,13))
VS0(84,14)=PAz*VS0(56,14)+WPz*VS1(56,14)+r1x2Z*VR1(56,14)&
   +5D0*r1x2Z*(VS0(35,14)-ExZpE*VS1(35,14))
VS0(84,15)=PAz*VS0(56,15)+WPz*VS1(56,15)+r1x2Z*VR1(56,15)&
   +5D0*r1x2Z*(VS0(35,15)-ExZpE*VS1(35,15))&
   +HfxZpE*VS1(56,5)
VS0(84,16)=PAz*VS0(56,16)+WPz*VS1(56,16)+r1x2Z*VR1(56,16)&
   +5D0*r1x2Z*(VS0(35,16)-ExZpE*VS1(35,16))&
   +HfxZpE*VS1(56,6)
VS0(84,17)=PAz*VS0(56,17)+WPz*VS1(56,17)+r1x2Z*VR1(56,17)&
   +5D0*r1x2Z*(VS0(35,17)-ExZpE*VS1(35,17))&
   +HfxZpE*VS1(56,7)
VS0(84,18)=PAz*VS0(56,18)+WPz*VS1(56,18)+r1x2Z*VR1(56,18)&
   +5D0*r1x2Z*(VS0(35,18)-ExZpE*VS1(35,18))&
   +2D0*HfxZpE*VS1(56,8)
VS0(84,19)=PAz*VS0(56,19)+WPz*VS1(56,19)+r1x2Z*VR1(56,19)&
   +5D0*r1x2Z*(VS0(35,19)-ExZpE*VS1(35,19))&
   +2D0*HfxZpE*VS1(56,9)
VS0(84,20)=PAz*VS0(56,20)+WPz*VS1(56,20)+r1x2Z*VR1(56,20)&
   +5D0*r1x2Z*(VS0(35,20)-ExZpE*VS1(35,20))&
   +3D0*HfxZpE*VS1(56,10)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRi0f0'
STOP
END SELECT
END SUBROUTINE MVRRi0f0
