!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(21,60)
      V(2)=HfxZpE*VRR1(21,61)
      V(3)=HfxZpE*VRR1(21,67)
      V(4)=HfxZpE*VRR1(21,68)
      V(5)=HfxZpE*VRR1(21,73)
      V(6)=HfxZpE*VRR1(21,74)
      V(7)=HfxZpE*VRR1(21,75)
      V(8)=HfxZpE*VRR1(21,76)
      V(9)=HfxZpE*VRR1(21,77)
      V(10)=HfxZpE*VRR1(21,78)
      V(11)=HfxZpE*VRR1(21,79)
      V(12)=HfxZpE*VRR1(21,80)
      V(13)=HfxZpE*VRR1(21,81)
      V(14)=r1x2E*VRR0(37,38)
      V(15)=r1x2E*ZxZpE*VRR1(37,38)
      V(16)=r1x2E*VRR0(37,39)
      V(17)=HfxZpE*VRR1(22,60)
      V(18)=r1x2E*ZxZpE*VRR1(37,39)
      V(19)=r1x2E*VRR0(37,44)
      V(20)=3.D0*V(19)
      V(21)=r1x2E*ZxZpE*VRR1(37,44)
      V(22)=-3.D0*V(21)
      V(23)=HfxZpE*VRR1(22,67)
      V(24)=r1x2E*VRR0(37,47)
      V(25)=r1x2E*ZxZpE*VRR1(37,47)
      V(26)=r1x2E*VRR0(37,48)
      V(27)=3.D0*V(26)
      V(28)=r1x2E*ZxZpE*VRR1(37,48)
      V(29)=-3.D0*V(28)
      V(30)=HfxZpE*VRR1(22,72)
      V(31)=HfxZpE*VRR1(22,73)
      V(32)=2.D0*V(31)
      V(33)=r1x2E*VRR0(37,49)
      V(34)=3.D0*V(33)
      V(35)=r1x2E*ZxZpE*VRR1(37,49)
      V(36)=-3.D0*V(35)
      V(37)=r1x2E*VRR0(37,50)
      V(38)=r1x2E*ZxZpE*VRR1(37,50)
      V(39)=r1x2E*VRR0(37,51)
      V(40)=HfxZpE*VRR1(22,75)
      V(41)=r1x2E*ZxZpE*VRR1(37,51)
      V(42)=HfxZpE*VRR1(22,76)
      V(43)=HfxZpE*VRR1(22,77)
      V(44)=2.D0*V(43)
      V(45)=HfxZpE*VRR1(22,78)
      V(46)=r1x2E*VRR0(37,53)
      V(47)=r1x2E*ZxZpE*VRR1(37,53)
      V(48)=r1x2E*VRR0(38,38)
      V(49)=r1x2E*ZxZpE*VRR1(38,38)
      V(50)=r1x2E*VRR0(38,39)
      V(51)=HfxZpE*VRR1(23,60)
      V(52)=3.D0*V(51)
      V(53)=r1x2E*ZxZpE*VRR1(38,39)
      V(54)=r1x2E*VRR0(38,44)
      V(55)=3.D0*V(54)
      V(56)=r1x2E*ZxZpE*VRR1(38,44)
      V(57)=-3.D0*V(56)
      V(58)=r1x2E*VRR0(38,45)
      V(59)=HfxZpE*VRR1(23,67)
      V(60)=3.D0*V(59)
      V(61)=r1x2E*ZxZpE*VRR1(38,45)
      V(62)=r1x2E*VRR0(38,47)
      V(63)=r1x2E*ZxZpE*VRR1(38,47)
      V(64)=r1x2E*VRR0(38,48)
      V(65)=3.D0*V(64)
      V(66)=r1x2E*ZxZpE*VRR1(38,48)
      V(67)=-3.D0*V(66)
      V(68)=r1x2E*VRR0(38,49)
      V(69)=HfxZpE*VRR1(23,72)
      V(70)=3.D0*V(69)
      V(71)=r1x2E*ZxZpE*VRR1(38,49)
      V(72)=3.D0*V(68)
      V(73)=-3.D0*V(71)
      V(74)=r1x2E*VRR0(38,50)
      V(75)=r1x2E*ZxZpE*VRR1(38,50)
      V(76)=r1x2E*VRR0(38,51)
      V(77)=HfxZpE*VRR1(23,75)
      V(78)=r1x2E*ZxZpE*VRR1(38,51)
      V(79)=r1x2E*VRR0(38,52)
      V(80)=2.D0*V(79)
      V(81)=HfxZpE*VRR1(23,76)
      V(82)=r1x2E*ZxZpE*VRR1(38,52)
      V(83)=-2.D0*V(82)
      V(84)=r1x2E*VRR0(38,53)
      V(85)=r1x2E*ZxZpE*VRR1(38,53)
      V(86)=r1x2E*VRR0(39,38)
      V(87)=r1x2E*ZxZpE*VRR1(39,38)
      V(88)=r1x2E*VRR0(39,39)
      V(89)=HfxZpE*VRR1(24,60)
      V(90)=r1x2E*ZxZpE*VRR1(39,39)
      V(91)=r1x2E*VRR0(39,44)
      V(92)=3.D0*V(91)
      V(93)=HfxZpE*VRR1(24,66)
      V(94)=r1x2E*ZxZpE*VRR1(39,44)
      V(95)=-3.D0*V(94)
      V(96)=r1x2E*VRR0(39,45)
      V(97)=HfxZpE*VRR1(24,67)
      V(98)=r1x2E*ZxZpE*VRR1(39,45)
      V(99)=r1x2E*VRR0(39,47)
      V(100)=r1x2E*ZxZpE*VRR1(39,47)
      V(101)=r1x2E*VRR0(39,48)
      V(102)=3.D0*V(101)
      V(103)=HfxZpE*VRR1(24,71)
      V(104)=2.D0*V(103)
      V(105)=r1x2E*ZxZpE*VRR1(39,48)
      V(106)=-3.D0*V(105)
      V(107)=r1x2E*VRR0(39,49)
      V(108)=HfxZpE*VRR1(24,72)
      V(109)=r1x2E*ZxZpE*VRR1(39,49)
      V(110)=3.D0*V(107)
      V(111)=-3.D0*V(109)
      V(112)=r1x2E*VRR0(39,50)
      V(113)=r1x2E*ZxZpE*VRR1(39,50)
      V(114)=r1x2E*VRR0(39,51)
      V(115)=HfxZpE*VRR1(24,75)
      V(116)=r1x2E*ZxZpE*VRR1(39,51)
      V(117)=r1x2E*VRR0(39,52)
      V(118)=2.D0*V(117)
      V(119)=HfxZpE*VRR1(24,76)
      V(120)=2.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(39,52)
      V(122)=-2.D0*V(121)
      V(123)=HfxZpE*VRR1(23,77)
      V(124)=r1x2E*VRR0(39,53)
      V(125)=HfxZpE*VRR1(23,78)
      V(126)=r1x2E*ZxZpE*VRR1(39,53)
      V(127)=r1x2E*VRR0(40,38)
      V(128)=HfxZpE*VRR1(25,59)
      V(129)=r1x2E*ZxZpE*VRR1(40,38)
      V(130)=r1x2E*VRR0(40,39)
      V(131)=HfxZpE*VRR1(25,60)
      V(132)=r1x2E*ZxZpE*VRR1(40,39)
      V(133)=HfxZpE*VRR1(25,65)
      V(134)=r1x2E*VRR0(40,44)
      V(135)=3.D0*V(134)
      V(136)=HfxZpE*VRR1(25,66)
      V(137)=r1x2E*ZxZpE*VRR1(40,44)
      V(138)=-3.D0*V(137)
      V(139)=r1x2E*VRR0(40,47)
      V(140)=HfxZpE*VRR1(25,70)
      V(141)=r1x2E*ZxZpE*VRR1(40,47)
      V(142)=r1x2E*VRR0(40,48)
      V(143)=3.D0*V(142)
      V(144)=HfxZpE*VRR1(25,71)
      V(145)=r1x2E*ZxZpE*VRR1(40,48)
      V(146)=-3.D0*V(145)
      V(147)=r1x2E*VRR0(40,49)
      V(148)=3.D0*V(147)
      V(149)=r1x2E*ZxZpE*VRR1(40,49)
      V(150)=-3.D0*V(149)
      V(151)=r1x2E*VRR0(40,50)
      V(152)=r1x2E*ZxZpE*VRR1(40,50)
      V(153)=r1x2E*VRR0(40,51)
      V(154)=HfxZpE*VRR1(25,75)
      V(155)=r1x2E*ZxZpE*VRR1(40,51)
      V(156)=HfxZpE*VRR1(24,77)
      V(157)=r1x2E*VRR0(40,53)
      V(158)=HfxZpE*VRR1(24,78)
      V(159)=r1x2E*ZxZpE*VRR1(40,53)
      V(160)=HfxZpE*VRR1(25,76)
      V(161)=HfxZpE*VRR1(25,77)
      V(162)=HfxZpE*VRR1(25,78)
      V(163)=HfxZpE*VRR1(25,79)
      V(164)=HfxZpE*VRR1(25,80)
      V(165)=HfxZpE*VRR1(25,81)
      V(166)=r1x2E*VRR0(42,38)
      V(167)=r1x2E*ZxZpE*VRR1(42,38)
      V(168)=r1x2E*VRR0(42,39)
      V(169)=HfxZpE*VRR1(26,60)
      V(170)=r1x2E*ZxZpE*VRR1(42,39)
      V(171)=r1x2E*VRR0(42,44)
      V(172)=3.D0*V(171)
      V(173)=r1x2E*ZxZpE*VRR1(42,44)
      V(174)=-3.D0*V(173)
      V(175)=HfxZpE*VRR1(26,67)
      V(176)=r1x2E*VRR0(42,47)
      V(177)=r1x2E*ZxZpE*VRR1(42,47)
      V(178)=r1x2E*VRR0(42,48)
      V(179)=3.D0*V(178)
      V(180)=r1x2E*ZxZpE*VRR1(42,48)
      V(181)=-3.D0*V(180)
      V(182)=HfxZpE*VRR1(26,72)
      V(183)=HfxZpE*VRR1(26,73)
      V(184)=r1x2E*VRR0(42,49)
      V(185)=3.D0*V(184)
      V(186)=r1x2E*ZxZpE*VRR1(42,49)
      V(187)=-3.D0*V(186)
      V(188)=r1x2E*VRR0(42,50)
      V(189)=r1x2E*ZxZpE*VRR1(42,50)
      V(190)=r1x2E*VRR0(42,51)
      V(191)=HfxZpE*VRR1(26,75)
      V(192)=r1x2E*ZxZpE*VRR1(42,51)
      V(193)=HfxZpE*VRR1(26,76)
      V(194)=HfxZpE*VRR1(26,77)
      V(195)=2.D0*V(194)
      V(196)=HfxZpE*VRR1(26,78)
      V(197)=r1x2E*VRR0(42,53)
      V(198)=r1x2E*ZxZpE*VRR1(42,53)
      V(199)=r1x2E*VRR0(43,38)
      V(200)=r1x2E*ZxZpE*VRR1(43,38)
      V(201)=r1x2E*VRR0(43,39)
      V(202)=HfxZpE*VRR1(27,60)
      V(203)=r1x2E*ZxZpE*VRR1(43,39)
      V(204)=r1x2E*VRR0(43,44)
      V(205)=3.D0*V(204)
      V(206)=r1x2E*ZxZpE*VRR1(43,44)
      V(207)=-3.D0*V(206)
      V(208)=r1x2E*VRR0(43,45)
      V(209)=HfxZpE*VRR1(27,67)
      V(210)=r1x2E*ZxZpE*VRR1(43,45)
      V(211)=r1x2E*VRR0(43,47)
      V(212)=r1x2E*ZxZpE*VRR1(43,47)
      V(213)=r1x2E*VRR0(43,48)
      V(214)=3.D0*V(213)
      V(215)=r1x2E*ZxZpE*VRR1(43,48)
      V(216)=-3.D0*V(215)
      V(217)=r1x2E*VRR0(43,49)
      V(218)=HfxZpE*VRR1(27,72)
      V(219)=r1x2E*ZxZpE*VRR1(43,49)
      V(220)=3.D0*V(217)
      V(221)=-3.D0*V(219)
      V(222)=r1x2E*VRR0(43,50)
      V(223)=r1x2E*ZxZpE*VRR1(43,50)
      V(224)=r1x2E*VRR0(43,51)
      V(225)=HfxZpE*VRR1(27,75)
      V(226)=r1x2E*ZxZpE*VRR1(43,51)
      V(227)=r1x2E*VRR0(43,52)
      V(228)=2.D0*V(227)
      V(229)=HfxZpE*VRR1(27,76)
      V(230)=r1x2E*ZxZpE*VRR1(43,52)
      V(231)=-2.D0*V(230)
      V(232)=r1x2E*VRR0(43,53)
      V(233)=r1x2E*ZxZpE*VRR1(43,53)
      V(234)=r1x2E*VRR0(44,38)
      V(235)=r1x2E*ZxZpE*VRR1(44,38)
      V(236)=r1x2E*VRR0(44,39)
      V(237)=HfxZpE*VRR1(28,60)
      V(238)=r1x2E*ZxZpE*VRR1(44,39)
      V(239)=r1x2E*VRR0(44,44)
      V(240)=3.D0*V(239)
      V(241)=r1x2E*ZxZpE*VRR1(44,44)
      V(242)=-3.D0*V(241)
      V(243)=r1x2E*VRR0(44,45)
      V(244)=HfxZpE*VRR1(28,67)
      V(245)=r1x2E*ZxZpE*VRR1(44,45)
      V(246)=r1x2E*VRR0(44,47)
      V(247)=r1x2E*ZxZpE*VRR1(44,47)
      V(248)=r1x2E*VRR0(44,48)
      V(249)=3.D0*V(248)
      V(250)=r1x2E*ZxZpE*VRR1(44,48)
      V(251)=-3.D0*V(250)
      V(252)=r1x2E*VRR0(44,49)
      V(253)=HfxZpE*VRR1(28,72)
      V(254)=2.D0*V(253)
      V(255)=r1x2E*ZxZpE*VRR1(44,49)
      V(256)=2.D0*V(218)
      V(257)=3.D0*V(252)
      V(258)=-3.D0*V(255)
      V(259)=r1x2E*VRR0(44,50)
      V(260)=r1x2E*ZxZpE*VRR1(44,50)
      V(261)=r1x2E*VRR0(44,51)
      V(262)=HfxZpE*VRR1(28,75)
      V(263)=2.D0*V(262)
      V(264)=r1x2E*ZxZpE*VRR1(44,51)
      V(265)=r1x2E*VRR0(44,52)
      V(266)=2.D0*V(265)
      V(267)=HfxZpE*VRR1(28,76)
      V(268)=2.D0*V(267)
      V(269)=r1x2E*ZxZpE*VRR1(44,52)
      V(270)=-2.D0*V(269)
      V(271)=HfxZpE*VRR1(27,77)
      V(272)=2.D0*V(271)
      V(273)=r1x2E*VRR0(44,53)
      V(274)=HfxZpE*VRR1(27,78)
      V(275)=2.D0*V(274)
      V(276)=r1x2E*ZxZpE*VRR1(44,53)
      V(277)=r1x2E*VRR0(45,38)
      V(278)=r1x2E*ZxZpE*VRR1(45,38)
      V(279)=r1x2E*VRR0(45,39)
      V(280)=HfxZpE*VRR1(29,60)
      V(281)=r1x2E*ZxZpE*VRR1(45,39)
      V(282)=r1x2E*VRR0(45,44)
      V(283)=3.D0*V(282)
      V(284)=HfxZpE*VRR1(29,66)
      V(285)=r1x2E*ZxZpE*VRR1(45,44)
      V(286)=-3.D0*V(285)
      V(287)=r1x2E*VRR0(45,45)
      V(288)=HfxZpE*VRR1(29,67)
      V(289)=r1x2E*ZxZpE*VRR1(45,45)
      V(290)=r1x2E*VRR0(45,47)
      V(291)=r1x2E*ZxZpE*VRR1(45,47)
      V(292)=r1x2E*VRR0(45,48)
      V(293)=3.D0*V(292)
      V(294)=HfxZpE*VRR1(29,71)
      V(295)=r1x2E*ZxZpE*VRR1(45,48)
      V(296)=-3.D0*V(295)
      V(297)=r1x2E*VRR0(45,49)
      V(298)=HfxZpE*VRR1(29,72)
      V(299)=r1x2E*ZxZpE*VRR1(45,49)
      V(300)=3.D0*V(297)
      V(301)=-3.D0*V(299)
      V(302)=r1x2E*VRR0(45,50)
      V(303)=r1x2E*ZxZpE*VRR1(45,50)
      V(304)=r1x2E*VRR0(45,51)
      V(305)=HfxZpE*VRR1(29,75)
      V(306)=r1x2E*ZxZpE*VRR1(45,51)
      V(307)=r1x2E*VRR0(45,52)
      V(308)=2.D0*V(307)
      V(309)=HfxZpE*VRR1(29,76)
      V(310)=r1x2E*ZxZpE*VRR1(45,52)
      V(311)=-2.D0*V(310)
      V(312)=HfxZpE*VRR1(28,77)
      V(313)=r1x2E*VRR0(45,53)
      V(314)=HfxZpE*VRR1(28,78)
      V(315)=r1x2E*ZxZpE*VRR1(45,53)
      V(316)=r1x2E*VRR0(46,38)
      V(317)=r1x2E*ZxZpE*VRR1(46,38)
      V(318)=r1x2E*VRR0(46,39)
      V(319)=r1x2E*ZxZpE*VRR1(46,39)
      V(320)=r1x2E*VRR0(46,44)
      V(321)=3.D0*V(320)
      V(322)=r1x2E*ZxZpE*VRR1(46,44)
      V(323)=-3.D0*V(322)
      V(324)=r1x2E*VRR0(46,47)
      V(325)=r1x2E*ZxZpE*VRR1(46,47)
      V(326)=r1x2E*VRR0(46,48)
      V(327)=3.D0*V(326)
      V(328)=r1x2E*ZxZpE*VRR1(46,48)
      V(329)=-3.D0*V(328)
      V(330)=r1x2E*VRR0(46,49)
      V(331)=3.D0*V(330)
      V(332)=r1x2E*ZxZpE*VRR1(46,49)
      V(333)=-3.D0*V(332)
      V(334)=r1x2E*VRR0(46,50)
      V(335)=r1x2E*ZxZpE*VRR1(46,50)
      V(336)=r1x2E*VRR0(46,51)
      V(337)=r1x2E*ZxZpE*VRR1(46,51)
      V(338)=2.D0*V(309)
      V(339)=HfxZpE*VRR1(29,77)
      V(340)=r1x2E*VRR0(46,53)
      V(341)=HfxZpE*VRR1(29,78)
      V(342)=r1x2E*ZxZpE*VRR1(46,53)
      V(343)=r1x2E*VRR0(47,38)
      V(344)=r1x2E*ZxZpE*VRR1(47,38)
      V(345)=r1x2E*VRR0(47,39)
      V(346)=HfxZpE*VRR1(30,60)
      V(347)=r1x2E*ZxZpE*VRR1(47,39)
      V(348)=r1x2E*VRR0(47,44)
      V(349)=3.D0*V(348)
      V(350)=r1x2E*ZxZpE*VRR1(47,44)
      V(351)=-3.D0*V(350)
      V(352)=r1x2E*VRR0(47,45)
      V(353)=HfxZpE*VRR1(30,67)
      V(354)=r1x2E*ZxZpE*VRR1(47,45)
      V(355)=r1x2E*VRR0(47,47)
      V(356)=r1x2E*ZxZpE*VRR1(47,47)
      V(357)=r1x2E*VRR0(47,48)
      V(358)=3.D0*V(357)
      V(359)=r1x2E*ZxZpE*VRR1(47,48)
      V(360)=-3.D0*V(359)
      V(361)=r1x2E*VRR0(47,49)
      V(362)=HfxZpE*VRR1(30,72)
      V(363)=3.D0*V(362)
      V(364)=r1x2E*ZxZpE*VRR1(47,49)
      V(365)=3.D0*V(361)
      V(366)=-3.D0*V(364)
      V(367)=r1x2E*VRR0(47,50)
      V(368)=r1x2E*ZxZpE*VRR1(47,50)
      V(369)=r1x2E*VRR0(47,51)
      V(370)=HfxZpE*VRR1(30,75)
      V(371)=3.D0*V(370)
      V(372)=r1x2E*ZxZpE*VRR1(47,51)
      V(373)=r1x2E*VRR0(47,52)
      V(374)=2.D0*V(373)
      V(375)=HfxZpE*VRR1(30,76)
      V(376)=3.D0*V(375)
      V(377)=r1x2E*ZxZpE*VRR1(47,52)
      V(378)=-2.D0*V(377)
      V(379)=r1x2E*VRR0(47,53)
      V(380)=r1x2E*ZxZpE*VRR1(47,53)
      V(381)=r1x2E*VRR0(48,38)
      V(382)=r1x2E*ZxZpE*VRR1(48,38)
      V(383)=r1x2E*VRR0(48,39)
      V(384)=HfxZpE*VRR1(31,60)
      V(385)=2.D0*V(384)
      V(386)=r1x2E*ZxZpE*VRR1(48,39)
      V(387)=r1x2E*VRR0(48,44)
      V(388)=3.D0*V(387)
      V(389)=r1x2E*ZxZpE*VRR1(48,44)
      V(390)=-3.D0*V(389)
      V(391)=r1x2E*VRR0(48,45)
      V(392)=HfxZpE*VRR1(31,67)
      V(393)=2.D0*V(392)
      V(394)=r1x2E*ZxZpE*VRR1(48,45)
      V(395)=r1x2E*VRR0(48,47)
      V(396)=r1x2E*ZxZpE*VRR1(48,47)
      V(397)=r1x2E*VRR0(48,48)
      V(398)=3.D0*V(397)
      V(399)=r1x2E*ZxZpE*VRR1(48,48)
      V(400)=-3.D0*V(399)
      V(401)=r1x2E*VRR0(48,49)
      V(402)=HfxZpE*VRR1(31,72)
      V(403)=2.D0*V(402)
      V(404)=r1x2E*ZxZpE*VRR1(48,49)
      V(405)=3.D0*V(401)
      V(406)=-3.D0*V(404)
      V(407)=r1x2E*VRR0(48,50)
      V(408)=r1x2E*ZxZpE*VRR1(48,50)
      V(409)=r1x2E*VRR0(48,51)
      V(410)=HfxZpE*VRR1(31,75)
      V(411)=r1x2E*ZxZpE*VRR1(48,51)
      V(412)=r1x2E*VRR0(48,52)
      V(413)=2.D0*V(412)
      V(414)=HfxZpE*VRR1(31,76)
      V(415)=r1x2E*ZxZpE*VRR1(48,52)
      V(416)=-2.D0*V(415)
      V(417)=HfxZpE*VRR1(30,77)
      V(418)=r1x2E*VRR0(48,53)
      V(419)=HfxZpE*VRR1(30,78)
      V(420)=r1x2E*ZxZpE*VRR1(48,53)
      V(421)=r1x2E*VRR0(49,38)
      V(422)=r1x2E*ZxZpE*VRR1(49,38)
      V(423)=r1x2E*VRR0(49,39)
      V(424)=HfxZpE*VRR1(32,60)
      V(425)=r1x2E*ZxZpE*VRR1(49,39)
      V(426)=r1x2E*VRR0(49,44)
      V(427)=3.D0*V(426)
      V(428)=r1x2E*ZxZpE*VRR1(49,44)
      V(429)=-3.D0*V(428)
      V(430)=r1x2E*VRR0(49,45)
      V(431)=HfxZpE*VRR1(32,67)
      V(432)=r1x2E*ZxZpE*VRR1(49,45)
      V(433)=r1x2E*VRR0(49,47)
      V(434)=r1x2E*ZxZpE*VRR1(49,47)
      V(435)=r1x2E*VRR0(49,48)
      V(436)=3.D0*V(435)
      V(437)=r1x2E*ZxZpE*VRR1(49,48)
      V(438)=-3.D0*V(437)
      V(439)=r1x2E*VRR0(49,49)
      V(440)=HfxZpE*VRR1(32,72)
      V(441)=r1x2E*ZxZpE*VRR1(49,49)
      V(442)=3.D0*V(439)
      V(443)=-3.D0*V(441)
      V(444)=r1x2E*VRR0(49,50)
      V(445)=r1x2E*ZxZpE*VRR1(49,50)
      V(446)=r1x2E*VRR0(49,51)
      V(447)=HfxZpE*VRR1(32,75)
      V(448)=r1x2E*ZxZpE*VRR1(49,51)
      V(449)=r1x2E*VRR0(49,52)
      V(450)=2.D0*V(449)
      V(451)=HfxZpE*VRR1(32,76)
      V(452)=r1x2E*ZxZpE*VRR1(49,52)
      V(453)=-2.D0*V(452)
      V(454)=HfxZpE*VRR1(31,77)
      V(455)=r1x2E*VRR0(49,53)
      V(456)=HfxZpE*VRR1(31,78)
      V(457)=r1x2E*ZxZpE*VRR1(49,53)
      V(458)=r1x2E*VRR0(50,38)
      V(459)=r1x2E*ZxZpE*VRR1(50,38)
      V(460)=r1x2E*VRR0(50,39)
      V(461)=r1x2E*ZxZpE*VRR1(50,39)
      V(462)=r1x2E*VRR0(50,44)
      V(463)=3.D0*V(462)
      V(464)=r1x2E*ZxZpE*VRR1(50,44)
      V(465)=-3.D0*V(464)
      V(466)=r1x2E*VRR0(50,45)
      V(467)=r1x2E*ZxZpE*VRR1(50,45)
      V(468)=r1x2E*VRR0(50,47)
      V(469)=r1x2E*ZxZpE*VRR1(50,47)
      V(470)=r1x2E*VRR0(50,48)
      V(471)=3.D0*V(470)
      V(472)=r1x2E*ZxZpE*VRR1(50,48)
      V(473)=-3.D0*V(472)
      V(474)=r1x2E*VRR0(50,49)
      V(475)=r1x2E*ZxZpE*VRR1(50,49)
      V(476)=3.D0*V(440)
      V(477)=3.D0*V(474)
      V(478)=-3.D0*V(475)
      V(479)=r1x2E*VRR0(50,50)
      V(480)=r1x2E*ZxZpE*VRR1(50,50)
      V(481)=r1x2E*VRR0(50,51)
      V(482)=r1x2E*ZxZpE*VRR1(50,51)
      V(483)=r1x2E*VRR0(50,52)
      V(484)=2.D0*V(483)
      V(485)=r1x2E*ZxZpE*VRR1(50,52)
      V(486)=-2.D0*V(485)
      V(487)=HfxZpE*VRR1(32,77)
      V(488)=3.D0*V(487)
      V(489)=r1x2E*VRR0(50,53)
      V(490)=HfxZpE*VRR1(32,78)
      V(491)=3.D0*V(490)
      V(492)=r1x2E*ZxZpE*VRR1(50,53)
      V(493)=r1x2E*VRR0(51,38)
      V(494)=r1x2E*ZxZpE*VRR1(51,38)
      V(495)=r1x2E*VRR0(51,39)
      V(496)=HfxZpE*VRR1(33,60)
      V(497)=r1x2E*ZxZpE*VRR1(51,39)
      V(498)=r1x2E*VRR0(51,44)
      V(499)=3.D0*V(498)
      V(500)=HfxZpE*VRR1(33,66)
      V(501)=2.D0*V(500)
      V(502)=r1x2E*ZxZpE*VRR1(51,44)
      V(503)=-3.D0*V(502)
      V(504)=r1x2E*VRR0(51,45)
      V(505)=HfxZpE*VRR1(33,67)
      V(506)=2.D0*V(505)
      V(507)=r1x2E*ZxZpE*VRR1(51,45)
      V(508)=r1x2E*VRR0(51,47)
      V(509)=r1x2E*ZxZpE*VRR1(51,47)
      V(510)=r1x2E*VRR0(51,48)
      V(511)=3.D0*V(510)
      V(512)=HfxZpE*VRR1(33,71)
      V(513)=r1x2E*ZxZpE*VRR1(51,48)
      V(514)=-3.D0*V(513)
      V(515)=r1x2E*VRR0(51,49)
      V(516)=HfxZpE*VRR1(33,72)
      V(517)=r1x2E*ZxZpE*VRR1(51,49)
      V(518)=3.D0*V(515)
      V(519)=-3.D0*V(517)
      V(520)=r1x2E*VRR0(51,50)
      V(521)=r1x2E*ZxZpE*VRR1(51,50)
      V(522)=r1x2E*VRR0(51,51)
      V(523)=HfxZpE*VRR1(33,75)
      V(524)=r1x2E*ZxZpE*VRR1(51,51)
      V(525)=r1x2E*VRR0(51,52)
      V(526)=2.D0*V(525)
      V(527)=HfxZpE*VRR1(33,76)
      V(528)=r1x2E*ZxZpE*VRR1(51,52)
      V(529)=-2.D0*V(528)
      V(530)=r1x2E*VRR0(51,53)
      V(531)=r1x2E*ZxZpE*VRR1(51,53)
      V(532)=r1x2E*VRR0(52,38)
      V(533)=r1x2E*ZxZpE*VRR1(52,38)
      V(534)=r1x2E*VRR0(52,39)
      V(535)=HfxZpE*VRR1(34,60)
      V(536)=r1x2E*ZxZpE*VRR1(52,39)
      V(537)=r1x2E*VRR0(52,44)
      V(538)=3.D0*V(537)
      V(539)=HfxZpE*VRR1(34,66)
      V(540)=r1x2E*ZxZpE*VRR1(52,44)
      V(541)=-3.D0*V(540)
      V(542)=r1x2E*VRR0(52,45)
      V(543)=HfxZpE*VRR1(34,67)
      V(544)=r1x2E*ZxZpE*VRR1(52,45)
      V(545)=r1x2E*VRR0(52,47)
      V(546)=r1x2E*ZxZpE*VRR1(52,47)
      V(547)=r1x2E*VRR0(52,48)
      V(548)=3.D0*V(547)
      V(549)=HfxZpE*VRR1(34,71)
      V(550)=r1x2E*ZxZpE*VRR1(52,48)
      V(551)=-3.D0*V(550)
      V(552)=r1x2E*VRR0(52,49)
      V(553)=HfxZpE*VRR1(34,72)
      V(554)=r1x2E*ZxZpE*VRR1(52,49)
      V(555)=3.D0*V(552)
      V(556)=HfxZpE*VRR1(33,73)
      V(557)=-3.D0*V(554)
      V(558)=r1x2E*VRR0(52,50)
      V(559)=r1x2E*ZxZpE*VRR1(52,50)
      V(560)=r1x2E*VRR0(52,51)
      V(561)=HfxZpE*VRR1(34,75)
      V(562)=r1x2E*ZxZpE*VRR1(52,51)
      V(563)=r1x2E*VRR0(52,52)
      V(564)=2.D0*V(563)
      V(565)=HfxZpE*VRR1(34,76)
      V(566)=r1x2E*ZxZpE*VRR1(52,52)
      V(567)=-2.D0*V(566)
      V(568)=HfxZpE*VRR1(33,77)
      V(569)=r1x2E*VRR0(52,53)
      V(570)=HfxZpE*VRR1(33,78)
      V(571)=r1x2E*ZxZpE*VRR1(52,53)
      V(572)=r1x2E*VRR0(53,38)
      V(573)=r1x2E*ZxZpE*VRR1(53,38)
      V(574)=r1x2E*VRR0(53,39)
      V(575)=r1x2E*ZxZpE*VRR1(53,39)
      V(576)=r1x2E*VRR0(53,44)
      V(577)=3.D0*V(576)
      V(578)=r1x2E*ZxZpE*VRR1(53,44)
      V(579)=-3.D0*V(578)
      V(580)=r1x2E*VRR0(53,45)
      V(581)=r1x2E*ZxZpE*VRR1(53,45)
      V(582)=2.D0*V(543)
      V(583)=r1x2E*VRR0(53,47)
      V(584)=r1x2E*ZxZpE*VRR1(53,47)
      V(585)=r1x2E*VRR0(53,48)
      V(586)=3.D0*V(585)
      V(587)=r1x2E*ZxZpE*VRR1(53,48)
      V(588)=-3.D0*V(587)
      V(589)=r1x2E*VRR0(53,49)
      V(590)=r1x2E*ZxZpE*VRR1(53,49)
      V(591)=3.D0*V(589)
      V(592)=HfxZpE*VRR1(34,73)
      V(593)=-3.D0*V(590)
      V(594)=r1x2E*VRR0(53,50)
      V(595)=r1x2E*ZxZpE*VRR1(53,50)
      V(596)=r1x2E*VRR0(53,51)
      V(597)=r1x2E*ZxZpE*VRR1(53,51)
      V(598)=r1x2E*VRR0(53,52)
      V(599)=2.D0*V(598)
      V(600)=r1x2E*ZxZpE*VRR1(53,52)
      V(601)=-2.D0*V(600)
      V(602)=HfxZpE*VRR1(34,77)
      V(603)=r1x2E*VRR0(53,53)
      V(604)=HfxZpE*VRR1(34,78)
      V(605)=r1x2E*ZxZpE*VRR1(53,53)
      V(606)=r1x2E*VRR0(54,38)
      V(607)=HfxZpE*VRR1(35,59)
      V(608)=r1x2E*ZxZpE*VRR1(54,38)
      V(609)=r1x2E*VRR0(54,39)
      V(610)=HfxZpE*VRR1(35,60)
      V(611)=r1x2E*ZxZpE*VRR1(54,39)
      V(612)=HfxZpE*VRR1(35,65)
      V(613)=r1x2E*VRR0(54,44)
      V(614)=3.D0*V(613)
      V(615)=HfxZpE*VRR1(35,66)
      V(616)=r1x2E*ZxZpE*VRR1(54,44)
      V(617)=-3.D0*V(616)
      V(618)=r1x2E*VRR0(54,47)
      V(619)=HfxZpE*VRR1(35,70)
      V(620)=r1x2E*ZxZpE*VRR1(54,47)
      V(621)=r1x2E*VRR0(54,48)
      V(622)=3.D0*V(621)
      V(623)=HfxZpE*VRR1(35,71)
      V(624)=r1x2E*ZxZpE*VRR1(54,48)
      V(625)=-3.D0*V(624)
      V(626)=r1x2E*VRR0(54,49)
      V(627)=3.D0*V(626)
      V(628)=r1x2E*ZxZpE*VRR1(54,49)
      V(629)=-3.D0*V(628)
      V(630)=r1x2E*VRR0(54,50)
      V(631)=r1x2E*ZxZpE*VRR1(54,50)
      V(632)=r1x2E*VRR0(54,51)
      V(633)=HfxZpE*VRR1(35,75)
      V(634)=r1x2E*ZxZpE*VRR1(54,51)
      V(635)=r1x2E*VRR0(54,53)
      V(636)=r1x2E*ZxZpE*VRR1(54,53)
      V(637)=r1x2E*VRR0(55,38)
      V(638)=r1x2E*ZxZpE*VRR1(55,38)
      V(639)=r1x2E*VRR0(55,39)
      V(640)=r1x2E*ZxZpE*VRR1(55,39)
      V(641)=HfxZpE*VRR1(35,61)
      V(642)=r1x2E*VRR0(55,44)
      V(643)=3.D0*V(642)
      V(644)=r1x2E*ZxZpE*VRR1(55,44)
      V(645)=-3.D0*V(644)
      V(646)=HfxZpE*VRR1(35,67)
      V(647)=HfxZpE*VRR1(35,68)
      V(648)=r1x2E*VRR0(55,47)
      V(649)=r1x2E*ZxZpE*VRR1(55,47)
      V(650)=r1x2E*VRR0(55,48)
      V(651)=3.D0*V(650)
      V(652)=r1x2E*ZxZpE*VRR1(55,48)
      V(653)=-3.D0*V(652)
      V(654)=r1x2E*VRR0(55,49)
      V(655)=3.D0*V(654)
      V(656)=HfxZpE*VRR1(35,73)
      V(657)=r1x2E*ZxZpE*VRR1(55,49)
      V(658)=-3.D0*V(657)
      V(659)=r1x2E*VRR0(55,50)
      V(660)=HfxZpE*VRR1(35,74)
      V(661)=r1x2E*ZxZpE*VRR1(55,50)
      V(662)=r1x2E*VRR0(55,51)
      V(663)=r1x2E*ZxZpE*VRR1(55,51)
      V(664)=r1x2E*VRR0(55,53)
      V(665)=HfxZpE*VRR1(35,78)
      V(666)=r1x2E*ZxZpE*VRR1(55,53)
      VRR0(36,85)=6.D0*r1x2E*VRR0(36,36)+QCx*VRR0(36,57)+5.D0*HfxZpE*VRR1(21,57)-6.D0*r1x2E*ZxZpE*VRR1(36,36)+WQx*VRR1(36,57)
      VRR0(36,86)=5.D0*r1x2E*VRR0(36,37)+QCx*VRR0(36,58)+5.D0*HfxZpE*VRR1(21,58)-5.D0*r1x2E*ZxZpE*VRR1(36,37)+WQx*VRR1(36,58)
      VRR0(36,87)=4.D0*r1x2E*VRR0(36,38)+QCx*VRR0(36,59)+5.D0*HfxZpE*VRR1(21,59)-4.D0*r1x2E*ZxZpE*VRR1(36,38)+WQx*VRR1(36,59)
      VRR0(36,88)=4.D0*V(1)+4.D0*r1x2Z*VRR0(11,88)+PAx*VRR0(21,88)-4.D0*ExZpE*r1x2Z*VRR1(11,88)+WPx*VRR1(21,88)
      VRR0(36,89)=3.D0*V(2)+4.D0*r1x2Z*VRR0(11,89)+PAx*VRR0(21,89)-4.D0*ExZpE*r1x2Z*VRR1(11,89)+WPx*VRR1(21,89)
      VRR0(36,90)=4.D0*r1x2E*VRR0(36,39)+QCy*VRR0(36,61)-4.D0*r1x2E*ZxZpE*VRR1(36,39)+WQy*VRR1(36,61)
      VRR0(36,91)=5.D0*r1x2E*VRR0(36,40)+QCy*VRR0(36,62)-5.D0*r1x2E*ZxZpE*VRR1(36,40)+WQy*VRR1(36,62)
      VRR0(36,92)=6.D0*r1x2E*VRR0(36,41)+QCy*VRR0(36,63)-6.D0*r1x2E*ZxZpE*VRR1(36,41)+WQy*VRR1(36,63)
      VRR0(36,93)=5.D0*r1x2E*VRR0(36,42)+QCx*VRR0(36,64)+5.D0*HfxZpE*VRR1(21,64)-5.D0*r1x2E*ZxZpE*VRR1(36,42)+WQx*VRR1(36,64)
      VRR0(36,94)=4.D0*r1x2E*VRR0(36,43)+QCx*VRR0(36,65)+5.D0*HfxZpE*VRR1(21,65)-4.D0*r1x2E*ZxZpE*VRR1(36,43)+WQx*VRR1(36,65)
      VRR0(36,95)=4.D0*r1x2Z*VRR0(11,95)+PAx*VRR0(21,95)-4.D0*ExZpE*r1x2Z*VRR1(11,95)+4.D0*HfxZpE*VRR1(21,66)+WPx*VRR1(21,95)
      VRR0(36,96)=3.D0*V(3)+4.D0*r1x2Z*VRR0(11,96)+PAx*VRR0(21,96)-4.D0*ExZpE*r1x2Z*VRR1(11,96)+WPx*VRR1(21,96)
      VRR0(36,97)=2.D0*V(4)+4.D0*r1x2Z*VRR0(11,97)+PAx*VRR0(21,97)-4.D0*ExZpE*r1x2Z*VRR1(11,97)+WPx*VRR1(21,97)
      VRR0(36,98)=4.D0*r1x2E*VRR0(36,45)+QCy*VRR0(36,68)-4.D0*r1x2E*ZxZpE*VRR1(36,45)+WQy*VRR1(36,68)
      VRR0(36,99)=5.D0*r1x2E*VRR0(36,46)+QCy*VRR0(36,69)-5.D0*r1x2E*ZxZpE*VRR1(36,46)+WQy*VRR1(36,69)
      VRR0(36,100)=4.D0*r1x2E*VRR0(36,47)+QCx*VRR0(36,70)+5.D0*HfxZpE*VRR1(21,70)-4.D0*r1x2E*ZxZpE*VRR1(36,47)+WQx*VRR1(36,70)
      VRR0(36,101)=4.D0*r1x2Z*VRR0(11,101)+PAx*VRR0(21,101)-4.D0*ExZpE*r1x2Z*VRR1(11,101)+4.D0*HfxZpE*VRR1(21,71)+WPx*VRR1(21,101)
      VRR0(36,102)=4.D0*r1x2Z*VRR0(11,102)+PAx*VRR0(21,102)-4.D0*ExZpE*r1x2Z*VRR1(11,102)+3.D0*HfxZpE*VRR1(21,72)+WPx*VRR1(21,102)
      VRR0(36,103)=2.D0*V(5)+4.D0*r1x2Z*VRR0(11,103)+PAx*VRR0(21,103)-4.D0*ExZpE*r1x2Z*VRR1(11,103)+WPx*VRR1(21,103)
      VRR0(36,104)=V(6)+4.D0*r1x2Z*VRR0(11,104)+PAx*VRR0(21,104)-4.D0*ExZpE*r1x2Z*VRR1(11,104)+WPx*VRR1(21,104)
      VRR0(36,105)=4.D0*r1x2E*VRR0(36,50)+QCy*VRR0(36,74)-4.D0*r1x2E*ZxZpE*VRR1(36,50)+WQy*VRR1(36,74)
      VRR0(36,106)=4.D0*V(7)+4.D0*r1x2Z*VRR0(11,106)+PAx*VRR0(21,106)-4.D0*ExZpE*r1x2Z*VRR1(11,106)+WPx*VRR1(21,106)
      VRR0(36,107)=3.D0*V(8)+4.D0*r1x2Z*VRR0(11,107)+PAx*VRR0(21,107)-4.D0*ExZpE*r1x2Z*VRR1(11,107)+WPx*VRR1(21,107)
      VRR0(36,108)=2.D0*V(9)+4.D0*r1x2Z*VRR0(11,108)+PAx*VRR0(21,108)-4.D0*ExZpE*r1x2Z*VRR1(11,108)+WPx*VRR1(21,108)
      VRR0(36,109)=V(10)+4.D0*r1x2Z*VRR0(11,109)+PAx*VRR0(21,109)-4.D0*ExZpE*r1x2Z*VRR1(11,109)+WPx*VRR1(21,109)
      VRR0(36,110)=4.D0*r1x2Z*VRR0(11,110)+PAx*VRR0(21,110)-4.D0*ExZpE*r1x2Z*VRR1(11,110)+WPx*VRR1(21,110)
      VRR0(36,111)=3.D0*V(11)+4.D0*r1x2Z*VRR0(11,111)+PAx*VRR0(21,111)-4.D0*ExZpE*r1x2Z*VRR1(11,111)+WPx*VRR1(21,111)
      VRR0(36,112)=2.D0*V(12)+4.D0*r1x2Z*VRR0(11,112)+PAx*VRR0(21,112)-4.D0*ExZpE*r1x2Z*VRR1(11,112)+WPx*VRR1(21,112)
      VRR0(36,113)=V(13)+4.D0*r1x2Z*VRR0(11,113)+PAx*VRR0(21,113)-4.D0*ExZpE*r1x2Z*VRR1(11,113)+WPx*VRR1(21,113)
      VRR0(36,114)=4.D0*r1x2Z*VRR0(11,114)+PAx*VRR0(21,114)-4.D0*ExZpE*r1x2Z*VRR1(11,114)+WPx*VRR1(21,114)
      VRR0(36,115)=4.D0*r1x2E*VRR0(36,51)+QCz*VRR0(36,79)-4.D0*r1x2E*ZxZpE*VRR1(36,51)+WQz*VRR1(36,79)
      VRR0(36,116)=4.D0*r1x2E*VRR0(36,52)+QCz*VRR0(36,80)-4.D0*r1x2E*ZxZpE*VRR1(36,52)+WQz*VRR1(36,80)
      VRR0(36,117)=4.D0*r1x2E*VRR0(36,53)+QCz*VRR0(36,81)-4.D0*r1x2E*ZxZpE*VRR1(36,53)+WQz*VRR1(36,81)
      VRR0(36,118)=5.D0*r1x2E*VRR0(36,54)+QCz*VRR0(36,82)-5.D0*r1x2E*ZxZpE*VRR1(36,54)+WQz*VRR1(36,82)
      VRR0(36,119)=5.D0*r1x2E*VRR0(36,55)+QCz*VRR0(36,83)-5.D0*r1x2E*ZxZpE*VRR1(36,55)+WQz*VRR1(36,83)
      VRR0(36,120)=6.D0*r1x2E*VRR0(36,56)+QCz*VRR0(36,84)-6.D0*r1x2E*ZxZpE*VRR1(36,56)+WQz*VRR1(36,84)
      VRR0(37,85)=6.D0*r1x2E*VRR0(37,36)+QCx*VRR0(37,57)+4.D0*HfxZpE*VRR1(22,57)-6.D0*r1x2E*ZxZpE*VRR1(37,36)+WQx*VRR1(37,57)
      VRR0(37,86)=5.D0*r1x2E*VRR0(37,37)+QCx*VRR0(37,58)+4.D0*HfxZpE*VRR1(22,58)-5.D0*r1x2E*ZxZpE*VRR1(37,37)+WQx*VRR1(37,58)
      VRR0(37,87)=4.D0*V(14)-4.D0*V(15)+QCx*VRR0(37,59)+4.D0*HfxZpE*VRR1(22,59)+WQx*VRR1(37,59)
      VRR0(37,88)=3.D0*V(16)+4.D0*V(17)-3.D0*V(18)+QCx*VRR0(37,60)+WQx*VRR1(37,60)
      VRR0(37,89)=V(1)+3.D0*V(14)-3.D0*V(15)+QCy*VRR0(37,60)+WQy*VRR1(37,60)
      VRR0(37,90)=V(2)+4.D0*V(16)-4.D0*V(18)+QCy*VRR0(37,61)+WQy*VRR1(37,61)
      VRR0(37,91)=5.D0*r1x2E*VRR0(37,40)+QCy*VRR0(37,62)+HfxZpE*VRR1(21,62)-5.D0*r1x2E*ZxZpE*VRR1(37,40)+WQy*VRR1(37,62)
      VRR0(37,92)=6.D0*r1x2E*VRR0(37,41)+QCy*VRR0(37,63)+HfxZpE*VRR1(21,63)-6.D0*r1x2E*ZxZpE*VRR1(37,41)+WQy*VRR1(37,63)
      VRR0(37,93)=5.D0*r1x2E*VRR0(37,42)+QCx*VRR0(37,64)+4.D0*HfxZpE*VRR1(22,64)-5.D0*r1x2E*ZxZpE*VRR1(37,42)+WQx*VRR1(37,64)
      VRR0(37,94)=4.D0*r1x2E*VRR0(37,43)+QCx*VRR0(37,65)+4.D0*HfxZpE*VRR1(22,65)-4.D0*r1x2E*ZxZpE*VRR1(37,43)+WQx*VRR1(37,65)
      VRR0(37,95)=V(20)+V(22)+QCx*VRR0(37,66)+4.D0*HfxZpE*VRR1(22,66)+WQx*VRR1(37,66)
      VRR0(37,96)=3.D0*V(23)+3.D0*r1x2Z*VRR0(12,96)+PAx*VRR0(22,96)-3.D0*ExZpE*r1x2Z*VRR1(12,96)+WPx*VRR1(22,96)
      VRR0(37,97)=V(3)+V(20)+V(22)+QCy*VRR0(37,67)+WQy*VRR1(37,67)
      VRR0(37,98)=V(4)+4.D0*r1x2E*VRR0(37,45)+QCy*VRR0(37,68)-4.D0*r1x2E*ZxZpE*VRR1(37,45)+WQy*VRR1(37,68)
      VRR0(37,99)=5.D0*r1x2E*VRR0(37,46)+QCy*VRR0(37,69)+HfxZpE*VRR1(21,69)-5.D0*r1x2E*ZxZpE*VRR1(37,46)+WQy*VRR1(37,69)
      VRR0(37,100)=4.D0*V(24)-4.D0*V(25)+QCx*VRR0(37,70)+4.D0*HfxZpE*VRR1(22,70)+WQx*VRR1(37,70)
      VRR0(37,101)=V(27)+V(29)+QCx*VRR0(37,71)+4.D0*HfxZpE*VRR1(22,71)+WQx*VRR1(37,71)
      VRR0(37,102)=3.D0*V(30)+3.D0*r1x2Z*VRR0(12,102)+PAx*VRR0(22,102)-3.D0*ExZpE*r1x2Z*VRR1(12,102)+WPx*VRR1(22,102)
      VRR0(37,103)=V(32)+3.D0*r1x2Z*VRR0(12,103)+PAx*VRR0(22,103)-3.D0*ExZpE*r1x2Z*VRR1(12,103)+WPx*VRR1(22,103)
      VRR0(37,104)=V(5)+V(34)+V(36)+QCy*VRR0(37,73)+WQy*VRR1(37,73)
      VRR0(37,105)=V(6)+4.D0*V(37)-4.D0*V(38)+QCy*VRR0(37,74)+WQy*VRR1(37,74)
      VRR0(37,106)=3.D0*V(39)+4.D0*V(40)-3.D0*V(41)+QCx*VRR0(37,75)+WQx*VRR1(37,75)
      VRR0(37,107)=3.D0*V(42)+3.D0*r1x2Z*VRR0(12,107)+PAx*VRR0(22,107)-3.D0*ExZpE*r1x2Z*VRR1(12,107)+WPx*VRR1(22,107)
      VRR0(37,108)=V(44)+3.D0*r1x2Z*VRR0(12,108)+PAx*VRR0(22,108)-3.D0*ExZpE*r1x2Z*VRR1(12,108)+WPx*VRR1(22,108)
      VRR0(37,109)=V(45)+3.D0*r1x2Z*VRR0(12,109)+PAx*VRR0(22,109)-3.D0*ExZpE*r1x2Z*VRR1(12,109)+WPx*VRR1(22,109)
      VRR0(37,110)=V(10)+3.D0*V(46)-3.D0*V(47)+QCy*VRR0(37,78)+WQy*VRR1(37,78)
      VRR0(37,111)=3.D0*V(24)-3.D0*V(25)+QCz*VRR0(37,75)+WQz*VRR1(37,75)
      VRR0(37,112)=V(27)+V(29)+QCz*VRR0(37,76)+WQz*VRR1(37,76)
      VRR0(37,113)=V(34)+V(36)+QCz*VRR0(37,77)+WQz*VRR1(37,77)
      VRR0(37,114)=3.D0*V(37)-3.D0*V(38)+QCz*VRR0(37,78)+WQz*VRR1(37,78)
      VRR0(37,115)=4.D0*V(39)-4.D0*V(41)+QCz*VRR0(37,79)+WQz*VRR1(37,79)
      VRR0(37,116)=4.D0*r1x2E*VRR0(37,52)+QCz*VRR0(37,80)-4.D0*r1x2E*ZxZpE*VRR1(37,52)+WQz*VRR1(37,80)
      VRR0(37,117)=4.D0*V(46)-4.D0*V(47)+QCz*VRR0(37,81)+WQz*VRR1(37,81)
      VRR0(37,118)=5.D0*r1x2E*VRR0(37,54)+QCz*VRR0(37,82)-5.D0*r1x2E*ZxZpE*VRR1(37,54)+WQz*VRR1(37,82)
      VRR0(37,119)=5.D0*r1x2E*VRR0(37,55)+QCz*VRR0(37,83)-5.D0*r1x2E*ZxZpE*VRR1(37,55)+WQz*VRR1(37,83)
      VRR0(37,120)=6.D0*r1x2E*VRR0(37,56)+QCz*VRR0(37,84)-6.D0*r1x2E*ZxZpE*VRR1(37,56)+WQz*VRR1(37,84)
      VRR0(38,85)=6.D0*r1x2E*VRR0(38,36)+QCx*VRR0(38,57)+3.D0*HfxZpE*VRR1(23,57)-6.D0*r1x2E*ZxZpE*VRR1(38,36)+WQx*VRR1(38,57)
      VRR0(38,86)=5.D0*r1x2E*VRR0(38,37)+QCx*VRR0(38,58)+3.D0*HfxZpE*VRR1(23,58)-5.D0*r1x2E*ZxZpE*VRR1(38,37)+WQx*VRR1(38,58)
      VRR0(38,87)=4.D0*V(48)-4.D0*V(49)+QCx*VRR0(38,59)+3.D0*HfxZpE*VRR1(23,59)+WQx*VRR1(38,59)
      VRR0(38,88)=3.D0*V(50)+V(52)-3.D0*V(53)+QCx*VRR0(38,60)+WQx*VRR1(38,60)
      VRR0(38,89)=2.D0*V(17)+3.D0*V(48)-3.D0*V(49)+QCy*VRR0(38,60)+WQy*VRR1(38,60)
      VRR0(38,90)=4.D0*V(50)-4.D0*V(53)+QCy*VRR0(38,61)+2.D0*HfxZpE*VRR1(22,61)+WQy*VRR1(38,61)
      VRR0(38,91)=5.D0*r1x2E*VRR0(38,40)+QCy*VRR0(38,62)+2.D0*HfxZpE*VRR1(22,62)-5.D0*r1x2E*ZxZpE*VRR1(38,40)+WQy*VRR1(38,62)
      VRR0(38,92)=6.D0*r1x2E*VRR0(38,41)+QCy*VRR0(38,63)+2.D0*HfxZpE*VRR1(22,63)-6.D0*r1x2E*ZxZpE*VRR1(38,41)+WQy*VRR1(38,63)
      VRR0(38,93)=5.D0*r1x2E*VRR0(38,42)+QCx*VRR0(38,64)+3.D0*HfxZpE*VRR1(23,64)-5.D0*r1x2E*ZxZpE*VRR1(38,42)+WQx*VRR1(38,64)
      VRR0(38,94)=4.D0*r1x2E*VRR0(38,43)+QCx*VRR0(38,65)+3.D0*HfxZpE*VRR1(23,65)-4.D0*r1x2E*ZxZpE*VRR1(38,43)+WQx*VRR1(38,65)
      VRR0(38,95)=V(55)+V(57)+QCx*VRR0(38,66)+3.D0*HfxZpE*VRR1(23,66)+WQx*VRR1(38,66)
      VRR0(38,96)=2.D0*V(58)+V(60)-2.D0*V(61)+QCx*VRR0(38,67)+WQx*VRR1(38,67)
      VRR0(38,97)=2.D0*V(23)+V(55)+V(57)+QCy*VRR0(38,67)+WQy*VRR1(38,67)
      VRR0(38,98)=4.D0*V(58)-4.D0*V(61)+QCy*VRR0(38,68)+2.D0*HfxZpE*VRR1(22,68)+WQy*VRR1(38,68)
      VRR0(38,99)=5.D0*r1x2E*VRR0(38,46)+QCy*VRR0(38,69)+2.D0*HfxZpE*VRR1(22,69)-5.D0*r1x2E*ZxZpE*VRR1(38,46)+WQy*VRR1(38,69)
      VRR0(38,100)=4.D0*V(62)-4.D0*V(63)+QCx*VRR0(38,70)+3.D0*HfxZpE*VRR1(23,70)+WQx*VRR1(38,70)
      VRR0(38,101)=V(65)+V(67)+QCx*VRR0(38,71)+3.D0*HfxZpE*VRR1(23,71)+WQx*VRR1(38,71)
      VRR0(38,102)=2.D0*V(68)+V(70)-2.D0*V(71)+QCx*VRR0(38,72)+WQx*VRR1(38,72)
      VRR0(38,103)=2.D0*V(30)+2.D0*V(64)-2.D0*V(66)+QCy*VRR0(38,72)+WQy*VRR1(38,72)
      VRR0(38,104)=V(32)+V(72)+V(73)+QCy*VRR0(38,73)+WQy*VRR1(38,73)
      VRR0(38,105)=4.D0*V(74)-4.D0*V(75)+QCy*VRR0(38,74)+2.D0*HfxZpE*VRR1(22,74)+WQy*VRR1(38,74)
      VRR0(38,106)=3.D0*V(76)+3.D0*V(77)-3.D0*V(78)+QCx*VRR0(38,75)+WQx*VRR1(38,75)
      VRR0(38,107)=V(80)+3.D0*V(81)+V(83)+QCx*VRR0(38,76)+WQx*VRR1(38,76)
      VRR0(38,108)=2.D0*V(54)-2.D0*V(56)+QCz*VRR0(38,72)+WQz*VRR1(38,72)
      VRR0(38,109)=V(44)+V(80)+V(83)+QCy*VRR0(38,77)+WQy*VRR1(38,77)
      VRR0(38,110)=2.D0*V(45)+3.D0*V(84)-3.D0*V(85)+QCy*VRR0(38,78)+WQy*VRR1(38,78)
      VRR0(38,111)=3.D0*V(62)-3.D0*V(63)+QCz*VRR0(38,75)+WQz*VRR1(38,75)
      VRR0(38,112)=V(65)+V(67)+QCz*VRR0(38,76)+WQz*VRR1(38,76)
      VRR0(38,113)=V(72)+V(73)+QCz*VRR0(38,77)+WQz*VRR1(38,77)
      VRR0(38,114)=3.D0*V(74)-3.D0*V(75)+QCz*VRR0(38,78)+WQz*VRR1(38,78)
      VRR0(38,115)=4.D0*V(76)-4.D0*V(78)+QCz*VRR0(38,79)+WQz*VRR1(38,79)
      VRR0(38,116)=4.D0*V(79)-4.D0*V(82)+QCz*VRR0(38,80)+WQz*VRR1(38,80)
      VRR0(38,117)=4.D0*V(84)-4.D0*V(85)+QCz*VRR0(38,81)+WQz*VRR1(38,81)
      VRR0(38,118)=5.D0*r1x2E*VRR0(38,54)+QCz*VRR0(38,82)-5.D0*r1x2E*ZxZpE*VRR1(38,54)+WQz*VRR1(38,82)
      VRR0(38,119)=5.D0*r1x2E*VRR0(38,55)+QCz*VRR0(38,83)-5.D0*r1x2E*ZxZpE*VRR1(38,55)+WQz*VRR1(38,83)
      VRR0(38,120)=6.D0*r1x2E*VRR0(38,56)+QCz*VRR0(38,84)-6.D0*r1x2E*ZxZpE*VRR1(38,56)+WQz*VRR1(38,84)
      VRR0(39,85)=6.D0*r1x2E*VRR0(39,36)+QCx*VRR0(39,57)+2.D0*HfxZpE*VRR1(24,57)-6.D0*r1x2E*ZxZpE*VRR1(39,36)+WQx*VRR1(39,57)
      VRR0(39,86)=5.D0*r1x2E*VRR0(39,37)+QCx*VRR0(39,58)+2.D0*HfxZpE*VRR1(24,58)-5.D0*r1x2E*ZxZpE*VRR1(39,37)+WQx*VRR1(39,58)
      VRR0(39,87)=4.D0*V(86)-4.D0*V(87)+QCx*VRR0(39,59)+2.D0*HfxZpE*VRR1(24,59)+WQx*VRR1(39,59)
      VRR0(39,88)=3.D0*V(88)+2.D0*V(89)-3.D0*V(90)+QCx*VRR0(39,60)+WQx*VRR1(39,60)
      VRR0(39,89)=V(52)+3.D0*V(86)-3.D0*V(87)+QCy*VRR0(39,60)+WQy*VRR1(39,60)
      VRR0(39,90)=4.D0*V(88)-4.D0*V(90)+QCy*VRR0(39,61)+3.D0*HfxZpE*VRR1(23,61)+WQy*VRR1(39,61)
      VRR0(39,91)=5.D0*r1x2E*VRR0(39,40)+QCy*VRR0(39,62)+3.D0*HfxZpE*VRR1(23,62)-5.D0*r1x2E*ZxZpE*VRR1(39,40)+WQy*VRR1(39,62)
      VRR0(39,92)=6.D0*r1x2E*VRR0(39,41)+QCy*VRR0(39,63)+3.D0*HfxZpE*VRR1(23,63)-6.D0*r1x2E*ZxZpE*VRR1(39,41)+WQy*VRR1(39,63)
      VRR0(39,93)=5.D0*r1x2E*VRR0(39,42)+QCx*VRR0(39,64)+2.D0*HfxZpE*VRR1(24,64)-5.D0*r1x2E*ZxZpE*VRR1(39,42)+WQx*VRR1(39,64)
      VRR0(39,94)=4.D0*r1x2E*VRR0(39,43)+QCx*VRR0(39,65)+2.D0*HfxZpE*VRR1(24,65)-4.D0*r1x2E*ZxZpE*VRR1(39,43)+WQx*VRR1(39,65)
      VRR0(39,95)=V(92)+2.D0*V(93)+V(95)+QCx*VRR0(39,66)+WQx*VRR1(39,66)
      VRR0(39,96)=2.D0*V(96)+2.D0*V(97)-2.D0*V(98)+QCx*VRR0(39,67)+WQx*VRR1(39,67)
      VRR0(39,97)=V(60)+V(92)+V(95)+QCy*VRR0(39,67)+WQy*VRR1(39,67)
      VRR0(39,98)=4.D0*V(96)-4.D0*V(98)+QCy*VRR0(39,68)+3.D0*HfxZpE*VRR1(23,68)+WQy*VRR1(39,68)
      VRR0(39,99)=5.D0*r1x2E*VRR0(39,46)+QCy*VRR0(39,69)+3.D0*HfxZpE*VRR1(23,69)-5.D0*r1x2E*ZxZpE*VRR1(39,46)+WQy*VRR1(39,69)
      VRR0(39,100)=4.D0*V(99)-4.D0*V(100)+QCx*VRR0(39,70)+2.D0*HfxZpE*VRR1(24,70)+WQx*VRR1(39,70)
      VRR0(39,101)=V(102)+V(104)+V(106)+QCx*VRR0(39,71)+WQx*VRR1(39,71)
      VRR0(39,102)=2.D0*V(107)+2.D0*V(108)-2.D0*V(109)+QCx*VRR0(39,72)+WQx*VRR1(39,72)
      VRR0(39,103)=V(70)+2.D0*V(101)-2.D0*V(105)+QCy*VRR0(39,72)+WQy*VRR1(39,72)
      VRR0(39,104)=V(110)+V(111)+QCy*VRR0(39,73)+3.D0*HfxZpE*VRR1(23,73)+WQy*VRR1(39,73)
      VRR0(39,105)=4.D0*V(112)-4.D0*V(113)+QCy*VRR0(39,74)+3.D0*HfxZpE*VRR1(23,74)+WQy*VRR1(39,74)
      VRR0(39,106)=3.D0*V(114)+2.D0*V(115)-3.D0*V(116)+QCx*VRR0(39,75)+WQx*VRR1(39,75)
      VRR0(39,107)=V(118)+V(120)+V(122)+QCx*VRR0(39,76)+WQx*VRR1(39,76)
      VRR0(39,108)=2.D0*V(91)-2.D0*V(94)+QCz*VRR0(39,72)+WQz*VRR1(39,72)
      VRR0(39,109)=V(118)+V(122)+3.D0*V(123)+QCy*VRR0(39,77)+WQy*VRR1(39,77)
      VRR0(39,110)=3.D0*V(124)+3.D0*V(125)-3.D0*V(126)+QCy*VRR0(39,78)+WQy*VRR1(39,78)
      VRR0(39,111)=3.D0*V(99)-3.D0*V(100)+QCz*VRR0(39,75)+WQz*VRR1(39,75)
      VRR0(39,112)=V(102)+V(106)+QCz*VRR0(39,76)+WQz*VRR1(39,76)
      VRR0(39,113)=V(110)+V(111)+QCz*VRR0(39,77)+WQz*VRR1(39,77)
      VRR0(39,114)=3.D0*V(112)-3.D0*V(113)+QCz*VRR0(39,78)+WQz*VRR1(39,78)
      VRR0(39,115)=4.D0*V(114)-4.D0*V(116)+QCz*VRR0(39,79)+WQz*VRR1(39,79)
      VRR0(39,116)=4.D0*V(117)-4.D0*V(121)+QCz*VRR0(39,80)+WQz*VRR1(39,80)
      VRR0(39,117)=4.D0*V(124)-4.D0*V(126)+QCz*VRR0(39,81)+WQz*VRR1(39,81)
      VRR0(39,118)=5.D0*r1x2E*VRR0(39,54)+QCz*VRR0(39,82)-5.D0*r1x2E*ZxZpE*VRR1(39,54)+WQz*VRR1(39,82)
      VRR0(39,119)=5.D0*r1x2E*VRR0(39,55)+QCz*VRR0(39,83)-5.D0*r1x2E*ZxZpE*VRR1(39,55)+WQz*VRR1(39,83)
      VRR0(39,120)=6.D0*r1x2E*VRR0(39,56)+QCz*VRR0(39,84)-6.D0*r1x2E*ZxZpE*VRR1(39,56)+WQz*VRR1(39,84)
      VRR0(40,85)=6.D0*r1x2E*VRR0(40,36)+QCx*VRR0(40,57)+HfxZpE*VRR1(25,57)-6.D0*r1x2E*ZxZpE*VRR1(40,36)+WQx*VRR1(40,57)
      VRR0(40,86)=5.D0*r1x2E*VRR0(40,37)+QCx*VRR0(40,58)+HfxZpE*VRR1(25,58)-5.D0*r1x2E*ZxZpE*VRR1(40,37)+WQx*VRR1(40,58)
      VRR0(40,87)=4.D0*V(127)+V(128)-4.D0*V(129)+QCx*VRR0(40,59)+WQx*VRR1(40,59)
      VRR0(40,88)=3.D0*V(130)+V(131)-3.D0*V(132)+QCx*VRR0(40,60)+WQx*VRR1(40,60)
      VRR0(40,89)=4.D0*V(89)+3.D0*V(127)-3.D0*V(129)+QCy*VRR0(40,60)+WQy*VRR1(40,60)
      VRR0(40,90)=4.D0*V(130)-4.D0*V(132)+QCy*VRR0(40,61)+4.D0*HfxZpE*VRR1(24,61)+WQy*VRR1(40,61)
      VRR0(40,91)=5.D0*r1x2E*VRR0(40,40)+QCy*VRR0(40,62)+4.D0*HfxZpE*VRR1(24,62)-5.D0*r1x2E*ZxZpE*VRR1(40,40)+WQy*VRR1(40,62)
      VRR0(40,92)=6.D0*r1x2E*VRR0(40,41)+QCy*VRR0(40,63)+4.D0*HfxZpE*VRR1(24,63)-6.D0*r1x2E*ZxZpE*VRR1(40,41)+WQy*VRR1(40,63)
      VRR0(40,93)=5.D0*r1x2E*VRR0(40,42)+QCx*VRR0(40,64)+HfxZpE*VRR1(25,64)-5.D0*r1x2E*ZxZpE*VRR1(40,42)+WQx*VRR1(40,64)
      VRR0(40,94)=V(133)+4.D0*r1x2E*VRR0(40,43)+QCx*VRR0(40,65)-4.D0*r1x2E*ZxZpE*VRR1(40,43)+WQx*VRR1(40,65)
      VRR0(40,95)=V(135)+V(136)+V(138)+QCx*VRR0(40,66)+WQx*VRR1(40,66)
      VRR0(40,96)=3.D0*V(93)+3.D0*r1x2Z*VRR0(13,96)+PAy*VRR0(24,96)-3.D0*ExZpE*r1x2Z*VRR1(13,96)+WPy*VRR1(24,96)
      VRR0(40,97)=4.D0*V(97)+V(135)+V(138)+QCy*VRR0(40,67)+WQy*VRR1(40,67)
      VRR0(40,98)=4.D0*r1x2E*VRR0(40,45)+QCy*VRR0(40,68)+4.D0*HfxZpE*VRR1(24,68)-4.D0*r1x2E*ZxZpE*VRR1(40,45)+WQy*VRR1(40,68)
      VRR0(40,99)=5.D0*r1x2E*VRR0(40,46)+QCy*VRR0(40,69)+4.D0*HfxZpE*VRR1(24,69)-5.D0*r1x2E*ZxZpE*VRR1(40,46)+WQy*VRR1(40,69)
      VRR0(40,100)=4.D0*V(139)+V(140)-4.D0*V(141)+QCx*VRR0(40,70)+WQx*VRR1(40,70)
      VRR0(40,101)=V(143)+V(144)+V(146)+QCx*VRR0(40,71)+WQx*VRR1(40,71)
      VRR0(40,102)=V(104)+3.D0*r1x2Z*VRR0(13,102)+PAy*VRR0(24,102)-3.D0*ExZpE*r1x2Z*VRR1(13,102)+WPy*VRR1(24,102)
      VRR0(40,103)=3.D0*V(108)+3.D0*r1x2Z*VRR0(13,103)+PAy*VRR0(24,103)-3.D0*ExZpE*r1x2Z*VRR1(13,103)+WPy*VRR1(24,103)
      VRR0(40,104)=V(148)+V(150)+QCy*VRR0(40,73)+4.D0*HfxZpE*VRR1(24,73)+WQy*VRR1(40,73)
      VRR0(40,105)=4.D0*V(151)-4.D0*V(152)+QCy*VRR0(40,74)+4.D0*HfxZpE*VRR1(24,74)+WQy*VRR1(40,74)
      VRR0(40,106)=3.D0*V(153)+V(154)-3.D0*V(155)+QCx*VRR0(40,75)+WQx*VRR1(40,75)
      VRR0(40,107)=V(115)+3.D0*r1x2Z*VRR0(13,107)+PAy*VRR0(24,107)-3.D0*ExZpE*r1x2Z*VRR1(13,107)+WPy*VRR1(24,107)
      VRR0(40,108)=V(120)+3.D0*r1x2Z*VRR0(13,108)+PAy*VRR0(24,108)-3.D0*ExZpE*r1x2Z*VRR1(13,108)+WPy*VRR1(24,108)
      VRR0(40,109)=3.D0*V(156)+3.D0*r1x2Z*VRR0(13,109)+PAy*VRR0(24,109)-3.D0*ExZpE*r1x2Z*VRR1(13,109)+WPy*VRR1(24,109)
      VRR0(40,110)=3.D0*V(157)+4.D0*V(158)-3.D0*V(159)+QCy*VRR0(40,78)+WQy*VRR1(40,78)
      VRR0(40,111)=3.D0*V(139)-3.D0*V(141)+QCz*VRR0(40,75)+WQz*VRR1(40,75)
      VRR0(40,112)=V(143)+V(146)+QCz*VRR0(40,76)+WQz*VRR1(40,76)
      VRR0(40,113)=V(148)+V(150)+QCz*VRR0(40,77)+WQz*VRR1(40,77)
      VRR0(40,114)=3.D0*V(151)-3.D0*V(152)+QCz*VRR0(40,78)+WQz*VRR1(40,78)
      VRR0(40,115)=4.D0*V(153)-4.D0*V(155)+QCz*VRR0(40,79)+WQz*VRR1(40,79)
      VRR0(40,116)=4.D0*r1x2E*VRR0(40,52)+QCz*VRR0(40,80)-4.D0*r1x2E*ZxZpE*VRR1(40,52)+WQz*VRR1(40,80)
      VRR0(40,117)=4.D0*V(157)-4.D0*V(159)+QCz*VRR0(40,81)+WQz*VRR1(40,81)
      VRR0(40,118)=5.D0*r1x2E*VRR0(40,54)+QCz*VRR0(40,82)-5.D0*r1x2E*ZxZpE*VRR1(40,54)+WQz*VRR1(40,82)
      VRR0(40,119)=5.D0*r1x2E*VRR0(40,55)+QCz*VRR0(40,83)-5.D0*r1x2E*ZxZpE*VRR1(40,55)+WQz*VRR1(40,83)
      VRR0(40,120)=6.D0*r1x2E*VRR0(40,56)+QCz*VRR0(40,84)-6.D0*r1x2E*ZxZpE*VRR1(40,56)+WQz*VRR1(40,84)
      VRR0(41,85)=6.D0*r1x2E*VRR0(41,36)+QCx*VRR0(41,57)-6.D0*r1x2E*ZxZpE*VRR1(41,36)+WQx*VRR1(41,57)
      VRR0(41,86)=5.D0*r1x2E*VRR0(41,37)+QCx*VRR0(41,58)-5.D0*r1x2E*ZxZpE*VRR1(41,37)+WQx*VRR1(41,58)
      VRR0(41,87)=4.D0*r1x2E*VRR0(41,38)+QCx*VRR0(41,59)-4.D0*r1x2E*ZxZpE*VRR1(41,38)+WQx*VRR1(41,59)
      VRR0(41,88)=3.D0*V(128)+4.D0*r1x2Z*VRR0(14,88)+PAy*VRR0(25,88)-4.D0*ExZpE*r1x2Z*VRR1(14,88)+WPy*VRR1(25,88)
      VRR0(41,89)=4.D0*V(131)+4.D0*r1x2Z*VRR0(14,89)+PAy*VRR0(25,89)-4.D0*ExZpE*r1x2Z*VRR1(14,89)+WPy*VRR1(25,89)
      VRR0(41,90)=4.D0*r1x2E*VRR0(41,39)+QCy*VRR0(41,61)+5.D0*HfxZpE*VRR1(25,61)-4.D0*r1x2E*ZxZpE*VRR1(41,39)+WQy*VRR1(41,61)
      VRR0(41,91)=5.D0*r1x2E*VRR0(41,40)+QCy*VRR0(41,62)+5.D0*HfxZpE*VRR1(25,62)-5.D0*r1x2E*ZxZpE*VRR1(41,40)+WQy*VRR1(41,62)
      VRR0(41,92)=6.D0*r1x2E*VRR0(41,41)+QCy*VRR0(41,63)+5.D0*HfxZpE*VRR1(25,63)-6.D0*r1x2E*ZxZpE*VRR1(41,41)+WQy*VRR1(41,63)
      VRR0(41,93)=5.D0*r1x2E*VRR0(41,42)+QCx*VRR0(41,64)-5.D0*r1x2E*ZxZpE*VRR1(41,42)+WQx*VRR1(41,64)
      VRR0(41,94)=4.D0*r1x2E*VRR0(41,43)+QCx*VRR0(41,65)-4.D0*r1x2E*ZxZpE*VRR1(41,43)+WQx*VRR1(41,65)
      VRR0(41,95)=2.D0*V(133)+4.D0*r1x2Z*VRR0(14,95)+PAy*VRR0(25,95)-4.D0*ExZpE*r1x2Z*VRR1(14,95)+WPy*VRR1(25,95)
      VRR0(41,96)=3.D0*V(136)+4.D0*r1x2Z*VRR0(14,96)+PAy*VRR0(25,96)-4.D0*ExZpE*r1x2Z*VRR1(14,96)+WPy*VRR1(25,96)
      VRR0(41,97)=4.D0*r1x2Z*VRR0(14,97)+PAy*VRR0(25,97)-4.D0*ExZpE*r1x2Z*VRR1(14,97)+4.D0*HfxZpE*VRR1(25,67)+WPy*VRR1(25,97)
      VRR0(41,98)=4.D0*r1x2E*VRR0(41,45)+QCy*VRR0(41,68)+5.D0*HfxZpE*VRR1(25,68)-4.D0*r1x2E*ZxZpE*VRR1(41,45)+WQy*VRR1(41,68)
      VRR0(41,99)=5.D0*r1x2E*VRR0(41,46)+QCy*VRR0(41,69)+5.D0*HfxZpE*VRR1(25,69)-5.D0*r1x2E*ZxZpE*VRR1(41,46)+WQy*VRR1(41,69)
      VRR0(41,100)=4.D0*r1x2E*VRR0(41,47)+QCx*VRR0(41,70)-4.D0*r1x2E*ZxZpE*VRR1(41,47)+WQx*VRR1(41,70)
      VRR0(41,101)=V(140)+4.D0*r1x2Z*VRR0(14,101)+PAy*VRR0(25,101)-4.D0*ExZpE*r1x2Z*VRR1(14,101)+WPy*VRR1(25,101)
      VRR0(41,102)=2.D0*V(144)+4.D0*r1x2Z*VRR0(14,102)+PAy*VRR0(25,102)-4.D0*ExZpE*r1x2Z*VRR1(14,102)+WPy*VRR1(25,102)
      VRR0(41,103)=4.D0*r1x2Z*VRR0(14,103)+PAy*VRR0(25,103)-4.D0*ExZpE*r1x2Z*VRR1(14,103)+3.D0*HfxZpE*VRR1(25,72)+WPy*VRR1(25,103)
      VRR0(41,104)=4.D0*r1x2Z*VRR0(14,104)+PAy*VRR0(25,104)-4.D0*ExZpE*r1x2Z*VRR1(14,104)+4.D0*HfxZpE*VRR1(25,73)+WPy*VRR1(25,104)
      VRR0(41,105)=4.D0*r1x2E*VRR0(41,50)+QCy*VRR0(41,74)+5.D0*HfxZpE*VRR1(25,74)-4.D0*r1x2E*ZxZpE*VRR1(41,50)+WQy*VRR1(41,74)
      VRR0(41,106)=4.D0*r1x2Z*VRR0(14,106)+PAy*VRR0(25,106)-4.D0*ExZpE*r1x2Z*VRR1(14,106)+WPy*VRR1(25,106)
      VRR0(41,107)=V(154)+4.D0*r1x2Z*VRR0(14,107)+PAy*VRR0(25,107)-4.D0*ExZpE*r1x2Z*VRR1(14,107)+WPy*VRR1(25,107)
      VRR0(41,108)=2.D0*V(160)+4.D0*r1x2Z*VRR0(14,108)+PAy*VRR0(25,108)-4.D0*ExZpE*r1x2Z*VRR1(14,108)+WPy*VRR1(25,108)
      VRR0(41,109)=3.D0*V(161)+4.D0*r1x2Z*VRR0(14,109)+PAy*VRR0(25,109)-4.D0*ExZpE*r1x2Z*VRR1(14,109)+WPy*VRR1(25,109)
      VRR0(41,110)=4.D0*V(162)+4.D0*r1x2Z*VRR0(14,110)+PAy*VRR0(25,110)-4.D0*ExZpE*r1x2Z*VRR1(14,110)+WPy*VRR1(25,110)
      VRR0(41,111)=4.D0*r1x2Z*VRR0(14,111)+PAy*VRR0(25,111)-4.D0*ExZpE*r1x2Z*VRR1(14,111)+WPy*VRR1(25,111)
      VRR0(41,112)=V(163)+4.D0*r1x2Z*VRR0(14,112)+PAy*VRR0(25,112)-4.D0*ExZpE*r1x2Z*VRR1(14,112)+WPy*VRR1(25,112)
      VRR0(41,113)=2.D0*V(164)+4.D0*r1x2Z*VRR0(14,113)+PAy*VRR0(25,113)-4.D0*ExZpE*r1x2Z*VRR1(14,113)+WPy*VRR1(25,113)
      VRR0(41,114)=3.D0*V(165)+4.D0*r1x2Z*VRR0(14,114)+PAy*VRR0(25,114)-4.D0*ExZpE*r1x2Z*VRR1(14,114)+WPy*VRR1(25,114)
      VRR0(41,115)=4.D0*r1x2E*VRR0(41,51)+QCz*VRR0(41,79)-4.D0*r1x2E*ZxZpE*VRR1(41,51)+WQz*VRR1(41,79)
      VRR0(41,116)=4.D0*r1x2E*VRR0(41,52)+QCz*VRR0(41,80)-4.D0*r1x2E*ZxZpE*VRR1(41,52)+WQz*VRR1(41,80)
      VRR0(41,117)=4.D0*r1x2E*VRR0(41,53)+QCz*VRR0(41,81)-4.D0*r1x2E*ZxZpE*VRR1(41,53)+WQz*VRR1(41,81)
      VRR0(41,118)=5.D0*r1x2E*VRR0(41,54)+QCz*VRR0(41,82)-5.D0*r1x2E*ZxZpE*VRR1(41,54)+WQz*VRR1(41,82)
      VRR0(41,119)=5.D0*r1x2E*VRR0(41,55)+QCz*VRR0(41,83)-5.D0*r1x2E*ZxZpE*VRR1(41,55)+WQz*VRR1(41,83)
      VRR0(41,120)=6.D0*r1x2E*VRR0(41,56)+QCz*VRR0(41,84)-6.D0*r1x2E*ZxZpE*VRR1(41,56)+WQz*VRR1(41,84)
      VRR0(42,85)=6.D0*r1x2E*VRR0(42,36)+QCx*VRR0(42,57)+4.D0*HfxZpE*VRR1(26,57)-6.D0*r1x2E*ZxZpE*VRR1(42,36)+WQx*VRR1(42,57)
      VRR0(42,86)=5.D0*r1x2E*VRR0(42,37)+QCx*VRR0(42,58)+4.D0*HfxZpE*VRR1(26,58)-5.D0*r1x2E*ZxZpE*VRR1(42,37)+WQx*VRR1(42,58)
      VRR0(42,87)=4.D0*V(166)-4.D0*V(167)+QCx*VRR0(42,59)+4.D0*HfxZpE*VRR1(26,59)+WQx*VRR1(42,59)
      VRR0(42,88)=3.D0*V(168)+4.D0*V(169)-3.D0*V(170)+QCx*VRR0(42,60)+WQx*VRR1(42,60)
      VRR0(42,89)=3.D0*V(166)-3.D0*V(167)+QCy*VRR0(42,60)+WQy*VRR1(42,60)
      VRR0(42,90)=4.D0*V(168)-4.D0*V(170)+QCy*VRR0(42,61)+WQy*VRR1(42,61)
      VRR0(42,91)=5.D0*r1x2E*VRR0(42,40)+QCy*VRR0(42,62)-5.D0*r1x2E*ZxZpE*VRR1(42,40)+WQy*VRR1(42,62)
      VRR0(42,92)=6.D0*r1x2E*VRR0(42,41)+QCy*VRR0(42,63)-6.D0*r1x2E*ZxZpE*VRR1(42,41)+WQy*VRR1(42,63)
      VRR0(42,93)=5.D0*r1x2E*VRR0(42,42)+QCx*VRR0(42,64)+4.D0*HfxZpE*VRR1(26,64)-5.D0*r1x2E*ZxZpE*VRR1(42,42)+WQx*VRR1(42,64)
      VRR0(42,94)=4.D0*r1x2E*VRR0(42,43)+QCx*VRR0(42,65)+4.D0*HfxZpE*VRR1(26,65)-4.D0*r1x2E*ZxZpE*VRR1(42,43)+WQx*VRR1(42,65)
      VRR0(42,95)=V(172)+V(174)+QCx*VRR0(42,66)+4.D0*HfxZpE*VRR1(26,66)+WQx*VRR1(42,66)
      VRR0(42,96)=3.D0*V(175)+3.D0*r1x2Z*VRR0(15,96)+PAx*VRR0(26,96)-3.D0*ExZpE*r1x2Z*VRR1(15,96)+WPx*VRR1(26,96)
      VRR0(42,97)=V(172)+V(174)+QCy*VRR0(42,67)+WQy*VRR1(42,67)
      VRR0(42,98)=4.D0*r1x2E*VRR0(42,45)+QCy*VRR0(42,68)-4.D0*r1x2E*ZxZpE*VRR1(42,45)+WQy*VRR1(42,68)
      VRR0(42,99)=5.D0*r1x2E*VRR0(42,46)+QCy*VRR0(42,69)-5.D0*r1x2E*ZxZpE*VRR1(42,46)+WQy*VRR1(42,69)
      VRR0(42,100)=4.D0*V(176)-4.D0*V(177)+QCx*VRR0(42,70)+4.D0*HfxZpE*VRR1(26,70)+WQx*VRR1(42,70)
      VRR0(42,101)=V(179)+V(181)+QCx*VRR0(42,71)+4.D0*HfxZpE*VRR1(26,71)+WQx*VRR1(42,71)
      VRR0(42,102)=3.D0*V(182)+3.D0*r1x2Z*VRR0(15,102)+PAx*VRR0(26,102)-3.D0*ExZpE*r1x2Z*VRR1(15,102)+WPx*VRR1(26,102)
      VRR0(42,103)=2.D0*V(183)+3.D0*r1x2Z*VRR0(15,103)+PAx*VRR0(26,103)-3.D0*ExZpE*r1x2Z*VRR1(15,103)+WPx*VRR1(26,103)
      VRR0(42,104)=V(185)+V(187)+QCy*VRR0(42,73)+WQy*VRR1(42,73)
      VRR0(42,105)=4.D0*V(188)-4.D0*V(189)+QCy*VRR0(42,74)+WQy*VRR1(42,74)
      VRR0(42,106)=3.D0*V(190)+4.D0*V(191)-3.D0*V(192)+QCx*VRR0(42,75)+WQx*VRR1(42,75)
      VRR0(42,107)=3.D0*V(193)+3.D0*r1x2Z*VRR0(15,107)+PAx*VRR0(26,107)-3.D0*ExZpE*r1x2Z*VRR1(15,107)+WPx*VRR1(26,107)
      VRR0(42,108)=V(195)+3.D0*r1x2Z*VRR0(15,108)+PAx*VRR0(26,108)-3.D0*ExZpE*r1x2Z*VRR1(15,108)+WPx*VRR1(26,108)
      VRR0(42,109)=V(196)+3.D0*r1x2Z*VRR0(15,109)+PAx*VRR0(26,109)-3.D0*ExZpE*r1x2Z*VRR1(15,109)+WPx*VRR1(26,109)
      VRR0(42,110)=3.D0*V(197)-3.D0*V(198)+QCy*VRR0(42,78)+WQy*VRR1(42,78)
      VRR0(42,111)=V(7)+3.D0*V(176)-3.D0*V(177)+QCz*VRR0(42,75)+WQz*VRR1(42,75)
      VRR0(42,112)=V(8)+V(179)+V(181)+QCz*VRR0(42,76)+WQz*VRR1(42,76)
      VRR0(42,113)=V(9)+V(185)+V(187)+QCz*VRR0(42,77)+WQz*VRR1(42,77)
      VRR0(42,114)=V(10)+3.D0*V(188)-3.D0*V(189)+QCz*VRR0(42,78)+WQz*VRR1(42,78)
      VRR0(42,115)=V(11)+4.D0*V(190)-4.D0*V(192)+QCz*VRR0(42,79)+WQz*VRR1(42,79)
      VRR0(42,116)=V(12)+4.D0*r1x2E*VRR0(42,52)+QCz*VRR0(42,80)-4.D0*r1x2E*ZxZpE*VRR1(42,52)+WQz*VRR1(42,80)
      VRR0(42,117)=V(13)+4.D0*V(197)-4.D0*V(198)+QCz*VRR0(42,81)+WQz*VRR1(42,81)
      VRR0(42,118)=5.D0*r1x2E*VRR0(42,54)+QCz*VRR0(42,82)+HfxZpE*VRR1(21,82)-5.D0*r1x2E*ZxZpE*VRR1(42,54)+WQz*VRR1(42,82)
      VRR0(42,119)=5.D0*r1x2E*VRR0(42,55)+QCz*VRR0(42,83)+HfxZpE*VRR1(21,83)-5.D0*r1x2E*ZxZpE*VRR1(42,55)+WQz*VRR1(42,83)
      VRR0(42,120)=6.D0*r1x2E*VRR0(42,56)+QCz*VRR0(42,84)+HfxZpE*VRR1(21,84)-6.D0*r1x2E*ZxZpE*VRR1(42,56)+WQz*VRR1(42,84)
      VRR0(43,85)=6.D0*r1x2E*VRR0(43,36)+QCx*VRR0(43,57)+3.D0*HfxZpE*VRR1(27,57)-6.D0*r1x2E*ZxZpE*VRR1(43,36)+WQx*VRR1(43,57)
      VRR0(43,86)=5.D0*r1x2E*VRR0(43,37)+QCx*VRR0(43,58)+3.D0*HfxZpE*VRR1(27,58)-5.D0*r1x2E*ZxZpE*VRR1(43,37)+WQx*VRR1(43,58)
      VRR0(43,87)=4.D0*V(199)-4.D0*V(200)+QCx*VRR0(43,59)+3.D0*HfxZpE*VRR1(27,59)+WQx*VRR1(43,59)
      VRR0(43,88)=3.D0*V(201)+3.D0*V(202)-3.D0*V(203)+QCx*VRR0(43,60)+WQx*VRR1(43,60)
      VRR0(43,89)=V(169)+3.D0*V(199)-3.D0*V(200)+QCy*VRR0(43,60)+WQy*VRR1(43,60)
      VRR0(43,90)=4.D0*V(201)-4.D0*V(203)+QCy*VRR0(43,61)+HfxZpE*VRR1(26,61)+WQy*VRR1(43,61)
      VRR0(43,91)=5.D0*r1x2E*VRR0(43,40)+QCy*VRR0(43,62)+HfxZpE*VRR1(26,62)-5.D0*r1x2E*ZxZpE*VRR1(43,40)+WQy*VRR1(43,62)
      VRR0(43,92)=6.D0*r1x2E*VRR0(43,41)+QCy*VRR0(43,63)+HfxZpE*VRR1(26,63)-6.D0*r1x2E*ZxZpE*VRR1(43,41)+WQy*VRR1(43,63)
      VRR0(43,93)=5.D0*r1x2E*VRR0(43,42)+QCx*VRR0(43,64)+3.D0*HfxZpE*VRR1(27,64)-5.D0*r1x2E*ZxZpE*VRR1(43,42)+WQx*VRR1(43,64)
      VRR0(43,94)=4.D0*r1x2E*VRR0(43,43)+QCx*VRR0(43,65)+3.D0*HfxZpE*VRR1(27,65)-4.D0*r1x2E*ZxZpE*VRR1(43,43)+WQx*VRR1(43,65)
      VRR0(43,95)=V(205)+V(207)+QCx*VRR0(43,66)+3.D0*HfxZpE*VRR1(27,66)+WQx*VRR1(43,66)
      VRR0(43,96)=2.D0*V(208)+3.D0*V(209)-2.D0*V(210)+QCx*VRR0(43,67)+WQx*VRR1(43,67)
      VRR0(43,97)=V(175)+V(205)+V(207)+QCy*VRR0(43,67)+WQy*VRR1(43,67)
      VRR0(43,98)=4.D0*V(208)-4.D0*V(210)+QCy*VRR0(43,68)+HfxZpE*VRR1(26,68)+WQy*VRR1(43,68)
      VRR0(43,99)=5.D0*r1x2E*VRR0(43,46)+QCy*VRR0(43,69)+HfxZpE*VRR1(26,69)-5.D0*r1x2E*ZxZpE*VRR1(43,46)+WQy*VRR1(43,69)
      VRR0(43,100)=4.D0*V(211)-4.D0*V(212)+QCx*VRR0(43,70)+3.D0*HfxZpE*VRR1(27,70)+WQx*VRR1(43,70)
      VRR0(43,101)=V(214)+V(216)+QCx*VRR0(43,71)+3.D0*HfxZpE*VRR1(27,71)+WQx*VRR1(43,71)
      VRR0(43,102)=2.D0*V(217)+3.D0*V(218)-2.D0*V(219)+QCx*VRR0(43,72)+WQx*VRR1(43,72)
      VRR0(43,103)=V(182)+2.D0*V(213)-2.D0*V(215)+QCy*VRR0(43,72)+WQy*VRR1(43,72)
      VRR0(43,104)=V(183)+V(220)+V(221)+QCy*VRR0(43,73)+WQy*VRR1(43,73)
      VRR0(43,105)=4.D0*V(222)-4.D0*V(223)+QCy*VRR0(43,74)+HfxZpE*VRR1(26,74)+WQy*VRR1(43,74)
      VRR0(43,106)=3.D0*V(224)+3.D0*V(225)-3.D0*V(226)+QCx*VRR0(43,75)+WQx*VRR1(43,75)
      VRR0(43,107)=V(228)+3.D0*V(229)+V(231)+QCx*VRR0(43,76)+WQx*VRR1(43,76)
      VRR0(43,108)=V(30)+2.D0*V(204)-2.D0*V(206)+QCz*VRR0(43,72)+WQz*VRR1(43,72)
      VRR0(43,109)=V(194)+V(228)+V(231)+QCy*VRR0(43,77)+WQy*VRR1(43,77)
      VRR0(43,110)=V(196)+3.D0*V(232)-3.D0*V(233)+QCy*VRR0(43,78)+WQy*VRR1(43,78)
      VRR0(43,111)=V(40)+3.D0*V(211)-3.D0*V(212)+QCz*VRR0(43,75)+WQz*VRR1(43,75)
      VRR0(43,112)=V(42)+V(214)+V(216)+QCz*VRR0(43,76)+WQz*VRR1(43,76)
      VRR0(43,113)=V(43)+V(220)+V(221)+QCz*VRR0(43,77)+WQz*VRR1(43,77)
      VRR0(43,114)=V(45)+3.D0*V(222)-3.D0*V(223)+QCz*VRR0(43,78)+WQz*VRR1(43,78)
      VRR0(43,115)=4.D0*V(224)-4.D0*V(226)+QCz*VRR0(43,79)+HfxZpE*VRR1(22,79)+WQz*VRR1(43,79)
      VRR0(43,116)=4.D0*V(227)-4.D0*V(230)+QCz*VRR0(43,80)+HfxZpE*VRR1(22,80)+WQz*VRR1(43,80)
      VRR0(43,117)=4.D0*V(232)-4.D0*V(233)+QCz*VRR0(43,81)+HfxZpE*VRR1(22,81)+WQz*VRR1(43,81)
      VRR0(43,118)=5.D0*r1x2E*VRR0(43,54)+QCz*VRR0(43,82)+HfxZpE*VRR1(22,82)-5.D0*r1x2E*ZxZpE*VRR1(43,54)+WQz*VRR1(43,82)
      VRR0(43,119)=5.D0*r1x2E*VRR0(43,55)+QCz*VRR0(43,83)+HfxZpE*VRR1(22,83)-5.D0*r1x2E*ZxZpE*VRR1(43,55)+WQz*VRR1(43,83)
      VRR0(43,120)=6.D0*r1x2E*VRR0(43,56)+QCz*VRR0(43,84)+HfxZpE*VRR1(22,84)-6.D0*r1x2E*ZxZpE*VRR1(43,56)+WQz*VRR1(43,84)
      VRR0(44,85)=6.D0*r1x2E*VRR0(44,36)+QCx*VRR0(44,57)+2.D0*HfxZpE*VRR1(28,57)-6.D0*r1x2E*ZxZpE*VRR1(44,36)+WQx*VRR1(44,57)
      VRR0(44,86)=5.D0*r1x2E*VRR0(44,37)+QCx*VRR0(44,58)+2.D0*HfxZpE*VRR1(28,58)-5.D0*r1x2E*ZxZpE*VRR1(44,37)+WQx*VRR1(44,58)
      VRR0(44,87)=4.D0*V(234)-4.D0*V(235)+QCx*VRR0(44,59)+2.D0*HfxZpE*VRR1(28,59)+WQx*VRR1(44,59)
      VRR0(44,88)=3.D0*V(236)+2.D0*V(237)-3.D0*V(238)+QCx*VRR0(44,60)+WQx*VRR1(44,60)
      VRR0(44,89)=2.D0*V(202)+3.D0*V(234)-3.D0*V(235)+QCy*VRR0(44,60)+WQy*VRR1(44,60)
      VRR0(44,90)=4.D0*V(236)-4.D0*V(238)+QCy*VRR0(44,61)+2.D0*HfxZpE*VRR1(27,61)+WQy*VRR1(44,61)
      VRR0(44,91)=5.D0*r1x2E*VRR0(44,40)+QCy*VRR0(44,62)+2.D0*HfxZpE*VRR1(27,62)-5.D0*r1x2E*ZxZpE*VRR1(44,40)+WQy*VRR1(44,62)
      VRR0(44,92)=6.D0*r1x2E*VRR0(44,41)+QCy*VRR0(44,63)+2.D0*HfxZpE*VRR1(27,63)-6.D0*r1x2E*ZxZpE*VRR1(44,41)+WQy*VRR1(44,63)
      VRR0(44,93)=5.D0*r1x2E*VRR0(44,42)+QCx*VRR0(44,64)+2.D0*HfxZpE*VRR1(28,64)-5.D0*r1x2E*ZxZpE*VRR1(44,42)+WQx*VRR1(44,64)
      VRR0(44,94)=4.D0*r1x2E*VRR0(44,43)+QCx*VRR0(44,65)+2.D0*HfxZpE*VRR1(28,65)-4.D0*r1x2E*ZxZpE*VRR1(44,43)+WQx*VRR1(44,65)
      VRR0(44,95)=V(240)+V(242)+QCx*VRR0(44,66)+2.D0*HfxZpE*VRR1(28,66)+WQx*VRR1(44,66)
      VRR0(44,96)=2.D0*V(243)+2.D0*V(244)-2.D0*V(245)+QCx*VRR0(44,67)+WQx*VRR1(44,67)
      VRR0(44,97)=2.D0*V(209)+V(240)+V(242)+QCy*VRR0(44,67)+WQy*VRR1(44,67)
      VRR0(44,98)=4.D0*V(243)-4.D0*V(245)+QCy*VRR0(44,68)+2.D0*HfxZpE*VRR1(27,68)+WQy*VRR1(44,68)
      VRR0(44,99)=5.D0*r1x2E*VRR0(44,46)+QCy*VRR0(44,69)+2.D0*HfxZpE*VRR1(27,69)-5.D0*r1x2E*ZxZpE*VRR1(44,46)+WQy*VRR1(44,69)
      VRR0(44,100)=4.D0*V(246)-4.D0*V(247)+QCx*VRR0(44,70)+2.D0*HfxZpE*VRR1(28,70)+WQx*VRR1(44,70)
      VRR0(44,101)=V(249)+V(251)+QCx*VRR0(44,71)+2.D0*HfxZpE*VRR1(28,71)+WQx*VRR1(44,71)
      VRR0(44,102)=2.D0*V(252)+V(254)-2.D0*V(255)+QCx*VRR0(44,72)+WQx*VRR1(44,72)
      VRR0(44,103)=2.D0*V(248)-2.D0*V(250)+V(256)+QCy*VRR0(44,72)+WQy*VRR1(44,72)
      VRR0(44,104)=V(257)+V(258)+QCy*VRR0(44,73)+2.D0*HfxZpE*VRR1(27,73)+WQy*VRR1(44,73)
      VRR0(44,105)=4.D0*V(259)-4.D0*V(260)+QCy*VRR0(44,74)+2.D0*HfxZpE*VRR1(27,74)+WQy*VRR1(44,74)
      VRR0(44,106)=3.D0*V(261)+V(263)-3.D0*V(264)+QCx*VRR0(44,75)+WQx*VRR1(44,75)
      VRR0(44,107)=V(266)+V(268)+V(270)+QCx*VRR0(44,76)+WQx*VRR1(44,76)
      VRR0(44,108)=V(69)+2.D0*V(239)-2.D0*V(241)+QCz*VRR0(44,72)+WQz*VRR1(44,72)
      VRR0(44,109)=V(266)+V(270)+V(272)+QCy*VRR0(44,77)+WQy*VRR1(44,77)
      VRR0(44,110)=3.D0*V(273)+V(275)-3.D0*V(276)+QCy*VRR0(44,78)+WQy*VRR1(44,78)
      VRR0(44,111)=V(77)+3.D0*V(246)-3.D0*V(247)+QCz*VRR0(44,75)+WQz*VRR1(44,75)
      VRR0(44,112)=V(81)+V(249)+V(251)+QCz*VRR0(44,76)+WQz*VRR1(44,76)
      VRR0(44,113)=V(123)+V(257)+V(258)+QCz*VRR0(44,77)+WQz*VRR1(44,77)
      VRR0(44,114)=V(125)+3.D0*V(259)-3.D0*V(260)+QCz*VRR0(44,78)+WQz*VRR1(44,78)
      VRR0(44,115)=4.D0*V(261)-4.D0*V(264)+QCz*VRR0(44,79)+HfxZpE*VRR1(23,79)+WQz*VRR1(44,79)
      VRR0(44,116)=4.D0*V(265)-4.D0*V(269)+QCz*VRR0(44,80)+HfxZpE*VRR1(23,80)+WQz*VRR1(44,80)
      VRR0(44,117)=4.D0*V(273)-4.D0*V(276)+QCz*VRR0(44,81)+HfxZpE*VRR1(23,81)+WQz*VRR1(44,81)
      VRR0(44,118)=5.D0*r1x2E*VRR0(44,54)+QCz*VRR0(44,82)+HfxZpE*VRR1(23,82)-5.D0*r1x2E*ZxZpE*VRR1(44,54)+WQz*VRR1(44,82)
      VRR0(44,119)=5.D0*r1x2E*VRR0(44,55)+QCz*VRR0(44,83)+HfxZpE*VRR1(23,83)-5.D0*r1x2E*ZxZpE*VRR1(44,55)+WQz*VRR1(44,83)
      VRR0(44,120)=6.D0*r1x2E*VRR0(44,56)+QCz*VRR0(44,84)+HfxZpE*VRR1(23,84)-6.D0*r1x2E*ZxZpE*VRR1(44,56)+WQz*VRR1(44,84)
      VRR0(45,85)=6.D0*r1x2E*VRR0(45,36)+QCx*VRR0(45,57)+HfxZpE*VRR1(29,57)-6.D0*r1x2E*ZxZpE*VRR1(45,36)+WQx*VRR1(45,57)
      VRR0(45,86)=5.D0*r1x2E*VRR0(45,37)+QCx*VRR0(45,58)+HfxZpE*VRR1(29,58)-5.D0*r1x2E*ZxZpE*VRR1(45,37)+WQx*VRR1(45,58)
      VRR0(45,87)=4.D0*V(277)-4.D0*V(278)+QCx*VRR0(45,59)+HfxZpE*VRR1(29,59)+WQx*VRR1(45,59)
      VRR0(45,88)=3.D0*V(279)+V(280)-3.D0*V(281)+QCx*VRR0(45,60)+WQx*VRR1(45,60)
      VRR0(45,89)=3.D0*V(237)+3.D0*V(277)-3.D0*V(278)+QCy*VRR0(45,60)+WQy*VRR1(45,60)
      VRR0(45,90)=4.D0*V(279)-4.D0*V(281)+QCy*VRR0(45,61)+3.D0*HfxZpE*VRR1(28,61)+WQy*VRR1(45,61)
      VRR0(45,91)=5.D0*r1x2E*VRR0(45,40)+QCy*VRR0(45,62)+3.D0*HfxZpE*VRR1(28,62)-5.D0*r1x2E*ZxZpE*VRR1(45,40)+WQy*VRR1(45,62)
      VRR0(45,92)=6.D0*r1x2E*VRR0(45,41)+QCy*VRR0(45,63)+3.D0*HfxZpE*VRR1(28,63)-6.D0*r1x2E*ZxZpE*VRR1(45,41)+WQy*VRR1(45,63)
      VRR0(45,93)=5.D0*r1x2E*VRR0(45,42)+QCx*VRR0(45,64)+HfxZpE*VRR1(29,64)-5.D0*r1x2E*ZxZpE*VRR1(45,42)+WQx*VRR1(45,64)
      VRR0(45,94)=4.D0*r1x2E*VRR0(45,43)+QCx*VRR0(45,65)+HfxZpE*VRR1(29,65)-4.D0*r1x2E*ZxZpE*VRR1(45,43)+WQx*VRR1(45,65)
      VRR0(45,95)=V(283)+V(284)+V(286)+QCx*VRR0(45,66)+WQx*VRR1(45,66)
      VRR0(45,96)=2.D0*V(287)+V(288)-2.D0*V(289)+QCx*VRR0(45,67)+WQx*VRR1(45,67)
      VRR0(45,97)=3.D0*V(244)+V(283)+V(286)+QCy*VRR0(45,67)+WQy*VRR1(45,67)
      VRR0(45,98)=4.D0*V(287)-4.D0*V(289)+QCy*VRR0(45,68)+3.D0*HfxZpE*VRR1(28,68)+WQy*VRR1(45,68)
      VRR0(45,99)=5.D0*r1x2E*VRR0(45,46)+QCy*VRR0(45,69)+3.D0*HfxZpE*VRR1(28,69)-5.D0*r1x2E*ZxZpE*VRR1(45,46)+WQy*VRR1(45,69)
      VRR0(45,100)=4.D0*V(290)-4.D0*V(291)+QCx*VRR0(45,70)+HfxZpE*VRR1(29,70)+WQx*VRR1(45,70)
      VRR0(45,101)=V(293)+V(294)+V(296)+QCx*VRR0(45,71)+WQx*VRR1(45,71)
      VRR0(45,102)=2.D0*V(297)+V(298)-2.D0*V(299)+QCx*VRR0(45,72)+WQx*VRR1(45,72)
      VRR0(45,103)=3.D0*V(253)+2.D0*V(292)-2.D0*V(295)+QCy*VRR0(45,72)+WQy*VRR1(45,72)
      VRR0(45,104)=V(300)+V(301)+QCy*VRR0(45,73)+3.D0*HfxZpE*VRR1(28,73)+WQy*VRR1(45,73)
      VRR0(45,105)=4.D0*V(302)-4.D0*V(303)+QCy*VRR0(45,74)+3.D0*HfxZpE*VRR1(28,74)+WQy*VRR1(45,74)
      VRR0(45,106)=3.D0*V(304)+V(305)-3.D0*V(306)+QCx*VRR0(45,75)+WQx*VRR1(45,75)
      VRR0(45,107)=V(308)+V(309)+V(311)+QCx*VRR0(45,76)+WQx*VRR1(45,76)
      VRR0(45,108)=V(108)+2.D0*V(282)-2.D0*V(285)+QCz*VRR0(45,72)+WQz*VRR1(45,72)
      VRR0(45,109)=V(308)+V(311)+3.D0*V(312)+QCy*VRR0(45,77)+WQy*VRR1(45,77)
      VRR0(45,110)=3.D0*V(313)+3.D0*V(314)-3.D0*V(315)+QCy*VRR0(45,78)+WQy*VRR1(45,78)
      VRR0(45,111)=V(115)+3.D0*V(290)-3.D0*V(291)+QCz*VRR0(45,75)+WQz*VRR1(45,75)
      VRR0(45,112)=V(119)+V(293)+V(296)+QCz*VRR0(45,76)+WQz*VRR1(45,76)
      VRR0(45,113)=V(156)+V(300)+V(301)+QCz*VRR0(45,77)+WQz*VRR1(45,77)
      VRR0(45,114)=V(158)+3.D0*V(302)-3.D0*V(303)+QCz*VRR0(45,78)+WQz*VRR1(45,78)
      VRR0(45,115)=4.D0*V(304)-4.D0*V(306)+QCz*VRR0(45,79)+HfxZpE*VRR1(24,79)+WQz*VRR1(45,79)
      VRR0(45,116)=4.D0*V(307)-4.D0*V(310)+QCz*VRR0(45,80)+HfxZpE*VRR1(24,80)+WQz*VRR1(45,80)
      VRR0(45,117)=4.D0*V(313)-4.D0*V(315)+QCz*VRR0(45,81)+HfxZpE*VRR1(24,81)+WQz*VRR1(45,81)
      VRR0(45,118)=5.D0*r1x2E*VRR0(45,54)+QCz*VRR0(45,82)+HfxZpE*VRR1(24,82)-5.D0*r1x2E*ZxZpE*VRR1(45,54)+WQz*VRR1(45,82)
      VRR0(45,119)=5.D0*r1x2E*VRR0(45,55)+QCz*VRR0(45,83)+HfxZpE*VRR1(24,83)-5.D0*r1x2E*ZxZpE*VRR1(45,55)+WQz*VRR1(45,83)
      VRR0(45,120)=6.D0*r1x2E*VRR0(45,56)+QCz*VRR0(45,84)+HfxZpE*VRR1(24,84)-6.D0*r1x2E*ZxZpE*VRR1(45,56)+WQz*VRR1(45,84)
      VRR0(46,85)=6.D0*r1x2E*VRR0(46,36)+QCx*VRR0(46,57)-6.D0*r1x2E*ZxZpE*VRR1(46,36)+WQx*VRR1(46,57)
      VRR0(46,86)=5.D0*r1x2E*VRR0(46,37)+QCx*VRR0(46,58)-5.D0*r1x2E*ZxZpE*VRR1(46,37)+WQx*VRR1(46,58)
      VRR0(46,87)=4.D0*V(316)-4.D0*V(317)+QCx*VRR0(46,59)+WQx*VRR1(46,59)
      VRR0(46,88)=3.D0*V(318)-3.D0*V(319)+QCx*VRR0(46,60)+WQx*VRR1(46,60)
      VRR0(46,89)=4.D0*V(280)+3.D0*V(316)-3.D0*V(317)+QCy*VRR0(46,60)+WQy*VRR1(46,60)
      VRR0(46,90)=4.D0*V(318)-4.D0*V(319)+QCy*VRR0(46,61)+4.D0*HfxZpE*VRR1(29,61)+WQy*VRR1(46,61)
      VRR0(46,91)=5.D0*r1x2E*VRR0(46,40)+QCy*VRR0(46,62)+4.D0*HfxZpE*VRR1(29,62)-5.D0*r1x2E*ZxZpE*VRR1(46,40)+WQy*VRR1(46,62)
      VRR0(46,92)=6.D0*r1x2E*VRR0(46,41)+QCy*VRR0(46,63)+4.D0*HfxZpE*VRR1(29,63)-6.D0*r1x2E*ZxZpE*VRR1(46,41)+WQy*VRR1(46,63)
      VRR0(46,93)=5.D0*r1x2E*VRR0(46,42)+QCx*VRR0(46,64)-5.D0*r1x2E*ZxZpE*VRR1(46,42)+WQx*VRR1(46,64)
      VRR0(46,94)=4.D0*r1x2E*VRR0(46,43)+QCx*VRR0(46,65)-4.D0*r1x2E*ZxZpE*VRR1(46,43)+WQx*VRR1(46,65)
      VRR0(46,95)=V(321)+V(323)+QCx*VRR0(46,66)+WQx*VRR1(46,66)
      VRR0(46,96)=3.D0*V(284)+3.D0*r1x2Z*VRR0(17,96)+PAy*VRR0(29,96)-3.D0*ExZpE*r1x2Z*VRR1(17,96)+WPy*VRR1(29,96)
      VRR0(46,97)=4.D0*V(288)+V(321)+V(323)+QCy*VRR0(46,67)+WQy*VRR1(46,67)
      VRR0(46,98)=4.D0*r1x2E*VRR0(46,45)+QCy*VRR0(46,68)+4.D0*HfxZpE*VRR1(29,68)-4.D0*r1x2E*ZxZpE*VRR1(46,45)+WQy*VRR1(46,68)
      VRR0(46,99)=5.D0*r1x2E*VRR0(46,46)+QCy*VRR0(46,69)+4.D0*HfxZpE*VRR1(29,69)-5.D0*r1x2E*ZxZpE*VRR1(46,46)+WQy*VRR1(46,69)
      VRR0(46,100)=4.D0*V(324)-4.D0*V(325)+QCx*VRR0(46,70)+WQx*VRR1(46,70)
      VRR0(46,101)=V(327)+V(329)+QCx*VRR0(46,71)+WQx*VRR1(46,71)
      VRR0(46,102)=2.D0*V(294)+3.D0*r1x2Z*VRR0(17,102)+PAy*VRR0(29,102)-3.D0*ExZpE*r1x2Z*VRR1(17,102)+WPy*VRR1(29,102)
      VRR0(46,103)=3.D0*V(298)+3.D0*r1x2Z*VRR0(17,103)+PAy*VRR0(29,103)-3.D0*ExZpE*r1x2Z*VRR1(17,103)+WPy*VRR1(29,103)
      VRR0(46,104)=V(331)+V(333)+QCy*VRR0(46,73)+4.D0*HfxZpE*VRR1(29,73)+WQy*VRR1(46,73)
      VRR0(46,105)=4.D0*V(334)-4.D0*V(335)+QCy*VRR0(46,74)+4.D0*HfxZpE*VRR1(29,74)+WQy*VRR1(46,74)
      VRR0(46,106)=3.D0*V(336)-3.D0*V(337)+QCx*VRR0(46,75)+WQx*VRR1(46,75)
      VRR0(46,107)=V(305)+3.D0*r1x2Z*VRR0(17,107)+PAy*VRR0(29,107)-3.D0*ExZpE*r1x2Z*VRR1(17,107)+WPy*VRR1(29,107)
      VRR0(46,108)=V(338)+3.D0*r1x2Z*VRR0(17,108)+PAy*VRR0(29,108)-3.D0*ExZpE*r1x2Z*VRR1(17,108)+WPy*VRR1(29,108)
      VRR0(46,109)=3.D0*V(339)+3.D0*r1x2Z*VRR0(17,109)+PAy*VRR0(29,109)-3.D0*ExZpE*r1x2Z*VRR1(17,109)+WPy*VRR1(29,109)
      VRR0(46,110)=3.D0*V(340)+4.D0*V(341)-3.D0*V(342)+QCy*VRR0(46,78)+WQy*VRR1(46,78)
      VRR0(46,111)=V(154)+3.D0*V(324)-3.D0*V(325)+QCz*VRR0(46,75)+WQz*VRR1(46,75)
      VRR0(46,112)=V(160)+V(327)+V(329)+QCz*VRR0(46,76)+WQz*VRR1(46,76)
      VRR0(46,113)=V(161)+V(331)+V(333)+QCz*VRR0(46,77)+WQz*VRR1(46,77)
      VRR0(46,114)=V(162)+3.D0*V(334)-3.D0*V(335)+QCz*VRR0(46,78)+WQz*VRR1(46,78)
      VRR0(46,115)=V(163)+4.D0*V(336)-4.D0*V(337)+QCz*VRR0(46,79)+WQz*VRR1(46,79)
      VRR0(46,116)=V(164)+4.D0*r1x2E*VRR0(46,52)+QCz*VRR0(46,80)-4.D0*r1x2E*ZxZpE*VRR1(46,52)+WQz*VRR1(46,80)
      VRR0(46,117)=V(165)+4.D0*V(340)-4.D0*V(342)+QCz*VRR0(46,81)+WQz*VRR1(46,81)
      VRR0(46,118)=5.D0*r1x2E*VRR0(46,54)+QCz*VRR0(46,82)+HfxZpE*VRR1(25,82)-5.D0*r1x2E*ZxZpE*VRR1(46,54)+WQz*VRR1(46,82)
      VRR0(46,119)=5.D0*r1x2E*VRR0(46,55)+QCz*VRR0(46,83)+HfxZpE*VRR1(25,83)-5.D0*r1x2E*ZxZpE*VRR1(46,55)+WQz*VRR1(46,83)
      VRR0(46,120)=6.D0*r1x2E*VRR0(46,56)+QCz*VRR0(46,84)+HfxZpE*VRR1(25,84)-6.D0*r1x2E*ZxZpE*VRR1(46,56)+WQz*VRR1(46,84)
      VRR0(47,85)=6.D0*r1x2E*VRR0(47,36)+QCx*VRR0(47,57)+3.D0*HfxZpE*VRR1(30,57)-6.D0*r1x2E*ZxZpE*VRR1(47,36)+WQx*VRR1(47,57)
      VRR0(47,86)=5.D0*r1x2E*VRR0(47,37)+QCx*VRR0(47,58)+3.D0*HfxZpE*VRR1(30,58)-5.D0*r1x2E*ZxZpE*VRR1(47,37)+WQx*VRR1(47,58)
      VRR0(47,87)=4.D0*V(343)-4.D0*V(344)+QCx*VRR0(47,59)+3.D0*HfxZpE*VRR1(30,59)+WQx*VRR1(47,59)
      VRR0(47,88)=3.D0*V(345)+3.D0*V(346)-3.D0*V(347)+QCx*VRR0(47,60)+WQx*VRR1(47,60)
      VRR0(47,89)=3.D0*V(343)-3.D0*V(344)+QCy*VRR0(47,60)+WQy*VRR1(47,60)
      VRR0(47,90)=4.D0*V(345)-4.D0*V(347)+QCy*VRR0(47,61)+WQy*VRR1(47,61)
      VRR0(47,91)=5.D0*r1x2E*VRR0(47,40)+QCy*VRR0(47,62)-5.D0*r1x2E*ZxZpE*VRR1(47,40)+WQy*VRR1(47,62)
      VRR0(47,92)=6.D0*r1x2E*VRR0(47,41)+QCy*VRR0(47,63)-6.D0*r1x2E*ZxZpE*VRR1(47,41)+WQy*VRR1(47,63)
      VRR0(47,93)=5.D0*r1x2E*VRR0(47,42)+QCx*VRR0(47,64)+3.D0*HfxZpE*VRR1(30,64)-5.D0*r1x2E*ZxZpE*VRR1(47,42)+WQx*VRR1(47,64)
      VRR0(47,94)=4.D0*r1x2E*VRR0(47,43)+QCx*VRR0(47,65)+3.D0*HfxZpE*VRR1(30,65)-4.D0*r1x2E*ZxZpE*VRR1(47,43)+WQx*VRR1(47,65)
      VRR0(47,95)=V(349)+V(351)+QCx*VRR0(47,66)+3.D0*HfxZpE*VRR1(30,66)+WQx*VRR1(47,66)
      VRR0(47,96)=2.D0*V(352)+3.D0*V(353)-2.D0*V(354)+QCx*VRR0(47,67)+WQx*VRR1(47,67)
      VRR0(47,97)=V(349)+V(351)+QCy*VRR0(47,67)+WQy*VRR1(47,67)
      VRR0(47,98)=4.D0*V(352)-4.D0*V(354)+QCy*VRR0(47,68)+WQy*VRR1(47,68)
      VRR0(47,99)=5.D0*r1x2E*VRR0(47,46)+QCy*VRR0(47,69)-5.D0*r1x2E*ZxZpE*VRR1(47,46)+WQy*VRR1(47,69)
      VRR0(47,100)=4.D0*V(355)-4.D0*V(356)+QCx*VRR0(47,70)+3.D0*HfxZpE*VRR1(30,70)+WQx*VRR1(47,70)
      VRR0(47,101)=V(358)+V(360)+QCx*VRR0(47,71)+3.D0*HfxZpE*VRR1(30,71)+WQx*VRR1(47,71)
      VRR0(47,102)=2.D0*V(361)+V(363)-2.D0*V(364)+QCx*VRR0(47,72)+WQx*VRR1(47,72)
      VRR0(47,103)=2.D0*V(357)-2.D0*V(359)+QCy*VRR0(47,72)+WQy*VRR1(47,72)
      VRR0(47,104)=V(365)+V(366)+QCy*VRR0(47,73)+WQy*VRR1(47,73)
      VRR0(47,105)=4.D0*V(367)-4.D0*V(368)+QCy*VRR0(47,74)+WQy*VRR1(47,74)
      VRR0(47,106)=3.D0*V(369)+V(371)-3.D0*V(372)+QCx*VRR0(47,75)+WQx*VRR1(47,75)
      VRR0(47,107)=V(374)+V(376)+V(378)+QCx*VRR0(47,76)+WQx*VRR1(47,76)
      VRR0(47,108)=2.D0*V(182)+2.D0*V(348)-2.D0*V(350)+QCz*VRR0(47,72)+WQz*VRR1(47,72)
      VRR0(47,109)=V(374)+V(378)+QCy*VRR0(47,77)+WQy*VRR1(47,77)
      VRR0(47,110)=3.D0*V(379)-3.D0*V(380)+QCy*VRR0(47,78)+WQy*VRR1(47,78)
      VRR0(47,111)=2.D0*V(191)+3.D0*V(355)-3.D0*V(356)+QCz*VRR0(47,75)+WQz*VRR1(47,75)
      VRR0(47,112)=2.D0*V(193)+V(358)+V(360)+QCz*VRR0(47,76)+WQz*VRR1(47,76)
      VRR0(47,113)=V(195)+V(365)+V(366)+QCz*VRR0(47,77)+WQz*VRR1(47,77)
      VRR0(47,114)=2.D0*V(196)+3.D0*V(367)-3.D0*V(368)+QCz*VRR0(47,78)+WQz*VRR1(47,78)
      VRR0(47,115)=4.D0*V(369)-4.D0*V(372)+QCz*VRR0(47,79)+2.D0*HfxZpE*VRR1(26,79)+WQz*VRR1(47,79)
      VRR0(47,116)=4.D0*V(373)-4.D0*V(377)+QCz*VRR0(47,80)+2.D0*HfxZpE*VRR1(26,80)+WQz*VRR1(47,80)
      VRR0(47,117)=4.D0*V(379)-4.D0*V(380)+QCz*VRR0(47,81)+2.D0*HfxZpE*VRR1(26,81)+WQz*VRR1(47,81)
      VRR0(47,118)=5.D0*r1x2E*VRR0(47,54)+QCz*VRR0(47,82)+2.D0*HfxZpE*VRR1(26,82)-5.D0*r1x2E*ZxZpE*VRR1(47,54)+WQz*VRR1(47,82)
      VRR0(47,119)=5.D0*r1x2E*VRR0(47,55)+QCz*VRR0(47,83)+2.D0*HfxZpE*VRR1(26,83)-5.D0*r1x2E*ZxZpE*VRR1(47,55)+WQz*VRR1(47,83)
      VRR0(47,120)=6.D0*r1x2E*VRR0(47,56)+QCz*VRR0(47,84)+2.D0*HfxZpE*VRR1(26,84)-6.D0*r1x2E*ZxZpE*VRR1(47,56)+WQz*VRR1(47,84)
      VRR0(48,85)=6.D0*r1x2E*VRR0(48,36)+QCx*VRR0(48,57)+2.D0*HfxZpE*VRR1(31,57)-6.D0*r1x2E*ZxZpE*VRR1(48,36)+WQx*VRR1(48,57)
      VRR0(48,86)=5.D0*r1x2E*VRR0(48,37)+QCx*VRR0(48,58)+2.D0*HfxZpE*VRR1(31,58)-5.D0*r1x2E*ZxZpE*VRR1(48,37)+WQx*VRR1(48,58)
      VRR0(48,87)=4.D0*V(381)-4.D0*V(382)+QCx*VRR0(48,59)+2.D0*HfxZpE*VRR1(31,59)+WQx*VRR1(48,59)
      VRR0(48,88)=3.D0*V(383)+V(385)-3.D0*V(386)+QCx*VRR0(48,60)+WQx*VRR1(48,60)
      VRR0(48,89)=V(346)+3.D0*V(381)-3.D0*V(382)+QCy*VRR0(48,60)+WQy*VRR1(48,60)
      VRR0(48,90)=4.D0*V(383)-4.D0*V(386)+QCy*VRR0(48,61)+HfxZpE*VRR1(30,61)+WQy*VRR1(48,61)
      VRR0(48,91)=5.D0*r1x2E*VRR0(48,40)+QCy*VRR0(48,62)+HfxZpE*VRR1(30,62)-5.D0*r1x2E*ZxZpE*VRR1(48,40)+WQy*VRR1(48,62)
      VRR0(48,92)=6.D0*r1x2E*VRR0(48,41)+QCy*VRR0(48,63)+HfxZpE*VRR1(30,63)-6.D0*r1x2E*ZxZpE*VRR1(48,41)+WQy*VRR1(48,63)
      VRR0(48,93)=5.D0*r1x2E*VRR0(48,42)+QCx*VRR0(48,64)+2.D0*HfxZpE*VRR1(31,64)-5.D0*r1x2E*ZxZpE*VRR1(48,42)+WQx*VRR1(48,64)
      VRR0(48,94)=4.D0*r1x2E*VRR0(48,43)+QCx*VRR0(48,65)+2.D0*HfxZpE*VRR1(31,65)-4.D0*r1x2E*ZxZpE*VRR1(48,43)+WQx*VRR1(48,65)
      VRR0(48,95)=V(388)+V(390)+QCx*VRR0(48,66)+2.D0*HfxZpE*VRR1(31,66)+WQx*VRR1(48,66)
      VRR0(48,96)=2.D0*V(391)+V(393)-2.D0*V(394)+QCx*VRR0(48,67)+WQx*VRR1(48,67)
      VRR0(48,97)=V(353)+V(388)+V(390)+QCy*VRR0(48,67)+WQy*VRR1(48,67)
      VRR0(48,98)=4.D0*V(391)-4.D0*V(394)+QCy*VRR0(48,68)+HfxZpE*VRR1(30,68)+WQy*VRR1(48,68)
      VRR0(48,99)=5.D0*r1x2E*VRR0(48,46)+QCy*VRR0(48,69)+HfxZpE*VRR1(30,69)-5.D0*r1x2E*ZxZpE*VRR1(48,46)+WQy*VRR1(48,69)
      VRR0(48,100)=4.D0*V(395)-4.D0*V(396)+QCx*VRR0(48,70)+2.D0*HfxZpE*VRR1(31,70)+WQx*VRR1(48,70)
      VRR0(48,101)=V(398)+V(400)+QCx*VRR0(48,71)+2.D0*HfxZpE*VRR1(31,71)+WQx*VRR1(48,71)
      VRR0(48,102)=2.D0*V(401)+V(403)-2.D0*V(404)+QCx*VRR0(48,72)+WQx*VRR1(48,72)
      VRR0(48,103)=V(362)+2.D0*V(397)-2.D0*V(399)+QCy*VRR0(48,72)+WQy*VRR1(48,72)
      VRR0(48,104)=V(405)+V(406)+QCy*VRR0(48,73)+HfxZpE*VRR1(30,73)+WQy*VRR1(48,73)
      VRR0(48,105)=4.D0*V(407)-4.D0*V(408)+QCy*VRR0(48,74)+HfxZpE*VRR1(30,74)+WQy*VRR1(48,74)
      VRR0(48,106)=3.D0*V(409)+2.D0*V(410)-3.D0*V(411)+QCx*VRR0(48,75)+WQx*VRR1(48,75)
      VRR0(48,107)=V(413)+2.D0*V(414)+V(416)+QCx*VRR0(48,76)+WQx*VRR1(48,76)
      VRR0(48,108)=V(256)+2.D0*V(387)-2.D0*V(389)+QCz*VRR0(48,72)+WQz*VRR1(48,72)
      VRR0(48,109)=V(413)+V(416)+V(417)+QCy*VRR0(48,77)+WQy*VRR1(48,77)
      VRR0(48,110)=3.D0*V(418)+V(419)-3.D0*V(420)+QCy*VRR0(48,78)+WQy*VRR1(48,78)
      VRR0(48,111)=2.D0*V(225)+3.D0*V(395)-3.D0*V(396)+QCz*VRR0(48,75)+WQz*VRR1(48,75)
      VRR0(48,112)=2.D0*V(229)+V(398)+V(400)+QCz*VRR0(48,76)+WQz*VRR1(48,76)
      VRR0(48,113)=V(272)+V(405)+V(406)+QCz*VRR0(48,77)+WQz*VRR1(48,77)
      VRR0(48,114)=V(275)+3.D0*V(407)-3.D0*V(408)+QCz*VRR0(48,78)+WQz*VRR1(48,78)
      VRR0(48,115)=4.D0*V(409)-4.D0*V(411)+QCz*VRR0(48,79)+2.D0*HfxZpE*VRR1(27,79)+WQz*VRR1(48,79)
      VRR0(48,116)=4.D0*V(412)-4.D0*V(415)+QCz*VRR0(48,80)+2.D0*HfxZpE*VRR1(27,80)+WQz*VRR1(48,80)
      VRR0(48,117)=4.D0*V(418)-4.D0*V(420)+QCz*VRR0(48,81)+2.D0*HfxZpE*VRR1(27,81)+WQz*VRR1(48,81)
      VRR0(48,118)=5.D0*r1x2E*VRR0(48,54)+QCz*VRR0(48,82)+2.D0*HfxZpE*VRR1(27,82)-5.D0*r1x2E*ZxZpE*VRR1(48,54)+WQz*VRR1(48,82)
      VRR0(48,119)=5.D0*r1x2E*VRR0(48,55)+QCz*VRR0(48,83)+2.D0*HfxZpE*VRR1(27,83)-5.D0*r1x2E*ZxZpE*VRR1(48,55)+WQz*VRR1(48,83)
      VRR0(48,120)=6.D0*r1x2E*VRR0(48,56)+QCz*VRR0(48,84)+2.D0*HfxZpE*VRR1(27,84)-6.D0*r1x2E*ZxZpE*VRR1(48,56)+WQz*VRR1(48,84)
      VRR0(49,85)=6.D0*r1x2E*VRR0(49,36)+QCx*VRR0(49,57)+HfxZpE*VRR1(32,57)-6.D0*r1x2E*ZxZpE*VRR1(49,36)+WQx*VRR1(49,57)
      VRR0(49,86)=5.D0*r1x2E*VRR0(49,37)+QCx*VRR0(49,58)+HfxZpE*VRR1(32,58)-5.D0*r1x2E*ZxZpE*VRR1(49,37)+WQx*VRR1(49,58)
      VRR0(49,87)=4.D0*V(421)-4.D0*V(422)+QCx*VRR0(49,59)+HfxZpE*VRR1(32,59)+WQx*VRR1(49,59)
      VRR0(49,88)=3.D0*V(423)+V(424)-3.D0*V(425)+QCx*VRR0(49,60)+WQx*VRR1(49,60)
      VRR0(49,89)=V(385)+3.D0*V(421)-3.D0*V(422)+QCy*VRR0(49,60)+WQy*VRR1(49,60)
      VRR0(49,90)=4.D0*V(423)-4.D0*V(425)+QCy*VRR0(49,61)+2.D0*HfxZpE*VRR1(31,61)+WQy*VRR1(49,61)
      VRR0(49,91)=5.D0*r1x2E*VRR0(49,40)+QCy*VRR0(49,62)+2.D0*HfxZpE*VRR1(31,62)-5.D0*r1x2E*ZxZpE*VRR1(49,40)+WQy*VRR1(49,62)
      VRR0(49,92)=6.D0*r1x2E*VRR0(49,41)+QCy*VRR0(49,63)+2.D0*HfxZpE*VRR1(31,63)-6.D0*r1x2E*ZxZpE*VRR1(49,41)+WQy*VRR1(49,63)
      VRR0(49,93)=5.D0*r1x2E*VRR0(49,42)+QCx*VRR0(49,64)+HfxZpE*VRR1(32,64)-5.D0*r1x2E*ZxZpE*VRR1(49,42)+WQx*VRR1(49,64)
      VRR0(49,94)=4.D0*r1x2E*VRR0(49,43)+QCx*VRR0(49,65)+HfxZpE*VRR1(32,65)-4.D0*r1x2E*ZxZpE*VRR1(49,43)+WQx*VRR1(49,65)
      VRR0(49,95)=V(427)+V(429)+QCx*VRR0(49,66)+HfxZpE*VRR1(32,66)+WQx*VRR1(49,66)
      VRR0(49,96)=2.D0*V(430)+V(431)-2.D0*V(432)+QCx*VRR0(49,67)+WQx*VRR1(49,67)
      VRR0(49,97)=V(393)+V(427)+V(429)+QCy*VRR0(49,67)+WQy*VRR1(49,67)
      VRR0(49,98)=4.D0*V(430)-4.D0*V(432)+QCy*VRR0(49,68)+2.D0*HfxZpE*VRR1(31,68)+WQy*VRR1(49,68)
      VRR0(49,99)=5.D0*r1x2E*VRR0(49,46)+QCy*VRR0(49,69)+2.D0*HfxZpE*VRR1(31,69)-5.D0*r1x2E*ZxZpE*VRR1(49,46)+WQy*VRR1(49,69)
      VRR0(49,100)=4.D0*V(433)-4.D0*V(434)+QCx*VRR0(49,70)+HfxZpE*VRR1(32,70)+WQx*VRR1(49,70)
      VRR0(49,101)=V(436)+V(438)+QCx*VRR0(49,71)+HfxZpE*VRR1(32,71)+WQx*VRR1(49,71)
      VRR0(49,102)=2.D0*V(439)+V(440)-2.D0*V(441)+QCx*VRR0(49,72)+WQx*VRR1(49,72)
      VRR0(49,103)=V(403)+2.D0*V(435)-2.D0*V(437)+QCy*VRR0(49,72)+WQy*VRR1(49,72)
      VRR0(49,104)=V(442)+V(443)+QCy*VRR0(49,73)+2.D0*HfxZpE*VRR1(31,73)+WQy*VRR1(49,73)
      VRR0(49,105)=4.D0*V(444)-4.D0*V(445)+QCy*VRR0(49,74)+2.D0*HfxZpE*VRR1(31,74)+WQy*VRR1(49,74)
      VRR0(49,106)=3.D0*V(446)+V(447)-3.D0*V(448)+QCx*VRR0(49,75)+WQx*VRR1(49,75)
      VRR0(49,107)=V(450)+V(451)+V(453)+QCx*VRR0(49,76)+WQx*VRR1(49,76)
      VRR0(49,108)=V(254)+2.D0*V(426)-2.D0*V(428)+QCz*VRR0(49,72)+WQz*VRR1(49,72)
      VRR0(49,109)=V(450)+V(453)+2.D0*V(454)+QCy*VRR0(49,77)+WQy*VRR1(49,77)
      VRR0(49,110)=3.D0*V(455)+2.D0*V(456)-3.D0*V(457)+QCy*VRR0(49,78)+WQy*VRR1(49,78)
      VRR0(49,111)=V(263)+3.D0*V(433)-3.D0*V(434)+QCz*VRR0(49,75)+WQz*VRR1(49,75)
      VRR0(49,112)=V(268)+V(436)+V(438)+QCz*VRR0(49,76)+WQz*VRR1(49,76)
      VRR0(49,113)=2.D0*V(312)+V(442)+V(443)+QCz*VRR0(49,77)+WQz*VRR1(49,77)
      VRR0(49,114)=2.D0*V(314)+3.D0*V(444)-3.D0*V(445)+QCz*VRR0(49,78)+WQz*VRR1(49,78)
      VRR0(49,115)=4.D0*V(446)-4.D0*V(448)+QCz*VRR0(49,79)+2.D0*HfxZpE*VRR1(28,79)+WQz*VRR1(49,79)
      VRR0(49,116)=4.D0*V(449)-4.D0*V(452)+QCz*VRR0(49,80)+2.D0*HfxZpE*VRR1(28,80)+WQz*VRR1(49,80)
      VRR0(49,117)=4.D0*V(455)-4.D0*V(457)+QCz*VRR0(49,81)+2.D0*HfxZpE*VRR1(28,81)+WQz*VRR1(49,81)
      VRR0(49,118)=5.D0*r1x2E*VRR0(49,54)+QCz*VRR0(49,82)+2.D0*HfxZpE*VRR1(28,82)-5.D0*r1x2E*ZxZpE*VRR1(49,54)+WQz*VRR1(49,82)
      VRR0(49,119)=5.D0*r1x2E*VRR0(49,55)+QCz*VRR0(49,83)+2.D0*HfxZpE*VRR1(28,83)-5.D0*r1x2E*ZxZpE*VRR1(49,55)+WQz*VRR1(49,83)
      VRR0(49,120)=6.D0*r1x2E*VRR0(49,56)+QCz*VRR0(49,84)+2.D0*HfxZpE*VRR1(28,84)-6.D0*r1x2E*ZxZpE*VRR1(49,56)+WQz*VRR1(49,84)
      VRR0(50,85)=6.D0*r1x2E*VRR0(50,36)+QCx*VRR0(50,57)-6.D0*r1x2E*ZxZpE*VRR1(50,36)+WQx*VRR1(50,57)
      VRR0(50,86)=5.D0*r1x2E*VRR0(50,37)+QCx*VRR0(50,58)-5.D0*r1x2E*ZxZpE*VRR1(50,37)+WQx*VRR1(50,58)
      VRR0(50,87)=4.D0*V(458)-4.D0*V(459)+QCx*VRR0(50,59)+WQx*VRR1(50,59)
      VRR0(50,88)=3.D0*V(460)-3.D0*V(461)+QCx*VRR0(50,60)+WQx*VRR1(50,60)
      VRR0(50,89)=3.D0*V(424)+3.D0*V(458)-3.D0*V(459)+QCy*VRR0(50,60)+WQy*VRR1(50,60)
      VRR0(50,90)=4.D0*V(460)-4.D0*V(461)+QCy*VRR0(50,61)+3.D0*HfxZpE*VRR1(32,61)+WQy*VRR1(50,61)
      VRR0(50,91)=5.D0*r1x2E*VRR0(50,40)+QCy*VRR0(50,62)+3.D0*HfxZpE*VRR1(32,62)-5.D0*r1x2E*ZxZpE*VRR1(50,40)+WQy*VRR1(50,62)
      VRR0(50,92)=6.D0*r1x2E*VRR0(50,41)+QCy*VRR0(50,63)+3.D0*HfxZpE*VRR1(32,63)-6.D0*r1x2E*ZxZpE*VRR1(50,41)+WQy*VRR1(50,63)
      VRR0(50,93)=5.D0*r1x2E*VRR0(50,42)+QCx*VRR0(50,64)-5.D0*r1x2E*ZxZpE*VRR1(50,42)+WQx*VRR1(50,64)
      VRR0(50,94)=4.D0*r1x2E*VRR0(50,43)+QCx*VRR0(50,65)-4.D0*r1x2E*ZxZpE*VRR1(50,43)+WQx*VRR1(50,65)
      VRR0(50,95)=V(463)+V(465)+QCx*VRR0(50,66)+WQx*VRR1(50,66)
      VRR0(50,96)=2.D0*V(466)-2.D0*V(467)+QCx*VRR0(50,67)+WQx*VRR1(50,67)
      VRR0(50,97)=3.D0*V(431)+V(463)+V(465)+QCy*VRR0(50,67)+WQy*VRR1(50,67)
      VRR0(50,98)=4.D0*V(466)-4.D0*V(467)+QCy*VRR0(50,68)+3.D0*HfxZpE*VRR1(32,68)+WQy*VRR1(50,68)
      VRR0(50,99)=5.D0*r1x2E*VRR0(50,46)+QCy*VRR0(50,69)+3.D0*HfxZpE*VRR1(32,69)-5.D0*r1x2E*ZxZpE*VRR1(50,46)+WQy*VRR1(50,69)
      VRR0(50,100)=4.D0*V(468)-4.D0*V(469)+QCx*VRR0(50,70)+WQx*VRR1(50,70)
      VRR0(50,101)=V(471)+V(473)+QCx*VRR0(50,71)+WQx*VRR1(50,71)
      VRR0(50,102)=2.D0*V(474)-2.D0*V(475)+QCx*VRR0(50,72)+WQx*VRR1(50,72)
      VRR0(50,103)=2.D0*V(470)-2.D0*V(472)+V(476)+QCy*VRR0(50,72)+WQy*VRR1(50,72)
      VRR0(50,104)=V(477)+V(478)+QCy*VRR0(50,73)+3.D0*HfxZpE*VRR1(32,73)+WQy*VRR1(50,73)
      VRR0(50,105)=4.D0*V(479)-4.D0*V(480)+QCy*VRR0(50,74)+3.D0*HfxZpE*VRR1(32,74)+WQy*VRR1(50,74)
      VRR0(50,106)=3.D0*V(481)-3.D0*V(482)+QCx*VRR0(50,75)+WQx*VRR1(50,75)
      VRR0(50,107)=V(484)+V(486)+QCx*VRR0(50,76)+WQx*VRR1(50,76)
      VRR0(50,108)=2.D0*V(298)+2.D0*V(462)-2.D0*V(464)+QCz*VRR0(50,72)+WQz*VRR1(50,72)
      VRR0(50,109)=V(484)+V(486)+V(488)+QCy*VRR0(50,77)+WQy*VRR1(50,77)
      VRR0(50,110)=3.D0*V(489)+V(491)-3.D0*V(492)+QCy*VRR0(50,78)+WQy*VRR1(50,78)
      VRR0(50,111)=2.D0*V(305)+3.D0*V(468)-3.D0*V(469)+QCz*VRR0(50,75)+WQz*VRR1(50,75)
      VRR0(50,112)=V(338)+V(471)+V(473)+QCz*VRR0(50,76)+WQz*VRR1(50,76)
      VRR0(50,113)=2.D0*V(339)+V(477)+V(478)+QCz*VRR0(50,77)+WQz*VRR1(50,77)
      VRR0(50,114)=2.D0*V(341)+3.D0*V(479)-3.D0*V(480)+QCz*VRR0(50,78)+WQz*VRR1(50,78)
      VRR0(50,115)=4.D0*V(481)-4.D0*V(482)+QCz*VRR0(50,79)+2.D0*HfxZpE*VRR1(29,79)+WQz*VRR1(50,79)
      VRR0(50,116)=4.D0*V(483)-4.D0*V(485)+QCz*VRR0(50,80)+2.D0*HfxZpE*VRR1(29,80)+WQz*VRR1(50,80)
      VRR0(50,117)=4.D0*V(489)-4.D0*V(492)+QCz*VRR0(50,81)+2.D0*HfxZpE*VRR1(29,81)+WQz*VRR1(50,81)
      VRR0(50,118)=5.D0*r1x2E*VRR0(50,54)+QCz*VRR0(50,82)+2.D0*HfxZpE*VRR1(29,82)-5.D0*r1x2E*ZxZpE*VRR1(50,54)+WQz*VRR1(50,82)
      VRR0(50,119)=5.D0*r1x2E*VRR0(50,55)+QCz*VRR0(50,83)+2.D0*HfxZpE*VRR1(29,83)-5.D0*r1x2E*ZxZpE*VRR1(50,55)+WQz*VRR1(50,83)
      VRR0(50,120)=6.D0*r1x2E*VRR0(50,56)+QCz*VRR0(50,84)+2.D0*HfxZpE*VRR1(29,84)-6.D0*r1x2E*ZxZpE*VRR1(50,56)+WQz*VRR1(50,84)
      VRR0(51,85)=6.D0*r1x2E*VRR0(51,36)+QCx*VRR0(51,57)+2.D0*HfxZpE*VRR1(33,57)-6.D0*r1x2E*ZxZpE*VRR1(51,36)+WQx*VRR1(51,57)
      VRR0(51,86)=5.D0*r1x2E*VRR0(51,37)+QCx*VRR0(51,58)+2.D0*HfxZpE*VRR1(33,58)-5.D0*r1x2E*ZxZpE*VRR1(51,37)+WQx*VRR1(51,58)
      VRR0(51,87)=4.D0*V(493)-4.D0*V(494)+QCx*VRR0(51,59)+2.D0*HfxZpE*VRR1(33,59)+WQx*VRR1(51,59)
      VRR0(51,88)=3.D0*V(495)+2.D0*V(496)-3.D0*V(497)+QCx*VRR0(51,60)+WQx*VRR1(51,60)
      VRR0(51,89)=3.D0*V(493)-3.D0*V(494)+QCy*VRR0(51,60)+WQy*VRR1(51,60)
      VRR0(51,90)=4.D0*V(495)-4.D0*V(497)+QCy*VRR0(51,61)+WQy*VRR1(51,61)
      VRR0(51,91)=5.D0*r1x2E*VRR0(51,40)+QCy*VRR0(51,62)-5.D0*r1x2E*ZxZpE*VRR1(51,40)+WQy*VRR1(51,62)
      VRR0(51,92)=6.D0*r1x2E*VRR0(51,41)+QCy*VRR0(51,63)-6.D0*r1x2E*ZxZpE*VRR1(51,41)+WQy*VRR1(51,63)
      VRR0(51,93)=5.D0*r1x2E*VRR0(51,42)+QCx*VRR0(51,64)+2.D0*HfxZpE*VRR1(33,64)-5.D0*r1x2E*ZxZpE*VRR1(51,42)+WQx*VRR1(51,64)
      VRR0(51,94)=4.D0*r1x2E*VRR0(51,43)+QCx*VRR0(51,65)+2.D0*HfxZpE*VRR1(33,65)-4.D0*r1x2E*ZxZpE*VRR1(51,43)+WQx*VRR1(51,65)
      VRR0(51,95)=V(499)+V(501)+V(503)+QCx*VRR0(51,66)+WQx*VRR1(51,66)
      VRR0(51,96)=2.D0*V(504)+V(506)-2.D0*V(507)+QCx*VRR0(51,67)+WQx*VRR1(51,67)
      VRR0(51,97)=V(499)+V(503)+QCy*VRR0(51,67)+WQy*VRR1(51,67)
      VRR0(51,98)=4.D0*V(504)-4.D0*V(507)+QCy*VRR0(51,68)+WQy*VRR1(51,68)
      VRR0(51,99)=5.D0*r1x2E*VRR0(51,46)+QCy*VRR0(51,69)-5.D0*r1x2E*ZxZpE*VRR1(51,46)+WQy*VRR1(51,69)
      VRR0(51,100)=4.D0*V(508)-4.D0*V(509)+QCx*VRR0(51,70)+2.D0*HfxZpE*VRR1(33,70)+WQx*VRR1(51,70)
      VRR0(51,101)=V(511)+2.D0*V(512)+V(514)+QCx*VRR0(51,71)+WQx*VRR1(51,71)
      VRR0(51,102)=2.D0*V(515)+2.D0*V(516)-2.D0*V(517)+QCx*VRR0(51,72)+WQx*VRR1(51,72)
      VRR0(51,103)=2.D0*V(510)-2.D0*V(513)+QCy*VRR0(51,72)+WQy*VRR1(51,72)
      VRR0(51,104)=V(518)+V(519)+QCy*VRR0(51,73)+WQy*VRR1(51,73)
      VRR0(51,105)=4.D0*V(520)-4.D0*V(521)+QCy*VRR0(51,74)+WQy*VRR1(51,74)
      VRR0(51,106)=3.D0*V(522)+2.D0*V(523)-3.D0*V(524)+QCx*VRR0(51,75)+WQx*VRR1(51,75)
      VRR0(51,107)=V(526)+2.D0*V(527)+V(529)+QCx*VRR0(51,76)+WQx*VRR1(51,76)
      VRR0(51,108)=V(363)+2.D0*V(498)-2.D0*V(502)+QCz*VRR0(51,72)+WQz*VRR1(51,72)
      VRR0(51,109)=V(526)+V(529)+QCy*VRR0(51,77)+WQy*VRR1(51,77)
      VRR0(51,110)=3.D0*V(530)-3.D0*V(531)+QCy*VRR0(51,78)+WQy*VRR1(51,78)
      VRR0(51,111)=V(371)+3.D0*V(508)-3.D0*V(509)+QCz*VRR0(51,75)+WQz*VRR1(51,75)
      VRR0(51,112)=V(376)+V(511)+V(514)+QCz*VRR0(51,76)+WQz*VRR1(51,76)
      VRR0(51,113)=3.D0*V(417)+V(518)+V(519)+QCz*VRR0(51,77)+WQz*VRR1(51,77)
      VRR0(51,114)=3.D0*V(419)+3.D0*V(520)-3.D0*V(521)+QCz*VRR0(51,78)+WQz*VRR1(51,78)
      VRR0(51,115)=4.D0*V(522)-4.D0*V(524)+QCz*VRR0(51,79)+3.D0*HfxZpE*VRR1(30,79)+WQz*VRR1(51,79)
      VRR0(51,116)=4.D0*V(525)-4.D0*V(528)+QCz*VRR0(51,80)+3.D0*HfxZpE*VRR1(30,80)+WQz*VRR1(51,80)
      VRR0(51,117)=4.D0*V(530)-4.D0*V(531)+QCz*VRR0(51,81)+3.D0*HfxZpE*VRR1(30,81)+WQz*VRR1(51,81)
      VRR0(51,118)=5.D0*r1x2E*VRR0(51,54)+QCz*VRR0(51,82)+3.D0*HfxZpE*VRR1(30,82)-5.D0*r1x2E*ZxZpE*VRR1(51,54)+WQz*VRR1(51,82)
      VRR0(51,119)=5.D0*r1x2E*VRR0(51,55)+QCz*VRR0(51,83)+3.D0*HfxZpE*VRR1(30,83)-5.D0*r1x2E*ZxZpE*VRR1(51,55)+WQz*VRR1(51,83)
      VRR0(51,120)=6.D0*r1x2E*VRR0(51,56)+QCz*VRR0(51,84)+3.D0*HfxZpE*VRR1(30,84)-6.D0*r1x2E*ZxZpE*VRR1(51,56)+WQz*VRR1(51,84)
      VRR0(52,85)=6.D0*r1x2E*VRR0(52,36)+QCx*VRR0(52,57)+HfxZpE*VRR1(34,57)-6.D0*r1x2E*ZxZpE*VRR1(52,36)+WQx*VRR1(52,57)
      VRR0(52,86)=5.D0*r1x2E*VRR0(52,37)+QCx*VRR0(52,58)+HfxZpE*VRR1(34,58)-5.D0*r1x2E*ZxZpE*VRR1(52,37)+WQx*VRR1(52,58)
      VRR0(52,87)=4.D0*V(532)-4.D0*V(533)+QCx*VRR0(52,59)+HfxZpE*VRR1(34,59)+WQx*VRR1(52,59)
      VRR0(52,88)=3.D0*V(534)+V(535)-3.D0*V(536)+QCx*VRR0(52,60)+WQx*VRR1(52,60)
      VRR0(52,89)=V(496)+3.D0*V(532)-3.D0*V(533)+QCy*VRR0(52,60)+WQy*VRR1(52,60)
      VRR0(52,90)=4.D0*V(534)-4.D0*V(536)+QCy*VRR0(52,61)+HfxZpE*VRR1(33,61)+WQy*VRR1(52,61)
      VRR0(52,91)=5.D0*r1x2E*VRR0(52,40)+QCy*VRR0(52,62)+HfxZpE*VRR1(33,62)-5.D0*r1x2E*ZxZpE*VRR1(52,40)+WQy*VRR1(52,62)
      VRR0(52,92)=6.D0*r1x2E*VRR0(52,41)+QCy*VRR0(52,63)+HfxZpE*VRR1(33,63)-6.D0*r1x2E*ZxZpE*VRR1(52,41)+WQy*VRR1(52,63)
      VRR0(52,93)=5.D0*r1x2E*VRR0(52,42)+QCx*VRR0(52,64)+HfxZpE*VRR1(34,64)-5.D0*r1x2E*ZxZpE*VRR1(52,42)+WQx*VRR1(52,64)
      VRR0(52,94)=4.D0*r1x2E*VRR0(52,43)+QCx*VRR0(52,65)+HfxZpE*VRR1(34,65)-4.D0*r1x2E*ZxZpE*VRR1(52,43)+WQx*VRR1(52,65)
      VRR0(52,95)=V(538)+V(539)+V(541)+QCx*VRR0(52,66)+WQx*VRR1(52,66)
      VRR0(52,96)=2.D0*V(542)+V(543)-2.D0*V(544)+QCx*VRR0(52,67)+WQx*VRR1(52,67)
      VRR0(52,97)=V(505)+V(538)+V(541)+QCy*VRR0(52,67)+WQy*VRR1(52,67)
      VRR0(52,98)=4.D0*V(542)-4.D0*V(544)+QCy*VRR0(52,68)+HfxZpE*VRR1(33,68)+WQy*VRR1(52,68)
      VRR0(52,99)=5.D0*r1x2E*VRR0(52,46)+QCy*VRR0(52,69)+HfxZpE*VRR1(33,69)-5.D0*r1x2E*ZxZpE*VRR1(52,46)+WQy*VRR1(52,69)
      VRR0(52,100)=4.D0*V(545)-4.D0*V(546)+QCx*VRR0(52,70)+HfxZpE*VRR1(34,70)+WQx*VRR1(52,70)
      VRR0(52,101)=V(548)+V(549)+V(551)+QCx*VRR0(52,71)+WQx*VRR1(52,71)
      VRR0(52,102)=2.D0*V(552)+V(553)-2.D0*V(554)+QCx*VRR0(52,72)+WQx*VRR1(52,72)
      VRR0(52,103)=V(516)+2.D0*V(547)-2.D0*V(550)+QCy*VRR0(52,72)+WQy*VRR1(52,72)
      VRR0(52,104)=V(555)+V(556)+V(557)+QCy*VRR0(52,73)+WQy*VRR1(52,73)
      VRR0(52,105)=4.D0*V(558)-4.D0*V(559)+QCy*VRR0(52,74)+HfxZpE*VRR1(33,74)+WQy*VRR1(52,74)
      VRR0(52,106)=3.D0*V(560)+V(561)-3.D0*V(562)+QCx*VRR0(52,75)+WQx*VRR1(52,75)
      VRR0(52,107)=V(564)+V(565)+V(567)+QCx*VRR0(52,76)+WQx*VRR1(52,76)
      VRR0(52,108)=3.D0*V(402)+2.D0*V(537)-2.D0*V(540)+QCz*VRR0(52,72)+WQz*VRR1(52,72)
      VRR0(52,109)=V(564)+V(567)+V(568)+QCy*VRR0(52,77)+WQy*VRR1(52,77)
      VRR0(52,110)=3.D0*V(569)+V(570)-3.D0*V(571)+QCy*VRR0(52,78)+WQy*VRR1(52,78)
      VRR0(52,111)=3.D0*V(410)+3.D0*V(545)-3.D0*V(546)+QCz*VRR0(52,75)+WQz*VRR1(52,75)
      VRR0(52,112)=3.D0*V(414)+V(548)+V(551)+QCz*VRR0(52,76)+WQz*VRR1(52,76)
      VRR0(52,113)=3.D0*V(454)+V(555)+V(557)+QCz*VRR0(52,77)+WQz*VRR1(52,77)
      VRR0(52,114)=3.D0*V(456)+3.D0*V(558)-3.D0*V(559)+QCz*VRR0(52,78)+WQz*VRR1(52,78)
      VRR0(52,115)=4.D0*V(560)-4.D0*V(562)+QCz*VRR0(52,79)+3.D0*HfxZpE*VRR1(31,79)+WQz*VRR1(52,79)
      VRR0(52,116)=4.D0*V(563)-4.D0*V(566)+QCz*VRR0(52,80)+3.D0*HfxZpE*VRR1(31,80)+WQz*VRR1(52,80)
      VRR0(52,117)=4.D0*V(569)-4.D0*V(571)+QCz*VRR0(52,81)+3.D0*HfxZpE*VRR1(31,81)+WQz*VRR1(52,81)
      VRR0(52,118)=5.D0*r1x2E*VRR0(52,54)+QCz*VRR0(52,82)+3.D0*HfxZpE*VRR1(31,82)-5.D0*r1x2E*ZxZpE*VRR1(52,54)+WQz*VRR1(52,82)
      VRR0(52,119)=5.D0*r1x2E*VRR0(52,55)+QCz*VRR0(52,83)+3.D0*HfxZpE*VRR1(31,83)-5.D0*r1x2E*ZxZpE*VRR1(52,55)+WQz*VRR1(52,83)
      VRR0(52,120)=6.D0*r1x2E*VRR0(52,56)+QCz*VRR0(52,84)+3.D0*HfxZpE*VRR1(31,84)-6.D0*r1x2E*ZxZpE*VRR1(52,56)+WQz*VRR1(52,84)
      VRR0(53,85)=6.D0*r1x2E*VRR0(53,36)+QCx*VRR0(53,57)-6.D0*r1x2E*ZxZpE*VRR1(53,36)+WQx*VRR1(53,57)
      VRR0(53,86)=5.D0*r1x2E*VRR0(53,37)+QCx*VRR0(53,58)-5.D0*r1x2E*ZxZpE*VRR1(53,37)+WQx*VRR1(53,58)
      VRR0(53,87)=4.D0*V(572)-4.D0*V(573)+QCx*VRR0(53,59)+WQx*VRR1(53,59)
      VRR0(53,88)=3.D0*V(574)-3.D0*V(575)+QCx*VRR0(53,60)+WQx*VRR1(53,60)
      VRR0(53,89)=2.D0*V(535)+3.D0*V(572)-3.D0*V(573)+QCy*VRR0(53,60)+WQy*VRR1(53,60)
      VRR0(53,90)=4.D0*V(574)-4.D0*V(575)+QCy*VRR0(53,61)+2.D0*HfxZpE*VRR1(34,61)+WQy*VRR1(53,61)
      VRR0(53,91)=5.D0*r1x2E*VRR0(53,40)+QCy*VRR0(53,62)+2.D0*HfxZpE*VRR1(34,62)-5.D0*r1x2E*ZxZpE*VRR1(53,40)+WQy*VRR1(53,62)
      VRR0(53,92)=6.D0*r1x2E*VRR0(53,41)+QCy*VRR0(53,63)+2.D0*HfxZpE*VRR1(34,63)-6.D0*r1x2E*ZxZpE*VRR1(53,41)+WQy*VRR1(53,63)
      VRR0(53,93)=5.D0*r1x2E*VRR0(53,42)+QCx*VRR0(53,64)-5.D0*r1x2E*ZxZpE*VRR1(53,42)+WQx*VRR1(53,64)
      VRR0(53,94)=4.D0*r1x2E*VRR0(53,43)+QCx*VRR0(53,65)-4.D0*r1x2E*ZxZpE*VRR1(53,43)+WQx*VRR1(53,65)
      VRR0(53,95)=V(577)+V(579)+QCx*VRR0(53,66)+WQx*VRR1(53,66)
      VRR0(53,96)=2.D0*V(580)-2.D0*V(581)+QCx*VRR0(53,67)+WQx*VRR1(53,67)
      VRR0(53,97)=V(577)+V(579)+V(582)+QCy*VRR0(53,67)+WQy*VRR1(53,67)
      VRR0(53,98)=4.D0*V(580)-4.D0*V(581)+QCy*VRR0(53,68)+2.D0*HfxZpE*VRR1(34,68)+WQy*VRR1(53,68)
      VRR0(53,99)=5.D0*r1x2E*VRR0(53,46)+QCy*VRR0(53,69)+2.D0*HfxZpE*VRR1(34,69)-5.D0*r1x2E*ZxZpE*VRR1(53,46)+WQy*VRR1(53,69)
      VRR0(53,100)=4.D0*V(583)-4.D0*V(584)+QCx*VRR0(53,70)+WQx*VRR1(53,70)
      VRR0(53,101)=V(586)+V(588)+QCx*VRR0(53,71)+WQx*VRR1(53,71)
      VRR0(53,102)=2.D0*V(589)-2.D0*V(590)+QCx*VRR0(53,72)+WQx*VRR1(53,72)
      VRR0(53,103)=2.D0*V(553)+2.D0*V(585)-2.D0*V(587)+QCy*VRR0(53,72)+WQy*VRR1(53,72)
      VRR0(53,104)=V(591)+2.D0*V(592)+V(593)+QCy*VRR0(53,73)+WQy*VRR1(53,73)
      VRR0(53,105)=4.D0*V(594)-4.D0*V(595)+QCy*VRR0(53,74)+2.D0*HfxZpE*VRR1(34,74)+WQy*VRR1(53,74)
      VRR0(53,106)=3.D0*V(596)-3.D0*V(597)+QCx*VRR0(53,75)+WQx*VRR1(53,75)
      VRR0(53,107)=V(599)+V(601)+QCx*VRR0(53,76)+WQx*VRR1(53,76)
      VRR0(53,108)=V(476)+2.D0*V(576)-2.D0*V(578)+QCz*VRR0(53,72)+WQz*VRR1(53,72)
      VRR0(53,109)=V(599)+V(601)+2.D0*V(602)+QCy*VRR0(53,77)+WQy*VRR1(53,77)
      VRR0(53,110)=3.D0*V(603)+2.D0*V(604)-3.D0*V(605)+QCy*VRR0(53,78)+WQy*VRR1(53,78)
      VRR0(53,111)=3.D0*V(447)+3.D0*V(583)-3.D0*V(584)+QCz*VRR0(53,75)+WQz*VRR1(53,75)
      VRR0(53,112)=3.D0*V(451)+V(586)+V(588)+QCz*VRR0(53,76)+WQz*VRR1(53,76)
      VRR0(53,113)=V(488)+V(591)+V(593)+QCz*VRR0(53,77)+WQz*VRR1(53,77)
      VRR0(53,114)=V(491)+3.D0*V(594)-3.D0*V(595)+QCz*VRR0(53,78)+WQz*VRR1(53,78)
      VRR0(53,115)=4.D0*V(596)-4.D0*V(597)+QCz*VRR0(53,79)+3.D0*HfxZpE*VRR1(32,79)+WQz*VRR1(53,79)
      VRR0(53,116)=4.D0*V(598)-4.D0*V(600)+QCz*VRR0(53,80)+3.D0*HfxZpE*VRR1(32,80)+WQz*VRR1(53,80)
      VRR0(53,117)=4.D0*V(603)-4.D0*V(605)+QCz*VRR0(53,81)+3.D0*HfxZpE*VRR1(32,81)+WQz*VRR1(53,81)
      VRR0(53,118)=5.D0*r1x2E*VRR0(53,54)+QCz*VRR0(53,82)+3.D0*HfxZpE*VRR1(32,82)-5.D0*r1x2E*ZxZpE*VRR1(53,54)+WQz*VRR1(53,82)
      VRR0(53,119)=5.D0*r1x2E*VRR0(53,55)+QCz*VRR0(53,83)+3.D0*HfxZpE*VRR1(32,83)-5.D0*r1x2E*ZxZpE*VRR1(53,55)+WQz*VRR1(53,83)
      VRR0(53,120)=6.D0*r1x2E*VRR0(53,56)+QCz*VRR0(53,84)+3.D0*HfxZpE*VRR1(32,84)-6.D0*r1x2E*ZxZpE*VRR1(53,56)+WQz*VRR1(53,84)
      VRR0(54,85)=6.D0*r1x2E*VRR0(54,36)+QCx*VRR0(54,57)+HfxZpE*VRR1(35,57)-6.D0*r1x2E*ZxZpE*VRR1(54,36)+WQx*VRR1(54,57)
      VRR0(54,86)=5.D0*r1x2E*VRR0(54,37)+QCx*VRR0(54,58)+HfxZpE*VRR1(35,58)-5.D0*r1x2E*ZxZpE*VRR1(54,37)+WQx*VRR1(54,58)
      VRR0(54,87)=4.D0*V(606)+V(607)-4.D0*V(608)+QCx*VRR0(54,59)+WQx*VRR1(54,59)
      VRR0(54,88)=3.D0*V(609)+V(610)-3.D0*V(611)+QCx*VRR0(54,60)+WQx*VRR1(54,60)
      VRR0(54,89)=3.D0*V(606)-3.D0*V(608)+QCy*VRR0(54,60)+WQy*VRR1(54,60)
      VRR0(54,90)=4.D0*V(609)-4.D0*V(611)+QCy*VRR0(54,61)+WQy*VRR1(54,61)
      VRR0(54,91)=5.D0*r1x2E*VRR0(54,40)+QCy*VRR0(54,62)-5.D0*r1x2E*ZxZpE*VRR1(54,40)+WQy*VRR1(54,62)
      VRR0(54,92)=6.D0*r1x2E*VRR0(54,41)+QCy*VRR0(54,63)-6.D0*r1x2E*ZxZpE*VRR1(54,41)+WQy*VRR1(54,63)
      VRR0(54,93)=5.D0*r1x2E*VRR0(54,42)+QCx*VRR0(54,64)+HfxZpE*VRR1(35,64)-5.D0*r1x2E*ZxZpE*VRR1(54,42)+WQx*VRR1(54,64)
      VRR0(54,94)=V(612)+4.D0*r1x2E*VRR0(54,43)+QCx*VRR0(54,65)-4.D0*r1x2E*ZxZpE*VRR1(54,43)+WQx*VRR1(54,65)
      VRR0(54,95)=V(614)+V(615)+V(617)+QCx*VRR0(54,66)+WQx*VRR1(54,66)
      VRR0(54,96)=V(496)+3.D0*r1x2Z*VRR0(18,96)+PAz*VRR0(33,96)-3.D0*ExZpE*r1x2Z*VRR1(18,96)+WPz*VRR1(33,96)
      VRR0(54,97)=V(614)+V(617)+QCy*VRR0(54,67)+WQy*VRR1(54,67)
      VRR0(54,98)=4.D0*r1x2E*VRR0(54,45)+QCy*VRR0(54,68)-4.D0*r1x2E*ZxZpE*VRR1(54,45)+WQy*VRR1(54,68)
      VRR0(54,99)=5.D0*r1x2E*VRR0(54,46)+QCy*VRR0(54,69)-5.D0*r1x2E*ZxZpE*VRR1(54,46)+WQy*VRR1(54,69)
      VRR0(54,100)=4.D0*V(618)+V(619)-4.D0*V(620)+QCx*VRR0(54,70)+WQx*VRR1(54,70)
      VRR0(54,101)=V(622)+V(623)+V(625)+QCx*VRR0(54,71)+WQx*VRR1(54,71)
      VRR0(54,102)=V(501)+3.D0*r1x2Z*VRR0(18,102)+PAz*VRR0(33,102)-3.D0*ExZpE*r1x2Z*VRR1(18,102)+WPz*VRR1(33,102)
      VRR0(54,103)=V(506)+3.D0*r1x2Z*VRR0(18,103)+PAz*VRR0(33,103)-3.D0*ExZpE*r1x2Z*VRR1(18,103)+WPz*VRR1(33,103)
      VRR0(54,104)=V(627)+V(629)+QCy*VRR0(54,73)+WQy*VRR1(54,73)
      VRR0(54,105)=4.D0*V(630)-4.D0*V(631)+QCy*VRR0(54,74)+WQy*VRR1(54,74)
      VRR0(54,106)=3.D0*V(632)+V(633)-3.D0*V(634)+QCx*VRR0(54,75)+WQx*VRR1(54,75)
      VRR0(54,107)=3.D0*V(512)+3.D0*r1x2Z*VRR0(18,107)+PAz*VRR0(33,107)-3.D0*ExZpE*r1x2Z*VRR1(18,107)+WPz*VRR1(33,107)
      VRR0(54,108)=3.D0*V(516)+3.D0*r1x2Z*VRR0(18,108)+PAz*VRR0(33,108)-3.D0*ExZpE*r1x2Z*VRR1(18,108)+WPz*VRR1(33,108)
      VRR0(54,109)=3.D0*V(556)+3.D0*r1x2Z*VRR0(18,109)+PAz*VRR0(33,109)-3.D0*ExZpE*r1x2Z*VRR1(18,109)+WPz*VRR1(33,109)
      VRR0(54,110)=3.D0*V(635)-3.D0*V(636)+QCy*VRR0(54,78)+WQy*VRR1(54,78)
      VRR0(54,111)=4.D0*V(523)+3.D0*V(618)-3.D0*V(620)+QCz*VRR0(54,75)+WQz*VRR1(54,75)
      VRR0(54,112)=4.D0*V(527)+V(622)+V(625)+QCz*VRR0(54,76)+WQz*VRR1(54,76)
      VRR0(54,113)=4.D0*V(568)+V(627)+V(629)+QCz*VRR0(54,77)+WQz*VRR1(54,77)
      VRR0(54,114)=4.D0*V(570)+3.D0*V(630)-3.D0*V(631)+QCz*VRR0(54,78)+WQz*VRR1(54,78)
      VRR0(54,115)=4.D0*V(632)-4.D0*V(634)+QCz*VRR0(54,79)+4.D0*HfxZpE*VRR1(33,79)+WQz*VRR1(54,79)
      VRR0(54,116)=4.D0*r1x2E*VRR0(54,52)+QCz*VRR0(54,80)+4.D0*HfxZpE*VRR1(33,80)-4.D0*r1x2E*ZxZpE*VRR1(54,52)+WQz*VRR1(54,80)
      VRR0(54,117)=4.D0*V(635)-4.D0*V(636)+QCz*VRR0(54,81)+4.D0*HfxZpE*VRR1(33,81)+WQz*VRR1(54,81)
      VRR0(54,118)=5.D0*r1x2E*VRR0(54,54)+QCz*VRR0(54,82)+4.D0*HfxZpE*VRR1(33,82)-5.D0*r1x2E*ZxZpE*VRR1(54,54)+WQz*VRR1(54,82)
      VRR0(54,119)=5.D0*r1x2E*VRR0(54,55)+QCz*VRR0(54,83)+4.D0*HfxZpE*VRR1(33,83)-5.D0*r1x2E*ZxZpE*VRR1(54,55)+WQz*VRR1(54,83)
      VRR0(54,120)=6.D0*r1x2E*VRR0(54,56)+QCz*VRR0(54,84)+4.D0*HfxZpE*VRR1(33,84)-6.D0*r1x2E*ZxZpE*VRR1(54,56)+WQz*VRR1(54,84)
      VRR0(55,85)=6.D0*r1x2E*VRR0(55,36)+QCx*VRR0(55,57)-6.D0*r1x2E*ZxZpE*VRR1(55,36)+WQx*VRR1(55,57)
      VRR0(55,86)=5.D0*r1x2E*VRR0(55,37)+QCx*VRR0(55,58)-5.D0*r1x2E*ZxZpE*VRR1(55,37)+WQx*VRR1(55,58)
      VRR0(55,87)=4.D0*V(637)-4.D0*V(638)+QCx*VRR0(55,59)+WQx*VRR1(55,59)
      VRR0(55,88)=3.D0*V(639)-3.D0*V(640)+QCx*VRR0(55,60)+WQx*VRR1(55,60)
      VRR0(55,89)=V(610)+3.D0*V(637)-3.D0*V(638)+QCy*VRR0(55,60)+WQy*VRR1(55,60)
      VRR0(55,90)=4.D0*V(639)-4.D0*V(640)+V(641)+QCy*VRR0(55,61)+WQy*VRR1(55,61)
      VRR0(55,91)=5.D0*r1x2E*VRR0(55,40)+QCy*VRR0(55,62)+HfxZpE*VRR1(35,62)-5.D0*r1x2E*ZxZpE*VRR1(55,40)+WQy*VRR1(55,62)
      VRR0(55,92)=6.D0*r1x2E*VRR0(55,41)+QCy*VRR0(55,63)+HfxZpE*VRR1(35,63)-6.D0*r1x2E*ZxZpE*VRR1(55,41)+WQy*VRR1(55,63)
      VRR0(55,93)=5.D0*r1x2E*VRR0(55,42)+QCx*VRR0(55,64)-5.D0*r1x2E*ZxZpE*VRR1(55,42)+WQx*VRR1(55,64)
      VRR0(55,94)=4.D0*r1x2E*VRR0(55,43)+QCx*VRR0(55,65)-4.D0*r1x2E*ZxZpE*VRR1(55,43)+WQx*VRR1(55,65)
      VRR0(55,95)=V(643)+V(645)+QCx*VRR0(55,66)+WQx*VRR1(55,66)
      VRR0(55,96)=V(535)+3.D0*r1x2Z*VRR0(19,96)+PAz*VRR0(34,96)-3.D0*ExZpE*r1x2Z*VRR1(19,96)+WPz*VRR1(34,96)
      VRR0(55,97)=V(643)+V(645)+V(646)+QCy*VRR0(55,67)+WQy*VRR1(55,67)
      VRR0(55,98)=V(647)+4.D0*r1x2E*VRR0(55,45)+QCy*VRR0(55,68)-4.D0*r1x2E*ZxZpE*VRR1(55,45)+WQy*VRR1(55,68)
      VRR0(55,99)=5.D0*r1x2E*VRR0(55,46)+QCy*VRR0(55,69)+HfxZpE*VRR1(35,69)-5.D0*r1x2E*ZxZpE*VRR1(55,46)+WQy*VRR1(55,69)
      VRR0(55,100)=4.D0*V(648)-4.D0*V(649)+QCx*VRR0(55,70)+WQx*VRR1(55,70)
      VRR0(55,101)=V(651)+V(653)+QCx*VRR0(55,71)+WQx*VRR1(55,71)
      VRR0(55,102)=2.D0*V(539)+3.D0*r1x2Z*VRR0(19,102)+PAz*VRR0(34,102)-3.D0*ExZpE*r1x2Z*VRR1(19,102)+WPz*VRR1(34,102)
      VRR0(55,103)=V(582)+3.D0*r1x2Z*VRR0(19,103)+PAz*VRR0(34,103)-3.D0*ExZpE*r1x2Z*VRR1(19,103)+WPz*VRR1(34,103)
      VRR0(55,104)=V(655)+V(656)+V(658)+QCy*VRR0(55,73)+WQy*VRR1(55,73)
      VRR0(55,105)=4.D0*V(659)+V(660)-4.D0*V(661)+QCy*VRR0(55,74)+WQy*VRR1(55,74)
      VRR0(55,106)=3.D0*V(662)-3.D0*V(663)+QCx*VRR0(55,75)+WQx*VRR1(55,75)
      VRR0(55,107)=3.D0*V(549)+3.D0*r1x2Z*VRR0(19,107)+PAz*VRR0(34,107)-3.D0*ExZpE*r1x2Z*VRR1(19,107)+WPz*VRR1(34,107)
      VRR0(55,108)=3.D0*V(553)+3.D0*r1x2Z*VRR0(19,108)+PAz*VRR0(34,108)-3.D0*ExZpE*r1x2Z*VRR1(19,108)+WPz*VRR1(34,108)
      VRR0(55,109)=3.D0*V(592)+3.D0*r1x2Z*VRR0(19,109)+PAz*VRR0(34,109)-3.D0*ExZpE*r1x2Z*VRR1(19,109)+WPz*VRR1(34,109)
      VRR0(55,110)=3.D0*V(664)+V(665)-3.D0*V(666)+QCy*VRR0(55,78)+WQy*VRR1(55,78)
      VRR0(55,111)=4.D0*V(561)+3.D0*V(648)-3.D0*V(649)+QCz*VRR0(55,75)+WQz*VRR1(55,75)
      VRR0(55,112)=4.D0*V(565)+V(651)+V(653)+QCz*VRR0(55,76)+WQz*VRR1(55,76)
      VRR0(55,113)=4.D0*V(602)+V(655)+V(658)+QCz*VRR0(55,77)+WQz*VRR1(55,77)
      VRR0(55,114)=4.D0*V(604)+3.D0*V(659)-3.D0*V(661)+QCz*VRR0(55,78)+WQz*VRR1(55,78)
      VRR0(55,115)=4.D0*V(662)-4.D0*V(663)+QCz*VRR0(55,79)+4.D0*HfxZpE*VRR1(34,79)+WQz*VRR1(55,79)
      VRR0(55,116)=4.D0*r1x2E*VRR0(55,52)+QCz*VRR0(55,80)+4.D0*HfxZpE*VRR1(34,80)-4.D0*r1x2E*ZxZpE*VRR1(55,52)+WQz*VRR1(55,80)
      VRR0(55,117)=4.D0*V(664)-4.D0*V(666)+QCz*VRR0(55,81)+4.D0*HfxZpE*VRR1(34,81)+WQz*VRR1(55,81)
      VRR0(55,118)=5.D0*r1x2E*VRR0(55,54)+QCz*VRR0(55,82)+4.D0*HfxZpE*VRR1(34,82)-5.D0*r1x2E*ZxZpE*VRR1(55,54)+WQz*VRR1(55,82)
      VRR0(55,119)=5.D0*r1x2E*VRR0(55,55)+QCz*VRR0(55,83)+4.D0*HfxZpE*VRR1(34,83)-5.D0*r1x2E*ZxZpE*VRR1(55,55)+WQz*VRR1(55,83)
      VRR0(55,120)=6.D0*r1x2E*VRR0(55,56)+QCz*VRR0(55,84)+4.D0*HfxZpE*VRR1(34,84)-6.D0*r1x2E*ZxZpE*VRR1(55,56)+WQz*VRR1(55,84)
      VRR0(56,85)=6.D0*r1x2E*VRR0(56,36)+QCx*VRR0(56,57)-6.D0*r1x2E*ZxZpE*VRR1(56,36)+WQx*VRR1(56,57)
      VRR0(56,86)=5.D0*r1x2E*VRR0(56,37)+QCx*VRR0(56,58)-5.D0*r1x2E*ZxZpE*VRR1(56,37)+WQx*VRR1(56,58)
      VRR0(56,87)=4.D0*r1x2E*VRR0(56,38)+QCx*VRR0(56,59)-4.D0*r1x2E*ZxZpE*VRR1(56,38)+WQx*VRR1(56,59)
      VRR0(56,88)=4.D0*r1x2Z*VRR0(20,88)+PAz*VRR0(35,88)-4.D0*ExZpE*r1x2Z*VRR1(20,88)+WPz*VRR1(35,88)
      VRR0(56,89)=4.D0*r1x2Z*VRR0(20,89)+PAz*VRR0(35,89)-4.D0*ExZpE*r1x2Z*VRR1(20,89)+WPz*VRR1(35,89)
      VRR0(56,90)=4.D0*r1x2E*VRR0(56,39)+QCy*VRR0(56,61)-4.D0*r1x2E*ZxZpE*VRR1(56,39)+WQy*VRR1(56,61)
      VRR0(56,91)=5.D0*r1x2E*VRR0(56,40)+QCy*VRR0(56,62)-5.D0*r1x2E*ZxZpE*VRR1(56,40)+WQy*VRR1(56,62)
      VRR0(56,92)=6.D0*r1x2E*VRR0(56,41)+QCy*VRR0(56,63)-6.D0*r1x2E*ZxZpE*VRR1(56,41)+WQy*VRR1(56,63)
      VRR0(56,93)=5.D0*r1x2E*VRR0(56,42)+QCx*VRR0(56,64)-5.D0*r1x2E*ZxZpE*VRR1(56,42)+WQx*VRR1(56,64)
      VRR0(56,94)=4.D0*r1x2E*VRR0(56,43)+QCx*VRR0(56,65)-4.D0*r1x2E*ZxZpE*VRR1(56,43)+WQx*VRR1(56,65)
      VRR0(56,95)=V(607)+4.D0*r1x2Z*VRR0(20,95)+PAz*VRR0(35,95)-4.D0*ExZpE*r1x2Z*VRR1(20,95)+WPz*VRR1(35,95)
      VRR0(56,96)=V(610)+4.D0*r1x2Z*VRR0(20,96)+PAz*VRR0(35,96)-4.D0*ExZpE*r1x2Z*VRR1(20,96)+WPz*VRR1(35,96)
      VRR0(56,97)=V(641)+4.D0*r1x2Z*VRR0(20,97)+PAz*VRR0(35,97)-4.D0*ExZpE*r1x2Z*VRR1(20,97)+WPz*VRR1(35,97)
      VRR0(56,98)=4.D0*r1x2E*VRR0(56,45)+QCy*VRR0(56,68)-4.D0*r1x2E*ZxZpE*VRR1(56,45)+WQy*VRR1(56,68)
      VRR0(56,99)=5.D0*r1x2E*VRR0(56,46)+QCy*VRR0(56,69)-5.D0*r1x2E*ZxZpE*VRR1(56,46)+WQy*VRR1(56,69)
      VRR0(56,100)=4.D0*r1x2E*VRR0(56,47)+QCx*VRR0(56,70)-4.D0*r1x2E*ZxZpE*VRR1(56,47)+WQx*VRR1(56,70)
      VRR0(56,101)=2.D0*V(612)+4.D0*r1x2Z*VRR0(20,101)+PAz*VRR0(35,101)-4.D0*ExZpE*r1x2Z*VRR1(20,101)+WPz*VRR1(35,101)
      VRR0(56,102)=2.D0*V(615)+4.D0*r1x2Z*VRR0(20,102)+PAz*VRR0(35,102)-4.D0*ExZpE*r1x2Z*VRR1(20,102)+WPz*VRR1(35,102)
      VRR0(56,103)=2.D0*V(646)+4.D0*r1x2Z*VRR0(20,103)+PAz*VRR0(35,103)-4.D0*ExZpE*r1x2Z*VRR1(20,103)+WPz*VRR1(35,103)
      VRR0(56,104)=2.D0*V(647)+4.D0*r1x2Z*VRR0(20,104)+PAz*VRR0(35,104)-4.D0*ExZpE*r1x2Z*VRR1(20,104)+WPz*VRR1(35,104)
      VRR0(56,105)=4.D0*r1x2E*VRR0(56,50)+QCy*VRR0(56,74)-4.D0*r1x2E*ZxZpE*VRR1(56,50)+WQy*VRR1(56,74)
      VRR0(56,106)=3.D0*V(619)+4.D0*r1x2Z*VRR0(20,106)+PAz*VRR0(35,106)-4.D0*ExZpE*r1x2Z*VRR1(20,106)+WPz*VRR1(35,106)
      VRR0(56,107)=3.D0*V(623)+4.D0*r1x2Z*VRR0(20,107)+PAz*VRR0(35,107)-4.D0*ExZpE*r1x2Z*VRR1(20,107)+WPz*VRR1(35,107)
      VRR0(56,108)=4.D0*r1x2Z*VRR0(20,108)+PAz*VRR0(35,108)-4.D0*ExZpE*r1x2Z*VRR1(20,108)+3.D0*HfxZpE*VRR1(35,72)+WPz*VRR1(35,108)
      VRR0(56,109)=3.D0*V(656)+4.D0*r1x2Z*VRR0(20,109)+PAz*VRR0(35,109)-4.D0*ExZpE*r1x2Z*VRR1(20,109)+WPz*VRR1(35,109)
      VRR0(56,110)=3.D0*V(660)+4.D0*r1x2Z*VRR0(20,110)+PAz*VRR0(35,110)-4.D0*ExZpE*r1x2Z*VRR1(20,110)+WPz*VRR1(35,110)
      VRR0(56,111)=4.D0*V(633)+4.D0*r1x2Z*VRR0(20,111)+PAz*VRR0(35,111)-4.D0*ExZpE*r1x2Z*VRR1(20,111)+WPz*VRR1(35,111)
      VRR0(56,112)=4.D0*r1x2Z*VRR0(20,112)+PAz*VRR0(35,112)-4.D0*ExZpE*r1x2Z*VRR1(20,112)+4.D0*HfxZpE*VRR1(35,76)+WPz*VRR1(35,112)
      VRR0(56,113)=4.D0*r1x2Z*VRR0(20,113)+PAz*VRR0(35,113)-4.D0*ExZpE*r1x2Z*VRR1(20,113)+4.D0*HfxZpE*VRR1(35,77)+WPz*VRR1(35,113)
      VRR0(56,114)=4.D0*V(665)+4.D0*r1x2Z*VRR0(20,114)+PAz*VRR0(35,114)-4.D0*ExZpE*r1x2Z*VRR1(20,114)+WPz*VRR1(35,114)
      VRR0(56,115)=4.D0*r1x2E*VRR0(56,51)+QCz*VRR0(56,79)+5.D0*HfxZpE*VRR1(35,79)-4.D0*r1x2E*ZxZpE*VRR1(56,51)+WQz*VRR1(56,79)
      VRR0(56,116)=4.D0*r1x2E*VRR0(56,52)+QCz*VRR0(56,80)+5.D0*HfxZpE*VRR1(35,80)-4.D0*r1x2E*ZxZpE*VRR1(56,52)+WQz*VRR1(56,80)
      VRR0(56,117)=4.D0*r1x2E*VRR0(56,53)+QCz*VRR0(56,81)+5.D0*HfxZpE*VRR1(35,81)-4.D0*r1x2E*ZxZpE*VRR1(56,53)+WQz*VRR1(56,81)
      VRR0(56,118)=5.D0*r1x2E*VRR0(56,54)+QCz*VRR0(56,82)+5.D0*HfxZpE*VRR1(35,82)-5.D0*r1x2E*ZxZpE*VRR1(56,54)+WQz*VRR1(56,82)
      VRR0(56,119)=5.D0*r1x2E*VRR0(56,55)+QCz*VRR0(56,83)+5.D0*HfxZpE*VRR1(35,83)-5.D0*r1x2E*ZxZpE*VRR1(56,55)+WQz*VRR1(56,83)
      VRR0(56,120)=6.D0*r1x2E*VRR0(56,56)+QCz*VRR0(56,84)+5.D0*HfxZpE*VRR1(35,84)-6.D0*r1x2E*ZxZpE*VRR1(56,56)+WQz*VRR1(56,84)
END SUBROUTINE VRRh0j0
