!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0g0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(21,14)
      V(2)=HfxZpE*VRR1(21,20)
      V(3)=r1x2Z*VRR0(12,23)
      V(4)=ExZpE*r1x2Z*VRR1(12,23)
      V(5)=HfxZpE*VRR1(22,13)
      V(6)=2.D0*V(5)
      V(7)=HfxZpE*VRR1(22,14)
      V(8)=r1x2Z*VRR0(12,27)
      V(9)=ExZpE*r1x2Z*VRR1(12,27)
      V(10)=r1x2Z*VRR0(12,28)
      V(11)=ExZpE*r1x2Z*VRR1(12,28)
      V(12)=HfxZpE*VRR1(22,17)
      V(13)=r1x2Z*VRR0(12,30)
      V(14)=ExZpE*r1x2Z*VRR1(12,30)
      V(15)=HfxZpE*VRR1(22,18)
      V(16)=r1x2Z*VRR0(12,31)
      V(17)=ExZpE*r1x2Z*VRR1(12,31)
      V(18)=HfxZpE*VRR1(22,19)
      V(19)=r1x2Z*VRR0(12,32)
      V(20)=ExZpE*r1x2Z*VRR1(12,32)
      V(21)=HfxZpE*VRR1(22,20)
      V(22)=r1x2E*VRR0(38,6)
      V(23)=2.D0*V(22)
      V(24)=HfxZpE*VRR1(23,12)
      V(25)=r1x2E*ZxZpE*VRR1(38,6)
      V(26)=-2.D0*V(25)
      V(27)=r1x2Z*VRR0(13,23)
      V(28)=ExZpE*r1x2Z*VRR1(13,23)
      V(29)=HfxZpE*VRR1(23,13)
      V(30)=r1x2E*VRR0(38,8)
      V(31)=2.D0*V(30)
      V(32)=HfxZpE*VRR1(23,15)
      V(33)=r1x2E*ZxZpE*VRR1(38,8)
      V(34)=-2.D0*V(33)
      V(35)=r1x2Z*VRR0(13,27)
      V(36)=ExZpE*r1x2Z*VRR1(13,27)
      V(37)=HfxZpE*VRR1(23,16)
      V(38)=2.D0*V(37)
      V(39)=r1x2Z*VRR0(13,28)
      V(40)=ExZpE*r1x2Z*VRR1(13,28)
      V(41)=HfxZpE*VRR1(23,17)
      V(42)=r1x2E*VRR0(38,9)
      V(43)=2.D0*V(42)
      V(44)=r1x2E*ZxZpE*VRR1(38,9)
      V(45)=-2.D0*V(44)
      V(46)=r1x2Z*VRR0(13,30)
      V(47)=ExZpE*r1x2Z*VRR1(13,30)
      V(48)=HfxZpE*VRR1(23,18)
      V(49)=r1x2Z*VRR0(13,31)
      V(50)=ExZpE*r1x2Z*VRR1(13,31)
      V(51)=HfxZpE*VRR1(23,19)
      V(52)=r1x2Z*VRR0(13,32)
      V(53)=ExZpE*r1x2Z*VRR1(13,32)
      V(54)=HfxZpE*VRR1(24,11)
      V(55)=r1x2E*VRR0(39,6)
      V(56)=2.D0*V(55)
      V(57)=HfxZpE*VRR1(24,12)
      V(58)=2.D0*V(57)
      V(59)=r1x2E*ZxZpE*VRR1(39,6)
      V(60)=-2.D0*V(59)
      V(61)=r1x2E*VRR0(39,8)
      V(62)=2.D0*V(61)
      V(63)=HfxZpE*VRR1(24,15)
      V(64)=r1x2E*ZxZpE*VRR1(39,8)
      V(65)=-2.D0*V(64)
      V(66)=r1x2E*VRR0(39,9)
      V(67)=2.D0*V(66)
      V(68)=r1x2E*ZxZpE*VRR1(39,9)
      V(69)=-2.D0*V(68)
      V(70)=HfxZpE*VRR1(25,11)
      V(71)=HfxZpE*VRR1(24,18)
      V(72)=HfxZpE*VRR1(24,19)
      V(73)=HfxZpE*VRR1(24,20)
      V(74)=HfxZpE*VRR1(25,20)
      V(75)=r1x2Z*VRR0(15,23)
      V(76)=ExZpE*r1x2Z*VRR1(15,23)
      V(77)=HfxZpE*VRR1(26,13)
      V(78)=HfxZpE*VRR1(26,14)
      V(79)=r1x2Z*VRR0(15,27)
      V(80)=ExZpE*r1x2Z*VRR1(15,27)
      V(81)=r1x2Z*VRR0(15,28)
      V(82)=ExZpE*r1x2Z*VRR1(15,28)
      V(83)=HfxZpE*VRR1(26,17)
      V(84)=r1x2Z*VRR0(15,30)
      V(85)=ExZpE*r1x2Z*VRR1(15,30)
      V(86)=HfxZpE*VRR1(26,18)
      V(87)=2.D0*V(86)
      V(88)=r1x2Z*VRR0(15,31)
      V(89)=ExZpE*r1x2Z*VRR1(15,31)
      V(90)=HfxZpE*VRR1(26,19)
      V(91)=r1x2Z*VRR0(15,32)
      V(92)=ExZpE*r1x2Z*VRR1(15,32)
      V(93)=HfxZpE*VRR1(26,20)
      V(94)=r1x2E*VRR0(43,6)
      V(95)=2.D0*V(94)
      V(96)=r1x2E*ZxZpE*VRR1(43,6)
      V(97)=-2.D0*V(96)
      V(98)=r1x2Z*VRR0(16,23)
      V(99)=2.D0*V(98)
      V(100)=ExZpE*r1x2Z*VRR1(16,23)
      V(101)=-2.D0*V(100)
      V(102)=HfxZpE*VRR1(27,13)
      V(103)=2.D0*V(102)
      V(104)=r1x2E*VRR0(43,8)
      V(105)=2.D0*V(104)
      V(106)=r1x2E*ZxZpE*VRR1(43,8)
      V(107)=-2.D0*V(106)
      V(108)=r1x2Z*VRR0(16,27)
      V(109)=2.D0*V(108)
      V(110)=ExZpE*r1x2Z*VRR1(16,27)
      V(111)=-2.D0*V(110)
      V(112)=HfxZpE*VRR1(27,16)
      V(113)=2.D0*V(112)
      V(114)=r1x2Z*VRR0(16,28)
      V(115)=2.D0*V(114)
      V(116)=ExZpE*r1x2Z*VRR1(16,28)
      V(117)=-2.D0*V(116)
      V(118)=HfxZpE*VRR1(27,17)
      V(119)=r1x2E*VRR0(43,9)
      V(120)=2.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(43,9)
      V(122)=-2.D0*V(121)
      V(123)=r1x2Z*VRR0(16,30)
      V(124)=2.D0*V(123)
      V(125)=ExZpE*r1x2Z*VRR1(16,30)
      V(126)=-2.D0*V(125)
      V(127)=HfxZpE*VRR1(27,18)
      V(128)=2.D0*V(127)
      V(129)=r1x2Z*VRR0(16,31)
      V(130)=2.D0*V(129)
      V(131)=ExZpE*r1x2Z*VRR1(16,31)
      V(132)=-2.D0*V(131)
      V(133)=HfxZpE*VRR1(27,19)
      V(134)=r1x2Z*VRR0(16,32)
      V(135)=2.D0*V(134)
      V(136)=ExZpE*r1x2Z*VRR1(16,32)
      V(137)=-2.D0*V(136)
      V(138)=r1x2E*VRR0(44,6)
      V(139)=2.D0*V(138)
      V(140)=HfxZpE*VRR1(28,12)
      V(141)=2.D0*V(140)
      V(142)=r1x2E*ZxZpE*VRR1(44,6)
      V(143)=-2.D0*V(142)
      V(144)=r1x2E*VRR0(44,7)
      V(145)=HfxZpE*VRR1(28,13)
      V(146)=r1x2E*ZxZpE*VRR1(44,7)
      V(147)=r1x2E*VRR0(44,8)
      V(148)=2.D0*V(147)
      V(149)=HfxZpE*VRR1(28,15)
      V(150)=r1x2E*ZxZpE*VRR1(44,8)
      V(151)=-2.D0*V(150)
      V(152)=r1x2E*VRR0(44,9)
      V(153)=HfxZpE*VRR1(28,16)
      V(154)=2.D0*V(153)
      V(155)=r1x2E*ZxZpE*VRR1(44,9)
      V(156)=2.D0*V(152)
      V(157)=-2.D0*V(155)
      V(158)=r1x2E*VRR0(44,10)
      V(159)=HfxZpE*VRR1(28,18)
      V(160)=2.D0*V(159)
      V(161)=r1x2E*ZxZpE*VRR1(44,10)
      V(162)=-V(161)
      V(163)=2.D0*V(133)
      V(164)=HfxZpE*VRR1(29,11)
      V(165)=r1x2E*VRR0(45,6)
      V(166)=2.D0*V(165)
      V(167)=HfxZpE*VRR1(29,12)
      V(168)=r1x2E*ZxZpE*VRR1(45,6)
      V(169)=-2.D0*V(168)
      V(170)=r1x2E*VRR0(45,8)
      V(171)=2.D0*V(170)
      V(172)=HfxZpE*VRR1(29,15)
      V(173)=r1x2E*ZxZpE*VRR1(45,8)
      V(174)=-2.D0*V(173)
      V(175)=r1x2E*VRR0(45,9)
      V(176)=2.D0*V(175)
      V(177)=r1x2E*ZxZpE*VRR1(45,9)
      V(178)=-2.D0*V(177)
      V(179)=HfxZpE*VRR1(28,19)
      V(180)=2.D0*V(179)
      V(181)=r1x2Z*VRR0(17,23)
      V(182)=ExZpE*r1x2Z*VRR1(17,23)
      V(183)=r1x2Z*VRR0(17,27)
      V(184)=ExZpE*r1x2Z*VRR1(17,27)
      V(185)=r1x2Z*VRR0(17,28)
      V(186)=ExZpE*r1x2Z*VRR1(17,28)
      V(187)=r1x2Z*VRR0(17,30)
      V(188)=ExZpE*r1x2Z*VRR1(17,30)
      V(189)=r1x2Z*VRR0(17,31)
      V(190)=ExZpE*r1x2Z*VRR1(17,31)
      V(191)=HfxZpE*VRR1(29,18)
      V(192)=r1x2Z*VRR0(17,32)
      V(193)=ExZpE*r1x2Z*VRR1(17,32)
      V(194)=HfxZpE*VRR1(29,19)
      V(195)=2.D0*V(194)
      V(196)=HfxZpE*VRR1(29,20)
      V(197)=r1x2E*VRR0(47,6)
      V(198)=2.D0*V(197)
      V(199)=HfxZpE*VRR1(30,12)
      V(200)=r1x2E*ZxZpE*VRR1(47,6)
      V(201)=-2.D0*V(200)
      V(202)=r1x2Z*VRR0(18,23)
      V(203)=ExZpE*r1x2Z*VRR1(18,23)
      V(204)=HfxZpE*VRR1(30,13)
      V(205)=r1x2E*VRR0(47,8)
      V(206)=2.D0*V(205)
      V(207)=HfxZpE*VRR1(30,15)
      V(208)=r1x2E*ZxZpE*VRR1(47,8)
      V(209)=-2.D0*V(208)
      V(210)=r1x2Z*VRR0(18,27)
      V(211)=ExZpE*r1x2Z*VRR1(18,27)
      V(212)=HfxZpE*VRR1(30,16)
      V(213)=2.D0*V(212)
      V(214)=r1x2Z*VRR0(18,28)
      V(215)=ExZpE*r1x2Z*VRR1(18,28)
      V(216)=HfxZpE*VRR1(30,17)
      V(217)=r1x2E*VRR0(47,9)
      V(218)=2.D0*V(217)
      V(219)=r1x2E*ZxZpE*VRR1(47,9)
      V(220)=-2.D0*V(219)
      V(221)=r1x2Z*VRR0(18,30)
      V(222)=ExZpE*r1x2Z*VRR1(18,30)
      V(223)=HfxZpE*VRR1(30,18)
      V(224)=r1x2Z*VRR0(18,31)
      V(225)=ExZpE*r1x2Z*VRR1(18,31)
      V(226)=HfxZpE*VRR1(30,19)
      V(227)=r1x2Z*VRR0(18,32)
      V(228)=ExZpE*r1x2Z*VRR1(18,32)
      V(229)=r1x2E*VRR0(48,6)
      V(230)=2.D0*V(229)
      V(231)=HfxZpE*VRR1(31,12)
      V(232)=r1x2E*ZxZpE*VRR1(48,6)
      V(233)=-2.D0*V(232)
      V(234)=r1x2E*VRR0(48,7)
      V(235)=HfxZpE*VRR1(31,13)
      V(236)=2.D0*V(235)
      V(237)=r1x2E*ZxZpE*VRR1(48,7)
      V(238)=r1x2E*VRR0(48,8)
      V(239)=2.D0*V(238)
      V(240)=HfxZpE*VRR1(31,15)
      V(241)=2.D0*V(240)
      V(242)=r1x2E*ZxZpE*VRR1(48,8)
      V(243)=-2.D0*V(242)
      V(244)=r1x2E*VRR0(48,9)
      V(245)=HfxZpE*VRR1(31,16)
      V(246)=2.D0*V(245)
      V(247)=r1x2E*ZxZpE*VRR1(48,9)
      V(248)=2.D0*V(244)
      V(249)=-2.D0*V(247)
      V(250)=r1x2E*VRR0(48,10)
      V(251)=HfxZpE*VRR1(31,18)
      V(252)=r1x2E*ZxZpE*VRR1(48,10)
      V(253)=-V(252)
      V(254)=r1x2E*VRR0(49,6)
      V(255)=2.D0*V(254)
      V(256)=HfxZpE*VRR1(32,12)
      V(257)=r1x2E*ZxZpE*VRR1(49,6)
      V(258)=-2.D0*V(257)
      V(259)=r1x2E*VRR0(49,7)
      V(260)=HfxZpE*VRR1(32,13)
      V(261)=r1x2E*ZxZpE*VRR1(49,7)
      V(262)=r1x2E*VRR0(49,8)
      V(263)=2.D0*V(262)
      V(264)=HfxZpE*VRR1(32,15)
      V(265)=r1x2E*ZxZpE*VRR1(49,8)
      V(266)=-2.D0*V(265)
      V(267)=r1x2E*VRR0(49,9)
      V(268)=HfxZpE*VRR1(32,16)
      V(269)=r1x2E*ZxZpE*VRR1(49,9)
      V(270)=2.D0*V(267)
      V(271)=HfxZpE*VRR1(31,17)
      V(272)=2.D0*V(271)
      V(273)=-2.D0*V(269)
      V(274)=r1x2E*VRR0(49,10)
      V(275)=HfxZpE*VRR1(32,18)
      V(276)=r1x2E*ZxZpE*VRR1(49,10)
      V(277)=-V(276)
      V(278)=HfxZpE*VRR1(31,19)
      V(279)=r1x2E*VRR0(50,6)
      V(280)=2.D0*V(279)
      V(281)=r1x2E*ZxZpE*VRR1(50,6)
      V(282)=-2.D0*V(281)
      V(283)=r1x2Z*VRR0(19,23)
      V(284)=ExZpE*r1x2Z*VRR1(19,23)
      V(285)=r1x2E*VRR0(50,8)
      V(286)=2.D0*V(285)
      V(287)=r1x2E*ZxZpE*VRR1(50,8)
      V(288)=-2.D0*V(287)
      V(289)=r1x2Z*VRR0(19,27)
      V(290)=ExZpE*r1x2Z*VRR1(19,27)
      V(291)=r1x2Z*VRR0(19,28)
      V(292)=ExZpE*r1x2Z*VRR1(19,28)
      V(293)=2.D0*V(268)
      V(294)=r1x2E*VRR0(50,9)
      V(295)=2.D0*V(294)
      V(296)=HfxZpE*VRR1(32,17)
      V(297)=r1x2E*ZxZpE*VRR1(50,9)
      V(298)=-2.D0*V(297)
      V(299)=r1x2Z*VRR0(19,30)
      V(300)=ExZpE*r1x2Z*VRR1(19,30)
      V(301)=r1x2Z*VRR0(19,31)
      V(302)=ExZpE*r1x2Z*VRR1(19,31)
      V(303)=r1x2Z*VRR0(19,32)
      V(304)=ExZpE*r1x2Z*VRR1(19,32)
      V(305)=HfxZpE*VRR1(32,19)
      V(306)=HfxZpE*VRR1(33,11)
      V(307)=r1x2E*VRR0(51,6)
      V(308)=2.D0*V(307)
      V(309)=HfxZpE*VRR1(33,12)
      V(310)=r1x2E*ZxZpE*VRR1(51,6)
      V(311)=-2.D0*V(310)
      V(312)=r1x2E*VRR0(51,8)
      V(313)=2.D0*V(312)
      V(314)=HfxZpE*VRR1(33,15)
      V(315)=2.D0*V(314)
      V(316)=r1x2E*ZxZpE*VRR1(51,8)
      V(317)=-2.D0*V(316)
      V(318)=r1x2E*VRR0(51,9)
      V(319)=2.D0*V(318)
      V(320)=r1x2E*ZxZpE*VRR1(51,9)
      V(321)=-2.D0*V(320)
      V(322)=HfxZpE*VRR1(34,11)
      V(323)=r1x2E*VRR0(52,6)
      V(324)=2.D0*V(323)
      V(325)=HfxZpE*VRR1(34,12)
      V(326)=r1x2E*ZxZpE*VRR1(52,6)
      V(327)=-2.D0*V(326)
      V(328)=HfxZpE*VRR1(33,13)
      V(329)=HfxZpE*VRR1(33,14)
      V(330)=r1x2E*VRR0(52,8)
      V(331)=2.D0*V(330)
      V(332)=HfxZpE*VRR1(34,15)
      V(333)=r1x2E*ZxZpE*VRR1(52,8)
      V(334)=-2.D0*V(333)
      V(335)=r1x2E*VRR0(52,9)
      V(336)=2.D0*V(335)
      V(337)=HfxZpE*VRR1(33,17)
      V(338)=r1x2E*ZxZpE*VRR1(52,9)
      V(339)=-2.D0*V(338)
      V(340)=r1x2E*VRR0(53,6)
      V(341)=2.D0*V(340)
      V(342)=r1x2E*ZxZpE*VRR1(53,6)
      V(343)=-2.D0*V(342)
      V(344)=HfxZpE*VRR1(34,13)
      V(345)=HfxZpE*VRR1(34,14)
      V(346)=r1x2E*VRR0(53,8)
      V(347)=2.D0*V(346)
      V(348)=r1x2E*ZxZpE*VRR1(53,8)
      V(349)=-2.D0*V(348)
      V(350)=r1x2E*VRR0(53,9)
      V(351)=2.D0*V(350)
      V(352)=HfxZpE*VRR1(34,17)
      V(353)=2.D0*V(352)
      V(354)=r1x2E*ZxZpE*VRR1(53,9)
      V(355)=-2.D0*V(354)
      V(356)=HfxZpE*VRR1(35,11)
      V(357)=HfxZpE*VRR1(35,14)
      VRR0(36,21)=4.D0*r1x2Z*VRR0(11,21)+PAx*VRR0(21,21)-4.D0*ExZpE*r1x2Z*VRR1(11,21)+4.D0*HfxZpE*VRR1(21,11)+WPx*VRR1(21,21)
      VRR0(36,22)=4.D0*r1x2Z*VRR0(11,22)+PAx*VRR0(21,22)-4.D0*ExZpE*r1x2Z*VRR1(11,22)+3.D0*HfxZpE*VRR1(21,12)+WPx*VRR1(21,22)
      VRR0(36,23)=4.D0*r1x2Z*VRR0(11,23)+PAx*VRR0(21,23)-4.D0*ExZpE*r1x2Z*VRR1(11,23)+2.D0*HfxZpE*VRR1(21,13)+WPx*VRR1(21,23)
      VRR0(36,24)=V(1)+4.D0*r1x2Z*VRR0(11,24)+PAx*VRR0(21,24)-4.D0*ExZpE*r1x2Z*VRR1(11,24)+WPx*VRR1(21,24)
      VRR0(36,25)=4.D0*r1x2Z*VRR0(11,25)+PAx*VRR0(21,25)-4.D0*ExZpE*r1x2Z*VRR1(11,25)+WPx*VRR1(21,25)
      VRR0(36,26)=4.D0*r1x2Z*VRR0(11,26)+PAx*VRR0(21,26)-4.D0*ExZpE*r1x2Z*VRR1(11,26)+3.D0*HfxZpE*VRR1(21,15)+WPx*VRR1(21,26)
      VRR0(36,27)=4.D0*r1x2Z*VRR0(11,27)+PAx*VRR0(21,27)-4.D0*ExZpE*r1x2Z*VRR1(11,27)+2.D0*HfxZpE*VRR1(21,16)+WPx*VRR1(21,27)
      VRR0(36,28)=4.D0*r1x2Z*VRR0(11,28)+PAx*VRR0(21,28)-4.D0*ExZpE*r1x2Z*VRR1(11,28)+HfxZpE*VRR1(21,17)+WPx*VRR1(21,28)
      VRR0(36,29)=4.D0*r1x2Z*VRR0(11,29)+PAx*VRR0(21,29)-4.D0*ExZpE*r1x2Z*VRR1(11,29)+WPx*VRR1(21,29)
      VRR0(36,30)=4.D0*r1x2Z*VRR0(11,30)+PAx*VRR0(21,30)-4.D0*ExZpE*r1x2Z*VRR1(11,30)+2.D0*HfxZpE*VRR1(21,18)+WPx*VRR1(21,30)
      VRR0(36,31)=4.D0*r1x2Z*VRR0(11,31)+PAx*VRR0(21,31)-4.D0*ExZpE*r1x2Z*VRR1(11,31)+HfxZpE*VRR1(21,19)+WPx*VRR1(21,31)
      VRR0(36,32)=4.D0*r1x2Z*VRR0(11,32)+PAx*VRR0(21,32)-4.D0*ExZpE*r1x2Z*VRR1(11,32)+WPx*VRR1(21,32)
      VRR0(36,33)=V(2)+4.D0*r1x2Z*VRR0(11,33)+PAx*VRR0(21,33)-4.D0*ExZpE*r1x2Z*VRR1(11,33)+WPx*VRR1(21,33)
      VRR0(36,34)=4.D0*r1x2Z*VRR0(11,34)+PAx*VRR0(21,34)-4.D0*ExZpE*r1x2Z*VRR1(11,34)+WPx*VRR1(21,34)
      VRR0(36,35)=4.D0*r1x2Z*VRR0(11,35)+PAx*VRR0(21,35)-4.D0*ExZpE*r1x2Z*VRR1(11,35)+WPx*VRR1(21,35)
      VRR0(37,21)=3.D0*r1x2E*VRR0(37,5)+QCx*VRR0(37,11)+4.D0*HfxZpE*VRR1(22,11)-3.D0*r1x2E*ZxZpE*VRR1(37,5)+WQx*VRR1(37,11)
      VRR0(37,22)=3.D0*r1x2Z*VRR0(12,22)+PAx*VRR0(22,22)-3.D0*ExZpE*r1x2Z*VRR1(12,22)+3.D0*HfxZpE*VRR1(22,12)+WPx*VRR1(22,22)
      VRR0(37,23)=3.D0*V(3)-3.D0*V(4)+V(6)+PAx*VRR0(22,23)+WPx*VRR1(22,23)
      VRR0(37,24)=V(7)+3.D0*r1x2Z*VRR0(12,24)+PAx*VRR0(22,24)-3.D0*ExZpE*r1x2Z*VRR1(12,24)+WPx*VRR1(22,24)
      VRR0(37,25)=V(1)+3.D0*r1x2E*VRR0(37,7)+QCy*VRR0(37,14)-3.D0*r1x2E*ZxZpE*VRR1(37,7)+WQy*VRR1(37,14)
      VRR0(37,26)=3.D0*r1x2Z*VRR0(12,26)+PAx*VRR0(22,26)-3.D0*ExZpE*r1x2Z*VRR1(12,26)+3.D0*HfxZpE*VRR1(22,15)+WPx*VRR1(22,26)
      VRR0(37,27)=3.D0*V(8)-3.D0*V(9)+PAx*VRR0(22,27)+2.D0*HfxZpE*VRR1(22,16)+WPx*VRR1(22,27)
      VRR0(37,28)=3.D0*V(10)-3.D0*V(11)+V(12)+PAx*VRR0(22,28)+WPx*VRR1(22,28)
      VRR0(37,29)=3.D0*r1x2Z*VRR0(12,29)+PAx*VRR0(22,29)-3.D0*ExZpE*r1x2Z*VRR1(12,29)+WPx*VRR1(22,29)
      VRR0(37,30)=3.D0*V(13)-3.D0*V(14)+2.D0*V(15)+PAx*VRR0(22,30)+WPx*VRR1(22,30)
      VRR0(37,31)=3.D0*V(16)-3.D0*V(17)+V(18)+PAx*VRR0(22,31)+WPx*VRR1(22,31)
      VRR0(37,32)=3.D0*V(19)-3.D0*V(20)+PAx*VRR0(22,32)+WPx*VRR1(22,32)
      VRR0(37,33)=V(21)+3.D0*r1x2Z*VRR0(12,33)+PAx*VRR0(22,33)-3.D0*ExZpE*r1x2Z*VRR1(12,33)+WPx*VRR1(22,33)
      VRR0(37,34)=3.D0*r1x2Z*VRR0(12,34)+PAx*VRR0(22,34)-3.D0*ExZpE*r1x2Z*VRR1(12,34)+WPx*VRR1(22,34)
      VRR0(37,35)=3.D0*r1x2E*VRR0(37,10)+QCz*VRR0(37,20)-3.D0*r1x2E*ZxZpE*VRR1(37,10)+WQz*VRR1(37,20)
      VRR0(38,21)=3.D0*r1x2E*VRR0(38,5)+QCx*VRR0(38,11)+3.D0*HfxZpE*VRR1(23,11)-3.D0*r1x2E*ZxZpE*VRR1(38,5)+WQx*VRR1(38,11)
      VRR0(38,22)=V(23)+3.D0*V(24)+V(26)+QCx*VRR0(38,12)+WQx*VRR1(38,12)
      VRR0(38,23)=2.D0*V(27)-2.D0*V(28)+2.D0*V(29)+PAx*VRR0(23,23)+WPx*VRR1(23,23)
      VRR0(38,24)=V(6)+V(23)+V(26)+QCy*VRR0(38,13)+WQy*VRR1(38,13)
      VRR0(38,25)=2.D0*V(7)+3.D0*r1x2E*VRR0(38,7)+QCy*VRR0(38,14)-3.D0*r1x2E*ZxZpE*VRR1(38,7)+WQy*VRR1(38,14)
      VRR0(38,26)=V(31)+3.D0*V(32)+V(34)+QCx*VRR0(38,15)+WQx*VRR1(38,15)
      VRR0(38,27)=2.D0*V(35)-2.D0*V(36)+V(38)+PAx*VRR0(23,27)+WPx*VRR1(23,27)
      VRR0(38,28)=2.D0*V(39)-2.D0*V(40)+V(41)+PAx*VRR0(23,28)+WPx*VRR1(23,28)
      VRR0(38,29)=2.D0*V(12)+V(43)+V(45)+QCy*VRR0(38,17)+WQy*VRR1(38,17)
      VRR0(38,30)=2.D0*V(46)-2.D0*V(47)+2.D0*V(48)+PAx*VRR0(23,30)+WPx*VRR1(23,30)
      VRR0(38,31)=2.D0*V(49)-2.D0*V(50)+V(51)+PAx*VRR0(23,31)+WPx*VRR1(23,31)
      VRR0(38,32)=2.D0*V(52)-2.D0*V(53)+PAx*VRR0(23,32)+WPx*VRR1(23,32)
      VRR0(38,33)=V(31)+V(34)+QCz*VRR0(38,18)+WQz*VRR1(38,18)
      VRR0(38,34)=V(43)+V(45)+QCz*VRR0(38,19)+WQz*VRR1(38,19)
      VRR0(38,35)=3.D0*r1x2E*VRR0(38,10)+QCz*VRR0(38,20)-3.D0*r1x2E*ZxZpE*VRR1(38,10)+WQz*VRR1(38,20)
      VRR0(39,21)=2.D0*V(54)+3.D0*r1x2E*VRR0(39,5)+QCx*VRR0(39,11)-3.D0*r1x2E*ZxZpE*VRR1(39,5)+WQx*VRR1(39,11)
      VRR0(39,22)=V(56)+V(58)+V(60)+QCx*VRR0(39,12)+WQx*VRR1(39,12)
      VRR0(39,23)=2.D0*V(3)-2.D0*V(4)+2.D0*V(24)+PAy*VRR0(23,23)+WPy*VRR1(23,23)
      VRR0(39,24)=3.D0*V(29)+V(56)+V(60)+QCy*VRR0(39,13)+WQy*VRR1(39,13)
      VRR0(39,25)=3.D0*r1x2E*VRR0(39,7)+QCy*VRR0(39,14)+3.D0*HfxZpE*VRR1(23,14)-3.D0*r1x2E*ZxZpE*VRR1(39,7)+WQy*VRR1(39,14)
      VRR0(39,26)=V(62)+2.D0*V(63)+V(65)+QCx*VRR0(39,15)+WQx*VRR1(39,15)
      VRR0(39,27)=2.D0*V(8)-2.D0*V(9)+V(32)+PAy*VRR0(23,27)+WPy*VRR1(23,27)
      VRR0(39,28)=2.D0*V(10)-2.D0*V(11)+V(38)+PAy*VRR0(23,28)+WPy*VRR1(23,28)
      VRR0(39,29)=3.D0*V(41)+V(67)+V(69)+QCy*VRR0(39,17)+WQy*VRR1(39,17)
      VRR0(39,30)=2.D0*V(13)-2.D0*V(14)+PAy*VRR0(23,30)+WPy*VRR1(23,30)
      VRR0(39,31)=2.D0*V(16)-2.D0*V(17)+V(48)+PAy*VRR0(23,31)+WPy*VRR1(23,31)
      VRR0(39,32)=2.D0*V(19)-2.D0*V(20)+2.D0*V(51)+PAy*VRR0(23,32)+WPy*VRR1(23,32)
      VRR0(39,33)=V(62)+V(65)+QCz*VRR0(39,18)+WQz*VRR1(39,18)
      VRR0(39,34)=V(67)+V(69)+QCz*VRR0(39,19)+WQz*VRR1(39,19)
      VRR0(39,35)=3.D0*r1x2E*VRR0(39,10)+QCz*VRR0(39,20)-3.D0*r1x2E*ZxZpE*VRR1(39,10)+WQz*VRR1(39,20)
      VRR0(40,21)=V(70)+3.D0*r1x2E*VRR0(40,5)+QCx*VRR0(40,11)-3.D0*r1x2E*ZxZpE*VRR1(40,5)+WQx*VRR1(40,11)
      VRR0(40,22)=V(54)+3.D0*r1x2Z*VRR0(13,22)+PAy*VRR0(24,22)-3.D0*ExZpE*r1x2Z*VRR1(13,22)+WPy*VRR1(24,22)
      VRR0(40,23)=3.D0*V(27)-3.D0*V(28)+V(58)+PAy*VRR0(24,23)+WPy*VRR1(24,23)
      VRR0(40,24)=3.D0*r1x2Z*VRR0(13,24)+PAy*VRR0(24,24)-3.D0*ExZpE*r1x2Z*VRR1(13,24)+3.D0*HfxZpE*VRR1(24,13)+WPy*VRR1(24,24)
      VRR0(40,25)=3.D0*r1x2E*VRR0(40,7)+QCy*VRR0(40,14)+4.D0*HfxZpE*VRR1(24,14)-3.D0*r1x2E*ZxZpE*VRR1(40,7)+WQy*VRR1(40,14)
      VRR0(40,26)=3.D0*r1x2Z*VRR0(13,26)+PAy*VRR0(24,26)-3.D0*ExZpE*r1x2Z*VRR1(13,26)+WPy*VRR1(24,26)
      VRR0(40,27)=3.D0*V(35)-3.D0*V(36)+V(63)+PAy*VRR0(24,27)+WPy*VRR1(24,27)
      VRR0(40,28)=3.D0*V(39)-3.D0*V(40)+PAy*VRR0(24,28)+2.D0*HfxZpE*VRR1(24,16)+WPy*VRR1(24,28)
      VRR0(40,29)=3.D0*r1x2Z*VRR0(13,29)+PAy*VRR0(24,29)-3.D0*ExZpE*r1x2Z*VRR1(13,29)+3.D0*HfxZpE*VRR1(24,17)+WPy*VRR1(24,29)
      VRR0(40,30)=3.D0*V(46)-3.D0*V(47)+PAy*VRR0(24,30)+WPy*VRR1(24,30)
      VRR0(40,31)=3.D0*V(49)-3.D0*V(50)+V(71)+PAy*VRR0(24,31)+WPy*VRR1(24,31)
      VRR0(40,32)=3.D0*V(52)-3.D0*V(53)+2.D0*V(72)+PAy*VRR0(24,32)+WPy*VRR1(24,32)
      VRR0(40,33)=3.D0*r1x2Z*VRR0(13,33)+PAy*VRR0(24,33)-3.D0*ExZpE*r1x2Z*VRR1(13,33)+WPy*VRR1(24,33)
      VRR0(40,34)=V(73)+3.D0*r1x2Z*VRR0(13,34)+PAy*VRR0(24,34)-3.D0*ExZpE*r1x2Z*VRR1(13,34)+WPy*VRR1(24,34)
      VRR0(40,35)=3.D0*r1x2E*VRR0(40,10)+QCz*VRR0(40,20)-3.D0*r1x2E*ZxZpE*VRR1(40,10)+WQz*VRR1(40,20)
      VRR0(41,21)=4.D0*r1x2Z*VRR0(14,21)+PAy*VRR0(25,21)-4.D0*ExZpE*r1x2Z*VRR1(14,21)+WPy*VRR1(25,21)
      VRR0(41,22)=V(70)+4.D0*r1x2Z*VRR0(14,22)+PAy*VRR0(25,22)-4.D0*ExZpE*r1x2Z*VRR1(14,22)+WPy*VRR1(25,22)
      VRR0(41,23)=4.D0*r1x2Z*VRR0(14,23)+PAy*VRR0(25,23)-4.D0*ExZpE*r1x2Z*VRR1(14,23)+2.D0*HfxZpE*VRR1(25,12)+WPy*VRR1(25,23)
      VRR0(41,24)=4.D0*r1x2Z*VRR0(14,24)+PAy*VRR0(25,24)-4.D0*ExZpE*r1x2Z*VRR1(14,24)+3.D0*HfxZpE*VRR1(25,13)+WPy*VRR1(25,24)
      VRR0(41,25)=4.D0*r1x2Z*VRR0(14,25)+PAy*VRR0(25,25)-4.D0*ExZpE*r1x2Z*VRR1(14,25)+4.D0*HfxZpE*VRR1(25,14)+WPy*VRR1(25,25)
      VRR0(41,26)=4.D0*r1x2Z*VRR0(14,26)+PAy*VRR0(25,26)-4.D0*ExZpE*r1x2Z*VRR1(14,26)+WPy*VRR1(25,26)
      VRR0(41,27)=4.D0*r1x2Z*VRR0(14,27)+PAy*VRR0(25,27)-4.D0*ExZpE*r1x2Z*VRR1(14,27)+HfxZpE*VRR1(25,15)+WPy*VRR1(25,27)
      VRR0(41,28)=4.D0*r1x2Z*VRR0(14,28)+PAy*VRR0(25,28)-4.D0*ExZpE*r1x2Z*VRR1(14,28)+2.D0*HfxZpE*VRR1(25,16)+WPy*VRR1(25,28)
      VRR0(41,29)=4.D0*r1x2Z*VRR0(14,29)+PAy*VRR0(25,29)-4.D0*ExZpE*r1x2Z*VRR1(14,29)+3.D0*HfxZpE*VRR1(25,17)+WPy*VRR1(25,29)
      VRR0(41,30)=4.D0*r1x2Z*VRR0(14,30)+PAy*VRR0(25,30)-4.D0*ExZpE*r1x2Z*VRR1(14,30)+WPy*VRR1(25,30)
      VRR0(41,31)=4.D0*r1x2Z*VRR0(14,31)+PAy*VRR0(25,31)-4.D0*ExZpE*r1x2Z*VRR1(14,31)+HfxZpE*VRR1(25,18)+WPy*VRR1(25,31)
      VRR0(41,32)=4.D0*r1x2Z*VRR0(14,32)+PAy*VRR0(25,32)-4.D0*ExZpE*r1x2Z*VRR1(14,32)+2.D0*HfxZpE*VRR1(25,19)+WPy*VRR1(25,32)
      VRR0(41,33)=4.D0*r1x2Z*VRR0(14,33)+PAy*VRR0(25,33)-4.D0*ExZpE*r1x2Z*VRR1(14,33)+WPy*VRR1(25,33)
      VRR0(41,34)=V(74)+4.D0*r1x2Z*VRR0(14,34)+PAy*VRR0(25,34)-4.D0*ExZpE*r1x2Z*VRR1(14,34)+WPy*VRR1(25,34)
      VRR0(41,35)=4.D0*r1x2Z*VRR0(14,35)+PAy*VRR0(25,35)-4.D0*ExZpE*r1x2Z*VRR1(14,35)+WPy*VRR1(25,35)
      VRR0(42,21)=3.D0*r1x2E*VRR0(42,5)+QCx*VRR0(42,11)+4.D0*HfxZpE*VRR1(26,11)-3.D0*r1x2E*ZxZpE*VRR1(42,5)+WQx*VRR1(42,11)
      VRR0(42,22)=3.D0*r1x2Z*VRR0(15,22)+PAx*VRR0(26,22)-3.D0*ExZpE*r1x2Z*VRR1(15,22)+3.D0*HfxZpE*VRR1(26,12)+WPx*VRR1(26,22)
      VRR0(42,23)=3.D0*V(75)-3.D0*V(76)+2.D0*V(77)+PAx*VRR0(26,23)+WPx*VRR1(26,23)
      VRR0(42,24)=V(78)+3.D0*r1x2Z*VRR0(15,24)+PAx*VRR0(26,24)-3.D0*ExZpE*r1x2Z*VRR1(15,24)+WPx*VRR1(26,24)
      VRR0(42,25)=3.D0*r1x2E*VRR0(42,7)+QCy*VRR0(42,14)-3.D0*r1x2E*ZxZpE*VRR1(42,7)+WQy*VRR1(42,14)
      VRR0(42,26)=3.D0*r1x2Z*VRR0(15,26)+PAx*VRR0(26,26)-3.D0*ExZpE*r1x2Z*VRR1(15,26)+3.D0*HfxZpE*VRR1(26,15)+WPx*VRR1(26,26)
      VRR0(42,27)=3.D0*V(79)-3.D0*V(80)+PAx*VRR0(26,27)+2.D0*HfxZpE*VRR1(26,16)+WPx*VRR1(26,27)
      VRR0(42,28)=3.D0*V(81)-3.D0*V(82)+V(83)+PAx*VRR0(26,28)+WPx*VRR1(26,28)
      VRR0(42,29)=3.D0*r1x2Z*VRR0(15,29)+PAx*VRR0(26,29)-3.D0*ExZpE*r1x2Z*VRR1(15,29)+WPx*VRR1(26,29)
      VRR0(42,30)=3.D0*V(84)-3.D0*V(85)+V(87)+PAx*VRR0(26,30)+WPx*VRR1(26,30)
      VRR0(42,31)=3.D0*V(88)-3.D0*V(89)+V(90)+PAx*VRR0(26,31)+WPx*VRR1(26,31)
      VRR0(42,32)=3.D0*V(91)-3.D0*V(92)+PAx*VRR0(26,32)+WPx*VRR1(26,32)
      VRR0(42,33)=V(93)+3.D0*r1x2Z*VRR0(15,33)+PAx*VRR0(26,33)-3.D0*ExZpE*r1x2Z*VRR1(15,33)+WPx*VRR1(26,33)
      VRR0(42,34)=3.D0*r1x2Z*VRR0(15,34)+PAx*VRR0(26,34)-3.D0*ExZpE*r1x2Z*VRR1(15,34)+WPx*VRR1(26,34)
      VRR0(42,35)=V(2)+3.D0*r1x2E*VRR0(42,10)+QCz*VRR0(42,20)-3.D0*r1x2E*ZxZpE*VRR1(42,10)+WQz*VRR1(42,20)
      VRR0(43,21)=3.D0*r1x2E*VRR0(43,5)+QCx*VRR0(43,11)+3.D0*HfxZpE*VRR1(27,11)-3.D0*r1x2E*ZxZpE*VRR1(43,5)+WQx*VRR1(43,11)
      VRR0(43,22)=V(95)+V(97)+QCx*VRR0(43,12)+3.D0*HfxZpE*VRR1(27,12)+WQx*VRR1(43,12)
      VRR0(43,23)=V(99)+V(101)+V(103)+PAx*VRR0(27,23)+WPx*VRR1(27,23)
      VRR0(43,24)=V(77)+V(95)+V(97)+QCy*VRR0(43,13)+WQy*VRR1(43,13)
      VRR0(43,25)=V(78)+3.D0*r1x2E*VRR0(43,7)+QCy*VRR0(43,14)-3.D0*r1x2E*ZxZpE*VRR1(43,7)+WQy*VRR1(43,14)
      VRR0(43,26)=V(105)+V(107)+QCx*VRR0(43,15)+3.D0*HfxZpE*VRR1(27,15)+WQx*VRR1(43,15)
      VRR0(43,27)=V(109)+V(111)+V(113)+PAx*VRR0(27,27)+WPx*VRR1(27,27)
      VRR0(43,28)=V(115)+V(117)+V(118)+PAx*VRR0(27,28)+WPx*VRR1(27,28)
      VRR0(43,29)=V(83)+V(120)+V(122)+QCy*VRR0(43,17)+WQy*VRR1(43,17)
      VRR0(43,30)=V(124)+V(126)+V(128)+PAx*VRR0(27,30)+WPx*VRR1(27,30)
      VRR0(43,31)=V(130)+V(132)+V(133)+PAx*VRR0(27,31)+WPx*VRR1(27,31)
      VRR0(43,32)=V(135)+V(137)+PAx*VRR0(27,32)+WPx*VRR1(27,32)
      VRR0(43,33)=V(15)+V(105)+V(107)+QCz*VRR0(43,18)+WQz*VRR1(43,18)
      VRR0(43,34)=V(18)+V(120)+V(122)+QCz*VRR0(43,19)+WQz*VRR1(43,19)
      VRR0(43,35)=V(21)+3.D0*r1x2E*VRR0(43,10)+QCz*VRR0(43,20)-3.D0*r1x2E*ZxZpE*VRR1(43,10)+WQz*VRR1(43,20)
      VRR0(44,21)=3.D0*r1x2E*VRR0(44,5)+QCx*VRR0(44,11)+2.D0*HfxZpE*VRR1(28,11)-3.D0*r1x2E*ZxZpE*VRR1(44,5)+WQx*VRR1(44,11)
      VRR0(44,22)=V(139)+V(141)+V(143)+QCx*VRR0(44,12)+WQx*VRR1(44,12)
      VRR0(44,23)=V(144)+2.D0*V(145)-V(146)+QCx*VRR0(44,13)+WQx*VRR1(44,13)
      VRR0(44,24)=V(103)+V(139)+V(143)+QCy*VRR0(44,13)+WQy*VRR1(44,13)
      VRR0(44,25)=3.D0*V(144)-3.D0*V(146)+QCy*VRR0(44,14)+2.D0*HfxZpE*VRR1(27,14)+WQy*VRR1(44,14)
      VRR0(44,26)=V(148)+2.D0*V(149)+V(151)+QCx*VRR0(44,15)+WQx*VRR1(44,15)
      VRR0(44,27)=V(152)+V(154)-V(155)+QCx*VRR0(44,16)+WQx*VRR1(44,16)
      VRR0(44,28)=V(113)+V(147)-V(150)+QCy*VRR0(44,16)+WQy*VRR1(44,16)
      VRR0(44,29)=2.D0*V(118)+V(156)+V(157)+QCy*VRR0(44,17)+WQy*VRR1(44,17)
      VRR0(44,30)=V(158)+V(160)+V(162)+QCx*VRR0(44,18)+WQx*VRR1(44,18)
      VRR0(44,31)=V(37)+V(138)-V(142)+QCz*VRR0(44,16)+WQz*VRR1(44,16)
      VRR0(44,32)=V(158)+V(162)+V(163)+QCy*VRR0(44,19)+WQy*VRR1(44,19)
      VRR0(44,33)=V(48)+V(148)+V(151)+QCz*VRR0(44,18)+WQz*VRR1(44,18)
      VRR0(44,34)=V(51)+V(156)+V(157)+QCz*VRR0(44,19)+WQz*VRR1(44,19)
      VRR0(44,35)=3.D0*V(158)-3.D0*V(161)+QCz*VRR0(44,20)+HfxZpE*VRR1(23,20)+WQz*VRR1(44,20)
      VRR0(45,21)=V(164)+3.D0*r1x2E*VRR0(45,5)+QCx*VRR0(45,11)-3.D0*r1x2E*ZxZpE*VRR1(45,5)+WQx*VRR1(45,11)
      VRR0(45,22)=V(166)+V(167)+V(169)+QCx*VRR0(45,12)+WQx*VRR1(45,12)
      VRR0(45,23)=V(99)+V(101)+V(141)+PAy*VRR0(28,23)+WPy*VRR1(28,23)
      VRR0(45,24)=3.D0*V(145)+V(166)+V(169)+QCy*VRR0(45,13)+WQy*VRR1(45,13)
      VRR0(45,25)=3.D0*r1x2E*VRR0(45,7)+QCy*VRR0(45,14)+3.D0*HfxZpE*VRR1(28,14)-3.D0*r1x2E*ZxZpE*VRR1(45,7)+WQy*VRR1(45,14)
      VRR0(45,26)=V(171)+V(172)+V(174)+QCx*VRR0(45,15)+WQx*VRR1(45,15)
      VRR0(45,27)=V(109)+V(111)+V(149)+PAy*VRR0(28,27)+WPy*VRR1(28,27)
      VRR0(45,28)=V(115)+V(117)+V(154)+PAy*VRR0(28,28)+WPy*VRR1(28,28)
      VRR0(45,29)=V(176)+V(178)+QCy*VRR0(45,17)+3.D0*HfxZpE*VRR1(28,17)+WQy*VRR1(45,17)
      VRR0(45,30)=V(124)+V(126)+PAy*VRR0(28,30)+WPy*VRR1(28,30)
      VRR0(45,31)=V(130)+V(132)+V(159)+PAy*VRR0(28,31)+WPy*VRR1(28,31)
      VRR0(45,32)=V(135)+V(137)+V(180)+PAy*VRR0(28,32)+WPy*VRR1(28,32)
      VRR0(45,33)=V(71)+V(171)+V(174)+QCz*VRR0(45,18)+WQz*VRR1(45,18)
      VRR0(45,34)=V(72)+V(176)+V(178)+QCz*VRR0(45,19)+WQz*VRR1(45,19)
      VRR0(45,35)=V(73)+3.D0*r1x2E*VRR0(45,10)+QCz*VRR0(45,20)-3.D0*r1x2E*ZxZpE*VRR1(45,10)+WQz*VRR1(45,20)
      VRR0(46,21)=3.D0*r1x2E*VRR0(46,5)+QCx*VRR0(46,11)-3.D0*r1x2E*ZxZpE*VRR1(46,5)+WQx*VRR1(46,11)
      VRR0(46,22)=V(164)+3.D0*r1x2Z*VRR0(17,22)+PAy*VRR0(29,22)-3.D0*ExZpE*r1x2Z*VRR1(17,22)+WPy*VRR1(29,22)
      VRR0(46,23)=2.D0*V(167)+3.D0*V(181)-3.D0*V(182)+PAy*VRR0(29,23)+WPy*VRR1(29,23)
      VRR0(46,24)=3.D0*r1x2Z*VRR0(17,24)+PAy*VRR0(29,24)-3.D0*ExZpE*r1x2Z*VRR1(17,24)+3.D0*HfxZpE*VRR1(29,13)+WPy*VRR1(29,24)
      VRR0(46,25)=3.D0*r1x2E*VRR0(46,7)+QCy*VRR0(46,14)+4.D0*HfxZpE*VRR1(29,14)-3.D0*r1x2E*ZxZpE*VRR1(46,7)+WQy*VRR1(46,14)
      VRR0(46,26)=3.D0*r1x2Z*VRR0(17,26)+PAy*VRR0(29,26)-3.D0*ExZpE*r1x2Z*VRR1(17,26)+WPy*VRR1(29,26)
      VRR0(46,27)=V(172)+3.D0*V(183)-3.D0*V(184)+PAy*VRR0(29,27)+WPy*VRR1(29,27)
      VRR0(46,28)=3.D0*V(185)-3.D0*V(186)+PAy*VRR0(29,28)+2.D0*HfxZpE*VRR1(29,16)+WPy*VRR1(29,28)
      VRR0(46,29)=3.D0*r1x2Z*VRR0(17,29)+PAy*VRR0(29,29)-3.D0*ExZpE*r1x2Z*VRR1(17,29)+3.D0*HfxZpE*VRR1(29,17)+WPy*VRR1(29,29)
      VRR0(46,30)=3.D0*V(187)-3.D0*V(188)+PAy*VRR0(29,30)+WPy*VRR1(29,30)
      VRR0(46,31)=3.D0*V(189)-3.D0*V(190)+V(191)+PAy*VRR0(29,31)+WPy*VRR1(29,31)
      VRR0(46,32)=3.D0*V(192)-3.D0*V(193)+V(195)+PAy*VRR0(29,32)+WPy*VRR1(29,32)
      VRR0(46,33)=3.D0*r1x2Z*VRR0(17,33)+PAy*VRR0(29,33)-3.D0*ExZpE*r1x2Z*VRR1(17,33)+WPy*VRR1(29,33)
      VRR0(46,34)=V(196)+3.D0*r1x2Z*VRR0(17,34)+PAy*VRR0(29,34)-3.D0*ExZpE*r1x2Z*VRR1(17,34)+WPy*VRR1(29,34)
      VRR0(46,35)=V(74)+3.D0*r1x2E*VRR0(46,10)+QCz*VRR0(46,20)-3.D0*r1x2E*ZxZpE*VRR1(46,10)+WQz*VRR1(46,20)
      VRR0(47,21)=3.D0*r1x2E*VRR0(47,5)+QCx*VRR0(47,11)+3.D0*HfxZpE*VRR1(30,11)-3.D0*r1x2E*ZxZpE*VRR1(47,5)+WQx*VRR1(47,11)
      VRR0(47,22)=V(198)+3.D0*V(199)+V(201)+QCx*VRR0(47,12)+WQx*VRR1(47,12)
      VRR0(47,23)=2.D0*V(202)-2.D0*V(203)+2.D0*V(204)+PAx*VRR0(30,23)+WPx*VRR1(30,23)
      VRR0(47,24)=V(198)+V(201)+QCy*VRR0(47,13)+WQy*VRR1(47,13)
      VRR0(47,25)=3.D0*r1x2E*VRR0(47,7)+QCy*VRR0(47,14)-3.D0*r1x2E*ZxZpE*VRR1(47,7)+WQy*VRR1(47,14)
      VRR0(47,26)=V(206)+3.D0*V(207)+V(209)+QCx*VRR0(47,15)+WQx*VRR1(47,15)
      VRR0(47,27)=2.D0*V(210)-2.D0*V(211)+V(213)+PAx*VRR0(30,27)+WPx*VRR1(30,27)
      VRR0(47,28)=2.D0*V(214)-2.D0*V(215)+V(216)+PAx*VRR0(30,28)+WPx*VRR1(30,28)
      VRR0(47,29)=V(218)+V(220)+QCy*VRR0(47,17)+WQy*VRR1(47,17)
      VRR0(47,30)=2.D0*V(221)-2.D0*V(222)+2.D0*V(223)+PAx*VRR0(30,30)+WPx*VRR1(30,30)
      VRR0(47,31)=2.D0*V(224)-2.D0*V(225)+V(226)+PAx*VRR0(30,31)+WPx*VRR1(30,31)
      VRR0(47,32)=2.D0*V(227)-2.D0*V(228)+PAx*VRR0(30,32)+WPx*VRR1(30,32)
      VRR0(47,33)=V(87)+V(206)+V(209)+QCz*VRR0(47,18)+WQz*VRR1(47,18)
      VRR0(47,34)=2.D0*V(90)+V(218)+V(220)+QCz*VRR0(47,19)+WQz*VRR1(47,19)
      VRR0(47,35)=2.D0*V(93)+3.D0*r1x2E*VRR0(47,10)+QCz*VRR0(47,20)-3.D0*r1x2E*ZxZpE*VRR1(47,10)+WQz*VRR1(47,20)
      VRR0(48,21)=3.D0*r1x2E*VRR0(48,5)+QCx*VRR0(48,11)+2.D0*HfxZpE*VRR1(31,11)-3.D0*r1x2E*ZxZpE*VRR1(48,5)+WQx*VRR1(48,11)
      VRR0(48,22)=V(230)+2.D0*V(231)+V(233)+QCx*VRR0(48,12)+WQx*VRR1(48,12)
      VRR0(48,23)=V(234)+V(236)-V(237)+QCx*VRR0(48,13)+WQx*VRR1(48,13)
      VRR0(48,24)=V(204)+V(230)+V(233)+QCy*VRR0(48,13)+WQy*VRR1(48,13)
      VRR0(48,25)=3.D0*V(234)-3.D0*V(237)+QCy*VRR0(48,14)+HfxZpE*VRR1(30,14)+WQy*VRR1(48,14)
      VRR0(48,26)=V(239)+V(241)+V(243)+QCx*VRR0(48,15)+WQx*VRR1(48,15)
      VRR0(48,27)=V(244)+V(246)-V(247)+QCx*VRR0(48,16)+WQx*VRR1(48,16)
      VRR0(48,28)=V(212)+V(238)-V(242)+QCy*VRR0(48,16)+WQy*VRR1(48,16)
      VRR0(48,29)=V(216)+V(248)+V(249)+QCy*VRR0(48,17)+WQy*VRR1(48,17)
      VRR0(48,30)=V(250)+2.D0*V(251)+V(253)+QCx*VRR0(48,18)+WQx*VRR1(48,18)
      VRR0(48,31)=V(113)+V(229)-V(232)+QCz*VRR0(48,16)+WQz*VRR1(48,16)
      VRR0(48,32)=V(226)+V(250)+V(253)+QCy*VRR0(48,19)+WQy*VRR1(48,19)
      VRR0(48,33)=V(128)+V(239)+V(243)+QCz*VRR0(48,18)+WQz*VRR1(48,18)
      VRR0(48,34)=V(163)+V(248)+V(249)+QCz*VRR0(48,19)+WQz*VRR1(48,19)
      VRR0(48,35)=3.D0*V(250)-3.D0*V(252)+QCz*VRR0(48,20)+2.D0*HfxZpE*VRR1(27,20)+WQz*VRR1(48,20)
      VRR0(49,21)=3.D0*r1x2E*VRR0(49,5)+QCx*VRR0(49,11)+HfxZpE*VRR1(32,11)-3.D0*r1x2E*ZxZpE*VRR1(49,5)+WQx*VRR1(49,11)
      VRR0(49,22)=V(255)+V(256)+V(258)+QCx*VRR0(49,12)+WQx*VRR1(49,12)
      VRR0(49,23)=V(259)+V(260)-V(261)+QCx*VRR0(49,13)+WQx*VRR1(49,13)
      VRR0(49,24)=V(236)+V(255)+V(258)+QCy*VRR0(49,13)+WQy*VRR1(49,13)
      VRR0(49,25)=3.D0*V(259)-3.D0*V(261)+QCy*VRR0(49,14)+2.D0*HfxZpE*VRR1(31,14)+WQy*VRR1(49,14)
      VRR0(49,26)=V(263)+V(264)+V(266)+QCx*VRR0(49,15)+WQx*VRR1(49,15)
      VRR0(49,27)=V(267)+V(268)-V(269)+QCx*VRR0(49,16)+WQx*VRR1(49,16)
      VRR0(49,28)=V(246)+V(262)-V(265)+QCy*VRR0(49,16)+WQy*VRR1(49,16)
      VRR0(49,29)=V(270)+V(272)+V(273)+QCy*VRR0(49,17)+WQy*VRR1(49,17)
      VRR0(49,30)=V(274)+V(275)+V(277)+QCx*VRR0(49,18)+WQx*VRR1(49,18)
      VRR0(49,31)=V(154)+V(254)-V(257)+QCz*VRR0(49,16)+WQz*VRR1(49,16)
      VRR0(49,32)=V(274)+V(277)+2.D0*V(278)+QCy*VRR0(49,19)+WQy*VRR1(49,19)
      VRR0(49,33)=V(160)+V(263)+V(266)+QCz*VRR0(49,18)+WQz*VRR1(49,18)
      VRR0(49,34)=V(180)+V(270)+V(273)+QCz*VRR0(49,19)+WQz*VRR1(49,19)
      VRR0(49,35)=3.D0*V(274)-3.D0*V(276)+QCz*VRR0(49,20)+2.D0*HfxZpE*VRR1(28,20)+WQz*VRR1(49,20)
      VRR0(50,21)=3.D0*r1x2E*VRR0(50,5)+QCx*VRR0(50,11)-3.D0*r1x2E*ZxZpE*VRR1(50,5)+WQx*VRR1(50,11)
      VRR0(50,22)=V(280)+V(282)+QCx*VRR0(50,12)+WQx*VRR1(50,12)
      VRR0(50,23)=2.D0*V(256)+2.D0*V(283)-2.D0*V(284)+PAy*VRR0(32,23)+WPy*VRR1(32,23)
      VRR0(50,24)=3.D0*V(260)+V(280)+V(282)+QCy*VRR0(50,13)+WQy*VRR1(50,13)
      VRR0(50,25)=3.D0*r1x2E*VRR0(50,7)+QCy*VRR0(50,14)+3.D0*HfxZpE*VRR1(32,14)-3.D0*r1x2E*ZxZpE*VRR1(50,7)+WQy*VRR1(50,14)
      VRR0(50,26)=V(286)+V(288)+QCx*VRR0(50,15)+WQx*VRR1(50,15)
      VRR0(50,27)=V(264)+2.D0*V(289)-2.D0*V(290)+PAy*VRR0(32,27)+WPy*VRR1(32,27)
      VRR0(50,28)=2.D0*V(291)-2.D0*V(292)+V(293)+PAy*VRR0(32,28)+WPy*VRR1(32,28)
      VRR0(50,29)=V(295)+3.D0*V(296)+V(298)+QCy*VRR0(50,17)+WQy*VRR1(50,17)
      VRR0(50,30)=2.D0*V(299)-2.D0*V(300)+PAy*VRR0(32,30)+WPy*VRR1(32,30)
      VRR0(50,31)=V(275)+2.D0*V(301)-2.D0*V(302)+PAy*VRR0(32,31)+WPy*VRR1(32,31)
      VRR0(50,32)=2.D0*V(303)-2.D0*V(304)+2.D0*V(305)+PAy*VRR0(32,32)+WPy*VRR1(32,32)
      VRR0(50,33)=2.D0*V(191)+V(286)+V(288)+QCz*VRR0(50,18)+WQz*VRR1(50,18)
      VRR0(50,34)=V(195)+V(295)+V(298)+QCz*VRR0(50,19)+WQz*VRR1(50,19)
      VRR0(50,35)=2.D0*V(196)+3.D0*r1x2E*VRR0(50,10)+QCz*VRR0(50,20)-3.D0*r1x2E*ZxZpE*VRR1(50,10)+WQz*VRR1(50,20)
      VRR0(51,21)=2.D0*V(306)+3.D0*r1x2E*VRR0(51,5)+QCx*VRR0(51,11)-3.D0*r1x2E*ZxZpE*VRR1(51,5)+WQx*VRR1(51,11)
      VRR0(51,22)=V(308)+2.D0*V(309)+V(311)+QCx*VRR0(51,12)+WQx*VRR1(51,12)
      VRR0(51,23)=2.D0*V(75)-2.D0*V(76)+PAz*VRR0(30,23)+WPz*VRR1(30,23)
      VRR0(51,24)=V(308)+V(311)+QCy*VRR0(51,13)+WQy*VRR1(51,13)
      VRR0(51,25)=3.D0*r1x2E*VRR0(51,7)+QCy*VRR0(51,14)-3.D0*r1x2E*ZxZpE*VRR1(51,7)+WQy*VRR1(51,14)
      VRR0(51,26)=V(313)+V(315)+V(317)+QCx*VRR0(51,15)+WQx*VRR1(51,15)
      VRR0(51,27)=2.D0*V(79)-2.D0*V(80)+V(199)+PAz*VRR0(30,27)+WPz*VRR1(30,27)
      VRR0(51,28)=2.D0*V(81)-2.D0*V(82)+V(204)+PAz*VRR0(30,28)+WPz*VRR1(30,28)
      VRR0(51,29)=V(319)+V(321)+QCy*VRR0(51,17)+WQy*VRR1(51,17)
      VRR0(51,30)=2.D0*V(84)-2.D0*V(85)+2.D0*V(207)+PAz*VRR0(30,30)+WPz*VRR1(30,30)
      VRR0(51,31)=2.D0*V(88)-2.D0*V(89)+V(213)+PAz*VRR0(30,31)+WPz*VRR1(30,31)
      VRR0(51,32)=2.D0*V(91)-2.D0*V(92)+2.D0*V(216)+PAz*VRR0(30,32)+WPz*VRR1(30,32)
      VRR0(51,33)=3.D0*V(223)+V(313)+V(317)+QCz*VRR0(51,18)+WQz*VRR1(51,18)
      VRR0(51,34)=3.D0*V(226)+V(319)+V(321)+QCz*VRR0(51,19)+WQz*VRR1(51,19)
      VRR0(51,35)=3.D0*r1x2E*VRR0(51,10)+QCz*VRR0(51,20)+3.D0*HfxZpE*VRR1(30,20)-3.D0*r1x2E*ZxZpE*VRR1(51,10)+WQz*VRR1(51,20)
      VRR0(52,21)=V(322)+3.D0*r1x2E*VRR0(52,5)+QCx*VRR0(52,11)-3.D0*r1x2E*ZxZpE*VRR1(52,5)+WQx*VRR1(52,11)
      VRR0(52,22)=V(324)+V(325)+V(327)+QCx*VRR0(52,12)+WQx*VRR1(52,12)
      VRR0(52,23)=V(99)+V(101)+PAz*VRR0(31,23)+WPz*VRR1(31,23)
      VRR0(52,24)=V(324)+V(327)+V(328)+QCy*VRR0(52,13)+WQy*VRR1(52,13)
      VRR0(52,25)=V(329)+3.D0*r1x2E*VRR0(52,7)+QCy*VRR0(52,14)-3.D0*r1x2E*ZxZpE*VRR1(52,7)+WQy*VRR1(52,14)
      VRR0(52,26)=V(331)+V(332)+V(334)+QCx*VRR0(52,15)+WQx*VRR1(52,15)
      VRR0(52,27)=V(109)+V(111)+V(231)+PAz*VRR0(31,27)+WPz*VRR1(31,27)
      VRR0(52,28)=V(115)+V(117)+V(235)+PAz*VRR0(31,28)+WPz*VRR1(31,28)
      VRR0(52,29)=V(336)+V(337)+V(339)+QCy*VRR0(52,17)+WQy*VRR1(52,17)
      VRR0(52,30)=V(124)+V(126)+V(241)+PAz*VRR0(31,30)+WPz*VRR1(31,30)
      VRR0(52,31)=V(130)+V(132)+V(246)+PAz*VRR0(31,31)+WPz*VRR1(31,31)
      VRR0(52,32)=V(135)+V(137)+V(272)+PAz*VRR0(31,32)+WPz*VRR1(31,32)
      VRR0(52,33)=3.D0*V(251)+V(331)+V(334)+QCz*VRR0(52,18)+WQz*VRR1(52,18)
      VRR0(52,34)=3.D0*V(278)+V(336)+V(339)+QCz*VRR0(52,19)+WQz*VRR1(52,19)
      VRR0(52,35)=3.D0*r1x2E*VRR0(52,10)+QCz*VRR0(52,20)+3.D0*HfxZpE*VRR1(31,20)-3.D0*r1x2E*ZxZpE*VRR1(52,10)+WQz*VRR1(52,20)
      VRR0(53,21)=3.D0*r1x2E*VRR0(53,5)+QCx*VRR0(53,11)-3.D0*r1x2E*ZxZpE*VRR1(53,5)+WQx*VRR1(53,11)
      VRR0(53,22)=V(341)+V(343)+QCx*VRR0(53,12)+WQx*VRR1(53,12)
      VRR0(53,23)=2.D0*V(181)-2.D0*V(182)+PAz*VRR0(32,23)+WPz*VRR1(32,23)
      VRR0(53,24)=V(341)+V(343)+2.D0*V(344)+QCy*VRR0(53,13)+WQy*VRR1(53,13)
      VRR0(53,25)=2.D0*V(345)+3.D0*r1x2E*VRR0(53,7)+QCy*VRR0(53,14)-3.D0*r1x2E*ZxZpE*VRR1(53,7)+WQy*VRR1(53,14)
      VRR0(53,26)=V(347)+V(349)+QCx*VRR0(53,15)+WQx*VRR1(53,15)
      VRR0(53,27)=2.D0*V(183)-2.D0*V(184)+V(256)+PAz*VRR0(32,27)+WPz*VRR1(32,27)
      VRR0(53,28)=2.D0*V(185)-2.D0*V(186)+V(260)+PAz*VRR0(32,28)+WPz*VRR1(32,28)
      VRR0(53,29)=V(351)+V(353)+V(355)+QCy*VRR0(53,17)+WQy*VRR1(53,17)
      VRR0(53,30)=2.D0*V(187)-2.D0*V(188)+2.D0*V(264)+PAz*VRR0(32,30)+WPz*VRR1(32,30)
      VRR0(53,31)=2.D0*V(189)-2.D0*V(190)+V(293)+PAz*VRR0(32,31)+WPz*VRR1(32,31)
      VRR0(53,32)=2.D0*V(192)-2.D0*V(193)+2.D0*V(296)+PAz*VRR0(32,32)+WPz*VRR1(32,32)
      VRR0(53,33)=3.D0*V(275)+V(347)+V(349)+QCz*VRR0(53,18)+WQz*VRR1(53,18)
      VRR0(53,34)=3.D0*V(305)+V(351)+V(355)+QCz*VRR0(53,19)+WQz*VRR1(53,19)
      VRR0(53,35)=3.D0*r1x2E*VRR0(53,10)+QCz*VRR0(53,20)+3.D0*HfxZpE*VRR1(32,20)-3.D0*r1x2E*ZxZpE*VRR1(53,10)+WQz*VRR1(53,20)
      VRR0(54,21)=V(356)+3.D0*r1x2E*VRR0(54,5)+QCx*VRR0(54,11)-3.D0*r1x2E*ZxZpE*VRR1(54,5)+WQx*VRR1(54,11)
      VRR0(54,22)=3.D0*r1x2Z*VRR0(18,22)+PAz*VRR0(33,22)-3.D0*ExZpE*r1x2Z*VRR1(18,22)+WPz*VRR1(33,22)
      VRR0(54,23)=3.D0*V(202)-3.D0*V(203)+PAz*VRR0(33,23)+WPz*VRR1(33,23)
      VRR0(54,24)=3.D0*r1x2Z*VRR0(18,24)+PAz*VRR0(33,24)-3.D0*ExZpE*r1x2Z*VRR1(18,24)+WPz*VRR1(33,24)
      VRR0(54,25)=3.D0*r1x2E*VRR0(54,7)+QCy*VRR0(54,14)-3.D0*r1x2E*ZxZpE*VRR1(54,7)+WQy*VRR1(54,14)
      VRR0(54,26)=V(306)+3.D0*r1x2Z*VRR0(18,26)+PAz*VRR0(33,26)-3.D0*ExZpE*r1x2Z*VRR1(18,26)+WPz*VRR1(33,26)
      VRR0(54,27)=3.D0*V(210)-3.D0*V(211)+V(309)+PAz*VRR0(33,27)+WPz*VRR1(33,27)
      VRR0(54,28)=3.D0*V(214)-3.D0*V(215)+V(328)+PAz*VRR0(33,28)+WPz*VRR1(33,28)
      VRR0(54,29)=V(329)+3.D0*r1x2Z*VRR0(18,29)+PAz*VRR0(33,29)-3.D0*ExZpE*r1x2Z*VRR1(18,29)+WPz*VRR1(33,29)
      VRR0(54,30)=3.D0*V(221)-3.D0*V(222)+V(315)+PAz*VRR0(33,30)+WPz*VRR1(33,30)
      VRR0(54,31)=3.D0*V(224)-3.D0*V(225)+PAz*VRR0(33,31)+2.D0*HfxZpE*VRR1(33,16)+WPz*VRR1(33,31)
      VRR0(54,32)=3.D0*V(227)-3.D0*V(228)+2.D0*V(337)+PAz*VRR0(33,32)+WPz*VRR1(33,32)
      VRR0(54,33)=3.D0*r1x2Z*VRR0(18,33)+PAz*VRR0(33,33)-3.D0*ExZpE*r1x2Z*VRR1(18,33)+3.D0*HfxZpE*VRR1(33,18)+WPz*VRR1(33,33)
      VRR0(54,34)=3.D0*r1x2Z*VRR0(18,34)+PAz*VRR0(33,34)-3.D0*ExZpE*r1x2Z*VRR1(18,34)+3.D0*HfxZpE*VRR1(33,19)+WPz*VRR1(33,34)
      VRR0(54,35)=3.D0*r1x2E*VRR0(54,10)+QCz*VRR0(54,20)+4.D0*HfxZpE*VRR1(33,20)-3.D0*r1x2E*ZxZpE*VRR1(54,10)+WQz*VRR1(54,20)
      VRR0(55,21)=3.D0*r1x2E*VRR0(55,5)+QCx*VRR0(55,11)-3.D0*r1x2E*ZxZpE*VRR1(55,5)+WQx*VRR1(55,11)
      VRR0(55,22)=3.D0*r1x2Z*VRR0(19,22)+PAz*VRR0(34,22)-3.D0*ExZpE*r1x2Z*VRR1(19,22)+WPz*VRR1(34,22)
      VRR0(55,23)=3.D0*V(283)-3.D0*V(284)+PAz*VRR0(34,23)+WPz*VRR1(34,23)
      VRR0(55,24)=3.D0*r1x2Z*VRR0(19,24)+PAz*VRR0(34,24)-3.D0*ExZpE*r1x2Z*VRR1(19,24)+WPz*VRR1(34,24)
      VRR0(55,25)=V(357)+3.D0*r1x2E*VRR0(55,7)+QCy*VRR0(55,14)-3.D0*r1x2E*ZxZpE*VRR1(55,7)+WQy*VRR1(55,14)
      VRR0(55,26)=V(322)+3.D0*r1x2Z*VRR0(19,26)+PAz*VRR0(34,26)-3.D0*ExZpE*r1x2Z*VRR1(19,26)+WPz*VRR1(34,26)
      VRR0(55,27)=3.D0*V(289)-3.D0*V(290)+V(325)+PAz*VRR0(34,27)+WPz*VRR1(34,27)
      VRR0(55,28)=3.D0*V(291)-3.D0*V(292)+V(344)+PAz*VRR0(34,28)+WPz*VRR1(34,28)
      VRR0(55,29)=V(345)+3.D0*r1x2Z*VRR0(19,29)+PAz*VRR0(34,29)-3.D0*ExZpE*r1x2Z*VRR1(19,29)+WPz*VRR1(34,29)
      VRR0(55,30)=3.D0*V(299)-3.D0*V(300)+2.D0*V(332)+PAz*VRR0(34,30)+WPz*VRR1(34,30)
      VRR0(55,31)=3.D0*V(301)-3.D0*V(302)+PAz*VRR0(34,31)+2.D0*HfxZpE*VRR1(34,16)+WPz*VRR1(34,31)
      VRR0(55,32)=3.D0*V(303)-3.D0*V(304)+V(353)+PAz*VRR0(34,32)+WPz*VRR1(34,32)
      VRR0(55,33)=3.D0*r1x2Z*VRR0(19,33)+PAz*VRR0(34,33)-3.D0*ExZpE*r1x2Z*VRR1(19,33)+3.D0*HfxZpE*VRR1(34,18)+WPz*VRR1(34,33)
      VRR0(55,34)=3.D0*r1x2Z*VRR0(19,34)+PAz*VRR0(34,34)-3.D0*ExZpE*r1x2Z*VRR1(19,34)+3.D0*HfxZpE*VRR1(34,19)+WPz*VRR1(34,34)
      VRR0(55,35)=3.D0*r1x2E*VRR0(55,10)+QCz*VRR0(55,20)+4.D0*HfxZpE*VRR1(34,20)-3.D0*r1x2E*ZxZpE*VRR1(55,10)+WQz*VRR1(55,20)
      VRR0(56,21)=4.D0*r1x2Z*VRR0(20,21)+PAz*VRR0(35,21)-4.D0*ExZpE*r1x2Z*VRR1(20,21)+WPz*VRR1(35,21)
      VRR0(56,22)=4.D0*r1x2Z*VRR0(20,22)+PAz*VRR0(35,22)-4.D0*ExZpE*r1x2Z*VRR1(20,22)+WPz*VRR1(35,22)
      VRR0(56,23)=4.D0*r1x2Z*VRR0(20,23)+PAz*VRR0(35,23)-4.D0*ExZpE*r1x2Z*VRR1(20,23)+WPz*VRR1(35,23)
      VRR0(56,24)=4.D0*r1x2Z*VRR0(20,24)+PAz*VRR0(35,24)-4.D0*ExZpE*r1x2Z*VRR1(20,24)+WPz*VRR1(35,24)
      VRR0(56,25)=4.D0*r1x2Z*VRR0(20,25)+PAz*VRR0(35,25)-4.D0*ExZpE*r1x2Z*VRR1(20,25)+WPz*VRR1(35,25)
      VRR0(56,26)=V(356)+4.D0*r1x2Z*VRR0(20,26)+PAz*VRR0(35,26)-4.D0*ExZpE*r1x2Z*VRR1(20,26)+WPz*VRR1(35,26)
      VRR0(56,27)=4.D0*r1x2Z*VRR0(20,27)+PAz*VRR0(35,27)-4.D0*ExZpE*r1x2Z*VRR1(20,27)+HfxZpE*VRR1(35,12)+WPz*VRR1(35,27)
      VRR0(56,28)=4.D0*r1x2Z*VRR0(20,28)+PAz*VRR0(35,28)-4.D0*ExZpE*r1x2Z*VRR1(20,28)+HfxZpE*VRR1(35,13)+WPz*VRR1(35,28)
      VRR0(56,29)=V(357)+4.D0*r1x2Z*VRR0(20,29)+PAz*VRR0(35,29)-4.D0*ExZpE*r1x2Z*VRR1(20,29)+WPz*VRR1(35,29)
      VRR0(56,30)=4.D0*r1x2Z*VRR0(20,30)+PAz*VRR0(35,30)-4.D0*ExZpE*r1x2Z*VRR1(20,30)+2.D0*HfxZpE*VRR1(35,15)+WPz*VRR1(35,30)
      VRR0(56,31)=4.D0*r1x2Z*VRR0(20,31)+PAz*VRR0(35,31)-4.D0*ExZpE*r1x2Z*VRR1(20,31)+2.D0*HfxZpE*VRR1(35,16)+WPz*VRR1(35,31)
      VRR0(56,32)=4.D0*r1x2Z*VRR0(20,32)+PAz*VRR0(35,32)-4.D0*ExZpE*r1x2Z*VRR1(20,32)+2.D0*HfxZpE*VRR1(35,17)+WPz*VRR1(35,32)
      VRR0(56,33)=4.D0*r1x2Z*VRR0(20,33)+PAz*VRR0(35,33)-4.D0*ExZpE*r1x2Z*VRR1(20,33)+3.D0*HfxZpE*VRR1(35,18)+WPz*VRR1(35,33)
      VRR0(56,34)=4.D0*r1x2Z*VRR0(20,34)+PAz*VRR0(35,34)-4.D0*ExZpE*r1x2Z*VRR1(20,34)+3.D0*HfxZpE*VRR1(35,19)+WPz*VRR1(35,34)
      VRR0(56,35)=4.D0*r1x2Z*VRR0(20,35)+PAz*VRR0(35,35)-4.D0*ExZpE*r1x2Z*VRR1(20,35)+4.D0*HfxZpE*VRR1(35,20)+WPz*VRR1(35,35)
END SUBROUTINE VRRh0g0
SUBROUTINE MVRRh0g0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(36,21)=PAx*VS0(21,21)+WPx*VS1(21,21)+r1x2Z*VR1(21,21)&
   +4D0*r1x2Z*(VS0(11,21)-ExZpE*VS1(11,21))&
   +4D0*HfxZpE*VS1(21,11)
VS0(36,22)=PAx*VS0(21,22)+WPx*VS1(21,22)+r1x2Z*VR1(21,22)&
   +4D0*r1x2Z*(VS0(11,22)-ExZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(21,12)
VS0(36,23)=PAx*VS0(21,23)+WPx*VS1(21,23)+r1x2Z*VR1(21,23)&
   +4D0*r1x2Z*(VS0(11,23)-ExZpE*VS1(11,23))&
   +2D0*HfxZpE*VS1(21,13)
VS0(36,24)=PAx*VS0(21,24)+WPx*VS1(21,24)+r1x2Z*VR1(21,24)&
   +4D0*r1x2Z*(VS0(11,24)-ExZpE*VS1(11,24))&
   +HfxZpE*VS1(21,14)
VS0(36,25)=PAx*VS0(21,25)+WPx*VS1(21,25)+r1x2Z*VR1(21,25)&
   +4D0*r1x2Z*(VS0(11,25)-ExZpE*VS1(11,25))
VS0(36,26)=PAx*VS0(21,26)+WPx*VS1(21,26)+r1x2Z*VR1(21,26)&
   +4D0*r1x2Z*(VS0(11,26)-ExZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(21,15)
VS0(36,27)=PAx*VS0(21,27)+WPx*VS1(21,27)+r1x2Z*VR1(21,27)&
   +4D0*r1x2Z*(VS0(11,27)-ExZpE*VS1(11,27))&
   +2D0*HfxZpE*VS1(21,16)
VS0(36,28)=PAx*VS0(21,28)+WPx*VS1(21,28)+r1x2Z*VR1(21,28)&
   +4D0*r1x2Z*(VS0(11,28)-ExZpE*VS1(11,28))&
   +HfxZpE*VS1(21,17)
VS0(36,29)=PAx*VS0(21,29)+WPx*VS1(21,29)+r1x2Z*VR1(21,29)&
   +4D0*r1x2Z*(VS0(11,29)-ExZpE*VS1(11,29))
VS0(36,30)=PAx*VS0(21,30)+WPx*VS1(21,30)+r1x2Z*VR1(21,30)&
   +4D0*r1x2Z*(VS0(11,30)-ExZpE*VS1(11,30))&
   +2D0*HfxZpE*VS1(21,18)
VS0(36,31)=PAx*VS0(21,31)+WPx*VS1(21,31)+r1x2Z*VR1(21,31)&
   +4D0*r1x2Z*(VS0(11,31)-ExZpE*VS1(11,31))&
   +HfxZpE*VS1(21,19)
VS0(36,32)=PAx*VS0(21,32)+WPx*VS1(21,32)+r1x2Z*VR1(21,32)&
   +4D0*r1x2Z*(VS0(11,32)-ExZpE*VS1(11,32))
VS0(36,33)=PAx*VS0(21,33)+WPx*VS1(21,33)+r1x2Z*VR1(21,33)&
   +4D0*r1x2Z*(VS0(11,33)-ExZpE*VS1(11,33))&
   +HfxZpE*VS1(21,20)
VS0(36,34)=PAx*VS0(21,34)+WPx*VS1(21,34)+r1x2Z*VR1(21,34)&
   +4D0*r1x2Z*(VS0(11,34)-ExZpE*VS1(11,34))
VS0(36,35)=PAx*VS0(21,35)+WPx*VS1(21,35)+r1x2Z*VR1(21,35)&
   +4D0*r1x2Z*(VS0(11,35)-ExZpE*VS1(11,35))
VS0(37,21)=PAx*VS0(22,21)+WPx*VS1(22,21)+r1x2Z*VR1(22,21)&
   +3D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))&
   +4D0*HfxZpE*VS1(22,11)
VS0(37,22)=PAx*VS0(22,22)+WPx*VS1(22,22)+r1x2Z*VR1(22,22)&
   +3D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +3D0*HfxZpE*VS1(22,12)
VS0(37,23)=PAx*VS0(22,23)+WPx*VS1(22,23)+r1x2Z*VR1(22,23)&
   +3D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(22,13)
VS0(37,24)=PAx*VS0(22,24)+WPx*VS1(22,24)+r1x2Z*VR1(22,24)&
   +3D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +HfxZpE*VS1(22,14)
VS0(37,25)=PAx*VS0(22,25)+WPx*VS1(22,25)+r1x2Z*VR1(22,25)&
   +3D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))
VS0(37,26)=PAx*VS0(22,26)+WPx*VS1(22,26)+r1x2Z*VR1(22,26)&
   +3D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))&
   +3D0*HfxZpE*VS1(22,15)
VS0(37,27)=PAx*VS0(22,27)+WPx*VS1(22,27)+r1x2Z*VR1(22,27)&
   +3D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(22,16)
VS0(37,28)=PAx*VS0(22,28)+WPx*VS1(22,28)+r1x2Z*VR1(22,28)&
   +3D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +HfxZpE*VS1(22,17)
VS0(37,29)=PAx*VS0(22,29)+WPx*VS1(22,29)+r1x2Z*VR1(22,29)&
   +3D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))
VS0(37,30)=PAx*VS0(22,30)+WPx*VS1(22,30)+r1x2Z*VR1(22,30)&
   +3D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(22,18)
VS0(37,31)=PAx*VS0(22,31)+WPx*VS1(22,31)+r1x2Z*VR1(22,31)&
   +3D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(22,19)
VS0(37,32)=PAx*VS0(22,32)+WPx*VS1(22,32)+r1x2Z*VR1(22,32)&
   +3D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))
VS0(37,33)=PAx*VS0(22,33)+WPx*VS1(22,33)+r1x2Z*VR1(22,33)&
   +3D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))&
   +HfxZpE*VS1(22,20)
VS0(37,34)=PAx*VS0(22,34)+WPx*VS1(22,34)+r1x2Z*VR1(22,34)&
   +3D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))
VS0(37,35)=PAx*VS0(22,35)+WPx*VS1(22,35)+r1x2Z*VR1(22,35)&
   +3D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(38,21)=PAx*VS0(23,21)+WPx*VS1(23,21)+r1x2Z*VR1(23,21)&
   +2D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))&
   +4D0*HfxZpE*VS1(23,11)
VS0(38,22)=PAx*VS0(23,22)+WPx*VS1(23,22)+r1x2Z*VR1(23,22)&
   +2D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +3D0*HfxZpE*VS1(23,12)
VS0(38,23)=PAx*VS0(23,23)+WPx*VS1(23,23)+r1x2Z*VR1(23,23)&
   +2D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(23,13)
VS0(38,24)=PAx*VS0(23,24)+WPx*VS1(23,24)+r1x2Z*VR1(23,24)&
   +2D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +HfxZpE*VS1(23,14)
VS0(38,25)=PAx*VS0(23,25)+WPx*VS1(23,25)+r1x2Z*VR1(23,25)&
   +2D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))
VS0(38,26)=PAx*VS0(23,26)+WPx*VS1(23,26)+r1x2Z*VR1(23,26)&
   +2D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))&
   +3D0*HfxZpE*VS1(23,15)
VS0(38,27)=PAx*VS0(23,27)+WPx*VS1(23,27)+r1x2Z*VR1(23,27)&
   +2D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(23,16)
VS0(38,28)=PAx*VS0(23,28)+WPx*VS1(23,28)+r1x2Z*VR1(23,28)&
   +2D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +HfxZpE*VS1(23,17)
VS0(38,29)=PAx*VS0(23,29)+WPx*VS1(23,29)+r1x2Z*VR1(23,29)&
   +2D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))
VS0(38,30)=PAx*VS0(23,30)+WPx*VS1(23,30)+r1x2Z*VR1(23,30)&
   +2D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))&
   +2D0*HfxZpE*VS1(23,18)
VS0(38,31)=PAx*VS0(23,31)+WPx*VS1(23,31)+r1x2Z*VR1(23,31)&
   +2D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(23,19)
VS0(38,32)=PAx*VS0(23,32)+WPx*VS1(23,32)+r1x2Z*VR1(23,32)&
   +2D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))
VS0(38,33)=PAx*VS0(23,33)+WPx*VS1(23,33)+r1x2Z*VR1(23,33)&
   +2D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))&
   +HfxZpE*VS1(23,20)
VS0(38,34)=PAx*VS0(23,34)+WPx*VS1(23,34)+r1x2Z*VR1(23,34)&
   +2D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))
VS0(38,35)=PAx*VS0(23,35)+WPx*VS1(23,35)+r1x2Z*VR1(23,35)&
   +2D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(39,21)=PAy*VS0(23,21)+WPy*VS1(23,21)&
   +2D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))
VS0(39,22)=PAy*VS0(23,22)+WPy*VS1(23,22)&
   +2D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +HfxZpE*VS1(23,11)
VS0(39,23)=PAy*VS0(23,23)+WPy*VS1(23,23)&
   +2D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(23,12)
VS0(39,24)=PAy*VS0(23,24)+WPy*VS1(23,24)&
   +2D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +3D0*HfxZpE*VS1(23,13)
VS0(39,25)=PAy*VS0(23,25)+WPy*VS1(23,25)&
   +2D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))&
   +4D0*HfxZpE*VS1(23,14)
VS0(39,26)=PAy*VS0(23,26)+WPy*VS1(23,26)&
   +2D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))
VS0(39,27)=PAy*VS0(23,27)+WPy*VS1(23,27)&
   +2D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +HfxZpE*VS1(23,15)
VS0(39,28)=PAy*VS0(23,28)+WPy*VS1(23,28)&
   +2D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(23,16)
VS0(39,29)=PAy*VS0(23,29)+WPy*VS1(23,29)&
   +2D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))&
   +3D0*HfxZpE*VS1(23,17)
VS0(39,30)=PAy*VS0(23,30)+WPy*VS1(23,30)&
   +2D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))
VS0(39,31)=PAy*VS0(23,31)+WPy*VS1(23,31)&
   +2D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(23,18)
VS0(39,32)=PAy*VS0(23,32)+WPy*VS1(23,32)&
   +2D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(23,19)
VS0(39,33)=PAy*VS0(23,33)+WPy*VS1(23,33)&
   +2D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))
VS0(39,34)=PAy*VS0(23,34)+WPy*VS1(23,34)&
   +2D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))&
   +HfxZpE*VS1(23,20)
VS0(39,35)=PAy*VS0(23,35)+WPy*VS1(23,35)&
   +2D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(40,21)=PAy*VS0(24,21)+WPy*VS1(24,21)&
   +3D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))
VS0(40,22)=PAy*VS0(24,22)+WPy*VS1(24,22)&
   +3D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +HfxZpE*VS1(24,11)
VS0(40,23)=PAy*VS0(24,23)+WPy*VS1(24,23)&
   +3D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(24,12)
VS0(40,24)=PAy*VS0(24,24)+WPy*VS1(24,24)&
   +3D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +3D0*HfxZpE*VS1(24,13)
VS0(40,25)=PAy*VS0(24,25)+WPy*VS1(24,25)&
   +3D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))&
   +4D0*HfxZpE*VS1(24,14)
VS0(40,26)=PAy*VS0(24,26)+WPy*VS1(24,26)&
   +3D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))
VS0(40,27)=PAy*VS0(24,27)+WPy*VS1(24,27)&
   +3D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +HfxZpE*VS1(24,15)
VS0(40,28)=PAy*VS0(24,28)+WPy*VS1(24,28)&
   +3D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(24,16)
VS0(40,29)=PAy*VS0(24,29)+WPy*VS1(24,29)&
   +3D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))&
   +3D0*HfxZpE*VS1(24,17)
VS0(40,30)=PAy*VS0(24,30)+WPy*VS1(24,30)&
   +3D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))
VS0(40,31)=PAy*VS0(24,31)+WPy*VS1(24,31)&
   +3D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(24,18)
VS0(40,32)=PAy*VS0(24,32)+WPy*VS1(24,32)&
   +3D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(24,19)
VS0(40,33)=PAy*VS0(24,33)+WPy*VS1(24,33)&
   +3D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))
VS0(40,34)=PAy*VS0(24,34)+WPy*VS1(24,34)&
   +3D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))&
   +HfxZpE*VS1(24,20)
VS0(40,35)=PAy*VS0(24,35)+WPy*VS1(24,35)&
   +3D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(41,21)=PAy*VS0(25,21)+WPy*VS1(25,21)&
   +4D0*r1x2Z*(VS0(14,21)-ExZpE*VS1(14,21))
VS0(41,22)=PAy*VS0(25,22)+WPy*VS1(25,22)&
   +4D0*r1x2Z*(VS0(14,22)-ExZpE*VS1(14,22))&
   +HfxZpE*VS1(25,11)
VS0(41,23)=PAy*VS0(25,23)+WPy*VS1(25,23)&
   +4D0*r1x2Z*(VS0(14,23)-ExZpE*VS1(14,23))&
   +2D0*HfxZpE*VS1(25,12)
VS0(41,24)=PAy*VS0(25,24)+WPy*VS1(25,24)&
   +4D0*r1x2Z*(VS0(14,24)-ExZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(25,13)
VS0(41,25)=PAy*VS0(25,25)+WPy*VS1(25,25)&
   +4D0*r1x2Z*(VS0(14,25)-ExZpE*VS1(14,25))&
   +4D0*HfxZpE*VS1(25,14)
VS0(41,26)=PAy*VS0(25,26)+WPy*VS1(25,26)&
   +4D0*r1x2Z*(VS0(14,26)-ExZpE*VS1(14,26))
VS0(41,27)=PAy*VS0(25,27)+WPy*VS1(25,27)&
   +4D0*r1x2Z*(VS0(14,27)-ExZpE*VS1(14,27))&
   +HfxZpE*VS1(25,15)
VS0(41,28)=PAy*VS0(25,28)+WPy*VS1(25,28)&
   +4D0*r1x2Z*(VS0(14,28)-ExZpE*VS1(14,28))&
   +2D0*HfxZpE*VS1(25,16)
VS0(41,29)=PAy*VS0(25,29)+WPy*VS1(25,29)&
   +4D0*r1x2Z*(VS0(14,29)-ExZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(25,17)
VS0(41,30)=PAy*VS0(25,30)+WPy*VS1(25,30)&
   +4D0*r1x2Z*(VS0(14,30)-ExZpE*VS1(14,30))
VS0(41,31)=PAy*VS0(25,31)+WPy*VS1(25,31)&
   +4D0*r1x2Z*(VS0(14,31)-ExZpE*VS1(14,31))&
   +HfxZpE*VS1(25,18)
VS0(41,32)=PAy*VS0(25,32)+WPy*VS1(25,32)&
   +4D0*r1x2Z*(VS0(14,32)-ExZpE*VS1(14,32))&
   +2D0*HfxZpE*VS1(25,19)
VS0(41,33)=PAy*VS0(25,33)+WPy*VS1(25,33)&
   +4D0*r1x2Z*(VS0(14,33)-ExZpE*VS1(14,33))
VS0(41,34)=PAy*VS0(25,34)+WPy*VS1(25,34)&
   +4D0*r1x2Z*(VS0(14,34)-ExZpE*VS1(14,34))&
   +HfxZpE*VS1(25,20)
VS0(41,35)=PAy*VS0(25,35)+WPy*VS1(25,35)&
   +4D0*r1x2Z*(VS0(14,35)-ExZpE*VS1(14,35))
VS0(42,21)=PAx*VS0(26,21)+WPx*VS1(26,21)+r1x2Z*VR1(26,21)&
   +3D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))&
   +4D0*HfxZpE*VS1(26,11)
VS0(42,22)=PAx*VS0(26,22)+WPx*VS1(26,22)+r1x2Z*VR1(26,22)&
   +3D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))&
   +3D0*HfxZpE*VS1(26,12)
VS0(42,23)=PAx*VS0(26,23)+WPx*VS1(26,23)+r1x2Z*VR1(26,23)&
   +3D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(26,13)
VS0(42,24)=PAx*VS0(26,24)+WPx*VS1(26,24)+r1x2Z*VR1(26,24)&
   +3D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))&
   +HfxZpE*VS1(26,14)
VS0(42,25)=PAx*VS0(26,25)+WPx*VS1(26,25)+r1x2Z*VR1(26,25)&
   +3D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(42,26)=PAx*VS0(26,26)+WPx*VS1(26,26)+r1x2Z*VR1(26,26)&
   +3D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +3D0*HfxZpE*VS1(26,15)
VS0(42,27)=PAx*VS0(26,27)+WPx*VS1(26,27)+r1x2Z*VR1(26,27)&
   +3D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(26,16)
VS0(42,28)=PAx*VS0(26,28)+WPx*VS1(26,28)+r1x2Z*VR1(26,28)&
   +3D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(26,17)
VS0(42,29)=PAx*VS0(26,29)+WPx*VS1(26,29)+r1x2Z*VR1(26,29)&
   +3D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))
VS0(42,30)=PAx*VS0(26,30)+WPx*VS1(26,30)+r1x2Z*VR1(26,30)&
   +3D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(26,18)
VS0(42,31)=PAx*VS0(26,31)+WPx*VS1(26,31)+r1x2Z*VR1(26,31)&
   +3D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +HfxZpE*VS1(26,19)
VS0(42,32)=PAx*VS0(26,32)+WPx*VS1(26,32)+r1x2Z*VR1(26,32)&
   +3D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))
VS0(42,33)=PAx*VS0(26,33)+WPx*VS1(26,33)+r1x2Z*VR1(26,33)&
   +3D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +HfxZpE*VS1(26,20)
VS0(42,34)=PAx*VS0(26,34)+WPx*VS1(26,34)+r1x2Z*VR1(26,34)&
   +3D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))
VS0(42,35)=PAx*VS0(26,35)+WPx*VS1(26,35)+r1x2Z*VR1(26,35)&
   +3D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))
VS0(43,21)=PAx*VS0(27,21)+WPx*VS1(27,21)+r1x2Z*VR1(27,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))&
   +4D0*HfxZpE*VS1(27,11)
VS0(43,22)=PAx*VS0(27,22)+WPx*VS1(27,22)+r1x2Z*VR1(27,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +3D0*HfxZpE*VS1(27,12)
VS0(43,23)=PAx*VS0(27,23)+WPx*VS1(27,23)+r1x2Z*VR1(27,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(27,13)
VS0(43,24)=PAx*VS0(27,24)+WPx*VS1(27,24)+r1x2Z*VR1(27,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +HfxZpE*VS1(27,14)
VS0(43,25)=PAx*VS0(27,25)+WPx*VS1(27,25)+r1x2Z*VR1(27,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(43,26)=PAx*VS0(27,26)+WPx*VS1(27,26)+r1x2Z*VR1(27,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +3D0*HfxZpE*VS1(27,15)
VS0(43,27)=PAx*VS0(27,27)+WPx*VS1(27,27)+r1x2Z*VR1(27,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +2D0*HfxZpE*VS1(27,16)
VS0(43,28)=PAx*VS0(27,28)+WPx*VS1(27,28)+r1x2Z*VR1(27,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(27,17)
VS0(43,29)=PAx*VS0(27,29)+WPx*VS1(27,29)+r1x2Z*VR1(27,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))
VS0(43,30)=PAx*VS0(27,30)+WPx*VS1(27,30)+r1x2Z*VR1(27,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(27,18)
VS0(43,31)=PAx*VS0(27,31)+WPx*VS1(27,31)+r1x2Z*VR1(27,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(27,19)
VS0(43,32)=PAx*VS0(27,32)+WPx*VS1(27,32)+r1x2Z*VR1(27,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))
VS0(43,33)=PAx*VS0(27,33)+WPx*VS1(27,33)+r1x2Z*VR1(27,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +HfxZpE*VS1(27,20)
VS0(43,34)=PAx*VS0(27,34)+WPx*VS1(27,34)+r1x2Z*VR1(27,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))
VS0(43,35)=PAx*VS0(27,35)+WPx*VS1(27,35)+r1x2Z*VR1(27,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(44,21)=PAx*VS0(28,21)+WPx*VS1(28,21)+r1x2Z*VR1(28,21)&
   +r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))&
   +4D0*HfxZpE*VS1(28,11)
VS0(44,22)=PAx*VS0(28,22)+WPx*VS1(28,22)+r1x2Z*VR1(28,22)&
   +r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +3D0*HfxZpE*VS1(28,12)
VS0(44,23)=PAx*VS0(28,23)+WPx*VS1(28,23)+r1x2Z*VR1(28,23)&
   +r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(28,13)
VS0(44,24)=PAx*VS0(28,24)+WPx*VS1(28,24)+r1x2Z*VR1(28,24)&
   +r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +HfxZpE*VS1(28,14)
VS0(44,25)=PAx*VS0(28,25)+WPx*VS1(28,25)+r1x2Z*VR1(28,25)&
   +r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(44,26)=PAx*VS0(28,26)+WPx*VS1(28,26)+r1x2Z*VR1(28,26)&
   +r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +3D0*HfxZpE*VS1(28,15)
VS0(44,27)=PAx*VS0(28,27)+WPx*VS1(28,27)+r1x2Z*VR1(28,27)&
   +r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(28,16)
VS0(44,28)=PAx*VS0(28,28)+WPx*VS1(28,28)+r1x2Z*VR1(28,28)&
   +r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(28,17)
VS0(44,29)=PAx*VS0(28,29)+WPx*VS1(28,29)+r1x2Z*VR1(28,29)&
   +r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))
VS0(44,30)=PAx*VS0(28,30)+WPx*VS1(28,30)+r1x2Z*VR1(28,30)&
   +r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(28,18)
VS0(44,31)=PAx*VS0(28,31)+WPx*VS1(28,31)+r1x2Z*VR1(28,31)&
   +r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(28,19)
VS0(44,32)=PAx*VS0(28,32)+WPx*VS1(28,32)+r1x2Z*VR1(28,32)&
   +r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))
VS0(44,33)=PAx*VS0(28,33)+WPx*VS1(28,33)+r1x2Z*VR1(28,33)&
   +r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +HfxZpE*VS1(28,20)
VS0(44,34)=PAx*VS0(28,34)+WPx*VS1(28,34)+r1x2Z*VR1(28,34)&
   +r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))
VS0(44,35)=PAx*VS0(28,35)+WPx*VS1(28,35)+r1x2Z*VR1(28,35)&
   +r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(45,21)=PAy*VS0(28,21)+WPy*VS1(28,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(45,22)=PAy*VS0(28,22)+WPy*VS1(28,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +HfxZpE*VS1(28,11)
VS0(45,23)=PAy*VS0(28,23)+WPy*VS1(28,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(28,12)
VS0(45,24)=PAy*VS0(28,24)+WPy*VS1(28,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +3D0*HfxZpE*VS1(28,13)
VS0(45,25)=PAy*VS0(28,25)+WPy*VS1(28,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))&
   +4D0*HfxZpE*VS1(28,14)
VS0(45,26)=PAy*VS0(28,26)+WPy*VS1(28,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))
VS0(45,27)=PAy*VS0(28,27)+WPy*VS1(28,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(28,15)
VS0(45,28)=PAy*VS0(28,28)+WPy*VS1(28,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +2D0*HfxZpE*VS1(28,16)
VS0(45,29)=PAy*VS0(28,29)+WPy*VS1(28,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +3D0*HfxZpE*VS1(28,17)
VS0(45,30)=PAy*VS0(28,30)+WPy*VS1(28,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))
VS0(45,31)=PAy*VS0(28,31)+WPy*VS1(28,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(28,18)
VS0(45,32)=PAy*VS0(28,32)+WPy*VS1(28,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(28,19)
VS0(45,33)=PAy*VS0(28,33)+WPy*VS1(28,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))
VS0(45,34)=PAy*VS0(28,34)+WPy*VS1(28,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +HfxZpE*VS1(28,20)
VS0(45,35)=PAy*VS0(28,35)+WPy*VS1(28,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(46,21)=PAy*VS0(29,21)+WPy*VS1(29,21)&
   +3D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(46,22)=PAy*VS0(29,22)+WPy*VS1(29,22)&
   +3D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +HfxZpE*VS1(29,11)
VS0(46,23)=PAy*VS0(29,23)+WPy*VS1(29,23)&
   +3D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(29,12)
VS0(46,24)=PAy*VS0(29,24)+WPy*VS1(29,24)&
   +3D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +3D0*HfxZpE*VS1(29,13)
VS0(46,25)=PAy*VS0(29,25)+WPy*VS1(29,25)&
   +3D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))&
   +4D0*HfxZpE*VS1(29,14)
VS0(46,26)=PAy*VS0(29,26)+WPy*VS1(29,26)&
   +3D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))
VS0(46,27)=PAy*VS0(29,27)+WPy*VS1(29,27)&
   +3D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(29,15)
VS0(46,28)=PAy*VS0(29,28)+WPy*VS1(29,28)&
   +3D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(29,16)
VS0(46,29)=PAy*VS0(29,29)+WPy*VS1(29,29)&
   +3D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +3D0*HfxZpE*VS1(29,17)
VS0(46,30)=PAy*VS0(29,30)+WPy*VS1(29,30)&
   +3D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))
VS0(46,31)=PAy*VS0(29,31)+WPy*VS1(29,31)&
   +3D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(29,18)
VS0(46,32)=PAy*VS0(29,32)+WPy*VS1(29,32)&
   +3D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(29,19)
VS0(46,33)=PAy*VS0(29,33)+WPy*VS1(29,33)&
   +3D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))
VS0(46,34)=PAy*VS0(29,34)+WPy*VS1(29,34)&
   +3D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +HfxZpE*VS1(29,20)
VS0(46,35)=PAy*VS0(29,35)+WPy*VS1(29,35)&
   +3D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(47,21)=PAx*VS0(30,21)+WPx*VS1(30,21)+r1x2Z*VR1(30,21)&
   +2D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))&
   +4D0*HfxZpE*VS1(30,11)
VS0(47,22)=PAx*VS0(30,22)+WPx*VS1(30,22)+r1x2Z*VR1(30,22)&
   +2D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +3D0*HfxZpE*VS1(30,12)
VS0(47,23)=PAx*VS0(30,23)+WPx*VS1(30,23)+r1x2Z*VR1(30,23)&
   +2D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(30,13)
VS0(47,24)=PAx*VS0(30,24)+WPx*VS1(30,24)+r1x2Z*VR1(30,24)&
   +2D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +HfxZpE*VS1(30,14)
VS0(47,25)=PAx*VS0(30,25)+WPx*VS1(30,25)+r1x2Z*VR1(30,25)&
   +2D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(47,26)=PAx*VS0(30,26)+WPx*VS1(30,26)+r1x2Z*VR1(30,26)&
   +2D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +3D0*HfxZpE*VS1(30,15)
VS0(47,27)=PAx*VS0(30,27)+WPx*VS1(30,27)+r1x2Z*VR1(30,27)&
   +2D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(30,16)
VS0(47,28)=PAx*VS0(30,28)+WPx*VS1(30,28)+r1x2Z*VR1(30,28)&
   +2D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(30,17)
VS0(47,29)=PAx*VS0(30,29)+WPx*VS1(30,29)+r1x2Z*VR1(30,29)&
   +2D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))
VS0(47,30)=PAx*VS0(30,30)+WPx*VS1(30,30)+r1x2Z*VR1(30,30)&
   +2D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(30,18)
VS0(47,31)=PAx*VS0(30,31)+WPx*VS1(30,31)+r1x2Z*VR1(30,31)&
   +2D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(30,19)
VS0(47,32)=PAx*VS0(30,32)+WPx*VS1(30,32)+r1x2Z*VR1(30,32)&
   +2D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))
VS0(47,33)=PAx*VS0(30,33)+WPx*VS1(30,33)+r1x2Z*VR1(30,33)&
   +2D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +HfxZpE*VS1(30,20)
VS0(47,34)=PAx*VS0(30,34)+WPx*VS1(30,34)+r1x2Z*VR1(30,34)&
   +2D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))
VS0(47,35)=PAx*VS0(30,35)+WPx*VS1(30,35)+r1x2Z*VR1(30,35)&
   +2D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(48,21)=PAx*VS0(31,21)+WPx*VS1(31,21)+r1x2Z*VR1(31,21)&
   +r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))&
   +4D0*HfxZpE*VS1(31,11)
VS0(48,22)=PAx*VS0(31,22)+WPx*VS1(31,22)+r1x2Z*VR1(31,22)&
   +r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +3D0*HfxZpE*VS1(31,12)
VS0(48,23)=PAx*VS0(31,23)+WPx*VS1(31,23)+r1x2Z*VR1(31,23)&
   +r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(31,13)
VS0(48,24)=PAx*VS0(31,24)+WPx*VS1(31,24)+r1x2Z*VR1(31,24)&
   +r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +HfxZpE*VS1(31,14)
VS0(48,25)=PAx*VS0(31,25)+WPx*VS1(31,25)+r1x2Z*VR1(31,25)&
   +r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(48,26)=PAx*VS0(31,26)+WPx*VS1(31,26)+r1x2Z*VR1(31,26)&
   +r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +3D0*HfxZpE*VS1(31,15)
VS0(48,27)=PAx*VS0(31,27)+WPx*VS1(31,27)+r1x2Z*VR1(31,27)&
   +r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(31,16)
VS0(48,28)=PAx*VS0(31,28)+WPx*VS1(31,28)+r1x2Z*VR1(31,28)&
   +r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(31,17)
VS0(48,29)=PAx*VS0(31,29)+WPx*VS1(31,29)+r1x2Z*VR1(31,29)&
   +r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))
VS0(48,30)=PAx*VS0(31,30)+WPx*VS1(31,30)+r1x2Z*VR1(31,30)&
   +r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(31,18)
VS0(48,31)=PAx*VS0(31,31)+WPx*VS1(31,31)+r1x2Z*VR1(31,31)&
   +r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(31,19)
VS0(48,32)=PAx*VS0(31,32)+WPx*VS1(31,32)+r1x2Z*VR1(31,32)&
   +r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))
VS0(48,33)=PAx*VS0(31,33)+WPx*VS1(31,33)+r1x2Z*VR1(31,33)&
   +r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +HfxZpE*VS1(31,20)
VS0(48,34)=PAx*VS0(31,34)+WPx*VS1(31,34)+r1x2Z*VR1(31,34)&
   +r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))
VS0(48,35)=PAx*VS0(31,35)+WPx*VS1(31,35)+r1x2Z*VR1(31,35)&
   +r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(49,21)=PAy*VS0(31,21)+WPy*VS1(31,21)&
   +r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(49,22)=PAy*VS0(31,22)+WPy*VS1(31,22)&
   +r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +HfxZpE*VS1(31,11)
VS0(49,23)=PAy*VS0(31,23)+WPy*VS1(31,23)&
   +r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(31,12)
VS0(49,24)=PAy*VS0(31,24)+WPy*VS1(31,24)&
   +r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +3D0*HfxZpE*VS1(31,13)
VS0(49,25)=PAy*VS0(31,25)+WPy*VS1(31,25)&
   +r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))&
   +4D0*HfxZpE*VS1(31,14)
VS0(49,26)=PAy*VS0(31,26)+WPy*VS1(31,26)&
   +r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))
VS0(49,27)=PAy*VS0(31,27)+WPy*VS1(31,27)&
   +r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(31,15)
VS0(49,28)=PAy*VS0(31,28)+WPy*VS1(31,28)&
   +r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(31,16)
VS0(49,29)=PAy*VS0(31,29)+WPy*VS1(31,29)&
   +r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +3D0*HfxZpE*VS1(31,17)
VS0(49,30)=PAy*VS0(31,30)+WPy*VS1(31,30)&
   +r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))
VS0(49,31)=PAy*VS0(31,31)+WPy*VS1(31,31)&
   +r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(31,18)
VS0(49,32)=PAy*VS0(31,32)+WPy*VS1(31,32)&
   +r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(31,19)
VS0(49,33)=PAy*VS0(31,33)+WPy*VS1(31,33)&
   +r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))
VS0(49,34)=PAy*VS0(31,34)+WPy*VS1(31,34)&
   +r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +HfxZpE*VS1(31,20)
VS0(49,35)=PAy*VS0(31,35)+WPy*VS1(31,35)&
   +r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(50,21)=PAy*VS0(32,21)+WPy*VS1(32,21)&
   +2D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(50,22)=PAy*VS0(32,22)+WPy*VS1(32,22)&
   +2D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +HfxZpE*VS1(32,11)
VS0(50,23)=PAy*VS0(32,23)+WPy*VS1(32,23)&
   +2D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(32,12)
VS0(50,24)=PAy*VS0(32,24)+WPy*VS1(32,24)&
   +2D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +3D0*HfxZpE*VS1(32,13)
VS0(50,25)=PAy*VS0(32,25)+WPy*VS1(32,25)&
   +2D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))&
   +4D0*HfxZpE*VS1(32,14)
VS0(50,26)=PAy*VS0(32,26)+WPy*VS1(32,26)&
   +2D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))
VS0(50,27)=PAy*VS0(32,27)+WPy*VS1(32,27)&
   +2D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(32,15)
VS0(50,28)=PAy*VS0(32,28)+WPy*VS1(32,28)&
   +2D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(32,16)
VS0(50,29)=PAy*VS0(32,29)+WPy*VS1(32,29)&
   +2D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +3D0*HfxZpE*VS1(32,17)
VS0(50,30)=PAy*VS0(32,30)+WPy*VS1(32,30)&
   +2D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))
VS0(50,31)=PAy*VS0(32,31)+WPy*VS1(32,31)&
   +2D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(32,18)
VS0(50,32)=PAy*VS0(32,32)+WPy*VS1(32,32)&
   +2D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(32,19)
VS0(50,33)=PAy*VS0(32,33)+WPy*VS1(32,33)&
   +2D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))
VS0(50,34)=PAy*VS0(32,34)+WPy*VS1(32,34)&
   +2D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +HfxZpE*VS1(32,20)
VS0(50,35)=PAy*VS0(32,35)+WPy*VS1(32,35)&
   +2D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(51,21)=PAz*VS0(30,21)+WPz*VS1(30,21)&
   +2D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))
VS0(51,22)=PAz*VS0(30,22)+WPz*VS1(30,22)&
   +2D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))
VS0(51,23)=PAz*VS0(30,23)+WPz*VS1(30,23)&
   +2D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))
VS0(51,24)=PAz*VS0(30,24)+WPz*VS1(30,24)&
   +2D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))
VS0(51,25)=PAz*VS0(30,25)+WPz*VS1(30,25)&
   +2D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(51,26)=PAz*VS0(30,26)+WPz*VS1(30,26)&
   +2D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +HfxZpE*VS1(30,11)
VS0(51,27)=PAz*VS0(30,27)+WPz*VS1(30,27)&
   +2D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +HfxZpE*VS1(30,12)
VS0(51,28)=PAz*VS0(30,28)+WPz*VS1(30,28)&
   +2D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(30,13)
VS0(51,29)=PAz*VS0(30,29)+WPz*VS1(30,29)&
   +2D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))&
   +HfxZpE*VS1(30,14)
VS0(51,30)=PAz*VS0(30,30)+WPz*VS1(30,30)&
   +2D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(30,15)
VS0(51,31)=PAz*VS0(30,31)+WPz*VS1(30,31)&
   +2D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(30,16)
VS0(51,32)=PAz*VS0(30,32)+WPz*VS1(30,32)&
   +2D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(30,17)
VS0(51,33)=PAz*VS0(30,33)+WPz*VS1(30,33)&
   +2D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +3D0*HfxZpE*VS1(30,18)
VS0(51,34)=PAz*VS0(30,34)+WPz*VS1(30,34)&
   +2D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))&
   +3D0*HfxZpE*VS1(30,19)
VS0(51,35)=PAz*VS0(30,35)+WPz*VS1(30,35)&
   +2D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))&
   +4D0*HfxZpE*VS1(30,20)
VS0(52,21)=PAz*VS0(31,21)+WPz*VS1(31,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(52,22)=PAz*VS0(31,22)+WPz*VS1(31,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))
VS0(52,23)=PAz*VS0(31,23)+WPz*VS1(31,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))
VS0(52,24)=PAz*VS0(31,24)+WPz*VS1(31,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))
VS0(52,25)=PAz*VS0(31,25)+WPz*VS1(31,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(52,26)=PAz*VS0(31,26)+WPz*VS1(31,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +HfxZpE*VS1(31,11)
VS0(52,27)=PAz*VS0(31,27)+WPz*VS1(31,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(31,12)
VS0(52,28)=PAz*VS0(31,28)+WPz*VS1(31,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(31,13)
VS0(52,29)=PAz*VS0(31,29)+WPz*VS1(31,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +HfxZpE*VS1(31,14)
VS0(52,30)=PAz*VS0(31,30)+WPz*VS1(31,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(31,15)
VS0(52,31)=PAz*VS0(31,31)+WPz*VS1(31,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +2D0*HfxZpE*VS1(31,16)
VS0(52,32)=PAz*VS0(31,32)+WPz*VS1(31,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(31,17)
VS0(52,33)=PAz*VS0(31,33)+WPz*VS1(31,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +3D0*HfxZpE*VS1(31,18)
VS0(52,34)=PAz*VS0(31,34)+WPz*VS1(31,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +3D0*HfxZpE*VS1(31,19)
VS0(52,35)=PAz*VS0(31,35)+WPz*VS1(31,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))&
   +4D0*HfxZpE*VS1(31,20)
VS0(53,21)=PAz*VS0(32,21)+WPz*VS1(32,21)&
   +2D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(53,22)=PAz*VS0(32,22)+WPz*VS1(32,22)&
   +2D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))
VS0(53,23)=PAz*VS0(32,23)+WPz*VS1(32,23)&
   +2D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))
VS0(53,24)=PAz*VS0(32,24)+WPz*VS1(32,24)&
   +2D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))
VS0(53,25)=PAz*VS0(32,25)+WPz*VS1(32,25)&
   +2D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(53,26)=PAz*VS0(32,26)+WPz*VS1(32,26)&
   +2D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +HfxZpE*VS1(32,11)
VS0(53,27)=PAz*VS0(32,27)+WPz*VS1(32,27)&
   +2D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(32,12)
VS0(53,28)=PAz*VS0(32,28)+WPz*VS1(32,28)&
   +2D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(32,13)
VS0(53,29)=PAz*VS0(32,29)+WPz*VS1(32,29)&
   +2D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +HfxZpE*VS1(32,14)
VS0(53,30)=PAz*VS0(32,30)+WPz*VS1(32,30)&
   +2D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(32,15)
VS0(53,31)=PAz*VS0(32,31)+WPz*VS1(32,31)&
   +2D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(32,16)
VS0(53,32)=PAz*VS0(32,32)+WPz*VS1(32,32)&
   +2D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(32,17)
VS0(53,33)=PAz*VS0(32,33)+WPz*VS1(32,33)&
   +2D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +3D0*HfxZpE*VS1(32,18)
VS0(53,34)=PAz*VS0(32,34)+WPz*VS1(32,34)&
   +2D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +3D0*HfxZpE*VS1(32,19)
VS0(53,35)=PAz*VS0(32,35)+WPz*VS1(32,35)&
   +2D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))&
   +4D0*HfxZpE*VS1(32,20)
VS0(54,21)=PAz*VS0(33,21)+WPz*VS1(33,21)&
   +3D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(54,22)=PAz*VS0(33,22)+WPz*VS1(33,22)&
   +3D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))
VS0(54,23)=PAz*VS0(33,23)+WPz*VS1(33,23)&
   +3D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))
VS0(54,24)=PAz*VS0(33,24)+WPz*VS1(33,24)&
   +3D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))
VS0(54,25)=PAz*VS0(33,25)+WPz*VS1(33,25)&
   +3D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(54,26)=PAz*VS0(33,26)+WPz*VS1(33,26)&
   +3D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +HfxZpE*VS1(33,11)
VS0(54,27)=PAz*VS0(33,27)+WPz*VS1(33,27)&
   +3D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(33,12)
VS0(54,28)=PAz*VS0(33,28)+WPz*VS1(33,28)&
   +3D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(33,13)
VS0(54,29)=PAz*VS0(33,29)+WPz*VS1(33,29)&
   +3D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +HfxZpE*VS1(33,14)
VS0(54,30)=PAz*VS0(33,30)+WPz*VS1(33,30)&
   +3D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(33,15)
VS0(54,31)=PAz*VS0(33,31)+WPz*VS1(33,31)&
   +3D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(33,16)
VS0(54,32)=PAz*VS0(33,32)+WPz*VS1(33,32)&
   +3D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(33,17)
VS0(54,33)=PAz*VS0(33,33)+WPz*VS1(33,33)&
   +3D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +3D0*HfxZpE*VS1(33,18)
VS0(54,34)=PAz*VS0(33,34)+WPz*VS1(33,34)&
   +3D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +3D0*HfxZpE*VS1(33,19)
VS0(54,35)=PAz*VS0(33,35)+WPz*VS1(33,35)&
   +3D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))&
   +4D0*HfxZpE*VS1(33,20)
VS0(55,21)=PAz*VS0(34,21)+WPz*VS1(34,21)&
   +3D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(55,22)=PAz*VS0(34,22)+WPz*VS1(34,22)&
   +3D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))
VS0(55,23)=PAz*VS0(34,23)+WPz*VS1(34,23)&
   +3D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))
VS0(55,24)=PAz*VS0(34,24)+WPz*VS1(34,24)&
   +3D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))
VS0(55,25)=PAz*VS0(34,25)+WPz*VS1(34,25)&
   +3D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(55,26)=PAz*VS0(34,26)+WPz*VS1(34,26)&
   +3D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +HfxZpE*VS1(34,11)
VS0(55,27)=PAz*VS0(34,27)+WPz*VS1(34,27)&
   +3D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(34,12)
VS0(55,28)=PAz*VS0(34,28)+WPz*VS1(34,28)&
   +3D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(34,13)
VS0(55,29)=PAz*VS0(34,29)+WPz*VS1(34,29)&
   +3D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +HfxZpE*VS1(34,14)
VS0(55,30)=PAz*VS0(34,30)+WPz*VS1(34,30)&
   +3D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(34,15)
VS0(55,31)=PAz*VS0(34,31)+WPz*VS1(34,31)&
   +3D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(34,16)
VS0(55,32)=PAz*VS0(34,32)+WPz*VS1(34,32)&
   +3D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(34,17)
VS0(55,33)=PAz*VS0(34,33)+WPz*VS1(34,33)&
   +3D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +3D0*HfxZpE*VS1(34,18)
VS0(55,34)=PAz*VS0(34,34)+WPz*VS1(34,34)&
   +3D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +3D0*HfxZpE*VS1(34,19)
VS0(55,35)=PAz*VS0(34,35)+WPz*VS1(34,35)&
   +3D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))&
   +4D0*HfxZpE*VS1(34,20)
VS0(56,21)=PAz*VS0(35,21)+WPz*VS1(35,21)&
   +4D0*r1x2Z*(VS0(20,21)-ExZpE*VS1(20,21))
VS0(56,22)=PAz*VS0(35,22)+WPz*VS1(35,22)&
   +4D0*r1x2Z*(VS0(20,22)-ExZpE*VS1(20,22))
VS0(56,23)=PAz*VS0(35,23)+WPz*VS1(35,23)&
   +4D0*r1x2Z*(VS0(20,23)-ExZpE*VS1(20,23))
VS0(56,24)=PAz*VS0(35,24)+WPz*VS1(35,24)&
   +4D0*r1x2Z*(VS0(20,24)-ExZpE*VS1(20,24))
VS0(56,25)=PAz*VS0(35,25)+WPz*VS1(35,25)&
   +4D0*r1x2Z*(VS0(20,25)-ExZpE*VS1(20,25))
VS0(56,26)=PAz*VS0(35,26)+WPz*VS1(35,26)&
   +4D0*r1x2Z*(VS0(20,26)-ExZpE*VS1(20,26))&
   +HfxZpE*VS1(35,11)
VS0(56,27)=PAz*VS0(35,27)+WPz*VS1(35,27)&
   +4D0*r1x2Z*(VS0(20,27)-ExZpE*VS1(20,27))&
   +HfxZpE*VS1(35,12)
VS0(56,28)=PAz*VS0(35,28)+WPz*VS1(35,28)&
   +4D0*r1x2Z*(VS0(20,28)-ExZpE*VS1(20,28))&
   +HfxZpE*VS1(35,13)
VS0(56,29)=PAz*VS0(35,29)+WPz*VS1(35,29)&
   +4D0*r1x2Z*(VS0(20,29)-ExZpE*VS1(20,29))&
   +HfxZpE*VS1(35,14)
VS0(56,30)=PAz*VS0(35,30)+WPz*VS1(35,30)&
   +4D0*r1x2Z*(VS0(20,30)-ExZpE*VS1(20,30))&
   +2D0*HfxZpE*VS1(35,15)
VS0(56,31)=PAz*VS0(35,31)+WPz*VS1(35,31)&
   +4D0*r1x2Z*(VS0(20,31)-ExZpE*VS1(20,31))&
   +2D0*HfxZpE*VS1(35,16)
VS0(56,32)=PAz*VS0(35,32)+WPz*VS1(35,32)&
   +4D0*r1x2Z*(VS0(20,32)-ExZpE*VS1(20,32))&
   +2D0*HfxZpE*VS1(35,17)
VS0(56,33)=PAz*VS0(35,33)+WPz*VS1(35,33)&
   +4D0*r1x2Z*(VS0(20,33)-ExZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(35,18)
VS0(56,34)=PAz*VS0(35,34)+WPz*VS1(35,34)&
   +4D0*r1x2Z*(VS0(20,34)-ExZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(35,19)
VS0(56,35)=PAz*VS0(35,35)+WPz*VS1(35,35)&
   +4D0*r1x2Z*(VS0(20,35)-ExZpE*VS1(20,35))&
   +4D0*HfxZpE*VS1(35,20)
CASE(2)
VS0(36,21)=PAx*VS0(21,21)+WPx*VS1(21,21)&
   +4D0*r1x2Z*(VS0(11,21)-ExZpE*VS1(11,21))&
   +4D0*HfxZpE*VS1(21,11)
VS0(36,22)=PAx*VS0(21,22)+WPx*VS1(21,22)&
   +4D0*r1x2Z*(VS0(11,22)-ExZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(21,12)
VS0(36,23)=PAx*VS0(21,23)+WPx*VS1(21,23)&
   +4D0*r1x2Z*(VS0(11,23)-ExZpE*VS1(11,23))&
   +2D0*HfxZpE*VS1(21,13)
VS0(36,24)=PAx*VS0(21,24)+WPx*VS1(21,24)&
   +4D0*r1x2Z*(VS0(11,24)-ExZpE*VS1(11,24))&
   +HfxZpE*VS1(21,14)
VS0(36,25)=PAx*VS0(21,25)+WPx*VS1(21,25)&
   +4D0*r1x2Z*(VS0(11,25)-ExZpE*VS1(11,25))
VS0(36,26)=PAx*VS0(21,26)+WPx*VS1(21,26)&
   +4D0*r1x2Z*(VS0(11,26)-ExZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(21,15)
VS0(36,27)=PAx*VS0(21,27)+WPx*VS1(21,27)&
   +4D0*r1x2Z*(VS0(11,27)-ExZpE*VS1(11,27))&
   +2D0*HfxZpE*VS1(21,16)
VS0(36,28)=PAx*VS0(21,28)+WPx*VS1(21,28)&
   +4D0*r1x2Z*(VS0(11,28)-ExZpE*VS1(11,28))&
   +HfxZpE*VS1(21,17)
VS0(36,29)=PAx*VS0(21,29)+WPx*VS1(21,29)&
   +4D0*r1x2Z*(VS0(11,29)-ExZpE*VS1(11,29))
VS0(36,30)=PAx*VS0(21,30)+WPx*VS1(21,30)&
   +4D0*r1x2Z*(VS0(11,30)-ExZpE*VS1(11,30))&
   +2D0*HfxZpE*VS1(21,18)
VS0(36,31)=PAx*VS0(21,31)+WPx*VS1(21,31)&
   +4D0*r1x2Z*(VS0(11,31)-ExZpE*VS1(11,31))&
   +HfxZpE*VS1(21,19)
VS0(36,32)=PAx*VS0(21,32)+WPx*VS1(21,32)&
   +4D0*r1x2Z*(VS0(11,32)-ExZpE*VS1(11,32))
VS0(36,33)=PAx*VS0(21,33)+WPx*VS1(21,33)&
   +4D0*r1x2Z*(VS0(11,33)-ExZpE*VS1(11,33))&
   +HfxZpE*VS1(21,20)
VS0(36,34)=PAx*VS0(21,34)+WPx*VS1(21,34)&
   +4D0*r1x2Z*(VS0(11,34)-ExZpE*VS1(11,34))
VS0(36,35)=PAx*VS0(21,35)+WPx*VS1(21,35)&
   +4D0*r1x2Z*(VS0(11,35)-ExZpE*VS1(11,35))
VS0(37,21)=PAx*VS0(22,21)+WPx*VS1(22,21)&
   +3D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))&
   +4D0*HfxZpE*VS1(22,11)
VS0(37,22)=PAx*VS0(22,22)+WPx*VS1(22,22)&
   +3D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +3D0*HfxZpE*VS1(22,12)
VS0(37,23)=PAx*VS0(22,23)+WPx*VS1(22,23)&
   +3D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(22,13)
VS0(37,24)=PAx*VS0(22,24)+WPx*VS1(22,24)&
   +3D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +HfxZpE*VS1(22,14)
VS0(37,25)=PAx*VS0(22,25)+WPx*VS1(22,25)&
   +3D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))
VS0(37,26)=PAx*VS0(22,26)+WPx*VS1(22,26)&
   +3D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))&
   +3D0*HfxZpE*VS1(22,15)
VS0(37,27)=PAx*VS0(22,27)+WPx*VS1(22,27)&
   +3D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(22,16)
VS0(37,28)=PAx*VS0(22,28)+WPx*VS1(22,28)&
   +3D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +HfxZpE*VS1(22,17)
VS0(37,29)=PAx*VS0(22,29)+WPx*VS1(22,29)&
   +3D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))
VS0(37,30)=PAx*VS0(22,30)+WPx*VS1(22,30)&
   +3D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(22,18)
VS0(37,31)=PAx*VS0(22,31)+WPx*VS1(22,31)&
   +3D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(22,19)
VS0(37,32)=PAx*VS0(22,32)+WPx*VS1(22,32)&
   +3D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))
VS0(37,33)=PAx*VS0(22,33)+WPx*VS1(22,33)&
   +3D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))&
   +HfxZpE*VS1(22,20)
VS0(37,34)=PAx*VS0(22,34)+WPx*VS1(22,34)&
   +3D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))
VS0(37,35)=PAx*VS0(22,35)+WPx*VS1(22,35)&
   +3D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(38,21)=PAx*VS0(23,21)+WPx*VS1(23,21)&
   +2D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))&
   +4D0*HfxZpE*VS1(23,11)
VS0(38,22)=PAx*VS0(23,22)+WPx*VS1(23,22)&
   +2D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +3D0*HfxZpE*VS1(23,12)
VS0(38,23)=PAx*VS0(23,23)+WPx*VS1(23,23)&
   +2D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(23,13)
VS0(38,24)=PAx*VS0(23,24)+WPx*VS1(23,24)&
   +2D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +HfxZpE*VS1(23,14)
VS0(38,25)=PAx*VS0(23,25)+WPx*VS1(23,25)&
   +2D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))
VS0(38,26)=PAx*VS0(23,26)+WPx*VS1(23,26)&
   +2D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))&
   +3D0*HfxZpE*VS1(23,15)
VS0(38,27)=PAx*VS0(23,27)+WPx*VS1(23,27)&
   +2D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(23,16)
VS0(38,28)=PAx*VS0(23,28)+WPx*VS1(23,28)&
   +2D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +HfxZpE*VS1(23,17)
VS0(38,29)=PAx*VS0(23,29)+WPx*VS1(23,29)&
   +2D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))
VS0(38,30)=PAx*VS0(23,30)+WPx*VS1(23,30)&
   +2D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))&
   +2D0*HfxZpE*VS1(23,18)
VS0(38,31)=PAx*VS0(23,31)+WPx*VS1(23,31)&
   +2D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(23,19)
VS0(38,32)=PAx*VS0(23,32)+WPx*VS1(23,32)&
   +2D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))
VS0(38,33)=PAx*VS0(23,33)+WPx*VS1(23,33)&
   +2D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))&
   +HfxZpE*VS1(23,20)
VS0(38,34)=PAx*VS0(23,34)+WPx*VS1(23,34)&
   +2D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))
VS0(38,35)=PAx*VS0(23,35)+WPx*VS1(23,35)&
   +2D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(39,21)=PAy*VS0(23,21)+WPy*VS1(23,21)+r1x2Z*VR1(23,21)&
   +2D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))
VS0(39,22)=PAy*VS0(23,22)+WPy*VS1(23,22)+r1x2Z*VR1(23,22)&
   +2D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +HfxZpE*VS1(23,11)
VS0(39,23)=PAy*VS0(23,23)+WPy*VS1(23,23)+r1x2Z*VR1(23,23)&
   +2D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(23,12)
VS0(39,24)=PAy*VS0(23,24)+WPy*VS1(23,24)+r1x2Z*VR1(23,24)&
   +2D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +3D0*HfxZpE*VS1(23,13)
VS0(39,25)=PAy*VS0(23,25)+WPy*VS1(23,25)+r1x2Z*VR1(23,25)&
   +2D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))&
   +4D0*HfxZpE*VS1(23,14)
VS0(39,26)=PAy*VS0(23,26)+WPy*VS1(23,26)+r1x2Z*VR1(23,26)&
   +2D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))
VS0(39,27)=PAy*VS0(23,27)+WPy*VS1(23,27)+r1x2Z*VR1(23,27)&
   +2D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +HfxZpE*VS1(23,15)
VS0(39,28)=PAy*VS0(23,28)+WPy*VS1(23,28)+r1x2Z*VR1(23,28)&
   +2D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(23,16)
VS0(39,29)=PAy*VS0(23,29)+WPy*VS1(23,29)+r1x2Z*VR1(23,29)&
   +2D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))&
   +3D0*HfxZpE*VS1(23,17)
VS0(39,30)=PAy*VS0(23,30)+WPy*VS1(23,30)+r1x2Z*VR1(23,30)&
   +2D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))
VS0(39,31)=PAy*VS0(23,31)+WPy*VS1(23,31)+r1x2Z*VR1(23,31)&
   +2D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(23,18)
VS0(39,32)=PAy*VS0(23,32)+WPy*VS1(23,32)+r1x2Z*VR1(23,32)&
   +2D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(23,19)
VS0(39,33)=PAy*VS0(23,33)+WPy*VS1(23,33)+r1x2Z*VR1(23,33)&
   +2D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))
VS0(39,34)=PAy*VS0(23,34)+WPy*VS1(23,34)+r1x2Z*VR1(23,34)&
   +2D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))&
   +HfxZpE*VS1(23,20)
VS0(39,35)=PAy*VS0(23,35)+WPy*VS1(23,35)+r1x2Z*VR1(23,35)&
   +2D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(40,21)=PAy*VS0(24,21)+WPy*VS1(24,21)+r1x2Z*VR1(24,21)&
   +3D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))
VS0(40,22)=PAy*VS0(24,22)+WPy*VS1(24,22)+r1x2Z*VR1(24,22)&
   +3D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +HfxZpE*VS1(24,11)
VS0(40,23)=PAy*VS0(24,23)+WPy*VS1(24,23)+r1x2Z*VR1(24,23)&
   +3D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(24,12)
VS0(40,24)=PAy*VS0(24,24)+WPy*VS1(24,24)+r1x2Z*VR1(24,24)&
   +3D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +3D0*HfxZpE*VS1(24,13)
VS0(40,25)=PAy*VS0(24,25)+WPy*VS1(24,25)+r1x2Z*VR1(24,25)&
   +3D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))&
   +4D0*HfxZpE*VS1(24,14)
VS0(40,26)=PAy*VS0(24,26)+WPy*VS1(24,26)+r1x2Z*VR1(24,26)&
   +3D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))
VS0(40,27)=PAy*VS0(24,27)+WPy*VS1(24,27)+r1x2Z*VR1(24,27)&
   +3D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +HfxZpE*VS1(24,15)
VS0(40,28)=PAy*VS0(24,28)+WPy*VS1(24,28)+r1x2Z*VR1(24,28)&
   +3D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(24,16)
VS0(40,29)=PAy*VS0(24,29)+WPy*VS1(24,29)+r1x2Z*VR1(24,29)&
   +3D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))&
   +3D0*HfxZpE*VS1(24,17)
VS0(40,30)=PAy*VS0(24,30)+WPy*VS1(24,30)+r1x2Z*VR1(24,30)&
   +3D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))
VS0(40,31)=PAy*VS0(24,31)+WPy*VS1(24,31)+r1x2Z*VR1(24,31)&
   +3D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(24,18)
VS0(40,32)=PAy*VS0(24,32)+WPy*VS1(24,32)+r1x2Z*VR1(24,32)&
   +3D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(24,19)
VS0(40,33)=PAy*VS0(24,33)+WPy*VS1(24,33)+r1x2Z*VR1(24,33)&
   +3D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))
VS0(40,34)=PAy*VS0(24,34)+WPy*VS1(24,34)+r1x2Z*VR1(24,34)&
   +3D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))&
   +HfxZpE*VS1(24,20)
VS0(40,35)=PAy*VS0(24,35)+WPy*VS1(24,35)+r1x2Z*VR1(24,35)&
   +3D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(41,21)=PAy*VS0(25,21)+WPy*VS1(25,21)+r1x2Z*VR1(25,21)&
   +4D0*r1x2Z*(VS0(14,21)-ExZpE*VS1(14,21))
VS0(41,22)=PAy*VS0(25,22)+WPy*VS1(25,22)+r1x2Z*VR1(25,22)&
   +4D0*r1x2Z*(VS0(14,22)-ExZpE*VS1(14,22))&
   +HfxZpE*VS1(25,11)
VS0(41,23)=PAy*VS0(25,23)+WPy*VS1(25,23)+r1x2Z*VR1(25,23)&
   +4D0*r1x2Z*(VS0(14,23)-ExZpE*VS1(14,23))&
   +2D0*HfxZpE*VS1(25,12)
VS0(41,24)=PAy*VS0(25,24)+WPy*VS1(25,24)+r1x2Z*VR1(25,24)&
   +4D0*r1x2Z*(VS0(14,24)-ExZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(25,13)
VS0(41,25)=PAy*VS0(25,25)+WPy*VS1(25,25)+r1x2Z*VR1(25,25)&
   +4D0*r1x2Z*(VS0(14,25)-ExZpE*VS1(14,25))&
   +4D0*HfxZpE*VS1(25,14)
VS0(41,26)=PAy*VS0(25,26)+WPy*VS1(25,26)+r1x2Z*VR1(25,26)&
   +4D0*r1x2Z*(VS0(14,26)-ExZpE*VS1(14,26))
VS0(41,27)=PAy*VS0(25,27)+WPy*VS1(25,27)+r1x2Z*VR1(25,27)&
   +4D0*r1x2Z*(VS0(14,27)-ExZpE*VS1(14,27))&
   +HfxZpE*VS1(25,15)
VS0(41,28)=PAy*VS0(25,28)+WPy*VS1(25,28)+r1x2Z*VR1(25,28)&
   +4D0*r1x2Z*(VS0(14,28)-ExZpE*VS1(14,28))&
   +2D0*HfxZpE*VS1(25,16)
VS0(41,29)=PAy*VS0(25,29)+WPy*VS1(25,29)+r1x2Z*VR1(25,29)&
   +4D0*r1x2Z*(VS0(14,29)-ExZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(25,17)
VS0(41,30)=PAy*VS0(25,30)+WPy*VS1(25,30)+r1x2Z*VR1(25,30)&
   +4D0*r1x2Z*(VS0(14,30)-ExZpE*VS1(14,30))
VS0(41,31)=PAy*VS0(25,31)+WPy*VS1(25,31)+r1x2Z*VR1(25,31)&
   +4D0*r1x2Z*(VS0(14,31)-ExZpE*VS1(14,31))&
   +HfxZpE*VS1(25,18)
VS0(41,32)=PAy*VS0(25,32)+WPy*VS1(25,32)+r1x2Z*VR1(25,32)&
   +4D0*r1x2Z*(VS0(14,32)-ExZpE*VS1(14,32))&
   +2D0*HfxZpE*VS1(25,19)
VS0(41,33)=PAy*VS0(25,33)+WPy*VS1(25,33)+r1x2Z*VR1(25,33)&
   +4D0*r1x2Z*(VS0(14,33)-ExZpE*VS1(14,33))
VS0(41,34)=PAy*VS0(25,34)+WPy*VS1(25,34)+r1x2Z*VR1(25,34)&
   +4D0*r1x2Z*(VS0(14,34)-ExZpE*VS1(14,34))&
   +HfxZpE*VS1(25,20)
VS0(41,35)=PAy*VS0(25,35)+WPy*VS1(25,35)+r1x2Z*VR1(25,35)&
   +4D0*r1x2Z*(VS0(14,35)-ExZpE*VS1(14,35))
VS0(42,21)=PAx*VS0(26,21)+WPx*VS1(26,21)&
   +3D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))&
   +4D0*HfxZpE*VS1(26,11)
VS0(42,22)=PAx*VS0(26,22)+WPx*VS1(26,22)&
   +3D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))&
   +3D0*HfxZpE*VS1(26,12)
VS0(42,23)=PAx*VS0(26,23)+WPx*VS1(26,23)&
   +3D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(26,13)
VS0(42,24)=PAx*VS0(26,24)+WPx*VS1(26,24)&
   +3D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))&
   +HfxZpE*VS1(26,14)
VS0(42,25)=PAx*VS0(26,25)+WPx*VS1(26,25)&
   +3D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(42,26)=PAx*VS0(26,26)+WPx*VS1(26,26)&
   +3D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +3D0*HfxZpE*VS1(26,15)
VS0(42,27)=PAx*VS0(26,27)+WPx*VS1(26,27)&
   +3D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(26,16)
VS0(42,28)=PAx*VS0(26,28)+WPx*VS1(26,28)&
   +3D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(26,17)
VS0(42,29)=PAx*VS0(26,29)+WPx*VS1(26,29)&
   +3D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))
VS0(42,30)=PAx*VS0(26,30)+WPx*VS1(26,30)&
   +3D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(26,18)
VS0(42,31)=PAx*VS0(26,31)+WPx*VS1(26,31)&
   +3D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +HfxZpE*VS1(26,19)
VS0(42,32)=PAx*VS0(26,32)+WPx*VS1(26,32)&
   +3D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))
VS0(42,33)=PAx*VS0(26,33)+WPx*VS1(26,33)&
   +3D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +HfxZpE*VS1(26,20)
VS0(42,34)=PAx*VS0(26,34)+WPx*VS1(26,34)&
   +3D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))
VS0(42,35)=PAx*VS0(26,35)+WPx*VS1(26,35)&
   +3D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))
VS0(43,21)=PAx*VS0(27,21)+WPx*VS1(27,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))&
   +4D0*HfxZpE*VS1(27,11)
VS0(43,22)=PAx*VS0(27,22)+WPx*VS1(27,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +3D0*HfxZpE*VS1(27,12)
VS0(43,23)=PAx*VS0(27,23)+WPx*VS1(27,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(27,13)
VS0(43,24)=PAx*VS0(27,24)+WPx*VS1(27,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +HfxZpE*VS1(27,14)
VS0(43,25)=PAx*VS0(27,25)+WPx*VS1(27,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(43,26)=PAx*VS0(27,26)+WPx*VS1(27,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +3D0*HfxZpE*VS1(27,15)
VS0(43,27)=PAx*VS0(27,27)+WPx*VS1(27,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +2D0*HfxZpE*VS1(27,16)
VS0(43,28)=PAx*VS0(27,28)+WPx*VS1(27,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(27,17)
VS0(43,29)=PAx*VS0(27,29)+WPx*VS1(27,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))
VS0(43,30)=PAx*VS0(27,30)+WPx*VS1(27,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(27,18)
VS0(43,31)=PAx*VS0(27,31)+WPx*VS1(27,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(27,19)
VS0(43,32)=PAx*VS0(27,32)+WPx*VS1(27,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))
VS0(43,33)=PAx*VS0(27,33)+WPx*VS1(27,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +HfxZpE*VS1(27,20)
VS0(43,34)=PAx*VS0(27,34)+WPx*VS1(27,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))
VS0(43,35)=PAx*VS0(27,35)+WPx*VS1(27,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(44,21)=PAx*VS0(28,21)+WPx*VS1(28,21)&
   +r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))&
   +4D0*HfxZpE*VS1(28,11)
VS0(44,22)=PAx*VS0(28,22)+WPx*VS1(28,22)&
   +r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +3D0*HfxZpE*VS1(28,12)
VS0(44,23)=PAx*VS0(28,23)+WPx*VS1(28,23)&
   +r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(28,13)
VS0(44,24)=PAx*VS0(28,24)+WPx*VS1(28,24)&
   +r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +HfxZpE*VS1(28,14)
VS0(44,25)=PAx*VS0(28,25)+WPx*VS1(28,25)&
   +r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(44,26)=PAx*VS0(28,26)+WPx*VS1(28,26)&
   +r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +3D0*HfxZpE*VS1(28,15)
VS0(44,27)=PAx*VS0(28,27)+WPx*VS1(28,27)&
   +r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(28,16)
VS0(44,28)=PAx*VS0(28,28)+WPx*VS1(28,28)&
   +r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(28,17)
VS0(44,29)=PAx*VS0(28,29)+WPx*VS1(28,29)&
   +r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))
VS0(44,30)=PAx*VS0(28,30)+WPx*VS1(28,30)&
   +r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(28,18)
VS0(44,31)=PAx*VS0(28,31)+WPx*VS1(28,31)&
   +r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(28,19)
VS0(44,32)=PAx*VS0(28,32)+WPx*VS1(28,32)&
   +r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))
VS0(44,33)=PAx*VS0(28,33)+WPx*VS1(28,33)&
   +r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +HfxZpE*VS1(28,20)
VS0(44,34)=PAx*VS0(28,34)+WPx*VS1(28,34)&
   +r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))
VS0(44,35)=PAx*VS0(28,35)+WPx*VS1(28,35)&
   +r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(45,21)=PAy*VS0(28,21)+WPy*VS1(28,21)+r1x2Z*VR1(28,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(45,22)=PAy*VS0(28,22)+WPy*VS1(28,22)+r1x2Z*VR1(28,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +HfxZpE*VS1(28,11)
VS0(45,23)=PAy*VS0(28,23)+WPy*VS1(28,23)+r1x2Z*VR1(28,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(28,12)
VS0(45,24)=PAy*VS0(28,24)+WPy*VS1(28,24)+r1x2Z*VR1(28,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +3D0*HfxZpE*VS1(28,13)
VS0(45,25)=PAy*VS0(28,25)+WPy*VS1(28,25)+r1x2Z*VR1(28,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))&
   +4D0*HfxZpE*VS1(28,14)
VS0(45,26)=PAy*VS0(28,26)+WPy*VS1(28,26)+r1x2Z*VR1(28,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))
VS0(45,27)=PAy*VS0(28,27)+WPy*VS1(28,27)+r1x2Z*VR1(28,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(28,15)
VS0(45,28)=PAy*VS0(28,28)+WPy*VS1(28,28)+r1x2Z*VR1(28,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +2D0*HfxZpE*VS1(28,16)
VS0(45,29)=PAy*VS0(28,29)+WPy*VS1(28,29)+r1x2Z*VR1(28,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +3D0*HfxZpE*VS1(28,17)
VS0(45,30)=PAy*VS0(28,30)+WPy*VS1(28,30)+r1x2Z*VR1(28,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))
VS0(45,31)=PAy*VS0(28,31)+WPy*VS1(28,31)+r1x2Z*VR1(28,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(28,18)
VS0(45,32)=PAy*VS0(28,32)+WPy*VS1(28,32)+r1x2Z*VR1(28,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(28,19)
VS0(45,33)=PAy*VS0(28,33)+WPy*VS1(28,33)+r1x2Z*VR1(28,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))
VS0(45,34)=PAy*VS0(28,34)+WPy*VS1(28,34)+r1x2Z*VR1(28,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +HfxZpE*VS1(28,20)
VS0(45,35)=PAy*VS0(28,35)+WPy*VS1(28,35)+r1x2Z*VR1(28,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(46,21)=PAy*VS0(29,21)+WPy*VS1(29,21)+r1x2Z*VR1(29,21)&
   +3D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(46,22)=PAy*VS0(29,22)+WPy*VS1(29,22)+r1x2Z*VR1(29,22)&
   +3D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +HfxZpE*VS1(29,11)
VS0(46,23)=PAy*VS0(29,23)+WPy*VS1(29,23)+r1x2Z*VR1(29,23)&
   +3D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(29,12)
VS0(46,24)=PAy*VS0(29,24)+WPy*VS1(29,24)+r1x2Z*VR1(29,24)&
   +3D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +3D0*HfxZpE*VS1(29,13)
VS0(46,25)=PAy*VS0(29,25)+WPy*VS1(29,25)+r1x2Z*VR1(29,25)&
   +3D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))&
   +4D0*HfxZpE*VS1(29,14)
VS0(46,26)=PAy*VS0(29,26)+WPy*VS1(29,26)+r1x2Z*VR1(29,26)&
   +3D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))
VS0(46,27)=PAy*VS0(29,27)+WPy*VS1(29,27)+r1x2Z*VR1(29,27)&
   +3D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(29,15)
VS0(46,28)=PAy*VS0(29,28)+WPy*VS1(29,28)+r1x2Z*VR1(29,28)&
   +3D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(29,16)
VS0(46,29)=PAy*VS0(29,29)+WPy*VS1(29,29)+r1x2Z*VR1(29,29)&
   +3D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +3D0*HfxZpE*VS1(29,17)
VS0(46,30)=PAy*VS0(29,30)+WPy*VS1(29,30)+r1x2Z*VR1(29,30)&
   +3D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))
VS0(46,31)=PAy*VS0(29,31)+WPy*VS1(29,31)+r1x2Z*VR1(29,31)&
   +3D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(29,18)
VS0(46,32)=PAy*VS0(29,32)+WPy*VS1(29,32)+r1x2Z*VR1(29,32)&
   +3D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(29,19)
VS0(46,33)=PAy*VS0(29,33)+WPy*VS1(29,33)+r1x2Z*VR1(29,33)&
   +3D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))
VS0(46,34)=PAy*VS0(29,34)+WPy*VS1(29,34)+r1x2Z*VR1(29,34)&
   +3D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +HfxZpE*VS1(29,20)
VS0(46,35)=PAy*VS0(29,35)+WPy*VS1(29,35)+r1x2Z*VR1(29,35)&
   +3D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(47,21)=PAx*VS0(30,21)+WPx*VS1(30,21)&
   +2D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))&
   +4D0*HfxZpE*VS1(30,11)
VS0(47,22)=PAx*VS0(30,22)+WPx*VS1(30,22)&
   +2D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +3D0*HfxZpE*VS1(30,12)
VS0(47,23)=PAx*VS0(30,23)+WPx*VS1(30,23)&
   +2D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(30,13)
VS0(47,24)=PAx*VS0(30,24)+WPx*VS1(30,24)&
   +2D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +HfxZpE*VS1(30,14)
VS0(47,25)=PAx*VS0(30,25)+WPx*VS1(30,25)&
   +2D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(47,26)=PAx*VS0(30,26)+WPx*VS1(30,26)&
   +2D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +3D0*HfxZpE*VS1(30,15)
VS0(47,27)=PAx*VS0(30,27)+WPx*VS1(30,27)&
   +2D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(30,16)
VS0(47,28)=PAx*VS0(30,28)+WPx*VS1(30,28)&
   +2D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(30,17)
VS0(47,29)=PAx*VS0(30,29)+WPx*VS1(30,29)&
   +2D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))
VS0(47,30)=PAx*VS0(30,30)+WPx*VS1(30,30)&
   +2D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(30,18)
VS0(47,31)=PAx*VS0(30,31)+WPx*VS1(30,31)&
   +2D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(30,19)
VS0(47,32)=PAx*VS0(30,32)+WPx*VS1(30,32)&
   +2D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))
VS0(47,33)=PAx*VS0(30,33)+WPx*VS1(30,33)&
   +2D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +HfxZpE*VS1(30,20)
VS0(47,34)=PAx*VS0(30,34)+WPx*VS1(30,34)&
   +2D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))
VS0(47,35)=PAx*VS0(30,35)+WPx*VS1(30,35)&
   +2D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(48,21)=PAx*VS0(31,21)+WPx*VS1(31,21)&
   +r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))&
   +4D0*HfxZpE*VS1(31,11)
VS0(48,22)=PAx*VS0(31,22)+WPx*VS1(31,22)&
   +r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +3D0*HfxZpE*VS1(31,12)
VS0(48,23)=PAx*VS0(31,23)+WPx*VS1(31,23)&
   +r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(31,13)
VS0(48,24)=PAx*VS0(31,24)+WPx*VS1(31,24)&
   +r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +HfxZpE*VS1(31,14)
VS0(48,25)=PAx*VS0(31,25)+WPx*VS1(31,25)&
   +r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(48,26)=PAx*VS0(31,26)+WPx*VS1(31,26)&
   +r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +3D0*HfxZpE*VS1(31,15)
VS0(48,27)=PAx*VS0(31,27)+WPx*VS1(31,27)&
   +r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(31,16)
VS0(48,28)=PAx*VS0(31,28)+WPx*VS1(31,28)&
   +r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(31,17)
VS0(48,29)=PAx*VS0(31,29)+WPx*VS1(31,29)&
   +r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))
VS0(48,30)=PAx*VS0(31,30)+WPx*VS1(31,30)&
   +r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(31,18)
VS0(48,31)=PAx*VS0(31,31)+WPx*VS1(31,31)&
   +r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(31,19)
VS0(48,32)=PAx*VS0(31,32)+WPx*VS1(31,32)&
   +r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))
VS0(48,33)=PAx*VS0(31,33)+WPx*VS1(31,33)&
   +r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +HfxZpE*VS1(31,20)
VS0(48,34)=PAx*VS0(31,34)+WPx*VS1(31,34)&
   +r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))
VS0(48,35)=PAx*VS0(31,35)+WPx*VS1(31,35)&
   +r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(49,21)=PAy*VS0(31,21)+WPy*VS1(31,21)+r1x2Z*VR1(31,21)&
   +r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(49,22)=PAy*VS0(31,22)+WPy*VS1(31,22)+r1x2Z*VR1(31,22)&
   +r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +HfxZpE*VS1(31,11)
VS0(49,23)=PAy*VS0(31,23)+WPy*VS1(31,23)+r1x2Z*VR1(31,23)&
   +r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(31,12)
VS0(49,24)=PAy*VS0(31,24)+WPy*VS1(31,24)+r1x2Z*VR1(31,24)&
   +r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +3D0*HfxZpE*VS1(31,13)
VS0(49,25)=PAy*VS0(31,25)+WPy*VS1(31,25)+r1x2Z*VR1(31,25)&
   +r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))&
   +4D0*HfxZpE*VS1(31,14)
VS0(49,26)=PAy*VS0(31,26)+WPy*VS1(31,26)+r1x2Z*VR1(31,26)&
   +r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))
VS0(49,27)=PAy*VS0(31,27)+WPy*VS1(31,27)+r1x2Z*VR1(31,27)&
   +r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(31,15)
VS0(49,28)=PAy*VS0(31,28)+WPy*VS1(31,28)+r1x2Z*VR1(31,28)&
   +r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(31,16)
VS0(49,29)=PAy*VS0(31,29)+WPy*VS1(31,29)+r1x2Z*VR1(31,29)&
   +r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +3D0*HfxZpE*VS1(31,17)
VS0(49,30)=PAy*VS0(31,30)+WPy*VS1(31,30)+r1x2Z*VR1(31,30)&
   +r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))
VS0(49,31)=PAy*VS0(31,31)+WPy*VS1(31,31)+r1x2Z*VR1(31,31)&
   +r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(31,18)
VS0(49,32)=PAy*VS0(31,32)+WPy*VS1(31,32)+r1x2Z*VR1(31,32)&
   +r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(31,19)
VS0(49,33)=PAy*VS0(31,33)+WPy*VS1(31,33)+r1x2Z*VR1(31,33)&
   +r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))
VS0(49,34)=PAy*VS0(31,34)+WPy*VS1(31,34)+r1x2Z*VR1(31,34)&
   +r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +HfxZpE*VS1(31,20)
VS0(49,35)=PAy*VS0(31,35)+WPy*VS1(31,35)+r1x2Z*VR1(31,35)&
   +r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(50,21)=PAy*VS0(32,21)+WPy*VS1(32,21)+r1x2Z*VR1(32,21)&
   +2D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(50,22)=PAy*VS0(32,22)+WPy*VS1(32,22)+r1x2Z*VR1(32,22)&
   +2D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +HfxZpE*VS1(32,11)
VS0(50,23)=PAy*VS0(32,23)+WPy*VS1(32,23)+r1x2Z*VR1(32,23)&
   +2D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(32,12)
VS0(50,24)=PAy*VS0(32,24)+WPy*VS1(32,24)+r1x2Z*VR1(32,24)&
   +2D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +3D0*HfxZpE*VS1(32,13)
VS0(50,25)=PAy*VS0(32,25)+WPy*VS1(32,25)+r1x2Z*VR1(32,25)&
   +2D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))&
   +4D0*HfxZpE*VS1(32,14)
VS0(50,26)=PAy*VS0(32,26)+WPy*VS1(32,26)+r1x2Z*VR1(32,26)&
   +2D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))
VS0(50,27)=PAy*VS0(32,27)+WPy*VS1(32,27)+r1x2Z*VR1(32,27)&
   +2D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(32,15)
VS0(50,28)=PAy*VS0(32,28)+WPy*VS1(32,28)+r1x2Z*VR1(32,28)&
   +2D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(32,16)
VS0(50,29)=PAy*VS0(32,29)+WPy*VS1(32,29)+r1x2Z*VR1(32,29)&
   +2D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +3D0*HfxZpE*VS1(32,17)
VS0(50,30)=PAy*VS0(32,30)+WPy*VS1(32,30)+r1x2Z*VR1(32,30)&
   +2D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))
VS0(50,31)=PAy*VS0(32,31)+WPy*VS1(32,31)+r1x2Z*VR1(32,31)&
   +2D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(32,18)
VS0(50,32)=PAy*VS0(32,32)+WPy*VS1(32,32)+r1x2Z*VR1(32,32)&
   +2D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(32,19)
VS0(50,33)=PAy*VS0(32,33)+WPy*VS1(32,33)+r1x2Z*VR1(32,33)&
   +2D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))
VS0(50,34)=PAy*VS0(32,34)+WPy*VS1(32,34)+r1x2Z*VR1(32,34)&
   +2D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +HfxZpE*VS1(32,20)
VS0(50,35)=PAy*VS0(32,35)+WPy*VS1(32,35)+r1x2Z*VR1(32,35)&
   +2D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(51,21)=PAz*VS0(30,21)+WPz*VS1(30,21)&
   +2D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))
VS0(51,22)=PAz*VS0(30,22)+WPz*VS1(30,22)&
   +2D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))
VS0(51,23)=PAz*VS0(30,23)+WPz*VS1(30,23)&
   +2D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))
VS0(51,24)=PAz*VS0(30,24)+WPz*VS1(30,24)&
   +2D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))
VS0(51,25)=PAz*VS0(30,25)+WPz*VS1(30,25)&
   +2D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(51,26)=PAz*VS0(30,26)+WPz*VS1(30,26)&
   +2D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +HfxZpE*VS1(30,11)
VS0(51,27)=PAz*VS0(30,27)+WPz*VS1(30,27)&
   +2D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +HfxZpE*VS1(30,12)
VS0(51,28)=PAz*VS0(30,28)+WPz*VS1(30,28)&
   +2D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(30,13)
VS0(51,29)=PAz*VS0(30,29)+WPz*VS1(30,29)&
   +2D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))&
   +HfxZpE*VS1(30,14)
VS0(51,30)=PAz*VS0(30,30)+WPz*VS1(30,30)&
   +2D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(30,15)
VS0(51,31)=PAz*VS0(30,31)+WPz*VS1(30,31)&
   +2D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(30,16)
VS0(51,32)=PAz*VS0(30,32)+WPz*VS1(30,32)&
   +2D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(30,17)
VS0(51,33)=PAz*VS0(30,33)+WPz*VS1(30,33)&
   +2D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +3D0*HfxZpE*VS1(30,18)
VS0(51,34)=PAz*VS0(30,34)+WPz*VS1(30,34)&
   +2D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))&
   +3D0*HfxZpE*VS1(30,19)
VS0(51,35)=PAz*VS0(30,35)+WPz*VS1(30,35)&
   +2D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))&
   +4D0*HfxZpE*VS1(30,20)
VS0(52,21)=PAz*VS0(31,21)+WPz*VS1(31,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(52,22)=PAz*VS0(31,22)+WPz*VS1(31,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))
VS0(52,23)=PAz*VS0(31,23)+WPz*VS1(31,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))
VS0(52,24)=PAz*VS0(31,24)+WPz*VS1(31,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))
VS0(52,25)=PAz*VS0(31,25)+WPz*VS1(31,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(52,26)=PAz*VS0(31,26)+WPz*VS1(31,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +HfxZpE*VS1(31,11)
VS0(52,27)=PAz*VS0(31,27)+WPz*VS1(31,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(31,12)
VS0(52,28)=PAz*VS0(31,28)+WPz*VS1(31,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(31,13)
VS0(52,29)=PAz*VS0(31,29)+WPz*VS1(31,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +HfxZpE*VS1(31,14)
VS0(52,30)=PAz*VS0(31,30)+WPz*VS1(31,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(31,15)
VS0(52,31)=PAz*VS0(31,31)+WPz*VS1(31,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +2D0*HfxZpE*VS1(31,16)
VS0(52,32)=PAz*VS0(31,32)+WPz*VS1(31,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(31,17)
VS0(52,33)=PAz*VS0(31,33)+WPz*VS1(31,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +3D0*HfxZpE*VS1(31,18)
VS0(52,34)=PAz*VS0(31,34)+WPz*VS1(31,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +3D0*HfxZpE*VS1(31,19)
VS0(52,35)=PAz*VS0(31,35)+WPz*VS1(31,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))&
   +4D0*HfxZpE*VS1(31,20)
VS0(53,21)=PAz*VS0(32,21)+WPz*VS1(32,21)&
   +2D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(53,22)=PAz*VS0(32,22)+WPz*VS1(32,22)&
   +2D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))
VS0(53,23)=PAz*VS0(32,23)+WPz*VS1(32,23)&
   +2D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))
VS0(53,24)=PAz*VS0(32,24)+WPz*VS1(32,24)&
   +2D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))
VS0(53,25)=PAz*VS0(32,25)+WPz*VS1(32,25)&
   +2D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(53,26)=PAz*VS0(32,26)+WPz*VS1(32,26)&
   +2D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +HfxZpE*VS1(32,11)
VS0(53,27)=PAz*VS0(32,27)+WPz*VS1(32,27)&
   +2D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(32,12)
VS0(53,28)=PAz*VS0(32,28)+WPz*VS1(32,28)&
   +2D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(32,13)
VS0(53,29)=PAz*VS0(32,29)+WPz*VS1(32,29)&
   +2D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +HfxZpE*VS1(32,14)
VS0(53,30)=PAz*VS0(32,30)+WPz*VS1(32,30)&
   +2D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(32,15)
VS0(53,31)=PAz*VS0(32,31)+WPz*VS1(32,31)&
   +2D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(32,16)
VS0(53,32)=PAz*VS0(32,32)+WPz*VS1(32,32)&
   +2D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(32,17)
VS0(53,33)=PAz*VS0(32,33)+WPz*VS1(32,33)&
   +2D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +3D0*HfxZpE*VS1(32,18)
VS0(53,34)=PAz*VS0(32,34)+WPz*VS1(32,34)&
   +2D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +3D0*HfxZpE*VS1(32,19)
VS0(53,35)=PAz*VS0(32,35)+WPz*VS1(32,35)&
   +2D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))&
   +4D0*HfxZpE*VS1(32,20)
VS0(54,21)=PAz*VS0(33,21)+WPz*VS1(33,21)&
   +3D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(54,22)=PAz*VS0(33,22)+WPz*VS1(33,22)&
   +3D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))
VS0(54,23)=PAz*VS0(33,23)+WPz*VS1(33,23)&
   +3D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))
VS0(54,24)=PAz*VS0(33,24)+WPz*VS1(33,24)&
   +3D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))
VS0(54,25)=PAz*VS0(33,25)+WPz*VS1(33,25)&
   +3D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(54,26)=PAz*VS0(33,26)+WPz*VS1(33,26)&
   +3D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +HfxZpE*VS1(33,11)
VS0(54,27)=PAz*VS0(33,27)+WPz*VS1(33,27)&
   +3D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(33,12)
VS0(54,28)=PAz*VS0(33,28)+WPz*VS1(33,28)&
   +3D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(33,13)
VS0(54,29)=PAz*VS0(33,29)+WPz*VS1(33,29)&
   +3D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +HfxZpE*VS1(33,14)
VS0(54,30)=PAz*VS0(33,30)+WPz*VS1(33,30)&
   +3D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(33,15)
VS0(54,31)=PAz*VS0(33,31)+WPz*VS1(33,31)&
   +3D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(33,16)
VS0(54,32)=PAz*VS0(33,32)+WPz*VS1(33,32)&
   +3D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(33,17)
VS0(54,33)=PAz*VS0(33,33)+WPz*VS1(33,33)&
   +3D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +3D0*HfxZpE*VS1(33,18)
VS0(54,34)=PAz*VS0(33,34)+WPz*VS1(33,34)&
   +3D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +3D0*HfxZpE*VS1(33,19)
VS0(54,35)=PAz*VS0(33,35)+WPz*VS1(33,35)&
   +3D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))&
   +4D0*HfxZpE*VS1(33,20)
VS0(55,21)=PAz*VS0(34,21)+WPz*VS1(34,21)&
   +3D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(55,22)=PAz*VS0(34,22)+WPz*VS1(34,22)&
   +3D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))
VS0(55,23)=PAz*VS0(34,23)+WPz*VS1(34,23)&
   +3D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))
VS0(55,24)=PAz*VS0(34,24)+WPz*VS1(34,24)&
   +3D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))
VS0(55,25)=PAz*VS0(34,25)+WPz*VS1(34,25)&
   +3D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(55,26)=PAz*VS0(34,26)+WPz*VS1(34,26)&
   +3D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +HfxZpE*VS1(34,11)
VS0(55,27)=PAz*VS0(34,27)+WPz*VS1(34,27)&
   +3D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(34,12)
VS0(55,28)=PAz*VS0(34,28)+WPz*VS1(34,28)&
   +3D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(34,13)
VS0(55,29)=PAz*VS0(34,29)+WPz*VS1(34,29)&
   +3D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +HfxZpE*VS1(34,14)
VS0(55,30)=PAz*VS0(34,30)+WPz*VS1(34,30)&
   +3D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(34,15)
VS0(55,31)=PAz*VS0(34,31)+WPz*VS1(34,31)&
   +3D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(34,16)
VS0(55,32)=PAz*VS0(34,32)+WPz*VS1(34,32)&
   +3D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(34,17)
VS0(55,33)=PAz*VS0(34,33)+WPz*VS1(34,33)&
   +3D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +3D0*HfxZpE*VS1(34,18)
VS0(55,34)=PAz*VS0(34,34)+WPz*VS1(34,34)&
   +3D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +3D0*HfxZpE*VS1(34,19)
VS0(55,35)=PAz*VS0(34,35)+WPz*VS1(34,35)&
   +3D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))&
   +4D0*HfxZpE*VS1(34,20)
VS0(56,21)=PAz*VS0(35,21)+WPz*VS1(35,21)&
   +4D0*r1x2Z*(VS0(20,21)-ExZpE*VS1(20,21))
VS0(56,22)=PAz*VS0(35,22)+WPz*VS1(35,22)&
   +4D0*r1x2Z*(VS0(20,22)-ExZpE*VS1(20,22))
VS0(56,23)=PAz*VS0(35,23)+WPz*VS1(35,23)&
   +4D0*r1x2Z*(VS0(20,23)-ExZpE*VS1(20,23))
VS0(56,24)=PAz*VS0(35,24)+WPz*VS1(35,24)&
   +4D0*r1x2Z*(VS0(20,24)-ExZpE*VS1(20,24))
VS0(56,25)=PAz*VS0(35,25)+WPz*VS1(35,25)&
   +4D0*r1x2Z*(VS0(20,25)-ExZpE*VS1(20,25))
VS0(56,26)=PAz*VS0(35,26)+WPz*VS1(35,26)&
   +4D0*r1x2Z*(VS0(20,26)-ExZpE*VS1(20,26))&
   +HfxZpE*VS1(35,11)
VS0(56,27)=PAz*VS0(35,27)+WPz*VS1(35,27)&
   +4D0*r1x2Z*(VS0(20,27)-ExZpE*VS1(20,27))&
   +HfxZpE*VS1(35,12)
VS0(56,28)=PAz*VS0(35,28)+WPz*VS1(35,28)&
   +4D0*r1x2Z*(VS0(20,28)-ExZpE*VS1(20,28))&
   +HfxZpE*VS1(35,13)
VS0(56,29)=PAz*VS0(35,29)+WPz*VS1(35,29)&
   +4D0*r1x2Z*(VS0(20,29)-ExZpE*VS1(20,29))&
   +HfxZpE*VS1(35,14)
VS0(56,30)=PAz*VS0(35,30)+WPz*VS1(35,30)&
   +4D0*r1x2Z*(VS0(20,30)-ExZpE*VS1(20,30))&
   +2D0*HfxZpE*VS1(35,15)
VS0(56,31)=PAz*VS0(35,31)+WPz*VS1(35,31)&
   +4D0*r1x2Z*(VS0(20,31)-ExZpE*VS1(20,31))&
   +2D0*HfxZpE*VS1(35,16)
VS0(56,32)=PAz*VS0(35,32)+WPz*VS1(35,32)&
   +4D0*r1x2Z*(VS0(20,32)-ExZpE*VS1(20,32))&
   +2D0*HfxZpE*VS1(35,17)
VS0(56,33)=PAz*VS0(35,33)+WPz*VS1(35,33)&
   +4D0*r1x2Z*(VS0(20,33)-ExZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(35,18)
VS0(56,34)=PAz*VS0(35,34)+WPz*VS1(35,34)&
   +4D0*r1x2Z*(VS0(20,34)-ExZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(35,19)
VS0(56,35)=PAz*VS0(35,35)+WPz*VS1(35,35)&
   +4D0*r1x2Z*(VS0(20,35)-ExZpE*VS1(20,35))&
   +4D0*HfxZpE*VS1(35,20)
CASE(3)
VS0(36,21)=PAx*VS0(21,21)+WPx*VS1(21,21)&
   +4D0*r1x2Z*(VS0(11,21)-ExZpE*VS1(11,21))&
   +4D0*HfxZpE*VS1(21,11)
VS0(36,22)=PAx*VS0(21,22)+WPx*VS1(21,22)&
   +4D0*r1x2Z*(VS0(11,22)-ExZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(21,12)
VS0(36,23)=PAx*VS0(21,23)+WPx*VS1(21,23)&
   +4D0*r1x2Z*(VS0(11,23)-ExZpE*VS1(11,23))&
   +2D0*HfxZpE*VS1(21,13)
VS0(36,24)=PAx*VS0(21,24)+WPx*VS1(21,24)&
   +4D0*r1x2Z*(VS0(11,24)-ExZpE*VS1(11,24))&
   +HfxZpE*VS1(21,14)
VS0(36,25)=PAx*VS0(21,25)+WPx*VS1(21,25)&
   +4D0*r1x2Z*(VS0(11,25)-ExZpE*VS1(11,25))
VS0(36,26)=PAx*VS0(21,26)+WPx*VS1(21,26)&
   +4D0*r1x2Z*(VS0(11,26)-ExZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(21,15)
VS0(36,27)=PAx*VS0(21,27)+WPx*VS1(21,27)&
   +4D0*r1x2Z*(VS0(11,27)-ExZpE*VS1(11,27))&
   +2D0*HfxZpE*VS1(21,16)
VS0(36,28)=PAx*VS0(21,28)+WPx*VS1(21,28)&
   +4D0*r1x2Z*(VS0(11,28)-ExZpE*VS1(11,28))&
   +HfxZpE*VS1(21,17)
VS0(36,29)=PAx*VS0(21,29)+WPx*VS1(21,29)&
   +4D0*r1x2Z*(VS0(11,29)-ExZpE*VS1(11,29))
VS0(36,30)=PAx*VS0(21,30)+WPx*VS1(21,30)&
   +4D0*r1x2Z*(VS0(11,30)-ExZpE*VS1(11,30))&
   +2D0*HfxZpE*VS1(21,18)
VS0(36,31)=PAx*VS0(21,31)+WPx*VS1(21,31)&
   +4D0*r1x2Z*(VS0(11,31)-ExZpE*VS1(11,31))&
   +HfxZpE*VS1(21,19)
VS0(36,32)=PAx*VS0(21,32)+WPx*VS1(21,32)&
   +4D0*r1x2Z*(VS0(11,32)-ExZpE*VS1(11,32))
VS0(36,33)=PAx*VS0(21,33)+WPx*VS1(21,33)&
   +4D0*r1x2Z*(VS0(11,33)-ExZpE*VS1(11,33))&
   +HfxZpE*VS1(21,20)
VS0(36,34)=PAx*VS0(21,34)+WPx*VS1(21,34)&
   +4D0*r1x2Z*(VS0(11,34)-ExZpE*VS1(11,34))
VS0(36,35)=PAx*VS0(21,35)+WPx*VS1(21,35)&
   +4D0*r1x2Z*(VS0(11,35)-ExZpE*VS1(11,35))
VS0(37,21)=PAx*VS0(22,21)+WPx*VS1(22,21)&
   +3D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))&
   +4D0*HfxZpE*VS1(22,11)
VS0(37,22)=PAx*VS0(22,22)+WPx*VS1(22,22)&
   +3D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +3D0*HfxZpE*VS1(22,12)
VS0(37,23)=PAx*VS0(22,23)+WPx*VS1(22,23)&
   +3D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(22,13)
VS0(37,24)=PAx*VS0(22,24)+WPx*VS1(22,24)&
   +3D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +HfxZpE*VS1(22,14)
VS0(37,25)=PAx*VS0(22,25)+WPx*VS1(22,25)&
   +3D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))
VS0(37,26)=PAx*VS0(22,26)+WPx*VS1(22,26)&
   +3D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))&
   +3D0*HfxZpE*VS1(22,15)
VS0(37,27)=PAx*VS0(22,27)+WPx*VS1(22,27)&
   +3D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(22,16)
VS0(37,28)=PAx*VS0(22,28)+WPx*VS1(22,28)&
   +3D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +HfxZpE*VS1(22,17)
VS0(37,29)=PAx*VS0(22,29)+WPx*VS1(22,29)&
   +3D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))
VS0(37,30)=PAx*VS0(22,30)+WPx*VS1(22,30)&
   +3D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(22,18)
VS0(37,31)=PAx*VS0(22,31)+WPx*VS1(22,31)&
   +3D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(22,19)
VS0(37,32)=PAx*VS0(22,32)+WPx*VS1(22,32)&
   +3D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))
VS0(37,33)=PAx*VS0(22,33)+WPx*VS1(22,33)&
   +3D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))&
   +HfxZpE*VS1(22,20)
VS0(37,34)=PAx*VS0(22,34)+WPx*VS1(22,34)&
   +3D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))
VS0(37,35)=PAx*VS0(22,35)+WPx*VS1(22,35)&
   +3D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(38,21)=PAx*VS0(23,21)+WPx*VS1(23,21)&
   +2D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))&
   +4D0*HfxZpE*VS1(23,11)
VS0(38,22)=PAx*VS0(23,22)+WPx*VS1(23,22)&
   +2D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +3D0*HfxZpE*VS1(23,12)
VS0(38,23)=PAx*VS0(23,23)+WPx*VS1(23,23)&
   +2D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(23,13)
VS0(38,24)=PAx*VS0(23,24)+WPx*VS1(23,24)&
   +2D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +HfxZpE*VS1(23,14)
VS0(38,25)=PAx*VS0(23,25)+WPx*VS1(23,25)&
   +2D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))
VS0(38,26)=PAx*VS0(23,26)+WPx*VS1(23,26)&
   +2D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))&
   +3D0*HfxZpE*VS1(23,15)
VS0(38,27)=PAx*VS0(23,27)+WPx*VS1(23,27)&
   +2D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(23,16)
VS0(38,28)=PAx*VS0(23,28)+WPx*VS1(23,28)&
   +2D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +HfxZpE*VS1(23,17)
VS0(38,29)=PAx*VS0(23,29)+WPx*VS1(23,29)&
   +2D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))
VS0(38,30)=PAx*VS0(23,30)+WPx*VS1(23,30)&
   +2D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))&
   +2D0*HfxZpE*VS1(23,18)
VS0(38,31)=PAx*VS0(23,31)+WPx*VS1(23,31)&
   +2D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(23,19)
VS0(38,32)=PAx*VS0(23,32)+WPx*VS1(23,32)&
   +2D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))
VS0(38,33)=PAx*VS0(23,33)+WPx*VS1(23,33)&
   +2D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))&
   +HfxZpE*VS1(23,20)
VS0(38,34)=PAx*VS0(23,34)+WPx*VS1(23,34)&
   +2D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))
VS0(38,35)=PAx*VS0(23,35)+WPx*VS1(23,35)&
   +2D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(39,21)=PAy*VS0(23,21)+WPy*VS1(23,21)&
   +2D0*r1x2Z*(VS0(12,21)-ExZpE*VS1(12,21))
VS0(39,22)=PAy*VS0(23,22)+WPy*VS1(23,22)&
   +2D0*r1x2Z*(VS0(12,22)-ExZpE*VS1(12,22))&
   +HfxZpE*VS1(23,11)
VS0(39,23)=PAy*VS0(23,23)+WPy*VS1(23,23)&
   +2D0*r1x2Z*(VS0(12,23)-ExZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(23,12)
VS0(39,24)=PAy*VS0(23,24)+WPy*VS1(23,24)&
   +2D0*r1x2Z*(VS0(12,24)-ExZpE*VS1(12,24))&
   +3D0*HfxZpE*VS1(23,13)
VS0(39,25)=PAy*VS0(23,25)+WPy*VS1(23,25)&
   +2D0*r1x2Z*(VS0(12,25)-ExZpE*VS1(12,25))&
   +4D0*HfxZpE*VS1(23,14)
VS0(39,26)=PAy*VS0(23,26)+WPy*VS1(23,26)&
   +2D0*r1x2Z*(VS0(12,26)-ExZpE*VS1(12,26))
VS0(39,27)=PAy*VS0(23,27)+WPy*VS1(23,27)&
   +2D0*r1x2Z*(VS0(12,27)-ExZpE*VS1(12,27))&
   +HfxZpE*VS1(23,15)
VS0(39,28)=PAy*VS0(23,28)+WPy*VS1(23,28)&
   +2D0*r1x2Z*(VS0(12,28)-ExZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(23,16)
VS0(39,29)=PAy*VS0(23,29)+WPy*VS1(23,29)&
   +2D0*r1x2Z*(VS0(12,29)-ExZpE*VS1(12,29))&
   +3D0*HfxZpE*VS1(23,17)
VS0(39,30)=PAy*VS0(23,30)+WPy*VS1(23,30)&
   +2D0*r1x2Z*(VS0(12,30)-ExZpE*VS1(12,30))
VS0(39,31)=PAy*VS0(23,31)+WPy*VS1(23,31)&
   +2D0*r1x2Z*(VS0(12,31)-ExZpE*VS1(12,31))&
   +HfxZpE*VS1(23,18)
VS0(39,32)=PAy*VS0(23,32)+WPy*VS1(23,32)&
   +2D0*r1x2Z*(VS0(12,32)-ExZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(23,19)
VS0(39,33)=PAy*VS0(23,33)+WPy*VS1(23,33)&
   +2D0*r1x2Z*(VS0(12,33)-ExZpE*VS1(12,33))
VS0(39,34)=PAy*VS0(23,34)+WPy*VS1(23,34)&
   +2D0*r1x2Z*(VS0(12,34)-ExZpE*VS1(12,34))&
   +HfxZpE*VS1(23,20)
VS0(39,35)=PAy*VS0(23,35)+WPy*VS1(23,35)&
   +2D0*r1x2Z*(VS0(12,35)-ExZpE*VS1(12,35))
VS0(40,21)=PAy*VS0(24,21)+WPy*VS1(24,21)&
   +3D0*r1x2Z*(VS0(13,21)-ExZpE*VS1(13,21))
VS0(40,22)=PAy*VS0(24,22)+WPy*VS1(24,22)&
   +3D0*r1x2Z*(VS0(13,22)-ExZpE*VS1(13,22))&
   +HfxZpE*VS1(24,11)
VS0(40,23)=PAy*VS0(24,23)+WPy*VS1(24,23)&
   +3D0*r1x2Z*(VS0(13,23)-ExZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(24,12)
VS0(40,24)=PAy*VS0(24,24)+WPy*VS1(24,24)&
   +3D0*r1x2Z*(VS0(13,24)-ExZpE*VS1(13,24))&
   +3D0*HfxZpE*VS1(24,13)
VS0(40,25)=PAy*VS0(24,25)+WPy*VS1(24,25)&
   +3D0*r1x2Z*(VS0(13,25)-ExZpE*VS1(13,25))&
   +4D0*HfxZpE*VS1(24,14)
VS0(40,26)=PAy*VS0(24,26)+WPy*VS1(24,26)&
   +3D0*r1x2Z*(VS0(13,26)-ExZpE*VS1(13,26))
VS0(40,27)=PAy*VS0(24,27)+WPy*VS1(24,27)&
   +3D0*r1x2Z*(VS0(13,27)-ExZpE*VS1(13,27))&
   +HfxZpE*VS1(24,15)
VS0(40,28)=PAy*VS0(24,28)+WPy*VS1(24,28)&
   +3D0*r1x2Z*(VS0(13,28)-ExZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(24,16)
VS0(40,29)=PAy*VS0(24,29)+WPy*VS1(24,29)&
   +3D0*r1x2Z*(VS0(13,29)-ExZpE*VS1(13,29))&
   +3D0*HfxZpE*VS1(24,17)
VS0(40,30)=PAy*VS0(24,30)+WPy*VS1(24,30)&
   +3D0*r1x2Z*(VS0(13,30)-ExZpE*VS1(13,30))
VS0(40,31)=PAy*VS0(24,31)+WPy*VS1(24,31)&
   +3D0*r1x2Z*(VS0(13,31)-ExZpE*VS1(13,31))&
   +HfxZpE*VS1(24,18)
VS0(40,32)=PAy*VS0(24,32)+WPy*VS1(24,32)&
   +3D0*r1x2Z*(VS0(13,32)-ExZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(24,19)
VS0(40,33)=PAy*VS0(24,33)+WPy*VS1(24,33)&
   +3D0*r1x2Z*(VS0(13,33)-ExZpE*VS1(13,33))
VS0(40,34)=PAy*VS0(24,34)+WPy*VS1(24,34)&
   +3D0*r1x2Z*(VS0(13,34)-ExZpE*VS1(13,34))&
   +HfxZpE*VS1(24,20)
VS0(40,35)=PAy*VS0(24,35)+WPy*VS1(24,35)&
   +3D0*r1x2Z*(VS0(13,35)-ExZpE*VS1(13,35))
VS0(41,21)=PAy*VS0(25,21)+WPy*VS1(25,21)&
   +4D0*r1x2Z*(VS0(14,21)-ExZpE*VS1(14,21))
VS0(41,22)=PAy*VS0(25,22)+WPy*VS1(25,22)&
   +4D0*r1x2Z*(VS0(14,22)-ExZpE*VS1(14,22))&
   +HfxZpE*VS1(25,11)
VS0(41,23)=PAy*VS0(25,23)+WPy*VS1(25,23)&
   +4D0*r1x2Z*(VS0(14,23)-ExZpE*VS1(14,23))&
   +2D0*HfxZpE*VS1(25,12)
VS0(41,24)=PAy*VS0(25,24)+WPy*VS1(25,24)&
   +4D0*r1x2Z*(VS0(14,24)-ExZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(25,13)
VS0(41,25)=PAy*VS0(25,25)+WPy*VS1(25,25)&
   +4D0*r1x2Z*(VS0(14,25)-ExZpE*VS1(14,25))&
   +4D0*HfxZpE*VS1(25,14)
VS0(41,26)=PAy*VS0(25,26)+WPy*VS1(25,26)&
   +4D0*r1x2Z*(VS0(14,26)-ExZpE*VS1(14,26))
VS0(41,27)=PAy*VS0(25,27)+WPy*VS1(25,27)&
   +4D0*r1x2Z*(VS0(14,27)-ExZpE*VS1(14,27))&
   +HfxZpE*VS1(25,15)
VS0(41,28)=PAy*VS0(25,28)+WPy*VS1(25,28)&
   +4D0*r1x2Z*(VS0(14,28)-ExZpE*VS1(14,28))&
   +2D0*HfxZpE*VS1(25,16)
VS0(41,29)=PAy*VS0(25,29)+WPy*VS1(25,29)&
   +4D0*r1x2Z*(VS0(14,29)-ExZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(25,17)
VS0(41,30)=PAy*VS0(25,30)+WPy*VS1(25,30)&
   +4D0*r1x2Z*(VS0(14,30)-ExZpE*VS1(14,30))
VS0(41,31)=PAy*VS0(25,31)+WPy*VS1(25,31)&
   +4D0*r1x2Z*(VS0(14,31)-ExZpE*VS1(14,31))&
   +HfxZpE*VS1(25,18)
VS0(41,32)=PAy*VS0(25,32)+WPy*VS1(25,32)&
   +4D0*r1x2Z*(VS0(14,32)-ExZpE*VS1(14,32))&
   +2D0*HfxZpE*VS1(25,19)
VS0(41,33)=PAy*VS0(25,33)+WPy*VS1(25,33)&
   +4D0*r1x2Z*(VS0(14,33)-ExZpE*VS1(14,33))
VS0(41,34)=PAy*VS0(25,34)+WPy*VS1(25,34)&
   +4D0*r1x2Z*(VS0(14,34)-ExZpE*VS1(14,34))&
   +HfxZpE*VS1(25,20)
VS0(41,35)=PAy*VS0(25,35)+WPy*VS1(25,35)&
   +4D0*r1x2Z*(VS0(14,35)-ExZpE*VS1(14,35))
VS0(42,21)=PAx*VS0(26,21)+WPx*VS1(26,21)&
   +3D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))&
   +4D0*HfxZpE*VS1(26,11)
VS0(42,22)=PAx*VS0(26,22)+WPx*VS1(26,22)&
   +3D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))&
   +3D0*HfxZpE*VS1(26,12)
VS0(42,23)=PAx*VS0(26,23)+WPx*VS1(26,23)&
   +3D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(26,13)
VS0(42,24)=PAx*VS0(26,24)+WPx*VS1(26,24)&
   +3D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))&
   +HfxZpE*VS1(26,14)
VS0(42,25)=PAx*VS0(26,25)+WPx*VS1(26,25)&
   +3D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(42,26)=PAx*VS0(26,26)+WPx*VS1(26,26)&
   +3D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +3D0*HfxZpE*VS1(26,15)
VS0(42,27)=PAx*VS0(26,27)+WPx*VS1(26,27)&
   +3D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(26,16)
VS0(42,28)=PAx*VS0(26,28)+WPx*VS1(26,28)&
   +3D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(26,17)
VS0(42,29)=PAx*VS0(26,29)+WPx*VS1(26,29)&
   +3D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))
VS0(42,30)=PAx*VS0(26,30)+WPx*VS1(26,30)&
   +3D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(26,18)
VS0(42,31)=PAx*VS0(26,31)+WPx*VS1(26,31)&
   +3D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +HfxZpE*VS1(26,19)
VS0(42,32)=PAx*VS0(26,32)+WPx*VS1(26,32)&
   +3D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))
VS0(42,33)=PAx*VS0(26,33)+WPx*VS1(26,33)&
   +3D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +HfxZpE*VS1(26,20)
VS0(42,34)=PAx*VS0(26,34)+WPx*VS1(26,34)&
   +3D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))
VS0(42,35)=PAx*VS0(26,35)+WPx*VS1(26,35)&
   +3D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))
VS0(43,21)=PAx*VS0(27,21)+WPx*VS1(27,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))&
   +4D0*HfxZpE*VS1(27,11)
VS0(43,22)=PAx*VS0(27,22)+WPx*VS1(27,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +3D0*HfxZpE*VS1(27,12)
VS0(43,23)=PAx*VS0(27,23)+WPx*VS1(27,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(27,13)
VS0(43,24)=PAx*VS0(27,24)+WPx*VS1(27,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +HfxZpE*VS1(27,14)
VS0(43,25)=PAx*VS0(27,25)+WPx*VS1(27,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(43,26)=PAx*VS0(27,26)+WPx*VS1(27,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +3D0*HfxZpE*VS1(27,15)
VS0(43,27)=PAx*VS0(27,27)+WPx*VS1(27,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +2D0*HfxZpE*VS1(27,16)
VS0(43,28)=PAx*VS0(27,28)+WPx*VS1(27,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(27,17)
VS0(43,29)=PAx*VS0(27,29)+WPx*VS1(27,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))
VS0(43,30)=PAx*VS0(27,30)+WPx*VS1(27,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(27,18)
VS0(43,31)=PAx*VS0(27,31)+WPx*VS1(27,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(27,19)
VS0(43,32)=PAx*VS0(27,32)+WPx*VS1(27,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))
VS0(43,33)=PAx*VS0(27,33)+WPx*VS1(27,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +HfxZpE*VS1(27,20)
VS0(43,34)=PAx*VS0(27,34)+WPx*VS1(27,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))
VS0(43,35)=PAx*VS0(27,35)+WPx*VS1(27,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(44,21)=PAx*VS0(28,21)+WPx*VS1(28,21)&
   +r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))&
   +4D0*HfxZpE*VS1(28,11)
VS0(44,22)=PAx*VS0(28,22)+WPx*VS1(28,22)&
   +r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +3D0*HfxZpE*VS1(28,12)
VS0(44,23)=PAx*VS0(28,23)+WPx*VS1(28,23)&
   +r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(28,13)
VS0(44,24)=PAx*VS0(28,24)+WPx*VS1(28,24)&
   +r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +HfxZpE*VS1(28,14)
VS0(44,25)=PAx*VS0(28,25)+WPx*VS1(28,25)&
   +r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(44,26)=PAx*VS0(28,26)+WPx*VS1(28,26)&
   +r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +3D0*HfxZpE*VS1(28,15)
VS0(44,27)=PAx*VS0(28,27)+WPx*VS1(28,27)&
   +r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(28,16)
VS0(44,28)=PAx*VS0(28,28)+WPx*VS1(28,28)&
   +r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(28,17)
VS0(44,29)=PAx*VS0(28,29)+WPx*VS1(28,29)&
   +r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))
VS0(44,30)=PAx*VS0(28,30)+WPx*VS1(28,30)&
   +r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(28,18)
VS0(44,31)=PAx*VS0(28,31)+WPx*VS1(28,31)&
   +r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(28,19)
VS0(44,32)=PAx*VS0(28,32)+WPx*VS1(28,32)&
   +r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))
VS0(44,33)=PAx*VS0(28,33)+WPx*VS1(28,33)&
   +r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +HfxZpE*VS1(28,20)
VS0(44,34)=PAx*VS0(28,34)+WPx*VS1(28,34)&
   +r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))
VS0(44,35)=PAx*VS0(28,35)+WPx*VS1(28,35)&
   +r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(45,21)=PAy*VS0(28,21)+WPy*VS1(28,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(45,22)=PAy*VS0(28,22)+WPy*VS1(28,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))&
   +HfxZpE*VS1(28,11)
VS0(45,23)=PAy*VS0(28,23)+WPy*VS1(28,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))&
   +2D0*HfxZpE*VS1(28,12)
VS0(45,24)=PAy*VS0(28,24)+WPy*VS1(28,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))&
   +3D0*HfxZpE*VS1(28,13)
VS0(45,25)=PAy*VS0(28,25)+WPy*VS1(28,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))&
   +4D0*HfxZpE*VS1(28,14)
VS0(45,26)=PAy*VS0(28,26)+WPy*VS1(28,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))
VS0(45,27)=PAy*VS0(28,27)+WPy*VS1(28,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(28,15)
VS0(45,28)=PAy*VS0(28,28)+WPy*VS1(28,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +2D0*HfxZpE*VS1(28,16)
VS0(45,29)=PAy*VS0(28,29)+WPy*VS1(28,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +3D0*HfxZpE*VS1(28,17)
VS0(45,30)=PAy*VS0(28,30)+WPy*VS1(28,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))
VS0(45,31)=PAy*VS0(28,31)+WPy*VS1(28,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +HfxZpE*VS1(28,18)
VS0(45,32)=PAy*VS0(28,32)+WPy*VS1(28,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(28,19)
VS0(45,33)=PAy*VS0(28,33)+WPy*VS1(28,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))
VS0(45,34)=PAy*VS0(28,34)+WPy*VS1(28,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +HfxZpE*VS1(28,20)
VS0(45,35)=PAy*VS0(28,35)+WPy*VS1(28,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))
VS0(46,21)=PAy*VS0(29,21)+WPy*VS1(29,21)&
   +3D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(46,22)=PAy*VS0(29,22)+WPy*VS1(29,22)&
   +3D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))&
   +HfxZpE*VS1(29,11)
VS0(46,23)=PAy*VS0(29,23)+WPy*VS1(29,23)&
   +3D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(29,12)
VS0(46,24)=PAy*VS0(29,24)+WPy*VS1(29,24)&
   +3D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))&
   +3D0*HfxZpE*VS1(29,13)
VS0(46,25)=PAy*VS0(29,25)+WPy*VS1(29,25)&
   +3D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))&
   +4D0*HfxZpE*VS1(29,14)
VS0(46,26)=PAy*VS0(29,26)+WPy*VS1(29,26)&
   +3D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))
VS0(46,27)=PAy*VS0(29,27)+WPy*VS1(29,27)&
   +3D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(29,15)
VS0(46,28)=PAy*VS0(29,28)+WPy*VS1(29,28)&
   +3D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(29,16)
VS0(46,29)=PAy*VS0(29,29)+WPy*VS1(29,29)&
   +3D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +3D0*HfxZpE*VS1(29,17)
VS0(46,30)=PAy*VS0(29,30)+WPy*VS1(29,30)&
   +3D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))
VS0(46,31)=PAy*VS0(29,31)+WPy*VS1(29,31)&
   +3D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +HfxZpE*VS1(29,18)
VS0(46,32)=PAy*VS0(29,32)+WPy*VS1(29,32)&
   +3D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(29,19)
VS0(46,33)=PAy*VS0(29,33)+WPy*VS1(29,33)&
   +3D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))
VS0(46,34)=PAy*VS0(29,34)+WPy*VS1(29,34)&
   +3D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +HfxZpE*VS1(29,20)
VS0(46,35)=PAy*VS0(29,35)+WPy*VS1(29,35)&
   +3D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))
VS0(47,21)=PAx*VS0(30,21)+WPx*VS1(30,21)&
   +2D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))&
   +4D0*HfxZpE*VS1(30,11)
VS0(47,22)=PAx*VS0(30,22)+WPx*VS1(30,22)&
   +2D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +3D0*HfxZpE*VS1(30,12)
VS0(47,23)=PAx*VS0(30,23)+WPx*VS1(30,23)&
   +2D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(30,13)
VS0(47,24)=PAx*VS0(30,24)+WPx*VS1(30,24)&
   +2D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +HfxZpE*VS1(30,14)
VS0(47,25)=PAx*VS0(30,25)+WPx*VS1(30,25)&
   +2D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(47,26)=PAx*VS0(30,26)+WPx*VS1(30,26)&
   +2D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +3D0*HfxZpE*VS1(30,15)
VS0(47,27)=PAx*VS0(30,27)+WPx*VS1(30,27)&
   +2D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(30,16)
VS0(47,28)=PAx*VS0(30,28)+WPx*VS1(30,28)&
   +2D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(30,17)
VS0(47,29)=PAx*VS0(30,29)+WPx*VS1(30,29)&
   +2D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))
VS0(47,30)=PAx*VS0(30,30)+WPx*VS1(30,30)&
   +2D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(30,18)
VS0(47,31)=PAx*VS0(30,31)+WPx*VS1(30,31)&
   +2D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(30,19)
VS0(47,32)=PAx*VS0(30,32)+WPx*VS1(30,32)&
   +2D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))
VS0(47,33)=PAx*VS0(30,33)+WPx*VS1(30,33)&
   +2D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +HfxZpE*VS1(30,20)
VS0(47,34)=PAx*VS0(30,34)+WPx*VS1(30,34)&
   +2D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))
VS0(47,35)=PAx*VS0(30,35)+WPx*VS1(30,35)&
   +2D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(48,21)=PAx*VS0(31,21)+WPx*VS1(31,21)&
   +r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))&
   +4D0*HfxZpE*VS1(31,11)
VS0(48,22)=PAx*VS0(31,22)+WPx*VS1(31,22)&
   +r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +3D0*HfxZpE*VS1(31,12)
VS0(48,23)=PAx*VS0(31,23)+WPx*VS1(31,23)&
   +r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(31,13)
VS0(48,24)=PAx*VS0(31,24)+WPx*VS1(31,24)&
   +r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +HfxZpE*VS1(31,14)
VS0(48,25)=PAx*VS0(31,25)+WPx*VS1(31,25)&
   +r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(48,26)=PAx*VS0(31,26)+WPx*VS1(31,26)&
   +r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +3D0*HfxZpE*VS1(31,15)
VS0(48,27)=PAx*VS0(31,27)+WPx*VS1(31,27)&
   +r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(31,16)
VS0(48,28)=PAx*VS0(31,28)+WPx*VS1(31,28)&
   +r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(31,17)
VS0(48,29)=PAx*VS0(31,29)+WPx*VS1(31,29)&
   +r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))
VS0(48,30)=PAx*VS0(31,30)+WPx*VS1(31,30)&
   +r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(31,18)
VS0(48,31)=PAx*VS0(31,31)+WPx*VS1(31,31)&
   +r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(31,19)
VS0(48,32)=PAx*VS0(31,32)+WPx*VS1(31,32)&
   +r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))
VS0(48,33)=PAx*VS0(31,33)+WPx*VS1(31,33)&
   +r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +HfxZpE*VS1(31,20)
VS0(48,34)=PAx*VS0(31,34)+WPx*VS1(31,34)&
   +r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))
VS0(48,35)=PAx*VS0(31,35)+WPx*VS1(31,35)&
   +r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(49,21)=PAy*VS0(31,21)+WPy*VS1(31,21)&
   +r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(49,22)=PAy*VS0(31,22)+WPy*VS1(31,22)&
   +r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))&
   +HfxZpE*VS1(31,11)
VS0(49,23)=PAy*VS0(31,23)+WPy*VS1(31,23)&
   +r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))&
   +2D0*HfxZpE*VS1(31,12)
VS0(49,24)=PAy*VS0(31,24)+WPy*VS1(31,24)&
   +r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))&
   +3D0*HfxZpE*VS1(31,13)
VS0(49,25)=PAy*VS0(31,25)+WPy*VS1(31,25)&
   +r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))&
   +4D0*HfxZpE*VS1(31,14)
VS0(49,26)=PAy*VS0(31,26)+WPy*VS1(31,26)&
   +r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))
VS0(49,27)=PAy*VS0(31,27)+WPy*VS1(31,27)&
   +r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(31,15)
VS0(49,28)=PAy*VS0(31,28)+WPy*VS1(31,28)&
   +r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(31,16)
VS0(49,29)=PAy*VS0(31,29)+WPy*VS1(31,29)&
   +r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +3D0*HfxZpE*VS1(31,17)
VS0(49,30)=PAy*VS0(31,30)+WPy*VS1(31,30)&
   +r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))
VS0(49,31)=PAy*VS0(31,31)+WPy*VS1(31,31)&
   +r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +HfxZpE*VS1(31,18)
VS0(49,32)=PAy*VS0(31,32)+WPy*VS1(31,32)&
   +r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(31,19)
VS0(49,33)=PAy*VS0(31,33)+WPy*VS1(31,33)&
   +r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))
VS0(49,34)=PAy*VS0(31,34)+WPy*VS1(31,34)&
   +r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +HfxZpE*VS1(31,20)
VS0(49,35)=PAy*VS0(31,35)+WPy*VS1(31,35)&
   +r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))
VS0(50,21)=PAy*VS0(32,21)+WPy*VS1(32,21)&
   +2D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(50,22)=PAy*VS0(32,22)+WPy*VS1(32,22)&
   +2D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))&
   +HfxZpE*VS1(32,11)
VS0(50,23)=PAy*VS0(32,23)+WPy*VS1(32,23)&
   +2D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))&
   +2D0*HfxZpE*VS1(32,12)
VS0(50,24)=PAy*VS0(32,24)+WPy*VS1(32,24)&
   +2D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))&
   +3D0*HfxZpE*VS1(32,13)
VS0(50,25)=PAy*VS0(32,25)+WPy*VS1(32,25)&
   +2D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))&
   +4D0*HfxZpE*VS1(32,14)
VS0(50,26)=PAy*VS0(32,26)+WPy*VS1(32,26)&
   +2D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))
VS0(50,27)=PAy*VS0(32,27)+WPy*VS1(32,27)&
   +2D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(32,15)
VS0(50,28)=PAy*VS0(32,28)+WPy*VS1(32,28)&
   +2D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(32,16)
VS0(50,29)=PAy*VS0(32,29)+WPy*VS1(32,29)&
   +2D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +3D0*HfxZpE*VS1(32,17)
VS0(50,30)=PAy*VS0(32,30)+WPy*VS1(32,30)&
   +2D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))
VS0(50,31)=PAy*VS0(32,31)+WPy*VS1(32,31)&
   +2D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +HfxZpE*VS1(32,18)
VS0(50,32)=PAy*VS0(32,32)+WPy*VS1(32,32)&
   +2D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(32,19)
VS0(50,33)=PAy*VS0(32,33)+WPy*VS1(32,33)&
   +2D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))
VS0(50,34)=PAy*VS0(32,34)+WPy*VS1(32,34)&
   +2D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +HfxZpE*VS1(32,20)
VS0(50,35)=PAy*VS0(32,35)+WPy*VS1(32,35)&
   +2D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))
VS0(51,21)=PAz*VS0(30,21)+WPz*VS1(30,21)+r1x2Z*VR1(30,21)&
   +2D0*r1x2Z*(VS0(15,21)-ExZpE*VS1(15,21))
VS0(51,22)=PAz*VS0(30,22)+WPz*VS1(30,22)+r1x2Z*VR1(30,22)&
   +2D0*r1x2Z*(VS0(15,22)-ExZpE*VS1(15,22))
VS0(51,23)=PAz*VS0(30,23)+WPz*VS1(30,23)+r1x2Z*VR1(30,23)&
   +2D0*r1x2Z*(VS0(15,23)-ExZpE*VS1(15,23))
VS0(51,24)=PAz*VS0(30,24)+WPz*VS1(30,24)+r1x2Z*VR1(30,24)&
   +2D0*r1x2Z*(VS0(15,24)-ExZpE*VS1(15,24))
VS0(51,25)=PAz*VS0(30,25)+WPz*VS1(30,25)+r1x2Z*VR1(30,25)&
   +2D0*r1x2Z*(VS0(15,25)-ExZpE*VS1(15,25))
VS0(51,26)=PAz*VS0(30,26)+WPz*VS1(30,26)+r1x2Z*VR1(30,26)&
   +2D0*r1x2Z*(VS0(15,26)-ExZpE*VS1(15,26))&
   +HfxZpE*VS1(30,11)
VS0(51,27)=PAz*VS0(30,27)+WPz*VS1(30,27)+r1x2Z*VR1(30,27)&
   +2D0*r1x2Z*(VS0(15,27)-ExZpE*VS1(15,27))&
   +HfxZpE*VS1(30,12)
VS0(51,28)=PAz*VS0(30,28)+WPz*VS1(30,28)+r1x2Z*VR1(30,28)&
   +2D0*r1x2Z*(VS0(15,28)-ExZpE*VS1(15,28))&
   +HfxZpE*VS1(30,13)
VS0(51,29)=PAz*VS0(30,29)+WPz*VS1(30,29)+r1x2Z*VR1(30,29)&
   +2D0*r1x2Z*(VS0(15,29)-ExZpE*VS1(15,29))&
   +HfxZpE*VS1(30,14)
VS0(51,30)=PAz*VS0(30,30)+WPz*VS1(30,30)+r1x2Z*VR1(30,30)&
   +2D0*r1x2Z*(VS0(15,30)-ExZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(30,15)
VS0(51,31)=PAz*VS0(30,31)+WPz*VS1(30,31)+r1x2Z*VR1(30,31)&
   +2D0*r1x2Z*(VS0(15,31)-ExZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(30,16)
VS0(51,32)=PAz*VS0(30,32)+WPz*VS1(30,32)+r1x2Z*VR1(30,32)&
   +2D0*r1x2Z*(VS0(15,32)-ExZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(30,17)
VS0(51,33)=PAz*VS0(30,33)+WPz*VS1(30,33)+r1x2Z*VR1(30,33)&
   +2D0*r1x2Z*(VS0(15,33)-ExZpE*VS1(15,33))&
   +3D0*HfxZpE*VS1(30,18)
VS0(51,34)=PAz*VS0(30,34)+WPz*VS1(30,34)+r1x2Z*VR1(30,34)&
   +2D0*r1x2Z*(VS0(15,34)-ExZpE*VS1(15,34))&
   +3D0*HfxZpE*VS1(30,19)
VS0(51,35)=PAz*VS0(30,35)+WPz*VS1(30,35)+r1x2Z*VR1(30,35)&
   +2D0*r1x2Z*(VS0(15,35)-ExZpE*VS1(15,35))&
   +4D0*HfxZpE*VS1(30,20)
VS0(52,21)=PAz*VS0(31,21)+WPz*VS1(31,21)+r1x2Z*VR1(31,21)&
   +2D0*r1x2Z*(VS0(16,21)-ExZpE*VS1(16,21))
VS0(52,22)=PAz*VS0(31,22)+WPz*VS1(31,22)+r1x2Z*VR1(31,22)&
   +2D0*r1x2Z*(VS0(16,22)-ExZpE*VS1(16,22))
VS0(52,23)=PAz*VS0(31,23)+WPz*VS1(31,23)+r1x2Z*VR1(31,23)&
   +2D0*r1x2Z*(VS0(16,23)-ExZpE*VS1(16,23))
VS0(52,24)=PAz*VS0(31,24)+WPz*VS1(31,24)+r1x2Z*VR1(31,24)&
   +2D0*r1x2Z*(VS0(16,24)-ExZpE*VS1(16,24))
VS0(52,25)=PAz*VS0(31,25)+WPz*VS1(31,25)+r1x2Z*VR1(31,25)&
   +2D0*r1x2Z*(VS0(16,25)-ExZpE*VS1(16,25))
VS0(52,26)=PAz*VS0(31,26)+WPz*VS1(31,26)+r1x2Z*VR1(31,26)&
   +2D0*r1x2Z*(VS0(16,26)-ExZpE*VS1(16,26))&
   +HfxZpE*VS1(31,11)
VS0(52,27)=PAz*VS0(31,27)+WPz*VS1(31,27)+r1x2Z*VR1(31,27)&
   +2D0*r1x2Z*(VS0(16,27)-ExZpE*VS1(16,27))&
   +HfxZpE*VS1(31,12)
VS0(52,28)=PAz*VS0(31,28)+WPz*VS1(31,28)+r1x2Z*VR1(31,28)&
   +2D0*r1x2Z*(VS0(16,28)-ExZpE*VS1(16,28))&
   +HfxZpE*VS1(31,13)
VS0(52,29)=PAz*VS0(31,29)+WPz*VS1(31,29)+r1x2Z*VR1(31,29)&
   +2D0*r1x2Z*(VS0(16,29)-ExZpE*VS1(16,29))&
   +HfxZpE*VS1(31,14)
VS0(52,30)=PAz*VS0(31,30)+WPz*VS1(31,30)+r1x2Z*VR1(31,30)&
   +2D0*r1x2Z*(VS0(16,30)-ExZpE*VS1(16,30))&
   +2D0*HfxZpE*VS1(31,15)
VS0(52,31)=PAz*VS0(31,31)+WPz*VS1(31,31)+r1x2Z*VR1(31,31)&
   +2D0*r1x2Z*(VS0(16,31)-ExZpE*VS1(16,31))&
   +2D0*HfxZpE*VS1(31,16)
VS0(52,32)=PAz*VS0(31,32)+WPz*VS1(31,32)+r1x2Z*VR1(31,32)&
   +2D0*r1x2Z*(VS0(16,32)-ExZpE*VS1(16,32))&
   +2D0*HfxZpE*VS1(31,17)
VS0(52,33)=PAz*VS0(31,33)+WPz*VS1(31,33)+r1x2Z*VR1(31,33)&
   +2D0*r1x2Z*(VS0(16,33)-ExZpE*VS1(16,33))&
   +3D0*HfxZpE*VS1(31,18)
VS0(52,34)=PAz*VS0(31,34)+WPz*VS1(31,34)+r1x2Z*VR1(31,34)&
   +2D0*r1x2Z*(VS0(16,34)-ExZpE*VS1(16,34))&
   +3D0*HfxZpE*VS1(31,19)
VS0(52,35)=PAz*VS0(31,35)+WPz*VS1(31,35)+r1x2Z*VR1(31,35)&
   +2D0*r1x2Z*(VS0(16,35)-ExZpE*VS1(16,35))&
   +4D0*HfxZpE*VS1(31,20)
VS0(53,21)=PAz*VS0(32,21)+WPz*VS1(32,21)+r1x2Z*VR1(32,21)&
   +2D0*r1x2Z*(VS0(17,21)-ExZpE*VS1(17,21))
VS0(53,22)=PAz*VS0(32,22)+WPz*VS1(32,22)+r1x2Z*VR1(32,22)&
   +2D0*r1x2Z*(VS0(17,22)-ExZpE*VS1(17,22))
VS0(53,23)=PAz*VS0(32,23)+WPz*VS1(32,23)+r1x2Z*VR1(32,23)&
   +2D0*r1x2Z*(VS0(17,23)-ExZpE*VS1(17,23))
VS0(53,24)=PAz*VS0(32,24)+WPz*VS1(32,24)+r1x2Z*VR1(32,24)&
   +2D0*r1x2Z*(VS0(17,24)-ExZpE*VS1(17,24))
VS0(53,25)=PAz*VS0(32,25)+WPz*VS1(32,25)+r1x2Z*VR1(32,25)&
   +2D0*r1x2Z*(VS0(17,25)-ExZpE*VS1(17,25))
VS0(53,26)=PAz*VS0(32,26)+WPz*VS1(32,26)+r1x2Z*VR1(32,26)&
   +2D0*r1x2Z*(VS0(17,26)-ExZpE*VS1(17,26))&
   +HfxZpE*VS1(32,11)
VS0(53,27)=PAz*VS0(32,27)+WPz*VS1(32,27)+r1x2Z*VR1(32,27)&
   +2D0*r1x2Z*(VS0(17,27)-ExZpE*VS1(17,27))&
   +HfxZpE*VS1(32,12)
VS0(53,28)=PAz*VS0(32,28)+WPz*VS1(32,28)+r1x2Z*VR1(32,28)&
   +2D0*r1x2Z*(VS0(17,28)-ExZpE*VS1(17,28))&
   +HfxZpE*VS1(32,13)
VS0(53,29)=PAz*VS0(32,29)+WPz*VS1(32,29)+r1x2Z*VR1(32,29)&
   +2D0*r1x2Z*(VS0(17,29)-ExZpE*VS1(17,29))&
   +HfxZpE*VS1(32,14)
VS0(53,30)=PAz*VS0(32,30)+WPz*VS1(32,30)+r1x2Z*VR1(32,30)&
   +2D0*r1x2Z*(VS0(17,30)-ExZpE*VS1(17,30))&
   +2D0*HfxZpE*VS1(32,15)
VS0(53,31)=PAz*VS0(32,31)+WPz*VS1(32,31)+r1x2Z*VR1(32,31)&
   +2D0*r1x2Z*(VS0(17,31)-ExZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(32,16)
VS0(53,32)=PAz*VS0(32,32)+WPz*VS1(32,32)+r1x2Z*VR1(32,32)&
   +2D0*r1x2Z*(VS0(17,32)-ExZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(32,17)
VS0(53,33)=PAz*VS0(32,33)+WPz*VS1(32,33)+r1x2Z*VR1(32,33)&
   +2D0*r1x2Z*(VS0(17,33)-ExZpE*VS1(17,33))&
   +3D0*HfxZpE*VS1(32,18)
VS0(53,34)=PAz*VS0(32,34)+WPz*VS1(32,34)+r1x2Z*VR1(32,34)&
   +2D0*r1x2Z*(VS0(17,34)-ExZpE*VS1(17,34))&
   +3D0*HfxZpE*VS1(32,19)
VS0(53,35)=PAz*VS0(32,35)+WPz*VS1(32,35)+r1x2Z*VR1(32,35)&
   +2D0*r1x2Z*(VS0(17,35)-ExZpE*VS1(17,35))&
   +4D0*HfxZpE*VS1(32,20)
VS0(54,21)=PAz*VS0(33,21)+WPz*VS1(33,21)+r1x2Z*VR1(33,21)&
   +3D0*r1x2Z*(VS0(18,21)-ExZpE*VS1(18,21))
VS0(54,22)=PAz*VS0(33,22)+WPz*VS1(33,22)+r1x2Z*VR1(33,22)&
   +3D0*r1x2Z*(VS0(18,22)-ExZpE*VS1(18,22))
VS0(54,23)=PAz*VS0(33,23)+WPz*VS1(33,23)+r1x2Z*VR1(33,23)&
   +3D0*r1x2Z*(VS0(18,23)-ExZpE*VS1(18,23))
VS0(54,24)=PAz*VS0(33,24)+WPz*VS1(33,24)+r1x2Z*VR1(33,24)&
   +3D0*r1x2Z*(VS0(18,24)-ExZpE*VS1(18,24))
VS0(54,25)=PAz*VS0(33,25)+WPz*VS1(33,25)+r1x2Z*VR1(33,25)&
   +3D0*r1x2Z*(VS0(18,25)-ExZpE*VS1(18,25))
VS0(54,26)=PAz*VS0(33,26)+WPz*VS1(33,26)+r1x2Z*VR1(33,26)&
   +3D0*r1x2Z*(VS0(18,26)-ExZpE*VS1(18,26))&
   +HfxZpE*VS1(33,11)
VS0(54,27)=PAz*VS0(33,27)+WPz*VS1(33,27)+r1x2Z*VR1(33,27)&
   +3D0*r1x2Z*(VS0(18,27)-ExZpE*VS1(18,27))&
   +HfxZpE*VS1(33,12)
VS0(54,28)=PAz*VS0(33,28)+WPz*VS1(33,28)+r1x2Z*VR1(33,28)&
   +3D0*r1x2Z*(VS0(18,28)-ExZpE*VS1(18,28))&
   +HfxZpE*VS1(33,13)
VS0(54,29)=PAz*VS0(33,29)+WPz*VS1(33,29)+r1x2Z*VR1(33,29)&
   +3D0*r1x2Z*(VS0(18,29)-ExZpE*VS1(18,29))&
   +HfxZpE*VS1(33,14)
VS0(54,30)=PAz*VS0(33,30)+WPz*VS1(33,30)+r1x2Z*VR1(33,30)&
   +3D0*r1x2Z*(VS0(18,30)-ExZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(33,15)
VS0(54,31)=PAz*VS0(33,31)+WPz*VS1(33,31)+r1x2Z*VR1(33,31)&
   +3D0*r1x2Z*(VS0(18,31)-ExZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(33,16)
VS0(54,32)=PAz*VS0(33,32)+WPz*VS1(33,32)+r1x2Z*VR1(33,32)&
   +3D0*r1x2Z*(VS0(18,32)-ExZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(33,17)
VS0(54,33)=PAz*VS0(33,33)+WPz*VS1(33,33)+r1x2Z*VR1(33,33)&
   +3D0*r1x2Z*(VS0(18,33)-ExZpE*VS1(18,33))&
   +3D0*HfxZpE*VS1(33,18)
VS0(54,34)=PAz*VS0(33,34)+WPz*VS1(33,34)+r1x2Z*VR1(33,34)&
   +3D0*r1x2Z*(VS0(18,34)-ExZpE*VS1(18,34))&
   +3D0*HfxZpE*VS1(33,19)
VS0(54,35)=PAz*VS0(33,35)+WPz*VS1(33,35)+r1x2Z*VR1(33,35)&
   +3D0*r1x2Z*(VS0(18,35)-ExZpE*VS1(18,35))&
   +4D0*HfxZpE*VS1(33,20)
VS0(55,21)=PAz*VS0(34,21)+WPz*VS1(34,21)+r1x2Z*VR1(34,21)&
   +3D0*r1x2Z*(VS0(19,21)-ExZpE*VS1(19,21))
VS0(55,22)=PAz*VS0(34,22)+WPz*VS1(34,22)+r1x2Z*VR1(34,22)&
   +3D0*r1x2Z*(VS0(19,22)-ExZpE*VS1(19,22))
VS0(55,23)=PAz*VS0(34,23)+WPz*VS1(34,23)+r1x2Z*VR1(34,23)&
   +3D0*r1x2Z*(VS0(19,23)-ExZpE*VS1(19,23))
VS0(55,24)=PAz*VS0(34,24)+WPz*VS1(34,24)+r1x2Z*VR1(34,24)&
   +3D0*r1x2Z*(VS0(19,24)-ExZpE*VS1(19,24))
VS0(55,25)=PAz*VS0(34,25)+WPz*VS1(34,25)+r1x2Z*VR1(34,25)&
   +3D0*r1x2Z*(VS0(19,25)-ExZpE*VS1(19,25))
VS0(55,26)=PAz*VS0(34,26)+WPz*VS1(34,26)+r1x2Z*VR1(34,26)&
   +3D0*r1x2Z*(VS0(19,26)-ExZpE*VS1(19,26))&
   +HfxZpE*VS1(34,11)
VS0(55,27)=PAz*VS0(34,27)+WPz*VS1(34,27)+r1x2Z*VR1(34,27)&
   +3D0*r1x2Z*(VS0(19,27)-ExZpE*VS1(19,27))&
   +HfxZpE*VS1(34,12)
VS0(55,28)=PAz*VS0(34,28)+WPz*VS1(34,28)+r1x2Z*VR1(34,28)&
   +3D0*r1x2Z*(VS0(19,28)-ExZpE*VS1(19,28))&
   +HfxZpE*VS1(34,13)
VS0(55,29)=PAz*VS0(34,29)+WPz*VS1(34,29)+r1x2Z*VR1(34,29)&
   +3D0*r1x2Z*(VS0(19,29)-ExZpE*VS1(19,29))&
   +HfxZpE*VS1(34,14)
VS0(55,30)=PAz*VS0(34,30)+WPz*VS1(34,30)+r1x2Z*VR1(34,30)&
   +3D0*r1x2Z*(VS0(19,30)-ExZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(34,15)
VS0(55,31)=PAz*VS0(34,31)+WPz*VS1(34,31)+r1x2Z*VR1(34,31)&
   +3D0*r1x2Z*(VS0(19,31)-ExZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(34,16)
VS0(55,32)=PAz*VS0(34,32)+WPz*VS1(34,32)+r1x2Z*VR1(34,32)&
   +3D0*r1x2Z*(VS0(19,32)-ExZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(34,17)
VS0(55,33)=PAz*VS0(34,33)+WPz*VS1(34,33)+r1x2Z*VR1(34,33)&
   +3D0*r1x2Z*(VS0(19,33)-ExZpE*VS1(19,33))&
   +3D0*HfxZpE*VS1(34,18)
VS0(55,34)=PAz*VS0(34,34)+WPz*VS1(34,34)+r1x2Z*VR1(34,34)&
   +3D0*r1x2Z*(VS0(19,34)-ExZpE*VS1(19,34))&
   +3D0*HfxZpE*VS1(34,19)
VS0(55,35)=PAz*VS0(34,35)+WPz*VS1(34,35)+r1x2Z*VR1(34,35)&
   +3D0*r1x2Z*(VS0(19,35)-ExZpE*VS1(19,35))&
   +4D0*HfxZpE*VS1(34,20)
VS0(56,21)=PAz*VS0(35,21)+WPz*VS1(35,21)+r1x2Z*VR1(35,21)&
   +4D0*r1x2Z*(VS0(20,21)-ExZpE*VS1(20,21))
VS0(56,22)=PAz*VS0(35,22)+WPz*VS1(35,22)+r1x2Z*VR1(35,22)&
   +4D0*r1x2Z*(VS0(20,22)-ExZpE*VS1(20,22))
VS0(56,23)=PAz*VS0(35,23)+WPz*VS1(35,23)+r1x2Z*VR1(35,23)&
   +4D0*r1x2Z*(VS0(20,23)-ExZpE*VS1(20,23))
VS0(56,24)=PAz*VS0(35,24)+WPz*VS1(35,24)+r1x2Z*VR1(35,24)&
   +4D0*r1x2Z*(VS0(20,24)-ExZpE*VS1(20,24))
VS0(56,25)=PAz*VS0(35,25)+WPz*VS1(35,25)+r1x2Z*VR1(35,25)&
   +4D0*r1x2Z*(VS0(20,25)-ExZpE*VS1(20,25))
VS0(56,26)=PAz*VS0(35,26)+WPz*VS1(35,26)+r1x2Z*VR1(35,26)&
   +4D0*r1x2Z*(VS0(20,26)-ExZpE*VS1(20,26))&
   +HfxZpE*VS1(35,11)
VS0(56,27)=PAz*VS0(35,27)+WPz*VS1(35,27)+r1x2Z*VR1(35,27)&
   +4D0*r1x2Z*(VS0(20,27)-ExZpE*VS1(20,27))&
   +HfxZpE*VS1(35,12)
VS0(56,28)=PAz*VS0(35,28)+WPz*VS1(35,28)+r1x2Z*VR1(35,28)&
   +4D0*r1x2Z*(VS0(20,28)-ExZpE*VS1(20,28))&
   +HfxZpE*VS1(35,13)
VS0(56,29)=PAz*VS0(35,29)+WPz*VS1(35,29)+r1x2Z*VR1(35,29)&
   +4D0*r1x2Z*(VS0(20,29)-ExZpE*VS1(20,29))&
   +HfxZpE*VS1(35,14)
VS0(56,30)=PAz*VS0(35,30)+WPz*VS1(35,30)+r1x2Z*VR1(35,30)&
   +4D0*r1x2Z*(VS0(20,30)-ExZpE*VS1(20,30))&
   +2D0*HfxZpE*VS1(35,15)
VS0(56,31)=PAz*VS0(35,31)+WPz*VS1(35,31)+r1x2Z*VR1(35,31)&
   +4D0*r1x2Z*(VS0(20,31)-ExZpE*VS1(20,31))&
   +2D0*HfxZpE*VS1(35,16)
VS0(56,32)=PAz*VS0(35,32)+WPz*VS1(35,32)+r1x2Z*VR1(35,32)&
   +4D0*r1x2Z*(VS0(20,32)-ExZpE*VS1(20,32))&
   +2D0*HfxZpE*VS1(35,17)
VS0(56,33)=PAz*VS0(35,33)+WPz*VS1(35,33)+r1x2Z*VR1(35,33)&
   +4D0*r1x2Z*(VS0(20,33)-ExZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(35,18)
VS0(56,34)=PAz*VS0(35,34)+WPz*VS1(35,34)+r1x2Z*VR1(35,34)&
   +4D0*r1x2Z*(VS0(20,34)-ExZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(35,19)
VS0(56,35)=PAz*VS0(35,35)+WPz*VS1(35,35)+r1x2Z*VR1(35,35)&
   +4D0*r1x2Z*(VS0(20,35)-ExZpE*VS1(20,35))&
   +4D0*HfxZpE*VS1(35,20)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRh0g0'
STOP
END SELECT
END SUBROUTINE MVRRh0g0
