!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0f0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(11,7)
      V(2)=HfxZpE*VRR1(11,10)
      V(3)=r1x2Z*VRR0(6,12)
      V(4)=2.D0*V(3)
      V(5)=ExZpE*r1x2Z*VRR1(6,12)
      V(6)=-2.D0*V(5)
      V(7)=HfxZpE*VRR1(12,6)
      V(8)=2.D0*V(7)
      V(9)=r1x2Z*VRR0(6,13)
      V(10)=2.D0*V(9)
      V(11)=ExZpE*r1x2Z*VRR1(6,13)
      V(12)=-2.D0*V(11)
      V(13)=HfxZpE*VRR1(12,7)
      V(14)=r1x2Z*VRR0(6,15)
      V(15)=2.D0*V(14)
      V(16)=ExZpE*r1x2Z*VRR1(6,15)
      V(17)=-2.D0*V(16)
      V(18)=HfxZpE*VRR1(12,8)
      V(19)=r1x2Z*VRR0(6,16)
      V(20)=2.D0*V(19)
      V(21)=ExZpE*r1x2Z*VRR1(6,16)
      V(22)=-2.D0*V(21)
      V(23)=HfxZpE*VRR1(12,9)
      V(24)=r1x2Z*VRR0(6,17)
      V(25)=2.D0*V(24)
      V(26)=ExZpE*r1x2Z*VRR1(6,17)
      V(27)=-2.D0*V(26)
      V(28)=r1x2Z*VRR0(6,18)
      V(29)=2.D0*V(28)
      V(30)=ExZpE*r1x2Z*VRR1(6,18)
      V(31)=-2.D0*V(30)
      V(32)=HfxZpE*VRR1(12,10)
      V(33)=r1x2Z*VRR0(6,19)
      V(34)=2.D0*V(33)
      V(35)=ExZpE*r1x2Z*VRR1(6,19)
      V(36)=-2.D0*V(35)
      V(37)=r1x2E*VRR0(23,2)
      V(38)=HfxZpE*VRR1(13,5)
      V(39)=r1x2E*ZxZpE*VRR1(23,2)
      V(40)=r1x2E*VRR0(23,3)
      V(41)=HfxZpE*VRR1(13,6)
      V(42)=2.D0*V(41)
      V(43)=r1x2E*ZxZpE*VRR1(23,3)
      V(44)=-V(43)
      V(45)=-V(39)
      V(46)=r1x2E*VRR0(23,4)
      V(47)=HfxZpE*VRR1(13,8)
      V(48)=r1x2E*ZxZpE*VRR1(23,4)
      V(49)=-V(48)
      V(50)=r1x2Z*VRR0(7,16)
      V(51)=ExZpE*r1x2Z*VRR1(7,16)
      V(52)=HfxZpE*VRR1(13,9)
      V(53)=HfxZpE*VRR1(14,5)
      V(54)=HfxZpE*VRR1(13,10)
      V(55)=HfxZpE*VRR1(14,10)
      V(56)=r1x2Z*VRR0(8,12)
      V(57)=2.D0*V(56)
      V(58)=ExZpE*r1x2Z*VRR1(8,12)
      V(59)=-2.D0*V(58)
      V(60)=HfxZpE*VRR1(15,6)
      V(61)=r1x2Z*VRR0(8,13)
      V(62)=2.D0*V(61)
      V(63)=ExZpE*r1x2Z*VRR1(8,13)
      V(64)=-2.D0*V(63)
      V(65)=HfxZpE*VRR1(15,7)
      V(66)=r1x2Z*VRR0(8,15)
      V(67)=2.D0*V(66)
      V(68)=ExZpE*r1x2Z*VRR1(8,15)
      V(69)=-2.D0*V(68)
      V(70)=HfxZpE*VRR1(15,8)
      V(71)=2.D0*V(70)
      V(72)=r1x2Z*VRR0(8,16)
      V(73)=2.D0*V(72)
      V(74)=ExZpE*r1x2Z*VRR1(8,16)
      V(75)=-2.D0*V(74)
      V(76)=HfxZpE*VRR1(15,9)
      V(77)=r1x2Z*VRR0(8,17)
      V(78)=2.D0*V(77)
      V(79)=ExZpE*r1x2Z*VRR1(8,17)
      V(80)=-2.D0*V(79)
      V(81)=r1x2Z*VRR0(8,18)
      V(82)=2.D0*V(81)
      V(83)=ExZpE*r1x2Z*VRR1(8,18)
      V(84)=-2.D0*V(83)
      V(85)=HfxZpE*VRR1(15,10)
      V(86)=r1x2Z*VRR0(8,19)
      V(87)=2.D0*V(86)
      V(88)=ExZpE*r1x2Z*VRR1(8,19)
      V(89)=-2.D0*V(88)
      V(90)=r1x2E*VRR0(27,2)
      V(91)=r1x2E*ZxZpE*VRR1(27,2)
      V(92)=r1x2E*VRR0(27,3)
      V(93)=HfxZpE*VRR1(16,6)
      V(94)=2.D0*V(93)
      V(95)=r1x2E*ZxZpE*VRR1(27,3)
      V(96)=-V(95)
      V(97)=-V(91)
      V(98)=r1x2E*VRR0(27,4)
      V(99)=HfxZpE*VRR1(16,8)
      V(100)=2.D0*V(99)
      V(101)=r1x2E*ZxZpE*VRR1(27,4)
      V(102)=-V(101)
      V(103)=r1x2Z*VRR0(9,16)
      V(104)=ExZpE*r1x2Z*VRR1(9,16)
      V(105)=HfxZpE*VRR1(16,9)
      V(106)=r1x2E*VRR0(28,2)
      V(107)=HfxZpE*VRR1(17,5)
      V(108)=r1x2E*ZxZpE*VRR1(28,2)
      V(109)=r1x2E*VRR0(28,3)
      V(110)=HfxZpE*VRR1(17,6)
      V(111)=r1x2E*ZxZpE*VRR1(28,3)
      V(112)=-V(111)
      V(113)=-V(108)
      V(114)=r1x2E*VRR0(28,4)
      V(115)=HfxZpE*VRR1(17,8)
      V(116)=r1x2E*ZxZpE*VRR1(28,4)
      V(117)=-V(116)
      V(118)=2.D0*V(105)
      V(119)=r1x2Z*VRR0(9,12)
      V(120)=2.D0*V(119)
      V(121)=ExZpE*r1x2Z*VRR1(9,12)
      V(122)=-2.D0*V(121)
      V(123)=r1x2Z*VRR0(9,13)
      V(124)=2.D0*V(123)
      V(125)=ExZpE*r1x2Z*VRR1(9,13)
      V(126)=-2.D0*V(125)
      V(127)=r1x2Z*VRR0(9,15)
      V(128)=2.D0*V(127)
      V(129)=ExZpE*r1x2Z*VRR1(9,15)
      V(130)=-2.D0*V(129)
      V(131)=2.D0*V(103)
      V(132)=-2.D0*V(104)
      V(133)=r1x2Z*VRR0(9,17)
      V(134)=2.D0*V(133)
      V(135)=ExZpE*r1x2Z*VRR1(9,17)
      V(136)=-2.D0*V(135)
      V(137)=HfxZpE*VRR1(17,9)
      V(138)=2.D0*V(137)
      V(139)=r1x2Z*VRR0(9,18)
      V(140)=2.D0*V(139)
      V(141)=ExZpE*r1x2Z*VRR1(9,18)
      V(142)=-2.D0*V(141)
      V(143)=r1x2Z*VRR0(9,19)
      V(144)=2.D0*V(143)
      V(145)=ExZpE*r1x2Z*VRR1(9,19)
      V(146)=-2.D0*V(145)
      V(147)=HfxZpE*VRR1(17,10)
      V(148)=r1x2E*VRR0(30,2)
      V(149)=HfxZpE*VRR1(18,5)
      V(150)=r1x2E*ZxZpE*VRR1(30,2)
      V(151)=r1x2E*VRR0(30,3)
      V(152)=HfxZpE*VRR1(18,6)
      V(153)=r1x2E*ZxZpE*VRR1(30,3)
      V(154)=-V(153)
      V(155)=-V(150)
      V(156)=r1x2E*VRR0(30,4)
      V(157)=HfxZpE*VRR1(18,8)
      V(158)=2.D0*V(157)
      V(159)=r1x2E*ZxZpE*VRR1(30,4)
      V(160)=-V(159)
      V(161)=r1x2Z*VRR0(10,16)
      V(162)=ExZpE*r1x2Z*VRR1(10,16)
      V(163)=-V(162)
      V(164)=HfxZpE*VRR1(18,9)
      V(165)=r1x2E*VRR0(31,2)
      V(166)=HfxZpE*VRR1(19,5)
      V(167)=r1x2E*ZxZpE*VRR1(31,2)
      V(168)=r1x2E*VRR0(31,3)
      V(169)=HfxZpE*VRR1(19,6)
      V(170)=r1x2E*ZxZpE*VRR1(31,3)
      V(171)=-V(170)
      V(172)=-V(167)
      V(173)=HfxZpE*VRR1(18,7)
      V(174)=r1x2E*VRR0(31,4)
      V(175)=HfxZpE*VRR1(19,8)
      V(176)=r1x2E*ZxZpE*VRR1(31,4)
      V(177)=-V(176)
      V(178)=r1x2E*VRR0(32,2)
      V(179)=r1x2E*ZxZpE*VRR1(32,2)
      V(180)=r1x2E*VRR0(32,3)
      V(181)=r1x2E*ZxZpE*VRR1(32,3)
      V(182)=-V(181)
      V(183)=-V(179)
      V(184)=HfxZpE*VRR1(19,7)
      V(185)=r1x2E*VRR0(32,4)
      V(186)=r1x2E*ZxZpE*VRR1(32,4)
      V(187)=-V(186)
      V(188)=HfxZpE*VRR1(19,9)
      V(189)=2.D0*V(188)
      V(190)=HfxZpE*VRR1(20,5)
      V(191)=HfxZpE*VRR1(20,7)
      VRR0(21,11)=3.D0*r1x2Z*VRR0(5,11)+PAx*VRR0(11,11)-3.D0*ExZpE*r1x2Z*VRR1(5,11)+3.D0*HfxZpE*VRR1(11,5)+WPx*VRR1(11,11)
      VRR0(21,12)=3.D0*r1x2Z*VRR0(5,12)+PAx*VRR0(11,12)-3.D0*ExZpE*r1x2Z*VRR1(5,12)+2.D0*HfxZpE*VRR1(11,6)+WPx*VRR1(11,12)
      VRR0(21,13)=V(1)+3.D0*r1x2Z*VRR0(5,13)+PAx*VRR0(11,13)-3.D0*ExZpE*r1x2Z*VRR1(5,13)+WPx*VRR1(11,13)
      VRR0(21,14)=3.D0*r1x2Z*VRR0(5,14)+PAx*VRR0(11,14)-3.D0*ExZpE*r1x2Z*VRR1(5,14)+WPx*VRR1(11,14)
      VRR0(21,15)=3.D0*r1x2Z*VRR0(5,15)+PAx*VRR0(11,15)-3.D0*ExZpE*r1x2Z*VRR1(5,15)+2.D0*HfxZpE*VRR1(11,8)+WPx*VRR1(11,15)
      VRR0(21,16)=3.D0*r1x2Z*VRR0(5,16)+PAx*VRR0(11,16)-3.D0*ExZpE*r1x2Z*VRR1(5,16)+HfxZpE*VRR1(11,9)+WPx*VRR1(11,16)
      VRR0(21,17)=3.D0*r1x2Z*VRR0(5,17)+PAx*VRR0(11,17)-3.D0*ExZpE*r1x2Z*VRR1(5,17)+WPx*VRR1(11,17)
      VRR0(21,18)=V(2)+3.D0*r1x2Z*VRR0(5,18)+PAx*VRR0(11,18)-3.D0*ExZpE*r1x2Z*VRR1(5,18)+WPx*VRR1(11,18)
      VRR0(21,19)=3.D0*r1x2Z*VRR0(5,19)+PAx*VRR0(11,19)-3.D0*ExZpE*r1x2Z*VRR1(5,19)+WPx*VRR1(11,19)
      VRR0(21,20)=3.D0*r1x2Z*VRR0(5,20)+PAx*VRR0(11,20)-3.D0*ExZpE*r1x2Z*VRR1(5,20)+WPx*VRR1(11,20)
      VRR0(22,11)=2.D0*r1x2E*VRR0(22,2)+QCx*VRR0(22,5)+3.D0*HfxZpE*VRR1(12,5)-2.D0*r1x2E*ZxZpE*VRR1(22,2)+WQx*VRR1(22,5)
      VRR0(22,12)=V(4)+V(6)+V(8)+PAx*VRR0(12,12)+WPx*VRR1(12,12)
      VRR0(22,13)=V(10)+V(12)+V(13)+PAx*VRR0(12,13)+WPx*VRR1(12,13)
      VRR0(22,14)=V(1)+2.D0*r1x2E*VRR0(22,3)+QCy*VRR0(22,7)-2.D0*r1x2E*ZxZpE*VRR1(22,3)+WQy*VRR1(22,7)
      VRR0(22,15)=V(15)+V(17)+2.D0*V(18)+PAx*VRR0(12,15)+WPx*VRR1(12,15)
      VRR0(22,16)=V(20)+V(22)+V(23)+PAx*VRR0(12,16)+WPx*VRR1(12,16)
      VRR0(22,17)=V(25)+V(27)+PAx*VRR0(12,17)+WPx*VRR1(12,17)
      VRR0(22,18)=V(29)+V(31)+V(32)+PAx*VRR0(12,18)+WPx*VRR1(12,18)
      VRR0(22,19)=V(34)+V(36)+PAx*VRR0(12,19)+WPx*VRR1(12,19)
      VRR0(22,20)=2.D0*r1x2E*VRR0(22,4)+QCz*VRR0(22,10)-2.D0*r1x2E*ZxZpE*VRR1(22,4)+WQz*VRR1(22,10)
      VRR0(23,11)=2.D0*V(37)+2.D0*V(38)-2.D0*V(39)+QCx*VRR0(23,5)+WQx*VRR1(23,5)
      VRR0(23,12)=V(40)+V(42)+V(44)+QCx*VRR0(23,6)+WQx*VRR1(23,6)
      VRR0(23,13)=V(8)+V(37)+V(45)+QCy*VRR0(23,6)+WQy*VRR1(23,6)
      VRR0(23,14)=2.D0*V(13)+2.D0*V(40)-2.D0*V(43)+QCy*VRR0(23,7)+WQy*VRR1(23,7)
      VRR0(23,15)=V(46)+2.D0*V(47)+V(49)+QCx*VRR0(23,8)+WQx*VRR1(23,8)
      VRR0(23,16)=V(50)-V(51)+V(52)+PAx*VRR0(13,16)+WPx*VRR1(13,16)
      VRR0(23,17)=2.D0*V(23)+V(46)+V(49)+QCy*VRR0(23,9)+WQy*VRR1(23,9)
      VRR0(23,18)=V(37)+V(45)+QCz*VRR0(23,8)+WQz*VRR1(23,8)
      VRR0(23,19)=V(40)+V(44)+QCz*VRR0(23,9)+WQz*VRR1(23,9)
      VRR0(23,20)=2.D0*V(46)-2.D0*V(48)+QCz*VRR0(23,10)+WQz*VRR1(23,10)
      VRR0(24,11)=V(53)+2.D0*r1x2E*VRR0(24,2)+QCx*VRR0(24,5)-2.D0*r1x2E*ZxZpE*VRR1(24,2)+WQx*VRR1(24,5)
      VRR0(24,12)=V(4)+V(6)+V(38)+PAy*VRR0(13,12)+WPy*VRR1(13,12)
      VRR0(24,13)=V(10)+V(12)+V(42)+PAy*VRR0(13,13)+WPy*VRR1(13,13)
      VRR0(24,14)=2.D0*r1x2E*VRR0(24,3)+QCy*VRR0(24,7)+3.D0*HfxZpE*VRR1(13,7)-2.D0*r1x2E*ZxZpE*VRR1(24,3)+WQy*VRR1(24,7)
      VRR0(24,15)=V(15)+V(17)+PAy*VRR0(13,15)+WPy*VRR1(13,15)
      VRR0(24,16)=V(20)+V(22)+V(47)+PAy*VRR0(13,16)+WPy*VRR1(13,16)
      VRR0(24,17)=V(25)+V(27)+2.D0*V(52)+PAy*VRR0(13,17)+WPy*VRR1(13,17)
      VRR0(24,18)=V(29)+V(31)+PAy*VRR0(13,18)+WPy*VRR1(13,18)
      VRR0(24,19)=V(34)+V(36)+V(54)+PAy*VRR0(13,19)+WPy*VRR1(13,19)
      VRR0(24,20)=2.D0*r1x2E*VRR0(24,4)+QCz*VRR0(24,10)-2.D0*r1x2E*ZxZpE*VRR1(24,4)+WQz*VRR1(24,10)
      VRR0(25,11)=3.D0*r1x2Z*VRR0(7,11)+PAy*VRR0(14,11)-3.D0*ExZpE*r1x2Z*VRR1(7,11)+WPy*VRR1(14,11)
      VRR0(25,12)=V(53)+3.D0*r1x2Z*VRR0(7,12)+PAy*VRR0(14,12)-3.D0*ExZpE*r1x2Z*VRR1(7,12)+WPy*VRR1(14,12)
      VRR0(25,13)=3.D0*r1x2Z*VRR0(7,13)+PAy*VRR0(14,13)-3.D0*ExZpE*r1x2Z*VRR1(7,13)+2.D0*HfxZpE*VRR1(14,6)+WPy*VRR1(14,13)
      VRR0(25,14)=3.D0*r1x2Z*VRR0(7,14)+PAy*VRR0(14,14)-3.D0*ExZpE*r1x2Z*VRR1(7,14)+3.D0*HfxZpE*VRR1(14,7)+WPy*VRR1(14,14)
      VRR0(25,15)=3.D0*r1x2Z*VRR0(7,15)+PAy*VRR0(14,15)-3.D0*ExZpE*r1x2Z*VRR1(7,15)+WPy*VRR1(14,15)
      VRR0(25,16)=3.D0*V(50)-3.D0*V(51)+PAy*VRR0(14,16)+HfxZpE*VRR1(14,8)+WPy*VRR1(14,16)
      VRR0(25,17)=3.D0*r1x2Z*VRR0(7,17)+PAy*VRR0(14,17)-3.D0*ExZpE*r1x2Z*VRR1(7,17)+2.D0*HfxZpE*VRR1(14,9)+WPy*VRR1(14,17)
      VRR0(25,18)=3.D0*r1x2Z*VRR0(7,18)+PAy*VRR0(14,18)-3.D0*ExZpE*r1x2Z*VRR1(7,18)+WPy*VRR1(14,18)
      VRR0(25,19)=V(55)+3.D0*r1x2Z*VRR0(7,19)+PAy*VRR0(14,19)-3.D0*ExZpE*r1x2Z*VRR1(7,19)+WPy*VRR1(14,19)
      VRR0(25,20)=3.D0*r1x2Z*VRR0(7,20)+PAy*VRR0(14,20)-3.D0*ExZpE*r1x2Z*VRR1(7,20)+WPy*VRR1(14,20)
      VRR0(26,11)=2.D0*r1x2E*VRR0(26,2)+QCx*VRR0(26,5)+3.D0*HfxZpE*VRR1(15,5)-2.D0*r1x2E*ZxZpE*VRR1(26,2)+WQx*VRR1(26,5)
      VRR0(26,12)=V(57)+V(59)+2.D0*V(60)+PAx*VRR0(15,12)+WPx*VRR1(15,12)
      VRR0(26,13)=V(62)+V(64)+V(65)+PAx*VRR0(15,13)+WPx*VRR1(15,13)
      VRR0(26,14)=2.D0*r1x2E*VRR0(26,3)+QCy*VRR0(26,7)-2.D0*r1x2E*ZxZpE*VRR1(26,3)+WQy*VRR1(26,7)
      VRR0(26,15)=V(67)+V(69)+V(71)+PAx*VRR0(15,15)+WPx*VRR1(15,15)
      VRR0(26,16)=V(73)+V(75)+V(76)+PAx*VRR0(15,16)+WPx*VRR1(15,16)
      VRR0(26,17)=V(78)+V(80)+PAx*VRR0(15,17)+WPx*VRR1(15,17)
      VRR0(26,18)=V(82)+V(84)+V(85)+PAx*VRR0(15,18)+WPx*VRR1(15,18)
      VRR0(26,19)=V(87)+V(89)+PAx*VRR0(15,19)+WPx*VRR1(15,19)
      VRR0(26,20)=V(2)+2.D0*r1x2E*VRR0(26,4)+QCz*VRR0(26,10)-2.D0*r1x2E*ZxZpE*VRR1(26,4)+WQz*VRR1(26,10)
      VRR0(27,11)=2.D0*V(90)-2.D0*V(91)+QCx*VRR0(27,5)+2.D0*HfxZpE*VRR1(16,5)+WQx*VRR1(27,5)
      VRR0(27,12)=V(92)+V(94)+V(96)+QCx*VRR0(27,6)+WQx*VRR1(27,6)
      VRR0(27,13)=V(60)+V(90)+V(97)+QCy*VRR0(27,6)+WQy*VRR1(27,6)
      VRR0(27,14)=V(65)+2.D0*V(92)-2.D0*V(95)+QCy*VRR0(27,7)+WQy*VRR1(27,7)
      VRR0(27,15)=V(98)+V(100)+V(102)+QCx*VRR0(27,8)+WQx*VRR1(27,8)
      VRR0(27,16)=V(103)-V(104)+V(105)+PAx*VRR0(16,16)+WPx*VRR1(16,16)
      VRR0(27,17)=V(76)+V(98)+V(102)+QCy*VRR0(27,9)+WQy*VRR1(27,9)
      VRR0(27,18)=V(18)+V(90)+V(97)+QCz*VRR0(27,8)+WQz*VRR1(27,8)
      VRR0(27,19)=V(23)+V(92)+V(96)+QCz*VRR0(27,9)+WQz*VRR1(27,9)
      VRR0(27,20)=V(32)+2.D0*V(98)-2.D0*V(101)+QCz*VRR0(27,10)+WQz*VRR1(27,10)
      VRR0(28,11)=2.D0*V(106)+V(107)-2.D0*V(108)+QCx*VRR0(28,5)+WQx*VRR1(28,5)
      VRR0(28,12)=V(109)+V(110)+V(112)+QCx*VRR0(28,6)+WQx*VRR1(28,6)
      VRR0(28,13)=V(94)+V(106)+V(113)+QCy*VRR0(28,6)+WQy*VRR1(28,6)
      VRR0(28,14)=2.D0*V(109)-2.D0*V(111)+QCy*VRR0(28,7)+2.D0*HfxZpE*VRR1(16,7)+WQy*VRR1(28,7)
      VRR0(28,15)=V(114)+V(115)+V(117)+QCx*VRR0(28,8)+WQx*VRR1(28,8)
      VRR0(28,16)=V(72)-V(74)+V(99)+PAy*VRR0(16,16)+WPy*VRR1(16,16)
      VRR0(28,17)=V(114)+V(117)+V(118)+QCy*VRR0(28,9)+WQy*VRR1(28,9)
      VRR0(28,18)=V(47)+V(106)+V(113)+QCz*VRR0(28,8)+WQz*VRR1(28,8)
      VRR0(28,19)=V(52)+V(109)+V(112)+QCz*VRR0(28,9)+WQz*VRR1(28,9)
      VRR0(28,20)=V(54)+2.D0*V(114)-2.D0*V(116)+QCz*VRR0(28,10)+WQz*VRR1(28,10)
      VRR0(29,11)=2.D0*r1x2E*VRR0(29,2)+QCx*VRR0(29,5)-2.D0*r1x2E*ZxZpE*VRR1(29,2)+WQx*VRR1(29,5)
      VRR0(29,12)=V(107)+V(120)+V(122)+PAy*VRR0(17,12)+WPy*VRR1(17,12)
      VRR0(29,13)=2.D0*V(110)+V(124)+V(126)+PAy*VRR0(17,13)+WPy*VRR1(17,13)
      VRR0(29,14)=2.D0*r1x2E*VRR0(29,3)+QCy*VRR0(29,7)+3.D0*HfxZpE*VRR1(17,7)-2.D0*r1x2E*ZxZpE*VRR1(29,3)+WQy*VRR1(29,7)
      VRR0(29,15)=V(128)+V(130)+PAy*VRR0(17,15)+WPy*VRR1(17,15)
      VRR0(29,16)=V(115)+V(131)+V(132)+PAy*VRR0(17,16)+WPy*VRR1(17,16)
      VRR0(29,17)=V(134)+V(136)+V(138)+PAy*VRR0(17,17)+WPy*VRR1(17,17)
      VRR0(29,18)=V(140)+V(142)+PAy*VRR0(17,18)+WPy*VRR1(17,18)
      VRR0(29,19)=V(144)+V(146)+V(147)+PAy*VRR0(17,19)+WPy*VRR1(17,19)
      VRR0(29,20)=V(55)+2.D0*r1x2E*VRR0(29,4)+QCz*VRR0(29,10)-2.D0*r1x2E*ZxZpE*VRR1(29,4)+WQz*VRR1(29,10)
      VRR0(30,11)=2.D0*V(148)+2.D0*V(149)-2.D0*V(150)+QCx*VRR0(30,5)+WQx*VRR1(30,5)
      VRR0(30,12)=V(151)+2.D0*V(152)+V(154)+QCx*VRR0(30,6)+WQx*VRR1(30,6)
      VRR0(30,13)=V(148)+V(155)+QCy*VRR0(30,6)+WQy*VRR1(30,6)
      VRR0(30,14)=2.D0*V(151)-2.D0*V(153)+QCy*VRR0(30,7)+WQy*VRR1(30,7)
      VRR0(30,15)=V(156)+V(158)+V(160)+QCx*VRR0(30,8)+WQx*VRR1(30,8)
      VRR0(30,16)=V(161)+V(163)+V(164)+PAx*VRR0(18,16)+WPx*VRR1(18,16)
      VRR0(30,17)=V(156)+V(160)+QCy*VRR0(30,9)+WQy*VRR1(30,9)
      VRR0(30,18)=V(71)+V(148)+V(155)+QCz*VRR0(30,8)+WQz*VRR1(30,8)
      VRR0(30,19)=2.D0*V(76)+V(151)+V(154)+QCz*VRR0(30,9)+WQz*VRR1(30,9)
      VRR0(30,20)=2.D0*V(85)+2.D0*V(156)-2.D0*V(159)+QCz*VRR0(30,10)+WQz*VRR1(30,10)
      VRR0(31,11)=2.D0*V(165)+V(166)-2.D0*V(167)+QCx*VRR0(31,5)+WQx*VRR1(31,5)
      VRR0(31,12)=V(168)+V(169)+V(171)+QCx*VRR0(31,6)+WQx*VRR1(31,6)
      VRR0(31,13)=V(152)+V(165)+V(172)+QCy*VRR0(31,6)+WQy*VRR1(31,6)
      VRR0(31,14)=2.D0*V(168)-2.D0*V(170)+V(173)+QCy*VRR0(31,7)+WQy*VRR1(31,7)
      VRR0(31,15)=V(174)+V(175)+V(177)+QCx*VRR0(31,8)+WQx*VRR1(31,8)
      VRR0(31,16)=V(19)-V(21)+V(93)+PAz*VRR0(16,16)+WPz*VRR1(16,16)
      VRR0(31,17)=V(164)+V(174)+V(177)+QCy*VRR0(31,9)+WQy*VRR1(31,9)
      VRR0(31,18)=V(100)+V(165)+V(172)+QCz*VRR0(31,8)+WQz*VRR1(31,8)
      VRR0(31,19)=V(118)+V(168)+V(171)+QCz*VRR0(31,9)+WQz*VRR1(31,9)
      VRR0(31,20)=2.D0*V(174)-2.D0*V(176)+QCz*VRR0(31,10)+2.D0*HfxZpE*VRR1(16,10)+WQz*VRR1(31,10)
      VRR0(32,11)=2.D0*V(178)-2.D0*V(179)+QCx*VRR0(32,5)+WQx*VRR1(32,5)
      VRR0(32,12)=V(180)+V(182)+QCx*VRR0(32,6)+WQx*VRR1(32,6)
      VRR0(32,13)=2.D0*V(169)+V(178)+V(183)+QCy*VRR0(32,6)+WQy*VRR1(32,6)
      VRR0(32,14)=2.D0*V(180)-2.D0*V(181)+2.D0*V(184)+QCy*VRR0(32,7)+WQy*VRR1(32,7)
      VRR0(32,15)=V(185)+V(187)+QCx*VRR0(32,8)+WQx*VRR1(32,8)
      VRR0(32,16)=V(161)+V(163)+V(175)+PAy*VRR0(19,16)+WPy*VRR1(19,16)
      VRR0(32,17)=V(185)+V(187)+V(189)+QCy*VRR0(32,9)+WQy*VRR1(32,9)
      VRR0(32,18)=2.D0*V(115)+V(178)+V(183)+QCz*VRR0(32,8)+WQz*VRR1(32,8)
      VRR0(32,19)=V(138)+V(180)+V(182)+QCz*VRR0(32,9)+WQz*VRR1(32,9)
      VRR0(32,20)=2.D0*V(147)+2.D0*V(185)-2.D0*V(186)+QCz*VRR0(32,10)+WQz*VRR1(32,10)
      VRR0(33,11)=V(190)+2.D0*r1x2E*VRR0(33,2)+QCx*VRR0(33,5)-2.D0*r1x2E*ZxZpE*VRR1(33,2)+WQx*VRR1(33,5)
      VRR0(33,12)=V(57)+V(59)+PAz*VRR0(18,12)+WPz*VRR1(18,12)
      VRR0(33,13)=V(62)+V(64)+PAz*VRR0(18,13)+WPz*VRR1(18,13)
      VRR0(33,14)=2.D0*r1x2E*VRR0(33,3)+QCy*VRR0(33,7)-2.D0*r1x2E*ZxZpE*VRR1(33,3)+WQy*VRR1(33,7)
      VRR0(33,15)=V(67)+V(69)+V(149)+PAz*VRR0(18,15)+WPz*VRR1(18,15)
      VRR0(33,16)=V(73)+V(75)+V(152)+PAz*VRR0(18,16)+WPz*VRR1(18,16)
      VRR0(33,17)=V(78)+V(80)+V(173)+PAz*VRR0(18,17)+WPz*VRR1(18,17)
      VRR0(33,18)=V(82)+V(84)+V(158)+PAz*VRR0(18,18)+WPz*VRR1(18,18)
      VRR0(33,19)=V(87)+V(89)+2.D0*V(164)+PAz*VRR0(18,19)+WPz*VRR1(18,19)
      VRR0(33,20)=2.D0*r1x2E*VRR0(33,4)+QCz*VRR0(33,10)+3.D0*HfxZpE*VRR1(18,10)-2.D0*r1x2E*ZxZpE*VRR1(33,4)+WQz*VRR1(33,10)
      VRR0(34,11)=2.D0*r1x2E*VRR0(34,2)+QCx*VRR0(34,5)-2.D0*r1x2E*ZxZpE*VRR1(34,2)+WQx*VRR1(34,5)
      VRR0(34,12)=V(120)+V(122)+PAz*VRR0(19,12)+WPz*VRR1(19,12)
      VRR0(34,13)=V(124)+V(126)+PAz*VRR0(19,13)+WPz*VRR1(19,13)
      VRR0(34,14)=V(191)+2.D0*r1x2E*VRR0(34,3)+QCy*VRR0(34,7)-2.D0*r1x2E*ZxZpE*VRR1(34,3)+WQy*VRR1(34,7)
      VRR0(34,15)=V(128)+V(130)+V(166)+PAz*VRR0(19,15)+WPz*VRR1(19,15)
      VRR0(34,16)=V(131)+V(132)+V(169)+PAz*VRR0(19,16)+WPz*VRR1(19,16)
      VRR0(34,17)=V(134)+V(136)+V(184)+PAz*VRR0(19,17)+WPz*VRR1(19,17)
      VRR0(34,18)=V(140)+V(142)+2.D0*V(175)+PAz*VRR0(19,18)+WPz*VRR1(19,18)
      VRR0(34,19)=V(144)+V(146)+V(189)+PAz*VRR0(19,19)+WPz*VRR1(19,19)
      VRR0(34,20)=2.D0*r1x2E*VRR0(34,4)+QCz*VRR0(34,10)+3.D0*HfxZpE*VRR1(19,10)-2.D0*r1x2E*ZxZpE*VRR1(34,4)+WQz*VRR1(34,10)
      VRR0(35,11)=3.D0*r1x2Z*VRR0(10,11)+PAz*VRR0(20,11)-3.D0*ExZpE*r1x2Z*VRR1(10,11)+WPz*VRR1(20,11)
      VRR0(35,12)=3.D0*r1x2Z*VRR0(10,12)+PAz*VRR0(20,12)-3.D0*ExZpE*r1x2Z*VRR1(10,12)+WPz*VRR1(20,12)
      VRR0(35,13)=3.D0*r1x2Z*VRR0(10,13)+PAz*VRR0(20,13)-3.D0*ExZpE*r1x2Z*VRR1(10,13)+WPz*VRR1(20,13)
      VRR0(35,14)=3.D0*r1x2Z*VRR0(10,14)+PAz*VRR0(20,14)-3.D0*ExZpE*r1x2Z*VRR1(10,14)+WPz*VRR1(20,14)
      VRR0(35,15)=V(190)+3.D0*r1x2Z*VRR0(10,15)+PAz*VRR0(20,15)-3.D0*ExZpE*r1x2Z*VRR1(10,15)+WPz*VRR1(20,15)
      VRR0(35,16)=3.D0*V(161)-3.D0*V(162)+PAz*VRR0(20,16)+HfxZpE*VRR1(20,6)+WPz*VRR1(20,16)
      VRR0(35,17)=V(191)+3.D0*r1x2Z*VRR0(10,17)+PAz*VRR0(20,17)-3.D0*ExZpE*r1x2Z*VRR1(10,17)+WPz*VRR1(20,17)
      VRR0(35,18)=3.D0*r1x2Z*VRR0(10,18)+PAz*VRR0(20,18)-3.D0*ExZpE*r1x2Z*VRR1(10,18)+2.D0*HfxZpE*VRR1(20,8)+WPz*VRR1(20,18)
      VRR0(35,19)=3.D0*r1x2Z*VRR0(10,19)+PAz*VRR0(20,19)-3.D0*ExZpE*r1x2Z*VRR1(10,19)+2.D0*HfxZpE*VRR1(20,9)+WPz*VRR1(20,19)
      VRR0(35,20)=3.D0*r1x2Z*VRR0(10,20)+PAz*VRR0(20,20)-3.D0*ExZpE*r1x2Z*VRR1(10,20)+3.D0*HfxZpE*VRR1(20,10)+WPz*VRR1(20,20)
END SUBROUTINE VRRg0f0
SUBROUTINE MVRRg0f0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,11)=PAx*VS0(11,11)+WPx*VS1(11,11)+r1x2Z*VR1(11,11)&
   +3D0*r1x2Z*(VS0(5,11)-ExZpE*VS1(5,11))&
   +3D0*HfxZpE*VS1(11,5)
VS0(21,12)=PAx*VS0(11,12)+WPx*VS1(11,12)+r1x2Z*VR1(11,12)&
   +3D0*r1x2Z*(VS0(5,12)-ExZpE*VS1(5,12))&
   +2D0*HfxZpE*VS1(11,6)
VS0(21,13)=PAx*VS0(11,13)+WPx*VS1(11,13)+r1x2Z*VR1(11,13)&
   +3D0*r1x2Z*(VS0(5,13)-ExZpE*VS1(5,13))&
   +HfxZpE*VS1(11,7)
VS0(21,14)=PAx*VS0(11,14)+WPx*VS1(11,14)+r1x2Z*VR1(11,14)&
   +3D0*r1x2Z*(VS0(5,14)-ExZpE*VS1(5,14))
VS0(21,15)=PAx*VS0(11,15)+WPx*VS1(11,15)+r1x2Z*VR1(11,15)&
   +3D0*r1x2Z*(VS0(5,15)-ExZpE*VS1(5,15))&
   +2D0*HfxZpE*VS1(11,8)
VS0(21,16)=PAx*VS0(11,16)+WPx*VS1(11,16)+r1x2Z*VR1(11,16)&
   +3D0*r1x2Z*(VS0(5,16)-ExZpE*VS1(5,16))&
   +HfxZpE*VS1(11,9)
VS0(21,17)=PAx*VS0(11,17)+WPx*VS1(11,17)+r1x2Z*VR1(11,17)&
   +3D0*r1x2Z*(VS0(5,17)-ExZpE*VS1(5,17))
VS0(21,18)=PAx*VS0(11,18)+WPx*VS1(11,18)+r1x2Z*VR1(11,18)&
   +3D0*r1x2Z*(VS0(5,18)-ExZpE*VS1(5,18))&
   +HfxZpE*VS1(11,10)
VS0(21,19)=PAx*VS0(11,19)+WPx*VS1(11,19)+r1x2Z*VR1(11,19)&
   +3D0*r1x2Z*(VS0(5,19)-ExZpE*VS1(5,19))
VS0(21,20)=PAx*VS0(11,20)+WPx*VS1(11,20)+r1x2Z*VR1(11,20)&
   +3D0*r1x2Z*(VS0(5,20)-ExZpE*VS1(5,20))
VS0(22,11)=PAx*VS0(12,11)+WPx*VS1(12,11)+r1x2Z*VR1(12,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))&
   +3D0*HfxZpE*VS1(12,5)
VS0(22,12)=PAx*VS0(12,12)+WPx*VS1(12,12)+r1x2Z*VR1(12,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +2D0*HfxZpE*VS1(12,6)
VS0(22,13)=PAx*VS0(12,13)+WPx*VS1(12,13)+r1x2Z*VR1(12,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +HfxZpE*VS1(12,7)
VS0(22,14)=PAx*VS0(12,14)+WPx*VS1(12,14)+r1x2Z*VR1(12,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(22,15)=PAx*VS0(12,15)+WPx*VS1(12,15)+r1x2Z*VR1(12,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +2D0*HfxZpE*VS1(12,8)
VS0(22,16)=PAx*VS0(12,16)+WPx*VS1(12,16)+r1x2Z*VR1(12,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(12,9)
VS0(22,17)=PAx*VS0(12,17)+WPx*VS1(12,17)+r1x2Z*VR1(12,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))
VS0(22,18)=PAx*VS0(12,18)+WPx*VS1(12,18)+r1x2Z*VR1(12,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +HfxZpE*VS1(12,10)
VS0(22,19)=PAx*VS0(12,19)+WPx*VS1(12,19)+r1x2Z*VR1(12,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))
VS0(22,20)=PAx*VS0(12,20)+WPx*VS1(12,20)+r1x2Z*VR1(12,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(23,11)=PAx*VS0(13,11)+WPx*VS1(13,11)+r1x2Z*VR1(13,11)&
   +r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))&
   +3D0*HfxZpE*VS1(13,5)
VS0(23,12)=PAx*VS0(13,12)+WPx*VS1(13,12)+r1x2Z*VR1(13,12)&
   +r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +2D0*HfxZpE*VS1(13,6)
VS0(23,13)=PAx*VS0(13,13)+WPx*VS1(13,13)+r1x2Z*VR1(13,13)&
   +r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +HfxZpE*VS1(13,7)
VS0(23,14)=PAx*VS0(13,14)+WPx*VS1(13,14)+r1x2Z*VR1(13,14)&
   +r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))
VS0(23,15)=PAx*VS0(13,15)+WPx*VS1(13,15)+r1x2Z*VR1(13,15)&
   +r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))&
   +2D0*HfxZpE*VS1(13,8)
VS0(23,16)=PAx*VS0(13,16)+WPx*VS1(13,16)+r1x2Z*VR1(13,16)&
   +r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(13,9)
VS0(23,17)=PAx*VS0(13,17)+WPx*VS1(13,17)+r1x2Z*VR1(13,17)&
   +r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))
VS0(23,18)=PAx*VS0(13,18)+WPx*VS1(13,18)+r1x2Z*VR1(13,18)&
   +r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))&
   +HfxZpE*VS1(13,10)
VS0(23,19)=PAx*VS0(13,19)+WPx*VS1(13,19)+r1x2Z*VR1(13,19)&
   +r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))
VS0(23,20)=PAx*VS0(13,20)+WPx*VS1(13,20)+r1x2Z*VR1(13,20)&
   +r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(24,11)=PAy*VS0(13,11)+WPy*VS1(13,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(24,12)=PAy*VS0(13,12)+WPy*VS1(13,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +HfxZpE*VS1(13,5)
VS0(24,13)=PAy*VS0(13,13)+WPy*VS1(13,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +2D0*HfxZpE*VS1(13,6)
VS0(24,14)=PAy*VS0(13,14)+WPy*VS1(13,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))&
   +3D0*HfxZpE*VS1(13,7)
VS0(24,15)=PAy*VS0(13,15)+WPy*VS1(13,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))
VS0(24,16)=PAy*VS0(13,16)+WPy*VS1(13,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(13,8)
VS0(24,17)=PAy*VS0(13,17)+WPy*VS1(13,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +2D0*HfxZpE*VS1(13,9)
VS0(24,18)=PAy*VS0(13,18)+WPy*VS1(13,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))
VS0(24,19)=PAy*VS0(13,19)+WPy*VS1(13,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +HfxZpE*VS1(13,10)
VS0(24,20)=PAy*VS0(13,20)+WPy*VS1(13,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(25,11)=PAy*VS0(14,11)+WPy*VS1(14,11)&
   +3D0*r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))
VS0(25,12)=PAy*VS0(14,12)+WPy*VS1(14,12)&
   +3D0*r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +HfxZpE*VS1(14,5)
VS0(25,13)=PAy*VS0(14,13)+WPy*VS1(14,13)&
   +3D0*r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +2D0*HfxZpE*VS1(14,6)
VS0(25,14)=PAy*VS0(14,14)+WPy*VS1(14,14)&
   +3D0*r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))&
   +3D0*HfxZpE*VS1(14,7)
VS0(25,15)=PAy*VS0(14,15)+WPy*VS1(14,15)&
   +3D0*r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))
VS0(25,16)=PAy*VS0(14,16)+WPy*VS1(14,16)&
   +3D0*r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(14,8)
VS0(25,17)=PAy*VS0(14,17)+WPy*VS1(14,17)&
   +3D0*r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))&
   +2D0*HfxZpE*VS1(14,9)
VS0(25,18)=PAy*VS0(14,18)+WPy*VS1(14,18)&
   +3D0*r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))
VS0(25,19)=PAy*VS0(14,19)+WPy*VS1(14,19)&
   +3D0*r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))&
   +HfxZpE*VS1(14,10)
VS0(25,20)=PAy*VS0(14,20)+WPy*VS1(14,20)&
   +3D0*r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(26,11)=PAx*VS0(15,11)+WPx*VS1(15,11)+r1x2Z*VR1(15,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))&
   +3D0*HfxZpE*VS1(15,5)
VS0(26,12)=PAx*VS0(15,12)+WPx*VS1(15,12)+r1x2Z*VR1(15,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +2D0*HfxZpE*VS1(15,6)
VS0(26,13)=PAx*VS0(15,13)+WPx*VS1(15,13)+r1x2Z*VR1(15,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +HfxZpE*VS1(15,7)
VS0(26,14)=PAx*VS0(15,14)+WPx*VS1(15,14)+r1x2Z*VR1(15,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(26,15)=PAx*VS0(15,15)+WPx*VS1(15,15)+r1x2Z*VR1(15,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +2D0*HfxZpE*VS1(15,8)
VS0(26,16)=PAx*VS0(15,16)+WPx*VS1(15,16)+r1x2Z*VR1(15,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(15,9)
VS0(26,17)=PAx*VS0(15,17)+WPx*VS1(15,17)+r1x2Z*VR1(15,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))
VS0(26,18)=PAx*VS0(15,18)+WPx*VS1(15,18)+r1x2Z*VR1(15,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +HfxZpE*VS1(15,10)
VS0(26,19)=PAx*VS0(15,19)+WPx*VS1(15,19)+r1x2Z*VR1(15,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))
VS0(26,20)=PAx*VS0(15,20)+WPx*VS1(15,20)+r1x2Z*VR1(15,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(27,11)=PAx*VS0(16,11)+WPx*VS1(16,11)+r1x2Z*VR1(16,11)&
   +r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))&
   +3D0*HfxZpE*VS1(16,5)
VS0(27,12)=PAx*VS0(16,12)+WPx*VS1(16,12)+r1x2Z*VR1(16,12)&
   +r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +2D0*HfxZpE*VS1(16,6)
VS0(27,13)=PAx*VS0(16,13)+WPx*VS1(16,13)+r1x2Z*VR1(16,13)&
   +r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +HfxZpE*VS1(16,7)
VS0(27,14)=PAx*VS0(16,14)+WPx*VS1(16,14)+r1x2Z*VR1(16,14)&
   +r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(27,15)=PAx*VS0(16,15)+WPx*VS1(16,15)+r1x2Z*VR1(16,15)&
   +r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +2D0*HfxZpE*VS1(16,8)
VS0(27,16)=PAx*VS0(16,16)+WPx*VS1(16,16)+r1x2Z*VR1(16,16)&
   +r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(16,9)
VS0(27,17)=PAx*VS0(16,17)+WPx*VS1(16,17)+r1x2Z*VR1(16,17)&
   +r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))
VS0(27,18)=PAx*VS0(16,18)+WPx*VS1(16,18)+r1x2Z*VR1(16,18)&
   +r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +HfxZpE*VS1(16,10)
VS0(27,19)=PAx*VS0(16,19)+WPx*VS1(16,19)+r1x2Z*VR1(16,19)&
   +r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))
VS0(27,20)=PAx*VS0(16,20)+WPx*VS1(16,20)+r1x2Z*VR1(16,20)&
   +r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(28,11)=PAy*VS0(16,11)+WPy*VS1(16,11)&
   +r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(28,12)=PAy*VS0(16,12)+WPy*VS1(16,12)&
   +r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +HfxZpE*VS1(16,5)
VS0(28,13)=PAy*VS0(16,13)+WPy*VS1(16,13)&
   +r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +2D0*HfxZpE*VS1(16,6)
VS0(28,14)=PAy*VS0(16,14)+WPy*VS1(16,14)&
   +r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))&
   +3D0*HfxZpE*VS1(16,7)
VS0(28,15)=PAy*VS0(16,15)+WPy*VS1(16,15)&
   +r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))
VS0(28,16)=PAy*VS0(16,16)+WPy*VS1(16,16)&
   +r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(16,8)
VS0(28,17)=PAy*VS0(16,17)+WPy*VS1(16,17)&
   +r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +2D0*HfxZpE*VS1(16,9)
VS0(28,18)=PAy*VS0(16,18)+WPy*VS1(16,18)&
   +r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))
VS0(28,19)=PAy*VS0(16,19)+WPy*VS1(16,19)&
   +r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +HfxZpE*VS1(16,10)
VS0(28,20)=PAy*VS0(16,20)+WPy*VS1(16,20)&
   +r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(29,11)=PAy*VS0(17,11)+WPy*VS1(17,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(29,12)=PAy*VS0(17,12)+WPy*VS1(17,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +HfxZpE*VS1(17,5)
VS0(29,13)=PAy*VS0(17,13)+WPy*VS1(17,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +2D0*HfxZpE*VS1(17,6)
VS0(29,14)=PAy*VS0(17,14)+WPy*VS1(17,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))&
   +3D0*HfxZpE*VS1(17,7)
VS0(29,15)=PAy*VS0(17,15)+WPy*VS1(17,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))
VS0(29,16)=PAy*VS0(17,16)+WPy*VS1(17,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(17,8)
VS0(29,17)=PAy*VS0(17,17)+WPy*VS1(17,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +2D0*HfxZpE*VS1(17,9)
VS0(29,18)=PAy*VS0(17,18)+WPy*VS1(17,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))
VS0(29,19)=PAy*VS0(17,19)+WPy*VS1(17,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +HfxZpE*VS1(17,10)
VS0(29,20)=PAy*VS0(17,20)+WPy*VS1(17,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(30,11)=PAx*VS0(18,11)+WPx*VS1(18,11)+r1x2Z*VR1(18,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))&
   +3D0*HfxZpE*VS1(18,5)
VS0(30,12)=PAx*VS0(18,12)+WPx*VS1(18,12)+r1x2Z*VR1(18,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +2D0*HfxZpE*VS1(18,6)
VS0(30,13)=PAx*VS0(18,13)+WPx*VS1(18,13)+r1x2Z*VR1(18,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +HfxZpE*VS1(18,7)
VS0(30,14)=PAx*VS0(18,14)+WPx*VS1(18,14)+r1x2Z*VR1(18,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(30,15)=PAx*VS0(18,15)+WPx*VS1(18,15)+r1x2Z*VR1(18,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +2D0*HfxZpE*VS1(18,8)
VS0(30,16)=PAx*VS0(18,16)+WPx*VS1(18,16)+r1x2Z*VR1(18,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(18,9)
VS0(30,17)=PAx*VS0(18,17)+WPx*VS1(18,17)+r1x2Z*VR1(18,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))
VS0(30,18)=PAx*VS0(18,18)+WPx*VS1(18,18)+r1x2Z*VR1(18,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +HfxZpE*VS1(18,10)
VS0(30,19)=PAx*VS0(18,19)+WPx*VS1(18,19)+r1x2Z*VR1(18,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))
VS0(30,20)=PAx*VS0(18,20)+WPx*VS1(18,20)+r1x2Z*VR1(18,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(31,11)=PAz*VS0(16,11)+WPz*VS1(16,11)&
   +r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(31,12)=PAz*VS0(16,12)+WPz*VS1(16,12)&
   +r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))
VS0(31,13)=PAz*VS0(16,13)+WPz*VS1(16,13)&
   +r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))
VS0(31,14)=PAz*VS0(16,14)+WPz*VS1(16,14)&
   +r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(31,15)=PAz*VS0(16,15)+WPz*VS1(16,15)&
   +r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +HfxZpE*VS1(16,5)
VS0(31,16)=PAz*VS0(16,16)+WPz*VS1(16,16)&
   +r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(16,6)
VS0(31,17)=PAz*VS0(16,17)+WPz*VS1(16,17)&
   +r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +HfxZpE*VS1(16,7)
VS0(31,18)=PAz*VS0(16,18)+WPz*VS1(16,18)&
   +r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +2D0*HfxZpE*VS1(16,8)
VS0(31,19)=PAz*VS0(16,19)+WPz*VS1(16,19)&
   +r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +2D0*HfxZpE*VS1(16,9)
VS0(31,20)=PAz*VS0(16,20)+WPz*VS1(16,20)&
   +r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))&
   +3D0*HfxZpE*VS1(16,10)
VS0(32,11)=PAy*VS0(19,11)+WPy*VS1(19,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(32,12)=PAy*VS0(19,12)+WPy*VS1(19,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +HfxZpE*VS1(19,5)
VS0(32,13)=PAy*VS0(19,13)+WPy*VS1(19,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +2D0*HfxZpE*VS1(19,6)
VS0(32,14)=PAy*VS0(19,14)+WPy*VS1(19,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))&
   +3D0*HfxZpE*VS1(19,7)
VS0(32,15)=PAy*VS0(19,15)+WPy*VS1(19,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))
VS0(32,16)=PAy*VS0(19,16)+WPy*VS1(19,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(19,8)
VS0(32,17)=PAy*VS0(19,17)+WPy*VS1(19,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +2D0*HfxZpE*VS1(19,9)
VS0(32,18)=PAy*VS0(19,18)+WPy*VS1(19,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))
VS0(32,19)=PAy*VS0(19,19)+WPy*VS1(19,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +HfxZpE*VS1(19,10)
VS0(32,20)=PAy*VS0(19,20)+WPy*VS1(19,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(33,11)=PAz*VS0(18,11)+WPz*VS1(18,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(33,12)=PAz*VS0(18,12)+WPz*VS1(18,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))
VS0(33,13)=PAz*VS0(18,13)+WPz*VS1(18,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))
VS0(33,14)=PAz*VS0(18,14)+WPz*VS1(18,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(33,15)=PAz*VS0(18,15)+WPz*VS1(18,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +HfxZpE*VS1(18,5)
VS0(33,16)=PAz*VS0(18,16)+WPz*VS1(18,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(18,6)
VS0(33,17)=PAz*VS0(18,17)+WPz*VS1(18,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +HfxZpE*VS1(18,7)
VS0(33,18)=PAz*VS0(18,18)+WPz*VS1(18,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +2D0*HfxZpE*VS1(18,8)
VS0(33,19)=PAz*VS0(18,19)+WPz*VS1(18,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +2D0*HfxZpE*VS1(18,9)
VS0(33,20)=PAz*VS0(18,20)+WPz*VS1(18,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))&
   +3D0*HfxZpE*VS1(18,10)
VS0(34,11)=PAz*VS0(19,11)+WPz*VS1(19,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(34,12)=PAz*VS0(19,12)+WPz*VS1(19,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))
VS0(34,13)=PAz*VS0(19,13)+WPz*VS1(19,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))
VS0(34,14)=PAz*VS0(19,14)+WPz*VS1(19,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(34,15)=PAz*VS0(19,15)+WPz*VS1(19,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +HfxZpE*VS1(19,5)
VS0(34,16)=PAz*VS0(19,16)+WPz*VS1(19,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(19,6)
VS0(34,17)=PAz*VS0(19,17)+WPz*VS1(19,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +HfxZpE*VS1(19,7)
VS0(34,18)=PAz*VS0(19,18)+WPz*VS1(19,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +2D0*HfxZpE*VS1(19,8)
VS0(34,19)=PAz*VS0(19,19)+WPz*VS1(19,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +2D0*HfxZpE*VS1(19,9)
VS0(34,20)=PAz*VS0(19,20)+WPz*VS1(19,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))&
   +3D0*HfxZpE*VS1(19,10)
VS0(35,11)=PAz*VS0(20,11)+WPz*VS1(20,11)&
   +3D0*r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(35,12)=PAz*VS0(20,12)+WPz*VS1(20,12)&
   +3D0*r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))
VS0(35,13)=PAz*VS0(20,13)+WPz*VS1(20,13)&
   +3D0*r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))
VS0(35,14)=PAz*VS0(20,14)+WPz*VS1(20,14)&
   +3D0*r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(35,15)=PAz*VS0(20,15)+WPz*VS1(20,15)&
   +3D0*r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +HfxZpE*VS1(20,5)
VS0(35,16)=PAz*VS0(20,16)+WPz*VS1(20,16)&
   +3D0*r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(20,6)
VS0(35,17)=PAz*VS0(20,17)+WPz*VS1(20,17)&
   +3D0*r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +HfxZpE*VS1(20,7)
VS0(35,18)=PAz*VS0(20,18)+WPz*VS1(20,18)&
   +3D0*r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +2D0*HfxZpE*VS1(20,8)
VS0(35,19)=PAz*VS0(20,19)+WPz*VS1(20,19)&
   +3D0*r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +2D0*HfxZpE*VS1(20,9)
VS0(35,20)=PAz*VS0(20,20)+WPz*VS1(20,20)&
   +3D0*r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))&
   +3D0*HfxZpE*VS1(20,10)
CASE(2)
VS0(21,11)=PAx*VS0(11,11)+WPx*VS1(11,11)&
   +3D0*r1x2Z*(VS0(5,11)-ExZpE*VS1(5,11))&
   +3D0*HfxZpE*VS1(11,5)
VS0(21,12)=PAx*VS0(11,12)+WPx*VS1(11,12)&
   +3D0*r1x2Z*(VS0(5,12)-ExZpE*VS1(5,12))&
   +2D0*HfxZpE*VS1(11,6)
VS0(21,13)=PAx*VS0(11,13)+WPx*VS1(11,13)&
   +3D0*r1x2Z*(VS0(5,13)-ExZpE*VS1(5,13))&
   +HfxZpE*VS1(11,7)
VS0(21,14)=PAx*VS0(11,14)+WPx*VS1(11,14)&
   +3D0*r1x2Z*(VS0(5,14)-ExZpE*VS1(5,14))
VS0(21,15)=PAx*VS0(11,15)+WPx*VS1(11,15)&
   +3D0*r1x2Z*(VS0(5,15)-ExZpE*VS1(5,15))&
   +2D0*HfxZpE*VS1(11,8)
VS0(21,16)=PAx*VS0(11,16)+WPx*VS1(11,16)&
   +3D0*r1x2Z*(VS0(5,16)-ExZpE*VS1(5,16))&
   +HfxZpE*VS1(11,9)
VS0(21,17)=PAx*VS0(11,17)+WPx*VS1(11,17)&
   +3D0*r1x2Z*(VS0(5,17)-ExZpE*VS1(5,17))
VS0(21,18)=PAx*VS0(11,18)+WPx*VS1(11,18)&
   +3D0*r1x2Z*(VS0(5,18)-ExZpE*VS1(5,18))&
   +HfxZpE*VS1(11,10)
VS0(21,19)=PAx*VS0(11,19)+WPx*VS1(11,19)&
   +3D0*r1x2Z*(VS0(5,19)-ExZpE*VS1(5,19))
VS0(21,20)=PAx*VS0(11,20)+WPx*VS1(11,20)&
   +3D0*r1x2Z*(VS0(5,20)-ExZpE*VS1(5,20))
VS0(22,11)=PAx*VS0(12,11)+WPx*VS1(12,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))&
   +3D0*HfxZpE*VS1(12,5)
VS0(22,12)=PAx*VS0(12,12)+WPx*VS1(12,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +2D0*HfxZpE*VS1(12,6)
VS0(22,13)=PAx*VS0(12,13)+WPx*VS1(12,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +HfxZpE*VS1(12,7)
VS0(22,14)=PAx*VS0(12,14)+WPx*VS1(12,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(22,15)=PAx*VS0(12,15)+WPx*VS1(12,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +2D0*HfxZpE*VS1(12,8)
VS0(22,16)=PAx*VS0(12,16)+WPx*VS1(12,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(12,9)
VS0(22,17)=PAx*VS0(12,17)+WPx*VS1(12,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))
VS0(22,18)=PAx*VS0(12,18)+WPx*VS1(12,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +HfxZpE*VS1(12,10)
VS0(22,19)=PAx*VS0(12,19)+WPx*VS1(12,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))
VS0(22,20)=PAx*VS0(12,20)+WPx*VS1(12,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(23,11)=PAx*VS0(13,11)+WPx*VS1(13,11)&
   +r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))&
   +3D0*HfxZpE*VS1(13,5)
VS0(23,12)=PAx*VS0(13,12)+WPx*VS1(13,12)&
   +r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +2D0*HfxZpE*VS1(13,6)
VS0(23,13)=PAx*VS0(13,13)+WPx*VS1(13,13)&
   +r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +HfxZpE*VS1(13,7)
VS0(23,14)=PAx*VS0(13,14)+WPx*VS1(13,14)&
   +r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))
VS0(23,15)=PAx*VS0(13,15)+WPx*VS1(13,15)&
   +r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))&
   +2D0*HfxZpE*VS1(13,8)
VS0(23,16)=PAx*VS0(13,16)+WPx*VS1(13,16)&
   +r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(13,9)
VS0(23,17)=PAx*VS0(13,17)+WPx*VS1(13,17)&
   +r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))
VS0(23,18)=PAx*VS0(13,18)+WPx*VS1(13,18)&
   +r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))&
   +HfxZpE*VS1(13,10)
VS0(23,19)=PAx*VS0(13,19)+WPx*VS1(13,19)&
   +r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))
VS0(23,20)=PAx*VS0(13,20)+WPx*VS1(13,20)&
   +r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(24,11)=PAy*VS0(13,11)+WPy*VS1(13,11)+r1x2Z*VR1(13,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(24,12)=PAy*VS0(13,12)+WPy*VS1(13,12)+r1x2Z*VR1(13,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +HfxZpE*VS1(13,5)
VS0(24,13)=PAy*VS0(13,13)+WPy*VS1(13,13)+r1x2Z*VR1(13,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +2D0*HfxZpE*VS1(13,6)
VS0(24,14)=PAy*VS0(13,14)+WPy*VS1(13,14)+r1x2Z*VR1(13,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))&
   +3D0*HfxZpE*VS1(13,7)
VS0(24,15)=PAy*VS0(13,15)+WPy*VS1(13,15)+r1x2Z*VR1(13,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))
VS0(24,16)=PAy*VS0(13,16)+WPy*VS1(13,16)+r1x2Z*VR1(13,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(13,8)
VS0(24,17)=PAy*VS0(13,17)+WPy*VS1(13,17)+r1x2Z*VR1(13,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +2D0*HfxZpE*VS1(13,9)
VS0(24,18)=PAy*VS0(13,18)+WPy*VS1(13,18)+r1x2Z*VR1(13,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))
VS0(24,19)=PAy*VS0(13,19)+WPy*VS1(13,19)+r1x2Z*VR1(13,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +HfxZpE*VS1(13,10)
VS0(24,20)=PAy*VS0(13,20)+WPy*VS1(13,20)+r1x2Z*VR1(13,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(25,11)=PAy*VS0(14,11)+WPy*VS1(14,11)+r1x2Z*VR1(14,11)&
   +3D0*r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))
VS0(25,12)=PAy*VS0(14,12)+WPy*VS1(14,12)+r1x2Z*VR1(14,12)&
   +3D0*r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +HfxZpE*VS1(14,5)
VS0(25,13)=PAy*VS0(14,13)+WPy*VS1(14,13)+r1x2Z*VR1(14,13)&
   +3D0*r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +2D0*HfxZpE*VS1(14,6)
VS0(25,14)=PAy*VS0(14,14)+WPy*VS1(14,14)+r1x2Z*VR1(14,14)&
   +3D0*r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))&
   +3D0*HfxZpE*VS1(14,7)
VS0(25,15)=PAy*VS0(14,15)+WPy*VS1(14,15)+r1x2Z*VR1(14,15)&
   +3D0*r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))
VS0(25,16)=PAy*VS0(14,16)+WPy*VS1(14,16)+r1x2Z*VR1(14,16)&
   +3D0*r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(14,8)
VS0(25,17)=PAy*VS0(14,17)+WPy*VS1(14,17)+r1x2Z*VR1(14,17)&
   +3D0*r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))&
   +2D0*HfxZpE*VS1(14,9)
VS0(25,18)=PAy*VS0(14,18)+WPy*VS1(14,18)+r1x2Z*VR1(14,18)&
   +3D0*r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))
VS0(25,19)=PAy*VS0(14,19)+WPy*VS1(14,19)+r1x2Z*VR1(14,19)&
   +3D0*r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))&
   +HfxZpE*VS1(14,10)
VS0(25,20)=PAy*VS0(14,20)+WPy*VS1(14,20)+r1x2Z*VR1(14,20)&
   +3D0*r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(26,11)=PAx*VS0(15,11)+WPx*VS1(15,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))&
   +3D0*HfxZpE*VS1(15,5)
VS0(26,12)=PAx*VS0(15,12)+WPx*VS1(15,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +2D0*HfxZpE*VS1(15,6)
VS0(26,13)=PAx*VS0(15,13)+WPx*VS1(15,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +HfxZpE*VS1(15,7)
VS0(26,14)=PAx*VS0(15,14)+WPx*VS1(15,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(26,15)=PAx*VS0(15,15)+WPx*VS1(15,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +2D0*HfxZpE*VS1(15,8)
VS0(26,16)=PAx*VS0(15,16)+WPx*VS1(15,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(15,9)
VS0(26,17)=PAx*VS0(15,17)+WPx*VS1(15,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))
VS0(26,18)=PAx*VS0(15,18)+WPx*VS1(15,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +HfxZpE*VS1(15,10)
VS0(26,19)=PAx*VS0(15,19)+WPx*VS1(15,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))
VS0(26,20)=PAx*VS0(15,20)+WPx*VS1(15,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(27,11)=PAx*VS0(16,11)+WPx*VS1(16,11)&
   +r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))&
   +3D0*HfxZpE*VS1(16,5)
VS0(27,12)=PAx*VS0(16,12)+WPx*VS1(16,12)&
   +r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +2D0*HfxZpE*VS1(16,6)
VS0(27,13)=PAx*VS0(16,13)+WPx*VS1(16,13)&
   +r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +HfxZpE*VS1(16,7)
VS0(27,14)=PAx*VS0(16,14)+WPx*VS1(16,14)&
   +r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(27,15)=PAx*VS0(16,15)+WPx*VS1(16,15)&
   +r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +2D0*HfxZpE*VS1(16,8)
VS0(27,16)=PAx*VS0(16,16)+WPx*VS1(16,16)&
   +r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(16,9)
VS0(27,17)=PAx*VS0(16,17)+WPx*VS1(16,17)&
   +r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))
VS0(27,18)=PAx*VS0(16,18)+WPx*VS1(16,18)&
   +r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +HfxZpE*VS1(16,10)
VS0(27,19)=PAx*VS0(16,19)+WPx*VS1(16,19)&
   +r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))
VS0(27,20)=PAx*VS0(16,20)+WPx*VS1(16,20)&
   +r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(28,11)=PAy*VS0(16,11)+WPy*VS1(16,11)+r1x2Z*VR1(16,11)&
   +r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(28,12)=PAy*VS0(16,12)+WPy*VS1(16,12)+r1x2Z*VR1(16,12)&
   +r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +HfxZpE*VS1(16,5)
VS0(28,13)=PAy*VS0(16,13)+WPy*VS1(16,13)+r1x2Z*VR1(16,13)&
   +r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +2D0*HfxZpE*VS1(16,6)
VS0(28,14)=PAy*VS0(16,14)+WPy*VS1(16,14)+r1x2Z*VR1(16,14)&
   +r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))&
   +3D0*HfxZpE*VS1(16,7)
VS0(28,15)=PAy*VS0(16,15)+WPy*VS1(16,15)+r1x2Z*VR1(16,15)&
   +r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))
VS0(28,16)=PAy*VS0(16,16)+WPy*VS1(16,16)+r1x2Z*VR1(16,16)&
   +r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(16,8)
VS0(28,17)=PAy*VS0(16,17)+WPy*VS1(16,17)+r1x2Z*VR1(16,17)&
   +r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +2D0*HfxZpE*VS1(16,9)
VS0(28,18)=PAy*VS0(16,18)+WPy*VS1(16,18)+r1x2Z*VR1(16,18)&
   +r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))
VS0(28,19)=PAy*VS0(16,19)+WPy*VS1(16,19)+r1x2Z*VR1(16,19)&
   +r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +HfxZpE*VS1(16,10)
VS0(28,20)=PAy*VS0(16,20)+WPy*VS1(16,20)+r1x2Z*VR1(16,20)&
   +r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(29,11)=PAy*VS0(17,11)+WPy*VS1(17,11)+r1x2Z*VR1(17,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(29,12)=PAy*VS0(17,12)+WPy*VS1(17,12)+r1x2Z*VR1(17,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +HfxZpE*VS1(17,5)
VS0(29,13)=PAy*VS0(17,13)+WPy*VS1(17,13)+r1x2Z*VR1(17,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +2D0*HfxZpE*VS1(17,6)
VS0(29,14)=PAy*VS0(17,14)+WPy*VS1(17,14)+r1x2Z*VR1(17,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))&
   +3D0*HfxZpE*VS1(17,7)
VS0(29,15)=PAy*VS0(17,15)+WPy*VS1(17,15)+r1x2Z*VR1(17,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))
VS0(29,16)=PAy*VS0(17,16)+WPy*VS1(17,16)+r1x2Z*VR1(17,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(17,8)
VS0(29,17)=PAy*VS0(17,17)+WPy*VS1(17,17)+r1x2Z*VR1(17,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +2D0*HfxZpE*VS1(17,9)
VS0(29,18)=PAy*VS0(17,18)+WPy*VS1(17,18)+r1x2Z*VR1(17,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))
VS0(29,19)=PAy*VS0(17,19)+WPy*VS1(17,19)+r1x2Z*VR1(17,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +HfxZpE*VS1(17,10)
VS0(29,20)=PAy*VS0(17,20)+WPy*VS1(17,20)+r1x2Z*VR1(17,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(30,11)=PAx*VS0(18,11)+WPx*VS1(18,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))&
   +3D0*HfxZpE*VS1(18,5)
VS0(30,12)=PAx*VS0(18,12)+WPx*VS1(18,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +2D0*HfxZpE*VS1(18,6)
VS0(30,13)=PAx*VS0(18,13)+WPx*VS1(18,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +HfxZpE*VS1(18,7)
VS0(30,14)=PAx*VS0(18,14)+WPx*VS1(18,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(30,15)=PAx*VS0(18,15)+WPx*VS1(18,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +2D0*HfxZpE*VS1(18,8)
VS0(30,16)=PAx*VS0(18,16)+WPx*VS1(18,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(18,9)
VS0(30,17)=PAx*VS0(18,17)+WPx*VS1(18,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))
VS0(30,18)=PAx*VS0(18,18)+WPx*VS1(18,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +HfxZpE*VS1(18,10)
VS0(30,19)=PAx*VS0(18,19)+WPx*VS1(18,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))
VS0(30,20)=PAx*VS0(18,20)+WPx*VS1(18,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(31,11)=PAz*VS0(16,11)+WPz*VS1(16,11)&
   +r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(31,12)=PAz*VS0(16,12)+WPz*VS1(16,12)&
   +r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))
VS0(31,13)=PAz*VS0(16,13)+WPz*VS1(16,13)&
   +r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))
VS0(31,14)=PAz*VS0(16,14)+WPz*VS1(16,14)&
   +r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(31,15)=PAz*VS0(16,15)+WPz*VS1(16,15)&
   +r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +HfxZpE*VS1(16,5)
VS0(31,16)=PAz*VS0(16,16)+WPz*VS1(16,16)&
   +r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(16,6)
VS0(31,17)=PAz*VS0(16,17)+WPz*VS1(16,17)&
   +r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +HfxZpE*VS1(16,7)
VS0(31,18)=PAz*VS0(16,18)+WPz*VS1(16,18)&
   +r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +2D0*HfxZpE*VS1(16,8)
VS0(31,19)=PAz*VS0(16,19)+WPz*VS1(16,19)&
   +r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +2D0*HfxZpE*VS1(16,9)
VS0(31,20)=PAz*VS0(16,20)+WPz*VS1(16,20)&
   +r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))&
   +3D0*HfxZpE*VS1(16,10)
VS0(32,11)=PAy*VS0(19,11)+WPy*VS1(19,11)+r1x2Z*VR1(19,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(32,12)=PAy*VS0(19,12)+WPy*VS1(19,12)+r1x2Z*VR1(19,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +HfxZpE*VS1(19,5)
VS0(32,13)=PAy*VS0(19,13)+WPy*VS1(19,13)+r1x2Z*VR1(19,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +2D0*HfxZpE*VS1(19,6)
VS0(32,14)=PAy*VS0(19,14)+WPy*VS1(19,14)+r1x2Z*VR1(19,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))&
   +3D0*HfxZpE*VS1(19,7)
VS0(32,15)=PAy*VS0(19,15)+WPy*VS1(19,15)+r1x2Z*VR1(19,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))
VS0(32,16)=PAy*VS0(19,16)+WPy*VS1(19,16)+r1x2Z*VR1(19,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(19,8)
VS0(32,17)=PAy*VS0(19,17)+WPy*VS1(19,17)+r1x2Z*VR1(19,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +2D0*HfxZpE*VS1(19,9)
VS0(32,18)=PAy*VS0(19,18)+WPy*VS1(19,18)+r1x2Z*VR1(19,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))
VS0(32,19)=PAy*VS0(19,19)+WPy*VS1(19,19)+r1x2Z*VR1(19,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +HfxZpE*VS1(19,10)
VS0(32,20)=PAy*VS0(19,20)+WPy*VS1(19,20)+r1x2Z*VR1(19,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(33,11)=PAz*VS0(18,11)+WPz*VS1(18,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(33,12)=PAz*VS0(18,12)+WPz*VS1(18,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))
VS0(33,13)=PAz*VS0(18,13)+WPz*VS1(18,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))
VS0(33,14)=PAz*VS0(18,14)+WPz*VS1(18,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(33,15)=PAz*VS0(18,15)+WPz*VS1(18,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +HfxZpE*VS1(18,5)
VS0(33,16)=PAz*VS0(18,16)+WPz*VS1(18,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(18,6)
VS0(33,17)=PAz*VS0(18,17)+WPz*VS1(18,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +HfxZpE*VS1(18,7)
VS0(33,18)=PAz*VS0(18,18)+WPz*VS1(18,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +2D0*HfxZpE*VS1(18,8)
VS0(33,19)=PAz*VS0(18,19)+WPz*VS1(18,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +2D0*HfxZpE*VS1(18,9)
VS0(33,20)=PAz*VS0(18,20)+WPz*VS1(18,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))&
   +3D0*HfxZpE*VS1(18,10)
VS0(34,11)=PAz*VS0(19,11)+WPz*VS1(19,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(34,12)=PAz*VS0(19,12)+WPz*VS1(19,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))
VS0(34,13)=PAz*VS0(19,13)+WPz*VS1(19,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))
VS0(34,14)=PAz*VS0(19,14)+WPz*VS1(19,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(34,15)=PAz*VS0(19,15)+WPz*VS1(19,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +HfxZpE*VS1(19,5)
VS0(34,16)=PAz*VS0(19,16)+WPz*VS1(19,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(19,6)
VS0(34,17)=PAz*VS0(19,17)+WPz*VS1(19,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +HfxZpE*VS1(19,7)
VS0(34,18)=PAz*VS0(19,18)+WPz*VS1(19,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +2D0*HfxZpE*VS1(19,8)
VS0(34,19)=PAz*VS0(19,19)+WPz*VS1(19,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +2D0*HfxZpE*VS1(19,9)
VS0(34,20)=PAz*VS0(19,20)+WPz*VS1(19,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))&
   +3D0*HfxZpE*VS1(19,10)
VS0(35,11)=PAz*VS0(20,11)+WPz*VS1(20,11)&
   +3D0*r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(35,12)=PAz*VS0(20,12)+WPz*VS1(20,12)&
   +3D0*r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))
VS0(35,13)=PAz*VS0(20,13)+WPz*VS1(20,13)&
   +3D0*r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))
VS0(35,14)=PAz*VS0(20,14)+WPz*VS1(20,14)&
   +3D0*r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(35,15)=PAz*VS0(20,15)+WPz*VS1(20,15)&
   +3D0*r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +HfxZpE*VS1(20,5)
VS0(35,16)=PAz*VS0(20,16)+WPz*VS1(20,16)&
   +3D0*r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(20,6)
VS0(35,17)=PAz*VS0(20,17)+WPz*VS1(20,17)&
   +3D0*r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +HfxZpE*VS1(20,7)
VS0(35,18)=PAz*VS0(20,18)+WPz*VS1(20,18)&
   +3D0*r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +2D0*HfxZpE*VS1(20,8)
VS0(35,19)=PAz*VS0(20,19)+WPz*VS1(20,19)&
   +3D0*r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +2D0*HfxZpE*VS1(20,9)
VS0(35,20)=PAz*VS0(20,20)+WPz*VS1(20,20)&
   +3D0*r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))&
   +3D0*HfxZpE*VS1(20,10)
CASE(3)
VS0(21,11)=PAx*VS0(11,11)+WPx*VS1(11,11)&
   +3D0*r1x2Z*(VS0(5,11)-ExZpE*VS1(5,11))&
   +3D0*HfxZpE*VS1(11,5)
VS0(21,12)=PAx*VS0(11,12)+WPx*VS1(11,12)&
   +3D0*r1x2Z*(VS0(5,12)-ExZpE*VS1(5,12))&
   +2D0*HfxZpE*VS1(11,6)
VS0(21,13)=PAx*VS0(11,13)+WPx*VS1(11,13)&
   +3D0*r1x2Z*(VS0(5,13)-ExZpE*VS1(5,13))&
   +HfxZpE*VS1(11,7)
VS0(21,14)=PAx*VS0(11,14)+WPx*VS1(11,14)&
   +3D0*r1x2Z*(VS0(5,14)-ExZpE*VS1(5,14))
VS0(21,15)=PAx*VS0(11,15)+WPx*VS1(11,15)&
   +3D0*r1x2Z*(VS0(5,15)-ExZpE*VS1(5,15))&
   +2D0*HfxZpE*VS1(11,8)
VS0(21,16)=PAx*VS0(11,16)+WPx*VS1(11,16)&
   +3D0*r1x2Z*(VS0(5,16)-ExZpE*VS1(5,16))&
   +HfxZpE*VS1(11,9)
VS0(21,17)=PAx*VS0(11,17)+WPx*VS1(11,17)&
   +3D0*r1x2Z*(VS0(5,17)-ExZpE*VS1(5,17))
VS0(21,18)=PAx*VS0(11,18)+WPx*VS1(11,18)&
   +3D0*r1x2Z*(VS0(5,18)-ExZpE*VS1(5,18))&
   +HfxZpE*VS1(11,10)
VS0(21,19)=PAx*VS0(11,19)+WPx*VS1(11,19)&
   +3D0*r1x2Z*(VS0(5,19)-ExZpE*VS1(5,19))
VS0(21,20)=PAx*VS0(11,20)+WPx*VS1(11,20)&
   +3D0*r1x2Z*(VS0(5,20)-ExZpE*VS1(5,20))
VS0(22,11)=PAx*VS0(12,11)+WPx*VS1(12,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))&
   +3D0*HfxZpE*VS1(12,5)
VS0(22,12)=PAx*VS0(12,12)+WPx*VS1(12,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +2D0*HfxZpE*VS1(12,6)
VS0(22,13)=PAx*VS0(12,13)+WPx*VS1(12,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +HfxZpE*VS1(12,7)
VS0(22,14)=PAx*VS0(12,14)+WPx*VS1(12,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(22,15)=PAx*VS0(12,15)+WPx*VS1(12,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +2D0*HfxZpE*VS1(12,8)
VS0(22,16)=PAx*VS0(12,16)+WPx*VS1(12,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(12,9)
VS0(22,17)=PAx*VS0(12,17)+WPx*VS1(12,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))
VS0(22,18)=PAx*VS0(12,18)+WPx*VS1(12,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +HfxZpE*VS1(12,10)
VS0(22,19)=PAx*VS0(12,19)+WPx*VS1(12,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))
VS0(22,20)=PAx*VS0(12,20)+WPx*VS1(12,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(23,11)=PAx*VS0(13,11)+WPx*VS1(13,11)&
   +r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))&
   +3D0*HfxZpE*VS1(13,5)
VS0(23,12)=PAx*VS0(13,12)+WPx*VS1(13,12)&
   +r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +2D0*HfxZpE*VS1(13,6)
VS0(23,13)=PAx*VS0(13,13)+WPx*VS1(13,13)&
   +r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +HfxZpE*VS1(13,7)
VS0(23,14)=PAx*VS0(13,14)+WPx*VS1(13,14)&
   +r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))
VS0(23,15)=PAx*VS0(13,15)+WPx*VS1(13,15)&
   +r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))&
   +2D0*HfxZpE*VS1(13,8)
VS0(23,16)=PAx*VS0(13,16)+WPx*VS1(13,16)&
   +r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(13,9)
VS0(23,17)=PAx*VS0(13,17)+WPx*VS1(13,17)&
   +r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))
VS0(23,18)=PAx*VS0(13,18)+WPx*VS1(13,18)&
   +r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))&
   +HfxZpE*VS1(13,10)
VS0(23,19)=PAx*VS0(13,19)+WPx*VS1(13,19)&
   +r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))
VS0(23,20)=PAx*VS0(13,20)+WPx*VS1(13,20)&
   +r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(24,11)=PAy*VS0(13,11)+WPy*VS1(13,11)&
   +2D0*r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(24,12)=PAy*VS0(13,12)+WPy*VS1(13,12)&
   +2D0*r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))&
   +HfxZpE*VS1(13,5)
VS0(24,13)=PAy*VS0(13,13)+WPy*VS1(13,13)&
   +2D0*r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))&
   +2D0*HfxZpE*VS1(13,6)
VS0(24,14)=PAy*VS0(13,14)+WPy*VS1(13,14)&
   +2D0*r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))&
   +3D0*HfxZpE*VS1(13,7)
VS0(24,15)=PAy*VS0(13,15)+WPy*VS1(13,15)&
   +2D0*r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))
VS0(24,16)=PAy*VS0(13,16)+WPy*VS1(13,16)&
   +2D0*r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(13,8)
VS0(24,17)=PAy*VS0(13,17)+WPy*VS1(13,17)&
   +2D0*r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +2D0*HfxZpE*VS1(13,9)
VS0(24,18)=PAy*VS0(13,18)+WPy*VS1(13,18)&
   +2D0*r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))
VS0(24,19)=PAy*VS0(13,19)+WPy*VS1(13,19)&
   +2D0*r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +HfxZpE*VS1(13,10)
VS0(24,20)=PAy*VS0(13,20)+WPy*VS1(13,20)&
   +2D0*r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))
VS0(25,11)=PAy*VS0(14,11)+WPy*VS1(14,11)&
   +3D0*r1x2Z*(VS0(7,11)-ExZpE*VS1(7,11))
VS0(25,12)=PAy*VS0(14,12)+WPy*VS1(14,12)&
   +3D0*r1x2Z*(VS0(7,12)-ExZpE*VS1(7,12))&
   +HfxZpE*VS1(14,5)
VS0(25,13)=PAy*VS0(14,13)+WPy*VS1(14,13)&
   +3D0*r1x2Z*(VS0(7,13)-ExZpE*VS1(7,13))&
   +2D0*HfxZpE*VS1(14,6)
VS0(25,14)=PAy*VS0(14,14)+WPy*VS1(14,14)&
   +3D0*r1x2Z*(VS0(7,14)-ExZpE*VS1(7,14))&
   +3D0*HfxZpE*VS1(14,7)
VS0(25,15)=PAy*VS0(14,15)+WPy*VS1(14,15)&
   +3D0*r1x2Z*(VS0(7,15)-ExZpE*VS1(7,15))
VS0(25,16)=PAy*VS0(14,16)+WPy*VS1(14,16)&
   +3D0*r1x2Z*(VS0(7,16)-ExZpE*VS1(7,16))&
   +HfxZpE*VS1(14,8)
VS0(25,17)=PAy*VS0(14,17)+WPy*VS1(14,17)&
   +3D0*r1x2Z*(VS0(7,17)-ExZpE*VS1(7,17))&
   +2D0*HfxZpE*VS1(14,9)
VS0(25,18)=PAy*VS0(14,18)+WPy*VS1(14,18)&
   +3D0*r1x2Z*(VS0(7,18)-ExZpE*VS1(7,18))
VS0(25,19)=PAy*VS0(14,19)+WPy*VS1(14,19)&
   +3D0*r1x2Z*(VS0(7,19)-ExZpE*VS1(7,19))&
   +HfxZpE*VS1(14,10)
VS0(25,20)=PAy*VS0(14,20)+WPy*VS1(14,20)&
   +3D0*r1x2Z*(VS0(7,20)-ExZpE*VS1(7,20))
VS0(26,11)=PAx*VS0(15,11)+WPx*VS1(15,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))&
   +3D0*HfxZpE*VS1(15,5)
VS0(26,12)=PAx*VS0(15,12)+WPx*VS1(15,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +2D0*HfxZpE*VS1(15,6)
VS0(26,13)=PAx*VS0(15,13)+WPx*VS1(15,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +HfxZpE*VS1(15,7)
VS0(26,14)=PAx*VS0(15,14)+WPx*VS1(15,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(26,15)=PAx*VS0(15,15)+WPx*VS1(15,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +2D0*HfxZpE*VS1(15,8)
VS0(26,16)=PAx*VS0(15,16)+WPx*VS1(15,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(15,9)
VS0(26,17)=PAx*VS0(15,17)+WPx*VS1(15,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))
VS0(26,18)=PAx*VS0(15,18)+WPx*VS1(15,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +HfxZpE*VS1(15,10)
VS0(26,19)=PAx*VS0(15,19)+WPx*VS1(15,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))
VS0(26,20)=PAx*VS0(15,20)+WPx*VS1(15,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(27,11)=PAx*VS0(16,11)+WPx*VS1(16,11)&
   +r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))&
   +3D0*HfxZpE*VS1(16,5)
VS0(27,12)=PAx*VS0(16,12)+WPx*VS1(16,12)&
   +r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +2D0*HfxZpE*VS1(16,6)
VS0(27,13)=PAx*VS0(16,13)+WPx*VS1(16,13)&
   +r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +HfxZpE*VS1(16,7)
VS0(27,14)=PAx*VS0(16,14)+WPx*VS1(16,14)&
   +r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(27,15)=PAx*VS0(16,15)+WPx*VS1(16,15)&
   +r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +2D0*HfxZpE*VS1(16,8)
VS0(27,16)=PAx*VS0(16,16)+WPx*VS1(16,16)&
   +r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(16,9)
VS0(27,17)=PAx*VS0(16,17)+WPx*VS1(16,17)&
   +r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))
VS0(27,18)=PAx*VS0(16,18)+WPx*VS1(16,18)&
   +r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +HfxZpE*VS1(16,10)
VS0(27,19)=PAx*VS0(16,19)+WPx*VS1(16,19)&
   +r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))
VS0(27,20)=PAx*VS0(16,20)+WPx*VS1(16,20)&
   +r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(28,11)=PAy*VS0(16,11)+WPy*VS1(16,11)&
   +r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(28,12)=PAy*VS0(16,12)+WPy*VS1(16,12)&
   +r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))&
   +HfxZpE*VS1(16,5)
VS0(28,13)=PAy*VS0(16,13)+WPy*VS1(16,13)&
   +r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))&
   +2D0*HfxZpE*VS1(16,6)
VS0(28,14)=PAy*VS0(16,14)+WPy*VS1(16,14)&
   +r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))&
   +3D0*HfxZpE*VS1(16,7)
VS0(28,15)=PAy*VS0(16,15)+WPy*VS1(16,15)&
   +r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))
VS0(28,16)=PAy*VS0(16,16)+WPy*VS1(16,16)&
   +r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(16,8)
VS0(28,17)=PAy*VS0(16,17)+WPy*VS1(16,17)&
   +r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +2D0*HfxZpE*VS1(16,9)
VS0(28,18)=PAy*VS0(16,18)+WPy*VS1(16,18)&
   +r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))
VS0(28,19)=PAy*VS0(16,19)+WPy*VS1(16,19)&
   +r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +HfxZpE*VS1(16,10)
VS0(28,20)=PAy*VS0(16,20)+WPy*VS1(16,20)&
   +r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))
VS0(29,11)=PAy*VS0(17,11)+WPy*VS1(17,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(29,12)=PAy*VS0(17,12)+WPy*VS1(17,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))&
   +HfxZpE*VS1(17,5)
VS0(29,13)=PAy*VS0(17,13)+WPy*VS1(17,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))&
   +2D0*HfxZpE*VS1(17,6)
VS0(29,14)=PAy*VS0(17,14)+WPy*VS1(17,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))&
   +3D0*HfxZpE*VS1(17,7)
VS0(29,15)=PAy*VS0(17,15)+WPy*VS1(17,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))
VS0(29,16)=PAy*VS0(17,16)+WPy*VS1(17,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(17,8)
VS0(29,17)=PAy*VS0(17,17)+WPy*VS1(17,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +2D0*HfxZpE*VS1(17,9)
VS0(29,18)=PAy*VS0(17,18)+WPy*VS1(17,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))
VS0(29,19)=PAy*VS0(17,19)+WPy*VS1(17,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +HfxZpE*VS1(17,10)
VS0(29,20)=PAy*VS0(17,20)+WPy*VS1(17,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))
VS0(30,11)=PAx*VS0(18,11)+WPx*VS1(18,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))&
   +3D0*HfxZpE*VS1(18,5)
VS0(30,12)=PAx*VS0(18,12)+WPx*VS1(18,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +2D0*HfxZpE*VS1(18,6)
VS0(30,13)=PAx*VS0(18,13)+WPx*VS1(18,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +HfxZpE*VS1(18,7)
VS0(30,14)=PAx*VS0(18,14)+WPx*VS1(18,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(30,15)=PAx*VS0(18,15)+WPx*VS1(18,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +2D0*HfxZpE*VS1(18,8)
VS0(30,16)=PAx*VS0(18,16)+WPx*VS1(18,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(18,9)
VS0(30,17)=PAx*VS0(18,17)+WPx*VS1(18,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))
VS0(30,18)=PAx*VS0(18,18)+WPx*VS1(18,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +HfxZpE*VS1(18,10)
VS0(30,19)=PAx*VS0(18,19)+WPx*VS1(18,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))
VS0(30,20)=PAx*VS0(18,20)+WPx*VS1(18,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(31,11)=PAz*VS0(16,11)+WPz*VS1(16,11)+r1x2Z*VR1(16,11)&
   +r1x2Z*(VS0(6,11)-ExZpE*VS1(6,11))
VS0(31,12)=PAz*VS0(16,12)+WPz*VS1(16,12)+r1x2Z*VR1(16,12)&
   +r1x2Z*(VS0(6,12)-ExZpE*VS1(6,12))
VS0(31,13)=PAz*VS0(16,13)+WPz*VS1(16,13)+r1x2Z*VR1(16,13)&
   +r1x2Z*(VS0(6,13)-ExZpE*VS1(6,13))
VS0(31,14)=PAz*VS0(16,14)+WPz*VS1(16,14)+r1x2Z*VR1(16,14)&
   +r1x2Z*(VS0(6,14)-ExZpE*VS1(6,14))
VS0(31,15)=PAz*VS0(16,15)+WPz*VS1(16,15)+r1x2Z*VR1(16,15)&
   +r1x2Z*(VS0(6,15)-ExZpE*VS1(6,15))&
   +HfxZpE*VS1(16,5)
VS0(31,16)=PAz*VS0(16,16)+WPz*VS1(16,16)+r1x2Z*VR1(16,16)&
   +r1x2Z*(VS0(6,16)-ExZpE*VS1(6,16))&
   +HfxZpE*VS1(16,6)
VS0(31,17)=PAz*VS0(16,17)+WPz*VS1(16,17)+r1x2Z*VR1(16,17)&
   +r1x2Z*(VS0(6,17)-ExZpE*VS1(6,17))&
   +HfxZpE*VS1(16,7)
VS0(31,18)=PAz*VS0(16,18)+WPz*VS1(16,18)+r1x2Z*VR1(16,18)&
   +r1x2Z*(VS0(6,18)-ExZpE*VS1(6,18))&
   +2D0*HfxZpE*VS1(16,8)
VS0(31,19)=PAz*VS0(16,19)+WPz*VS1(16,19)+r1x2Z*VR1(16,19)&
   +r1x2Z*(VS0(6,19)-ExZpE*VS1(6,19))&
   +2D0*HfxZpE*VS1(16,9)
VS0(31,20)=PAz*VS0(16,20)+WPz*VS1(16,20)+r1x2Z*VR1(16,20)&
   +r1x2Z*(VS0(6,20)-ExZpE*VS1(6,20))&
   +3D0*HfxZpE*VS1(16,10)
VS0(32,11)=PAy*VS0(19,11)+WPy*VS1(19,11)&
   +r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(32,12)=PAy*VS0(19,12)+WPy*VS1(19,12)&
   +r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))&
   +HfxZpE*VS1(19,5)
VS0(32,13)=PAy*VS0(19,13)+WPy*VS1(19,13)&
   +r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))&
   +2D0*HfxZpE*VS1(19,6)
VS0(32,14)=PAy*VS0(19,14)+WPy*VS1(19,14)&
   +r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))&
   +3D0*HfxZpE*VS1(19,7)
VS0(32,15)=PAy*VS0(19,15)+WPy*VS1(19,15)&
   +r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))
VS0(32,16)=PAy*VS0(19,16)+WPy*VS1(19,16)&
   +r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(19,8)
VS0(32,17)=PAy*VS0(19,17)+WPy*VS1(19,17)&
   +r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +2D0*HfxZpE*VS1(19,9)
VS0(32,18)=PAy*VS0(19,18)+WPy*VS1(19,18)&
   +r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))
VS0(32,19)=PAy*VS0(19,19)+WPy*VS1(19,19)&
   +r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +HfxZpE*VS1(19,10)
VS0(32,20)=PAy*VS0(19,20)+WPy*VS1(19,20)&
   +r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))
VS0(33,11)=PAz*VS0(18,11)+WPz*VS1(18,11)+r1x2Z*VR1(18,11)&
   +2D0*r1x2Z*(VS0(8,11)-ExZpE*VS1(8,11))
VS0(33,12)=PAz*VS0(18,12)+WPz*VS1(18,12)+r1x2Z*VR1(18,12)&
   +2D0*r1x2Z*(VS0(8,12)-ExZpE*VS1(8,12))
VS0(33,13)=PAz*VS0(18,13)+WPz*VS1(18,13)+r1x2Z*VR1(18,13)&
   +2D0*r1x2Z*(VS0(8,13)-ExZpE*VS1(8,13))
VS0(33,14)=PAz*VS0(18,14)+WPz*VS1(18,14)+r1x2Z*VR1(18,14)&
   +2D0*r1x2Z*(VS0(8,14)-ExZpE*VS1(8,14))
VS0(33,15)=PAz*VS0(18,15)+WPz*VS1(18,15)+r1x2Z*VR1(18,15)&
   +2D0*r1x2Z*(VS0(8,15)-ExZpE*VS1(8,15))&
   +HfxZpE*VS1(18,5)
VS0(33,16)=PAz*VS0(18,16)+WPz*VS1(18,16)+r1x2Z*VR1(18,16)&
   +2D0*r1x2Z*(VS0(8,16)-ExZpE*VS1(8,16))&
   +HfxZpE*VS1(18,6)
VS0(33,17)=PAz*VS0(18,17)+WPz*VS1(18,17)+r1x2Z*VR1(18,17)&
   +2D0*r1x2Z*(VS0(8,17)-ExZpE*VS1(8,17))&
   +HfxZpE*VS1(18,7)
VS0(33,18)=PAz*VS0(18,18)+WPz*VS1(18,18)+r1x2Z*VR1(18,18)&
   +2D0*r1x2Z*(VS0(8,18)-ExZpE*VS1(8,18))&
   +2D0*HfxZpE*VS1(18,8)
VS0(33,19)=PAz*VS0(18,19)+WPz*VS1(18,19)+r1x2Z*VR1(18,19)&
   +2D0*r1x2Z*(VS0(8,19)-ExZpE*VS1(8,19))&
   +2D0*HfxZpE*VS1(18,9)
VS0(33,20)=PAz*VS0(18,20)+WPz*VS1(18,20)+r1x2Z*VR1(18,20)&
   +2D0*r1x2Z*(VS0(8,20)-ExZpE*VS1(8,20))&
   +3D0*HfxZpE*VS1(18,10)
VS0(34,11)=PAz*VS0(19,11)+WPz*VS1(19,11)+r1x2Z*VR1(19,11)&
   +2D0*r1x2Z*(VS0(9,11)-ExZpE*VS1(9,11))
VS0(34,12)=PAz*VS0(19,12)+WPz*VS1(19,12)+r1x2Z*VR1(19,12)&
   +2D0*r1x2Z*(VS0(9,12)-ExZpE*VS1(9,12))
VS0(34,13)=PAz*VS0(19,13)+WPz*VS1(19,13)+r1x2Z*VR1(19,13)&
   +2D0*r1x2Z*(VS0(9,13)-ExZpE*VS1(9,13))
VS0(34,14)=PAz*VS0(19,14)+WPz*VS1(19,14)+r1x2Z*VR1(19,14)&
   +2D0*r1x2Z*(VS0(9,14)-ExZpE*VS1(9,14))
VS0(34,15)=PAz*VS0(19,15)+WPz*VS1(19,15)+r1x2Z*VR1(19,15)&
   +2D0*r1x2Z*(VS0(9,15)-ExZpE*VS1(9,15))&
   +HfxZpE*VS1(19,5)
VS0(34,16)=PAz*VS0(19,16)+WPz*VS1(19,16)+r1x2Z*VR1(19,16)&
   +2D0*r1x2Z*(VS0(9,16)-ExZpE*VS1(9,16))&
   +HfxZpE*VS1(19,6)
VS0(34,17)=PAz*VS0(19,17)+WPz*VS1(19,17)+r1x2Z*VR1(19,17)&
   +2D0*r1x2Z*(VS0(9,17)-ExZpE*VS1(9,17))&
   +HfxZpE*VS1(19,7)
VS0(34,18)=PAz*VS0(19,18)+WPz*VS1(19,18)+r1x2Z*VR1(19,18)&
   +2D0*r1x2Z*(VS0(9,18)-ExZpE*VS1(9,18))&
   +2D0*HfxZpE*VS1(19,8)
VS0(34,19)=PAz*VS0(19,19)+WPz*VS1(19,19)+r1x2Z*VR1(19,19)&
   +2D0*r1x2Z*(VS0(9,19)-ExZpE*VS1(9,19))&
   +2D0*HfxZpE*VS1(19,9)
VS0(34,20)=PAz*VS0(19,20)+WPz*VS1(19,20)+r1x2Z*VR1(19,20)&
   +2D0*r1x2Z*(VS0(9,20)-ExZpE*VS1(9,20))&
   +3D0*HfxZpE*VS1(19,10)
VS0(35,11)=PAz*VS0(20,11)+WPz*VS1(20,11)+r1x2Z*VR1(20,11)&
   +3D0*r1x2Z*(VS0(10,11)-ExZpE*VS1(10,11))
VS0(35,12)=PAz*VS0(20,12)+WPz*VS1(20,12)+r1x2Z*VR1(20,12)&
   +3D0*r1x2Z*(VS0(10,12)-ExZpE*VS1(10,12))
VS0(35,13)=PAz*VS0(20,13)+WPz*VS1(20,13)+r1x2Z*VR1(20,13)&
   +3D0*r1x2Z*(VS0(10,13)-ExZpE*VS1(10,13))
VS0(35,14)=PAz*VS0(20,14)+WPz*VS1(20,14)+r1x2Z*VR1(20,14)&
   +3D0*r1x2Z*(VS0(10,14)-ExZpE*VS1(10,14))
VS0(35,15)=PAz*VS0(20,15)+WPz*VS1(20,15)+r1x2Z*VR1(20,15)&
   +3D0*r1x2Z*(VS0(10,15)-ExZpE*VS1(10,15))&
   +HfxZpE*VS1(20,5)
VS0(35,16)=PAz*VS0(20,16)+WPz*VS1(20,16)+r1x2Z*VR1(20,16)&
   +3D0*r1x2Z*(VS0(10,16)-ExZpE*VS1(10,16))&
   +HfxZpE*VS1(20,6)
VS0(35,17)=PAz*VS0(20,17)+WPz*VS1(20,17)+r1x2Z*VR1(20,17)&
   +3D0*r1x2Z*(VS0(10,17)-ExZpE*VS1(10,17))&
   +HfxZpE*VS1(20,7)
VS0(35,18)=PAz*VS0(20,18)+WPz*VS1(20,18)+r1x2Z*VR1(20,18)&
   +3D0*r1x2Z*(VS0(10,18)-ExZpE*VS1(10,18))&
   +2D0*HfxZpE*VS1(20,8)
VS0(35,19)=PAz*VS0(20,19)+WPz*VS1(20,19)+r1x2Z*VR1(20,19)&
   +3D0*r1x2Z*(VS0(10,19)-ExZpE*VS1(10,19))&
   +2D0*HfxZpE*VS1(20,9)
VS0(35,20)=PAz*VS0(20,20)+WPz*VS1(20,20)+r1x2Z*VR1(20,20)&
   +3D0*r1x2Z*(VS0(10,20)-ExZpE*VS1(10,20))&
   +3D0*HfxZpE*VS1(20,10)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0f0'
STOP
END SELECT
END SUBROUTINE MVRRg0f0
