!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRf0i0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(11,23)
      V(2)=3.D0*V(1)
      V(3)=r1x2E*ZxZpE*VRR1(11,23)
      V(4)=-3.D0*V(3)
      V(5)=r1x2E*VRR0(11,24)
      V(6)=HfxZpE*VRR1(5,39)
      V(7)=r1x2E*ZxZpE*VRR1(11,24)
      V(8)=r1x2E*VRR0(11,27)
      V(9)=r1x2E*ZxZpE*VRR1(11,27)
      V(10)=r1x2E*VRR0(11,28)
      V(11)=2.D0*V(10)
      V(12)=HfxZpE*VRR1(5,44)
      V(13)=r1x2E*ZxZpE*VRR1(11,28)
      V(14)=-2.D0*V(13)
      V(15)=2.D0*V(8)
      V(16)=-2.D0*V(9)
      V(17)=r1x2E*VRR0(11,30)
      V(18)=3.D0*V(17)
      V(19)=r1x2E*ZxZpE*VRR1(11,30)
      V(20)=-3.D0*V(19)
      V(21)=r1x2E*VRR0(11,31)
      V(22)=2.D0*V(21)
      V(23)=HfxZpE*VRR1(5,48)
      V(24)=r1x2E*ZxZpE*VRR1(11,31)
      V(25)=-2.D0*V(24)
      V(26)=HfxZpE*VRR1(5,49)
      V(27)=r1x2E*VRR0(11,32)
      V(28)=3.D0*V(27)
      V(29)=r1x2E*ZxZpE*VRR1(11,32)
      V(30)=-3.D0*V(29)
      V(31)=r1x2E*VRR0(11,33)
      V(32)=HfxZpE*VRR1(5,51)
      V(33)=r1x2E*ZxZpE*VRR1(11,33)
      V(34)=r1x2E*VRR0(11,34)
      V(35)=r1x2E*ZxZpE*VRR1(11,34)
      V(36)=r1x2E*VRR0(12,23)
      V(37)=3.D0*V(36)
      V(38)=r1x2E*ZxZpE*VRR1(12,23)
      V(39)=-3.D0*V(38)
      V(40)=r1x2E*VRR0(12,24)
      V(41)=HfxZpE*VRR1(6,39)
      V(42)=2.D0*V(41)
      V(43)=r1x2E*ZxZpE*VRR1(12,24)
      V(44)=r1x2E*VRR0(12,27)
      V(45)=r1x2E*ZxZpE*VRR1(12,27)
      V(46)=r1x2E*VRR0(12,28)
      V(47)=2.D0*V(46)
      V(48)=HfxZpE*VRR1(6,44)
      V(49)=2.D0*V(48)
      V(50)=r1x2E*ZxZpE*VRR1(12,28)
      V(51)=-2.D0*V(50)
      V(52)=2.D0*V(44)
      V(53)=-2.D0*V(45)
      V(54)=r1x2E*VRR0(12,30)
      V(55)=3.D0*V(54)
      V(56)=r1x2E*ZxZpE*VRR1(12,30)
      V(57)=-3.D0*V(56)
      V(58)=r1x2E*VRR0(12,31)
      V(59)=2.D0*V(58)
      V(60)=HfxZpE*VRR1(6,48)
      V(61)=r1x2E*ZxZpE*VRR1(12,31)
      V(62)=-2.D0*V(61)
      V(63)=r1x2E*VRR0(12,32)
      V(64)=HfxZpE*VRR1(6,49)
      V(65)=2.D0*V(64)
      V(66)=r1x2E*ZxZpE*VRR1(12,32)
      V(67)=3.D0*V(63)
      V(68)=-3.D0*V(66)
      V(69)=r1x2E*VRR0(12,33)
      V(70)=HfxZpE*VRR1(6,51)
      V(71)=r1x2E*ZxZpE*VRR1(12,33)
      V(72)=r1x2E*VRR0(12,34)
      V(73)=HfxZpE*VRR1(5,53)
      V(74)=r1x2E*ZxZpE*VRR1(12,34)
      V(75)=r1x2E*VRR0(13,23)
      V(76)=3.D0*V(75)
      V(77)=r1x2E*ZxZpE*VRR1(13,23)
      V(78)=-3.D0*V(77)
      V(79)=r1x2E*VRR0(13,24)
      V(80)=HfxZpE*VRR1(7,39)
      V(81)=r1x2E*ZxZpE*VRR1(13,24)
      V(82)=r1x2E*VRR0(13,27)
      V(83)=r1x2E*ZxZpE*VRR1(13,27)
      V(84)=r1x2E*VRR0(13,28)
      V(85)=2.D0*V(84)
      V(86)=HfxZpE*VRR1(7,44)
      V(87)=r1x2E*ZxZpE*VRR1(13,28)
      V(88)=-2.D0*V(87)
      V(89)=2.D0*V(82)
      V(90)=-2.D0*V(83)
      V(91)=r1x2E*VRR0(13,30)
      V(92)=3.D0*V(91)
      V(93)=r1x2E*ZxZpE*VRR1(13,30)
      V(94)=-3.D0*V(93)
      V(95)=r1x2E*VRR0(13,31)
      V(96)=2.D0*V(95)
      V(97)=HfxZpE*VRR1(7,48)
      V(98)=r1x2E*ZxZpE*VRR1(13,31)
      V(99)=-2.D0*V(98)
      V(100)=r1x2E*VRR0(13,32)
      V(101)=HfxZpE*VRR1(7,49)
      V(102)=r1x2E*ZxZpE*VRR1(13,32)
      V(103)=3.D0*V(100)
      V(104)=-3.D0*V(102)
      V(105)=r1x2E*VRR0(13,33)
      V(106)=HfxZpE*VRR1(7,51)
      V(107)=r1x2E*ZxZpE*VRR1(13,33)
      V(108)=r1x2E*VRR0(13,34)
      V(109)=HfxZpE*VRR1(6,53)
      V(110)=r1x2E*ZxZpE*VRR1(13,34)
      V(111)=r1x2E*VRR0(14,23)
      V(112)=3.D0*V(111)
      V(113)=r1x2E*ZxZpE*VRR1(14,23)
      V(114)=-3.D0*V(113)
      V(115)=r1x2E*VRR0(14,24)
      V(116)=r1x2E*ZxZpE*VRR1(14,24)
      V(117)=r1x2E*VRR0(14,27)
      V(118)=r1x2E*ZxZpE*VRR1(14,27)
      V(119)=r1x2E*VRR0(14,28)
      V(120)=2.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(14,28)
      V(122)=-2.D0*V(121)
      V(123)=2.D0*V(117)
      V(124)=-2.D0*V(118)
      V(125)=r1x2E*VRR0(14,30)
      V(126)=3.D0*V(125)
      V(127)=r1x2E*ZxZpE*VRR1(14,30)
      V(128)=-3.D0*V(127)
      V(129)=r1x2E*VRR0(14,31)
      V(130)=2.D0*V(129)
      V(131)=r1x2E*ZxZpE*VRR1(14,31)
      V(132)=-2.D0*V(131)
      V(133)=r1x2E*VRR0(14,32)
      V(134)=3.D0*V(133)
      V(135)=r1x2E*ZxZpE*VRR1(14,32)
      V(136)=-3.D0*V(135)
      V(137)=r1x2E*VRR0(14,33)
      V(138)=r1x2E*ZxZpE*VRR1(14,33)
      V(139)=r1x2E*VRR0(14,34)
      V(140)=HfxZpE*VRR1(7,53)
      V(141)=r1x2E*ZxZpE*VRR1(14,34)
      V(142)=r1x2E*VRR0(15,23)
      V(143)=3.D0*V(142)
      V(144)=r1x2E*ZxZpE*VRR1(15,23)
      V(145)=-3.D0*V(144)
      V(146)=r1x2E*VRR0(15,24)
      V(147)=HfxZpE*VRR1(8,39)
      V(148)=r1x2E*ZxZpE*VRR1(15,24)
      V(149)=r1x2E*VRR0(15,27)
      V(150)=r1x2E*ZxZpE*VRR1(15,27)
      V(151)=r1x2E*VRR0(15,28)
      V(152)=2.D0*V(151)
      V(153)=HfxZpE*VRR1(8,44)
      V(154)=r1x2E*ZxZpE*VRR1(15,28)
      V(155)=-2.D0*V(154)
      V(156)=2.D0*V(149)
      V(157)=-2.D0*V(150)
      V(158)=r1x2E*VRR0(15,30)
      V(159)=3.D0*V(158)
      V(160)=r1x2E*ZxZpE*VRR1(15,30)
      V(161)=-3.D0*V(160)
      V(162)=r1x2E*VRR0(15,31)
      V(163)=2.D0*V(162)
      V(164)=HfxZpE*VRR1(8,48)
      V(165)=2.D0*V(164)
      V(166)=r1x2E*ZxZpE*VRR1(15,31)
      V(167)=-2.D0*V(166)
      V(168)=r1x2E*VRR0(15,32)
      V(169)=HfxZpE*VRR1(8,49)
      V(170)=2.D0*V(169)
      V(171)=r1x2E*ZxZpE*VRR1(15,32)
      V(172)=3.D0*V(168)
      V(173)=-3.D0*V(171)
      V(174)=r1x2E*VRR0(15,33)
      V(175)=HfxZpE*VRR1(8,51)
      V(176)=2.D0*V(175)
      V(177)=r1x2E*ZxZpE*VRR1(15,33)
      V(178)=r1x2E*VRR0(15,34)
      V(179)=r1x2E*ZxZpE*VRR1(15,34)
      V(180)=r1x2E*VRR0(16,23)
      V(181)=3.D0*V(180)
      V(182)=r1x2E*ZxZpE*VRR1(16,23)
      V(183)=-3.D0*V(182)
      V(184)=r1x2E*VRR0(16,24)
      V(185)=HfxZpE*VRR1(9,39)
      V(186)=r1x2E*ZxZpE*VRR1(16,24)
      V(187)=r1x2E*VRR0(16,27)
      V(188)=r1x2E*ZxZpE*VRR1(16,27)
      V(189)=r1x2E*VRR0(16,28)
      V(190)=2.D0*V(189)
      V(191)=HfxZpE*VRR1(9,44)
      V(192)=r1x2E*ZxZpE*VRR1(16,28)
      V(193)=-2.D0*V(192)
      V(194)=2.D0*V(187)
      V(195)=-2.D0*V(188)
      V(196)=r1x2E*VRR0(16,30)
      V(197)=3.D0*V(196)
      V(198)=r1x2E*ZxZpE*VRR1(16,30)
      V(199)=-3.D0*V(198)
      V(200)=r1x2E*VRR0(16,31)
      V(201)=2.D0*V(200)
      V(202)=HfxZpE*VRR1(9,48)
      V(203)=r1x2E*ZxZpE*VRR1(16,31)
      V(204)=-2.D0*V(203)
      V(205)=r1x2E*VRR0(16,32)
      V(206)=HfxZpE*VRR1(9,49)
      V(207)=r1x2E*ZxZpE*VRR1(16,32)
      V(208)=3.D0*V(205)
      V(209)=-3.D0*V(207)
      V(210)=r1x2E*VRR0(16,33)
      V(211)=HfxZpE*VRR1(9,51)
      V(212)=r1x2E*ZxZpE*VRR1(16,33)
      V(213)=r1x2E*VRR0(16,34)
      V(214)=HfxZpE*VRR1(8,53)
      V(215)=r1x2E*ZxZpE*VRR1(16,34)
      V(216)=r1x2E*VRR0(17,23)
      V(217)=3.D0*V(216)
      V(218)=r1x2E*ZxZpE*VRR1(17,23)
      V(219)=-3.D0*V(218)
      V(220)=r1x2E*VRR0(17,24)
      V(221)=r1x2E*ZxZpE*VRR1(17,24)
      V(222)=r1x2E*VRR0(17,27)
      V(223)=r1x2E*ZxZpE*VRR1(17,27)
      V(224)=r1x2E*VRR0(17,28)
      V(225)=2.D0*V(224)
      V(226)=r1x2E*ZxZpE*VRR1(17,28)
      V(227)=-2.D0*V(226)
      V(228)=2.D0*V(222)
      V(229)=-2.D0*V(223)
      V(230)=r1x2E*VRR0(17,30)
      V(231)=3.D0*V(230)
      V(232)=r1x2E*ZxZpE*VRR1(17,30)
      V(233)=-3.D0*V(232)
      V(234)=r1x2E*VRR0(17,31)
      V(235)=2.D0*V(234)
      V(236)=r1x2E*ZxZpE*VRR1(17,31)
      V(237)=-2.D0*V(236)
      V(238)=r1x2E*VRR0(17,32)
      V(239)=r1x2E*ZxZpE*VRR1(17,32)
      V(240)=2.D0*V(206)
      V(241)=3.D0*V(238)
      V(242)=-3.D0*V(239)
      V(243)=r1x2E*VRR0(17,33)
      V(244)=r1x2E*ZxZpE*VRR1(17,33)
      V(245)=r1x2E*VRR0(17,34)
      V(246)=HfxZpE*VRR1(9,53)
      V(247)=2.D0*V(246)
      V(248)=r1x2E*ZxZpE*VRR1(17,34)
      V(249)=r1x2E*VRR0(18,23)
      V(250)=3.D0*V(249)
      V(251)=r1x2E*ZxZpE*VRR1(18,23)
      V(252)=-3.D0*V(251)
      V(253)=r1x2E*VRR0(18,24)
      V(254)=HfxZpE*VRR1(10,39)
      V(255)=r1x2E*ZxZpE*VRR1(18,24)
      V(256)=r1x2E*VRR0(18,27)
      V(257)=r1x2E*ZxZpE*VRR1(18,27)
      V(258)=r1x2E*VRR0(18,28)
      V(259)=2.D0*V(258)
      V(260)=HfxZpE*VRR1(10,44)
      V(261)=r1x2E*ZxZpE*VRR1(18,28)
      V(262)=-2.D0*V(261)
      V(263)=2.D0*V(256)
      V(264)=-2.D0*V(257)
      V(265)=r1x2E*VRR0(18,30)
      V(266)=3.D0*V(265)
      V(267)=r1x2E*ZxZpE*VRR1(18,30)
      V(268)=-3.D0*V(267)
      V(269)=r1x2E*VRR0(18,31)
      V(270)=2.D0*V(269)
      V(271)=HfxZpE*VRR1(10,48)
      V(272)=r1x2E*ZxZpE*VRR1(18,31)
      V(273)=-2.D0*V(272)
      V(274)=r1x2E*VRR0(18,32)
      V(275)=HfxZpE*VRR1(10,49)
      V(276)=r1x2E*ZxZpE*VRR1(18,32)
      V(277)=3.D0*V(274)
      V(278)=-3.D0*V(276)
      V(279)=r1x2E*VRR0(18,33)
      V(280)=HfxZpE*VRR1(10,51)
      V(281)=r1x2E*ZxZpE*VRR1(18,33)
      V(282)=r1x2E*VRR0(18,34)
      V(283)=r1x2E*ZxZpE*VRR1(18,34)
      V(284)=r1x2E*VRR0(19,23)
      V(285)=3.D0*V(284)
      V(286)=r1x2E*ZxZpE*VRR1(19,23)
      V(287)=-3.D0*V(286)
      V(288)=r1x2E*VRR0(19,24)
      V(289)=r1x2E*ZxZpE*VRR1(19,24)
      V(290)=r1x2E*VRR0(19,27)
      V(291)=r1x2E*ZxZpE*VRR1(19,27)
      V(292)=r1x2E*VRR0(19,28)
      V(293)=2.D0*V(292)
      V(294)=r1x2E*ZxZpE*VRR1(19,28)
      V(295)=-2.D0*V(294)
      V(296)=2.D0*V(290)
      V(297)=-2.D0*V(291)
      V(298)=r1x2E*VRR0(19,30)
      V(299)=3.D0*V(298)
      V(300)=r1x2E*ZxZpE*VRR1(19,30)
      V(301)=-3.D0*V(300)
      V(302)=r1x2E*VRR0(19,31)
      V(303)=2.D0*V(302)
      V(304)=r1x2E*ZxZpE*VRR1(19,31)
      V(305)=-2.D0*V(304)
      V(306)=r1x2E*VRR0(19,32)
      V(307)=r1x2E*ZxZpE*VRR1(19,32)
      V(308)=3.D0*V(306)
      V(309)=-3.D0*V(307)
      V(310)=r1x2E*VRR0(19,33)
      V(311)=r1x2E*ZxZpE*VRR1(19,33)
      V(312)=r1x2E*VRR0(19,34)
      V(313)=HfxZpE*VRR1(10,53)
      V(314)=r1x2E*ZxZpE*VRR1(19,34)
      V(315)=r1x2E*VRR0(20,23)
      V(316)=3.D0*V(315)
      V(317)=r1x2E*ZxZpE*VRR1(20,23)
      V(318)=-3.D0*V(317)
      V(319)=r1x2E*VRR0(20,24)
      V(320)=r1x2E*ZxZpE*VRR1(20,24)
      V(321)=r1x2E*VRR0(20,27)
      V(322)=r1x2E*ZxZpE*VRR1(20,27)
      V(323)=r1x2E*VRR0(20,28)
      V(324)=2.D0*V(323)
      V(325)=r1x2E*ZxZpE*VRR1(20,28)
      V(326)=-2.D0*V(325)
      V(327)=2.D0*V(321)
      V(328)=-2.D0*V(322)
      V(329)=r1x2E*VRR0(20,30)
      V(330)=3.D0*V(329)
      V(331)=r1x2E*ZxZpE*VRR1(20,30)
      V(332)=-3.D0*V(331)
      V(333)=r1x2E*VRR0(20,31)
      V(334)=2.D0*V(333)
      V(335)=r1x2E*ZxZpE*VRR1(20,31)
      V(336)=-2.D0*V(335)
      V(337)=r1x2E*VRR0(20,32)
      V(338)=3.D0*V(337)
      V(339)=r1x2E*ZxZpE*VRR1(20,32)
      V(340)=-3.D0*V(339)
      V(341)=r1x2E*VRR0(20,33)
      V(342)=r1x2E*ZxZpE*VRR1(20,33)
      V(343)=r1x2E*VRR0(20,34)
      V(344)=r1x2E*ZxZpE*VRR1(20,34)
      VRR0(11,57)=5.D0*r1x2E*VRR0(11,21)+QCx*VRR0(11,36)+3.D0*HfxZpE*VRR1(5,36)-5.D0*r1x2E*ZxZpE*VRR1(11,21)+WQx*VRR1(11,36)
      VRR0(11,58)=4.D0*r1x2E*VRR0(11,22)+QCx*VRR0(11,37)+3.D0*HfxZpE*VRR1(5,37)-4.D0*r1x2E*ZxZpE*VRR1(11,22)+WQx*VRR1(11,37)
      VRR0(11,59)=V(2)+V(4)+QCx*VRR0(11,38)+3.D0*HfxZpE*VRR1(5,38)+WQx*VRR1(11,38)
      VRR0(11,60)=2.D0*V(5)+3.D0*V(6)-2.D0*V(7)+QCx*VRR0(11,39)+WQx*VRR1(11,39)
      VRR0(11,61)=V(2)+V(4)+QCy*VRR0(11,39)+WQy*VRR1(11,39)
      VRR0(11,62)=4.D0*V(5)-4.D0*V(7)+QCy*VRR0(11,40)+WQy*VRR1(11,40)
      VRR0(11,63)=5.D0*r1x2E*VRR0(11,25)+QCy*VRR0(11,41)-5.D0*r1x2E*ZxZpE*VRR1(11,25)+WQy*VRR1(11,41)
      VRR0(11,64)=4.D0*r1x2E*VRR0(11,26)+QCx*VRR0(11,42)+3.D0*HfxZpE*VRR1(5,42)-4.D0*r1x2E*ZxZpE*VRR1(11,26)+WQx*VRR1(11,42)
      VRR0(11,65)=3.D0*V(8)-3.D0*V(9)+QCx*VRR0(11,43)+3.D0*HfxZpE*VRR1(5,43)+WQx*VRR1(11,43)
      VRR0(11,66)=V(11)+3.D0*V(12)+V(14)+QCx*VRR0(11,44)+WQx*VRR1(11,44)
      VRR0(11,67)=V(15)+V(16)+QCy*VRR0(11,44)+WQy*VRR1(11,44)
      VRR0(11,68)=3.D0*V(10)-3.D0*V(13)+QCy*VRR0(11,45)+WQy*VRR1(11,45)
      VRR0(11,69)=4.D0*r1x2E*VRR0(11,29)+QCy*VRR0(11,46)-4.D0*r1x2E*ZxZpE*VRR1(11,29)+WQy*VRR1(11,46)
      VRR0(11,70)=V(18)+V(20)+QCx*VRR0(11,47)+3.D0*HfxZpE*VRR1(5,47)+WQx*VRR1(11,47)
      VRR0(11,71)=V(22)+3.D0*V(23)+V(25)+QCx*VRR0(11,48)+WQx*VRR1(11,48)
      VRR0(11,72)=2.D0*V(26)+2.D0*r1x2Z*VRR0(2,72)+PAx*VRR0(5,72)-2.D0*ExZpE*r1x2Z*VRR1(2,72)+WPx*VRR1(5,72)
      VRR0(11,73)=V(22)+V(25)+QCy*VRR0(11,49)+WQy*VRR1(11,49)
      VRR0(11,74)=V(28)+V(30)+QCy*VRR0(11,50)+WQy*VRR1(11,50)
      VRR0(11,75)=2.D0*V(31)+3.D0*V(32)-2.D0*V(33)+QCx*VRR0(11,51)+WQx*VRR1(11,51)
      VRR0(11,76)=V(15)+V(16)+QCz*VRR0(11,48)+WQz*VRR1(11,48)
      VRR0(11,77)=V(11)+V(14)+QCz*VRR0(11,49)+WQz*VRR1(11,49)
      VRR0(11,78)=2.D0*V(34)-2.D0*V(35)+QCy*VRR0(11,53)+WQy*VRR1(11,53)
      VRR0(11,79)=V(18)+V(20)+QCz*VRR0(11,51)+WQz*VRR1(11,51)
      VRR0(11,80)=3.D0*V(21)-3.D0*V(24)+QCz*VRR0(11,52)+WQz*VRR1(11,52)
      VRR0(11,81)=V(28)+V(30)+QCz*VRR0(11,53)+WQz*VRR1(11,53)
      VRR0(11,82)=4.D0*V(31)-4.D0*V(33)+QCz*VRR0(11,54)+WQz*VRR1(11,54)
      VRR0(11,83)=4.D0*V(34)-4.D0*V(35)+QCz*VRR0(11,55)+WQz*VRR1(11,55)
      VRR0(11,84)=5.D0*r1x2E*VRR0(11,35)+QCz*VRR0(11,56)-5.D0*r1x2E*ZxZpE*VRR1(11,35)+WQz*VRR1(11,56)
      VRR0(12,57)=5.D0*r1x2E*VRR0(12,21)+QCx*VRR0(12,36)+2.D0*HfxZpE*VRR1(6,36)-5.D0*r1x2E*ZxZpE*VRR1(12,21)+WQx*VRR1(12,36)
      VRR0(12,58)=4.D0*r1x2E*VRR0(12,22)+QCx*VRR0(12,37)+2.D0*HfxZpE*VRR1(6,37)-4.D0*r1x2E*ZxZpE*VRR1(12,22)+WQx*VRR1(12,37)
      VRR0(12,59)=V(37)+V(39)+QCx*VRR0(12,38)+2.D0*HfxZpE*VRR1(6,38)+WQx*VRR1(12,38)
      VRR0(12,60)=2.D0*V(40)+V(42)-2.D0*V(43)+QCx*VRR0(12,39)+WQx*VRR1(12,39)
      VRR0(12,61)=V(6)+V(37)+V(39)+QCy*VRR0(12,39)+WQy*VRR1(12,39)
      VRR0(12,62)=4.D0*V(40)-4.D0*V(43)+QCy*VRR0(12,40)+HfxZpE*VRR1(5,40)+WQy*VRR1(12,40)
      VRR0(12,63)=5.D0*r1x2E*VRR0(12,25)+QCy*VRR0(12,41)+HfxZpE*VRR1(5,41)-5.D0*r1x2E*ZxZpE*VRR1(12,25)+WQy*VRR1(12,41)
      VRR0(12,64)=4.D0*r1x2E*VRR0(12,26)+QCx*VRR0(12,42)+2.D0*HfxZpE*VRR1(6,42)-4.D0*r1x2E*ZxZpE*VRR1(12,26)+WQx*VRR1(12,42)
      VRR0(12,65)=3.D0*V(44)-3.D0*V(45)+QCx*VRR0(12,43)+2.D0*HfxZpE*VRR1(6,43)+WQx*VRR1(12,43)
      VRR0(12,66)=V(47)+V(49)+V(51)+QCx*VRR0(12,44)+WQx*VRR1(12,44)
      VRR0(12,67)=V(12)+V(52)+V(53)+QCy*VRR0(12,44)+WQy*VRR1(12,44)
      VRR0(12,68)=3.D0*V(46)-3.D0*V(50)+QCy*VRR0(12,45)+HfxZpE*VRR1(5,45)+WQy*VRR1(12,45)
      VRR0(12,69)=4.D0*r1x2E*VRR0(12,29)+QCy*VRR0(12,46)+HfxZpE*VRR1(5,46)-4.D0*r1x2E*ZxZpE*VRR1(12,29)+WQy*VRR1(12,46)
      VRR0(12,70)=V(55)+V(57)+QCx*VRR0(12,47)+2.D0*HfxZpE*VRR1(6,47)+WQx*VRR1(12,47)
      VRR0(12,71)=V(59)+2.D0*V(60)+V(62)+QCx*VRR0(12,48)+WQx*VRR1(12,48)
      VRR0(12,72)=V(63)+V(65)-V(66)+QCx*VRR0(12,49)+WQx*VRR1(12,49)
      VRR0(12,73)=V(26)+V(59)+V(62)+QCy*VRR0(12,49)+WQy*VRR1(12,49)
      VRR0(12,74)=V(67)+V(68)+QCy*VRR0(12,50)+HfxZpE*VRR1(5,50)+WQy*VRR1(12,50)
      VRR0(12,75)=2.D0*V(69)+2.D0*V(70)-2.D0*V(71)+QCx*VRR0(12,51)+WQx*VRR1(12,51)
      VRR0(12,76)=V(52)+V(53)+QCz*VRR0(12,48)+WQz*VRR1(12,48)
      VRR0(12,77)=V(47)+V(51)+QCz*VRR0(12,49)+WQz*VRR1(12,49)
      VRR0(12,78)=2.D0*V(72)+V(73)-2.D0*V(74)+QCy*VRR0(12,53)+WQy*VRR1(12,53)
      VRR0(12,79)=V(55)+V(57)+QCz*VRR0(12,51)+WQz*VRR1(12,51)
      VRR0(12,80)=3.D0*V(58)-3.D0*V(61)+QCz*VRR0(12,52)+WQz*VRR1(12,52)
      VRR0(12,81)=V(67)+V(68)+QCz*VRR0(12,53)+WQz*VRR1(12,53)
      VRR0(12,82)=4.D0*V(69)-4.D0*V(71)+QCz*VRR0(12,54)+WQz*VRR1(12,54)
      VRR0(12,83)=4.D0*V(72)-4.D0*V(74)+QCz*VRR0(12,55)+WQz*VRR1(12,55)
      VRR0(12,84)=5.D0*r1x2E*VRR0(12,35)+QCz*VRR0(12,56)-5.D0*r1x2E*ZxZpE*VRR1(12,35)+WQz*VRR1(12,56)
      VRR0(13,57)=5.D0*r1x2E*VRR0(13,21)+QCx*VRR0(13,36)+HfxZpE*VRR1(7,36)-5.D0*r1x2E*ZxZpE*VRR1(13,21)+WQx*VRR1(13,36)
      VRR0(13,58)=4.D0*r1x2E*VRR0(13,22)+QCx*VRR0(13,37)+HfxZpE*VRR1(7,37)-4.D0*r1x2E*ZxZpE*VRR1(13,22)+WQx*VRR1(13,37)
      VRR0(13,59)=V(76)+V(78)+QCx*VRR0(13,38)+HfxZpE*VRR1(7,38)+WQx*VRR1(13,38)
      VRR0(13,60)=2.D0*V(79)+V(80)-2.D0*V(81)+QCx*VRR0(13,39)+WQx*VRR1(13,39)
      VRR0(13,61)=V(42)+V(76)+V(78)+QCy*VRR0(13,39)+WQy*VRR1(13,39)
      VRR0(13,62)=4.D0*V(79)-4.D0*V(81)+QCy*VRR0(13,40)+2.D0*HfxZpE*VRR1(6,40)+WQy*VRR1(13,40)
      VRR0(13,63)=5.D0*r1x2E*VRR0(13,25)+QCy*VRR0(13,41)+2.D0*HfxZpE*VRR1(6,41)-5.D0*r1x2E*ZxZpE*VRR1(13,25)+WQy*VRR1(13,41)
      VRR0(13,64)=4.D0*r1x2E*VRR0(13,26)+QCx*VRR0(13,42)+HfxZpE*VRR1(7,42)-4.D0*r1x2E*ZxZpE*VRR1(13,26)+WQx*VRR1(13,42)
      VRR0(13,65)=3.D0*V(82)-3.D0*V(83)+QCx*VRR0(13,43)+HfxZpE*VRR1(7,43)+WQx*VRR1(13,43)
      VRR0(13,66)=V(85)+V(86)+V(88)+QCx*VRR0(13,44)+WQx*VRR1(13,44)
      VRR0(13,67)=V(49)+V(89)+V(90)+QCy*VRR0(13,44)+WQy*VRR1(13,44)
      VRR0(13,68)=3.D0*V(84)-3.D0*V(87)+QCy*VRR0(13,45)+2.D0*HfxZpE*VRR1(6,45)+WQy*VRR1(13,45)
      VRR0(13,69)=4.D0*r1x2E*VRR0(13,29)+QCy*VRR0(13,46)+2.D0*HfxZpE*VRR1(6,46)-4.D0*r1x2E*ZxZpE*VRR1(13,29)+WQy*VRR1(13,46)
      VRR0(13,70)=V(92)+V(94)+QCx*VRR0(13,47)+HfxZpE*VRR1(7,47)+WQx*VRR1(13,47)
      VRR0(13,71)=V(96)+V(97)+V(99)+QCx*VRR0(13,48)+WQx*VRR1(13,48)
      VRR0(13,72)=V(100)+V(101)-V(102)+QCx*VRR0(13,49)+WQx*VRR1(13,49)
      VRR0(13,73)=V(65)+V(96)+V(99)+QCy*VRR0(13,49)+WQy*VRR1(13,49)
      VRR0(13,74)=V(103)+V(104)+QCy*VRR0(13,50)+2.D0*HfxZpE*VRR1(6,50)+WQy*VRR1(13,50)
      VRR0(13,75)=2.D0*V(105)+V(106)-2.D0*V(107)+QCx*VRR0(13,51)+WQx*VRR1(13,51)
      VRR0(13,76)=V(89)+V(90)+QCz*VRR0(13,48)+WQz*VRR1(13,48)
      VRR0(13,77)=V(85)+V(88)+QCz*VRR0(13,49)+WQz*VRR1(13,49)
      VRR0(13,78)=2.D0*V(108)+2.D0*V(109)-2.D0*V(110)+QCy*VRR0(13,53)+WQy*VRR1(13,53)
      VRR0(13,79)=V(92)+V(94)+QCz*VRR0(13,51)+WQz*VRR1(13,51)
      VRR0(13,80)=3.D0*V(95)-3.D0*V(98)+QCz*VRR0(13,52)+WQz*VRR1(13,52)
      VRR0(13,81)=V(103)+V(104)+QCz*VRR0(13,53)+WQz*VRR1(13,53)
      VRR0(13,82)=4.D0*V(105)-4.D0*V(107)+QCz*VRR0(13,54)+WQz*VRR1(13,54)
      VRR0(13,83)=4.D0*V(108)-4.D0*V(110)+QCz*VRR0(13,55)+WQz*VRR1(13,55)
      VRR0(13,84)=5.D0*r1x2E*VRR0(13,35)+QCz*VRR0(13,56)-5.D0*r1x2E*ZxZpE*VRR1(13,35)+WQz*VRR1(13,56)
      VRR0(14,57)=5.D0*r1x2E*VRR0(14,21)+QCx*VRR0(14,36)-5.D0*r1x2E*ZxZpE*VRR1(14,21)+WQx*VRR1(14,36)
      VRR0(14,58)=4.D0*r1x2E*VRR0(14,22)+QCx*VRR0(14,37)-4.D0*r1x2E*ZxZpE*VRR1(14,22)+WQx*VRR1(14,37)
      VRR0(14,59)=V(112)+V(114)+QCx*VRR0(14,38)+WQx*VRR1(14,38)
      VRR0(14,60)=2.D0*V(115)-2.D0*V(116)+QCx*VRR0(14,39)+WQx*VRR1(14,39)
      VRR0(14,61)=3.D0*V(80)+V(112)+V(114)+QCy*VRR0(14,39)+WQy*VRR1(14,39)
      VRR0(14,62)=4.D0*V(115)-4.D0*V(116)+QCy*VRR0(14,40)+3.D0*HfxZpE*VRR1(7,40)+WQy*VRR1(14,40)
      VRR0(14,63)=5.D0*r1x2E*VRR0(14,25)+QCy*VRR0(14,41)+3.D0*HfxZpE*VRR1(7,41)-5.D0*r1x2E*ZxZpE*VRR1(14,25)+WQy*VRR1(14,41)
      VRR0(14,64)=4.D0*r1x2E*VRR0(14,26)+QCx*VRR0(14,42)-4.D0*r1x2E*ZxZpE*VRR1(14,26)+WQx*VRR1(14,42)
      VRR0(14,65)=3.D0*V(117)-3.D0*V(118)+QCx*VRR0(14,43)+WQx*VRR1(14,43)
      VRR0(14,66)=V(120)+V(122)+QCx*VRR0(14,44)+WQx*VRR1(14,44)
      VRR0(14,67)=3.D0*V(86)+V(123)+V(124)+QCy*VRR0(14,44)+WQy*VRR1(14,44)
      VRR0(14,68)=3.D0*V(119)-3.D0*V(121)+QCy*VRR0(14,45)+3.D0*HfxZpE*VRR1(7,45)+WQy*VRR1(14,45)
      VRR0(14,69)=4.D0*r1x2E*VRR0(14,29)+QCy*VRR0(14,46)+3.D0*HfxZpE*VRR1(7,46)-4.D0*r1x2E*ZxZpE*VRR1(14,29)+WQy*VRR1(14,46)
      VRR0(14,70)=V(126)+V(128)+QCx*VRR0(14,47)+WQx*VRR1(14,47)
      VRR0(14,71)=V(130)+V(132)+QCx*VRR0(14,48)+WQx*VRR1(14,48)
      VRR0(14,72)=2.D0*V(97)+2.D0*r1x2Z*VRR0(3,72)+PAy*VRR0(7,72)-2.D0*ExZpE*r1x2Z*VRR1(3,72)+WPy*VRR1(7,72)
      VRR0(14,73)=3.D0*V(101)+V(130)+V(132)+QCy*VRR0(14,49)+WQy*VRR1(14,49)
      VRR0(14,74)=V(134)+V(136)+QCy*VRR0(14,50)+3.D0*HfxZpE*VRR1(7,50)+WQy*VRR1(14,50)
      VRR0(14,75)=2.D0*V(137)-2.D0*V(138)+QCx*VRR0(14,51)+WQx*VRR1(14,51)
      VRR0(14,76)=V(123)+V(124)+QCz*VRR0(14,48)+WQz*VRR1(14,48)
      VRR0(14,77)=V(120)+V(122)+QCz*VRR0(14,49)+WQz*VRR1(14,49)
      VRR0(14,78)=2.D0*V(139)+3.D0*V(140)-2.D0*V(141)+QCy*VRR0(14,53)+WQy*VRR1(14,53)
      VRR0(14,79)=V(126)+V(128)+QCz*VRR0(14,51)+WQz*VRR1(14,51)
      VRR0(14,80)=3.D0*V(129)-3.D0*V(131)+QCz*VRR0(14,52)+WQz*VRR1(14,52)
      VRR0(14,81)=V(134)+V(136)+QCz*VRR0(14,53)+WQz*VRR1(14,53)
      VRR0(14,82)=4.D0*V(137)-4.D0*V(138)+QCz*VRR0(14,54)+WQz*VRR1(14,54)
      VRR0(14,83)=4.D0*V(139)-4.D0*V(141)+QCz*VRR0(14,55)+WQz*VRR1(14,55)
      VRR0(14,84)=5.D0*r1x2E*VRR0(14,35)+QCz*VRR0(14,56)-5.D0*r1x2E*ZxZpE*VRR1(14,35)+WQz*VRR1(14,56)
      VRR0(15,57)=5.D0*r1x2E*VRR0(15,21)+QCx*VRR0(15,36)+2.D0*HfxZpE*VRR1(8,36)-5.D0*r1x2E*ZxZpE*VRR1(15,21)+WQx*VRR1(15,36)
      VRR0(15,58)=4.D0*r1x2E*VRR0(15,22)+QCx*VRR0(15,37)+2.D0*HfxZpE*VRR1(8,37)-4.D0*r1x2E*ZxZpE*VRR1(15,22)+WQx*VRR1(15,37)
      VRR0(15,59)=V(143)+V(145)+QCx*VRR0(15,38)+2.D0*HfxZpE*VRR1(8,38)+WQx*VRR1(15,38)
      VRR0(15,60)=2.D0*V(146)+2.D0*V(147)-2.D0*V(148)+QCx*VRR0(15,39)+WQx*VRR1(15,39)
      VRR0(15,61)=V(143)+V(145)+QCy*VRR0(15,39)+WQy*VRR1(15,39)
      VRR0(15,62)=4.D0*V(146)-4.D0*V(148)+QCy*VRR0(15,40)+WQy*VRR1(15,40)
      VRR0(15,63)=5.D0*r1x2E*VRR0(15,25)+QCy*VRR0(15,41)-5.D0*r1x2E*ZxZpE*VRR1(15,25)+WQy*VRR1(15,41)
      VRR0(15,64)=4.D0*r1x2E*VRR0(15,26)+QCx*VRR0(15,42)+2.D0*HfxZpE*VRR1(8,42)-4.D0*r1x2E*ZxZpE*VRR1(15,26)+WQx*VRR1(15,42)
      VRR0(15,65)=3.D0*V(149)-3.D0*V(150)+QCx*VRR0(15,43)+2.D0*HfxZpE*VRR1(8,43)+WQx*VRR1(15,43)
      VRR0(15,66)=V(152)+2.D0*V(153)+V(155)+QCx*VRR0(15,44)+WQx*VRR1(15,44)
      VRR0(15,67)=V(156)+V(157)+QCy*VRR0(15,44)+WQy*VRR1(15,44)
      VRR0(15,68)=3.D0*V(151)-3.D0*V(154)+QCy*VRR0(15,45)+WQy*VRR1(15,45)
      VRR0(15,69)=4.D0*r1x2E*VRR0(15,29)+QCy*VRR0(15,46)-4.D0*r1x2E*ZxZpE*VRR1(15,29)+WQy*VRR1(15,46)
      VRR0(15,70)=V(159)+V(161)+QCx*VRR0(15,47)+2.D0*HfxZpE*VRR1(8,47)+WQx*VRR1(15,47)
      VRR0(15,71)=V(163)+V(165)+V(167)+QCx*VRR0(15,48)+WQx*VRR1(15,48)
      VRR0(15,72)=V(168)+V(170)-V(171)+QCx*VRR0(15,49)+WQx*VRR1(15,49)
      VRR0(15,73)=V(163)+V(167)+QCy*VRR0(15,49)+WQy*VRR1(15,49)
      VRR0(15,74)=V(172)+V(173)+QCy*VRR0(15,50)+WQy*VRR1(15,50)
      VRR0(15,75)=2.D0*V(174)+V(176)-2.D0*V(177)+QCx*VRR0(15,51)+WQx*VRR1(15,51)
      VRR0(15,76)=V(23)+V(156)+V(157)+QCz*VRR0(15,48)+WQz*VRR1(15,48)
      VRR0(15,77)=V(26)+V(152)+V(155)+QCz*VRR0(15,49)+WQz*VRR1(15,49)
      VRR0(15,78)=2.D0*V(178)-2.D0*V(179)+QCy*VRR0(15,53)+WQy*VRR1(15,53)
      VRR0(15,79)=V(32)+V(159)+V(161)+QCz*VRR0(15,51)+WQz*VRR1(15,51)
      VRR0(15,80)=3.D0*V(162)-3.D0*V(166)+QCz*VRR0(15,52)+HfxZpE*VRR1(5,52)+WQz*VRR1(15,52)
      VRR0(15,81)=V(73)+V(172)+V(173)+QCz*VRR0(15,53)+WQz*VRR1(15,53)
      VRR0(15,82)=4.D0*V(174)-4.D0*V(177)+QCz*VRR0(15,54)+HfxZpE*VRR1(5,54)+WQz*VRR1(15,54)
      VRR0(15,83)=4.D0*V(178)-4.D0*V(179)+QCz*VRR0(15,55)+HfxZpE*VRR1(5,55)+WQz*VRR1(15,55)
      VRR0(15,84)=5.D0*r1x2E*VRR0(15,35)+QCz*VRR0(15,56)+HfxZpE*VRR1(5,56)-5.D0*r1x2E*ZxZpE*VRR1(15,35)+WQz*VRR1(15,56)
      VRR0(16,57)=5.D0*r1x2E*VRR0(16,21)+QCx*VRR0(16,36)+HfxZpE*VRR1(9,36)-5.D0*r1x2E*ZxZpE*VRR1(16,21)+WQx*VRR1(16,36)
      VRR0(16,58)=4.D0*r1x2E*VRR0(16,22)+QCx*VRR0(16,37)+HfxZpE*VRR1(9,37)-4.D0*r1x2E*ZxZpE*VRR1(16,22)+WQx*VRR1(16,37)
      VRR0(16,59)=V(181)+V(183)+QCx*VRR0(16,38)+HfxZpE*VRR1(9,38)+WQx*VRR1(16,38)
      VRR0(16,60)=2.D0*V(184)+V(185)-2.D0*V(186)+QCx*VRR0(16,39)+WQx*VRR1(16,39)
      VRR0(16,61)=V(147)+V(181)+V(183)+QCy*VRR0(16,39)+WQy*VRR1(16,39)
      VRR0(16,62)=4.D0*V(184)-4.D0*V(186)+QCy*VRR0(16,40)+HfxZpE*VRR1(8,40)+WQy*VRR1(16,40)
      VRR0(16,63)=5.D0*r1x2E*VRR0(16,25)+QCy*VRR0(16,41)+HfxZpE*VRR1(8,41)-5.D0*r1x2E*ZxZpE*VRR1(16,25)+WQy*VRR1(16,41)
      VRR0(16,64)=4.D0*r1x2E*VRR0(16,26)+QCx*VRR0(16,42)+HfxZpE*VRR1(9,42)-4.D0*r1x2E*ZxZpE*VRR1(16,26)+WQx*VRR1(16,42)
      VRR0(16,65)=3.D0*V(187)-3.D0*V(188)+QCx*VRR0(16,43)+HfxZpE*VRR1(9,43)+WQx*VRR1(16,43)
      VRR0(16,66)=V(190)+V(191)+V(193)+QCx*VRR0(16,44)+WQx*VRR1(16,44)
      VRR0(16,67)=V(153)+V(194)+V(195)+QCy*VRR0(16,44)+WQy*VRR1(16,44)
      VRR0(16,68)=3.D0*V(189)-3.D0*V(192)+QCy*VRR0(16,45)+HfxZpE*VRR1(8,45)+WQy*VRR1(16,45)
      VRR0(16,69)=4.D0*r1x2E*VRR0(16,29)+QCy*VRR0(16,46)+HfxZpE*VRR1(8,46)-4.D0*r1x2E*ZxZpE*VRR1(16,29)+WQy*VRR1(16,46)
      VRR0(16,70)=V(197)+V(199)+QCx*VRR0(16,47)+HfxZpE*VRR1(9,47)+WQx*VRR1(16,47)
      VRR0(16,71)=V(201)+V(202)+V(204)+QCx*VRR0(16,48)+WQx*VRR1(16,48)
      VRR0(16,72)=V(205)+V(206)-V(207)+QCx*VRR0(16,49)+WQx*VRR1(16,49)
      VRR0(16,73)=V(169)+V(201)+V(204)+QCy*VRR0(16,49)+WQy*VRR1(16,49)
      VRR0(16,74)=V(208)+V(209)+QCy*VRR0(16,50)+HfxZpE*VRR1(8,50)+WQy*VRR1(16,50)
      VRR0(16,75)=2.D0*V(210)+V(211)-2.D0*V(212)+QCx*VRR0(16,51)+WQx*VRR1(16,51)
      VRR0(16,76)=V(60)+V(194)+V(195)+QCz*VRR0(16,48)+WQz*VRR1(16,48)
      VRR0(16,77)=V(64)+V(190)+V(193)+QCz*VRR0(16,49)+WQz*VRR1(16,49)
      VRR0(16,78)=2.D0*V(213)+V(214)-2.D0*V(215)+QCy*VRR0(16,53)+WQy*VRR1(16,53)
      VRR0(16,79)=V(70)+V(197)+V(199)+QCz*VRR0(16,51)+WQz*VRR1(16,51)
      VRR0(16,80)=3.D0*V(200)-3.D0*V(203)+QCz*VRR0(16,52)+HfxZpE*VRR1(6,52)+WQz*VRR1(16,52)
      VRR0(16,81)=V(109)+V(208)+V(209)+QCz*VRR0(16,53)+WQz*VRR1(16,53)
      VRR0(16,82)=4.D0*V(210)-4.D0*V(212)+QCz*VRR0(16,54)+HfxZpE*VRR1(6,54)+WQz*VRR1(16,54)
      VRR0(16,83)=4.D0*V(213)-4.D0*V(215)+QCz*VRR0(16,55)+HfxZpE*VRR1(6,55)+WQz*VRR1(16,55)
      VRR0(16,84)=5.D0*r1x2E*VRR0(16,35)+QCz*VRR0(16,56)+HfxZpE*VRR1(6,56)-5.D0*r1x2E*ZxZpE*VRR1(16,35)+WQz*VRR1(16,56)
      VRR0(17,57)=5.D0*r1x2E*VRR0(17,21)+QCx*VRR0(17,36)-5.D0*r1x2E*ZxZpE*VRR1(17,21)+WQx*VRR1(17,36)
      VRR0(17,58)=4.D0*r1x2E*VRR0(17,22)+QCx*VRR0(17,37)-4.D0*r1x2E*ZxZpE*VRR1(17,22)+WQx*VRR1(17,37)
      VRR0(17,59)=V(217)+V(219)+QCx*VRR0(17,38)+WQx*VRR1(17,38)
      VRR0(17,60)=2.D0*V(220)-2.D0*V(221)+QCx*VRR0(17,39)+WQx*VRR1(17,39)
      VRR0(17,61)=2.D0*V(185)+V(217)+V(219)+QCy*VRR0(17,39)+WQy*VRR1(17,39)
      VRR0(17,62)=4.D0*V(220)-4.D0*V(221)+QCy*VRR0(17,40)+2.D0*HfxZpE*VRR1(9,40)+WQy*VRR1(17,40)
      VRR0(17,63)=5.D0*r1x2E*VRR0(17,25)+QCy*VRR0(17,41)+2.D0*HfxZpE*VRR1(9,41)-5.D0*r1x2E*ZxZpE*VRR1(17,25)+WQy*VRR1(17,41)
      VRR0(17,64)=4.D0*r1x2E*VRR0(17,26)+QCx*VRR0(17,42)-4.D0*r1x2E*ZxZpE*VRR1(17,26)+WQx*VRR1(17,42)
      VRR0(17,65)=3.D0*V(222)-3.D0*V(223)+QCx*VRR0(17,43)+WQx*VRR1(17,43)
      VRR0(17,66)=V(225)+V(227)+QCx*VRR0(17,44)+WQx*VRR1(17,44)
      VRR0(17,67)=2.D0*V(191)+V(228)+V(229)+QCy*VRR0(17,44)+WQy*VRR1(17,44)
      VRR0(17,68)=3.D0*V(224)-3.D0*V(226)+QCy*VRR0(17,45)+2.D0*HfxZpE*VRR1(9,45)+WQy*VRR1(17,45)
      VRR0(17,69)=4.D0*r1x2E*VRR0(17,29)+QCy*VRR0(17,46)+2.D0*HfxZpE*VRR1(9,46)-4.D0*r1x2E*ZxZpE*VRR1(17,29)+WQy*VRR1(17,46)
      VRR0(17,70)=V(231)+V(233)+QCx*VRR0(17,47)+WQx*VRR1(17,47)
      VRR0(17,71)=V(235)+V(237)+QCx*VRR0(17,48)+WQx*VRR1(17,48)
      VRR0(17,72)=V(238)-V(239)+QCx*VRR0(17,49)+WQx*VRR1(17,49)
      VRR0(17,73)=V(235)+V(237)+V(240)+QCy*VRR0(17,49)+WQy*VRR1(17,49)
      VRR0(17,74)=V(241)+V(242)+QCy*VRR0(17,50)+2.D0*HfxZpE*VRR1(9,50)+WQy*VRR1(17,50)
      VRR0(17,75)=2.D0*V(243)-2.D0*V(244)+QCx*VRR0(17,51)+WQx*VRR1(17,51)
      VRR0(17,76)=V(97)+V(228)+V(229)+QCz*VRR0(17,48)+WQz*VRR1(17,48)
      VRR0(17,77)=V(101)+V(225)+V(227)+QCz*VRR0(17,49)+WQz*VRR1(17,49)
      VRR0(17,78)=2.D0*V(245)+V(247)-2.D0*V(248)+QCy*VRR0(17,53)+WQy*VRR1(17,53)
      VRR0(17,79)=V(106)+V(231)+V(233)+QCz*VRR0(17,51)+WQz*VRR1(17,51)
      VRR0(17,80)=3.D0*V(234)-3.D0*V(236)+QCz*VRR0(17,52)+HfxZpE*VRR1(7,52)+WQz*VRR1(17,52)
      VRR0(17,81)=V(140)+V(241)+V(242)+QCz*VRR0(17,53)+WQz*VRR1(17,53)
      VRR0(17,82)=4.D0*V(243)-4.D0*V(244)+QCz*VRR0(17,54)+HfxZpE*VRR1(7,54)+WQz*VRR1(17,54)
      VRR0(17,83)=4.D0*V(245)-4.D0*V(248)+QCz*VRR0(17,55)+HfxZpE*VRR1(7,55)+WQz*VRR1(17,55)
      VRR0(17,84)=5.D0*r1x2E*VRR0(17,35)+QCz*VRR0(17,56)+HfxZpE*VRR1(7,56)-5.D0*r1x2E*ZxZpE*VRR1(17,35)+WQz*VRR1(17,56)
      VRR0(18,57)=5.D0*r1x2E*VRR0(18,21)+QCx*VRR0(18,36)+HfxZpE*VRR1(10,36)-5.D0*r1x2E*ZxZpE*VRR1(18,21)+WQx*VRR1(18,36)
      VRR0(18,58)=4.D0*r1x2E*VRR0(18,22)+QCx*VRR0(18,37)+HfxZpE*VRR1(10,37)-4.D0*r1x2E*ZxZpE*VRR1(18,22)+WQx*VRR1(18,37)
      VRR0(18,59)=V(250)+V(252)+QCx*VRR0(18,38)+HfxZpE*VRR1(10,38)+WQx*VRR1(18,38)
      VRR0(18,60)=2.D0*V(253)+V(254)-2.D0*V(255)+QCx*VRR0(18,39)+WQx*VRR1(18,39)
      VRR0(18,61)=V(250)+V(252)+QCy*VRR0(18,39)+WQy*VRR1(18,39)
      VRR0(18,62)=4.D0*V(253)-4.D0*V(255)+QCy*VRR0(18,40)+WQy*VRR1(18,40)
      VRR0(18,63)=5.D0*r1x2E*VRR0(18,25)+QCy*VRR0(18,41)-5.D0*r1x2E*ZxZpE*VRR1(18,25)+WQy*VRR1(18,41)
      VRR0(18,64)=4.D0*r1x2E*VRR0(18,26)+QCx*VRR0(18,42)+HfxZpE*VRR1(10,42)-4.D0*r1x2E*ZxZpE*VRR1(18,26)+WQx*VRR1(18,42)
      VRR0(18,65)=3.D0*V(256)-3.D0*V(257)+QCx*VRR0(18,43)+HfxZpE*VRR1(10,43)+WQx*VRR1(18,43)
      VRR0(18,66)=V(259)+V(260)+V(262)+QCx*VRR0(18,44)+WQx*VRR1(18,44)
      VRR0(18,67)=V(263)+V(264)+QCy*VRR0(18,44)+WQy*VRR1(18,44)
      VRR0(18,68)=3.D0*V(258)-3.D0*V(261)+QCy*VRR0(18,45)+WQy*VRR1(18,45)
      VRR0(18,69)=4.D0*r1x2E*VRR0(18,29)+QCy*VRR0(18,46)-4.D0*r1x2E*ZxZpE*VRR1(18,29)+WQy*VRR1(18,46)
      VRR0(18,70)=V(266)+V(268)+QCx*VRR0(18,47)+HfxZpE*VRR1(10,47)+WQx*VRR1(18,47)
      VRR0(18,71)=V(270)+V(271)+V(273)+QCx*VRR0(18,48)+WQx*VRR1(18,48)
      VRR0(18,72)=V(274)+V(275)-V(276)+QCx*VRR0(18,49)+WQx*VRR1(18,49)
      VRR0(18,73)=V(270)+V(273)+QCy*VRR0(18,49)+WQy*VRR1(18,49)
      VRR0(18,74)=V(277)+V(278)+QCy*VRR0(18,50)+WQy*VRR1(18,50)
      VRR0(18,75)=2.D0*V(279)+V(280)-2.D0*V(281)+QCx*VRR0(18,51)+WQx*VRR1(18,51)
      VRR0(18,76)=V(165)+V(263)+V(264)+QCz*VRR0(18,48)+WQz*VRR1(18,48)
      VRR0(18,77)=V(170)+V(259)+V(262)+QCz*VRR0(18,49)+WQz*VRR1(18,49)
      VRR0(18,78)=2.D0*V(282)-2.D0*V(283)+QCy*VRR0(18,53)+WQy*VRR1(18,53)
      VRR0(18,79)=V(176)+V(266)+V(268)+QCz*VRR0(18,51)+WQz*VRR1(18,51)
      VRR0(18,80)=3.D0*V(269)-3.D0*V(272)+QCz*VRR0(18,52)+2.D0*HfxZpE*VRR1(8,52)+WQz*VRR1(18,52)
      VRR0(18,81)=2.D0*V(214)+V(277)+V(278)+QCz*VRR0(18,53)+WQz*VRR1(18,53)
      VRR0(18,82)=4.D0*V(279)-4.D0*V(281)+QCz*VRR0(18,54)+2.D0*HfxZpE*VRR1(8,54)+WQz*VRR1(18,54)
      VRR0(18,83)=4.D0*V(282)-4.D0*V(283)+QCz*VRR0(18,55)+2.D0*HfxZpE*VRR1(8,55)+WQz*VRR1(18,55)
      VRR0(18,84)=5.D0*r1x2E*VRR0(18,35)+QCz*VRR0(18,56)+2.D0*HfxZpE*VRR1(8,56)-5.D0*r1x2E*ZxZpE*VRR1(18,35)+WQz*VRR1(18,56)
      VRR0(19,57)=5.D0*r1x2E*VRR0(19,21)+QCx*VRR0(19,36)-5.D0*r1x2E*ZxZpE*VRR1(19,21)+WQx*VRR1(19,36)
      VRR0(19,58)=4.D0*r1x2E*VRR0(19,22)+QCx*VRR0(19,37)-4.D0*r1x2E*ZxZpE*VRR1(19,22)+WQx*VRR1(19,37)
      VRR0(19,59)=V(285)+V(287)+QCx*VRR0(19,38)+WQx*VRR1(19,38)
      VRR0(19,60)=2.D0*V(288)-2.D0*V(289)+QCx*VRR0(19,39)+WQx*VRR1(19,39)
      VRR0(19,61)=V(254)+V(285)+V(287)+QCy*VRR0(19,39)+WQy*VRR1(19,39)
      VRR0(19,62)=4.D0*V(288)-4.D0*V(289)+QCy*VRR0(19,40)+HfxZpE*VRR1(10,40)+WQy*VRR1(19,40)
      VRR0(19,63)=5.D0*r1x2E*VRR0(19,25)+QCy*VRR0(19,41)+HfxZpE*VRR1(10,41)-5.D0*r1x2E*ZxZpE*VRR1(19,25)+WQy*VRR1(19,41)
      VRR0(19,64)=4.D0*r1x2E*VRR0(19,26)+QCx*VRR0(19,42)-4.D0*r1x2E*ZxZpE*VRR1(19,26)+WQx*VRR1(19,42)
      VRR0(19,65)=3.D0*V(290)-3.D0*V(291)+QCx*VRR0(19,43)+WQx*VRR1(19,43)
      VRR0(19,66)=V(293)+V(295)+QCx*VRR0(19,44)+WQx*VRR1(19,44)
      VRR0(19,67)=V(260)+V(296)+V(297)+QCy*VRR0(19,44)+WQy*VRR1(19,44)
      VRR0(19,68)=3.D0*V(292)-3.D0*V(294)+QCy*VRR0(19,45)+HfxZpE*VRR1(10,45)+WQy*VRR1(19,45)
      VRR0(19,69)=4.D0*r1x2E*VRR0(19,29)+QCy*VRR0(19,46)+HfxZpE*VRR1(10,46)-4.D0*r1x2E*ZxZpE*VRR1(19,29)+WQy*VRR1(19,46)
      VRR0(19,70)=V(299)+V(301)+QCx*VRR0(19,47)+WQx*VRR1(19,47)
      VRR0(19,71)=V(303)+V(305)+QCx*VRR0(19,48)+WQx*VRR1(19,48)
      VRR0(19,72)=V(306)-V(307)+QCx*VRR0(19,49)+WQx*VRR1(19,49)
      VRR0(19,73)=V(275)+V(303)+V(305)+QCy*VRR0(19,49)+WQy*VRR1(19,49)
      VRR0(19,74)=V(308)+V(309)+QCy*VRR0(19,50)+HfxZpE*VRR1(10,50)+WQy*VRR1(19,50)
      VRR0(19,75)=2.D0*V(310)-2.D0*V(311)+QCx*VRR0(19,51)+WQx*VRR1(19,51)
      VRR0(19,76)=2.D0*V(202)+V(296)+V(297)+QCz*VRR0(19,48)+WQz*VRR1(19,48)
      VRR0(19,77)=V(240)+V(293)+V(295)+QCz*VRR0(19,49)+WQz*VRR1(19,49)
      VRR0(19,78)=2.D0*V(312)+V(313)-2.D0*V(314)+QCy*VRR0(19,53)+WQy*VRR1(19,53)
      VRR0(19,79)=2.D0*V(211)+V(299)+V(301)+QCz*VRR0(19,51)+WQz*VRR1(19,51)
      VRR0(19,80)=3.D0*V(302)-3.D0*V(304)+QCz*VRR0(19,52)+2.D0*HfxZpE*VRR1(9,52)+WQz*VRR1(19,52)
      VRR0(19,81)=V(247)+V(308)+V(309)+QCz*VRR0(19,53)+WQz*VRR1(19,53)
      VRR0(19,82)=4.D0*V(310)-4.D0*V(311)+QCz*VRR0(19,54)+2.D0*HfxZpE*VRR1(9,54)+WQz*VRR1(19,54)
      VRR0(19,83)=4.D0*V(312)-4.D0*V(314)+QCz*VRR0(19,55)+2.D0*HfxZpE*VRR1(9,55)+WQz*VRR1(19,55)
      VRR0(19,84)=5.D0*r1x2E*VRR0(19,35)+QCz*VRR0(19,56)+2.D0*HfxZpE*VRR1(9,56)-5.D0*r1x2E*ZxZpE*VRR1(19,35)+WQz*VRR1(19,56)
      VRR0(20,57)=5.D0*r1x2E*VRR0(20,21)+QCx*VRR0(20,36)-5.D0*r1x2E*ZxZpE*VRR1(20,21)+WQx*VRR1(20,36)
      VRR0(20,58)=4.D0*r1x2E*VRR0(20,22)+QCx*VRR0(20,37)-4.D0*r1x2E*ZxZpE*VRR1(20,22)+WQx*VRR1(20,37)
      VRR0(20,59)=V(316)+V(318)+QCx*VRR0(20,38)+WQx*VRR1(20,38)
      VRR0(20,60)=2.D0*V(319)-2.D0*V(320)+QCx*VRR0(20,39)+WQx*VRR1(20,39)
      VRR0(20,61)=V(316)+V(318)+QCy*VRR0(20,39)+WQy*VRR1(20,39)
      VRR0(20,62)=4.D0*V(319)-4.D0*V(320)+QCy*VRR0(20,40)+WQy*VRR1(20,40)
      VRR0(20,63)=5.D0*r1x2E*VRR0(20,25)+QCy*VRR0(20,41)-5.D0*r1x2E*ZxZpE*VRR1(20,25)+WQy*VRR1(20,41)
      VRR0(20,64)=4.D0*r1x2E*VRR0(20,26)+QCx*VRR0(20,42)-4.D0*r1x2E*ZxZpE*VRR1(20,26)+WQx*VRR1(20,42)
      VRR0(20,65)=3.D0*V(321)-3.D0*V(322)+QCx*VRR0(20,43)+WQx*VRR1(20,43)
      VRR0(20,66)=V(324)+V(326)+QCx*VRR0(20,44)+WQx*VRR1(20,44)
      VRR0(20,67)=V(327)+V(328)+QCy*VRR0(20,44)+WQy*VRR1(20,44)
      VRR0(20,68)=3.D0*V(323)-3.D0*V(325)+QCy*VRR0(20,45)+WQy*VRR1(20,45)
      VRR0(20,69)=4.D0*r1x2E*VRR0(20,29)+QCy*VRR0(20,46)-4.D0*r1x2E*ZxZpE*VRR1(20,29)+WQy*VRR1(20,46)
      VRR0(20,70)=V(330)+V(332)+QCx*VRR0(20,47)+WQx*VRR1(20,47)
      VRR0(20,71)=V(334)+V(336)+QCx*VRR0(20,48)+WQx*VRR1(20,48)
      VRR0(20,72)=2.D0*V(260)+2.D0*r1x2Z*VRR0(4,72)+PAz*VRR0(10,72)-2.D0*ExZpE*r1x2Z*VRR1(4,72)+WPz*VRR1(10,72)
      VRR0(20,73)=V(334)+V(336)+QCy*VRR0(20,49)+WQy*VRR1(20,49)
      VRR0(20,74)=V(338)+V(340)+QCy*VRR0(20,50)+WQy*VRR1(20,50)
      VRR0(20,75)=2.D0*V(341)-2.D0*V(342)+QCx*VRR0(20,51)+WQx*VRR1(20,51)
      VRR0(20,76)=3.D0*V(271)+V(327)+V(328)+QCz*VRR0(20,48)+WQz*VRR1(20,48)
      VRR0(20,77)=3.D0*V(275)+V(324)+V(326)+QCz*VRR0(20,49)+WQz*VRR1(20,49)
      VRR0(20,78)=2.D0*V(343)-2.D0*V(344)+QCy*VRR0(20,53)+WQy*VRR1(20,53)
      VRR0(20,79)=3.D0*V(280)+V(330)+V(332)+QCz*VRR0(20,51)+WQz*VRR1(20,51)
      VRR0(20,80)=3.D0*V(333)-3.D0*V(335)+QCz*VRR0(20,52)+3.D0*HfxZpE*VRR1(10,52)+WQz*VRR1(20,52)
      VRR0(20,81)=3.D0*V(313)+V(338)+V(340)+QCz*VRR0(20,53)+WQz*VRR1(20,53)
      VRR0(20,82)=4.D0*V(341)-4.D0*V(342)+QCz*VRR0(20,54)+3.D0*HfxZpE*VRR1(10,54)+WQz*VRR1(20,54)
      VRR0(20,83)=4.D0*V(343)-4.D0*V(344)+QCz*VRR0(20,55)+3.D0*HfxZpE*VRR1(10,55)+WQz*VRR1(20,55)
      VRR0(20,84)=5.D0*r1x2E*VRR0(20,35)+QCz*VRR0(20,56)+3.D0*HfxZpE*VRR1(10,56)-5.D0*r1x2E*ZxZpE*VRR1(20,35)+WQz*VRR1(20,56)
END SUBROUTINE VRRf0i0
SUBROUTINE MVRRf0i0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(11,57)=QCx*VS0(11,36)+WQx*VS1(11,36)-r1x2E*VR1(11,36)&
   +5D0*r1x2E*(VS0(11,21)-ZxZpE*VS1(11,21))&
   +3D0*HfxZpE*VS1(5,36)
VS0(11,58)=QCx*VS0(11,37)+WQx*VS1(11,37)-r1x2E*VR1(11,37)&
   +4D0*r1x2E*(VS0(11,22)-ZxZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(5,37)
VS0(11,59)=QCx*VS0(11,38)+WQx*VS1(11,38)-r1x2E*VR1(11,38)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))&
   +3D0*HfxZpE*VS1(5,38)
VS0(11,60)=QCx*VS0(11,39)+WQx*VS1(11,39)-r1x2E*VR1(11,39)&
   +2D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))&
   +3D0*HfxZpE*VS1(5,39)
VS0(11,61)=QCy*VS0(11,39)+WQy*VS1(11,39)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))
VS0(11,62)=QCy*VS0(11,40)+WQy*VS1(11,40)&
   +4D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))
VS0(11,63)=QCy*VS0(11,41)+WQy*VS1(11,41)&
   +5D0*r1x2E*(VS0(11,25)-ZxZpE*VS1(11,25))
VS0(11,64)=QCx*VS0(11,42)+WQx*VS1(11,42)-r1x2E*VR1(11,42)&
   +4D0*r1x2E*(VS0(11,26)-ZxZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(5,42)
VS0(11,65)=QCx*VS0(11,43)+WQx*VS1(11,43)-r1x2E*VR1(11,43)&
   +3D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))&
   +3D0*HfxZpE*VS1(5,43)
VS0(11,66)=QCx*VS0(11,44)+WQx*VS1(11,44)-r1x2E*VR1(11,44)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))&
   +3D0*HfxZpE*VS1(5,44)
VS0(11,67)=QCy*VS0(11,44)+WQy*VS1(11,44)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,68)=QCy*VS0(11,45)+WQy*VS1(11,45)&
   +3D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,69)=QCy*VS0(11,46)+WQy*VS1(11,46)&
   +4D0*r1x2E*(VS0(11,29)-ZxZpE*VS1(11,29))
VS0(11,70)=QCx*VS0(11,47)+WQx*VS1(11,47)-r1x2E*VR1(11,47)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))&
   +3D0*HfxZpE*VS1(5,47)
VS0(11,71)=QCx*VS0(11,48)+WQx*VS1(11,48)-r1x2E*VR1(11,48)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))&
   +3D0*HfxZpE*VS1(5,48)
VS0(11,72)=QCx*VS0(11,49)+WQx*VS1(11,49)-r1x2E*VR1(11,49)&
   +r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))&
   +3D0*HfxZpE*VS1(5,49)
VS0(11,73)=QCy*VS0(11,49)+WQy*VS1(11,49)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,74)=QCy*VS0(11,50)+WQy*VS1(11,50)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,75)=QCx*VS0(11,51)+WQx*VS1(11,51)-r1x2E*VR1(11,51)&
   +2D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))&
   +3D0*HfxZpE*VS1(5,51)
VS0(11,76)=QCz*VS0(11,48)+WQz*VS1(11,48)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,77)=QCz*VS0(11,49)+WQz*VS1(11,49)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,78)=QCy*VS0(11,53)+WQy*VS1(11,53)&
   +2D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,79)=QCz*VS0(11,51)+WQz*VS1(11,51)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))
VS0(11,80)=QCz*VS0(11,52)+WQz*VS1(11,52)&
   +3D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,81)=QCz*VS0(11,53)+WQz*VS1(11,53)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,82)=QCz*VS0(11,54)+WQz*VS1(11,54)&
   +4D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))
VS0(11,83)=QCz*VS0(11,55)+WQz*VS1(11,55)&
   +4D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,84)=QCz*VS0(11,56)+WQz*VS1(11,56)&
   +5D0*r1x2E*(VS0(11,35)-ZxZpE*VS1(11,35))
VS0(12,57)=QCx*VS0(12,36)+WQx*VS1(12,36)-r1x2E*VR1(12,36)&
   +5D0*r1x2E*(VS0(12,21)-ZxZpE*VS1(12,21))&
   +2D0*HfxZpE*VS1(6,36)
VS0(12,58)=QCx*VS0(12,37)+WQx*VS1(12,37)-r1x2E*VR1(12,37)&
   +4D0*r1x2E*(VS0(12,22)-ZxZpE*VS1(12,22))&
   +2D0*HfxZpE*VS1(6,37)
VS0(12,59)=QCx*VS0(12,38)+WQx*VS1(12,38)-r1x2E*VR1(12,38)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(6,38)
VS0(12,60)=QCx*VS0(12,39)+WQx*VS1(12,39)-r1x2E*VR1(12,39)&
   +2D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +2D0*HfxZpE*VS1(6,39)
VS0(12,61)=QCy*VS0(12,39)+WQy*VS1(12,39)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +HfxZpE*VS1(5,39)
VS0(12,62)=QCy*VS0(12,40)+WQy*VS1(12,40)&
   +4D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +HfxZpE*VS1(5,40)
VS0(12,63)=QCy*VS0(12,41)+WQy*VS1(12,41)&
   +5D0*r1x2E*(VS0(12,25)-ZxZpE*VS1(12,25))&
   +HfxZpE*VS1(5,41)
VS0(12,64)=QCx*VS0(12,42)+WQx*VS1(12,42)-r1x2E*VR1(12,42)&
   +4D0*r1x2E*(VS0(12,26)-ZxZpE*VS1(12,26))&
   +2D0*HfxZpE*VS1(6,42)
VS0(12,65)=QCx*VS0(12,43)+WQx*VS1(12,43)-r1x2E*VR1(12,43)&
   +3D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(6,43)
VS0(12,66)=QCx*VS0(12,44)+WQx*VS1(12,44)-r1x2E*VR1(12,44)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(6,44)
VS0(12,67)=QCy*VS0(12,44)+WQy*VS1(12,44)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +HfxZpE*VS1(5,44)
VS0(12,68)=QCy*VS0(12,45)+WQy*VS1(12,45)&
   +3D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +HfxZpE*VS1(5,45)
VS0(12,69)=QCy*VS0(12,46)+WQy*VS1(12,46)&
   +4D0*r1x2E*(VS0(12,29)-ZxZpE*VS1(12,29))&
   +HfxZpE*VS1(5,46)
VS0(12,70)=QCx*VS0(12,47)+WQx*VS1(12,47)-r1x2E*VR1(12,47)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(6,47)
VS0(12,71)=QCx*VS0(12,48)+WQx*VS1(12,48)-r1x2E*VR1(12,48)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +2D0*HfxZpE*VS1(6,48)
VS0(12,72)=QCx*VS0(12,49)+WQx*VS1(12,49)-r1x2E*VR1(12,49)&
   +r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(6,49)
VS0(12,73)=QCy*VS0(12,49)+WQy*VS1(12,49)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +HfxZpE*VS1(5,49)
VS0(12,74)=QCy*VS0(12,50)+WQy*VS1(12,50)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +HfxZpE*VS1(5,50)
VS0(12,75)=QCx*VS0(12,51)+WQx*VS1(12,51)-r1x2E*VR1(12,51)&
   +2D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))&
   +2D0*HfxZpE*VS1(6,51)
VS0(12,76)=QCz*VS0(12,48)+WQz*VS1(12,48)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))
VS0(12,77)=QCz*VS0(12,49)+WQz*VS1(12,49)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))
VS0(12,78)=QCy*VS0(12,53)+WQy*VS1(12,53)&
   +2D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))&
   +HfxZpE*VS1(5,53)
VS0(12,79)=QCz*VS0(12,51)+WQz*VS1(12,51)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))
VS0(12,80)=QCz*VS0(12,52)+WQz*VS1(12,52)&
   +3D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))
VS0(12,81)=QCz*VS0(12,53)+WQz*VS1(12,53)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))
VS0(12,82)=QCz*VS0(12,54)+WQz*VS1(12,54)&
   +4D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))
VS0(12,83)=QCz*VS0(12,55)+WQz*VS1(12,55)&
   +4D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))
VS0(12,84)=QCz*VS0(12,56)+WQz*VS1(12,56)&
   +5D0*r1x2E*(VS0(12,35)-ZxZpE*VS1(12,35))
VS0(13,57)=QCx*VS0(13,36)+WQx*VS1(13,36)-r1x2E*VR1(13,36)&
   +5D0*r1x2E*(VS0(13,21)-ZxZpE*VS1(13,21))&
   +HfxZpE*VS1(7,36)
VS0(13,58)=QCx*VS0(13,37)+WQx*VS1(13,37)-r1x2E*VR1(13,37)&
   +4D0*r1x2E*(VS0(13,22)-ZxZpE*VS1(13,22))&
   +HfxZpE*VS1(7,37)
VS0(13,59)=QCx*VS0(13,38)+WQx*VS1(13,38)-r1x2E*VR1(13,38)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +HfxZpE*VS1(7,38)
VS0(13,60)=QCx*VS0(13,39)+WQx*VS1(13,39)-r1x2E*VR1(13,39)&
   +2D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +HfxZpE*VS1(7,39)
VS0(13,61)=QCy*VS0(13,39)+WQy*VS1(13,39)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(6,39)
VS0(13,62)=QCy*VS0(13,40)+WQy*VS1(13,40)&
   +4D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +2D0*HfxZpE*VS1(6,40)
VS0(13,63)=QCy*VS0(13,41)+WQy*VS1(13,41)&
   +5D0*r1x2E*(VS0(13,25)-ZxZpE*VS1(13,25))&
   +2D0*HfxZpE*VS1(6,41)
VS0(13,64)=QCx*VS0(13,42)+WQx*VS1(13,42)-r1x2E*VR1(13,42)&
   +4D0*r1x2E*(VS0(13,26)-ZxZpE*VS1(13,26))&
   +HfxZpE*VS1(7,42)
VS0(13,65)=QCx*VS0(13,43)+WQx*VS1(13,43)-r1x2E*VR1(13,43)&
   +3D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +HfxZpE*VS1(7,43)
VS0(13,66)=QCx*VS0(13,44)+WQx*VS1(13,44)-r1x2E*VR1(13,44)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +HfxZpE*VS1(7,44)
VS0(13,67)=QCy*VS0(13,44)+WQy*VS1(13,44)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(6,44)
VS0(13,68)=QCy*VS0(13,45)+WQy*VS1(13,45)&
   +3D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(6,45)
VS0(13,69)=QCy*VS0(13,46)+WQy*VS1(13,46)&
   +4D0*r1x2E*(VS0(13,29)-ZxZpE*VS1(13,29))&
   +2D0*HfxZpE*VS1(6,46)
VS0(13,70)=QCx*VS0(13,47)+WQx*VS1(13,47)-r1x2E*VR1(13,47)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))&
   +HfxZpE*VS1(7,47)
VS0(13,71)=QCx*VS0(13,48)+WQx*VS1(13,48)-r1x2E*VR1(13,48)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +HfxZpE*VS1(7,48)
VS0(13,72)=QCx*VS0(13,49)+WQx*VS1(13,49)-r1x2E*VR1(13,49)&
   +r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +HfxZpE*VS1(7,49)
VS0(13,73)=QCy*VS0(13,49)+WQy*VS1(13,49)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +2D0*HfxZpE*VS1(6,49)
VS0(13,74)=QCy*VS0(13,50)+WQy*VS1(13,50)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(6,50)
VS0(13,75)=QCx*VS0(13,51)+WQx*VS1(13,51)-r1x2E*VR1(13,51)&
   +2D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))&
   +HfxZpE*VS1(7,51)
VS0(13,76)=QCz*VS0(13,48)+WQz*VS1(13,48)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))
VS0(13,77)=QCz*VS0(13,49)+WQz*VS1(13,49)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))
VS0(13,78)=QCy*VS0(13,53)+WQy*VS1(13,53)&
   +2D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))&
   +2D0*HfxZpE*VS1(6,53)
VS0(13,79)=QCz*VS0(13,51)+WQz*VS1(13,51)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))
VS0(13,80)=QCz*VS0(13,52)+WQz*VS1(13,52)&
   +3D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))
VS0(13,81)=QCz*VS0(13,53)+WQz*VS1(13,53)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))
VS0(13,82)=QCz*VS0(13,54)+WQz*VS1(13,54)&
   +4D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))
VS0(13,83)=QCz*VS0(13,55)+WQz*VS1(13,55)&
   +4D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))
VS0(13,84)=QCz*VS0(13,56)+WQz*VS1(13,56)&
   +5D0*r1x2E*(VS0(13,35)-ZxZpE*VS1(13,35))
VS0(14,57)=QCx*VS0(14,36)+WQx*VS1(14,36)-r1x2E*VR1(14,36)&
   +5D0*r1x2E*(VS0(14,21)-ZxZpE*VS1(14,21))
VS0(14,58)=QCx*VS0(14,37)+WQx*VS1(14,37)-r1x2E*VR1(14,37)&
   +4D0*r1x2E*(VS0(14,22)-ZxZpE*VS1(14,22))
VS0(14,59)=QCx*VS0(14,38)+WQx*VS1(14,38)-r1x2E*VR1(14,38)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))
VS0(14,60)=QCx*VS0(14,39)+WQx*VS1(14,39)-r1x2E*VR1(14,39)&
   +2D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))
VS0(14,61)=QCy*VS0(14,39)+WQy*VS1(14,39)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))&
   +3D0*HfxZpE*VS1(7,39)
VS0(14,62)=QCy*VS0(14,40)+WQy*VS1(14,40)&
   +4D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(7,40)
VS0(14,63)=QCy*VS0(14,41)+WQy*VS1(14,41)&
   +5D0*r1x2E*(VS0(14,25)-ZxZpE*VS1(14,25))&
   +3D0*HfxZpE*VS1(7,41)
VS0(14,64)=QCx*VS0(14,42)+WQx*VS1(14,42)-r1x2E*VR1(14,42)&
   +4D0*r1x2E*(VS0(14,26)-ZxZpE*VS1(14,26))
VS0(14,65)=QCx*VS0(14,43)+WQx*VS1(14,43)-r1x2E*VR1(14,43)&
   +3D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,66)=QCx*VS0(14,44)+WQx*VS1(14,44)-r1x2E*VR1(14,44)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,67)=QCy*VS0(14,44)+WQy*VS1(14,44)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))&
   +3D0*HfxZpE*VS1(7,44)
VS0(14,68)=QCy*VS0(14,45)+WQy*VS1(14,45)&
   +3D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))&
   +3D0*HfxZpE*VS1(7,45)
VS0(14,69)=QCy*VS0(14,46)+WQy*VS1(14,46)&
   +4D0*r1x2E*(VS0(14,29)-ZxZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(7,46)
VS0(14,70)=QCx*VS0(14,47)+WQx*VS1(14,47)-r1x2E*VR1(14,47)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,71)=QCx*VS0(14,48)+WQx*VS1(14,48)-r1x2E*VR1(14,48)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,72)=QCx*VS0(14,49)+WQx*VS1(14,49)-r1x2E*VR1(14,49)&
   +r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,73)=QCy*VS0(14,49)+WQy*VS1(14,49)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))&
   +3D0*HfxZpE*VS1(7,49)
VS0(14,74)=QCy*VS0(14,50)+WQy*VS1(14,50)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))&
   +3D0*HfxZpE*VS1(7,50)
VS0(14,75)=QCx*VS0(14,51)+WQx*VS1(14,51)-r1x2E*VR1(14,51)&
   +2D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,76)=QCz*VS0(14,48)+WQz*VS1(14,48)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,77)=QCz*VS0(14,49)+WQz*VS1(14,49)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,78)=QCy*VS0(14,53)+WQy*VS1(14,53)&
   +2D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))&
   +3D0*HfxZpE*VS1(7,53)
VS0(14,79)=QCz*VS0(14,51)+WQz*VS1(14,51)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,80)=QCz*VS0(14,52)+WQz*VS1(14,52)&
   +3D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,81)=QCz*VS0(14,53)+WQz*VS1(14,53)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,82)=QCz*VS0(14,54)+WQz*VS1(14,54)&
   +4D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,83)=QCz*VS0(14,55)+WQz*VS1(14,55)&
   +4D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))
VS0(14,84)=QCz*VS0(14,56)+WQz*VS1(14,56)&
   +5D0*r1x2E*(VS0(14,35)-ZxZpE*VS1(14,35))
VS0(15,57)=QCx*VS0(15,36)+WQx*VS1(15,36)-r1x2E*VR1(15,36)&
   +5D0*r1x2E*(VS0(15,21)-ZxZpE*VS1(15,21))&
   +2D0*HfxZpE*VS1(8,36)
VS0(15,58)=QCx*VS0(15,37)+WQx*VS1(15,37)-r1x2E*VR1(15,37)&
   +4D0*r1x2E*(VS0(15,22)-ZxZpE*VS1(15,22))&
   +2D0*HfxZpE*VS1(8,37)
VS0(15,59)=QCx*VS0(15,38)+WQx*VS1(15,38)-r1x2E*VR1(15,38)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(8,38)
VS0(15,60)=QCx*VS0(15,39)+WQx*VS1(15,39)-r1x2E*VR1(15,39)&
   +2D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))&
   +2D0*HfxZpE*VS1(8,39)
VS0(15,61)=QCy*VS0(15,39)+WQy*VS1(15,39)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))
VS0(15,62)=QCy*VS0(15,40)+WQy*VS1(15,40)&
   +4D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))
VS0(15,63)=QCy*VS0(15,41)+WQy*VS1(15,41)&
   +5D0*r1x2E*(VS0(15,25)-ZxZpE*VS1(15,25))
VS0(15,64)=QCx*VS0(15,42)+WQx*VS1(15,42)-r1x2E*VR1(15,42)&
   +4D0*r1x2E*(VS0(15,26)-ZxZpE*VS1(15,26))&
   +2D0*HfxZpE*VS1(8,42)
VS0(15,65)=QCx*VS0(15,43)+WQx*VS1(15,43)-r1x2E*VR1(15,43)&
   +3D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(8,43)
VS0(15,66)=QCx*VS0(15,44)+WQx*VS1(15,44)-r1x2E*VR1(15,44)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +2D0*HfxZpE*VS1(8,44)
VS0(15,67)=QCy*VS0(15,44)+WQy*VS1(15,44)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))
VS0(15,68)=QCy*VS0(15,45)+WQy*VS1(15,45)&
   +3D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))
VS0(15,69)=QCy*VS0(15,46)+WQy*VS1(15,46)&
   +4D0*r1x2E*(VS0(15,29)-ZxZpE*VS1(15,29))
VS0(15,70)=QCx*VS0(15,47)+WQx*VS1(15,47)-r1x2E*VR1(15,47)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(8,47)
VS0(15,71)=QCx*VS0(15,48)+WQx*VS1(15,48)-r1x2E*VR1(15,48)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(8,48)
VS0(15,72)=QCx*VS0(15,49)+WQx*VS1(15,49)-r1x2E*VR1(15,49)&
   +r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(8,49)
VS0(15,73)=QCy*VS0(15,49)+WQy*VS1(15,49)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))
VS0(15,74)=QCy*VS0(15,50)+WQy*VS1(15,50)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))
VS0(15,75)=QCx*VS0(15,51)+WQx*VS1(15,51)-r1x2E*VR1(15,51)&
   +2D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +2D0*HfxZpE*VS1(8,51)
VS0(15,76)=QCz*VS0(15,48)+WQz*VS1(15,48)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +HfxZpE*VS1(5,48)
VS0(15,77)=QCz*VS0(15,49)+WQz*VS1(15,49)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +HfxZpE*VS1(5,49)
VS0(15,78)=QCy*VS0(15,53)+WQy*VS1(15,53)&
   +2D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))
VS0(15,79)=QCz*VS0(15,51)+WQz*VS1(15,51)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +HfxZpE*VS1(5,51)
VS0(15,80)=QCz*VS0(15,52)+WQz*VS1(15,52)&
   +3D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +HfxZpE*VS1(5,52)
VS0(15,81)=QCz*VS0(15,53)+WQz*VS1(15,53)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +HfxZpE*VS1(5,53)
VS0(15,82)=QCz*VS0(15,54)+WQz*VS1(15,54)&
   +4D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +HfxZpE*VS1(5,54)
VS0(15,83)=QCz*VS0(15,55)+WQz*VS1(15,55)&
   +4D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))&
   +HfxZpE*VS1(5,55)
VS0(15,84)=QCz*VS0(15,56)+WQz*VS1(15,56)&
   +5D0*r1x2E*(VS0(15,35)-ZxZpE*VS1(15,35))&
   +HfxZpE*VS1(5,56)
VS0(16,57)=QCx*VS0(16,36)+WQx*VS1(16,36)-r1x2E*VR1(16,36)&
   +5D0*r1x2E*(VS0(16,21)-ZxZpE*VS1(16,21))&
   +HfxZpE*VS1(9,36)
VS0(16,58)=QCx*VS0(16,37)+WQx*VS1(16,37)-r1x2E*VR1(16,37)&
   +4D0*r1x2E*(VS0(16,22)-ZxZpE*VS1(16,22))&
   +HfxZpE*VS1(9,37)
VS0(16,59)=QCx*VS0(16,38)+WQx*VS1(16,38)-r1x2E*VR1(16,38)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(9,38)
VS0(16,60)=QCx*VS0(16,39)+WQx*VS1(16,39)-r1x2E*VR1(16,39)&
   +2D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(9,39)
VS0(16,61)=QCy*VS0(16,39)+WQy*VS1(16,39)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(8,39)
VS0(16,62)=QCy*VS0(16,40)+WQy*VS1(16,40)&
   +4D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(8,40)
VS0(16,63)=QCy*VS0(16,41)+WQy*VS1(16,41)&
   +5D0*r1x2E*(VS0(16,25)-ZxZpE*VS1(16,25))&
   +HfxZpE*VS1(8,41)
VS0(16,64)=QCx*VS0(16,42)+WQx*VS1(16,42)-r1x2E*VR1(16,42)&
   +4D0*r1x2E*(VS0(16,26)-ZxZpE*VS1(16,26))&
   +HfxZpE*VS1(9,42)
VS0(16,65)=QCx*VS0(16,43)+WQx*VS1(16,43)-r1x2E*VR1(16,43)&
   +3D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(9,43)
VS0(16,66)=QCx*VS0(16,44)+WQx*VS1(16,44)-r1x2E*VR1(16,44)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(9,44)
VS0(16,67)=QCy*VS0(16,44)+WQy*VS1(16,44)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(8,44)
VS0(16,68)=QCy*VS0(16,45)+WQy*VS1(16,45)&
   +3D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(8,45)
VS0(16,69)=QCy*VS0(16,46)+WQy*VS1(16,46)&
   +4D0*r1x2E*(VS0(16,29)-ZxZpE*VS1(16,29))&
   +HfxZpE*VS1(8,46)
VS0(16,70)=QCx*VS0(16,47)+WQx*VS1(16,47)-r1x2E*VR1(16,47)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(9,47)
VS0(16,71)=QCx*VS0(16,48)+WQx*VS1(16,48)-r1x2E*VR1(16,48)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(9,48)
VS0(16,72)=QCx*VS0(16,49)+WQx*VS1(16,49)-r1x2E*VR1(16,49)&
   +r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(9,49)
VS0(16,73)=QCy*VS0(16,49)+WQy*VS1(16,49)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(8,49)
VS0(16,74)=QCy*VS0(16,50)+WQy*VS1(16,50)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(8,50)
VS0(16,75)=QCx*VS0(16,51)+WQx*VS1(16,51)-r1x2E*VR1(16,51)&
   +2D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(9,51)
VS0(16,76)=QCz*VS0(16,48)+WQz*VS1(16,48)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(6,48)
VS0(16,77)=QCz*VS0(16,49)+WQz*VS1(16,49)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(6,49)
VS0(16,78)=QCy*VS0(16,53)+WQy*VS1(16,53)&
   +2D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(8,53)
VS0(16,79)=QCz*VS0(16,51)+WQz*VS1(16,51)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(6,51)
VS0(16,80)=QCz*VS0(16,52)+WQz*VS1(16,52)&
   +3D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(6,52)
VS0(16,81)=QCz*VS0(16,53)+WQz*VS1(16,53)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(6,53)
VS0(16,82)=QCz*VS0(16,54)+WQz*VS1(16,54)&
   +4D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(6,54)
VS0(16,83)=QCz*VS0(16,55)+WQz*VS1(16,55)&
   +4D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(6,55)
VS0(16,84)=QCz*VS0(16,56)+WQz*VS1(16,56)&
   +5D0*r1x2E*(VS0(16,35)-ZxZpE*VS1(16,35))&
   +HfxZpE*VS1(6,56)
VS0(17,57)=QCx*VS0(17,36)+WQx*VS1(17,36)-r1x2E*VR1(17,36)&
   +5D0*r1x2E*(VS0(17,21)-ZxZpE*VS1(17,21))
VS0(17,58)=QCx*VS0(17,37)+WQx*VS1(17,37)-r1x2E*VR1(17,37)&
   +4D0*r1x2E*(VS0(17,22)-ZxZpE*VS1(17,22))
VS0(17,59)=QCx*VS0(17,38)+WQx*VS1(17,38)-r1x2E*VR1(17,38)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))
VS0(17,60)=QCx*VS0(17,39)+WQx*VS1(17,39)-r1x2E*VR1(17,39)&
   +2D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))
VS0(17,61)=QCy*VS0(17,39)+WQy*VS1(17,39)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(9,39)
VS0(17,62)=QCy*VS0(17,40)+WQy*VS1(17,40)&
   +4D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))&
   +2D0*HfxZpE*VS1(9,40)
VS0(17,63)=QCy*VS0(17,41)+WQy*VS1(17,41)&
   +5D0*r1x2E*(VS0(17,25)-ZxZpE*VS1(17,25))&
   +2D0*HfxZpE*VS1(9,41)
VS0(17,64)=QCx*VS0(17,42)+WQx*VS1(17,42)-r1x2E*VR1(17,42)&
   +4D0*r1x2E*(VS0(17,26)-ZxZpE*VS1(17,26))
VS0(17,65)=QCx*VS0(17,43)+WQx*VS1(17,43)-r1x2E*VR1(17,43)&
   +3D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))
VS0(17,66)=QCx*VS0(17,44)+WQx*VS1(17,44)-r1x2E*VR1(17,44)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))
VS0(17,67)=QCy*VS0(17,44)+WQy*VS1(17,44)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(9,44)
VS0(17,68)=QCy*VS0(17,45)+WQy*VS1(17,45)&
   +3D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(9,45)
VS0(17,69)=QCy*VS0(17,46)+WQy*VS1(17,46)&
   +4D0*r1x2E*(VS0(17,29)-ZxZpE*VS1(17,29))&
   +2D0*HfxZpE*VS1(9,46)
VS0(17,70)=QCx*VS0(17,47)+WQx*VS1(17,47)-r1x2E*VR1(17,47)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))
VS0(17,71)=QCx*VS0(17,48)+WQx*VS1(17,48)-r1x2E*VR1(17,48)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))
VS0(17,72)=QCx*VS0(17,49)+WQx*VS1(17,49)-r1x2E*VR1(17,49)&
   +r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))
VS0(17,73)=QCy*VS0(17,49)+WQy*VS1(17,49)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(9,49)
VS0(17,74)=QCy*VS0(17,50)+WQy*VS1(17,50)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(9,50)
VS0(17,75)=QCx*VS0(17,51)+WQx*VS1(17,51)-r1x2E*VR1(17,51)&
   +2D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))
VS0(17,76)=QCz*VS0(17,48)+WQz*VS1(17,48)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +HfxZpE*VS1(7,48)
VS0(17,77)=QCz*VS0(17,49)+WQz*VS1(17,49)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +HfxZpE*VS1(7,49)
VS0(17,78)=QCy*VS0(17,53)+WQy*VS1(17,53)&
   +2D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +2D0*HfxZpE*VS1(9,53)
VS0(17,79)=QCz*VS0(17,51)+WQz*VS1(17,51)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))&
   +HfxZpE*VS1(7,51)
VS0(17,80)=QCz*VS0(17,52)+WQz*VS1(17,52)&
   +3D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +HfxZpE*VS1(7,52)
VS0(17,81)=QCz*VS0(17,53)+WQz*VS1(17,53)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +HfxZpE*VS1(7,53)
VS0(17,82)=QCz*VS0(17,54)+WQz*VS1(17,54)&
   +4D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))&
   +HfxZpE*VS1(7,54)
VS0(17,83)=QCz*VS0(17,55)+WQz*VS1(17,55)&
   +4D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +HfxZpE*VS1(7,55)
VS0(17,84)=QCz*VS0(17,56)+WQz*VS1(17,56)&
   +5D0*r1x2E*(VS0(17,35)-ZxZpE*VS1(17,35))&
   +HfxZpE*VS1(7,56)
VS0(18,57)=QCx*VS0(18,36)+WQx*VS1(18,36)-r1x2E*VR1(18,36)&
   +5D0*r1x2E*(VS0(18,21)-ZxZpE*VS1(18,21))&
   +HfxZpE*VS1(10,36)
VS0(18,58)=QCx*VS0(18,37)+WQx*VS1(18,37)-r1x2E*VR1(18,37)&
   +4D0*r1x2E*(VS0(18,22)-ZxZpE*VS1(18,22))&
   +HfxZpE*VS1(10,37)
VS0(18,59)=QCx*VS0(18,38)+WQx*VS1(18,38)-r1x2E*VR1(18,38)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))&
   +HfxZpE*VS1(10,38)
VS0(18,60)=QCx*VS0(18,39)+WQx*VS1(18,39)-r1x2E*VR1(18,39)&
   +2D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))&
   +HfxZpE*VS1(10,39)
VS0(18,61)=QCy*VS0(18,39)+WQy*VS1(18,39)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))
VS0(18,62)=QCy*VS0(18,40)+WQy*VS1(18,40)&
   +4D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))
VS0(18,63)=QCy*VS0(18,41)+WQy*VS1(18,41)&
   +5D0*r1x2E*(VS0(18,25)-ZxZpE*VS1(18,25))
VS0(18,64)=QCx*VS0(18,42)+WQx*VS1(18,42)-r1x2E*VR1(18,42)&
   +4D0*r1x2E*(VS0(18,26)-ZxZpE*VS1(18,26))&
   +HfxZpE*VS1(10,42)
VS0(18,65)=QCx*VS0(18,43)+WQx*VS1(18,43)-r1x2E*VR1(18,43)&
   +3D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +HfxZpE*VS1(10,43)
VS0(18,66)=QCx*VS0(18,44)+WQx*VS1(18,44)-r1x2E*VR1(18,44)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +HfxZpE*VS1(10,44)
VS0(18,67)=QCy*VS0(18,44)+WQy*VS1(18,44)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))
VS0(18,68)=QCy*VS0(18,45)+WQy*VS1(18,45)&
   +3D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))
VS0(18,69)=QCy*VS0(18,46)+WQy*VS1(18,46)&
   +4D0*r1x2E*(VS0(18,29)-ZxZpE*VS1(18,29))
VS0(18,70)=QCx*VS0(18,47)+WQx*VS1(18,47)-r1x2E*VR1(18,47)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +HfxZpE*VS1(10,47)
VS0(18,71)=QCx*VS0(18,48)+WQx*VS1(18,48)-r1x2E*VR1(18,48)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +HfxZpE*VS1(10,48)
VS0(18,72)=QCx*VS0(18,49)+WQx*VS1(18,49)-r1x2E*VR1(18,49)&
   +r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +HfxZpE*VS1(10,49)
VS0(18,73)=QCy*VS0(18,49)+WQy*VS1(18,49)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))
VS0(18,74)=QCy*VS0(18,50)+WQy*VS1(18,50)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))
VS0(18,75)=QCx*VS0(18,51)+WQx*VS1(18,51)-r1x2E*VR1(18,51)&
   +2D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +HfxZpE*VS1(10,51)
VS0(18,76)=QCz*VS0(18,48)+WQz*VS1(18,48)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(8,48)
VS0(18,77)=QCz*VS0(18,49)+WQz*VS1(18,49)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(8,49)
VS0(18,78)=QCy*VS0(18,53)+WQy*VS1(18,53)&
   +2D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))
VS0(18,79)=QCz*VS0(18,51)+WQz*VS1(18,51)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(8,51)
VS0(18,80)=QCz*VS0(18,52)+WQz*VS1(18,52)&
   +3D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(8,52)
VS0(18,81)=QCz*VS0(18,53)+WQz*VS1(18,53)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(8,53)
VS0(18,82)=QCz*VS0(18,54)+WQz*VS1(18,54)&
   +4D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +2D0*HfxZpE*VS1(8,54)
VS0(18,83)=QCz*VS0(18,55)+WQz*VS1(18,55)&
   +4D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))&
   +2D0*HfxZpE*VS1(8,55)
VS0(18,84)=QCz*VS0(18,56)+WQz*VS1(18,56)&
   +5D0*r1x2E*(VS0(18,35)-ZxZpE*VS1(18,35))&
   +2D0*HfxZpE*VS1(8,56)
VS0(19,57)=QCx*VS0(19,36)+WQx*VS1(19,36)-r1x2E*VR1(19,36)&
   +5D0*r1x2E*(VS0(19,21)-ZxZpE*VS1(19,21))
VS0(19,58)=QCx*VS0(19,37)+WQx*VS1(19,37)-r1x2E*VR1(19,37)&
   +4D0*r1x2E*(VS0(19,22)-ZxZpE*VS1(19,22))
VS0(19,59)=QCx*VS0(19,38)+WQx*VS1(19,38)-r1x2E*VR1(19,38)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))
VS0(19,60)=QCx*VS0(19,39)+WQx*VS1(19,39)-r1x2E*VR1(19,39)&
   +2D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))
VS0(19,61)=QCy*VS0(19,39)+WQy*VS1(19,39)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))&
   +HfxZpE*VS1(10,39)
VS0(19,62)=QCy*VS0(19,40)+WQy*VS1(19,40)&
   +4D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))&
   +HfxZpE*VS1(10,40)
VS0(19,63)=QCy*VS0(19,41)+WQy*VS1(19,41)&
   +5D0*r1x2E*(VS0(19,25)-ZxZpE*VS1(19,25))&
   +HfxZpE*VS1(10,41)
VS0(19,64)=QCx*VS0(19,42)+WQx*VS1(19,42)-r1x2E*VR1(19,42)&
   +4D0*r1x2E*(VS0(19,26)-ZxZpE*VS1(19,26))
VS0(19,65)=QCx*VS0(19,43)+WQx*VS1(19,43)-r1x2E*VR1(19,43)&
   +3D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))
VS0(19,66)=QCx*VS0(19,44)+WQx*VS1(19,44)-r1x2E*VR1(19,44)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))
VS0(19,67)=QCy*VS0(19,44)+WQy*VS1(19,44)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +HfxZpE*VS1(10,44)
VS0(19,68)=QCy*VS0(19,45)+WQy*VS1(19,45)&
   +3D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +HfxZpE*VS1(10,45)
VS0(19,69)=QCy*VS0(19,46)+WQy*VS1(19,46)&
   +4D0*r1x2E*(VS0(19,29)-ZxZpE*VS1(19,29))&
   +HfxZpE*VS1(10,46)
VS0(19,70)=QCx*VS0(19,47)+WQx*VS1(19,47)-r1x2E*VR1(19,47)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))
VS0(19,71)=QCx*VS0(19,48)+WQx*VS1(19,48)-r1x2E*VR1(19,48)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))
VS0(19,72)=QCx*VS0(19,49)+WQx*VS1(19,49)-r1x2E*VR1(19,49)&
   +r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))
VS0(19,73)=QCy*VS0(19,49)+WQy*VS1(19,49)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +HfxZpE*VS1(10,49)
VS0(19,74)=QCy*VS0(19,50)+WQy*VS1(19,50)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +HfxZpE*VS1(10,50)
VS0(19,75)=QCx*VS0(19,51)+WQx*VS1(19,51)-r1x2E*VR1(19,51)&
   +2D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))
VS0(19,76)=QCz*VS0(19,48)+WQz*VS1(19,48)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(9,48)
VS0(19,77)=QCz*VS0(19,49)+WQz*VS1(19,49)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(9,49)
VS0(19,78)=QCy*VS0(19,53)+WQy*VS1(19,53)&
   +2D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +HfxZpE*VS1(10,53)
VS0(19,79)=QCz*VS0(19,51)+WQz*VS1(19,51)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(9,51)
VS0(19,80)=QCz*VS0(19,52)+WQz*VS1(19,52)&
   +3D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(9,52)
VS0(19,81)=QCz*VS0(19,53)+WQz*VS1(19,53)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(9,53)
VS0(19,82)=QCz*VS0(19,54)+WQz*VS1(19,54)&
   +4D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))&
   +2D0*HfxZpE*VS1(9,54)
VS0(19,83)=QCz*VS0(19,55)+WQz*VS1(19,55)&
   +4D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +2D0*HfxZpE*VS1(9,55)
VS0(19,84)=QCz*VS0(19,56)+WQz*VS1(19,56)&
   +5D0*r1x2E*(VS0(19,35)-ZxZpE*VS1(19,35))&
   +2D0*HfxZpE*VS1(9,56)
VS0(20,57)=QCx*VS0(20,36)+WQx*VS1(20,36)-r1x2E*VR1(20,36)&
   +5D0*r1x2E*(VS0(20,21)-ZxZpE*VS1(20,21))
VS0(20,58)=QCx*VS0(20,37)+WQx*VS1(20,37)-r1x2E*VR1(20,37)&
   +4D0*r1x2E*(VS0(20,22)-ZxZpE*VS1(20,22))
VS0(20,59)=QCx*VS0(20,38)+WQx*VS1(20,38)-r1x2E*VR1(20,38)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,60)=QCx*VS0(20,39)+WQx*VS1(20,39)-r1x2E*VR1(20,39)&
   +2D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,61)=QCy*VS0(20,39)+WQy*VS1(20,39)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,62)=QCy*VS0(20,40)+WQy*VS1(20,40)&
   +4D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,63)=QCy*VS0(20,41)+WQy*VS1(20,41)&
   +5D0*r1x2E*(VS0(20,25)-ZxZpE*VS1(20,25))
VS0(20,64)=QCx*VS0(20,42)+WQx*VS1(20,42)-r1x2E*VR1(20,42)&
   +4D0*r1x2E*(VS0(20,26)-ZxZpE*VS1(20,26))
VS0(20,65)=QCx*VS0(20,43)+WQx*VS1(20,43)-r1x2E*VR1(20,43)&
   +3D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,66)=QCx*VS0(20,44)+WQx*VS1(20,44)-r1x2E*VR1(20,44)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,67)=QCy*VS0(20,44)+WQy*VS1(20,44)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,68)=QCy*VS0(20,45)+WQy*VS1(20,45)&
   +3D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,69)=QCy*VS0(20,46)+WQy*VS1(20,46)&
   +4D0*r1x2E*(VS0(20,29)-ZxZpE*VS1(20,29))
VS0(20,70)=QCx*VS0(20,47)+WQx*VS1(20,47)-r1x2E*VR1(20,47)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))
VS0(20,71)=QCx*VS0(20,48)+WQx*VS1(20,48)-r1x2E*VR1(20,48)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,72)=QCx*VS0(20,49)+WQx*VS1(20,49)-r1x2E*VR1(20,49)&
   +r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,73)=QCy*VS0(20,49)+WQy*VS1(20,49)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,74)=QCy*VS0(20,50)+WQy*VS1(20,50)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,75)=QCx*VS0(20,51)+WQx*VS1(20,51)-r1x2E*VR1(20,51)&
   +2D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))
VS0(20,76)=QCz*VS0(20,48)+WQz*VS1(20,48)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))&
   +3D0*HfxZpE*VS1(10,48)
VS0(20,77)=QCz*VS0(20,49)+WQz*VS1(20,49)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))&
   +3D0*HfxZpE*VS1(10,49)
VS0(20,78)=QCy*VS0(20,53)+WQy*VS1(20,53)&
   +2D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))
VS0(20,79)=QCz*VS0(20,51)+WQz*VS1(20,51)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))&
   +3D0*HfxZpE*VS1(10,51)
VS0(20,80)=QCz*VS0(20,52)+WQz*VS1(20,52)&
   +3D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))&
   +3D0*HfxZpE*VS1(10,52)
VS0(20,81)=QCz*VS0(20,53)+WQz*VS1(20,53)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))&
   +3D0*HfxZpE*VS1(10,53)
VS0(20,82)=QCz*VS0(20,54)+WQz*VS1(20,54)&
   +4D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(10,54)
VS0(20,83)=QCz*VS0(20,55)+WQz*VS1(20,55)&
   +4D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(10,55)
VS0(20,84)=QCz*VS0(20,56)+WQz*VS1(20,56)&
   +5D0*r1x2E*(VS0(20,35)-ZxZpE*VS1(20,35))&
   +3D0*HfxZpE*VS1(10,56)
CASE(2)
VS0(11,57)=QCx*VS0(11,36)+WQx*VS1(11,36)&
   +5D0*r1x2E*(VS0(11,21)-ZxZpE*VS1(11,21))&
   +3D0*HfxZpE*VS1(5,36)
VS0(11,58)=QCx*VS0(11,37)+WQx*VS1(11,37)&
   +4D0*r1x2E*(VS0(11,22)-ZxZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(5,37)
VS0(11,59)=QCx*VS0(11,38)+WQx*VS1(11,38)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))&
   +3D0*HfxZpE*VS1(5,38)
VS0(11,60)=QCx*VS0(11,39)+WQx*VS1(11,39)&
   +2D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))&
   +3D0*HfxZpE*VS1(5,39)
VS0(11,61)=QCy*VS0(11,39)+WQy*VS1(11,39)-r1x2E*VR1(11,39)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))
VS0(11,62)=QCy*VS0(11,40)+WQy*VS1(11,40)-r1x2E*VR1(11,40)&
   +4D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))
VS0(11,63)=QCy*VS0(11,41)+WQy*VS1(11,41)-r1x2E*VR1(11,41)&
   +5D0*r1x2E*(VS0(11,25)-ZxZpE*VS1(11,25))
VS0(11,64)=QCx*VS0(11,42)+WQx*VS1(11,42)&
   +4D0*r1x2E*(VS0(11,26)-ZxZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(5,42)
VS0(11,65)=QCx*VS0(11,43)+WQx*VS1(11,43)&
   +3D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))&
   +3D0*HfxZpE*VS1(5,43)
VS0(11,66)=QCx*VS0(11,44)+WQx*VS1(11,44)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))&
   +3D0*HfxZpE*VS1(5,44)
VS0(11,67)=QCy*VS0(11,44)+WQy*VS1(11,44)-r1x2E*VR1(11,44)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,68)=QCy*VS0(11,45)+WQy*VS1(11,45)-r1x2E*VR1(11,45)&
   +3D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,69)=QCy*VS0(11,46)+WQy*VS1(11,46)-r1x2E*VR1(11,46)&
   +4D0*r1x2E*(VS0(11,29)-ZxZpE*VS1(11,29))
VS0(11,70)=QCx*VS0(11,47)+WQx*VS1(11,47)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))&
   +3D0*HfxZpE*VS1(5,47)
VS0(11,71)=QCx*VS0(11,48)+WQx*VS1(11,48)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))&
   +3D0*HfxZpE*VS1(5,48)
VS0(11,72)=QCx*VS0(11,49)+WQx*VS1(11,49)&
   +r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))&
   +3D0*HfxZpE*VS1(5,49)
VS0(11,73)=QCy*VS0(11,49)+WQy*VS1(11,49)-r1x2E*VR1(11,49)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,74)=QCy*VS0(11,50)+WQy*VS1(11,50)-r1x2E*VR1(11,50)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,75)=QCx*VS0(11,51)+WQx*VS1(11,51)&
   +2D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))&
   +3D0*HfxZpE*VS1(5,51)
VS0(11,76)=QCz*VS0(11,48)+WQz*VS1(11,48)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,77)=QCz*VS0(11,49)+WQz*VS1(11,49)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,78)=QCy*VS0(11,53)+WQy*VS1(11,53)-r1x2E*VR1(11,53)&
   +2D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,79)=QCz*VS0(11,51)+WQz*VS1(11,51)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))
VS0(11,80)=QCz*VS0(11,52)+WQz*VS1(11,52)&
   +3D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,81)=QCz*VS0(11,53)+WQz*VS1(11,53)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,82)=QCz*VS0(11,54)+WQz*VS1(11,54)&
   +4D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))
VS0(11,83)=QCz*VS0(11,55)+WQz*VS1(11,55)&
   +4D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,84)=QCz*VS0(11,56)+WQz*VS1(11,56)&
   +5D0*r1x2E*(VS0(11,35)-ZxZpE*VS1(11,35))
VS0(12,57)=QCx*VS0(12,36)+WQx*VS1(12,36)&
   +5D0*r1x2E*(VS0(12,21)-ZxZpE*VS1(12,21))&
   +2D0*HfxZpE*VS1(6,36)
VS0(12,58)=QCx*VS0(12,37)+WQx*VS1(12,37)&
   +4D0*r1x2E*(VS0(12,22)-ZxZpE*VS1(12,22))&
   +2D0*HfxZpE*VS1(6,37)
VS0(12,59)=QCx*VS0(12,38)+WQx*VS1(12,38)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(6,38)
VS0(12,60)=QCx*VS0(12,39)+WQx*VS1(12,39)&
   +2D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +2D0*HfxZpE*VS1(6,39)
VS0(12,61)=QCy*VS0(12,39)+WQy*VS1(12,39)-r1x2E*VR1(12,39)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +HfxZpE*VS1(5,39)
VS0(12,62)=QCy*VS0(12,40)+WQy*VS1(12,40)-r1x2E*VR1(12,40)&
   +4D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +HfxZpE*VS1(5,40)
VS0(12,63)=QCy*VS0(12,41)+WQy*VS1(12,41)-r1x2E*VR1(12,41)&
   +5D0*r1x2E*(VS0(12,25)-ZxZpE*VS1(12,25))&
   +HfxZpE*VS1(5,41)
VS0(12,64)=QCx*VS0(12,42)+WQx*VS1(12,42)&
   +4D0*r1x2E*(VS0(12,26)-ZxZpE*VS1(12,26))&
   +2D0*HfxZpE*VS1(6,42)
VS0(12,65)=QCx*VS0(12,43)+WQx*VS1(12,43)&
   +3D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(6,43)
VS0(12,66)=QCx*VS0(12,44)+WQx*VS1(12,44)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(6,44)
VS0(12,67)=QCy*VS0(12,44)+WQy*VS1(12,44)-r1x2E*VR1(12,44)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +HfxZpE*VS1(5,44)
VS0(12,68)=QCy*VS0(12,45)+WQy*VS1(12,45)-r1x2E*VR1(12,45)&
   +3D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +HfxZpE*VS1(5,45)
VS0(12,69)=QCy*VS0(12,46)+WQy*VS1(12,46)-r1x2E*VR1(12,46)&
   +4D0*r1x2E*(VS0(12,29)-ZxZpE*VS1(12,29))&
   +HfxZpE*VS1(5,46)
VS0(12,70)=QCx*VS0(12,47)+WQx*VS1(12,47)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(6,47)
VS0(12,71)=QCx*VS0(12,48)+WQx*VS1(12,48)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +2D0*HfxZpE*VS1(6,48)
VS0(12,72)=QCx*VS0(12,49)+WQx*VS1(12,49)&
   +r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(6,49)
VS0(12,73)=QCy*VS0(12,49)+WQy*VS1(12,49)-r1x2E*VR1(12,49)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +HfxZpE*VS1(5,49)
VS0(12,74)=QCy*VS0(12,50)+WQy*VS1(12,50)-r1x2E*VR1(12,50)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +HfxZpE*VS1(5,50)
VS0(12,75)=QCx*VS0(12,51)+WQx*VS1(12,51)&
   +2D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))&
   +2D0*HfxZpE*VS1(6,51)
VS0(12,76)=QCz*VS0(12,48)+WQz*VS1(12,48)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))
VS0(12,77)=QCz*VS0(12,49)+WQz*VS1(12,49)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))
VS0(12,78)=QCy*VS0(12,53)+WQy*VS1(12,53)-r1x2E*VR1(12,53)&
   +2D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))&
   +HfxZpE*VS1(5,53)
VS0(12,79)=QCz*VS0(12,51)+WQz*VS1(12,51)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))
VS0(12,80)=QCz*VS0(12,52)+WQz*VS1(12,52)&
   +3D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))
VS0(12,81)=QCz*VS0(12,53)+WQz*VS1(12,53)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))
VS0(12,82)=QCz*VS0(12,54)+WQz*VS1(12,54)&
   +4D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))
VS0(12,83)=QCz*VS0(12,55)+WQz*VS1(12,55)&
   +4D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))
VS0(12,84)=QCz*VS0(12,56)+WQz*VS1(12,56)&
   +5D0*r1x2E*(VS0(12,35)-ZxZpE*VS1(12,35))
VS0(13,57)=QCx*VS0(13,36)+WQx*VS1(13,36)&
   +5D0*r1x2E*(VS0(13,21)-ZxZpE*VS1(13,21))&
   +HfxZpE*VS1(7,36)
VS0(13,58)=QCx*VS0(13,37)+WQx*VS1(13,37)&
   +4D0*r1x2E*(VS0(13,22)-ZxZpE*VS1(13,22))&
   +HfxZpE*VS1(7,37)
VS0(13,59)=QCx*VS0(13,38)+WQx*VS1(13,38)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +HfxZpE*VS1(7,38)
VS0(13,60)=QCx*VS0(13,39)+WQx*VS1(13,39)&
   +2D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +HfxZpE*VS1(7,39)
VS0(13,61)=QCy*VS0(13,39)+WQy*VS1(13,39)-r1x2E*VR1(13,39)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(6,39)
VS0(13,62)=QCy*VS0(13,40)+WQy*VS1(13,40)-r1x2E*VR1(13,40)&
   +4D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +2D0*HfxZpE*VS1(6,40)
VS0(13,63)=QCy*VS0(13,41)+WQy*VS1(13,41)-r1x2E*VR1(13,41)&
   +5D0*r1x2E*(VS0(13,25)-ZxZpE*VS1(13,25))&
   +2D0*HfxZpE*VS1(6,41)
VS0(13,64)=QCx*VS0(13,42)+WQx*VS1(13,42)&
   +4D0*r1x2E*(VS0(13,26)-ZxZpE*VS1(13,26))&
   +HfxZpE*VS1(7,42)
VS0(13,65)=QCx*VS0(13,43)+WQx*VS1(13,43)&
   +3D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +HfxZpE*VS1(7,43)
VS0(13,66)=QCx*VS0(13,44)+WQx*VS1(13,44)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +HfxZpE*VS1(7,44)
VS0(13,67)=QCy*VS0(13,44)+WQy*VS1(13,44)-r1x2E*VR1(13,44)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(6,44)
VS0(13,68)=QCy*VS0(13,45)+WQy*VS1(13,45)-r1x2E*VR1(13,45)&
   +3D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(6,45)
VS0(13,69)=QCy*VS0(13,46)+WQy*VS1(13,46)-r1x2E*VR1(13,46)&
   +4D0*r1x2E*(VS0(13,29)-ZxZpE*VS1(13,29))&
   +2D0*HfxZpE*VS1(6,46)
VS0(13,70)=QCx*VS0(13,47)+WQx*VS1(13,47)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))&
   +HfxZpE*VS1(7,47)
VS0(13,71)=QCx*VS0(13,48)+WQx*VS1(13,48)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +HfxZpE*VS1(7,48)
VS0(13,72)=QCx*VS0(13,49)+WQx*VS1(13,49)&
   +r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +HfxZpE*VS1(7,49)
VS0(13,73)=QCy*VS0(13,49)+WQy*VS1(13,49)-r1x2E*VR1(13,49)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +2D0*HfxZpE*VS1(6,49)
VS0(13,74)=QCy*VS0(13,50)+WQy*VS1(13,50)-r1x2E*VR1(13,50)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(6,50)
VS0(13,75)=QCx*VS0(13,51)+WQx*VS1(13,51)&
   +2D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))&
   +HfxZpE*VS1(7,51)
VS0(13,76)=QCz*VS0(13,48)+WQz*VS1(13,48)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))
VS0(13,77)=QCz*VS0(13,49)+WQz*VS1(13,49)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))
VS0(13,78)=QCy*VS0(13,53)+WQy*VS1(13,53)-r1x2E*VR1(13,53)&
   +2D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))&
   +2D0*HfxZpE*VS1(6,53)
VS0(13,79)=QCz*VS0(13,51)+WQz*VS1(13,51)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))
VS0(13,80)=QCz*VS0(13,52)+WQz*VS1(13,52)&
   +3D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))
VS0(13,81)=QCz*VS0(13,53)+WQz*VS1(13,53)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))
VS0(13,82)=QCz*VS0(13,54)+WQz*VS1(13,54)&
   +4D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))
VS0(13,83)=QCz*VS0(13,55)+WQz*VS1(13,55)&
   +4D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))
VS0(13,84)=QCz*VS0(13,56)+WQz*VS1(13,56)&
   +5D0*r1x2E*(VS0(13,35)-ZxZpE*VS1(13,35))
VS0(14,57)=QCx*VS0(14,36)+WQx*VS1(14,36)&
   +5D0*r1x2E*(VS0(14,21)-ZxZpE*VS1(14,21))
VS0(14,58)=QCx*VS0(14,37)+WQx*VS1(14,37)&
   +4D0*r1x2E*(VS0(14,22)-ZxZpE*VS1(14,22))
VS0(14,59)=QCx*VS0(14,38)+WQx*VS1(14,38)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))
VS0(14,60)=QCx*VS0(14,39)+WQx*VS1(14,39)&
   +2D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))
VS0(14,61)=QCy*VS0(14,39)+WQy*VS1(14,39)-r1x2E*VR1(14,39)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))&
   +3D0*HfxZpE*VS1(7,39)
VS0(14,62)=QCy*VS0(14,40)+WQy*VS1(14,40)-r1x2E*VR1(14,40)&
   +4D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(7,40)
VS0(14,63)=QCy*VS0(14,41)+WQy*VS1(14,41)-r1x2E*VR1(14,41)&
   +5D0*r1x2E*(VS0(14,25)-ZxZpE*VS1(14,25))&
   +3D0*HfxZpE*VS1(7,41)
VS0(14,64)=QCx*VS0(14,42)+WQx*VS1(14,42)&
   +4D0*r1x2E*(VS0(14,26)-ZxZpE*VS1(14,26))
VS0(14,65)=QCx*VS0(14,43)+WQx*VS1(14,43)&
   +3D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,66)=QCx*VS0(14,44)+WQx*VS1(14,44)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,67)=QCy*VS0(14,44)+WQy*VS1(14,44)-r1x2E*VR1(14,44)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))&
   +3D0*HfxZpE*VS1(7,44)
VS0(14,68)=QCy*VS0(14,45)+WQy*VS1(14,45)-r1x2E*VR1(14,45)&
   +3D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))&
   +3D0*HfxZpE*VS1(7,45)
VS0(14,69)=QCy*VS0(14,46)+WQy*VS1(14,46)-r1x2E*VR1(14,46)&
   +4D0*r1x2E*(VS0(14,29)-ZxZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(7,46)
VS0(14,70)=QCx*VS0(14,47)+WQx*VS1(14,47)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,71)=QCx*VS0(14,48)+WQx*VS1(14,48)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,72)=QCx*VS0(14,49)+WQx*VS1(14,49)&
   +r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,73)=QCy*VS0(14,49)+WQy*VS1(14,49)-r1x2E*VR1(14,49)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))&
   +3D0*HfxZpE*VS1(7,49)
VS0(14,74)=QCy*VS0(14,50)+WQy*VS1(14,50)-r1x2E*VR1(14,50)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))&
   +3D0*HfxZpE*VS1(7,50)
VS0(14,75)=QCx*VS0(14,51)+WQx*VS1(14,51)&
   +2D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,76)=QCz*VS0(14,48)+WQz*VS1(14,48)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,77)=QCz*VS0(14,49)+WQz*VS1(14,49)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,78)=QCy*VS0(14,53)+WQy*VS1(14,53)-r1x2E*VR1(14,53)&
   +2D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))&
   +3D0*HfxZpE*VS1(7,53)
VS0(14,79)=QCz*VS0(14,51)+WQz*VS1(14,51)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,80)=QCz*VS0(14,52)+WQz*VS1(14,52)&
   +3D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,81)=QCz*VS0(14,53)+WQz*VS1(14,53)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,82)=QCz*VS0(14,54)+WQz*VS1(14,54)&
   +4D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,83)=QCz*VS0(14,55)+WQz*VS1(14,55)&
   +4D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))
VS0(14,84)=QCz*VS0(14,56)+WQz*VS1(14,56)&
   +5D0*r1x2E*(VS0(14,35)-ZxZpE*VS1(14,35))
VS0(15,57)=QCx*VS0(15,36)+WQx*VS1(15,36)&
   +5D0*r1x2E*(VS0(15,21)-ZxZpE*VS1(15,21))&
   +2D0*HfxZpE*VS1(8,36)
VS0(15,58)=QCx*VS0(15,37)+WQx*VS1(15,37)&
   +4D0*r1x2E*(VS0(15,22)-ZxZpE*VS1(15,22))&
   +2D0*HfxZpE*VS1(8,37)
VS0(15,59)=QCx*VS0(15,38)+WQx*VS1(15,38)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(8,38)
VS0(15,60)=QCx*VS0(15,39)+WQx*VS1(15,39)&
   +2D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))&
   +2D0*HfxZpE*VS1(8,39)
VS0(15,61)=QCy*VS0(15,39)+WQy*VS1(15,39)-r1x2E*VR1(15,39)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))
VS0(15,62)=QCy*VS0(15,40)+WQy*VS1(15,40)-r1x2E*VR1(15,40)&
   +4D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))
VS0(15,63)=QCy*VS0(15,41)+WQy*VS1(15,41)-r1x2E*VR1(15,41)&
   +5D0*r1x2E*(VS0(15,25)-ZxZpE*VS1(15,25))
VS0(15,64)=QCx*VS0(15,42)+WQx*VS1(15,42)&
   +4D0*r1x2E*(VS0(15,26)-ZxZpE*VS1(15,26))&
   +2D0*HfxZpE*VS1(8,42)
VS0(15,65)=QCx*VS0(15,43)+WQx*VS1(15,43)&
   +3D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(8,43)
VS0(15,66)=QCx*VS0(15,44)+WQx*VS1(15,44)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +2D0*HfxZpE*VS1(8,44)
VS0(15,67)=QCy*VS0(15,44)+WQy*VS1(15,44)-r1x2E*VR1(15,44)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))
VS0(15,68)=QCy*VS0(15,45)+WQy*VS1(15,45)-r1x2E*VR1(15,45)&
   +3D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))
VS0(15,69)=QCy*VS0(15,46)+WQy*VS1(15,46)-r1x2E*VR1(15,46)&
   +4D0*r1x2E*(VS0(15,29)-ZxZpE*VS1(15,29))
VS0(15,70)=QCx*VS0(15,47)+WQx*VS1(15,47)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(8,47)
VS0(15,71)=QCx*VS0(15,48)+WQx*VS1(15,48)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(8,48)
VS0(15,72)=QCx*VS0(15,49)+WQx*VS1(15,49)&
   +r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(8,49)
VS0(15,73)=QCy*VS0(15,49)+WQy*VS1(15,49)-r1x2E*VR1(15,49)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))
VS0(15,74)=QCy*VS0(15,50)+WQy*VS1(15,50)-r1x2E*VR1(15,50)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))
VS0(15,75)=QCx*VS0(15,51)+WQx*VS1(15,51)&
   +2D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +2D0*HfxZpE*VS1(8,51)
VS0(15,76)=QCz*VS0(15,48)+WQz*VS1(15,48)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +HfxZpE*VS1(5,48)
VS0(15,77)=QCz*VS0(15,49)+WQz*VS1(15,49)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +HfxZpE*VS1(5,49)
VS0(15,78)=QCy*VS0(15,53)+WQy*VS1(15,53)-r1x2E*VR1(15,53)&
   +2D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))
VS0(15,79)=QCz*VS0(15,51)+WQz*VS1(15,51)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +HfxZpE*VS1(5,51)
VS0(15,80)=QCz*VS0(15,52)+WQz*VS1(15,52)&
   +3D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +HfxZpE*VS1(5,52)
VS0(15,81)=QCz*VS0(15,53)+WQz*VS1(15,53)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +HfxZpE*VS1(5,53)
VS0(15,82)=QCz*VS0(15,54)+WQz*VS1(15,54)&
   +4D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +HfxZpE*VS1(5,54)
VS0(15,83)=QCz*VS0(15,55)+WQz*VS1(15,55)&
   +4D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))&
   +HfxZpE*VS1(5,55)
VS0(15,84)=QCz*VS0(15,56)+WQz*VS1(15,56)&
   +5D0*r1x2E*(VS0(15,35)-ZxZpE*VS1(15,35))&
   +HfxZpE*VS1(5,56)
VS0(16,57)=QCx*VS0(16,36)+WQx*VS1(16,36)&
   +5D0*r1x2E*(VS0(16,21)-ZxZpE*VS1(16,21))&
   +HfxZpE*VS1(9,36)
VS0(16,58)=QCx*VS0(16,37)+WQx*VS1(16,37)&
   +4D0*r1x2E*(VS0(16,22)-ZxZpE*VS1(16,22))&
   +HfxZpE*VS1(9,37)
VS0(16,59)=QCx*VS0(16,38)+WQx*VS1(16,38)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(9,38)
VS0(16,60)=QCx*VS0(16,39)+WQx*VS1(16,39)&
   +2D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(9,39)
VS0(16,61)=QCy*VS0(16,39)+WQy*VS1(16,39)-r1x2E*VR1(16,39)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(8,39)
VS0(16,62)=QCy*VS0(16,40)+WQy*VS1(16,40)-r1x2E*VR1(16,40)&
   +4D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(8,40)
VS0(16,63)=QCy*VS0(16,41)+WQy*VS1(16,41)-r1x2E*VR1(16,41)&
   +5D0*r1x2E*(VS0(16,25)-ZxZpE*VS1(16,25))&
   +HfxZpE*VS1(8,41)
VS0(16,64)=QCx*VS0(16,42)+WQx*VS1(16,42)&
   +4D0*r1x2E*(VS0(16,26)-ZxZpE*VS1(16,26))&
   +HfxZpE*VS1(9,42)
VS0(16,65)=QCx*VS0(16,43)+WQx*VS1(16,43)&
   +3D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(9,43)
VS0(16,66)=QCx*VS0(16,44)+WQx*VS1(16,44)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(9,44)
VS0(16,67)=QCy*VS0(16,44)+WQy*VS1(16,44)-r1x2E*VR1(16,44)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(8,44)
VS0(16,68)=QCy*VS0(16,45)+WQy*VS1(16,45)-r1x2E*VR1(16,45)&
   +3D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(8,45)
VS0(16,69)=QCy*VS0(16,46)+WQy*VS1(16,46)-r1x2E*VR1(16,46)&
   +4D0*r1x2E*(VS0(16,29)-ZxZpE*VS1(16,29))&
   +HfxZpE*VS1(8,46)
VS0(16,70)=QCx*VS0(16,47)+WQx*VS1(16,47)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(9,47)
VS0(16,71)=QCx*VS0(16,48)+WQx*VS1(16,48)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(9,48)
VS0(16,72)=QCx*VS0(16,49)+WQx*VS1(16,49)&
   +r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(9,49)
VS0(16,73)=QCy*VS0(16,49)+WQy*VS1(16,49)-r1x2E*VR1(16,49)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(8,49)
VS0(16,74)=QCy*VS0(16,50)+WQy*VS1(16,50)-r1x2E*VR1(16,50)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(8,50)
VS0(16,75)=QCx*VS0(16,51)+WQx*VS1(16,51)&
   +2D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(9,51)
VS0(16,76)=QCz*VS0(16,48)+WQz*VS1(16,48)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(6,48)
VS0(16,77)=QCz*VS0(16,49)+WQz*VS1(16,49)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(6,49)
VS0(16,78)=QCy*VS0(16,53)+WQy*VS1(16,53)-r1x2E*VR1(16,53)&
   +2D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(8,53)
VS0(16,79)=QCz*VS0(16,51)+WQz*VS1(16,51)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(6,51)
VS0(16,80)=QCz*VS0(16,52)+WQz*VS1(16,52)&
   +3D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(6,52)
VS0(16,81)=QCz*VS0(16,53)+WQz*VS1(16,53)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(6,53)
VS0(16,82)=QCz*VS0(16,54)+WQz*VS1(16,54)&
   +4D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(6,54)
VS0(16,83)=QCz*VS0(16,55)+WQz*VS1(16,55)&
   +4D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(6,55)
VS0(16,84)=QCz*VS0(16,56)+WQz*VS1(16,56)&
   +5D0*r1x2E*(VS0(16,35)-ZxZpE*VS1(16,35))&
   +HfxZpE*VS1(6,56)
VS0(17,57)=QCx*VS0(17,36)+WQx*VS1(17,36)&
   +5D0*r1x2E*(VS0(17,21)-ZxZpE*VS1(17,21))
VS0(17,58)=QCx*VS0(17,37)+WQx*VS1(17,37)&
   +4D0*r1x2E*(VS0(17,22)-ZxZpE*VS1(17,22))
VS0(17,59)=QCx*VS0(17,38)+WQx*VS1(17,38)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))
VS0(17,60)=QCx*VS0(17,39)+WQx*VS1(17,39)&
   +2D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))
VS0(17,61)=QCy*VS0(17,39)+WQy*VS1(17,39)-r1x2E*VR1(17,39)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(9,39)
VS0(17,62)=QCy*VS0(17,40)+WQy*VS1(17,40)-r1x2E*VR1(17,40)&
   +4D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))&
   +2D0*HfxZpE*VS1(9,40)
VS0(17,63)=QCy*VS0(17,41)+WQy*VS1(17,41)-r1x2E*VR1(17,41)&
   +5D0*r1x2E*(VS0(17,25)-ZxZpE*VS1(17,25))&
   +2D0*HfxZpE*VS1(9,41)
VS0(17,64)=QCx*VS0(17,42)+WQx*VS1(17,42)&
   +4D0*r1x2E*(VS0(17,26)-ZxZpE*VS1(17,26))
VS0(17,65)=QCx*VS0(17,43)+WQx*VS1(17,43)&
   +3D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))
VS0(17,66)=QCx*VS0(17,44)+WQx*VS1(17,44)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))
VS0(17,67)=QCy*VS0(17,44)+WQy*VS1(17,44)-r1x2E*VR1(17,44)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(9,44)
VS0(17,68)=QCy*VS0(17,45)+WQy*VS1(17,45)-r1x2E*VR1(17,45)&
   +3D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(9,45)
VS0(17,69)=QCy*VS0(17,46)+WQy*VS1(17,46)-r1x2E*VR1(17,46)&
   +4D0*r1x2E*(VS0(17,29)-ZxZpE*VS1(17,29))&
   +2D0*HfxZpE*VS1(9,46)
VS0(17,70)=QCx*VS0(17,47)+WQx*VS1(17,47)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))
VS0(17,71)=QCx*VS0(17,48)+WQx*VS1(17,48)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))
VS0(17,72)=QCx*VS0(17,49)+WQx*VS1(17,49)&
   +r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))
VS0(17,73)=QCy*VS0(17,49)+WQy*VS1(17,49)-r1x2E*VR1(17,49)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(9,49)
VS0(17,74)=QCy*VS0(17,50)+WQy*VS1(17,50)-r1x2E*VR1(17,50)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(9,50)
VS0(17,75)=QCx*VS0(17,51)+WQx*VS1(17,51)&
   +2D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))
VS0(17,76)=QCz*VS0(17,48)+WQz*VS1(17,48)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +HfxZpE*VS1(7,48)
VS0(17,77)=QCz*VS0(17,49)+WQz*VS1(17,49)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +HfxZpE*VS1(7,49)
VS0(17,78)=QCy*VS0(17,53)+WQy*VS1(17,53)-r1x2E*VR1(17,53)&
   +2D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +2D0*HfxZpE*VS1(9,53)
VS0(17,79)=QCz*VS0(17,51)+WQz*VS1(17,51)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))&
   +HfxZpE*VS1(7,51)
VS0(17,80)=QCz*VS0(17,52)+WQz*VS1(17,52)&
   +3D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +HfxZpE*VS1(7,52)
VS0(17,81)=QCz*VS0(17,53)+WQz*VS1(17,53)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +HfxZpE*VS1(7,53)
VS0(17,82)=QCz*VS0(17,54)+WQz*VS1(17,54)&
   +4D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))&
   +HfxZpE*VS1(7,54)
VS0(17,83)=QCz*VS0(17,55)+WQz*VS1(17,55)&
   +4D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +HfxZpE*VS1(7,55)
VS0(17,84)=QCz*VS0(17,56)+WQz*VS1(17,56)&
   +5D0*r1x2E*(VS0(17,35)-ZxZpE*VS1(17,35))&
   +HfxZpE*VS1(7,56)
VS0(18,57)=QCx*VS0(18,36)+WQx*VS1(18,36)&
   +5D0*r1x2E*(VS0(18,21)-ZxZpE*VS1(18,21))&
   +HfxZpE*VS1(10,36)
VS0(18,58)=QCx*VS0(18,37)+WQx*VS1(18,37)&
   +4D0*r1x2E*(VS0(18,22)-ZxZpE*VS1(18,22))&
   +HfxZpE*VS1(10,37)
VS0(18,59)=QCx*VS0(18,38)+WQx*VS1(18,38)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))&
   +HfxZpE*VS1(10,38)
VS0(18,60)=QCx*VS0(18,39)+WQx*VS1(18,39)&
   +2D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))&
   +HfxZpE*VS1(10,39)
VS0(18,61)=QCy*VS0(18,39)+WQy*VS1(18,39)-r1x2E*VR1(18,39)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))
VS0(18,62)=QCy*VS0(18,40)+WQy*VS1(18,40)-r1x2E*VR1(18,40)&
   +4D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))
VS0(18,63)=QCy*VS0(18,41)+WQy*VS1(18,41)-r1x2E*VR1(18,41)&
   +5D0*r1x2E*(VS0(18,25)-ZxZpE*VS1(18,25))
VS0(18,64)=QCx*VS0(18,42)+WQx*VS1(18,42)&
   +4D0*r1x2E*(VS0(18,26)-ZxZpE*VS1(18,26))&
   +HfxZpE*VS1(10,42)
VS0(18,65)=QCx*VS0(18,43)+WQx*VS1(18,43)&
   +3D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +HfxZpE*VS1(10,43)
VS0(18,66)=QCx*VS0(18,44)+WQx*VS1(18,44)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +HfxZpE*VS1(10,44)
VS0(18,67)=QCy*VS0(18,44)+WQy*VS1(18,44)-r1x2E*VR1(18,44)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))
VS0(18,68)=QCy*VS0(18,45)+WQy*VS1(18,45)-r1x2E*VR1(18,45)&
   +3D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))
VS0(18,69)=QCy*VS0(18,46)+WQy*VS1(18,46)-r1x2E*VR1(18,46)&
   +4D0*r1x2E*(VS0(18,29)-ZxZpE*VS1(18,29))
VS0(18,70)=QCx*VS0(18,47)+WQx*VS1(18,47)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +HfxZpE*VS1(10,47)
VS0(18,71)=QCx*VS0(18,48)+WQx*VS1(18,48)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +HfxZpE*VS1(10,48)
VS0(18,72)=QCx*VS0(18,49)+WQx*VS1(18,49)&
   +r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +HfxZpE*VS1(10,49)
VS0(18,73)=QCy*VS0(18,49)+WQy*VS1(18,49)-r1x2E*VR1(18,49)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))
VS0(18,74)=QCy*VS0(18,50)+WQy*VS1(18,50)-r1x2E*VR1(18,50)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))
VS0(18,75)=QCx*VS0(18,51)+WQx*VS1(18,51)&
   +2D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +HfxZpE*VS1(10,51)
VS0(18,76)=QCz*VS0(18,48)+WQz*VS1(18,48)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(8,48)
VS0(18,77)=QCz*VS0(18,49)+WQz*VS1(18,49)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(8,49)
VS0(18,78)=QCy*VS0(18,53)+WQy*VS1(18,53)-r1x2E*VR1(18,53)&
   +2D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))
VS0(18,79)=QCz*VS0(18,51)+WQz*VS1(18,51)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(8,51)
VS0(18,80)=QCz*VS0(18,52)+WQz*VS1(18,52)&
   +3D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(8,52)
VS0(18,81)=QCz*VS0(18,53)+WQz*VS1(18,53)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(8,53)
VS0(18,82)=QCz*VS0(18,54)+WQz*VS1(18,54)&
   +4D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +2D0*HfxZpE*VS1(8,54)
VS0(18,83)=QCz*VS0(18,55)+WQz*VS1(18,55)&
   +4D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))&
   +2D0*HfxZpE*VS1(8,55)
VS0(18,84)=QCz*VS0(18,56)+WQz*VS1(18,56)&
   +5D0*r1x2E*(VS0(18,35)-ZxZpE*VS1(18,35))&
   +2D0*HfxZpE*VS1(8,56)
VS0(19,57)=QCx*VS0(19,36)+WQx*VS1(19,36)&
   +5D0*r1x2E*(VS0(19,21)-ZxZpE*VS1(19,21))
VS0(19,58)=QCx*VS0(19,37)+WQx*VS1(19,37)&
   +4D0*r1x2E*(VS0(19,22)-ZxZpE*VS1(19,22))
VS0(19,59)=QCx*VS0(19,38)+WQx*VS1(19,38)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))
VS0(19,60)=QCx*VS0(19,39)+WQx*VS1(19,39)&
   +2D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))
VS0(19,61)=QCy*VS0(19,39)+WQy*VS1(19,39)-r1x2E*VR1(19,39)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))&
   +HfxZpE*VS1(10,39)
VS0(19,62)=QCy*VS0(19,40)+WQy*VS1(19,40)-r1x2E*VR1(19,40)&
   +4D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))&
   +HfxZpE*VS1(10,40)
VS0(19,63)=QCy*VS0(19,41)+WQy*VS1(19,41)-r1x2E*VR1(19,41)&
   +5D0*r1x2E*(VS0(19,25)-ZxZpE*VS1(19,25))&
   +HfxZpE*VS1(10,41)
VS0(19,64)=QCx*VS0(19,42)+WQx*VS1(19,42)&
   +4D0*r1x2E*(VS0(19,26)-ZxZpE*VS1(19,26))
VS0(19,65)=QCx*VS0(19,43)+WQx*VS1(19,43)&
   +3D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))
VS0(19,66)=QCx*VS0(19,44)+WQx*VS1(19,44)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))
VS0(19,67)=QCy*VS0(19,44)+WQy*VS1(19,44)-r1x2E*VR1(19,44)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +HfxZpE*VS1(10,44)
VS0(19,68)=QCy*VS0(19,45)+WQy*VS1(19,45)-r1x2E*VR1(19,45)&
   +3D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +HfxZpE*VS1(10,45)
VS0(19,69)=QCy*VS0(19,46)+WQy*VS1(19,46)-r1x2E*VR1(19,46)&
   +4D0*r1x2E*(VS0(19,29)-ZxZpE*VS1(19,29))&
   +HfxZpE*VS1(10,46)
VS0(19,70)=QCx*VS0(19,47)+WQx*VS1(19,47)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))
VS0(19,71)=QCx*VS0(19,48)+WQx*VS1(19,48)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))
VS0(19,72)=QCx*VS0(19,49)+WQx*VS1(19,49)&
   +r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))
VS0(19,73)=QCy*VS0(19,49)+WQy*VS1(19,49)-r1x2E*VR1(19,49)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +HfxZpE*VS1(10,49)
VS0(19,74)=QCy*VS0(19,50)+WQy*VS1(19,50)-r1x2E*VR1(19,50)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +HfxZpE*VS1(10,50)
VS0(19,75)=QCx*VS0(19,51)+WQx*VS1(19,51)&
   +2D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))
VS0(19,76)=QCz*VS0(19,48)+WQz*VS1(19,48)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(9,48)
VS0(19,77)=QCz*VS0(19,49)+WQz*VS1(19,49)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(9,49)
VS0(19,78)=QCy*VS0(19,53)+WQy*VS1(19,53)-r1x2E*VR1(19,53)&
   +2D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +HfxZpE*VS1(10,53)
VS0(19,79)=QCz*VS0(19,51)+WQz*VS1(19,51)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(9,51)
VS0(19,80)=QCz*VS0(19,52)+WQz*VS1(19,52)&
   +3D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(9,52)
VS0(19,81)=QCz*VS0(19,53)+WQz*VS1(19,53)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(9,53)
VS0(19,82)=QCz*VS0(19,54)+WQz*VS1(19,54)&
   +4D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))&
   +2D0*HfxZpE*VS1(9,54)
VS0(19,83)=QCz*VS0(19,55)+WQz*VS1(19,55)&
   +4D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +2D0*HfxZpE*VS1(9,55)
VS0(19,84)=QCz*VS0(19,56)+WQz*VS1(19,56)&
   +5D0*r1x2E*(VS0(19,35)-ZxZpE*VS1(19,35))&
   +2D0*HfxZpE*VS1(9,56)
VS0(20,57)=QCx*VS0(20,36)+WQx*VS1(20,36)&
   +5D0*r1x2E*(VS0(20,21)-ZxZpE*VS1(20,21))
VS0(20,58)=QCx*VS0(20,37)+WQx*VS1(20,37)&
   +4D0*r1x2E*(VS0(20,22)-ZxZpE*VS1(20,22))
VS0(20,59)=QCx*VS0(20,38)+WQx*VS1(20,38)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,60)=QCx*VS0(20,39)+WQx*VS1(20,39)&
   +2D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,61)=QCy*VS0(20,39)+WQy*VS1(20,39)-r1x2E*VR1(20,39)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,62)=QCy*VS0(20,40)+WQy*VS1(20,40)-r1x2E*VR1(20,40)&
   +4D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,63)=QCy*VS0(20,41)+WQy*VS1(20,41)-r1x2E*VR1(20,41)&
   +5D0*r1x2E*(VS0(20,25)-ZxZpE*VS1(20,25))
VS0(20,64)=QCx*VS0(20,42)+WQx*VS1(20,42)&
   +4D0*r1x2E*(VS0(20,26)-ZxZpE*VS1(20,26))
VS0(20,65)=QCx*VS0(20,43)+WQx*VS1(20,43)&
   +3D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,66)=QCx*VS0(20,44)+WQx*VS1(20,44)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,67)=QCy*VS0(20,44)+WQy*VS1(20,44)-r1x2E*VR1(20,44)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,68)=QCy*VS0(20,45)+WQy*VS1(20,45)-r1x2E*VR1(20,45)&
   +3D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,69)=QCy*VS0(20,46)+WQy*VS1(20,46)-r1x2E*VR1(20,46)&
   +4D0*r1x2E*(VS0(20,29)-ZxZpE*VS1(20,29))
VS0(20,70)=QCx*VS0(20,47)+WQx*VS1(20,47)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))
VS0(20,71)=QCx*VS0(20,48)+WQx*VS1(20,48)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,72)=QCx*VS0(20,49)+WQx*VS1(20,49)&
   +r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,73)=QCy*VS0(20,49)+WQy*VS1(20,49)-r1x2E*VR1(20,49)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,74)=QCy*VS0(20,50)+WQy*VS1(20,50)-r1x2E*VR1(20,50)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,75)=QCx*VS0(20,51)+WQx*VS1(20,51)&
   +2D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))
VS0(20,76)=QCz*VS0(20,48)+WQz*VS1(20,48)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))&
   +3D0*HfxZpE*VS1(10,48)
VS0(20,77)=QCz*VS0(20,49)+WQz*VS1(20,49)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))&
   +3D0*HfxZpE*VS1(10,49)
VS0(20,78)=QCy*VS0(20,53)+WQy*VS1(20,53)-r1x2E*VR1(20,53)&
   +2D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))
VS0(20,79)=QCz*VS0(20,51)+WQz*VS1(20,51)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))&
   +3D0*HfxZpE*VS1(10,51)
VS0(20,80)=QCz*VS0(20,52)+WQz*VS1(20,52)&
   +3D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))&
   +3D0*HfxZpE*VS1(10,52)
VS0(20,81)=QCz*VS0(20,53)+WQz*VS1(20,53)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))&
   +3D0*HfxZpE*VS1(10,53)
VS0(20,82)=QCz*VS0(20,54)+WQz*VS1(20,54)&
   +4D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(10,54)
VS0(20,83)=QCz*VS0(20,55)+WQz*VS1(20,55)&
   +4D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(10,55)
VS0(20,84)=QCz*VS0(20,56)+WQz*VS1(20,56)&
   +5D0*r1x2E*(VS0(20,35)-ZxZpE*VS1(20,35))&
   +3D0*HfxZpE*VS1(10,56)
CASE(3)
VS0(11,57)=QCx*VS0(11,36)+WQx*VS1(11,36)&
   +5D0*r1x2E*(VS0(11,21)-ZxZpE*VS1(11,21))&
   +3D0*HfxZpE*VS1(5,36)
VS0(11,58)=QCx*VS0(11,37)+WQx*VS1(11,37)&
   +4D0*r1x2E*(VS0(11,22)-ZxZpE*VS1(11,22))&
   +3D0*HfxZpE*VS1(5,37)
VS0(11,59)=QCx*VS0(11,38)+WQx*VS1(11,38)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))&
   +3D0*HfxZpE*VS1(5,38)
VS0(11,60)=QCx*VS0(11,39)+WQx*VS1(11,39)&
   +2D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))&
   +3D0*HfxZpE*VS1(5,39)
VS0(11,61)=QCy*VS0(11,39)+WQy*VS1(11,39)&
   +3D0*r1x2E*(VS0(11,23)-ZxZpE*VS1(11,23))
VS0(11,62)=QCy*VS0(11,40)+WQy*VS1(11,40)&
   +4D0*r1x2E*(VS0(11,24)-ZxZpE*VS1(11,24))
VS0(11,63)=QCy*VS0(11,41)+WQy*VS1(11,41)&
   +5D0*r1x2E*(VS0(11,25)-ZxZpE*VS1(11,25))
VS0(11,64)=QCx*VS0(11,42)+WQx*VS1(11,42)&
   +4D0*r1x2E*(VS0(11,26)-ZxZpE*VS1(11,26))&
   +3D0*HfxZpE*VS1(5,42)
VS0(11,65)=QCx*VS0(11,43)+WQx*VS1(11,43)&
   +3D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))&
   +3D0*HfxZpE*VS1(5,43)
VS0(11,66)=QCx*VS0(11,44)+WQx*VS1(11,44)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))&
   +3D0*HfxZpE*VS1(5,44)
VS0(11,67)=QCy*VS0(11,44)+WQy*VS1(11,44)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,68)=QCy*VS0(11,45)+WQy*VS1(11,45)&
   +3D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,69)=QCy*VS0(11,46)+WQy*VS1(11,46)&
   +4D0*r1x2E*(VS0(11,29)-ZxZpE*VS1(11,29))
VS0(11,70)=QCx*VS0(11,47)+WQx*VS1(11,47)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))&
   +3D0*HfxZpE*VS1(5,47)
VS0(11,71)=QCx*VS0(11,48)+WQx*VS1(11,48)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))&
   +3D0*HfxZpE*VS1(5,48)
VS0(11,72)=QCx*VS0(11,49)+WQx*VS1(11,49)&
   +r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))&
   +3D0*HfxZpE*VS1(5,49)
VS0(11,73)=QCy*VS0(11,49)+WQy*VS1(11,49)&
   +2D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,74)=QCy*VS0(11,50)+WQy*VS1(11,50)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,75)=QCx*VS0(11,51)+WQx*VS1(11,51)&
   +2D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))&
   +3D0*HfxZpE*VS1(5,51)
VS0(11,76)=QCz*VS0(11,48)+WQz*VS1(11,48)-r1x2E*VR1(11,48)&
   +2D0*r1x2E*(VS0(11,27)-ZxZpE*VS1(11,27))
VS0(11,77)=QCz*VS0(11,49)+WQz*VS1(11,49)-r1x2E*VR1(11,49)&
   +2D0*r1x2E*(VS0(11,28)-ZxZpE*VS1(11,28))
VS0(11,78)=QCy*VS0(11,53)+WQy*VS1(11,53)&
   +2D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,79)=QCz*VS0(11,51)+WQz*VS1(11,51)-r1x2E*VR1(11,51)&
   +3D0*r1x2E*(VS0(11,30)-ZxZpE*VS1(11,30))
VS0(11,80)=QCz*VS0(11,52)+WQz*VS1(11,52)-r1x2E*VR1(11,52)&
   +3D0*r1x2E*(VS0(11,31)-ZxZpE*VS1(11,31))
VS0(11,81)=QCz*VS0(11,53)+WQz*VS1(11,53)-r1x2E*VR1(11,53)&
   +3D0*r1x2E*(VS0(11,32)-ZxZpE*VS1(11,32))
VS0(11,82)=QCz*VS0(11,54)+WQz*VS1(11,54)-r1x2E*VR1(11,54)&
   +4D0*r1x2E*(VS0(11,33)-ZxZpE*VS1(11,33))
VS0(11,83)=QCz*VS0(11,55)+WQz*VS1(11,55)-r1x2E*VR1(11,55)&
   +4D0*r1x2E*(VS0(11,34)-ZxZpE*VS1(11,34))
VS0(11,84)=QCz*VS0(11,56)+WQz*VS1(11,56)-r1x2E*VR1(11,56)&
   +5D0*r1x2E*(VS0(11,35)-ZxZpE*VS1(11,35))
VS0(12,57)=QCx*VS0(12,36)+WQx*VS1(12,36)&
   +5D0*r1x2E*(VS0(12,21)-ZxZpE*VS1(12,21))&
   +2D0*HfxZpE*VS1(6,36)
VS0(12,58)=QCx*VS0(12,37)+WQx*VS1(12,37)&
   +4D0*r1x2E*(VS0(12,22)-ZxZpE*VS1(12,22))&
   +2D0*HfxZpE*VS1(6,37)
VS0(12,59)=QCx*VS0(12,38)+WQx*VS1(12,38)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +2D0*HfxZpE*VS1(6,38)
VS0(12,60)=QCx*VS0(12,39)+WQx*VS1(12,39)&
   +2D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +2D0*HfxZpE*VS1(6,39)
VS0(12,61)=QCy*VS0(12,39)+WQy*VS1(12,39)&
   +3D0*r1x2E*(VS0(12,23)-ZxZpE*VS1(12,23))&
   +HfxZpE*VS1(5,39)
VS0(12,62)=QCy*VS0(12,40)+WQy*VS1(12,40)&
   +4D0*r1x2E*(VS0(12,24)-ZxZpE*VS1(12,24))&
   +HfxZpE*VS1(5,40)
VS0(12,63)=QCy*VS0(12,41)+WQy*VS1(12,41)&
   +5D0*r1x2E*(VS0(12,25)-ZxZpE*VS1(12,25))&
   +HfxZpE*VS1(5,41)
VS0(12,64)=QCx*VS0(12,42)+WQx*VS1(12,42)&
   +4D0*r1x2E*(VS0(12,26)-ZxZpE*VS1(12,26))&
   +2D0*HfxZpE*VS1(6,42)
VS0(12,65)=QCx*VS0(12,43)+WQx*VS1(12,43)&
   +3D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +2D0*HfxZpE*VS1(6,43)
VS0(12,66)=QCx*VS0(12,44)+WQx*VS1(12,44)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +2D0*HfxZpE*VS1(6,44)
VS0(12,67)=QCy*VS0(12,44)+WQy*VS1(12,44)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))&
   +HfxZpE*VS1(5,44)
VS0(12,68)=QCy*VS0(12,45)+WQy*VS1(12,45)&
   +3D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))&
   +HfxZpE*VS1(5,45)
VS0(12,69)=QCy*VS0(12,46)+WQy*VS1(12,46)&
   +4D0*r1x2E*(VS0(12,29)-ZxZpE*VS1(12,29))&
   +HfxZpE*VS1(5,46)
VS0(12,70)=QCx*VS0(12,47)+WQx*VS1(12,47)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))&
   +2D0*HfxZpE*VS1(6,47)
VS0(12,71)=QCx*VS0(12,48)+WQx*VS1(12,48)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +2D0*HfxZpE*VS1(6,48)
VS0(12,72)=QCx*VS0(12,49)+WQx*VS1(12,49)&
   +r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +2D0*HfxZpE*VS1(6,49)
VS0(12,73)=QCy*VS0(12,49)+WQy*VS1(12,49)&
   +2D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))&
   +HfxZpE*VS1(5,49)
VS0(12,74)=QCy*VS0(12,50)+WQy*VS1(12,50)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))&
   +HfxZpE*VS1(5,50)
VS0(12,75)=QCx*VS0(12,51)+WQx*VS1(12,51)&
   +2D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))&
   +2D0*HfxZpE*VS1(6,51)
VS0(12,76)=QCz*VS0(12,48)+WQz*VS1(12,48)-r1x2E*VR1(12,48)&
   +2D0*r1x2E*(VS0(12,27)-ZxZpE*VS1(12,27))
VS0(12,77)=QCz*VS0(12,49)+WQz*VS1(12,49)-r1x2E*VR1(12,49)&
   +2D0*r1x2E*(VS0(12,28)-ZxZpE*VS1(12,28))
VS0(12,78)=QCy*VS0(12,53)+WQy*VS1(12,53)&
   +2D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))&
   +HfxZpE*VS1(5,53)
VS0(12,79)=QCz*VS0(12,51)+WQz*VS1(12,51)-r1x2E*VR1(12,51)&
   +3D0*r1x2E*(VS0(12,30)-ZxZpE*VS1(12,30))
VS0(12,80)=QCz*VS0(12,52)+WQz*VS1(12,52)-r1x2E*VR1(12,52)&
   +3D0*r1x2E*(VS0(12,31)-ZxZpE*VS1(12,31))
VS0(12,81)=QCz*VS0(12,53)+WQz*VS1(12,53)-r1x2E*VR1(12,53)&
   +3D0*r1x2E*(VS0(12,32)-ZxZpE*VS1(12,32))
VS0(12,82)=QCz*VS0(12,54)+WQz*VS1(12,54)-r1x2E*VR1(12,54)&
   +4D0*r1x2E*(VS0(12,33)-ZxZpE*VS1(12,33))
VS0(12,83)=QCz*VS0(12,55)+WQz*VS1(12,55)-r1x2E*VR1(12,55)&
   +4D0*r1x2E*(VS0(12,34)-ZxZpE*VS1(12,34))
VS0(12,84)=QCz*VS0(12,56)+WQz*VS1(12,56)-r1x2E*VR1(12,56)&
   +5D0*r1x2E*(VS0(12,35)-ZxZpE*VS1(12,35))
VS0(13,57)=QCx*VS0(13,36)+WQx*VS1(13,36)&
   +5D0*r1x2E*(VS0(13,21)-ZxZpE*VS1(13,21))&
   +HfxZpE*VS1(7,36)
VS0(13,58)=QCx*VS0(13,37)+WQx*VS1(13,37)&
   +4D0*r1x2E*(VS0(13,22)-ZxZpE*VS1(13,22))&
   +HfxZpE*VS1(7,37)
VS0(13,59)=QCx*VS0(13,38)+WQx*VS1(13,38)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +HfxZpE*VS1(7,38)
VS0(13,60)=QCx*VS0(13,39)+WQx*VS1(13,39)&
   +2D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +HfxZpE*VS1(7,39)
VS0(13,61)=QCy*VS0(13,39)+WQy*VS1(13,39)&
   +3D0*r1x2E*(VS0(13,23)-ZxZpE*VS1(13,23))&
   +2D0*HfxZpE*VS1(6,39)
VS0(13,62)=QCy*VS0(13,40)+WQy*VS1(13,40)&
   +4D0*r1x2E*(VS0(13,24)-ZxZpE*VS1(13,24))&
   +2D0*HfxZpE*VS1(6,40)
VS0(13,63)=QCy*VS0(13,41)+WQy*VS1(13,41)&
   +5D0*r1x2E*(VS0(13,25)-ZxZpE*VS1(13,25))&
   +2D0*HfxZpE*VS1(6,41)
VS0(13,64)=QCx*VS0(13,42)+WQx*VS1(13,42)&
   +4D0*r1x2E*(VS0(13,26)-ZxZpE*VS1(13,26))&
   +HfxZpE*VS1(7,42)
VS0(13,65)=QCx*VS0(13,43)+WQx*VS1(13,43)&
   +3D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +HfxZpE*VS1(7,43)
VS0(13,66)=QCx*VS0(13,44)+WQx*VS1(13,44)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +HfxZpE*VS1(7,44)
VS0(13,67)=QCy*VS0(13,44)+WQy*VS1(13,44)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))&
   +2D0*HfxZpE*VS1(6,44)
VS0(13,68)=QCy*VS0(13,45)+WQy*VS1(13,45)&
   +3D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))&
   +2D0*HfxZpE*VS1(6,45)
VS0(13,69)=QCy*VS0(13,46)+WQy*VS1(13,46)&
   +4D0*r1x2E*(VS0(13,29)-ZxZpE*VS1(13,29))&
   +2D0*HfxZpE*VS1(6,46)
VS0(13,70)=QCx*VS0(13,47)+WQx*VS1(13,47)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))&
   +HfxZpE*VS1(7,47)
VS0(13,71)=QCx*VS0(13,48)+WQx*VS1(13,48)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +HfxZpE*VS1(7,48)
VS0(13,72)=QCx*VS0(13,49)+WQx*VS1(13,49)&
   +r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +HfxZpE*VS1(7,49)
VS0(13,73)=QCy*VS0(13,49)+WQy*VS1(13,49)&
   +2D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))&
   +2D0*HfxZpE*VS1(6,49)
VS0(13,74)=QCy*VS0(13,50)+WQy*VS1(13,50)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))&
   +2D0*HfxZpE*VS1(6,50)
VS0(13,75)=QCx*VS0(13,51)+WQx*VS1(13,51)&
   +2D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))&
   +HfxZpE*VS1(7,51)
VS0(13,76)=QCz*VS0(13,48)+WQz*VS1(13,48)-r1x2E*VR1(13,48)&
   +2D0*r1x2E*(VS0(13,27)-ZxZpE*VS1(13,27))
VS0(13,77)=QCz*VS0(13,49)+WQz*VS1(13,49)-r1x2E*VR1(13,49)&
   +2D0*r1x2E*(VS0(13,28)-ZxZpE*VS1(13,28))
VS0(13,78)=QCy*VS0(13,53)+WQy*VS1(13,53)&
   +2D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))&
   +2D0*HfxZpE*VS1(6,53)
VS0(13,79)=QCz*VS0(13,51)+WQz*VS1(13,51)-r1x2E*VR1(13,51)&
   +3D0*r1x2E*(VS0(13,30)-ZxZpE*VS1(13,30))
VS0(13,80)=QCz*VS0(13,52)+WQz*VS1(13,52)-r1x2E*VR1(13,52)&
   +3D0*r1x2E*(VS0(13,31)-ZxZpE*VS1(13,31))
VS0(13,81)=QCz*VS0(13,53)+WQz*VS1(13,53)-r1x2E*VR1(13,53)&
   +3D0*r1x2E*(VS0(13,32)-ZxZpE*VS1(13,32))
VS0(13,82)=QCz*VS0(13,54)+WQz*VS1(13,54)-r1x2E*VR1(13,54)&
   +4D0*r1x2E*(VS0(13,33)-ZxZpE*VS1(13,33))
VS0(13,83)=QCz*VS0(13,55)+WQz*VS1(13,55)-r1x2E*VR1(13,55)&
   +4D0*r1x2E*(VS0(13,34)-ZxZpE*VS1(13,34))
VS0(13,84)=QCz*VS0(13,56)+WQz*VS1(13,56)-r1x2E*VR1(13,56)&
   +5D0*r1x2E*(VS0(13,35)-ZxZpE*VS1(13,35))
VS0(14,57)=QCx*VS0(14,36)+WQx*VS1(14,36)&
   +5D0*r1x2E*(VS0(14,21)-ZxZpE*VS1(14,21))
VS0(14,58)=QCx*VS0(14,37)+WQx*VS1(14,37)&
   +4D0*r1x2E*(VS0(14,22)-ZxZpE*VS1(14,22))
VS0(14,59)=QCx*VS0(14,38)+WQx*VS1(14,38)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))
VS0(14,60)=QCx*VS0(14,39)+WQx*VS1(14,39)&
   +2D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))
VS0(14,61)=QCy*VS0(14,39)+WQy*VS1(14,39)&
   +3D0*r1x2E*(VS0(14,23)-ZxZpE*VS1(14,23))&
   +3D0*HfxZpE*VS1(7,39)
VS0(14,62)=QCy*VS0(14,40)+WQy*VS1(14,40)&
   +4D0*r1x2E*(VS0(14,24)-ZxZpE*VS1(14,24))&
   +3D0*HfxZpE*VS1(7,40)
VS0(14,63)=QCy*VS0(14,41)+WQy*VS1(14,41)&
   +5D0*r1x2E*(VS0(14,25)-ZxZpE*VS1(14,25))&
   +3D0*HfxZpE*VS1(7,41)
VS0(14,64)=QCx*VS0(14,42)+WQx*VS1(14,42)&
   +4D0*r1x2E*(VS0(14,26)-ZxZpE*VS1(14,26))
VS0(14,65)=QCx*VS0(14,43)+WQx*VS1(14,43)&
   +3D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,66)=QCx*VS0(14,44)+WQx*VS1(14,44)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,67)=QCy*VS0(14,44)+WQy*VS1(14,44)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))&
   +3D0*HfxZpE*VS1(7,44)
VS0(14,68)=QCy*VS0(14,45)+WQy*VS1(14,45)&
   +3D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))&
   +3D0*HfxZpE*VS1(7,45)
VS0(14,69)=QCy*VS0(14,46)+WQy*VS1(14,46)&
   +4D0*r1x2E*(VS0(14,29)-ZxZpE*VS1(14,29))&
   +3D0*HfxZpE*VS1(7,46)
VS0(14,70)=QCx*VS0(14,47)+WQx*VS1(14,47)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,71)=QCx*VS0(14,48)+WQx*VS1(14,48)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,72)=QCx*VS0(14,49)+WQx*VS1(14,49)&
   +r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,73)=QCy*VS0(14,49)+WQy*VS1(14,49)&
   +2D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))&
   +3D0*HfxZpE*VS1(7,49)
VS0(14,74)=QCy*VS0(14,50)+WQy*VS1(14,50)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))&
   +3D0*HfxZpE*VS1(7,50)
VS0(14,75)=QCx*VS0(14,51)+WQx*VS1(14,51)&
   +2D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,76)=QCz*VS0(14,48)+WQz*VS1(14,48)-r1x2E*VR1(14,48)&
   +2D0*r1x2E*(VS0(14,27)-ZxZpE*VS1(14,27))
VS0(14,77)=QCz*VS0(14,49)+WQz*VS1(14,49)-r1x2E*VR1(14,49)&
   +2D0*r1x2E*(VS0(14,28)-ZxZpE*VS1(14,28))
VS0(14,78)=QCy*VS0(14,53)+WQy*VS1(14,53)&
   +2D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))&
   +3D0*HfxZpE*VS1(7,53)
VS0(14,79)=QCz*VS0(14,51)+WQz*VS1(14,51)-r1x2E*VR1(14,51)&
   +3D0*r1x2E*(VS0(14,30)-ZxZpE*VS1(14,30))
VS0(14,80)=QCz*VS0(14,52)+WQz*VS1(14,52)-r1x2E*VR1(14,52)&
   +3D0*r1x2E*(VS0(14,31)-ZxZpE*VS1(14,31))
VS0(14,81)=QCz*VS0(14,53)+WQz*VS1(14,53)-r1x2E*VR1(14,53)&
   +3D0*r1x2E*(VS0(14,32)-ZxZpE*VS1(14,32))
VS0(14,82)=QCz*VS0(14,54)+WQz*VS1(14,54)-r1x2E*VR1(14,54)&
   +4D0*r1x2E*(VS0(14,33)-ZxZpE*VS1(14,33))
VS0(14,83)=QCz*VS0(14,55)+WQz*VS1(14,55)-r1x2E*VR1(14,55)&
   +4D0*r1x2E*(VS0(14,34)-ZxZpE*VS1(14,34))
VS0(14,84)=QCz*VS0(14,56)+WQz*VS1(14,56)-r1x2E*VR1(14,56)&
   +5D0*r1x2E*(VS0(14,35)-ZxZpE*VS1(14,35))
VS0(15,57)=QCx*VS0(15,36)+WQx*VS1(15,36)&
   +5D0*r1x2E*(VS0(15,21)-ZxZpE*VS1(15,21))&
   +2D0*HfxZpE*VS1(8,36)
VS0(15,58)=QCx*VS0(15,37)+WQx*VS1(15,37)&
   +4D0*r1x2E*(VS0(15,22)-ZxZpE*VS1(15,22))&
   +2D0*HfxZpE*VS1(8,37)
VS0(15,59)=QCx*VS0(15,38)+WQx*VS1(15,38)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))&
   +2D0*HfxZpE*VS1(8,38)
VS0(15,60)=QCx*VS0(15,39)+WQx*VS1(15,39)&
   +2D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))&
   +2D0*HfxZpE*VS1(8,39)
VS0(15,61)=QCy*VS0(15,39)+WQy*VS1(15,39)&
   +3D0*r1x2E*(VS0(15,23)-ZxZpE*VS1(15,23))
VS0(15,62)=QCy*VS0(15,40)+WQy*VS1(15,40)&
   +4D0*r1x2E*(VS0(15,24)-ZxZpE*VS1(15,24))
VS0(15,63)=QCy*VS0(15,41)+WQy*VS1(15,41)&
   +5D0*r1x2E*(VS0(15,25)-ZxZpE*VS1(15,25))
VS0(15,64)=QCx*VS0(15,42)+WQx*VS1(15,42)&
   +4D0*r1x2E*(VS0(15,26)-ZxZpE*VS1(15,26))&
   +2D0*HfxZpE*VS1(8,42)
VS0(15,65)=QCx*VS0(15,43)+WQx*VS1(15,43)&
   +3D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +2D0*HfxZpE*VS1(8,43)
VS0(15,66)=QCx*VS0(15,44)+WQx*VS1(15,44)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +2D0*HfxZpE*VS1(8,44)
VS0(15,67)=QCy*VS0(15,44)+WQy*VS1(15,44)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))
VS0(15,68)=QCy*VS0(15,45)+WQy*VS1(15,45)&
   +3D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))
VS0(15,69)=QCy*VS0(15,46)+WQy*VS1(15,46)&
   +4D0*r1x2E*(VS0(15,29)-ZxZpE*VS1(15,29))
VS0(15,70)=QCx*VS0(15,47)+WQx*VS1(15,47)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +2D0*HfxZpE*VS1(8,47)
VS0(15,71)=QCx*VS0(15,48)+WQx*VS1(15,48)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +2D0*HfxZpE*VS1(8,48)
VS0(15,72)=QCx*VS0(15,49)+WQx*VS1(15,49)&
   +r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +2D0*HfxZpE*VS1(8,49)
VS0(15,73)=QCy*VS0(15,49)+WQy*VS1(15,49)&
   +2D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))
VS0(15,74)=QCy*VS0(15,50)+WQy*VS1(15,50)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))
VS0(15,75)=QCx*VS0(15,51)+WQx*VS1(15,51)&
   +2D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +2D0*HfxZpE*VS1(8,51)
VS0(15,76)=QCz*VS0(15,48)+WQz*VS1(15,48)-r1x2E*VR1(15,48)&
   +2D0*r1x2E*(VS0(15,27)-ZxZpE*VS1(15,27))&
   +HfxZpE*VS1(5,48)
VS0(15,77)=QCz*VS0(15,49)+WQz*VS1(15,49)-r1x2E*VR1(15,49)&
   +2D0*r1x2E*(VS0(15,28)-ZxZpE*VS1(15,28))&
   +HfxZpE*VS1(5,49)
VS0(15,78)=QCy*VS0(15,53)+WQy*VS1(15,53)&
   +2D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))
VS0(15,79)=QCz*VS0(15,51)+WQz*VS1(15,51)-r1x2E*VR1(15,51)&
   +3D0*r1x2E*(VS0(15,30)-ZxZpE*VS1(15,30))&
   +HfxZpE*VS1(5,51)
VS0(15,80)=QCz*VS0(15,52)+WQz*VS1(15,52)-r1x2E*VR1(15,52)&
   +3D0*r1x2E*(VS0(15,31)-ZxZpE*VS1(15,31))&
   +HfxZpE*VS1(5,52)
VS0(15,81)=QCz*VS0(15,53)+WQz*VS1(15,53)-r1x2E*VR1(15,53)&
   +3D0*r1x2E*(VS0(15,32)-ZxZpE*VS1(15,32))&
   +HfxZpE*VS1(5,53)
VS0(15,82)=QCz*VS0(15,54)+WQz*VS1(15,54)-r1x2E*VR1(15,54)&
   +4D0*r1x2E*(VS0(15,33)-ZxZpE*VS1(15,33))&
   +HfxZpE*VS1(5,54)
VS0(15,83)=QCz*VS0(15,55)+WQz*VS1(15,55)-r1x2E*VR1(15,55)&
   +4D0*r1x2E*(VS0(15,34)-ZxZpE*VS1(15,34))&
   +HfxZpE*VS1(5,55)
VS0(15,84)=QCz*VS0(15,56)+WQz*VS1(15,56)-r1x2E*VR1(15,56)&
   +5D0*r1x2E*(VS0(15,35)-ZxZpE*VS1(15,35))&
   +HfxZpE*VS1(5,56)
VS0(16,57)=QCx*VS0(16,36)+WQx*VS1(16,36)&
   +5D0*r1x2E*(VS0(16,21)-ZxZpE*VS1(16,21))&
   +HfxZpE*VS1(9,36)
VS0(16,58)=QCx*VS0(16,37)+WQx*VS1(16,37)&
   +4D0*r1x2E*(VS0(16,22)-ZxZpE*VS1(16,22))&
   +HfxZpE*VS1(9,37)
VS0(16,59)=QCx*VS0(16,38)+WQx*VS1(16,38)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(9,38)
VS0(16,60)=QCx*VS0(16,39)+WQx*VS1(16,39)&
   +2D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(9,39)
VS0(16,61)=QCy*VS0(16,39)+WQy*VS1(16,39)&
   +3D0*r1x2E*(VS0(16,23)-ZxZpE*VS1(16,23))&
   +HfxZpE*VS1(8,39)
VS0(16,62)=QCy*VS0(16,40)+WQy*VS1(16,40)&
   +4D0*r1x2E*(VS0(16,24)-ZxZpE*VS1(16,24))&
   +HfxZpE*VS1(8,40)
VS0(16,63)=QCy*VS0(16,41)+WQy*VS1(16,41)&
   +5D0*r1x2E*(VS0(16,25)-ZxZpE*VS1(16,25))&
   +HfxZpE*VS1(8,41)
VS0(16,64)=QCx*VS0(16,42)+WQx*VS1(16,42)&
   +4D0*r1x2E*(VS0(16,26)-ZxZpE*VS1(16,26))&
   +HfxZpE*VS1(9,42)
VS0(16,65)=QCx*VS0(16,43)+WQx*VS1(16,43)&
   +3D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(9,43)
VS0(16,66)=QCx*VS0(16,44)+WQx*VS1(16,44)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(9,44)
VS0(16,67)=QCy*VS0(16,44)+WQy*VS1(16,44)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(8,44)
VS0(16,68)=QCy*VS0(16,45)+WQy*VS1(16,45)&
   +3D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(8,45)
VS0(16,69)=QCy*VS0(16,46)+WQy*VS1(16,46)&
   +4D0*r1x2E*(VS0(16,29)-ZxZpE*VS1(16,29))&
   +HfxZpE*VS1(8,46)
VS0(16,70)=QCx*VS0(16,47)+WQx*VS1(16,47)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(9,47)
VS0(16,71)=QCx*VS0(16,48)+WQx*VS1(16,48)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(9,48)
VS0(16,72)=QCx*VS0(16,49)+WQx*VS1(16,49)&
   +r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(9,49)
VS0(16,73)=QCy*VS0(16,49)+WQy*VS1(16,49)&
   +2D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(8,49)
VS0(16,74)=QCy*VS0(16,50)+WQy*VS1(16,50)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(8,50)
VS0(16,75)=QCx*VS0(16,51)+WQx*VS1(16,51)&
   +2D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(9,51)
VS0(16,76)=QCz*VS0(16,48)+WQz*VS1(16,48)-r1x2E*VR1(16,48)&
   +2D0*r1x2E*(VS0(16,27)-ZxZpE*VS1(16,27))&
   +HfxZpE*VS1(6,48)
VS0(16,77)=QCz*VS0(16,49)+WQz*VS1(16,49)-r1x2E*VR1(16,49)&
   +2D0*r1x2E*(VS0(16,28)-ZxZpE*VS1(16,28))&
   +HfxZpE*VS1(6,49)
VS0(16,78)=QCy*VS0(16,53)+WQy*VS1(16,53)&
   +2D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(8,53)
VS0(16,79)=QCz*VS0(16,51)+WQz*VS1(16,51)-r1x2E*VR1(16,51)&
   +3D0*r1x2E*(VS0(16,30)-ZxZpE*VS1(16,30))&
   +HfxZpE*VS1(6,51)
VS0(16,80)=QCz*VS0(16,52)+WQz*VS1(16,52)-r1x2E*VR1(16,52)&
   +3D0*r1x2E*(VS0(16,31)-ZxZpE*VS1(16,31))&
   +HfxZpE*VS1(6,52)
VS0(16,81)=QCz*VS0(16,53)+WQz*VS1(16,53)-r1x2E*VR1(16,53)&
   +3D0*r1x2E*(VS0(16,32)-ZxZpE*VS1(16,32))&
   +HfxZpE*VS1(6,53)
VS0(16,82)=QCz*VS0(16,54)+WQz*VS1(16,54)-r1x2E*VR1(16,54)&
   +4D0*r1x2E*(VS0(16,33)-ZxZpE*VS1(16,33))&
   +HfxZpE*VS1(6,54)
VS0(16,83)=QCz*VS0(16,55)+WQz*VS1(16,55)-r1x2E*VR1(16,55)&
   +4D0*r1x2E*(VS0(16,34)-ZxZpE*VS1(16,34))&
   +HfxZpE*VS1(6,55)
VS0(16,84)=QCz*VS0(16,56)+WQz*VS1(16,56)-r1x2E*VR1(16,56)&
   +5D0*r1x2E*(VS0(16,35)-ZxZpE*VS1(16,35))&
   +HfxZpE*VS1(6,56)
VS0(17,57)=QCx*VS0(17,36)+WQx*VS1(17,36)&
   +5D0*r1x2E*(VS0(17,21)-ZxZpE*VS1(17,21))
VS0(17,58)=QCx*VS0(17,37)+WQx*VS1(17,37)&
   +4D0*r1x2E*(VS0(17,22)-ZxZpE*VS1(17,22))
VS0(17,59)=QCx*VS0(17,38)+WQx*VS1(17,38)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))
VS0(17,60)=QCx*VS0(17,39)+WQx*VS1(17,39)&
   +2D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))
VS0(17,61)=QCy*VS0(17,39)+WQy*VS1(17,39)&
   +3D0*r1x2E*(VS0(17,23)-ZxZpE*VS1(17,23))&
   +2D0*HfxZpE*VS1(9,39)
VS0(17,62)=QCy*VS0(17,40)+WQy*VS1(17,40)&
   +4D0*r1x2E*(VS0(17,24)-ZxZpE*VS1(17,24))&
   +2D0*HfxZpE*VS1(9,40)
VS0(17,63)=QCy*VS0(17,41)+WQy*VS1(17,41)&
   +5D0*r1x2E*(VS0(17,25)-ZxZpE*VS1(17,25))&
   +2D0*HfxZpE*VS1(9,41)
VS0(17,64)=QCx*VS0(17,42)+WQx*VS1(17,42)&
   +4D0*r1x2E*(VS0(17,26)-ZxZpE*VS1(17,26))
VS0(17,65)=QCx*VS0(17,43)+WQx*VS1(17,43)&
   +3D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))
VS0(17,66)=QCx*VS0(17,44)+WQx*VS1(17,44)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))
VS0(17,67)=QCy*VS0(17,44)+WQy*VS1(17,44)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +2D0*HfxZpE*VS1(9,44)
VS0(17,68)=QCy*VS0(17,45)+WQy*VS1(17,45)&
   +3D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +2D0*HfxZpE*VS1(9,45)
VS0(17,69)=QCy*VS0(17,46)+WQy*VS1(17,46)&
   +4D0*r1x2E*(VS0(17,29)-ZxZpE*VS1(17,29))&
   +2D0*HfxZpE*VS1(9,46)
VS0(17,70)=QCx*VS0(17,47)+WQx*VS1(17,47)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))
VS0(17,71)=QCx*VS0(17,48)+WQx*VS1(17,48)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))
VS0(17,72)=QCx*VS0(17,49)+WQx*VS1(17,49)&
   +r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))
VS0(17,73)=QCy*VS0(17,49)+WQy*VS1(17,49)&
   +2D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +2D0*HfxZpE*VS1(9,49)
VS0(17,74)=QCy*VS0(17,50)+WQy*VS1(17,50)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +2D0*HfxZpE*VS1(9,50)
VS0(17,75)=QCx*VS0(17,51)+WQx*VS1(17,51)&
   +2D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))
VS0(17,76)=QCz*VS0(17,48)+WQz*VS1(17,48)-r1x2E*VR1(17,48)&
   +2D0*r1x2E*(VS0(17,27)-ZxZpE*VS1(17,27))&
   +HfxZpE*VS1(7,48)
VS0(17,77)=QCz*VS0(17,49)+WQz*VS1(17,49)-r1x2E*VR1(17,49)&
   +2D0*r1x2E*(VS0(17,28)-ZxZpE*VS1(17,28))&
   +HfxZpE*VS1(7,49)
VS0(17,78)=QCy*VS0(17,53)+WQy*VS1(17,53)&
   +2D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +2D0*HfxZpE*VS1(9,53)
VS0(17,79)=QCz*VS0(17,51)+WQz*VS1(17,51)-r1x2E*VR1(17,51)&
   +3D0*r1x2E*(VS0(17,30)-ZxZpE*VS1(17,30))&
   +HfxZpE*VS1(7,51)
VS0(17,80)=QCz*VS0(17,52)+WQz*VS1(17,52)-r1x2E*VR1(17,52)&
   +3D0*r1x2E*(VS0(17,31)-ZxZpE*VS1(17,31))&
   +HfxZpE*VS1(7,52)
VS0(17,81)=QCz*VS0(17,53)+WQz*VS1(17,53)-r1x2E*VR1(17,53)&
   +3D0*r1x2E*(VS0(17,32)-ZxZpE*VS1(17,32))&
   +HfxZpE*VS1(7,53)
VS0(17,82)=QCz*VS0(17,54)+WQz*VS1(17,54)-r1x2E*VR1(17,54)&
   +4D0*r1x2E*(VS0(17,33)-ZxZpE*VS1(17,33))&
   +HfxZpE*VS1(7,54)
VS0(17,83)=QCz*VS0(17,55)+WQz*VS1(17,55)-r1x2E*VR1(17,55)&
   +4D0*r1x2E*(VS0(17,34)-ZxZpE*VS1(17,34))&
   +HfxZpE*VS1(7,55)
VS0(17,84)=QCz*VS0(17,56)+WQz*VS1(17,56)-r1x2E*VR1(17,56)&
   +5D0*r1x2E*(VS0(17,35)-ZxZpE*VS1(17,35))&
   +HfxZpE*VS1(7,56)
VS0(18,57)=QCx*VS0(18,36)+WQx*VS1(18,36)&
   +5D0*r1x2E*(VS0(18,21)-ZxZpE*VS1(18,21))&
   +HfxZpE*VS1(10,36)
VS0(18,58)=QCx*VS0(18,37)+WQx*VS1(18,37)&
   +4D0*r1x2E*(VS0(18,22)-ZxZpE*VS1(18,22))&
   +HfxZpE*VS1(10,37)
VS0(18,59)=QCx*VS0(18,38)+WQx*VS1(18,38)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))&
   +HfxZpE*VS1(10,38)
VS0(18,60)=QCx*VS0(18,39)+WQx*VS1(18,39)&
   +2D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))&
   +HfxZpE*VS1(10,39)
VS0(18,61)=QCy*VS0(18,39)+WQy*VS1(18,39)&
   +3D0*r1x2E*(VS0(18,23)-ZxZpE*VS1(18,23))
VS0(18,62)=QCy*VS0(18,40)+WQy*VS1(18,40)&
   +4D0*r1x2E*(VS0(18,24)-ZxZpE*VS1(18,24))
VS0(18,63)=QCy*VS0(18,41)+WQy*VS1(18,41)&
   +5D0*r1x2E*(VS0(18,25)-ZxZpE*VS1(18,25))
VS0(18,64)=QCx*VS0(18,42)+WQx*VS1(18,42)&
   +4D0*r1x2E*(VS0(18,26)-ZxZpE*VS1(18,26))&
   +HfxZpE*VS1(10,42)
VS0(18,65)=QCx*VS0(18,43)+WQx*VS1(18,43)&
   +3D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +HfxZpE*VS1(10,43)
VS0(18,66)=QCx*VS0(18,44)+WQx*VS1(18,44)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +HfxZpE*VS1(10,44)
VS0(18,67)=QCy*VS0(18,44)+WQy*VS1(18,44)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))
VS0(18,68)=QCy*VS0(18,45)+WQy*VS1(18,45)&
   +3D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))
VS0(18,69)=QCy*VS0(18,46)+WQy*VS1(18,46)&
   +4D0*r1x2E*(VS0(18,29)-ZxZpE*VS1(18,29))
VS0(18,70)=QCx*VS0(18,47)+WQx*VS1(18,47)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +HfxZpE*VS1(10,47)
VS0(18,71)=QCx*VS0(18,48)+WQx*VS1(18,48)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +HfxZpE*VS1(10,48)
VS0(18,72)=QCx*VS0(18,49)+WQx*VS1(18,49)&
   +r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +HfxZpE*VS1(10,49)
VS0(18,73)=QCy*VS0(18,49)+WQy*VS1(18,49)&
   +2D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))
VS0(18,74)=QCy*VS0(18,50)+WQy*VS1(18,50)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))
VS0(18,75)=QCx*VS0(18,51)+WQx*VS1(18,51)&
   +2D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +HfxZpE*VS1(10,51)
VS0(18,76)=QCz*VS0(18,48)+WQz*VS1(18,48)-r1x2E*VR1(18,48)&
   +2D0*r1x2E*(VS0(18,27)-ZxZpE*VS1(18,27))&
   +2D0*HfxZpE*VS1(8,48)
VS0(18,77)=QCz*VS0(18,49)+WQz*VS1(18,49)-r1x2E*VR1(18,49)&
   +2D0*r1x2E*(VS0(18,28)-ZxZpE*VS1(18,28))&
   +2D0*HfxZpE*VS1(8,49)
VS0(18,78)=QCy*VS0(18,53)+WQy*VS1(18,53)&
   +2D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))
VS0(18,79)=QCz*VS0(18,51)+WQz*VS1(18,51)-r1x2E*VR1(18,51)&
   +3D0*r1x2E*(VS0(18,30)-ZxZpE*VS1(18,30))&
   +2D0*HfxZpE*VS1(8,51)
VS0(18,80)=QCz*VS0(18,52)+WQz*VS1(18,52)-r1x2E*VR1(18,52)&
   +3D0*r1x2E*(VS0(18,31)-ZxZpE*VS1(18,31))&
   +2D0*HfxZpE*VS1(8,52)
VS0(18,81)=QCz*VS0(18,53)+WQz*VS1(18,53)-r1x2E*VR1(18,53)&
   +3D0*r1x2E*(VS0(18,32)-ZxZpE*VS1(18,32))&
   +2D0*HfxZpE*VS1(8,53)
VS0(18,82)=QCz*VS0(18,54)+WQz*VS1(18,54)-r1x2E*VR1(18,54)&
   +4D0*r1x2E*(VS0(18,33)-ZxZpE*VS1(18,33))&
   +2D0*HfxZpE*VS1(8,54)
VS0(18,83)=QCz*VS0(18,55)+WQz*VS1(18,55)-r1x2E*VR1(18,55)&
   +4D0*r1x2E*(VS0(18,34)-ZxZpE*VS1(18,34))&
   +2D0*HfxZpE*VS1(8,55)
VS0(18,84)=QCz*VS0(18,56)+WQz*VS1(18,56)-r1x2E*VR1(18,56)&
   +5D0*r1x2E*(VS0(18,35)-ZxZpE*VS1(18,35))&
   +2D0*HfxZpE*VS1(8,56)
VS0(19,57)=QCx*VS0(19,36)+WQx*VS1(19,36)&
   +5D0*r1x2E*(VS0(19,21)-ZxZpE*VS1(19,21))
VS0(19,58)=QCx*VS0(19,37)+WQx*VS1(19,37)&
   +4D0*r1x2E*(VS0(19,22)-ZxZpE*VS1(19,22))
VS0(19,59)=QCx*VS0(19,38)+WQx*VS1(19,38)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))
VS0(19,60)=QCx*VS0(19,39)+WQx*VS1(19,39)&
   +2D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))
VS0(19,61)=QCy*VS0(19,39)+WQy*VS1(19,39)&
   +3D0*r1x2E*(VS0(19,23)-ZxZpE*VS1(19,23))&
   +HfxZpE*VS1(10,39)
VS0(19,62)=QCy*VS0(19,40)+WQy*VS1(19,40)&
   +4D0*r1x2E*(VS0(19,24)-ZxZpE*VS1(19,24))&
   +HfxZpE*VS1(10,40)
VS0(19,63)=QCy*VS0(19,41)+WQy*VS1(19,41)&
   +5D0*r1x2E*(VS0(19,25)-ZxZpE*VS1(19,25))&
   +HfxZpE*VS1(10,41)
VS0(19,64)=QCx*VS0(19,42)+WQx*VS1(19,42)&
   +4D0*r1x2E*(VS0(19,26)-ZxZpE*VS1(19,26))
VS0(19,65)=QCx*VS0(19,43)+WQx*VS1(19,43)&
   +3D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))
VS0(19,66)=QCx*VS0(19,44)+WQx*VS1(19,44)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))
VS0(19,67)=QCy*VS0(19,44)+WQy*VS1(19,44)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +HfxZpE*VS1(10,44)
VS0(19,68)=QCy*VS0(19,45)+WQy*VS1(19,45)&
   +3D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +HfxZpE*VS1(10,45)
VS0(19,69)=QCy*VS0(19,46)+WQy*VS1(19,46)&
   +4D0*r1x2E*(VS0(19,29)-ZxZpE*VS1(19,29))&
   +HfxZpE*VS1(10,46)
VS0(19,70)=QCx*VS0(19,47)+WQx*VS1(19,47)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))
VS0(19,71)=QCx*VS0(19,48)+WQx*VS1(19,48)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))
VS0(19,72)=QCx*VS0(19,49)+WQx*VS1(19,49)&
   +r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))
VS0(19,73)=QCy*VS0(19,49)+WQy*VS1(19,49)&
   +2D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +HfxZpE*VS1(10,49)
VS0(19,74)=QCy*VS0(19,50)+WQy*VS1(19,50)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +HfxZpE*VS1(10,50)
VS0(19,75)=QCx*VS0(19,51)+WQx*VS1(19,51)&
   +2D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))
VS0(19,76)=QCz*VS0(19,48)+WQz*VS1(19,48)-r1x2E*VR1(19,48)&
   +2D0*r1x2E*(VS0(19,27)-ZxZpE*VS1(19,27))&
   +2D0*HfxZpE*VS1(9,48)
VS0(19,77)=QCz*VS0(19,49)+WQz*VS1(19,49)-r1x2E*VR1(19,49)&
   +2D0*r1x2E*(VS0(19,28)-ZxZpE*VS1(19,28))&
   +2D0*HfxZpE*VS1(9,49)
VS0(19,78)=QCy*VS0(19,53)+WQy*VS1(19,53)&
   +2D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +HfxZpE*VS1(10,53)
VS0(19,79)=QCz*VS0(19,51)+WQz*VS1(19,51)-r1x2E*VR1(19,51)&
   +3D0*r1x2E*(VS0(19,30)-ZxZpE*VS1(19,30))&
   +2D0*HfxZpE*VS1(9,51)
VS0(19,80)=QCz*VS0(19,52)+WQz*VS1(19,52)-r1x2E*VR1(19,52)&
   +3D0*r1x2E*(VS0(19,31)-ZxZpE*VS1(19,31))&
   +2D0*HfxZpE*VS1(9,52)
VS0(19,81)=QCz*VS0(19,53)+WQz*VS1(19,53)-r1x2E*VR1(19,53)&
   +3D0*r1x2E*(VS0(19,32)-ZxZpE*VS1(19,32))&
   +2D0*HfxZpE*VS1(9,53)
VS0(19,82)=QCz*VS0(19,54)+WQz*VS1(19,54)-r1x2E*VR1(19,54)&
   +4D0*r1x2E*(VS0(19,33)-ZxZpE*VS1(19,33))&
   +2D0*HfxZpE*VS1(9,54)
VS0(19,83)=QCz*VS0(19,55)+WQz*VS1(19,55)-r1x2E*VR1(19,55)&
   +4D0*r1x2E*(VS0(19,34)-ZxZpE*VS1(19,34))&
   +2D0*HfxZpE*VS1(9,55)
VS0(19,84)=QCz*VS0(19,56)+WQz*VS1(19,56)-r1x2E*VR1(19,56)&
   +5D0*r1x2E*(VS0(19,35)-ZxZpE*VS1(19,35))&
   +2D0*HfxZpE*VS1(9,56)
VS0(20,57)=QCx*VS0(20,36)+WQx*VS1(20,36)&
   +5D0*r1x2E*(VS0(20,21)-ZxZpE*VS1(20,21))
VS0(20,58)=QCx*VS0(20,37)+WQx*VS1(20,37)&
   +4D0*r1x2E*(VS0(20,22)-ZxZpE*VS1(20,22))
VS0(20,59)=QCx*VS0(20,38)+WQx*VS1(20,38)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,60)=QCx*VS0(20,39)+WQx*VS1(20,39)&
   +2D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,61)=QCy*VS0(20,39)+WQy*VS1(20,39)&
   +3D0*r1x2E*(VS0(20,23)-ZxZpE*VS1(20,23))
VS0(20,62)=QCy*VS0(20,40)+WQy*VS1(20,40)&
   +4D0*r1x2E*(VS0(20,24)-ZxZpE*VS1(20,24))
VS0(20,63)=QCy*VS0(20,41)+WQy*VS1(20,41)&
   +5D0*r1x2E*(VS0(20,25)-ZxZpE*VS1(20,25))
VS0(20,64)=QCx*VS0(20,42)+WQx*VS1(20,42)&
   +4D0*r1x2E*(VS0(20,26)-ZxZpE*VS1(20,26))
VS0(20,65)=QCx*VS0(20,43)+WQx*VS1(20,43)&
   +3D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,66)=QCx*VS0(20,44)+WQx*VS1(20,44)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,67)=QCy*VS0(20,44)+WQy*VS1(20,44)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))
VS0(20,68)=QCy*VS0(20,45)+WQy*VS1(20,45)&
   +3D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))
VS0(20,69)=QCy*VS0(20,46)+WQy*VS1(20,46)&
   +4D0*r1x2E*(VS0(20,29)-ZxZpE*VS1(20,29))
VS0(20,70)=QCx*VS0(20,47)+WQx*VS1(20,47)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))
VS0(20,71)=QCx*VS0(20,48)+WQx*VS1(20,48)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,72)=QCx*VS0(20,49)+WQx*VS1(20,49)&
   +r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,73)=QCy*VS0(20,49)+WQy*VS1(20,49)&
   +2D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))
VS0(20,74)=QCy*VS0(20,50)+WQy*VS1(20,50)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))
VS0(20,75)=QCx*VS0(20,51)+WQx*VS1(20,51)&
   +2D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))
VS0(20,76)=QCz*VS0(20,48)+WQz*VS1(20,48)-r1x2E*VR1(20,48)&
   +2D0*r1x2E*(VS0(20,27)-ZxZpE*VS1(20,27))&
   +3D0*HfxZpE*VS1(10,48)
VS0(20,77)=QCz*VS0(20,49)+WQz*VS1(20,49)-r1x2E*VR1(20,49)&
   +2D0*r1x2E*(VS0(20,28)-ZxZpE*VS1(20,28))&
   +3D0*HfxZpE*VS1(10,49)
VS0(20,78)=QCy*VS0(20,53)+WQy*VS1(20,53)&
   +2D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))
VS0(20,79)=QCz*VS0(20,51)+WQz*VS1(20,51)-r1x2E*VR1(20,51)&
   +3D0*r1x2E*(VS0(20,30)-ZxZpE*VS1(20,30))&
   +3D0*HfxZpE*VS1(10,51)
VS0(20,80)=QCz*VS0(20,52)+WQz*VS1(20,52)-r1x2E*VR1(20,52)&
   +3D0*r1x2E*(VS0(20,31)-ZxZpE*VS1(20,31))&
   +3D0*HfxZpE*VS1(10,52)
VS0(20,81)=QCz*VS0(20,53)+WQz*VS1(20,53)-r1x2E*VR1(20,53)&
   +3D0*r1x2E*(VS0(20,32)-ZxZpE*VS1(20,32))&
   +3D0*HfxZpE*VS1(10,53)
VS0(20,82)=QCz*VS0(20,54)+WQz*VS1(20,54)-r1x2E*VR1(20,54)&
   +4D0*r1x2E*(VS0(20,33)-ZxZpE*VS1(20,33))&
   +3D0*HfxZpE*VS1(10,54)
VS0(20,83)=QCz*VS0(20,55)+WQz*VS1(20,55)-r1x2E*VR1(20,55)&
   +4D0*r1x2E*(VS0(20,34)-ZxZpE*VS1(20,34))&
   +3D0*HfxZpE*VS1(10,55)
VS0(20,84)=QCz*VS0(20,56)+WQz*VS1(20,56)-r1x2E*VR1(20,56)&
   +5D0*r1x2E*(VS0(20,35)-ZxZpE*VS1(20,35))&
   +3D0*HfxZpE*VS1(10,56)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRf0i0'
STOP
END SELECT
END SUBROUTINE MVRRf0i0
