!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRf0g0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(11,6)
      V(2)=2.D0*V(1)
      V(3)=r1x2E*ZxZpE*VRR1(11,6)
      V(4)=-2.D0*V(3)
      V(5)=HfxZpE*VRR1(5,13)
      V(6)=r1x2E*VRR0(11,8)
      V(7)=2.D0*V(6)
      V(8)=r1x2E*ZxZpE*VRR1(11,8)
      V(9)=-2.D0*V(8)
      V(10)=HfxZpE*VRR1(5,16)
      V(11)=HfxZpE*VRR1(5,17)
      V(12)=r1x2E*VRR0(11,9)
      V(13)=2.D0*V(12)
      V(14)=r1x2E*ZxZpE*VRR1(11,9)
      V(15)=-2.D0*V(14)
      V(16)=HfxZpE*VRR1(5,18)
      V(17)=HfxZpE*VRR1(5,19)
      V(18)=r1x2E*VRR0(12,6)
      V(19)=2.D0*V(18)
      V(20)=r1x2E*ZxZpE*VRR1(12,6)
      V(21)=-2.D0*V(20)
      V(22)=r1x2E*VRR0(12,7)
      V(23)=HfxZpE*VRR1(6,13)
      V(24)=2.D0*V(23)
      V(25)=r1x2E*ZxZpE*VRR1(12,7)
      V(26)=r1x2E*VRR0(12,8)
      V(27)=2.D0*V(26)
      V(28)=r1x2E*ZxZpE*VRR1(12,8)
      V(29)=-2.D0*V(28)
      V(30)=r1x2E*VRR0(12,9)
      V(31)=HfxZpE*VRR1(6,16)
      V(32)=2.D0*V(31)
      V(33)=r1x2E*ZxZpE*VRR1(12,9)
      V(34)=2.D0*V(30)
      V(35)=-2.D0*V(33)
      V(36)=r1x2E*VRR0(12,10)
      V(37)=HfxZpE*VRR1(6,18)
      V(38)=r1x2E*ZxZpE*VRR1(12,10)
      V(39)=-V(38)
      V(40)=r1x2E*VRR0(13,6)
      V(41)=2.D0*V(40)
      V(42)=HfxZpE*VRR1(7,12)
      V(43)=r1x2E*ZxZpE*VRR1(13,6)
      V(44)=-2.D0*V(43)
      V(45)=r1x2E*VRR0(13,7)
      V(46)=HfxZpE*VRR1(7,13)
      V(47)=r1x2E*ZxZpE*VRR1(13,7)
      V(48)=r1x2E*VRR0(13,8)
      V(49)=2.D0*V(48)
      V(50)=HfxZpE*VRR1(7,15)
      V(51)=r1x2E*ZxZpE*VRR1(13,8)
      V(52)=-2.D0*V(51)
      V(53)=r1x2E*VRR0(13,9)
      V(54)=HfxZpE*VRR1(7,16)
      V(55)=r1x2E*ZxZpE*VRR1(13,9)
      V(56)=2.D0*V(53)
      V(57)=-2.D0*V(55)
      V(58)=r1x2E*VRR0(13,10)
      V(59)=HfxZpE*VRR1(7,18)
      V(60)=r1x2E*ZxZpE*VRR1(13,10)
      V(61)=-V(60)
      V(62)=HfxZpE*VRR1(6,19)
      V(63)=r1x2E*VRR0(14,6)
      V(64)=2.D0*V(63)
      V(65)=r1x2E*ZxZpE*VRR1(14,6)
      V(66)=-2.D0*V(65)
      V(67)=r1x2E*VRR0(14,8)
      V(68)=2.D0*V(67)
      V(69)=r1x2E*ZxZpE*VRR1(14,8)
      V(70)=-2.D0*V(69)
      V(71)=r1x2E*VRR0(14,9)
      V(72)=2.D0*V(71)
      V(73)=r1x2E*ZxZpE*VRR1(14,9)
      V(74)=-2.D0*V(73)
      V(75)=HfxZpE*VRR1(7,19)
      V(76)=r1x2E*VRR0(15,6)
      V(77)=2.D0*V(76)
      V(78)=r1x2E*ZxZpE*VRR1(15,6)
      V(79)=-2.D0*V(78)
      V(80)=r1x2E*VRR0(15,7)
      V(81)=HfxZpE*VRR1(8,13)
      V(82)=r1x2E*ZxZpE*VRR1(15,7)
      V(83)=r1x2E*VRR0(15,8)
      V(84)=2.D0*V(83)
      V(85)=r1x2E*ZxZpE*VRR1(15,8)
      V(86)=-2.D0*V(85)
      V(87)=r1x2E*VRR0(15,9)
      V(88)=HfxZpE*VRR1(8,16)
      V(89)=2.D0*V(88)
      V(90)=r1x2E*ZxZpE*VRR1(15,9)
      V(91)=2.D0*V(87)
      V(92)=-2.D0*V(90)
      V(93)=r1x2E*VRR0(15,10)
      V(94)=HfxZpE*VRR1(8,18)
      V(95)=2.D0*V(94)
      V(96)=r1x2E*ZxZpE*VRR1(15,10)
      V(97)=-V(96)
      V(98)=r1x2E*VRR0(16,6)
      V(99)=2.D0*V(98)
      V(100)=r1x2E*ZxZpE*VRR1(16,6)
      V(101)=-2.D0*V(100)
      V(102)=r1x2E*VRR0(16,7)
      V(103)=HfxZpE*VRR1(9,13)
      V(104)=r1x2E*ZxZpE*VRR1(16,7)
      V(105)=r1x2E*VRR0(16,8)
      V(106)=2.D0*V(105)
      V(107)=r1x2E*ZxZpE*VRR1(16,8)
      V(108)=-2.D0*V(107)
      V(109)=r1x2E*VRR0(16,9)
      V(110)=HfxZpE*VRR1(9,16)
      V(111)=r1x2E*ZxZpE*VRR1(16,9)
      V(112)=2.D0*V(109)
      V(113)=-2.D0*V(111)
      V(114)=r1x2E*VRR0(16,10)
      V(115)=HfxZpE*VRR1(9,18)
      V(116)=r1x2E*ZxZpE*VRR1(16,10)
      V(117)=-V(116)
      V(118)=HfxZpE*VRR1(8,19)
      V(119)=r1x2E*VRR0(17,6)
      V(120)=2.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(17,6)
      V(122)=-2.D0*V(121)
      V(123)=r1x2E*VRR0(17,7)
      V(124)=r1x2E*ZxZpE*VRR1(17,7)
      V(125)=r1x2E*VRR0(17,8)
      V(126)=2.D0*V(125)
      V(127)=r1x2E*ZxZpE*VRR1(17,8)
      V(128)=-2.D0*V(127)
      V(129)=r1x2E*VRR0(17,9)
      V(130)=r1x2E*ZxZpE*VRR1(17,9)
      V(131)=2.D0*V(110)
      V(132)=2.D0*V(129)
      V(133)=-2.D0*V(130)
      V(134)=r1x2E*VRR0(17,10)
      V(135)=r1x2E*ZxZpE*VRR1(17,10)
      V(136)=-V(135)
      V(137)=HfxZpE*VRR1(9,19)
      V(138)=2.D0*V(137)
      V(139)=r1x2E*VRR0(18,6)
      V(140)=2.D0*V(139)
      V(141)=HfxZpE*VRR1(10,12)
      V(142)=r1x2E*ZxZpE*VRR1(18,6)
      V(143)=-2.D0*V(142)
      V(144)=r1x2E*VRR0(18,7)
      V(145)=HfxZpE*VRR1(10,13)
      V(146)=r1x2E*ZxZpE*VRR1(18,7)
      V(147)=r1x2E*VRR0(18,8)
      V(148)=2.D0*V(147)
      V(149)=HfxZpE*VRR1(10,15)
      V(150)=r1x2E*ZxZpE*VRR1(18,8)
      V(151)=-2.D0*V(150)
      V(152)=r1x2E*VRR0(18,9)
      V(153)=HfxZpE*VRR1(10,16)
      V(154)=r1x2E*ZxZpE*VRR1(18,9)
      V(155)=2.D0*V(152)
      V(156)=-2.D0*V(154)
      V(157)=r1x2E*VRR0(18,10)
      V(158)=HfxZpE*VRR1(10,18)
      V(159)=r1x2E*ZxZpE*VRR1(18,10)
      V(160)=-V(159)
      V(161)=r1x2E*VRR0(19,6)
      V(162)=2.D0*V(161)
      V(163)=r1x2E*ZxZpE*VRR1(19,6)
      V(164)=-2.D0*V(163)
      V(165)=r1x2E*VRR0(19,7)
      V(166)=r1x2E*ZxZpE*VRR1(19,7)
      V(167)=r1x2E*VRR0(19,8)
      V(168)=2.D0*V(167)
      V(169)=r1x2E*ZxZpE*VRR1(19,8)
      V(170)=-2.D0*V(169)
      V(171)=r1x2E*VRR0(19,9)
      V(172)=r1x2E*ZxZpE*VRR1(19,9)
      V(173)=2.D0*V(171)
      V(174)=HfxZpE*VRR1(10,17)
      V(175)=-2.D0*V(172)
      V(176)=r1x2E*VRR0(19,10)
      V(177)=r1x2E*ZxZpE*VRR1(19,10)
      V(178)=-V(177)
      V(179)=HfxZpE*VRR1(10,19)
      V(180)=r1x2E*VRR0(20,6)
      V(181)=2.D0*V(180)
      V(182)=r1x2E*ZxZpE*VRR1(20,6)
      V(183)=-2.D0*V(182)
      V(184)=r1x2E*VRR0(20,8)
      V(185)=2.D0*V(184)
      V(186)=r1x2E*ZxZpE*VRR1(20,8)
      V(187)=-2.D0*V(186)
      V(188)=r1x2E*VRR0(20,9)
      V(189)=2.D0*V(188)
      V(190)=r1x2E*ZxZpE*VRR1(20,9)
      V(191)=-2.D0*V(190)
      VRR0(11,21)=3.D0*r1x2E*VRR0(11,5)+QCx*VRR0(11,11)+3.D0*HfxZpE*VRR1(5,11)-3.D0*r1x2E*ZxZpE*VRR1(11,5)+WQx*VRR1(11,11)
      VRR0(11,22)=V(2)+V(4)+QCx*VRR0(11,12)+3.D0*HfxZpE*VRR1(5,12)+WQx*VRR1(11,12)
      VRR0(11,23)=2.D0*V(5)+2.D0*r1x2Z*VRR0(2,23)+PAx*VRR0(5,23)-2.D0*ExZpE*r1x2Z*VRR1(2,23)+WPx*VRR1(5,23)
      VRR0(11,24)=V(2)+V(4)+QCy*VRR0(11,13)+WQy*VRR1(11,13)
      VRR0(11,25)=3.D0*r1x2E*VRR0(11,7)+QCy*VRR0(11,14)-3.D0*r1x2E*ZxZpE*VRR1(11,7)+WQy*VRR1(11,14)
      VRR0(11,26)=V(7)+V(9)+QCx*VRR0(11,15)+3.D0*HfxZpE*VRR1(5,15)+WQx*VRR1(11,15)
      VRR0(11,27)=2.D0*V(10)+2.D0*r1x2Z*VRR0(2,27)+PAx*VRR0(5,27)-2.D0*ExZpE*r1x2Z*VRR1(2,27)+WPx*VRR1(5,27)
      VRR0(11,28)=V(11)+2.D0*r1x2Z*VRR0(2,28)+PAx*VRR0(5,28)-2.D0*ExZpE*r1x2Z*VRR1(2,28)+WPx*VRR1(5,28)
      VRR0(11,29)=V(13)+V(15)+QCy*VRR0(11,17)+WQy*VRR1(11,17)
      VRR0(11,30)=2.D0*V(16)+2.D0*r1x2Z*VRR0(2,30)+PAx*VRR0(5,30)-2.D0*ExZpE*r1x2Z*VRR1(2,30)+WPx*VRR1(5,30)
      VRR0(11,31)=V(17)+2.D0*r1x2Z*VRR0(2,31)+PAx*VRR0(5,31)-2.D0*ExZpE*r1x2Z*VRR1(2,31)+WPx*VRR1(5,31)
      VRR0(11,32)=2.D0*r1x2Z*VRR0(2,32)+PAx*VRR0(5,32)-2.D0*ExZpE*r1x2Z*VRR1(2,32)+WPx*VRR1(5,32)
      VRR0(11,33)=V(7)+V(9)+QCz*VRR0(11,18)+WQz*VRR1(11,18)
      VRR0(11,34)=V(13)+V(15)+QCz*VRR0(11,19)+WQz*VRR1(11,19)
      VRR0(11,35)=3.D0*r1x2E*VRR0(11,10)+QCz*VRR0(11,20)-3.D0*r1x2E*ZxZpE*VRR1(11,10)+WQz*VRR1(11,20)
      VRR0(12,21)=3.D0*r1x2E*VRR0(12,5)+QCx*VRR0(12,11)+2.D0*HfxZpE*VRR1(6,11)-3.D0*r1x2E*ZxZpE*VRR1(12,5)+WQx*VRR1(12,11)
      VRR0(12,22)=V(19)+V(21)+QCx*VRR0(12,12)+2.D0*HfxZpE*VRR1(6,12)+WQx*VRR1(12,12)
      VRR0(12,23)=V(22)+V(24)-V(25)+QCx*VRR0(12,13)+WQx*VRR1(12,13)
      VRR0(12,24)=V(5)+V(19)+V(21)+QCy*VRR0(12,13)+WQy*VRR1(12,13)
      VRR0(12,25)=3.D0*V(22)-3.D0*V(25)+QCy*VRR0(12,14)+HfxZpE*VRR1(5,14)+WQy*VRR1(12,14)
      VRR0(12,26)=V(27)+V(29)+QCx*VRR0(12,15)+2.D0*HfxZpE*VRR1(6,15)+WQx*VRR1(12,15)
      VRR0(12,27)=V(30)+V(32)-V(33)+QCx*VRR0(12,16)+WQx*VRR1(12,16)
      VRR0(12,28)=V(10)+V(26)-V(28)+QCy*VRR0(12,16)+WQy*VRR1(12,16)
      VRR0(12,29)=V(11)+V(34)+V(35)+QCy*VRR0(12,17)+WQy*VRR1(12,17)
      VRR0(12,30)=V(36)+2.D0*V(37)+V(39)+QCx*VRR0(12,18)+WQx*VRR1(12,18)
      VRR0(12,31)=V(18)-V(20)+QCz*VRR0(12,16)+WQz*VRR1(12,16)
      VRR0(12,32)=V(17)+V(36)+V(39)+QCy*VRR0(12,19)+WQy*VRR1(12,19)
      VRR0(12,33)=V(27)+V(29)+QCz*VRR0(12,18)+WQz*VRR1(12,18)
      VRR0(12,34)=V(34)+V(35)+QCz*VRR0(12,19)+WQz*VRR1(12,19)
      VRR0(12,35)=3.D0*V(36)-3.D0*V(38)+QCz*VRR0(12,20)+WQz*VRR1(12,20)
      VRR0(13,21)=3.D0*r1x2E*VRR0(13,5)+QCx*VRR0(13,11)+HfxZpE*VRR1(7,11)-3.D0*r1x2E*ZxZpE*VRR1(13,5)+WQx*VRR1(13,11)
      VRR0(13,22)=V(41)+V(42)+V(44)+QCx*VRR0(13,12)+WQx*VRR1(13,12)
      VRR0(13,23)=V(45)+V(46)-V(47)+QCx*VRR0(13,13)+WQx*VRR1(13,13)
      VRR0(13,24)=V(24)+V(41)+V(44)+QCy*VRR0(13,13)+WQy*VRR1(13,13)
      VRR0(13,25)=3.D0*V(45)-3.D0*V(47)+QCy*VRR0(13,14)+2.D0*HfxZpE*VRR1(6,14)+WQy*VRR1(13,14)
      VRR0(13,26)=V(49)+V(50)+V(52)+QCx*VRR0(13,15)+WQx*VRR1(13,15)
      VRR0(13,27)=V(53)+V(54)-V(55)+QCx*VRR0(13,16)+WQx*VRR1(13,16)
      VRR0(13,28)=V(32)+V(48)-V(51)+QCy*VRR0(13,16)+WQy*VRR1(13,16)
      VRR0(13,29)=V(56)+V(57)+QCy*VRR0(13,17)+2.D0*HfxZpE*VRR1(6,17)+WQy*VRR1(13,17)
      VRR0(13,30)=V(58)+V(59)+V(61)+QCx*VRR0(13,18)+WQx*VRR1(13,18)
      VRR0(13,31)=V(40)-V(43)+QCz*VRR0(13,16)+WQz*VRR1(13,16)
      VRR0(13,32)=V(58)+V(61)+2.D0*V(62)+QCy*VRR0(13,19)+WQy*VRR1(13,19)
      VRR0(13,33)=V(49)+V(52)+QCz*VRR0(13,18)+WQz*VRR1(13,18)
      VRR0(13,34)=V(56)+V(57)+QCz*VRR0(13,19)+WQz*VRR1(13,19)
      VRR0(13,35)=3.D0*V(58)-3.D0*V(60)+QCz*VRR0(13,20)+WQz*VRR1(13,20)
      VRR0(14,21)=3.D0*r1x2E*VRR0(14,5)+QCx*VRR0(14,11)-3.D0*r1x2E*ZxZpE*VRR1(14,5)+WQx*VRR1(14,11)
      VRR0(14,22)=V(64)+V(66)+QCx*VRR0(14,12)+WQx*VRR1(14,12)
      VRR0(14,23)=2.D0*V(42)+2.D0*r1x2Z*VRR0(3,23)+PAy*VRR0(7,23)-2.D0*ExZpE*r1x2Z*VRR1(3,23)+WPy*VRR1(7,23)
      VRR0(14,24)=3.D0*V(46)+V(64)+V(66)+QCy*VRR0(14,13)+WQy*VRR1(14,13)
      VRR0(14,25)=3.D0*r1x2E*VRR0(14,7)+QCy*VRR0(14,14)+3.D0*HfxZpE*VRR1(7,14)-3.D0*r1x2E*ZxZpE*VRR1(14,7)+WQy*VRR1(14,14)
      VRR0(14,26)=V(68)+V(70)+QCx*VRR0(14,15)+WQx*VRR1(14,15)
      VRR0(14,27)=V(50)+2.D0*r1x2Z*VRR0(3,27)+PAy*VRR0(7,27)-2.D0*ExZpE*r1x2Z*VRR1(3,27)+WPy*VRR1(7,27)
      VRR0(14,28)=2.D0*V(54)+2.D0*r1x2Z*VRR0(3,28)+PAy*VRR0(7,28)-2.D0*ExZpE*r1x2Z*VRR1(3,28)+WPy*VRR1(7,28)
      VRR0(14,29)=V(72)+V(74)+QCy*VRR0(14,17)+3.D0*HfxZpE*VRR1(7,17)+WQy*VRR1(14,17)
      VRR0(14,30)=2.D0*r1x2Z*VRR0(3,30)+PAy*VRR0(7,30)-2.D0*ExZpE*r1x2Z*VRR1(3,30)+WPy*VRR1(7,30)
      VRR0(14,31)=V(59)+2.D0*r1x2Z*VRR0(3,31)+PAy*VRR0(7,31)-2.D0*ExZpE*r1x2Z*VRR1(3,31)+WPy*VRR1(7,31)
      VRR0(14,32)=2.D0*V(75)+2.D0*r1x2Z*VRR0(3,32)+PAy*VRR0(7,32)-2.D0*ExZpE*r1x2Z*VRR1(3,32)+WPy*VRR1(7,32)
      VRR0(14,33)=V(68)+V(70)+QCz*VRR0(14,18)+WQz*VRR1(14,18)
      VRR0(14,34)=V(72)+V(74)+QCz*VRR0(14,19)+WQz*VRR1(14,19)
      VRR0(14,35)=3.D0*r1x2E*VRR0(14,10)+QCz*VRR0(14,20)-3.D0*r1x2E*ZxZpE*VRR1(14,10)+WQz*VRR1(14,20)
      VRR0(15,21)=3.D0*r1x2E*VRR0(15,5)+QCx*VRR0(15,11)+2.D0*HfxZpE*VRR1(8,11)-3.D0*r1x2E*ZxZpE*VRR1(15,5)+WQx*VRR1(15,11)
      VRR0(15,22)=V(77)+V(79)+QCx*VRR0(15,12)+2.D0*HfxZpE*VRR1(8,12)+WQx*VRR1(15,12)
      VRR0(15,23)=V(80)+2.D0*V(81)-V(82)+QCx*VRR0(15,13)+WQx*VRR1(15,13)
      VRR0(15,24)=V(77)+V(79)+QCy*VRR0(15,13)+WQy*VRR1(15,13)
      VRR0(15,25)=3.D0*V(80)-3.D0*V(82)+QCy*VRR0(15,14)+WQy*VRR1(15,14)
      VRR0(15,26)=V(84)+V(86)+QCx*VRR0(15,15)+2.D0*HfxZpE*VRR1(8,15)+WQx*VRR1(15,15)
      VRR0(15,27)=V(87)+V(89)-V(90)+QCx*VRR0(15,16)+WQx*VRR1(15,16)
      VRR0(15,28)=V(83)-V(85)+QCy*VRR0(15,16)+WQy*VRR1(15,16)
      VRR0(15,29)=V(91)+V(92)+QCy*VRR0(15,17)+WQy*VRR1(15,17)
      VRR0(15,30)=V(93)+V(95)+V(97)+QCx*VRR0(15,18)+WQx*VRR1(15,18)
      VRR0(15,31)=V(10)+V(76)-V(78)+QCz*VRR0(15,16)+WQz*VRR1(15,16)
      VRR0(15,32)=V(93)+V(97)+QCy*VRR0(15,19)+WQy*VRR1(15,19)
      VRR0(15,33)=V(16)+V(84)+V(86)+QCz*VRR0(15,18)+WQz*VRR1(15,18)
      VRR0(15,34)=V(17)+V(91)+V(92)+QCz*VRR0(15,19)+WQz*VRR1(15,19)
      VRR0(15,35)=3.D0*V(93)-3.D0*V(96)+QCz*VRR0(15,20)+HfxZpE*VRR1(5,20)+WQz*VRR1(15,20)
      VRR0(16,21)=3.D0*r1x2E*VRR0(16,5)+QCx*VRR0(16,11)+HfxZpE*VRR1(9,11)-3.D0*r1x2E*ZxZpE*VRR1(16,5)+WQx*VRR1(16,11)
      VRR0(16,22)=V(99)+V(101)+QCx*VRR0(16,12)+HfxZpE*VRR1(9,12)+WQx*VRR1(16,12)
      VRR0(16,23)=V(102)+V(103)-V(104)+QCx*VRR0(16,13)+WQx*VRR1(16,13)
      VRR0(16,24)=V(81)+V(99)+V(101)+QCy*VRR0(16,13)+WQy*VRR1(16,13)
      VRR0(16,25)=3.D0*V(102)-3.D0*V(104)+QCy*VRR0(16,14)+HfxZpE*VRR1(8,14)+WQy*VRR1(16,14)
      VRR0(16,26)=V(106)+V(108)+QCx*VRR0(16,15)+HfxZpE*VRR1(9,15)+WQx*VRR1(16,15)
      VRR0(16,27)=V(109)+V(110)-V(111)+QCx*VRR0(16,16)+WQx*VRR1(16,16)
      VRR0(16,28)=V(88)+V(105)-V(107)+QCy*VRR0(16,16)+WQy*VRR1(16,16)
      VRR0(16,29)=V(112)+V(113)+QCy*VRR0(16,17)+HfxZpE*VRR1(8,17)+WQy*VRR1(16,17)
      VRR0(16,30)=V(114)+V(115)+V(117)+QCx*VRR0(16,18)+WQx*VRR1(16,18)
      VRR0(16,31)=V(31)+V(98)-V(100)+QCz*VRR0(16,16)+WQz*VRR1(16,16)
      VRR0(16,32)=V(114)+V(117)+V(118)+QCy*VRR0(16,19)+WQy*VRR1(16,19)
      VRR0(16,33)=V(37)+V(106)+V(108)+QCz*VRR0(16,18)+WQz*VRR1(16,18)
      VRR0(16,34)=V(62)+V(112)+V(113)+QCz*VRR0(16,19)+WQz*VRR1(16,19)
      VRR0(16,35)=3.D0*V(114)-3.D0*V(116)+QCz*VRR0(16,20)+HfxZpE*VRR1(6,20)+WQz*VRR1(16,20)
      VRR0(17,21)=3.D0*r1x2E*VRR0(17,5)+QCx*VRR0(17,11)-3.D0*r1x2E*ZxZpE*VRR1(17,5)+WQx*VRR1(17,11)
      VRR0(17,22)=V(120)+V(122)+QCx*VRR0(17,12)+WQx*VRR1(17,12)
      VRR0(17,23)=V(123)-V(124)+QCx*VRR0(17,13)+WQx*VRR1(17,13)
      VRR0(17,24)=2.D0*V(103)+V(120)+V(122)+QCy*VRR0(17,13)+WQy*VRR1(17,13)
      VRR0(17,25)=3.D0*V(123)-3.D0*V(124)+QCy*VRR0(17,14)+2.D0*HfxZpE*VRR1(9,14)+WQy*VRR1(17,14)
      VRR0(17,26)=V(126)+V(128)+QCx*VRR0(17,15)+WQx*VRR1(17,15)
      VRR0(17,27)=V(129)-V(130)+QCx*VRR0(17,16)+WQx*VRR1(17,16)
      VRR0(17,28)=V(125)-V(127)+V(131)+QCy*VRR0(17,16)+WQy*VRR1(17,16)
      VRR0(17,29)=V(132)+V(133)+QCy*VRR0(17,17)+2.D0*HfxZpE*VRR1(9,17)+WQy*VRR1(17,17)
      VRR0(17,30)=V(134)+V(136)+QCx*VRR0(17,18)+WQx*VRR1(17,18)
      VRR0(17,31)=V(54)+V(119)-V(121)+QCz*VRR0(17,16)+WQz*VRR1(17,16)
      VRR0(17,32)=V(134)+V(136)+V(138)+QCy*VRR0(17,19)+WQy*VRR1(17,19)
      VRR0(17,33)=V(59)+V(126)+V(128)+QCz*VRR0(17,18)+WQz*VRR1(17,18)
      VRR0(17,34)=V(75)+V(132)+V(133)+QCz*VRR0(17,19)+WQz*VRR1(17,19)
      VRR0(17,35)=3.D0*V(134)-3.D0*V(135)+QCz*VRR0(17,20)+HfxZpE*VRR1(7,20)+WQz*VRR1(17,20)
      VRR0(18,21)=3.D0*r1x2E*VRR0(18,5)+QCx*VRR0(18,11)+HfxZpE*VRR1(10,11)-3.D0*r1x2E*ZxZpE*VRR1(18,5)+WQx*VRR1(18,11)
      VRR0(18,22)=V(140)+V(141)+V(143)+QCx*VRR0(18,12)+WQx*VRR1(18,12)
      VRR0(18,23)=V(144)+V(145)-V(146)+QCx*VRR0(18,13)+WQx*VRR1(18,13)
      VRR0(18,24)=V(140)+V(143)+QCy*VRR0(18,13)+WQy*VRR1(18,13)
      VRR0(18,25)=3.D0*V(144)-3.D0*V(146)+QCy*VRR0(18,14)+WQy*VRR1(18,14)
      VRR0(18,26)=V(148)+V(149)+V(151)+QCx*VRR0(18,15)+WQx*VRR1(18,15)
      VRR0(18,27)=V(152)+V(153)-V(154)+QCx*VRR0(18,16)+WQx*VRR1(18,16)
      VRR0(18,28)=V(147)-V(150)+QCy*VRR0(18,16)+WQy*VRR1(18,16)
      VRR0(18,29)=V(155)+V(156)+QCy*VRR0(18,17)+WQy*VRR1(18,17)
      VRR0(18,30)=V(157)+V(158)+V(160)+QCx*VRR0(18,18)+WQx*VRR1(18,18)
      VRR0(18,31)=V(89)+V(139)-V(142)+QCz*VRR0(18,16)+WQz*VRR1(18,16)
      VRR0(18,32)=V(157)+V(160)+QCy*VRR0(18,19)+WQy*VRR1(18,19)
      VRR0(18,33)=V(95)+V(148)+V(151)+QCz*VRR0(18,18)+WQz*VRR1(18,18)
      VRR0(18,34)=2.D0*V(118)+V(155)+V(156)+QCz*VRR0(18,19)+WQz*VRR1(18,19)
      VRR0(18,35)=3.D0*V(157)-3.D0*V(159)+QCz*VRR0(18,20)+2.D0*HfxZpE*VRR1(8,20)+WQz*VRR1(18,20)
      VRR0(19,21)=3.D0*r1x2E*VRR0(19,5)+QCx*VRR0(19,11)-3.D0*r1x2E*ZxZpE*VRR1(19,5)+WQx*VRR1(19,11)
      VRR0(19,22)=V(162)+V(164)+QCx*VRR0(19,12)+WQx*VRR1(19,12)
      VRR0(19,23)=V(165)-V(166)+QCx*VRR0(19,13)+WQx*VRR1(19,13)
      VRR0(19,24)=V(145)+V(162)+V(164)+QCy*VRR0(19,13)+WQy*VRR1(19,13)
      VRR0(19,25)=3.D0*V(165)-3.D0*V(166)+QCy*VRR0(19,14)+HfxZpE*VRR1(10,14)+WQy*VRR1(19,14)
      VRR0(19,26)=V(168)+V(170)+QCx*VRR0(19,15)+WQx*VRR1(19,15)
      VRR0(19,27)=V(171)-V(172)+QCx*VRR0(19,16)+WQx*VRR1(19,16)
      VRR0(19,28)=V(153)+V(167)-V(169)+QCy*VRR0(19,16)+WQy*VRR1(19,16)
      VRR0(19,29)=V(173)+V(174)+V(175)+QCy*VRR0(19,17)+WQy*VRR1(19,17)
      VRR0(19,30)=V(176)+V(178)+QCx*VRR0(19,18)+WQx*VRR1(19,18)
      VRR0(19,31)=V(131)+V(161)-V(163)+QCz*VRR0(19,16)+WQz*VRR1(19,16)
      VRR0(19,32)=V(176)+V(178)+V(179)+QCy*VRR0(19,19)+WQy*VRR1(19,19)
      VRR0(19,33)=2.D0*V(115)+V(168)+V(170)+QCz*VRR0(19,18)+WQz*VRR1(19,18)
      VRR0(19,34)=V(138)+V(173)+V(175)+QCz*VRR0(19,19)+WQz*VRR1(19,19)
      VRR0(19,35)=3.D0*V(176)-3.D0*V(177)+QCz*VRR0(19,20)+2.D0*HfxZpE*VRR1(9,20)+WQz*VRR1(19,20)
      VRR0(20,21)=3.D0*r1x2E*VRR0(20,5)+QCx*VRR0(20,11)-3.D0*r1x2E*ZxZpE*VRR1(20,5)+WQx*VRR1(20,11)
      VRR0(20,22)=V(181)+V(183)+QCx*VRR0(20,12)+WQx*VRR1(20,12)
      VRR0(20,23)=2.D0*r1x2Z*VRR0(4,23)+PAz*VRR0(10,23)-2.D0*ExZpE*r1x2Z*VRR1(4,23)+WPz*VRR1(10,23)
      VRR0(20,24)=V(181)+V(183)+QCy*VRR0(20,13)+WQy*VRR1(20,13)
      VRR0(20,25)=3.D0*r1x2E*VRR0(20,7)+QCy*VRR0(20,14)-3.D0*r1x2E*ZxZpE*VRR1(20,7)+WQy*VRR1(20,14)
      VRR0(20,26)=V(185)+V(187)+QCx*VRR0(20,15)+WQx*VRR1(20,15)
      VRR0(20,27)=V(141)+2.D0*r1x2Z*VRR0(4,27)+PAz*VRR0(10,27)-2.D0*ExZpE*r1x2Z*VRR1(4,27)+WPz*VRR1(10,27)
      VRR0(20,28)=V(145)+2.D0*r1x2Z*VRR0(4,28)+PAz*VRR0(10,28)-2.D0*ExZpE*r1x2Z*VRR1(4,28)+WPz*VRR1(10,28)
      VRR0(20,29)=V(189)+V(191)+QCy*VRR0(20,17)+WQy*VRR1(20,17)
      VRR0(20,30)=2.D0*V(149)+2.D0*r1x2Z*VRR0(4,30)+PAz*VRR0(10,30)-2.D0*ExZpE*r1x2Z*VRR1(4,30)+WPz*VRR1(10,30)
      VRR0(20,31)=2.D0*V(153)+2.D0*r1x2Z*VRR0(4,31)+PAz*VRR0(10,31)-2.D0*ExZpE*r1x2Z*VRR1(4,31)+WPz*VRR1(10,31)
      VRR0(20,32)=2.D0*V(174)+2.D0*r1x2Z*VRR0(4,32)+PAz*VRR0(10,32)-2.D0*ExZpE*r1x2Z*VRR1(4,32)+WPz*VRR1(10,32)
      VRR0(20,33)=3.D0*V(158)+V(185)+V(187)+QCz*VRR0(20,18)+WQz*VRR1(20,18)
      VRR0(20,34)=3.D0*V(179)+V(189)+V(191)+QCz*VRR0(20,19)+WQz*VRR1(20,19)
      VRR0(20,35)=3.D0*r1x2E*VRR0(20,10)+QCz*VRR0(20,20)+3.D0*HfxZpE*VRR1(10,20)-3.D0*r1x2E*ZxZpE*VRR1(20,10)+WQz*VRR1(20,20)
END SUBROUTINE VRRf0g0
SUBROUTINE MVRRf0g0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(11,21)=QCx*VS0(11,11)+WQx*VS1(11,11)-r1x2E*VR1(11,11)&
   +3D0*r1x2E*(VS0(11,5)-ZxZpE*VS1(11,5))&
   +3D0*HfxZpE*VS1(5,11)
VS0(11,22)=QCx*VS0(11,12)+WQx*VS1(11,12)-r1x2E*VR1(11,12)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))&
   +3D0*HfxZpE*VS1(5,12)
VS0(11,23)=QCx*VS0(11,13)+WQx*VS1(11,13)-r1x2E*VR1(11,13)&
   +r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))&
   +3D0*HfxZpE*VS1(5,13)
VS0(11,24)=QCy*VS0(11,13)+WQy*VS1(11,13)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,25)=QCy*VS0(11,14)+WQy*VS1(11,14)&
   +3D0*r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))
VS0(11,26)=QCx*VS0(11,15)+WQx*VS1(11,15)-r1x2E*VR1(11,15)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))&
   +3D0*HfxZpE*VS1(5,15)
VS0(11,27)=QCx*VS0(11,16)+WQx*VS1(11,16)-r1x2E*VR1(11,16)&
   +r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))&
   +3D0*HfxZpE*VS1(5,16)
VS0(11,28)=QCy*VS0(11,16)+WQy*VS1(11,16)&
   +r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,29)=QCy*VS0(11,17)+WQy*VS1(11,17)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,30)=QCx*VS0(11,18)+WQx*VS1(11,18)-r1x2E*VR1(11,18)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))&
   +3D0*HfxZpE*VS1(5,18)
VS0(11,31)=QCz*VS0(11,16)+WQz*VS1(11,16)&
   +r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,32)=QCy*VS0(11,19)+WQy*VS1(11,19)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(11,33)=QCz*VS0(11,18)+WQz*VS1(11,18)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,34)=QCz*VS0(11,19)+WQz*VS1(11,19)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,35)=QCz*VS0(11,20)+WQz*VS1(11,20)&
   +3D0*r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(12,21)=QCx*VS0(12,11)+WQx*VS1(12,11)-r1x2E*VR1(12,11)&
   +3D0*r1x2E*(VS0(12,5)-ZxZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(6,11)
VS0(12,22)=QCx*VS0(12,12)+WQx*VS1(12,12)-r1x2E*VR1(12,12)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +2D0*HfxZpE*VS1(6,12)
VS0(12,23)=QCx*VS0(12,13)+WQx*VS1(12,13)-r1x2E*VR1(12,13)&
   +r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(6,13)
VS0(12,24)=QCy*VS0(12,13)+WQy*VS1(12,13)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +HfxZpE*VS1(5,13)
VS0(12,25)=QCy*VS0(12,14)+WQy*VS1(12,14)&
   +3D0*r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +HfxZpE*VS1(5,14)
VS0(12,26)=QCx*VS0(12,15)+WQx*VS1(12,15)-r1x2E*VR1(12,15)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +2D0*HfxZpE*VS1(6,15)
VS0(12,27)=QCx*VS0(12,16)+WQx*VS1(12,16)-r1x2E*VR1(12,16)&
   +r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +2D0*HfxZpE*VS1(6,16)
VS0(12,28)=QCy*VS0(12,16)+WQy*VS1(12,16)&
   +r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +HfxZpE*VS1(5,16)
VS0(12,29)=QCy*VS0(12,17)+WQy*VS1(12,17)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +HfxZpE*VS1(5,17)
VS0(12,30)=QCx*VS0(12,18)+WQx*VS1(12,18)-r1x2E*VR1(12,18)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +2D0*HfxZpE*VS1(6,18)
VS0(12,31)=QCz*VS0(12,16)+WQz*VS1(12,16)&
   +r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))
VS0(12,32)=QCy*VS0(12,19)+WQy*VS1(12,19)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +HfxZpE*VS1(5,19)
VS0(12,33)=QCz*VS0(12,18)+WQz*VS1(12,18)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))
VS0(12,34)=QCz*VS0(12,19)+WQz*VS1(12,19)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))
VS0(12,35)=QCz*VS0(12,20)+WQz*VS1(12,20)&
   +3D0*r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))
VS0(13,21)=QCx*VS0(13,11)+WQx*VS1(13,11)-r1x2E*VR1(13,11)&
   +3D0*r1x2E*(VS0(13,5)-ZxZpE*VS1(13,5))&
   +HfxZpE*VS1(7,11)
VS0(13,22)=QCx*VS0(13,12)+WQx*VS1(13,12)-r1x2E*VR1(13,12)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +HfxZpE*VS1(7,12)
VS0(13,23)=QCx*VS0(13,13)+WQx*VS1(13,13)-r1x2E*VR1(13,13)&
   +r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +HfxZpE*VS1(7,13)
VS0(13,24)=QCy*VS0(13,13)+WQy*VS1(13,13)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +2D0*HfxZpE*VS1(6,13)
VS0(13,25)=QCy*VS0(13,14)+WQy*VS1(13,14)&
   +3D0*r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(6,14)
VS0(13,26)=QCx*VS0(13,15)+WQx*VS1(13,15)-r1x2E*VR1(13,15)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +HfxZpE*VS1(7,15)
VS0(13,27)=QCx*VS0(13,16)+WQx*VS1(13,16)-r1x2E*VR1(13,16)&
   +r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +HfxZpE*VS1(7,16)
VS0(13,28)=QCy*VS0(13,16)+WQy*VS1(13,16)&
   +r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +2D0*HfxZpE*VS1(6,16)
VS0(13,29)=QCy*VS0(13,17)+WQy*VS1(13,17)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +2D0*HfxZpE*VS1(6,17)
VS0(13,30)=QCx*VS0(13,18)+WQx*VS1(13,18)-r1x2E*VR1(13,18)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +HfxZpE*VS1(7,18)
VS0(13,31)=QCz*VS0(13,16)+WQz*VS1(13,16)&
   +r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))
VS0(13,32)=QCy*VS0(13,19)+WQy*VS1(13,19)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +2D0*HfxZpE*VS1(6,19)
VS0(13,33)=QCz*VS0(13,18)+WQz*VS1(13,18)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))
VS0(13,34)=QCz*VS0(13,19)+WQz*VS1(13,19)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))
VS0(13,35)=QCz*VS0(13,20)+WQz*VS1(13,20)&
   +3D0*r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))
VS0(14,21)=QCx*VS0(14,11)+WQx*VS1(14,11)-r1x2E*VR1(14,11)&
   +3D0*r1x2E*(VS0(14,5)-ZxZpE*VS1(14,5))
VS0(14,22)=QCx*VS0(14,12)+WQx*VS1(14,12)-r1x2E*VR1(14,12)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,23)=QCx*VS0(14,13)+WQx*VS1(14,13)-r1x2E*VR1(14,13)&
   +r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))
VS0(14,24)=QCy*VS0(14,13)+WQy*VS1(14,13)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))&
   +3D0*HfxZpE*VS1(7,13)
VS0(14,25)=QCy*VS0(14,14)+WQy*VS1(14,14)&
   +3D0*r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))&
   +3D0*HfxZpE*VS1(7,14)
VS0(14,26)=QCx*VS0(14,15)+WQx*VS1(14,15)-r1x2E*VR1(14,15)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,27)=QCx*VS0(14,16)+WQx*VS1(14,16)-r1x2E*VR1(14,16)&
   +r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,28)=QCy*VS0(14,16)+WQy*VS1(14,16)&
   +r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))&
   +3D0*HfxZpE*VS1(7,16)
VS0(14,29)=QCy*VS0(14,17)+WQy*VS1(14,17)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))&
   +3D0*HfxZpE*VS1(7,17)
VS0(14,30)=QCx*VS0(14,18)+WQx*VS1(14,18)-r1x2E*VR1(14,18)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(14,31)=QCz*VS0(14,16)+WQz*VS1(14,16)&
   +r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,32)=QCy*VS0(14,19)+WQy*VS1(14,19)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))&
   +3D0*HfxZpE*VS1(7,19)
VS0(14,33)=QCz*VS0(14,18)+WQz*VS1(14,18)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,34)=QCz*VS0(14,19)+WQz*VS1(14,19)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,35)=QCz*VS0(14,20)+WQz*VS1(14,20)&
   +3D0*r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(15,21)=QCx*VS0(15,11)+WQx*VS1(15,11)-r1x2E*VR1(15,11)&
   +3D0*r1x2E*(VS0(15,5)-ZxZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(8,11)
VS0(15,22)=QCx*VS0(15,12)+WQx*VS1(15,12)-r1x2E*VR1(15,12)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +2D0*HfxZpE*VS1(8,12)
VS0(15,23)=QCx*VS0(15,13)+WQx*VS1(15,13)-r1x2E*VR1(15,13)&
   +r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))&
   +2D0*HfxZpE*VS1(8,13)
VS0(15,24)=QCy*VS0(15,13)+WQy*VS1(15,13)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))
VS0(15,25)=QCy*VS0(15,14)+WQy*VS1(15,14)&
   +3D0*r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))
VS0(15,26)=QCx*VS0(15,15)+WQx*VS1(15,15)-r1x2E*VR1(15,15)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +2D0*HfxZpE*VS1(8,15)
VS0(15,27)=QCx*VS0(15,16)+WQx*VS1(15,16)-r1x2E*VR1(15,16)&
   +r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +2D0*HfxZpE*VS1(8,16)
VS0(15,28)=QCy*VS0(15,16)+WQy*VS1(15,16)&
   +r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))
VS0(15,29)=QCy*VS0(15,17)+WQy*VS1(15,17)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))
VS0(15,30)=QCx*VS0(15,18)+WQx*VS1(15,18)-r1x2E*VR1(15,18)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(8,18)
VS0(15,31)=QCz*VS0(15,16)+WQz*VS1(15,16)&
   +r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +HfxZpE*VS1(5,16)
VS0(15,32)=QCy*VS0(15,19)+WQy*VS1(15,19)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))
VS0(15,33)=QCz*VS0(15,18)+WQz*VS1(15,18)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +HfxZpE*VS1(5,18)
VS0(15,34)=QCz*VS0(15,19)+WQz*VS1(15,19)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +HfxZpE*VS1(5,19)
VS0(15,35)=QCz*VS0(15,20)+WQz*VS1(15,20)&
   +3D0*r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +HfxZpE*VS1(5,20)
VS0(16,21)=QCx*VS0(16,11)+WQx*VS1(16,11)-r1x2E*VR1(16,11)&
   +3D0*r1x2E*(VS0(16,5)-ZxZpE*VS1(16,5))&
   +HfxZpE*VS1(9,11)
VS0(16,22)=QCx*VS0(16,12)+WQx*VS1(16,12)-r1x2E*VR1(16,12)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(9,12)
VS0(16,23)=QCx*VS0(16,13)+WQx*VS1(16,13)-r1x2E*VR1(16,13)&
   +r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(9,13)
VS0(16,24)=QCy*VS0(16,13)+WQy*VS1(16,13)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(8,13)
VS0(16,25)=QCy*VS0(16,14)+WQy*VS1(16,14)&
   +3D0*r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(8,14)
VS0(16,26)=QCx*VS0(16,15)+WQx*VS1(16,15)-r1x2E*VR1(16,15)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(9,15)
VS0(16,27)=QCx*VS0(16,16)+WQx*VS1(16,16)-r1x2E*VR1(16,16)&
   +r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(9,16)
VS0(16,28)=QCy*VS0(16,16)+WQy*VS1(16,16)&
   +r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(8,16)
VS0(16,29)=QCy*VS0(16,17)+WQy*VS1(16,17)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(8,17)
VS0(16,30)=QCx*VS0(16,18)+WQx*VS1(16,18)-r1x2E*VR1(16,18)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(9,18)
VS0(16,31)=QCz*VS0(16,16)+WQz*VS1(16,16)&
   +r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(6,16)
VS0(16,32)=QCy*VS0(16,19)+WQy*VS1(16,19)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(8,19)
VS0(16,33)=QCz*VS0(16,18)+WQz*VS1(16,18)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(6,18)
VS0(16,34)=QCz*VS0(16,19)+WQz*VS1(16,19)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(6,19)
VS0(16,35)=QCz*VS0(16,20)+WQz*VS1(16,20)&
   +3D0*r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(6,20)
VS0(17,21)=QCx*VS0(17,11)+WQx*VS1(17,11)-r1x2E*VR1(17,11)&
   +3D0*r1x2E*(VS0(17,5)-ZxZpE*VS1(17,5))
VS0(17,22)=QCx*VS0(17,12)+WQx*VS1(17,12)-r1x2E*VR1(17,12)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))
VS0(17,23)=QCx*VS0(17,13)+WQx*VS1(17,13)-r1x2E*VR1(17,13)&
   +r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))
VS0(17,24)=QCy*VS0(17,13)+WQy*VS1(17,13)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +2D0*HfxZpE*VS1(9,13)
VS0(17,25)=QCy*VS0(17,14)+WQy*VS1(17,14)&
   +3D0*r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(9,14)
VS0(17,26)=QCx*VS0(17,15)+WQx*VS1(17,15)-r1x2E*VR1(17,15)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))
VS0(17,27)=QCx*VS0(17,16)+WQx*VS1(17,16)-r1x2E*VR1(17,16)&
   +r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))
VS0(17,28)=QCy*VS0(17,16)+WQy*VS1(17,16)&
   +r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +2D0*HfxZpE*VS1(9,16)
VS0(17,29)=QCy*VS0(17,17)+WQy*VS1(17,17)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +2D0*HfxZpE*VS1(9,17)
VS0(17,30)=QCx*VS0(17,18)+WQx*VS1(17,18)-r1x2E*VR1(17,18)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))
VS0(17,31)=QCz*VS0(17,16)+WQz*VS1(17,16)&
   +r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +HfxZpE*VS1(7,16)
VS0(17,32)=QCy*VS0(17,19)+WQy*VS1(17,19)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(9,19)
VS0(17,33)=QCz*VS0(17,18)+WQz*VS1(17,18)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +HfxZpE*VS1(7,18)
VS0(17,34)=QCz*VS0(17,19)+WQz*VS1(17,19)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +HfxZpE*VS1(7,19)
VS0(17,35)=QCz*VS0(17,20)+WQz*VS1(17,20)&
   +3D0*r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +HfxZpE*VS1(7,20)
VS0(18,21)=QCx*VS0(18,11)+WQx*VS1(18,11)-r1x2E*VR1(18,11)&
   +3D0*r1x2E*(VS0(18,5)-ZxZpE*VS1(18,5))&
   +HfxZpE*VS1(10,11)
VS0(18,22)=QCx*VS0(18,12)+WQx*VS1(18,12)-r1x2E*VR1(18,12)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +HfxZpE*VS1(10,12)
VS0(18,23)=QCx*VS0(18,13)+WQx*VS1(18,13)-r1x2E*VR1(18,13)&
   +r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))&
   +HfxZpE*VS1(10,13)
VS0(18,24)=QCy*VS0(18,13)+WQy*VS1(18,13)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))
VS0(18,25)=QCy*VS0(18,14)+WQy*VS1(18,14)&
   +3D0*r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))
VS0(18,26)=QCx*VS0(18,15)+WQx*VS1(18,15)-r1x2E*VR1(18,15)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +HfxZpE*VS1(10,15)
VS0(18,27)=QCx*VS0(18,16)+WQx*VS1(18,16)-r1x2E*VR1(18,16)&
   +r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +HfxZpE*VS1(10,16)
VS0(18,28)=QCy*VS0(18,16)+WQy*VS1(18,16)&
   +r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))
VS0(18,29)=QCy*VS0(18,17)+WQy*VS1(18,17)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))
VS0(18,30)=QCx*VS0(18,18)+WQx*VS1(18,18)-r1x2E*VR1(18,18)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +HfxZpE*VS1(10,18)
VS0(18,31)=QCz*VS0(18,16)+WQz*VS1(18,16)&
   +r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +2D0*HfxZpE*VS1(8,16)
VS0(18,32)=QCy*VS0(18,19)+WQy*VS1(18,19)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))
VS0(18,33)=QCz*VS0(18,18)+WQz*VS1(18,18)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +2D0*HfxZpE*VS1(8,18)
VS0(18,34)=QCz*VS0(18,19)+WQz*VS1(18,19)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +2D0*HfxZpE*VS1(8,19)
VS0(18,35)=QCz*VS0(18,20)+WQz*VS1(18,20)&
   +3D0*r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(8,20)
VS0(19,21)=QCx*VS0(19,11)+WQx*VS1(19,11)-r1x2E*VR1(19,11)&
   +3D0*r1x2E*(VS0(19,5)-ZxZpE*VS1(19,5))
VS0(19,22)=QCx*VS0(19,12)+WQx*VS1(19,12)-r1x2E*VR1(19,12)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))
VS0(19,23)=QCx*VS0(19,13)+WQx*VS1(19,13)-r1x2E*VR1(19,13)&
   +r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))
VS0(19,24)=QCy*VS0(19,13)+WQy*VS1(19,13)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +HfxZpE*VS1(10,13)
VS0(19,25)=QCy*VS0(19,14)+WQy*VS1(19,14)&
   +3D0*r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))&
   +HfxZpE*VS1(10,14)
VS0(19,26)=QCx*VS0(19,15)+WQx*VS1(19,15)-r1x2E*VR1(19,15)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))
VS0(19,27)=QCx*VS0(19,16)+WQx*VS1(19,16)-r1x2E*VR1(19,16)&
   +r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))
VS0(19,28)=QCy*VS0(19,16)+WQy*VS1(19,16)&
   +r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +HfxZpE*VS1(10,16)
VS0(19,29)=QCy*VS0(19,17)+WQy*VS1(19,17)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +HfxZpE*VS1(10,17)
VS0(19,30)=QCx*VS0(19,18)+WQx*VS1(19,18)-r1x2E*VR1(19,18)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))
VS0(19,31)=QCz*VS0(19,16)+WQz*VS1(19,16)&
   +r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +2D0*HfxZpE*VS1(9,16)
VS0(19,32)=QCy*VS0(19,19)+WQy*VS1(19,19)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +HfxZpE*VS1(10,19)
VS0(19,33)=QCz*VS0(19,18)+WQz*VS1(19,18)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +2D0*HfxZpE*VS1(9,18)
VS0(19,34)=QCz*VS0(19,19)+WQz*VS1(19,19)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +2D0*HfxZpE*VS1(9,19)
VS0(19,35)=QCz*VS0(19,20)+WQz*VS1(19,20)&
   +3D0*r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(9,20)
VS0(20,21)=QCx*VS0(20,11)+WQx*VS1(20,11)-r1x2E*VR1(20,11)&
   +3D0*r1x2E*(VS0(20,5)-ZxZpE*VS1(20,5))
VS0(20,22)=QCx*VS0(20,12)+WQx*VS1(20,12)-r1x2E*VR1(20,12)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,23)=QCx*VS0(20,13)+WQx*VS1(20,13)-r1x2E*VR1(20,13)&
   +r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,24)=QCy*VS0(20,13)+WQy*VS1(20,13)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,25)=QCy*VS0(20,14)+WQy*VS1(20,14)&
   +3D0*r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,26)=QCx*VS0(20,15)+WQx*VS1(20,15)-r1x2E*VR1(20,15)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,27)=QCx*VS0(20,16)+WQx*VS1(20,16)-r1x2E*VR1(20,16)&
   +r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,28)=QCy*VS0(20,16)+WQy*VS1(20,16)&
   +r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,29)=QCy*VS0(20,17)+WQy*VS1(20,17)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,30)=QCx*VS0(20,18)+WQx*VS1(20,18)-r1x2E*VR1(20,18)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,31)=QCz*VS0(20,16)+WQz*VS1(20,16)&
   +r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))&
   +3D0*HfxZpE*VS1(10,16)
VS0(20,32)=QCy*VS0(20,19)+WQy*VS1(20,19)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,33)=QCz*VS0(20,18)+WQz*VS1(20,18)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))&
   +3D0*HfxZpE*VS1(10,18)
VS0(20,34)=QCz*VS0(20,19)+WQz*VS1(20,19)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))&
   +3D0*HfxZpE*VS1(10,19)
VS0(20,35)=QCz*VS0(20,20)+WQz*VS1(20,20)&
   +3D0*r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))&
   +3D0*HfxZpE*VS1(10,20)
CASE(2)
VS0(11,21)=QCx*VS0(11,11)+WQx*VS1(11,11)&
   +3D0*r1x2E*(VS0(11,5)-ZxZpE*VS1(11,5))&
   +3D0*HfxZpE*VS1(5,11)
VS0(11,22)=QCx*VS0(11,12)+WQx*VS1(11,12)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))&
   +3D0*HfxZpE*VS1(5,12)
VS0(11,23)=QCx*VS0(11,13)+WQx*VS1(11,13)&
   +r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))&
   +3D0*HfxZpE*VS1(5,13)
VS0(11,24)=QCy*VS0(11,13)+WQy*VS1(11,13)-r1x2E*VR1(11,13)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,25)=QCy*VS0(11,14)+WQy*VS1(11,14)-r1x2E*VR1(11,14)&
   +3D0*r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))
VS0(11,26)=QCx*VS0(11,15)+WQx*VS1(11,15)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))&
   +3D0*HfxZpE*VS1(5,15)
VS0(11,27)=QCx*VS0(11,16)+WQx*VS1(11,16)&
   +r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))&
   +3D0*HfxZpE*VS1(5,16)
VS0(11,28)=QCy*VS0(11,16)+WQy*VS1(11,16)-r1x2E*VR1(11,16)&
   +r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,29)=QCy*VS0(11,17)+WQy*VS1(11,17)-r1x2E*VR1(11,17)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,30)=QCx*VS0(11,18)+WQx*VS1(11,18)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))&
   +3D0*HfxZpE*VS1(5,18)
VS0(11,31)=QCz*VS0(11,16)+WQz*VS1(11,16)&
   +r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,32)=QCy*VS0(11,19)+WQy*VS1(11,19)-r1x2E*VR1(11,19)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(11,33)=QCz*VS0(11,18)+WQz*VS1(11,18)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,34)=QCz*VS0(11,19)+WQz*VS1(11,19)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,35)=QCz*VS0(11,20)+WQz*VS1(11,20)&
   +3D0*r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(12,21)=QCx*VS0(12,11)+WQx*VS1(12,11)&
   +3D0*r1x2E*(VS0(12,5)-ZxZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(6,11)
VS0(12,22)=QCx*VS0(12,12)+WQx*VS1(12,12)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +2D0*HfxZpE*VS1(6,12)
VS0(12,23)=QCx*VS0(12,13)+WQx*VS1(12,13)&
   +r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(6,13)
VS0(12,24)=QCy*VS0(12,13)+WQy*VS1(12,13)-r1x2E*VR1(12,13)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +HfxZpE*VS1(5,13)
VS0(12,25)=QCy*VS0(12,14)+WQy*VS1(12,14)-r1x2E*VR1(12,14)&
   +3D0*r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +HfxZpE*VS1(5,14)
VS0(12,26)=QCx*VS0(12,15)+WQx*VS1(12,15)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +2D0*HfxZpE*VS1(6,15)
VS0(12,27)=QCx*VS0(12,16)+WQx*VS1(12,16)&
   +r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +2D0*HfxZpE*VS1(6,16)
VS0(12,28)=QCy*VS0(12,16)+WQy*VS1(12,16)-r1x2E*VR1(12,16)&
   +r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +HfxZpE*VS1(5,16)
VS0(12,29)=QCy*VS0(12,17)+WQy*VS1(12,17)-r1x2E*VR1(12,17)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +HfxZpE*VS1(5,17)
VS0(12,30)=QCx*VS0(12,18)+WQx*VS1(12,18)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +2D0*HfxZpE*VS1(6,18)
VS0(12,31)=QCz*VS0(12,16)+WQz*VS1(12,16)&
   +r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))
VS0(12,32)=QCy*VS0(12,19)+WQy*VS1(12,19)-r1x2E*VR1(12,19)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +HfxZpE*VS1(5,19)
VS0(12,33)=QCz*VS0(12,18)+WQz*VS1(12,18)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))
VS0(12,34)=QCz*VS0(12,19)+WQz*VS1(12,19)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))
VS0(12,35)=QCz*VS0(12,20)+WQz*VS1(12,20)&
   +3D0*r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))
VS0(13,21)=QCx*VS0(13,11)+WQx*VS1(13,11)&
   +3D0*r1x2E*(VS0(13,5)-ZxZpE*VS1(13,5))&
   +HfxZpE*VS1(7,11)
VS0(13,22)=QCx*VS0(13,12)+WQx*VS1(13,12)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +HfxZpE*VS1(7,12)
VS0(13,23)=QCx*VS0(13,13)+WQx*VS1(13,13)&
   +r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +HfxZpE*VS1(7,13)
VS0(13,24)=QCy*VS0(13,13)+WQy*VS1(13,13)-r1x2E*VR1(13,13)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +2D0*HfxZpE*VS1(6,13)
VS0(13,25)=QCy*VS0(13,14)+WQy*VS1(13,14)-r1x2E*VR1(13,14)&
   +3D0*r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(6,14)
VS0(13,26)=QCx*VS0(13,15)+WQx*VS1(13,15)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +HfxZpE*VS1(7,15)
VS0(13,27)=QCx*VS0(13,16)+WQx*VS1(13,16)&
   +r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +HfxZpE*VS1(7,16)
VS0(13,28)=QCy*VS0(13,16)+WQy*VS1(13,16)-r1x2E*VR1(13,16)&
   +r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +2D0*HfxZpE*VS1(6,16)
VS0(13,29)=QCy*VS0(13,17)+WQy*VS1(13,17)-r1x2E*VR1(13,17)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +2D0*HfxZpE*VS1(6,17)
VS0(13,30)=QCx*VS0(13,18)+WQx*VS1(13,18)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +HfxZpE*VS1(7,18)
VS0(13,31)=QCz*VS0(13,16)+WQz*VS1(13,16)&
   +r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))
VS0(13,32)=QCy*VS0(13,19)+WQy*VS1(13,19)-r1x2E*VR1(13,19)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +2D0*HfxZpE*VS1(6,19)
VS0(13,33)=QCz*VS0(13,18)+WQz*VS1(13,18)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))
VS0(13,34)=QCz*VS0(13,19)+WQz*VS1(13,19)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))
VS0(13,35)=QCz*VS0(13,20)+WQz*VS1(13,20)&
   +3D0*r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))
VS0(14,21)=QCx*VS0(14,11)+WQx*VS1(14,11)&
   +3D0*r1x2E*(VS0(14,5)-ZxZpE*VS1(14,5))
VS0(14,22)=QCx*VS0(14,12)+WQx*VS1(14,12)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,23)=QCx*VS0(14,13)+WQx*VS1(14,13)&
   +r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))
VS0(14,24)=QCy*VS0(14,13)+WQy*VS1(14,13)-r1x2E*VR1(14,13)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))&
   +3D0*HfxZpE*VS1(7,13)
VS0(14,25)=QCy*VS0(14,14)+WQy*VS1(14,14)-r1x2E*VR1(14,14)&
   +3D0*r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))&
   +3D0*HfxZpE*VS1(7,14)
VS0(14,26)=QCx*VS0(14,15)+WQx*VS1(14,15)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,27)=QCx*VS0(14,16)+WQx*VS1(14,16)&
   +r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,28)=QCy*VS0(14,16)+WQy*VS1(14,16)-r1x2E*VR1(14,16)&
   +r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))&
   +3D0*HfxZpE*VS1(7,16)
VS0(14,29)=QCy*VS0(14,17)+WQy*VS1(14,17)-r1x2E*VR1(14,17)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))&
   +3D0*HfxZpE*VS1(7,17)
VS0(14,30)=QCx*VS0(14,18)+WQx*VS1(14,18)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(14,31)=QCz*VS0(14,16)+WQz*VS1(14,16)&
   +r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,32)=QCy*VS0(14,19)+WQy*VS1(14,19)-r1x2E*VR1(14,19)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))&
   +3D0*HfxZpE*VS1(7,19)
VS0(14,33)=QCz*VS0(14,18)+WQz*VS1(14,18)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,34)=QCz*VS0(14,19)+WQz*VS1(14,19)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,35)=QCz*VS0(14,20)+WQz*VS1(14,20)&
   +3D0*r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(15,21)=QCx*VS0(15,11)+WQx*VS1(15,11)&
   +3D0*r1x2E*(VS0(15,5)-ZxZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(8,11)
VS0(15,22)=QCx*VS0(15,12)+WQx*VS1(15,12)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +2D0*HfxZpE*VS1(8,12)
VS0(15,23)=QCx*VS0(15,13)+WQx*VS1(15,13)&
   +r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))&
   +2D0*HfxZpE*VS1(8,13)
VS0(15,24)=QCy*VS0(15,13)+WQy*VS1(15,13)-r1x2E*VR1(15,13)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))
VS0(15,25)=QCy*VS0(15,14)+WQy*VS1(15,14)-r1x2E*VR1(15,14)&
   +3D0*r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))
VS0(15,26)=QCx*VS0(15,15)+WQx*VS1(15,15)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +2D0*HfxZpE*VS1(8,15)
VS0(15,27)=QCx*VS0(15,16)+WQx*VS1(15,16)&
   +r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +2D0*HfxZpE*VS1(8,16)
VS0(15,28)=QCy*VS0(15,16)+WQy*VS1(15,16)-r1x2E*VR1(15,16)&
   +r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))
VS0(15,29)=QCy*VS0(15,17)+WQy*VS1(15,17)-r1x2E*VR1(15,17)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))
VS0(15,30)=QCx*VS0(15,18)+WQx*VS1(15,18)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(8,18)
VS0(15,31)=QCz*VS0(15,16)+WQz*VS1(15,16)&
   +r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +HfxZpE*VS1(5,16)
VS0(15,32)=QCy*VS0(15,19)+WQy*VS1(15,19)-r1x2E*VR1(15,19)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))
VS0(15,33)=QCz*VS0(15,18)+WQz*VS1(15,18)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +HfxZpE*VS1(5,18)
VS0(15,34)=QCz*VS0(15,19)+WQz*VS1(15,19)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +HfxZpE*VS1(5,19)
VS0(15,35)=QCz*VS0(15,20)+WQz*VS1(15,20)&
   +3D0*r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +HfxZpE*VS1(5,20)
VS0(16,21)=QCx*VS0(16,11)+WQx*VS1(16,11)&
   +3D0*r1x2E*(VS0(16,5)-ZxZpE*VS1(16,5))&
   +HfxZpE*VS1(9,11)
VS0(16,22)=QCx*VS0(16,12)+WQx*VS1(16,12)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(9,12)
VS0(16,23)=QCx*VS0(16,13)+WQx*VS1(16,13)&
   +r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(9,13)
VS0(16,24)=QCy*VS0(16,13)+WQy*VS1(16,13)-r1x2E*VR1(16,13)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(8,13)
VS0(16,25)=QCy*VS0(16,14)+WQy*VS1(16,14)-r1x2E*VR1(16,14)&
   +3D0*r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(8,14)
VS0(16,26)=QCx*VS0(16,15)+WQx*VS1(16,15)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(9,15)
VS0(16,27)=QCx*VS0(16,16)+WQx*VS1(16,16)&
   +r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(9,16)
VS0(16,28)=QCy*VS0(16,16)+WQy*VS1(16,16)-r1x2E*VR1(16,16)&
   +r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(8,16)
VS0(16,29)=QCy*VS0(16,17)+WQy*VS1(16,17)-r1x2E*VR1(16,17)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(8,17)
VS0(16,30)=QCx*VS0(16,18)+WQx*VS1(16,18)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(9,18)
VS0(16,31)=QCz*VS0(16,16)+WQz*VS1(16,16)&
   +r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(6,16)
VS0(16,32)=QCy*VS0(16,19)+WQy*VS1(16,19)-r1x2E*VR1(16,19)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(8,19)
VS0(16,33)=QCz*VS0(16,18)+WQz*VS1(16,18)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(6,18)
VS0(16,34)=QCz*VS0(16,19)+WQz*VS1(16,19)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(6,19)
VS0(16,35)=QCz*VS0(16,20)+WQz*VS1(16,20)&
   +3D0*r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(6,20)
VS0(17,21)=QCx*VS0(17,11)+WQx*VS1(17,11)&
   +3D0*r1x2E*(VS0(17,5)-ZxZpE*VS1(17,5))
VS0(17,22)=QCx*VS0(17,12)+WQx*VS1(17,12)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))
VS0(17,23)=QCx*VS0(17,13)+WQx*VS1(17,13)&
   +r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))
VS0(17,24)=QCy*VS0(17,13)+WQy*VS1(17,13)-r1x2E*VR1(17,13)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +2D0*HfxZpE*VS1(9,13)
VS0(17,25)=QCy*VS0(17,14)+WQy*VS1(17,14)-r1x2E*VR1(17,14)&
   +3D0*r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(9,14)
VS0(17,26)=QCx*VS0(17,15)+WQx*VS1(17,15)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))
VS0(17,27)=QCx*VS0(17,16)+WQx*VS1(17,16)&
   +r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))
VS0(17,28)=QCy*VS0(17,16)+WQy*VS1(17,16)-r1x2E*VR1(17,16)&
   +r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +2D0*HfxZpE*VS1(9,16)
VS0(17,29)=QCy*VS0(17,17)+WQy*VS1(17,17)-r1x2E*VR1(17,17)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +2D0*HfxZpE*VS1(9,17)
VS0(17,30)=QCx*VS0(17,18)+WQx*VS1(17,18)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))
VS0(17,31)=QCz*VS0(17,16)+WQz*VS1(17,16)&
   +r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +HfxZpE*VS1(7,16)
VS0(17,32)=QCy*VS0(17,19)+WQy*VS1(17,19)-r1x2E*VR1(17,19)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(9,19)
VS0(17,33)=QCz*VS0(17,18)+WQz*VS1(17,18)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +HfxZpE*VS1(7,18)
VS0(17,34)=QCz*VS0(17,19)+WQz*VS1(17,19)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +HfxZpE*VS1(7,19)
VS0(17,35)=QCz*VS0(17,20)+WQz*VS1(17,20)&
   +3D0*r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +HfxZpE*VS1(7,20)
VS0(18,21)=QCx*VS0(18,11)+WQx*VS1(18,11)&
   +3D0*r1x2E*(VS0(18,5)-ZxZpE*VS1(18,5))&
   +HfxZpE*VS1(10,11)
VS0(18,22)=QCx*VS0(18,12)+WQx*VS1(18,12)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +HfxZpE*VS1(10,12)
VS0(18,23)=QCx*VS0(18,13)+WQx*VS1(18,13)&
   +r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))&
   +HfxZpE*VS1(10,13)
VS0(18,24)=QCy*VS0(18,13)+WQy*VS1(18,13)-r1x2E*VR1(18,13)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))
VS0(18,25)=QCy*VS0(18,14)+WQy*VS1(18,14)-r1x2E*VR1(18,14)&
   +3D0*r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))
VS0(18,26)=QCx*VS0(18,15)+WQx*VS1(18,15)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +HfxZpE*VS1(10,15)
VS0(18,27)=QCx*VS0(18,16)+WQx*VS1(18,16)&
   +r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +HfxZpE*VS1(10,16)
VS0(18,28)=QCy*VS0(18,16)+WQy*VS1(18,16)-r1x2E*VR1(18,16)&
   +r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))
VS0(18,29)=QCy*VS0(18,17)+WQy*VS1(18,17)-r1x2E*VR1(18,17)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))
VS0(18,30)=QCx*VS0(18,18)+WQx*VS1(18,18)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +HfxZpE*VS1(10,18)
VS0(18,31)=QCz*VS0(18,16)+WQz*VS1(18,16)&
   +r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +2D0*HfxZpE*VS1(8,16)
VS0(18,32)=QCy*VS0(18,19)+WQy*VS1(18,19)-r1x2E*VR1(18,19)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))
VS0(18,33)=QCz*VS0(18,18)+WQz*VS1(18,18)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +2D0*HfxZpE*VS1(8,18)
VS0(18,34)=QCz*VS0(18,19)+WQz*VS1(18,19)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +2D0*HfxZpE*VS1(8,19)
VS0(18,35)=QCz*VS0(18,20)+WQz*VS1(18,20)&
   +3D0*r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(8,20)
VS0(19,21)=QCx*VS0(19,11)+WQx*VS1(19,11)&
   +3D0*r1x2E*(VS0(19,5)-ZxZpE*VS1(19,5))
VS0(19,22)=QCx*VS0(19,12)+WQx*VS1(19,12)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))
VS0(19,23)=QCx*VS0(19,13)+WQx*VS1(19,13)&
   +r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))
VS0(19,24)=QCy*VS0(19,13)+WQy*VS1(19,13)-r1x2E*VR1(19,13)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +HfxZpE*VS1(10,13)
VS0(19,25)=QCy*VS0(19,14)+WQy*VS1(19,14)-r1x2E*VR1(19,14)&
   +3D0*r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))&
   +HfxZpE*VS1(10,14)
VS0(19,26)=QCx*VS0(19,15)+WQx*VS1(19,15)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))
VS0(19,27)=QCx*VS0(19,16)+WQx*VS1(19,16)&
   +r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))
VS0(19,28)=QCy*VS0(19,16)+WQy*VS1(19,16)-r1x2E*VR1(19,16)&
   +r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +HfxZpE*VS1(10,16)
VS0(19,29)=QCy*VS0(19,17)+WQy*VS1(19,17)-r1x2E*VR1(19,17)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +HfxZpE*VS1(10,17)
VS0(19,30)=QCx*VS0(19,18)+WQx*VS1(19,18)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))
VS0(19,31)=QCz*VS0(19,16)+WQz*VS1(19,16)&
   +r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +2D0*HfxZpE*VS1(9,16)
VS0(19,32)=QCy*VS0(19,19)+WQy*VS1(19,19)-r1x2E*VR1(19,19)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +HfxZpE*VS1(10,19)
VS0(19,33)=QCz*VS0(19,18)+WQz*VS1(19,18)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +2D0*HfxZpE*VS1(9,18)
VS0(19,34)=QCz*VS0(19,19)+WQz*VS1(19,19)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +2D0*HfxZpE*VS1(9,19)
VS0(19,35)=QCz*VS0(19,20)+WQz*VS1(19,20)&
   +3D0*r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(9,20)
VS0(20,21)=QCx*VS0(20,11)+WQx*VS1(20,11)&
   +3D0*r1x2E*(VS0(20,5)-ZxZpE*VS1(20,5))
VS0(20,22)=QCx*VS0(20,12)+WQx*VS1(20,12)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,23)=QCx*VS0(20,13)+WQx*VS1(20,13)&
   +r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,24)=QCy*VS0(20,13)+WQy*VS1(20,13)-r1x2E*VR1(20,13)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,25)=QCy*VS0(20,14)+WQy*VS1(20,14)-r1x2E*VR1(20,14)&
   +3D0*r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,26)=QCx*VS0(20,15)+WQx*VS1(20,15)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,27)=QCx*VS0(20,16)+WQx*VS1(20,16)&
   +r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,28)=QCy*VS0(20,16)+WQy*VS1(20,16)-r1x2E*VR1(20,16)&
   +r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,29)=QCy*VS0(20,17)+WQy*VS1(20,17)-r1x2E*VR1(20,17)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,30)=QCx*VS0(20,18)+WQx*VS1(20,18)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,31)=QCz*VS0(20,16)+WQz*VS1(20,16)&
   +r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))&
   +3D0*HfxZpE*VS1(10,16)
VS0(20,32)=QCy*VS0(20,19)+WQy*VS1(20,19)-r1x2E*VR1(20,19)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,33)=QCz*VS0(20,18)+WQz*VS1(20,18)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))&
   +3D0*HfxZpE*VS1(10,18)
VS0(20,34)=QCz*VS0(20,19)+WQz*VS1(20,19)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))&
   +3D0*HfxZpE*VS1(10,19)
VS0(20,35)=QCz*VS0(20,20)+WQz*VS1(20,20)&
   +3D0*r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))&
   +3D0*HfxZpE*VS1(10,20)
CASE(3)
VS0(11,21)=QCx*VS0(11,11)+WQx*VS1(11,11)&
   +3D0*r1x2E*(VS0(11,5)-ZxZpE*VS1(11,5))&
   +3D0*HfxZpE*VS1(5,11)
VS0(11,22)=QCx*VS0(11,12)+WQx*VS1(11,12)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))&
   +3D0*HfxZpE*VS1(5,12)
VS0(11,23)=QCx*VS0(11,13)+WQx*VS1(11,13)&
   +r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))&
   +3D0*HfxZpE*VS1(5,13)
VS0(11,24)=QCy*VS0(11,13)+WQy*VS1(11,13)&
   +2D0*r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,25)=QCy*VS0(11,14)+WQy*VS1(11,14)&
   +3D0*r1x2E*(VS0(11,7)-ZxZpE*VS1(11,7))
VS0(11,26)=QCx*VS0(11,15)+WQx*VS1(11,15)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))&
   +3D0*HfxZpE*VS1(5,15)
VS0(11,27)=QCx*VS0(11,16)+WQx*VS1(11,16)&
   +r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))&
   +3D0*HfxZpE*VS1(5,16)
VS0(11,28)=QCy*VS0(11,16)+WQy*VS1(11,16)&
   +r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,29)=QCy*VS0(11,17)+WQy*VS1(11,17)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,30)=QCx*VS0(11,18)+WQx*VS1(11,18)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))&
   +3D0*HfxZpE*VS1(5,18)
VS0(11,31)=QCz*VS0(11,16)+WQz*VS1(11,16)-r1x2E*VR1(11,16)&
   +r1x2E*(VS0(11,6)-ZxZpE*VS1(11,6))
VS0(11,32)=QCy*VS0(11,19)+WQy*VS1(11,19)&
   +r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(11,33)=QCz*VS0(11,18)+WQz*VS1(11,18)-r1x2E*VR1(11,18)&
   +2D0*r1x2E*(VS0(11,8)-ZxZpE*VS1(11,8))
VS0(11,34)=QCz*VS0(11,19)+WQz*VS1(11,19)-r1x2E*VR1(11,19)&
   +2D0*r1x2E*(VS0(11,9)-ZxZpE*VS1(11,9))
VS0(11,35)=QCz*VS0(11,20)+WQz*VS1(11,20)-r1x2E*VR1(11,20)&
   +3D0*r1x2E*(VS0(11,10)-ZxZpE*VS1(11,10))
VS0(12,21)=QCx*VS0(12,11)+WQx*VS1(12,11)&
   +3D0*r1x2E*(VS0(12,5)-ZxZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(6,11)
VS0(12,22)=QCx*VS0(12,12)+WQx*VS1(12,12)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +2D0*HfxZpE*VS1(6,12)
VS0(12,23)=QCx*VS0(12,13)+WQx*VS1(12,13)&
   +r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(6,13)
VS0(12,24)=QCy*VS0(12,13)+WQy*VS1(12,13)&
   +2D0*r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))&
   +HfxZpE*VS1(5,13)
VS0(12,25)=QCy*VS0(12,14)+WQy*VS1(12,14)&
   +3D0*r1x2E*(VS0(12,7)-ZxZpE*VS1(12,7))&
   +HfxZpE*VS1(5,14)
VS0(12,26)=QCx*VS0(12,15)+WQx*VS1(12,15)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +2D0*HfxZpE*VS1(6,15)
VS0(12,27)=QCx*VS0(12,16)+WQx*VS1(12,16)&
   +r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +2D0*HfxZpE*VS1(6,16)
VS0(12,28)=QCy*VS0(12,16)+WQy*VS1(12,16)&
   +r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))&
   +HfxZpE*VS1(5,16)
VS0(12,29)=QCy*VS0(12,17)+WQy*VS1(12,17)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))&
   +HfxZpE*VS1(5,17)
VS0(12,30)=QCx*VS0(12,18)+WQx*VS1(12,18)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +2D0*HfxZpE*VS1(6,18)
VS0(12,31)=QCz*VS0(12,16)+WQz*VS1(12,16)-r1x2E*VR1(12,16)&
   +r1x2E*(VS0(12,6)-ZxZpE*VS1(12,6))
VS0(12,32)=QCy*VS0(12,19)+WQy*VS1(12,19)&
   +r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))&
   +HfxZpE*VS1(5,19)
VS0(12,33)=QCz*VS0(12,18)+WQz*VS1(12,18)-r1x2E*VR1(12,18)&
   +2D0*r1x2E*(VS0(12,8)-ZxZpE*VS1(12,8))
VS0(12,34)=QCz*VS0(12,19)+WQz*VS1(12,19)-r1x2E*VR1(12,19)&
   +2D0*r1x2E*(VS0(12,9)-ZxZpE*VS1(12,9))
VS0(12,35)=QCz*VS0(12,20)+WQz*VS1(12,20)-r1x2E*VR1(12,20)&
   +3D0*r1x2E*(VS0(12,10)-ZxZpE*VS1(12,10))
VS0(13,21)=QCx*VS0(13,11)+WQx*VS1(13,11)&
   +3D0*r1x2E*(VS0(13,5)-ZxZpE*VS1(13,5))&
   +HfxZpE*VS1(7,11)
VS0(13,22)=QCx*VS0(13,12)+WQx*VS1(13,12)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +HfxZpE*VS1(7,12)
VS0(13,23)=QCx*VS0(13,13)+WQx*VS1(13,13)&
   +r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +HfxZpE*VS1(7,13)
VS0(13,24)=QCy*VS0(13,13)+WQy*VS1(13,13)&
   +2D0*r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))&
   +2D0*HfxZpE*VS1(6,13)
VS0(13,25)=QCy*VS0(13,14)+WQy*VS1(13,14)&
   +3D0*r1x2E*(VS0(13,7)-ZxZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(6,14)
VS0(13,26)=QCx*VS0(13,15)+WQx*VS1(13,15)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +HfxZpE*VS1(7,15)
VS0(13,27)=QCx*VS0(13,16)+WQx*VS1(13,16)&
   +r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +HfxZpE*VS1(7,16)
VS0(13,28)=QCy*VS0(13,16)+WQy*VS1(13,16)&
   +r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))&
   +2D0*HfxZpE*VS1(6,16)
VS0(13,29)=QCy*VS0(13,17)+WQy*VS1(13,17)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))&
   +2D0*HfxZpE*VS1(6,17)
VS0(13,30)=QCx*VS0(13,18)+WQx*VS1(13,18)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +HfxZpE*VS1(7,18)
VS0(13,31)=QCz*VS0(13,16)+WQz*VS1(13,16)-r1x2E*VR1(13,16)&
   +r1x2E*(VS0(13,6)-ZxZpE*VS1(13,6))
VS0(13,32)=QCy*VS0(13,19)+WQy*VS1(13,19)&
   +r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))&
   +2D0*HfxZpE*VS1(6,19)
VS0(13,33)=QCz*VS0(13,18)+WQz*VS1(13,18)-r1x2E*VR1(13,18)&
   +2D0*r1x2E*(VS0(13,8)-ZxZpE*VS1(13,8))
VS0(13,34)=QCz*VS0(13,19)+WQz*VS1(13,19)-r1x2E*VR1(13,19)&
   +2D0*r1x2E*(VS0(13,9)-ZxZpE*VS1(13,9))
VS0(13,35)=QCz*VS0(13,20)+WQz*VS1(13,20)-r1x2E*VR1(13,20)&
   +3D0*r1x2E*(VS0(13,10)-ZxZpE*VS1(13,10))
VS0(14,21)=QCx*VS0(14,11)+WQx*VS1(14,11)&
   +3D0*r1x2E*(VS0(14,5)-ZxZpE*VS1(14,5))
VS0(14,22)=QCx*VS0(14,12)+WQx*VS1(14,12)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,23)=QCx*VS0(14,13)+WQx*VS1(14,13)&
   +r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))
VS0(14,24)=QCy*VS0(14,13)+WQy*VS1(14,13)&
   +2D0*r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))&
   +3D0*HfxZpE*VS1(7,13)
VS0(14,25)=QCy*VS0(14,14)+WQy*VS1(14,14)&
   +3D0*r1x2E*(VS0(14,7)-ZxZpE*VS1(14,7))&
   +3D0*HfxZpE*VS1(7,14)
VS0(14,26)=QCx*VS0(14,15)+WQx*VS1(14,15)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,27)=QCx*VS0(14,16)+WQx*VS1(14,16)&
   +r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,28)=QCy*VS0(14,16)+WQy*VS1(14,16)&
   +r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))&
   +3D0*HfxZpE*VS1(7,16)
VS0(14,29)=QCy*VS0(14,17)+WQy*VS1(14,17)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))&
   +3D0*HfxZpE*VS1(7,17)
VS0(14,30)=QCx*VS0(14,18)+WQx*VS1(14,18)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(14,31)=QCz*VS0(14,16)+WQz*VS1(14,16)-r1x2E*VR1(14,16)&
   +r1x2E*(VS0(14,6)-ZxZpE*VS1(14,6))
VS0(14,32)=QCy*VS0(14,19)+WQy*VS1(14,19)&
   +r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))&
   +3D0*HfxZpE*VS1(7,19)
VS0(14,33)=QCz*VS0(14,18)+WQz*VS1(14,18)-r1x2E*VR1(14,18)&
   +2D0*r1x2E*(VS0(14,8)-ZxZpE*VS1(14,8))
VS0(14,34)=QCz*VS0(14,19)+WQz*VS1(14,19)-r1x2E*VR1(14,19)&
   +2D0*r1x2E*(VS0(14,9)-ZxZpE*VS1(14,9))
VS0(14,35)=QCz*VS0(14,20)+WQz*VS1(14,20)-r1x2E*VR1(14,20)&
   +3D0*r1x2E*(VS0(14,10)-ZxZpE*VS1(14,10))
VS0(15,21)=QCx*VS0(15,11)+WQx*VS1(15,11)&
   +3D0*r1x2E*(VS0(15,5)-ZxZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(8,11)
VS0(15,22)=QCx*VS0(15,12)+WQx*VS1(15,12)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +2D0*HfxZpE*VS1(8,12)
VS0(15,23)=QCx*VS0(15,13)+WQx*VS1(15,13)&
   +r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))&
   +2D0*HfxZpE*VS1(8,13)
VS0(15,24)=QCy*VS0(15,13)+WQy*VS1(15,13)&
   +2D0*r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))
VS0(15,25)=QCy*VS0(15,14)+WQy*VS1(15,14)&
   +3D0*r1x2E*(VS0(15,7)-ZxZpE*VS1(15,7))
VS0(15,26)=QCx*VS0(15,15)+WQx*VS1(15,15)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +2D0*HfxZpE*VS1(8,15)
VS0(15,27)=QCx*VS0(15,16)+WQx*VS1(15,16)&
   +r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +2D0*HfxZpE*VS1(8,16)
VS0(15,28)=QCy*VS0(15,16)+WQy*VS1(15,16)&
   +r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))
VS0(15,29)=QCy*VS0(15,17)+WQy*VS1(15,17)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))
VS0(15,30)=QCx*VS0(15,18)+WQx*VS1(15,18)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(8,18)
VS0(15,31)=QCz*VS0(15,16)+WQz*VS1(15,16)-r1x2E*VR1(15,16)&
   +r1x2E*(VS0(15,6)-ZxZpE*VS1(15,6))&
   +HfxZpE*VS1(5,16)
VS0(15,32)=QCy*VS0(15,19)+WQy*VS1(15,19)&
   +r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))
VS0(15,33)=QCz*VS0(15,18)+WQz*VS1(15,18)-r1x2E*VR1(15,18)&
   +2D0*r1x2E*(VS0(15,8)-ZxZpE*VS1(15,8))&
   +HfxZpE*VS1(5,18)
VS0(15,34)=QCz*VS0(15,19)+WQz*VS1(15,19)-r1x2E*VR1(15,19)&
   +2D0*r1x2E*(VS0(15,9)-ZxZpE*VS1(15,9))&
   +HfxZpE*VS1(5,19)
VS0(15,35)=QCz*VS0(15,20)+WQz*VS1(15,20)-r1x2E*VR1(15,20)&
   +3D0*r1x2E*(VS0(15,10)-ZxZpE*VS1(15,10))&
   +HfxZpE*VS1(5,20)
VS0(16,21)=QCx*VS0(16,11)+WQx*VS1(16,11)&
   +3D0*r1x2E*(VS0(16,5)-ZxZpE*VS1(16,5))&
   +HfxZpE*VS1(9,11)
VS0(16,22)=QCx*VS0(16,12)+WQx*VS1(16,12)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(9,12)
VS0(16,23)=QCx*VS0(16,13)+WQx*VS1(16,13)&
   +r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(9,13)
VS0(16,24)=QCy*VS0(16,13)+WQy*VS1(16,13)&
   +2D0*r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(8,13)
VS0(16,25)=QCy*VS0(16,14)+WQy*VS1(16,14)&
   +3D0*r1x2E*(VS0(16,7)-ZxZpE*VS1(16,7))&
   +HfxZpE*VS1(8,14)
VS0(16,26)=QCx*VS0(16,15)+WQx*VS1(16,15)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(9,15)
VS0(16,27)=QCx*VS0(16,16)+WQx*VS1(16,16)&
   +r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(9,16)
VS0(16,28)=QCy*VS0(16,16)+WQy*VS1(16,16)&
   +r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(8,16)
VS0(16,29)=QCy*VS0(16,17)+WQy*VS1(16,17)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(8,17)
VS0(16,30)=QCx*VS0(16,18)+WQx*VS1(16,18)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(9,18)
VS0(16,31)=QCz*VS0(16,16)+WQz*VS1(16,16)-r1x2E*VR1(16,16)&
   +r1x2E*(VS0(16,6)-ZxZpE*VS1(16,6))&
   +HfxZpE*VS1(6,16)
VS0(16,32)=QCy*VS0(16,19)+WQy*VS1(16,19)&
   +r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(8,19)
VS0(16,33)=QCz*VS0(16,18)+WQz*VS1(16,18)-r1x2E*VR1(16,18)&
   +2D0*r1x2E*(VS0(16,8)-ZxZpE*VS1(16,8))&
   +HfxZpE*VS1(6,18)
VS0(16,34)=QCz*VS0(16,19)+WQz*VS1(16,19)-r1x2E*VR1(16,19)&
   +2D0*r1x2E*(VS0(16,9)-ZxZpE*VS1(16,9))&
   +HfxZpE*VS1(6,19)
VS0(16,35)=QCz*VS0(16,20)+WQz*VS1(16,20)-r1x2E*VR1(16,20)&
   +3D0*r1x2E*(VS0(16,10)-ZxZpE*VS1(16,10))&
   +HfxZpE*VS1(6,20)
VS0(17,21)=QCx*VS0(17,11)+WQx*VS1(17,11)&
   +3D0*r1x2E*(VS0(17,5)-ZxZpE*VS1(17,5))
VS0(17,22)=QCx*VS0(17,12)+WQx*VS1(17,12)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))
VS0(17,23)=QCx*VS0(17,13)+WQx*VS1(17,13)&
   +r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))
VS0(17,24)=QCy*VS0(17,13)+WQy*VS1(17,13)&
   +2D0*r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +2D0*HfxZpE*VS1(9,13)
VS0(17,25)=QCy*VS0(17,14)+WQy*VS1(17,14)&
   +3D0*r1x2E*(VS0(17,7)-ZxZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(9,14)
VS0(17,26)=QCx*VS0(17,15)+WQx*VS1(17,15)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))
VS0(17,27)=QCx*VS0(17,16)+WQx*VS1(17,16)&
   +r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))
VS0(17,28)=QCy*VS0(17,16)+WQy*VS1(17,16)&
   +r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +2D0*HfxZpE*VS1(9,16)
VS0(17,29)=QCy*VS0(17,17)+WQy*VS1(17,17)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +2D0*HfxZpE*VS1(9,17)
VS0(17,30)=QCx*VS0(17,18)+WQx*VS1(17,18)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))
VS0(17,31)=QCz*VS0(17,16)+WQz*VS1(17,16)-r1x2E*VR1(17,16)&
   +r1x2E*(VS0(17,6)-ZxZpE*VS1(17,6))&
   +HfxZpE*VS1(7,16)
VS0(17,32)=QCy*VS0(17,19)+WQy*VS1(17,19)&
   +r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(9,19)
VS0(17,33)=QCz*VS0(17,18)+WQz*VS1(17,18)-r1x2E*VR1(17,18)&
   +2D0*r1x2E*(VS0(17,8)-ZxZpE*VS1(17,8))&
   +HfxZpE*VS1(7,18)
VS0(17,34)=QCz*VS0(17,19)+WQz*VS1(17,19)-r1x2E*VR1(17,19)&
   +2D0*r1x2E*(VS0(17,9)-ZxZpE*VS1(17,9))&
   +HfxZpE*VS1(7,19)
VS0(17,35)=QCz*VS0(17,20)+WQz*VS1(17,20)-r1x2E*VR1(17,20)&
   +3D0*r1x2E*(VS0(17,10)-ZxZpE*VS1(17,10))&
   +HfxZpE*VS1(7,20)
VS0(18,21)=QCx*VS0(18,11)+WQx*VS1(18,11)&
   +3D0*r1x2E*(VS0(18,5)-ZxZpE*VS1(18,5))&
   +HfxZpE*VS1(10,11)
VS0(18,22)=QCx*VS0(18,12)+WQx*VS1(18,12)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +HfxZpE*VS1(10,12)
VS0(18,23)=QCx*VS0(18,13)+WQx*VS1(18,13)&
   +r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))&
   +HfxZpE*VS1(10,13)
VS0(18,24)=QCy*VS0(18,13)+WQy*VS1(18,13)&
   +2D0*r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))
VS0(18,25)=QCy*VS0(18,14)+WQy*VS1(18,14)&
   +3D0*r1x2E*(VS0(18,7)-ZxZpE*VS1(18,7))
VS0(18,26)=QCx*VS0(18,15)+WQx*VS1(18,15)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +HfxZpE*VS1(10,15)
VS0(18,27)=QCx*VS0(18,16)+WQx*VS1(18,16)&
   +r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +HfxZpE*VS1(10,16)
VS0(18,28)=QCy*VS0(18,16)+WQy*VS1(18,16)&
   +r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))
VS0(18,29)=QCy*VS0(18,17)+WQy*VS1(18,17)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))
VS0(18,30)=QCx*VS0(18,18)+WQx*VS1(18,18)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +HfxZpE*VS1(10,18)
VS0(18,31)=QCz*VS0(18,16)+WQz*VS1(18,16)-r1x2E*VR1(18,16)&
   +r1x2E*(VS0(18,6)-ZxZpE*VS1(18,6))&
   +2D0*HfxZpE*VS1(8,16)
VS0(18,32)=QCy*VS0(18,19)+WQy*VS1(18,19)&
   +r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))
VS0(18,33)=QCz*VS0(18,18)+WQz*VS1(18,18)-r1x2E*VR1(18,18)&
   +2D0*r1x2E*(VS0(18,8)-ZxZpE*VS1(18,8))&
   +2D0*HfxZpE*VS1(8,18)
VS0(18,34)=QCz*VS0(18,19)+WQz*VS1(18,19)-r1x2E*VR1(18,19)&
   +2D0*r1x2E*(VS0(18,9)-ZxZpE*VS1(18,9))&
   +2D0*HfxZpE*VS1(8,19)
VS0(18,35)=QCz*VS0(18,20)+WQz*VS1(18,20)-r1x2E*VR1(18,20)&
   +3D0*r1x2E*(VS0(18,10)-ZxZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(8,20)
VS0(19,21)=QCx*VS0(19,11)+WQx*VS1(19,11)&
   +3D0*r1x2E*(VS0(19,5)-ZxZpE*VS1(19,5))
VS0(19,22)=QCx*VS0(19,12)+WQx*VS1(19,12)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))
VS0(19,23)=QCx*VS0(19,13)+WQx*VS1(19,13)&
   +r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))
VS0(19,24)=QCy*VS0(19,13)+WQy*VS1(19,13)&
   +2D0*r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +HfxZpE*VS1(10,13)
VS0(19,25)=QCy*VS0(19,14)+WQy*VS1(19,14)&
   +3D0*r1x2E*(VS0(19,7)-ZxZpE*VS1(19,7))&
   +HfxZpE*VS1(10,14)
VS0(19,26)=QCx*VS0(19,15)+WQx*VS1(19,15)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))
VS0(19,27)=QCx*VS0(19,16)+WQx*VS1(19,16)&
   +r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))
VS0(19,28)=QCy*VS0(19,16)+WQy*VS1(19,16)&
   +r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +HfxZpE*VS1(10,16)
VS0(19,29)=QCy*VS0(19,17)+WQy*VS1(19,17)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +HfxZpE*VS1(10,17)
VS0(19,30)=QCx*VS0(19,18)+WQx*VS1(19,18)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))
VS0(19,31)=QCz*VS0(19,16)+WQz*VS1(19,16)-r1x2E*VR1(19,16)&
   +r1x2E*(VS0(19,6)-ZxZpE*VS1(19,6))&
   +2D0*HfxZpE*VS1(9,16)
VS0(19,32)=QCy*VS0(19,19)+WQy*VS1(19,19)&
   +r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +HfxZpE*VS1(10,19)
VS0(19,33)=QCz*VS0(19,18)+WQz*VS1(19,18)-r1x2E*VR1(19,18)&
   +2D0*r1x2E*(VS0(19,8)-ZxZpE*VS1(19,8))&
   +2D0*HfxZpE*VS1(9,18)
VS0(19,34)=QCz*VS0(19,19)+WQz*VS1(19,19)-r1x2E*VR1(19,19)&
   +2D0*r1x2E*(VS0(19,9)-ZxZpE*VS1(19,9))&
   +2D0*HfxZpE*VS1(9,19)
VS0(19,35)=QCz*VS0(19,20)+WQz*VS1(19,20)-r1x2E*VR1(19,20)&
   +3D0*r1x2E*(VS0(19,10)-ZxZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(9,20)
VS0(20,21)=QCx*VS0(20,11)+WQx*VS1(20,11)&
   +3D0*r1x2E*(VS0(20,5)-ZxZpE*VS1(20,5))
VS0(20,22)=QCx*VS0(20,12)+WQx*VS1(20,12)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,23)=QCx*VS0(20,13)+WQx*VS1(20,13)&
   +r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,24)=QCy*VS0(20,13)+WQy*VS1(20,13)&
   +2D0*r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))
VS0(20,25)=QCy*VS0(20,14)+WQy*VS1(20,14)&
   +3D0*r1x2E*(VS0(20,7)-ZxZpE*VS1(20,7))
VS0(20,26)=QCx*VS0(20,15)+WQx*VS1(20,15)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,27)=QCx*VS0(20,16)+WQx*VS1(20,16)&
   +r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,28)=QCy*VS0(20,16)+WQy*VS1(20,16)&
   +r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))
VS0(20,29)=QCy*VS0(20,17)+WQy*VS1(20,17)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))
VS0(20,30)=QCx*VS0(20,18)+WQx*VS1(20,18)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,31)=QCz*VS0(20,16)+WQz*VS1(20,16)-r1x2E*VR1(20,16)&
   +r1x2E*(VS0(20,6)-ZxZpE*VS1(20,6))&
   +3D0*HfxZpE*VS1(10,16)
VS0(20,32)=QCy*VS0(20,19)+WQy*VS1(20,19)&
   +r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))
VS0(20,33)=QCz*VS0(20,18)+WQz*VS1(20,18)-r1x2E*VR1(20,18)&
   +2D0*r1x2E*(VS0(20,8)-ZxZpE*VS1(20,8))&
   +3D0*HfxZpE*VS1(10,18)
VS0(20,34)=QCz*VS0(20,19)+WQz*VS1(20,19)-r1x2E*VR1(20,19)&
   +2D0*r1x2E*(VS0(20,9)-ZxZpE*VS1(20,9))&
   +3D0*HfxZpE*VS1(10,19)
VS0(20,35)=QCz*VS0(20,20)+WQz*VS1(20,20)-r1x2E*VR1(20,20)&
   +3D0*r1x2E*(VS0(20,10)-ZxZpE*VS1(20,10))&
   +3D0*HfxZpE*VS1(10,20)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRf0g0'
STOP
END SELECT
END SUBROUTINE MVRRf0g0
