!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
! ----------------------------------------------------------
! COMPUTES THE INTEGRAL CLASS (f sp|d d)
! ----------------------------------------------------------
   SUBROUTINE IntB10020606(PrmBufB,LBra,PrmBufK,LKet,ACInfo,BDInfo, &
                              OA,LDA,OB,LDB,OC,LDC,OD,LDD,PBC,INTGRL)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      USE ShellPairStruct
      USE GammaF8
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER        :: LBra,LKet,CDOffSet
      REAL(DOUBLE)   :: PrmBufB(10,LBra),PrmBufK(10,LKet)
      TYPE(SmallAtomInfo) :: ACInfo,BDInfo
      TYPE(PBCInfo) :: PBC
      REAL(DOUBLE)  :: INTGRL(*)
      REAL(DOUBLE)  :: Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz
      REAL(DOUBLE)  :: Dx,Dy,Dz,Qx,Qy,Qz,Px,Py,Pz
      REAL(DOUBLE)  :: PQx,PQy,PQz,FPQx,FPQy,FPQz
      REAL(DOUBLE)  :: Zeta,Eta,Omega,Up,Uq,Upq
      REAL(DOUBLE)  :: T,ET,TwoT,InvT,SqInvT
      REAL(DOUBLE)  :: VRR(35,35,0:8)
      REAL(DOUBLE)  :: HRR(45,35,10)
      INTEGER       :: OffSet,OA,LDA,OB,LDB,OC,LDC,OD,LDD,I,J,K,L
      EXTERNAL InitDbl
      CALL InitDbl(45*35,HRR(1,1,1))
      Ax=ACInfo%Atm1X
      Ay=ACInfo%Atm1Y
      Az=ACInfo%Atm1Z
      Bx=ACInfo%Atm2X
      By=ACInfo%Atm2Y
      Bz=ACInfo%Atm2Z
      Cx=BDInfo%Atm1X
      Cy=BDInfo%Atm1Y
      Cz=BDInfo%Atm1Z
      Dx=BDInfo%Atm2X
      Dy=BDInfo%Atm2Y
      Dz=BDInfo%Atm2Z
      ABx=Ax-Bx
      ABy=Ay-By
      ABz=Az-Bz
      CDx=Cx-Dx
      CDy=Cy-Dy
      CDz=Cz-Dz
      DO J=1,LKet ! K^2 VRR |N0) loop
         Eta=PrmBufK(1,J)
         Qx=PrmBufK(2,J)
         Qy=PrmBufK(3,J)
         Qz=PrmBufK(4,J)
         Uq=PrmBufK(5,J)
         QCx=Qx-Cx
         QCy=Qy-Cy
         QCz=Qz-Cz
         DO K=1,LBra ! K^2 VRR (M0| loop
            Zeta=PrmBufB(1,K)
            Px=PrmBufB(2,K)
            Py=PrmBufB(3,K)
            Pz=PrmBufB(4,K)
            Up=PrmBufB(5,K)
            FnSpB=PrmBufB(6,K)
            r1xZpE=One/(Zeta+Eta)
            Upq=SQRT(r1xZpE)*Up*Uq
            HfxZpE=Half/(Zeta+Eta)
            r1x2E=Half/Eta
            r1x2Z=Half/Zeta
            ExZpE=Eta*r1xZpE
            ZxZpE=Zeta*r1xZpE
            Omega=Eta*Zeta*r1xZpE
            PAx=Px-Ax
            PAy=Py-Ay
            PAz=Pz-Az
            PQx=Px-Qx
            PQy=Py-Qy
            PQz=Pz-Qz
            ! Begin Minimum Image Convention
            FPQx = PQx*PBC%InvBoxSh%D(1,1)+PQy*PBC%InvBoxSh%D(1,2)+PQz*PBC%InvBoxSh%D(1,3)
            FPQy = PQy*PBC%InvBoxSh%D(2,2)+PQz*PBC%InvBoxSh%D(2,3)
            FPQz = PQz*PBC%InvBoxSh%D(3,3)
            IF(PBC%AutoW%I(1)==1)FPQx=FPQx-ANINT(FPQx-SIGN(1D-15,FPQx))
            IF(PBC%AutoW%I(2)==1)FPQy=FPQy-ANINT(FPQy-SIGN(1D-15,FPQy))
            IF(PBC%AutoW%I(3)==1)FPQz=FPQz-ANINT(FPQz-SIGN(1D-15,FPQz))
            PQx=FPQx*PBC%BoxShape%D(1,1)+FPQy*PBC%BoxShape%D(1,2)+FPQz*PBC%BoxShape%D(1,3)
            PQy=FPQy*PBC%BoxShape%D(2,2)+FPQz*PBC%BoxShape%D(2,3)
            PQz=FPQz*PBC%BoxShape%D(3,3)
            ! End MIC
            WPx = -Eta*PQx*r1xZpE
            WPy = -Eta*PQy*r1xZpE
            WPz = -Eta*PQz*r1xZpE
            WQx = Zeta*PQx*r1xZpE
            WQy = Zeta*PQy*r1xZpE
            WQz = Zeta*PQz*r1xZpE
            T=Omega*(PQx*PQx+PQy*PQy+PQz*PQz)
            IF(T<Gamma_Switch)THEN
              L=AINT(T*Gamma_Grid)
              ET=EXP(-T)
              TwoT=Two*T
              W8=(F8_0(L)+T*(F8_1(L)+T*(F8_2(L)+T*(F8_3(L)+T*F8_4(L)))))
              W7=+6.666666666666666D-02*(TwoT*W8+ET)
              W6=+7.692307692307693D-02*(TwoT*W7+ET)
              W5=+9.090909090909090D-02*(TwoT*W6+ET)
              W4=+1.111111111111111D-01*(TwoT*W5+ET)
              W3=+1.428571428571428D-01*(TwoT*W4+ET)
              W2=+2.000000000000000D-01*(TwoT*W3+ET)
              W1=+3.333333333333333D-01*(TwoT*W2+ET)
              W0=TwoT*W1+ET
              VRR(1,1,0)=Upq*W0
              VRR(1,1,1)=Upq*W1
              VRR(1,1,2)=Upq*W2
              VRR(1,1,3)=Upq*W3
              VRR(1,1,4)=Upq*W4
              VRR(1,1,5)=Upq*W5
              VRR(1,1,6)=Upq*W6
              VRR(1,1,7)=Upq*W7
              VRR(1,1,8)=Upq*W8
            ELSE
              InvT=One/T
              SqInvT=DSQRT(InvT)
              VRR(1,1,0)=+8.862269254527580D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,1)=+4.431134627263790D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,2)=+6.646701940895685D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,3)=+1.661675485223921D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,4)=+5.815864198283724D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,5)=+2.617138889227676D+01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,6)=+1.439426389075222D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,7)=+9.356271528988940D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,8)=+7.017203646741708D+03*Upq*SqInvT
            ENDIF
            ! Generating (p0|s0)^(7)
            VRR(2,1,7)=PAx*VRR(1,1,7)+WPx*VRR(1,1,8)
            VRR(3,1,7)=PAy*VRR(1,1,7)+WPy*VRR(1,1,8)
            VRR(4,1,7)=PAz*VRR(1,1,7)+WPz*VRR(1,1,8)
            ! Generating (p0|s0)^(6)
            VRR(2,1,6)=PAx*VRR(1,1,6)+WPx*VRR(1,1,7)
            VRR(3,1,6)=PAy*VRR(1,1,6)+WPy*VRR(1,1,7)
            VRR(4,1,6)=PAz*VRR(1,1,6)+WPz*VRR(1,1,7)
            ! Generating (p0|s0)^(5)
            VRR(2,1,5)=PAx*VRR(1,1,5)+WPx*VRR(1,1,6)
            VRR(3,1,5)=PAy*VRR(1,1,5)+WPy*VRR(1,1,6)
            VRR(4,1,5)=PAz*VRR(1,1,5)+WPz*VRR(1,1,6)
            ! Generating (p0|s0)^(4)
            VRR(2,1,4)=PAx*VRR(1,1,4)+WPx*VRR(1,1,5)
            VRR(3,1,4)=PAy*VRR(1,1,4)+WPy*VRR(1,1,5)
            VRR(4,1,4)=PAz*VRR(1,1,4)+WPz*VRR(1,1,5)
            ! Generating (p0|s0)^(3)
            VRR(2,1,3)=PAx*VRR(1,1,3)+WPx*VRR(1,1,4)
            VRR(3,1,3)=PAy*VRR(1,1,3)+WPy*VRR(1,1,4)
            VRR(4,1,3)=PAz*VRR(1,1,3)+WPz*VRR(1,1,4)
            ! Generating (p0|s0)^(2)
            VRR(2,1,2)=PAx*VRR(1,1,2)+WPx*VRR(1,1,3)
            VRR(3,1,2)=PAy*VRR(1,1,2)+WPy*VRR(1,1,3)
            VRR(4,1,2)=PAz*VRR(1,1,2)+WPz*VRR(1,1,3)
            ! Generating (p0|s0)^(1)
            VRR(2,1,1)=PAx*VRR(1,1,1)+WPx*VRR(1,1,2)
            VRR(3,1,1)=PAy*VRR(1,1,1)+WPy*VRR(1,1,2)
            VRR(4,1,1)=PAz*VRR(1,1,1)+WPz*VRR(1,1,2)
            ! Generating (p0|s0)^(0)
            VRR(2,1,0)=PAx*VRR(1,1,0)+WPx*VRR(1,1,1)
            VRR(3,1,0)=PAy*VRR(1,1,0)+WPy*VRR(1,1,1)
            VRR(4,1,0)=PAz*VRR(1,1,0)+WPz*VRR(1,1,1)
            ! Generating (d0|s0)^(6)
            VRR(5,1,6)=PAx*VRR(2,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPx*VRR(2,1,7)
            VRR(6,1,6)=PAx*VRR(3,1,6)+WPx*VRR(3,1,7)
            VRR(7,1,6)=PAy*VRR(3,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPy*VRR(3,1,7)
            VRR(8,1,6)=PAx*VRR(4,1,6)+WPx*VRR(4,1,7)
            VRR(9,1,6)=PAy*VRR(4,1,6)+WPy*VRR(4,1,7)
            VRR(10,1,6)=PAz*VRR(4,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPz*VRR(4,1,7)
            ! Generating (d0|s0)^(5)
            VRR(5,1,5)=PAx*VRR(2,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPx*VRR(2,1,6)
            VRR(6,1,5)=PAx*VRR(3,1,5)+WPx*VRR(3,1,6)
            VRR(7,1,5)=PAy*VRR(3,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPy*VRR(3,1,6)
            VRR(8,1,5)=PAx*VRR(4,1,5)+WPx*VRR(4,1,6)
            VRR(9,1,5)=PAy*VRR(4,1,5)+WPy*VRR(4,1,6)
            VRR(10,1,5)=PAz*VRR(4,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPz*VRR(4,1,6)
            ! Generating (d0|s0)^(4)
            VRR(5,1,4)=PAx*VRR(2,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPx*VRR(2,1,5)
            VRR(6,1,4)=PAx*VRR(3,1,4)+WPx*VRR(3,1,5)
            VRR(7,1,4)=PAy*VRR(3,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPy*VRR(3,1,5)
            VRR(8,1,4)=PAx*VRR(4,1,4)+WPx*VRR(4,1,5)
            VRR(9,1,4)=PAy*VRR(4,1,4)+WPy*VRR(4,1,5)
            VRR(10,1,4)=PAz*VRR(4,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPz*VRR(4,1,5)
            ! Generating (d0|s0)^(3)
            VRR(5,1,3)=PAx*VRR(2,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPx*VRR(2,1,4)
            VRR(6,1,3)=PAx*VRR(3,1,3)+WPx*VRR(3,1,4)
            VRR(7,1,3)=PAy*VRR(3,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPy*VRR(3,1,4)
            VRR(8,1,3)=PAx*VRR(4,1,3)+WPx*VRR(4,1,4)
            VRR(9,1,3)=PAy*VRR(4,1,3)+WPy*VRR(4,1,4)
            VRR(10,1,3)=PAz*VRR(4,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPz*VRR(4,1,4)
            ! Generating (d0|s0)^(2)
            VRR(5,1,2)=PAx*VRR(2,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPx*VRR(2,1,3)
            VRR(6,1,2)=PAx*VRR(3,1,2)+WPx*VRR(3,1,3)
            VRR(7,1,2)=PAy*VRR(3,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPy*VRR(3,1,3)
            VRR(8,1,2)=PAx*VRR(4,1,2)+WPx*VRR(4,1,3)
            VRR(9,1,2)=PAy*VRR(4,1,2)+WPy*VRR(4,1,3)
            VRR(10,1,2)=PAz*VRR(4,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPz*VRR(4,1,3)
            ! Generating (d0|s0)^(1)
            VRR(5,1,1)=PAx*VRR(2,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPx*VRR(2,1,2)
            VRR(6,1,1)=PAx*VRR(3,1,1)+WPx*VRR(3,1,2)
            VRR(7,1,1)=PAy*VRR(3,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPy*VRR(3,1,2)
            VRR(8,1,1)=PAx*VRR(4,1,1)+WPx*VRR(4,1,2)
            VRR(9,1,1)=PAy*VRR(4,1,1)+WPy*VRR(4,1,2)
            VRR(10,1,1)=PAz*VRR(4,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPz*VRR(4,1,2)
            ! Generating (d0|s0)^(0)
            VRR(5,1,0)=PAx*VRR(2,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPx*VRR(2,1,1)
            VRR(6,1,0)=PAx*VRR(3,1,0)+WPx*VRR(3,1,1)
            VRR(7,1,0)=PAy*VRR(3,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPy*VRR(3,1,1)
            VRR(8,1,0)=PAx*VRR(4,1,0)+WPx*VRR(4,1,1)
            VRR(9,1,0)=PAy*VRR(4,1,0)+WPy*VRR(4,1,1)
            VRR(10,1,0)=PAz*VRR(4,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPz*VRR(4,1,1)
            ! Generating (f0|s0)^(5)
            CALL VRRf0s0(35,35,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|s0)^(4)
            CALL VRRf0s0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|s0)^(3)
            CALL VRRf0s0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|s0)^(2)
            CALL VRRf0s0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|s0)^(1)
            CALL VRRf0s0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|s0)^(0)
            CALL VRRf0s0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|s0)^(4)
            CALL VRRg0s0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|s0)^(3)
            CALL VRRg0s0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|s0)^(2)
            CALL VRRg0s0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|s0)^(1)
            CALL VRRg0s0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|s0)^(0)
            CALL VRRg0s0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|p0)^(7)
            VRR(1,2,7)=QCx*VRR(1,1,7)+WQx*VRR(1,1,8)
            VRR(1,3,7)=QCy*VRR(1,1,7)+WQy*VRR(1,1,8)
            VRR(1,4,7)=QCz*VRR(1,1,7)+WQz*VRR(1,1,8)
            ! Generating (s0|p0)^(6)
            VRR(1,2,6)=QCx*VRR(1,1,6)+WQx*VRR(1,1,7)
            VRR(1,3,6)=QCy*VRR(1,1,6)+WQy*VRR(1,1,7)
            VRR(1,4,6)=QCz*VRR(1,1,6)+WQz*VRR(1,1,7)
            ! Generating (s0|p0)^(5)
            VRR(1,2,5)=QCx*VRR(1,1,5)+WQx*VRR(1,1,6)
            VRR(1,3,5)=QCy*VRR(1,1,5)+WQy*VRR(1,1,6)
            VRR(1,4,5)=QCz*VRR(1,1,5)+WQz*VRR(1,1,6)
            ! Generating (s0|p0)^(4)
            VRR(1,2,4)=QCx*VRR(1,1,4)+WQx*VRR(1,1,5)
            VRR(1,3,4)=QCy*VRR(1,1,4)+WQy*VRR(1,1,5)
            VRR(1,4,4)=QCz*VRR(1,1,4)+WQz*VRR(1,1,5)
            ! Generating (s0|p0)^(3)
            VRR(1,2,3)=QCx*VRR(1,1,3)+WQx*VRR(1,1,4)
            VRR(1,3,3)=QCy*VRR(1,1,3)+WQy*VRR(1,1,4)
            VRR(1,4,3)=QCz*VRR(1,1,3)+WQz*VRR(1,1,4)
            ! Generating (s0|p0)^(2)
            VRR(1,2,2)=QCx*VRR(1,1,2)+WQx*VRR(1,1,3)
            VRR(1,3,2)=QCy*VRR(1,1,2)+WQy*VRR(1,1,3)
            VRR(1,4,2)=QCz*VRR(1,1,2)+WQz*VRR(1,1,3)
            ! Generating (s0|p0)^(1)
            VRR(1,2,1)=QCx*VRR(1,1,1)+WQx*VRR(1,1,2)
            VRR(1,3,1)=QCy*VRR(1,1,1)+WQy*VRR(1,1,2)
            VRR(1,4,1)=QCz*VRR(1,1,1)+WQz*VRR(1,1,2)
            ! Generating (s0|p0)^(0)
            VRR(1,2,0)=QCx*VRR(1,1,0)+WQx*VRR(1,1,1)
            VRR(1,3,0)=QCy*VRR(1,1,0)+WQy*VRR(1,1,1)
            VRR(1,4,0)=QCz*VRR(1,1,0)+WQz*VRR(1,1,1)
            ! Generating (p0|p0)^(6)
            VRR(2,2,6)=QCx*VRR(2,1,6)+HfxZpE*VRR(1,1,7)+WQx*VRR(2,1,7)
            VRR(2,3,6)=QCy*VRR(2,1,6)+WQy*VRR(2,1,7)
            VRR(2,4,6)=QCz*VRR(2,1,6)+WQz*VRR(2,1,7)
            VRR(3,2,6)=QCx*VRR(3,1,6)+WQx*VRR(3,1,7)
            VRR(3,3,6)=QCy*VRR(3,1,6)+HfxZpE*VRR(1,1,7)+WQy*VRR(3,1,7)
            VRR(3,4,6)=QCz*VRR(3,1,6)+WQz*VRR(3,1,7)
            VRR(4,2,6)=QCx*VRR(4,1,6)+WQx*VRR(4,1,7)
            VRR(4,3,6)=QCy*VRR(4,1,6)+WQy*VRR(4,1,7)
            VRR(4,4,6)=QCz*VRR(4,1,6)+HfxZpE*VRR(1,1,7)+WQz*VRR(4,1,7)
            ! Generating (p0|p0)^(5)
            VRR(2,2,5)=QCx*VRR(2,1,5)+HfxZpE*VRR(1,1,6)+WQx*VRR(2,1,6)
            VRR(2,3,5)=QCy*VRR(2,1,5)+WQy*VRR(2,1,6)
            VRR(2,4,5)=QCz*VRR(2,1,5)+WQz*VRR(2,1,6)
            VRR(3,2,5)=QCx*VRR(3,1,5)+WQx*VRR(3,1,6)
            VRR(3,3,5)=QCy*VRR(3,1,5)+HfxZpE*VRR(1,1,6)+WQy*VRR(3,1,6)
            VRR(3,4,5)=QCz*VRR(3,1,5)+WQz*VRR(3,1,6)
            VRR(4,2,5)=QCx*VRR(4,1,5)+WQx*VRR(4,1,6)
            VRR(4,3,5)=QCy*VRR(4,1,5)+WQy*VRR(4,1,6)
            VRR(4,4,5)=QCz*VRR(4,1,5)+HfxZpE*VRR(1,1,6)+WQz*VRR(4,1,6)
            ! Generating (p0|p0)^(4)
            VRR(2,2,4)=QCx*VRR(2,1,4)+HfxZpE*VRR(1,1,5)+WQx*VRR(2,1,5)
            VRR(2,3,4)=QCy*VRR(2,1,4)+WQy*VRR(2,1,5)
            VRR(2,4,4)=QCz*VRR(2,1,4)+WQz*VRR(2,1,5)
            VRR(3,2,4)=QCx*VRR(3,1,4)+WQx*VRR(3,1,5)
            VRR(3,3,4)=QCy*VRR(3,1,4)+HfxZpE*VRR(1,1,5)+WQy*VRR(3,1,5)
            VRR(3,4,4)=QCz*VRR(3,1,4)+WQz*VRR(3,1,5)
            VRR(4,2,4)=QCx*VRR(4,1,4)+WQx*VRR(4,1,5)
            VRR(4,3,4)=QCy*VRR(4,1,4)+WQy*VRR(4,1,5)
            VRR(4,4,4)=QCz*VRR(4,1,4)+HfxZpE*VRR(1,1,5)+WQz*VRR(4,1,5)
            ! Generating (p0|p0)^(3)
            VRR(2,2,3)=QCx*VRR(2,1,3)+HfxZpE*VRR(1,1,4)+WQx*VRR(2,1,4)
            VRR(2,3,3)=QCy*VRR(2,1,3)+WQy*VRR(2,1,4)
            VRR(2,4,3)=QCz*VRR(2,1,3)+WQz*VRR(2,1,4)
            VRR(3,2,3)=QCx*VRR(3,1,3)+WQx*VRR(3,1,4)
            VRR(3,3,3)=QCy*VRR(3,1,3)+HfxZpE*VRR(1,1,4)+WQy*VRR(3,1,4)
            VRR(3,4,3)=QCz*VRR(3,1,3)+WQz*VRR(3,1,4)
            VRR(4,2,3)=QCx*VRR(4,1,3)+WQx*VRR(4,1,4)
            VRR(4,3,3)=QCy*VRR(4,1,3)+WQy*VRR(4,1,4)
            VRR(4,4,3)=QCz*VRR(4,1,3)+HfxZpE*VRR(1,1,4)+WQz*VRR(4,1,4)
            ! Generating (p0|p0)^(2)
            VRR(2,2,2)=QCx*VRR(2,1,2)+HfxZpE*VRR(1,1,3)+WQx*VRR(2,1,3)
            VRR(2,3,2)=QCy*VRR(2,1,2)+WQy*VRR(2,1,3)
            VRR(2,4,2)=QCz*VRR(2,1,2)+WQz*VRR(2,1,3)
            VRR(3,2,2)=QCx*VRR(3,1,2)+WQx*VRR(3,1,3)
            VRR(3,3,2)=QCy*VRR(3,1,2)+HfxZpE*VRR(1,1,3)+WQy*VRR(3,1,3)
            VRR(3,4,2)=QCz*VRR(3,1,2)+WQz*VRR(3,1,3)
            VRR(4,2,2)=QCx*VRR(4,1,2)+WQx*VRR(4,1,3)
            VRR(4,3,2)=QCy*VRR(4,1,2)+WQy*VRR(4,1,3)
            VRR(4,4,2)=QCz*VRR(4,1,2)+HfxZpE*VRR(1,1,3)+WQz*VRR(4,1,3)
            ! Generating (p0|p0)^(1)
            VRR(2,2,1)=QCx*VRR(2,1,1)+HfxZpE*VRR(1,1,2)+WQx*VRR(2,1,2)
            VRR(2,3,1)=QCy*VRR(2,1,1)+WQy*VRR(2,1,2)
            VRR(2,4,1)=QCz*VRR(2,1,1)+WQz*VRR(2,1,2)
            VRR(3,2,1)=QCx*VRR(3,1,1)+WQx*VRR(3,1,2)
            VRR(3,3,1)=QCy*VRR(3,1,1)+HfxZpE*VRR(1,1,2)+WQy*VRR(3,1,2)
            VRR(3,4,1)=QCz*VRR(3,1,1)+WQz*VRR(3,1,2)
            VRR(4,2,1)=QCx*VRR(4,1,1)+WQx*VRR(4,1,2)
            VRR(4,3,1)=QCy*VRR(4,1,1)+WQy*VRR(4,1,2)
            VRR(4,4,1)=QCz*VRR(4,1,1)+HfxZpE*VRR(1,1,2)+WQz*VRR(4,1,2)
            ! Generating (p0|p0)^(0)
            VRR(2,2,0)=QCx*VRR(2,1,0)+HfxZpE*VRR(1,1,1)+WQx*VRR(2,1,1)
            VRR(2,3,0)=QCy*VRR(2,1,0)+WQy*VRR(2,1,1)
            VRR(2,4,0)=QCz*VRR(2,1,0)+WQz*VRR(2,1,1)
            VRR(3,2,0)=QCx*VRR(3,1,0)+WQx*VRR(3,1,1)
            VRR(3,3,0)=QCy*VRR(3,1,0)+HfxZpE*VRR(1,1,1)+WQy*VRR(3,1,1)
            VRR(3,4,0)=QCz*VRR(3,1,0)+WQz*VRR(3,1,1)
            VRR(4,2,0)=QCx*VRR(4,1,0)+WQx*VRR(4,1,1)
            VRR(4,3,0)=QCy*VRR(4,1,0)+WQy*VRR(4,1,1)
            VRR(4,4,0)=QCz*VRR(4,1,0)+HfxZpE*VRR(1,1,1)+WQz*VRR(4,1,1)
            ! Generating (d0|p0)^(5)
            CALL VRRd0p0(35,35,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|p0)^(4)
            CALL VRRd0p0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|p0)^(3)
            CALL VRRd0p0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|p0)^(2)
            CALL VRRd0p0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|p0)^(1)
            CALL VRRd0p0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|p0)^(0)
            CALL VRRd0p0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|p0)^(4)
            CALL VRRf0p0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|p0)^(3)
            CALL VRRf0p0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|p0)^(2)
            CALL VRRf0p0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|p0)^(1)
            CALL VRRf0p0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|p0)^(0)
            CALL VRRf0p0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|p0)^(3)
            CALL VRRg0p0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|p0)^(2)
            CALL VRRg0p0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|p0)^(1)
            CALL VRRg0p0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|p0)^(0)
            CALL VRRg0p0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|d0)^(6)
            CALL VRRs0d0(35,35,VRR(1,1,6),VRR(1,1,7))
            ! Generating (s0|d0)^(5)
            CALL VRRs0d0(35,35,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|d0)^(4)
            CALL VRRs0d0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|d0)^(3)
            CALL VRRs0d0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|d0)^(2)
            CALL VRRs0d0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|d0)^(1)
            CALL VRRs0d0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|d0)^(0)
            CALL VRRs0d0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|d0)^(5)
            CALL VRRp0d0(35,35,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|d0)^(4)
            CALL VRRp0d0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|d0)^(3)
            CALL VRRp0d0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|d0)^(2)
            CALL VRRp0d0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|d0)^(1)
            CALL VRRp0d0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|d0)^(0)
            CALL VRRp0d0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|d0)^(4)
            CALL VRRd0d0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|d0)^(3)
            CALL VRRd0d0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|d0)^(2)
            CALL VRRd0d0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|d0)^(1)
            CALL VRRd0d0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|d0)^(0)
            CALL VRRd0d0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|d0)^(3)
            CALL VRRf0d0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|d0)^(2)
            CALL VRRf0d0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|d0)^(1)
            CALL VRRf0d0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|d0)^(0)
            CALL VRRf0d0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|d0)^(2)
            CALL VRRg0d0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|d0)^(1)
            CALL VRRg0d0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|d0)^(0)
            CALL VRRg0d0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|f0)^(5)
            CALL VRRs0f0(35,35,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|f0)^(4)
            CALL VRRs0f0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|f0)^(3)
            CALL VRRs0f0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|f0)^(2)
            CALL VRRs0f0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|f0)^(1)
            CALL VRRs0f0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|f0)^(0)
            CALL VRRs0f0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|f0)^(4)
            CALL VRRp0f0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|f0)^(3)
            CALL VRRp0f0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|f0)^(2)
            CALL VRRp0f0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|f0)^(1)
            CALL VRRp0f0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|f0)^(0)
            CALL VRRp0f0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|f0)^(3)
            CALL VRRd0f0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|f0)^(2)
            CALL VRRd0f0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|f0)^(1)
            CALL VRRd0f0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|f0)^(0)
            CALL VRRd0f0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|f0)^(2)
            CALL VRRf0f0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|f0)^(1)
            CALL VRRf0f0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|f0)^(0)
            CALL VRRf0f0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|f0)^(1)
            CALL VRRg0f0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|f0)^(0)
            CALL VRRg0f0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|g0)^(4)
            CALL VRRs0g0(35,35,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|g0)^(3)
            CALL VRRs0g0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|g0)^(2)
            CALL VRRs0g0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|g0)^(1)
            CALL VRRs0g0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|g0)^(0)
            CALL VRRs0g0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|g0)^(3)
            CALL VRRp0g0(35,35,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|g0)^(2)
            CALL VRRp0g0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|g0)^(1)
            CALL VRRp0g0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|g0)^(0)
            CALL VRRp0g0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|g0)^(2)
            CALL VRRd0g0(35,35,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|g0)^(1)
            CALL VRRd0g0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|g0)^(0)
            CALL VRRd0g0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|g0)^(1)
            CALL VRRf0g0(35,35,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|g0)^(0)
            CALL VRRf0g0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|g0)^(0)
            CALL VRRg0g0(35,35,VRR(1,1,0),VRR(1,1,1))
            ! Contracting ...
            CALL CNTRCT10266(VRR,HRR)
         ENDDO ! (M0| loop
      ENDDO ! |N0) loop
      ! Generating (f,0|d,d)^(0)
      CALL KetHRR66(45,HRR)
      ! Generating (f,sp|d,d)^(0)
      DO L=5,10
         DO K=5,10
            CDOffSet=(OC+K-5)*LDC+(OD+L-5)*LDD
            CALL BraHRR102(OA,OB,LDA,LDB,CDOffSet,HRR(1,K,L),INTGRL)
          ENDDO
      ENDDO
    END SUBROUTINE IntB10020606
    SUBROUTINE CNTRCT10266(VRR,HRR)
      USE DerivedTypes
      USE VScratchB
      REAL(DOUBLE)  :: VRR(35,35,0:8)
      REAL(DOUBLE)  :: HRR(45,35,10)
      HRR(1,1,1)=HRR(1,1,1)+VRR(1,1,0)
      HRR(1,2,1)=HRR(1,2,1)+VRR(1,2,0)
      HRR(1,3,1)=HRR(1,3,1)+VRR(1,3,0)
      HRR(1,4,1)=HRR(1,4,1)+VRR(1,4,0)
      HRR(1,5,1)=HRR(1,5,1)+VRR(1,5,0)
      HRR(1,6,1)=HRR(1,6,1)+VRR(1,6,0)
      HRR(1,7,1)=HRR(1,7,1)+VRR(1,7,0)
      HRR(1,8,1)=HRR(1,8,1)+VRR(1,8,0)
      HRR(1,9,1)=HRR(1,9,1)+VRR(1,9,0)
      HRR(1,10,1)=HRR(1,10,1)+VRR(1,10,0)
      HRR(1,11,1)=HRR(1,11,1)+VRR(1,11,0)
      HRR(1,12,1)=HRR(1,12,1)+VRR(1,12,0)
      HRR(1,13,1)=HRR(1,13,1)+VRR(1,13,0)
      HRR(1,14,1)=HRR(1,14,1)+VRR(1,14,0)
      HRR(1,15,1)=HRR(1,15,1)+VRR(1,15,0)
      HRR(1,16,1)=HRR(1,16,1)+VRR(1,16,0)
      HRR(1,17,1)=HRR(1,17,1)+VRR(1,17,0)
      HRR(1,18,1)=HRR(1,18,1)+VRR(1,18,0)
      HRR(1,19,1)=HRR(1,19,1)+VRR(1,19,0)
      HRR(1,20,1)=HRR(1,20,1)+VRR(1,20,0)
      HRR(1,21,1)=HRR(1,21,1)+VRR(1,21,0)
      HRR(1,22,1)=HRR(1,22,1)+VRR(1,22,0)
      HRR(1,23,1)=HRR(1,23,1)+VRR(1,23,0)
      HRR(1,24,1)=HRR(1,24,1)+VRR(1,24,0)
      HRR(1,25,1)=HRR(1,25,1)+VRR(1,25,0)
      HRR(1,26,1)=HRR(1,26,1)+VRR(1,26,0)
      HRR(1,27,1)=HRR(1,27,1)+VRR(1,27,0)
      HRR(1,28,1)=HRR(1,28,1)+VRR(1,28,0)
      HRR(1,29,1)=HRR(1,29,1)+VRR(1,29,0)
      HRR(1,30,1)=HRR(1,30,1)+VRR(1,30,0)
      HRR(1,31,1)=HRR(1,31,1)+VRR(1,31,0)
      HRR(1,32,1)=HRR(1,32,1)+VRR(1,32,0)
      HRR(1,33,1)=HRR(1,33,1)+VRR(1,33,0)
      HRR(1,34,1)=HRR(1,34,1)+VRR(1,34,0)
      HRR(1,35,1)=HRR(1,35,1)+VRR(1,35,0)
      HRR(2,1,1)=HRR(2,1,1)+VRR(2,1,0)
      HRR(2,2,1)=HRR(2,2,1)+VRR(2,2,0)
      HRR(2,3,1)=HRR(2,3,1)+VRR(2,3,0)
      HRR(2,4,1)=HRR(2,4,1)+VRR(2,4,0)
      HRR(2,5,1)=HRR(2,5,1)+VRR(2,5,0)
      HRR(2,6,1)=HRR(2,6,1)+VRR(2,6,0)
      HRR(2,7,1)=HRR(2,7,1)+VRR(2,7,0)
      HRR(2,8,1)=HRR(2,8,1)+VRR(2,8,0)
      HRR(2,9,1)=HRR(2,9,1)+VRR(2,9,0)
      HRR(2,10,1)=HRR(2,10,1)+VRR(2,10,0)
      HRR(2,11,1)=HRR(2,11,1)+VRR(2,11,0)
      HRR(2,12,1)=HRR(2,12,1)+VRR(2,12,0)
      HRR(2,13,1)=HRR(2,13,1)+VRR(2,13,0)
      HRR(2,14,1)=HRR(2,14,1)+VRR(2,14,0)
      HRR(2,15,1)=HRR(2,15,1)+VRR(2,15,0)
      HRR(2,16,1)=HRR(2,16,1)+VRR(2,16,0)
      HRR(2,17,1)=HRR(2,17,1)+VRR(2,17,0)
      HRR(2,18,1)=HRR(2,18,1)+VRR(2,18,0)
      HRR(2,19,1)=HRR(2,19,1)+VRR(2,19,0)
      HRR(2,20,1)=HRR(2,20,1)+VRR(2,20,0)
      HRR(2,21,1)=HRR(2,21,1)+VRR(2,21,0)
      HRR(2,22,1)=HRR(2,22,1)+VRR(2,22,0)
      HRR(2,23,1)=HRR(2,23,1)+VRR(2,23,0)
      HRR(2,24,1)=HRR(2,24,1)+VRR(2,24,0)
      HRR(2,25,1)=HRR(2,25,1)+VRR(2,25,0)
      HRR(2,26,1)=HRR(2,26,1)+VRR(2,26,0)
      HRR(2,27,1)=HRR(2,27,1)+VRR(2,27,0)
      HRR(2,28,1)=HRR(2,28,1)+VRR(2,28,0)
      HRR(2,29,1)=HRR(2,29,1)+VRR(2,29,0)
      HRR(2,30,1)=HRR(2,30,1)+VRR(2,30,0)
      HRR(2,31,1)=HRR(2,31,1)+VRR(2,31,0)
      HRR(2,32,1)=HRR(2,32,1)+VRR(2,32,0)
      HRR(2,33,1)=HRR(2,33,1)+VRR(2,33,0)
      HRR(2,34,1)=HRR(2,34,1)+VRR(2,34,0)
      HRR(2,35,1)=HRR(2,35,1)+VRR(2,35,0)
      HRR(3,1,1)=HRR(3,1,1)+VRR(3,1,0)
      HRR(3,2,1)=HRR(3,2,1)+VRR(3,2,0)
      HRR(3,3,1)=HRR(3,3,1)+VRR(3,3,0)
      HRR(3,4,1)=HRR(3,4,1)+VRR(3,4,0)
      HRR(3,5,1)=HRR(3,5,1)+VRR(3,5,0)
      HRR(3,6,1)=HRR(3,6,1)+VRR(3,6,0)
      HRR(3,7,1)=HRR(3,7,1)+VRR(3,7,0)
      HRR(3,8,1)=HRR(3,8,1)+VRR(3,8,0)
      HRR(3,9,1)=HRR(3,9,1)+VRR(3,9,0)
      HRR(3,10,1)=HRR(3,10,1)+VRR(3,10,0)
      HRR(3,11,1)=HRR(3,11,1)+VRR(3,11,0)
      HRR(3,12,1)=HRR(3,12,1)+VRR(3,12,0)
      HRR(3,13,1)=HRR(3,13,1)+VRR(3,13,0)
      HRR(3,14,1)=HRR(3,14,1)+VRR(3,14,0)
      HRR(3,15,1)=HRR(3,15,1)+VRR(3,15,0)
      HRR(3,16,1)=HRR(3,16,1)+VRR(3,16,0)
      HRR(3,17,1)=HRR(3,17,1)+VRR(3,17,0)
      HRR(3,18,1)=HRR(3,18,1)+VRR(3,18,0)
      HRR(3,19,1)=HRR(3,19,1)+VRR(3,19,0)
      HRR(3,20,1)=HRR(3,20,1)+VRR(3,20,0)
      HRR(3,21,1)=HRR(3,21,1)+VRR(3,21,0)
      HRR(3,22,1)=HRR(3,22,1)+VRR(3,22,0)
      HRR(3,23,1)=HRR(3,23,1)+VRR(3,23,0)
      HRR(3,24,1)=HRR(3,24,1)+VRR(3,24,0)
      HRR(3,25,1)=HRR(3,25,1)+VRR(3,25,0)
      HRR(3,26,1)=HRR(3,26,1)+VRR(3,26,0)
      HRR(3,27,1)=HRR(3,27,1)+VRR(3,27,0)
      HRR(3,28,1)=HRR(3,28,1)+VRR(3,28,0)
      HRR(3,29,1)=HRR(3,29,1)+VRR(3,29,0)
      HRR(3,30,1)=HRR(3,30,1)+VRR(3,30,0)
      HRR(3,31,1)=HRR(3,31,1)+VRR(3,31,0)
      HRR(3,32,1)=HRR(3,32,1)+VRR(3,32,0)
      HRR(3,33,1)=HRR(3,33,1)+VRR(3,33,0)
      HRR(3,34,1)=HRR(3,34,1)+VRR(3,34,0)
      HRR(3,35,1)=HRR(3,35,1)+VRR(3,35,0)
      HRR(4,1,1)=HRR(4,1,1)+VRR(4,1,0)
      HRR(4,2,1)=HRR(4,2,1)+VRR(4,2,0)
      HRR(4,3,1)=HRR(4,3,1)+VRR(4,3,0)
      HRR(4,4,1)=HRR(4,4,1)+VRR(4,4,0)
      HRR(4,5,1)=HRR(4,5,1)+VRR(4,5,0)
      HRR(4,6,1)=HRR(4,6,1)+VRR(4,6,0)
      HRR(4,7,1)=HRR(4,7,1)+VRR(4,7,0)
      HRR(4,8,1)=HRR(4,8,1)+VRR(4,8,0)
      HRR(4,9,1)=HRR(4,9,1)+VRR(4,9,0)
      HRR(4,10,1)=HRR(4,10,1)+VRR(4,10,0)
      HRR(4,11,1)=HRR(4,11,1)+VRR(4,11,0)
      HRR(4,12,1)=HRR(4,12,1)+VRR(4,12,0)
      HRR(4,13,1)=HRR(4,13,1)+VRR(4,13,0)
      HRR(4,14,1)=HRR(4,14,1)+VRR(4,14,0)
      HRR(4,15,1)=HRR(4,15,1)+VRR(4,15,0)
      HRR(4,16,1)=HRR(4,16,1)+VRR(4,16,0)
      HRR(4,17,1)=HRR(4,17,1)+VRR(4,17,0)
      HRR(4,18,1)=HRR(4,18,1)+VRR(4,18,0)
      HRR(4,19,1)=HRR(4,19,1)+VRR(4,19,0)
      HRR(4,20,1)=HRR(4,20,1)+VRR(4,20,0)
      HRR(4,21,1)=HRR(4,21,1)+VRR(4,21,0)
      HRR(4,22,1)=HRR(4,22,1)+VRR(4,22,0)
      HRR(4,23,1)=HRR(4,23,1)+VRR(4,23,0)
      HRR(4,24,1)=HRR(4,24,1)+VRR(4,24,0)
      HRR(4,25,1)=HRR(4,25,1)+VRR(4,25,0)
      HRR(4,26,1)=HRR(4,26,1)+VRR(4,26,0)
      HRR(4,27,1)=HRR(4,27,1)+VRR(4,27,0)
      HRR(4,28,1)=HRR(4,28,1)+VRR(4,28,0)
      HRR(4,29,1)=HRR(4,29,1)+VRR(4,29,0)
      HRR(4,30,1)=HRR(4,30,1)+VRR(4,30,0)
      HRR(4,31,1)=HRR(4,31,1)+VRR(4,31,0)
      HRR(4,32,1)=HRR(4,32,1)+VRR(4,32,0)
      HRR(4,33,1)=HRR(4,33,1)+VRR(4,33,0)
      HRR(4,34,1)=HRR(4,34,1)+VRR(4,34,0)
      HRR(4,35,1)=HRR(4,35,1)+VRR(4,35,0)
      HRR(5,1,1)=HRR(5,1,1)+VRR(5,1,0)
      HRR(5,2,1)=HRR(5,2,1)+VRR(5,2,0)
      HRR(5,3,1)=HRR(5,3,1)+VRR(5,3,0)
      HRR(5,4,1)=HRR(5,4,1)+VRR(5,4,0)
      HRR(5,5,1)=HRR(5,5,1)+VRR(5,5,0)
      HRR(5,6,1)=HRR(5,6,1)+VRR(5,6,0)
      HRR(5,7,1)=HRR(5,7,1)+VRR(5,7,0)
      HRR(5,8,1)=HRR(5,8,1)+VRR(5,8,0)
      HRR(5,9,1)=HRR(5,9,1)+VRR(5,9,0)
      HRR(5,10,1)=HRR(5,10,1)+VRR(5,10,0)
      HRR(5,11,1)=HRR(5,11,1)+VRR(5,11,0)
      HRR(5,12,1)=HRR(5,12,1)+VRR(5,12,0)
      HRR(5,13,1)=HRR(5,13,1)+VRR(5,13,0)
      HRR(5,14,1)=HRR(5,14,1)+VRR(5,14,0)
      HRR(5,15,1)=HRR(5,15,1)+VRR(5,15,0)
      HRR(5,16,1)=HRR(5,16,1)+VRR(5,16,0)
      HRR(5,17,1)=HRR(5,17,1)+VRR(5,17,0)
      HRR(5,18,1)=HRR(5,18,1)+VRR(5,18,0)
      HRR(5,19,1)=HRR(5,19,1)+VRR(5,19,0)
      HRR(5,20,1)=HRR(5,20,1)+VRR(5,20,0)
      HRR(5,21,1)=HRR(5,21,1)+VRR(5,21,0)
      HRR(5,22,1)=HRR(5,22,1)+VRR(5,22,0)
      HRR(5,23,1)=HRR(5,23,1)+VRR(5,23,0)
      HRR(5,24,1)=HRR(5,24,1)+VRR(5,24,0)
      HRR(5,25,1)=HRR(5,25,1)+VRR(5,25,0)
      HRR(5,26,1)=HRR(5,26,1)+VRR(5,26,0)
      HRR(5,27,1)=HRR(5,27,1)+VRR(5,27,0)
      HRR(5,28,1)=HRR(5,28,1)+VRR(5,28,0)
      HRR(5,29,1)=HRR(5,29,1)+VRR(5,29,0)
      HRR(5,30,1)=HRR(5,30,1)+VRR(5,30,0)
      HRR(5,31,1)=HRR(5,31,1)+VRR(5,31,0)
      HRR(5,32,1)=HRR(5,32,1)+VRR(5,32,0)
      HRR(5,33,1)=HRR(5,33,1)+VRR(5,33,0)
      HRR(5,34,1)=HRR(5,34,1)+VRR(5,34,0)
      HRR(5,35,1)=HRR(5,35,1)+VRR(5,35,0)
      HRR(6,1,1)=HRR(6,1,1)+VRR(6,1,0)
      HRR(6,2,1)=HRR(6,2,1)+VRR(6,2,0)
      HRR(6,3,1)=HRR(6,3,1)+VRR(6,3,0)
      HRR(6,4,1)=HRR(6,4,1)+VRR(6,4,0)
      HRR(6,5,1)=HRR(6,5,1)+VRR(6,5,0)
      HRR(6,6,1)=HRR(6,6,1)+VRR(6,6,0)
      HRR(6,7,1)=HRR(6,7,1)+VRR(6,7,0)
      HRR(6,8,1)=HRR(6,8,1)+VRR(6,8,0)
      HRR(6,9,1)=HRR(6,9,1)+VRR(6,9,0)
      HRR(6,10,1)=HRR(6,10,1)+VRR(6,10,0)
      HRR(6,11,1)=HRR(6,11,1)+VRR(6,11,0)
      HRR(6,12,1)=HRR(6,12,1)+VRR(6,12,0)
      HRR(6,13,1)=HRR(6,13,1)+VRR(6,13,0)
      HRR(6,14,1)=HRR(6,14,1)+VRR(6,14,0)
      HRR(6,15,1)=HRR(6,15,1)+VRR(6,15,0)
      HRR(6,16,1)=HRR(6,16,1)+VRR(6,16,0)
      HRR(6,17,1)=HRR(6,17,1)+VRR(6,17,0)
      HRR(6,18,1)=HRR(6,18,1)+VRR(6,18,0)
      HRR(6,19,1)=HRR(6,19,1)+VRR(6,19,0)
      HRR(6,20,1)=HRR(6,20,1)+VRR(6,20,0)
      HRR(6,21,1)=HRR(6,21,1)+VRR(6,21,0)
      HRR(6,22,1)=HRR(6,22,1)+VRR(6,22,0)
      HRR(6,23,1)=HRR(6,23,1)+VRR(6,23,0)
      HRR(6,24,1)=HRR(6,24,1)+VRR(6,24,0)
      HRR(6,25,1)=HRR(6,25,1)+VRR(6,25,0)
      HRR(6,26,1)=HRR(6,26,1)+VRR(6,26,0)
      HRR(6,27,1)=HRR(6,27,1)+VRR(6,27,0)
      HRR(6,28,1)=HRR(6,28,1)+VRR(6,28,0)
      HRR(6,29,1)=HRR(6,29,1)+VRR(6,29,0)
      HRR(6,30,1)=HRR(6,30,1)+VRR(6,30,0)
      HRR(6,31,1)=HRR(6,31,1)+VRR(6,31,0)
      HRR(6,32,1)=HRR(6,32,1)+VRR(6,32,0)
      HRR(6,33,1)=HRR(6,33,1)+VRR(6,33,0)
      HRR(6,34,1)=HRR(6,34,1)+VRR(6,34,0)
      HRR(6,35,1)=HRR(6,35,1)+VRR(6,35,0)
      HRR(7,1,1)=HRR(7,1,1)+VRR(7,1,0)
      HRR(7,2,1)=HRR(7,2,1)+VRR(7,2,0)
      HRR(7,3,1)=HRR(7,3,1)+VRR(7,3,0)
      HRR(7,4,1)=HRR(7,4,1)+VRR(7,4,0)
      HRR(7,5,1)=HRR(7,5,1)+VRR(7,5,0)
      HRR(7,6,1)=HRR(7,6,1)+VRR(7,6,0)
      HRR(7,7,1)=HRR(7,7,1)+VRR(7,7,0)
      HRR(7,8,1)=HRR(7,8,1)+VRR(7,8,0)
      HRR(7,9,1)=HRR(7,9,1)+VRR(7,9,0)
      HRR(7,10,1)=HRR(7,10,1)+VRR(7,10,0)
      HRR(7,11,1)=HRR(7,11,1)+VRR(7,11,0)
      HRR(7,12,1)=HRR(7,12,1)+VRR(7,12,0)
      HRR(7,13,1)=HRR(7,13,1)+VRR(7,13,0)
      HRR(7,14,1)=HRR(7,14,1)+VRR(7,14,0)
      HRR(7,15,1)=HRR(7,15,1)+VRR(7,15,0)
      HRR(7,16,1)=HRR(7,16,1)+VRR(7,16,0)
      HRR(7,17,1)=HRR(7,17,1)+VRR(7,17,0)
      HRR(7,18,1)=HRR(7,18,1)+VRR(7,18,0)
      HRR(7,19,1)=HRR(7,19,1)+VRR(7,19,0)
      HRR(7,20,1)=HRR(7,20,1)+VRR(7,20,0)
      HRR(7,21,1)=HRR(7,21,1)+VRR(7,21,0)
      HRR(7,22,1)=HRR(7,22,1)+VRR(7,22,0)
      HRR(7,23,1)=HRR(7,23,1)+VRR(7,23,0)
      HRR(7,24,1)=HRR(7,24,1)+VRR(7,24,0)
      HRR(7,25,1)=HRR(7,25,1)+VRR(7,25,0)
      HRR(7,26,1)=HRR(7,26,1)+VRR(7,26,0)
      HRR(7,27,1)=HRR(7,27,1)+VRR(7,27,0)
      HRR(7,28,1)=HRR(7,28,1)+VRR(7,28,0)
      HRR(7,29,1)=HRR(7,29,1)+VRR(7,29,0)
      HRR(7,30,1)=HRR(7,30,1)+VRR(7,30,0)
      HRR(7,31,1)=HRR(7,31,1)+VRR(7,31,0)
      HRR(7,32,1)=HRR(7,32,1)+VRR(7,32,0)
      HRR(7,33,1)=HRR(7,33,1)+VRR(7,33,0)
      HRR(7,34,1)=HRR(7,34,1)+VRR(7,34,0)
      HRR(7,35,1)=HRR(7,35,1)+VRR(7,35,0)
      HRR(8,1,1)=HRR(8,1,1)+VRR(8,1,0)
      HRR(8,2,1)=HRR(8,2,1)+VRR(8,2,0)
      HRR(8,3,1)=HRR(8,3,1)+VRR(8,3,0)
      HRR(8,4,1)=HRR(8,4,1)+VRR(8,4,0)
      HRR(8,5,1)=HRR(8,5,1)+VRR(8,5,0)
      HRR(8,6,1)=HRR(8,6,1)+VRR(8,6,0)
      HRR(8,7,1)=HRR(8,7,1)+VRR(8,7,0)
      HRR(8,8,1)=HRR(8,8,1)+VRR(8,8,0)
      HRR(8,9,1)=HRR(8,9,1)+VRR(8,9,0)
      HRR(8,10,1)=HRR(8,10,1)+VRR(8,10,0)
      HRR(8,11,1)=HRR(8,11,1)+VRR(8,11,0)
      HRR(8,12,1)=HRR(8,12,1)+VRR(8,12,0)
      HRR(8,13,1)=HRR(8,13,1)+VRR(8,13,0)
      HRR(8,14,1)=HRR(8,14,1)+VRR(8,14,0)
      HRR(8,15,1)=HRR(8,15,1)+VRR(8,15,0)
      HRR(8,16,1)=HRR(8,16,1)+VRR(8,16,0)
      HRR(8,17,1)=HRR(8,17,1)+VRR(8,17,0)
      HRR(8,18,1)=HRR(8,18,1)+VRR(8,18,0)
      HRR(8,19,1)=HRR(8,19,1)+VRR(8,19,0)
      HRR(8,20,1)=HRR(8,20,1)+VRR(8,20,0)
      HRR(8,21,1)=HRR(8,21,1)+VRR(8,21,0)
      HRR(8,22,1)=HRR(8,22,1)+VRR(8,22,0)
      HRR(8,23,1)=HRR(8,23,1)+VRR(8,23,0)
      HRR(8,24,1)=HRR(8,24,1)+VRR(8,24,0)
      HRR(8,25,1)=HRR(8,25,1)+VRR(8,25,0)
      HRR(8,26,1)=HRR(8,26,1)+VRR(8,26,0)
      HRR(8,27,1)=HRR(8,27,1)+VRR(8,27,0)
      HRR(8,28,1)=HRR(8,28,1)+VRR(8,28,0)
      HRR(8,29,1)=HRR(8,29,1)+VRR(8,29,0)
      HRR(8,30,1)=HRR(8,30,1)+VRR(8,30,0)
      HRR(8,31,1)=HRR(8,31,1)+VRR(8,31,0)
      HRR(8,32,1)=HRR(8,32,1)+VRR(8,32,0)
      HRR(8,33,1)=HRR(8,33,1)+VRR(8,33,0)
      HRR(8,34,1)=HRR(8,34,1)+VRR(8,34,0)
      HRR(8,35,1)=HRR(8,35,1)+VRR(8,35,0)
      HRR(9,1,1)=HRR(9,1,1)+VRR(9,1,0)
      HRR(9,2,1)=HRR(9,2,1)+VRR(9,2,0)
      HRR(9,3,1)=HRR(9,3,1)+VRR(9,3,0)
      HRR(9,4,1)=HRR(9,4,1)+VRR(9,4,0)
      HRR(9,5,1)=HRR(9,5,1)+VRR(9,5,0)
      HRR(9,6,1)=HRR(9,6,1)+VRR(9,6,0)
      HRR(9,7,1)=HRR(9,7,1)+VRR(9,7,0)
      HRR(9,8,1)=HRR(9,8,1)+VRR(9,8,0)
      HRR(9,9,1)=HRR(9,9,1)+VRR(9,9,0)
      HRR(9,10,1)=HRR(9,10,1)+VRR(9,10,0)
      HRR(9,11,1)=HRR(9,11,1)+VRR(9,11,0)
      HRR(9,12,1)=HRR(9,12,1)+VRR(9,12,0)
      HRR(9,13,1)=HRR(9,13,1)+VRR(9,13,0)
      HRR(9,14,1)=HRR(9,14,1)+VRR(9,14,0)
      HRR(9,15,1)=HRR(9,15,1)+VRR(9,15,0)
      HRR(9,16,1)=HRR(9,16,1)+VRR(9,16,0)
      HRR(9,17,1)=HRR(9,17,1)+VRR(9,17,0)
      HRR(9,18,1)=HRR(9,18,1)+VRR(9,18,0)
      HRR(9,19,1)=HRR(9,19,1)+VRR(9,19,0)
      HRR(9,20,1)=HRR(9,20,1)+VRR(9,20,0)
      HRR(9,21,1)=HRR(9,21,1)+VRR(9,21,0)
      HRR(9,22,1)=HRR(9,22,1)+VRR(9,22,0)
      HRR(9,23,1)=HRR(9,23,1)+VRR(9,23,0)
      HRR(9,24,1)=HRR(9,24,1)+VRR(9,24,0)
      HRR(9,25,1)=HRR(9,25,1)+VRR(9,25,0)
      HRR(9,26,1)=HRR(9,26,1)+VRR(9,26,0)
      HRR(9,27,1)=HRR(9,27,1)+VRR(9,27,0)
      HRR(9,28,1)=HRR(9,28,1)+VRR(9,28,0)
      HRR(9,29,1)=HRR(9,29,1)+VRR(9,29,0)
      HRR(9,30,1)=HRR(9,30,1)+VRR(9,30,0)
      HRR(9,31,1)=HRR(9,31,1)+VRR(9,31,0)
      HRR(9,32,1)=HRR(9,32,1)+VRR(9,32,0)
      HRR(9,33,1)=HRR(9,33,1)+VRR(9,33,0)
      HRR(9,34,1)=HRR(9,34,1)+VRR(9,34,0)
      HRR(9,35,1)=HRR(9,35,1)+VRR(9,35,0)
      HRR(10,1,1)=HRR(10,1,1)+VRR(10,1,0)
      HRR(10,2,1)=HRR(10,2,1)+VRR(10,2,0)
      HRR(10,3,1)=HRR(10,3,1)+VRR(10,3,0)
      HRR(10,4,1)=HRR(10,4,1)+VRR(10,4,0)
      HRR(10,5,1)=HRR(10,5,1)+VRR(10,5,0)
      HRR(10,6,1)=HRR(10,6,1)+VRR(10,6,0)
      HRR(10,7,1)=HRR(10,7,1)+VRR(10,7,0)
      HRR(10,8,1)=HRR(10,8,1)+VRR(10,8,0)
      HRR(10,9,1)=HRR(10,9,1)+VRR(10,9,0)
      HRR(10,10,1)=HRR(10,10,1)+VRR(10,10,0)
      HRR(10,11,1)=HRR(10,11,1)+VRR(10,11,0)
      HRR(10,12,1)=HRR(10,12,1)+VRR(10,12,0)
      HRR(10,13,1)=HRR(10,13,1)+VRR(10,13,0)
      HRR(10,14,1)=HRR(10,14,1)+VRR(10,14,0)
      HRR(10,15,1)=HRR(10,15,1)+VRR(10,15,0)
      HRR(10,16,1)=HRR(10,16,1)+VRR(10,16,0)
      HRR(10,17,1)=HRR(10,17,1)+VRR(10,17,0)
      HRR(10,18,1)=HRR(10,18,1)+VRR(10,18,0)
      HRR(10,19,1)=HRR(10,19,1)+VRR(10,19,0)
      HRR(10,20,1)=HRR(10,20,1)+VRR(10,20,0)
      HRR(10,21,1)=HRR(10,21,1)+VRR(10,21,0)
      HRR(10,22,1)=HRR(10,22,1)+VRR(10,22,0)
      HRR(10,23,1)=HRR(10,23,1)+VRR(10,23,0)
      HRR(10,24,1)=HRR(10,24,1)+VRR(10,24,0)
      HRR(10,25,1)=HRR(10,25,1)+VRR(10,25,0)
      HRR(10,26,1)=HRR(10,26,1)+VRR(10,26,0)
      HRR(10,27,1)=HRR(10,27,1)+VRR(10,27,0)
      HRR(10,28,1)=HRR(10,28,1)+VRR(10,28,0)
      HRR(10,29,1)=HRR(10,29,1)+VRR(10,29,0)
      HRR(10,30,1)=HRR(10,30,1)+VRR(10,30,0)
      HRR(10,31,1)=HRR(10,31,1)+VRR(10,31,0)
      HRR(10,32,1)=HRR(10,32,1)+VRR(10,32,0)
      HRR(10,33,1)=HRR(10,33,1)+VRR(10,33,0)
      HRR(10,34,1)=HRR(10,34,1)+VRR(10,34,0)
      HRR(10,35,1)=HRR(10,35,1)+VRR(10,35,0)
      HRR(11,1,1)=HRR(11,1,1)+VRR(11,1,0)
      HRR(36,1,1)=HRR(36,1,1)+FnSpB*VRR(11,1,0)
      HRR(11,2,1)=HRR(11,2,1)+VRR(11,2,0)
      HRR(36,2,1)=HRR(36,2,1)+FnSpB*VRR(11,2,0)
      HRR(11,3,1)=HRR(11,3,1)+VRR(11,3,0)
      HRR(36,3,1)=HRR(36,3,1)+FnSpB*VRR(11,3,0)
      HRR(11,4,1)=HRR(11,4,1)+VRR(11,4,0)
      HRR(36,4,1)=HRR(36,4,1)+FnSpB*VRR(11,4,0)
      HRR(11,5,1)=HRR(11,5,1)+VRR(11,5,0)
      HRR(36,5,1)=HRR(36,5,1)+FnSpB*VRR(11,5,0)
      HRR(11,6,1)=HRR(11,6,1)+VRR(11,6,0)
      HRR(36,6,1)=HRR(36,6,1)+FnSpB*VRR(11,6,0)
      HRR(11,7,1)=HRR(11,7,1)+VRR(11,7,0)
      HRR(36,7,1)=HRR(36,7,1)+FnSpB*VRR(11,7,0)
      HRR(11,8,1)=HRR(11,8,1)+VRR(11,8,0)
      HRR(36,8,1)=HRR(36,8,1)+FnSpB*VRR(11,8,0)
      HRR(11,9,1)=HRR(11,9,1)+VRR(11,9,0)
      HRR(36,9,1)=HRR(36,9,1)+FnSpB*VRR(11,9,0)
      HRR(11,10,1)=HRR(11,10,1)+VRR(11,10,0)
      HRR(36,10,1)=HRR(36,10,1)+FnSpB*VRR(11,10,0)
      HRR(11,11,1)=HRR(11,11,1)+VRR(11,11,0)
      HRR(36,11,1)=HRR(36,11,1)+FnSpB*VRR(11,11,0)
      HRR(11,12,1)=HRR(11,12,1)+VRR(11,12,0)
      HRR(36,12,1)=HRR(36,12,1)+FnSpB*VRR(11,12,0)
      HRR(11,13,1)=HRR(11,13,1)+VRR(11,13,0)
      HRR(36,13,1)=HRR(36,13,1)+FnSpB*VRR(11,13,0)
      HRR(11,14,1)=HRR(11,14,1)+VRR(11,14,0)
      HRR(36,14,1)=HRR(36,14,1)+FnSpB*VRR(11,14,0)
      HRR(11,15,1)=HRR(11,15,1)+VRR(11,15,0)
      HRR(36,15,1)=HRR(36,15,1)+FnSpB*VRR(11,15,0)
      HRR(11,16,1)=HRR(11,16,1)+VRR(11,16,0)
      HRR(36,16,1)=HRR(36,16,1)+FnSpB*VRR(11,16,0)
      HRR(11,17,1)=HRR(11,17,1)+VRR(11,17,0)
      HRR(36,17,1)=HRR(36,17,1)+FnSpB*VRR(11,17,0)
      HRR(11,18,1)=HRR(11,18,1)+VRR(11,18,0)
      HRR(36,18,1)=HRR(36,18,1)+FnSpB*VRR(11,18,0)
      HRR(11,19,1)=HRR(11,19,1)+VRR(11,19,0)
      HRR(36,19,1)=HRR(36,19,1)+FnSpB*VRR(11,19,0)
      HRR(11,20,1)=HRR(11,20,1)+VRR(11,20,0)
      HRR(36,20,1)=HRR(36,20,1)+FnSpB*VRR(11,20,0)
      HRR(11,21,1)=HRR(11,21,1)+VRR(11,21,0)
      HRR(36,21,1)=HRR(36,21,1)+FnSpB*VRR(11,21,0)
      HRR(11,22,1)=HRR(11,22,1)+VRR(11,22,0)
      HRR(36,22,1)=HRR(36,22,1)+FnSpB*VRR(11,22,0)
      HRR(11,23,1)=HRR(11,23,1)+VRR(11,23,0)
      HRR(36,23,1)=HRR(36,23,1)+FnSpB*VRR(11,23,0)
      HRR(11,24,1)=HRR(11,24,1)+VRR(11,24,0)
      HRR(36,24,1)=HRR(36,24,1)+FnSpB*VRR(11,24,0)
      HRR(11,25,1)=HRR(11,25,1)+VRR(11,25,0)
      HRR(36,25,1)=HRR(36,25,1)+FnSpB*VRR(11,25,0)
      HRR(11,26,1)=HRR(11,26,1)+VRR(11,26,0)
      HRR(36,26,1)=HRR(36,26,1)+FnSpB*VRR(11,26,0)
      HRR(11,27,1)=HRR(11,27,1)+VRR(11,27,0)
      HRR(36,27,1)=HRR(36,27,1)+FnSpB*VRR(11,27,0)
      HRR(11,28,1)=HRR(11,28,1)+VRR(11,28,0)
      HRR(36,28,1)=HRR(36,28,1)+FnSpB*VRR(11,28,0)
      HRR(11,29,1)=HRR(11,29,1)+VRR(11,29,0)
      HRR(36,29,1)=HRR(36,29,1)+FnSpB*VRR(11,29,0)
      HRR(11,30,1)=HRR(11,30,1)+VRR(11,30,0)
      HRR(36,30,1)=HRR(36,30,1)+FnSpB*VRR(11,30,0)
      HRR(11,31,1)=HRR(11,31,1)+VRR(11,31,0)
      HRR(36,31,1)=HRR(36,31,1)+FnSpB*VRR(11,31,0)
      HRR(11,32,1)=HRR(11,32,1)+VRR(11,32,0)
      HRR(36,32,1)=HRR(36,32,1)+FnSpB*VRR(11,32,0)
      HRR(11,33,1)=HRR(11,33,1)+VRR(11,33,0)
      HRR(36,33,1)=HRR(36,33,1)+FnSpB*VRR(11,33,0)
      HRR(11,34,1)=HRR(11,34,1)+VRR(11,34,0)
      HRR(36,34,1)=HRR(36,34,1)+FnSpB*VRR(11,34,0)
      HRR(11,35,1)=HRR(11,35,1)+VRR(11,35,0)
      HRR(36,35,1)=HRR(36,35,1)+FnSpB*VRR(11,35,0)
      HRR(12,1,1)=HRR(12,1,1)+VRR(12,1,0)
      HRR(37,1,1)=HRR(37,1,1)+FnSpB*VRR(12,1,0)
      HRR(12,2,1)=HRR(12,2,1)+VRR(12,2,0)
      HRR(37,2,1)=HRR(37,2,1)+FnSpB*VRR(12,2,0)
      HRR(12,3,1)=HRR(12,3,1)+VRR(12,3,0)
      HRR(37,3,1)=HRR(37,3,1)+FnSpB*VRR(12,3,0)
      HRR(12,4,1)=HRR(12,4,1)+VRR(12,4,0)
      HRR(37,4,1)=HRR(37,4,1)+FnSpB*VRR(12,4,0)
      HRR(12,5,1)=HRR(12,5,1)+VRR(12,5,0)
      HRR(37,5,1)=HRR(37,5,1)+FnSpB*VRR(12,5,0)
      HRR(12,6,1)=HRR(12,6,1)+VRR(12,6,0)
      HRR(37,6,1)=HRR(37,6,1)+FnSpB*VRR(12,6,0)
      HRR(12,7,1)=HRR(12,7,1)+VRR(12,7,0)
      HRR(37,7,1)=HRR(37,7,1)+FnSpB*VRR(12,7,0)
      HRR(12,8,1)=HRR(12,8,1)+VRR(12,8,0)
      HRR(37,8,1)=HRR(37,8,1)+FnSpB*VRR(12,8,0)
      HRR(12,9,1)=HRR(12,9,1)+VRR(12,9,0)
      HRR(37,9,1)=HRR(37,9,1)+FnSpB*VRR(12,9,0)
      HRR(12,10,1)=HRR(12,10,1)+VRR(12,10,0)
      HRR(37,10,1)=HRR(37,10,1)+FnSpB*VRR(12,10,0)
      HRR(12,11,1)=HRR(12,11,1)+VRR(12,11,0)
      HRR(37,11,1)=HRR(37,11,1)+FnSpB*VRR(12,11,0)
      HRR(12,12,1)=HRR(12,12,1)+VRR(12,12,0)
      HRR(37,12,1)=HRR(37,12,1)+FnSpB*VRR(12,12,0)
      HRR(12,13,1)=HRR(12,13,1)+VRR(12,13,0)
      HRR(37,13,1)=HRR(37,13,1)+FnSpB*VRR(12,13,0)
      HRR(12,14,1)=HRR(12,14,1)+VRR(12,14,0)
      HRR(37,14,1)=HRR(37,14,1)+FnSpB*VRR(12,14,0)
      HRR(12,15,1)=HRR(12,15,1)+VRR(12,15,0)
      HRR(37,15,1)=HRR(37,15,1)+FnSpB*VRR(12,15,0)
      HRR(12,16,1)=HRR(12,16,1)+VRR(12,16,0)
      HRR(37,16,1)=HRR(37,16,1)+FnSpB*VRR(12,16,0)
      HRR(12,17,1)=HRR(12,17,1)+VRR(12,17,0)
      HRR(37,17,1)=HRR(37,17,1)+FnSpB*VRR(12,17,0)
      HRR(12,18,1)=HRR(12,18,1)+VRR(12,18,0)
      HRR(37,18,1)=HRR(37,18,1)+FnSpB*VRR(12,18,0)
      HRR(12,19,1)=HRR(12,19,1)+VRR(12,19,0)
      HRR(37,19,1)=HRR(37,19,1)+FnSpB*VRR(12,19,0)
      HRR(12,20,1)=HRR(12,20,1)+VRR(12,20,0)
      HRR(37,20,1)=HRR(37,20,1)+FnSpB*VRR(12,20,0)
      HRR(12,21,1)=HRR(12,21,1)+VRR(12,21,0)
      HRR(37,21,1)=HRR(37,21,1)+FnSpB*VRR(12,21,0)
      HRR(12,22,1)=HRR(12,22,1)+VRR(12,22,0)
      HRR(37,22,1)=HRR(37,22,1)+FnSpB*VRR(12,22,0)
      HRR(12,23,1)=HRR(12,23,1)+VRR(12,23,0)
      HRR(37,23,1)=HRR(37,23,1)+FnSpB*VRR(12,23,0)
      HRR(12,24,1)=HRR(12,24,1)+VRR(12,24,0)
      HRR(37,24,1)=HRR(37,24,1)+FnSpB*VRR(12,24,0)
      HRR(12,25,1)=HRR(12,25,1)+VRR(12,25,0)
      HRR(37,25,1)=HRR(37,25,1)+FnSpB*VRR(12,25,0)
      HRR(12,26,1)=HRR(12,26,1)+VRR(12,26,0)
      HRR(37,26,1)=HRR(37,26,1)+FnSpB*VRR(12,26,0)
      HRR(12,27,1)=HRR(12,27,1)+VRR(12,27,0)
      HRR(37,27,1)=HRR(37,27,1)+FnSpB*VRR(12,27,0)
      HRR(12,28,1)=HRR(12,28,1)+VRR(12,28,0)
      HRR(37,28,1)=HRR(37,28,1)+FnSpB*VRR(12,28,0)
      HRR(12,29,1)=HRR(12,29,1)+VRR(12,29,0)
      HRR(37,29,1)=HRR(37,29,1)+FnSpB*VRR(12,29,0)
      HRR(12,30,1)=HRR(12,30,1)+VRR(12,30,0)
      HRR(37,30,1)=HRR(37,30,1)+FnSpB*VRR(12,30,0)
      HRR(12,31,1)=HRR(12,31,1)+VRR(12,31,0)
      HRR(37,31,1)=HRR(37,31,1)+FnSpB*VRR(12,31,0)
      HRR(12,32,1)=HRR(12,32,1)+VRR(12,32,0)
      HRR(37,32,1)=HRR(37,32,1)+FnSpB*VRR(12,32,0)
      HRR(12,33,1)=HRR(12,33,1)+VRR(12,33,0)
      HRR(37,33,1)=HRR(37,33,1)+FnSpB*VRR(12,33,0)
      HRR(12,34,1)=HRR(12,34,1)+VRR(12,34,0)
      HRR(37,34,1)=HRR(37,34,1)+FnSpB*VRR(12,34,0)
      HRR(12,35,1)=HRR(12,35,1)+VRR(12,35,0)
      HRR(37,35,1)=HRR(37,35,1)+FnSpB*VRR(12,35,0)
      HRR(13,1,1)=HRR(13,1,1)+VRR(13,1,0)
      HRR(38,1,1)=HRR(38,1,1)+FnSpB*VRR(13,1,0)
      HRR(13,2,1)=HRR(13,2,1)+VRR(13,2,0)
      HRR(38,2,1)=HRR(38,2,1)+FnSpB*VRR(13,2,0)
      HRR(13,3,1)=HRR(13,3,1)+VRR(13,3,0)
      HRR(38,3,1)=HRR(38,3,1)+FnSpB*VRR(13,3,0)
      HRR(13,4,1)=HRR(13,4,1)+VRR(13,4,0)
      HRR(38,4,1)=HRR(38,4,1)+FnSpB*VRR(13,4,0)
      HRR(13,5,1)=HRR(13,5,1)+VRR(13,5,0)
      HRR(38,5,1)=HRR(38,5,1)+FnSpB*VRR(13,5,0)
      HRR(13,6,1)=HRR(13,6,1)+VRR(13,6,0)
      HRR(38,6,1)=HRR(38,6,1)+FnSpB*VRR(13,6,0)
      HRR(13,7,1)=HRR(13,7,1)+VRR(13,7,0)
      HRR(38,7,1)=HRR(38,7,1)+FnSpB*VRR(13,7,0)
      HRR(13,8,1)=HRR(13,8,1)+VRR(13,8,0)
      HRR(38,8,1)=HRR(38,8,1)+FnSpB*VRR(13,8,0)
      HRR(13,9,1)=HRR(13,9,1)+VRR(13,9,0)
      HRR(38,9,1)=HRR(38,9,1)+FnSpB*VRR(13,9,0)
      HRR(13,10,1)=HRR(13,10,1)+VRR(13,10,0)
      HRR(38,10,1)=HRR(38,10,1)+FnSpB*VRR(13,10,0)
      HRR(13,11,1)=HRR(13,11,1)+VRR(13,11,0)
      HRR(38,11,1)=HRR(38,11,1)+FnSpB*VRR(13,11,0)
      HRR(13,12,1)=HRR(13,12,1)+VRR(13,12,0)
      HRR(38,12,1)=HRR(38,12,1)+FnSpB*VRR(13,12,0)
      HRR(13,13,1)=HRR(13,13,1)+VRR(13,13,0)
      HRR(38,13,1)=HRR(38,13,1)+FnSpB*VRR(13,13,0)
      HRR(13,14,1)=HRR(13,14,1)+VRR(13,14,0)
      HRR(38,14,1)=HRR(38,14,1)+FnSpB*VRR(13,14,0)
      HRR(13,15,1)=HRR(13,15,1)+VRR(13,15,0)
      HRR(38,15,1)=HRR(38,15,1)+FnSpB*VRR(13,15,0)
      HRR(13,16,1)=HRR(13,16,1)+VRR(13,16,0)
      HRR(38,16,1)=HRR(38,16,1)+FnSpB*VRR(13,16,0)
      HRR(13,17,1)=HRR(13,17,1)+VRR(13,17,0)
      HRR(38,17,1)=HRR(38,17,1)+FnSpB*VRR(13,17,0)
      HRR(13,18,1)=HRR(13,18,1)+VRR(13,18,0)
      HRR(38,18,1)=HRR(38,18,1)+FnSpB*VRR(13,18,0)
      HRR(13,19,1)=HRR(13,19,1)+VRR(13,19,0)
      HRR(38,19,1)=HRR(38,19,1)+FnSpB*VRR(13,19,0)
      HRR(13,20,1)=HRR(13,20,1)+VRR(13,20,0)
      HRR(38,20,1)=HRR(38,20,1)+FnSpB*VRR(13,20,0)
      HRR(13,21,1)=HRR(13,21,1)+VRR(13,21,0)
      HRR(38,21,1)=HRR(38,21,1)+FnSpB*VRR(13,21,0)
      HRR(13,22,1)=HRR(13,22,1)+VRR(13,22,0)
      HRR(38,22,1)=HRR(38,22,1)+FnSpB*VRR(13,22,0)
      HRR(13,23,1)=HRR(13,23,1)+VRR(13,23,0)
      HRR(38,23,1)=HRR(38,23,1)+FnSpB*VRR(13,23,0)
      HRR(13,24,1)=HRR(13,24,1)+VRR(13,24,0)
      HRR(38,24,1)=HRR(38,24,1)+FnSpB*VRR(13,24,0)
      HRR(13,25,1)=HRR(13,25,1)+VRR(13,25,0)
      HRR(38,25,1)=HRR(38,25,1)+FnSpB*VRR(13,25,0)
      HRR(13,26,1)=HRR(13,26,1)+VRR(13,26,0)
      HRR(38,26,1)=HRR(38,26,1)+FnSpB*VRR(13,26,0)
      HRR(13,27,1)=HRR(13,27,1)+VRR(13,27,0)
      HRR(38,27,1)=HRR(38,27,1)+FnSpB*VRR(13,27,0)
      HRR(13,28,1)=HRR(13,28,1)+VRR(13,28,0)
      HRR(38,28,1)=HRR(38,28,1)+FnSpB*VRR(13,28,0)
      HRR(13,29,1)=HRR(13,29,1)+VRR(13,29,0)
      HRR(38,29,1)=HRR(38,29,1)+FnSpB*VRR(13,29,0)
      HRR(13,30,1)=HRR(13,30,1)+VRR(13,30,0)
      HRR(38,30,1)=HRR(38,30,1)+FnSpB*VRR(13,30,0)
      HRR(13,31,1)=HRR(13,31,1)+VRR(13,31,0)
      HRR(38,31,1)=HRR(38,31,1)+FnSpB*VRR(13,31,0)
      HRR(13,32,1)=HRR(13,32,1)+VRR(13,32,0)
      HRR(38,32,1)=HRR(38,32,1)+FnSpB*VRR(13,32,0)
      HRR(13,33,1)=HRR(13,33,1)+VRR(13,33,0)
      HRR(38,33,1)=HRR(38,33,1)+FnSpB*VRR(13,33,0)
      HRR(13,34,1)=HRR(13,34,1)+VRR(13,34,0)
      HRR(38,34,1)=HRR(38,34,1)+FnSpB*VRR(13,34,0)
      HRR(13,35,1)=HRR(13,35,1)+VRR(13,35,0)
      HRR(38,35,1)=HRR(38,35,1)+FnSpB*VRR(13,35,0)
      HRR(14,1,1)=HRR(14,1,1)+VRR(14,1,0)
      HRR(39,1,1)=HRR(39,1,1)+FnSpB*VRR(14,1,0)
      HRR(14,2,1)=HRR(14,2,1)+VRR(14,2,0)
      HRR(39,2,1)=HRR(39,2,1)+FnSpB*VRR(14,2,0)
      HRR(14,3,1)=HRR(14,3,1)+VRR(14,3,0)
      HRR(39,3,1)=HRR(39,3,1)+FnSpB*VRR(14,3,0)
      HRR(14,4,1)=HRR(14,4,1)+VRR(14,4,0)
      HRR(39,4,1)=HRR(39,4,1)+FnSpB*VRR(14,4,0)
      HRR(14,5,1)=HRR(14,5,1)+VRR(14,5,0)
      HRR(39,5,1)=HRR(39,5,1)+FnSpB*VRR(14,5,0)
      HRR(14,6,1)=HRR(14,6,1)+VRR(14,6,0)
      HRR(39,6,1)=HRR(39,6,1)+FnSpB*VRR(14,6,0)
      HRR(14,7,1)=HRR(14,7,1)+VRR(14,7,0)
      HRR(39,7,1)=HRR(39,7,1)+FnSpB*VRR(14,7,0)
      HRR(14,8,1)=HRR(14,8,1)+VRR(14,8,0)
      HRR(39,8,1)=HRR(39,8,1)+FnSpB*VRR(14,8,0)
      HRR(14,9,1)=HRR(14,9,1)+VRR(14,9,0)
      HRR(39,9,1)=HRR(39,9,1)+FnSpB*VRR(14,9,0)
      HRR(14,10,1)=HRR(14,10,1)+VRR(14,10,0)
      HRR(39,10,1)=HRR(39,10,1)+FnSpB*VRR(14,10,0)
      HRR(14,11,1)=HRR(14,11,1)+VRR(14,11,0)
      HRR(39,11,1)=HRR(39,11,1)+FnSpB*VRR(14,11,0)
      HRR(14,12,1)=HRR(14,12,1)+VRR(14,12,0)
      HRR(39,12,1)=HRR(39,12,1)+FnSpB*VRR(14,12,0)
      HRR(14,13,1)=HRR(14,13,1)+VRR(14,13,0)
      HRR(39,13,1)=HRR(39,13,1)+FnSpB*VRR(14,13,0)
      HRR(14,14,1)=HRR(14,14,1)+VRR(14,14,0)
      HRR(39,14,1)=HRR(39,14,1)+FnSpB*VRR(14,14,0)
      HRR(14,15,1)=HRR(14,15,1)+VRR(14,15,0)
      HRR(39,15,1)=HRR(39,15,1)+FnSpB*VRR(14,15,0)
      HRR(14,16,1)=HRR(14,16,1)+VRR(14,16,0)
      HRR(39,16,1)=HRR(39,16,1)+FnSpB*VRR(14,16,0)
      HRR(14,17,1)=HRR(14,17,1)+VRR(14,17,0)
      HRR(39,17,1)=HRR(39,17,1)+FnSpB*VRR(14,17,0)
      HRR(14,18,1)=HRR(14,18,1)+VRR(14,18,0)
      HRR(39,18,1)=HRR(39,18,1)+FnSpB*VRR(14,18,0)
      HRR(14,19,1)=HRR(14,19,1)+VRR(14,19,0)
      HRR(39,19,1)=HRR(39,19,1)+FnSpB*VRR(14,19,0)
      HRR(14,20,1)=HRR(14,20,1)+VRR(14,20,0)
      HRR(39,20,1)=HRR(39,20,1)+FnSpB*VRR(14,20,0)
      HRR(14,21,1)=HRR(14,21,1)+VRR(14,21,0)
      HRR(39,21,1)=HRR(39,21,1)+FnSpB*VRR(14,21,0)
      HRR(14,22,1)=HRR(14,22,1)+VRR(14,22,0)
      HRR(39,22,1)=HRR(39,22,1)+FnSpB*VRR(14,22,0)
      HRR(14,23,1)=HRR(14,23,1)+VRR(14,23,0)
      HRR(39,23,1)=HRR(39,23,1)+FnSpB*VRR(14,23,0)
      HRR(14,24,1)=HRR(14,24,1)+VRR(14,24,0)
      HRR(39,24,1)=HRR(39,24,1)+FnSpB*VRR(14,24,0)
      HRR(14,25,1)=HRR(14,25,1)+VRR(14,25,0)
      HRR(39,25,1)=HRR(39,25,1)+FnSpB*VRR(14,25,0)
      HRR(14,26,1)=HRR(14,26,1)+VRR(14,26,0)
      HRR(39,26,1)=HRR(39,26,1)+FnSpB*VRR(14,26,0)
      HRR(14,27,1)=HRR(14,27,1)+VRR(14,27,0)
      HRR(39,27,1)=HRR(39,27,1)+FnSpB*VRR(14,27,0)
      HRR(14,28,1)=HRR(14,28,1)+VRR(14,28,0)
      HRR(39,28,1)=HRR(39,28,1)+FnSpB*VRR(14,28,0)
      HRR(14,29,1)=HRR(14,29,1)+VRR(14,29,0)
      HRR(39,29,1)=HRR(39,29,1)+FnSpB*VRR(14,29,0)
      HRR(14,30,1)=HRR(14,30,1)+VRR(14,30,0)
      HRR(39,30,1)=HRR(39,30,1)+FnSpB*VRR(14,30,0)
      HRR(14,31,1)=HRR(14,31,1)+VRR(14,31,0)
      HRR(39,31,1)=HRR(39,31,1)+FnSpB*VRR(14,31,0)
      HRR(14,32,1)=HRR(14,32,1)+VRR(14,32,0)
      HRR(39,32,1)=HRR(39,32,1)+FnSpB*VRR(14,32,0)
      HRR(14,33,1)=HRR(14,33,1)+VRR(14,33,0)
      HRR(39,33,1)=HRR(39,33,1)+FnSpB*VRR(14,33,0)
      HRR(14,34,1)=HRR(14,34,1)+VRR(14,34,0)
      HRR(39,34,1)=HRR(39,34,1)+FnSpB*VRR(14,34,0)
      HRR(14,35,1)=HRR(14,35,1)+VRR(14,35,0)
      HRR(39,35,1)=HRR(39,35,1)+FnSpB*VRR(14,35,0)
      HRR(15,1,1)=HRR(15,1,1)+VRR(15,1,0)
      HRR(40,1,1)=HRR(40,1,1)+FnSpB*VRR(15,1,0)
      HRR(15,2,1)=HRR(15,2,1)+VRR(15,2,0)
      HRR(40,2,1)=HRR(40,2,1)+FnSpB*VRR(15,2,0)
      HRR(15,3,1)=HRR(15,3,1)+VRR(15,3,0)
      HRR(40,3,1)=HRR(40,3,1)+FnSpB*VRR(15,3,0)
      HRR(15,4,1)=HRR(15,4,1)+VRR(15,4,0)
      HRR(40,4,1)=HRR(40,4,1)+FnSpB*VRR(15,4,0)
      HRR(15,5,1)=HRR(15,5,1)+VRR(15,5,0)
      HRR(40,5,1)=HRR(40,5,1)+FnSpB*VRR(15,5,0)
      HRR(15,6,1)=HRR(15,6,1)+VRR(15,6,0)
      HRR(40,6,1)=HRR(40,6,1)+FnSpB*VRR(15,6,0)
      HRR(15,7,1)=HRR(15,7,1)+VRR(15,7,0)
      HRR(40,7,1)=HRR(40,7,1)+FnSpB*VRR(15,7,0)
      HRR(15,8,1)=HRR(15,8,1)+VRR(15,8,0)
      HRR(40,8,1)=HRR(40,8,1)+FnSpB*VRR(15,8,0)
      HRR(15,9,1)=HRR(15,9,1)+VRR(15,9,0)
      HRR(40,9,1)=HRR(40,9,1)+FnSpB*VRR(15,9,0)
      HRR(15,10,1)=HRR(15,10,1)+VRR(15,10,0)
      HRR(40,10,1)=HRR(40,10,1)+FnSpB*VRR(15,10,0)
      HRR(15,11,1)=HRR(15,11,1)+VRR(15,11,0)
      HRR(40,11,1)=HRR(40,11,1)+FnSpB*VRR(15,11,0)
      HRR(15,12,1)=HRR(15,12,1)+VRR(15,12,0)
      HRR(40,12,1)=HRR(40,12,1)+FnSpB*VRR(15,12,0)
      HRR(15,13,1)=HRR(15,13,1)+VRR(15,13,0)
      HRR(40,13,1)=HRR(40,13,1)+FnSpB*VRR(15,13,0)
      HRR(15,14,1)=HRR(15,14,1)+VRR(15,14,0)
      HRR(40,14,1)=HRR(40,14,1)+FnSpB*VRR(15,14,0)
      HRR(15,15,1)=HRR(15,15,1)+VRR(15,15,0)
      HRR(40,15,1)=HRR(40,15,1)+FnSpB*VRR(15,15,0)
      HRR(15,16,1)=HRR(15,16,1)+VRR(15,16,0)
      HRR(40,16,1)=HRR(40,16,1)+FnSpB*VRR(15,16,0)
      HRR(15,17,1)=HRR(15,17,1)+VRR(15,17,0)
      HRR(40,17,1)=HRR(40,17,1)+FnSpB*VRR(15,17,0)
      HRR(15,18,1)=HRR(15,18,1)+VRR(15,18,0)
      HRR(40,18,1)=HRR(40,18,1)+FnSpB*VRR(15,18,0)
      HRR(15,19,1)=HRR(15,19,1)+VRR(15,19,0)
      HRR(40,19,1)=HRR(40,19,1)+FnSpB*VRR(15,19,0)
      HRR(15,20,1)=HRR(15,20,1)+VRR(15,20,0)
      HRR(40,20,1)=HRR(40,20,1)+FnSpB*VRR(15,20,0)
      HRR(15,21,1)=HRR(15,21,1)+VRR(15,21,0)
      HRR(40,21,1)=HRR(40,21,1)+FnSpB*VRR(15,21,0)
      HRR(15,22,1)=HRR(15,22,1)+VRR(15,22,0)
      HRR(40,22,1)=HRR(40,22,1)+FnSpB*VRR(15,22,0)
      HRR(15,23,1)=HRR(15,23,1)+VRR(15,23,0)
      HRR(40,23,1)=HRR(40,23,1)+FnSpB*VRR(15,23,0)
      HRR(15,24,1)=HRR(15,24,1)+VRR(15,24,0)
      HRR(40,24,1)=HRR(40,24,1)+FnSpB*VRR(15,24,0)
      HRR(15,25,1)=HRR(15,25,1)+VRR(15,25,0)
      HRR(40,25,1)=HRR(40,25,1)+FnSpB*VRR(15,25,0)
      HRR(15,26,1)=HRR(15,26,1)+VRR(15,26,0)
      HRR(40,26,1)=HRR(40,26,1)+FnSpB*VRR(15,26,0)
      HRR(15,27,1)=HRR(15,27,1)+VRR(15,27,0)
      HRR(40,27,1)=HRR(40,27,1)+FnSpB*VRR(15,27,0)
      HRR(15,28,1)=HRR(15,28,1)+VRR(15,28,0)
      HRR(40,28,1)=HRR(40,28,1)+FnSpB*VRR(15,28,0)
      HRR(15,29,1)=HRR(15,29,1)+VRR(15,29,0)
      HRR(40,29,1)=HRR(40,29,1)+FnSpB*VRR(15,29,0)
      HRR(15,30,1)=HRR(15,30,1)+VRR(15,30,0)
      HRR(40,30,1)=HRR(40,30,1)+FnSpB*VRR(15,30,0)
      HRR(15,31,1)=HRR(15,31,1)+VRR(15,31,0)
      HRR(40,31,1)=HRR(40,31,1)+FnSpB*VRR(15,31,0)
      HRR(15,32,1)=HRR(15,32,1)+VRR(15,32,0)
      HRR(40,32,1)=HRR(40,32,1)+FnSpB*VRR(15,32,0)
      HRR(15,33,1)=HRR(15,33,1)+VRR(15,33,0)
      HRR(40,33,1)=HRR(40,33,1)+FnSpB*VRR(15,33,0)
      HRR(15,34,1)=HRR(15,34,1)+VRR(15,34,0)
      HRR(40,34,1)=HRR(40,34,1)+FnSpB*VRR(15,34,0)
      HRR(15,35,1)=HRR(15,35,1)+VRR(15,35,0)
      HRR(40,35,1)=HRR(40,35,1)+FnSpB*VRR(15,35,0)
      HRR(16,1,1)=HRR(16,1,1)+VRR(16,1,0)
      HRR(41,1,1)=HRR(41,1,1)+FnSpB*VRR(16,1,0)
      HRR(16,2,1)=HRR(16,2,1)+VRR(16,2,0)
      HRR(41,2,1)=HRR(41,2,1)+FnSpB*VRR(16,2,0)
      HRR(16,3,1)=HRR(16,3,1)+VRR(16,3,0)
      HRR(41,3,1)=HRR(41,3,1)+FnSpB*VRR(16,3,0)
      HRR(16,4,1)=HRR(16,4,1)+VRR(16,4,0)
      HRR(41,4,1)=HRR(41,4,1)+FnSpB*VRR(16,4,0)
      HRR(16,5,1)=HRR(16,5,1)+VRR(16,5,0)
      HRR(41,5,1)=HRR(41,5,1)+FnSpB*VRR(16,5,0)
      HRR(16,6,1)=HRR(16,6,1)+VRR(16,6,0)
      HRR(41,6,1)=HRR(41,6,1)+FnSpB*VRR(16,6,0)
      HRR(16,7,1)=HRR(16,7,1)+VRR(16,7,0)
      HRR(41,7,1)=HRR(41,7,1)+FnSpB*VRR(16,7,0)
      HRR(16,8,1)=HRR(16,8,1)+VRR(16,8,0)
      HRR(41,8,1)=HRR(41,8,1)+FnSpB*VRR(16,8,0)
      HRR(16,9,1)=HRR(16,9,1)+VRR(16,9,0)
      HRR(41,9,1)=HRR(41,9,1)+FnSpB*VRR(16,9,0)
      HRR(16,10,1)=HRR(16,10,1)+VRR(16,10,0)
      HRR(41,10,1)=HRR(41,10,1)+FnSpB*VRR(16,10,0)
      HRR(16,11,1)=HRR(16,11,1)+VRR(16,11,0)
      HRR(41,11,1)=HRR(41,11,1)+FnSpB*VRR(16,11,0)
      HRR(16,12,1)=HRR(16,12,1)+VRR(16,12,0)
      HRR(41,12,1)=HRR(41,12,1)+FnSpB*VRR(16,12,0)
      HRR(16,13,1)=HRR(16,13,1)+VRR(16,13,0)
      HRR(41,13,1)=HRR(41,13,1)+FnSpB*VRR(16,13,0)
      HRR(16,14,1)=HRR(16,14,1)+VRR(16,14,0)
      HRR(41,14,1)=HRR(41,14,1)+FnSpB*VRR(16,14,0)
      HRR(16,15,1)=HRR(16,15,1)+VRR(16,15,0)
      HRR(41,15,1)=HRR(41,15,1)+FnSpB*VRR(16,15,0)
      HRR(16,16,1)=HRR(16,16,1)+VRR(16,16,0)
      HRR(41,16,1)=HRR(41,16,1)+FnSpB*VRR(16,16,0)
      HRR(16,17,1)=HRR(16,17,1)+VRR(16,17,0)
      HRR(41,17,1)=HRR(41,17,1)+FnSpB*VRR(16,17,0)
      HRR(16,18,1)=HRR(16,18,1)+VRR(16,18,0)
      HRR(41,18,1)=HRR(41,18,1)+FnSpB*VRR(16,18,0)
      HRR(16,19,1)=HRR(16,19,1)+VRR(16,19,0)
      HRR(41,19,1)=HRR(41,19,1)+FnSpB*VRR(16,19,0)
      HRR(16,20,1)=HRR(16,20,1)+VRR(16,20,0)
      HRR(41,20,1)=HRR(41,20,1)+FnSpB*VRR(16,20,0)
      HRR(16,21,1)=HRR(16,21,1)+VRR(16,21,0)
      HRR(41,21,1)=HRR(41,21,1)+FnSpB*VRR(16,21,0)
      HRR(16,22,1)=HRR(16,22,1)+VRR(16,22,0)
      HRR(41,22,1)=HRR(41,22,1)+FnSpB*VRR(16,22,0)
      HRR(16,23,1)=HRR(16,23,1)+VRR(16,23,0)
      HRR(41,23,1)=HRR(41,23,1)+FnSpB*VRR(16,23,0)
      HRR(16,24,1)=HRR(16,24,1)+VRR(16,24,0)
      HRR(41,24,1)=HRR(41,24,1)+FnSpB*VRR(16,24,0)
      HRR(16,25,1)=HRR(16,25,1)+VRR(16,25,0)
      HRR(41,25,1)=HRR(41,25,1)+FnSpB*VRR(16,25,0)
      HRR(16,26,1)=HRR(16,26,1)+VRR(16,26,0)
      HRR(41,26,1)=HRR(41,26,1)+FnSpB*VRR(16,26,0)
      HRR(16,27,1)=HRR(16,27,1)+VRR(16,27,0)
      HRR(41,27,1)=HRR(41,27,1)+FnSpB*VRR(16,27,0)
      HRR(16,28,1)=HRR(16,28,1)+VRR(16,28,0)
      HRR(41,28,1)=HRR(41,28,1)+FnSpB*VRR(16,28,0)
      HRR(16,29,1)=HRR(16,29,1)+VRR(16,29,0)
      HRR(41,29,1)=HRR(41,29,1)+FnSpB*VRR(16,29,0)
      HRR(16,30,1)=HRR(16,30,1)+VRR(16,30,0)
      HRR(41,30,1)=HRR(41,30,1)+FnSpB*VRR(16,30,0)
      HRR(16,31,1)=HRR(16,31,1)+VRR(16,31,0)
      HRR(41,31,1)=HRR(41,31,1)+FnSpB*VRR(16,31,0)
      HRR(16,32,1)=HRR(16,32,1)+VRR(16,32,0)
      HRR(41,32,1)=HRR(41,32,1)+FnSpB*VRR(16,32,0)
      HRR(16,33,1)=HRR(16,33,1)+VRR(16,33,0)
      HRR(41,33,1)=HRR(41,33,1)+FnSpB*VRR(16,33,0)
      HRR(16,34,1)=HRR(16,34,1)+VRR(16,34,0)
      HRR(41,34,1)=HRR(41,34,1)+FnSpB*VRR(16,34,0)
      HRR(16,35,1)=HRR(16,35,1)+VRR(16,35,0)
      HRR(41,35,1)=HRR(41,35,1)+FnSpB*VRR(16,35,0)
      HRR(17,1,1)=HRR(17,1,1)+VRR(17,1,0)
      HRR(42,1,1)=HRR(42,1,1)+FnSpB*VRR(17,1,0)
      HRR(17,2,1)=HRR(17,2,1)+VRR(17,2,0)
      HRR(42,2,1)=HRR(42,2,1)+FnSpB*VRR(17,2,0)
      HRR(17,3,1)=HRR(17,3,1)+VRR(17,3,0)
      HRR(42,3,1)=HRR(42,3,1)+FnSpB*VRR(17,3,0)
      HRR(17,4,1)=HRR(17,4,1)+VRR(17,4,0)
      HRR(42,4,1)=HRR(42,4,1)+FnSpB*VRR(17,4,0)
      HRR(17,5,1)=HRR(17,5,1)+VRR(17,5,0)
      HRR(42,5,1)=HRR(42,5,1)+FnSpB*VRR(17,5,0)
      HRR(17,6,1)=HRR(17,6,1)+VRR(17,6,0)
      HRR(42,6,1)=HRR(42,6,1)+FnSpB*VRR(17,6,0)
      HRR(17,7,1)=HRR(17,7,1)+VRR(17,7,0)
      HRR(42,7,1)=HRR(42,7,1)+FnSpB*VRR(17,7,0)
      HRR(17,8,1)=HRR(17,8,1)+VRR(17,8,0)
      HRR(42,8,1)=HRR(42,8,1)+FnSpB*VRR(17,8,0)
      HRR(17,9,1)=HRR(17,9,1)+VRR(17,9,0)
      HRR(42,9,1)=HRR(42,9,1)+FnSpB*VRR(17,9,0)
      HRR(17,10,1)=HRR(17,10,1)+VRR(17,10,0)
      HRR(42,10,1)=HRR(42,10,1)+FnSpB*VRR(17,10,0)
      HRR(17,11,1)=HRR(17,11,1)+VRR(17,11,0)
      HRR(42,11,1)=HRR(42,11,1)+FnSpB*VRR(17,11,0)
      HRR(17,12,1)=HRR(17,12,1)+VRR(17,12,0)
      HRR(42,12,1)=HRR(42,12,1)+FnSpB*VRR(17,12,0)
      HRR(17,13,1)=HRR(17,13,1)+VRR(17,13,0)
      HRR(42,13,1)=HRR(42,13,1)+FnSpB*VRR(17,13,0)
      HRR(17,14,1)=HRR(17,14,1)+VRR(17,14,0)
      HRR(42,14,1)=HRR(42,14,1)+FnSpB*VRR(17,14,0)
      HRR(17,15,1)=HRR(17,15,1)+VRR(17,15,0)
      HRR(42,15,1)=HRR(42,15,1)+FnSpB*VRR(17,15,0)
      HRR(17,16,1)=HRR(17,16,1)+VRR(17,16,0)
      HRR(42,16,1)=HRR(42,16,1)+FnSpB*VRR(17,16,0)
      HRR(17,17,1)=HRR(17,17,1)+VRR(17,17,0)
      HRR(42,17,1)=HRR(42,17,1)+FnSpB*VRR(17,17,0)
      HRR(17,18,1)=HRR(17,18,1)+VRR(17,18,0)
      HRR(42,18,1)=HRR(42,18,1)+FnSpB*VRR(17,18,0)
      HRR(17,19,1)=HRR(17,19,1)+VRR(17,19,0)
      HRR(42,19,1)=HRR(42,19,1)+FnSpB*VRR(17,19,0)
      HRR(17,20,1)=HRR(17,20,1)+VRR(17,20,0)
      HRR(42,20,1)=HRR(42,20,1)+FnSpB*VRR(17,20,0)
      HRR(17,21,1)=HRR(17,21,1)+VRR(17,21,0)
      HRR(42,21,1)=HRR(42,21,1)+FnSpB*VRR(17,21,0)
      HRR(17,22,1)=HRR(17,22,1)+VRR(17,22,0)
      HRR(42,22,1)=HRR(42,22,1)+FnSpB*VRR(17,22,0)
      HRR(17,23,1)=HRR(17,23,1)+VRR(17,23,0)
      HRR(42,23,1)=HRR(42,23,1)+FnSpB*VRR(17,23,0)
      HRR(17,24,1)=HRR(17,24,1)+VRR(17,24,0)
      HRR(42,24,1)=HRR(42,24,1)+FnSpB*VRR(17,24,0)
      HRR(17,25,1)=HRR(17,25,1)+VRR(17,25,0)
      HRR(42,25,1)=HRR(42,25,1)+FnSpB*VRR(17,25,0)
      HRR(17,26,1)=HRR(17,26,1)+VRR(17,26,0)
      HRR(42,26,1)=HRR(42,26,1)+FnSpB*VRR(17,26,0)
      HRR(17,27,1)=HRR(17,27,1)+VRR(17,27,0)
      HRR(42,27,1)=HRR(42,27,1)+FnSpB*VRR(17,27,0)
      HRR(17,28,1)=HRR(17,28,1)+VRR(17,28,0)
      HRR(42,28,1)=HRR(42,28,1)+FnSpB*VRR(17,28,0)
      HRR(17,29,1)=HRR(17,29,1)+VRR(17,29,0)
      HRR(42,29,1)=HRR(42,29,1)+FnSpB*VRR(17,29,0)
      HRR(17,30,1)=HRR(17,30,1)+VRR(17,30,0)
      HRR(42,30,1)=HRR(42,30,1)+FnSpB*VRR(17,30,0)
      HRR(17,31,1)=HRR(17,31,1)+VRR(17,31,0)
      HRR(42,31,1)=HRR(42,31,1)+FnSpB*VRR(17,31,0)
      HRR(17,32,1)=HRR(17,32,1)+VRR(17,32,0)
      HRR(42,32,1)=HRR(42,32,1)+FnSpB*VRR(17,32,0)
      HRR(17,33,1)=HRR(17,33,1)+VRR(17,33,0)
      HRR(42,33,1)=HRR(42,33,1)+FnSpB*VRR(17,33,0)
      HRR(17,34,1)=HRR(17,34,1)+VRR(17,34,0)
      HRR(42,34,1)=HRR(42,34,1)+FnSpB*VRR(17,34,0)
      HRR(17,35,1)=HRR(17,35,1)+VRR(17,35,0)
      HRR(42,35,1)=HRR(42,35,1)+FnSpB*VRR(17,35,0)
      HRR(18,1,1)=HRR(18,1,1)+VRR(18,1,0)
      HRR(43,1,1)=HRR(43,1,1)+FnSpB*VRR(18,1,0)
      HRR(18,2,1)=HRR(18,2,1)+VRR(18,2,0)
      HRR(43,2,1)=HRR(43,2,1)+FnSpB*VRR(18,2,0)
      HRR(18,3,1)=HRR(18,3,1)+VRR(18,3,0)
      HRR(43,3,1)=HRR(43,3,1)+FnSpB*VRR(18,3,0)
      HRR(18,4,1)=HRR(18,4,1)+VRR(18,4,0)
      HRR(43,4,1)=HRR(43,4,1)+FnSpB*VRR(18,4,0)
      HRR(18,5,1)=HRR(18,5,1)+VRR(18,5,0)
      HRR(43,5,1)=HRR(43,5,1)+FnSpB*VRR(18,5,0)
      HRR(18,6,1)=HRR(18,6,1)+VRR(18,6,0)
      HRR(43,6,1)=HRR(43,6,1)+FnSpB*VRR(18,6,0)
      HRR(18,7,1)=HRR(18,7,1)+VRR(18,7,0)
      HRR(43,7,1)=HRR(43,7,1)+FnSpB*VRR(18,7,0)
      HRR(18,8,1)=HRR(18,8,1)+VRR(18,8,0)
      HRR(43,8,1)=HRR(43,8,1)+FnSpB*VRR(18,8,0)
      HRR(18,9,1)=HRR(18,9,1)+VRR(18,9,0)
      HRR(43,9,1)=HRR(43,9,1)+FnSpB*VRR(18,9,0)
      HRR(18,10,1)=HRR(18,10,1)+VRR(18,10,0)
      HRR(43,10,1)=HRR(43,10,1)+FnSpB*VRR(18,10,0)
      HRR(18,11,1)=HRR(18,11,1)+VRR(18,11,0)
      HRR(43,11,1)=HRR(43,11,1)+FnSpB*VRR(18,11,0)
      HRR(18,12,1)=HRR(18,12,1)+VRR(18,12,0)
      HRR(43,12,1)=HRR(43,12,1)+FnSpB*VRR(18,12,0)
      HRR(18,13,1)=HRR(18,13,1)+VRR(18,13,0)
      HRR(43,13,1)=HRR(43,13,1)+FnSpB*VRR(18,13,0)
      HRR(18,14,1)=HRR(18,14,1)+VRR(18,14,0)
      HRR(43,14,1)=HRR(43,14,1)+FnSpB*VRR(18,14,0)
      HRR(18,15,1)=HRR(18,15,1)+VRR(18,15,0)
      HRR(43,15,1)=HRR(43,15,1)+FnSpB*VRR(18,15,0)
      HRR(18,16,1)=HRR(18,16,1)+VRR(18,16,0)
      HRR(43,16,1)=HRR(43,16,1)+FnSpB*VRR(18,16,0)
      HRR(18,17,1)=HRR(18,17,1)+VRR(18,17,0)
      HRR(43,17,1)=HRR(43,17,1)+FnSpB*VRR(18,17,0)
      HRR(18,18,1)=HRR(18,18,1)+VRR(18,18,0)
      HRR(43,18,1)=HRR(43,18,1)+FnSpB*VRR(18,18,0)
      HRR(18,19,1)=HRR(18,19,1)+VRR(18,19,0)
      HRR(43,19,1)=HRR(43,19,1)+FnSpB*VRR(18,19,0)
      HRR(18,20,1)=HRR(18,20,1)+VRR(18,20,0)
      HRR(43,20,1)=HRR(43,20,1)+FnSpB*VRR(18,20,0)
      HRR(18,21,1)=HRR(18,21,1)+VRR(18,21,0)
      HRR(43,21,1)=HRR(43,21,1)+FnSpB*VRR(18,21,0)
      HRR(18,22,1)=HRR(18,22,1)+VRR(18,22,0)
      HRR(43,22,1)=HRR(43,22,1)+FnSpB*VRR(18,22,0)
      HRR(18,23,1)=HRR(18,23,1)+VRR(18,23,0)
      HRR(43,23,1)=HRR(43,23,1)+FnSpB*VRR(18,23,0)
      HRR(18,24,1)=HRR(18,24,1)+VRR(18,24,0)
      HRR(43,24,1)=HRR(43,24,1)+FnSpB*VRR(18,24,0)
      HRR(18,25,1)=HRR(18,25,1)+VRR(18,25,0)
      HRR(43,25,1)=HRR(43,25,1)+FnSpB*VRR(18,25,0)
      HRR(18,26,1)=HRR(18,26,1)+VRR(18,26,0)
      HRR(43,26,1)=HRR(43,26,1)+FnSpB*VRR(18,26,0)
      HRR(18,27,1)=HRR(18,27,1)+VRR(18,27,0)
      HRR(43,27,1)=HRR(43,27,1)+FnSpB*VRR(18,27,0)
      HRR(18,28,1)=HRR(18,28,1)+VRR(18,28,0)
      HRR(43,28,1)=HRR(43,28,1)+FnSpB*VRR(18,28,0)
      HRR(18,29,1)=HRR(18,29,1)+VRR(18,29,0)
      HRR(43,29,1)=HRR(43,29,1)+FnSpB*VRR(18,29,0)
      HRR(18,30,1)=HRR(18,30,1)+VRR(18,30,0)
      HRR(43,30,1)=HRR(43,30,1)+FnSpB*VRR(18,30,0)
      HRR(18,31,1)=HRR(18,31,1)+VRR(18,31,0)
      HRR(43,31,1)=HRR(43,31,1)+FnSpB*VRR(18,31,0)
      HRR(18,32,1)=HRR(18,32,1)+VRR(18,32,0)
      HRR(43,32,1)=HRR(43,32,1)+FnSpB*VRR(18,32,0)
      HRR(18,33,1)=HRR(18,33,1)+VRR(18,33,0)
      HRR(43,33,1)=HRR(43,33,1)+FnSpB*VRR(18,33,0)
      HRR(18,34,1)=HRR(18,34,1)+VRR(18,34,0)
      HRR(43,34,1)=HRR(43,34,1)+FnSpB*VRR(18,34,0)
      HRR(18,35,1)=HRR(18,35,1)+VRR(18,35,0)
      HRR(43,35,1)=HRR(43,35,1)+FnSpB*VRR(18,35,0)
      HRR(19,1,1)=HRR(19,1,1)+VRR(19,1,0)
      HRR(44,1,1)=HRR(44,1,1)+FnSpB*VRR(19,1,0)
      HRR(19,2,1)=HRR(19,2,1)+VRR(19,2,0)
      HRR(44,2,1)=HRR(44,2,1)+FnSpB*VRR(19,2,0)
      HRR(19,3,1)=HRR(19,3,1)+VRR(19,3,0)
      HRR(44,3,1)=HRR(44,3,1)+FnSpB*VRR(19,3,0)
      HRR(19,4,1)=HRR(19,4,1)+VRR(19,4,0)
      HRR(44,4,1)=HRR(44,4,1)+FnSpB*VRR(19,4,0)
      HRR(19,5,1)=HRR(19,5,1)+VRR(19,5,0)
      HRR(44,5,1)=HRR(44,5,1)+FnSpB*VRR(19,5,0)
      HRR(19,6,1)=HRR(19,6,1)+VRR(19,6,0)
      HRR(44,6,1)=HRR(44,6,1)+FnSpB*VRR(19,6,0)
      HRR(19,7,1)=HRR(19,7,1)+VRR(19,7,0)
      HRR(44,7,1)=HRR(44,7,1)+FnSpB*VRR(19,7,0)
      HRR(19,8,1)=HRR(19,8,1)+VRR(19,8,0)
      HRR(44,8,1)=HRR(44,8,1)+FnSpB*VRR(19,8,0)
      HRR(19,9,1)=HRR(19,9,1)+VRR(19,9,0)
      HRR(44,9,1)=HRR(44,9,1)+FnSpB*VRR(19,9,0)
      HRR(19,10,1)=HRR(19,10,1)+VRR(19,10,0)
      HRR(44,10,1)=HRR(44,10,1)+FnSpB*VRR(19,10,0)
      HRR(19,11,1)=HRR(19,11,1)+VRR(19,11,0)
      HRR(44,11,1)=HRR(44,11,1)+FnSpB*VRR(19,11,0)
      HRR(19,12,1)=HRR(19,12,1)+VRR(19,12,0)
      HRR(44,12,1)=HRR(44,12,1)+FnSpB*VRR(19,12,0)
      HRR(19,13,1)=HRR(19,13,1)+VRR(19,13,0)
      HRR(44,13,1)=HRR(44,13,1)+FnSpB*VRR(19,13,0)
      HRR(19,14,1)=HRR(19,14,1)+VRR(19,14,0)
      HRR(44,14,1)=HRR(44,14,1)+FnSpB*VRR(19,14,0)
      HRR(19,15,1)=HRR(19,15,1)+VRR(19,15,0)
      HRR(44,15,1)=HRR(44,15,1)+FnSpB*VRR(19,15,0)
      HRR(19,16,1)=HRR(19,16,1)+VRR(19,16,0)
      HRR(44,16,1)=HRR(44,16,1)+FnSpB*VRR(19,16,0)
      HRR(19,17,1)=HRR(19,17,1)+VRR(19,17,0)
      HRR(44,17,1)=HRR(44,17,1)+FnSpB*VRR(19,17,0)
      HRR(19,18,1)=HRR(19,18,1)+VRR(19,18,0)
      HRR(44,18,1)=HRR(44,18,1)+FnSpB*VRR(19,18,0)
      HRR(19,19,1)=HRR(19,19,1)+VRR(19,19,0)
      HRR(44,19,1)=HRR(44,19,1)+FnSpB*VRR(19,19,0)
      HRR(19,20,1)=HRR(19,20,1)+VRR(19,20,0)
      HRR(44,20,1)=HRR(44,20,1)+FnSpB*VRR(19,20,0)
      HRR(19,21,1)=HRR(19,21,1)+VRR(19,21,0)
      HRR(44,21,1)=HRR(44,21,1)+FnSpB*VRR(19,21,0)
      HRR(19,22,1)=HRR(19,22,1)+VRR(19,22,0)
      HRR(44,22,1)=HRR(44,22,1)+FnSpB*VRR(19,22,0)
      HRR(19,23,1)=HRR(19,23,1)+VRR(19,23,0)
      HRR(44,23,1)=HRR(44,23,1)+FnSpB*VRR(19,23,0)
      HRR(19,24,1)=HRR(19,24,1)+VRR(19,24,0)
      HRR(44,24,1)=HRR(44,24,1)+FnSpB*VRR(19,24,0)
      HRR(19,25,1)=HRR(19,25,1)+VRR(19,25,0)
      HRR(44,25,1)=HRR(44,25,1)+FnSpB*VRR(19,25,0)
      HRR(19,26,1)=HRR(19,26,1)+VRR(19,26,0)
      HRR(44,26,1)=HRR(44,26,1)+FnSpB*VRR(19,26,0)
      HRR(19,27,1)=HRR(19,27,1)+VRR(19,27,0)
      HRR(44,27,1)=HRR(44,27,1)+FnSpB*VRR(19,27,0)
      HRR(19,28,1)=HRR(19,28,1)+VRR(19,28,0)
      HRR(44,28,1)=HRR(44,28,1)+FnSpB*VRR(19,28,0)
      HRR(19,29,1)=HRR(19,29,1)+VRR(19,29,0)
      HRR(44,29,1)=HRR(44,29,1)+FnSpB*VRR(19,29,0)
      HRR(19,30,1)=HRR(19,30,1)+VRR(19,30,0)
      HRR(44,30,1)=HRR(44,30,1)+FnSpB*VRR(19,30,0)
      HRR(19,31,1)=HRR(19,31,1)+VRR(19,31,0)
      HRR(44,31,1)=HRR(44,31,1)+FnSpB*VRR(19,31,0)
      HRR(19,32,1)=HRR(19,32,1)+VRR(19,32,0)
      HRR(44,32,1)=HRR(44,32,1)+FnSpB*VRR(19,32,0)
      HRR(19,33,1)=HRR(19,33,1)+VRR(19,33,0)
      HRR(44,33,1)=HRR(44,33,1)+FnSpB*VRR(19,33,0)
      HRR(19,34,1)=HRR(19,34,1)+VRR(19,34,0)
      HRR(44,34,1)=HRR(44,34,1)+FnSpB*VRR(19,34,0)
      HRR(19,35,1)=HRR(19,35,1)+VRR(19,35,0)
      HRR(44,35,1)=HRR(44,35,1)+FnSpB*VRR(19,35,0)
      HRR(20,1,1)=HRR(20,1,1)+VRR(20,1,0)
      HRR(45,1,1)=HRR(45,1,1)+FnSpB*VRR(20,1,0)
      HRR(20,2,1)=HRR(20,2,1)+VRR(20,2,0)
      HRR(45,2,1)=HRR(45,2,1)+FnSpB*VRR(20,2,0)
      HRR(20,3,1)=HRR(20,3,1)+VRR(20,3,0)
      HRR(45,3,1)=HRR(45,3,1)+FnSpB*VRR(20,3,0)
      HRR(20,4,1)=HRR(20,4,1)+VRR(20,4,0)
      HRR(45,4,1)=HRR(45,4,1)+FnSpB*VRR(20,4,0)
      HRR(20,5,1)=HRR(20,5,1)+VRR(20,5,0)
      HRR(45,5,1)=HRR(45,5,1)+FnSpB*VRR(20,5,0)
      HRR(20,6,1)=HRR(20,6,1)+VRR(20,6,0)
      HRR(45,6,1)=HRR(45,6,1)+FnSpB*VRR(20,6,0)
      HRR(20,7,1)=HRR(20,7,1)+VRR(20,7,0)
      HRR(45,7,1)=HRR(45,7,1)+FnSpB*VRR(20,7,0)
      HRR(20,8,1)=HRR(20,8,1)+VRR(20,8,0)
      HRR(45,8,1)=HRR(45,8,1)+FnSpB*VRR(20,8,0)
      HRR(20,9,1)=HRR(20,9,1)+VRR(20,9,0)
      HRR(45,9,1)=HRR(45,9,1)+FnSpB*VRR(20,9,0)
      HRR(20,10,1)=HRR(20,10,1)+VRR(20,10,0)
      HRR(45,10,1)=HRR(45,10,1)+FnSpB*VRR(20,10,0)
      HRR(20,11,1)=HRR(20,11,1)+VRR(20,11,0)
      HRR(45,11,1)=HRR(45,11,1)+FnSpB*VRR(20,11,0)
      HRR(20,12,1)=HRR(20,12,1)+VRR(20,12,0)
      HRR(45,12,1)=HRR(45,12,1)+FnSpB*VRR(20,12,0)
      HRR(20,13,1)=HRR(20,13,1)+VRR(20,13,0)
      HRR(45,13,1)=HRR(45,13,1)+FnSpB*VRR(20,13,0)
      HRR(20,14,1)=HRR(20,14,1)+VRR(20,14,0)
      HRR(45,14,1)=HRR(45,14,1)+FnSpB*VRR(20,14,0)
      HRR(20,15,1)=HRR(20,15,1)+VRR(20,15,0)
      HRR(45,15,1)=HRR(45,15,1)+FnSpB*VRR(20,15,0)
      HRR(20,16,1)=HRR(20,16,1)+VRR(20,16,0)
      HRR(45,16,1)=HRR(45,16,1)+FnSpB*VRR(20,16,0)
      HRR(20,17,1)=HRR(20,17,1)+VRR(20,17,0)
      HRR(45,17,1)=HRR(45,17,1)+FnSpB*VRR(20,17,0)
      HRR(20,18,1)=HRR(20,18,1)+VRR(20,18,0)
      HRR(45,18,1)=HRR(45,18,1)+FnSpB*VRR(20,18,0)
      HRR(20,19,1)=HRR(20,19,1)+VRR(20,19,0)
      HRR(45,19,1)=HRR(45,19,1)+FnSpB*VRR(20,19,0)
      HRR(20,20,1)=HRR(20,20,1)+VRR(20,20,0)
      HRR(45,20,1)=HRR(45,20,1)+FnSpB*VRR(20,20,0)
      HRR(20,21,1)=HRR(20,21,1)+VRR(20,21,0)
      HRR(45,21,1)=HRR(45,21,1)+FnSpB*VRR(20,21,0)
      HRR(20,22,1)=HRR(20,22,1)+VRR(20,22,0)
      HRR(45,22,1)=HRR(45,22,1)+FnSpB*VRR(20,22,0)
      HRR(20,23,1)=HRR(20,23,1)+VRR(20,23,0)
      HRR(45,23,1)=HRR(45,23,1)+FnSpB*VRR(20,23,0)
      HRR(20,24,1)=HRR(20,24,1)+VRR(20,24,0)
      HRR(45,24,1)=HRR(45,24,1)+FnSpB*VRR(20,24,0)
      HRR(20,25,1)=HRR(20,25,1)+VRR(20,25,0)
      HRR(45,25,1)=HRR(45,25,1)+FnSpB*VRR(20,25,0)
      HRR(20,26,1)=HRR(20,26,1)+VRR(20,26,0)
      HRR(45,26,1)=HRR(45,26,1)+FnSpB*VRR(20,26,0)
      HRR(20,27,1)=HRR(20,27,1)+VRR(20,27,0)
      HRR(45,27,1)=HRR(45,27,1)+FnSpB*VRR(20,27,0)
      HRR(20,28,1)=HRR(20,28,1)+VRR(20,28,0)
      HRR(45,28,1)=HRR(45,28,1)+FnSpB*VRR(20,28,0)
      HRR(20,29,1)=HRR(20,29,1)+VRR(20,29,0)
      HRR(45,29,1)=HRR(45,29,1)+FnSpB*VRR(20,29,0)
      HRR(20,30,1)=HRR(20,30,1)+VRR(20,30,0)
      HRR(45,30,1)=HRR(45,30,1)+FnSpB*VRR(20,30,0)
      HRR(20,31,1)=HRR(20,31,1)+VRR(20,31,0)
      HRR(45,31,1)=HRR(45,31,1)+FnSpB*VRR(20,31,0)
      HRR(20,32,1)=HRR(20,32,1)+VRR(20,32,0)
      HRR(45,32,1)=HRR(45,32,1)+FnSpB*VRR(20,32,0)
      HRR(20,33,1)=HRR(20,33,1)+VRR(20,33,0)
      HRR(45,33,1)=HRR(45,33,1)+FnSpB*VRR(20,33,0)
      HRR(20,34,1)=HRR(20,34,1)+VRR(20,34,0)
      HRR(45,34,1)=HRR(45,34,1)+FnSpB*VRR(20,34,0)
      HRR(20,35,1)=HRR(20,35,1)+VRR(20,35,0)
      HRR(45,35,1)=HRR(45,35,1)+FnSpB*VRR(20,35,0)
      HRR(21,1,1)=HRR(21,1,1)+VRR(21,1,0)
      HRR(21,2,1)=HRR(21,2,1)+VRR(21,2,0)
      HRR(21,3,1)=HRR(21,3,1)+VRR(21,3,0)
      HRR(21,4,1)=HRR(21,4,1)+VRR(21,4,0)
      HRR(21,5,1)=HRR(21,5,1)+VRR(21,5,0)
      HRR(21,6,1)=HRR(21,6,1)+VRR(21,6,0)
      HRR(21,7,1)=HRR(21,7,1)+VRR(21,7,0)
      HRR(21,8,1)=HRR(21,8,1)+VRR(21,8,0)
      HRR(21,9,1)=HRR(21,9,1)+VRR(21,9,0)
      HRR(21,10,1)=HRR(21,10,1)+VRR(21,10,0)
      HRR(21,11,1)=HRR(21,11,1)+VRR(21,11,0)
      HRR(21,12,1)=HRR(21,12,1)+VRR(21,12,0)
      HRR(21,13,1)=HRR(21,13,1)+VRR(21,13,0)
      HRR(21,14,1)=HRR(21,14,1)+VRR(21,14,0)
      HRR(21,15,1)=HRR(21,15,1)+VRR(21,15,0)
      HRR(21,16,1)=HRR(21,16,1)+VRR(21,16,0)
      HRR(21,17,1)=HRR(21,17,1)+VRR(21,17,0)
      HRR(21,18,1)=HRR(21,18,1)+VRR(21,18,0)
      HRR(21,19,1)=HRR(21,19,1)+VRR(21,19,0)
      HRR(21,20,1)=HRR(21,20,1)+VRR(21,20,0)
      HRR(21,21,1)=HRR(21,21,1)+VRR(21,21,0)
      HRR(21,22,1)=HRR(21,22,1)+VRR(21,22,0)
      HRR(21,23,1)=HRR(21,23,1)+VRR(21,23,0)
      HRR(21,24,1)=HRR(21,24,1)+VRR(21,24,0)
      HRR(21,25,1)=HRR(21,25,1)+VRR(21,25,0)
      HRR(21,26,1)=HRR(21,26,1)+VRR(21,26,0)
      HRR(21,27,1)=HRR(21,27,1)+VRR(21,27,0)
      HRR(21,28,1)=HRR(21,28,1)+VRR(21,28,0)
      HRR(21,29,1)=HRR(21,29,1)+VRR(21,29,0)
      HRR(21,30,1)=HRR(21,30,1)+VRR(21,30,0)
      HRR(21,31,1)=HRR(21,31,1)+VRR(21,31,0)
      HRR(21,32,1)=HRR(21,32,1)+VRR(21,32,0)
      HRR(21,33,1)=HRR(21,33,1)+VRR(21,33,0)
      HRR(21,34,1)=HRR(21,34,1)+VRR(21,34,0)
      HRR(21,35,1)=HRR(21,35,1)+VRR(21,35,0)
      HRR(22,1,1)=HRR(22,1,1)+VRR(22,1,0)
      HRR(22,2,1)=HRR(22,2,1)+VRR(22,2,0)
      HRR(22,3,1)=HRR(22,3,1)+VRR(22,3,0)
      HRR(22,4,1)=HRR(22,4,1)+VRR(22,4,0)
      HRR(22,5,1)=HRR(22,5,1)+VRR(22,5,0)
      HRR(22,6,1)=HRR(22,6,1)+VRR(22,6,0)
      HRR(22,7,1)=HRR(22,7,1)+VRR(22,7,0)
      HRR(22,8,1)=HRR(22,8,1)+VRR(22,8,0)
      HRR(22,9,1)=HRR(22,9,1)+VRR(22,9,0)
      HRR(22,10,1)=HRR(22,10,1)+VRR(22,10,0)
      HRR(22,11,1)=HRR(22,11,1)+VRR(22,11,0)
      HRR(22,12,1)=HRR(22,12,1)+VRR(22,12,0)
      HRR(22,13,1)=HRR(22,13,1)+VRR(22,13,0)
      HRR(22,14,1)=HRR(22,14,1)+VRR(22,14,0)
      HRR(22,15,1)=HRR(22,15,1)+VRR(22,15,0)
      HRR(22,16,1)=HRR(22,16,1)+VRR(22,16,0)
      HRR(22,17,1)=HRR(22,17,1)+VRR(22,17,0)
      HRR(22,18,1)=HRR(22,18,1)+VRR(22,18,0)
      HRR(22,19,1)=HRR(22,19,1)+VRR(22,19,0)
      HRR(22,20,1)=HRR(22,20,1)+VRR(22,20,0)
      HRR(22,21,1)=HRR(22,21,1)+VRR(22,21,0)
      HRR(22,22,1)=HRR(22,22,1)+VRR(22,22,0)
      HRR(22,23,1)=HRR(22,23,1)+VRR(22,23,0)
      HRR(22,24,1)=HRR(22,24,1)+VRR(22,24,0)
      HRR(22,25,1)=HRR(22,25,1)+VRR(22,25,0)
      HRR(22,26,1)=HRR(22,26,1)+VRR(22,26,0)
      HRR(22,27,1)=HRR(22,27,1)+VRR(22,27,0)
      HRR(22,28,1)=HRR(22,28,1)+VRR(22,28,0)
      HRR(22,29,1)=HRR(22,29,1)+VRR(22,29,0)
      HRR(22,30,1)=HRR(22,30,1)+VRR(22,30,0)
      HRR(22,31,1)=HRR(22,31,1)+VRR(22,31,0)
      HRR(22,32,1)=HRR(22,32,1)+VRR(22,32,0)
      HRR(22,33,1)=HRR(22,33,1)+VRR(22,33,0)
      HRR(22,34,1)=HRR(22,34,1)+VRR(22,34,0)
      HRR(22,35,1)=HRR(22,35,1)+VRR(22,35,0)
      HRR(23,1,1)=HRR(23,1,1)+VRR(23,1,0)
      HRR(23,2,1)=HRR(23,2,1)+VRR(23,2,0)
      HRR(23,3,1)=HRR(23,3,1)+VRR(23,3,0)
      HRR(23,4,1)=HRR(23,4,1)+VRR(23,4,0)
      HRR(23,5,1)=HRR(23,5,1)+VRR(23,5,0)
      HRR(23,6,1)=HRR(23,6,1)+VRR(23,6,0)
      HRR(23,7,1)=HRR(23,7,1)+VRR(23,7,0)
      HRR(23,8,1)=HRR(23,8,1)+VRR(23,8,0)
      HRR(23,9,1)=HRR(23,9,1)+VRR(23,9,0)
      HRR(23,10,1)=HRR(23,10,1)+VRR(23,10,0)
      HRR(23,11,1)=HRR(23,11,1)+VRR(23,11,0)
      HRR(23,12,1)=HRR(23,12,1)+VRR(23,12,0)
      HRR(23,13,1)=HRR(23,13,1)+VRR(23,13,0)
      HRR(23,14,1)=HRR(23,14,1)+VRR(23,14,0)
      HRR(23,15,1)=HRR(23,15,1)+VRR(23,15,0)
      HRR(23,16,1)=HRR(23,16,1)+VRR(23,16,0)
      HRR(23,17,1)=HRR(23,17,1)+VRR(23,17,0)
      HRR(23,18,1)=HRR(23,18,1)+VRR(23,18,0)
      HRR(23,19,1)=HRR(23,19,1)+VRR(23,19,0)
      HRR(23,20,1)=HRR(23,20,1)+VRR(23,20,0)
      HRR(23,21,1)=HRR(23,21,1)+VRR(23,21,0)
      HRR(23,22,1)=HRR(23,22,1)+VRR(23,22,0)
      HRR(23,23,1)=HRR(23,23,1)+VRR(23,23,0)
      HRR(23,24,1)=HRR(23,24,1)+VRR(23,24,0)
      HRR(23,25,1)=HRR(23,25,1)+VRR(23,25,0)
      HRR(23,26,1)=HRR(23,26,1)+VRR(23,26,0)
      HRR(23,27,1)=HRR(23,27,1)+VRR(23,27,0)
      HRR(23,28,1)=HRR(23,28,1)+VRR(23,28,0)
      HRR(23,29,1)=HRR(23,29,1)+VRR(23,29,0)
      HRR(23,30,1)=HRR(23,30,1)+VRR(23,30,0)
      HRR(23,31,1)=HRR(23,31,1)+VRR(23,31,0)
      HRR(23,32,1)=HRR(23,32,1)+VRR(23,32,0)
      HRR(23,33,1)=HRR(23,33,1)+VRR(23,33,0)
      HRR(23,34,1)=HRR(23,34,1)+VRR(23,34,0)
      HRR(23,35,1)=HRR(23,35,1)+VRR(23,35,0)
      HRR(24,1,1)=HRR(24,1,1)+VRR(24,1,0)
      HRR(24,2,1)=HRR(24,2,1)+VRR(24,2,0)
      HRR(24,3,1)=HRR(24,3,1)+VRR(24,3,0)
      HRR(24,4,1)=HRR(24,4,1)+VRR(24,4,0)
      HRR(24,5,1)=HRR(24,5,1)+VRR(24,5,0)
      HRR(24,6,1)=HRR(24,6,1)+VRR(24,6,0)
      HRR(24,7,1)=HRR(24,7,1)+VRR(24,7,0)
      HRR(24,8,1)=HRR(24,8,1)+VRR(24,8,0)
      HRR(24,9,1)=HRR(24,9,1)+VRR(24,9,0)
      HRR(24,10,1)=HRR(24,10,1)+VRR(24,10,0)
      HRR(24,11,1)=HRR(24,11,1)+VRR(24,11,0)
      HRR(24,12,1)=HRR(24,12,1)+VRR(24,12,0)
      HRR(24,13,1)=HRR(24,13,1)+VRR(24,13,0)
      HRR(24,14,1)=HRR(24,14,1)+VRR(24,14,0)
      HRR(24,15,1)=HRR(24,15,1)+VRR(24,15,0)
      HRR(24,16,1)=HRR(24,16,1)+VRR(24,16,0)
      HRR(24,17,1)=HRR(24,17,1)+VRR(24,17,0)
      HRR(24,18,1)=HRR(24,18,1)+VRR(24,18,0)
      HRR(24,19,1)=HRR(24,19,1)+VRR(24,19,0)
      HRR(24,20,1)=HRR(24,20,1)+VRR(24,20,0)
      HRR(24,21,1)=HRR(24,21,1)+VRR(24,21,0)
      HRR(24,22,1)=HRR(24,22,1)+VRR(24,22,0)
      HRR(24,23,1)=HRR(24,23,1)+VRR(24,23,0)
      HRR(24,24,1)=HRR(24,24,1)+VRR(24,24,0)
      HRR(24,25,1)=HRR(24,25,1)+VRR(24,25,0)
      HRR(24,26,1)=HRR(24,26,1)+VRR(24,26,0)
      HRR(24,27,1)=HRR(24,27,1)+VRR(24,27,0)
      HRR(24,28,1)=HRR(24,28,1)+VRR(24,28,0)
      HRR(24,29,1)=HRR(24,29,1)+VRR(24,29,0)
      HRR(24,30,1)=HRR(24,30,1)+VRR(24,30,0)
      HRR(24,31,1)=HRR(24,31,1)+VRR(24,31,0)
      HRR(24,32,1)=HRR(24,32,1)+VRR(24,32,0)
      HRR(24,33,1)=HRR(24,33,1)+VRR(24,33,0)
      HRR(24,34,1)=HRR(24,34,1)+VRR(24,34,0)
      HRR(24,35,1)=HRR(24,35,1)+VRR(24,35,0)
      HRR(25,1,1)=HRR(25,1,1)+VRR(25,1,0)
      HRR(25,2,1)=HRR(25,2,1)+VRR(25,2,0)
      HRR(25,3,1)=HRR(25,3,1)+VRR(25,3,0)
      HRR(25,4,1)=HRR(25,4,1)+VRR(25,4,0)
      HRR(25,5,1)=HRR(25,5,1)+VRR(25,5,0)
      HRR(25,6,1)=HRR(25,6,1)+VRR(25,6,0)
      HRR(25,7,1)=HRR(25,7,1)+VRR(25,7,0)
      HRR(25,8,1)=HRR(25,8,1)+VRR(25,8,0)
      HRR(25,9,1)=HRR(25,9,1)+VRR(25,9,0)
      HRR(25,10,1)=HRR(25,10,1)+VRR(25,10,0)
      HRR(25,11,1)=HRR(25,11,1)+VRR(25,11,0)
      HRR(25,12,1)=HRR(25,12,1)+VRR(25,12,0)
      HRR(25,13,1)=HRR(25,13,1)+VRR(25,13,0)
      HRR(25,14,1)=HRR(25,14,1)+VRR(25,14,0)
      HRR(25,15,1)=HRR(25,15,1)+VRR(25,15,0)
      HRR(25,16,1)=HRR(25,16,1)+VRR(25,16,0)
      HRR(25,17,1)=HRR(25,17,1)+VRR(25,17,0)
      HRR(25,18,1)=HRR(25,18,1)+VRR(25,18,0)
      HRR(25,19,1)=HRR(25,19,1)+VRR(25,19,0)
      HRR(25,20,1)=HRR(25,20,1)+VRR(25,20,0)
      HRR(25,21,1)=HRR(25,21,1)+VRR(25,21,0)
      HRR(25,22,1)=HRR(25,22,1)+VRR(25,22,0)
      HRR(25,23,1)=HRR(25,23,1)+VRR(25,23,0)
      HRR(25,24,1)=HRR(25,24,1)+VRR(25,24,0)
      HRR(25,25,1)=HRR(25,25,1)+VRR(25,25,0)
      HRR(25,26,1)=HRR(25,26,1)+VRR(25,26,0)
      HRR(25,27,1)=HRR(25,27,1)+VRR(25,27,0)
      HRR(25,28,1)=HRR(25,28,1)+VRR(25,28,0)
      HRR(25,29,1)=HRR(25,29,1)+VRR(25,29,0)
      HRR(25,30,1)=HRR(25,30,1)+VRR(25,30,0)
      HRR(25,31,1)=HRR(25,31,1)+VRR(25,31,0)
      HRR(25,32,1)=HRR(25,32,1)+VRR(25,32,0)
      HRR(25,33,1)=HRR(25,33,1)+VRR(25,33,0)
      HRR(25,34,1)=HRR(25,34,1)+VRR(25,34,0)
      HRR(25,35,1)=HRR(25,35,1)+VRR(25,35,0)
      HRR(26,1,1)=HRR(26,1,1)+VRR(26,1,0)
      HRR(26,2,1)=HRR(26,2,1)+VRR(26,2,0)
      HRR(26,3,1)=HRR(26,3,1)+VRR(26,3,0)
      HRR(26,4,1)=HRR(26,4,1)+VRR(26,4,0)
      HRR(26,5,1)=HRR(26,5,1)+VRR(26,5,0)
      HRR(26,6,1)=HRR(26,6,1)+VRR(26,6,0)
      HRR(26,7,1)=HRR(26,7,1)+VRR(26,7,0)
      HRR(26,8,1)=HRR(26,8,1)+VRR(26,8,0)
      HRR(26,9,1)=HRR(26,9,1)+VRR(26,9,0)
      HRR(26,10,1)=HRR(26,10,1)+VRR(26,10,0)
      HRR(26,11,1)=HRR(26,11,1)+VRR(26,11,0)
      HRR(26,12,1)=HRR(26,12,1)+VRR(26,12,0)
      HRR(26,13,1)=HRR(26,13,1)+VRR(26,13,0)
      HRR(26,14,1)=HRR(26,14,1)+VRR(26,14,0)
      HRR(26,15,1)=HRR(26,15,1)+VRR(26,15,0)
      HRR(26,16,1)=HRR(26,16,1)+VRR(26,16,0)
      HRR(26,17,1)=HRR(26,17,1)+VRR(26,17,0)
      HRR(26,18,1)=HRR(26,18,1)+VRR(26,18,0)
      HRR(26,19,1)=HRR(26,19,1)+VRR(26,19,0)
      HRR(26,20,1)=HRR(26,20,1)+VRR(26,20,0)
      HRR(26,21,1)=HRR(26,21,1)+VRR(26,21,0)
      HRR(26,22,1)=HRR(26,22,1)+VRR(26,22,0)
      HRR(26,23,1)=HRR(26,23,1)+VRR(26,23,0)
      HRR(26,24,1)=HRR(26,24,1)+VRR(26,24,0)
      HRR(26,25,1)=HRR(26,25,1)+VRR(26,25,0)
      HRR(26,26,1)=HRR(26,26,1)+VRR(26,26,0)
      HRR(26,27,1)=HRR(26,27,1)+VRR(26,27,0)
      HRR(26,28,1)=HRR(26,28,1)+VRR(26,28,0)
      HRR(26,29,1)=HRR(26,29,1)+VRR(26,29,0)
      HRR(26,30,1)=HRR(26,30,1)+VRR(26,30,0)
      HRR(26,31,1)=HRR(26,31,1)+VRR(26,31,0)
      HRR(26,32,1)=HRR(26,32,1)+VRR(26,32,0)
      HRR(26,33,1)=HRR(26,33,1)+VRR(26,33,0)
      HRR(26,34,1)=HRR(26,34,1)+VRR(26,34,0)
      HRR(26,35,1)=HRR(26,35,1)+VRR(26,35,0)
      HRR(27,1,1)=HRR(27,1,1)+VRR(27,1,0)
      HRR(27,2,1)=HRR(27,2,1)+VRR(27,2,0)
      HRR(27,3,1)=HRR(27,3,1)+VRR(27,3,0)
      HRR(27,4,1)=HRR(27,4,1)+VRR(27,4,0)
      HRR(27,5,1)=HRR(27,5,1)+VRR(27,5,0)
      HRR(27,6,1)=HRR(27,6,1)+VRR(27,6,0)
      HRR(27,7,1)=HRR(27,7,1)+VRR(27,7,0)
      HRR(27,8,1)=HRR(27,8,1)+VRR(27,8,0)
      HRR(27,9,1)=HRR(27,9,1)+VRR(27,9,0)
      HRR(27,10,1)=HRR(27,10,1)+VRR(27,10,0)
      HRR(27,11,1)=HRR(27,11,1)+VRR(27,11,0)
      HRR(27,12,1)=HRR(27,12,1)+VRR(27,12,0)
      HRR(27,13,1)=HRR(27,13,1)+VRR(27,13,0)
      HRR(27,14,1)=HRR(27,14,1)+VRR(27,14,0)
      HRR(27,15,1)=HRR(27,15,1)+VRR(27,15,0)
      HRR(27,16,1)=HRR(27,16,1)+VRR(27,16,0)
      HRR(27,17,1)=HRR(27,17,1)+VRR(27,17,0)
      HRR(27,18,1)=HRR(27,18,1)+VRR(27,18,0)
      HRR(27,19,1)=HRR(27,19,1)+VRR(27,19,0)
      HRR(27,20,1)=HRR(27,20,1)+VRR(27,20,0)
      HRR(27,21,1)=HRR(27,21,1)+VRR(27,21,0)
      HRR(27,22,1)=HRR(27,22,1)+VRR(27,22,0)
      HRR(27,23,1)=HRR(27,23,1)+VRR(27,23,0)
      HRR(27,24,1)=HRR(27,24,1)+VRR(27,24,0)
      HRR(27,25,1)=HRR(27,25,1)+VRR(27,25,0)
      HRR(27,26,1)=HRR(27,26,1)+VRR(27,26,0)
      HRR(27,27,1)=HRR(27,27,1)+VRR(27,27,0)
      HRR(27,28,1)=HRR(27,28,1)+VRR(27,28,0)
      HRR(27,29,1)=HRR(27,29,1)+VRR(27,29,0)
      HRR(27,30,1)=HRR(27,30,1)+VRR(27,30,0)
      HRR(27,31,1)=HRR(27,31,1)+VRR(27,31,0)
      HRR(27,32,1)=HRR(27,32,1)+VRR(27,32,0)
      HRR(27,33,1)=HRR(27,33,1)+VRR(27,33,0)
      HRR(27,34,1)=HRR(27,34,1)+VRR(27,34,0)
      HRR(27,35,1)=HRR(27,35,1)+VRR(27,35,0)
      HRR(28,1,1)=HRR(28,1,1)+VRR(28,1,0)
      HRR(28,2,1)=HRR(28,2,1)+VRR(28,2,0)
      HRR(28,3,1)=HRR(28,3,1)+VRR(28,3,0)
      HRR(28,4,1)=HRR(28,4,1)+VRR(28,4,0)
      HRR(28,5,1)=HRR(28,5,1)+VRR(28,5,0)
      HRR(28,6,1)=HRR(28,6,1)+VRR(28,6,0)
      HRR(28,7,1)=HRR(28,7,1)+VRR(28,7,0)
      HRR(28,8,1)=HRR(28,8,1)+VRR(28,8,0)
      HRR(28,9,1)=HRR(28,9,1)+VRR(28,9,0)
      HRR(28,10,1)=HRR(28,10,1)+VRR(28,10,0)
      HRR(28,11,1)=HRR(28,11,1)+VRR(28,11,0)
      HRR(28,12,1)=HRR(28,12,1)+VRR(28,12,0)
      HRR(28,13,1)=HRR(28,13,1)+VRR(28,13,0)
      HRR(28,14,1)=HRR(28,14,1)+VRR(28,14,0)
      HRR(28,15,1)=HRR(28,15,1)+VRR(28,15,0)
      HRR(28,16,1)=HRR(28,16,1)+VRR(28,16,0)
      HRR(28,17,1)=HRR(28,17,1)+VRR(28,17,0)
      HRR(28,18,1)=HRR(28,18,1)+VRR(28,18,0)
      HRR(28,19,1)=HRR(28,19,1)+VRR(28,19,0)
      HRR(28,20,1)=HRR(28,20,1)+VRR(28,20,0)
      HRR(28,21,1)=HRR(28,21,1)+VRR(28,21,0)
      HRR(28,22,1)=HRR(28,22,1)+VRR(28,22,0)
      HRR(28,23,1)=HRR(28,23,1)+VRR(28,23,0)
      HRR(28,24,1)=HRR(28,24,1)+VRR(28,24,0)
      HRR(28,25,1)=HRR(28,25,1)+VRR(28,25,0)
      HRR(28,26,1)=HRR(28,26,1)+VRR(28,26,0)
      HRR(28,27,1)=HRR(28,27,1)+VRR(28,27,0)
      HRR(28,28,1)=HRR(28,28,1)+VRR(28,28,0)
      HRR(28,29,1)=HRR(28,29,1)+VRR(28,29,0)
      HRR(28,30,1)=HRR(28,30,1)+VRR(28,30,0)
      HRR(28,31,1)=HRR(28,31,1)+VRR(28,31,0)
      HRR(28,32,1)=HRR(28,32,1)+VRR(28,32,0)
      HRR(28,33,1)=HRR(28,33,1)+VRR(28,33,0)
      HRR(28,34,1)=HRR(28,34,1)+VRR(28,34,0)
      HRR(28,35,1)=HRR(28,35,1)+VRR(28,35,0)
      HRR(29,1,1)=HRR(29,1,1)+VRR(29,1,0)
      HRR(29,2,1)=HRR(29,2,1)+VRR(29,2,0)
      HRR(29,3,1)=HRR(29,3,1)+VRR(29,3,0)
      HRR(29,4,1)=HRR(29,4,1)+VRR(29,4,0)
      HRR(29,5,1)=HRR(29,5,1)+VRR(29,5,0)
      HRR(29,6,1)=HRR(29,6,1)+VRR(29,6,0)
      HRR(29,7,1)=HRR(29,7,1)+VRR(29,7,0)
      HRR(29,8,1)=HRR(29,8,1)+VRR(29,8,0)
      HRR(29,9,1)=HRR(29,9,1)+VRR(29,9,0)
      HRR(29,10,1)=HRR(29,10,1)+VRR(29,10,0)
      HRR(29,11,1)=HRR(29,11,1)+VRR(29,11,0)
      HRR(29,12,1)=HRR(29,12,1)+VRR(29,12,0)
      HRR(29,13,1)=HRR(29,13,1)+VRR(29,13,0)
      HRR(29,14,1)=HRR(29,14,1)+VRR(29,14,0)
      HRR(29,15,1)=HRR(29,15,1)+VRR(29,15,0)
      HRR(29,16,1)=HRR(29,16,1)+VRR(29,16,0)
      HRR(29,17,1)=HRR(29,17,1)+VRR(29,17,0)
      HRR(29,18,1)=HRR(29,18,1)+VRR(29,18,0)
      HRR(29,19,1)=HRR(29,19,1)+VRR(29,19,0)
      HRR(29,20,1)=HRR(29,20,1)+VRR(29,20,0)
      HRR(29,21,1)=HRR(29,21,1)+VRR(29,21,0)
      HRR(29,22,1)=HRR(29,22,1)+VRR(29,22,0)
      HRR(29,23,1)=HRR(29,23,1)+VRR(29,23,0)
      HRR(29,24,1)=HRR(29,24,1)+VRR(29,24,0)
      HRR(29,25,1)=HRR(29,25,1)+VRR(29,25,0)
      HRR(29,26,1)=HRR(29,26,1)+VRR(29,26,0)
      HRR(29,27,1)=HRR(29,27,1)+VRR(29,27,0)
      HRR(29,28,1)=HRR(29,28,1)+VRR(29,28,0)
      HRR(29,29,1)=HRR(29,29,1)+VRR(29,29,0)
      HRR(29,30,1)=HRR(29,30,1)+VRR(29,30,0)
      HRR(29,31,1)=HRR(29,31,1)+VRR(29,31,0)
      HRR(29,32,1)=HRR(29,32,1)+VRR(29,32,0)
      HRR(29,33,1)=HRR(29,33,1)+VRR(29,33,0)
      HRR(29,34,1)=HRR(29,34,1)+VRR(29,34,0)
      HRR(29,35,1)=HRR(29,35,1)+VRR(29,35,0)
      HRR(30,1,1)=HRR(30,1,1)+VRR(30,1,0)
      HRR(30,2,1)=HRR(30,2,1)+VRR(30,2,0)
      HRR(30,3,1)=HRR(30,3,1)+VRR(30,3,0)
      HRR(30,4,1)=HRR(30,4,1)+VRR(30,4,0)
      HRR(30,5,1)=HRR(30,5,1)+VRR(30,5,0)
      HRR(30,6,1)=HRR(30,6,1)+VRR(30,6,0)
      HRR(30,7,1)=HRR(30,7,1)+VRR(30,7,0)
      HRR(30,8,1)=HRR(30,8,1)+VRR(30,8,0)
      HRR(30,9,1)=HRR(30,9,1)+VRR(30,9,0)
      HRR(30,10,1)=HRR(30,10,1)+VRR(30,10,0)
      HRR(30,11,1)=HRR(30,11,1)+VRR(30,11,0)
      HRR(30,12,1)=HRR(30,12,1)+VRR(30,12,0)
      HRR(30,13,1)=HRR(30,13,1)+VRR(30,13,0)
      HRR(30,14,1)=HRR(30,14,1)+VRR(30,14,0)
      HRR(30,15,1)=HRR(30,15,1)+VRR(30,15,0)
      HRR(30,16,1)=HRR(30,16,1)+VRR(30,16,0)
      HRR(30,17,1)=HRR(30,17,1)+VRR(30,17,0)
      HRR(30,18,1)=HRR(30,18,1)+VRR(30,18,0)
      HRR(30,19,1)=HRR(30,19,1)+VRR(30,19,0)
      HRR(30,20,1)=HRR(30,20,1)+VRR(30,20,0)
      HRR(30,21,1)=HRR(30,21,1)+VRR(30,21,0)
      HRR(30,22,1)=HRR(30,22,1)+VRR(30,22,0)
      HRR(30,23,1)=HRR(30,23,1)+VRR(30,23,0)
      HRR(30,24,1)=HRR(30,24,1)+VRR(30,24,0)
      HRR(30,25,1)=HRR(30,25,1)+VRR(30,25,0)
      HRR(30,26,1)=HRR(30,26,1)+VRR(30,26,0)
      HRR(30,27,1)=HRR(30,27,1)+VRR(30,27,0)
      HRR(30,28,1)=HRR(30,28,1)+VRR(30,28,0)
      HRR(30,29,1)=HRR(30,29,1)+VRR(30,29,0)
      HRR(30,30,1)=HRR(30,30,1)+VRR(30,30,0)
      HRR(30,31,1)=HRR(30,31,1)+VRR(30,31,0)
      HRR(30,32,1)=HRR(30,32,1)+VRR(30,32,0)
      HRR(30,33,1)=HRR(30,33,1)+VRR(30,33,0)
      HRR(30,34,1)=HRR(30,34,1)+VRR(30,34,0)
      HRR(30,35,1)=HRR(30,35,1)+VRR(30,35,0)
      HRR(31,1,1)=HRR(31,1,1)+VRR(31,1,0)
      HRR(31,2,1)=HRR(31,2,1)+VRR(31,2,0)
      HRR(31,3,1)=HRR(31,3,1)+VRR(31,3,0)
      HRR(31,4,1)=HRR(31,4,1)+VRR(31,4,0)
      HRR(31,5,1)=HRR(31,5,1)+VRR(31,5,0)
      HRR(31,6,1)=HRR(31,6,1)+VRR(31,6,0)
      HRR(31,7,1)=HRR(31,7,1)+VRR(31,7,0)
      HRR(31,8,1)=HRR(31,8,1)+VRR(31,8,0)
      HRR(31,9,1)=HRR(31,9,1)+VRR(31,9,0)
      HRR(31,10,1)=HRR(31,10,1)+VRR(31,10,0)
      HRR(31,11,1)=HRR(31,11,1)+VRR(31,11,0)
      HRR(31,12,1)=HRR(31,12,1)+VRR(31,12,0)
      HRR(31,13,1)=HRR(31,13,1)+VRR(31,13,0)
      HRR(31,14,1)=HRR(31,14,1)+VRR(31,14,0)
      HRR(31,15,1)=HRR(31,15,1)+VRR(31,15,0)
      HRR(31,16,1)=HRR(31,16,1)+VRR(31,16,0)
      HRR(31,17,1)=HRR(31,17,1)+VRR(31,17,0)
      HRR(31,18,1)=HRR(31,18,1)+VRR(31,18,0)
      HRR(31,19,1)=HRR(31,19,1)+VRR(31,19,0)
      HRR(31,20,1)=HRR(31,20,1)+VRR(31,20,0)
      HRR(31,21,1)=HRR(31,21,1)+VRR(31,21,0)
      HRR(31,22,1)=HRR(31,22,1)+VRR(31,22,0)
      HRR(31,23,1)=HRR(31,23,1)+VRR(31,23,0)
      HRR(31,24,1)=HRR(31,24,1)+VRR(31,24,0)
      HRR(31,25,1)=HRR(31,25,1)+VRR(31,25,0)
      HRR(31,26,1)=HRR(31,26,1)+VRR(31,26,0)
      HRR(31,27,1)=HRR(31,27,1)+VRR(31,27,0)
      HRR(31,28,1)=HRR(31,28,1)+VRR(31,28,0)
      HRR(31,29,1)=HRR(31,29,1)+VRR(31,29,0)
      HRR(31,30,1)=HRR(31,30,1)+VRR(31,30,0)
      HRR(31,31,1)=HRR(31,31,1)+VRR(31,31,0)
      HRR(31,32,1)=HRR(31,32,1)+VRR(31,32,0)
      HRR(31,33,1)=HRR(31,33,1)+VRR(31,33,0)
      HRR(31,34,1)=HRR(31,34,1)+VRR(31,34,0)
      HRR(31,35,1)=HRR(31,35,1)+VRR(31,35,0)
      HRR(32,1,1)=HRR(32,1,1)+VRR(32,1,0)
      HRR(32,2,1)=HRR(32,2,1)+VRR(32,2,0)
      HRR(32,3,1)=HRR(32,3,1)+VRR(32,3,0)
      HRR(32,4,1)=HRR(32,4,1)+VRR(32,4,0)
      HRR(32,5,1)=HRR(32,5,1)+VRR(32,5,0)
      HRR(32,6,1)=HRR(32,6,1)+VRR(32,6,0)
      HRR(32,7,1)=HRR(32,7,1)+VRR(32,7,0)
      HRR(32,8,1)=HRR(32,8,1)+VRR(32,8,0)
      HRR(32,9,1)=HRR(32,9,1)+VRR(32,9,0)
      HRR(32,10,1)=HRR(32,10,1)+VRR(32,10,0)
      HRR(32,11,1)=HRR(32,11,1)+VRR(32,11,0)
      HRR(32,12,1)=HRR(32,12,1)+VRR(32,12,0)
      HRR(32,13,1)=HRR(32,13,1)+VRR(32,13,0)
      HRR(32,14,1)=HRR(32,14,1)+VRR(32,14,0)
      HRR(32,15,1)=HRR(32,15,1)+VRR(32,15,0)
      HRR(32,16,1)=HRR(32,16,1)+VRR(32,16,0)
      HRR(32,17,1)=HRR(32,17,1)+VRR(32,17,0)
      HRR(32,18,1)=HRR(32,18,1)+VRR(32,18,0)
      HRR(32,19,1)=HRR(32,19,1)+VRR(32,19,0)
      HRR(32,20,1)=HRR(32,20,1)+VRR(32,20,0)
      HRR(32,21,1)=HRR(32,21,1)+VRR(32,21,0)
      HRR(32,22,1)=HRR(32,22,1)+VRR(32,22,0)
      HRR(32,23,1)=HRR(32,23,1)+VRR(32,23,0)
      HRR(32,24,1)=HRR(32,24,1)+VRR(32,24,0)
      HRR(32,25,1)=HRR(32,25,1)+VRR(32,25,0)
      HRR(32,26,1)=HRR(32,26,1)+VRR(32,26,0)
      HRR(32,27,1)=HRR(32,27,1)+VRR(32,27,0)
      HRR(32,28,1)=HRR(32,28,1)+VRR(32,28,0)
      HRR(32,29,1)=HRR(32,29,1)+VRR(32,29,0)
      HRR(32,30,1)=HRR(32,30,1)+VRR(32,30,0)
      HRR(32,31,1)=HRR(32,31,1)+VRR(32,31,0)
      HRR(32,32,1)=HRR(32,32,1)+VRR(32,32,0)
      HRR(32,33,1)=HRR(32,33,1)+VRR(32,33,0)
      HRR(32,34,1)=HRR(32,34,1)+VRR(32,34,0)
      HRR(32,35,1)=HRR(32,35,1)+VRR(32,35,0)
      HRR(33,1,1)=HRR(33,1,1)+VRR(33,1,0)
      HRR(33,2,1)=HRR(33,2,1)+VRR(33,2,0)
      HRR(33,3,1)=HRR(33,3,1)+VRR(33,3,0)
      HRR(33,4,1)=HRR(33,4,1)+VRR(33,4,0)
      HRR(33,5,1)=HRR(33,5,1)+VRR(33,5,0)
      HRR(33,6,1)=HRR(33,6,1)+VRR(33,6,0)
      HRR(33,7,1)=HRR(33,7,1)+VRR(33,7,0)
      HRR(33,8,1)=HRR(33,8,1)+VRR(33,8,0)
      HRR(33,9,1)=HRR(33,9,1)+VRR(33,9,0)
      HRR(33,10,1)=HRR(33,10,1)+VRR(33,10,0)
      HRR(33,11,1)=HRR(33,11,1)+VRR(33,11,0)
      HRR(33,12,1)=HRR(33,12,1)+VRR(33,12,0)
      HRR(33,13,1)=HRR(33,13,1)+VRR(33,13,0)
      HRR(33,14,1)=HRR(33,14,1)+VRR(33,14,0)
      HRR(33,15,1)=HRR(33,15,1)+VRR(33,15,0)
      HRR(33,16,1)=HRR(33,16,1)+VRR(33,16,0)
      HRR(33,17,1)=HRR(33,17,1)+VRR(33,17,0)
      HRR(33,18,1)=HRR(33,18,1)+VRR(33,18,0)
      HRR(33,19,1)=HRR(33,19,1)+VRR(33,19,0)
      HRR(33,20,1)=HRR(33,20,1)+VRR(33,20,0)
      HRR(33,21,1)=HRR(33,21,1)+VRR(33,21,0)
      HRR(33,22,1)=HRR(33,22,1)+VRR(33,22,0)
      HRR(33,23,1)=HRR(33,23,1)+VRR(33,23,0)
      HRR(33,24,1)=HRR(33,24,1)+VRR(33,24,0)
      HRR(33,25,1)=HRR(33,25,1)+VRR(33,25,0)
      HRR(33,26,1)=HRR(33,26,1)+VRR(33,26,0)
      HRR(33,27,1)=HRR(33,27,1)+VRR(33,27,0)
      HRR(33,28,1)=HRR(33,28,1)+VRR(33,28,0)
      HRR(33,29,1)=HRR(33,29,1)+VRR(33,29,0)
      HRR(33,30,1)=HRR(33,30,1)+VRR(33,30,0)
      HRR(33,31,1)=HRR(33,31,1)+VRR(33,31,0)
      HRR(33,32,1)=HRR(33,32,1)+VRR(33,32,0)
      HRR(33,33,1)=HRR(33,33,1)+VRR(33,33,0)
      HRR(33,34,1)=HRR(33,34,1)+VRR(33,34,0)
      HRR(33,35,1)=HRR(33,35,1)+VRR(33,35,0)
      HRR(34,1,1)=HRR(34,1,1)+VRR(34,1,0)
      HRR(34,2,1)=HRR(34,2,1)+VRR(34,2,0)
      HRR(34,3,1)=HRR(34,3,1)+VRR(34,3,0)
      HRR(34,4,1)=HRR(34,4,1)+VRR(34,4,0)
      HRR(34,5,1)=HRR(34,5,1)+VRR(34,5,0)
      HRR(34,6,1)=HRR(34,6,1)+VRR(34,6,0)
      HRR(34,7,1)=HRR(34,7,1)+VRR(34,7,0)
      HRR(34,8,1)=HRR(34,8,1)+VRR(34,8,0)
      HRR(34,9,1)=HRR(34,9,1)+VRR(34,9,0)
      HRR(34,10,1)=HRR(34,10,1)+VRR(34,10,0)
      HRR(34,11,1)=HRR(34,11,1)+VRR(34,11,0)
      HRR(34,12,1)=HRR(34,12,1)+VRR(34,12,0)
      HRR(34,13,1)=HRR(34,13,1)+VRR(34,13,0)
      HRR(34,14,1)=HRR(34,14,1)+VRR(34,14,0)
      HRR(34,15,1)=HRR(34,15,1)+VRR(34,15,0)
      HRR(34,16,1)=HRR(34,16,1)+VRR(34,16,0)
      HRR(34,17,1)=HRR(34,17,1)+VRR(34,17,0)
      HRR(34,18,1)=HRR(34,18,1)+VRR(34,18,0)
      HRR(34,19,1)=HRR(34,19,1)+VRR(34,19,0)
      HRR(34,20,1)=HRR(34,20,1)+VRR(34,20,0)
      HRR(34,21,1)=HRR(34,21,1)+VRR(34,21,0)
      HRR(34,22,1)=HRR(34,22,1)+VRR(34,22,0)
      HRR(34,23,1)=HRR(34,23,1)+VRR(34,23,0)
      HRR(34,24,1)=HRR(34,24,1)+VRR(34,24,0)
      HRR(34,25,1)=HRR(34,25,1)+VRR(34,25,0)
      HRR(34,26,1)=HRR(34,26,1)+VRR(34,26,0)
      HRR(34,27,1)=HRR(34,27,1)+VRR(34,27,0)
      HRR(34,28,1)=HRR(34,28,1)+VRR(34,28,0)
      HRR(34,29,1)=HRR(34,29,1)+VRR(34,29,0)
      HRR(34,30,1)=HRR(34,30,1)+VRR(34,30,0)
      HRR(34,31,1)=HRR(34,31,1)+VRR(34,31,0)
      HRR(34,32,1)=HRR(34,32,1)+VRR(34,32,0)
      HRR(34,33,1)=HRR(34,33,1)+VRR(34,33,0)
      HRR(34,34,1)=HRR(34,34,1)+VRR(34,34,0)
      HRR(34,35,1)=HRR(34,35,1)+VRR(34,35,0)
      HRR(35,1,1)=HRR(35,1,1)+VRR(35,1,0)
      HRR(35,2,1)=HRR(35,2,1)+VRR(35,2,0)
      HRR(35,3,1)=HRR(35,3,1)+VRR(35,3,0)
      HRR(35,4,1)=HRR(35,4,1)+VRR(35,4,0)
      HRR(35,5,1)=HRR(35,5,1)+VRR(35,5,0)
      HRR(35,6,1)=HRR(35,6,1)+VRR(35,6,0)
      HRR(35,7,1)=HRR(35,7,1)+VRR(35,7,0)
      HRR(35,8,1)=HRR(35,8,1)+VRR(35,8,0)
      HRR(35,9,1)=HRR(35,9,1)+VRR(35,9,0)
      HRR(35,10,1)=HRR(35,10,1)+VRR(35,10,0)
      HRR(35,11,1)=HRR(35,11,1)+VRR(35,11,0)
      HRR(35,12,1)=HRR(35,12,1)+VRR(35,12,0)
      HRR(35,13,1)=HRR(35,13,1)+VRR(35,13,0)
      HRR(35,14,1)=HRR(35,14,1)+VRR(35,14,0)
      HRR(35,15,1)=HRR(35,15,1)+VRR(35,15,0)
      HRR(35,16,1)=HRR(35,16,1)+VRR(35,16,0)
      HRR(35,17,1)=HRR(35,17,1)+VRR(35,17,0)
      HRR(35,18,1)=HRR(35,18,1)+VRR(35,18,0)
      HRR(35,19,1)=HRR(35,19,1)+VRR(35,19,0)
      HRR(35,20,1)=HRR(35,20,1)+VRR(35,20,0)
      HRR(35,21,1)=HRR(35,21,1)+VRR(35,21,0)
      HRR(35,22,1)=HRR(35,22,1)+VRR(35,22,0)
      HRR(35,23,1)=HRR(35,23,1)+VRR(35,23,0)
      HRR(35,24,1)=HRR(35,24,1)+VRR(35,24,0)
      HRR(35,25,1)=HRR(35,25,1)+VRR(35,25,0)
      HRR(35,26,1)=HRR(35,26,1)+VRR(35,26,0)
      HRR(35,27,1)=HRR(35,27,1)+VRR(35,27,0)
      HRR(35,28,1)=HRR(35,28,1)+VRR(35,28,0)
      HRR(35,29,1)=HRR(35,29,1)+VRR(35,29,0)
      HRR(35,30,1)=HRR(35,30,1)+VRR(35,30,0)
      HRR(35,31,1)=HRR(35,31,1)+VRR(35,31,0)
      HRR(35,32,1)=HRR(35,32,1)+VRR(35,32,0)
      HRR(35,33,1)=HRR(35,33,1)+VRR(35,33,0)
      HRR(35,34,1)=HRR(35,34,1)+VRR(35,34,0)
      HRR(35,35,1)=HRR(35,35,1)+VRR(35,35,0)
    END SUBROUTINE CNTRCT10266
