!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
    SUBROUTINE BraHRR1010ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR,HRRA,HRRB,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*),HRRA(*),HRRB(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(11_x,11|
      DUM=-3.D0*HRR(36)+&
                         ABx*(-9.D0*HRR(21)+&
                         ABx*(-9.D0*HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         3.D0*HRRA(36))+&
                         3.D0*HRRA(57))+&
                         HRRA(85)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,11_x|
      DUM=-3.D0*HRR(36)+&
                         ABx*(-6.D0*HRR(21)+&
                         ABx*(-3.D0*HRR(11)+&
                         ABx*(ABx*HRRB(11)+&
                         4.D0*HRRB(21))+&
                         6.D0*HRRB(36))+&
                         4.D0*HRRB(57))+&
                         HRRB(85)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(22)+&
                         3.D0*HRRA(37))+&
                         3.D0*HRRA(58))+&
                         HRRA(86)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,11_y|
      DUM=ABy*HRRB(57)+&
                         ABx*(3.D0*ABy*HRRB(36)+&
                         ABx*(3.D0*ABy*HRRB(21)+&
                         ABx*(ABy*HRRB(11)+&
                         HRRB(22))+&
                         3.D0*HRRB(37))+&
                         3.D0*HRRB(58))+&
                         HRRB(86)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(26)+&
                         3.D0*HRRA(42))+&
                         3.D0*HRRA(64))+&
                         HRRA(93)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,11_z|
      DUM=ABz*HRRB(57)+&
                         ABx*(3.D0*ABz*HRRB(36)+&
                         ABx*(3.D0*ABz*HRRB(21)+&
                         ABx*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         3.D0*HRRB(42))+&
                         3.D0*HRRB(64))+&
                         HRRB(93)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(12_x,11|
      DUM=-2.D0*HRR(37)+&
                         ABx*(-6.D0*HRR(22)+&
                         ABx*(-6.D0*HRR(12)+&
                         ABx*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         3.D0*HRRA(37))+&
                         3.D0*HRRA(58))+&
                         HRRA(86)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,11_x|
      DUM=-3.D0*HRR(37)+&
                         ABx*(-6.D0*HRR(22)+&
                         ABx*(-3.D0*HRR(12)+&
                         ABx*(ABx*HRRB(12)+&
                         4.D0*HRRB(22))+&
                         6.D0*HRRB(37))+&
                         4.D0*HRRB(58))+&
                         HRRB(86)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,11|
      DUM=-HRR(36)+&
                         ABx*(-3.D0*HRR(21)+&
                         ABx*(-3.D0*HRR(11)+&
                         ABx*(-HRR(5)+&
                         HRRA(23))+&
                         3.D0*HRRA(38))+&
                         3.D0*HRRA(59))+&
                         HRRA(87)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,11_y|
      DUM=ABy*HRRB(58)+&
                         ABx*(3.D0*ABy*HRRB(37)+&
                         ABx*(3.D0*ABy*HRRB(22)+&
                         ABx*(ABy*HRRB(12)+&
                         HRRB(23))+&
                         3.D0*HRRB(38))+&
                         3.D0*HRRB(59))+&
                         HRRB(87)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(27)+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,11_z|
      DUM=ABz*HRRB(58)+&
                         ABx*(3.D0*ABz*HRRB(37)+&
                         ABx*(3.D0*ABz*HRRB(22)+&
                         ABx*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(13_x,11|
      DUM=-HRR(38)+&
                         ABx*(-3.D0*HRR(23)+&
                         ABx*(-3.D0*HRR(13)+&
                         ABx*(-HRR(7)+&
                         HRRA(23))+&
                         3.D0*HRRA(38))+&
                         3.D0*HRRA(59))+&
                         HRRA(87)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,11_x|
      DUM=-3.D0*HRR(38)+&
                         ABx*(-6.D0*HRR(23)+&
                         ABx*(-3.D0*HRR(13)+&
                         ABx*(ABx*HRRB(13)+&
                         4.D0*HRRB(23))+&
                         6.D0*HRRB(38))+&
                         4.D0*HRRB(59))+&
                         HRRB(87)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,11|
      DUM=-2.D0*HRR(37)+&
                         ABx*(-6.D0*HRR(22)+&
                         ABx*(-6.D0*HRR(12)+&
                         ABx*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         3.D0*HRRA(39))+&
                         3.D0*HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,11_y|
      DUM=ABy*HRRB(59)+&
                         ABx*(3.D0*ABy*HRRB(38)+&
                         ABx*(3.D0*ABy*HRRB(23)+&
                         ABx*(ABy*HRRB(13)+&
                         HRRB(24))+&
                         3.D0*HRRB(39))+&
                         3.D0*HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(28)+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,11_z|
      DUM=ABz*HRRB(59)+&
                         ABx*(3.D0*ABz*HRRB(38)+&
                         ABx*(3.D0*ABz*HRRB(23)+&
                         ABx*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(14_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(24)+&
                         3.D0*HRRA(39))+&
                         3.D0*HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,11_x|
      DUM=-3.D0*HRR(39)+&
                         ABx*(-6.D0*HRR(24)+&
                         ABx*(-3.D0*HRR(14)+&
                         ABx*(ABx*HRRB(14)+&
                         4.D0*HRRB(24))+&
                         6.D0*HRRB(39))+&
                         4.D0*HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,11|
      DUM=-3.D0*HRR(38)+&
                         ABx*(-9.D0*HRR(23)+&
                         ABx*(-9.D0*HRR(13)+&
                         ABx*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         3.D0*HRRA(40))+&
                         3.D0*HRRA(61))+&
                         HRRA(89)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,11_y|
      DUM=ABy*HRRB(60)+&
                         ABx*(3.D0*ABy*HRRB(39)+&
                         ABx*(3.D0*ABy*HRRB(24)+&
                         ABx*(ABy*HRRB(14)+&
                         HRRB(25))+&
                         3.D0*HRRB(40))+&
                         3.D0*HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(29)+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,11_z|
      DUM=ABz*HRRB(60)+&
                         ABx*(3.D0*ABz*HRRB(39)+&
                         ABx*(3.D0*ABz*HRRB(24)+&
                         ABx*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(15_x,11|
      DUM=-2.D0*HRR(42)+&
                         ABx*(-6.D0*HRR(26)+&
                         ABx*(-6.D0*HRR(15)+&
                         ABx*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         3.D0*HRRA(42))+&
                         3.D0*HRRA(64))+&
                         HRRA(93)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,11_x|
      DUM=-3.D0*HRR(42)+&
                         ABx*(-6.D0*HRR(26)+&
                         ABx*(-3.D0*HRR(15)+&
                         ABx*(ABx*HRRB(15)+&
                         4.D0*HRRB(26))+&
                         6.D0*HRRB(42))+&
                         4.D0*HRRB(64))+&
                         HRRB(93)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(27)+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,11_y|
      DUM=ABy*HRRB(64)+&
                         ABx*(3.D0*ABy*HRRB(42)+&
                         ABx*(3.D0*ABy*HRRB(26)+&
                         ABx*(ABy*HRRB(15)+&
                         HRRB(27))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,11|
      DUM=-HRR(36)+&
                         ABx*(-3.D0*HRR(21)+&
                         ABx*(-3.D0*HRR(11)+&
                         ABx*(-HRR(5)+&
                         HRRA(30))+&
                         3.D0*HRRA(47))+&
                         3.D0*HRRA(70))+&
                         HRRA(100)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,11_z|
      DUM=ABz*HRRB(64)+&
                         ABx*(3.D0*ABz*HRRB(42)+&
                         ABx*(3.D0*ABz*HRRB(26)+&
                         ABx*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         3.D0*HRRB(47))+&
                         3.D0*HRRB(70))+&
                         HRRB(100)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(16_x,11|
      DUM=-HRR(43)+&
                         ABx*(-3.D0*HRR(27)+&
                         ABx*(-3.D0*HRR(16)+&
                         ABx*(-HRR(9)+&
                         HRRA(27))+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,11_x|
      DUM=-3.D0*HRR(43)+&
                         ABx*(-6.D0*HRR(27)+&
                         ABx*(-3.D0*HRR(16)+&
                         ABx*(ABx*HRRB(16)+&
                         4.D0*HRRB(27))+&
                         6.D0*HRRB(43))+&
                         4.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,11|
      DUM=-HRR(42)+&
                         ABx*(-3.D0*HRR(26)+&
                         ABx*(-3.D0*HRR(15)+&
                         ABx*(-HRR(8)+&
                         HRRA(28))+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,11_y|
      DUM=ABy*HRRB(65)+&
                         ABx*(3.D0*ABy*HRRB(43)+&
                         ABx*(3.D0*ABy*HRRB(27)+&
                         ABx*(ABy*HRRB(16)+&
                         HRRB(28))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,11|
      DUM=-HRR(37)+&
                         ABx*(-3.D0*HRR(22)+&
                         ABx*(-3.D0*HRR(12)+&
                         ABx*(-HRR(6)+&
                         HRRA(31))+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,11_z|
      DUM=ABz*HRRB(65)+&
                         ABx*(3.D0*ABz*HRRB(43)+&
                         ABx*(3.D0*ABz*HRRB(27)+&
                         ABx*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(17_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(28)+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,11_x|
      DUM=-3.D0*HRR(44)+&
                         ABx*(-6.D0*HRR(28)+&
                         ABx*(-3.D0*HRR(17)+&
                         ABx*(ABx*HRRB(17)+&
                         4.D0*HRRB(28))+&
                         6.D0*HRRB(44))+&
                         4.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,11|
      DUM=-2.D0*HRR(43)+&
                         ABx*(-6.D0*HRR(27)+&
                         ABx*(-6.D0*HRR(16)+&
                         ABx*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,11_y|
      DUM=ABy*HRRB(66)+&
                         ABx*(3.D0*ABy*HRRB(44)+&
                         ABx*(3.D0*ABy*HRRB(28)+&
                         ABx*(ABy*HRRB(17)+&
                         HRRB(29))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,11|
      DUM=-HRR(38)+&
                         ABx*(-3.D0*HRR(23)+&
                         ABx*(-3.D0*HRR(13)+&
                         ABx*(-HRR(7)+&
                         HRRA(32))+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,11_z|
      DUM=ABz*HRRB(66)+&
                         ABx*(3.D0*ABz*HRRB(44)+&
                         ABx*(3.D0*ABz*HRRB(28)+&
                         ABx*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(18_x,11|
      DUM=-HRR(47)+&
                         ABx*(-3.D0*HRR(30)+&
                         ABx*(-3.D0*HRR(18)+&
                         ABx*(-HRR(10)+&
                         HRRA(30))+&
                         3.D0*HRRA(47))+&
                         3.D0*HRRA(70))+&
                         HRRA(100)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,11_x|
      DUM=-3.D0*HRR(47)+&
                         ABx*(-6.D0*HRR(30)+&
                         ABx*(-3.D0*HRR(18)+&
                         ABx*(ABx*HRRB(18)+&
                         4.D0*HRRB(30))+&
                         6.D0*HRRB(47))+&
                         4.D0*HRRB(70))+&
                         HRRB(100)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(31)+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,11_y|
      DUM=ABy*HRRB(70)+&
                         ABx*(3.D0*ABy*HRRB(47)+&
                         ABx*(3.D0*ABy*HRRB(30)+&
                         ABx*(ABy*HRRB(18)+&
                         HRRB(31))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,11|
      DUM=-2.D0*HRR(42)+&
                         ABx*(-6.D0*HRR(26)+&
                         ABx*(-6.D0*HRR(15)+&
                         ABx*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         3.D0*HRRA(51))+&
                         3.D0*HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,11_z|
      DUM=ABz*HRRB(70)+&
                         ABx*(3.D0*ABz*HRRB(47)+&
                         ABx*(3.D0*ABz*HRRB(30)+&
                         ABx*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         3.D0*HRRB(51))+&
                         3.D0*HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(19_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(31)+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,11_x|
      DUM=-3.D0*HRR(48)+&
                         ABx*(-6.D0*HRR(31)+&
                         ABx*(-3.D0*HRR(19)+&
                         ABx*(ABx*HRRB(19)+&
                         4.D0*HRRB(31))+&
                         6.D0*HRRB(48))+&
                         4.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,11|
      DUM=-HRR(47)+&
                         ABx*(-3.D0*HRR(30)+&
                         ABx*(-3.D0*HRR(18)+&
                         ABx*(-HRR(10)+&
                         HRRA(32))+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,11_y|
      DUM=ABy*HRRB(71)+&
                         ABx*(3.D0*ABy*HRRB(48)+&
                         ABx*(3.D0*ABy*HRRB(31)+&
                         ABx*(ABy*HRRB(19)+&
                         HRRB(32))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,11|
      DUM=-2.D0*HRR(43)+&
                         ABx*(-6.D0*HRR(27)+&
                         ABx*(-6.D0*HRR(16)+&
                         ABx*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,11_z|
      DUM=ABz*HRRB(71)+&
                         ABx*(3.D0*ABz*HRRB(48)+&
                         ABx*(3.D0*ABz*HRRB(31)+&
                         ABx*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(20_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(33)+&
                         3.D0*HRRA(51))+&
                         3.D0*HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,11_x|
      DUM=-3.D0*HRR(51)+&
                         ABx*(-6.D0*HRR(33)+&
                         ABx*(-3.D0*HRR(20)+&
                         ABx*(ABx*HRRB(20)+&
                         4.D0*HRRB(33))+&
                         6.D0*HRRB(51))+&
                         4.D0*HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(34)+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,11_y|
      DUM=ABy*HRRB(75)+&
                         ABx*(3.D0*ABy*HRRB(51)+&
                         ABx*(3.D0*ABy*HRRB(33)+&
                         ABx*(ABy*HRRB(20)+&
                         HRRB(34))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,11|
      DUM=-3.D0*HRR(47)+&
                         ABx*(-9.D0*HRR(30)+&
                         ABx*(-9.D0*HRR(18)+&
                         ABx*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         3.D0*HRRA(54))+&
                         3.D0*HRRA(79))+&
                         HRRA(111)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,11_z|
      DUM=ABz*HRRB(75)+&
                         ABx*(3.D0*ABz*HRRB(51)+&
                         ABx*(3.D0*ABz*HRRB(33)+&
                         ABx*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         3.D0*HRRB(54))+&
                         3.D0*HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(11_x,12|
      DUM=-3.D0*HRR(37)+&
                         ABy*(-3.D0*HRR(21)+&
                         HRRA(57))+&
                         ABx*(-6.D0*HRR(22)+&
                         ABy*(-6.D0*HRR(11)+&
                         2.D0*HRRA(36))+&
                         ABx*(-3.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(37))+&
                         2.D0*HRRA(58))+&
                         HRRA(86)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,12_x|
      DUM=-2.D0*HRR(37)+&
                         ABy*(-2.D0*HRR(21)+&
                         HRRB(57))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         3.D0*HRRB(36))+&
                         ABx*(3.D0*ABy*HRRB(21)+&
                         ABx*(ABy*HRRB(11)+&
                         HRRB(22))+&
                         3.D0*HRRB(37))+&
                         3.D0*HRRB(58))+&
                         HRRB(86)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,12|
      DUM=ABy*HRRA(58)+&
                         ABx*(2.D0*ABy*HRRA(37)+&
                         ABx*(ABy*HRRA(22)+&
                         HRRA(38))+&
                         2.D0*HRRA(59))+&
                         HRRA(87)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,12_y|
      DUM=-HRR(36)+&
                         ABy*(ABy*HRRB(36)+&
                         2.D0*HRRB(58))+&
                         ABx*(-2.D0*HRR(21)+&
                         ABy*(2.D0*ABy*HRRB(21)+&
                         4.D0*HRRB(37))+&
                         ABx*(-HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         2.D0*HRRB(22))+&
                         HRRB(38))+&
                         2.D0*HRRB(59))+&
                         HRRB(87)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,12|
      DUM=ABy*HRRA(64)+&
                         ABx*(2.D0*ABy*HRRA(42)+&
                         ABx*(ABy*HRRA(26)+&
                         HRRA(43))+&
                         2.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,12_z|
      DUM=ABz*HRRB(58)+&
                         ABy*(ABz*HRRB(36)+&
                         HRRB(64))+&
                         ABx*(2.D0*ABz*HRRB(37)+&
                         ABy*(2.D0*ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         2.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(12_x,12|
      DUM=-2.D0*HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         HRRA(58))+&
                         ABx*(-4.D0*HRR(23)+&
                         ABy*(-4.D0*HRR(12)+&
                         2.D0*HRRA(37))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(38))+&
                         2.D0*HRRA(59))+&
                         HRRA(87)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,12_x|
      DUM=-2.D0*HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         HRRB(58))+&
                         ABx*(-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         3.D0*HRRB(37))+&
                         ABx*(3.D0*ABy*HRRB(22)+&
                         ABx*(ABy*HRRB(12)+&
                         HRRB(23))+&
                         3.D0*HRRB(38))+&
                         3.D0*HRRB(59))+&
                         HRRB(87)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,12|
      DUM=-HRR(37)+&
                         ABy*(-HRR(21)+&
                         HRRA(59))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         2.D0*HRRA(38))+&
                         ABx*(-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(39))+&
                         2.D0*HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,12_y|
      DUM=-HRR(37)+&
                         ABy*(ABy*HRRB(37)+&
                         2.D0*HRRB(59))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABy*(2.D0*ABy*HRRB(22)+&
                         4.D0*HRRB(38))+&
                         ABx*(-HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         2.D0*HRRB(23))+&
                         HRRB(39))+&
                         2.D0*HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,12|
      DUM=ABy*HRRA(65)+&
                         ABx*(2.D0*ABy*HRRA(43)+&
                         ABx*(ABy*HRRA(27)+&
                         HRRA(44))+&
                         2.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,12_z|
      DUM=ABz*HRRB(59)+&
                         ABy*(ABz*HRRB(37)+&
                         HRRB(65))+&
                         ABx*(2.D0*ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         2.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(13_x,12|
      DUM=-HRR(39)+&
                         ABy*(-HRR(23)+&
                         HRRA(59))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         2.D0*HRRA(38))+&
                         ABx*(-HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(39))+&
                         2.D0*HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,12_x|
      DUM=-2.D0*HRR(39)+&
                         ABy*(-2.D0*HRR(23)+&
                         HRRB(59))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         3.D0*HRRB(38))+&
                         ABx*(3.D0*ABy*HRRB(23)+&
                         ABx*(ABy*HRRB(13)+&
                         HRRB(24))+&
                         3.D0*HRRB(39))+&
                         3.D0*HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,12|
      DUM=-2.D0*HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         HRRA(60))+&
                         ABx*(-4.D0*HRR(23)+&
                         ABy*(-4.D0*HRR(12)+&
                         2.D0*HRRA(39))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(40))+&
                         2.D0*HRRA(61))+&
                         HRRA(89)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,12_y|
      DUM=-HRR(38)+&
                         ABy*(ABy*HRRB(38)+&
                         2.D0*HRRB(60))+&
                         ABx*(-2.D0*HRR(23)+&
                         ABy*(2.D0*ABy*HRRB(23)+&
                         4.D0*HRRB(39))+&
                         ABx*(-HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         2.D0*HRRB(24))+&
                         HRRB(40))+&
                         2.D0*HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,12|
      DUM=ABy*HRRA(66)+&
                         ABx*(2.D0*ABy*HRRA(44)+&
                         ABx*(ABy*HRRA(28)+&
                         HRRA(45))+&
                         2.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,12_z|
      DUM=ABz*HRRB(60)+&
                         ABy*(ABz*HRRB(38)+&
                         HRRB(66))+&
                         ABx*(2.D0*ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         2.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(14_x,12|
      DUM=ABy*HRRA(60)+&
                         ABx*(2.D0*ABy*HRRA(39)+&
                         ABx*(ABy*HRRA(24)+&
                         HRRA(40))+&
                         2.D0*HRRA(61))+&
                         HRRA(89)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,12_x|
      DUM=-2.D0*HRR(40)+&
                         ABy*(-2.D0*HRR(24)+&
                         HRRB(60))+&
                         ABx*(-2.D0*HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         3.D0*HRRB(39))+&
                         ABx*(3.D0*ABy*HRRB(24)+&
                         ABx*(ABy*HRRB(14)+&
                         HRRB(25))+&
                         3.D0*HRRB(40))+&
                         3.D0*HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,12|
      DUM=-3.D0*HRR(39)+&
                         ABy*(-3.D0*HRR(23)+&
                         HRRA(61))+&
                         ABx*(-6.D0*HRR(24)+&
                         ABy*(-6.D0*HRR(13)+&
                         2.D0*HRRA(40))+&
                         ABx*(-3.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(41))+&
                         2.D0*HRRA(62))+&
                         HRRA(90)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,12_y|
      DUM=-HRR(39)+&
                         ABy*(ABy*HRRB(39)+&
                         2.D0*HRRB(61))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(2.D0*ABy*HRRB(24)+&
                         4.D0*HRRB(40))+&
                         ABx*(-HRR(14)+&
                         ABy*(ABy*HRRB(14)+&
                         2.D0*HRRB(25))+&
                         HRRB(41))+&
                         2.D0*HRRB(62))+&
                         HRRB(90)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,12|
      DUM=ABy*HRRA(67)+&
                         ABx*(2.D0*ABy*HRRA(45)+&
                         ABx*(ABy*HRRA(29)+&
                         HRRA(46))+&
                         2.D0*HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,12_z|
      DUM=ABz*HRRB(61)+&
                         ABy*(ABz*HRRB(39)+&
                         HRRB(67))+&
                         ABx*(2.D0*ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         2.D0*HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(15_x,12|
      DUM=-2.D0*HRR(43)+&
                         ABy*(-2.D0*HRR(26)+&
                         HRRA(64))+&
                         ABx*(-4.D0*HRR(27)+&
                         ABy*(-4.D0*HRR(15)+&
                         2.D0*HRRA(42))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(43))+&
                         2.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,12_x|
      DUM=-2.D0*HRR(43)+&
                         ABy*(-2.D0*HRR(26)+&
                         HRRB(64))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         3.D0*HRRB(42))+&
                         ABx*(3.D0*ABy*HRRB(26)+&
                         ABx*(ABy*HRRB(15)+&
                         HRRB(27))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,12|
      DUM=ABy*HRRA(65)+&
                         ABx*(2.D0*ABy*HRRA(43)+&
                         ABx*(ABy*HRRA(27)+&
                         HRRA(44))+&
                         2.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,12_y|
      DUM=-HRR(42)+&
                         ABy*(ABy*HRRB(42)+&
                         2.D0*HRRB(65))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABy*(2.D0*ABy*HRRB(26)+&
                         4.D0*HRRB(43))+&
                         ABx*(-HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         2.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,12|
      DUM=-HRR(37)+&
                         ABy*(-HRR(21)+&
                         HRRA(70))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         2.D0*HRRA(47))+&
                         ABx*(-HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(48))+&
                         2.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,12_z|
      DUM=ABz*HRRB(65)+&
                         ABy*(ABz*HRRB(42)+&
                         HRRB(70))+&
                         ABx*(2.D0*ABz*HRRB(43)+&
                         ABy*(2.D0*ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         2.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(16_x,12|
      DUM=-HRR(44)+&
                         ABy*(-HRR(27)+&
                         HRRA(65))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         2.D0*HRRA(43))+&
                         ABx*(-HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(44))+&
                         2.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,12_x|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         HRRB(65))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         3.D0*HRRB(43))+&
                         ABx*(3.D0*ABy*HRRB(27)+&
                         ABx*(ABy*HRRB(16)+&
                         HRRB(28))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,12|
      DUM=-HRR(43)+&
                         ABy*(-HRR(26)+&
                         HRRA(66))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         2.D0*HRRA(44))+&
                         ABx*(-HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(45))+&
                         2.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,12_y|
      DUM=-HRR(43)+&
                         ABy*(ABy*HRRB(43)+&
                         2.D0*HRRB(66))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABy*(2.D0*ABy*HRRB(27)+&
                         4.D0*HRRB(44))+&
                         ABx*(-HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         2.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,12|
      DUM=-HRR(38)+&
                         ABy*(-HRR(22)+&
                         HRRA(71))+&
                         ABx*(-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         2.D0*HRRA(48))+&
                         ABx*(-HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,12_z|
      DUM=ABz*HRRB(66)+&
                         ABy*(ABz*HRRB(43)+&
                         HRRB(71))+&
                         ABx*(2.D0*ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(17_x,12|
      DUM=ABy*HRRA(66)+&
                         ABx*(2.D0*ABy*HRRA(44)+&
                         ABx*(ABy*HRRA(28)+&
                         HRRA(45))+&
                         2.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,12_x|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-2.D0*HRR(28)+&
                         HRRB(66))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         3.D0*HRRB(44))+&
                         ABx*(3.D0*ABy*HRRB(28)+&
                         ABx*(ABy*HRRB(17)+&
                         HRRB(29))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,12|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         HRRA(67))+&
                         ABx*(-4.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         2.D0*HRRA(45))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(46))+&
                         2.D0*HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,12_y|
      DUM=-HRR(44)+&
                         ABy*(ABy*HRRB(44)+&
                         2.D0*HRRB(67))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(2.D0*ABy*HRRB(28)+&
                         4.D0*HRRB(45))+&
                         ABx*(-HRR(17)+&
                         ABy*(ABy*HRRB(17)+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         2.D0*HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,12|
      DUM=-HRR(39)+&
                         ABy*(-HRR(23)+&
                         HRRA(72))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(50))+&
                         2.D0*HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,12_z|
      DUM=ABz*HRRB(67)+&
                         ABy*(ABz*HRRB(44)+&
                         HRRB(72))+&
                         ABx*(2.D0*ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(18_x,12|
      DUM=-HRR(48)+&
                         ABy*(-HRR(30)+&
                         HRRA(70))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         2.D0*HRRA(47))+&
                         ABx*(-HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(48))+&
                         2.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,12_x|
      DUM=-2.D0*HRR(48)+&
                         ABy*(-2.D0*HRR(30)+&
                         HRRB(70))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         3.D0*HRRB(47))+&
                         ABx*(3.D0*ABy*HRRB(30)+&
                         ABx*(ABy*HRRB(18)+&
                         HRRB(31))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,12|
      DUM=ABy*HRRA(71)+&
                         ABx*(2.D0*ABy*HRRA(48)+&
                         ABx*(ABy*HRRA(31)+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,12_y|
      DUM=-HRR(47)+&
                         ABy*(ABy*HRRB(47)+&
                         2.D0*HRRB(71))+&
                         ABx*(-2.D0*HRR(30)+&
                         ABy*(2.D0*ABy*HRRB(30)+&
                         4.D0*HRRB(48))+&
                         ABx*(-HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,12|
      DUM=-2.D0*HRR(43)+&
                         ABy*(-2.D0*HRR(26)+&
                         HRRA(75))+&
                         ABx*(-4.D0*HRR(27)+&
                         ABy*(-4.D0*HRR(15)+&
                         2.D0*HRRA(51))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(52))+&
                         2.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,12_z|
      DUM=ABz*HRRB(71)+&
                         ABy*(ABz*HRRB(47)+&
                         HRRB(75))+&
                         ABx*(2.D0*ABz*HRRB(48)+&
                         ABy*(2.D0*ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         2.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(19_x,12|
      DUM=ABy*HRRA(71)+&
                         ABx*(2.D0*ABy*HRRA(48)+&
                         ABx*(ABy*HRRA(31)+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,12_x|
      DUM=-2.D0*HRR(49)+&
                         ABy*(-2.D0*HRR(31)+&
                         HRRB(71))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         3.D0*HRRB(48))+&
                         ABx*(3.D0*ABy*HRRB(31)+&
                         ABx*(ABy*HRRB(19)+&
                         HRRB(32))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,12|
      DUM=-HRR(48)+&
                         ABy*(-HRR(30)+&
                         HRRA(72))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(50))+&
                         2.D0*HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,12_y|
      DUM=-HRR(48)+&
                         ABy*(ABy*HRRB(48)+&
                         2.D0*HRRB(72))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABy*(2.D0*ABy*HRRB(31)+&
                         4.D0*HRRB(49))+&
                         ABx*(-HRR(19)+&
                         ABy*(ABy*HRRB(19)+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,12|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         HRRA(76))+&
                         ABx*(-4.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         2.D0*HRRA(52))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(53))+&
                         2.D0*HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,12_z|
      DUM=ABz*HRRB(72)+&
                         ABy*(ABz*HRRB(48)+&
                         HRRB(76))+&
                         ABx*(2.D0*ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(20_x,12|
      DUM=ABy*HRRA(75)+&
                         ABx*(2.D0*ABy*HRRA(51)+&
                         ABx*(ABy*HRRA(33)+&
                         HRRA(52))+&
                         2.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,12_x|
      DUM=-2.D0*HRR(52)+&
                         ABy*(-2.D0*HRR(33)+&
                         HRRB(75))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABy*(-2.D0*HRR(20)+&
                         3.D0*HRRB(51))+&
                         ABx*(3.D0*ABy*HRRB(33)+&
                         ABx*(ABy*HRRB(20)+&
                         HRRB(34))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,12|
      DUM=ABy*HRRA(76)+&
                         ABx*(2.D0*ABy*HRRA(52)+&
                         ABx*(ABy*HRRA(34)+&
                         HRRA(53))+&
                         2.D0*HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,12_y|
      DUM=-HRR(51)+&
                         ABy*(ABy*HRRB(51)+&
                         2.D0*HRRB(76))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABy*(2.D0*ABy*HRRB(33)+&
                         4.D0*HRRB(52))+&
                         ABx*(-HRR(20)+&
                         ABy*(ABy*HRRB(20)+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,12|
      DUM=-3.D0*HRR(48)+&
                         ABy*(-3.D0*HRR(30)+&
                         HRRA(79))+&
                         ABx*(-6.D0*HRR(31)+&
                         ABy*(-6.D0*HRR(18)+&
                         2.D0*HRRA(54))+&
                         ABx*(-3.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(55))+&
                         2.D0*HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,12_z|
      DUM=ABz*HRRB(76)+&
                         ABy*(ABz*HRRB(51)+&
                         HRRB(79))+&
                         ABx*(2.D0*ABz*HRRB(52)+&
                         ABy*(2.D0*ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         2.D0*HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(11_x,13|
      DUM=-3.D0*HRR(38)+&
                         ABy*(-6.D0*HRR(22)+&
                         ABy*(-3.D0*HRR(11)+&
                         HRRA(36))+&
                         2.D0*HRRA(58))+&
                         ABx*(-3.D0*HRR(23)+&
                         ABy*(-6.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(37))+&
                         HRRA(59))+&
                         HRRA(87)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,13_x|
      DUM=-HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRB(36))+&
                         2.D0*HRRB(58))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(21)+&
                         4.D0*HRRB(37))+&
                         ABx*(ABy*(ABy*HRRB(11)+&
                         2.D0*HRRB(22))+&
                         HRRB(38))+&
                         2.D0*HRRB(59))+&
                         HRRB(87)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,13|
      DUM=ABy*(ABy*HRRA(37)+&
                         2.D0*HRRA(59))+&
                         ABx*(ABy*(ABy*HRRA(22)+&
                         2.D0*HRRA(38))+&
                         HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,13_y|
      DUM=-2.D0*HRR(37)+&
                         ABy*(-2.D0*HRR(21)+&
                         ABy*(ABy*HRRB(21)+&
                         3.D0*HRRB(37))+&
                         3.D0*HRRB(59))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(38))+&
                         HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,13|
      DUM=ABy*(ABy*HRRA(42)+&
                         2.D0*HRRA(65))+&
                         ABx*(ABy*(ABy*HRRA(26)+&
                         2.D0*HRRA(43))+&
                         HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,13_z|
      DUM=ABz*HRRB(59)+&
                         ABy*(2.D0*ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         2.D0*HRRB(65))+&
                         ABx*(ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(12_x,13|
      DUM=-2.D0*HRR(39)+&
                         ABy*(-4.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         2.D0*HRRA(59))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-4.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(38))+&
                         HRRA(60))+&
                         HRRA(88)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,13_x|
      DUM=-HRR(39)+&
                         ABy*(-2.D0*HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRB(37))+&
                         2.D0*HRRB(59))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(22)+&
                         4.D0*HRRB(38))+&
                         ABx*(ABy*(ABy*HRRB(12)+&
                         2.D0*HRRB(23))+&
                         HRRB(39))+&
                         2.D0*HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,13|
      DUM=-HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(38))+&
                         2.D0*HRRA(60))+&
                         ABx*(-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(39))+&
                         HRRA(61))+&
                         HRRA(89)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,13_y|
      DUM=-2.D0*HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         ABy*(ABy*HRRB(22)+&
                         3.D0*HRRB(38))+&
                         3.D0*HRRB(60))+&
                         ABx*(-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(39))+&
                         HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,13|
      DUM=ABy*(ABy*HRRA(43)+&
                         2.D0*HRRA(66))+&
                         ABx*(ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,13_z|
      DUM=ABz*HRRB(60)+&
                         ABy*(2.D0*ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         2.D0*HRRB(66))+&
                         ABx*(ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(13_x,13|
      DUM=-HRR(40)+&
                         ABy*(-2.D0*HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRA(38))+&
                         2.D0*HRRA(60))+&
                         ABx*(-HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(39))+&
                         HRRA(61))+&
                         HRRA(89)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,13_x|
      DUM=-HRR(40)+&
                         ABy*(-2.D0*HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRB(38))+&
                         2.D0*HRRB(60))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(23)+&
                         4.D0*HRRB(39))+&
                         ABx*(ABy*(ABy*HRRB(13)+&
                         2.D0*HRRB(24))+&
                         HRRB(40))+&
                         2.D0*HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,13|
      DUM=-2.D0*HRR(39)+&
                         ABy*(-4.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         2.D0*HRRA(61))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-4.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(40))+&
                         HRRA(62))+&
                         HRRA(90)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,13_y|
      DUM=-2.D0*HRR(39)+&
                         ABy*(-2.D0*HRR(23)+&
                         ABy*(ABy*HRRB(23)+&
                         3.D0*HRRB(39))+&
                         3.D0*HRRB(61))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(40))+&
                         HRRB(62))+&
                         HRRB(90)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,13|
      DUM=ABy*(ABy*HRRA(44)+&
                         2.D0*HRRA(67))+&
                         ABx*(ABy*(ABy*HRRA(28)+&
                         2.D0*HRRA(45))+&
                         HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,13_z|
      DUM=ABz*HRRB(61)+&
                         ABy*(2.D0*ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         2.D0*HRRB(67))+&
                         ABx*(ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(14_x,13|
      DUM=ABy*(ABy*HRRA(39)+&
                         2.D0*HRRA(61))+&
                         ABx*(ABy*(ABy*HRRA(24)+&
                         2.D0*HRRA(40))+&
                         HRRA(62))+&
                         HRRA(90)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,13_x|
      DUM=-HRR(41)+&
                         ABy*(-2.D0*HRR(25)+&
                         ABy*(-HRR(14)+&
                         HRRB(39))+&
                         2.D0*HRRB(61))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(24)+&
                         4.D0*HRRB(40))+&
                         ABx*(ABy*(ABy*HRRB(14)+&
                         2.D0*HRRB(25))+&
                         HRRB(41))+&
                         2.D0*HRRB(62))+&
                         HRRB(90)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,13|
      DUM=-3.D0*HRR(40)+&
                         ABy*(-6.D0*HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         HRRA(40))+&
                         2.D0*HRRA(62))+&
                         ABx*(-3.D0*HRR(25)+&
                         ABy*(-6.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(41))+&
                         HRRA(63))+&
                         HRRA(91)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,13_y|
      DUM=-2.D0*HRR(40)+&
                         ABy*(-2.D0*HRR(24)+&
                         ABy*(ABy*HRRB(24)+&
                         3.D0*HRRB(40))+&
                         3.D0*HRRB(62))+&
                         ABx*(-2.D0*HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(ABy*HRRB(14)+&
                         3.D0*HRRB(25))+&
                         3.D0*HRRB(41))+&
                         HRRB(63))+&
                         HRRB(91)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,13|
      DUM=ABy*(ABy*HRRA(45)+&
                         2.D0*HRRA(68))+&
                         ABx*(ABy*(ABy*HRRA(29)+&
                         2.D0*HRRA(46))+&
                         HRRA(69))+&
                         HRRA(98)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,13_z|
      DUM=ABz*HRRB(62)+&
                         ABy*(2.D0*ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         2.D0*HRRB(68))+&
                         ABx*(ABz*HRRB(41)+&
                         ABy*(2.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(46))+&
                         HRRB(69))+&
                         HRRB(98)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(15_x,13|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-4.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRA(42))+&
                         2.D0*HRRA(65))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(43))+&
                         HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,13_x|
      DUM=-HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRB(42))+&
                         2.D0*HRRB(65))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(26)+&
                         4.D0*HRRB(43))+&
                         ABx*(ABy*(ABy*HRRB(15)+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         2.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,13|
      DUM=ABy*(ABy*HRRA(43)+&
                         2.D0*HRRA(66))+&
                         ABx*(ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,13_y|
      DUM=-2.D0*HRR(43)+&
                         ABy*(-2.D0*HRR(26)+&
                         ABy*(ABy*HRRB(26)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(66))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,13|
      DUM=-HRR(38)+&
                         ABy*(-2.D0*HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(47))+&
                         2.D0*HRRA(71))+&
                         ABx*(-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,13_z|
      DUM=ABz*HRRB(66)+&
                         ABy*(2.D0*ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         ABx*(ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(16_x,13|
      DUM=-HRR(45)+&
                         ABy*(-2.D0*HRR(28)+&
                         ABy*(-HRR(16)+&
                         HRRA(43))+&
                         2.D0*HRRA(66))+&
                         ABx*(-HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(44))+&
                         HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,13_x|
      DUM=-HRR(45)+&
                         ABy*(-2.D0*HRR(28)+&
                         ABy*(-HRR(16)+&
                         HRRB(43))+&
                         2.D0*HRRB(66))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(27)+&
                         4.D0*HRRB(44))+&
                         ABx*(ABy*(ABy*HRRB(16)+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         2.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,13|
      DUM=-HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRA(44))+&
                         2.D0*HRRA(67))+&
                         ABx*(-HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(45))+&
                         HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,13_y|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-2.D0*HRR(27)+&
                         ABy*(ABy*HRRB(27)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(67))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,13|
      DUM=-HRR(39)+&
                         ABy*(-2.D0*HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRA(48))+&
                         2.D0*HRRA(72))+&
                         ABx*(-HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,13_z|
      DUM=ABz*HRRB(67)+&
                         ABy*(2.D0*ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         ABx*(ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(17_x,13|
      DUM=ABy*(ABy*HRRA(44)+&
                         2.D0*HRRA(67))+&
                         ABx*(ABy*(ABy*HRRA(28)+&
                         2.D0*HRRA(45))+&
                         HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,13_x|
      DUM=-HRR(46)+&
                         ABy*(-2.D0*HRR(29)+&
                         ABy*(-HRR(17)+&
                         HRRB(44))+&
                         2.D0*HRRB(67))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(28)+&
                         4.D0*HRRB(45))+&
                         ABx*(ABy*(ABy*HRRB(17)+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         2.D0*HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,13|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-4.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         HRRA(45))+&
                         2.D0*HRRA(68))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABy*(-4.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(46))+&
                         HRRA(69))+&
                         HRRA(98)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,13_y|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-2.D0*HRR(28)+&
                         ABy*(ABy*HRRB(28)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(68))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         ABy*(ABy*HRRB(17)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(46))+&
                         HRRB(69))+&
                         HRRB(98)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,13|
      DUM=-HRR(40)+&
                         ABy*(-2.D0*HRR(24)+&
                         ABy*(-HRR(13)+&
                         HRRA(49))+&
                         2.D0*HRRA(73))+&
                         ABx*(-HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74))+&
                         HRRA(104)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,13_z|
      DUM=ABz*HRRB(68)+&
                         ABy*(2.D0*ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         2.D0*HRRB(73))+&
                         ABx*(ABz*HRRB(46)+&
                         ABy*(2.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(18_x,13|
      DUM=-HRR(49)+&
                         ABy*(-2.D0*HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRA(47))+&
                         2.D0*HRRA(71))+&
                         ABx*(-HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,13_x|
      DUM=-HRR(49)+&
                         ABy*(-2.D0*HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(30)+&
                         4.D0*HRRB(48))+&
                         ABx*(ABy*(ABy*HRRB(18)+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,13|
      DUM=ABy*(ABy*HRRA(48)+&
                         2.D0*HRRA(72))+&
                         ABx*(ABy*(ABy*HRRA(31)+&
                         2.D0*HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,13_y|
      DUM=-2.D0*HRR(48)+&
                         ABy*(-2.D0*HRR(30)+&
                         ABy*(ABy*HRRB(30)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(72))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,13|
      DUM=-2.D0*HRR(44)+&
                         ABy*(-4.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         2.D0*HRRA(76))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(52))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,13_z|
      DUM=ABz*HRRB(72)+&
                         ABy*(2.D0*ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         ABx*(ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(19_x,13|
      DUM=ABy*(ABy*HRRA(48)+&
                         2.D0*HRRA(72))+&
                         ABx*(ABy*(ABy*HRRA(31)+&
                         2.D0*HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,13_x|
      DUM=-HRR(50)+&
                         ABy*(-2.D0*HRR(32)+&
                         ABy*(-HRR(19)+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(31)+&
                         4.D0*HRRB(49))+&
                         ABx*(ABy*(ABy*HRRB(19)+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,13|
      DUM=-HRR(49)+&
                         ABy*(-2.D0*HRR(31)+&
                         ABy*(-HRR(18)+&
                         HRRA(49))+&
                         2.D0*HRRA(73))+&
                         ABx*(-HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,13_y|
      DUM=-2.D0*HRR(49)+&
                         ABy*(-2.D0*HRR(31)+&
                         ABy*(ABy*HRRB(31)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(73))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(ABy*HRRB(19)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,13|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-4.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         2.D0*HRRA(77))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABy*(-4.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(53))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,13_z|
      DUM=ABz*HRRB(73)+&
                         ABy*(2.D0*ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         2.D0*HRRB(77))+&
                         ABx*(ABz*HRRB(50)+&
                         ABy*(2.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(20_x,13|
      DUM=ABy*(ABy*HRRA(51)+&
                         2.D0*HRRA(76))+&
                         ABx*(ABy*(ABy*HRRA(33)+&
                         2.D0*HRRA(52))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,13_x|
      DUM=-HRR(53)+&
                         ABy*(-2.D0*HRR(34)+&
                         ABy*(-HRR(20)+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(33)+&
                         4.D0*HRRB(52))+&
                         ABx*(ABy*(ABy*HRRB(20)+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,13|
      DUM=ABy*(ABy*HRRA(52)+&
                         2.D0*HRRA(77))+&
                         ABx*(ABy*(ABy*HRRA(34)+&
                         2.D0*HRRA(53))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,13_y|
      DUM=-2.D0*HRR(52)+&
                         ABy*(-2.D0*HRR(33)+&
                         ABy*(ABy*HRRB(33)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(77))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABy*(-2.D0*HRR(20)+&
                         ABy*(ABy*HRRB(20)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,13|
      DUM=-3.D0*HRR(49)+&
                         ABy*(-6.D0*HRR(31)+&
                         ABy*(-3.D0*HRR(18)+&
                         HRRA(54))+&
                         2.D0*HRRA(80))+&
                         ABx*(-3.D0*HRR(32)+&
                         ABy*(-6.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(55))+&
                         HRRA(81))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,13_z|
      DUM=ABz*HRRB(77)+&
                         ABy*(2.D0*ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         2.D0*HRRB(80))+&
                         ABx*(ABz*HRRB(53)+&
                         ABy*(2.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(11_x,14|
      DUM=-3.D0*HRR(39)+&
                         ABy*(-9.D0*HRR(23)+&
                         ABy*(-9.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         3.D0*HRRA(37))+&
                         3.D0*HRRA(59))+&
                         HRRA(88)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(21)+&
                         3.D0*HRRB(37))+&
                         3.D0*HRRB(59))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(11)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(38))+&
                         HRRB(60))+&
                         HRRB(88)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(22)+&
                         3.D0*HRRA(38))+&
                         3.D0*HRRA(60))+&
                         HRRA(89)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,14_y|
      DUM=-3.D0*HRR(38)+&
                         ABy*(-6.D0*HRR(22)+&
                         ABy*(-3.D0*HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         4.D0*HRRB(22))+&
                         6.D0*HRRB(38))+&
                         4.D0*HRRB(60))+&
                         HRRB(89)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(26)+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(66))+&
                         HRRA(96)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,14_z|
      DUM=ABz*HRRB(60)+&
                         ABy*(3.D0*ABz*HRRB(38)+&
                         ABy*(3.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(66))+&
                         HRRB(96)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(12_x,14|
      DUM=-2.D0*HRR(40)+&
                         ABy*(-6.D0*HRR(24)+&
                         ABy*(-6.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         3.D0*HRRA(38))+&
                         3.D0*HRRA(60))+&
                         HRRA(89)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(22)+&
                         3.D0*HRRB(38))+&
                         3.D0*HRRB(60))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(12)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(39))+&
                         HRRB(61))+&
                         HRRB(89)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,14|
      DUM=-HRR(39)+&
                         ABy*(-3.D0*HRR(23)+&
                         ABy*(-3.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         3.D0*HRRA(39))+&
                         3.D0*HRRA(61))+&
                         HRRA(90)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,14_y|
      DUM=-3.D0*HRR(39)+&
                         ABy*(-6.D0*HRR(23)+&
                         ABy*(-3.D0*HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         4.D0*HRRB(23))+&
                         6.D0*HRRB(39))+&
                         4.D0*HRRB(61))+&
                         HRRB(90)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(27)+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(67))+&
                         HRRA(97)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,14_z|
      DUM=ABz*HRRB(61)+&
                         ABy*(3.D0*ABz*HRRB(39)+&
                         ABy*(3.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(67))+&
                         HRRB(97)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(13_x,14|
      DUM=-HRR(41)+&
                         ABy*(-3.D0*HRR(25)+&
                         ABy*(-3.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(23))+&
                         3.D0*HRRA(39))+&
                         3.D0*HRRA(61))+&
                         HRRA(90)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(23)+&
                         3.D0*HRRB(39))+&
                         3.D0*HRRB(61))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(13)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(40))+&
                         HRRB(62))+&
                         HRRB(90)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,14|
      DUM=-2.D0*HRR(40)+&
                         ABy*(-6.D0*HRR(24)+&
                         ABy*(-6.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         3.D0*HRRA(40))+&
                         3.D0*HRRA(62))+&
                         HRRA(91)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,14_y|
      DUM=-3.D0*HRR(40)+&
                         ABy*(-6.D0*HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         4.D0*HRRB(24))+&
                         6.D0*HRRB(40))+&
                         4.D0*HRRB(62))+&
                         HRRB(91)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(28)+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(68))+&
                         HRRA(98)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,14_z|
      DUM=ABz*HRRB(62)+&
                         ABy*(3.D0*ABz*HRRB(40)+&
                         ABy*(3.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(68))+&
                         HRRB(98)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(14_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(24)+&
                         3.D0*HRRA(40))+&
                         3.D0*HRRA(62))+&
                         HRRA(91)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(24)+&
                         3.D0*HRRB(40))+&
                         3.D0*HRRB(62))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(14)+&
                         3.D0*HRRB(25))+&
                         3.D0*HRRB(41))+&
                         HRRB(63))+&
                         HRRB(91)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,14|
      DUM=-3.D0*HRR(41)+&
                         ABy*(-9.D0*HRR(25)+&
                         ABy*(-9.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         3.D0*HRRA(41))+&
                         3.D0*HRRA(63))+&
                         HRRA(92)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,14_y|
      DUM=-3.D0*HRR(41)+&
                         ABy*(-6.D0*HRR(25)+&
                         ABy*(-3.D0*HRR(14)+&
                         ABy*(ABy*HRRB(14)+&
                         4.D0*HRRB(25))+&
                         6.D0*HRRB(41))+&
                         4.D0*HRRB(63))+&
                         HRRB(92)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(29)+&
                         3.D0*HRRA(46))+&
                         3.D0*HRRA(69))+&
                         HRRA(99)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,14_z|
      DUM=ABz*HRRB(63)+&
                         ABy*(3.D0*ABz*HRRB(41)+&
                         ABy*(3.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         3.D0*HRRB(46))+&
                         3.D0*HRRB(69))+&
                         HRRB(99)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(15_x,14|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-6.D0*HRR(28)+&
                         ABy*(-6.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(66))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(26)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(66))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(15)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(27)+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(67))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,14_y|
      DUM=-3.D0*HRR(44)+&
                         ABy*(-6.D0*HRR(27)+&
                         ABy*(-3.D0*HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         4.D0*HRRB(27))+&
                         6.D0*HRRB(44))+&
                         4.D0*HRRB(67))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,14|
      DUM=-HRR(39)+&
                         ABy*(-3.D0*HRR(23)+&
                         ABy*(-3.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,14_z|
      DUM=ABz*HRRB(67)+&
                         ABy*(3.D0*ABz*HRRB(44)+&
                         ABy*(3.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(72))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(16_x,14|
      DUM=-HRR(46)+&
                         ABy*(-3.D0*HRR(29)+&
                         ABy*(-3.D0*HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRA(27))+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(67))+&
                         HRRA(97)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(27)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(67))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(16)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,14|
      DUM=-HRR(45)+&
                         ABy*(-3.D0*HRR(28)+&
                         ABy*(-3.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(68))+&
                         HRRA(98)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,14_y|
      DUM=-3.D0*HRR(45)+&
                         ABy*(-6.D0*HRR(28)+&
                         ABy*(-3.D0*HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         4.D0*HRRB(28))+&
                         6.D0*HRRB(45))+&
                         4.D0*HRRB(68))+&
                         HRRB(98)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,14|
      DUM=-HRR(40)+&
                         ABy*(-3.D0*HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,14_z|
      DUM=ABz*HRRB(68)+&
                         ABy*(3.D0*ABz*HRRB(45)+&
                         ABy*(3.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(73))+&
                         HRRB(104)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(17_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(28)+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(68))+&
                         HRRA(98)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(28)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(68))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(17)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(46))+&
                         HRRB(69))+&
                         HRRB(98)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,14|
      DUM=-2.D0*HRR(46)+&
                         ABy*(-6.D0*HRR(29)+&
                         ABy*(-6.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         3.D0*HRRA(46))+&
                         3.D0*HRRA(69))+&
                         HRRA(99)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,14_y|
      DUM=-3.D0*HRR(46)+&
                         ABy*(-6.D0*HRR(29)+&
                         ABy*(-3.D0*HRR(17)+&
                         ABy*(ABy*HRRB(17)+&
                         4.D0*HRRB(29))+&
                         6.D0*HRRB(46))+&
                         4.D0*HRRB(69))+&
                         HRRB(99)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,14|
      DUM=-HRR(41)+&
                         ABy*(-3.D0*HRR(25)+&
                         ABy*(-3.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRA(32))+&
                         3.D0*HRRA(50))+&
                         3.D0*HRRA(74))+&
                         HRRA(105)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,14_z|
      DUM=ABz*HRRB(69)+&
                         ABy*(3.D0*ABz*HRRB(46)+&
                         ABy*(3.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         3.D0*HRRB(50))+&
                         3.D0*HRRB(74))+&
                         HRRB(105)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(18_x,14|
      DUM=-HRR(50)+&
                         ABy*(-3.D0*HRR(32)+&
                         ABy*(-3.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(30))+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(30)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(72))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(18)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(31)+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,14_y|
      DUM=-3.D0*HRR(49)+&
                         ABy*(-6.D0*HRR(31)+&
                         ABy*(-3.D0*HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         4.D0*HRRB(31))+&
                         6.D0*HRRB(49))+&
                         4.D0*HRRB(73))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,14|
      DUM=-2.D0*HRR(45)+&
                         ABy*(-6.D0*HRR(28)+&
                         ABy*(-6.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,14_z|
      DUM=ABz*HRRB(73)+&
                         ABy*(3.D0*ABz*HRRB(49)+&
                         ABy*(3.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(19_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(31)+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(31)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(73))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(19)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,14|
      DUM=-HRR(50)+&
                         ABy*(-3.D0*HRR(32)+&
                         ABy*(-3.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRA(32))+&
                         3.D0*HRRA(50))+&
                         3.D0*HRRA(74))+&
                         HRRA(105)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,14_y|
      DUM=-3.D0*HRR(50)+&
                         ABy*(-6.D0*HRR(32)+&
                         ABy*(-3.D0*HRR(19)+&
                         ABy*(ABy*HRRB(19)+&
                         4.D0*HRRB(32))+&
                         6.D0*HRRB(50))+&
                         4.D0*HRRB(74))+&
                         HRRB(105)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,14|
      DUM=-2.D0*HRR(46)+&
                         ABy*(-6.D0*HRR(29)+&
                         ABy*(-6.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         3.D0*HRRA(53))+&
                         3.D0*HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,14_z|
      DUM=ABz*HRRB(74)+&
                         ABy*(3.D0*ABz*HRRB(50)+&
                         ABy*(3.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         3.D0*HRRB(53))+&
                         3.D0*HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(20_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(33)+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(33)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(77))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(20)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(34)+&
                         3.D0*HRRA(53))+&
                         3.D0*HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,14_y|
      DUM=-3.D0*HRR(53)+&
                         ABy*(-6.D0*HRR(34)+&
                         ABy*(-3.D0*HRR(20)+&
                         ABy*(ABy*HRRB(20)+&
                         4.D0*HRRB(34))+&
                         6.D0*HRRB(53))+&
                         4.D0*HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,14|
      DUM=-3.D0*HRR(50)+&
                         ABy*(-9.D0*HRR(32)+&
                         ABy*(-9.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         3.D0*HRRA(55))+&
                         3.D0*HRRA(81))+&
                         HRRA(114)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,14_z|
      DUM=ABz*HRRB(78)+&
                         ABy*(3.D0*ABz*HRRB(53)+&
                         ABy*(3.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         3.D0*HRRB(55))+&
                         3.D0*HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(11_x,15|
      DUM=-3.D0*HRR(42)+&
                         ABz*(-3.D0*HRR(21)+&
                         HRRA(57))+&
                         ABx*(-6.D0*HRR(26)+&
                         ABz*(-6.D0*HRR(11)+&
                         2.D0*HRRA(36))+&
                         ABx*(-3.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         2.D0*HRRA(64))+&
                         HRRA(93)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,15_x|
      DUM=-2.D0*HRR(42)+&
                         ABz*(-2.D0*HRR(21)+&
                         HRRB(57))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         3.D0*HRRB(36))+&
                         ABx*(3.D0*ABz*HRRB(21)+&
                         ABx*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         3.D0*HRRB(42))+&
                         3.D0*HRRB(64))+&
                         HRRB(93)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,15|
      DUM=ABz*HRRA(58)+&
                         ABx*(2.D0*ABz*HRRA(37)+&
                         ABx*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         2.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,15_y|
      DUM=ABz*HRRB(58)+&
                         ABy*(ABz*HRRB(36)+&
                         HRRB(64))+&
                         ABx*(2.D0*ABz*HRRB(37)+&
                         ABy*(2.D0*ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         2.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,15|
      DUM=ABz*HRRA(64)+&
                         ABx*(2.D0*ABz*HRRA(42)+&
                         ABx*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         2.D0*HRRA(70))+&
                         HRRA(100)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,15_z|
      DUM=-HRR(36)+&
                         ABz*(ABz*HRRB(36)+&
                         2.D0*HRRB(64))+&
                         ABx*(-2.D0*HRR(21)+&
                         ABz*(2.D0*ABz*HRRB(21)+&
                         4.D0*HRRB(42))+&
                         ABx*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         2.D0*HRRB(70))+&
                         HRRB(100)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(12_x,15|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         HRRA(58))+&
                         ABx*(-4.D0*HRR(27)+&
                         ABz*(-4.D0*HRR(12)+&
                         2.D0*HRRA(37))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         2.D0*HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,15_x|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         HRRB(58))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         3.D0*HRRB(37))+&
                         ABx*(3.D0*ABz*HRRB(22)+&
                         ABx*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,15|
      DUM=-HRR(42)+&
                         ABz*(-HRR(21)+&
                         HRRA(59))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         2.D0*HRRA(38))+&
                         ABx*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         2.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,15_y|
      DUM=ABz*HRRB(59)+&
                         ABy*(ABz*HRRB(37)+&
                         HRRB(65))+&
                         ABx*(2.D0*ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         2.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,15|
      DUM=ABz*HRRA(65)+&
                         ABx*(2.D0*ABz*HRRA(43)+&
                         ABx*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         2.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,15_z|
      DUM=-HRR(37)+&
                         ABz*(ABz*HRRB(37)+&
                         2.D0*HRRB(65))+&
                         ABx*(-2.D0*HRR(22)+&
                         ABz*(2.D0*ABz*HRRB(22)+&
                         4.D0*HRRB(43))+&
                         ABx*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         2.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(13_x,15|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRA(59))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         2.D0*HRRA(38))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         2.D0*HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,15_x|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         HRRB(59))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         3.D0*HRRB(38))+&
                         ABx*(3.D0*ABz*HRRB(23)+&
                         ABx*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,15|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         HRRA(60))+&
                         ABx*(-4.D0*HRR(27)+&
                         ABz*(-4.D0*HRR(12)+&
                         2.D0*HRRA(39))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         2.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,15_y|
      DUM=ABz*HRRB(60)+&
                         ABy*(ABz*HRRB(38)+&
                         HRRB(66))+&
                         ABx*(2.D0*ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         2.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,15|
      DUM=ABz*HRRA(66)+&
                         ABx*(2.D0*ABz*HRRA(44)+&
                         ABx*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,15_z|
      DUM=-HRR(38)+&
                         ABz*(ABz*HRRB(38)+&
                         2.D0*HRRB(66))+&
                         ABx*(-2.D0*HRR(23)+&
                         ABz*(2.D0*ABz*HRRB(23)+&
                         4.D0*HRRB(44))+&
                         ABx*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(14_x,15|
      DUM=ABz*HRRA(60)+&
                         ABx*(2.D0*ABz*HRRA(39)+&
                         ABx*(ABz*HRRA(24)+&
                         HRRA(45))+&
                         2.D0*HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,15_x|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         HRRB(60))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         3.D0*HRRB(39))+&
                         ABx*(3.D0*ABz*HRRB(24)+&
                         ABx*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,15|
      DUM=-3.D0*HRR(44)+&
                         ABz*(-3.D0*HRR(23)+&
                         HRRA(61))+&
                         ABx*(-6.D0*HRR(28)+&
                         ABz*(-6.D0*HRR(13)+&
                         2.D0*HRRA(40))+&
                         ABx*(-3.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(46))+&
                         2.D0*HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,15_y|
      DUM=ABz*HRRB(61)+&
                         ABy*(ABz*HRRB(39)+&
                         HRRB(67))+&
                         ABx*(2.D0*ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         2.D0*HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,15|
      DUM=ABz*HRRA(67)+&
                         ABx*(2.D0*ABz*HRRA(45)+&
                         ABx*(ABz*HRRA(29)+&
                         HRRA(50))+&
                         2.D0*HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,15_z|
      DUM=-HRR(39)+&
                         ABz*(ABz*HRRB(39)+&
                         2.D0*HRRB(67))+&
                         ABx*(-2.D0*HRR(24)+&
                         ABz*(2.D0*ABz*HRRB(24)+&
                         4.D0*HRRB(45))+&
                         ABx*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(15_x,15|
      DUM=-2.D0*HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         HRRA(64))+&
                         ABx*(-4.D0*HRR(30)+&
                         ABz*(-4.D0*HRR(15)+&
                         2.D0*HRRA(42))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         2.D0*HRRA(70))+&
                         HRRA(100)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,15_x|
      DUM=-2.D0*HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         HRRB(64))+&
                         ABx*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         3.D0*HRRB(42))+&
                         ABx*(3.D0*ABz*HRRB(26)+&
                         ABx*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         3.D0*HRRB(47))+&
                         3.D0*HRRB(70))+&
                         HRRB(100)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,15|
      DUM=ABz*HRRA(65)+&
                         ABx*(2.D0*ABz*HRRA(43)+&
                         ABx*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         2.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,15_y|
      DUM=ABz*HRRB(65)+&
                         ABy*(ABz*HRRB(42)+&
                         HRRB(70))+&
                         ABx*(2.D0*ABz*HRRB(43)+&
                         ABy*(2.D0*ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         2.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,15|
      DUM=-HRR(42)+&
                         ABz*(-HRR(21)+&
                         HRRA(70))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         2.D0*HRRA(47))+&
                         ABx*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         2.D0*HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,15_z|
      DUM=-HRR(42)+&
                         ABz*(ABz*HRRB(42)+&
                         2.D0*HRRB(70))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABz*(2.D0*ABz*HRRB(26)+&
                         4.D0*HRRB(47))+&
                         ABx*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         2.D0*HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(16_x,15|
      DUM=-HRR(48)+&
                         ABz*(-HRR(27)+&
                         HRRA(65))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         2.D0*HRRA(43))+&
                         ABx*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(48))+&
                         2.D0*HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,15_x|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRB(65))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         3.D0*HRRB(43))+&
                         ABx*(3.D0*ABz*HRRB(27)+&
                         ABx*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,15|
      DUM=-HRR(47)+&
                         ABz*(-HRR(26)+&
                         HRRA(66))+&
                         ABx*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         2.D0*HRRA(44))+&
                         ABx*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,15_y|
      DUM=ABz*HRRB(66)+&
                         ABy*(ABz*HRRB(43)+&
                         HRRB(71))+&
                         ABx*(2.D0*ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,15|
      DUM=-HRR(43)+&
                         ABz*(-HRR(22)+&
                         HRRA(71))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         2.D0*HRRA(48))+&
                         ABx*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         2.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,15_z|
      DUM=-HRR(43)+&
                         ABz*(ABz*HRRB(43)+&
                         2.D0*HRRB(71))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABz*(2.D0*ABz*HRRB(27)+&
                         4.D0*HRRB(48))+&
                         ABx*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         2.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(17_x,15|
      DUM=ABz*HRRA(66)+&
                         ABx*(2.D0*ABz*HRRA(44)+&
                         ABx*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         2.D0*HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,15_x|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRB(66))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         3.D0*HRRB(44))+&
                         ABx*(3.D0*ABz*HRRB(28)+&
                         ABx*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,15|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRA(67))+&
                         ABx*(-4.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         2.D0*HRRA(45))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(50))+&
                         2.D0*HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,15_y|
      DUM=ABz*HRRB(67)+&
                         ABy*(ABz*HRRB(44)+&
                         HRRB(72))+&
                         ABx*(2.D0*ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,15|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRA(72))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         2.D0*HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,15_z|
      DUM=-HRR(44)+&
                         ABz*(ABz*HRRB(44)+&
                         2.D0*HRRB(72))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(2.D0*ABz*HRRB(28)+&
                         4.D0*HRRB(49))+&
                         ABx*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(18_x,15|
      DUM=-HRR(51)+&
                         ABz*(-HRR(30)+&
                         HRRA(70))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         2.D0*HRRA(47))+&
                         ABx*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         2.D0*HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,15_x|
      DUM=-2.D0*HRR(51)+&
                         ABz*(-2.D0*HRR(30)+&
                         HRRB(70))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         3.D0*HRRB(47))+&
                         ABx*(3.D0*ABz*HRRB(30)+&
                         ABx*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         3.D0*HRRB(51))+&
                         3.D0*HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,15|
      DUM=ABz*HRRA(71)+&
                         ABx*(2.D0*ABz*HRRA(48)+&
                         ABx*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         2.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,15_y|
      DUM=ABz*HRRB(71)+&
                         ABy*(ABz*HRRB(47)+&
                         HRRB(75))+&
                         ABx*(2.D0*ABz*HRRB(48)+&
                         ABy*(2.D0*ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         2.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,15|
      DUM=-2.D0*HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         HRRA(75))+&
                         ABx*(-4.D0*HRR(30)+&
                         ABz*(-4.D0*HRR(15)+&
                         2.D0*HRRA(51))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         2.D0*HRRA(79))+&
                         HRRA(111)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,15_z|
      DUM=-HRR(47)+&
                         ABz*(ABz*HRRB(47)+&
                         2.D0*HRRB(75))+&
                         ABx*(-2.D0*HRR(30)+&
                         ABz*(2.D0*ABz*HRRB(30)+&
                         4.D0*HRRB(51))+&
                         ABx*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         2.D0*HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(19_x,15|
      DUM=ABz*HRRA(71)+&
                         ABx*(2.D0*ABz*HRRA(48)+&
                         ABx*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         2.D0*HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,15_x|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         HRRB(71))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         3.D0*HRRB(48))+&
                         ABx*(3.D0*ABz*HRRB(31)+&
                         ABx*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,15|
      DUM=-HRR(51)+&
                         ABz*(-HRR(30)+&
                         HRRA(72))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         2.D0*HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,15_y|
      DUM=ABz*HRRB(72)+&
                         ABy*(ABz*HRRB(48)+&
                         HRRB(76))+&
                         ABx*(2.D0*ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,15|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRA(76))+&
                         ABx*(-4.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         2.D0*HRRA(52))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(55))+&
                         2.D0*HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,15_z|
      DUM=-HRR(48)+&
                         ABz*(ABz*HRRB(48)+&
                         2.D0*HRRB(76))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(2.D0*ABz*HRRB(31)+&
                         4.D0*HRRB(52))+&
                         ABx*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         2.D0*HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(20_x,15|
      DUM=ABz*HRRA(75)+&
                         ABx*(2.D0*ABz*HRRA(51)+&
                         ABx*(ABz*HRRA(33)+&
                         HRRA(54))+&
                         2.D0*HRRA(79))+&
                         HRRA(111)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,15_x|
      DUM=-2.D0*HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         HRRB(75))+&
                         ABx*(-2.D0*HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         3.D0*HRRB(51))+&
                         ABx*(3.D0*ABz*HRRB(33)+&
                         ABx*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         3.D0*HRRB(54))+&
                         3.D0*HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,15|
      DUM=ABz*HRRA(76)+&
                         ABx*(2.D0*ABz*HRRA(52)+&
                         ABx*(ABz*HRRA(34)+&
                         HRRA(55))+&
                         2.D0*HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,15_y|
      DUM=ABz*HRRB(76)+&
                         ABy*(ABz*HRRB(51)+&
                         HRRB(79))+&
                         ABx*(2.D0*ABz*HRRB(52)+&
                         ABy*(2.D0*ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         2.D0*HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,15|
      DUM=-3.D0*HRR(51)+&
                         ABz*(-3.D0*HRR(30)+&
                         HRRA(79))+&
                         ABx*(-6.D0*HRR(33)+&
                         ABz*(-6.D0*HRR(18)+&
                         2.D0*HRRA(54))+&
                         ABx*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(56))+&
                         2.D0*HRRA(82))+&
                         HRRA(115)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,15_z|
      DUM=-HRR(51)+&
                         ABz*(ABz*HRRB(51)+&
                         2.D0*HRRB(79))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(2.D0*ABz*HRRB(33)+&
                         4.D0*HRRB(54))+&
                         ABx*(-HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         2.D0*HRRB(82))+&
                         HRRB(115)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(11_x,16|
      DUM=-3.D0*HRR(43)+&
                         ABz*(-3.D0*HRR(22)+&
                         HRRA(58))+&
                         ABy*(-3.D0*HRR(26)+&
                         ABz*(-3.D0*HRR(11)+&
                         HRRA(36))+&
                         HRRA(64))+&
                         ABx*(-3.D0*HRR(27)+&
                         ABz*(-3.D0*HRR(12)+&
                         HRRA(37))+&
                         ABy*(-3.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         HRRA(65))+&
                         HRRA(94)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,16_x|
      DUM=-HRR(43)+&
                         ABz*(-HRR(22)+&
                         HRRB(58))+&
                         ABy*(-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(36))+&
                         HRRB(64))+&
                         ABx*(2.D0*ABz*HRRB(37)+&
                         ABy*(2.D0*ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         HRRB(43))+&
                         2.D0*HRRB(65))+&
                         HRRB(94)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,16|
      DUM=ABz*HRRA(59)+&
                         ABy*(ABz*HRRA(37)+&
                         HRRA(65))+&
                         ABx*(ABz*HRRA(38)+&
                         ABy*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,16_y|
      DUM=-HRR(42)+&
                         ABz*(-HRR(21)+&
                         HRRB(59))+&
                         ABy*(2.D0*ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         2.D0*HRRB(65))+&
                         ABx*(-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(38))+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,16|
      DUM=ABz*HRRA(65)+&
                         ABy*(ABz*HRRA(42)+&
                         HRRA(70))+&
                         ABx*(ABz*HRRA(43)+&
                         ABy*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,16_z|
      DUM=-HRR(37)+&
                         ABz*(ABz*HRRB(37)+&
                         2.D0*HRRB(65))+&
                         ABy*(-HRR(21)+&
                         ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         HRRB(70))+&
                         ABx*(-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(12_x,16|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         HRRA(59))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         HRRA(65))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(38))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         HRRA(66))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,16_x|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRB(59))+&
                         ABy*(-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(37))+&
                         HRRB(65))+&
                         ABx*(2.D0*ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         HRRB(44))+&
                         2.D0*HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,16|
      DUM=-HRR(43)+&
                         ABz*(-HRR(22)+&
                         HRRA(60))+&
                         ABy*(-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(38))+&
                         HRRA(66))+&
                         ABx*(-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(39))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,16_y|
      DUM=-HRR(43)+&
                         ABz*(-HRR(22)+&
                         HRRB(60))+&
                         ABy*(2.D0*ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         2.D0*HRRB(66))+&
                         ABx*(-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(39))+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,16|
      DUM=ABz*HRRA(66)+&
                         ABy*(ABz*HRRA(43)+&
                         HRRA(71))+&
                         ABx*(ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,16_z|
      DUM=-HRR(38)+&
                         ABz*(ABz*HRRB(38)+&
                         2.D0*HRRB(66))+&
                         ABy*(-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         HRRB(71))+&
                         ABx*(-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(13_x,16|
      DUM=-HRR(45)+&
                         ABz*(-HRR(24)+&
                         HRRA(60))+&
                         ABy*(-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(38))+&
                         HRRA(66))+&
                         ABx*(-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(39))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         HRRA(67))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,16_x|
      DUM=-HRR(45)+&
                         ABz*(-HRR(24)+&
                         HRRB(60))+&
                         ABy*(-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(38))+&
                         HRRB(66))+&
                         ABx*(2.D0*ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         HRRB(45))+&
                         2.D0*HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,16|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         HRRA(61))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         HRRA(67))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,16_y|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRB(61))+&
                         ABy*(2.D0*ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         2.D0*HRRB(67))+&
                         ABx*(-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(40))+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,16|
      DUM=ABz*HRRA(67)+&
                         ABy*(ABz*HRRA(44)+&
                         HRRA(72))+&
                         ABx*(ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,16_z|
      DUM=-HRR(39)+&
                         ABz*(ABz*HRRB(39)+&
                         2.D0*HRRB(67))+&
                         ABy*(-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         HRRB(72))+&
                         ABx*(-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(14_x,16|
      DUM=ABz*HRRA(61)+&
                         ABy*(ABz*HRRA(39)+&
                         HRRA(67))+&
                         ABx*(ABz*HRRA(40)+&
                         ABy*(ABz*HRRA(24)+&
                         HRRA(45))+&
                         HRRA(68))+&
                         HRRA(97)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,16_x|
      DUM=-HRR(46)+&
                         ABz*(-HRR(25)+&
                         HRRB(61))+&
                         ABy*(-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(39))+&
                         HRRB(67))+&
                         ABx*(2.D0*ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         HRRB(46))+&
                         2.D0*HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,16|
      DUM=-3.D0*HRR(45)+&
                         ABz*(-3.D0*HRR(24)+&
                         HRRA(62))+&
                         ABy*(-3.D0*HRR(28)+&
                         ABz*(-3.D0*HRR(13)+&
                         HRRA(40))+&
                         HRRA(68))+&
                         ABx*(-3.D0*HRR(29)+&
                         ABz*(-3.D0*HRR(14)+&
                         HRRA(41))+&
                         ABy*(-3.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(46))+&
                         HRRA(69))+&
                         HRRA(98)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,16_y|
      DUM=-HRR(45)+&
                         ABz*(-HRR(24)+&
                         HRRB(62))+&
                         ABy*(2.D0*ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         2.D0*HRRB(68))+&
                         ABx*(-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(41))+&
                         ABy*(2.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(46))+&
                         HRRB(69))+&
                         HRRB(98)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,16|
      DUM=ABz*HRRA(68)+&
                         ABy*(ABz*HRRA(45)+&
                         HRRA(73))+&
                         ABx*(ABz*HRRA(46)+&
                         ABy*(ABz*HRRA(29)+&
                         HRRA(50))+&
                         HRRA(74))+&
                         HRRA(104)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,16_z|
      DUM=-HRR(40)+&
                         ABz*(ABz*HRRB(40)+&
                         2.D0*HRRB(68))+&
                         ABy*(-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         HRRB(73))+&
                         ABx*(-HRR(25)+&
                         ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(15_x,16|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRA(65))+&
                         ABy*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(42))+&
                         HRRA(70))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(43))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,16_x|
      DUM=-HRR(48)+&
                         ABz*(-HRR(27)+&
                         HRRB(65))+&
                         ABy*(-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(42))+&
                         HRRB(70))+&
                         ABx*(2.D0*ABz*HRRB(43)+&
                         ABy*(2.D0*ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         HRRB(48))+&
                         2.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,16|
      DUM=ABz*HRRA(66)+&
                         ABy*(ABz*HRRA(43)+&
                         HRRA(71))+&
                         ABx*(ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,16_y|
      DUM=-HRR(47)+&
                         ABz*(-HRR(26)+&
                         HRRB(66))+&
                         ABy*(2.D0*ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         ABx*(-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(44))+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,16|
      DUM=-HRR(43)+&
                         ABz*(-HRR(22)+&
                         HRRA(71))+&
                         ABy*(-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(47))+&
                         HRRA(75))+&
                         ABx*(-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,16_z|
      DUM=-HRR(43)+&
                         ABz*(ABz*HRRB(43)+&
                         2.D0*HRRB(71))+&
                         ABy*(-HRR(26)+&
                         ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         HRRB(75))+&
                         ABx*(-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(16_x,16|
      DUM=-HRR(49)+&
                         ABz*(-HRR(28)+&
                         HRRA(66))+&
                         ABy*(-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(43))+&
                         HRRA(71))+&
                         ABx*(-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRA(44))+&
                         ABy*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(48))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,16_x|
      DUM=-HRR(49)+&
                         ABz*(-HRR(28)+&
                         HRRB(66))+&
                         ABy*(-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(43))+&
                         HRRB(71))+&
                         ABx*(2.D0*ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,16|
      DUM=-HRR(48)+&
                         ABz*(-HRR(27)+&
                         HRRA(67))+&
                         ABy*(-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRA(44))+&
                         HRRA(72))+&
                         ABx*(-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(45))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,16_y|
      DUM=-HRR(48)+&
                         ABz*(-HRR(27)+&
                         HRRB(67))+&
                         ABy*(2.D0*ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         ABx*(-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(45))+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,16|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRA(72))+&
                         ABy*(-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         HRRA(76))+&
                         ABx*(-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,16_z|
      DUM=-HRR(44)+&
                         ABz*(ABz*HRRB(44)+&
                         2.D0*HRRB(72))+&
                         ABy*(-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         HRRB(76))+&
                         ABx*(-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(17_x,16|
      DUM=ABz*HRRA(67)+&
                         ABy*(ABz*HRRA(44)+&
                         HRRA(72))+&
                         ABx*(ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,16_x|
      DUM=-HRR(50)+&
                         ABz*(-HRR(29)+&
                         HRRB(67))+&
                         ABy*(-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(44))+&
                         HRRB(72))+&
                         ABx*(2.D0*ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,16|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRA(68))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(45))+&
                         HRRA(73))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(50))+&
                         HRRA(74))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,16_y|
      DUM=-HRR(49)+&
                         ABz*(-HRR(28)+&
                         HRRB(68))+&
                         ABy*(2.D0*ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         2.D0*HRRB(73))+&
                         ABx*(-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(46))+&
                         ABy*(2.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,16|
      DUM=-HRR(45)+&
                         ABz*(-HRR(24)+&
                         HRRA(73))+&
                         ABy*(-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         HRRA(77))+&
                         ABx*(-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,16_z|
      DUM=-HRR(45)+&
                         ABz*(ABz*HRRB(45)+&
                         2.D0*HRRB(73))+&
                         ABy*(-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         HRRB(77))+&
                         ABx*(-HRR(29)+&
                         ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(18_x,16|
      DUM=-HRR(52)+&
                         ABz*(-HRR(31)+&
                         HRRA(71))+&
                         ABy*(-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(47))+&
                         HRRA(75))+&
                         ABx*(-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(48))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,16_x|
      DUM=-HRR(52)+&
                         ABz*(-HRR(31)+&
                         HRRB(71))+&
                         ABy*(-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(47))+&
                         HRRB(75))+&
                         ABx*(2.D0*ABz*HRRB(48)+&
                         ABy*(2.D0*ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         HRRB(52))+&
                         2.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,16|
      DUM=ABz*HRRA(72)+&
                         ABy*(ABz*HRRA(48)+&
                         HRRA(76))+&
                         ABx*(ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,16_y|
      DUM=-HRR(51)+&
                         ABz*(-HRR(30)+&
                         HRRB(72))+&
                         ABy*(2.D0*ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         ABx*(-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(49))+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,16|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRA(76))+&
                         ABy*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         HRRA(79))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,16_z|
      DUM=-HRR(48)+&
                         ABz*(ABz*HRRB(48)+&
                         2.D0*HRRB(76))+&
                         ABy*(-HRR(30)+&
                         ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         HRRB(79))+&
                         ABx*(-HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(19_x,16|
      DUM=ABz*HRRA(72)+&
                         ABy*(ABz*HRRA(48)+&
                         HRRA(76))+&
                         ABx*(ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,16_x|
      DUM=-HRR(53)+&
                         ABz*(-HRR(32)+&
                         HRRB(72))+&
                         ABy*(-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(48))+&
                         HRRB(76))+&
                         ABx*(2.D0*ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,16|
      DUM=-HRR(52)+&
                         ABz*(-HRR(31)+&
                         HRRA(73))+&
                         ABy*(-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(49))+&
                         HRRA(77))+&
                         ABx*(-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(50))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,16_y|
      DUM=-HRR(52)+&
                         ABz*(-HRR(31)+&
                         HRRB(73))+&
                         ABy*(2.D0*ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         2.D0*HRRB(77))+&
                         ABx*(-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(50))+&
                         ABy*(2.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,16|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRA(77))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         HRRA(80))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(53))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(55))+&
                         HRRA(81))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,16_z|
      DUM=-HRR(49)+&
                         ABz*(ABz*HRRB(49)+&
                         2.D0*HRRB(77))+&
                         ABy*(-HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         HRRB(80))+&
                         ABx*(-HRR(32)+&
                         ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(20_x,16|
      DUM=ABz*HRRA(76)+&
                         ABy*(ABz*HRRA(51)+&
                         HRRA(79))+&
                         ABx*(ABz*HRRA(52)+&
                         ABy*(ABz*HRRA(33)+&
                         HRRA(54))+&
                         HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,16_x|
      DUM=-HRR(55)+&
                         ABz*(-HRR(34)+&
                         HRRB(76))+&
                         ABy*(-HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(51))+&
                         HRRB(79))+&
                         ABx*(2.D0*ABz*HRRB(52)+&
                         ABy*(2.D0*ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         ABx*(ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         HRRB(55))+&
                         2.D0*HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,16|
      DUM=ABz*HRRA(77)+&
                         ABy*(ABz*HRRA(52)+&
                         HRRA(80))+&
                         ABx*(ABz*HRRA(53)+&
                         ABy*(ABz*HRRA(34)+&
                         HRRA(55))+&
                         HRRA(81))+&
                         HRRA(113)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,16_y|
      DUM=-HRR(54)+&
                         ABz*(-HRR(33)+&
                         HRRB(77))+&
                         ABy*(2.D0*ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         2.D0*HRRB(80))+&
                         ABx*(-HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(53))+&
                         ABy*(2.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,16|
      DUM=-3.D0*HRR(52)+&
                         ABz*(-3.D0*HRR(31)+&
                         HRRA(80))+&
                         ABy*(-3.D0*HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         HRRA(54))+&
                         HRRA(82))+&
                         ABx*(-3.D0*HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         HRRA(55))+&
                         ABy*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(56))+&
                         HRRA(83))+&
                         HRRA(116)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,16_z|
      DUM=-HRR(52)+&
                         ABz*(ABz*HRRB(52)+&
                         2.D0*HRRB(80))+&
                         ABy*(-HRR(33)+&
                         ABz*(ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         HRRB(82))+&
                         ABx*(-HRR(34)+&
                         ABz*(ABz*HRRB(34)+&
                         2.D0*HRRB(55))+&
                         ABy*(-HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83))+&
                         HRRB(116)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(11_x,17|
      DUM=-3.D0*HRR(44)+&
                         ABz*(-3.D0*HRR(23)+&
                         HRRA(59))+&
                         ABy*(-6.D0*HRR(27)+&
                         ABz*(-6.D0*HRR(12)+&
                         2.D0*HRRA(37))+&
                         ABy*(-3.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         2.D0*HRRA(65))+&
                         HRRA(95)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,17_x|
      DUM=ABz*HRRB(59)+&
                         ABy*(2.D0*ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         2.D0*HRRB(65))+&
                         ABx*(ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         HRRB(66))+&
                         HRRB(95)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,17|
      DUM=ABz*HRRA(60)+&
                         ABy*(2.D0*ABz*HRRA(38)+&
                         ABy*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         2.D0*HRRA(66))+&
                         HRRA(96)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,17_y|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         HRRB(60))+&
                         ABy*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         3.D0*HRRB(38))+&
                         ABy*(3.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(66))+&
                         HRRB(96)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,17|
      DUM=ABz*HRRA(66)+&
                         ABy*(2.D0*ABz*HRRA(43)+&
                         ABy*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         2.D0*HRRA(71))+&
                         HRRA(102)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,17_z|
      DUM=-HRR(38)+&
                         ABz*(ABz*HRRB(38)+&
                         2.D0*HRRB(66))+&
                         ABy*(-2.D0*HRR(22)+&
                         ABz*(2.D0*ABz*HRRB(22)+&
                         4.D0*HRRB(43))+&
                         ABy*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         HRRB(102)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(12_x,17|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         HRRA(60))+&
                         ABy*(-4.D0*HRR(28)+&
                         ABz*(-4.D0*HRR(13)+&
                         2.D0*HRRA(38))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         2.D0*HRRA(66))+&
                         HRRA(96)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,17_x|
      DUM=ABz*HRRB(60)+&
                         ABy*(2.D0*ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         2.D0*HRRB(66))+&
                         ABx*(ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         HRRB(67))+&
                         HRRB(96)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,17|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRA(61))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         2.D0*HRRA(39))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         2.D0*HRRA(67))+&
                         HRRA(97)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,17_y|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         HRRB(61))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         3.D0*HRRB(39))+&
                         ABy*(3.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(67))+&
                         HRRB(97)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,17|
      DUM=ABz*HRRA(67)+&
                         ABy*(2.D0*ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         2.D0*HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,17_z|
      DUM=-HRR(39)+&
                         ABz*(ABz*HRRB(39)+&
                         2.D0*HRRB(67))+&
                         ABy*(-2.D0*HRR(23)+&
                         ABz*(2.D0*ABz*HRRB(23)+&
                         4.D0*HRRB(44))+&
                         ABy*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         HRRB(103)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(13_x,17|
      DUM=-HRR(46)+&
                         ABz*(-HRR(25)+&
                         HRRA(61))+&
                         ABy*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         2.D0*HRRA(39))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         2.D0*HRRA(67))+&
                         HRRA(97)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,17_x|
      DUM=ABz*HRRB(61)+&
                         ABy*(2.D0*ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         2.D0*HRRB(67))+&
                         ABx*(ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         HRRB(68))+&
                         HRRB(97)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,17|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         HRRA(62))+&
                         ABy*(-4.D0*HRR(28)+&
                         ABz*(-4.D0*HRR(13)+&
                         2.D0*HRRA(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         2.D0*HRRA(68))+&
                         HRRA(98)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,17_y|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         HRRB(62))+&
                         ABy*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         3.D0*HRRB(40))+&
                         ABy*(3.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(68))+&
                         HRRB(98)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,17|
      DUM=ABz*HRRA(68)+&
                         ABy*(2.D0*ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         2.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,17_z|
      DUM=-HRR(40)+&
                         ABz*(ABz*HRRB(40)+&
                         2.D0*HRRB(68))+&
                         ABy*(-2.D0*HRR(24)+&
                         ABz*(2.D0*ABz*HRRB(24)+&
                         4.D0*HRRB(45))+&
                         ABy*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         2.D0*HRRB(73))+&
                         HRRB(104)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(14_x,17|
      DUM=ABz*HRRA(62)+&
                         ABy*(2.D0*ABz*HRRA(40)+&
                         ABy*(ABz*HRRA(24)+&
                         HRRA(45))+&
                         2.D0*HRRA(68))+&
                         HRRA(98)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,17_x|
      DUM=ABz*HRRB(62)+&
                         ABy*(2.D0*ABz*HRRB(40)+&
                         ABy*(ABz*HRRB(24)+&
                         HRRB(45))+&
                         2.D0*HRRB(68))+&
                         ABx*(ABz*HRRB(41)+&
                         ABy*(2.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         2.D0*HRRB(46))+&
                         HRRB(69))+&
                         HRRB(98)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,17|
      DUM=-3.D0*HRR(46)+&
                         ABz*(-3.D0*HRR(25)+&
                         HRRA(63))+&
                         ABy*(-6.D0*HRR(29)+&
                         ABz*(-6.D0*HRR(14)+&
                         2.D0*HRRA(41))+&
                         ABy*(-3.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         HRRA(46))+&
                         2.D0*HRRA(69))+&
                         HRRA(99)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,17_y|
      DUM=-2.D0*HRR(46)+&
                         ABz*(-2.D0*HRR(25)+&
                         HRRB(63))+&
                         ABy*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         3.D0*HRRB(41))+&
                         ABy*(3.D0*ABz*HRRB(25)+&
                         ABy*(ABz*HRRB(14)+&
                         HRRB(29))+&
                         3.D0*HRRB(46))+&
                         3.D0*HRRB(69))+&
                         HRRB(99)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,17|
      DUM=ABz*HRRA(69)+&
                         ABy*(2.D0*ABz*HRRA(46)+&
                         ABy*(ABz*HRRA(29)+&
                         HRRA(50))+&
                         2.D0*HRRA(74))+&
                         HRRA(105)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,17_z|
      DUM=-HRR(41)+&
                         ABz*(ABz*HRRB(41)+&
                         2.D0*HRRB(69))+&
                         ABy*(-2.D0*HRR(25)+&
                         ABz*(2.D0*ABz*HRRB(25)+&
                         4.D0*HRRB(46))+&
                         ABy*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         2.D0*HRRB(74))+&
                         HRRB(105)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(15_x,17|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRA(66))+&
                         ABy*(-4.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         2.D0*HRRA(43))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         2.D0*HRRA(71))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,17_x|
      DUM=ABz*HRRB(66)+&
                         ABy*(2.D0*ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         ABx*(ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,17|
      DUM=ABz*HRRA(67)+&
                         ABy*(2.D0*ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         2.D0*HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,17_y|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         HRRB(67))+&
                         ABy*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         3.D0*HRRB(44))+&
                         ABy*(3.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(72))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,17|
      DUM=-HRR(44)+&
                         ABz*(-HRR(23)+&
                         HRRA(72))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         2.D0*HRRA(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         2.D0*HRRA(76))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,17_z|
      DUM=-HRR(44)+&
                         ABz*(ABz*HRRB(44)+&
                         2.D0*HRRB(72))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(2.D0*ABz*HRRB(27)+&
                         4.D0*HRRB(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(16_x,17|
      DUM=-HRR(50)+&
                         ABz*(-HRR(29)+&
                         HRRA(67))+&
                         ABy*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         2.D0*HRRA(44))+&
                         ABy*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         HRRA(48))+&
                         2.D0*HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,17_x|
      DUM=ABz*HRRB(67)+&
                         ABy*(2.D0*ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         ABx*(ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,17|
      DUM=-HRR(49)+&
                         ABz*(-HRR(28)+&
                         HRRA(68))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         2.D0*HRRA(45))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         2.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,17_y|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRB(68))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         3.D0*HRRB(45))+&
                         ABy*(3.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(73))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,17|
      DUM=-HRR(45)+&
                         ABz*(-HRR(24)+&
                         HRRA(73))+&
                         ABy*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         2.D0*HRRA(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         2.D0*HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,17_z|
      DUM=-HRR(45)+&
                         ABz*(ABz*HRRB(45)+&
                         2.D0*HRRB(73))+&
                         ABy*(-2.D0*HRR(28)+&
                         ABz*(2.D0*ABz*HRRB(28)+&
                         4.D0*HRRB(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         2.D0*HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(17_x,17|
      DUM=ABz*HRRA(68)+&
                         ABy*(2.D0*ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         2.D0*HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,17_x|
      DUM=ABz*HRRB(68)+&
                         ABy*(2.D0*ABz*HRRB(45)+&
                         ABy*(ABz*HRRB(28)+&
                         HRRB(49))+&
                         2.D0*HRRB(73))+&
                         ABx*(ABz*HRRB(46)+&
                         ABy*(2.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,17|
      DUM=-2.D0*HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         HRRA(69))+&
                         ABy*(-4.D0*HRR(32)+&
                         ABz*(-4.D0*HRR(17)+&
                         2.D0*HRRA(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         HRRA(50))+&
                         2.D0*HRRA(74))+&
                         HRRA(105)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,17_y|
      DUM=-2.D0*HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         HRRB(69))+&
                         ABy*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         3.D0*HRRB(46))+&
                         ABy*(3.D0*ABz*HRRB(29)+&
                         ABy*(ABz*HRRB(17)+&
                         HRRB(32))+&
                         3.D0*HRRB(50))+&
                         3.D0*HRRB(74))+&
                         HRRB(105)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,17|
      DUM=-HRR(46)+&
                         ABz*(-HRR(25)+&
                         HRRA(74))+&
                         ABy*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         2.D0*HRRA(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         2.D0*HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,17_z|
      DUM=-HRR(46)+&
                         ABz*(ABz*HRRB(46)+&
                         2.D0*HRRB(74))+&
                         ABy*(-2.D0*HRR(29)+&
                         ABz*(2.D0*ABz*HRRB(29)+&
                         4.D0*HRRB(50))+&
                         ABy*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         2.D0*HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(18_x,17|
      DUM=-HRR(53)+&
                         ABz*(-HRR(32)+&
                         HRRA(72))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         2.D0*HRRA(48))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         2.D0*HRRA(76))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,17_x|
      DUM=ABz*HRRB(72)+&
                         ABy*(2.D0*ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         ABx*(ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,17|
      DUM=ABz*HRRA(73)+&
                         ABy*(2.D0*ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         2.D0*HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,17_y|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         HRRB(73))+&
                         ABy*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         3.D0*HRRB(49))+&
                         ABy*(3.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,17|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         HRRA(77))+&
                         ABy*(-4.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         2.D0*HRRA(52))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         2.D0*HRRA(80))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,17_z|
      DUM=-HRR(49)+&
                         ABz*(ABz*HRRB(49)+&
                         2.D0*HRRB(77))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(2.D0*ABz*HRRB(31)+&
                         4.D0*HRRB(52))+&
                         ABy*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         2.D0*HRRB(80))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(19_x,17|
      DUM=ABz*HRRA(73)+&
                         ABy*(2.D0*ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         2.D0*HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,17_x|
      DUM=ABz*HRRB(73)+&
                         ABy*(2.D0*ABz*HRRB(49)+&
                         ABy*(ABz*HRRB(31)+&
                         HRRB(52))+&
                         2.D0*HRRB(77))+&
                         ABx*(ABz*HRRB(50)+&
                         ABy*(2.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,17|
      DUM=-HRR(53)+&
                         ABz*(-HRR(32)+&
                         HRRA(74))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         2.D0*HRRA(50))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         HRRA(53))+&
                         2.D0*HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,17_y|
      DUM=-2.D0*HRR(53)+&
                         ABz*(-2.D0*HRR(32)+&
                         HRRB(74))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         3.D0*HRRB(50))+&
                         ABy*(3.D0*ABz*HRRB(32)+&
                         ABy*(ABz*HRRB(19)+&
                         HRRB(34))+&
                         3.D0*HRRB(53))+&
                         3.D0*HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,17|
      DUM=-2.D0*HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         HRRA(78))+&
                         ABy*(-4.D0*HRR(32)+&
                         ABz*(-4.D0*HRR(17)+&
                         2.D0*HRRA(53))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         HRRA(55))+&
                         2.D0*HRRA(81))+&
                         HRRA(114)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,17_z|
      DUM=-HRR(50)+&
                         ABz*(ABz*HRRB(50)+&
                         2.D0*HRRB(78))+&
                         ABy*(-2.D0*HRR(32)+&
                         ABz*(2.D0*ABz*HRRB(32)+&
                         4.D0*HRRB(53))+&
                         ABy*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         2.D0*HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(20_x,17|
      DUM=ABz*HRRA(77)+&
                         ABy*(2.D0*ABz*HRRA(52)+&
                         ABy*(ABz*HRRA(33)+&
                         HRRA(54))+&
                         2.D0*HRRA(80))+&
                         HRRA(113)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,17_x|
      DUM=ABz*HRRB(77)+&
                         ABy*(2.D0*ABz*HRRB(52)+&
                         ABy*(ABz*HRRB(33)+&
                         HRRB(54))+&
                         2.D0*HRRB(80))+&
                         ABx*(ABz*HRRB(53)+&
                         ABy*(2.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,17|
      DUM=ABz*HRRA(78)+&
                         ABy*(2.D0*ABz*HRRA(53)+&
                         ABy*(ABz*HRRA(34)+&
                         HRRA(55))+&
                         2.D0*HRRA(81))+&
                         HRRA(114)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,17_y|
      DUM=-2.D0*HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         HRRB(78))+&
                         ABy*(-2.D0*HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         3.D0*HRRB(53))+&
                         ABy*(3.D0*ABz*HRRB(34)+&
                         ABy*(ABz*HRRB(20)+&
                         HRRB(35))+&
                         3.D0*HRRB(55))+&
                         3.D0*HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,17|
      DUM=-3.D0*HRR(53)+&
                         ABz*(-3.D0*HRR(32)+&
                         HRRA(81))+&
                         ABy*(-6.D0*HRR(34)+&
                         ABz*(-6.D0*HRR(19)+&
                         2.D0*HRRA(55))+&
                         ABy*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         HRRA(56))+&
                         2.D0*HRRA(83))+&
                         HRRA(117)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,17_z|
      DUM=-HRR(53)+&
                         ABz*(ABz*HRRB(53)+&
                         2.D0*HRRB(81))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(2.D0*ABz*HRRB(34)+&
                         4.D0*HRRB(55))+&
                         ABy*(-HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         2.D0*HRRB(83))+&
                         HRRB(117)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(11_x,18|
      DUM=-3.D0*HRR(47)+&
                         ABz*(-6.D0*HRR(26)+&
                         ABz*(-3.D0*HRR(11)+&
                         HRRA(36))+&
                         2.D0*HRRA(64))+&
                         ABx*(-3.D0*HRR(30)+&
                         ABz*(-6.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(42))+&
                         HRRA(70))+&
                         HRRA(100)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,18_x|
      DUM=-HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(36))+&
                         2.D0*HRRB(64))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(21)+&
                         4.D0*HRRB(42))+&
                         ABx*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         2.D0*HRRB(70))+&
                         HRRB(100)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,18|
      DUM=ABz*(ABz*HRRA(37)+&
                         2.D0*HRRA(65))+&
                         ABx*(ABz*(ABz*HRRA(22)+&
                         2.D0*HRRA(43))+&
                         HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,18_y|
      DUM=ABz*(ABz*HRRB(37)+&
                         2.D0*HRRB(65))+&
                         ABy*(ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         HRRB(70))+&
                         ABx*(ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,18|
      DUM=ABz*(ABz*HRRA(42)+&
                         2.D0*HRRA(70))+&
                         ABx*(ABz*(ABz*HRRA(26)+&
                         2.D0*HRRA(47))+&
                         HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,18_z|
      DUM=-2.D0*HRR(42)+&
                         ABz*(-2.D0*HRR(21)+&
                         ABz*(ABz*HRRB(21)+&
                         3.D0*HRRB(42))+&
                         3.D0*HRRB(70))+&
                         ABx*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(12_x,18|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-4.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         2.D0*HRRA(65))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(43))+&
                         HRRA(71))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,18_x|
      DUM=-HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(37))+&
                         2.D0*HRRB(65))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(22)+&
                         4.D0*HRRB(43))+&
                         ABx*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         2.D0*HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,18|
      DUM=-HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(38))+&
                         2.D0*HRRA(66))+&
                         ABx*(-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,18_y|
      DUM=ABz*(ABz*HRRB(38)+&
                         2.D0*HRRB(66))+&
                         ABy*(ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         HRRB(71))+&
                         ABx*(ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,18|
      DUM=ABz*(ABz*HRRA(43)+&
                         2.D0*HRRA(71))+&
                         ABx*(ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,18_z|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(71))+&
                         ABx*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(13_x,18|
      DUM=-HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(38))+&
                         2.D0*HRRA(66))+&
                         ABx*(-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,18_x|
      DUM=-HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(38))+&
                         2.D0*HRRB(66))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(23)+&
                         4.D0*HRRB(44))+&
                         ABx*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         2.D0*HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,18|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-4.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         2.D0*HRRA(67))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(45))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,18_y|
      DUM=ABz*(ABz*HRRB(39)+&
                         2.D0*HRRB(67))+&
                         ABy*(ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         HRRB(72))+&
                         ABx*(ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,18|
      DUM=ABz*(ABz*HRRA(44)+&
                         2.D0*HRRA(72))+&
                         ABx*(ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,18_z|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(72))+&
                         ABx*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(14_x,18|
      DUM=ABz*(ABz*HRRA(39)+&
                         2.D0*HRRA(67))+&
                         ABx*(ABz*(ABz*HRRA(24)+&
                         2.D0*HRRA(45))+&
                         HRRA(73))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,18_x|
      DUM=-HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(39))+&
                         2.D0*HRRB(67))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(24)+&
                         4.D0*HRRB(45))+&
                         ABx*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         2.D0*HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,18|
      DUM=-3.D0*HRR(49)+&
                         ABz*(-6.D0*HRR(28)+&
                         ABz*(-3.D0*HRR(13)+&
                         HRRA(40))+&
                         2.D0*HRRA(68))+&
                         ABx*(-3.D0*HRR(32)+&
                         ABz*(-6.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(46))+&
                         HRRA(74))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,18_y|
      DUM=ABz*(ABz*HRRB(40)+&
                         2.D0*HRRB(68))+&
                         ABy*(ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         HRRB(73))+&
                         ABx*(ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,18|
      DUM=ABz*(ABz*HRRA(45)+&
                         2.D0*HRRA(73))+&
                         ABx*(ABz*(ABz*HRRA(29)+&
                         2.D0*HRRA(50))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,18_z|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(73))+&
                         ABx*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(15_x,18|
      DUM=-2.D0*HRR(51)+&
                         ABz*(-4.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(42))+&
                         2.D0*HRRA(70))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(47))+&
                         HRRA(75))+&
                         HRRA(106)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,18_x|
      DUM=-HRR(51)+&
                         ABz*(-2.D0*HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(42))+&
                         2.D0*HRRB(70))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(26)+&
                         4.D0*HRRB(47))+&
                         ABx*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         2.D0*HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,18|
      DUM=ABz*(ABz*HRRA(43)+&
                         2.D0*HRRA(71))+&
                         ABx*(ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,18_y|
      DUM=ABz*(ABz*HRRB(43)+&
                         2.D0*HRRB(71))+&
                         ABy*(ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         HRRB(75))+&
                         ABx*(ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,18|
      DUM=-HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(47))+&
                         2.D0*HRRA(75))+&
                         ABx*(-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79))+&
                         HRRA(111)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,18_z|
      DUM=-2.D0*HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         ABz*(ABz*HRRB(26)+&
                         3.D0*HRRB(47))+&
                         3.D0*HRRB(75))+&
                         ABx*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(16_x,18|
      DUM=-HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(43))+&
                         2.D0*HRRA(71))+&
                         ABx*(-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,18_x|
      DUM=-HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(43))+&
                         2.D0*HRRB(71))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(27)+&
                         4.D0*HRRB(48))+&
                         ABx*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         2.D0*HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,18|
      DUM=-HRR(51)+&
                         ABz*(-2.D0*HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRA(44))+&
                         2.D0*HRRA(72))+&
                         ABx*(-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,18_y|
      DUM=ABz*(ABz*HRRB(44)+&
                         2.D0*HRRB(72))+&
                         ABy*(ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         HRRB(76))+&
                         ABx*(ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,18|
      DUM=-HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         2.D0*HRRA(76))+&
                         ABx*(-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,18_z|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(76))+&
                         ABx*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(17_x,18|
      DUM=ABz*(ABz*HRRA(44)+&
                         2.D0*HRRA(72))+&
                         ABx*(ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,18_x|
      DUM=-HRR(53)+&
                         ABz*(-2.D0*HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(44))+&
                         2.D0*HRRB(72))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(28)+&
                         4.D0*HRRB(49))+&
                         ABx*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         2.D0*HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,18|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-4.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(45))+&
                         2.D0*HRRA(73))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(50))+&
                         HRRA(78))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,18_y|
      DUM=ABz*(ABz*HRRB(45)+&
                         2.D0*HRRB(73))+&
                         ABy*(ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         HRRB(77))+&
                         ABx*(ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,18|
      DUM=-HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         2.D0*HRRA(77))+&
                         ABx*(-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,18_z|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(77))+&
                         ABx*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(18_x,18|
      DUM=-HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(47))+&
                         2.D0*HRRA(75))+&
                         ABx*(-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79))+&
                         HRRA(111)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,18_x|
      DUM=-HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(47))+&
                         2.D0*HRRB(75))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(30)+&
                         4.D0*HRRB(51))+&
                         ABx*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         2.D0*HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,18|
      DUM=ABz*(ABz*HRRA(48)+&
                         2.D0*HRRA(76))+&
                         ABx*(ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,18_y|
      DUM=ABz*(ABz*HRRB(48)+&
                         2.D0*HRRB(76))+&
                         ABy*(ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         HRRB(79))+&
                         ABx*(ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,18|
      DUM=-2.D0*HRR(51)+&
                         ABz*(-4.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         2.D0*HRRA(79))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(54))+&
                         HRRA(82))+&
                         HRRA(115)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,18_z|
      DUM=-2.D0*HRR(51)+&
                         ABz*(-2.D0*HRR(30)+&
                         ABz*(ABz*HRRB(30)+&
                         3.D0*HRRB(51))+&
                         3.D0*HRRB(79))+&
                         ABx*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         HRRB(82))+&
                         HRRB(115)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(19_x,18|
      DUM=ABz*(ABz*HRRA(48)+&
                         2.D0*HRRA(76))+&
                         ABx*(ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(112)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,18_x|
      DUM=-HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(48))+&
                         2.D0*HRRB(76))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(31)+&
                         4.D0*HRRB(52))+&
                         ABx*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         2.D0*HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,18|
      DUM=-HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRA(49))+&
                         2.D0*HRRA(77))+&
                         ABx*(-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81))+&
                         HRRA(113)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,18_y|
      DUM=ABz*(ABz*HRRB(49)+&
                         2.D0*HRRB(77))+&
                         ABy*(ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         HRRB(80))+&
                         ABx*(ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,18|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-4.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         2.D0*HRRA(80))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(55))+&
                         HRRA(83))+&
                         HRRA(116)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,18_z|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(80))+&
                         ABx*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         HRRB(83))+&
                         HRRB(116)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(20_x,18|
      DUM=ABz*(ABz*HRRA(51)+&
                         2.D0*HRRA(79))+&
                         ABx*(ABz*(ABz*HRRA(33)+&
                         2.D0*HRRA(54))+&
                         HRRA(82))+&
                         HRRA(115)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,18_x|
      DUM=-HRR(56)+&
                         ABz*(-2.D0*HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(51))+&
                         2.D0*HRRB(79))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(33)+&
                         4.D0*HRRB(54))+&
                         ABx*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         2.D0*HRRB(82))+&
                         HRRB(115)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,18|
      DUM=ABz*(ABz*HRRA(52)+&
                         2.D0*HRRA(80))+&
                         ABx*(ABz*(ABz*HRRA(34)+&
                         2.D0*HRRA(55))+&
                         HRRA(83))+&
                         HRRA(116)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,18_y|
      DUM=ABz*(ABz*HRRB(52)+&
                         2.D0*HRRB(80))+&
                         ABy*(ABz*(ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         HRRB(82))+&
                         ABx*(ABz*(ABz*HRRB(34)+&
                         2.D0*HRRB(55))+&
                         ABy*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83))+&
                         HRRB(116)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,18|
      DUM=-3.D0*HRR(54)+&
                         ABz*(-6.D0*HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         HRRA(54))+&
                         2.D0*HRRA(82))+&
                         ABx*(-3.D0*HRR(35)+&
                         ABz*(-6.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(56))+&
                         HRRA(84))+&
                         HRRA(118)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,18_z|
      DUM=-2.D0*HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         ABz*(ABz*HRRB(33)+&
                         3.D0*HRRB(54))+&
                         3.D0*HRRB(82))+&
                         ABx*(-2.D0*HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         3.D0*HRRB(35))+&
                         3.D0*HRRB(56))+&
                         HRRB(84))+&
                         HRRB(118)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(11_x,19|
      DUM=-3.D0*HRR(48)+&
                         ABz*(-6.D0*HRR(27)+&
                         ABz*(-3.D0*HRR(12)+&
                         HRRA(37))+&
                         2.D0*HRRA(65))+&
                         ABy*(-3.D0*HRR(30)+&
                         ABz*(-6.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(42))+&
                         HRRA(70))+&
                         HRRA(101)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,19_x|
      DUM=ABz*(ABz*HRRB(37)+&
                         2.D0*HRRB(65))+&
                         ABy*(ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         HRRB(70))+&
                         ABx*(ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         HRRB(71))+&
                         HRRB(101)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,19|
      DUM=ABz*(ABz*HRRA(38)+&
                         2.D0*HRRA(66))+&
                         ABy*(ABz*(ABz*HRRA(22)+&
                         2.D0*HRRA(43))+&
                         HRRA(71))+&
                         HRRA(102)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,19_y|
      DUM=-HRR(47)+&
                         ABz*(-2.D0*HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(38))+&
                         2.D0*HRRB(66))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(22)+&
                         4.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         2.D0*HRRB(71))+&
                         HRRB(102)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,19|
      DUM=ABz*(ABz*HRRA(43)+&
                         2.D0*HRRA(71))+&
                         ABy*(ABz*(ABz*HRRA(26)+&
                         2.D0*HRRA(47))+&
                         HRRA(75))+&
                         HRRA(107)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,19_z|
      DUM=-2.D0*HRR(43)+&
                         ABz*(-2.D0*HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(71))+&
                         ABy*(-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         HRRB(75))+&
                         HRRB(107)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(12_x,19|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-4.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(38))+&
                         2.D0*HRRA(66))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(43))+&
                         HRRA(71))+&
                         HRRA(102)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,19_x|
      DUM=ABz*(ABz*HRRB(38)+&
                         2.D0*HRRB(66))+&
                         ABy*(ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         HRRB(71))+&
                         ABx*(ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         HRRB(72))+&
                         HRRB(102)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,19|
      DUM=-HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(39))+&
                         2.D0*HRRA(67))+&
                         ABy*(-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,19_y|
      DUM=-HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(39))+&
                         2.D0*HRRB(67))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(23)+&
                         4.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         2.D0*HRRB(72))+&
                         HRRB(103)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,19|
      DUM=ABz*(ABz*HRRA(44)+&
                         2.D0*HRRA(72))+&
                         ABy*(ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(108)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,19_z|
      DUM=-2.D0*HRR(44)+&
                         ABz*(-2.D0*HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(72))+&
                         ABy*(-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         HRRB(76))+&
                         HRRB(108)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(13_x,19|
      DUM=-HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(39))+&
                         2.D0*HRRA(67))+&
                         ABy*(-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         HRRA(72))+&
                         HRRA(103)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,19_x|
      DUM=ABz*(ABz*HRRB(39)+&
                         2.D0*HRRB(67))+&
                         ABy*(ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         HRRB(72))+&
                         ABx*(ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         HRRB(73))+&
                         HRRB(103)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,19|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-4.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(40))+&
                         2.D0*HRRA(68))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(45))+&
                         HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,19_y|
      DUM=-HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(40))+&
                         2.D0*HRRB(68))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(24)+&
                         4.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         2.D0*HRRB(73))+&
                         HRRB(104)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,19|
      DUM=ABz*(ABz*HRRA(45)+&
                         2.D0*HRRA(73))+&
                         ABy*(ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,19_z|
      DUM=-2.D0*HRR(45)+&
                         ABz*(-2.D0*HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(73))+&
                         ABy*(-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(14_x,19|
      DUM=ABz*(ABz*HRRA(40)+&
                         2.D0*HRRA(68))+&
                         ABy*(ABz*(ABz*HRRA(24)+&
                         2.D0*HRRA(45))+&
                         HRRA(73))+&
                         HRRA(104)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,19_x|
      DUM=ABz*(ABz*HRRB(40)+&
                         2.D0*HRRB(68))+&
                         ABy*(ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         HRRB(73))+&
                         ABx*(ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         HRRB(74))+&
                         HRRB(104)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,19|
      DUM=-3.D0*HRR(50)+&
                         ABz*(-6.D0*HRR(29)+&
                         ABz*(-3.D0*HRR(14)+&
                         HRRA(41))+&
                         2.D0*HRRA(69))+&
                         ABy*(-3.D0*HRR(32)+&
                         ABz*(-6.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(46))+&
                         HRRA(74))+&
                         HRRA(105)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,19_y|
      DUM=-HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(41))+&
                         2.D0*HRRB(69))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(25)+&
                         4.D0*HRRB(46))+&
                         ABy*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         HRRB(50))+&
                         2.D0*HRRB(74))+&
                         HRRB(105)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,19|
      DUM=ABz*(ABz*HRRA(46)+&
                         2.D0*HRRA(74))+&
                         ABy*(ABz*(ABz*HRRA(29)+&
                         2.D0*HRRA(50))+&
                         HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,19_z|
      DUM=-2.D0*HRR(46)+&
                         ABz*(-2.D0*HRR(25)+&
                         ABz*(ABz*HRRB(25)+&
                         3.D0*HRRB(46))+&
                         3.D0*HRRB(74))+&
                         ABy*(-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(15_x,19|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-4.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(43))+&
                         2.D0*HRRA(71))+&
                         ABy*(-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(47))+&
                         HRRA(75))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,19_x|
      DUM=ABz*(ABz*HRRB(43)+&
                         2.D0*HRRB(71))+&
                         ABy*(ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         HRRB(75))+&
                         ABx*(ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,19|
      DUM=ABz*(ABz*HRRA(44)+&
                         2.D0*HRRA(72))+&
                         ABy*(ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,19_y|
      DUM=-HRR(51)+&
                         ABz*(-2.D0*HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(44))+&
                         2.D0*HRRB(72))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(27)+&
                         4.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         2.D0*HRRB(76))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,19|
      DUM=-HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         2.D0*HRRA(76))+&
                         ABy*(-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,19_z|
      DUM=-2.D0*HRR(48)+&
                         ABz*(-2.D0*HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(76))+&
                         ABy*(-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         HRRB(79))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(16_x,19|
      DUM=-HRR(53)+&
                         ABz*(-2.D0*HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRA(44))+&
                         2.D0*HRRA(72))+&
                         ABy*(-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(48))+&
                         HRRA(76))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,19_x|
      DUM=ABz*(ABz*HRRB(44)+&
                         2.D0*HRRB(72))+&
                         ABy*(ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         HRRB(76))+&
                         ABx*(ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,19|
      DUM=-HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(45))+&
                         2.D0*HRRA(73))+&
                         ABy*(-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,19_y|
      DUM=-HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(45))+&
                         2.D0*HRRB(73))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(28)+&
                         4.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         2.D0*HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,19|
      DUM=-HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         2.D0*HRRA(77))+&
                         ABy*(-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,19_z|
      DUM=-2.D0*HRR(49)+&
                         ABz*(-2.D0*HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(77))+&
                         ABy*(-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         HRRB(80))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(17_x,19|
      DUM=ABz*(ABz*HRRA(45)+&
                         2.D0*HRRA(73))+&
                         ABy*(ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         HRRA(77))+&
                         HRRA(109)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,19_x|
      DUM=ABz*(ABz*HRRB(45)+&
                         2.D0*HRRB(73))+&
                         ABy*(ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         HRRB(77))+&
                         ABx*(ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,19|
      DUM=-2.D0*HRR(53)+&
                         ABz*(-4.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(46))+&
                         2.D0*HRRA(74))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(50))+&
                         HRRA(78))+&
                         HRRA(110)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,19_y|
      DUM=-HRR(53)+&
                         ABz*(-2.D0*HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(46))+&
                         2.D0*HRRB(74))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(29)+&
                         4.D0*HRRB(50))+&
                         ABy*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         HRRB(53))+&
                         2.D0*HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,19|
      DUM=-HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(50))+&
                         2.D0*HRRA(78))+&
                         ABy*(-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81))+&
                         HRRA(114)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,19_z|
      DUM=-2.D0*HRR(50)+&
                         ABz*(-2.D0*HRR(29)+&
                         ABz*(ABz*HRRB(29)+&
                         3.D0*HRRB(50))+&
                         3.D0*HRRB(78))+&
                         ABy*(-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(18_x,19|
      DUM=-HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(48))+&
                         2.D0*HRRA(76))+&
                         ABy*(-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         HRRA(79))+&
                         HRRA(112)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,19_x|
      DUM=ABz*(ABz*HRRB(48)+&
                         2.D0*HRRB(76))+&
                         ABy*(ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         HRRB(79))+&
                         ABx*(ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,19|
      DUM=ABz*(ABz*HRRA(49)+&
                         2.D0*HRRA(77))+&
                         ABy*(ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(113)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,19_y|
      DUM=-HRR(54)+&
                         ABz*(-2.D0*HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(49))+&
                         2.D0*HRRB(77))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(31)+&
                         4.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         2.D0*HRRB(80))+&
                         HRRB(113)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,19|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-4.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         2.D0*HRRA(80))+&
                         ABy*(-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(54))+&
                         HRRA(82))+&
                         HRRA(116)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,19_z|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-2.D0*HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(80))+&
                         ABy*(-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         HRRB(82))+&
                         HRRB(116)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(19_x,19|
      DUM=ABz*(ABz*HRRA(49)+&
                         2.D0*HRRA(77))+&
                         ABy*(ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         HRRA(80))+&
                         HRRA(113)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,19_x|
      DUM=ABz*(ABz*HRRB(49)+&
                         2.D0*HRRB(77))+&
                         ABy*(ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         HRRB(80))+&
                         ABx*(ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,19|
      DUM=-HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRA(50))+&
                         2.D0*HRRA(78))+&
                         ABy*(-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         HRRA(81))+&
                         HRRA(114)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,19_y|
      DUM=-HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(50))+&
                         2.D0*HRRB(78))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(32)+&
                         4.D0*HRRB(53))+&
                         ABy*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         HRRB(55))+&
                         2.D0*HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,19|
      DUM=-2.D0*HRR(53)+&
                         ABz*(-4.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(53))+&
                         2.D0*HRRA(81))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(55))+&
                         HRRA(83))+&
                         HRRA(117)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,19_z|
      DUM=-2.D0*HRR(53)+&
                         ABz*(-2.D0*HRR(32)+&
                         ABz*(ABz*HRRB(32)+&
                         3.D0*HRRB(53))+&
                         3.D0*HRRB(81))+&
                         ABy*(-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         HRRB(83))+&
                         HRRB(117)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(20_x,19|
      DUM=ABz*(ABz*HRRA(52)+&
                         2.D0*HRRA(80))+&
                         ABy*(ABz*(ABz*HRRA(33)+&
                         2.D0*HRRA(54))+&
                         HRRA(82))+&
                         HRRA(116)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,19_x|
      DUM=ABz*(ABz*HRRB(52)+&
                         2.D0*HRRB(80))+&
                         ABy*(ABz*(ABz*HRRB(33)+&
                         2.D0*HRRB(54))+&
                         HRRB(82))+&
                         ABx*(ABz*(ABz*HRRB(34)+&
                         2.D0*HRRB(55))+&
                         ABy*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83))+&
                         HRRB(116)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,19|
      DUM=ABz*(ABz*HRRA(53)+&
                         2.D0*HRRA(81))+&
                         ABy*(ABz*(ABz*HRRA(34)+&
                         2.D0*HRRA(55))+&
                         HRRA(83))+&
                         HRRA(117)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,19_y|
      DUM=-HRR(56)+&
                         ABz*(-2.D0*HRR(35)+&
                         ABz*(-HRR(20)+&
                         HRRB(53))+&
                         2.D0*HRRB(81))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(34)+&
                         4.D0*HRRB(55))+&
                         ABy*(ABz*(ABz*HRRB(20)+&
                         2.D0*HRRB(35))+&
                         HRRB(56))+&
                         2.D0*HRRB(83))+&
                         HRRB(117)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,19|
      DUM=-3.D0*HRR(55)+&
                         ABz*(-6.D0*HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         HRRA(55))+&
                         2.D0*HRRA(83))+&
                         ABy*(-3.D0*HRR(35)+&
                         ABz*(-6.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         2.D0*HRRA(56))+&
                         HRRA(84))+&
                         HRRA(119)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,19_z|
      DUM=-2.D0*HRR(55)+&
                         ABz*(-2.D0*HRR(34)+&
                         ABz*(ABz*HRRB(34)+&
                         3.D0*HRRB(55))+&
                         3.D0*HRRB(83))+&
                         ABy*(-2.D0*HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         3.D0*HRRB(35))+&
                         3.D0*HRRB(56))+&
                         HRRB(84))+&
                         HRRB(119)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(11_x,20|
      DUM=-3.D0*HRR(51)+&
                         ABz*(-9.D0*HRR(30)+&
                         ABz*(-9.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         HRRA(21))+&
                         3.D0*HRRA(42))+&
                         3.D0*HRRA(70))+&
                         HRRA(106)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(11,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(21)+&
                         3.D0*HRRB(42))+&
                         3.D0*HRRB(70))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         HRRB(75))+&
                         HRRB(106)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(11_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(22)+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(71))+&
                         HRRA(107)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(11,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(22)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(71))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         HRRB(75))+&
                         HRRB(107)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(11_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(26)+&
                         3.D0*HRRA(47))+&
                         3.D0*HRRA(75))+&
                         HRRA(111)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(11,20_z|
      DUM=-3.D0*HRR(47)+&
                         ABz*(-6.D0*HRR(26)+&
                         ABz*(-3.D0*HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         4.D0*HRRB(26))+&
                         6.D0*HRRB(47))+&
                         4.D0*HRRB(75))+&
                         HRRB(111)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(12_x,20|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-6.D0*HRR(31)+&
                         ABz*(-6.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         3.D0*HRRA(43))+&
                         3.D0*HRRA(71))+&
                         HRRA(107)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(12,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(22)+&
                         3.D0*HRRB(43))+&
                         3.D0*HRRB(71))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         HRRB(76))+&
                         HRRB(107)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(12_y,20|
      DUM=-HRR(51)+&
                         ABz*(-3.D0*HRR(30)+&
                         ABz*(-3.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(72))+&
                         HRRA(108)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(12,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(23)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(72))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         HRRB(76))+&
                         HRRB(108)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(12_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(27)+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(76))+&
                         HRRA(112)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(12,20_z|
      DUM=-3.D0*HRR(48)+&
                         ABz*(-6.D0*HRR(27)+&
                         ABz*(-3.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         4.D0*HRRB(27))+&
                         6.D0*HRRB(48))+&
                         4.D0*HRRB(76))+&
                         HRRB(112)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(13_x,20|
      DUM=-HRR(53)+&
                         ABz*(-3.D0*HRR(32)+&
                         ABz*(-3.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         3.D0*HRRA(44))+&
                         3.D0*HRRA(72))+&
                         HRRA(108)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(13,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(23)+&
                         3.D0*HRRB(44))+&
                         3.D0*HRRB(72))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         HRRB(77))+&
                         HRRB(108)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(13_y,20|
      DUM=-2.D0*HRR(52)+&
                         ABz*(-6.D0*HRR(31)+&
                         ABz*(-6.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(73))+&
                         HRRA(109)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(13,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(24)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(73))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         HRRB(77))+&
                         HRRB(109)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(13_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(28)+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(77))+&
                         HRRA(113)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(13,20_z|
      DUM=-3.D0*HRR(49)+&
                         ABz*(-6.D0*HRR(28)+&
                         ABz*(-3.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         4.D0*HRRB(28))+&
                         6.D0*HRRB(49))+&
                         4.D0*HRRB(77))+&
                         HRRB(113)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(14_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(24)+&
                         3.D0*HRRA(45))+&
                         3.D0*HRRA(73))+&
                         HRRA(109)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(14,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(24)+&
                         3.D0*HRRB(45))+&
                         3.D0*HRRB(73))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         HRRB(78))+&
                         HRRB(109)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(14_y,20|
      DUM=-3.D0*HRR(53)+&
                         ABz*(-9.D0*HRR(32)+&
                         ABz*(-9.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         HRRA(25))+&
                         3.D0*HRRA(46))+&
                         3.D0*HRRA(74))+&
                         HRRA(110)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(14,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(25)+&
                         3.D0*HRRB(46))+&
                         3.D0*HRRB(74))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         HRRB(78))+&
                         HRRB(110)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(14_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(29)+&
                         3.D0*HRRA(50))+&
                         3.D0*HRRA(78))+&
                         HRRA(114)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(14,20_z|
      DUM=-3.D0*HRR(50)+&
                         ABz*(-6.D0*HRR(29)+&
                         ABz*(-3.D0*HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         4.D0*HRRB(29))+&
                         6.D0*HRRB(50))+&
                         4.D0*HRRB(78))+&
                         HRRB(114)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(15_x,20|
      DUM=-2.D0*HRR(54)+&
                         ABz*(-6.D0*HRR(33)+&
                         ABz*(-6.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(26))+&
                         3.D0*HRRA(47))+&
                         3.D0*HRRA(75))+&
                         HRRA(111)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(15,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(26)+&
                         3.D0*HRRB(47))+&
                         3.D0*HRRB(75))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         HRRB(79))+&
                         HRRB(111)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(15_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(27)+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(76))+&
                         HRRA(112)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(15,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(27)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(76))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         HRRB(79))+&
                         HRRB(112)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(15_z,20|
      DUM=-HRR(51)+&
                         ABz*(-3.D0*HRR(30)+&
                         ABz*(-3.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         3.D0*HRRA(51))+&
                         3.D0*HRRA(79))+&
                         HRRA(115)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(15,20_z|
      DUM=-3.D0*HRR(51)+&
                         ABz*(-6.D0*HRR(30)+&
                         ABz*(-3.D0*HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         4.D0*HRRB(30))+&
                         6.D0*HRRB(51))+&
                         4.D0*HRRB(79))+&
                         HRRB(115)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(16_x,20|
      DUM=-HRR(55)+&
                         ABz*(-3.D0*HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         3.D0*HRRA(48))+&
                         3.D0*HRRA(76))+&
                         HRRA(112)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(16,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(27)+&
                         3.D0*HRRB(48))+&
                         3.D0*HRRB(76))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         HRRB(80))+&
                         HRRB(112)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(16_y,20|
      DUM=-HRR(54)+&
                         ABz*(-3.D0*HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(77))+&
                         HRRA(113)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(16,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(28)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(77))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         HRRB(80))+&
                         HRRB(113)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(16_z,20|
      DUM=-HRR(52)+&
                         ABz*(-3.D0*HRR(31)+&
                         ABz*(-3.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(80))+&
                         HRRA(116)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(16,20_z|
      DUM=-3.D0*HRR(52)+&
                         ABz*(-6.D0*HRR(31)+&
                         ABz*(-3.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         4.D0*HRRB(31))+&
                         6.D0*HRRB(52))+&
                         4.D0*HRRB(80))+&
                         HRRB(116)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+6)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(17_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(28)+&
                         3.D0*HRRA(49))+&
                         3.D0*HRRA(77))+&
                         HRRA(113)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(17,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(28)+&
                         3.D0*HRRB(49))+&
                         3.D0*HRRB(77))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         HRRB(81))+&
                         HRRB(113)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(17_y,20|
      DUM=-2.D0*HRR(55)+&
                         ABz*(-6.D0*HRR(34)+&
                         ABz*(-6.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(29))+&
                         3.D0*HRRA(50))+&
                         3.D0*HRRA(78))+&
                         HRRA(114)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(17,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(29)+&
                         3.D0*HRRB(50))+&
                         3.D0*HRRB(78))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         HRRB(81))+&
                         HRRB(114)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(17_z,20|
      DUM=-HRR(53)+&
                         ABz*(-3.D0*HRR(32)+&
                         ABz*(-3.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         3.D0*HRRA(53))+&
                         3.D0*HRRA(81))+&
                         HRRA(117)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(17,20_z|
      DUM=-3.D0*HRR(53)+&
                         ABz*(-6.D0*HRR(32)+&
                         ABz*(-3.D0*HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         4.D0*HRRB(32))+&
                         6.D0*HRRB(53))+&
                         4.D0*HRRB(81))+&
                         HRRB(117)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+7)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(18_x,20|
      DUM=-HRR(56)+&
                         ABz*(-3.D0*HRR(35)+&
                         ABz*(-3.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(30))+&
                         3.D0*HRRA(51))+&
                         3.D0*HRRA(79))+&
                         HRRA(115)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(18,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(30)+&
                         3.D0*HRRB(51))+&
                         3.D0*HRRB(79))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         HRRB(82))+&
                         HRRB(115)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(18_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(31)+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(80))+&
                         HRRA(116)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(18,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(31)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(80))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         HRRB(82))+&
                         HRRB(116)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(18_z,20|
      DUM=-2.D0*HRR(54)+&
                         ABz*(-6.D0*HRR(33)+&
                         ABz*(-6.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         3.D0*HRRA(54))+&
                         3.D0*HRRA(82))+&
                         HRRA(118)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(18,20_z|
      DUM=-3.D0*HRR(54)+&
                         ABz*(-6.D0*HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         4.D0*HRRB(33))+&
                         6.D0*HRRB(54))+&
                         4.D0*HRRB(82))+&
                         HRRB(118)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+8)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(19_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(31)+&
                         3.D0*HRRA(52))+&
                         3.D0*HRRA(80))+&
                         HRRA(116)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(19,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(31)+&
                         3.D0*HRRB(52))+&
                         3.D0*HRRB(80))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         HRRB(83))+&
                         HRRB(116)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(19_y,20|
      DUM=-HRR(56)+&
                         ABz*(-3.D0*HRR(35)+&
                         ABz*(-3.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRA(32))+&
                         3.D0*HRRA(53))+&
                         3.D0*HRRA(81))+&
                         HRRA(117)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(19,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(32)+&
                         3.D0*HRRB(53))+&
                         3.D0*HRRB(81))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         HRRB(83))+&
                         HRRB(117)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(19_z,20|
      DUM=-2.D0*HRR(55)+&
                         ABz*(-6.D0*HRR(34)+&
                         ABz*(-6.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         3.D0*HRRA(55))+&
                         3.D0*HRRA(83))+&
                         HRRA(119)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(19,20_z|
      DUM=-3.D0*HRR(55)+&
                         ABz*(-6.D0*HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         4.D0*HRRB(34))+&
                         6.D0*HRRB(55))+&
                         4.D0*HRRB(83))+&
                         HRRB(119)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+9)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(20_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(33)+&
                         3.D0*HRRA(54))+&
                         3.D0*HRRA(82))+&
                         HRRA(118)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(20,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(33)+&
                         3.D0*HRRB(54))+&
                         3.D0*HRRB(82))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(20)+&
                         3.D0*HRRB(35))+&
                         3.D0*HRRB(56))+&
                         HRRB(84))+&
                         HRRB(118)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(20_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(34)+&
                         3.D0*HRRA(55))+&
                         3.D0*HRRA(83))+&
                         HRRA(119)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(20,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(34)+&
                         3.D0*HRRB(55))+&
                         3.D0*HRRB(83))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(20)+&
                         3.D0*HRRB(35))+&
                         3.D0*HRRB(56))+&
                         HRRB(84))+&
                         HRRB(119)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(20_z,20|
      DUM=-3.D0*HRR(56)+&
                         ABz*(-9.D0*HRR(35)+&
                         ABz*(-9.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         HRRA(35))+&
                         3.D0*HRRA(56))+&
                         3.D0*HRRA(84))+&
                         HRRA(120)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(20,20_z|
      DUM=-3.D0*HRR(56)+&
                         ABz*(-6.D0*HRR(35)+&
                         ABz*(-3.D0*HRR(20)+&
                         ABz*(ABz*HRRB(20)+&
                         4.D0*HRRB(35))+&
                         6.D0*HRRB(56))+&
                         4.D0*HRRB(84))+&
                         HRRB(120)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
    END SUBROUTINE BraHRR1010ab
    SUBROUTINE BraHRR1010cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,Cart,HRR,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,Cart,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(11,11|
      DUM=ABx*(ABx*(ABx*HRR(11)+&
                                3.D0*HRR(21))+&
                                3.D0*HRR(36))+&
                                HRR(57)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(12,11|
      DUM=ABx*(ABx*(ABx*HRR(12)+&
                                3.D0*HRR(22))+&
                                3.D0*HRR(37))+&
                                HRR(58)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(13,11|
      DUM=ABx*(ABx*(ABx*HRR(13)+&
                                3.D0*HRR(23))+&
                                3.D0*HRR(38))+&
                                HRR(59)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(14,11|
      DUM=ABx*(ABx*(ABx*HRR(14)+&
                                3.D0*HRR(24))+&
                                3.D0*HRR(39))+&
                                HRR(60)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(15,11|
      DUM=ABx*(ABx*(ABx*HRR(15)+&
                                3.D0*HRR(26))+&
                                3.D0*HRR(42))+&
                                HRR(64)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(16,11|
      DUM=ABx*(ABx*(ABx*HRR(16)+&
                                3.D0*HRR(27))+&
                                3.D0*HRR(43))+&
                                HRR(65)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(17,11|
      DUM=ABx*(ABx*(ABx*HRR(17)+&
                                3.D0*HRR(28))+&
                                3.D0*HRR(44))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(18,11|
      DUM=ABx*(ABx*(ABx*HRR(18)+&
                                3.D0*HRR(30))+&
                                3.D0*HRR(47))+&
                                HRR(70)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(19,11|
      DUM=ABx*(ABx*(ABx*HRR(19)+&
                                3.D0*HRR(31))+&
                                3.D0*HRR(48))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(20,11|
      DUM=ABx*(ABx*(ABx*HRR(20)+&
                                3.D0*HRR(33))+&
                                3.D0*HRR(51))+&
                                HRR(75)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(11,12|
      DUM=ABy*HRR(36)+&
                                ABx*(2.D0*ABy*HRR(21)+&
                                ABx*(ABy*HRR(11)+&
                                HRR(22))+&
                                2.D0*HRR(37))+&
                                HRR(58)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(12,12|
      DUM=ABy*HRR(37)+&
                                ABx*(2.D0*ABy*HRR(22)+&
                                ABx*(ABy*HRR(12)+&
                                HRR(23))+&
                                2.D0*HRR(38))+&
                                HRR(59)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(13,12|
      DUM=ABy*HRR(38)+&
                                ABx*(2.D0*ABy*HRR(23)+&
                                ABx*(ABy*HRR(13)+&
                                HRR(24))+&
                                2.D0*HRR(39))+&
                                HRR(60)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(14,12|
      DUM=ABy*HRR(39)+&
                                ABx*(2.D0*ABy*HRR(24)+&
                                ABx*(ABy*HRR(14)+&
                                HRR(25))+&
                                2.D0*HRR(40))+&
                                HRR(61)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(15,12|
      DUM=ABy*HRR(42)+&
                                ABx*(2.D0*ABy*HRR(26)+&
                                ABx*(ABy*HRR(15)+&
                                HRR(27))+&
                                2.D0*HRR(43))+&
                                HRR(65)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(16,12|
      DUM=ABy*HRR(43)+&
                                ABx*(2.D0*ABy*HRR(27)+&
                                ABx*(ABy*HRR(16)+&
                                HRR(28))+&
                                2.D0*HRR(44))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(17,12|
      DUM=ABy*HRR(44)+&
                                ABx*(2.D0*ABy*HRR(28)+&
                                ABx*(ABy*HRR(17)+&
                                HRR(29))+&
                                2.D0*HRR(45))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(18,12|
      DUM=ABy*HRR(47)+&
                                ABx*(2.D0*ABy*HRR(30)+&
                                ABx*(ABy*HRR(18)+&
                                HRR(31))+&
                                2.D0*HRR(48))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(19,12|
      DUM=ABy*HRR(48)+&
                                ABx*(2.D0*ABy*HRR(31)+&
                                ABx*(ABy*HRR(19)+&
                                HRR(32))+&
                                2.D0*HRR(49))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(20,12|
      DUM=ABy*HRR(51)+&
                                ABx*(2.D0*ABy*HRR(33)+&
                                ABx*(ABy*HRR(20)+&
                                HRR(34))+&
                                2.D0*HRR(52))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(11,13|
      DUM=ABy*(ABy*HRR(21)+&
                                2.D0*HRR(37))+&
                                ABx*(ABy*(ABy*HRR(11)+&
                                2.D0*HRR(22))+&
                                HRR(38))+&
                                HRR(59)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(12,13|
      DUM=ABy*(ABy*HRR(22)+&
                                2.D0*HRR(38))+&
                                ABx*(ABy*(ABy*HRR(12)+&
                                2.D0*HRR(23))+&
                                HRR(39))+&
                                HRR(60)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(13,13|
      DUM=ABy*(ABy*HRR(23)+&
                                2.D0*HRR(39))+&
                                ABx*(ABy*(ABy*HRR(13)+&
                                2.D0*HRR(24))+&
                                HRR(40))+&
                                HRR(61)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(14,13|
      DUM=ABy*(ABy*HRR(24)+&
                                2.D0*HRR(40))+&
                                ABx*(ABy*(ABy*HRR(14)+&
                                2.D0*HRR(25))+&
                                HRR(41))+&
                                HRR(62)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(15,13|
      DUM=ABy*(ABy*HRR(26)+&
                                2.D0*HRR(43))+&
                                ABx*(ABy*(ABy*HRR(15)+&
                                2.D0*HRR(27))+&
                                HRR(44))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(16,13|
      DUM=ABy*(ABy*HRR(27)+&
                                2.D0*HRR(44))+&
                                ABx*(ABy*(ABy*HRR(16)+&
                                2.D0*HRR(28))+&
                                HRR(45))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(17,13|
      DUM=ABy*(ABy*HRR(28)+&
                                2.D0*HRR(45))+&
                                ABx*(ABy*(ABy*HRR(17)+&
                                2.D0*HRR(29))+&
                                HRR(46))+&
                                HRR(68)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(18,13|
      DUM=ABy*(ABy*HRR(30)+&
                                2.D0*HRR(48))+&
                                ABx*(ABy*(ABy*HRR(18)+&
                                2.D0*HRR(31))+&
                                HRR(49))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(19,13|
      DUM=ABy*(ABy*HRR(31)+&
                                2.D0*HRR(49))+&
                                ABx*(ABy*(ABy*HRR(19)+&
                                2.D0*HRR(32))+&
                                HRR(50))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(20,13|
      DUM=ABy*(ABy*HRR(33)+&
                                2.D0*HRR(52))+&
                                ABx*(ABy*(ABy*HRR(20)+&
                                2.D0*HRR(34))+&
                                HRR(53))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(11,14|
      DUM=ABy*(ABy*(ABy*HRR(11)+&
                                3.D0*HRR(22))+&
                                3.D0*HRR(38))+&
                                HRR(60)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(12,14|
      DUM=ABy*(ABy*(ABy*HRR(12)+&
                                3.D0*HRR(23))+&
                                3.D0*HRR(39))+&
                                HRR(61)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(13,14|
      DUM=ABy*(ABy*(ABy*HRR(13)+&
                                3.D0*HRR(24))+&
                                3.D0*HRR(40))+&
                                HRR(62)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(14,14|
      DUM=ABy*(ABy*(ABy*HRR(14)+&
                                3.D0*HRR(25))+&
                                3.D0*HRR(41))+&
                                HRR(63)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(15,14|
      DUM=ABy*(ABy*(ABy*HRR(15)+&
                                3.D0*HRR(27))+&
                                3.D0*HRR(44))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(16,14|
      DUM=ABy*(ABy*(ABy*HRR(16)+&
                                3.D0*HRR(28))+&
                                3.D0*HRR(45))+&
                                HRR(68)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(17,14|
      DUM=ABy*(ABy*(ABy*HRR(17)+&
                                3.D0*HRR(29))+&
                                3.D0*HRR(46))+&
                                HRR(69)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(18,14|
      DUM=ABy*(ABy*(ABy*HRR(18)+&
                                3.D0*HRR(31))+&
                                3.D0*HRR(49))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(19,14|
      DUM=ABy*(ABy*(ABy*HRR(19)+&
                                3.D0*HRR(32))+&
                                3.D0*HRR(50))+&
                                HRR(74)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(20,14|
      DUM=ABy*(ABy*(ABy*HRR(20)+&
                                3.D0*HRR(34))+&
                                3.D0*HRR(53))+&
                                HRR(78)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(11,15|
      DUM=ABz*HRR(36)+&
                                ABx*(2.D0*ABz*HRR(21)+&
                                ABx*(ABz*HRR(11)+&
                                HRR(26))+&
                                2.D0*HRR(42))+&
                                HRR(64)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(12,15|
      DUM=ABz*HRR(37)+&
                                ABx*(2.D0*ABz*HRR(22)+&
                                ABx*(ABz*HRR(12)+&
                                HRR(27))+&
                                2.D0*HRR(43))+&
                                HRR(65)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(13,15|
      DUM=ABz*HRR(38)+&
                                ABx*(2.D0*ABz*HRR(23)+&
                                ABx*(ABz*HRR(13)+&
                                HRR(28))+&
                                2.D0*HRR(44))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(14,15|
      DUM=ABz*HRR(39)+&
                                ABx*(2.D0*ABz*HRR(24)+&
                                ABx*(ABz*HRR(14)+&
                                HRR(29))+&
                                2.D0*HRR(45))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(15,15|
      DUM=ABz*HRR(42)+&
                                ABx*(2.D0*ABz*HRR(26)+&
                                ABx*(ABz*HRR(15)+&
                                HRR(30))+&
                                2.D0*HRR(47))+&
                                HRR(70)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(16,15|
      DUM=ABz*HRR(43)+&
                                ABx*(2.D0*ABz*HRR(27)+&
                                ABx*(ABz*HRR(16)+&
                                HRR(31))+&
                                2.D0*HRR(48))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(17,15|
      DUM=ABz*HRR(44)+&
                                ABx*(2.D0*ABz*HRR(28)+&
                                ABx*(ABz*HRR(17)+&
                                HRR(32))+&
                                2.D0*HRR(49))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(18,15|
      DUM=ABz*HRR(47)+&
                                ABx*(2.D0*ABz*HRR(30)+&
                                ABx*(ABz*HRR(18)+&
                                HRR(33))+&
                                2.D0*HRR(51))+&
                                HRR(75)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(19,15|
      DUM=ABz*HRR(48)+&
                                ABx*(2.D0*ABz*HRR(31)+&
                                ABx*(ABz*HRR(19)+&
                                HRR(34))+&
                                2.D0*HRR(52))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(20,15|
      DUM=ABz*HRR(51)+&
                                ABx*(2.D0*ABz*HRR(33)+&
                                ABx*(ABz*HRR(20)+&
                                HRR(35))+&
                                2.D0*HRR(54))+&
                                HRR(79)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(11,16|
      DUM=ABz*HRR(37)+&
                                ABy*(ABz*HRR(21)+&
                                HRR(42))+&
                                ABx*(ABz*HRR(22)+&
                                ABy*(ABz*HRR(11)+&
                                HRR(26))+&
                                HRR(43))+&
                                HRR(65)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(12,16|
      DUM=ABz*HRR(38)+&
                                ABy*(ABz*HRR(22)+&
                                HRR(43))+&
                                ABx*(ABz*HRR(23)+&
                                ABy*(ABz*HRR(12)+&
                                HRR(27))+&
                                HRR(44))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(13,16|
      DUM=ABz*HRR(39)+&
                                ABy*(ABz*HRR(23)+&
                                HRR(44))+&
                                ABx*(ABz*HRR(24)+&
                                ABy*(ABz*HRR(13)+&
                                HRR(28))+&
                                HRR(45))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(14,16|
      DUM=ABz*HRR(40)+&
                                ABy*(ABz*HRR(24)+&
                                HRR(45))+&
                                ABx*(ABz*HRR(25)+&
                                ABy*(ABz*HRR(14)+&
                                HRR(29))+&
                                HRR(46))+&
                                HRR(68)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(15,16|
      DUM=ABz*HRR(43)+&
                                ABy*(ABz*HRR(26)+&
                                HRR(47))+&
                                ABx*(ABz*HRR(27)+&
                                ABy*(ABz*HRR(15)+&
                                HRR(30))+&
                                HRR(48))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(16,16|
      DUM=ABz*HRR(44)+&
                                ABy*(ABz*HRR(27)+&
                                HRR(48))+&
                                ABx*(ABz*HRR(28)+&
                                ABy*(ABz*HRR(16)+&
                                HRR(31))+&
                                HRR(49))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(17,16|
      DUM=ABz*HRR(45)+&
                                ABy*(ABz*HRR(28)+&
                                HRR(49))+&
                                ABx*(ABz*HRR(29)+&
                                ABy*(ABz*HRR(17)+&
                                HRR(32))+&
                                HRR(50))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(18,16|
      DUM=ABz*HRR(48)+&
                                ABy*(ABz*HRR(30)+&
                                HRR(51))+&
                                ABx*(ABz*HRR(31)+&
                                ABy*(ABz*HRR(18)+&
                                HRR(33))+&
                                HRR(52))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(19,16|
      DUM=ABz*HRR(49)+&
                                ABy*(ABz*HRR(31)+&
                                HRR(52))+&
                                ABx*(ABz*HRR(32)+&
                                ABy*(ABz*HRR(19)+&
                                HRR(34))+&
                                HRR(53))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(20,16|
      DUM=ABz*HRR(52)+&
                                ABy*(ABz*HRR(33)+&
                                HRR(54))+&
                                ABx*(ABz*HRR(34)+&
                                ABy*(ABz*HRR(20)+&
                                HRR(35))+&
                                HRR(55))+&
                                HRR(80)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(11,17|
      DUM=ABz*HRR(38)+&
                                ABy*(2.D0*ABz*HRR(22)+&
                                ABy*(ABz*HRR(11)+&
                                HRR(26))+&
                                2.D0*HRR(43))+&
                                HRR(66)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(12,17|
      DUM=ABz*HRR(39)+&
                                ABy*(2.D0*ABz*HRR(23)+&
                                ABy*(ABz*HRR(12)+&
                                HRR(27))+&
                                2.D0*HRR(44))+&
                                HRR(67)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(13,17|
      DUM=ABz*HRR(40)+&
                                ABy*(2.D0*ABz*HRR(24)+&
                                ABy*(ABz*HRR(13)+&
                                HRR(28))+&
                                2.D0*HRR(45))+&
                                HRR(68)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(14,17|
      DUM=ABz*HRR(41)+&
                                ABy*(2.D0*ABz*HRR(25)+&
                                ABy*(ABz*HRR(14)+&
                                HRR(29))+&
                                2.D0*HRR(46))+&
                                HRR(69)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(15,17|
      DUM=ABz*HRR(44)+&
                                ABy*(2.D0*ABz*HRR(27)+&
                                ABy*(ABz*HRR(15)+&
                                HRR(30))+&
                                2.D0*HRR(48))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(16,17|
      DUM=ABz*HRR(45)+&
                                ABy*(2.D0*ABz*HRR(28)+&
                                ABy*(ABz*HRR(16)+&
                                HRR(31))+&
                                2.D0*HRR(49))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(17,17|
      DUM=ABz*HRR(46)+&
                                ABy*(2.D0*ABz*HRR(29)+&
                                ABy*(ABz*HRR(17)+&
                                HRR(32))+&
                                2.D0*HRR(50))+&
                                HRR(74)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(18,17|
      DUM=ABz*HRR(49)+&
                                ABy*(2.D0*ABz*HRR(31)+&
                                ABy*(ABz*HRR(18)+&
                                HRR(33))+&
                                2.D0*HRR(52))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(19,17|
      DUM=ABz*HRR(50)+&
                                ABy*(2.D0*ABz*HRR(32)+&
                                ABy*(ABz*HRR(19)+&
                                HRR(34))+&
                                2.D0*HRR(53))+&
                                HRR(78)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(20,17|
      DUM=ABz*HRR(53)+&
                                ABy*(2.D0*ABz*HRR(34)+&
                                ABy*(ABz*HRR(20)+&
                                HRR(35))+&
                                2.D0*HRR(55))+&
                                HRR(81)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(11,18|
      DUM=ABz*(ABz*HRR(21)+&
                                2.D0*HRR(42))+&
                                ABx*(ABz*(ABz*HRR(11)+&
                                2.D0*HRR(26))+&
                                HRR(47))+&
                                HRR(70)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(12,18|
      DUM=ABz*(ABz*HRR(22)+&
                                2.D0*HRR(43))+&
                                ABx*(ABz*(ABz*HRR(12)+&
                                2.D0*HRR(27))+&
                                HRR(48))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(13,18|
      DUM=ABz*(ABz*HRR(23)+&
                                2.D0*HRR(44))+&
                                ABx*(ABz*(ABz*HRR(13)+&
                                2.D0*HRR(28))+&
                                HRR(49))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(14,18|
      DUM=ABz*(ABz*HRR(24)+&
                                2.D0*HRR(45))+&
                                ABx*(ABz*(ABz*HRR(14)+&
                                2.D0*HRR(29))+&
                                HRR(50))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(15,18|
      DUM=ABz*(ABz*HRR(26)+&
                                2.D0*HRR(47))+&
                                ABx*(ABz*(ABz*HRR(15)+&
                                2.D0*HRR(30))+&
                                HRR(51))+&
                                HRR(75)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(16,18|
      DUM=ABz*(ABz*HRR(27)+&
                                2.D0*HRR(48))+&
                                ABx*(ABz*(ABz*HRR(16)+&
                                2.D0*HRR(31))+&
                                HRR(52))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(17,18|
      DUM=ABz*(ABz*HRR(28)+&
                                2.D0*HRR(49))+&
                                ABx*(ABz*(ABz*HRR(17)+&
                                2.D0*HRR(32))+&
                                HRR(53))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(18,18|
      DUM=ABz*(ABz*HRR(30)+&
                                2.D0*HRR(51))+&
                                ABx*(ABz*(ABz*HRR(18)+&
                                2.D0*HRR(33))+&
                                HRR(54))+&
                                HRR(79)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(19,18|
      DUM=ABz*(ABz*HRR(31)+&
                                2.D0*HRR(52))+&
                                ABx*(ABz*(ABz*HRR(19)+&
                                2.D0*HRR(34))+&
                                HRR(55))+&
                                HRR(80)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(20,18|
      DUM=ABz*(ABz*HRR(33)+&
                                2.D0*HRR(54))+&
                                ABx*(ABz*(ABz*HRR(20)+&
                                2.D0*HRR(35))+&
                                HRR(56))+&
                                HRR(82)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(11,19|
      DUM=ABz*(ABz*HRR(22)+&
                                2.D0*HRR(43))+&
                                ABy*(ABz*(ABz*HRR(11)+&
                                2.D0*HRR(26))+&
                                HRR(47))+&
                                HRR(71)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(12,19|
      DUM=ABz*(ABz*HRR(23)+&
                                2.D0*HRR(44))+&
                                ABy*(ABz*(ABz*HRR(12)+&
                                2.D0*HRR(27))+&
                                HRR(48))+&
                                HRR(72)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(13,19|
      DUM=ABz*(ABz*HRR(24)+&
                                2.D0*HRR(45))+&
                                ABy*(ABz*(ABz*HRR(13)+&
                                2.D0*HRR(28))+&
                                HRR(49))+&
                                HRR(73)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(14,19|
      DUM=ABz*(ABz*HRR(25)+&
                                2.D0*HRR(46))+&
                                ABy*(ABz*(ABz*HRR(14)+&
                                2.D0*HRR(29))+&
                                HRR(50))+&
                                HRR(74)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(15,19|
      DUM=ABz*(ABz*HRR(27)+&
                                2.D0*HRR(48))+&
                                ABy*(ABz*(ABz*HRR(15)+&
                                2.D0*HRR(30))+&
                                HRR(51))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(16,19|
      DUM=ABz*(ABz*HRR(28)+&
                                2.D0*HRR(49))+&
                                ABy*(ABz*(ABz*HRR(16)+&
                                2.D0*HRR(31))+&
                                HRR(52))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(17,19|
      DUM=ABz*(ABz*HRR(29)+&
                                2.D0*HRR(50))+&
                                ABy*(ABz*(ABz*HRR(17)+&
                                2.D0*HRR(32))+&
                                HRR(53))+&
                                HRR(78)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(18,19|
      DUM=ABz*(ABz*HRR(31)+&
                                2.D0*HRR(52))+&
                                ABy*(ABz*(ABz*HRR(18)+&
                                2.D0*HRR(33))+&
                                HRR(54))+&
                                HRR(80)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(19,19|
      DUM=ABz*(ABz*HRR(32)+&
                                2.D0*HRR(53))+&
                                ABy*(ABz*(ABz*HRR(19)+&
                                2.D0*HRR(34))+&
                                HRR(55))+&
                                HRR(81)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(20,19|
      DUM=ABz*(ABz*HRR(34)+&
                                2.D0*HRR(55))+&
                                ABy*(ABz*(ABz*HRR(20)+&
                                2.D0*HRR(35))+&
                                HRR(56))+&
                                HRR(83)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(11,20|
      DUM=ABz*(ABz*(ABz*HRR(11)+&
                                3.D0*HRR(26))+&
                                3.D0*HRR(47))+&
                                HRR(75)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(12,20|
      DUM=ABz*(ABz*(ABz*HRR(12)+&
                                3.D0*HRR(27))+&
                                3.D0*HRR(48))+&
                                HRR(76)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(13,20|
      DUM=ABz*(ABz*(ABz*HRR(13)+&
                                3.D0*HRR(28))+&
                                3.D0*HRR(49))+&
                                HRR(77)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(14,20|
      DUM=ABz*(ABz*(ABz*HRR(14)+&
                                3.D0*HRR(29))+&
                                3.D0*HRR(50))+&
                                HRR(78)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(15,20|
      DUM=ABz*(ABz*(ABz*HRR(15)+&
                                3.D0*HRR(30))+&
                                3.D0*HRR(51))+&
                                HRR(79)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(16,20|
      DUM=ABz*(ABz*(ABz*HRR(16)+&
                                3.D0*HRR(31))+&
                                3.D0*HRR(52))+&
                                HRR(80)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+6)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(17,20|
      DUM=ABz*(ABz*(ABz*HRR(17)+&
                                3.D0*HRR(32))+&
                                3.D0*HRR(53))+&
                                HRR(81)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+7)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(18,20|
      DUM=ABz*(ABz*(ABz*HRR(18)+&
                                3.D0*HRR(33))+&
                                3.D0*HRR(54))+&
                                HRR(82)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+8)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(19,20|
      DUM=ABz*(ABz*(ABz*HRR(19)+&
                                3.D0*HRR(34))+&
                                3.D0*HRR(55))+&
                                HRR(83)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+9)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(20,20|
      DUM=ABz*(ABz*(ABz*HRR(20)+&
                                3.D0*HRR(35))+&
                                3.D0*HRR(56))+&
                                HRR(84)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
    END SUBROUTINE BraHRR1010cd
