!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0h0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(11,23)
      V(2)=HfxZpE*VRR1(11,24)
      V(3)=HfxZpE*VRR1(11,28)
      V(4)=HfxZpE*VRR1(11,29)
      V(5)=HfxZpE*VRR1(11,30)
      V(6)=HfxZpE*VRR1(11,31)
      V(7)=HfxZpE*VRR1(11,32)
      V(8)=HfxZpE*VRR1(11,33)
      V(9)=HfxZpE*VRR1(11,34)
      V(10)=r1x2E*VRR0(22,12)
      V(11)=r1x2E*ZxZpE*VRR1(22,12)
      V(12)=r1x2E*VRR0(22,13)
      V(13)=HfxZpE*VRR1(12,23)
      V(14)=r1x2E*ZxZpE*VRR1(22,13)
      V(15)=r1x2E*VRR0(22,15)
      V(16)=r1x2E*ZxZpE*VRR1(22,15)
      V(17)=r1x2E*VRR0(22,16)
      V(18)=2.D0*V(17)
      V(19)=r1x2E*ZxZpE*VRR1(22,16)
      V(20)=-2.D0*V(19)
      V(21)=r1x2Z*VRR0(6,44)
      V(22)=2.D0*V(21)
      V(23)=ExZpE*r1x2Z*VRR1(6,44)
      V(24)=-2.D0*V(23)
      V(25)=HfxZpE*VRR1(12,28)
      V(26)=2.D0*V(25)
      V(27)=r1x2E*VRR0(22,17)
      V(28)=r1x2E*ZxZpE*VRR1(22,17)
      V(29)=r1x2E*VRR0(22,18)
      V(30)=HfxZpE*VRR1(12,30)
      V(31)=r1x2E*ZxZpE*VRR1(22,18)
      V(32)=r1x2Z*VRR0(6,48)
      V(33)=2.D0*V(32)
      V(34)=ExZpE*r1x2Z*VRR1(6,48)
      V(35)=-2.D0*V(34)
      V(36)=HfxZpE*VRR1(12,31)
      V(37)=2.D0*V(36)
      V(38)=r1x2Z*VRR0(6,49)
      V(39)=2.D0*V(38)
      V(40)=ExZpE*r1x2Z*VRR1(6,49)
      V(41)=-2.D0*V(40)
      V(42)=HfxZpE*VRR1(12,32)
      V(43)=r1x2E*VRR0(22,19)
      V(44)=r1x2E*ZxZpE*VRR1(22,19)
      V(45)=r1x2E*VRR0(23,12)
      V(46)=r1x2E*ZxZpE*VRR1(23,12)
      V(47)=r1x2E*VRR0(23,13)
      V(48)=HfxZpE*VRR1(13,23)
      V(49)=r1x2E*ZxZpE*VRR1(23,13)
      V(50)=r1x2E*VRR0(23,15)
      V(51)=r1x2E*ZxZpE*VRR1(23,15)
      V(52)=r1x2E*VRR0(23,16)
      V(53)=2.D0*V(52)
      V(54)=HfxZpE*VRR1(13,27)
      V(55)=2.D0*V(54)
      V(56)=r1x2E*ZxZpE*VRR1(23,16)
      V(57)=-2.D0*V(56)
      V(58)=r1x2E*VRR0(23,17)
      V(59)=HfxZpE*VRR1(13,28)
      V(60)=r1x2E*ZxZpE*VRR1(23,17)
      V(61)=r1x2E*VRR0(23,18)
      V(62)=HfxZpE*VRR1(13,30)
      V(63)=r1x2E*ZxZpE*VRR1(23,18)
      V(64)=r1x2E*VRR0(23,19)
      V(65)=HfxZpE*VRR1(13,31)
      V(66)=2.D0*V(65)
      V(67)=r1x2E*ZxZpE*VRR1(23,19)
      V(68)=r1x2E*VRR0(24,12)
      V(69)=HfxZpE*VRR1(14,22)
      V(70)=r1x2E*ZxZpE*VRR1(24,12)
      V(71)=r1x2E*VRR0(24,13)
      V(72)=HfxZpE*VRR1(14,23)
      V(73)=r1x2E*ZxZpE*VRR1(24,13)
      V(74)=r1x2E*VRR0(24,15)
      V(75)=HfxZpE*VRR1(14,26)
      V(76)=r1x2E*ZxZpE*VRR1(24,15)
      V(77)=r1x2E*VRR0(24,16)
      V(78)=2.D0*V(77)
      V(79)=HfxZpE*VRR1(14,27)
      V(80)=r1x2E*ZxZpE*VRR1(24,16)
      V(81)=-2.D0*V(80)
      V(82)=r1x2E*VRR0(24,17)
      V(83)=r1x2E*ZxZpE*VRR1(24,17)
      V(84)=r1x2E*VRR0(24,18)
      V(85)=HfxZpE*VRR1(14,30)
      V(86)=r1x2E*ZxZpE*VRR1(24,18)
      V(87)=r1x2E*VRR0(24,19)
      V(88)=HfxZpE*VRR1(13,32)
      V(89)=r1x2E*ZxZpE*VRR1(24,19)
      V(90)=HfxZpE*VRR1(14,31)
      V(91)=HfxZpE*VRR1(14,32)
      V(92)=HfxZpE*VRR1(14,33)
      V(93)=HfxZpE*VRR1(14,34)
      V(94)=r1x2E*VRR0(26,12)
      V(95)=r1x2E*ZxZpE*VRR1(26,12)
      V(96)=r1x2E*VRR0(26,13)
      V(97)=HfxZpE*VRR1(15,23)
      V(98)=r1x2E*ZxZpE*VRR1(26,13)
      V(99)=r1x2E*VRR0(26,15)
      V(100)=r1x2E*ZxZpE*VRR1(26,15)
      V(101)=r1x2E*VRR0(26,16)
      V(102)=2.D0*V(101)
      V(103)=r1x2E*ZxZpE*VRR1(26,16)
      V(104)=-2.D0*V(103)
      V(105)=r1x2Z*VRR0(8,44)
      V(106)=2.D0*V(105)
      V(107)=ExZpE*r1x2Z*VRR1(8,44)
      V(108)=-2.D0*V(107)
      V(109)=HfxZpE*VRR1(15,28)
      V(110)=r1x2E*VRR0(26,17)
      V(111)=r1x2E*ZxZpE*VRR1(26,17)
      V(112)=r1x2E*VRR0(26,18)
      V(113)=HfxZpE*VRR1(15,30)
      V(114)=r1x2E*ZxZpE*VRR1(26,18)
      V(115)=r1x2Z*VRR0(8,48)
      V(116)=2.D0*V(115)
      V(117)=ExZpE*r1x2Z*VRR1(8,48)
      V(118)=-2.D0*V(117)
      V(119)=HfxZpE*VRR1(15,31)
      V(120)=2.D0*V(119)
      V(121)=r1x2Z*VRR0(8,49)
      V(122)=2.D0*V(121)
      V(123)=ExZpE*r1x2Z*VRR1(8,49)
      V(124)=-2.D0*V(123)
      V(125)=HfxZpE*VRR1(15,32)
      V(126)=r1x2E*VRR0(26,19)
      V(127)=r1x2E*ZxZpE*VRR1(26,19)
      V(128)=r1x2E*VRR0(27,12)
      V(129)=r1x2E*ZxZpE*VRR1(27,12)
      V(130)=r1x2E*VRR0(27,13)
      V(131)=HfxZpE*VRR1(16,23)
      V(132)=2.D0*V(131)
      V(133)=r1x2E*ZxZpE*VRR1(27,13)
      V(134)=r1x2E*VRR0(27,15)
      V(135)=r1x2E*ZxZpE*VRR1(27,15)
      V(136)=r1x2E*VRR0(27,16)
      V(137)=2.D0*V(136)
      V(138)=r1x2E*ZxZpE*VRR1(27,16)
      V(139)=-2.D0*V(138)
      V(140)=r1x2E*VRR0(27,17)
      V(141)=HfxZpE*VRR1(16,28)
      V(142)=2.D0*V(141)
      V(143)=r1x2E*ZxZpE*VRR1(27,17)
      V(144)=r1x2E*VRR0(27,18)
      V(145)=HfxZpE*VRR1(16,30)
      V(146)=2.D0*V(145)
      V(147)=r1x2E*ZxZpE*VRR1(27,18)
      V(148)=r1x2E*VRR0(27,19)
      V(149)=HfxZpE*VRR1(16,31)
      V(150)=2.D0*V(149)
      V(151)=r1x2E*ZxZpE*VRR1(27,19)
      V(152)=r1x2E*VRR0(28,12)
      V(153)=r1x2E*ZxZpE*VRR1(28,12)
      V(154)=r1x2E*VRR0(28,13)
      V(155)=HfxZpE*VRR1(17,23)
      V(156)=r1x2E*ZxZpE*VRR1(28,13)
      V(157)=r1x2E*VRR0(28,15)
      V(158)=r1x2E*ZxZpE*VRR1(28,15)
      V(159)=r1x2E*VRR0(28,16)
      V(160)=2.D0*V(159)
      V(161)=HfxZpE*VRR1(17,27)
      V(162)=r1x2E*ZxZpE*VRR1(28,16)
      V(163)=-2.D0*V(162)
      V(164)=r1x2E*VRR0(28,17)
      V(165)=HfxZpE*VRR1(17,28)
      V(166)=r1x2E*ZxZpE*VRR1(28,17)
      V(167)=r1x2E*VRR0(28,18)
      V(168)=HfxZpE*VRR1(17,30)
      V(169)=r1x2E*ZxZpE*VRR1(28,18)
      V(170)=r1x2E*VRR0(28,19)
      V(171)=HfxZpE*VRR1(17,31)
      V(172)=r1x2E*ZxZpE*VRR1(28,19)
      V(173)=HfxZpE*VRR1(16,32)
      V(174)=2.D0*V(173)
      V(175)=r1x2E*VRR0(29,12)
      V(176)=r1x2E*ZxZpE*VRR1(29,12)
      V(177)=r1x2E*VRR0(29,13)
      V(178)=r1x2E*ZxZpE*VRR1(29,13)
      V(179)=r1x2E*VRR0(29,15)
      V(180)=r1x2E*ZxZpE*VRR1(29,15)
      V(181)=r1x2E*VRR0(29,16)
      V(182)=2.D0*V(181)
      V(183)=r1x2E*ZxZpE*VRR1(29,16)
      V(184)=-2.D0*V(183)
      V(185)=r1x2Z*VRR0(9,44)
      V(186)=2.D0*V(185)
      V(187)=ExZpE*r1x2Z*VRR1(9,44)
      V(188)=-2.D0*V(187)
      V(189)=r1x2E*VRR0(29,17)
      V(190)=r1x2E*ZxZpE*VRR1(29,17)
      V(191)=r1x2E*VRR0(29,18)
      V(192)=r1x2E*ZxZpE*VRR1(29,18)
      V(193)=r1x2Z*VRR0(9,48)
      V(194)=2.D0*V(193)
      V(195)=ExZpE*r1x2Z*VRR1(9,48)
      V(196)=-2.D0*V(195)
      V(197)=r1x2Z*VRR0(9,49)
      V(198)=2.D0*V(197)
      V(199)=ExZpE*r1x2Z*VRR1(9,49)
      V(200)=-2.D0*V(199)
      V(201)=2.D0*V(171)
      V(202)=r1x2E*VRR0(29,19)
      V(203)=HfxZpE*VRR1(17,32)
      V(204)=r1x2E*ZxZpE*VRR1(29,19)
      V(205)=r1x2E*VRR0(30,12)
      V(206)=r1x2E*ZxZpE*VRR1(30,12)
      V(207)=r1x2E*VRR0(30,13)
      V(208)=HfxZpE*VRR1(18,23)
      V(209)=r1x2E*ZxZpE*VRR1(30,13)
      V(210)=r1x2E*VRR0(30,15)
      V(211)=r1x2E*ZxZpE*VRR1(30,15)
      V(212)=r1x2E*VRR0(30,16)
      V(213)=2.D0*V(212)
      V(214)=HfxZpE*VRR1(18,27)
      V(215)=2.D0*V(214)
      V(216)=r1x2E*ZxZpE*VRR1(30,16)
      V(217)=-2.D0*V(216)
      V(218)=r1x2E*VRR0(30,17)
      V(219)=HfxZpE*VRR1(18,28)
      V(220)=2.D0*V(219)
      V(221)=r1x2E*ZxZpE*VRR1(30,17)
      V(222)=r1x2E*VRR0(30,18)
      V(223)=HfxZpE*VRR1(18,30)
      V(224)=r1x2E*ZxZpE*VRR1(30,18)
      V(225)=r1x2E*VRR0(30,19)
      V(226)=HfxZpE*VRR1(18,31)
      V(227)=r1x2E*ZxZpE*VRR1(30,19)
      V(228)=r1x2E*VRR0(31,12)
      V(229)=r1x2E*ZxZpE*VRR1(31,12)
      V(230)=r1x2E*VRR0(31,13)
      V(231)=HfxZpE*VRR1(19,23)
      V(232)=r1x2E*ZxZpE*VRR1(31,13)
      V(233)=r1x2E*VRR0(31,15)
      V(234)=r1x2E*ZxZpE*VRR1(31,15)
      V(235)=r1x2E*VRR0(31,16)
      V(236)=2.D0*V(235)
      V(237)=HfxZpE*VRR1(19,27)
      V(238)=r1x2E*ZxZpE*VRR1(31,16)
      V(239)=-2.D0*V(238)
      V(240)=r1x2E*VRR0(31,17)
      V(241)=HfxZpE*VRR1(19,28)
      V(242)=r1x2E*ZxZpE*VRR1(31,17)
      V(243)=r1x2E*VRR0(31,18)
      V(244)=HfxZpE*VRR1(19,30)
      V(245)=r1x2E*ZxZpE*VRR1(31,18)
      V(246)=r1x2E*VRR0(31,19)
      V(247)=HfxZpE*VRR1(19,31)
      V(248)=r1x2E*ZxZpE*VRR1(31,19)
      V(249)=HfxZpE*VRR1(18,32)
      V(250)=r1x2E*VRR0(32,12)
      V(251)=r1x2E*ZxZpE*VRR1(32,12)
      V(252)=r1x2E*VRR0(32,13)
      V(253)=r1x2E*ZxZpE*VRR1(32,13)
      V(254)=r1x2E*VRR0(32,15)
      V(255)=r1x2E*ZxZpE*VRR1(32,15)
      V(256)=r1x2E*VRR0(32,16)
      V(257)=2.D0*V(256)
      V(258)=r1x2E*ZxZpE*VRR1(32,16)
      V(259)=-2.D0*V(258)
      V(260)=r1x2E*VRR0(32,17)
      V(261)=r1x2E*ZxZpE*VRR1(32,17)
      V(262)=2.D0*V(241)
      V(263)=r1x2E*VRR0(32,18)
      V(264)=r1x2E*ZxZpE*VRR1(32,18)
      V(265)=r1x2E*VRR0(32,19)
      V(266)=r1x2E*ZxZpE*VRR1(32,19)
      V(267)=HfxZpE*VRR1(19,32)
      V(268)=r1x2E*VRR0(33,12)
      V(269)=HfxZpE*VRR1(20,22)
      V(270)=r1x2E*ZxZpE*VRR1(33,12)
      V(271)=r1x2E*VRR0(33,13)
      V(272)=HfxZpE*VRR1(20,23)
      V(273)=r1x2E*ZxZpE*VRR1(33,13)
      V(274)=r1x2E*VRR0(33,15)
      V(275)=HfxZpE*VRR1(20,26)
      V(276)=r1x2E*ZxZpE*VRR1(33,15)
      V(277)=r1x2E*VRR0(33,16)
      V(278)=2.D0*V(277)
      V(279)=HfxZpE*VRR1(20,27)
      V(280)=r1x2E*ZxZpE*VRR1(33,16)
      V(281)=-2.D0*V(280)
      V(282)=r1x2E*VRR0(33,17)
      V(283)=r1x2E*ZxZpE*VRR1(33,17)
      V(284)=r1x2E*VRR0(33,18)
      V(285)=HfxZpE*VRR1(20,30)
      V(286)=r1x2E*ZxZpE*VRR1(33,18)
      V(287)=r1x2E*VRR0(33,19)
      V(288)=r1x2E*ZxZpE*VRR1(33,19)
      V(289)=r1x2E*VRR0(34,12)
      V(290)=r1x2E*ZxZpE*VRR1(34,12)
      V(291)=r1x2E*VRR0(34,13)
      V(292)=r1x2E*ZxZpE*VRR1(34,13)
      V(293)=HfxZpE*VRR1(20,24)
      V(294)=r1x2E*VRR0(34,15)
      V(295)=r1x2E*ZxZpE*VRR1(34,15)
      V(296)=r1x2E*VRR0(34,16)
      V(297)=2.D0*V(296)
      V(298)=r1x2E*ZxZpE*VRR1(34,16)
      V(299)=-2.D0*V(298)
      V(300)=HfxZpE*VRR1(20,28)
      V(301)=r1x2E*VRR0(34,17)
      V(302)=HfxZpE*VRR1(20,29)
      V(303)=r1x2E*ZxZpE*VRR1(34,17)
      V(304)=r1x2E*VRR0(34,18)
      V(305)=r1x2E*ZxZpE*VRR1(34,18)
      V(306)=r1x2E*VRR0(34,19)
      V(307)=HfxZpE*VRR1(20,32)
      V(308)=r1x2E*ZxZpE*VRR1(34,19)
      VRR0(21,36)=4.D0*r1x2E*VRR0(21,11)+QCx*VRR0(21,21)+4.D0*HfxZpE*VRR1(11,21)-4.D0*r1x2E*ZxZpE*VRR1(21,11)+WQx*VRR1(21,21)
      VRR0(21,37)=3.D0*r1x2E*VRR0(21,12)+QCx*VRR0(21,22)+4.D0*HfxZpE*VRR1(11,22)-3.D0*r1x2E*ZxZpE*VRR1(21,12)+WQx*VRR1(21,22)
      VRR0(21,38)=3.D0*V(1)+3.D0*r1x2Z*VRR0(5,38)+PAx*VRR0(11,38)-3.D0*ExZpE*r1x2Z*VRR1(5,38)+WPx*VRR1(11,38)
      VRR0(21,39)=2.D0*V(2)+3.D0*r1x2Z*VRR0(5,39)+PAx*VRR0(11,39)-3.D0*ExZpE*r1x2Z*VRR1(5,39)+WPx*VRR1(11,39)
      VRR0(21,40)=3.D0*r1x2E*VRR0(21,13)+QCy*VRR0(21,24)-3.D0*r1x2E*ZxZpE*VRR1(21,13)+WQy*VRR1(21,24)
      VRR0(21,41)=4.D0*r1x2E*VRR0(21,14)+QCy*VRR0(21,25)-4.D0*r1x2E*ZxZpE*VRR1(21,14)+WQy*VRR1(21,25)
      VRR0(21,42)=3.D0*r1x2E*VRR0(21,15)+QCx*VRR0(21,26)+4.D0*HfxZpE*VRR1(11,26)-3.D0*r1x2E*ZxZpE*VRR1(21,15)+WQx*VRR1(21,26)
      VRR0(21,43)=3.D0*r1x2Z*VRR0(5,43)+PAx*VRR0(11,43)-3.D0*ExZpE*r1x2Z*VRR1(5,43)+3.D0*HfxZpE*VRR1(11,27)+WPx*VRR1(11,43)
      VRR0(21,44)=2.D0*V(3)+3.D0*r1x2Z*VRR0(5,44)+PAx*VRR0(11,44)-3.D0*ExZpE*r1x2Z*VRR1(5,44)+WPx*VRR1(11,44)
      VRR0(21,45)=V(4)+3.D0*r1x2Z*VRR0(5,45)+PAx*VRR0(11,45)-3.D0*ExZpE*r1x2Z*VRR1(5,45)+WPx*VRR1(11,45)
      VRR0(21,46)=3.D0*r1x2E*VRR0(21,17)+QCy*VRR0(21,29)-3.D0*r1x2E*ZxZpE*VRR1(21,17)+WQy*VRR1(21,29)
      VRR0(21,47)=3.D0*V(5)+3.D0*r1x2Z*VRR0(5,47)+PAx*VRR0(11,47)-3.D0*ExZpE*r1x2Z*VRR1(5,47)+WPx*VRR1(11,47)
      VRR0(21,48)=2.D0*V(6)+3.D0*r1x2Z*VRR0(5,48)+PAx*VRR0(11,48)-3.D0*ExZpE*r1x2Z*VRR1(5,48)+WPx*VRR1(11,48)
      VRR0(21,49)=V(7)+3.D0*r1x2Z*VRR0(5,49)+PAx*VRR0(11,49)-3.D0*ExZpE*r1x2Z*VRR1(5,49)+WPx*VRR1(11,49)
      VRR0(21,50)=3.D0*r1x2Z*VRR0(5,50)+PAx*VRR0(11,50)-3.D0*ExZpE*r1x2Z*VRR1(5,50)+WPx*VRR1(11,50)
      VRR0(21,51)=2.D0*V(8)+3.D0*r1x2Z*VRR0(5,51)+PAx*VRR0(11,51)-3.D0*ExZpE*r1x2Z*VRR1(5,51)+WPx*VRR1(11,51)
      VRR0(21,52)=V(9)+3.D0*r1x2Z*VRR0(5,52)+PAx*VRR0(11,52)-3.D0*ExZpE*r1x2Z*VRR1(5,52)+WPx*VRR1(11,52)
      VRR0(21,53)=3.D0*r1x2Z*VRR0(5,53)+PAx*VRR0(11,53)-3.D0*ExZpE*r1x2Z*VRR1(5,53)+WPx*VRR1(11,53)
      VRR0(21,54)=3.D0*r1x2E*VRR0(21,18)+QCz*VRR0(21,33)-3.D0*r1x2E*ZxZpE*VRR1(21,18)+WQz*VRR1(21,33)
      VRR0(21,55)=3.D0*r1x2E*VRR0(21,19)+QCz*VRR0(21,34)-3.D0*r1x2E*ZxZpE*VRR1(21,19)+WQz*VRR1(21,34)
      VRR0(21,56)=4.D0*r1x2E*VRR0(21,20)+QCz*VRR0(21,35)-4.D0*r1x2E*ZxZpE*VRR1(21,20)+WQz*VRR1(21,35)
      VRR0(22,36)=4.D0*r1x2E*VRR0(22,11)+QCx*VRR0(22,21)+3.D0*HfxZpE*VRR1(12,21)-4.D0*r1x2E*ZxZpE*VRR1(22,11)+WQx*VRR1(22,21)
      VRR0(22,37)=3.D0*V(10)-3.D0*V(11)+QCx*VRR0(22,22)+3.D0*HfxZpE*VRR1(12,22)+WQx*VRR1(22,22)
      VRR0(22,38)=2.D0*V(12)+3.D0*V(13)-2.D0*V(14)+QCx*VRR0(22,23)+WQx*VRR1(22,23)
      VRR0(22,39)=V(1)+2.D0*V(10)-2.D0*V(11)+QCy*VRR0(22,23)+WQy*VRR1(22,23)
      VRR0(22,40)=V(2)+3.D0*V(12)-3.D0*V(14)+QCy*VRR0(22,24)+WQy*VRR1(22,24)
      VRR0(22,41)=4.D0*r1x2E*VRR0(22,14)+QCy*VRR0(22,25)+HfxZpE*VRR1(11,25)-4.D0*r1x2E*ZxZpE*VRR1(22,14)+WQy*VRR1(22,25)
      VRR0(22,42)=3.D0*V(15)-3.D0*V(16)+QCx*VRR0(22,26)+3.D0*HfxZpE*VRR1(12,26)+WQx*VRR1(22,26)
      VRR0(22,43)=V(18)+V(20)+QCx*VRR0(22,27)+3.D0*HfxZpE*VRR1(12,27)+WQx*VRR1(22,27)
      VRR0(22,44)=V(22)+V(24)+V(26)+PAx*VRR0(12,44)+WPx*VRR1(12,44)
      VRR0(22,45)=V(3)+V(18)+V(20)+QCy*VRR0(22,28)+WQy*VRR1(22,28)
      VRR0(22,46)=V(4)+3.D0*V(27)-3.D0*V(28)+QCy*VRR0(22,29)+WQy*VRR1(22,29)
      VRR0(22,47)=2.D0*V(29)+3.D0*V(30)-2.D0*V(31)+QCx*VRR0(22,30)+WQx*VRR1(22,30)
      VRR0(22,48)=V(33)+V(35)+V(37)+PAx*VRR0(12,48)+WPx*VRR1(12,48)
      VRR0(22,49)=V(39)+V(41)+V(42)+PAx*VRR0(12,49)+WPx*VRR1(12,49)
      VRR0(22,50)=V(7)+2.D0*V(43)-2.D0*V(44)+QCy*VRR0(22,32)+WQy*VRR1(22,32)
      VRR0(22,51)=2.D0*V(15)-2.D0*V(16)+QCz*VRR0(22,30)+WQz*VRR1(22,30)
      VRR0(22,52)=V(18)+V(20)+QCz*VRR0(22,31)+WQz*VRR1(22,31)
      VRR0(22,53)=2.D0*V(27)-2.D0*V(28)+QCz*VRR0(22,32)+WQz*VRR1(22,32)
      VRR0(22,54)=3.D0*V(29)-3.D0*V(31)+QCz*VRR0(22,33)+WQz*VRR1(22,33)
      VRR0(22,55)=3.D0*V(43)-3.D0*V(44)+QCz*VRR0(22,34)+WQz*VRR1(22,34)
      VRR0(22,56)=4.D0*r1x2E*VRR0(22,20)+QCz*VRR0(22,35)-4.D0*r1x2E*ZxZpE*VRR1(22,20)+WQz*VRR1(22,35)
      VRR0(23,36)=4.D0*r1x2E*VRR0(23,11)+QCx*VRR0(23,21)+2.D0*HfxZpE*VRR1(13,21)-4.D0*r1x2E*ZxZpE*VRR1(23,11)+WQx*VRR1(23,21)
      VRR0(23,37)=3.D0*V(45)-3.D0*V(46)+QCx*VRR0(23,22)+2.D0*HfxZpE*VRR1(13,22)+WQx*VRR1(23,22)
      VRR0(23,38)=2.D0*V(47)+2.D0*V(48)-2.D0*V(49)+QCx*VRR0(23,23)+WQx*VRR1(23,23)
      VRR0(23,39)=2.D0*V(13)+2.D0*V(45)-2.D0*V(46)+QCy*VRR0(23,23)+WQy*VRR1(23,23)
      VRR0(23,40)=3.D0*V(47)-3.D0*V(49)+QCy*VRR0(23,24)+2.D0*HfxZpE*VRR1(12,24)+WQy*VRR1(23,24)
      VRR0(23,41)=4.D0*r1x2E*VRR0(23,14)+QCy*VRR0(23,25)+2.D0*HfxZpE*VRR1(12,25)-4.D0*r1x2E*ZxZpE*VRR1(23,14)+WQy*VRR1(23,25)
      VRR0(23,42)=3.D0*V(50)-3.D0*V(51)+QCx*VRR0(23,26)+2.D0*HfxZpE*VRR1(13,26)+WQx*VRR1(23,26)
      VRR0(23,43)=V(53)+V(55)+V(57)+QCx*VRR0(23,27)+WQx*VRR1(23,27)
      VRR0(23,44)=V(58)+2.D0*V(59)-V(60)+QCx*VRR0(23,28)+WQx*VRR1(23,28)
      VRR0(23,45)=V(26)+V(53)+V(57)+QCy*VRR0(23,28)+WQy*VRR1(23,28)
      VRR0(23,46)=3.D0*V(58)-3.D0*V(60)+QCy*VRR0(23,29)+2.D0*HfxZpE*VRR1(12,29)+WQy*VRR1(23,29)
      VRR0(23,47)=2.D0*V(61)+2.D0*V(62)-2.D0*V(63)+QCx*VRR0(23,30)+WQx*VRR1(23,30)
      VRR0(23,48)=V(64)+V(66)-V(67)+QCx*VRR0(23,31)+WQx*VRR1(23,31)
      VRR0(23,49)=V(37)+V(61)-V(63)+QCy*VRR0(23,31)+WQy*VRR1(23,31)
      VRR0(23,50)=2.D0*V(42)+2.D0*V(64)-2.D0*V(67)+QCy*VRR0(23,32)+WQy*VRR1(23,32)
      VRR0(23,51)=2.D0*V(50)-2.D0*V(51)+QCz*VRR0(23,30)+WQz*VRR1(23,30)
      VRR0(23,52)=V(53)+V(57)+QCz*VRR0(23,31)+WQz*VRR1(23,31)
      VRR0(23,53)=2.D0*V(58)-2.D0*V(60)+QCz*VRR0(23,32)+WQz*VRR1(23,32)
      VRR0(23,54)=3.D0*V(61)-3.D0*V(63)+QCz*VRR0(23,33)+WQz*VRR1(23,33)
      VRR0(23,55)=3.D0*V(64)-3.D0*V(67)+QCz*VRR0(23,34)+WQz*VRR1(23,34)
      VRR0(23,56)=4.D0*r1x2E*VRR0(23,20)+QCz*VRR0(23,35)-4.D0*r1x2E*ZxZpE*VRR1(23,20)+WQz*VRR1(23,35)
      VRR0(24,36)=4.D0*r1x2E*VRR0(24,11)+QCx*VRR0(24,21)+HfxZpE*VRR1(14,21)-4.D0*r1x2E*ZxZpE*VRR1(24,11)+WQx*VRR1(24,21)
      VRR0(24,37)=3.D0*V(68)+V(69)-3.D0*V(70)+QCx*VRR0(24,22)+WQx*VRR1(24,22)
      VRR0(24,38)=2.D0*V(71)+V(72)-2.D0*V(73)+QCx*VRR0(24,23)+WQx*VRR1(24,23)
      VRR0(24,39)=3.D0*V(48)+2.D0*V(68)-2.D0*V(70)+QCy*VRR0(24,23)+WQy*VRR1(24,23)
      VRR0(24,40)=3.D0*V(71)-3.D0*V(73)+QCy*VRR0(24,24)+3.D0*HfxZpE*VRR1(13,24)+WQy*VRR1(24,24)
      VRR0(24,41)=4.D0*r1x2E*VRR0(24,14)+QCy*VRR0(24,25)+3.D0*HfxZpE*VRR1(13,25)-4.D0*r1x2E*ZxZpE*VRR1(24,14)+WQy*VRR1(24,25)
      VRR0(24,42)=3.D0*V(74)+V(75)-3.D0*V(76)+QCx*VRR0(24,26)+WQx*VRR1(24,26)
      VRR0(24,43)=V(78)+V(79)+V(81)+QCx*VRR0(24,27)+WQx*VRR1(24,27)
      VRR0(24,44)=V(22)+V(24)+V(55)+PAy*VRR0(13,44)+WPy*VRR1(13,44)
      VRR0(24,45)=3.D0*V(59)+V(78)+V(81)+QCy*VRR0(24,28)+WQy*VRR1(24,28)
      VRR0(24,46)=3.D0*V(82)-3.D0*V(83)+QCy*VRR0(24,29)+3.D0*HfxZpE*VRR1(13,29)+WQy*VRR1(24,29)
      VRR0(24,47)=2.D0*V(84)+V(85)-2.D0*V(86)+QCx*VRR0(24,30)+WQx*VRR1(24,30)
      VRR0(24,48)=V(33)+V(35)+V(62)+PAy*VRR0(13,48)+WPy*VRR1(13,48)
      VRR0(24,49)=V(39)+V(41)+V(66)+PAy*VRR0(13,49)+WPy*VRR1(13,49)
      VRR0(24,50)=2.D0*V(87)+3.D0*V(88)-2.D0*V(89)+QCy*VRR0(24,32)+WQy*VRR1(24,32)
      VRR0(24,51)=2.D0*V(74)-2.D0*V(76)+QCz*VRR0(24,30)+WQz*VRR1(24,30)
      VRR0(24,52)=V(78)+V(81)+QCz*VRR0(24,31)+WQz*VRR1(24,31)
      VRR0(24,53)=2.D0*V(82)-2.D0*V(83)+QCz*VRR0(24,32)+WQz*VRR1(24,32)
      VRR0(24,54)=3.D0*V(84)-3.D0*V(86)+QCz*VRR0(24,33)+WQz*VRR1(24,33)
      VRR0(24,55)=3.D0*V(87)-3.D0*V(89)+QCz*VRR0(24,34)+WQz*VRR1(24,34)
      VRR0(24,56)=4.D0*r1x2E*VRR0(24,20)+QCz*VRR0(24,35)-4.D0*r1x2E*ZxZpE*VRR1(24,20)+WQz*VRR1(24,35)
      VRR0(25,36)=4.D0*r1x2E*VRR0(25,11)+QCx*VRR0(25,21)-4.D0*r1x2E*ZxZpE*VRR1(25,11)+WQx*VRR1(25,21)
      VRR0(25,37)=3.D0*r1x2E*VRR0(25,12)+QCx*VRR0(25,22)-3.D0*r1x2E*ZxZpE*VRR1(25,12)+WQx*VRR1(25,22)
      VRR0(25,38)=2.D0*V(69)+3.D0*r1x2Z*VRR0(7,38)+PAy*VRR0(14,38)-3.D0*ExZpE*r1x2Z*VRR1(7,38)+WPy*VRR1(14,38)
      VRR0(25,39)=3.D0*V(72)+3.D0*r1x2Z*VRR0(7,39)+PAy*VRR0(14,39)-3.D0*ExZpE*r1x2Z*VRR1(7,39)+WPy*VRR1(14,39)
      VRR0(25,40)=3.D0*r1x2E*VRR0(25,13)+QCy*VRR0(25,24)+4.D0*HfxZpE*VRR1(14,24)-3.D0*r1x2E*ZxZpE*VRR1(25,13)+WQy*VRR1(25,24)
      VRR0(25,41)=4.D0*r1x2E*VRR0(25,14)+QCy*VRR0(25,25)+4.D0*HfxZpE*VRR1(14,25)-4.D0*r1x2E*ZxZpE*VRR1(25,14)+WQy*VRR1(25,25)
      VRR0(25,42)=3.D0*r1x2E*VRR0(25,15)+QCx*VRR0(25,26)-3.D0*r1x2E*ZxZpE*VRR1(25,15)+WQx*VRR1(25,26)
      VRR0(25,43)=V(75)+3.D0*r1x2Z*VRR0(7,43)+PAy*VRR0(14,43)-3.D0*ExZpE*r1x2Z*VRR1(7,43)+WPy*VRR1(14,43)
      VRR0(25,44)=2.D0*V(79)+3.D0*r1x2Z*VRR0(7,44)+PAy*VRR0(14,44)-3.D0*ExZpE*r1x2Z*VRR1(7,44)+WPy*VRR1(14,44)
      VRR0(25,45)=3.D0*r1x2Z*VRR0(7,45)+PAy*VRR0(14,45)-3.D0*ExZpE*r1x2Z*VRR1(7,45)+3.D0*HfxZpE*VRR1(14,28)+WPy*VRR1(14,45)
      VRR0(25,46)=3.D0*r1x2E*VRR0(25,17)+QCy*VRR0(25,29)+4.D0*HfxZpE*VRR1(14,29)-3.D0*r1x2E*ZxZpE*VRR1(25,17)+WQy*VRR1(25,29)
      VRR0(25,47)=3.D0*r1x2Z*VRR0(7,47)+PAy*VRR0(14,47)-3.D0*ExZpE*r1x2Z*VRR1(7,47)+WPy*VRR1(14,47)
      VRR0(25,48)=V(85)+3.D0*r1x2Z*VRR0(7,48)+PAy*VRR0(14,48)-3.D0*ExZpE*r1x2Z*VRR1(7,48)+WPy*VRR1(14,48)
      VRR0(25,49)=2.D0*V(90)+3.D0*r1x2Z*VRR0(7,49)+PAy*VRR0(14,49)-3.D0*ExZpE*r1x2Z*VRR1(7,49)+WPy*VRR1(14,49)
      VRR0(25,50)=3.D0*V(91)+3.D0*r1x2Z*VRR0(7,50)+PAy*VRR0(14,50)-3.D0*ExZpE*r1x2Z*VRR1(7,50)+WPy*VRR1(14,50)
      VRR0(25,51)=3.D0*r1x2Z*VRR0(7,51)+PAy*VRR0(14,51)-3.D0*ExZpE*r1x2Z*VRR1(7,51)+WPy*VRR1(14,51)
      VRR0(25,52)=V(92)+3.D0*r1x2Z*VRR0(7,52)+PAy*VRR0(14,52)-3.D0*ExZpE*r1x2Z*VRR1(7,52)+WPy*VRR1(14,52)
      VRR0(25,53)=2.D0*V(93)+3.D0*r1x2Z*VRR0(7,53)+PAy*VRR0(14,53)-3.D0*ExZpE*r1x2Z*VRR1(7,53)+WPy*VRR1(14,53)
      VRR0(25,54)=3.D0*r1x2E*VRR0(25,18)+QCz*VRR0(25,33)-3.D0*r1x2E*ZxZpE*VRR1(25,18)+WQz*VRR1(25,33)
      VRR0(25,55)=3.D0*r1x2E*VRR0(25,19)+QCz*VRR0(25,34)-3.D0*r1x2E*ZxZpE*VRR1(25,19)+WQz*VRR1(25,34)
      VRR0(25,56)=4.D0*r1x2E*VRR0(25,20)+QCz*VRR0(25,35)-4.D0*r1x2E*ZxZpE*VRR1(25,20)+WQz*VRR1(25,35)
      VRR0(26,36)=4.D0*r1x2E*VRR0(26,11)+QCx*VRR0(26,21)+3.D0*HfxZpE*VRR1(15,21)-4.D0*r1x2E*ZxZpE*VRR1(26,11)+WQx*VRR1(26,21)
      VRR0(26,37)=3.D0*V(94)-3.D0*V(95)+QCx*VRR0(26,22)+3.D0*HfxZpE*VRR1(15,22)+WQx*VRR1(26,22)
      VRR0(26,38)=2.D0*V(96)+3.D0*V(97)-2.D0*V(98)+QCx*VRR0(26,23)+WQx*VRR1(26,23)
      VRR0(26,39)=2.D0*V(94)-2.D0*V(95)+QCy*VRR0(26,23)+WQy*VRR1(26,23)
      VRR0(26,40)=3.D0*V(96)-3.D0*V(98)+QCy*VRR0(26,24)+WQy*VRR1(26,24)
      VRR0(26,41)=4.D0*r1x2E*VRR0(26,14)+QCy*VRR0(26,25)-4.D0*r1x2E*ZxZpE*VRR1(26,14)+WQy*VRR1(26,25)
      VRR0(26,42)=3.D0*V(99)-3.D0*V(100)+QCx*VRR0(26,26)+3.D0*HfxZpE*VRR1(15,26)+WQx*VRR1(26,26)
      VRR0(26,43)=V(102)+V(104)+QCx*VRR0(26,27)+3.D0*HfxZpE*VRR1(15,27)+WQx*VRR1(26,27)
      VRR0(26,44)=V(106)+V(108)+2.D0*V(109)+PAx*VRR0(15,44)+WPx*VRR1(15,44)
      VRR0(26,45)=V(102)+V(104)+QCy*VRR0(26,28)+WQy*VRR1(26,28)
      VRR0(26,46)=3.D0*V(110)-3.D0*V(111)+QCy*VRR0(26,29)+WQy*VRR1(26,29)
      VRR0(26,47)=2.D0*V(112)+3.D0*V(113)-2.D0*V(114)+QCx*VRR0(26,30)+WQx*VRR1(26,30)
      VRR0(26,48)=V(116)+V(118)+V(120)+PAx*VRR0(15,48)+WPx*VRR1(15,48)
      VRR0(26,49)=V(122)+V(124)+V(125)+PAx*VRR0(15,49)+WPx*VRR1(15,49)
      VRR0(26,50)=2.D0*V(126)-2.D0*V(127)+QCy*VRR0(26,32)+WQy*VRR1(26,32)
      VRR0(26,51)=V(5)+2.D0*V(99)-2.D0*V(100)+QCz*VRR0(26,30)+WQz*VRR1(26,30)
      VRR0(26,52)=V(6)+V(102)+V(104)+QCz*VRR0(26,31)+WQz*VRR1(26,31)
      VRR0(26,53)=V(7)+2.D0*V(110)-2.D0*V(111)+QCz*VRR0(26,32)+WQz*VRR1(26,32)
      VRR0(26,54)=V(8)+3.D0*V(112)-3.D0*V(114)+QCz*VRR0(26,33)+WQz*VRR1(26,33)
      VRR0(26,55)=V(9)+3.D0*V(126)-3.D0*V(127)+QCz*VRR0(26,34)+WQz*VRR1(26,34)
      VRR0(26,56)=4.D0*r1x2E*VRR0(26,20)+QCz*VRR0(26,35)+HfxZpE*VRR1(11,35)-4.D0*r1x2E*ZxZpE*VRR1(26,20)+WQz*VRR1(26,35)
      VRR0(27,36)=4.D0*r1x2E*VRR0(27,11)+QCx*VRR0(27,21)+2.D0*HfxZpE*VRR1(16,21)-4.D0*r1x2E*ZxZpE*VRR1(27,11)+WQx*VRR1(27,21)
      VRR0(27,37)=3.D0*V(128)-3.D0*V(129)+QCx*VRR0(27,22)+2.D0*HfxZpE*VRR1(16,22)+WQx*VRR1(27,22)
      VRR0(27,38)=2.D0*V(130)+V(132)-2.D0*V(133)+QCx*VRR0(27,23)+WQx*VRR1(27,23)
      VRR0(27,39)=V(97)+2.D0*V(128)-2.D0*V(129)+QCy*VRR0(27,23)+WQy*VRR1(27,23)
      VRR0(27,40)=3.D0*V(130)-3.D0*V(133)+QCy*VRR0(27,24)+HfxZpE*VRR1(15,24)+WQy*VRR1(27,24)
      VRR0(27,41)=4.D0*r1x2E*VRR0(27,14)+QCy*VRR0(27,25)+HfxZpE*VRR1(15,25)-4.D0*r1x2E*ZxZpE*VRR1(27,14)+WQy*VRR1(27,25)
      VRR0(27,42)=3.D0*V(134)-3.D0*V(135)+QCx*VRR0(27,26)+2.D0*HfxZpE*VRR1(16,26)+WQx*VRR1(27,26)
      VRR0(27,43)=V(137)+V(139)+QCx*VRR0(27,27)+2.D0*HfxZpE*VRR1(16,27)+WQx*VRR1(27,27)
      VRR0(27,44)=V(140)+V(142)-V(143)+QCx*VRR0(27,28)+WQx*VRR1(27,28)
      VRR0(27,45)=V(109)+V(137)+V(139)+QCy*VRR0(27,28)+WQy*VRR1(27,28)
      VRR0(27,46)=3.D0*V(140)-3.D0*V(143)+QCy*VRR0(27,29)+HfxZpE*VRR1(15,29)+WQy*VRR1(27,29)
      VRR0(27,47)=2.D0*V(144)+V(146)-2.D0*V(147)+QCx*VRR0(27,30)+WQx*VRR1(27,30)
      VRR0(27,48)=V(148)+V(150)-V(151)+QCx*VRR0(27,31)+WQx*VRR1(27,31)
      VRR0(27,49)=V(119)+V(144)-V(147)+QCy*VRR0(27,31)+WQy*VRR1(27,31)
      VRR0(27,50)=V(125)+2.D0*V(148)-2.D0*V(151)+QCy*VRR0(27,32)+WQy*VRR1(27,32)
      VRR0(27,51)=V(30)+2.D0*V(134)-2.D0*V(135)+QCz*VRR0(27,30)+WQz*VRR1(27,30)
      VRR0(27,52)=V(36)+V(137)+V(139)+QCz*VRR0(27,31)+WQz*VRR1(27,31)
      VRR0(27,53)=V(42)+2.D0*V(140)-2.D0*V(143)+QCz*VRR0(27,32)+WQz*VRR1(27,32)
      VRR0(27,54)=3.D0*V(144)-3.D0*V(147)+QCz*VRR0(27,33)+HfxZpE*VRR1(12,33)+WQz*VRR1(27,33)
      VRR0(27,55)=3.D0*V(148)-3.D0*V(151)+QCz*VRR0(27,34)+HfxZpE*VRR1(12,34)+WQz*VRR1(27,34)
      VRR0(27,56)=4.D0*r1x2E*VRR0(27,20)+QCz*VRR0(27,35)+HfxZpE*VRR1(12,35)-4.D0*r1x2E*ZxZpE*VRR1(27,20)+WQz*VRR1(27,35)
      VRR0(28,36)=4.D0*r1x2E*VRR0(28,11)+QCx*VRR0(28,21)+HfxZpE*VRR1(17,21)-4.D0*r1x2E*ZxZpE*VRR1(28,11)+WQx*VRR1(28,21)
      VRR0(28,37)=3.D0*V(152)-3.D0*V(153)+QCx*VRR0(28,22)+HfxZpE*VRR1(17,22)+WQx*VRR1(28,22)
      VRR0(28,38)=2.D0*V(154)+V(155)-2.D0*V(156)+QCx*VRR0(28,23)+WQx*VRR1(28,23)
      VRR0(28,39)=V(132)+2.D0*V(152)-2.D0*V(153)+QCy*VRR0(28,23)+WQy*VRR1(28,23)
      VRR0(28,40)=3.D0*V(154)-3.D0*V(156)+QCy*VRR0(28,24)+2.D0*HfxZpE*VRR1(16,24)+WQy*VRR1(28,24)
      VRR0(28,41)=4.D0*r1x2E*VRR0(28,14)+QCy*VRR0(28,25)+2.D0*HfxZpE*VRR1(16,25)-4.D0*r1x2E*ZxZpE*VRR1(28,14)+WQy*VRR1(28,25)
      VRR0(28,42)=3.D0*V(157)-3.D0*V(158)+QCx*VRR0(28,26)+HfxZpE*VRR1(17,26)+WQx*VRR1(28,26)
      VRR0(28,43)=V(160)+V(161)+V(163)+QCx*VRR0(28,27)+WQx*VRR1(28,27)
      VRR0(28,44)=V(164)+V(165)-V(166)+QCx*VRR0(28,28)+WQx*VRR1(28,28)
      VRR0(28,45)=V(142)+V(160)+V(163)+QCy*VRR0(28,28)+WQy*VRR1(28,28)
      VRR0(28,46)=3.D0*V(164)-3.D0*V(166)+QCy*VRR0(28,29)+2.D0*HfxZpE*VRR1(16,29)+WQy*VRR1(28,29)
      VRR0(28,47)=2.D0*V(167)+V(168)-2.D0*V(169)+QCx*VRR0(28,30)+WQx*VRR1(28,30)
      VRR0(28,48)=V(170)+V(171)-V(172)+QCx*VRR0(28,31)+WQx*VRR1(28,31)
      VRR0(28,49)=V(150)+V(167)-V(169)+QCy*VRR0(28,31)+WQy*VRR1(28,31)
      VRR0(28,50)=2.D0*V(170)-2.D0*V(172)+V(174)+QCy*VRR0(28,32)+WQy*VRR1(28,32)
      VRR0(28,51)=V(62)+2.D0*V(157)-2.D0*V(158)+QCz*VRR0(28,30)+WQz*VRR1(28,30)
      VRR0(28,52)=V(65)+V(160)+V(163)+QCz*VRR0(28,31)+WQz*VRR1(28,31)
      VRR0(28,53)=V(88)+2.D0*V(164)-2.D0*V(166)+QCz*VRR0(28,32)+WQz*VRR1(28,32)
      VRR0(28,54)=3.D0*V(167)-3.D0*V(169)+QCz*VRR0(28,33)+HfxZpE*VRR1(13,33)+WQz*VRR1(28,33)
      VRR0(28,55)=3.D0*V(170)-3.D0*V(172)+QCz*VRR0(28,34)+HfxZpE*VRR1(13,34)+WQz*VRR1(28,34)
      VRR0(28,56)=4.D0*r1x2E*VRR0(28,20)+QCz*VRR0(28,35)+HfxZpE*VRR1(13,35)-4.D0*r1x2E*ZxZpE*VRR1(28,20)+WQz*VRR1(28,35)
      VRR0(29,36)=4.D0*r1x2E*VRR0(29,11)+QCx*VRR0(29,21)-4.D0*r1x2E*ZxZpE*VRR1(29,11)+WQx*VRR1(29,21)
      VRR0(29,37)=3.D0*V(175)-3.D0*V(176)+QCx*VRR0(29,22)+WQx*VRR1(29,22)
      VRR0(29,38)=2.D0*V(177)-2.D0*V(178)+QCx*VRR0(29,23)+WQx*VRR1(29,23)
      VRR0(29,39)=3.D0*V(155)+2.D0*V(175)-2.D0*V(176)+QCy*VRR0(29,23)+WQy*VRR1(29,23)
      VRR0(29,40)=3.D0*V(177)-3.D0*V(178)+QCy*VRR0(29,24)+3.D0*HfxZpE*VRR1(17,24)+WQy*VRR1(29,24)
      VRR0(29,41)=4.D0*r1x2E*VRR0(29,14)+QCy*VRR0(29,25)+3.D0*HfxZpE*VRR1(17,25)-4.D0*r1x2E*ZxZpE*VRR1(29,14)+WQy*VRR1(29,25)
      VRR0(29,42)=3.D0*V(179)-3.D0*V(180)+QCx*VRR0(29,26)+WQx*VRR1(29,26)
      VRR0(29,43)=V(182)+V(184)+QCx*VRR0(29,27)+WQx*VRR1(29,27)
      VRR0(29,44)=2.D0*V(161)+V(186)+V(188)+PAy*VRR0(17,44)+WPy*VRR1(17,44)
      VRR0(29,45)=3.D0*V(165)+V(182)+V(184)+QCy*VRR0(29,28)+WQy*VRR1(29,28)
      VRR0(29,46)=3.D0*V(189)-3.D0*V(190)+QCy*VRR0(29,29)+3.D0*HfxZpE*VRR1(17,29)+WQy*VRR1(29,29)
      VRR0(29,47)=2.D0*V(191)-2.D0*V(192)+QCx*VRR0(29,30)+WQx*VRR1(29,30)
      VRR0(29,48)=V(168)+V(194)+V(196)+PAy*VRR0(17,48)+WPy*VRR1(17,48)
      VRR0(29,49)=V(198)+V(200)+V(201)+PAy*VRR0(17,49)+WPy*VRR1(17,49)
      VRR0(29,50)=2.D0*V(202)+3.D0*V(203)-2.D0*V(204)+QCy*VRR0(29,32)+WQy*VRR1(29,32)
      VRR0(29,51)=V(85)+2.D0*V(179)-2.D0*V(180)+QCz*VRR0(29,30)+WQz*VRR1(29,30)
      VRR0(29,52)=V(90)+V(182)+V(184)+QCz*VRR0(29,31)+WQz*VRR1(29,31)
      VRR0(29,53)=V(91)+2.D0*V(189)-2.D0*V(190)+QCz*VRR0(29,32)+WQz*VRR1(29,32)
      VRR0(29,54)=V(92)+3.D0*V(191)-3.D0*V(192)+QCz*VRR0(29,33)+WQz*VRR1(29,33)
      VRR0(29,55)=V(93)+3.D0*V(202)-3.D0*V(204)+QCz*VRR0(29,34)+WQz*VRR1(29,34)
      VRR0(29,56)=4.D0*r1x2E*VRR0(29,20)+QCz*VRR0(29,35)+HfxZpE*VRR1(14,35)-4.D0*r1x2E*ZxZpE*VRR1(29,20)+WQz*VRR1(29,35)
      VRR0(30,36)=4.D0*r1x2E*VRR0(30,11)+QCx*VRR0(30,21)+2.D0*HfxZpE*VRR1(18,21)-4.D0*r1x2E*ZxZpE*VRR1(30,11)+WQx*VRR1(30,21)
      VRR0(30,37)=3.D0*V(205)-3.D0*V(206)+QCx*VRR0(30,22)+2.D0*HfxZpE*VRR1(18,22)+WQx*VRR1(30,22)
      VRR0(30,38)=2.D0*V(207)+2.D0*V(208)-2.D0*V(209)+QCx*VRR0(30,23)+WQx*VRR1(30,23)
      VRR0(30,39)=2.D0*V(205)-2.D0*V(206)+QCy*VRR0(30,23)+WQy*VRR1(30,23)
      VRR0(30,40)=3.D0*V(207)-3.D0*V(209)+QCy*VRR0(30,24)+WQy*VRR1(30,24)
      VRR0(30,41)=4.D0*r1x2E*VRR0(30,14)+QCy*VRR0(30,25)-4.D0*r1x2E*ZxZpE*VRR1(30,14)+WQy*VRR1(30,25)
      VRR0(30,42)=3.D0*V(210)-3.D0*V(211)+QCx*VRR0(30,26)+2.D0*HfxZpE*VRR1(18,26)+WQx*VRR1(30,26)
      VRR0(30,43)=V(213)+V(215)+V(217)+QCx*VRR0(30,27)+WQx*VRR1(30,27)
      VRR0(30,44)=V(218)+V(220)-V(221)+QCx*VRR0(30,28)+WQx*VRR1(30,28)
      VRR0(30,45)=V(213)+V(217)+QCy*VRR0(30,28)+WQy*VRR1(30,28)
      VRR0(30,46)=3.D0*V(218)-3.D0*V(221)+QCy*VRR0(30,29)+WQy*VRR1(30,29)
      VRR0(30,47)=2.D0*V(222)+2.D0*V(223)-2.D0*V(224)+QCx*VRR0(30,30)+WQx*VRR1(30,30)
      VRR0(30,48)=V(225)+2.D0*V(226)-V(227)+QCx*VRR0(30,31)+WQx*VRR1(30,31)
      VRR0(30,49)=V(222)-V(224)+QCy*VRR0(30,31)+WQy*VRR1(30,31)
      VRR0(30,50)=2.D0*V(225)-2.D0*V(227)+QCy*VRR0(30,32)+WQy*VRR1(30,32)
      VRR0(30,51)=2.D0*V(113)+2.D0*V(210)-2.D0*V(211)+QCz*VRR0(30,30)+WQz*VRR1(30,30)
      VRR0(30,52)=V(120)+V(213)+V(217)+QCz*VRR0(30,31)+WQz*VRR1(30,31)
      VRR0(30,53)=2.D0*V(125)+2.D0*V(218)-2.D0*V(221)+QCz*VRR0(30,32)+WQz*VRR1(30,32)
      VRR0(30,54)=3.D0*V(222)-3.D0*V(224)+QCz*VRR0(30,33)+2.D0*HfxZpE*VRR1(15,33)+WQz*VRR1(30,33)
      VRR0(30,55)=3.D0*V(225)-3.D0*V(227)+QCz*VRR0(30,34)+2.D0*HfxZpE*VRR1(15,34)+WQz*VRR1(30,34)
      VRR0(30,56)=4.D0*r1x2E*VRR0(30,20)+QCz*VRR0(30,35)+2.D0*HfxZpE*VRR1(15,35)-4.D0*r1x2E*ZxZpE*VRR1(30,20)+WQz*VRR1(30,35)
      VRR0(31,36)=4.D0*r1x2E*VRR0(31,11)+QCx*VRR0(31,21)+HfxZpE*VRR1(19,21)-4.D0*r1x2E*ZxZpE*VRR1(31,11)+WQx*VRR1(31,21)
      VRR0(31,37)=3.D0*V(228)-3.D0*V(229)+QCx*VRR0(31,22)+HfxZpE*VRR1(19,22)+WQx*VRR1(31,22)
      VRR0(31,38)=2.D0*V(230)+V(231)-2.D0*V(232)+QCx*VRR0(31,23)+WQx*VRR1(31,23)
      VRR0(31,39)=V(208)+2.D0*V(228)-2.D0*V(229)+QCy*VRR0(31,23)+WQy*VRR1(31,23)
      VRR0(31,40)=3.D0*V(230)-3.D0*V(232)+QCy*VRR0(31,24)+HfxZpE*VRR1(18,24)+WQy*VRR1(31,24)
      VRR0(31,41)=4.D0*r1x2E*VRR0(31,14)+QCy*VRR0(31,25)+HfxZpE*VRR1(18,25)-4.D0*r1x2E*ZxZpE*VRR1(31,14)+WQy*VRR1(31,25)
      VRR0(31,42)=3.D0*V(233)-3.D0*V(234)+QCx*VRR0(31,26)+HfxZpE*VRR1(19,26)+WQx*VRR1(31,26)
      VRR0(31,43)=V(236)+V(237)+V(239)+QCx*VRR0(31,27)+WQx*VRR1(31,27)
      VRR0(31,44)=V(240)+V(241)-V(242)+QCx*VRR0(31,28)+WQx*VRR1(31,28)
      VRR0(31,45)=V(219)+V(236)+V(239)+QCy*VRR0(31,28)+WQy*VRR1(31,28)
      VRR0(31,46)=3.D0*V(240)-3.D0*V(242)+QCy*VRR0(31,29)+HfxZpE*VRR1(18,29)+WQy*VRR1(31,29)
      VRR0(31,47)=2.D0*V(243)+V(244)-2.D0*V(245)+QCx*VRR0(31,30)+WQx*VRR1(31,30)
      VRR0(31,48)=V(246)+V(247)-V(248)+QCx*VRR0(31,31)+WQx*VRR1(31,31)
      VRR0(31,49)=V(226)+V(243)-V(245)+QCy*VRR0(31,31)+WQy*VRR1(31,31)
      VRR0(31,50)=2.D0*V(246)-2.D0*V(248)+V(249)+QCy*VRR0(31,32)+WQy*VRR1(31,32)
      VRR0(31,51)=V(146)+2.D0*V(233)-2.D0*V(234)+QCz*VRR0(31,30)+WQz*VRR1(31,30)
      VRR0(31,52)=V(150)+V(236)+V(239)+QCz*VRR0(31,31)+WQz*VRR1(31,31)
      VRR0(31,53)=V(174)+2.D0*V(240)-2.D0*V(242)+QCz*VRR0(31,32)+WQz*VRR1(31,32)
      VRR0(31,54)=3.D0*V(243)-3.D0*V(245)+QCz*VRR0(31,33)+2.D0*HfxZpE*VRR1(16,33)+WQz*VRR1(31,33)
      VRR0(31,55)=3.D0*V(246)-3.D0*V(248)+QCz*VRR0(31,34)+2.D0*HfxZpE*VRR1(16,34)+WQz*VRR1(31,34)
      VRR0(31,56)=4.D0*r1x2E*VRR0(31,20)+QCz*VRR0(31,35)+2.D0*HfxZpE*VRR1(16,35)-4.D0*r1x2E*ZxZpE*VRR1(31,20)+WQz*VRR1(31,35)
      VRR0(32,36)=4.D0*r1x2E*VRR0(32,11)+QCx*VRR0(32,21)-4.D0*r1x2E*ZxZpE*VRR1(32,11)+WQx*VRR1(32,21)
      VRR0(32,37)=3.D0*V(250)-3.D0*V(251)+QCx*VRR0(32,22)+WQx*VRR1(32,22)
      VRR0(32,38)=2.D0*V(252)-2.D0*V(253)+QCx*VRR0(32,23)+WQx*VRR1(32,23)
      VRR0(32,39)=2.D0*V(231)+2.D0*V(250)-2.D0*V(251)+QCy*VRR0(32,23)+WQy*VRR1(32,23)
      VRR0(32,40)=3.D0*V(252)-3.D0*V(253)+QCy*VRR0(32,24)+2.D0*HfxZpE*VRR1(19,24)+WQy*VRR1(32,24)
      VRR0(32,41)=4.D0*r1x2E*VRR0(32,14)+QCy*VRR0(32,25)+2.D0*HfxZpE*VRR1(19,25)-4.D0*r1x2E*ZxZpE*VRR1(32,14)+WQy*VRR1(32,25)
      VRR0(32,42)=3.D0*V(254)-3.D0*V(255)+QCx*VRR0(32,26)+WQx*VRR1(32,26)
      VRR0(32,43)=V(257)+V(259)+QCx*VRR0(32,27)+WQx*VRR1(32,27)
      VRR0(32,44)=V(260)-V(261)+QCx*VRR0(32,28)+WQx*VRR1(32,28)
      VRR0(32,45)=V(257)+V(259)+V(262)+QCy*VRR0(32,28)+WQy*VRR1(32,28)
      VRR0(32,46)=3.D0*V(260)-3.D0*V(261)+QCy*VRR0(32,29)+2.D0*HfxZpE*VRR1(19,29)+WQy*VRR1(32,29)
      VRR0(32,47)=2.D0*V(263)-2.D0*V(264)+QCx*VRR0(32,30)+WQx*VRR1(32,30)
      VRR0(32,48)=V(265)-V(266)+QCx*VRR0(32,31)+WQx*VRR1(32,31)
      VRR0(32,49)=2.D0*V(247)+V(263)-V(264)+QCy*VRR0(32,31)+WQy*VRR1(32,31)
      VRR0(32,50)=2.D0*V(265)-2.D0*V(266)+2.D0*V(267)+QCy*VRR0(32,32)+WQy*VRR1(32,32)
      VRR0(32,51)=2.D0*V(168)+2.D0*V(254)-2.D0*V(255)+QCz*VRR0(32,30)+WQz*VRR1(32,30)
      VRR0(32,52)=V(201)+V(257)+V(259)+QCz*VRR0(32,31)+WQz*VRR1(32,31)
      VRR0(32,53)=2.D0*V(203)+2.D0*V(260)-2.D0*V(261)+QCz*VRR0(32,32)+WQz*VRR1(32,32)
      VRR0(32,54)=3.D0*V(263)-3.D0*V(264)+QCz*VRR0(32,33)+2.D0*HfxZpE*VRR1(17,33)+WQz*VRR1(32,33)
      VRR0(32,55)=3.D0*V(265)-3.D0*V(266)+QCz*VRR0(32,34)+2.D0*HfxZpE*VRR1(17,34)+WQz*VRR1(32,34)
      VRR0(32,56)=4.D0*r1x2E*VRR0(32,20)+QCz*VRR0(32,35)+2.D0*HfxZpE*VRR1(17,35)-4.D0*r1x2E*ZxZpE*VRR1(32,20)+WQz*VRR1(32,35)
      VRR0(33,36)=4.D0*r1x2E*VRR0(33,11)+QCx*VRR0(33,21)+HfxZpE*VRR1(20,21)-4.D0*r1x2E*ZxZpE*VRR1(33,11)+WQx*VRR1(33,21)
      VRR0(33,37)=3.D0*V(268)+V(269)-3.D0*V(270)+QCx*VRR0(33,22)+WQx*VRR1(33,22)
      VRR0(33,38)=2.D0*V(271)+V(272)-2.D0*V(273)+QCx*VRR0(33,23)+WQx*VRR1(33,23)
      VRR0(33,39)=2.D0*V(268)-2.D0*V(270)+QCy*VRR0(33,23)+WQy*VRR1(33,23)
      VRR0(33,40)=3.D0*V(271)-3.D0*V(273)+QCy*VRR0(33,24)+WQy*VRR1(33,24)
      VRR0(33,41)=4.D0*r1x2E*VRR0(33,14)+QCy*VRR0(33,25)-4.D0*r1x2E*ZxZpE*VRR1(33,14)+WQy*VRR1(33,25)
      VRR0(33,42)=3.D0*V(274)+V(275)-3.D0*V(276)+QCx*VRR0(33,26)+WQx*VRR1(33,26)
      VRR0(33,43)=V(278)+V(279)+V(281)+QCx*VRR0(33,27)+WQx*VRR1(33,27)
      VRR0(33,44)=V(106)+V(108)+V(208)+PAz*VRR0(18,44)+WPz*VRR1(18,44)
      VRR0(33,45)=V(278)+V(281)+QCy*VRR0(33,28)+WQy*VRR1(33,28)
      VRR0(33,46)=3.D0*V(282)-3.D0*V(283)+QCy*VRR0(33,29)+WQy*VRR1(33,29)
      VRR0(33,47)=2.D0*V(284)+V(285)-2.D0*V(286)+QCx*VRR0(33,30)+WQx*VRR1(33,30)
      VRR0(33,48)=V(116)+V(118)+V(215)+PAz*VRR0(18,48)+WPz*VRR1(18,48)
      VRR0(33,49)=V(122)+V(124)+V(220)+PAz*VRR0(18,49)+WPz*VRR1(18,49)
      VRR0(33,50)=2.D0*V(287)-2.D0*V(288)+QCy*VRR0(33,32)+WQy*VRR1(33,32)
      VRR0(33,51)=3.D0*V(223)+2.D0*V(274)-2.D0*V(276)+QCz*VRR0(33,30)+WQz*VRR1(33,30)
      VRR0(33,52)=3.D0*V(226)+V(278)+V(281)+QCz*VRR0(33,31)+WQz*VRR1(33,31)
      VRR0(33,53)=3.D0*V(249)+2.D0*V(282)-2.D0*V(283)+QCz*VRR0(33,32)+WQz*VRR1(33,32)
      VRR0(33,54)=3.D0*V(284)-3.D0*V(286)+QCz*VRR0(33,33)+3.D0*HfxZpE*VRR1(18,33)+WQz*VRR1(33,33)
      VRR0(33,55)=3.D0*V(287)-3.D0*V(288)+QCz*VRR0(33,34)+3.D0*HfxZpE*VRR1(18,34)+WQz*VRR1(33,34)
      VRR0(33,56)=4.D0*r1x2E*VRR0(33,20)+QCz*VRR0(33,35)+3.D0*HfxZpE*VRR1(18,35)-4.D0*r1x2E*ZxZpE*VRR1(33,20)+WQz*VRR1(33,35)
      VRR0(34,36)=4.D0*r1x2E*VRR0(34,11)+QCx*VRR0(34,21)-4.D0*r1x2E*ZxZpE*VRR1(34,11)+WQx*VRR1(34,21)
      VRR0(34,37)=3.D0*V(289)-3.D0*V(290)+QCx*VRR0(34,22)+WQx*VRR1(34,22)
      VRR0(34,38)=2.D0*V(291)-2.D0*V(292)+QCx*VRR0(34,23)+WQx*VRR1(34,23)
      VRR0(34,39)=V(272)+2.D0*V(289)-2.D0*V(290)+QCy*VRR0(34,23)+WQy*VRR1(34,23)
      VRR0(34,40)=3.D0*V(291)-3.D0*V(292)+V(293)+QCy*VRR0(34,24)+WQy*VRR1(34,24)
      VRR0(34,41)=4.D0*r1x2E*VRR0(34,14)+QCy*VRR0(34,25)+HfxZpE*VRR1(20,25)-4.D0*r1x2E*ZxZpE*VRR1(34,14)+WQy*VRR1(34,25)
      VRR0(34,42)=3.D0*V(294)-3.D0*V(295)+QCx*VRR0(34,26)+WQx*VRR1(34,26)
      VRR0(34,43)=V(297)+V(299)+QCx*VRR0(34,27)+WQx*VRR1(34,27)
      VRR0(34,44)=V(186)+V(188)+V(231)+PAz*VRR0(19,44)+WPz*VRR1(19,44)
      VRR0(34,45)=V(297)+V(299)+V(300)+QCy*VRR0(34,28)+WQy*VRR1(34,28)
      VRR0(34,46)=3.D0*V(301)+V(302)-3.D0*V(303)+QCy*VRR0(34,29)+WQy*VRR1(34,29)
      VRR0(34,47)=2.D0*V(304)-2.D0*V(305)+QCx*VRR0(34,30)+WQx*VRR1(34,30)
      VRR0(34,48)=V(194)+V(196)+2.D0*V(237)+PAz*VRR0(19,48)+WPz*VRR1(19,48)
      VRR0(34,49)=V(198)+V(200)+V(262)+PAz*VRR0(19,49)+WPz*VRR1(19,49)
      VRR0(34,50)=2.D0*V(306)+V(307)-2.D0*V(308)+QCy*VRR0(34,32)+WQy*VRR1(34,32)
      VRR0(34,51)=3.D0*V(244)+2.D0*V(294)-2.D0*V(295)+QCz*VRR0(34,30)+WQz*VRR1(34,30)
      VRR0(34,52)=3.D0*V(247)+V(297)+V(299)+QCz*VRR0(34,31)+WQz*VRR1(34,31)
      VRR0(34,53)=3.D0*V(267)+2.D0*V(301)-2.D0*V(303)+QCz*VRR0(34,32)+WQz*VRR1(34,32)
      VRR0(34,54)=3.D0*V(304)-3.D0*V(305)+QCz*VRR0(34,33)+3.D0*HfxZpE*VRR1(19,33)+WQz*VRR1(34,33)
      VRR0(34,55)=3.D0*V(306)-3.D0*V(308)+QCz*VRR0(34,34)+3.D0*HfxZpE*VRR1(19,34)+WQz*VRR1(34,34)
      VRR0(34,56)=4.D0*r1x2E*VRR0(34,20)+QCz*VRR0(34,35)+3.D0*HfxZpE*VRR1(19,35)-4.D0*r1x2E*ZxZpE*VRR1(34,20)+WQz*VRR1(34,35)
      VRR0(35,36)=4.D0*r1x2E*VRR0(35,11)+QCx*VRR0(35,21)-4.D0*r1x2E*ZxZpE*VRR1(35,11)+WQx*VRR1(35,21)
      VRR0(35,37)=3.D0*r1x2E*VRR0(35,12)+QCx*VRR0(35,22)-3.D0*r1x2E*ZxZpE*VRR1(35,12)+WQx*VRR1(35,22)
      VRR0(35,38)=3.D0*r1x2Z*VRR0(10,38)+PAz*VRR0(20,38)-3.D0*ExZpE*r1x2Z*VRR1(10,38)+WPz*VRR1(20,38)
      VRR0(35,39)=3.D0*r1x2Z*VRR0(10,39)+PAz*VRR0(20,39)-3.D0*ExZpE*r1x2Z*VRR1(10,39)+WPz*VRR1(20,39)
      VRR0(35,40)=3.D0*r1x2E*VRR0(35,13)+QCy*VRR0(35,24)-3.D0*r1x2E*ZxZpE*VRR1(35,13)+WQy*VRR1(35,24)
      VRR0(35,41)=4.D0*r1x2E*VRR0(35,14)+QCy*VRR0(35,25)-4.D0*r1x2E*ZxZpE*VRR1(35,14)+WQy*VRR1(35,25)
      VRR0(35,42)=3.D0*r1x2E*VRR0(35,15)+QCx*VRR0(35,26)-3.D0*r1x2E*ZxZpE*VRR1(35,15)+WQx*VRR1(35,26)
      VRR0(35,43)=V(269)+3.D0*r1x2Z*VRR0(10,43)+PAz*VRR0(20,43)-3.D0*ExZpE*r1x2Z*VRR1(10,43)+WPz*VRR1(20,43)
      VRR0(35,44)=V(272)+3.D0*r1x2Z*VRR0(10,44)+PAz*VRR0(20,44)-3.D0*ExZpE*r1x2Z*VRR1(10,44)+WPz*VRR1(20,44)
      VRR0(35,45)=V(293)+3.D0*r1x2Z*VRR0(10,45)+PAz*VRR0(20,45)-3.D0*ExZpE*r1x2Z*VRR1(10,45)+WPz*VRR1(20,45)
      VRR0(35,46)=3.D0*r1x2E*VRR0(35,17)+QCy*VRR0(35,29)-3.D0*r1x2E*ZxZpE*VRR1(35,17)+WQy*VRR1(35,29)
      VRR0(35,47)=2.D0*V(275)+3.D0*r1x2Z*VRR0(10,47)+PAz*VRR0(20,47)-3.D0*ExZpE*r1x2Z*VRR1(10,47)+WPz*VRR1(20,47)
      VRR0(35,48)=2.D0*V(279)+3.D0*r1x2Z*VRR0(10,48)+PAz*VRR0(20,48)-3.D0*ExZpE*r1x2Z*VRR1(10,48)+WPz*VRR1(20,48)
      VRR0(35,49)=2.D0*V(300)+3.D0*r1x2Z*VRR0(10,49)+PAz*VRR0(20,49)-3.D0*ExZpE*r1x2Z*VRR1(10,49)+WPz*VRR1(20,49)
      VRR0(35,50)=2.D0*V(302)+3.D0*r1x2Z*VRR0(10,50)+PAz*VRR0(20,50)-3.D0*ExZpE*r1x2Z*VRR1(10,50)+WPz*VRR1(20,50)
      VRR0(35,51)=3.D0*V(285)+3.D0*r1x2Z*VRR0(10,51)+PAz*VRR0(20,51)-3.D0*ExZpE*r1x2Z*VRR1(10,51)+WPz*VRR1(20,51)
      VRR0(35,52)=3.D0*r1x2Z*VRR0(10,52)+PAz*VRR0(20,52)-3.D0*ExZpE*r1x2Z*VRR1(10,52)+3.D0*HfxZpE*VRR1(20,31)+WPz*VRR1(20,52)
      VRR0(35,53)=3.D0*V(307)+3.D0*r1x2Z*VRR0(10,53)+PAz*VRR0(20,53)-3.D0*ExZpE*r1x2Z*VRR1(10,53)+WPz*VRR1(20,53)
      VRR0(35,54)=3.D0*r1x2E*VRR0(35,18)+QCz*VRR0(35,33)+4.D0*HfxZpE*VRR1(20,33)-3.D0*r1x2E*ZxZpE*VRR1(35,18)+WQz*VRR1(35,33)
      VRR0(35,55)=3.D0*r1x2E*VRR0(35,19)+QCz*VRR0(35,34)+4.D0*HfxZpE*VRR1(20,34)-3.D0*r1x2E*ZxZpE*VRR1(35,19)+WQz*VRR1(35,34)
      VRR0(35,56)=4.D0*r1x2E*VRR0(35,20)+QCz*VRR0(35,35)+4.D0*HfxZpE*VRR1(20,35)-4.D0*r1x2E*ZxZpE*VRR1(35,20)+WQz*VRR1(35,35)
END SUBROUTINE VRRg0h0
SUBROUTINE MVRRg0h0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,36)=QCx*VS0(21,21)+WQx*VS1(21,21)-r1x2E*VR1(21,21)&
   +4D0*r1x2E*(VS0(21,11)-ZxZpE*VS1(21,11))&
   +4D0*HfxZpE*VS1(11,21)
VS0(21,37)=QCx*VS0(21,22)+WQx*VS1(21,22)-r1x2E*VR1(21,22)&
   +3D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))&
   +4D0*HfxZpE*VS1(11,22)
VS0(21,38)=QCx*VS0(21,23)+WQx*VS1(21,23)-r1x2E*VR1(21,23)&
   +2D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))&
   +4D0*HfxZpE*VS1(11,23)
VS0(21,39)=QCy*VS0(21,23)+WQy*VS1(21,23)&
   +2D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))
VS0(21,40)=QCy*VS0(21,24)+WQy*VS1(21,24)&
   +3D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))
VS0(21,41)=QCy*VS0(21,25)+WQy*VS1(21,25)&
   +4D0*r1x2E*(VS0(21,14)-ZxZpE*VS1(21,14))
VS0(21,42)=QCx*VS0(21,26)+WQx*VS1(21,26)-r1x2E*VR1(21,26)&
   +3D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))&
   +4D0*HfxZpE*VS1(11,26)
VS0(21,43)=QCx*VS0(21,27)+WQx*VS1(21,27)-r1x2E*VR1(21,27)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))&
   +4D0*HfxZpE*VS1(11,27)
VS0(21,44)=QCx*VS0(21,28)+WQx*VS1(21,28)-r1x2E*VR1(21,28)&
   +r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))&
   +4D0*HfxZpE*VS1(11,28)
VS0(21,45)=QCy*VS0(21,28)+WQy*VS1(21,28)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,46)=QCy*VS0(21,29)+WQy*VS1(21,29)&
   +3D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,47)=QCx*VS0(21,30)+WQx*VS1(21,30)-r1x2E*VR1(21,30)&
   +2D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))&
   +4D0*HfxZpE*VS1(11,30)
VS0(21,48)=QCx*VS0(21,31)+WQx*VS1(21,31)-r1x2E*VR1(21,31)&
   +r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))&
   +4D0*HfxZpE*VS1(11,31)
VS0(21,49)=QCy*VS0(21,31)+WQy*VS1(21,31)&
   +r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,50)=QCy*VS0(21,32)+WQy*VS1(21,32)&
   +2D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,51)=QCz*VS0(21,30)+WQz*VS1(21,30)&
   +2D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))
VS0(21,52)=QCz*VS0(21,31)+WQz*VS1(21,31)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,53)=QCz*VS0(21,32)+WQz*VS1(21,32)&
   +2D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,54)=QCz*VS0(21,33)+WQz*VS1(21,33)&
   +3D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,55)=QCz*VS0(21,34)+WQz*VS1(21,34)&
   +3D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,56)=QCz*VS0(21,35)+WQz*VS1(21,35)&
   +4D0*r1x2E*(VS0(21,20)-ZxZpE*VS1(21,20))
VS0(22,36)=QCx*VS0(22,21)+WQx*VS1(22,21)-r1x2E*VR1(22,21)&
   +4D0*r1x2E*(VS0(22,11)-ZxZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(12,21)
VS0(22,37)=QCx*VS0(22,22)+WQx*VS1(22,22)-r1x2E*VR1(22,22)&
   +3D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +3D0*HfxZpE*VS1(12,22)
VS0(22,38)=QCx*VS0(22,23)+WQx*VS1(22,23)-r1x2E*VR1(22,23)&
   +2D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +3D0*HfxZpE*VS1(12,23)
VS0(22,39)=QCy*VS0(22,23)+WQy*VS1(22,23)&
   +2D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +HfxZpE*VS1(11,23)
VS0(22,40)=QCy*VS0(22,24)+WQy*VS1(22,24)&
   +3D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +HfxZpE*VS1(11,24)
VS0(22,41)=QCy*VS0(22,25)+WQy*VS1(22,25)&
   +4D0*r1x2E*(VS0(22,14)-ZxZpE*VS1(22,14))&
   +HfxZpE*VS1(11,25)
VS0(22,42)=QCx*VS0(22,26)+WQx*VS1(22,26)-r1x2E*VR1(22,26)&
   +3D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))&
   +3D0*HfxZpE*VS1(12,26)
VS0(22,43)=QCx*VS0(22,27)+WQx*VS1(22,27)-r1x2E*VR1(22,27)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +3D0*HfxZpE*VS1(12,27)
VS0(22,44)=QCx*VS0(22,28)+WQx*VS1(22,28)-r1x2E*VR1(22,28)&
   +r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +3D0*HfxZpE*VS1(12,28)
VS0(22,45)=QCy*VS0(22,28)+WQy*VS1(22,28)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +HfxZpE*VS1(11,28)
VS0(22,46)=QCy*VS0(22,29)+WQy*VS1(22,29)&
   +3D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +HfxZpE*VS1(11,29)
VS0(22,47)=QCx*VS0(22,30)+WQx*VS1(22,30)-r1x2E*VR1(22,30)&
   +2D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +3D0*HfxZpE*VS1(12,30)
VS0(22,48)=QCx*VS0(22,31)+WQx*VS1(22,31)-r1x2E*VR1(22,31)&
   +r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +3D0*HfxZpE*VS1(12,31)
VS0(22,49)=QCy*VS0(22,31)+WQy*VS1(22,31)&
   +r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +HfxZpE*VS1(11,31)
VS0(22,50)=QCy*VS0(22,32)+WQy*VS1(22,32)&
   +2D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +HfxZpE*VS1(11,32)
VS0(22,51)=QCz*VS0(22,30)+WQz*VS1(22,30)&
   +2D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))
VS0(22,52)=QCz*VS0(22,31)+WQz*VS1(22,31)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))
VS0(22,53)=QCz*VS0(22,32)+WQz*VS1(22,32)&
   +2D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))
VS0(22,54)=QCz*VS0(22,33)+WQz*VS1(22,33)&
   +3D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))
VS0(22,55)=QCz*VS0(22,34)+WQz*VS1(22,34)&
   +3D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))
VS0(22,56)=QCz*VS0(22,35)+WQz*VS1(22,35)&
   +4D0*r1x2E*(VS0(22,20)-ZxZpE*VS1(22,20))
VS0(23,36)=QCx*VS0(23,21)+WQx*VS1(23,21)-r1x2E*VR1(23,21)&
   +4D0*r1x2E*(VS0(23,11)-ZxZpE*VS1(23,11))&
   +2D0*HfxZpE*VS1(13,21)
VS0(23,37)=QCx*VS0(23,22)+WQx*VS1(23,22)-r1x2E*VR1(23,22)&
   +3D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(13,22)
VS0(23,38)=QCx*VS0(23,23)+WQx*VS1(23,23)-r1x2E*VR1(23,23)&
   +2D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(13,23)
VS0(23,39)=QCy*VS0(23,23)+WQy*VS1(23,23)&
   +2D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(12,23)
VS0(23,40)=QCy*VS0(23,24)+WQy*VS1(23,24)&
   +3D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(12,24)
VS0(23,41)=QCy*VS0(23,25)+WQy*VS1(23,25)&
   +4D0*r1x2E*(VS0(23,14)-ZxZpE*VS1(23,14))&
   +2D0*HfxZpE*VS1(12,25)
VS0(23,42)=QCx*VS0(23,26)+WQx*VS1(23,26)-r1x2E*VR1(23,26)&
   +3D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(13,26)
VS0(23,43)=QCx*VS0(23,27)+WQx*VS1(23,27)-r1x2E*VR1(23,27)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(13,27)
VS0(23,44)=QCx*VS0(23,28)+WQx*VS1(23,28)-r1x2E*VR1(23,28)&
   +r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(13,28)
VS0(23,45)=QCy*VS0(23,28)+WQy*VS1(23,28)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(12,28)
VS0(23,46)=QCy*VS0(23,29)+WQy*VS1(23,29)&
   +3D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(12,29)
VS0(23,47)=QCx*VS0(23,30)+WQx*VS1(23,30)-r1x2E*VR1(23,30)&
   +2D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(13,30)
VS0(23,48)=QCx*VS0(23,31)+WQx*VS1(23,31)-r1x2E*VR1(23,31)&
   +r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(13,31)
VS0(23,49)=QCy*VS0(23,31)+WQy*VS1(23,31)&
   +r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(12,31)
VS0(23,50)=QCy*VS0(23,32)+WQy*VS1(23,32)&
   +2D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(12,32)
VS0(23,51)=QCz*VS0(23,30)+WQz*VS1(23,30)&
   +2D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))
VS0(23,52)=QCz*VS0(23,31)+WQz*VS1(23,31)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))
VS0(23,53)=QCz*VS0(23,32)+WQz*VS1(23,32)&
   +2D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))
VS0(23,54)=QCz*VS0(23,33)+WQz*VS1(23,33)&
   +3D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))
VS0(23,55)=QCz*VS0(23,34)+WQz*VS1(23,34)&
   +3D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))
VS0(23,56)=QCz*VS0(23,35)+WQz*VS1(23,35)&
   +4D0*r1x2E*(VS0(23,20)-ZxZpE*VS1(23,20))
VS0(24,36)=QCx*VS0(24,21)+WQx*VS1(24,21)-r1x2E*VR1(24,21)&
   +4D0*r1x2E*(VS0(24,11)-ZxZpE*VS1(24,11))&
   +HfxZpE*VS1(14,21)
VS0(24,37)=QCx*VS0(24,22)+WQx*VS1(24,22)-r1x2E*VR1(24,22)&
   +3D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +HfxZpE*VS1(14,22)
VS0(24,38)=QCx*VS0(24,23)+WQx*VS1(24,23)-r1x2E*VR1(24,23)&
   +2D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +HfxZpE*VS1(14,23)
VS0(24,39)=QCy*VS0(24,23)+WQy*VS1(24,23)&
   +2D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +3D0*HfxZpE*VS1(13,23)
VS0(24,40)=QCy*VS0(24,24)+WQy*VS1(24,24)&
   +3D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +3D0*HfxZpE*VS1(13,24)
VS0(24,41)=QCy*VS0(24,25)+WQy*VS1(24,25)&
   +4D0*r1x2E*(VS0(24,14)-ZxZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(13,25)
VS0(24,42)=QCx*VS0(24,26)+WQx*VS1(24,26)-r1x2E*VR1(24,26)&
   +3D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))&
   +HfxZpE*VS1(14,26)
VS0(24,43)=QCx*VS0(24,27)+WQx*VS1(24,27)-r1x2E*VR1(24,27)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +HfxZpE*VS1(14,27)
VS0(24,44)=QCx*VS0(24,28)+WQx*VS1(24,28)-r1x2E*VR1(24,28)&
   +r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +HfxZpE*VS1(14,28)
VS0(24,45)=QCy*VS0(24,28)+WQy*VS1(24,28)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +3D0*HfxZpE*VS1(13,28)
VS0(24,46)=QCy*VS0(24,29)+WQy*VS1(24,29)&
   +3D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +3D0*HfxZpE*VS1(13,29)
VS0(24,47)=QCx*VS0(24,30)+WQx*VS1(24,30)-r1x2E*VR1(24,30)&
   +2D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +HfxZpE*VS1(14,30)
VS0(24,48)=QCx*VS0(24,31)+WQx*VS1(24,31)-r1x2E*VR1(24,31)&
   +r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +HfxZpE*VS1(14,31)
VS0(24,49)=QCy*VS0(24,31)+WQy*VS1(24,31)&
   +r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +3D0*HfxZpE*VS1(13,31)
VS0(24,50)=QCy*VS0(24,32)+WQy*VS1(24,32)&
   +2D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +3D0*HfxZpE*VS1(13,32)
VS0(24,51)=QCz*VS0(24,30)+WQz*VS1(24,30)&
   +2D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))
VS0(24,52)=QCz*VS0(24,31)+WQz*VS1(24,31)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))
VS0(24,53)=QCz*VS0(24,32)+WQz*VS1(24,32)&
   +2D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))
VS0(24,54)=QCz*VS0(24,33)+WQz*VS1(24,33)&
   +3D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))
VS0(24,55)=QCz*VS0(24,34)+WQz*VS1(24,34)&
   +3D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))
VS0(24,56)=QCz*VS0(24,35)+WQz*VS1(24,35)&
   +4D0*r1x2E*(VS0(24,20)-ZxZpE*VS1(24,20))
VS0(25,36)=QCx*VS0(25,21)+WQx*VS1(25,21)-r1x2E*VR1(25,21)&
   +4D0*r1x2E*(VS0(25,11)-ZxZpE*VS1(25,11))
VS0(25,37)=QCx*VS0(25,22)+WQx*VS1(25,22)-r1x2E*VR1(25,22)&
   +3D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))
VS0(25,38)=QCx*VS0(25,23)+WQx*VS1(25,23)-r1x2E*VR1(25,23)&
   +2D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))
VS0(25,39)=QCy*VS0(25,23)+WQy*VS1(25,23)&
   +2D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))&
   +4D0*HfxZpE*VS1(14,23)
VS0(25,40)=QCy*VS0(25,24)+WQy*VS1(25,24)&
   +3D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))&
   +4D0*HfxZpE*VS1(14,24)
VS0(25,41)=QCy*VS0(25,25)+WQy*VS1(25,25)&
   +4D0*r1x2E*(VS0(25,14)-ZxZpE*VS1(25,14))&
   +4D0*HfxZpE*VS1(14,25)
VS0(25,42)=QCx*VS0(25,26)+WQx*VS1(25,26)-r1x2E*VR1(25,26)&
   +3D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,43)=QCx*VS0(25,27)+WQx*VS1(25,27)-r1x2E*VR1(25,27)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,44)=QCx*VS0(25,28)+WQx*VS1(25,28)-r1x2E*VR1(25,28)&
   +r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,45)=QCy*VS0(25,28)+WQy*VS1(25,28)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))&
   +4D0*HfxZpE*VS1(14,28)
VS0(25,46)=QCy*VS0(25,29)+WQy*VS1(25,29)&
   +3D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))&
   +4D0*HfxZpE*VS1(14,29)
VS0(25,47)=QCx*VS0(25,30)+WQx*VS1(25,30)-r1x2E*VR1(25,30)&
   +2D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,48)=QCx*VS0(25,31)+WQx*VS1(25,31)-r1x2E*VR1(25,31)&
   +r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,49)=QCy*VS0(25,31)+WQy*VS1(25,31)&
   +r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))&
   +4D0*HfxZpE*VS1(14,31)
VS0(25,50)=QCy*VS0(25,32)+WQy*VS1(25,32)&
   +2D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))&
   +4D0*HfxZpE*VS1(14,32)
VS0(25,51)=QCz*VS0(25,30)+WQz*VS1(25,30)&
   +2D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,52)=QCz*VS0(25,31)+WQz*VS1(25,31)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,53)=QCz*VS0(25,32)+WQz*VS1(25,32)&
   +2D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,54)=QCz*VS0(25,33)+WQz*VS1(25,33)&
   +3D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,55)=QCz*VS0(25,34)+WQz*VS1(25,34)&
   +3D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,56)=QCz*VS0(25,35)+WQz*VS1(25,35)&
   +4D0*r1x2E*(VS0(25,20)-ZxZpE*VS1(25,20))
VS0(26,36)=QCx*VS0(26,21)+WQx*VS1(26,21)-r1x2E*VR1(26,21)&
   +4D0*r1x2E*(VS0(26,11)-ZxZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(15,21)
VS0(26,37)=QCx*VS0(26,22)+WQx*VS1(26,22)-r1x2E*VR1(26,22)&
   +3D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))&
   +3D0*HfxZpE*VS1(15,22)
VS0(26,38)=QCx*VS0(26,23)+WQx*VS1(26,23)-r1x2E*VR1(26,23)&
   +2D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))&
   +3D0*HfxZpE*VS1(15,23)
VS0(26,39)=QCy*VS0(26,23)+WQy*VS1(26,23)&
   +2D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))
VS0(26,40)=QCy*VS0(26,24)+WQy*VS1(26,24)&
   +3D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))
VS0(26,41)=QCy*VS0(26,25)+WQy*VS1(26,25)&
   +4D0*r1x2E*(VS0(26,14)-ZxZpE*VS1(26,14))
VS0(26,42)=QCx*VS0(26,26)+WQx*VS1(26,26)-r1x2E*VR1(26,26)&
   +3D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +3D0*HfxZpE*VS1(15,26)
VS0(26,43)=QCx*VS0(26,27)+WQx*VS1(26,27)-r1x2E*VR1(26,27)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +3D0*HfxZpE*VS1(15,27)
VS0(26,44)=QCx*VS0(26,28)+WQx*VS1(26,28)-r1x2E*VR1(26,28)&
   +r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +3D0*HfxZpE*VS1(15,28)
VS0(26,45)=QCy*VS0(26,28)+WQy*VS1(26,28)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))
VS0(26,46)=QCy*VS0(26,29)+WQy*VS1(26,29)&
   +3D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))
VS0(26,47)=QCx*VS0(26,30)+WQx*VS1(26,30)-r1x2E*VR1(26,30)&
   +2D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +3D0*HfxZpE*VS1(15,30)
VS0(26,48)=QCx*VS0(26,31)+WQx*VS1(26,31)-r1x2E*VR1(26,31)&
   +r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +3D0*HfxZpE*VS1(15,31)
VS0(26,49)=QCy*VS0(26,31)+WQy*VS1(26,31)&
   +r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))
VS0(26,50)=QCy*VS0(26,32)+WQy*VS1(26,32)&
   +2D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))
VS0(26,51)=QCz*VS0(26,30)+WQz*VS1(26,30)&
   +2D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +HfxZpE*VS1(11,30)
VS0(26,52)=QCz*VS0(26,31)+WQz*VS1(26,31)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +HfxZpE*VS1(11,31)
VS0(26,53)=QCz*VS0(26,32)+WQz*VS1(26,32)&
   +2D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +HfxZpE*VS1(11,32)
VS0(26,54)=QCz*VS0(26,33)+WQz*VS1(26,33)&
   +3D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +HfxZpE*VS1(11,33)
VS0(26,55)=QCz*VS0(26,34)+WQz*VS1(26,34)&
   +3D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +HfxZpE*VS1(11,34)
VS0(26,56)=QCz*VS0(26,35)+WQz*VS1(26,35)&
   +4D0*r1x2E*(VS0(26,20)-ZxZpE*VS1(26,20))&
   +HfxZpE*VS1(11,35)
VS0(27,36)=QCx*VS0(27,21)+WQx*VS1(27,21)-r1x2E*VR1(27,21)&
   +4D0*r1x2E*(VS0(27,11)-ZxZpE*VS1(27,11))&
   +2D0*HfxZpE*VS1(16,21)
VS0(27,37)=QCx*VS0(27,22)+WQx*VS1(27,22)-r1x2E*VR1(27,22)&
   +3D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(16,22)
VS0(27,38)=QCx*VS0(27,23)+WQx*VS1(27,23)-r1x2E*VR1(27,23)&
   +2D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(16,23)
VS0(27,39)=QCy*VS0(27,23)+WQy*VS1(27,23)&
   +2D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +HfxZpE*VS1(15,23)
VS0(27,40)=QCy*VS0(27,24)+WQy*VS1(27,24)&
   +3D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +HfxZpE*VS1(15,24)
VS0(27,41)=QCy*VS0(27,25)+WQy*VS1(27,25)&
   +4D0*r1x2E*(VS0(27,14)-ZxZpE*VS1(27,14))&
   +HfxZpE*VS1(15,25)
VS0(27,42)=QCx*VS0(27,26)+WQx*VS1(27,26)-r1x2E*VR1(27,26)&
   +3D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(16,26)
VS0(27,43)=QCx*VS0(27,27)+WQx*VS1(27,27)-r1x2E*VR1(27,27)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +2D0*HfxZpE*VS1(16,27)
VS0(27,44)=QCx*VS0(27,28)+WQx*VS1(27,28)-r1x2E*VR1(27,28)&
   +r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(16,28)
VS0(27,45)=QCy*VS0(27,28)+WQy*VS1(27,28)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(15,28)
VS0(27,46)=QCy*VS0(27,29)+WQy*VS1(27,29)&
   +3D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(15,29)
VS0(27,47)=QCx*VS0(27,30)+WQx*VS1(27,30)-r1x2E*VR1(27,30)&
   +2D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(16,30)
VS0(27,48)=QCx*VS0(27,31)+WQx*VS1(27,31)-r1x2E*VR1(27,31)&
   +r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(16,31)
VS0(27,49)=QCy*VS0(27,31)+WQy*VS1(27,31)&
   +r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(15,31)
VS0(27,50)=QCy*VS0(27,32)+WQy*VS1(27,32)&
   +2D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(15,32)
VS0(27,51)=QCz*VS0(27,30)+WQz*VS1(27,30)&
   +2D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +HfxZpE*VS1(12,30)
VS0(27,52)=QCz*VS0(27,31)+WQz*VS1(27,31)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(12,31)
VS0(27,53)=QCz*VS0(27,32)+WQz*VS1(27,32)&
   +2D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(12,32)
VS0(27,54)=QCz*VS0(27,33)+WQz*VS1(27,33)&
   +3D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(12,33)
VS0(27,55)=QCz*VS0(27,34)+WQz*VS1(27,34)&
   +3D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(12,34)
VS0(27,56)=QCz*VS0(27,35)+WQz*VS1(27,35)&
   +4D0*r1x2E*(VS0(27,20)-ZxZpE*VS1(27,20))&
   +HfxZpE*VS1(12,35)
VS0(28,36)=QCx*VS0(28,21)+WQx*VS1(28,21)-r1x2E*VR1(28,21)&
   +4D0*r1x2E*(VS0(28,11)-ZxZpE*VS1(28,11))&
   +HfxZpE*VS1(17,21)
VS0(28,37)=QCx*VS0(28,22)+WQx*VS1(28,22)-r1x2E*VR1(28,22)&
   +3D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +HfxZpE*VS1(17,22)
VS0(28,38)=QCx*VS0(28,23)+WQx*VS1(28,23)-r1x2E*VR1(28,23)&
   +2D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +HfxZpE*VS1(17,23)
VS0(28,39)=QCy*VS0(28,23)+WQy*VS1(28,23)&
   +2D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(16,23)
VS0(28,40)=QCy*VS0(28,24)+WQy*VS1(28,24)&
   +3D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(16,24)
VS0(28,41)=QCy*VS0(28,25)+WQy*VS1(28,25)&
   +4D0*r1x2E*(VS0(28,14)-ZxZpE*VS1(28,14))&
   +2D0*HfxZpE*VS1(16,25)
VS0(28,42)=QCx*VS0(28,26)+WQx*VS1(28,26)-r1x2E*VR1(28,26)&
   +3D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(17,26)
VS0(28,43)=QCx*VS0(28,27)+WQx*VS1(28,27)-r1x2E*VR1(28,27)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(17,27)
VS0(28,44)=QCx*VS0(28,28)+WQx*VS1(28,28)-r1x2E*VR1(28,28)&
   +r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(17,28)
VS0(28,45)=QCy*VS0(28,28)+WQy*VS1(28,28)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +2D0*HfxZpE*VS1(16,28)
VS0(28,46)=QCy*VS0(28,29)+WQy*VS1(28,29)&
   +3D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(16,29)
VS0(28,47)=QCx*VS0(28,30)+WQx*VS1(28,30)-r1x2E*VR1(28,30)&
   +2D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(17,30)
VS0(28,48)=QCx*VS0(28,31)+WQx*VS1(28,31)-r1x2E*VR1(28,31)&
   +r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(17,31)
VS0(28,49)=QCy*VS0(28,31)+WQy*VS1(28,31)&
   +r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(16,31)
VS0(28,50)=QCy*VS0(28,32)+WQy*VS1(28,32)&
   +2D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(16,32)
VS0(28,51)=QCz*VS0(28,30)+WQz*VS1(28,30)&
   +2D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(13,30)
VS0(28,52)=QCz*VS0(28,31)+WQz*VS1(28,31)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(13,31)
VS0(28,53)=QCz*VS0(28,32)+WQz*VS1(28,32)&
   +2D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(13,32)
VS0(28,54)=QCz*VS0(28,33)+WQz*VS1(28,33)&
   +3D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(13,33)
VS0(28,55)=QCz*VS0(28,34)+WQz*VS1(28,34)&
   +3D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(13,34)
VS0(28,56)=QCz*VS0(28,35)+WQz*VS1(28,35)&
   +4D0*r1x2E*(VS0(28,20)-ZxZpE*VS1(28,20))&
   +HfxZpE*VS1(13,35)
VS0(29,36)=QCx*VS0(29,21)+WQx*VS1(29,21)-r1x2E*VR1(29,21)&
   +4D0*r1x2E*(VS0(29,11)-ZxZpE*VS1(29,11))
VS0(29,37)=QCx*VS0(29,22)+WQx*VS1(29,22)-r1x2E*VR1(29,22)&
   +3D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))
VS0(29,38)=QCx*VS0(29,23)+WQx*VS1(29,23)-r1x2E*VR1(29,23)&
   +2D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))
VS0(29,39)=QCy*VS0(29,23)+WQy*VS1(29,23)&
   +2D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))&
   +3D0*HfxZpE*VS1(17,23)
VS0(29,40)=QCy*VS0(29,24)+WQy*VS1(29,24)&
   +3D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))&
   +3D0*HfxZpE*VS1(17,24)
VS0(29,41)=QCy*VS0(29,25)+WQy*VS1(29,25)&
   +4D0*r1x2E*(VS0(29,14)-ZxZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(17,25)
VS0(29,42)=QCx*VS0(29,26)+WQx*VS1(29,26)-r1x2E*VR1(29,26)&
   +3D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))
VS0(29,43)=QCx*VS0(29,27)+WQx*VS1(29,27)-r1x2E*VR1(29,27)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))
VS0(29,44)=QCx*VS0(29,28)+WQx*VS1(29,28)-r1x2E*VR1(29,28)&
   +r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))
VS0(29,45)=QCy*VS0(29,28)+WQy*VS1(29,28)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +3D0*HfxZpE*VS1(17,28)
VS0(29,46)=QCy*VS0(29,29)+WQy*VS1(29,29)&
   +3D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +3D0*HfxZpE*VS1(17,29)
VS0(29,47)=QCx*VS0(29,30)+WQx*VS1(29,30)-r1x2E*VR1(29,30)&
   +2D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))
VS0(29,48)=QCx*VS0(29,31)+WQx*VS1(29,31)-r1x2E*VR1(29,31)&
   +r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))
VS0(29,49)=QCy*VS0(29,31)+WQy*VS1(29,31)&
   +r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +3D0*HfxZpE*VS1(17,31)
VS0(29,50)=QCy*VS0(29,32)+WQy*VS1(29,32)&
   +2D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +3D0*HfxZpE*VS1(17,32)
VS0(29,51)=QCz*VS0(29,30)+WQz*VS1(29,30)&
   +2D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))&
   +HfxZpE*VS1(14,30)
VS0(29,52)=QCz*VS0(29,31)+WQz*VS1(29,31)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +HfxZpE*VS1(14,31)
VS0(29,53)=QCz*VS0(29,32)+WQz*VS1(29,32)&
   +2D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +HfxZpE*VS1(14,32)
VS0(29,54)=QCz*VS0(29,33)+WQz*VS1(29,33)&
   +3D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +HfxZpE*VS1(14,33)
VS0(29,55)=QCz*VS0(29,34)+WQz*VS1(29,34)&
   +3D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +HfxZpE*VS1(14,34)
VS0(29,56)=QCz*VS0(29,35)+WQz*VS1(29,35)&
   +4D0*r1x2E*(VS0(29,20)-ZxZpE*VS1(29,20))&
   +HfxZpE*VS1(14,35)
VS0(30,36)=QCx*VS0(30,21)+WQx*VS1(30,21)-r1x2E*VR1(30,21)&
   +4D0*r1x2E*(VS0(30,11)-ZxZpE*VS1(30,11))&
   +2D0*HfxZpE*VS1(18,21)
VS0(30,37)=QCx*VS0(30,22)+WQx*VS1(30,22)-r1x2E*VR1(30,22)&
   +3D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(18,22)
VS0(30,38)=QCx*VS0(30,23)+WQx*VS1(30,23)-r1x2E*VR1(30,23)&
   +2D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))&
   +2D0*HfxZpE*VS1(18,23)
VS0(30,39)=QCy*VS0(30,23)+WQy*VS1(30,23)&
   +2D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))
VS0(30,40)=QCy*VS0(30,24)+WQy*VS1(30,24)&
   +3D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))
VS0(30,41)=QCy*VS0(30,25)+WQy*VS1(30,25)&
   +4D0*r1x2E*(VS0(30,14)-ZxZpE*VS1(30,14))
VS0(30,42)=QCx*VS0(30,26)+WQx*VS1(30,26)-r1x2E*VR1(30,26)&
   +3D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(18,26)
VS0(30,43)=QCx*VS0(30,27)+WQx*VS1(30,27)-r1x2E*VR1(30,27)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(18,27)
VS0(30,44)=QCx*VS0(30,28)+WQx*VS1(30,28)-r1x2E*VR1(30,28)&
   +r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(18,28)
VS0(30,45)=QCy*VS0(30,28)+WQy*VS1(30,28)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))
VS0(30,46)=QCy*VS0(30,29)+WQy*VS1(30,29)&
   +3D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))
VS0(30,47)=QCx*VS0(30,30)+WQx*VS1(30,30)-r1x2E*VR1(30,30)&
   +2D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(18,30)
VS0(30,48)=QCx*VS0(30,31)+WQx*VS1(30,31)-r1x2E*VR1(30,31)&
   +r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(18,31)
VS0(30,49)=QCy*VS0(30,31)+WQy*VS1(30,31)&
   +r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))
VS0(30,50)=QCy*VS0(30,32)+WQy*VS1(30,32)&
   +2D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))
VS0(30,51)=QCz*VS0(30,30)+WQz*VS1(30,30)&
   +2D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(15,30)
VS0(30,52)=QCz*VS0(30,31)+WQz*VS1(30,31)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(15,31)
VS0(30,53)=QCz*VS0(30,32)+WQz*VS1(30,32)&
   +2D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(15,32)
VS0(30,54)=QCz*VS0(30,33)+WQz*VS1(30,33)&
   +3D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(15,33)
VS0(30,55)=QCz*VS0(30,34)+WQz*VS1(30,34)&
   +3D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(15,34)
VS0(30,56)=QCz*VS0(30,35)+WQz*VS1(30,35)&
   +4D0*r1x2E*(VS0(30,20)-ZxZpE*VS1(30,20))&
   +2D0*HfxZpE*VS1(15,35)
VS0(31,36)=QCx*VS0(31,21)+WQx*VS1(31,21)-r1x2E*VR1(31,21)&
   +4D0*r1x2E*(VS0(31,11)-ZxZpE*VS1(31,11))&
   +HfxZpE*VS1(19,21)
VS0(31,37)=QCx*VS0(31,22)+WQx*VS1(31,22)-r1x2E*VR1(31,22)&
   +3D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(19,22)
VS0(31,38)=QCx*VS0(31,23)+WQx*VS1(31,23)-r1x2E*VR1(31,23)&
   +2D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(19,23)
VS0(31,39)=QCy*VS0(31,23)+WQy*VS1(31,23)&
   +2D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(18,23)
VS0(31,40)=QCy*VS0(31,24)+WQy*VS1(31,24)&
   +3D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(18,24)
VS0(31,41)=QCy*VS0(31,25)+WQy*VS1(31,25)&
   +4D0*r1x2E*(VS0(31,14)-ZxZpE*VS1(31,14))&
   +HfxZpE*VS1(18,25)
VS0(31,42)=QCx*VS0(31,26)+WQx*VS1(31,26)-r1x2E*VR1(31,26)&
   +3D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +HfxZpE*VS1(19,26)
VS0(31,43)=QCx*VS0(31,27)+WQx*VS1(31,27)-r1x2E*VR1(31,27)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(19,27)
VS0(31,44)=QCx*VS0(31,28)+WQx*VS1(31,28)-r1x2E*VR1(31,28)&
   +r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(19,28)
VS0(31,45)=QCy*VS0(31,28)+WQy*VS1(31,28)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(18,28)
VS0(31,46)=QCy*VS0(31,29)+WQy*VS1(31,29)&
   +3D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(18,29)
VS0(31,47)=QCx*VS0(31,30)+WQx*VS1(31,30)-r1x2E*VR1(31,30)&
   +2D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(19,30)
VS0(31,48)=QCx*VS0(31,31)+WQx*VS1(31,31)-r1x2E*VR1(31,31)&
   +r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(19,31)
VS0(31,49)=QCy*VS0(31,31)+WQy*VS1(31,31)&
   +r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(18,31)
VS0(31,50)=QCy*VS0(31,32)+WQy*VS1(31,32)&
   +2D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(18,32)
VS0(31,51)=QCz*VS0(31,30)+WQz*VS1(31,30)&
   +2D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(16,30)
VS0(31,52)=QCz*VS0(31,31)+WQz*VS1(31,31)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +2D0*HfxZpE*VS1(16,31)
VS0(31,53)=QCz*VS0(31,32)+WQz*VS1(31,32)&
   +2D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(16,32)
VS0(31,54)=QCz*VS0(31,33)+WQz*VS1(31,33)&
   +3D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(16,33)
VS0(31,55)=QCz*VS0(31,34)+WQz*VS1(31,34)&
   +3D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(16,34)
VS0(31,56)=QCz*VS0(31,35)+WQz*VS1(31,35)&
   +4D0*r1x2E*(VS0(31,20)-ZxZpE*VS1(31,20))&
   +2D0*HfxZpE*VS1(16,35)
VS0(32,36)=QCx*VS0(32,21)+WQx*VS1(32,21)-r1x2E*VR1(32,21)&
   +4D0*r1x2E*(VS0(32,11)-ZxZpE*VS1(32,11))
VS0(32,37)=QCx*VS0(32,22)+WQx*VS1(32,22)-r1x2E*VR1(32,22)&
   +3D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))
VS0(32,38)=QCx*VS0(32,23)+WQx*VS1(32,23)-r1x2E*VR1(32,23)&
   +2D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))
VS0(32,39)=QCy*VS0(32,23)+WQy*VS1(32,23)&
   +2D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(19,23)
VS0(32,40)=QCy*VS0(32,24)+WQy*VS1(32,24)&
   +3D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(19,24)
VS0(32,41)=QCy*VS0(32,25)+WQy*VS1(32,25)&
   +4D0*r1x2E*(VS0(32,14)-ZxZpE*VS1(32,14))&
   +2D0*HfxZpE*VS1(19,25)
VS0(32,42)=QCx*VS0(32,26)+WQx*VS1(32,26)-r1x2E*VR1(32,26)&
   +3D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))
VS0(32,43)=QCx*VS0(32,27)+WQx*VS1(32,27)-r1x2E*VR1(32,27)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))
VS0(32,44)=QCx*VS0(32,28)+WQx*VS1(32,28)-r1x2E*VR1(32,28)&
   +r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))
VS0(32,45)=QCy*VS0(32,28)+WQy*VS1(32,28)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(19,28)
VS0(32,46)=QCy*VS0(32,29)+WQy*VS1(32,29)&
   +3D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(19,29)
VS0(32,47)=QCx*VS0(32,30)+WQx*VS1(32,30)-r1x2E*VR1(32,30)&
   +2D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))
VS0(32,48)=QCx*VS0(32,31)+WQx*VS1(32,31)-r1x2E*VR1(32,31)&
   +r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))
VS0(32,49)=QCy*VS0(32,31)+WQy*VS1(32,31)&
   +r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(19,31)
VS0(32,50)=QCy*VS0(32,32)+WQy*VS1(32,32)&
   +2D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(19,32)
VS0(32,51)=QCz*VS0(32,30)+WQz*VS1(32,30)&
   +2D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(17,30)
VS0(32,52)=QCz*VS0(32,31)+WQz*VS1(32,31)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(17,31)
VS0(32,53)=QCz*VS0(32,32)+WQz*VS1(32,32)&
   +2D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(17,32)
VS0(32,54)=QCz*VS0(32,33)+WQz*VS1(32,33)&
   +3D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(17,33)
VS0(32,55)=QCz*VS0(32,34)+WQz*VS1(32,34)&
   +3D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(17,34)
VS0(32,56)=QCz*VS0(32,35)+WQz*VS1(32,35)&
   +4D0*r1x2E*(VS0(32,20)-ZxZpE*VS1(32,20))&
   +2D0*HfxZpE*VS1(17,35)
VS0(33,36)=QCx*VS0(33,21)+WQx*VS1(33,21)-r1x2E*VR1(33,21)&
   +4D0*r1x2E*(VS0(33,11)-ZxZpE*VS1(33,11))&
   +HfxZpE*VS1(20,21)
VS0(33,37)=QCx*VS0(33,22)+WQx*VS1(33,22)-r1x2E*VR1(33,22)&
   +3D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))&
   +HfxZpE*VS1(20,22)
VS0(33,38)=QCx*VS0(33,23)+WQx*VS1(33,23)-r1x2E*VR1(33,23)&
   +2D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))&
   +HfxZpE*VS1(20,23)
VS0(33,39)=QCy*VS0(33,23)+WQy*VS1(33,23)&
   +2D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))
VS0(33,40)=QCy*VS0(33,24)+WQy*VS1(33,24)&
   +3D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))
VS0(33,41)=QCy*VS0(33,25)+WQy*VS1(33,25)&
   +4D0*r1x2E*(VS0(33,14)-ZxZpE*VS1(33,14))
VS0(33,42)=QCx*VS0(33,26)+WQx*VS1(33,26)-r1x2E*VR1(33,26)&
   +3D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +HfxZpE*VS1(20,26)
VS0(33,43)=QCx*VS0(33,27)+WQx*VS1(33,27)-r1x2E*VR1(33,27)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +HfxZpE*VS1(20,27)
VS0(33,44)=QCx*VS0(33,28)+WQx*VS1(33,28)-r1x2E*VR1(33,28)&
   +r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +HfxZpE*VS1(20,28)
VS0(33,45)=QCy*VS0(33,28)+WQy*VS1(33,28)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))
VS0(33,46)=QCy*VS0(33,29)+WQy*VS1(33,29)&
   +3D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))
VS0(33,47)=QCx*VS0(33,30)+WQx*VS1(33,30)-r1x2E*VR1(33,30)&
   +2D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +HfxZpE*VS1(20,30)
VS0(33,48)=QCx*VS0(33,31)+WQx*VS1(33,31)-r1x2E*VR1(33,31)&
   +r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +HfxZpE*VS1(20,31)
VS0(33,49)=QCy*VS0(33,31)+WQy*VS1(33,31)&
   +r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))
VS0(33,50)=QCy*VS0(33,32)+WQy*VS1(33,32)&
   +2D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))
VS0(33,51)=QCz*VS0(33,30)+WQz*VS1(33,30)&
   +2D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +3D0*HfxZpE*VS1(18,30)
VS0(33,52)=QCz*VS0(33,31)+WQz*VS1(33,31)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +3D0*HfxZpE*VS1(18,31)
VS0(33,53)=QCz*VS0(33,32)+WQz*VS1(33,32)&
   +2D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +3D0*HfxZpE*VS1(18,32)
VS0(33,54)=QCz*VS0(33,33)+WQz*VS1(33,33)&
   +3D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +3D0*HfxZpE*VS1(18,33)
VS0(33,55)=QCz*VS0(33,34)+WQz*VS1(33,34)&
   +3D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +3D0*HfxZpE*VS1(18,34)
VS0(33,56)=QCz*VS0(33,35)+WQz*VS1(33,35)&
   +4D0*r1x2E*(VS0(33,20)-ZxZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(18,35)
VS0(34,36)=QCx*VS0(34,21)+WQx*VS1(34,21)-r1x2E*VR1(34,21)&
   +4D0*r1x2E*(VS0(34,11)-ZxZpE*VS1(34,11))
VS0(34,37)=QCx*VS0(34,22)+WQx*VS1(34,22)-r1x2E*VR1(34,22)&
   +3D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))
VS0(34,38)=QCx*VS0(34,23)+WQx*VS1(34,23)-r1x2E*VR1(34,23)&
   +2D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))
VS0(34,39)=QCy*VS0(34,23)+WQy*VS1(34,23)&
   +2D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))&
   +HfxZpE*VS1(20,23)
VS0(34,40)=QCy*VS0(34,24)+WQy*VS1(34,24)&
   +3D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))&
   +HfxZpE*VS1(20,24)
VS0(34,41)=QCy*VS0(34,25)+WQy*VS1(34,25)&
   +4D0*r1x2E*(VS0(34,14)-ZxZpE*VS1(34,14))&
   +HfxZpE*VS1(20,25)
VS0(34,42)=QCx*VS0(34,26)+WQx*VS1(34,26)-r1x2E*VR1(34,26)&
   +3D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))
VS0(34,43)=QCx*VS0(34,27)+WQx*VS1(34,27)-r1x2E*VR1(34,27)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))
VS0(34,44)=QCx*VS0(34,28)+WQx*VS1(34,28)-r1x2E*VR1(34,28)&
   +r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))
VS0(34,45)=QCy*VS0(34,28)+WQy*VS1(34,28)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +HfxZpE*VS1(20,28)
VS0(34,46)=QCy*VS0(34,29)+WQy*VS1(34,29)&
   +3D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +HfxZpE*VS1(20,29)
VS0(34,47)=QCx*VS0(34,30)+WQx*VS1(34,30)-r1x2E*VR1(34,30)&
   +2D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))
VS0(34,48)=QCx*VS0(34,31)+WQx*VS1(34,31)-r1x2E*VR1(34,31)&
   +r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))
VS0(34,49)=QCy*VS0(34,31)+WQy*VS1(34,31)&
   +r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +HfxZpE*VS1(20,31)
VS0(34,50)=QCy*VS0(34,32)+WQy*VS1(34,32)&
   +2D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +HfxZpE*VS1(20,32)
VS0(34,51)=QCz*VS0(34,30)+WQz*VS1(34,30)&
   +2D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))&
   +3D0*HfxZpE*VS1(19,30)
VS0(34,52)=QCz*VS0(34,31)+WQz*VS1(34,31)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +3D0*HfxZpE*VS1(19,31)
VS0(34,53)=QCz*VS0(34,32)+WQz*VS1(34,32)&
   +2D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +3D0*HfxZpE*VS1(19,32)
VS0(34,54)=QCz*VS0(34,33)+WQz*VS1(34,33)&
   +3D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +3D0*HfxZpE*VS1(19,33)
VS0(34,55)=QCz*VS0(34,34)+WQz*VS1(34,34)&
   +3D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +3D0*HfxZpE*VS1(19,34)
VS0(34,56)=QCz*VS0(34,35)+WQz*VS1(34,35)&
   +4D0*r1x2E*(VS0(34,20)-ZxZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(19,35)
VS0(35,36)=QCx*VS0(35,21)+WQx*VS1(35,21)-r1x2E*VR1(35,21)&
   +4D0*r1x2E*(VS0(35,11)-ZxZpE*VS1(35,11))
VS0(35,37)=QCx*VS0(35,22)+WQx*VS1(35,22)-r1x2E*VR1(35,22)&
   +3D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,38)=QCx*VS0(35,23)+WQx*VS1(35,23)-r1x2E*VR1(35,23)&
   +2D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,39)=QCy*VS0(35,23)+WQy*VS1(35,23)&
   +2D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,40)=QCy*VS0(35,24)+WQy*VS1(35,24)&
   +3D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,41)=QCy*VS0(35,25)+WQy*VS1(35,25)&
   +4D0*r1x2E*(VS0(35,14)-ZxZpE*VS1(35,14))
VS0(35,42)=QCx*VS0(35,26)+WQx*VS1(35,26)-r1x2E*VR1(35,26)&
   +3D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))
VS0(35,43)=QCx*VS0(35,27)+WQx*VS1(35,27)-r1x2E*VR1(35,27)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,44)=QCx*VS0(35,28)+WQx*VS1(35,28)-r1x2E*VR1(35,28)&
   +r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,45)=QCy*VS0(35,28)+WQy*VS1(35,28)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,46)=QCy*VS0(35,29)+WQy*VS1(35,29)&
   +3D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,47)=QCx*VS0(35,30)+WQx*VS1(35,30)-r1x2E*VR1(35,30)&
   +2D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,48)=QCx*VS0(35,31)+WQx*VS1(35,31)-r1x2E*VR1(35,31)&
   +r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,49)=QCy*VS0(35,31)+WQy*VS1(35,31)&
   +r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,50)=QCy*VS0(35,32)+WQy*VS1(35,32)&
   +2D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,51)=QCz*VS0(35,30)+WQz*VS1(35,30)&
   +2D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))&
   +4D0*HfxZpE*VS1(20,30)
VS0(35,52)=QCz*VS0(35,31)+WQz*VS1(35,31)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))&
   +4D0*HfxZpE*VS1(20,31)
VS0(35,53)=QCz*VS0(35,32)+WQz*VS1(35,32)&
   +2D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))&
   +4D0*HfxZpE*VS1(20,32)
VS0(35,54)=QCz*VS0(35,33)+WQz*VS1(35,33)&
   +3D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))&
   +4D0*HfxZpE*VS1(20,33)
VS0(35,55)=QCz*VS0(35,34)+WQz*VS1(35,34)&
   +3D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))&
   +4D0*HfxZpE*VS1(20,34)
VS0(35,56)=QCz*VS0(35,35)+WQz*VS1(35,35)&
   +4D0*r1x2E*(VS0(35,20)-ZxZpE*VS1(35,20))&
   +4D0*HfxZpE*VS1(20,35)
CASE(2)
VS0(21,36)=QCx*VS0(21,21)+WQx*VS1(21,21)&
   +4D0*r1x2E*(VS0(21,11)-ZxZpE*VS1(21,11))&
   +4D0*HfxZpE*VS1(11,21)
VS0(21,37)=QCx*VS0(21,22)+WQx*VS1(21,22)&
   +3D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))&
   +4D0*HfxZpE*VS1(11,22)
VS0(21,38)=QCx*VS0(21,23)+WQx*VS1(21,23)&
   +2D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))&
   +4D0*HfxZpE*VS1(11,23)
VS0(21,39)=QCy*VS0(21,23)+WQy*VS1(21,23)-r1x2E*VR1(21,23)&
   +2D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))
VS0(21,40)=QCy*VS0(21,24)+WQy*VS1(21,24)-r1x2E*VR1(21,24)&
   +3D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))
VS0(21,41)=QCy*VS0(21,25)+WQy*VS1(21,25)-r1x2E*VR1(21,25)&
   +4D0*r1x2E*(VS0(21,14)-ZxZpE*VS1(21,14))
VS0(21,42)=QCx*VS0(21,26)+WQx*VS1(21,26)&
   +3D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))&
   +4D0*HfxZpE*VS1(11,26)
VS0(21,43)=QCx*VS0(21,27)+WQx*VS1(21,27)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))&
   +4D0*HfxZpE*VS1(11,27)
VS0(21,44)=QCx*VS0(21,28)+WQx*VS1(21,28)&
   +r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))&
   +4D0*HfxZpE*VS1(11,28)
VS0(21,45)=QCy*VS0(21,28)+WQy*VS1(21,28)-r1x2E*VR1(21,28)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,46)=QCy*VS0(21,29)+WQy*VS1(21,29)-r1x2E*VR1(21,29)&
   +3D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,47)=QCx*VS0(21,30)+WQx*VS1(21,30)&
   +2D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))&
   +4D0*HfxZpE*VS1(11,30)
VS0(21,48)=QCx*VS0(21,31)+WQx*VS1(21,31)&
   +r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))&
   +4D0*HfxZpE*VS1(11,31)
VS0(21,49)=QCy*VS0(21,31)+WQy*VS1(21,31)-r1x2E*VR1(21,31)&
   +r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,50)=QCy*VS0(21,32)+WQy*VS1(21,32)-r1x2E*VR1(21,32)&
   +2D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,51)=QCz*VS0(21,30)+WQz*VS1(21,30)&
   +2D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))
VS0(21,52)=QCz*VS0(21,31)+WQz*VS1(21,31)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,53)=QCz*VS0(21,32)+WQz*VS1(21,32)&
   +2D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,54)=QCz*VS0(21,33)+WQz*VS1(21,33)&
   +3D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,55)=QCz*VS0(21,34)+WQz*VS1(21,34)&
   +3D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,56)=QCz*VS0(21,35)+WQz*VS1(21,35)&
   +4D0*r1x2E*(VS0(21,20)-ZxZpE*VS1(21,20))
VS0(22,36)=QCx*VS0(22,21)+WQx*VS1(22,21)&
   +4D0*r1x2E*(VS0(22,11)-ZxZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(12,21)
VS0(22,37)=QCx*VS0(22,22)+WQx*VS1(22,22)&
   +3D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +3D0*HfxZpE*VS1(12,22)
VS0(22,38)=QCx*VS0(22,23)+WQx*VS1(22,23)&
   +2D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +3D0*HfxZpE*VS1(12,23)
VS0(22,39)=QCy*VS0(22,23)+WQy*VS1(22,23)-r1x2E*VR1(22,23)&
   +2D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +HfxZpE*VS1(11,23)
VS0(22,40)=QCy*VS0(22,24)+WQy*VS1(22,24)-r1x2E*VR1(22,24)&
   +3D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +HfxZpE*VS1(11,24)
VS0(22,41)=QCy*VS0(22,25)+WQy*VS1(22,25)-r1x2E*VR1(22,25)&
   +4D0*r1x2E*(VS0(22,14)-ZxZpE*VS1(22,14))&
   +HfxZpE*VS1(11,25)
VS0(22,42)=QCx*VS0(22,26)+WQx*VS1(22,26)&
   +3D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))&
   +3D0*HfxZpE*VS1(12,26)
VS0(22,43)=QCx*VS0(22,27)+WQx*VS1(22,27)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +3D0*HfxZpE*VS1(12,27)
VS0(22,44)=QCx*VS0(22,28)+WQx*VS1(22,28)&
   +r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +3D0*HfxZpE*VS1(12,28)
VS0(22,45)=QCy*VS0(22,28)+WQy*VS1(22,28)-r1x2E*VR1(22,28)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +HfxZpE*VS1(11,28)
VS0(22,46)=QCy*VS0(22,29)+WQy*VS1(22,29)-r1x2E*VR1(22,29)&
   +3D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +HfxZpE*VS1(11,29)
VS0(22,47)=QCx*VS0(22,30)+WQx*VS1(22,30)&
   +2D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +3D0*HfxZpE*VS1(12,30)
VS0(22,48)=QCx*VS0(22,31)+WQx*VS1(22,31)&
   +r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +3D0*HfxZpE*VS1(12,31)
VS0(22,49)=QCy*VS0(22,31)+WQy*VS1(22,31)-r1x2E*VR1(22,31)&
   +r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +HfxZpE*VS1(11,31)
VS0(22,50)=QCy*VS0(22,32)+WQy*VS1(22,32)-r1x2E*VR1(22,32)&
   +2D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +HfxZpE*VS1(11,32)
VS0(22,51)=QCz*VS0(22,30)+WQz*VS1(22,30)&
   +2D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))
VS0(22,52)=QCz*VS0(22,31)+WQz*VS1(22,31)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))
VS0(22,53)=QCz*VS0(22,32)+WQz*VS1(22,32)&
   +2D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))
VS0(22,54)=QCz*VS0(22,33)+WQz*VS1(22,33)&
   +3D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))
VS0(22,55)=QCz*VS0(22,34)+WQz*VS1(22,34)&
   +3D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))
VS0(22,56)=QCz*VS0(22,35)+WQz*VS1(22,35)&
   +4D0*r1x2E*(VS0(22,20)-ZxZpE*VS1(22,20))
VS0(23,36)=QCx*VS0(23,21)+WQx*VS1(23,21)&
   +4D0*r1x2E*(VS0(23,11)-ZxZpE*VS1(23,11))&
   +2D0*HfxZpE*VS1(13,21)
VS0(23,37)=QCx*VS0(23,22)+WQx*VS1(23,22)&
   +3D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(13,22)
VS0(23,38)=QCx*VS0(23,23)+WQx*VS1(23,23)&
   +2D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(13,23)
VS0(23,39)=QCy*VS0(23,23)+WQy*VS1(23,23)-r1x2E*VR1(23,23)&
   +2D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(12,23)
VS0(23,40)=QCy*VS0(23,24)+WQy*VS1(23,24)-r1x2E*VR1(23,24)&
   +3D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(12,24)
VS0(23,41)=QCy*VS0(23,25)+WQy*VS1(23,25)-r1x2E*VR1(23,25)&
   +4D0*r1x2E*(VS0(23,14)-ZxZpE*VS1(23,14))&
   +2D0*HfxZpE*VS1(12,25)
VS0(23,42)=QCx*VS0(23,26)+WQx*VS1(23,26)&
   +3D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(13,26)
VS0(23,43)=QCx*VS0(23,27)+WQx*VS1(23,27)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(13,27)
VS0(23,44)=QCx*VS0(23,28)+WQx*VS1(23,28)&
   +r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(13,28)
VS0(23,45)=QCy*VS0(23,28)+WQy*VS1(23,28)-r1x2E*VR1(23,28)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(12,28)
VS0(23,46)=QCy*VS0(23,29)+WQy*VS1(23,29)-r1x2E*VR1(23,29)&
   +3D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(12,29)
VS0(23,47)=QCx*VS0(23,30)+WQx*VS1(23,30)&
   +2D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(13,30)
VS0(23,48)=QCx*VS0(23,31)+WQx*VS1(23,31)&
   +r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(13,31)
VS0(23,49)=QCy*VS0(23,31)+WQy*VS1(23,31)-r1x2E*VR1(23,31)&
   +r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(12,31)
VS0(23,50)=QCy*VS0(23,32)+WQy*VS1(23,32)-r1x2E*VR1(23,32)&
   +2D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(12,32)
VS0(23,51)=QCz*VS0(23,30)+WQz*VS1(23,30)&
   +2D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))
VS0(23,52)=QCz*VS0(23,31)+WQz*VS1(23,31)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))
VS0(23,53)=QCz*VS0(23,32)+WQz*VS1(23,32)&
   +2D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))
VS0(23,54)=QCz*VS0(23,33)+WQz*VS1(23,33)&
   +3D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))
VS0(23,55)=QCz*VS0(23,34)+WQz*VS1(23,34)&
   +3D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))
VS0(23,56)=QCz*VS0(23,35)+WQz*VS1(23,35)&
   +4D0*r1x2E*(VS0(23,20)-ZxZpE*VS1(23,20))
VS0(24,36)=QCx*VS0(24,21)+WQx*VS1(24,21)&
   +4D0*r1x2E*(VS0(24,11)-ZxZpE*VS1(24,11))&
   +HfxZpE*VS1(14,21)
VS0(24,37)=QCx*VS0(24,22)+WQx*VS1(24,22)&
   +3D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +HfxZpE*VS1(14,22)
VS0(24,38)=QCx*VS0(24,23)+WQx*VS1(24,23)&
   +2D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +HfxZpE*VS1(14,23)
VS0(24,39)=QCy*VS0(24,23)+WQy*VS1(24,23)-r1x2E*VR1(24,23)&
   +2D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +3D0*HfxZpE*VS1(13,23)
VS0(24,40)=QCy*VS0(24,24)+WQy*VS1(24,24)-r1x2E*VR1(24,24)&
   +3D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +3D0*HfxZpE*VS1(13,24)
VS0(24,41)=QCy*VS0(24,25)+WQy*VS1(24,25)-r1x2E*VR1(24,25)&
   +4D0*r1x2E*(VS0(24,14)-ZxZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(13,25)
VS0(24,42)=QCx*VS0(24,26)+WQx*VS1(24,26)&
   +3D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))&
   +HfxZpE*VS1(14,26)
VS0(24,43)=QCx*VS0(24,27)+WQx*VS1(24,27)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +HfxZpE*VS1(14,27)
VS0(24,44)=QCx*VS0(24,28)+WQx*VS1(24,28)&
   +r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +HfxZpE*VS1(14,28)
VS0(24,45)=QCy*VS0(24,28)+WQy*VS1(24,28)-r1x2E*VR1(24,28)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +3D0*HfxZpE*VS1(13,28)
VS0(24,46)=QCy*VS0(24,29)+WQy*VS1(24,29)-r1x2E*VR1(24,29)&
   +3D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +3D0*HfxZpE*VS1(13,29)
VS0(24,47)=QCx*VS0(24,30)+WQx*VS1(24,30)&
   +2D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +HfxZpE*VS1(14,30)
VS0(24,48)=QCx*VS0(24,31)+WQx*VS1(24,31)&
   +r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +HfxZpE*VS1(14,31)
VS0(24,49)=QCy*VS0(24,31)+WQy*VS1(24,31)-r1x2E*VR1(24,31)&
   +r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +3D0*HfxZpE*VS1(13,31)
VS0(24,50)=QCy*VS0(24,32)+WQy*VS1(24,32)-r1x2E*VR1(24,32)&
   +2D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +3D0*HfxZpE*VS1(13,32)
VS0(24,51)=QCz*VS0(24,30)+WQz*VS1(24,30)&
   +2D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))
VS0(24,52)=QCz*VS0(24,31)+WQz*VS1(24,31)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))
VS0(24,53)=QCz*VS0(24,32)+WQz*VS1(24,32)&
   +2D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))
VS0(24,54)=QCz*VS0(24,33)+WQz*VS1(24,33)&
   +3D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))
VS0(24,55)=QCz*VS0(24,34)+WQz*VS1(24,34)&
   +3D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))
VS0(24,56)=QCz*VS0(24,35)+WQz*VS1(24,35)&
   +4D0*r1x2E*(VS0(24,20)-ZxZpE*VS1(24,20))
VS0(25,36)=QCx*VS0(25,21)+WQx*VS1(25,21)&
   +4D0*r1x2E*(VS0(25,11)-ZxZpE*VS1(25,11))
VS0(25,37)=QCx*VS0(25,22)+WQx*VS1(25,22)&
   +3D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))
VS0(25,38)=QCx*VS0(25,23)+WQx*VS1(25,23)&
   +2D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))
VS0(25,39)=QCy*VS0(25,23)+WQy*VS1(25,23)-r1x2E*VR1(25,23)&
   +2D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))&
   +4D0*HfxZpE*VS1(14,23)
VS0(25,40)=QCy*VS0(25,24)+WQy*VS1(25,24)-r1x2E*VR1(25,24)&
   +3D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))&
   +4D0*HfxZpE*VS1(14,24)
VS0(25,41)=QCy*VS0(25,25)+WQy*VS1(25,25)-r1x2E*VR1(25,25)&
   +4D0*r1x2E*(VS0(25,14)-ZxZpE*VS1(25,14))&
   +4D0*HfxZpE*VS1(14,25)
VS0(25,42)=QCx*VS0(25,26)+WQx*VS1(25,26)&
   +3D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,43)=QCx*VS0(25,27)+WQx*VS1(25,27)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,44)=QCx*VS0(25,28)+WQx*VS1(25,28)&
   +r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,45)=QCy*VS0(25,28)+WQy*VS1(25,28)-r1x2E*VR1(25,28)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))&
   +4D0*HfxZpE*VS1(14,28)
VS0(25,46)=QCy*VS0(25,29)+WQy*VS1(25,29)-r1x2E*VR1(25,29)&
   +3D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))&
   +4D0*HfxZpE*VS1(14,29)
VS0(25,47)=QCx*VS0(25,30)+WQx*VS1(25,30)&
   +2D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,48)=QCx*VS0(25,31)+WQx*VS1(25,31)&
   +r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,49)=QCy*VS0(25,31)+WQy*VS1(25,31)-r1x2E*VR1(25,31)&
   +r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))&
   +4D0*HfxZpE*VS1(14,31)
VS0(25,50)=QCy*VS0(25,32)+WQy*VS1(25,32)-r1x2E*VR1(25,32)&
   +2D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))&
   +4D0*HfxZpE*VS1(14,32)
VS0(25,51)=QCz*VS0(25,30)+WQz*VS1(25,30)&
   +2D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,52)=QCz*VS0(25,31)+WQz*VS1(25,31)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,53)=QCz*VS0(25,32)+WQz*VS1(25,32)&
   +2D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,54)=QCz*VS0(25,33)+WQz*VS1(25,33)&
   +3D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,55)=QCz*VS0(25,34)+WQz*VS1(25,34)&
   +3D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,56)=QCz*VS0(25,35)+WQz*VS1(25,35)&
   +4D0*r1x2E*(VS0(25,20)-ZxZpE*VS1(25,20))
VS0(26,36)=QCx*VS0(26,21)+WQx*VS1(26,21)&
   +4D0*r1x2E*(VS0(26,11)-ZxZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(15,21)
VS0(26,37)=QCx*VS0(26,22)+WQx*VS1(26,22)&
   +3D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))&
   +3D0*HfxZpE*VS1(15,22)
VS0(26,38)=QCx*VS0(26,23)+WQx*VS1(26,23)&
   +2D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))&
   +3D0*HfxZpE*VS1(15,23)
VS0(26,39)=QCy*VS0(26,23)+WQy*VS1(26,23)-r1x2E*VR1(26,23)&
   +2D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))
VS0(26,40)=QCy*VS0(26,24)+WQy*VS1(26,24)-r1x2E*VR1(26,24)&
   +3D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))
VS0(26,41)=QCy*VS0(26,25)+WQy*VS1(26,25)-r1x2E*VR1(26,25)&
   +4D0*r1x2E*(VS0(26,14)-ZxZpE*VS1(26,14))
VS0(26,42)=QCx*VS0(26,26)+WQx*VS1(26,26)&
   +3D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +3D0*HfxZpE*VS1(15,26)
VS0(26,43)=QCx*VS0(26,27)+WQx*VS1(26,27)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +3D0*HfxZpE*VS1(15,27)
VS0(26,44)=QCx*VS0(26,28)+WQx*VS1(26,28)&
   +r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +3D0*HfxZpE*VS1(15,28)
VS0(26,45)=QCy*VS0(26,28)+WQy*VS1(26,28)-r1x2E*VR1(26,28)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))
VS0(26,46)=QCy*VS0(26,29)+WQy*VS1(26,29)-r1x2E*VR1(26,29)&
   +3D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))
VS0(26,47)=QCx*VS0(26,30)+WQx*VS1(26,30)&
   +2D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +3D0*HfxZpE*VS1(15,30)
VS0(26,48)=QCx*VS0(26,31)+WQx*VS1(26,31)&
   +r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +3D0*HfxZpE*VS1(15,31)
VS0(26,49)=QCy*VS0(26,31)+WQy*VS1(26,31)-r1x2E*VR1(26,31)&
   +r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))
VS0(26,50)=QCy*VS0(26,32)+WQy*VS1(26,32)-r1x2E*VR1(26,32)&
   +2D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))
VS0(26,51)=QCz*VS0(26,30)+WQz*VS1(26,30)&
   +2D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +HfxZpE*VS1(11,30)
VS0(26,52)=QCz*VS0(26,31)+WQz*VS1(26,31)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +HfxZpE*VS1(11,31)
VS0(26,53)=QCz*VS0(26,32)+WQz*VS1(26,32)&
   +2D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +HfxZpE*VS1(11,32)
VS0(26,54)=QCz*VS0(26,33)+WQz*VS1(26,33)&
   +3D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +HfxZpE*VS1(11,33)
VS0(26,55)=QCz*VS0(26,34)+WQz*VS1(26,34)&
   +3D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +HfxZpE*VS1(11,34)
VS0(26,56)=QCz*VS0(26,35)+WQz*VS1(26,35)&
   +4D0*r1x2E*(VS0(26,20)-ZxZpE*VS1(26,20))&
   +HfxZpE*VS1(11,35)
VS0(27,36)=QCx*VS0(27,21)+WQx*VS1(27,21)&
   +4D0*r1x2E*(VS0(27,11)-ZxZpE*VS1(27,11))&
   +2D0*HfxZpE*VS1(16,21)
VS0(27,37)=QCx*VS0(27,22)+WQx*VS1(27,22)&
   +3D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(16,22)
VS0(27,38)=QCx*VS0(27,23)+WQx*VS1(27,23)&
   +2D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(16,23)
VS0(27,39)=QCy*VS0(27,23)+WQy*VS1(27,23)-r1x2E*VR1(27,23)&
   +2D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +HfxZpE*VS1(15,23)
VS0(27,40)=QCy*VS0(27,24)+WQy*VS1(27,24)-r1x2E*VR1(27,24)&
   +3D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +HfxZpE*VS1(15,24)
VS0(27,41)=QCy*VS0(27,25)+WQy*VS1(27,25)-r1x2E*VR1(27,25)&
   +4D0*r1x2E*(VS0(27,14)-ZxZpE*VS1(27,14))&
   +HfxZpE*VS1(15,25)
VS0(27,42)=QCx*VS0(27,26)+WQx*VS1(27,26)&
   +3D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(16,26)
VS0(27,43)=QCx*VS0(27,27)+WQx*VS1(27,27)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +2D0*HfxZpE*VS1(16,27)
VS0(27,44)=QCx*VS0(27,28)+WQx*VS1(27,28)&
   +r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(16,28)
VS0(27,45)=QCy*VS0(27,28)+WQy*VS1(27,28)-r1x2E*VR1(27,28)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(15,28)
VS0(27,46)=QCy*VS0(27,29)+WQy*VS1(27,29)-r1x2E*VR1(27,29)&
   +3D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(15,29)
VS0(27,47)=QCx*VS0(27,30)+WQx*VS1(27,30)&
   +2D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(16,30)
VS0(27,48)=QCx*VS0(27,31)+WQx*VS1(27,31)&
   +r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(16,31)
VS0(27,49)=QCy*VS0(27,31)+WQy*VS1(27,31)-r1x2E*VR1(27,31)&
   +r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(15,31)
VS0(27,50)=QCy*VS0(27,32)+WQy*VS1(27,32)-r1x2E*VR1(27,32)&
   +2D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(15,32)
VS0(27,51)=QCz*VS0(27,30)+WQz*VS1(27,30)&
   +2D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +HfxZpE*VS1(12,30)
VS0(27,52)=QCz*VS0(27,31)+WQz*VS1(27,31)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(12,31)
VS0(27,53)=QCz*VS0(27,32)+WQz*VS1(27,32)&
   +2D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(12,32)
VS0(27,54)=QCz*VS0(27,33)+WQz*VS1(27,33)&
   +3D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(12,33)
VS0(27,55)=QCz*VS0(27,34)+WQz*VS1(27,34)&
   +3D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(12,34)
VS0(27,56)=QCz*VS0(27,35)+WQz*VS1(27,35)&
   +4D0*r1x2E*(VS0(27,20)-ZxZpE*VS1(27,20))&
   +HfxZpE*VS1(12,35)
VS0(28,36)=QCx*VS0(28,21)+WQx*VS1(28,21)&
   +4D0*r1x2E*(VS0(28,11)-ZxZpE*VS1(28,11))&
   +HfxZpE*VS1(17,21)
VS0(28,37)=QCx*VS0(28,22)+WQx*VS1(28,22)&
   +3D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +HfxZpE*VS1(17,22)
VS0(28,38)=QCx*VS0(28,23)+WQx*VS1(28,23)&
   +2D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +HfxZpE*VS1(17,23)
VS0(28,39)=QCy*VS0(28,23)+WQy*VS1(28,23)-r1x2E*VR1(28,23)&
   +2D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(16,23)
VS0(28,40)=QCy*VS0(28,24)+WQy*VS1(28,24)-r1x2E*VR1(28,24)&
   +3D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(16,24)
VS0(28,41)=QCy*VS0(28,25)+WQy*VS1(28,25)-r1x2E*VR1(28,25)&
   +4D0*r1x2E*(VS0(28,14)-ZxZpE*VS1(28,14))&
   +2D0*HfxZpE*VS1(16,25)
VS0(28,42)=QCx*VS0(28,26)+WQx*VS1(28,26)&
   +3D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(17,26)
VS0(28,43)=QCx*VS0(28,27)+WQx*VS1(28,27)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(17,27)
VS0(28,44)=QCx*VS0(28,28)+WQx*VS1(28,28)&
   +r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(17,28)
VS0(28,45)=QCy*VS0(28,28)+WQy*VS1(28,28)-r1x2E*VR1(28,28)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +2D0*HfxZpE*VS1(16,28)
VS0(28,46)=QCy*VS0(28,29)+WQy*VS1(28,29)-r1x2E*VR1(28,29)&
   +3D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(16,29)
VS0(28,47)=QCx*VS0(28,30)+WQx*VS1(28,30)&
   +2D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(17,30)
VS0(28,48)=QCx*VS0(28,31)+WQx*VS1(28,31)&
   +r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(17,31)
VS0(28,49)=QCy*VS0(28,31)+WQy*VS1(28,31)-r1x2E*VR1(28,31)&
   +r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(16,31)
VS0(28,50)=QCy*VS0(28,32)+WQy*VS1(28,32)-r1x2E*VR1(28,32)&
   +2D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(16,32)
VS0(28,51)=QCz*VS0(28,30)+WQz*VS1(28,30)&
   +2D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(13,30)
VS0(28,52)=QCz*VS0(28,31)+WQz*VS1(28,31)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(13,31)
VS0(28,53)=QCz*VS0(28,32)+WQz*VS1(28,32)&
   +2D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(13,32)
VS0(28,54)=QCz*VS0(28,33)+WQz*VS1(28,33)&
   +3D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(13,33)
VS0(28,55)=QCz*VS0(28,34)+WQz*VS1(28,34)&
   +3D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(13,34)
VS0(28,56)=QCz*VS0(28,35)+WQz*VS1(28,35)&
   +4D0*r1x2E*(VS0(28,20)-ZxZpE*VS1(28,20))&
   +HfxZpE*VS1(13,35)
VS0(29,36)=QCx*VS0(29,21)+WQx*VS1(29,21)&
   +4D0*r1x2E*(VS0(29,11)-ZxZpE*VS1(29,11))
VS0(29,37)=QCx*VS0(29,22)+WQx*VS1(29,22)&
   +3D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))
VS0(29,38)=QCx*VS0(29,23)+WQx*VS1(29,23)&
   +2D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))
VS0(29,39)=QCy*VS0(29,23)+WQy*VS1(29,23)-r1x2E*VR1(29,23)&
   +2D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))&
   +3D0*HfxZpE*VS1(17,23)
VS0(29,40)=QCy*VS0(29,24)+WQy*VS1(29,24)-r1x2E*VR1(29,24)&
   +3D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))&
   +3D0*HfxZpE*VS1(17,24)
VS0(29,41)=QCy*VS0(29,25)+WQy*VS1(29,25)-r1x2E*VR1(29,25)&
   +4D0*r1x2E*(VS0(29,14)-ZxZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(17,25)
VS0(29,42)=QCx*VS0(29,26)+WQx*VS1(29,26)&
   +3D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))
VS0(29,43)=QCx*VS0(29,27)+WQx*VS1(29,27)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))
VS0(29,44)=QCx*VS0(29,28)+WQx*VS1(29,28)&
   +r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))
VS0(29,45)=QCy*VS0(29,28)+WQy*VS1(29,28)-r1x2E*VR1(29,28)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +3D0*HfxZpE*VS1(17,28)
VS0(29,46)=QCy*VS0(29,29)+WQy*VS1(29,29)-r1x2E*VR1(29,29)&
   +3D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +3D0*HfxZpE*VS1(17,29)
VS0(29,47)=QCx*VS0(29,30)+WQx*VS1(29,30)&
   +2D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))
VS0(29,48)=QCx*VS0(29,31)+WQx*VS1(29,31)&
   +r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))
VS0(29,49)=QCy*VS0(29,31)+WQy*VS1(29,31)-r1x2E*VR1(29,31)&
   +r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +3D0*HfxZpE*VS1(17,31)
VS0(29,50)=QCy*VS0(29,32)+WQy*VS1(29,32)-r1x2E*VR1(29,32)&
   +2D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +3D0*HfxZpE*VS1(17,32)
VS0(29,51)=QCz*VS0(29,30)+WQz*VS1(29,30)&
   +2D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))&
   +HfxZpE*VS1(14,30)
VS0(29,52)=QCz*VS0(29,31)+WQz*VS1(29,31)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +HfxZpE*VS1(14,31)
VS0(29,53)=QCz*VS0(29,32)+WQz*VS1(29,32)&
   +2D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +HfxZpE*VS1(14,32)
VS0(29,54)=QCz*VS0(29,33)+WQz*VS1(29,33)&
   +3D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +HfxZpE*VS1(14,33)
VS0(29,55)=QCz*VS0(29,34)+WQz*VS1(29,34)&
   +3D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +HfxZpE*VS1(14,34)
VS0(29,56)=QCz*VS0(29,35)+WQz*VS1(29,35)&
   +4D0*r1x2E*(VS0(29,20)-ZxZpE*VS1(29,20))&
   +HfxZpE*VS1(14,35)
VS0(30,36)=QCx*VS0(30,21)+WQx*VS1(30,21)&
   +4D0*r1x2E*(VS0(30,11)-ZxZpE*VS1(30,11))&
   +2D0*HfxZpE*VS1(18,21)
VS0(30,37)=QCx*VS0(30,22)+WQx*VS1(30,22)&
   +3D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(18,22)
VS0(30,38)=QCx*VS0(30,23)+WQx*VS1(30,23)&
   +2D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))&
   +2D0*HfxZpE*VS1(18,23)
VS0(30,39)=QCy*VS0(30,23)+WQy*VS1(30,23)-r1x2E*VR1(30,23)&
   +2D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))
VS0(30,40)=QCy*VS0(30,24)+WQy*VS1(30,24)-r1x2E*VR1(30,24)&
   +3D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))
VS0(30,41)=QCy*VS0(30,25)+WQy*VS1(30,25)-r1x2E*VR1(30,25)&
   +4D0*r1x2E*(VS0(30,14)-ZxZpE*VS1(30,14))
VS0(30,42)=QCx*VS0(30,26)+WQx*VS1(30,26)&
   +3D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(18,26)
VS0(30,43)=QCx*VS0(30,27)+WQx*VS1(30,27)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(18,27)
VS0(30,44)=QCx*VS0(30,28)+WQx*VS1(30,28)&
   +r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(18,28)
VS0(30,45)=QCy*VS0(30,28)+WQy*VS1(30,28)-r1x2E*VR1(30,28)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))
VS0(30,46)=QCy*VS0(30,29)+WQy*VS1(30,29)-r1x2E*VR1(30,29)&
   +3D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))
VS0(30,47)=QCx*VS0(30,30)+WQx*VS1(30,30)&
   +2D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(18,30)
VS0(30,48)=QCx*VS0(30,31)+WQx*VS1(30,31)&
   +r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(18,31)
VS0(30,49)=QCy*VS0(30,31)+WQy*VS1(30,31)-r1x2E*VR1(30,31)&
   +r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))
VS0(30,50)=QCy*VS0(30,32)+WQy*VS1(30,32)-r1x2E*VR1(30,32)&
   +2D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))
VS0(30,51)=QCz*VS0(30,30)+WQz*VS1(30,30)&
   +2D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(15,30)
VS0(30,52)=QCz*VS0(30,31)+WQz*VS1(30,31)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(15,31)
VS0(30,53)=QCz*VS0(30,32)+WQz*VS1(30,32)&
   +2D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(15,32)
VS0(30,54)=QCz*VS0(30,33)+WQz*VS1(30,33)&
   +3D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(15,33)
VS0(30,55)=QCz*VS0(30,34)+WQz*VS1(30,34)&
   +3D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(15,34)
VS0(30,56)=QCz*VS0(30,35)+WQz*VS1(30,35)&
   +4D0*r1x2E*(VS0(30,20)-ZxZpE*VS1(30,20))&
   +2D0*HfxZpE*VS1(15,35)
VS0(31,36)=QCx*VS0(31,21)+WQx*VS1(31,21)&
   +4D0*r1x2E*(VS0(31,11)-ZxZpE*VS1(31,11))&
   +HfxZpE*VS1(19,21)
VS0(31,37)=QCx*VS0(31,22)+WQx*VS1(31,22)&
   +3D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(19,22)
VS0(31,38)=QCx*VS0(31,23)+WQx*VS1(31,23)&
   +2D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(19,23)
VS0(31,39)=QCy*VS0(31,23)+WQy*VS1(31,23)-r1x2E*VR1(31,23)&
   +2D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(18,23)
VS0(31,40)=QCy*VS0(31,24)+WQy*VS1(31,24)-r1x2E*VR1(31,24)&
   +3D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(18,24)
VS0(31,41)=QCy*VS0(31,25)+WQy*VS1(31,25)-r1x2E*VR1(31,25)&
   +4D0*r1x2E*(VS0(31,14)-ZxZpE*VS1(31,14))&
   +HfxZpE*VS1(18,25)
VS0(31,42)=QCx*VS0(31,26)+WQx*VS1(31,26)&
   +3D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +HfxZpE*VS1(19,26)
VS0(31,43)=QCx*VS0(31,27)+WQx*VS1(31,27)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(19,27)
VS0(31,44)=QCx*VS0(31,28)+WQx*VS1(31,28)&
   +r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(19,28)
VS0(31,45)=QCy*VS0(31,28)+WQy*VS1(31,28)-r1x2E*VR1(31,28)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(18,28)
VS0(31,46)=QCy*VS0(31,29)+WQy*VS1(31,29)-r1x2E*VR1(31,29)&
   +3D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(18,29)
VS0(31,47)=QCx*VS0(31,30)+WQx*VS1(31,30)&
   +2D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(19,30)
VS0(31,48)=QCx*VS0(31,31)+WQx*VS1(31,31)&
   +r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(19,31)
VS0(31,49)=QCy*VS0(31,31)+WQy*VS1(31,31)-r1x2E*VR1(31,31)&
   +r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(18,31)
VS0(31,50)=QCy*VS0(31,32)+WQy*VS1(31,32)-r1x2E*VR1(31,32)&
   +2D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(18,32)
VS0(31,51)=QCz*VS0(31,30)+WQz*VS1(31,30)&
   +2D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(16,30)
VS0(31,52)=QCz*VS0(31,31)+WQz*VS1(31,31)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +2D0*HfxZpE*VS1(16,31)
VS0(31,53)=QCz*VS0(31,32)+WQz*VS1(31,32)&
   +2D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(16,32)
VS0(31,54)=QCz*VS0(31,33)+WQz*VS1(31,33)&
   +3D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(16,33)
VS0(31,55)=QCz*VS0(31,34)+WQz*VS1(31,34)&
   +3D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(16,34)
VS0(31,56)=QCz*VS0(31,35)+WQz*VS1(31,35)&
   +4D0*r1x2E*(VS0(31,20)-ZxZpE*VS1(31,20))&
   +2D0*HfxZpE*VS1(16,35)
VS0(32,36)=QCx*VS0(32,21)+WQx*VS1(32,21)&
   +4D0*r1x2E*(VS0(32,11)-ZxZpE*VS1(32,11))
VS0(32,37)=QCx*VS0(32,22)+WQx*VS1(32,22)&
   +3D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))
VS0(32,38)=QCx*VS0(32,23)+WQx*VS1(32,23)&
   +2D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))
VS0(32,39)=QCy*VS0(32,23)+WQy*VS1(32,23)-r1x2E*VR1(32,23)&
   +2D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(19,23)
VS0(32,40)=QCy*VS0(32,24)+WQy*VS1(32,24)-r1x2E*VR1(32,24)&
   +3D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(19,24)
VS0(32,41)=QCy*VS0(32,25)+WQy*VS1(32,25)-r1x2E*VR1(32,25)&
   +4D0*r1x2E*(VS0(32,14)-ZxZpE*VS1(32,14))&
   +2D0*HfxZpE*VS1(19,25)
VS0(32,42)=QCx*VS0(32,26)+WQx*VS1(32,26)&
   +3D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))
VS0(32,43)=QCx*VS0(32,27)+WQx*VS1(32,27)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))
VS0(32,44)=QCx*VS0(32,28)+WQx*VS1(32,28)&
   +r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))
VS0(32,45)=QCy*VS0(32,28)+WQy*VS1(32,28)-r1x2E*VR1(32,28)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(19,28)
VS0(32,46)=QCy*VS0(32,29)+WQy*VS1(32,29)-r1x2E*VR1(32,29)&
   +3D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(19,29)
VS0(32,47)=QCx*VS0(32,30)+WQx*VS1(32,30)&
   +2D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))
VS0(32,48)=QCx*VS0(32,31)+WQx*VS1(32,31)&
   +r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))
VS0(32,49)=QCy*VS0(32,31)+WQy*VS1(32,31)-r1x2E*VR1(32,31)&
   +r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(19,31)
VS0(32,50)=QCy*VS0(32,32)+WQy*VS1(32,32)-r1x2E*VR1(32,32)&
   +2D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(19,32)
VS0(32,51)=QCz*VS0(32,30)+WQz*VS1(32,30)&
   +2D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(17,30)
VS0(32,52)=QCz*VS0(32,31)+WQz*VS1(32,31)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(17,31)
VS0(32,53)=QCz*VS0(32,32)+WQz*VS1(32,32)&
   +2D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(17,32)
VS0(32,54)=QCz*VS0(32,33)+WQz*VS1(32,33)&
   +3D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(17,33)
VS0(32,55)=QCz*VS0(32,34)+WQz*VS1(32,34)&
   +3D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(17,34)
VS0(32,56)=QCz*VS0(32,35)+WQz*VS1(32,35)&
   +4D0*r1x2E*(VS0(32,20)-ZxZpE*VS1(32,20))&
   +2D0*HfxZpE*VS1(17,35)
VS0(33,36)=QCx*VS0(33,21)+WQx*VS1(33,21)&
   +4D0*r1x2E*(VS0(33,11)-ZxZpE*VS1(33,11))&
   +HfxZpE*VS1(20,21)
VS0(33,37)=QCx*VS0(33,22)+WQx*VS1(33,22)&
   +3D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))&
   +HfxZpE*VS1(20,22)
VS0(33,38)=QCx*VS0(33,23)+WQx*VS1(33,23)&
   +2D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))&
   +HfxZpE*VS1(20,23)
VS0(33,39)=QCy*VS0(33,23)+WQy*VS1(33,23)-r1x2E*VR1(33,23)&
   +2D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))
VS0(33,40)=QCy*VS0(33,24)+WQy*VS1(33,24)-r1x2E*VR1(33,24)&
   +3D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))
VS0(33,41)=QCy*VS0(33,25)+WQy*VS1(33,25)-r1x2E*VR1(33,25)&
   +4D0*r1x2E*(VS0(33,14)-ZxZpE*VS1(33,14))
VS0(33,42)=QCx*VS0(33,26)+WQx*VS1(33,26)&
   +3D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +HfxZpE*VS1(20,26)
VS0(33,43)=QCx*VS0(33,27)+WQx*VS1(33,27)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +HfxZpE*VS1(20,27)
VS0(33,44)=QCx*VS0(33,28)+WQx*VS1(33,28)&
   +r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +HfxZpE*VS1(20,28)
VS0(33,45)=QCy*VS0(33,28)+WQy*VS1(33,28)-r1x2E*VR1(33,28)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))
VS0(33,46)=QCy*VS0(33,29)+WQy*VS1(33,29)-r1x2E*VR1(33,29)&
   +3D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))
VS0(33,47)=QCx*VS0(33,30)+WQx*VS1(33,30)&
   +2D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +HfxZpE*VS1(20,30)
VS0(33,48)=QCx*VS0(33,31)+WQx*VS1(33,31)&
   +r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +HfxZpE*VS1(20,31)
VS0(33,49)=QCy*VS0(33,31)+WQy*VS1(33,31)-r1x2E*VR1(33,31)&
   +r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))
VS0(33,50)=QCy*VS0(33,32)+WQy*VS1(33,32)-r1x2E*VR1(33,32)&
   +2D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))
VS0(33,51)=QCz*VS0(33,30)+WQz*VS1(33,30)&
   +2D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +3D0*HfxZpE*VS1(18,30)
VS0(33,52)=QCz*VS0(33,31)+WQz*VS1(33,31)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +3D0*HfxZpE*VS1(18,31)
VS0(33,53)=QCz*VS0(33,32)+WQz*VS1(33,32)&
   +2D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +3D0*HfxZpE*VS1(18,32)
VS0(33,54)=QCz*VS0(33,33)+WQz*VS1(33,33)&
   +3D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +3D0*HfxZpE*VS1(18,33)
VS0(33,55)=QCz*VS0(33,34)+WQz*VS1(33,34)&
   +3D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +3D0*HfxZpE*VS1(18,34)
VS0(33,56)=QCz*VS0(33,35)+WQz*VS1(33,35)&
   +4D0*r1x2E*(VS0(33,20)-ZxZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(18,35)
VS0(34,36)=QCx*VS0(34,21)+WQx*VS1(34,21)&
   +4D0*r1x2E*(VS0(34,11)-ZxZpE*VS1(34,11))
VS0(34,37)=QCx*VS0(34,22)+WQx*VS1(34,22)&
   +3D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))
VS0(34,38)=QCx*VS0(34,23)+WQx*VS1(34,23)&
   +2D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))
VS0(34,39)=QCy*VS0(34,23)+WQy*VS1(34,23)-r1x2E*VR1(34,23)&
   +2D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))&
   +HfxZpE*VS1(20,23)
VS0(34,40)=QCy*VS0(34,24)+WQy*VS1(34,24)-r1x2E*VR1(34,24)&
   +3D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))&
   +HfxZpE*VS1(20,24)
VS0(34,41)=QCy*VS0(34,25)+WQy*VS1(34,25)-r1x2E*VR1(34,25)&
   +4D0*r1x2E*(VS0(34,14)-ZxZpE*VS1(34,14))&
   +HfxZpE*VS1(20,25)
VS0(34,42)=QCx*VS0(34,26)+WQx*VS1(34,26)&
   +3D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))
VS0(34,43)=QCx*VS0(34,27)+WQx*VS1(34,27)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))
VS0(34,44)=QCx*VS0(34,28)+WQx*VS1(34,28)&
   +r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))
VS0(34,45)=QCy*VS0(34,28)+WQy*VS1(34,28)-r1x2E*VR1(34,28)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +HfxZpE*VS1(20,28)
VS0(34,46)=QCy*VS0(34,29)+WQy*VS1(34,29)-r1x2E*VR1(34,29)&
   +3D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +HfxZpE*VS1(20,29)
VS0(34,47)=QCx*VS0(34,30)+WQx*VS1(34,30)&
   +2D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))
VS0(34,48)=QCx*VS0(34,31)+WQx*VS1(34,31)&
   +r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))
VS0(34,49)=QCy*VS0(34,31)+WQy*VS1(34,31)-r1x2E*VR1(34,31)&
   +r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +HfxZpE*VS1(20,31)
VS0(34,50)=QCy*VS0(34,32)+WQy*VS1(34,32)-r1x2E*VR1(34,32)&
   +2D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +HfxZpE*VS1(20,32)
VS0(34,51)=QCz*VS0(34,30)+WQz*VS1(34,30)&
   +2D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))&
   +3D0*HfxZpE*VS1(19,30)
VS0(34,52)=QCz*VS0(34,31)+WQz*VS1(34,31)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +3D0*HfxZpE*VS1(19,31)
VS0(34,53)=QCz*VS0(34,32)+WQz*VS1(34,32)&
   +2D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +3D0*HfxZpE*VS1(19,32)
VS0(34,54)=QCz*VS0(34,33)+WQz*VS1(34,33)&
   +3D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +3D0*HfxZpE*VS1(19,33)
VS0(34,55)=QCz*VS0(34,34)+WQz*VS1(34,34)&
   +3D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +3D0*HfxZpE*VS1(19,34)
VS0(34,56)=QCz*VS0(34,35)+WQz*VS1(34,35)&
   +4D0*r1x2E*(VS0(34,20)-ZxZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(19,35)
VS0(35,36)=QCx*VS0(35,21)+WQx*VS1(35,21)&
   +4D0*r1x2E*(VS0(35,11)-ZxZpE*VS1(35,11))
VS0(35,37)=QCx*VS0(35,22)+WQx*VS1(35,22)&
   +3D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,38)=QCx*VS0(35,23)+WQx*VS1(35,23)&
   +2D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,39)=QCy*VS0(35,23)+WQy*VS1(35,23)-r1x2E*VR1(35,23)&
   +2D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,40)=QCy*VS0(35,24)+WQy*VS1(35,24)-r1x2E*VR1(35,24)&
   +3D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,41)=QCy*VS0(35,25)+WQy*VS1(35,25)-r1x2E*VR1(35,25)&
   +4D0*r1x2E*(VS0(35,14)-ZxZpE*VS1(35,14))
VS0(35,42)=QCx*VS0(35,26)+WQx*VS1(35,26)&
   +3D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))
VS0(35,43)=QCx*VS0(35,27)+WQx*VS1(35,27)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,44)=QCx*VS0(35,28)+WQx*VS1(35,28)&
   +r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,45)=QCy*VS0(35,28)+WQy*VS1(35,28)-r1x2E*VR1(35,28)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,46)=QCy*VS0(35,29)+WQy*VS1(35,29)-r1x2E*VR1(35,29)&
   +3D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,47)=QCx*VS0(35,30)+WQx*VS1(35,30)&
   +2D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,48)=QCx*VS0(35,31)+WQx*VS1(35,31)&
   +r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,49)=QCy*VS0(35,31)+WQy*VS1(35,31)-r1x2E*VR1(35,31)&
   +r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,50)=QCy*VS0(35,32)+WQy*VS1(35,32)-r1x2E*VR1(35,32)&
   +2D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,51)=QCz*VS0(35,30)+WQz*VS1(35,30)&
   +2D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))&
   +4D0*HfxZpE*VS1(20,30)
VS0(35,52)=QCz*VS0(35,31)+WQz*VS1(35,31)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))&
   +4D0*HfxZpE*VS1(20,31)
VS0(35,53)=QCz*VS0(35,32)+WQz*VS1(35,32)&
   +2D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))&
   +4D0*HfxZpE*VS1(20,32)
VS0(35,54)=QCz*VS0(35,33)+WQz*VS1(35,33)&
   +3D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))&
   +4D0*HfxZpE*VS1(20,33)
VS0(35,55)=QCz*VS0(35,34)+WQz*VS1(35,34)&
   +3D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))&
   +4D0*HfxZpE*VS1(20,34)
VS0(35,56)=QCz*VS0(35,35)+WQz*VS1(35,35)&
   +4D0*r1x2E*(VS0(35,20)-ZxZpE*VS1(35,20))&
   +4D0*HfxZpE*VS1(20,35)
CASE(3)
VS0(21,36)=QCx*VS0(21,21)+WQx*VS1(21,21)&
   +4D0*r1x2E*(VS0(21,11)-ZxZpE*VS1(21,11))&
   +4D0*HfxZpE*VS1(11,21)
VS0(21,37)=QCx*VS0(21,22)+WQx*VS1(21,22)&
   +3D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))&
   +4D0*HfxZpE*VS1(11,22)
VS0(21,38)=QCx*VS0(21,23)+WQx*VS1(21,23)&
   +2D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))&
   +4D0*HfxZpE*VS1(11,23)
VS0(21,39)=QCy*VS0(21,23)+WQy*VS1(21,23)&
   +2D0*r1x2E*(VS0(21,12)-ZxZpE*VS1(21,12))
VS0(21,40)=QCy*VS0(21,24)+WQy*VS1(21,24)&
   +3D0*r1x2E*(VS0(21,13)-ZxZpE*VS1(21,13))
VS0(21,41)=QCy*VS0(21,25)+WQy*VS1(21,25)&
   +4D0*r1x2E*(VS0(21,14)-ZxZpE*VS1(21,14))
VS0(21,42)=QCx*VS0(21,26)+WQx*VS1(21,26)&
   +3D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))&
   +4D0*HfxZpE*VS1(11,26)
VS0(21,43)=QCx*VS0(21,27)+WQx*VS1(21,27)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))&
   +4D0*HfxZpE*VS1(11,27)
VS0(21,44)=QCx*VS0(21,28)+WQx*VS1(21,28)&
   +r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))&
   +4D0*HfxZpE*VS1(11,28)
VS0(21,45)=QCy*VS0(21,28)+WQy*VS1(21,28)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,46)=QCy*VS0(21,29)+WQy*VS1(21,29)&
   +3D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,47)=QCx*VS0(21,30)+WQx*VS1(21,30)&
   +2D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))&
   +4D0*HfxZpE*VS1(11,30)
VS0(21,48)=QCx*VS0(21,31)+WQx*VS1(21,31)&
   +r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))&
   +4D0*HfxZpE*VS1(11,31)
VS0(21,49)=QCy*VS0(21,31)+WQy*VS1(21,31)&
   +r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,50)=QCy*VS0(21,32)+WQy*VS1(21,32)&
   +2D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,51)=QCz*VS0(21,30)+WQz*VS1(21,30)-r1x2E*VR1(21,30)&
   +2D0*r1x2E*(VS0(21,15)-ZxZpE*VS1(21,15))
VS0(21,52)=QCz*VS0(21,31)+WQz*VS1(21,31)-r1x2E*VR1(21,31)&
   +2D0*r1x2E*(VS0(21,16)-ZxZpE*VS1(21,16))
VS0(21,53)=QCz*VS0(21,32)+WQz*VS1(21,32)-r1x2E*VR1(21,32)&
   +2D0*r1x2E*(VS0(21,17)-ZxZpE*VS1(21,17))
VS0(21,54)=QCz*VS0(21,33)+WQz*VS1(21,33)-r1x2E*VR1(21,33)&
   +3D0*r1x2E*(VS0(21,18)-ZxZpE*VS1(21,18))
VS0(21,55)=QCz*VS0(21,34)+WQz*VS1(21,34)-r1x2E*VR1(21,34)&
   +3D0*r1x2E*(VS0(21,19)-ZxZpE*VS1(21,19))
VS0(21,56)=QCz*VS0(21,35)+WQz*VS1(21,35)-r1x2E*VR1(21,35)&
   +4D0*r1x2E*(VS0(21,20)-ZxZpE*VS1(21,20))
VS0(22,36)=QCx*VS0(22,21)+WQx*VS1(22,21)&
   +4D0*r1x2E*(VS0(22,11)-ZxZpE*VS1(22,11))&
   +3D0*HfxZpE*VS1(12,21)
VS0(22,37)=QCx*VS0(22,22)+WQx*VS1(22,22)&
   +3D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +3D0*HfxZpE*VS1(12,22)
VS0(22,38)=QCx*VS0(22,23)+WQx*VS1(22,23)&
   +2D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +3D0*HfxZpE*VS1(12,23)
VS0(22,39)=QCy*VS0(22,23)+WQy*VS1(22,23)&
   +2D0*r1x2E*(VS0(22,12)-ZxZpE*VS1(22,12))&
   +HfxZpE*VS1(11,23)
VS0(22,40)=QCy*VS0(22,24)+WQy*VS1(22,24)&
   +3D0*r1x2E*(VS0(22,13)-ZxZpE*VS1(22,13))&
   +HfxZpE*VS1(11,24)
VS0(22,41)=QCy*VS0(22,25)+WQy*VS1(22,25)&
   +4D0*r1x2E*(VS0(22,14)-ZxZpE*VS1(22,14))&
   +HfxZpE*VS1(11,25)
VS0(22,42)=QCx*VS0(22,26)+WQx*VS1(22,26)&
   +3D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))&
   +3D0*HfxZpE*VS1(12,26)
VS0(22,43)=QCx*VS0(22,27)+WQx*VS1(22,27)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +3D0*HfxZpE*VS1(12,27)
VS0(22,44)=QCx*VS0(22,28)+WQx*VS1(22,28)&
   +r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +3D0*HfxZpE*VS1(12,28)
VS0(22,45)=QCy*VS0(22,28)+WQy*VS1(22,28)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))&
   +HfxZpE*VS1(11,28)
VS0(22,46)=QCy*VS0(22,29)+WQy*VS1(22,29)&
   +3D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))&
   +HfxZpE*VS1(11,29)
VS0(22,47)=QCx*VS0(22,30)+WQx*VS1(22,30)&
   +2D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +3D0*HfxZpE*VS1(12,30)
VS0(22,48)=QCx*VS0(22,31)+WQx*VS1(22,31)&
   +r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +3D0*HfxZpE*VS1(12,31)
VS0(22,49)=QCy*VS0(22,31)+WQy*VS1(22,31)&
   +r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))&
   +HfxZpE*VS1(11,31)
VS0(22,50)=QCy*VS0(22,32)+WQy*VS1(22,32)&
   +2D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))&
   +HfxZpE*VS1(11,32)
VS0(22,51)=QCz*VS0(22,30)+WQz*VS1(22,30)-r1x2E*VR1(22,30)&
   +2D0*r1x2E*(VS0(22,15)-ZxZpE*VS1(22,15))
VS0(22,52)=QCz*VS0(22,31)+WQz*VS1(22,31)-r1x2E*VR1(22,31)&
   +2D0*r1x2E*(VS0(22,16)-ZxZpE*VS1(22,16))
VS0(22,53)=QCz*VS0(22,32)+WQz*VS1(22,32)-r1x2E*VR1(22,32)&
   +2D0*r1x2E*(VS0(22,17)-ZxZpE*VS1(22,17))
VS0(22,54)=QCz*VS0(22,33)+WQz*VS1(22,33)-r1x2E*VR1(22,33)&
   +3D0*r1x2E*(VS0(22,18)-ZxZpE*VS1(22,18))
VS0(22,55)=QCz*VS0(22,34)+WQz*VS1(22,34)-r1x2E*VR1(22,34)&
   +3D0*r1x2E*(VS0(22,19)-ZxZpE*VS1(22,19))
VS0(22,56)=QCz*VS0(22,35)+WQz*VS1(22,35)-r1x2E*VR1(22,35)&
   +4D0*r1x2E*(VS0(22,20)-ZxZpE*VS1(22,20))
VS0(23,36)=QCx*VS0(23,21)+WQx*VS1(23,21)&
   +4D0*r1x2E*(VS0(23,11)-ZxZpE*VS1(23,11))&
   +2D0*HfxZpE*VS1(13,21)
VS0(23,37)=QCx*VS0(23,22)+WQx*VS1(23,22)&
   +3D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(13,22)
VS0(23,38)=QCx*VS0(23,23)+WQx*VS1(23,23)&
   +2D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(13,23)
VS0(23,39)=QCy*VS0(23,23)+WQy*VS1(23,23)&
   +2D0*r1x2E*(VS0(23,12)-ZxZpE*VS1(23,12))&
   +2D0*HfxZpE*VS1(12,23)
VS0(23,40)=QCy*VS0(23,24)+WQy*VS1(23,24)&
   +3D0*r1x2E*(VS0(23,13)-ZxZpE*VS1(23,13))&
   +2D0*HfxZpE*VS1(12,24)
VS0(23,41)=QCy*VS0(23,25)+WQy*VS1(23,25)&
   +4D0*r1x2E*(VS0(23,14)-ZxZpE*VS1(23,14))&
   +2D0*HfxZpE*VS1(12,25)
VS0(23,42)=QCx*VS0(23,26)+WQx*VS1(23,26)&
   +3D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))&
   +2D0*HfxZpE*VS1(13,26)
VS0(23,43)=QCx*VS0(23,27)+WQx*VS1(23,27)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(13,27)
VS0(23,44)=QCx*VS0(23,28)+WQx*VS1(23,28)&
   +r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(13,28)
VS0(23,45)=QCy*VS0(23,28)+WQy*VS1(23,28)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))&
   +2D0*HfxZpE*VS1(12,28)
VS0(23,46)=QCy*VS0(23,29)+WQy*VS1(23,29)&
   +3D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))&
   +2D0*HfxZpE*VS1(12,29)
VS0(23,47)=QCx*VS0(23,30)+WQx*VS1(23,30)&
   +2D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(13,30)
VS0(23,48)=QCx*VS0(23,31)+WQx*VS1(23,31)&
   +r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(13,31)
VS0(23,49)=QCy*VS0(23,31)+WQy*VS1(23,31)&
   +r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))&
   +2D0*HfxZpE*VS1(12,31)
VS0(23,50)=QCy*VS0(23,32)+WQy*VS1(23,32)&
   +2D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))&
   +2D0*HfxZpE*VS1(12,32)
VS0(23,51)=QCz*VS0(23,30)+WQz*VS1(23,30)-r1x2E*VR1(23,30)&
   +2D0*r1x2E*(VS0(23,15)-ZxZpE*VS1(23,15))
VS0(23,52)=QCz*VS0(23,31)+WQz*VS1(23,31)-r1x2E*VR1(23,31)&
   +2D0*r1x2E*(VS0(23,16)-ZxZpE*VS1(23,16))
VS0(23,53)=QCz*VS0(23,32)+WQz*VS1(23,32)-r1x2E*VR1(23,32)&
   +2D0*r1x2E*(VS0(23,17)-ZxZpE*VS1(23,17))
VS0(23,54)=QCz*VS0(23,33)+WQz*VS1(23,33)-r1x2E*VR1(23,33)&
   +3D0*r1x2E*(VS0(23,18)-ZxZpE*VS1(23,18))
VS0(23,55)=QCz*VS0(23,34)+WQz*VS1(23,34)-r1x2E*VR1(23,34)&
   +3D0*r1x2E*(VS0(23,19)-ZxZpE*VS1(23,19))
VS0(23,56)=QCz*VS0(23,35)+WQz*VS1(23,35)-r1x2E*VR1(23,35)&
   +4D0*r1x2E*(VS0(23,20)-ZxZpE*VS1(23,20))
VS0(24,36)=QCx*VS0(24,21)+WQx*VS1(24,21)&
   +4D0*r1x2E*(VS0(24,11)-ZxZpE*VS1(24,11))&
   +HfxZpE*VS1(14,21)
VS0(24,37)=QCx*VS0(24,22)+WQx*VS1(24,22)&
   +3D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +HfxZpE*VS1(14,22)
VS0(24,38)=QCx*VS0(24,23)+WQx*VS1(24,23)&
   +2D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +HfxZpE*VS1(14,23)
VS0(24,39)=QCy*VS0(24,23)+WQy*VS1(24,23)&
   +2D0*r1x2E*(VS0(24,12)-ZxZpE*VS1(24,12))&
   +3D0*HfxZpE*VS1(13,23)
VS0(24,40)=QCy*VS0(24,24)+WQy*VS1(24,24)&
   +3D0*r1x2E*(VS0(24,13)-ZxZpE*VS1(24,13))&
   +3D0*HfxZpE*VS1(13,24)
VS0(24,41)=QCy*VS0(24,25)+WQy*VS1(24,25)&
   +4D0*r1x2E*(VS0(24,14)-ZxZpE*VS1(24,14))&
   +3D0*HfxZpE*VS1(13,25)
VS0(24,42)=QCx*VS0(24,26)+WQx*VS1(24,26)&
   +3D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))&
   +HfxZpE*VS1(14,26)
VS0(24,43)=QCx*VS0(24,27)+WQx*VS1(24,27)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +HfxZpE*VS1(14,27)
VS0(24,44)=QCx*VS0(24,28)+WQx*VS1(24,28)&
   +r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +HfxZpE*VS1(14,28)
VS0(24,45)=QCy*VS0(24,28)+WQy*VS1(24,28)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))&
   +3D0*HfxZpE*VS1(13,28)
VS0(24,46)=QCy*VS0(24,29)+WQy*VS1(24,29)&
   +3D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))&
   +3D0*HfxZpE*VS1(13,29)
VS0(24,47)=QCx*VS0(24,30)+WQx*VS1(24,30)&
   +2D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +HfxZpE*VS1(14,30)
VS0(24,48)=QCx*VS0(24,31)+WQx*VS1(24,31)&
   +r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +HfxZpE*VS1(14,31)
VS0(24,49)=QCy*VS0(24,31)+WQy*VS1(24,31)&
   +r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))&
   +3D0*HfxZpE*VS1(13,31)
VS0(24,50)=QCy*VS0(24,32)+WQy*VS1(24,32)&
   +2D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))&
   +3D0*HfxZpE*VS1(13,32)
VS0(24,51)=QCz*VS0(24,30)+WQz*VS1(24,30)-r1x2E*VR1(24,30)&
   +2D0*r1x2E*(VS0(24,15)-ZxZpE*VS1(24,15))
VS0(24,52)=QCz*VS0(24,31)+WQz*VS1(24,31)-r1x2E*VR1(24,31)&
   +2D0*r1x2E*(VS0(24,16)-ZxZpE*VS1(24,16))
VS0(24,53)=QCz*VS0(24,32)+WQz*VS1(24,32)-r1x2E*VR1(24,32)&
   +2D0*r1x2E*(VS0(24,17)-ZxZpE*VS1(24,17))
VS0(24,54)=QCz*VS0(24,33)+WQz*VS1(24,33)-r1x2E*VR1(24,33)&
   +3D0*r1x2E*(VS0(24,18)-ZxZpE*VS1(24,18))
VS0(24,55)=QCz*VS0(24,34)+WQz*VS1(24,34)-r1x2E*VR1(24,34)&
   +3D0*r1x2E*(VS0(24,19)-ZxZpE*VS1(24,19))
VS0(24,56)=QCz*VS0(24,35)+WQz*VS1(24,35)-r1x2E*VR1(24,35)&
   +4D0*r1x2E*(VS0(24,20)-ZxZpE*VS1(24,20))
VS0(25,36)=QCx*VS0(25,21)+WQx*VS1(25,21)&
   +4D0*r1x2E*(VS0(25,11)-ZxZpE*VS1(25,11))
VS0(25,37)=QCx*VS0(25,22)+WQx*VS1(25,22)&
   +3D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))
VS0(25,38)=QCx*VS0(25,23)+WQx*VS1(25,23)&
   +2D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))
VS0(25,39)=QCy*VS0(25,23)+WQy*VS1(25,23)&
   +2D0*r1x2E*(VS0(25,12)-ZxZpE*VS1(25,12))&
   +4D0*HfxZpE*VS1(14,23)
VS0(25,40)=QCy*VS0(25,24)+WQy*VS1(25,24)&
   +3D0*r1x2E*(VS0(25,13)-ZxZpE*VS1(25,13))&
   +4D0*HfxZpE*VS1(14,24)
VS0(25,41)=QCy*VS0(25,25)+WQy*VS1(25,25)&
   +4D0*r1x2E*(VS0(25,14)-ZxZpE*VS1(25,14))&
   +4D0*HfxZpE*VS1(14,25)
VS0(25,42)=QCx*VS0(25,26)+WQx*VS1(25,26)&
   +3D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,43)=QCx*VS0(25,27)+WQx*VS1(25,27)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,44)=QCx*VS0(25,28)+WQx*VS1(25,28)&
   +r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,45)=QCy*VS0(25,28)+WQy*VS1(25,28)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))&
   +4D0*HfxZpE*VS1(14,28)
VS0(25,46)=QCy*VS0(25,29)+WQy*VS1(25,29)&
   +3D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))&
   +4D0*HfxZpE*VS1(14,29)
VS0(25,47)=QCx*VS0(25,30)+WQx*VS1(25,30)&
   +2D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,48)=QCx*VS0(25,31)+WQx*VS1(25,31)&
   +r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,49)=QCy*VS0(25,31)+WQy*VS1(25,31)&
   +r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))&
   +4D0*HfxZpE*VS1(14,31)
VS0(25,50)=QCy*VS0(25,32)+WQy*VS1(25,32)&
   +2D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))&
   +4D0*HfxZpE*VS1(14,32)
VS0(25,51)=QCz*VS0(25,30)+WQz*VS1(25,30)-r1x2E*VR1(25,30)&
   +2D0*r1x2E*(VS0(25,15)-ZxZpE*VS1(25,15))
VS0(25,52)=QCz*VS0(25,31)+WQz*VS1(25,31)-r1x2E*VR1(25,31)&
   +2D0*r1x2E*(VS0(25,16)-ZxZpE*VS1(25,16))
VS0(25,53)=QCz*VS0(25,32)+WQz*VS1(25,32)-r1x2E*VR1(25,32)&
   +2D0*r1x2E*(VS0(25,17)-ZxZpE*VS1(25,17))
VS0(25,54)=QCz*VS0(25,33)+WQz*VS1(25,33)-r1x2E*VR1(25,33)&
   +3D0*r1x2E*(VS0(25,18)-ZxZpE*VS1(25,18))
VS0(25,55)=QCz*VS0(25,34)+WQz*VS1(25,34)-r1x2E*VR1(25,34)&
   +3D0*r1x2E*(VS0(25,19)-ZxZpE*VS1(25,19))
VS0(25,56)=QCz*VS0(25,35)+WQz*VS1(25,35)-r1x2E*VR1(25,35)&
   +4D0*r1x2E*(VS0(25,20)-ZxZpE*VS1(25,20))
VS0(26,36)=QCx*VS0(26,21)+WQx*VS1(26,21)&
   +4D0*r1x2E*(VS0(26,11)-ZxZpE*VS1(26,11))&
   +3D0*HfxZpE*VS1(15,21)
VS0(26,37)=QCx*VS0(26,22)+WQx*VS1(26,22)&
   +3D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))&
   +3D0*HfxZpE*VS1(15,22)
VS0(26,38)=QCx*VS0(26,23)+WQx*VS1(26,23)&
   +2D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))&
   +3D0*HfxZpE*VS1(15,23)
VS0(26,39)=QCy*VS0(26,23)+WQy*VS1(26,23)&
   +2D0*r1x2E*(VS0(26,12)-ZxZpE*VS1(26,12))
VS0(26,40)=QCy*VS0(26,24)+WQy*VS1(26,24)&
   +3D0*r1x2E*(VS0(26,13)-ZxZpE*VS1(26,13))
VS0(26,41)=QCy*VS0(26,25)+WQy*VS1(26,25)&
   +4D0*r1x2E*(VS0(26,14)-ZxZpE*VS1(26,14))
VS0(26,42)=QCx*VS0(26,26)+WQx*VS1(26,26)&
   +3D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +3D0*HfxZpE*VS1(15,26)
VS0(26,43)=QCx*VS0(26,27)+WQx*VS1(26,27)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +3D0*HfxZpE*VS1(15,27)
VS0(26,44)=QCx*VS0(26,28)+WQx*VS1(26,28)&
   +r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +3D0*HfxZpE*VS1(15,28)
VS0(26,45)=QCy*VS0(26,28)+WQy*VS1(26,28)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))
VS0(26,46)=QCy*VS0(26,29)+WQy*VS1(26,29)&
   +3D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))
VS0(26,47)=QCx*VS0(26,30)+WQx*VS1(26,30)&
   +2D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +3D0*HfxZpE*VS1(15,30)
VS0(26,48)=QCx*VS0(26,31)+WQx*VS1(26,31)&
   +r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +3D0*HfxZpE*VS1(15,31)
VS0(26,49)=QCy*VS0(26,31)+WQy*VS1(26,31)&
   +r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))
VS0(26,50)=QCy*VS0(26,32)+WQy*VS1(26,32)&
   +2D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))
VS0(26,51)=QCz*VS0(26,30)+WQz*VS1(26,30)-r1x2E*VR1(26,30)&
   +2D0*r1x2E*(VS0(26,15)-ZxZpE*VS1(26,15))&
   +HfxZpE*VS1(11,30)
VS0(26,52)=QCz*VS0(26,31)+WQz*VS1(26,31)-r1x2E*VR1(26,31)&
   +2D0*r1x2E*(VS0(26,16)-ZxZpE*VS1(26,16))&
   +HfxZpE*VS1(11,31)
VS0(26,53)=QCz*VS0(26,32)+WQz*VS1(26,32)-r1x2E*VR1(26,32)&
   +2D0*r1x2E*(VS0(26,17)-ZxZpE*VS1(26,17))&
   +HfxZpE*VS1(11,32)
VS0(26,54)=QCz*VS0(26,33)+WQz*VS1(26,33)-r1x2E*VR1(26,33)&
   +3D0*r1x2E*(VS0(26,18)-ZxZpE*VS1(26,18))&
   +HfxZpE*VS1(11,33)
VS0(26,55)=QCz*VS0(26,34)+WQz*VS1(26,34)-r1x2E*VR1(26,34)&
   +3D0*r1x2E*(VS0(26,19)-ZxZpE*VS1(26,19))&
   +HfxZpE*VS1(11,34)
VS0(26,56)=QCz*VS0(26,35)+WQz*VS1(26,35)-r1x2E*VR1(26,35)&
   +4D0*r1x2E*(VS0(26,20)-ZxZpE*VS1(26,20))&
   +HfxZpE*VS1(11,35)
VS0(27,36)=QCx*VS0(27,21)+WQx*VS1(27,21)&
   +4D0*r1x2E*(VS0(27,11)-ZxZpE*VS1(27,11))&
   +2D0*HfxZpE*VS1(16,21)
VS0(27,37)=QCx*VS0(27,22)+WQx*VS1(27,22)&
   +3D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +2D0*HfxZpE*VS1(16,22)
VS0(27,38)=QCx*VS0(27,23)+WQx*VS1(27,23)&
   +2D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +2D0*HfxZpE*VS1(16,23)
VS0(27,39)=QCy*VS0(27,23)+WQy*VS1(27,23)&
   +2D0*r1x2E*(VS0(27,12)-ZxZpE*VS1(27,12))&
   +HfxZpE*VS1(15,23)
VS0(27,40)=QCy*VS0(27,24)+WQy*VS1(27,24)&
   +3D0*r1x2E*(VS0(27,13)-ZxZpE*VS1(27,13))&
   +HfxZpE*VS1(15,24)
VS0(27,41)=QCy*VS0(27,25)+WQy*VS1(27,25)&
   +4D0*r1x2E*(VS0(27,14)-ZxZpE*VS1(27,14))&
   +HfxZpE*VS1(15,25)
VS0(27,42)=QCx*VS0(27,26)+WQx*VS1(27,26)&
   +3D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +2D0*HfxZpE*VS1(16,26)
VS0(27,43)=QCx*VS0(27,27)+WQx*VS1(27,27)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +2D0*HfxZpE*VS1(16,27)
VS0(27,44)=QCx*VS0(27,28)+WQx*VS1(27,28)&
   +r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +2D0*HfxZpE*VS1(16,28)
VS0(27,45)=QCy*VS0(27,28)+WQy*VS1(27,28)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(15,28)
VS0(27,46)=QCy*VS0(27,29)+WQy*VS1(27,29)&
   +3D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(15,29)
VS0(27,47)=QCx*VS0(27,30)+WQx*VS1(27,30)&
   +2D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +2D0*HfxZpE*VS1(16,30)
VS0(27,48)=QCx*VS0(27,31)+WQx*VS1(27,31)&
   +r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +2D0*HfxZpE*VS1(16,31)
VS0(27,49)=QCy*VS0(27,31)+WQy*VS1(27,31)&
   +r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(15,31)
VS0(27,50)=QCy*VS0(27,32)+WQy*VS1(27,32)&
   +2D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(15,32)
VS0(27,51)=QCz*VS0(27,30)+WQz*VS1(27,30)-r1x2E*VR1(27,30)&
   +2D0*r1x2E*(VS0(27,15)-ZxZpE*VS1(27,15))&
   +HfxZpE*VS1(12,30)
VS0(27,52)=QCz*VS0(27,31)+WQz*VS1(27,31)-r1x2E*VR1(27,31)&
   +2D0*r1x2E*(VS0(27,16)-ZxZpE*VS1(27,16))&
   +HfxZpE*VS1(12,31)
VS0(27,53)=QCz*VS0(27,32)+WQz*VS1(27,32)-r1x2E*VR1(27,32)&
   +2D0*r1x2E*(VS0(27,17)-ZxZpE*VS1(27,17))&
   +HfxZpE*VS1(12,32)
VS0(27,54)=QCz*VS0(27,33)+WQz*VS1(27,33)-r1x2E*VR1(27,33)&
   +3D0*r1x2E*(VS0(27,18)-ZxZpE*VS1(27,18))&
   +HfxZpE*VS1(12,33)
VS0(27,55)=QCz*VS0(27,34)+WQz*VS1(27,34)-r1x2E*VR1(27,34)&
   +3D0*r1x2E*(VS0(27,19)-ZxZpE*VS1(27,19))&
   +HfxZpE*VS1(12,34)
VS0(27,56)=QCz*VS0(27,35)+WQz*VS1(27,35)-r1x2E*VR1(27,35)&
   +4D0*r1x2E*(VS0(27,20)-ZxZpE*VS1(27,20))&
   +HfxZpE*VS1(12,35)
VS0(28,36)=QCx*VS0(28,21)+WQx*VS1(28,21)&
   +4D0*r1x2E*(VS0(28,11)-ZxZpE*VS1(28,11))&
   +HfxZpE*VS1(17,21)
VS0(28,37)=QCx*VS0(28,22)+WQx*VS1(28,22)&
   +3D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +HfxZpE*VS1(17,22)
VS0(28,38)=QCx*VS0(28,23)+WQx*VS1(28,23)&
   +2D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +HfxZpE*VS1(17,23)
VS0(28,39)=QCy*VS0(28,23)+WQy*VS1(28,23)&
   +2D0*r1x2E*(VS0(28,12)-ZxZpE*VS1(28,12))&
   +2D0*HfxZpE*VS1(16,23)
VS0(28,40)=QCy*VS0(28,24)+WQy*VS1(28,24)&
   +3D0*r1x2E*(VS0(28,13)-ZxZpE*VS1(28,13))&
   +2D0*HfxZpE*VS1(16,24)
VS0(28,41)=QCy*VS0(28,25)+WQy*VS1(28,25)&
   +4D0*r1x2E*(VS0(28,14)-ZxZpE*VS1(28,14))&
   +2D0*HfxZpE*VS1(16,25)
VS0(28,42)=QCx*VS0(28,26)+WQx*VS1(28,26)&
   +3D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(17,26)
VS0(28,43)=QCx*VS0(28,27)+WQx*VS1(28,27)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(17,27)
VS0(28,44)=QCx*VS0(28,28)+WQx*VS1(28,28)&
   +r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(17,28)
VS0(28,45)=QCy*VS0(28,28)+WQy*VS1(28,28)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +2D0*HfxZpE*VS1(16,28)
VS0(28,46)=QCy*VS0(28,29)+WQy*VS1(28,29)&
   +3D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +2D0*HfxZpE*VS1(16,29)
VS0(28,47)=QCx*VS0(28,30)+WQx*VS1(28,30)&
   +2D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(17,30)
VS0(28,48)=QCx*VS0(28,31)+WQx*VS1(28,31)&
   +r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(17,31)
VS0(28,49)=QCy*VS0(28,31)+WQy*VS1(28,31)&
   +r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +2D0*HfxZpE*VS1(16,31)
VS0(28,50)=QCy*VS0(28,32)+WQy*VS1(28,32)&
   +2D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +2D0*HfxZpE*VS1(16,32)
VS0(28,51)=QCz*VS0(28,30)+WQz*VS1(28,30)-r1x2E*VR1(28,30)&
   +2D0*r1x2E*(VS0(28,15)-ZxZpE*VS1(28,15))&
   +HfxZpE*VS1(13,30)
VS0(28,52)=QCz*VS0(28,31)+WQz*VS1(28,31)-r1x2E*VR1(28,31)&
   +2D0*r1x2E*(VS0(28,16)-ZxZpE*VS1(28,16))&
   +HfxZpE*VS1(13,31)
VS0(28,53)=QCz*VS0(28,32)+WQz*VS1(28,32)-r1x2E*VR1(28,32)&
   +2D0*r1x2E*(VS0(28,17)-ZxZpE*VS1(28,17))&
   +HfxZpE*VS1(13,32)
VS0(28,54)=QCz*VS0(28,33)+WQz*VS1(28,33)-r1x2E*VR1(28,33)&
   +3D0*r1x2E*(VS0(28,18)-ZxZpE*VS1(28,18))&
   +HfxZpE*VS1(13,33)
VS0(28,55)=QCz*VS0(28,34)+WQz*VS1(28,34)-r1x2E*VR1(28,34)&
   +3D0*r1x2E*(VS0(28,19)-ZxZpE*VS1(28,19))&
   +HfxZpE*VS1(13,34)
VS0(28,56)=QCz*VS0(28,35)+WQz*VS1(28,35)-r1x2E*VR1(28,35)&
   +4D0*r1x2E*(VS0(28,20)-ZxZpE*VS1(28,20))&
   +HfxZpE*VS1(13,35)
VS0(29,36)=QCx*VS0(29,21)+WQx*VS1(29,21)&
   +4D0*r1x2E*(VS0(29,11)-ZxZpE*VS1(29,11))
VS0(29,37)=QCx*VS0(29,22)+WQx*VS1(29,22)&
   +3D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))
VS0(29,38)=QCx*VS0(29,23)+WQx*VS1(29,23)&
   +2D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))
VS0(29,39)=QCy*VS0(29,23)+WQy*VS1(29,23)&
   +2D0*r1x2E*(VS0(29,12)-ZxZpE*VS1(29,12))&
   +3D0*HfxZpE*VS1(17,23)
VS0(29,40)=QCy*VS0(29,24)+WQy*VS1(29,24)&
   +3D0*r1x2E*(VS0(29,13)-ZxZpE*VS1(29,13))&
   +3D0*HfxZpE*VS1(17,24)
VS0(29,41)=QCy*VS0(29,25)+WQy*VS1(29,25)&
   +4D0*r1x2E*(VS0(29,14)-ZxZpE*VS1(29,14))&
   +3D0*HfxZpE*VS1(17,25)
VS0(29,42)=QCx*VS0(29,26)+WQx*VS1(29,26)&
   +3D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))
VS0(29,43)=QCx*VS0(29,27)+WQx*VS1(29,27)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))
VS0(29,44)=QCx*VS0(29,28)+WQx*VS1(29,28)&
   +r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))
VS0(29,45)=QCy*VS0(29,28)+WQy*VS1(29,28)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +3D0*HfxZpE*VS1(17,28)
VS0(29,46)=QCy*VS0(29,29)+WQy*VS1(29,29)&
   +3D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +3D0*HfxZpE*VS1(17,29)
VS0(29,47)=QCx*VS0(29,30)+WQx*VS1(29,30)&
   +2D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))
VS0(29,48)=QCx*VS0(29,31)+WQx*VS1(29,31)&
   +r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))
VS0(29,49)=QCy*VS0(29,31)+WQy*VS1(29,31)&
   +r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +3D0*HfxZpE*VS1(17,31)
VS0(29,50)=QCy*VS0(29,32)+WQy*VS1(29,32)&
   +2D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +3D0*HfxZpE*VS1(17,32)
VS0(29,51)=QCz*VS0(29,30)+WQz*VS1(29,30)-r1x2E*VR1(29,30)&
   +2D0*r1x2E*(VS0(29,15)-ZxZpE*VS1(29,15))&
   +HfxZpE*VS1(14,30)
VS0(29,52)=QCz*VS0(29,31)+WQz*VS1(29,31)-r1x2E*VR1(29,31)&
   +2D0*r1x2E*(VS0(29,16)-ZxZpE*VS1(29,16))&
   +HfxZpE*VS1(14,31)
VS0(29,53)=QCz*VS0(29,32)+WQz*VS1(29,32)-r1x2E*VR1(29,32)&
   +2D0*r1x2E*(VS0(29,17)-ZxZpE*VS1(29,17))&
   +HfxZpE*VS1(14,32)
VS0(29,54)=QCz*VS0(29,33)+WQz*VS1(29,33)-r1x2E*VR1(29,33)&
   +3D0*r1x2E*(VS0(29,18)-ZxZpE*VS1(29,18))&
   +HfxZpE*VS1(14,33)
VS0(29,55)=QCz*VS0(29,34)+WQz*VS1(29,34)-r1x2E*VR1(29,34)&
   +3D0*r1x2E*(VS0(29,19)-ZxZpE*VS1(29,19))&
   +HfxZpE*VS1(14,34)
VS0(29,56)=QCz*VS0(29,35)+WQz*VS1(29,35)-r1x2E*VR1(29,35)&
   +4D0*r1x2E*(VS0(29,20)-ZxZpE*VS1(29,20))&
   +HfxZpE*VS1(14,35)
VS0(30,36)=QCx*VS0(30,21)+WQx*VS1(30,21)&
   +4D0*r1x2E*(VS0(30,11)-ZxZpE*VS1(30,11))&
   +2D0*HfxZpE*VS1(18,21)
VS0(30,37)=QCx*VS0(30,22)+WQx*VS1(30,22)&
   +3D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))&
   +2D0*HfxZpE*VS1(18,22)
VS0(30,38)=QCx*VS0(30,23)+WQx*VS1(30,23)&
   +2D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))&
   +2D0*HfxZpE*VS1(18,23)
VS0(30,39)=QCy*VS0(30,23)+WQy*VS1(30,23)&
   +2D0*r1x2E*(VS0(30,12)-ZxZpE*VS1(30,12))
VS0(30,40)=QCy*VS0(30,24)+WQy*VS1(30,24)&
   +3D0*r1x2E*(VS0(30,13)-ZxZpE*VS1(30,13))
VS0(30,41)=QCy*VS0(30,25)+WQy*VS1(30,25)&
   +4D0*r1x2E*(VS0(30,14)-ZxZpE*VS1(30,14))
VS0(30,42)=QCx*VS0(30,26)+WQx*VS1(30,26)&
   +3D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(18,26)
VS0(30,43)=QCx*VS0(30,27)+WQx*VS1(30,27)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(18,27)
VS0(30,44)=QCx*VS0(30,28)+WQx*VS1(30,28)&
   +r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(18,28)
VS0(30,45)=QCy*VS0(30,28)+WQy*VS1(30,28)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))
VS0(30,46)=QCy*VS0(30,29)+WQy*VS1(30,29)&
   +3D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))
VS0(30,47)=QCx*VS0(30,30)+WQx*VS1(30,30)&
   +2D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(18,30)
VS0(30,48)=QCx*VS0(30,31)+WQx*VS1(30,31)&
   +r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(18,31)
VS0(30,49)=QCy*VS0(30,31)+WQy*VS1(30,31)&
   +r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))
VS0(30,50)=QCy*VS0(30,32)+WQy*VS1(30,32)&
   +2D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))
VS0(30,51)=QCz*VS0(30,30)+WQz*VS1(30,30)-r1x2E*VR1(30,30)&
   +2D0*r1x2E*(VS0(30,15)-ZxZpE*VS1(30,15))&
   +2D0*HfxZpE*VS1(15,30)
VS0(30,52)=QCz*VS0(30,31)+WQz*VS1(30,31)-r1x2E*VR1(30,31)&
   +2D0*r1x2E*(VS0(30,16)-ZxZpE*VS1(30,16))&
   +2D0*HfxZpE*VS1(15,31)
VS0(30,53)=QCz*VS0(30,32)+WQz*VS1(30,32)-r1x2E*VR1(30,32)&
   +2D0*r1x2E*(VS0(30,17)-ZxZpE*VS1(30,17))&
   +2D0*HfxZpE*VS1(15,32)
VS0(30,54)=QCz*VS0(30,33)+WQz*VS1(30,33)-r1x2E*VR1(30,33)&
   +3D0*r1x2E*(VS0(30,18)-ZxZpE*VS1(30,18))&
   +2D0*HfxZpE*VS1(15,33)
VS0(30,55)=QCz*VS0(30,34)+WQz*VS1(30,34)-r1x2E*VR1(30,34)&
   +3D0*r1x2E*(VS0(30,19)-ZxZpE*VS1(30,19))&
   +2D0*HfxZpE*VS1(15,34)
VS0(30,56)=QCz*VS0(30,35)+WQz*VS1(30,35)-r1x2E*VR1(30,35)&
   +4D0*r1x2E*(VS0(30,20)-ZxZpE*VS1(30,20))&
   +2D0*HfxZpE*VS1(15,35)
VS0(31,36)=QCx*VS0(31,21)+WQx*VS1(31,21)&
   +4D0*r1x2E*(VS0(31,11)-ZxZpE*VS1(31,11))&
   +HfxZpE*VS1(19,21)
VS0(31,37)=QCx*VS0(31,22)+WQx*VS1(31,22)&
   +3D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(19,22)
VS0(31,38)=QCx*VS0(31,23)+WQx*VS1(31,23)&
   +2D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(19,23)
VS0(31,39)=QCy*VS0(31,23)+WQy*VS1(31,23)&
   +2D0*r1x2E*(VS0(31,12)-ZxZpE*VS1(31,12))&
   +HfxZpE*VS1(18,23)
VS0(31,40)=QCy*VS0(31,24)+WQy*VS1(31,24)&
   +3D0*r1x2E*(VS0(31,13)-ZxZpE*VS1(31,13))&
   +HfxZpE*VS1(18,24)
VS0(31,41)=QCy*VS0(31,25)+WQy*VS1(31,25)&
   +4D0*r1x2E*(VS0(31,14)-ZxZpE*VS1(31,14))&
   +HfxZpE*VS1(18,25)
VS0(31,42)=QCx*VS0(31,26)+WQx*VS1(31,26)&
   +3D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +HfxZpE*VS1(19,26)
VS0(31,43)=QCx*VS0(31,27)+WQx*VS1(31,27)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(19,27)
VS0(31,44)=QCx*VS0(31,28)+WQx*VS1(31,28)&
   +r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(19,28)
VS0(31,45)=QCy*VS0(31,28)+WQy*VS1(31,28)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +HfxZpE*VS1(18,28)
VS0(31,46)=QCy*VS0(31,29)+WQy*VS1(31,29)&
   +3D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +HfxZpE*VS1(18,29)
VS0(31,47)=QCx*VS0(31,30)+WQx*VS1(31,30)&
   +2D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(19,30)
VS0(31,48)=QCx*VS0(31,31)+WQx*VS1(31,31)&
   +r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(19,31)
VS0(31,49)=QCy*VS0(31,31)+WQy*VS1(31,31)&
   +r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +HfxZpE*VS1(18,31)
VS0(31,50)=QCy*VS0(31,32)+WQy*VS1(31,32)&
   +2D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +HfxZpE*VS1(18,32)
VS0(31,51)=QCz*VS0(31,30)+WQz*VS1(31,30)-r1x2E*VR1(31,30)&
   +2D0*r1x2E*(VS0(31,15)-ZxZpE*VS1(31,15))&
   +2D0*HfxZpE*VS1(16,30)
VS0(31,52)=QCz*VS0(31,31)+WQz*VS1(31,31)-r1x2E*VR1(31,31)&
   +2D0*r1x2E*(VS0(31,16)-ZxZpE*VS1(31,16))&
   +2D0*HfxZpE*VS1(16,31)
VS0(31,53)=QCz*VS0(31,32)+WQz*VS1(31,32)-r1x2E*VR1(31,32)&
   +2D0*r1x2E*(VS0(31,17)-ZxZpE*VS1(31,17))&
   +2D0*HfxZpE*VS1(16,32)
VS0(31,54)=QCz*VS0(31,33)+WQz*VS1(31,33)-r1x2E*VR1(31,33)&
   +3D0*r1x2E*(VS0(31,18)-ZxZpE*VS1(31,18))&
   +2D0*HfxZpE*VS1(16,33)
VS0(31,55)=QCz*VS0(31,34)+WQz*VS1(31,34)-r1x2E*VR1(31,34)&
   +3D0*r1x2E*(VS0(31,19)-ZxZpE*VS1(31,19))&
   +2D0*HfxZpE*VS1(16,34)
VS0(31,56)=QCz*VS0(31,35)+WQz*VS1(31,35)-r1x2E*VR1(31,35)&
   +4D0*r1x2E*(VS0(31,20)-ZxZpE*VS1(31,20))&
   +2D0*HfxZpE*VS1(16,35)
VS0(32,36)=QCx*VS0(32,21)+WQx*VS1(32,21)&
   +4D0*r1x2E*(VS0(32,11)-ZxZpE*VS1(32,11))
VS0(32,37)=QCx*VS0(32,22)+WQx*VS1(32,22)&
   +3D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))
VS0(32,38)=QCx*VS0(32,23)+WQx*VS1(32,23)&
   +2D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))
VS0(32,39)=QCy*VS0(32,23)+WQy*VS1(32,23)&
   +2D0*r1x2E*(VS0(32,12)-ZxZpE*VS1(32,12))&
   +2D0*HfxZpE*VS1(19,23)
VS0(32,40)=QCy*VS0(32,24)+WQy*VS1(32,24)&
   +3D0*r1x2E*(VS0(32,13)-ZxZpE*VS1(32,13))&
   +2D0*HfxZpE*VS1(19,24)
VS0(32,41)=QCy*VS0(32,25)+WQy*VS1(32,25)&
   +4D0*r1x2E*(VS0(32,14)-ZxZpE*VS1(32,14))&
   +2D0*HfxZpE*VS1(19,25)
VS0(32,42)=QCx*VS0(32,26)+WQx*VS1(32,26)&
   +3D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))
VS0(32,43)=QCx*VS0(32,27)+WQx*VS1(32,27)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))
VS0(32,44)=QCx*VS0(32,28)+WQx*VS1(32,28)&
   +r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))
VS0(32,45)=QCy*VS0(32,28)+WQy*VS1(32,28)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(19,28)
VS0(32,46)=QCy*VS0(32,29)+WQy*VS1(32,29)&
   +3D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(19,29)
VS0(32,47)=QCx*VS0(32,30)+WQx*VS1(32,30)&
   +2D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))
VS0(32,48)=QCx*VS0(32,31)+WQx*VS1(32,31)&
   +r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))
VS0(32,49)=QCy*VS0(32,31)+WQy*VS1(32,31)&
   +r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(19,31)
VS0(32,50)=QCy*VS0(32,32)+WQy*VS1(32,32)&
   +2D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(19,32)
VS0(32,51)=QCz*VS0(32,30)+WQz*VS1(32,30)-r1x2E*VR1(32,30)&
   +2D0*r1x2E*(VS0(32,15)-ZxZpE*VS1(32,15))&
   +2D0*HfxZpE*VS1(17,30)
VS0(32,52)=QCz*VS0(32,31)+WQz*VS1(32,31)-r1x2E*VR1(32,31)&
   +2D0*r1x2E*(VS0(32,16)-ZxZpE*VS1(32,16))&
   +2D0*HfxZpE*VS1(17,31)
VS0(32,53)=QCz*VS0(32,32)+WQz*VS1(32,32)-r1x2E*VR1(32,32)&
   +2D0*r1x2E*(VS0(32,17)-ZxZpE*VS1(32,17))&
   +2D0*HfxZpE*VS1(17,32)
VS0(32,54)=QCz*VS0(32,33)+WQz*VS1(32,33)-r1x2E*VR1(32,33)&
   +3D0*r1x2E*(VS0(32,18)-ZxZpE*VS1(32,18))&
   +2D0*HfxZpE*VS1(17,33)
VS0(32,55)=QCz*VS0(32,34)+WQz*VS1(32,34)-r1x2E*VR1(32,34)&
   +3D0*r1x2E*(VS0(32,19)-ZxZpE*VS1(32,19))&
   +2D0*HfxZpE*VS1(17,34)
VS0(32,56)=QCz*VS0(32,35)+WQz*VS1(32,35)-r1x2E*VR1(32,35)&
   +4D0*r1x2E*(VS0(32,20)-ZxZpE*VS1(32,20))&
   +2D0*HfxZpE*VS1(17,35)
VS0(33,36)=QCx*VS0(33,21)+WQx*VS1(33,21)&
   +4D0*r1x2E*(VS0(33,11)-ZxZpE*VS1(33,11))&
   +HfxZpE*VS1(20,21)
VS0(33,37)=QCx*VS0(33,22)+WQx*VS1(33,22)&
   +3D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))&
   +HfxZpE*VS1(20,22)
VS0(33,38)=QCx*VS0(33,23)+WQx*VS1(33,23)&
   +2D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))&
   +HfxZpE*VS1(20,23)
VS0(33,39)=QCy*VS0(33,23)+WQy*VS1(33,23)&
   +2D0*r1x2E*(VS0(33,12)-ZxZpE*VS1(33,12))
VS0(33,40)=QCy*VS0(33,24)+WQy*VS1(33,24)&
   +3D0*r1x2E*(VS0(33,13)-ZxZpE*VS1(33,13))
VS0(33,41)=QCy*VS0(33,25)+WQy*VS1(33,25)&
   +4D0*r1x2E*(VS0(33,14)-ZxZpE*VS1(33,14))
VS0(33,42)=QCx*VS0(33,26)+WQx*VS1(33,26)&
   +3D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +HfxZpE*VS1(20,26)
VS0(33,43)=QCx*VS0(33,27)+WQx*VS1(33,27)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +HfxZpE*VS1(20,27)
VS0(33,44)=QCx*VS0(33,28)+WQx*VS1(33,28)&
   +r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +HfxZpE*VS1(20,28)
VS0(33,45)=QCy*VS0(33,28)+WQy*VS1(33,28)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))
VS0(33,46)=QCy*VS0(33,29)+WQy*VS1(33,29)&
   +3D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))
VS0(33,47)=QCx*VS0(33,30)+WQx*VS1(33,30)&
   +2D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +HfxZpE*VS1(20,30)
VS0(33,48)=QCx*VS0(33,31)+WQx*VS1(33,31)&
   +r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +HfxZpE*VS1(20,31)
VS0(33,49)=QCy*VS0(33,31)+WQy*VS1(33,31)&
   +r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))
VS0(33,50)=QCy*VS0(33,32)+WQy*VS1(33,32)&
   +2D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))
VS0(33,51)=QCz*VS0(33,30)+WQz*VS1(33,30)-r1x2E*VR1(33,30)&
   +2D0*r1x2E*(VS0(33,15)-ZxZpE*VS1(33,15))&
   +3D0*HfxZpE*VS1(18,30)
VS0(33,52)=QCz*VS0(33,31)+WQz*VS1(33,31)-r1x2E*VR1(33,31)&
   +2D0*r1x2E*(VS0(33,16)-ZxZpE*VS1(33,16))&
   +3D0*HfxZpE*VS1(18,31)
VS0(33,53)=QCz*VS0(33,32)+WQz*VS1(33,32)-r1x2E*VR1(33,32)&
   +2D0*r1x2E*(VS0(33,17)-ZxZpE*VS1(33,17))&
   +3D0*HfxZpE*VS1(18,32)
VS0(33,54)=QCz*VS0(33,33)+WQz*VS1(33,33)-r1x2E*VR1(33,33)&
   +3D0*r1x2E*(VS0(33,18)-ZxZpE*VS1(33,18))&
   +3D0*HfxZpE*VS1(18,33)
VS0(33,55)=QCz*VS0(33,34)+WQz*VS1(33,34)-r1x2E*VR1(33,34)&
   +3D0*r1x2E*(VS0(33,19)-ZxZpE*VS1(33,19))&
   +3D0*HfxZpE*VS1(18,34)
VS0(33,56)=QCz*VS0(33,35)+WQz*VS1(33,35)-r1x2E*VR1(33,35)&
   +4D0*r1x2E*(VS0(33,20)-ZxZpE*VS1(33,20))&
   +3D0*HfxZpE*VS1(18,35)
VS0(34,36)=QCx*VS0(34,21)+WQx*VS1(34,21)&
   +4D0*r1x2E*(VS0(34,11)-ZxZpE*VS1(34,11))
VS0(34,37)=QCx*VS0(34,22)+WQx*VS1(34,22)&
   +3D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))
VS0(34,38)=QCx*VS0(34,23)+WQx*VS1(34,23)&
   +2D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))
VS0(34,39)=QCy*VS0(34,23)+WQy*VS1(34,23)&
   +2D0*r1x2E*(VS0(34,12)-ZxZpE*VS1(34,12))&
   +HfxZpE*VS1(20,23)
VS0(34,40)=QCy*VS0(34,24)+WQy*VS1(34,24)&
   +3D0*r1x2E*(VS0(34,13)-ZxZpE*VS1(34,13))&
   +HfxZpE*VS1(20,24)
VS0(34,41)=QCy*VS0(34,25)+WQy*VS1(34,25)&
   +4D0*r1x2E*(VS0(34,14)-ZxZpE*VS1(34,14))&
   +HfxZpE*VS1(20,25)
VS0(34,42)=QCx*VS0(34,26)+WQx*VS1(34,26)&
   +3D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))
VS0(34,43)=QCx*VS0(34,27)+WQx*VS1(34,27)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))
VS0(34,44)=QCx*VS0(34,28)+WQx*VS1(34,28)&
   +r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))
VS0(34,45)=QCy*VS0(34,28)+WQy*VS1(34,28)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +HfxZpE*VS1(20,28)
VS0(34,46)=QCy*VS0(34,29)+WQy*VS1(34,29)&
   +3D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +HfxZpE*VS1(20,29)
VS0(34,47)=QCx*VS0(34,30)+WQx*VS1(34,30)&
   +2D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))
VS0(34,48)=QCx*VS0(34,31)+WQx*VS1(34,31)&
   +r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))
VS0(34,49)=QCy*VS0(34,31)+WQy*VS1(34,31)&
   +r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +HfxZpE*VS1(20,31)
VS0(34,50)=QCy*VS0(34,32)+WQy*VS1(34,32)&
   +2D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +HfxZpE*VS1(20,32)
VS0(34,51)=QCz*VS0(34,30)+WQz*VS1(34,30)-r1x2E*VR1(34,30)&
   +2D0*r1x2E*(VS0(34,15)-ZxZpE*VS1(34,15))&
   +3D0*HfxZpE*VS1(19,30)
VS0(34,52)=QCz*VS0(34,31)+WQz*VS1(34,31)-r1x2E*VR1(34,31)&
   +2D0*r1x2E*(VS0(34,16)-ZxZpE*VS1(34,16))&
   +3D0*HfxZpE*VS1(19,31)
VS0(34,53)=QCz*VS0(34,32)+WQz*VS1(34,32)-r1x2E*VR1(34,32)&
   +2D0*r1x2E*(VS0(34,17)-ZxZpE*VS1(34,17))&
   +3D0*HfxZpE*VS1(19,32)
VS0(34,54)=QCz*VS0(34,33)+WQz*VS1(34,33)-r1x2E*VR1(34,33)&
   +3D0*r1x2E*(VS0(34,18)-ZxZpE*VS1(34,18))&
   +3D0*HfxZpE*VS1(19,33)
VS0(34,55)=QCz*VS0(34,34)+WQz*VS1(34,34)-r1x2E*VR1(34,34)&
   +3D0*r1x2E*(VS0(34,19)-ZxZpE*VS1(34,19))&
   +3D0*HfxZpE*VS1(19,34)
VS0(34,56)=QCz*VS0(34,35)+WQz*VS1(34,35)-r1x2E*VR1(34,35)&
   +4D0*r1x2E*(VS0(34,20)-ZxZpE*VS1(34,20))&
   +3D0*HfxZpE*VS1(19,35)
VS0(35,36)=QCx*VS0(35,21)+WQx*VS1(35,21)&
   +4D0*r1x2E*(VS0(35,11)-ZxZpE*VS1(35,11))
VS0(35,37)=QCx*VS0(35,22)+WQx*VS1(35,22)&
   +3D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,38)=QCx*VS0(35,23)+WQx*VS1(35,23)&
   +2D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,39)=QCy*VS0(35,23)+WQy*VS1(35,23)&
   +2D0*r1x2E*(VS0(35,12)-ZxZpE*VS1(35,12))
VS0(35,40)=QCy*VS0(35,24)+WQy*VS1(35,24)&
   +3D0*r1x2E*(VS0(35,13)-ZxZpE*VS1(35,13))
VS0(35,41)=QCy*VS0(35,25)+WQy*VS1(35,25)&
   +4D0*r1x2E*(VS0(35,14)-ZxZpE*VS1(35,14))
VS0(35,42)=QCx*VS0(35,26)+WQx*VS1(35,26)&
   +3D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))
VS0(35,43)=QCx*VS0(35,27)+WQx*VS1(35,27)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,44)=QCx*VS0(35,28)+WQx*VS1(35,28)&
   +r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,45)=QCy*VS0(35,28)+WQy*VS1(35,28)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))
VS0(35,46)=QCy*VS0(35,29)+WQy*VS1(35,29)&
   +3D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))
VS0(35,47)=QCx*VS0(35,30)+WQx*VS1(35,30)&
   +2D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,48)=QCx*VS0(35,31)+WQx*VS1(35,31)&
   +r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,49)=QCy*VS0(35,31)+WQy*VS1(35,31)&
   +r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))
VS0(35,50)=QCy*VS0(35,32)+WQy*VS1(35,32)&
   +2D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))
VS0(35,51)=QCz*VS0(35,30)+WQz*VS1(35,30)-r1x2E*VR1(35,30)&
   +2D0*r1x2E*(VS0(35,15)-ZxZpE*VS1(35,15))&
   +4D0*HfxZpE*VS1(20,30)
VS0(35,52)=QCz*VS0(35,31)+WQz*VS1(35,31)-r1x2E*VR1(35,31)&
   +2D0*r1x2E*(VS0(35,16)-ZxZpE*VS1(35,16))&
   +4D0*HfxZpE*VS1(20,31)
VS0(35,53)=QCz*VS0(35,32)+WQz*VS1(35,32)-r1x2E*VR1(35,32)&
   +2D0*r1x2E*(VS0(35,17)-ZxZpE*VS1(35,17))&
   +4D0*HfxZpE*VS1(20,32)
VS0(35,54)=QCz*VS0(35,33)+WQz*VS1(35,33)-r1x2E*VR1(35,33)&
   +3D0*r1x2E*(VS0(35,18)-ZxZpE*VS1(35,18))&
   +4D0*HfxZpE*VS1(20,33)
VS0(35,55)=QCz*VS0(35,34)+WQz*VS1(35,34)-r1x2E*VR1(35,34)&
   +3D0*r1x2E*(VS0(35,19)-ZxZpE*VS1(35,19))&
   +4D0*HfxZpE*VS1(20,34)
VS0(35,56)=QCz*VS0(35,35)+WQz*VS1(35,35)-r1x2E*VR1(35,35)&
   +4D0*r1x2E*(VS0(35,20)-ZxZpE*VS1(35,20))&
   +4D0*HfxZpE*VS1(20,35)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0h0'
STOP
END SELECT
END SUBROUTINE MVRRg0h0
