// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "mytrack.h"
#include <XL/xl.h>
#include <GL/gl.h>
#include <ode/ode.h>
#include "id.h"

typedef struct
{
	unsigned int textures;
	unsigned int mesh;
	dTriMeshDataID data;
	dGeomID geom;
} TRACK;

#define STORE ID_SMALL_STORE

static TRACK *store[STORE];

void
myTrackCreateContext(void)
{
	idClearStore(TRACK, STORE, store);
}

static
void
Init(TRACK *track)
{
	xlGenMeshes(1, &track->mesh);
	xlGenGroups(1, &track->textures);
}

static
void
Term(TRACK *track)
{
	xlDeleteGroups(1, &track->textures);
	xlDeleteMeshes(1, &track->mesh);
}

void
myGenTracks(unsigned int n, unsigned int *tracks)
{
	idGenObjects(TRACK, STORE, store, Init, n, tracks);
}

void
myDeleteTracks(unsigned int n, unsigned int *tracks)
{
	idDeleteObjects(store, Term, n, tracks);
}

void
myTrackLoad(unsigned int id, unsigned int name, dSpaceID space)
{
	unsigned int strings[3];
	TRACK *track;

	track = store[id];

	xlGenStrings(3, strings);

	xlStringLoad(strings[0], PACKAGE_DATADIR);

	xlStringConcatPath2(strings[2], strings[0], name);
	xlMeshLoad(track->mesh, strings[2]);

	xlStringUnload(strings[2]);

	xlStringLoad(strings[1], "textures");
	xlStringConcatPath(strings[2], 2, strings);
	xlMeshGenTextures(track->mesh, strings[2], track->textures);

	xlStringsUnload(3, strings);

	track->data = dGeomTriMeshDataCreate();
	xlMeshTriMeshDataBuild(track->mesh, track->data);
	track->geom = dCreateTriMesh(space, track->data, NULL, NULL, NULL);

	xlDeleteStrings(3, strings);

}

void
myTrackUnload(unsigned int id)
{
	TRACK *track;

	track = store[id];

	dGeomDestroy(track->geom);
	dGeomTriMeshDataDestroy(track->data);

	glDeleteTextures(xlGroupLength(track->textures), xlGroupArray(track->textures));
	xlGroupUnload(track->textures);

	xlMeshUnload(track->mesh);
}

void
myTracksUnload(unsigned int n, unsigned int *tracks)
{
	unsigned int i;

	for(i = 0; i < n; i++) myTrackUnload(tracks[i]);
}

void
myTrackFrame(unsigned int id, unsigned int frustum)
{
	TRACK *track;

	track = store[id];

	xlMeshFrustumDraw(track->mesh, track->textures, frustum);
}
