// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MY_MACHINE_H
#define MY_MACHINE_H

#include <ode/ode.h>

void
myMachineCreateContext(void);

void
myGenMachines(unsigned int n, unsigned int *strings);

void
myDeleteMachines(unsigned int n, unsigned int *strings);

void
myMachineLoad(unsigned int id, unsigned int name, dWorldID world, dSpaceID space, const float *position);

void
myMachineUnload(unsigned int id);

void
myMachinesUnload(unsigned int n, unsigned int *machines);

void
myMachineFrame(unsigned int id);

void
myMachineEnable(unsigned int id);

void
myMachineDisable(unsigned int id);

int
myMachineIsEnabled(unsigned int id);

void
myMachinePause(unsigned int id);

void
myMachinePlay(unsigned int id);

const float *
myMachineGetPosition(unsigned int id);

const float *
myMachineGetRotation(unsigned int id);

const float *
myMachineGetLinearVel(unsigned int id);

void
myMachineDrive(unsigned int id, int up, int down, int left, int right, int turbo);

void
myMachinePlace(unsigned int id, const float *position, const float *rotation);

#endif
