// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MY_GADGET_H
#define MY_GADGET_H

#include <ode/ode.h>

enum
{
	MY_GADGET_CUBE,
	MY_GADGET_TURBO,
	MY_GADGET_FAKE
};

void
myGadgetCreateContext(void);

void
myGenGadgets(unsigned int n, unsigned int *gadgets);

void
myDeleteGadgets(unsigned int n, unsigned int *gadgets);

void
myGadgetLoadCube(unsigned int id, dWorldID world, dSpaceID space);

void
myGadgetLoadTurbo(unsigned int id);

void
myGadgetLoadFake(unsigned int id);

void
myGadgetUnload(unsigned int id);

void
myGadgetsUnload(unsigned int n, unsigned int *gadgets);

unsigned int
myGadgetType(unsigned int id);

void
myGadgetFrame(unsigned int id);

void
myGadgetEnable(unsigned int id);

void
myGadgetDisable(unsigned int id);

void
myGadgetPlace(unsigned int id, const float *position);

#endif
