// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "mycheckpoints.h"
#include <XL/xl.h>
#include "id.h"

typedef struct
{
	int magic;
	unsigned int checkpoints;
} CHECKPOINTSheader;

typedef struct
{
	float *data;
	unsigned int length;
} CHECKPOINTS;

#define STORE ID_SMALL_STORE

static CHECKPOINTS *store[STORE];

void
myCheckPointsCreateContext(void)
{
	idClearStore(CHECKPOINTS, STORE, store);
}

static
void
Init(CHECKPOINTS *checkpoints)
{
}

static
void
Term(CHECKPOINTS *checkpoints)
{
}

void
myGenCheckPointss(unsigned int n, unsigned int *checkpointss)
{
	idGenObjects(CHECKPOINTS, STORE, store, Init, n, checkpointss);
}

void
myDeleteCheckPointss(unsigned int n, unsigned int *checkpointss)
{
	idDeleteObjects(store, Term, n, checkpointss);
}

void
myCheckPointsLoad(unsigned int id, unsigned int pathname)
{
	FILE *stream;
	stream = fopen(xlStringData(pathname), "rb");
	if(stream)
	{
		CHECKPOINTSheader header;
		CHECKPOINTS *checkpoints;

		checkpoints = store[id];

		fread(&header, 1, sizeof(CHECKPOINTSheader), stream);
		checkpoints->length = header.checkpoints;
		checkpoints->data = malloc(header.checkpoints * 3 * sizeof(float));
		fread(checkpoints->data, 1, header.checkpoints * 3 * sizeof(float), stream);
		fclose(stream);
	}
//	else myErrorSet(MY_INVALID);
}

void
myCheckPointsSave(unsigned int id, unsigned int pathname)
{
	FILE *stream;

	stream = fopen(xlStringData(pathname), "wb");
	if(stream)
	{
		CHECKPOINTSheader header;
		CHECKPOINTS *checkpoints;

		checkpoints = store[id];

		header.checkpoints = checkpoints->length;

		fwrite(&header, 1, sizeof(CHECKPOINTSheader), stream);
		fwrite(checkpoints->data, 1, header.checkpoints * 3 * sizeof(float), stream);
		fclose(stream);
	}
//	else myErrorSet(MY_INVALID);
}

void
myCheckPointsCompile(unsigned int id, unsigned int pathname)
{
	FILE *stream;
	stream = fopen(xlStringData(pathname), "r");
	if(stream)
	{
		unsigned int i;
		char buffer[256];
		CHECKPOINTS *checkpoints;

		checkpoints = store[id];

		fgets(buffer, 256, stream);
		//sscanf(buffer, "checkpoints %i", &info.ncheckpoints);
		sscanf(buffer, "length %i", &checkpoints->length);
		checkpoints->data = malloc(checkpoints->length * 3 * sizeof(float));
		for(i = 0; i < checkpoints->length; i++)
		{
			fgets(buffer, 256, stream);
			//sscanf(buffer, "coord %f %f %f", &checkpoints->data[i * 3], &checkpoints->data[i * 3 + 1], &checkpoints->data[i * 3 + 2]);
			sscanf(buffer, "(%f, %f, %f)", &checkpoints->data[i * 3], &checkpoints->data[i * 3 + 1], &checkpoints->data[i * 3 + 2]);
		}

		fclose(stream);
	}
//	else myErrorSet(MY_INVALID);
}

void
myCheckPointsDecompile(unsigned int id, unsigned int pathname)
{
	FILE *stream;

	stream = fopen(xlStringData(pathname), "w");
	if(stream)
	{
		unsigned int i;
		CHECKPOINTS *checkpoints;

		checkpoints = store[id];

		fprintf(stream, "checkpoints %i\n", checkpoints->length);
		for(i = 0; i < checkpoints->length; i++)
			fprintf(stream, "coord %f %f %f\n", checkpoints->data[i * 3], checkpoints->data[i * 3 + 1], checkpoints->data[i * 3 + 2]);

		fclose(stream);
	}
//	else myErrorSet(MY_INVALID);
}

void
myCheckPointsUnload(unsigned int id)
{
	CHECKPOINTS *checkpoints;

	checkpoints = store[id];
	
	free(checkpoints->data);
}

void
myCheckPointssUnload(unsigned int n, unsigned int *checkpointss)
{
	unsigned int i;

	for(i = 0; i < n; i++)
		myCheckPointsUnload(checkpointss[i]);
}

const float *
myCheckPointsCheckPoint(unsigned int id, unsigned int i)
{
	CHECKPOINTS *checkpoints;

	checkpoints = store[id];
	
	return &checkpoints->data[i * 3];
}

unsigned int
myCheckPointsLength(unsigned int id)
{
	CHECKPOINTS *checkpoints;

	checkpoints = store[id];

	return checkpoints->length;
}

