// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include <stdlib.h>
#include <XL/xl.h>

int
main(int argc, char **argv)
{
	int result;

	if(argc == 3)
	{
		unsigned int string;
		unsigned int mesh;

		xlGenStrings(1, &string);

		xlGenMeshes(1, &mesh);

		xlStringLoad(string, argv[1]);
		xlMeshLoad(mesh, string);
		xlStringUnload(string);

		xlStringLoad(string, argv[2]);
		xlMeshDecompile(mesh, string);
		xlStringUnload(string);

		xlMeshUnload(mesh);

		xlDeleteMeshes(1, &mesh);

		xlDeleteStrings(1, &string);

		result = xlErrorGet() == XL_NONE ? EXIT_SUCCESS : EXIT_FAILURE;
	}
	else result = EXIT_FAILURE;
	return result;
}
