// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "XL/string.h"
#include "XL/group.h"
#include "XL/xl.h"
#include <string.h>
#include <stdio.h>
#include "id.h"

typedef struct
{
	char *data;
	unsigned int length;
} STRING;

#define STORE ID_MEDIUM_STORE

static STRING *store[STORE];

void
xlStringCreateContext(void)
{
	idClearStore(STRING, STORE, store);
}

static
void
Init(STRING *string)
{
}

static
void
Term(STRING *string)
{
}

void
xlGenStrings(unsigned int n, unsigned int *strings)
{
	idGenObjects(STRING, STORE, store, Init, n, strings);
}

void
xlDeleteStrings(unsigned int n, unsigned int *strings)
{
	idDeleteObjects(store, Term, n, strings);
}

void
xlStringLoad(unsigned int id, const char *data)
{
	STRING *string;

	string = store[id];

	string->data = strdup(data),
	string->length = strlen(data);
}

void
xlStringUnload(unsigned int id)
{
	STRING *string;

	string = store[id];
	
	free(string->data);
}

void
xlStringsUnload(unsigned int n, unsigned int *strings)
{
	unsigned int i;

	for(i = 0; i < n; i++) xlStringUnload(strings[i]);
}

const char *
xlStringData(unsigned int id)
{
	STRING *string;

	string = store[id];
	
	return string->data;
}

unsigned int
xlStringLength(unsigned int id)
{
	STRING *string;

	string = store[id];

	return string->length;
}

void
xlStringConcat(unsigned int id, unsigned int n, unsigned int *strings)
{
	unsigned int i;
	STRING *string;

	string = store[id];

	for(string->length = 1, i = 0; i < n; string->length += xlStringLength(strings[i]), i++);
	string->data = malloc(string->length * sizeof(char));
	for(strcpy(string->data, xlStringData(strings[0])), i = 1; i < n; strcat(string->data, xlStringData(strings[i])), i++);
}

void
xlStringConcat2(unsigned int id, unsigned int a, unsigned int b)
{
	unsigned int strings[2] = { a, b };
	xlStringConcat(id, 2, strings);
}

void
xlStringConcatPath(unsigned int id, unsigned int n, unsigned int *strings)
{
	unsigned int i;
	STRING *string;

	string = store[id];

	for(string->length = n, i = 0; i < n; string->length += xlStringLength(strings[i]), i++);
	string->data = malloc(string->length * sizeof(char));
	for(strcpy(string->data, xlStringData(strings[0])), i = 1; i < n; strcat(string->data, XL_STRING_PATH_SEPARATOR), strcat(string->data, xlStringData(strings[i])), i++);
}

void
xlStringConcatPath2(unsigned int id, unsigned int a, unsigned int b)
{
	unsigned int strings[2] = { a, b };
	xlStringConcatPath(id, 2, strings);
}
