// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "XL/sound.h"
#include "XL/error.h"
#include "XL/math.h"
#include "XL/string.h"
#include "XL/xl.h"
#include <stdio.h>
#include <vorbis/vorbisfile.h>
#include "id.h"

typedef struct
{
	unsigned int rate;
	unsigned int channels;
	unsigned int frames;
	short *samples;
} SOUND;

#define STORE ID_MEDIUM_STORE

static SOUND *store[STORE];

void
xlSoundCreateContext(void)
{
	idClearStore(SOUND, STORE, store);
}

static
void
Init(SOUND *sound)
{
}

static
void
Term(SOUND *sound)
{
}

void
xlGenSounds(unsigned int n, unsigned int *sounds)
{
	idGenObjects(SOUND, STORE, store, Init, n, sounds);
}

void
xlDeleteSounds(unsigned int n, unsigned int *sounds)
{
	idDeleteObjects(store, Term, n, sounds);
}

void
xlSoundLoadVORBIS(unsigned int id, unsigned int pathname)
{
	FILE *stream;

	stream = fopen(xlStringData(pathname), "rb");
	if(stream)
	{
		OggVorbis_File ogg;

		if(ov_open(stream, &ogg, NULL, 0) == 0)
		{
			int bitstream;
			unsigned int bytes, read;
			vorbis_info *vorbis;
			SOUND *sound;

			sound = store[id];

			vorbis = ov_info(&ogg, -1);
			sound->rate = vorbis->rate;
			sound->channels = vorbis->channels;
			sound->frames = ov_pcm_total(&ogg, -1);
			sound->samples = malloc(sound->frames * sound->channels * sizeof(short));
			read = 0;
			do
			{
				bytes = ov_read(&ogg, (char*) sound->samples + read, sound->frames * sound->channels * sizeof(short) - read, 0, 2, 1, &bitstream);
				read += bytes;
			}	
			while(read < sound->frames * sound->channels * sizeof(short) && bytes > 0);
			ov_clear(&ogg);
		}
		else
		{
			xlErrorSet(XL_INVALID);
			fclose(stream);
		}
	}
	else xlErrorSet(XL_INVALID);
}

void
xlSoundUnload(unsigned int id)
{
	SOUND *sound;

	sound = store[id];

	free(sound->samples);
}

void
xlSoundsUnload(unsigned int n, unsigned int *sounds)
{
	unsigned int i;

	for(i = 0; i < n; i++) xlSoundUnload(sounds[i]);
}

static
ALenum
Format(unsigned int channels)
{
	ALenum format;

	switch(channels)
	{
		case 1: format = AL_FORMAT_MONO16; break;
		case 2: format = AL_FORMAT_STEREO16; break;
		default: xlErrorSet(XL_INVALID); break;
	}
	return format;
}

void
xlSoundBufferData(unsigned int id, ALuint buffer)
{
	SOUND *sound;

	sound = store[id];

	alBufferData(buffer, Format(sound->channels), sound->samples, sound->frames * sound->channels * sizeof(short), sound->rate);
}
