#ifndef ID_H
#define ID_H

#include <stdlib.h>
#include <string.h>

#define ID_SMALL_STORE 32
#define ID_MEDIUM_STORE 256
#define ID_LARGE_STORE 1024
#define ID_EXTRA_LARGE_STORE 4096

#define idClearStore(type, size, store) memset(store, 0, size * sizeof(type *))

#define idGenObjects(type, size, store, initializer, n, objects) \
	{ \
		unsigned int generated = 0; \
		unsigned int i; \
		for(i = 0; i < size && generated < n; i++) \
		{ \
			if(!store[i]) \
			{ \
				store[i] = malloc(sizeof(type)); \
				initializer(store[i]); \
				objects[generated++] = i; \
			} \
		} \
	}

#define idDeleteObjects(store, terminator, n, objects) \
	{ \
		unsigned int i; \
		for(i = 0; i < n; i++) \
		{ \
			terminator(store[objects[i]]); \
			free(store[objects[i]]); \
			store[objects[i]] = NULL; \
		} \
	}

#endif
