// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "XL/helper.h"

void
xlMatrixToODERotation(const float *matrix, float *rotation)
{
	rotation[0] = matrix[0]; rotation[1] = matrix[4]; rotation[2] = matrix[8];
	rotation[4] = matrix[1]; rotation[5] = matrix[5]; rotation[6] = matrix[9];
	rotation[8] = matrix[2]; rotation[9] = matrix[6]; rotation[10] = matrix[10];
}

void
xlMatrixFromODESituation(const float *position, const float *rotation, float *matrix)
{
	matrix[0] = rotation[0]; matrix[4] = rotation[1]; matrix[8] = rotation[2]; matrix[12] = position[0];
	matrix[1] = rotation[4]; matrix[5] = rotation[5]; matrix[9] = rotation[6]; matrix[13] = position[1];
	matrix[2] = rotation[8]; matrix[6] = rotation[9]; matrix[10] = rotation[10]; matrix[14] = position[2];
	matrix[3] = 0.0f; matrix[7] = 0.0f; matrix[11] = 0.0f; matrix[15] = 1.0f;
}
