// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "XL/group.h"
#include "id.h"

typedef struct
{
	void *array;
	unsigned int length;
	unsigned int size;
} GROUP;

#define STORE ID_LARGE_STORE

static GROUP *store[STORE];

void
xlGroupCreateContext(void)
{
	idClearStore(GROUP, STORE, store);
}

static
void
Init(GROUP *group)
{
}

static
void
Term(GROUP *group)
{
}

void
xlGenGroups(unsigned int n, unsigned int *groups)
{
	idGenObjects(GROUP, STORE, store, Init, n, groups);
}

void
xlDeleteGroups(unsigned int n, unsigned int *groups)
{
	idDeleteObjects(store, Term, n, groups);
}

void
xlGroupSet(unsigned int id, void *array, unsigned int length)
{
	GROUP *group;

	group = store[id];

	group->array = array;
	group->length = length;
}

void
xlGroupUnload(unsigned int id)
{
	GROUP *group;

	group = store[id];
	
	free(group->array);
}

void
xlGroupsUnload(unsigned int n, unsigned int *groups)
{
	unsigned int i;

	for(i = 0; i < n; i++)
		xlGroupUnload(groups[i]);
}

void *
xlGroupArray(unsigned int id)
{
	GROUP *group;

	group = store[id];

	return group->array;
}

unsigned int
xlGroupLength(unsigned int id)
{
	GROUP *group;

	group = store[id];

	return group->length;
}

void
xlGroupAllocate(unsigned int id, unsigned int n, unsigned int size)
{
	GROUP *group;

	group = store[id];

	group->array = malloc(n * size);
	group->length = n;
	group->size = size;
}

void
xlGroupRead(unsigned int id, unsigned int n, unsigned int size, FILE *stream)
{
	GROUP *group;

	group = store[id];

	group->array = malloc(n * size);
	group->length = n;
	group->size = size;

	fread(group->array, 1, group->length * group->size, stream);
}

void
xlGroupWrite(unsigned int id, FILE *stream)
{
	GROUP *group;

	group = store[id];

	fwrite(group->array, 1, group->length * group->size, stream);
}
