// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef XL_MESH_H
#define XL_MESH_H

#include <ode/ode.h>

void
xlMeshCreateContext(void);

void
xlGenMeshes(unsigned int n, unsigned int *meshes);

void
xlDeleteMeshes(unsigned int n, unsigned int *meshes);

void
xlMeshLoad(unsigned int id, unsigned int pathname);

void
xlMeshSave(unsigned int id, unsigned int pathname);

void
xlMeshCompile(unsigned int id, unsigned int pathname);

void
xlMeshDecompile(unsigned int id, unsigned int pathname);

void
xlMeshUnload(unsigned int id);

void
xlMeshesUnload(unsigned int n, unsigned int *meshes);

void
xlMeshGenTextures(unsigned int id, unsigned int path, unsigned int textures);

void
xlMeshTriMeshDataBuild(unsigned int id, dTriMeshDataID data);

void
xlMeshDraw(unsigned int id, unsigned int textures);

void
xlMeshFrustumDraw(unsigned int id, unsigned int textures, unsigned int frustum);

#endif
