// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef XL_MATH_H
#define XL_MATH_H

extern const float xlPi;

float
xlRadToDeg(float r);

float
xlDegToRad(float r);

unsigned int
xlNextTwoPower(float x);

float
xlClamp(float x, float a, float b);

float
xlMax(float a, float b);

extern const float xlPointZero[3];

void
xlPointPrint(const float *a);

void
xlPointCopy(const float *a, float *result);

void
xlPointLoad(float *a, float x, float y, float z);

void
xlPointLoadZero(float *a);

void
xlPointAdd(const float *a, const float *b, float *result);

void
xlPointAddInPlace(float *a, const float *b);

void
xlPointSub(const float *a, const float *b, float *result);

void
xlPointSubInPlace(float *a, const float *b);

extern const float xlVectorX[3];
extern const float xlVectorY[3];
extern const float xlVectorZ[3];
extern const float xlVectorNegX[3];
extern const float xlVectorNegY[3];
extern const float xlVectorNegZ[3];

void
xlVectorPrint(const float *a);

void
xlVectorCopy(const float *a, float *result);

void
xlVectorLoad(float *a, float x, float y, float z);

void
xlVectorLoadX(float *a);

void
xlVectorLoadY(float *a);

void
xlVectorLoadZ(float *a);

void
xlVectorLoadNegX(float *a);

void
xlVectorLoadNegY(float *a);

void
xlVectorLoadNegZ(float *a);

void
xlVectorAdd(const float *a, const float *b, float *result);

void
xlVectorAddInPlace(float *a, const float *b);

void
xlVectorSub(const float *a, const float *b, float *result);

void
xlVectorSubInPlace(float *a, const float *b);

void
xlVectorScalarProduct(const float *a, float b, float *result);

void
xlVectorScalarProductInPlace(float *a, float b);

void
xlVectorNorm(const float *a, float *result);

float
xlVectorNormFunc(const float *a);

void
xlVectorDotProduct(const float *a, const float *b, float *result);

float
xlVectorDotProductFunc(const float *a, const float *b);

void
xlVectorCrossProduct(const float *a, const float *b, float *result);

void
xlVectorCrossProductInPlace(float *a, const float *b);

void
xlVectorNormal(const float *a, float *result);

void
xlVectorNormalInPlace(float *a);

void
xlVectorMatrixProduct(const float *a, const float *b, float *result);

void
xlVectorMatrixProductInPlace(float *a, const float *b);

void
xlVectorRotate(const float *a, const float *axis, float angle, float *result);

void
xlVectorRotateInPlace(float *a, const float *axis, float angle);

void
xlVectorAngle(const float *a, const float *b, float *angle);

float
xlVectorAngleFunc(const float *a, const float *b);

extern const float xlMatrixIdentity[16];

void
xlMatrixPrint(const float *a);

void
xlMatrixCopy(const float *a, float *result);

void
xlMatrixLoad(float *x, float a, float b, float c, float d, float e, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p);

void
xlMatrixLoadIdentity(float *a);

void
xlMatrixAdd(const float *a, const float *b, float *result);

void
xlMatrixAddInPlace(float *a, const float *b);

void
xlMatrixSub(const float *a, const float *b, float *result);

void
xlMatrixSubInPlace(float *a, const float *b);

void
xlMatrixScalarProduct(const float *a, float b, float *result);

void
xlMatrixScalarProductInPlace(float *a, float b);

void
xlMatrixProduct(const float *a, const float *b, float *result);

void
xlMatrixProductInPlace(float *a, const float *b);

void
xlMatrixVectorProduct(const float *a, const float *b, float *result);

void
xlMatrixVectorProductInPlace(const float *a, float *b);

void
xlMatrixTranspose(const float *a, float *result);

void
xlMatrixTransposeInPlace(float *a);

void
xlMatrixScale(const float *a, const float *b, float *result);

void
xlMatrixScaleInPlace(float *a, const float *b);

void
xlMatrixRotate(const float *a, const float *axis, float angle, float *result);

void
xlMatrixRotateInPlace(float *a, const float *axis, float angle);

void
xlMatrixTranslate(const float *a, const float *b, float *result);

void
xlMatrixTranslateInPlace(float *a, const float *b);

void
xlMatrixLook(const float *position, const float *forward, const float *up, float *result);

void
xlMatrixLookAt(const float *eye, const float *center, const float *up, float *result);

void
xlMatrixRotation(const float *forward, const float *up, float *result);

void
xlMatrixGetPosition(const float *a, float *result);

void
xlMatrixGetRight(const float *a, float *result);

void
xlMatrixGetUp(const float *a, float *result);

void
xlMatrixGetForward(const float *a, float *result);

void
xlTrianglePrint(const float *a);

void
xlTriangleCopy(const float *a, float *result);

void
xlTriangleGetBoundSphere(const float *a, float *result);

void
xlSpherePrint(const float *a);

void
xlSphereCopy(const float *a, float *result);

void
xlSphereLoad(float *a, float x, float y, float z, float r);

void
xlSphereMerge(const float *a, const float *b, float *result);

void
xlSphereMergeInPlace(float *a, const float *b);

#endif
