// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef XL_IMAGE_H
#define XL_IMAGE_H

#include <GL/gl.h>

void
xlImageCreateContext(void);

void
xlGenImages(unsigned int n, unsigned int *images);

void
xlDeleteImages(unsigned int n, unsigned int *images);

void
xlImageLoadPNG(unsigned int id, unsigned int pathname);

void
xlImageSavePNG(unsigned int id, unsigned int pathname);

void
xlImageLoadJPEG(unsigned int id, unsigned int pathname);

void
xlImageSaveJPEG(unsigned int id, unsigned int pathname);

void
xlImageLoadTGA(unsigned int id, unsigned int pathname);

void
xlImageSaveTGA(unsigned int id, unsigned int pathname);

void
xlImageLoadNAME(unsigned int id, unsigned int pathname);

void
xlImageCapture(unsigned int id, int x, int y, unsigned int width, unsigned int height, GLenum format);

void
xlImageUnload(unsigned int id);

void
xlImagesUnload(unsigned int n, unsigned int *images);

void
xlImageBuild2DMipmaps(unsigned int id);

void
xlImageTexImage2D(unsigned int id);

#endif
