// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef XL_GROUP_H
#define XL_GROUP_H

#include <stdio.h>

void
xlGroupCreateContext(void);

void
xlGenGroups(unsigned int n, unsigned int *groups);

void
xlDeleteGroups(unsigned int n, unsigned int *groups);

void
xlGroupSet(unsigned int id, void *array, unsigned int length);

void
xlGroupUnload(unsigned int id);

void
xlGroupsUnload(unsigned int n, unsigned int *groups);

void *
xlGroupArray(unsigned int id);

unsigned int
xlGroupLength(unsigned int id);

void
xlGroupAllocate(unsigned int id, unsigned int n, unsigned int size);

void
xlGroupRead(unsigned int id, unsigned int n, unsigned int size, FILE *stream);

void
xlGroupWrite(unsigned int id, FILE *stream);

#endif
