// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef XL_FRUSTUM_H
#define XL_FRUSTUM_H

void
xlFrustumCreateContext(void);

void
xlGenFrustums(unsigned int n, unsigned int *frustums);

void
xlDeleteFrustums(unsigned int n, unsigned int *frustums);

void
xlFrustumCalc(unsigned int id);

int
xlFrustumPoint(unsigned int id, const float *point);

int
xlFrustumSphere(unsigned int id, const float *sphere);

int
xlFrustumTriangle(unsigned int id, const float *triangle);

int
xlFrustumCube(unsigned int id, const float *cube);

int
xlFrustumPolygon(unsigned int id, const float *points, unsigned int npoints);

#endif
