// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MY_MACHINES_H
#define MY_MACHINES_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MY_TYPE_MACHINES (my_machines_get_type ())
#define MY_MACHINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MY_TYPE_MACHINES, MyMachines))
#define MY_IS_MACHINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MY_TYPE_MACHINES))
#define MY_MACHINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MY_TYPE_MACHINES, MyMachinesClass))
#define MY_IS_MACHINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MY_TYPE_MACHINES))
#define MY_MACHINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MY_TYPE_MACHINES, MyMachinesClass))

typedef struct _MyMachines MyMachines;
typedef struct _MyMachinesClass MyMachinesClass;
typedef struct _MyMachinesPrivate MyMachinesPrivate;

struct _MyMachines
{
	GtkDrawingArea parent;
};

struct _MyMachinesClass
{
	GtkDrawingAreaClass parent;
};

typedef enum
{
	MY_MACHINES_LOAD_BEGIN,
	MY_MACHINES_LOAD_TRACK,
	MY_MACHINES_LOAD_ITEMS,
	MY_MACHINES_LOAD_MACHINES,
	MY_MACHINES_LOAD_SCENE,
	MY_MACHINES_LOAD_END
} MyMachinesLoadState;

typedef enum
{
	MY_MACHINES_STATE_MAIN,
	MY_MACHINES_STATE_PLAY,
	MY_MACHINES_STATE_PAUSE
} MyMachinesState;

typedef enum
{
	MY_MACHINES_ITEM_CUBE,
	MY_MACHINES_ITEM_TURBO,
	MY_MACHINES_ITEM_FAKE
} MyMachinesGadget;

GType
my_machines_get_type(void);

MyMachines *
my_machines_new(void);

void
my_machines_set_machines(MyMachines *self, guint machines);

guint
my_machines_get_machines(MyMachines *self);

void
my_machines_set_players(MyMachines *self, guint players);

guint
my_machines_get_players(MyMachines *self);

void
my_machines_set_items(MyMachines *self, guint items);

void
my_machines_set_points(MyMachines *self, guint points);

void
my_machines_set_track(MyMachines *self, guint track);

void
my_machines_set_machine(MyMachines *self, guint machine);

void
my_machines_load(MyMachines *self);

const gchar *
my_machines_get_gadget(MyMachines *self, MyMachinesGadget gadget);

const gchar *
my_machines_get_player_color(MyMachines *self, guint player);

guint
my_machines_get_player_points(MyMachines *self, guint player);

gint
my_machines_get_player_gadget(MyMachines *self, guint player);

void
my_machines_unload(MyMachines *self);

gboolean
my_machines_is_loaded(MyMachines *self);

void
my_machines_set_state(MyMachines *self, MyMachinesState state);

MyMachinesState
my_machines_get_state(MyMachines *self);

gfloat
my_machines_get_load_fraction(MyMachines *self);

G_END_DECLS

#endif
