// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "MyGadget.h"

MyGadget::MyGadget()
{
}

MyGadget::~MyGadget()
{
}

void
MyGadget::frame(void)
{
}

void
MyGadget::enable(void)
{
}

void
MyGadget::disable(void)
{
}

void
MyGadget::place(const float *position)
{
}

MyCube::MyCube()
{
}

MyCube::~MyCube()
{
}

bool
MyCube::load(dWorldID world, dSpaceID space)
{
	dMass mass;

	::H3D::Helper::Mesh::H3D::load(PACKAGE_DATADIR STRPS "cube");
	::H3D::Helper::Mesh::H3D::glLoad(PACKAGE_DATADIR STRPS "textures");

	body = dBodyCreate(world);
	dMassSetBox(&mass, 1.25f, 1.0f, 1.0f, 1.0f);
	dMassAdjust(&mass, 1.25f);
	dBodySetMass(body, &mass);
	geom = dCreateBox(space, 1.0f, 1.0f, 1.0f);
	dGeomSetBody(geom, body);

	return true;
}

void
MyCube::unload(void)
{
	dGeomDestroy(geom);
	dBodyDestroy(body);

	::H3D::Helper::Mesh::H3D::glUnload();
	::H3D::Helper::Mesh::H3D::unload();
}

void
MyCube::frame(void)
{
	const float *p, *r;
	float m[16];

	p = dBodyGetPosition(body);
	r = dBodyGetRotation(body);
	::H3D::Helper::OpenGL::OpenDE::Matrix(p, r, m);
	glPushMatrix();
		glMultMatrixf(m);
		::H3D::Helper::Mesh::H3D::draw();
	glPopMatrix();
}

void
MyCube::enable(void)
{
	dBodyEnable(body);
	dGeomEnable(geom);
}

void
MyCube::disable(void)
{
	dBodyDisable(body);
	dGeomDisable(geom);
}

void
MyCube::place(const float *position)
{
	dBodySetPosition(body, position[0], position[1], position[2]);
	dBodySetLinearVel(body, 0.0f, 0.0f, 0.0f);
	dBodySetAngularVel(body, 0.0f, 0.0f, 0.0f);
}

MyTurbo::MyTurbo()
{
}

MyTurbo::~MyTurbo()
{
}

bool
MyTurbo::load(dWorldID world, dSpaceID space)
{
	::H3D::Helper::Mesh::H3D::load(PACKAGE_DATADIR STRPS "box");
	::H3D::Helper::Mesh::H3D::glLoad(PACKAGE_DATADIR STRPS "textures");

	return true;
}

void
MyTurbo::unload(void)
{
	::H3D::Helper::Mesh::H3D::glUnload();
	::H3D::Helper::Mesh::H3D::unload();
}

MyFake::MyFake()
{
}

MyFake::~MyFake()
{
}

bool
MyFake::load(dWorldID world, dSpaceID space)
{
	::H3D::Helper::Mesh::H3D::load(PACKAGE_DATADIR STRPS "fake");
	::H3D::Helper::Mesh::H3D::glLoad(PACKAGE_DATADIR STRPS "textures");

	return true;
}

void
MyFake::unload(void)
{
	::H3D::Helper::Mesh::H3D::glUnload();
	::H3D::Helper::Mesh::H3D::unload();
}

