// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "MyBox.h"

MyBox::MyBox()
{
	mesh = new H3D::Helper::Mesh::H3D();
	H3D::Math::Matrix::LoadIdentity(matrix);
}

MyBox::~MyBox()
{
	delete mesh;
}

bool
MyBox::load(const float *sphere)
{
	dMass mass;

	mesh->load(PACKAGE_DATADIR STRPS "box");
	mesh->glLoad(PACKAGE_DATADIR STRPS "textures");

	H3D::Math::Sphere::Copy(sphere, this->sphere);

	return true;
}

void
MyBox::unload(void)
{
	mesh->glUnload();
	mesh->unload();
}

void
MyBox::frame(void)
{
	H3D::Math::Matrix::RotateInPlace(matrix, H3D::Math::Vector::Y, 18);
	glPushMatrix();
		glTranslatef(sphere[0], sphere[1], sphere[2]);
		glMultMatrixf(matrix);
		mesh->draw();
	glPopMatrix();
}
