// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#define _POSIX_C_SOURCE 199309L
#include "H3D/System.h"
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>

namespace H3D
{
	namespace System
	{
		unsigned int
		Ticks()
		{
			struct timeval tv;

			gettimeofday(&tv, NULL);
			return tv.tv_sec * 1000 + tv.tv_usec / 1000;
		}

		unsigned int
		Sleep(unsigned int ms)
		{
			struct timespec req, rem;
			int result;

			req.tv_sec = ms / 1000;
			req.tv_nsec = ms * 1000000;
			result = nanosleep(&req, &rem);
			if(result < 0) result = rem.tv_sec * 1000 + rem.tv_nsec / 10000000;
			return result;
		}
	}
}
