#!BPY

# Copyright (C) 2008 Juan Manuel Borges Caño

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Name: 'H3D...'
Blender: 246
Group: 'Export'
Tooltip: 'Save a H3D mesh'
"""

import Blender

def export(filename):
	if not filename.lower().endswith('.h3d'):
		filename += '.h3d'
	stream = open(filename, 'w')

	scene = Blender.Scene.GetCurrent()
	world = scene.world
	object = scene.objects.active

	mesh = object.getData(mesh=1)

	stream.write('vertices %s\n' % len(mesh.verts))
	for vert in mesh.verts:
		co = vert.co * object.getMatrix()
		no = vert.no * object.getMatrix()
		stream.write('coord %s %s %s\n' % (co.x, co.y, co.z))
		stream.write('normal %s %s %s\n' % (no.x, no.y, no.z))
	textures = []
	for material in mesh.materials:
		texture = Blender.sys.basename(material.getTextures()[0].tex.image.filename)
		if texture not in textures:
			textures.append(texture)
	stream.write('textures %i\n' % len(textures))
	for texture in textures:
		stream.write('name %s\n' % texture)
	stream.write('materials %s\n' % len(mesh.materials))
	for material in mesh.materials:
		texture = Blender.sys.basename(material.getTextures()[0].tex.image.filename)
		stream.write('texture %i\n' % textures.index(texture))
		stream.write('alpha %s\n' % material.alpha)
		stream.write('emit %s\n' % material.emit)
		amb0 = world.amb[0] * material.amb
		amb1 = world.amb[1] * material.amb
		amb2 = world.amb[2] * material.amb
		stream.write('ambient %s %s %s\n' % (amb0, amb1, amb2))
		stream.write('diffuse %s %s %s\n' % (material.R, material.G, material.B))
		stream.write('specular %s %s %s\n' %(material.specR, material.specG, material.specG))
	stream.write('faces %s\n' % len(mesh.faces))
	for face in mesh.faces:
		stream.write('vertices')
		for vert in face.verts:
			stream.write(' %s' % vert.index)
		stream.write('\n')
		if mesh.faceUV:
			stream.write('texcoords')
			for i in range(len(face.verts)):
				if mesh.faceUV:
					stream.write(' %s %s' % (face.uv[i][0], face.uv[i][1]))
			stream.write('\n')
		if mesh.faceUV:
			stream.write('normal %s %s %s\n' % (face.no.x, face.no.y, face.no.z))
		stream.write('material %s\n' % face.mat)
	stream.close()

Blender.Window.FileSelector(export, 'Export H3D', Blender.sys.makename(ext='.h3d'))
