// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#pragma once

#include <string>
#include <X11/Xlib.h>
#include <vector>
#include <H3D/H3D.h>

class MyTrack;
class MyMachine;
class MyBox;
class MyWidget;

class MyMachines
{
	public:

		typedef enum {INTRO, MAIN, LOAD, PLAY, SCORE, OPTIONS, HELP} State;
		bool loop;
		
		MyMachines(void);

		virtual
		~MyMachines(void);

		void
		resize(unsigned int width, unsigned int height);

		void
		keyPress(XEvent &event);

		void
		keyRelease(XEvent &event);

		void
		frame(void);

		void
		enter(State state);

		void
		leave(void);

	protected:

		typedef enum { START, TRACK, ITEMS, MACHINES, END } LoadState;
		typedef enum { CUBE, TURBO, FAKE } ItemType ;

		typedef struct
		{
			MyMachine *machine;
			bool keys[5];
			unsigned int checkpoint;
			float distance;
			unsigned int points;
			int item;
		} Player;

		typedef struct
		{
			ItemType type;
			MyBox *box;
			MyWidget *widget;
			int player;
			int frames;
		} Item;

		struct { unsigned int width, height; } screen;

		struct
		{
			FT_Library freetype;
			FT_Face face;
			GLUtesselator *tess;
			dWorldID world;
			dSpaceID space;
			dJointGroupID joints;
			std::string machines[4];
			std::string widgets[3];

			struct
			{
				bool done;
			} intro;

			struct
			{
				unsigned int progress;
				GLuint background;
				ALuint music;
				H3D::Helper::Mesh::H3D *selector;
				unsigned int selectoranim;
			} menu;

			struct
			{
				std::wstring entries[3];
				unsigned int selection;
			} main;

			struct
			{
				LoadState state;
			} load;

			struct
			{
				float camera[3];
				float frustum[24];
				Player players[4];
				MyTrack *track;
				Item items[9];
			} play;

			struct
			{
				unsigned int winner;
			} score;

			struct
			{
				std::wstring entries[6];
				std::string tracks[6];
				std::string machines[3];
				unsigned int selection;
				unsigned int nmachines;
				unsigned int nplayers;
				unsigned int nitems;
				unsigned int track;
				unsigned int machine;
				unsigned int npoints;
			} options;

			struct
			{
				std::wstring entries[7];
			} help;
		} content;

		State state;

		void
		change(State state);

		void
		enterIntro(void);

		void
		leaveIntro(void);

		void
		keyPressIntro(XEvent &event);

		void
		keyReleaseIntro(XEvent &event);

		void
		frameIntro(void);

		void
		enterMain(void);

		void
		leaveMain(void);

		void
		keyPressMain(XEvent &event);

		void
		keyReleaseMain(XEvent &event);

		void
		frameMain(void);

		void
		enterLoad(void);

		void
		leaveLoad(void);

		void
		keyPressLoad(XEvent &event);

		void
		keyReleaseLoad(XEvent &event);

		void
		frameLoad(void);

		void
		enterPlay(void);

		void
		leavePlay(void);

		void
		keyPressPlay(XEvent &event);

		void
		keyReleasePlay(XEvent &event);

		void
		framePlay(void);

		void
		enterScore(void);

		void
		leaveScore(void);

		void
		keyPressScore(XEvent &event);

		void
		keyReleaseScore(XEvent &event);

		void
		frameScore(void);

		void
		enterOptions(void);

		void
		leaveOptions(void);

		void
		keyPressOptions(XEvent &event);

		void
		keyReleaseOptions(XEvent &event);

		void
		frameOptions(void);

		void
		enterHelp(void);

		void
		leaveHelp(void);

		void
		keyPressHelp(XEvent &event);

		void
		keyReleaseHelp(XEvent &event);

		void
		frameHelp(void);

		void
		computer(unsigned int player);

		void
		human(unsigned int player);

		void
		DrawScore(FT_Face face, H3D::Helper::OpenGL::FreeType::DrawMode mode, unsigned int z, GLUtesselator *tess);

		static
		void
		NearCallback(void *data, dGeomID o1, dGeomID o2);
};
