// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include <string>
#include <ode/ode.h>
#include <AL/al.h>
#include <H3D/H3D.h>

class MyMachine
{
	public:

		typedef struct
		{
			float speed;
			float steer;
		} Info;

		Info info;
		dBodyID body[5];
		dGeomID geom[5];
		dJointID joint[4];
		H3D::Helper::Mesh::H3D *chassis;
		H3D::Helper::Mesh::H3D *wheel;
		ALuint engine;

		MyMachine(void);

		virtual
		~MyMachine(void);

		bool
		load(const std::string &machine, dWorldID world, dSpaceID space, const float *position);

		virtual
		void
		unload(void);

		void
		frame(void);

		void
		enable(void);

		void
		disable(void);

		void
		drive(bool up, bool down, bool left, bool right, bool turbo);

		void
		place(const float *position, const float *rotation);
};
