// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "MyCheckPoints.h"

MyCheckPoints::MyCheckPoints(void)
{
	info.magic = 0;
}

MyCheckPoints::~MyCheckPoints(void)
{
}

bool
MyCheckPoints::load(const std::string &filename, bool compiled)
{
	bool result;
	FILE *stream;
	if(compiled)
	{
		stream = fopen(filename.c_str(), "rb");
		if(stream)
		{
			fread(&info, 1, sizeof(Info), stream);
			content.checkpoints = new float[info.ncheckpoints * 3];
			fread(content.checkpoints, 1, info.ncheckpoints * 3 * sizeof(float), stream);
			fclose(stream);
			result = true;
		}
		else result = false;
	}
	else
	{
		stream = fopen(filename.c_str(), "r");
		if(stream)
		{
			char buffer[256];
			unsigned int i;
			fgets(buffer, 256, stream);
			//sscanf(buffer, "checkpoints %i", &info.ncheckpoints);
			sscanf(buffer, "length %i", &info.ncheckpoints);
			content.checkpoints = new float[info.ncheckpoints * 3];
			for(i = 0; i < info.ncheckpoints; i++)
			{
				fgets(buffer, 256, stream);
				//sscanf(buffer, "coord %f %f %f", &content.checkpoints[i * 3], &content.checkpoints[i * 3 + 1], &content.checkpoints[i * 3 + 2]);
				sscanf(buffer, "(%f, %f, %f)", &content.checkpoints[i * 3], &content.checkpoints[i * 3 + 1], &content.checkpoints[i * 3 + 2]);
			}
			fclose(stream);
			result = true;
		}
		else result = false;
	}
	return result;
}

void
MyCheckPoints::unload(void)
{
	delete content.checkpoints;
}

bool
MyCheckPoints::save(const std::string &filename, bool compiled)
{
	bool result;
	FILE *stream;
	if(compiled)
	{
		stream = fopen(filename.c_str(), "wb");
		if(stream)
		{
			fwrite(&info, 1, sizeof(Info),stream);
			fwrite(content.checkpoints, 1, info.ncheckpoints * 3 * sizeof(float), stream);
			fclose(stream);
			result = true;
		}
		else result = false;
	}
	else
	{
		stream = fopen(filename.c_str(), "w");
		if(stream)
		{
			unsigned int i;
			fprintf(stream, "checkpoints %i\n", info.ncheckpoints);
			for(i = 0; i < info.ncheckpoints; i++)
				fprintf(stream, "coord %f %f %f\n", content.checkpoints[i * 3], content.checkpoints[i * 3 + 1], content.checkpoints[i * 3 + 2]);
			fclose(stream);
			result = true;
		}
		else result = false;
		result = false;
	}
	return result;
}
