// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#pragma once

#include <H3D/Macros.h>
#include <string>

namespace H3D
{
	namespace Sound
	{
		class H3D_API H3D
		{
			public:

				typedef struct
				{
					int magic;
					unsigned int rate;
					unsigned int nchannels;
					unsigned int nframes;
				} Info;

				typedef struct
				{
					short* samples;
				} Content;

				Info info;
				Content content;

				H3D(void);

				virtual
				~H3D(void);

				bool
				load(const std::string& filename);

				virtual
				void
				unload(void);

				bool
				save(const std::string& filename);
		};

		namespace VORBIS
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace MIME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace NAME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}
	}
}
