// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include <H3D/H3D.h>
#include <GL/glx.h>
#include <GL/glu.h>
#include <AL/alc.h>
#include <AL/al.h>
#include <ode/ode.h>
#include "HMachines.h"
#include "config.h"

int
main(int argc, char **argv)
{
	HMachines *game;

	Display *display;
	Window root;
	XVisualInfo *info;
	Window window;
	XSetWindowAttributes swa;
	Atom wm_protocols, wm_delete_window;
	GLXContext gcontext;
	GLint attributes[] = {GLX_RGBA, GLX_DEPTH_SIZE, 24, GLX_DOUBLEBUFFER, None};
	ALCdevice *device;
	ALCcontext *acontext;
	XEvent event;


	unsigned int startticks, endticks, ticks;

	display = XOpenDisplay(NULL);
	if(display)
	{
		root = DefaultRootWindow(display);
		info = glXChooseVisual(display, 0, attributes);
		if(info)
		{
			swa.colormap = XCreateColormap(display, root, info->visual, AllocNone);
			swa.event_mask = ExposureMask | StructureNotifyMask | KeyPressMask | KeyReleaseMask;

			window = XCreateWindow(display, root, 0, 0, 640, 480, 0, info->depth, InputOutput, info->visual, CWColormap | CWEventMask, &swa);
			wm_delete_window = XInternAtom(display, "WM_DELETE_WINDOW", 0);
			XSetWMProtocols(display, window, &wm_delete_window, 1);
			wm_protocols = XInternAtom(display, "WM_PROTOCOLS", 0);
			XMapWindow(display, window);
			XStoreName(display, window, PACKAGE_STRING);
			glewInit();
			gcontext = glXCreateContext(display, info, NULL, GL_TRUE);
			if(gcontext)
			{
				glXMakeCurrent(display, window, gcontext);
				device = alcOpenDevice(NULL);
				if(device)
				{
					acontext = alcCreateContext(device, NULL);
					if(acontext)
					{
						alcMakeContextCurrent(acontext);
						dInitODE();
						game = new HMachines();
						game->loop = true;
						game->enter(HMachines::INTRO);
						while(game->loop)
						{
							startticks = H3D::System::Ticks();
							game->frame();
							glXSwapBuffers(display, window);
							while(game->loop && XPending(display))
							{
								XNextEvent(display, &event);
								switch(event.type)
								{
									//case Expose: glXSwapBuffers(display, window); break;
									case ConfigureNotify: game->resize(event.xconfigure.width, event.xconfigure.height); break;
									case KeyPress: game->keyPress(event); break;
									case KeyRelease: game->keyRelease(event); break;
									case ClientMessage: game->loop = !(event.xclient.message_type == wm_protocols && event.xclient.data.l[0] == wm_delete_window); break;
								}
							}
							endticks = H3D::System::Ticks();
							ticks = endticks - startticks;
							if(ticks < 40) H3D::System::Sleep(40 - ticks);
						}
						game->leave();
						delete game;
						dCloseODE();
						alcMakeContextCurrent(NULL);
						alcDestroyContext(acontext);
					}
					alcCloseDevice(device);
				}
				glXMakeCurrent(display, None, NULL);
			}
			glXDestroyContext(display, gcontext);
			XDestroyWindow(display, window);
		}
		XCloseDisplay(display);
	}
	return EXIT_SUCCESS;
}
