#pragma once

#include <string>
#include <X11/Xlib.h>
#include <vector>
#include <H3D/H3D.h>

class HCheckPoints
{
	public:

		typedef struct
		{
			int magic;
			unsigned int ncheckpoints;
		} Info;

		typedef struct
		{
			float *checkpoints;
		} Content;

		Info info;
		Content content;

		HCheckPoints(void);

		virtual
		~HCheckPoints(void);

		bool
		load(const std::string& filename, bool compiled = true);

		virtual
		void
		unload(void);

		bool
		save(const std::string& filename, bool compiled = true);
};

class HTrack:
	public HCheckPoints
{
	public:

		H3D::Helper::Mesh::H3D* mesh;

		HTrack(void);

		virtual
		~HTrack(void);

		bool
		load(const std::string& track, dSpaceID space);

		virtual
		void
		unload(void);

		void
		frame(void);
};

class HMachine
{
	public:

		typedef struct
		{
			float speed;
			float steer;
		} Info;

		Info info;
		dBodyID body[5];
		dGeomID geom[5];
		dJointID joint[4];
		H3D::Helper::Mesh::H3D* chassis;
		H3D::Helper::Mesh::H3D* wheel;
		ALuint engine;

		HMachine(void);

		virtual
		~HMachine(void);

		bool
		load(const std::string& machine, dWorldID world, dSpaceID space, const float *position);

		virtual
		void
		unload(void);

		void
		frame(void);

		void
		enable(void);

		void
		disable(void);

		void
		drive(bool up, bool down, bool left, bool right);

		void
		place(const float *position, const float *rotation);
};

class HMachines
{
	public:

		typedef enum {INTRO, MAIN, LOAD, PLAY, OPTIONS, HELP} State;
		bool loop;
		
		HMachines(void);

		virtual
		~HMachines(void);

		void
		resize(unsigned int width, unsigned int height);

		void
		keyPress(XEvent& event);

		void
		keyRelease(XEvent& event);

		void
		frame(void);

		void
		enter(State state);

		void
		leave(void);

	protected:

		typedef enum
		{
			START,
			TRACK,
			MACHINES,
			END
		} LoadState;

		typedef struct
		{
			HMachine* machine;
			bool keys[4];
			unsigned int checkpoint;
			float distance;
			unsigned int points;
		} Player;

		struct { unsigned int width, height; } screen;

		struct
		{
			FT_Library freetype;
			FT_Face face;
			GLUtesselator* tess;
			dWorldID world;
			dSpaceID space;
			dJointGroupID joints;
			std::string machines[4];

			struct
			{
				bool done;
			} intro;

			struct
			{
				unsigned int progress;
				GLuint background;
				ALuint music;
				H3D::Helper::Mesh::H3D* selector;
				unsigned int selectoranim;
			} menu;

			struct
			{
				std::wstring entries[3];
				unsigned int selection;
			} main;

			struct
			{
				LoadState state;
			} load;

			struct
			{
				float camera[3];
				float frustum[24];
				Player players[4];
				HTrack* track;
			} play;

			struct
			{
				std::wstring entries[5];
				std::string tracks[4];
				std::string machines[3];
				unsigned int selection;
				unsigned int nmachines;
				unsigned int nplayers;
				unsigned int track;
				unsigned int machine;
				unsigned int npoints;
			} options;

			struct
			{
				std::wstring entries[7];
			} help;
		} content;

		State state;

		void
		change(State state);

		void
		enterIntro(void);

		void
		leaveIntro(void);

		void
		keyPressIntro(XEvent& event);

		void
		keyReleaseIntro(XEvent& event);

		void
		frameIntro(void);

		void
		enterMain(void);

		void
		leaveMain(void);

		void
		keyPressMain(XEvent& event);

		void
		keyReleaseMain(XEvent& event);

		void
		frameMain(void);

		void
		enterLoad(void);

		void
		leaveLoad(void);

		void
		keyPressLoad(XEvent& event);

		void
		keyReleaseLoad(XEvent& event);

		void
		frameLoad(void);

		void
		enterPlay(void);

		void
		leavePlay(void);

		void
		keyPressPlay(XEvent& event);

		void
		keyReleasePlay(XEvent& event);

		void
		framePlay(void);

		void
		enterOptions(void);

		void
		leaveOptions(void);

		void
		keyPressOptions(XEvent& event);

		void
		keyReleaseOptions(XEvent& event);

		void
		frameOptions(void);

		void
		enterHelp(void);

		void
		leaveHelp(void);

		void
		keyPressHelp(XEvent& event);

		void
		keyReleaseHelp(XEvent& event);

		void
		frameHelp(void);

		void
		computer(unsigned int player);

		void
		human(unsigned int player);

		static
		void
		NearCallback(void *data, dGeomID o1, dGeomID o2);
};
