#define _POSIX_C_SOURCE 199309L
#include "H3D/System.h"
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>

namespace H3D
{
	namespace System
	{
		unsigned int
		Ticks()
		{
			struct timeval tv;

			gettimeofday(&tv, NULL);
			return tv.tv_sec * 1000 + tv.tv_usec / 1000;
		}

		unsigned int
		Sleep(unsigned int ms)
		{
			struct timespec req, rem;
			int result;

			req.tv_sec = ms / 1000;
			req.tv_nsec = ms * 1000000;
			result = nanosleep(&req, &rem);
			if(result < 0) result = rem.tv_sec * 1000 + rem.tv_nsec / 10000000;
			return result;
		}
	}
}
